import { ModuleWithProviders } from '@angular/core';
import { NgbTooltipConfig } from '@ng-bootstrap/ng-bootstrap';
import { TranslateService } from '@ngx-translate/core';
import { TranslateMessageFormatCompiler } from 'ngx-translate-messageformat-compiler';
import '@angular/localize/init';
import { AppRootComponent } from './components/appRoot.component';
import { PlatformService, ProfilesService, ProfileProvider, Profile, SelectorService, PartialProfileGroup, ProfileGroup } from './api';
import { AppService } from './services/app.service';
import { ConfigService } from './services/config.service';
import { HotkeysService } from './services/hotkeys.service';
import { LocaleService } from './services/locale.service';
import { CommandService } from './services/commands.service';
import { AppHotkeyProvider } from './hotkeys';
export declare function TranslateMessageFormatCompilerFactory(): TranslateMessageFormatCompiler;
/** @hidden */
export default class AppModule {
    locale: LocaleService;
    private translate;
    private profilesService;
    private selector;
    constructor(app: AppService, config: ConfigService, platform: PlatformService, hotkeys: HotkeysService, commands: CommandService, ngbTooltipConfig: NgbTooltipConfig, locale: LocaleService, translate: TranslateService, profilesService: ProfilesService, selector: SelectorService);
    showSelector(provider: ProfileProvider<Profile>): Promise<void>;
    showGroupSelector(group: PartialProfileGroup<ProfileGroup>): Promise<void>;
    static forRoot(): ModuleWithProviders<AppModule>;
}
export { AppRootComponent as bootstrap };
export * from './api';
export { AppHotkeyProvider };
export { ToolbarButton as IToolbarButton } from './api';
export { HotkeyDescription as IHotkeyDescription } from './api';
