import { TranslateService } from '@ngx-translate/core';
import { NewTabParameters } from './tabs.service';
import { BaseTabComponent } from '../components/baseTab.component';
import { PartialProfile, PartialProfileGroup, Profile, ProfileGroup, ProfileProvider } from '../api/profileProvider';
import { SelectorOption } from '../api/selector';
import { AppService } from './app.service';
import { ConfigService } from './config.service';
import { NotificationsService } from './notifications.service';
import { SelectorService } from './selector.service';
export declare class ProfilesService {
    private app;
    private config;
    private notifications;
    private selector;
    private translate;
    private profileProviders;
    private profileDefaults;
    constructor(app: AppService, config: ConfigService, notifications: NotificationsService, selector: SelectorService, translate: TranslateService, profileProviders: ProfileProvider<Profile>[]);
    getProviders(): ProfileProvider<Profile>[];
    providerForProfile<T extends Profile>(profile: PartialProfile<T>): ProfileProvider<T> | null;
    getDescription<P extends Profile>(profile: PartialProfile<P>): string | null;
    getConfigProxyForProfile<T extends Profile>(profile: PartialProfile<T>, options?: {
        skipGlobalDefaults?: boolean;
        skipGroupDefaults?: boolean;
    }): T;
    /**
    * Return an Array of Profiles
    * arg: includeBuiltin (default: true) -> include BuiltinProfiles
    * arg: clone (default: false) -> return deepclone Array
    */
    getProfiles(options?: {
        includeBuiltin?: boolean;
        clone?: boolean;
    }): Promise<PartialProfile<Profile>[]>;
    /**
    * Insert a new Profile in config
    * arg: genId (default: true) -> generate uuid in before pushing Profile into config
    */
    newProfile(profile: PartialProfile<Profile>, options?: {
        genId?: boolean;
    }): Promise<void>;
    /**
    * Write a Profile in config
    */
    writeProfile(profile: PartialProfile<Profile>): Promise<void>;
    /**
    * Delete a Profile from config
    */
    deleteProfile(profile: PartialProfile<Profile>): Promise<void>;
    /**
    * Delete all Profiles from config using option filter
    * arg: filter (p: PartialProfile<Profile>) => boolean -> predicate used to decide which profiles have to be deleted
    */
    bulkDeleteProfiles(filter: (p: PartialProfile<Profile>) => boolean): Promise<void>;
    openNewTabForProfile<P extends Profile>(profile: PartialProfile<P>): Promise<BaseTabComponent | null>;
    newTabParametersForProfile<P extends Profile>(profile: PartialProfile<P>): Promise<NewTabParameters<BaseTabComponent> | null>;
    launchProfile(profile: PartialProfile<Profile>): Promise<void>;
    static getProfileHotkeyName(profile: PartialProfile<Profile>): string;
    selectorOptionForProfile<P extends Profile, T>(profile: PartialProfile<P>): SelectorOption<T>;
    showProfileSelector(): Promise<PartialProfile<Profile> | null>;
    getRecentProfiles(): PartialProfile<Profile>[];
    quickConnect(query: string): Promise<PartialProfile<Profile> | null>;
    /**
    * Return global defaults for a given profile provider
    * Always return something, empty object if no defaults found
    */
    getProviderDefaults(provider: ProfileProvider<Profile>): any;
    /**
    * Set global defaults for a given profile provider
    */
    setProviderDefaults(provider: ProfileProvider<Profile>, pdefaults: any): void;
    /**
    * Return defaults for a given profile
    * Always return something, empty object if no defaults found
    * arg: skipUserDefaults -> do not merge global provider defaults in ConfigProxy
    * arg: skipGroupDefaults -> do not merge parent group provider defaults in ConfigProxy
    */
    getProfileDefaults(profile: PartialProfile<Profile>, options?: {
        skipGlobalDefaults?: boolean;
        skipGroupDefaults?: boolean;
    }): any[];
    /**
    * Synchronously return an Array of the existing ProfileGroups
    * Does not return builtin groups
    */
    getSyncProfileGroups(): PartialProfileGroup<ProfileGroup>[];
    /**
    * Return an Array of the existing ProfileGroups
    * arg: includeProfiles (default: false) -> if false, does not fill up the profiles field of ProfileGroup
    * arg: includeNonUserGroup (default: false) -> if false, does not add built-in and ungrouped groups
    */
    getProfileGroups(options?: {
        includeProfiles?: boolean;
        includeNonUserGroup?: boolean;
    }): Promise<PartialProfileGroup<ProfileGroup>[]>;
    /**
    * Insert a new ProfileGroup in config
    * arg: genId (default: true) -> generate uuid in before pushing Profile into config
    */
    newProfileGroup(group: PartialProfileGroup<ProfileGroup>, options?: {
        genId?: boolean;
    }): Promise<void>;
    /**
    * Write a ProfileGroup in config
    */
    writeProfileGroup(group: PartialProfileGroup<ProfileGroup>): Promise<void>;
    /**
    * Delete a ProfileGroup from config
    */
    deleteProfileGroup(group: PartialProfileGroup<ProfileGroup>, options?: {
        deleteProfiles?: boolean;
    }): Promise<void>;
    /**
    * Resolve and return ProfileGroup Name from ProfileGroup ID
    */
    resolveProfileGroupName(groupId: string): string;
    /**
    * Return defaults for a given group ID and provider
    * Always return something, empty object if no defaults found
    * arg: skipUserDefaults -> do not merge global provider defaults in ConfigProxy
    */
    getProviderProfileGroupDefaults(groupId: string, provider: ProfileProvider<Profile>): any;
}
