![alt tag](https://www.flightradar24.com/blog/wp-content/uploads/2016/03/3DView-AirbusA380.jpg)

# Flightradar24 3D models

This repo contains all models which are used for Flightradar24 3D view. All files are stored in [glTF format](https://github.com/KhronosGroup/glTF).

# Contribute

Contributions are always welcome!  Feel free to open pull requests for any 3D aircraft models or house liveries, as long as they are licensed under free license (GPLv2, BSD, etc...). 

## 3D Models
You can contribute missing 3d models by posting pull request with model (`.blend`, `.obj`, `.dae` or `.gltf` extension) and providing details about it and license info.

gltf extension is preferred, since not all `.blend`/`.obj`/`.dae` models correctly converts to [`glTF` format](https://github.com/KhronosGroup/glTF). To check conversion, please use [online converter from dae to glTF](https://cesiumjs.org/convertmodel.html). Also, you can use various [other converters](https://github.com/KhronosGroup/glTF#converters)

## Liveries
We are currently looking for house liveries for most of aircrafts. All of [FGMEMBERS](https://github.com/FGMEMBERS) aircrafts  contains paintkits, which you can use as a template for a livery ([example](https://github.com/FGMEMBERS/737-800/tree/master/Paintkit)). 

Please note that we are currently not looking for airlines liveries.

# Credits
Many thanks to [FlightGear project](http://www.flightgear.org/) and  [FGMEMBERS repository](https://github.com/FGMEMBERS) 
for providing 3D models of excellent quality.

List of used aircrafts: 


| Aircraft model            |                                                 |
| -------------             |:-------------:                                  |
| Boeing 737-600            | [link](https://github.com/FGMEMBERS/737NG)      |
| Boeing 737-700            | [link](https://github.com/FGMEMBERS/737NG)      |
| Boeing 737-800            | [link](https://github.com/FGMEMBERS/737-800)    |
| Boeing 737-900            | [link](https://github.com/FGMEMBERS/737NG)      |
| Boeing 747-400            | [link](https://github.com/FGMEMBERS/747-400)    |
| Boeing 747-8i             | [link](https://github.com/FGMEMBERS/747-8i)     |
| Boeing 757-200            | [link](https://github.com/FGMEMBERS/757-200)    |
| Boeing 757-300            | [link](https://github.com/FGMEMBERS/757-200)    |
| Boeing 767-200            | [link](https://github.com/FGMEMBERS/767)        |
| Boeing 767-300            | [link](https://github.com/FGMEMBERS/767-300)    |
| Boeing 767-400            | [link](https://github.com/FGMEMBERS/767)        |
| Boeing 777-200            | [link](https://github.com/FGMEMBERS/777)        |
| Boeing 777-300            | [link](https://github.com/FGMEMBERS/777)        |
| Boeing 787-800            | [link](https://github.com/FGMEMBERS/787-8)      |
| Boeing 787-900            | [link](https://github.com/FGMEMBERS/787-9)      |
| Airbus A318               | [link](https://github.com/FGMEMBERS/A320-family)|
| Airbus A319               | [link](https://github.com/FGMEMBERS/A320-family)|
| Airbus A320               | [link](https://github.com/FGMEMBERS/A320-family)|
| Airbus A321               | [link](https://github.com/FGMEMBERS/A320-family)|
| Airbus A330-200           | [link](https://github.com/FGMEMBERS/A330-200)   |
| Airbus A330-300           | [link](https://github.com/FGMEMBERS/A330-300)   |
| Airbus A340-300           | [link](https://github.com/FGMEMBERS/A340-313X)  |
| Airbus A340-600           | [link](https://github.com/FGMEMBERS/A340-600HGW)|
| Airbus A350               | [link](https://github.com/FGMEMBERS/A350XWB)    |
| Airbus A380               | [link](https://github.com/FGMEMBERS/A380-omega) |
| ATR 42                    | [link](https://github.com/FGMEMBERS/ATR-42-500) |
| Cessna Citation II        | [link](https://github.com/FGMEMBERS/Citation)   |
| Piper PA-28               | [link](https://github.com/FGMEMBERS/Piper-PA-28)|
| Bombardier CRJ700         | [link](https://github.com/FGMEMBERS/CRJ700-family)|
| Bombardier CRJ900         | [link](https://github.com/FGMEMBERS/CRJ700-family)|
| Embraer E170              | [link](https://github.com/FGMEMBERS/E-jet-family)|
| Embraer E190              | [link](https://github.com/FGMEMBERS/E-jet-family)|
| Bombardier CRJ700         | [link](https://github.com/FGMEMBERS/CRJ700-family)|
| Eurocopter EC135          | [link](https://github.com/FGMEMBERS/ec135)      |
| Millennium Falcon         | [link](https://sketchfab.com/models/bd3e54ac20ff4ade8ddd8043db75c1d1)|
| AN-225 Mrija              | [link](https://github.com/FGMEMBERS/AN-225-Mrija)|
| A300-600ST Beluga         | [link](https://github.com/FGMEMBERS/A300-600ST)|
| Bombardier CS100          | [link](https://github.com/FGMEMBERS/CSeries)|
| Bombardier CS300          | [link](https://github.com/FGMEMBERS/CSeries)|
| Bombardier Dash 8 Q400    | [link](https://github.com/FGMEMBERS/Q400)|
| BAe 146                   | [link](https://github.com/FGMEMBERS/Jumbolino)|
| ASK 21                    | [link](https://github.com/FGMEMBERS/ASK21)|
| Santa Claus               | [link](https://3dwarehouse.sketchup.com/model.html?id=cc022bd603e293864d0718bea75780c5)|

# License

Millenium Falcon is made by [Johnson Martin](https://sketchfab.com/Johnson-Martin) and licensed by [CC BY 4.0](http://creativecommons.org/licenses/by/4.0/). Changes to model were made.

Santa Claus model is made by [egis](https://3dwarehouse.sketchup.com/user.html?id=0189786303790230897228088&nav=models) and licensed by [3D Warehouse License](https://3dwarehouse.sketchup.com/tos.html#license)

All other models are licensed under GPLv2

