/*******************************************************************************

    locals.js - 搭配用户脚本插件`GitHub 中文化插件`的页面匹配规则, 翻译忽略规则,
                词条库文件
    Copyright (C) 2016-2021 楼教主 (https://github.com/52cik)
    Copyright (C) 2021-当前 沙漠之子 (https://github.com/maboloshi)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

    Home: https://github.com/maboloshi/github-chinese
*/
var I18N = {};

I18N.conf = {

    /**
     * 匹配 pathname 页面的正则
     *
     * 注册页面 /signup
     * 登录二步验证 /login/oauth
     * 登录页面 /login
     * 密码重置 /password_reset
     * 组织页面 /orgs
     * 探索页面 /explore
     * 订阅页面 /notifications/subscriptions
     * 通知页面 /notifications
     * 关注页面 /watching
     * 星标页面 /stars
     * 议题页面 /issues
     * 拉取请求 /pulls
     * 搜索页面 /search
     * 趋势页面 /trending
     * 展示页面 /showcases
     * 导入仓库 /new/import
     * ...
     */
    rePagePath: /^\/($|home|dashboard|feed|copilot|spark|signup|account_verifications|login\/oauth|login|logout|sessions?|password_reset|orgs|explore|topics|notifications\/subscriptions|notifications|watching|stars|issues|pulls|repos|search|trending|showcases|new\/(import|project)|new|import|settings\/(profile|admin|appearance|accessibility|notifications|billing|emails|security_analysis|security-log|security|auth|sessions|keys|ssh|gpg|organizations|enterprises|blocked_users|interaction_limits|code_review_limits|repositories|codespaces|models|codespaces\/allow_permissions|deleted_repositories|packages|copilot|pages|replies|installations|apps\/authorizations|reminders|sponsors-log|apps|(?:personal-access-|)tokens|developers|applications\/new|applications|connections\/applications|education\/benefits)|settings|installations\/new|marketplace|apps|account\/(organizations\/new|choose|upgrade|billing\/history)|projects|redeem|discussions|collections|sponsors|sponsoring|github-copilot\/(signup|free_signup|code-review-waitlist|pro)|codespaces|developer\/register|features|security|sitemap|education|mcp)|^\/users\/[^\/]+\/(projects|packages|succession\/invitation)/,

    // 仓库路径
    rePagePathRepo: /^\/[^\/]+\/[^\/]+\/(issues|pulls|pull|tree|watchers|stargazers|new|edit|delete|upload|find|models|wiki|branches|discussions|activity|rules|releases|packages|tags|labels|milestones?|compare|commit|blob|blame|actions(\/metrics\/(usage|performance))?|runs|deployments|security|pulse|community|forks|fork|import|graphs\/(contributors|community|traffic|commit-activity|code-frequency)|network$|network\/(dependencies|dependents|updates|members)|settings\/(access|code_review_limits|interaction_limits|branches|branch_protection_rules|tag_protection|rules|actions|models\/access-policy|hooks|copilot\/(code_review|coding_agent)|environments|codespaces|pages|security_analysis|dependabot_rules|keys|secrets|variables|installations|notifications|key_links)|settings|transfer|projects\/new|projects|pkgs|contribute|subscription|invitations|codespaces|attestations|custom-properties|reported_content)/,

    // 组织路径
    rePagePathOrg: /^\/[^\/]+\/[^\/]+\/(repositories\/new|repositories|sponsoring|discussions|projects|packages|teams|new-team|people|outside-collaborators|pending_collaborators|dashboard|billing_managers\/new|invitations?|settings\/(profile|billing|roles|member_privileges|teams|import-export|blocked_users|interaction_limits|code_review_limits|moderators|repository-defaults|rules|codespaces|copilot|actions|hooks|discussions|packages|pages|projects|security_analysis|security|dependabot_rules|domains|secrets|variables|oauth_application_policy|installations|personal-access-token|reminders|sponsors-log|audit-log|deleted_repositories|applications\/new|applications|apps\/new|apps|publisher|policies\/repositories)|topics|domain\/new|audit-log\/event_settings|billing\/(history|plans)|policies\/applications)|^\/[^\/]+\/(enterprise_plan|sponsoring)/,

    // 特定页面，启用`字符数据`监测
    characterDataPage: ['repository/new', 'repository/edit', 'new', 'new/import', 'orgs/repositories/new', 'repository/blob', 'repository/pull', 'marketplace', 'homepage', 'repository/issues', 'repository/commit', 'copilot', 'spark', 'repository/settings/rules'],

    // 特定页面，忽略突变元素规则
    ignoreMutationSelectorPage: {
        'repository/new': [".cm-scroller"], // 代码编辑器
        'repository/edit': [".cm-scroller", "table"], // 代码编辑器
        'repository/pull': [
            "td.blob-code", // 代码差异 分屏/同屏
            '.js-full-logs-container', // 工作流运行日志
        ],
        'repository/compare': [
            "tbody", // 代码差异
            ".js-preview-body", // 新建拉取请求 - 正文编辑器预览
        ],
        'repository/commit': ["td.blob-code"], // 代码差异 分屏/同屏
        'repository/blob': [
            "#highlighted-line-menu-positioner", // 代码视图 存在
            "#repos-sticky-header", // 代码视图 置顶标题
            'nav[data-testid="breadcrumbs"]', // 面包屑导航
            'div[data-testid="breadcrumbs-filename"]', // 面包屑导航 文件名部分
        ],
        'repository/blame': ["#highlighted-line-menu-positioner"], // 代码视图
        'repository': [
            ".AppHeader-context",
            "table",
            "article.markdown-body",
        ],
        'repository/tree': [
            'nav[data-testid="breadcrumbs"]', // 面包屑导航
            'div[data-testid="breadcrumbs-filename"]', // 面包屑导航 文件名部分
            'tr.react-directory-row', // 文件列表中文件夹和文件条目
        ],
        'repository/releases': [".Box-footer"], // 附件清单
        'repository/issues': [
            'div[aria-live="polite"]>div.markdown-body', // 新建议题 - 正文编辑器预览
            '.markdown-body[data-team-hovercards-enabled="true"]', // 某个议题 - 正文以及正文编辑器、添加评论编辑器预览
        ],
        'repository/actions': [
            'table.highlight', // 工作流程文件 源码视图
            '.js-full-logs-container', // 工作流运行日志
        ],
        'copilot':[
            '.cm-line',
        ],
        'spark':[
            '.cm-line',
        ],
        '*': [
            'div.QueryBuilder-StyledInputContainer', // 顶部搜索栏 关键词
            '#qb-input-query span', // 搜索页面 搜索栏 关键词
			'div.styled-input-content', // 筛选条
        ],
    },

    // 特定页面，忽略元素规则
    ignoreSelectorPage: {
        'page-profile': [
            'span.p-nickname', // 用户昵称
            'span.p-name', // 同上
        ],
        'page-profile/followers': [
            'span.f4.Link--primary',
            "span.Link--secondary.pl-1",
        ],
        'page-profile/repositories': [
            'a[itemprop="name codeRepository"]', // 仓库名称
        ],
        'page-profile/stars': [
            '.mb-1.d-inline-block > h3', // 仓库名称
        ],
        'repository': [
            '.AppHeader-context-full', // 顶部 <username>/<repo_name>
            'strong[itemprop="name"]', // 仓库名称
            // 'ul.list-style-none', // 右侧 部署列表 无效
            'div[data-testid="latest-commit"]', // 最新的提交
            'tr.react-directory-row', // 文件列表中文件夹和文件条目
            'p.f4.my-3', // 仓库简介正文
            '#translate-me',
            '.my-3.d-flex.flex-items-center', // 仓库简介中的链接
            'article.markdown-body', // 自述文件正文
            'li.mt-2',
        ],
        'repository/tree': [
            '.AppHeader-context-full', // 顶部 <username>/<repo_name>
            'div.react-tree-show-tree-items', // 左侧文件树项目
            'span.PRIVATE_TreeView-item-content-text', // 左侧文件树项目 - 子文件夹
            'article.markdown-body', // Markdown 正文
            'nav[data-testid="breadcrumbs"]', // 面包屑导航
            'div[data-testid="breadcrumbs-filename"]', // 面包屑导航 文件名部分
            'tr.react-directory-row', // 文件列表中文件夹和文件条目
        ],
        'repository/blob': [
            '.AppHeader-context-full', // 顶部 <username>/<repo_name>
            'article.markdown-body', // Markdown 正文
            'div.react-tree-show-tree-items', // 左侧文件树项目
            '[id^="offset"]', // 符号-->引用
            '#highlighted-line-menu-positioner', // 代码视图
            '#filter-results', // 右侧 符号筛选
            '.Text__StyledText-sc-17v1xeu-0', // 右侧 符号筛选
            'nav[data-testid="breadcrumbs"]', // 面包屑导航
            'div[data-testid="breadcrumbs-filename"]', // 面包屑导航 文件名部分
        ],
        'repository/issues': [
            'div[aria-live="polite"]>div.markdown-body', // 新建议题 - 正文编辑器预览
            '.markdown-body[data-team-hovercards-enabled="true"]', //  某个议题 - 正文以及正文编辑器、添加评论编辑器预览
        ],
        'repository/commit': [
            'td.blob-code', // 代码差异 分屏/同屏
            'span.ws-pre-wrap', // 提交说明
            "h4[class^='Title-module__heading']", // 提交标题
        ],
        'repository/pull': [
            'td.blob-code', // 代码差异 分屏/同屏
            '.js-full-logs-container', // 工作流运行日志
        ],
        'repository/compare': [
            'td.blob-code', // 代码差异 分屏/同屏
        ],
        'repository/edit': [
            '.cm-scroller', // 代码编辑器
            'table', // 代码差异预览
        ],
        'repository/new': [
            '.cm-scroller', // 代码编辑器
            'table', // 代码差异预览
        ],
        'repository/actions': [
            'table.highlight', // 工作流程文件 源码视图
            '.js-full-logs-container', // 工作流运行日志
        ],
        'repository/releases': [
            'div.Box-body>div.markdown-body', // 发布版正文
        ],
        'repository/wiki': [
            '#wiki-body', // wiki 正文
            'ul.list-style-none.mx-4.px-1', // 右侧目录
        ],
        'orgs': [
            'a[itemprop="name codeRepository"]', // 仓库名称
        ],
        'search': [
            'span.search-match', // 搜索匹配信息
            'div.code-list', // 代码片段预览
            'optgroup > option', // 下拉菜单列表
        ],
        'dashboard': [
            '.js-notice-dismiss', // 右侧栏 广告
            '.TimelineItem', // 右侧栏 最新变化
            'section.comment-body', // 发布版正文
        ],
        'gist': [
            '.gist-content[itemprop="about"]', // Gist 简介
            'div.js-blob-code-container', // 代码框
            'table.js-diff-table', // 代码差异
        ],
        'topics': [
            'h3.f3.color-fg-muted.text-normal.lh-condensed', // 仓库名称
        ],
        'marketplace': [
            '.markdown-body',
        ],
        'copilot':[
            '.cm-line',
        ],
        'spark': [
            '.Table',
            '.monaco-editor',
        ],
        '*': [
            '.comment-body', '.js-preview-body',
            '.markdown-title',
            'span.ActionListItem-descriptionWrap',  // 顶部搜索栏 关键词
            'CODE', 'SCRIPT', 'STYLE', 'LINK', 'IMG', 'MARKED-TEXT', 'PRE', 'KBD', 'SVG', 'MARK', // 特定元素标签
			'div.styled-input-content', // 筛选条
        ],
    },

    // 以下兼容 1.9.2 版本，且冻结 等待 1.9.3 明显 Bug 修复
    /**
     * 要翻译的页面正则(不含仓库页)
     *
     * 2021-10-07 11:53:34
     * GitHub 网站更新 调整 Class 过滤规则
     * 且过滤 Class 并不是总是生效，增加 PathName 规则补充
     */
    rePageClass: /\b(page-(profile|new-repo|create-org)|session-authentication)\b/,

    /**
     * 忽略区域的 class 正则
     *
     * 代码编辑器 内容 代码高亮 CodeMirror
     * 代码编辑器 最小单元 cm-line ͼ.*
     * 代码高亮 blob-code
     * 仓库名和用户名 repo-and-owner (已知出现在：应用安装授权页和设置页 选定仓库)
     * 文件,目录位置栏 |js-path-segment|final-path
     * 文件列表 files js-navigation-container js-active-navigation-container
     * 评论内容等 js-comment-body
     * 评论预览 js-preview-body
     * 评论编辑区域 comment-form-textarea
     * 文件搜索模式 js-tree-finder-virtual-filter
     * 仓库文件列表 js-navigation-open Link--primary
     * 快捷键 按键 js-modifier-key
     * 洞察-->流量-->热门内容列表 capped-list-label
     * realease 页面 描述主体 markdown-body my-3
     * 仓库页 仓库描述 f4 my-3
     * 提交的用户名 commit-author$
     * 搜索页 搜索结果 search-match
     * 追溯 视图 代码 react-code-text
     * tree 视图 文件名 react-directory-filename-column 提交信息 react-directory-commit-message
     * 代码差异页面 代码 pl-s1|pl-smi|pl-token|pl-c1|pl-kos|pl-k|pl-c|pl-en
     */
    reIgnoreClass: /(cm-line|ͼ.*|pl-s1|pl-smi|pl-token|pl-c1|pl-kos|pl-k|pl-c|pl-en|CodeMirror|blob-code|highlight-.*|repo-and-owner|js-path-segment|final-path|files js-navigation-container|js-comment-body|js-preview-body|comment-form-textarea|markdown-title|js-tree-finder-virtual-filter|js-navigation-open Link--primary|js-modifier-key|capped-list-label|blob-code blob-code-inner js-file-line|markdown-body my-3|f4 my-3|commit-author$|search-match|react-directory-filename-column|react-directory-commit-message|react-code-text|zausi)/,

    /**
     * 忽略区域的 itemprop 属性正则
     * name 列表页 仓库名
     * author 仓库页 作者名称
     * additionalName 个人主页 附加名称
     */
    reIgnoreItemprop: /(name|author|additionalName)/,

    /**
     * 忽略区域的 特定元素id 正则
     * /blob页面 offset  符号-->引用
     * /blob页面 右侧 符号筛选 filter-results
     * fix repo详情页文件路径breadcrumb
     */
    reIgnoreId: /(readme|^offset|breadcrumb|file-name-id|filter-results)/,

    /**
     * 忽略区域的 标签 正则
     * /i 规则不区分大小写
     */
    reIgnoreTag: ['CODE', 'SCRIPT', 'STYLE', 'LINK', 'IMG', 'MARKED-TEXT', 'PRE', 'KBD'],
    // marked-text --> 文件搜索模式/<user-name>/<repo-name>/find/<branch> 文件列表条目
    // ^script$ --> 避免勿过滤 notifications-list-subscription-form
    // ^pre$ --> 避免勿过滤
};

I18N["zh-CN"] = {};

I18N["zh-CN"]["title"] = { // 标题翻译
    "static": { // 静态翻译
        "Sign up to GitHub · GitHub": "注册 · GitHub",
        "Sign in to GitHub · GitHub": "登录 GitHub · GitHub",
        "Join GitHub · GitHub": "加入 GitHub · GitHub",
        "Forgot your password? · GitHub": "忘记您的密码了吗？· GitHub",
        "Forgot your password?": "忘记您的密码了吗？",
        "GitHub · Where software is built": "GitHub · 软件构建的地方",
        "Create a New Repository": "新建仓库",
        "Import a Repository": "导入仓库",
        "New Project": "创建项目",
        "Your Repositories": "我的仓库",
        "Your Projects": "我的项目",
        "Your Packages": "我的软件包",
        "Your Stars": "我的星标页面",
        "Your profile": "个人资料",
        "Your Achievements": "我的成就",
        "Your Followers": "我的关注者",
        "Who You’re Following": "我关注的人",
        "Account settings": "账户设置",
        "Appearance": "外观",
        "Accessibility": "无障碍",
        "Notification settings": "通知设置",
        "Billing": "账单",
        "Email settings": "邮箱设置",
        "Account security": "账户安全",
        "SSH and GPG keys": "SSH 与 GPG 公钥",
        "Organizations": "组织",
        //"Blocked users": "拉黑用户",
        "Temporary interaction limits": "临时互动限制",
        "Code review limits": "代码审查限制",
        "Repositorys": "仓库",
        "Deleted Packages": "删除的软件包",
        "Pages": "GitHub 页面",
        "Saved replies": "快捷回复",
        "Security & analysis": "安全与分析",
        "Installed GitHub Apps": "已安装的 GitHub 应用",
        "Issue search results": "议题搜索结果",
        "Scheduled reminders": "定时提醒",
        "Security log": "安全日志",
        "Sponsorship Log": "赞助日志",
        "GitHub Apps": "GitHub 应用",
        "Developer applications": "开发者应用",
        "Personal Access Tokens": "个人访问令牌",
        "Register new GitHub App": "注册新 GitHub 应用",
        "New OAuth Application": "新 OAuth 应用",
        "Create a new Gist": "创建新代码片段",
        "Discover gists": "探索代码片段",
        "Enable two-factor authentication": "启用双因素身份验证",
        "Manage two-factor authentication": "管理双因素身份验证",
        "Options": "仓库 · 选项",
        "Confirm access": "授权访问",
        "General": "通常",
        "Manage access": "访问管理",
        "Branches": "分支",
        "Tags": "标签",
        "Webhooks": "Web 钩子",
        "Environments": "环境",
        "Security & analysis": "安全性与分析",
        "Deploy keys": "部署密钥",
        "Add deploy key": "添加部署密钥",
        "Actions secrets": "操作机密",
        "Dependabot secrets": "Dependabot 机密",
        "Configure email notifications": "配置邮件通知",
        "Community Standards": "社区准则",
        "General Organization Settings": "常规组织设置",
        "Member privileges": "成员权限",
        "Teams": "团队",
        "Trending repositories on GitHub today": "今日热门仓库",
        "Trending repositories on GitHub this week": "本周热门仓库",
        "Trending repositories on GitHub this month": "本月热门仓库",
        "Repository defaults": "仓库默认值",
        "Repository search results": "仓库搜索结果",
        "Runners": "运行器",
        "Runner Groups": "运行器组",
        "Packages": "软件包",
        "Package": "软件包",
        "Payment Information": "支付信息",
        "Security": "安全",
        "Verified & approved domains": "经验证和批准的域名",
        "Add a Pages verified domain": "添加一个经验证的 GitHub Pages 域名",
        "Third-party application access policy": "第三方应用访问策略",
        "Audit log": "审计日志",
        "Deleted Repositories": "已删除的仓库",
        "GitHub Publisher Verification": "GitHub 发布者验证",
        "Notifications": "通知",
        "Confirm your account recovery settings": "确认您的账户恢复设置",
        "Your stars": "我的星标",
        "Your starred repositories": "我的星标仓库",
        "Your starred topics": "我的星标主题",
        "Register for the GitHub Developer Program": "注册 GitHub 开发者计划",
        "Codespaces": "代码空间",
        "Codespace Templates": "代码空间模版",
        "Create new codespace": "创建代码空间",
        "Error": "错误",
        "Discover gists · GitHub": "探索代码片段 · GitHub",
        "Explore GitHub Sponsors": "探索 GitHub 赞助者",
        "Actions Usage Metrics": "操作使用情况",
        "Actions usage metrics": "操作使用情况",
        "Fine-grained Personal Access Tokens": "精细化的个人访问令牌",
        "Import repository": "导入仓库",
        "Explore GitHub": "探索 GitHub",
        //"Rate limit · GitHub": "速率限制 · GitHub",
        //"GitHub: Let’s build from here · GitHub": "GitHub: 让我们从这里开始",
        "GitHub · Build and ship software on a single, collaborative platform · GitHub": "GitHub · 在单一协作平台上构建和发布软件",
        "GitHub · Build and ship software on a single, collaborative platform": "GitHub · 在单一协作平台上构建和发布软件",
        "Topics on GitHub · GitHub": "GitHub 上的主题",
        "Code security": "代码安全",
        "Deploy keys": "部署密钥",
        "Actions Performance Metrics": "操作数据看板",
        "Actions performance metrics": "操作数据看板",
        "GitHub Sitemap · GitHub": "GitHub 网站地图",
        "Code search results": "代码搜索结果",
        "Enterprises": "企业版",
        "Blocked users": "黑名单",
        "New conversation · GitHub Copilot": "新聊天 · GitHub Copilot",
        "Models · GitHub Marketplace": "模型 · GitHub 市场",
        "GitHub Education": "GitHub 教育",
        "GitHub Student Developer Pack - GitHub Education": "学生开发包 - GitHub 教育",
        "Get your GitHub benefits - GitHub Education": "获取福利 - GitHub 教育",
        "Signup to GitHub Copilot": "注册 GitHub Copilot",
        "Device Activation": "设备激活",
        "Spending Limit": "支付限额",
        "Autolink references": "自动链接引用",
        "Add autolink reference": "添加自动链接引用",
        "Billing Overview": "账单概览",
        "Billing Usage": "计费用量",
        "Budgets": "预算",
        "Code Security": "代码安全性",
        "New Fine-grained Personal Access Token": "新建精细化个人访问令牌",
        "Coding agent": "编程智能体",
        "Get Started With GitHub Discussions": "开始使用 GitHub 讨论",
        "SSH and GPG keys": "SSH 和 GPG 密钥",
        "MCP Registry": "MCP 互联",
        "User repositories": "用户仓库",
    },
    "regexp": [ // 正则翻译
        [/Authorized OAuth Apps/, "授权的 OAuth 应用"],
        [/Authorized GitHub Apps/, "授权的 GitHub 应用"],
        [/Installed GitHub Apps/, "已安装的 GitHub 应用"],
        [/Accessibility/, "无障碍"],
        [/Environments/, "环境"],
        [/New repository/, "新仓库"],
        [/([^ ]+) \((.+)\) \/ Repositories/, "$1 / 仓库"], // github 账户名/ 成就
        [/([^ ]+) \((.+)\) \/ Starred/, "$1($2) / 星标"], // github 账户名（昵称）/ 星标
        [/Repositories/, "仓库"],
        [/Starred/, "星标页面"],
        [/starred repositories/, "星标仓库"],
        [/starred topics/, "星标主题"],
        [/starred/, "星标"],
        [/Commits · ([^ ]+)/, "提交 · $1"],
        [/New Issue/, "新建议题"],
        [/Issues?/, "议题"],
        [/Pull (R|r)equests?/, "拉取请求"],
        [/Actions secrets · ([^ ]+)/, "操作机密 · $1"],
        [/Actions settings · ([^ ]+)/, "操作设置 · $1"],
        [/Actions/, "操作"],
        [/Projects/, "项目"],
        [/Packages?/, "软件包"],
        [/Settings · Rulesets/, "设置 · 规则集"],
        [/Security Overview/, "安全概述"],
        [/Security Policy/, "安全政策"],
        [/Security Advisories/, "安全公告"],
        [/Dependabot alerts/, "Dependabot 警报"],
        [/Pulse/, "统计"],
        //[/Contributors to/, "贡献者 ·"],
        [/Dashboard/, "仪表板"],
        [/Deployments/, "部署"],
        [/Community/, "社区"],
        [/Traffic/, "流量"],
        [/Commit Activity/, "提交活动"],
        [/Code frequency/, "代码频率"],
        [/Created/, "已创建"],
        [/Dependencies/, "依赖项"],
        [/Network Dependents/, "网络依赖者"],
        [/Network Graph/, "网络图"],
        [/Revisions/,"修订"],
        [/GitHub Skills Quickstart Guide/, "GitHub 技能快速入门指南"],
        [/Skills/, "技能"],
        [/Sponsoring/, "捐助"],
        [/Stargazers/, "追星者"],
        [/Forks?/, "复刻"],
        [/Settings · Tags · ([^ ]+)/, "设置 · 标签 · $1"],
        [/Tags?/, "标签"],
        [/Edit release/, "编辑发行版"],
        [/Releases?/, "发行版"],
        [/Draft Advisory/, "安全公告草案"],
        [/Code scanning alerts/, "代码扫描警报"],
        [/Repository topics/, "仓库主题"],
        [/Scheduled reminders/, "定时提醒"],
        [/Sponsorship Log/, "赞助日志"],
        [/Sponsor @([^ ]+) on GitHub Sponsors/, "在 GitHub 上赞助 $1"],
        [/OAuth applications/, "OAuth 应用"],
        [/People · Pending Collaborators/, "成员 · 待定协作者"],
        [/Members · People · ([^ ]+)/, "成员 · $1"],
        [/People/, "成员"],
        [/Outside collaborators/, "外部协作者"],
        [/New Discussion/, "新讨论"],
        [/Discussions/, "讨论"],
        [/Workflow runs/, "工作流运行"],
        [/Webhooks · Settings/, "Web 钩子 · 设置"],
        [/Add a code of conduct to/, "添加代码行为准则到"],
        [/Caches?/, "缓存"],
        [/Runners?/, "运行器"],
        [/Attestations?/, "证书"],
        [/Activit(y|ies)/, "活动"],
        [/Rate limit/, "速率限制"],
        [/Comparing/, "比较"],
        [/History for ([^ ]+)/, "$1 的历史"],
        [/Compare plans for ([^ ]+)/, "为 $1 比较计划"],
        [/([^ ]+)’s gists/, "$1 的代码片段"],
        [/Secret scanning · ([^ ]+)/, "机密扫描 · $1"],
        [/Dependabot secrets · ([^ ]+)/, "Dependabot 机密 · $1"],
        [/Contributors to ([^ ]+)/, "贡献者 · $1"],
        [/([^ ]+) repositories^/, "$1 的仓库"],
        [/Create new page · ([^ ]+) Wiki/, "新建页面 · $1 的 Wiki"],
        [/Settings · Branches · ([^ ]+)/, "设置 · 分支 · $1"],
        [/Webhooks · Settings · ([^ ]+)/, "Web 钩子  · 设置 · $1"],
        [/Environments · ([^ ]+)/, "环境 · $1"],
        [/Branches · ([^ ]+)/, "分支 · $1"],
        [/([^ ]+) · GitHub Topics/, "$1 · GitHub 主题"],
        [/New release · ([^ ]+)/, "新发行版 · $1"],
        [/Codespaces secrets · ([^ ]+)/, "代码空间机密 · $1"],
        [/Dependabot secrets · ([^ ]+)/, "Dependabot 机密 · $1"],
        [/Invitation to join ([^ ]+)/, "加入 $1 邀请"],
        [/Security Managers for · ([^ ]+)/, "安全管理员 · $1"],
        [/New File at \/ · ([^ ]+)/, "新建文件 · $1"],
        [/Blaming ([^ ]+) at ([^ ]+) · ([^ ]+)/, "追溯 $1（$2） · $3"],
        [/Deleting ([^ ]+)\/([^ ]+) at ([^ ]+) · ([^ ]+)/, "删除 $3/$2 · $4"], // 简化部分内容
        [/([^ ]+)'s list \/ (.+)/, "$1 的列表 / $2"],
        [/([^ ]+) \((.+)\) \/ Achievements/, "$1($2) / 成就"], // github 账户名（昵称）/ 成就
        [/Teams · ([^ ]+)/, "团队 · $1"],
        [/Create new team · ([^ ]+)/, "新建团队 · $1"],
        ["_regexp_end", "end"]
    ],
};

I18N["zh-CN"]["public"] = { // 公共区域翻译
    "static": { // 静态翻译
        // 错误页面
            "Find code, projects, and people on GitHub:": "在 GitHub 上查找代码、项目和人员：",
            "Access has been restricted": "访问被限制",
                "You have triggered a rate limit.": "您已触发速率限制。",
                "Please wait a few minutes before you try again;": "请稍等几分钟再重试；",
                "in some cases this may take up to an hour.": "在某些情况下，这可能最多需要一个小时。",
            "No server is currently available to service your request.": "当前服务器无法为您的请求提供服务。",
            "This page is taking too long to load.": "此页面加载时间过长。",
            "We had issues producing the response to your request.": "我们在响应您的请求时遇到了问题。",
            "Sorry about that. Please try refreshing and contact us if the problem persists.": "对此我们很抱歉。请尝试刷新，如果问题仍然存在，请联系我们。",
            "Error": "错误",
            "Looks like network is down!": "看起来网络未连接！",
            "Contact Support": "联系 GitHub 支持",
            "GitHub Status": "GitHub 状态",

        // 底部红条
            "You can’t perform that action at this time.": "此时无法执行该操作。",

        // 速率限制 - 短时间频繁访问网页，至少包括 https://github.com/issues
            "Whoa there!": "请停一下！",
            "You have exceeded a secondary rate limit.": "您已经超出次要速率限制。",
            "Please wait a few minutes before you try again;": "请稍等几分钟再重试；",
            "in some cases this may take up to an hour.": "在某些情况下，这可能最多需要一个小时。",

        // 议题、拉取请求、讨论浮动信息卡（在任一引用这些链接的页面都会出现
            "You opened this issue": "您打开了这个议题",
            "You opened this pull request": "您打开了这个拉取请求",
            "You commented on this issue": "您对此议题发表了评论",
            "You commented on and opened this issue": "您打开了这个议题并发表评论",
            "You commented on this pull request": "您对此拉取请求发表了评论",
            "You commented on and opened this pull request": "您打开了这个拉取请求并发表评论",
            "You were mentioned on and commented on this issue": "您在此议题上被提及并发表评论",
            "You were mentioned on and commented on this pull request": "您在此拉取请求上被提及并发表评论",
            "You were mentioned on and opened this pull request": "您被提及并打开了此拉取请求",
            "You are assigned to this pull request": "您被指派处理此拉取请求",
            "You are assigned to and opened this pull request": "您打开并被指派处理此拉取请求",
            "You left a review": "您已评论",
            "Changes requested": "请求更改", // 拉取请求
            "Review required": "请求审查", // 拉取请求
            "Approved": "已批准", // 拉取请求
            "replied": "已回复", // 讨论

        // 顶部栏 (未登录)
            "Platform": "平台",
                "AI CODE CREATION": "AI 代码生成",
                    // Copilot
                        "Write better code with AI": "借助 AI 写出更好的代码",
                    // Spark
                        "Build and deploy intelligent apps": "构建和部署智能应用",
                    "GitHub Models": "GitHub 模型",
                        "Manage and compare prompts": "管理和比较提示词",
                    "MCP Registry": "MCP 互联",
                        "Integrate external tools": "集成外部工具",
                "DEVELOPER WORKFLOWS": "开发者工作流",
                    // 操作
                        "Automate any workflow": "自动化任何工作流程",
                    // 代码空间
                        "Instant dev environments": "即时开发环境",
                    // 议题
                        "Plan and track work": "计划和追踪工作",
                    "Code Review": "代码审查",
                        "Manage code changes": "管理代码更改",
                "APPLICATION SECURITY": "应用安全",
                    "GitHub Advanced Security": "GitHub 高级安全",
                        "Find and fix vulnerabilities": "查找并修复漏洞",
                    "Code security": "代码安全",
                        "Secure your code as you build": "边开发边保障代码安全",
                    "Secret protection": "密钥保护",
                        "Stop leaks before they start": "在泄露发生前就阻止它们",

                "EXPLORE": "探索",
                    "Why GitHub": "为什么选择 GitHub",
                    "Changelog": "更新日志",
                    "GitHub Marketplace": "GitHub 市场",

                "View all features": "查看所有功能",

            "Solutions": "解决方案",
                "BY COMPANY SIZE": "企业规模",
                    "Enterprises": "企业",
                    "Small and medium teams": "中小团队",
                    "Startups": "初创公司",
                    "Nonprofits": "非盈利组织",
                "BY USE CASE": "使用案例",
                    "App Modernization": "应用现代化",
                    "DevSecOps": "开发安全运维",
                    "DevOps": "开发运维",
                    "CI/CD": "持续集成/持续部署",
                    "View all use cases": "查看所有使用案例",
                "BY INDUSTRY": "工业",
                    "Healthcare": "健康护理",
                    "Financial services": "金融服务",
                    "Manufacturing": "制造业",
                    "Government": "政府",
                    "View all industries": "查看所有工业",
                "View all solutions": "查看所有解决方案",

            "Resources": "资源",
                "EXPLORE BY TOPIC": "按主题探索",
                    "Software Development": "软件开发",
                    "View all topics": "查看所有主题",
                "EXPLORE BY TYPE": "按类型探索",
                    "Customer Stories": "客户案例",
                    "Customer stories": "客户案例",
                    "Events & webinars": "活动与网络研讨会",
                    "Ebooks & reports": "电子书与报告",
                    "Business insights": "商业洞察",
                    "GitHub Skills": "GitHub 技能课程",
                "SUPPORT & SERVICES": "支持与服务",
                    "Partners": "合作洽谈",
                    "Customer support": "客户支持",
                    "Community forum": "社区论坛",
                    "Trust center": "信任中心",

            "Open Source": "开源",
                "COMMUNITY": "社区",
                    "GitHub Sponsors": "GitHub 赞助者",
                        "Fund open source developers": "资助开源开发人员",
                "PROGRAMS": "项目",
                    "Security Lab": "安全实验室",
                    "Maintainer Community": "维护者社区",
                    "Accelerator": "加速器计划",
                    "Archive Program": "存档计划",
                "REPOSITORIES": "仓库",
                    "Topics": "主题",
                    "Trending": "趋势",
                    "Collections": "集合",

            "Enterprise": "企业",
                "ENTERPRISE SOLUTIONS": "企业级解决方案",
                    "Enterprise platform": "企业平台",
                        "AI-powered developer platform": "AI 驱动的开发者平台",
                "AVAILABLE ADD-ONS": "可选附加组件",
                    // GitHub 高级安全
                        "Enterprise-grade security features": "企业级安全功能",
                    "Copilot for Business": "Copilot 企业版",
                        "Enterprise-grade AI features": "企业级 AI 功能",
                    "Premium Support": "高级支持",
                        "Enterprise-grade 24/7 support": "企业级 24 小时全天候支持",
            "Pricing": "价格",
            "Search": "搜索",
            "Sign in": "登录",
            "Sign up": "注册",

        // 搜索栏
            "Search or jump to...": "搜索或跳转到…",
            "Type": "请键入",
            "to search": "去搜索",
            "Command palette": "命令面板",
            "Saved queries": "已保存的搜索",
            "All of GitHub": "整个 GitHub",
            "Autocomplete": "自动完成",
            "Search all of GitHub": "搜索整个 GitHub",
            "Search in this directory": "在文件夹中搜索",
            "Search in this repository": "在该仓库中搜索",
            "Search in this owner": "在该所有者中搜索",
            "Search in this organization": "在该组织中搜索",
            "Owners": "所有者",
            "Languages": "语言",
            "Search syntax tips": "搜索语法提示",
            "Jump to": "跳转到",

            "Ask Copilot": "询问 Copilot",
            "Start a new Copilot thread": "启动新的 Copilot 对话",

            // 未登录时
                "Enterprise": "企业",
                "Security": "安全",
                "Pricing": "价格",

        // 左上角下拉栏 (已登录)
            "Close menu": "关闭菜单",
            "Home": "主页",
            "Feed": "动态",
            "Issues": "议题",
            "Pull requests": "拉取请求",
            "Projects": "项目",
            "Discussions": "讨论",
            "Codespaces": "代码空间",
            "Explore": "探索",
            "Marketplace": "市场",
            "MCP registry": "MCP 互联",

            "Top repositories": "热门仓库",
                "Search for repositories": "搜索仓库",
                "Close search": "关闭搜索",
                // 团队
                "Search for teams": "搜索团队",

        // 顶部提示横幅
            "Don't get locked out of your account.": "不要被锁定在您的账户之外。",
            "Download your recovery codes": "下载您的恢复码",
            "add a passkey": "添加通行密钥",
            "so you don't lose access when you get a new device.": "这样您在登录新设备时就不会失去访问权限。",
            "GitHub users are": "GitHub 用户",  //下半句正则
            "now required": "现在被要求",  //下半句正则
            "Enable 2FA": "启用 2FA",

            "You only have a single verified email address. We recommend verifying at least one more email address to ensure you can recover your account if you lose access to your primary email.": "您只有一个经过验证的电子邮件地址。我们建议您至少再验证一个电子邮件地址，以确保在失去主邮箱访问权限时可以恢复账户。",
            "Email settings": "电子邮件设置",
            "Your recovery codes have not been saved in the past year. Make sure you still have them stored somewhere safe by viewing and downloading them again.": "如果您在过去一年中没有保存恢复密码。请确保将其保存在安全的地方，并再次查看和下载。",
                "View recovery codes": "查看恢复码",
            "You can also": "您也可以",
            "view this object as it appeared at the time of the comment": "查看此对象在评论时的状态",


        "Your issues": "您的议题",
        "Your pull requests": "您的拉取请求",

        // 右上角通知按钮提示
            "You have no unread notifications": "您没有未读通知",
            "You have unread notifications": "您有未读通知",

        // 右上角新建按钮下拉菜单
            "Create new...": "新建…",
            "Create new…": "新建…",
                "New repository": "新建仓库",
                "Import repository": "导入仓库",
                "New spark": "新建 spark",
                "New agent task": "新建智能体任务",
                "New codespace": "新建代码空间",
                "New gist": "新建代码片段",
                "New organization": "新建组织",
                "New project": "新建项目",
                "This organization": "本组织", // 组织
                "New team": "新建团队", // 组织
                // 新建议题 对话框
                    "Create new issue": "新建议题",
                    "Copy link": "复制链接",
                    "Templates and forms": "模板和表单",
                    "Blank issue": "空白议题",
                        "Create a new issue from scratch": "从头开始创建新议题",

        // 右上角 Copilot 下拉菜单
            "Agents":"智能体",
            "Chat with Copilot": "与 Copilot 聊天",
            "Learn more about Copilot coding agent": "了解有关 Copilot 编程智能体的更多信息",
            "Start a new task with Copilot": "使用 Copilot 启动新任务",
            "Describe a coding task to work on": "描述要完成的编程任务",
            "Open Copilot…": "打开 Copilot…",
                "New conversation in": "新聊天",
                "New conversation": "新聊天",
                    "Assistive": "小窗",
                    "Spaces": "空间",
                    "Immersive": "全屏",
                "Download for": "下载插件",

            "Open agents panel": "打开智能体面板",
                "Start a task with Copilot coding agent": "使用 Copilot 编程智能体开始任务",
                    "Describe your task in natural language. Copilot will work in the background and open a pull request for your review.": "请用自然语言描述您的任务。Copilot 会在后台工作，并创建一个拉取请求供您审核。",

                "Agent tasks": "智能体任务",
                    "Switch branches": "切换分支",
                        "Filter branches": "查找分支",
                        "default": "默认",

                "Recent tasks": "近期任务",

        // 右上角个人图标下拉菜单
            "Account switcher": "账户切换",
                "Add account": "添加账户",
                "Switch account": "切换账户",
                "Sign out...": "登出…",
            "Set status": "状态设置",
            "Profile": "个人资料",
            "Gists": "代码片段",

            "Settings": "设置",
            "Copilot settings": "Copilot 设置",
            "Feature preview": "功能预览",
            "Feature Preview": "功能预览",
                "Get early access to new features and give feedback": "测试新功能并提交反馈",
                "Help us improve this and make your experience even better.": "帮我们改进此功能，提升您的体验。",
                "On": "开",
                "Off": "关",
                // 对话框
                "Feature preview dialog": "功能预览对话框",
                "Enable": "启用",
                "Enabled": "启用",
                "Disable": "禁用",
                "Disabled": "禁用",
                "Documentation": "文档",

                "Colorblind themes": "色盲主题",
                    "Varying by gender and geography, color blindness can affect on average 8% of men and up to 0.5% of women. Our previous colorblind theme has been split into two new themes:": "色盲会因性别和地域的不同而有所不同，平均而言，色盲会影响约 8% 的男性和约 0.5% 的女性。我们之前的色盲主题被分为两个新主题：",
                    "Light/dark Protanopia & Deuteranopia for red/green color blindness.": "明/暗 - 红绿色盲主题适用于红绿色盲。",
                    "Light/dark Tritanopia for blue/yellow color blindness.": "明/暗 - 蓝色盲主题适用于蓝黄色盲。",
                "Command Palette": "命令面板",
                    "Quickly navigate and jump between your organizations or repositories and search recent issues, pull requests, projects and more with the new command palette. You can also execute time saving commands all without lifting your fingers off the keyboard!": "使用新的命令面板，可以快速导航并跳转到您所在的组织或仓库，并搜索最近的议题、拉取请求、项目等等。您还可以执行节省时间的命令，而无需将手指从键盘上移开！",
                    "To open the command palette:": "打开命令面板：",
                        "other:": "其他：",
                "Organization Custom Instructions": "组织自定义指令",
                    "Organization administrators can apply custom instructions across all Copilot chats in github.com.": "组织管理员可以在 GitHub.com 的所有 Copilot 聊天中应用自定义指令。",
                "New Dashboard Experience": "新仪表板体验",
                    "The updated home dashboard introduces enhanced agent workflows, making it easier to create and manage agent sessions, issues, and pull requests directly from your personalized dashboard. Once enabled, please refresh to see the changes.": "更新后的主页仪表板引入了增强的智能体工作流，使您可以更轻松地直接从个性化仪表板创建和管理智能体会话、议题和拉取请求。启用后，请刷新以查看更改。",
                "Rich Jupyter Notebook Diffs": "Jupyter Notebook 的丰富差异视图",
                    "Enables rich diffs of Jupyter Notebooks in pull requests": "在拉取请求中启用 Jupyter Notebook 的丰富差异视图",
                    "Note: commenting on rich diff views of notebooks is not yet supported": "注意：尚不支持对 Jupyter Notebook 的丰富差异视图进行评论",
                "New Files Changed Experience": "新版文件更改体验",
                    "Feature enabling the new Files Changed Page": "启用新版更改的文件页",
                "Slash Commands": "斜杠命令",
                    "Slash commands make it easier to type more complex Markdown, such as tables, tasklists, and code blocks.": "斜线命令可以让您更轻松地输入更复杂的 Markdown，如表格、任务列表和代码块。",
                    "Simply type": "只需在议题、拉取请求和讨论中键入",
                    "on Issues, PRs and Discussions to check out a list of available commands!": "，即可查看可用命令的列表！",
                "Feature disabled.": "功能已禁用。",
                    "Please": "请",
                    "give feedback": "提交反馈",
                    "so we can improve it!": "以便我们加以改进！",
                // 出错提示
                    "Sorry, something went wrong and we were not able to fetch the feature previews": "对不起，出了点问题，我们无法获取功能预览",
            "Appearance": "外观",
            "Accessibility": "无障碍",
            "Upgrade": "升级",
            "Try Enterprise": "试用企业版",
                "Free": "免费",
            "Sign out": "退出",

        // 状态设置对话框
        // 出现位置: 个人资料页, Gist 个人主页, 仓库页右上角个人图标下拉菜单
            "Edit status": "编辑状态",
            "What's happening?": "发生了什么？",

            "Suggestions": "建议",
                "On vacation": "在度假",
                "Out sick": "生病",
                "Working from home": "在家工作",
                "Focusing": "专注中",

            "Busy": "繁忙中",
                "When others mention you, assign you, or request your review, GitHub will let them know that you have limited availability.": "当其他人提及您、指派您或请求您进行评论时，GitHub 会告知他们您很忙。",
                "I may be slow to respond.": "我的回复可能比较慢。",

            "Clear status": "清除状态",
                "Never": "永不",
                "in 30 minutes": "30 分钟",
                "in 1 hour": "1 小时",
                "in 4 hours": "4 小时",
                "after today": "今日之后",
                "after this week": "本周之后",
                "after a month": "本月之后",
                "How long until this status will automatically clear.": "多久后状态自动清除。",
            "Visible to": "可见",
                "Everyone": "任何人",
                    "Scope status visibility to a single organization.": "将状态可视范围扩大到单个组织。",
            "Filter emoji": "筛选表情符号",
                "Search results": "筛选结果",

        // 底部条
            "Terms": "服务条款",
            "Privacy": "隐私",
            "Security": "安全",
            "Status": "状态",
            "Community": "社区",
            "Docs": "文档",
            "Contact": "联系我们",
            "Manage cookies": "管理 Cookies",
            "Do not share my personal information": "请勿分享我的个人信息",

        // 左侧栏底部条
            "About": "关于",
            "Blog": "博客",
            "Manage Cookies": "管理 Cookies",

        // 其他
            "Contact GitHub": "联系 GitHub",
            "Training": "培训",

        // 描述、评论编辑器翻译
            "Add a comment": "添加评论",
            "Add a body": "添加内容",
            "Write": "撰写",
                "Use Markdown to format your comment": "使用 Markdown 格式编写评论",
                "Add your comment here...": "在此添加您的评论…",
                "Add your answer here...": "在此添加您的答复…", // 具体讨论页
                "Text field is empty": "文本框为空",
            "Preview": "预览",
                "Nothing to preview": "没有可预览的内容。",
                "This file is empty.": "这是一个空文件。",
                "Try again with a file that’s not empty.": "使用非空文件重试。",
            "Leave a comment": "发表评论",
            "Write a reply": "发表回复", // 具体讨论页
            "Write a comment": "发表评论", // 具体讨论页
            "Suggest an answer": "提出答复", // 具体讨论页
            "Ask a question, start a conversation, or make an announcement": "提出问题、开始讨论或发布公告", // 新建讨论
            "Nothing to preview": "没有什么可预览",
            "This repository has been archived.": "此仓库已存档。", // 已存档仓库 某个提交的评论框
            "Add review comment": "添加审查意见", // 具体拉取请求 文件审查意见
            "Failed to save comment: Body can't be blank": "保存评论失败：正文内容不能为空", // 具体拉取请求 文件审查意见
            "Start a review": "开始审查", // 具体拉取请求 文件审查意见
            // 取消按钮 提醒信息
            "Are you sure you want to discard your unsaved changes?": "您确定要放弃未保存的更改吗？",

            "Apply Suggestion": "添加建议",
            "Add a title": "添加标题",
                "Title": "标题",
            "Add a description": "添加描述",
                "Add your description here...": "在此添加您的描述…",
                "Add an optional description...": "添加可选描述…",
            "There was an error trying to commit changes: Failed to submit suggested changes": "提交更改时出错：提交建议更改失败",

            // 网络错误
                "There was a problem saving your comment. Please try again.": "保存您的评论时出现问题。请再试一次。",

            // 拉取请求 代码审查 回复对话框
                "Add a suggestion, <Ctrl+g>": "添加建议, <Ctrl+g>",
                "Heading": "标题",
                "Bold": "粗体",
                "Italic": "斜体",
                "Quote": "摘引",
                "Link": "链接",
                "Menu": "菜单", // Android UA 下出现
                "Numbered list": "有序列表",
                "Unordered list": "无序列表",
                "Task list": "任务列表",
                "Attach files": "附件",
                "Mention": "提及",
                "Reference": "引用",
                "Saved replies": "快速回复",
                    "Select a reply": "选择回复",
                    "Create a new saved reply": "创建新的快速回复",
                "Slash commands": "斜杠命令",
                    "Alerts": "警示",
                        "Add a markdown alert to emphasize important information": "添加 MarkDown 警示标记，强调重要信息",
                    "Code block": "代码块",
                        "Insert a code block formatted for a chosen syntax": "插入针对所选语法格式化的代码块",
                    "Details": "详细信息",
                        "Add a details tag to hide content behind a visible heading": "添加详情标签，将内容隐藏在可见标题后面",
                    // "快速回复": "",
                        "Insert one of your saved replies": "插入您快速回复",
                    "Table": "表格",
                        "Add markdown table": "添加 Markdown 表格",
                    "Templates": "模板",
                        "Insert one of your issue templates": "插入您的议题模板",

                    "Slash": "斜杠",
                    // 代码块
                        "No Syntax": "无语法",
                    // 快速回复
                        "No saved replies": "尚无快速回复",
                        "You can create one in your": "您可以创建一个在您的",
                        "settings": "设置",
                    // 表格
                        "Columns": "列",
                        "1 column": "1 列",
                        "2 columns": "2 列",
                        "3 columns": "3 列",
                        "4 columns": "4 列",
                        "5 columns": "5 列",

                        "Rows": "行",
                        "1 row": "1 行",
                        "2 rows": "2 行",
                        "3 rows": "3 行",
                        "4 rows": "4 行",
                        "5 rows": "5 行",

                    // 模板
                        "No issue templates": "尚无议题模板",
                        "Learn more about": "了解更多关于",
                        "issue templates": "议题模板",

                // 小屏 插入链接 对话框
                    "Insert Link": "插入链接",
                    "Link Text": "链接文本",
                    "Add": "添加",

            "Attach files by": "通过",
            "dragging & dropping,": "拖放，",
            "selecting or pasting them.": "选择或粘贴来附加文件。",
            "Markdown is supported": "支持 Markdown 语法",
            "Styling with Markdown is supported.": "支持 Markdown 语法。",
            "Paste, drop, or click to add files": "粘贴、拖放或点击添加文件",
            "Write with Copilot": "使用 Copilot 撰写",
            "Type your description here…": "在此输入描述…",
            "Assignee": "受理人",
            "Label": "标签",
            "Create more": "添加更多",
            "Start typing to create an item, or type # to select a repository": "开始输入以创建项目，或输入 # 选择仓库",
            "Uploading your files…": "正在上传您的文件…",
            // 文件过大
                "This video is too big.": "该影片过大。",
                "Try again": "请上传",
                "with a file size less than 10MB.": "体积小于10MB的文件",

            "Close issue": "关闭议题", // issue页 评论框
                "Close as completed": "完成后关闭",
                    "Done, closed, fixed, resolved": "已完成、已关闭、已修复、已解决",
                "Close as not planned": "非计划中关闭",
                    "Won't fix, can't repro, duplicate, stale": "不会修复，无法重现，重复，陈旧",
                    "Won't fix, can't repro, stale": "不会修复，无法重现，陈旧", // 新版议题页
                // 因重复而关闭（新版议题页）
                    "Duplicate of another issue": "重复议题",
            "Close with comment": "评论并关闭", // 议题/拉取请求 评论框
            "Close pull request": "关闭拉取请求", // 拉取请求页 评论框
            "Reopen discussion": "重新打开讨论", // discussion页 评论框
            "Close discussion": "关闭讨论", // discussion页 评论框
                "Close as resolved": "因解决而关闭",
                    "The discussion has been resolved": "讨论已解决",
                "Close as outdated": "因过时而关闭",
                    "The discussion is no longer relevant": "讨论不再相关",
                "Close as duplicate": "因重复而关闭",
                    "The discussion is a duplicate of another": "讨论与另一个讨论重复",
            "Comment": "评论",
            "comment": "评论",
            "Submit new issue": "提交新议题",
            "Comment on this commit": "评论",
            "Close and comment": "提交并关闭",
            "Reopen and comment": "提交并重新打开",
            "Reopen issue": "重新打开议题", // 具体议题
            "Reopen with comment": "重新打开评论", // 具体议题
            "Reopen pull request": "重新打开拉取请求", //具体拉取请求
            "Add single comment": "评论", // 具体提交页 进行某条代码评论
            "Reply": "回复", // 具体讨论页
            "Answer": "答复", // 具体讨论页
            "Start discussion": "开始讨论", // 新建讨论
            "discussion": "讨论", // 新建讨论
            "discussions": "讨论", // 新建讨论

            "Spammy": "仅自己可见",
                "This user is marked as spammy. Their comments will onlyshow in staff mode.": "该用户已被封号，评论仅自己可见。",

        // 添加到清单
            "Add to list": "添加到清单",
                "You don't have any lists yet.": "您尚无任何清单。",
                "Lists": "清单",
                    "Search lists": "搜索清单",
                    "🔮 Future ideas": "🔮 超前想法",
                    "🚀 My stack": "🚀 技术栈",
                    "✨ Inspiration": "✨ 灵感",
                    "No results found.": "未找到结果。",
                "Create list": "创建清单",
                    "Create a list to organize your starred repositories.": "创建一个清单来组织您的星标仓库。",
                    "⭐️ Name this list": "⭐️ 清单名称",
                    "Write a description": "简单描述",
                    // 小贴士
                        "type": "输入",
                        "to add emoji to the name or description.": "在名称或描述中添加表情符号",
                    "Lists are currently in beta.": "清单目前处于测试阶段。",
                    "Share feedback and report bugs.": "分享反馈意见和报告错误。",
                    "Creating...": "创建中…",
                    // 私有
                        "Enabling this makes the list visible only to you.": "启用此选项将使该列表仅对您可见。",

        // 全局快捷键对话框 - 快捷键 ? 打开
            "Keyboard shortcuts": "键盘快捷键",
            "Site-wide shortcuts": "全站快捷键",
                "Open command palette": "打开命令面板",
                "Open command palette in command mode": "在命令模式下打开命令面板",
                "Focus search bar": "聚焦搜索栏", // gist
                "Open search bar": "打开搜索栏",
                "Go to notifications": "跳转到通知",
                "Go to dashboard": "跳转到仪表板",
                "Go to your issues": "跳转到议题",
                "Go to your pull requests": "跳转到拉取请求",
                "Bring up this help dialog": "弹出这个帮助对话框",
                "Move selection down": "向下移动选择",
                "Move selection up": "向上移动选择",
                "Toggle selection": "切换选择",
                "Open selection": "打开选择",
                "Expand and move focus into focused link's hovercard": "展开并将焦点移至聚焦链接的悬浮卡",
            "View all keyboard shortcuts": "查看所有键盘快捷键",

        // 命令面板 - ctrl k 或 ctrl alt k 打开
            "Clear Command Palette": "清除命令面板",
            "Tip:": "小贴士：",
                "Go to your accessibility settings to change your keyboard shortcuts": "跳转到您的无障碍设置，以更改您的键盘快捷键",
                "to search discussions": "搜索讨论", // 键入 #
                "to search issues": "搜索议题", // 键入 #
                "to search pull requests": "搜索拉取请求", // 键入 #
                "to search projects": "搜索项目", // 键入 !
                "to search people and organizations": "搜索成员和组织", // 键入 @
                "to search teams": "搜索团队", // 键入 @
                "to activate command mode": "激活命令模式", // 键入 >
                "Type is:issue to filter to issues": "键入 is:issue 以筛选议题",
                "Type is:pr to filter to pull requests": "键入 is:pr 以筛选拉取请求",
                "Type is:open to filter to open content": "键入 is:open 以筛选打开的内容",
                "Type author:@me to search your content": "键入 author:@me 以筛选您的内容",
                "for help and tips": "寻求帮助和提示", // 键入 ?

            "Pages": "GitHub Pages",
            "Dashboard": "仪表板",
            "Notifications": "通知",
            // "Discussions": "讨论",
            "Actions": "操作",
            "Insights": "洞察",
            "Organizations": "组织",
            "Repositories": "仓库",
            "Packages": "软件包",
            "Users": "用户",
            "to jump to": "去跳转",

            "Top result": "最佳结果",
            "No results matched your search": "没有与您的搜索相符的结果",
            // [/in ([\w]+/[\w]+)/, "在 $1"],

            // # 模式
                "Search issues and pull requests": "搜索议题和拉取请求",
                "Search issues, pull requests, discussions, and projects": "搜索议题、拉取请求、讨论和项目",
                "Issues, pull requests, and discussions": "议题、拉取请求和讨论",

            // ! 模式
                "Search projects": "搜索项目",

            // @ 模式
                "Search or jump to a repository": "搜索或跳转到仓库",
                "Search or jump to a user, organization, or repository": "搜索或跳转到用户、组织或仓库",

            // / 文件模式
                "Search files": "搜索文件",
                "Files": "文件",

            // > 命令模式
                "Run a command": "运行命令",
                "Run command": "运行命令",
                "Commands": "命令",
                "Global Commands": "全局命令",
                "Type > to filter": "键入 > 去筛选",
                "– New repository": "- 新建仓库",
                "– Import repository": "- 导入仓库",
                "– New project": "- 新建项目",
                "– New discussion": "- 新建讨论",
                "– New organization": "- 新建组织",
                "– New gist": "- 新建代码片段",
                "– New issue": "- 新建议题",
                "– New file": "- 新建文件",
                "– Change tab size rendering": "- 切换制表符尺寸",
                "– Switch theme": "- 切换主题",

                "New issue": "新建议题",
                "New discussion": "新建讨论",
                "New file": "新建文件",
                "Change tab size rendering": "切换制表符尺寸",
                "Change tab size r...": "切换制表符尺寸",
                    "2 spaces": "2 个空格",
                    "3 spaces": "3 个空格",
                    "4 spaces": "4 个空格",
                    "5 spaces": "5 个空格",
                    "6 spaces": "6 个空格",
                    "7 spaces": "7 个空格",
                    "8 spaces": "8 个空格",
                    "9 spaces": "9 个空格",
                    "10 spaces": "10 个空格",
                    "12 spaces": "12 个空格",
                "Switch theme": "切换主题",
                    "Default dark": "暗 - 默认",
                    "Default light": "亮 - 默认",
                    "Dark dimmed": "昏暗",
                    "Switch theme to dark high contrast": "切换主题为 暗 - 高对比",
                    "Sync with system settings": "与系统设置同步",

            // ? 模式
                "Modes": "模式",
                "Search for": "搜索",
                "across all of GitHub": "在整个 GitHub 中",
                "issues, pull requests, discussions,": "议题、拉取请求、讨论",
                "organizations, repositories,": "组织、仓库",
                "projects": "项目",
                "files": "文件",
                "issues": "议题",
                "pull requests": "拉取请求",
                "organizations": "组织",
                "repositories": "仓库",
                "users": "用户",
                "Activate": "激活",
                "command mode": "命令模式",

                "Use filters in issues, pull requests, discussions, and projects": "在议题、拉取请求、讨论和项目中使用过滤器",
                "Search your issues, pull requests, and discussions": "搜索您的议题、拉取请求和讨论",
                "Filter to pull requests": "筛选拉取请求",
                "Filter to issues": "筛选议题",
                "Filter to discussions": "筛选讨论",
                "Filter to projects": "筛选项目",
                "Filter to open issues, pull requests, and discussions": "筛选打开的议题、拉取请求和讨论",

            // 议题页面
                "Edit issue title": "编辑议题标题",
                "Edit issue body": "编辑议题内容",
                "Transfer issue…": "转移议题…",
                "Delete issue…": "删除议题…",

        // 公共词 高频词
            "Follow": "关注",
            "Unfollow": "取消关注",
            "Star": "星标",
            "Stars": "星标",
            "Unstar": "已加星标",
            "Starred": "已加星标",
            "Fork": "复刻",
            "Save": "保存",
            "Saving…": "保存中…",
            "Saving...": "保存中…",
            "Save changes": "保存更改",
            "Update": "更新",
            "Updating": "更新中",
            "Updating…": "更新中…",
            "Updating...": "更新中…",
            "Delete": "删除",
            "Cancel": "取消",
            "Edit": "编辑",
            "Added on": "添加于",
            "Loading": "加载中",
            "Loading…": "载入中…",
            "Loading...": "载入中…",
            "Copy": "复制",
            "Copied!": "✅ 复制成功!",
            "Copy to clipboard": "复制到剪切板",
            "Give feedback": "反馈",
            "Give us your feedback": "向我们提供反馈意见",
            "Download": "下载",
            "View": "查看",
            "Create": "创建",

            "Close": "关闭",
            "Closed": "已关闭",
            "Open": "打开",
            "Reopen": "重新打开",

            "and": "和",
            ", and": "，和",
            "or": "或",
            ", or": "，或",
            "to": "到",
            "by": "由",
            "on": "于",
            "Use": "使用",
            "New": "新",

            "Learn more": "了解更多",
            "Learn More": "了解更多",
            "Learn more.": "了解更多。",
            ",": "，",
            ".": "。",

            "Prev": "上一页",
            "Previous": "上一页",
            "Next": "下一页",

            "Less": "更少",
            "More": "更多",

            "Show more": "显示更多",
            "Show less": "显示更少",

            "Load more…": "载入更多…",
            "Loading more…": "载入更多…",
            "Loading more...": "载入更多…",

            // 名词
                "Public": "公共",
                "Private": "私有",
                "Public archive": "公共存档",
                "Private archive": "私有存档",
                "Public template": "公共模板",
                "Public mirror": "公共镜像",
                "Code": "代码",
                "Overview": "概况",
                "Followers": "关注者",
                "Collaborators": "协作者",
                "collaborators": "协作者",
                "Sponsors": "赞助者",
                "Sponsoring": "赞助者",
                "commit": "提交",
                "commits": "提交",
                "Organization": "组织",
                "People": "成员",
                "Teams": "团队",

            // 相对时间
                "just now": "刚刚",
                "now": "当前",
                "yesterday": "昨天",
                "last month": "上个月",

        // 验证标记浮动信息
            "This commit was created on GitHub.com and signed with GitHub’s": "此提交在 GitHub.com 上创建并签名，使用 GitHub 的",
            "This commit was created on GitHub.com and signed with GitHub's": "此提交在 GitHub.com 上创建并签名，使用 GitHub 的",
            "This commit was created on GitHub.com and signed with GitHub’s verified signature": "此提交在 GitHub.com 上创建并签名，使用 GitHub 的",
            "This commit was signed with the committer's": "此提交已签名，使用提交者的",
            "This tag was signed with the committer's": "此标签已签署，使用提交者的", // /<user-name>/<repo-name>/releases
            "This commit was signed with the committer’s": "此提交已签名，使用提交者的",
            "This tag was signed with the committer’s": "此标签已签署，使用提交者的", //
            "This commit is signed with the committer’s": "此提交已签名，使用提交者的",
            "’s contribution has been verified via GPG key.": "的贡献已通过 GPG 密钥验证。",
            "verified signature": "已验证签名",
            "The key has expired": "密钥已过期",
            "This commit is not signed, but one or more authors requires that any commit attributed to them is signed.": "此提交未签名，但一位或多位作者要求对归属于他们的任何提交进行签名。",
            "We had a problem verifying this signature. Please try again later.": "我们在验证此签名时遇到问题。请稍后再试。",
            "We were unable to verify this signature.": "我们无法验证此签名。",
            "This user has not yet uploaded their public signing key.": "此用户尚未上传其公共签名密钥。",

            "GPG key ID:": "GPG 密钥 ID：",
            "GPG Key ID:": "GPG 密钥 ID：",
            "SSH key Fingerprint:": "SSH 密钥指纹：",
            "SSH Key Fingerprint:": "SSH 密钥指纹：",
            "Learn about vigilant mode": "了解警戒模式",
            "The email in this signature doesn’t match the committer email.": "此签名中的电子邮箱与提交者的电子邮箱不相符。",
            "No user is associated with the committer email.": "提交者的电子邮箱未与用户相关联。",

            "Verified": "已验证",
            "Expired": "已过期",
            "Partially verified": "部分验证",
                "We cannot verify signatures from co-authors, and some of the co-authors attributed to this commit require their commits to be signed.": "我们无法验证来自共同作者的签名，并且此提交的某些共同作者要求对其提交进行签名。",
            "Unverified": "未验证",
                "Upload your public signing GPG key": "上传您的公共签名 GPG 密钥",
                "to verify your signature.": "以验证您的签名。",

        // 邮箱验证提示
            "Please verify your email address to access all of GitHub's features.": "请验证您的电子邮箱地址以便开启所有 GitHub 功能。",
            "Configure email settings": "修改电子邮箱设置",
            "Your email was verified.": "您的电子邮箱地址验证成功！",

        // 标签提示
            "New feature or request": "新功能或要求",

        // 更换新手机, 要求重新下载恢复码的全局提醒
            "Don't get locked out - if you get a new phone this season, be sure to transfer your authenticator app data to the new phone. Enable cloud back up if your authenticator app supports it and consider": "不要被锁在门外——如果您在这个季节买了一部新手机，请务必将您的身份验证器应用数据传输到新手机。如果您的身份验证器应用支持云备份，请启用它并考虑",
            "redownloading your recovery codes": "重新下载您的恢复码",
            ", just to be safe.": "，以确保安全。",

        // 刷新会话提示条
            "You signed in with another tab or window.": "您使用其他标签页或窗口登录。",
            "Reload": "重新加载",
            "to refresh your session.": "以刷新您的会话",

        // Cookie 设置
            "Manage cookie preferences": "管理 Cookie 偏好设置",
            "Most GitHub websites use cookies. Cookies are small text files placed on your device to store data so web servers can use it later. GitHub and our third-party partners use cookies to remember your preferences and settings, help you sign in, show you personalized ads, and analyze how well our websites are working. For more info, see the Cookies and similar technologies section of the": "大多数 GitHub 网站都使用 Cookie。Cookie 是保存在您的设备上的小型文本文件，用于存储数据，以便 Web 服务器稍后使用。GitHub 和我们的第三方合作伙伴使用 Cookie 来记住您的偏好和设置、帮助您登录、向您显示个性化广告以及分析我们网站的运行情况。有关更多信息，请参阅隐私声明中的",
            "Privacy Statement": "Cookie 和类似技术部分",
            "Accept": "接受",
            "Reject": "拒绝",
            "Reset all": "重置全部",
            "Required": "必要的",
            "GitHub uses required cookies to perform essential website functions and to provide the services. For example, cookies are used to log you in, save your language preferences, provide a shopping cart experience, improve performance, route traffic between web servers, detect the size of your screen, determine page load times, improve user experience, and for audience measurement. These cookies are necessary for our websites to work.": "GitHub 使用必需的 Cookie 来执行基本网站功能并提供服务。例如，Cookie 用于登录、保存您的语言偏好、提供购物车体验、提高性能、在 Web 服务器之间路由流量、检测屏幕大小、确定页面加载时间、改善用户体验以及用于受众测量。这些 Cookie 是我们网站正常运行所必需的。",
            "Analytics": "分析",
            "We allow third parties to use analytics cookies to understand how you use our websites so we can make them better. For example, cookies are used to gather information about the pages you visit and how many clicks you need to accomplish a task. We also use some analytics cookies to provide personalized advertising.": "我们允许第三方使用分析性 Cookie 来了解您如何使用我们的网站，以便我们改进网站。例如，Cookie 用于收集有关您访问的页面以及完成任务所需的点击次数的信息。我们还使用一些分析性 Cookie 来提供个性化广告。",
            "Social Media": "社交媒体",
            "GitHub and third parties use social media cookies to show you ads and content based on your social media profiles and activity on GitHub's websites. This ensures that the ads and content you see on our websites and on social media will better reflect your interests. This also enables third parties to develop and improve their products, which they may use on websites that are not owned or operated by GitHub.": "GitHub 和第三方使用社交媒体 Cookie 根据您的社交媒体个人资料和 GitHub 网站上的活动向您显示广告和内容。这可以确保您在我们的网站和社交媒体上看到的广告和内容将更好地反映您的兴趣。还使第三方能够开发和改进它们的产品，它们可能会在不由 GitHub 拥有或运营的网站上使用这些产品。",
            "Advertising": "广告",
            "In addition, GitHub and third parties use advertising cookies to show you new ads based on ads you've already seen. Cookies also track which ads you click or purchases you make after clicking an ad. This is done to show you ads that are more relevant to you and for business purposes with our advertising partners. For example, cookies are used to detect when you click an ad and to show you ads based on your social media interests and website browsing history.": "此外，GitHub 和第三方使用广告 Cookie 根据您已经看过的广告向您显示新广告。Cookie 还会跟踪您点击的广告或点击广告后进行的购买。这样做是为了向您显示与您更相关的广告，并用于与我们的广告合作伙伴开展业务。例如，Cookie 用于检测您何时点击广告，并根据您的社交媒体兴趣和网站浏览历史记录向您显示广告。",

        // 日历
            "Jan": "1月",
            "Feb": "2月",
            "Mar": "3月",
            "Apr": "4月",
            "May": "5月",
            "Jun": "6月",
            "Jul": "7月",
            "Aug": "8月",
            "Sep": "9月",
            "Oct": "10月",
            "Nov": "11月",
            "Dec": "12月",

            "January"   : "1月",
            "February"  : "2月",
            "March"     : "3月",
            "April"     : "4月",
            "June"      : "6月",
            "July"      : "7月",
            "August"    : "8月",
            "September" : "9月",
            "October"   : "10月",
            "November"  : "11月",
            "December"  : "12月",

            "Sun"  : "周日",
            "Mon"  : "周一",
            "Tue"  : "周二",
            "Wed"  : "周三",
            "Thu"  : "周四",
            "Fri"  : "周五",
            "Sat"  : "周六",

        // 语言名称（仅适配热门语言
            "Arabic": "阿拉伯文",
            "Chinese": "中文",
            "English": "英文",
            "French": "法文",
            "German": "德文",
            "Greek, Modern": "希腊文",
            "Italian": "意大利文",
            "Japanese": "日文",
            "Korean": "韩文",
            "Latin": "拉丁文",
            "Portuguese": "葡萄牙文",
            "Russian": "俄文",
            "Sichuan Yi, Nuosu": "彝文", // 存疑
            "Spanish, Castilian": "西班牙文",
            "Thai": "泰文",
            "Tibetan": "藏文",
            "Vietnamese": "越南文",
            "Zhuang, Chuang": "壮文", // 存疑

        // Copilot 窗口
            // 顶部
            "All repositories": "所有仓库",
            "Back": "返回",
            "Conversation options": "选项",
                "Enable custom instructions": "启用个人指导",
                "Disable custom instructions": "禁用个人指导",
                "Personal instructions": "个人指导",
                    "Set up Copilot to align with your workflows and preferences. These instructions will only impact your personal conversation.": "设置 Copilot 以符合您的工作流程和偏好。这些指导仅影响您的个人对话。",
                    "Your instructions": "您的指导",
                        "Role": "角色",
                        "Communication": "通信",
                        "Code preferences": "代码偏好",
                    "characters": "字符",
                "Delete conversation": "删除对话",
                "View all conversations": "查看全部对话",
                    "Active conversations": "最近对话",
                    "All conversations": "所有对话",
                    // 删除
                        "Are you sure? This can’t be undone.": "您确定吗？此操作无法撤销。",
            "Continue in immersive": "全屏对话",
            "Close chat": "关闭",

            "public": "公共",
            "repository": "仓库",

            "Ask Copilot": "询问 Copilot",
                "Select a repository to get started. Ask questions about your codebase to get answers fast and learn your way around.": "选择一个仓库即可开始。询问有关代码库的问题，以快速获得答案并了解相关知识。",
                "uses AI. Check for mistakes.": "使用 AI。请检查错误。",
            "Search repositories to chat about": "搜索要讨论的仓库",
            "Recent repositories": "最近访问",
            "General purpose chat": "普通对话",

            "Loading Conversation": "加载中",
            "Chatting about code and programming": "讨论关于代码和编程",
            // 对话框
            "Ask about the repository:": "询问关于此仓库的信息：",
            "Ask about the tree comparison:": "询问关于比较的信息：",
            "How can I help you?": "有什么可以帮忙？",
            "Attach": "附件",
            "Attach files or symbols": "附加文件或符号",
                "Fetching files, folders, and symbols…": "正在获取文件（夹）和符号…",
            "Add an extension": "添加扩展",
                //"Files and symbols…": "文件和符号…",
                "Files, folders, and symbols": "文件（夹）和符号…",
                    "First attach a repository": "请先附加仓库",
                    "Select files, folders, and symbols": "选择文件（夹）和符号",
                    "Choose a repository to browse for files, folders, and symbols.": "选择仓库以浏览文件（夹）和符号。",
                    //"Attach files and symbols": "附加文件和符号",
                        //"Choose which files and symbols you want to chat about. Use fewer references for more accurate responses.": "选择您想要讨论的文件和符号。使用较少的参考资料即可获得更准确的回复。",
                        "Choose what you want to chat about. Use fewer references for more accurate responses.": "选择您想要讨论的内容。使用较少的参考资料即可获得更准确的回复。",
                        "Search files and symbols": "搜索文件和符号",
                        "Current attachments": "当前附件",
                        "Symbols": "符号",
                "Repository…": "仓库…",
                    "Attach a repository": "附加仓库",
                        "Search repositories": "搜索仓库",
                        "Fetching repositories…": "正在获取仓库",
                "Repository": "仓库",
                "Repositories…": "仓库…",
                    "Select a repository": "选择仓库",
                    "Select repositories": "选择仓库",
                        "Choose repositories to chat about.": "选择以聊天",
                        "Choose a repository to chat about.": "选择以聊天",
                "Remove topic": "移除主题",
                "Add repositories, files, and spaces": "添加仓库、文件和空间",
                "Upload from computer": "上传本机文件",
                "Files and folders": "文件和文件夹",
                "Spaces…": "空间…",
                "Create your first space": "创建您的第一个空间",
                "Extensions…": "扩展…",
                "Extensions": "扩展",
                    "Chat with your favorite tools and services": "使用您最喜欢的工具和服务聊天",
                    "Browse the marketplace to find extensions for the tools and services you rely on": "浏览市场以查找您所依赖的工具和服务的扩展",
                    "Browse marketplace": "前往市场",
            "Add attachment": "添加附件",
            "Remove topic": "移除主题",
            "Convert to file": "转成文件",
            "Remove": "移除",
            "Attachments options": "附件选项",
                "Remove attachments": "移除附件",
            "Send now": "发送",
            "Stop response": "停止响应",
            // 反馈
            "Rate your experience": "反馈",
            // 四个表情
                "Love it": "优",
                "It’s ok": "良",
                "Not great": "中",
                "Hate it": "差",

            "Tell us what you liked or what could be better": "告诉我们您喜欢什么或可以改进的地方",

            // 响应状态
                "Copilot is responding…": "Copilot 响应中…",
                "creating plan": "创建计划中",
                "getting data": "获取数据中",
                "Using the GitHub API to search pull requests": "正在使用 GitHub API 搜索拉取请求",
                "Using the GitHub API to get latest release": "正在使用 GitHub API 获取最新发行版",
                    "Copilot used the": "Copilot 已使用",
                    "Issue API": "议题 API",
                    "tool": "工具",

            // 聊天内容 - 创建拉取请求
                "Are you sure?": "您确定吗？",
                    "Are you sure you wish to execute the \"Create pull request with Copilot coding agent\" tool?": "您确定要执行“使用 Copilot 编程智能体创建拉取请求”工具吗？",
                    "Allow": "允许",
                    "Dismiss": "拒绝",

                "accepted": "允许",
                    "the action": "此操作",

            // 引用
                "More reference options": "更多引用选项",
                    "Attach to chat": "附加至聊天",
                    "Raw": "源码",
                    "Show content": "显示内容",
                        "above": "上方",
                        "below": "下方",
                    "Reference details": "引用信息",
                        "contributor": "贡献者",
                        "contributors": "贡献者",
                        "updated": "更新于",

            // 报错
                "Copilot was interrupted before it could finish this message.": "Copilot 在完成此消息之前被中断。",

            "Please don’t include sensitive, confidential, or personal data. Your anonymous feedback helps us improve our services in line with our": "请不要包含敏感、机密或个人数据。您的匿名反馈有助于我们改进服务，根据",
            "Privacy Policy": "隐私政策",
            "Send": "发送",
            "Task": "任务",
            "Create task": "创建任务",
            "uses AI. Check for mistakes.": "使用 AI。请检查错误。",

            "Copy code": "复制代码",
            "Copied!": "复制成功！",

            "Good response": "点赞",
                "positive feedback submitted": "已提交正面反馈",
            "Bad response": "点踩",
            "Retry": "重试",

            "Give additional feedback": "提交额外反馈",
                "Would you like to participate in our research?": "您愿意参与我们的研究吗？",
                "You will be compensated for your time": "您的时间将得到补偿。",
                "Book a session": "预约",
                "No, thanks": "不，谢谢",

            "Chats": "聊天",
            "No chats yet": "还没有聊天",
            "Ask Copilot anything on the right to start your first chat.": "在右侧询问 Copilot 任何问题，开始您的第一次聊天。",

            "Agent sessions": "智能体任务",
                "New agent session": "新智能体任务",
                "No agents running": "没有智能体任务运行",
                "You can now ask Copilot to work on a task for you in the background, creating a pull request which you can review.": "您现在可以请求 Copilot 在后台处理任务，创建一个拉取请求供您审查。",

            "Explore the latest Copilot launches from Universe ’25": "探索 Universe ’25 的最新 Copilot 启动",
            "See what’s new": "查看最新内容",
            "Explore GitHub’s latest tools shaping agentic software and developer choice.": "探索 GitHub 最新的工具，塑造智能化的软件和开发者选择。",

            "Select a custom agent": "选择自定义智能体",
                "Create an agent": "新建智能体",

            "Start task": "开始任务",

            "Recent agent sessions": "最近智能体任务",
            "Recent sessions": "最近任务",
                "No sessions found. Create one by sending a prompt above.": "没有找到任务。通过发送提示来创建一个。",

            // 空间
            "Duplicate": "复制",
            "Duplicate Space": "复制空间",
            "Spaces are now available through the GitHub MCP in VSCode.": "空间现在可以通过 VSCode 的 GitHub MCP 使用。",
            "Install": "安装",
            "Spaces organize your files, pull requests, issues, and standards so Copilot can give more relevant help for your work.": "空间组织您的文件、拉取请求、议题和标准，以便 Copilot 为您的工作提供更相关的帮助。",
            "Create space": "创建空间",
            "Search...": "搜索…",
            "Shared with me":"与我共享的空间",
            "Start your first space": "开始您的第一个空间",
            "Need help? Read the docs": "需要帮助？阅读文档",
            "Generate code": "生成代码",
            "Produce code that follows your team's patterns.": "生成符合团队规范的代码。",
            "Share knowledge": "分享知识",
            "Centralize docs so your team can quickly find answers.": "集中管理文档，让团队快速找到答案。",
            "Plan projects": "规划项目",
            "Create requirements and issues your team can ship.": "创建团队可交付的需求与议题。",
            "New Space": "新空间",
            "Space name": "空间名称",
            "Choose a name that describes your project or use case": "选择一个描述您的项目或用例的名称",
            "Only you will be able to see this space.": "只有您可以看到此空间。",
            "Create Space": "创建空间",
            "Install MCP": "安装 MCP",
            "Add a short description to explain this space's purpose (e.g., 'Frontend design system' or 'API docs hub').": "添加一个简短的描述，解释此空间的用途（例如，'前端设计系统'或'API 文档中心'）。",
            "Add files": "添加文件",
            "Define Copilot’s role, focus, and what to avoid in this space. Ex. “You are a [role]. Follow our [framework/patterns] to [type of task]. Avoid [practices or tools] unless specified”.": "定义 Copilot 的角色、焦点和在此空间中避免的内容。例如，“您是 [角色]。遵循我们的 [框架/规范] 来 [任务类型]。除非另有说明，否则避免 [实践或工具]。”",
            "Sources": "来源",
            "Conversations": "对话",
            "Add sources": "添加来源",
                "Add repository": "添加仓库",
                "Add files from repository": "从仓库添加文件",
                "Link files, pull requests, and issues": "链接文件、拉取请求和议题",
                "Local": "本地",
                "Upload a file": "上传文件",
                "Add text content": "添加文本内容",
            "Add sources to get started": "添加来源以开始",
            "Provide files, docs, issues, or repositories so Copilot can give more relevant answers.": "提供文件、文档、议题或仓库，以便 Copilot 为您提供更相关的答案。",
            "Start a new conversation in this space by typing in the input box at the top.": "通过在顶部输入框中输入，开始在此空间中的新对话。",
            "Space not found": "空间未找到",
            "This URL may be incorrect, you're signed out of your organization, or the Space may have been deleted.": "此 URL 可能不正确，您已退出组织，或空间可能已被删除。",
            "Manage session": "管理会话",
            "View pull request": "查看拉取请求",
            "View verbose logs": "查看详细日志",
            "More actions": "更多操作",
            "Copilot started work": "Copilot 开始工作",
            "Summary": "摘要",
            "Copy head branch name to clipboard": "复制头分支名称到剪贴板",

    },
    "regexp": [ // 正则翻译
        // Copilot 窗口
        [/Chatting about ([^ ]+)/, "关于 $1 的对话"],
        [/Chatting with (\d+) attachments?/, "附加 $1 个附件"],
        //[/Public code references from 4 repositories/, ""],
        [/Public code references from (\d+) repositor(y|ies)/, "公共代码，引用自 $1 个仓库"],
        [/(\d+) references?/, "$1 条引用"],
        [/(\d+) lines? \((\d+) loc\) ·/, "$1 行（$2 非空行）·"],  // loc = 代码行（line of code）= 行数 - 空行数（lines - blank lines）
        [/Using the GitHub API to search for issues assigned to user ([^ ]+)/, "使用 GitHub API 搜索分配给用户 $1 的议题"],
        [/Chatting with (\d+) attachments?/, "附件 $1 个"],
        [/Choose items from ([^ ]+) to chat about. Use fewer references for more accurate responses./, "从 $1 中选择项目来进行交流。使用较少的引用以获得更准确的回答。"],
        [/Choose files, folders, and symbols from ([^ ]+) to chat about. Use fewer references for more accurate responses./, "选择 $1 中的文件（夹）和符号进行聊天。引用越少，回复越准确。"],
        [/Delete conversation: \"(.+)\"/, "删除对话：“$1”"],
        // 智能体
        [/Branch: (.+)/, "分支：$1"],
        /**
         * 匹配时间格式
         *
         * 月 日 或 月 日, 年
         * Mar 19, 2015 – Mar 19, 2016
         * January 26 – March 19
         * March 26
         *
         * 不知道是否稳定, 暂时先试用着. 2016-03-19 20:46:45
         *
         * 更新于 2021-10-04 15:19:18
         * 增加 带介词 on 的格式，on 翻译不体现
         * on Mar 19, 2015
         * on March 26
         *
         * 更新于 2021-10-10 13:44:36
         * on 星期(简写), 月 日 年  // 个人访问令牌 有效期
         * on Tue, Nov 9 2021
         *
         * 2021-10-19 12:04:19 融合更多规则
         *
         * 4 Sep
         * 30 Dec 2020
         *
         * on 4 Sep
         * on 30 Dec 2020
         *
         * 2021-11-22 12:51:57 新增 格式
         *
         * 星期(全称), 月 日, 年 // 仓库-->洞察-->流量 图示标识
         * Sunday, November 14, 2021
         *
         * 星期(全称), 日 月 年// 仓库-->洞察-->贡献者 和 仓库-->洞察-->代码频率
         * Sunday, 4 Jul 2023
         *
         * 更新于 2023-07-04 13:19:21
         * 新增前缀词, 减少二次组织翻译
         *  Updated Jul 4            // 仪表板页面 仓库标签卡
         *  Commits on Jul 4, 2023   // 提交页面、仓库拉取请求页->提交卡
         *  Joined on Jul 4, 2023    // 追星者，关注者页面
         *
         * 更新于 2023-11-11 16:48:02
         * 个人资料页->贡献卡
         * 日期带后缀
         * on March 19th.
         * on August 22nd.
         * on August 21st.
         *
         * Tip:
         * 正则中的 ?? 前面的字符 重复0次或1次
         * 正则中的 ?: 非捕获符号(即关闭圆括号的捕获能力) 使用方法 (?: 匹配规则) -->该匹配不会被捕获 为 $数字
         */
        [/(^Updated (?:on )?|^Commits on |^Joined on |on )?(?:(Sun(?:day)?|Mon(?:day)?|Tue(?:sday)?|Wed(?:nesday)?|Thu(?:rsday)?|Fri(?:day)?|Sat(?:urday)?)?,? )?(?:(\d{1,2})(?:st.|nd.|rd.|th.)?)? ?(Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:tember)?|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?) ?(\d{1,2})?,? (\d{4})?/g, function (all, prefix, week, date1, month, date2, year) {
            var prefixKey = {
                "Updated "   : "更新于 ",
                "Commits on ": "提交于 ",
                "Joined on " : "加入于 ",
                //"Submitted ": "提交于 ", // 教育
            };
            var weekKey = {
                "Sun"  : "周日",
                "Mon"  : "周一",
                "Tue"  : "周二",
                "Wed"  : "周三",
                "Thu"  : "周四",
                "Fri"  : "周五",
                "Sat"  : "周六"
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            // 处理日期
            var date = date1 ? date1 : date2;
            var formattedDate = (year ? year + '年' : '') + monthKey[month.substring(0, 3)] + (date ? date + '日' : '');

            // 处理星期
            var formattedWeek = week ? '，' + weekKey[week.substring(0, 3)] : '';

            // 返回翻译结果
            return (prefixKey[prefix] ? prefixKey[prefix] : '') + formattedDate + formattedWeek;
        }],
        /**
         * 相对时间格式处理
         *
         * 更新于 2021-11-21 16:47:14
         * 1. 添加 前缀词
         *    over xxx ago // 里程碑页面 最后更新时间
         *    about xxx ago // 里程碑页面 最后更新时间
         *    almost xxx ago // 里程碑页面 最后更新时间
         *    less than xxx ago // 导出账户数据
         * 2. xxx之内的相对时间格式
         *  in 6 minutes // 拉取请求页面
         *
         * 更新于 2021-11-22 11:54:30
         * 1. 修复 Bug: 意外的扩大了匹配范围(不带前缀与后缀的时间) 干扰了带有相对时间的其他规则
         *  7 months
         */
         [/^just now|^now|^last month|^yesterday|(?:(over|about|almost|in) |)(an?|\d+)(?: |)(second|minute|hour|day|month|year)s?( ago|)/, function (all, prefix, count, unit, suffix) {
            if (all === 'now') {
                return '现在';
            }
            if (all === 'just now') {
                return '刚刚';
            }
            if (all === 'last month') {
                return '上个月';
            }
            if (all === 'yesterday') {
                return '昨天';
            }
            if (count[0] === 'a') {
                count = '1';
            } // a, an 修改为 1

            var unitKey = {second: '秒', minute: '分钟', hour: '小时', day: '天', month: '个月', year: '年'};

            if (suffix) {
                return (prefix === 'about' || prefix === 'almost' ? '大约 ' : prefix === 'less than' ? '不到 ' : '') + count + ' ' + unitKey[unit] + (prefix === 'over' ? '多之前' : '之前');
            } else {
                return count + ' ' + unitKey[unit] + (prefix === 'in' ? '之内' : '之前');
            }
        }],
        /**
         * 匹配时间格式 2
         *
         * in 5m 20s
         */
        [/^(?:(in) |)(?:(\d+)m |)(\d+)s/,function (all, prefix, minute, second) {
            all = minute ? minute + '分' + second + '秒' : second + '秒';
            return (prefix ? all + '之内' : all);
        }],

        // 其他翻译
        [/to enable two-factor authentication as an additional security measure. Your activity on GitHub includes you in this requirement. You will need to enable two-factor authentication on your account before ([^ ]+), or be restricted from account actions./, "启用双因素身份验证（2FA）作为额外安全措施。您在 GitHub 上的活动让您接收到此要求。您将需要在 $1 前启用双因素身份验证，否则会被限制账户操作。"],
    ],
    "time-regexp": [ // 时间正则翻译专项
        /**
         * 匹配时间格式
         *
         * 月 日 或 月 日, 年
         * Mar 19, 2015 – Mar 19, 2016
         * January 26 – March 19
         * March 26
         *
         * 不知道是否稳定, 暂时先试用着. 2016-03-19 20:46:45
         *
         * 更新于 2021-10-04 15:19:18
         * 增加 带介词 on 的格式，on 翻译不体现
         * on Mar 19, 2015
         * on March 26
         *
         * 更新于 2021-10-10 13:44:36
         * on 星期(简写), 月 日 年  // 个人访问令牌 有效期
         * on Tue, Nov 9 2021
         *
         * 2021-10-19 12:04:19 融合更多规则
         *
         * 4 Sep
         * 30 Dec 2020
         *
         * on 4 Sep
         * on 30 Dec 2020
         *
         * 2021-11-22 12:51:57 新增 格式
         *
         * 星期(全称), 月 日, 年 // 仓库-->洞察-->流量 图示标识
         * Sunday, November 14, 2021
         *
         * Tip:
         * 正则中的 ?? 前面的字符 重复0次或1次
         * 正则中的 ?: 非捕获符号(即关闭圆括号的捕获能力) 使用方法 (?: 匹配规则) -->该匹配不会被捕获 为 $数字
         */
        [/(?:on |)(?:(\d{1,2}) |)(?:(Sun(?:day)?|Mon(?:day)?|Tue(?:sday)?|Wed(?:nesday)?|Thu(?:rsday)?|Fri(?:day)?|Sat(?:urday)?), |)(?:(Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May(?:)??|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:tember)?|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?)(?:,? |$))(\d{4}|)(\d{1,2}|)(?:,? (\d{4})|)/g, function (all, date1, week, month, year1, date2, year2) {
            var weekKey = {
                "Sun"  : "周日",
                "Mon"  : "周一",
                "Tue"  : "周二",
                "Wed"  : "周三",
                "Thu"  : "周四",
                "Fri"  : "周五",
                "Sat"  : "周六",
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };
            var date = date1 ? date1 : date2;
            var year = year1 ? year1 : year2;
            return (year ? year + '年' : '') + monthKey[month.substring(0, 3)] + (date ? date + '日' : '') + (week ? ', ' + weekKey[week.substring(0, 3)] : '');
        }],
        /**
         * 相对时间格式处理
         *
         * 更新于 2021-11-21 16:47:14
         * 1. 添加 前缀词
         *    over xxx ago // 里程碑页面 最后更新时间
         *    about xxx ago // 里程碑页面 最后更新时间
         *    almost xxx ago // 里程碑页面 最后更新时间
         *    less than xxx ago // 导出账户数据
         * 2. xxx之内的相对时间格式
         *  in 6 minutes // 拉取请求页面
         *
         * 更新于 2021-11-22 11:54:30
         * 1. 修复 Bug: 意外的扩大了匹配范围(不带前缀与后缀的时间) 干扰了带有相对时间的其他规则
         *  7 months
         */
        [/^just now|^now|^last year|^last month|^last week|^yesterday|(?:(over|about|almost|in) |)(an?|\d+)(?: |)(second|minute|hour|day|month|year|week)s?( ago|)/, function (all, prefix, count, unit, suffix) {
            if (all === 'now') {
                return '现在';
            }
            if (all === 'just now') {
                return '刚刚';
            }
            if (all === 'last year') {
                return '最近 1 年';
            }
            if (all === 'last month') {
                return '上个月';
            }
            if (all === 'last week') {
                return '上周';
            }
            if (all === 'yesterday') {
                return '昨天';
            }
            if (count[0] === 'a') {
                count = '1';
            } // a, an 修改为 1

            var unitKey = {second: '秒', minute: '分钟', hour: '小时', day: '天', month: '个月', year: '年', week: '周'};

            if (suffix) {
                return (prefix === 'about' || prefix === 'almost' ? '大约 ' : prefix === 'less than' ? '不到 ' : '') + count + ' ' + unitKey[unit] + (prefix === 'over' ? '多之前' : '之前');
            } else {
                return count + ' ' + unitKey[unit] + (prefix === 'in' ? '之内' : '之前');
            }
        }],
        [/(\d+)(y|h|d|w|m)/, function (all, count, suffix) {
            var suffixKey = {y: '年', h: '小时', d: '天', w: '周', m: '个月'};

            return count + ' ' + suffixKey[suffix] + '之前';
        }],
    ],
    "title": {
        "static": {
            "GitHub · Where software is built": "GitHub · 软件构建的地方",
            "Page not found · GitHub": "找不到页面 · GitHub",
        },
        "regexp": [],
    },
};

I18N["zh-CN"]["orgs-public"] = { // 组织公共部分
    "static": { // 静态翻译
    },
    "regexp": [ // 正则翻译
        [/Invite someone to/, "邀请加入到组织"],
        [/New team in/, "新建团队在组织"],
        [/New repository in/, "新建仓库在组织"],
        [/This organization was marked as archived by an administrator on (.+). It is no longer maintained./, (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `该组织已由管理员于 ${translatedDate} 存档。不再维护。`;
        }],
        [/You are now a member of ([^ ]+)!/, "您现在是 $1 的成员了！"],
    ],
};

I18N["zh-CN"]["page-dashboard"] = { // 已登录的首页 - 仪表板（含组织）
    "static": { // 静态翻译
        // 顶部 GPT 聊天窗口
        "Ask anything": "询问任何事",
        "Send": "发送",
        "Feedback": "反馈",
            "Message": "消息",
            "Tell us your feedback on the new dashboard experience":"告诉我们您对新仪表板体验的反馈",
            "Please don’t include sensitive, confidential, or personal data. Your feedback helps us improve our services in line with our":"请不要包含敏感、机密或个人信息。您的反馈有助于改进我们的服务",

        // 新版首页功能区
        "Task": "任务",
        "Create issue": "创建议题",
            "First, create a new draft issue. Then ask for additional information to fill out the issue.":"首先，创建一个新的草稿议题。然后，要求提供更多信息来完善议题。",
            "First, create an issue with sub issues. Then ask for additional information to fill out these issues.":"首先，创建一个包含子议题的议题。然后，要求提供更多信息来完善这些子议题。",
        "Write code": "编写代码",
        "Models": "模型",
            "Create a profile README":"个人资料",
            "Generate a simple calculator":"简易计算器",
            "Make a Pong game":"乒乓球游戏",
            "Design a Mermaid architecture overview":"Mermaid 架构预览",
        // Git
            "Basic Git commands":"基本 Git 命令",
            "Git branching":"Git 分支",
            "Advanced Git commands":"高级 Git 命令",
        // 拉取请求
            "My open pull requests":"我打开的",
            "Summarize my latest PR":"总结最近",

        "Fast and cost-efficient": "快速、经济高效",
        "Versatile and highly intelligent": "多功能、高智能",
        "Most powerful at complex tasks": "在复杂任务中最强大",
        "Agent sessions": "智能体任务",
        "No sessions found. Try a different filter, or": "没有找到会话。尝试不同的过滤器，或",
        "start a session": "开始任务",
        "Agent sessions options": "智能体任务选项",
        "Agent sessions to include": "智能体任务包含",
        "View all": "查看全部",
        "Number of results": "结果数量",
        "Pull request options": "拉取请求选项",
        "Pull requests to include": "拉取请求包含",
            "Authored": "由您创建",
            "Mentioned": "被提及",
            "Review requested": "请求审查",
            "Reviewed": "已审查",
        "Issue options": "议题选项",
        "Issues to include": "议题包含",
            "Assigned to me": "分配给我",
            "Involves me": "涉及我",
        "Open in Copilot chat": "在 Copilot Chat 中打开",
        "Assign to Copilot": "分配给 Copilot",
        "uses AI. Check for mistakes.": "使用 AI。请检查错误。",

            // 选项
                "Task": "任务",
                "Create issue": "创建议题",

            "Models": "模型",
                    "Fast and cost-efficient": "快速、经济高效",
                    "Versatile and highly intelligent": "多功能、高智能",
                    "Most powerful at complex tasks": "执行复杂任务",

        "Try the new experience": "尝试新版",
        "Try the new dashboard experience": "试用新仪表板",
        "Switch back": "切回旧版",

        // 新手帮助
        "Learn Git and GitHub without any code!": "了解 Git 和 GitHub 无需任何代码！",
        "Using the Hello World guide, you’ll create a repository, start a branch,": "使用 Hello World 指南，您将创建一个仓库，开始一个分支，",
        "write comments, and open a pull request.": "写评论，并创建一个拉取请求。(教程内容就不翻译了...)",
        "Let's get started!": "让我们开始吧！",
        "Hide this notice forever": "永久的隐藏该信息",

        "Welcome to GitHub! What’s next?": "欢迎来到 GitHub！下一步干什么？",
        "Create a repository": "创建一个仓库",
        "Tell us about yourself": "介绍一下您自己",
        "Browse interesting repositories": "浏览有趣的仓库",
        "on Twitter": "在 Twitter 上",

        "You don’t have any repositories yet!": "您目前还没有任何仓库！",
        "Create your first repository": "创建您的第一个仓库",
        "or": "或者",
        "Learn more about Git and GitHub": "了解更多关于 Git 和 GitHub 的信息",

        // 教育版
        "Join GitHub Education!": "加入 GitHub 教育！",
            "GitHub Education opens doors to new skills, tools, and a collaborative community eager to drive innovation. Join us and build a foundation for your future in technology.": "GitHub 教育为您打开通往新技能、新工具以及渴望推动创新的协作社区的大门。加入我们，为您的技术未来打下基础。",
        "Join GitHub Education": "加入 GitHub 教育",

        // 组织
        // [/You’re an owner of the ([^ ]+) organization!/, "您是 $1 组织的所有者！"],
        // [/Create a repository for ([^ ]+)/, "为 $1 创建仓库"],
        "Welcome to the": "欢迎来到",
        "View your teams": "查看您的团队",
        "View and create teams": "查看并创建团队",
        "See all owners": "查看全部所有者",
        "You've been added to the": "您已被添加至",
        "organization.": "组织",
        // [/Edit ([^ ]+)’s settings/, "编辑 $1 的设置"],
        "Return to your personal dashboard": "返回到您的个人仪表板",

        // 已有仓库的项目
        // 左侧栏
        "View organization": "查看组织", // 组织
        "Browse organization's repositories": "浏览组织的仓库", // 组织
        "Top repositories": "置顶仓库",
        "Top Repositories": "置顶仓库", // 安卓UA
        "New": "新建",
        "Find a repository…": "搜索仓库…",
        "Your teams": "您的团队",
            "You don’t belong to any teams yet!": "您还不属于任何团队！",
        "Find a team…": "搜索团队…",
        "Recent activity": "近期活动",
            "When you take actions across GitHub, we’ll provide links to that activity here.": "当您在 GitHub 上采取行动时，我们会在这里提供该活动的链接。", // 组织

        "Create your first project": "创建您的第一个项目",
            "Ready to start building? Create a repository for a new idea or bring over an existing repository to keep contributing to it.": "准备好开始构建了吗？为新想法创建一个仓库或使用现有仓库继续为其做出贡献。",
            "Create repository": "创建仓库",

        "Forked from": "复刻自", // 复刻仓库

        // 中间栏
        "Feed": "动态",
        "The home for all developers — including you.": "所有开发者的家园——包括您。",
        "Welcome to your personal dashboard, where you can find an introduction to how GitHub works, tools to help you build software, and help merging your first lines of code.": "欢迎来到您的个人仪表板，在这里您可以看到关于 GitHub 工作原理的介绍，帮助您构建软件的工具，以及帮助您合并您的第一行代码。",
        "Learn with a tutorial project": "通过教程项目学习",
            "Introduction to GitHub": "GitHub 简介",
            "Get started using GitHub in less than an hour.": "一个小时内学会如何使用 GitHub。",
            "Create a site or blog from your GitHub repositories with GitHub Pages.": "使用 GitHub Pages 从您的 GitHub 仓库创建网站或博客。",
            "Code with Copilot": "使用 Copilot 编程",
            "Develop with AI-powered code suggestions using GitHub Copilot, Codespaces, and VS Code.": "使用 GitHub Copilot、代码空间和 VS Code 通过 AI 驱动的代码建议进行开发。",
            "Hello GitHub Actions": "您好 GitHub Actions",
            "Create a GitHub Action and use it in a workflow.": "创建一个 GitHub Actions 并在工作流中使用它 ",
            "See more tutorial projects": "查看更多的教程项目",
        "Start writing code": "开始编写代码",
            "A repository contains all of your project's files, revision history, and collaborator discussion.": "仓库包含项目的所有文件、修订历史记录和协作者讨论。",
            "Repository name": "仓库名称",
            "name your new repository...": "命名您的新仓库……",
            "Anyone on the internet can see this repository": "任何人都可以看到这个仓库，您可以选择谁能提交。",
            "You choose who can see and commit to this repository": "您可以选择谁可以看和提交到该仓库。",
            "Create a new repository": "创建新的仓库",
            "You're seeing this because you haven't created a repository in a while.": "您看到这个是因为您有一段时间没有创建仓库了。",
            "You're seeing this because you haven't used repositories, issues, and pull requests recently.": "您看到这个是因为您最近没有使用仓库、议题和拉取请求。",
            "Remove from dashboard": "从仪表板中删除",
            "Repositories that need your help": "这些仓库需要您的帮助",
            "See more repos with good first issues": "查看更多适合新手提交议题的仓库",
        "Use tools of the trade": "使用贸易工具",
            "You're seeing this because you haven't opened a pull request in a while.": "您看到这个是因为您有一段时间没有打开拉取请求了。",
                "Simplify your development workflow with a GUI": "使用 GUI 简化开发工作流程",
                "Install GitHub Desktop": "安装 GitHub Desktop",
                "to visualize, commit, and push changes without ever touching the command line.": "来可视化、提交和推送更改，而无需使用命令行。",
            "Get AI-based coding suggestions": "获取基于 AI 的编码建议",
                "Try GitHub Copilot free for 30 days,": "免费试用 GitHub Copilot 30 天，",
                "which suggests entire functions in real time, right from your editor.": "它可以直接从您的编辑器实时建议所有函数。",
            "Write code in your web browser": "在您的网络浏览器中编写代码",
                "Use": "使用",
                "the github.dev web-based editor": "基于 github.dev 的网络编辑器",
                "from your repository or pull request to create and commit changes.": "从您的仓库或拉取请求中创建和提交更改。",
        "Install a powerful code editor": "安装一个强大的代码编辑器",
            "is a multi-platform code editor optimized for building and debugging software.": "是针对构建和调试软件进行了优化的多平台代码编辑器。",
        "Set up your local dev environment": "设置本地开发环境",
            "set up Git": "设置 Git",
            ", simplify your dev workflow with": "，简化您的开发工作流程，使用",
            ", or": "，或",
            "bring GitHub to the command line": "将 GitHub 引入命令行",
        "Get started on GitHub": "开始使用 GitHub",
            "You're seeing this because you haven't used GitHub's core features, yet.": "您看到这个是因为您有一段时间没有使用过 GitHub 的核心功能了。",
        "Introduce yourself with a profile README": "使用 README 介绍自己",
            "Share information about yourself by creating a profile README, which appears at the top of your profile page.": "通过创建个人资料自述文件（README）来分享有关您自己的信息，该信息将显示在您的个人资料页面顶部。",
        "Follow this exercise to try the GitHub flow": "按照此练习尝试 GitHub 流程",
            "GitHub's “Hello World” tutorial teaches you essentials, where you create your own repository and learn GitHub's pull request workflow for creating and reviewing code.": "GitHub 的 “Hello World” 教程会教您基本知识，您可以在其中创建自己的仓库并学习 GitHub 用于创建和审查代码的拉取请求工作流程。",
            "Try the GitHub flow": "尝试 GitHub 流程",
        "About version control and Git": "关于版本控制和 Git",
        "Learn about the version control system, Git, and how it works with GitHub.": "了解版本控制系统、Git 以及它如何与 GitHub 一起工作。",
        "The GitHub Flow": "GitHub 流程",
        "Adopt GitHub's lightweight, branch-based workflow to collaborate on projects.": "采用 GitHub 的轻量级、基于分支的工作流程来协作处理项目。",

        "One moment please...": "稍等一会儿…",
        "Loading activity...": "载入活动…",
        "All activity": "所有活动",

        "Welcome to the new feed!": "欢迎来到新的动态提要!",
        "We’re updating the cards and ranking all the time, so check back regularly. At first, you might need to follow some people or star some repositories to get started": "我们一直在更新卡片和排名，所以请定期查看。一开始，您可能需要关注一些人或标星一些仓库才能开始",
        "Send feedback": "发送反馈",

        "Updates to your homepage feed": "主页动态摘要的更新",
        "We've combined the power of the Following feed with the For you feed so there’s one place to discover content on GitHub. There’s improved filtering so you can customize your feed exactly how you like it, and a shiny new visual design. ✨": "我们将 “关注动态提要” 与 “您的动态提要” 的强大功能结合在一起，让您在一个地方就能发现 GitHub 上的内容。此外，我们还改进了筛选功能，让您可以完全按照自己的喜好定制动态提要，并采用全新的视觉设计。 ✨",
        "Learn more": "了解更多",

        "Explore GitHub": "探索 GitHub",
            "to receive personalized suggestions.": "以获取个性化建议。",

        // 提要筛选
        "Filter": "筛选器",
            "Feed filters": "提要筛选器",
            "Events": "事件",
                "Activity you want to see on your feed": "您想在提要上看到的活动",
            "Announcements": "公告",
                "Special discussion posts from repositories": "来自仓库的特别讨论帖",
            "Releases": "发行版",
                "Update posts from repositories": "来自仓库的更新帖",
            // 赞助
                "Relevant projects or people that are being sponsored": "获得赞助的相关项目或人员",
            "Stars": "星标",
                "Repositories being starred by people": "被人们标星的仓库",
            "Repositories": "仓库",
                "Repositories that are created or forked by people": "由人们创建或复刻的仓库",
            "Repository activity": "仓库活动",
                "Issues and pull requests from repositories": "来自仓库的议题和拉取请求",
            "Follows": "关注",
                "Who people are following": "人们在关注谁",
            "Recommendations": "推荐",
                "Repositories and people you may like": "您可能喜欢的仓库和人",

            "Include events from starred repositories": "包括来自星标仓库中的事件",
                "By default, the feed shows events from repositories you sponsor or watch, and people you follow.": "默认情况下，动态提要显示的事件来自您赞助或关注的仓库，以及您关注的人。",
            "Reset to default": "重置",
            "Save": "保存",

        "Show all": "显示所有",

        "Uh oh!": "哎呀！",
        "There was an error in loading the activity feed.": "载入动态提要时发生错误。",
        "Reload this page": "重载此页面",

        // 动态 状态词
        "starred": "标星了",
        "created": "创建了",
        "forked from": "复刻自",
        "generated from": "创建自",
        "mirrored from": "镜像自",
        "forked": "复刻了",
        "from": "来自",
        "for": "",
        "pushed to": "推送到",
        "released": "发布了",
        "published": "发布了",
        "started sponsoring": "赞助给",
        "started following": "已关注",
        "you": "您",
        "Updated": "更新于",
        "a repository": "1 个仓库",
        "has a new repository": "创建了仓库",
        "created a repository": "创建了仓库",
        "created a branch in": "创建了一个分支在",
        "in": "分支在",
        "Forked to": "复刻为",
        "of": "",
        "made": "将",
        "public": "设为公共",
        "committed": "提交于",
        "posted a discussion in": "发表讨论于",
        "made this repository public": "将此仓库公开",
        "labeled a pull request": "将标签添加到拉取请求中",
        "launched their sponsorship page 💖": "推出了他们的赞助页面 💖",
        //[/and (\d+) more/, "和另外 $1 个"],
        "All reactions": "所有看法",

        "published a release": "发布发行版",
        "forked a repository": "复刻仓库",
        "starred a repository": "星标仓库",
        "sponsored": "赞助了",
        "followed": "关注了",
        "added a repository to": "已将仓库添加到",
        "contributed to": "贡献给",
            // 现在会显示拉取请求状态
            "Merged": "已合并",

        "your repository": "您的仓库",

        "Read more": "阅读更多内容",

        "Subscribe to your news feed": "订阅您的新闻提要",
        "Subscribe to the": "订阅", // 组织
        "organization news feed": "组织的新闻提要", // 组织

        //主页上仓库3个点
        "Feed item options": "推送选项",
        "You're seeing this because of your activity.": "您看到这个是因为您的活动。",
        "Show less activity like this": "显示较少这类活动",
        // [/You're seeing this because you collaborated with ([^ ]+)/, "您看到这个是因为您与 $1 有过合作"],
        // [/You're seeing this because you starred ([^ ]+)/, "您看到这个，是因为您标星了 $1"],
        "Unstar this repository": "取消标星此仓库",
        // [/You're seeing this because you follow ([^ ]+)/, "您看到这个，是因为您关注了 $1"],
        "Unfollow this user": "取消关注此用户",

        "Contributors": "贡献者",
        "Report": "举报",
        "Recommended for you": "为您推荐",
        "Trending repositories": "热门仓库",
        "Latest from our changelog":"来自我们的更新日志",
        "Try the new experience": "尝试新体验",
        "See more": "查看更多",
        "Read more": "阅读更多",
        "You're seeing this based on GitHub-wide trends.": "您看到的是基于 GitHub-wide 的趋势。",
        "Recommended based on people you follow": "根据您关注的人推荐",
        "has a new discussion in": "有一条新讨论，在",
        "Join discussion": "参与讨论",
        "Popular among": "很受欢迎",
        "Popular projects among": "热门项目",
        "people you follow": "在您关注的人中",
        "Sponsor": "赞助",
        "added": "添加",

        // 右侧栏
        "Latest changes": "最新变化",
        "View changelog →": "查看更新日志 →",
        "Explore repositories": "探索仓库",
        "Explore more →": "探索更多 →",

        "Member statuses": "成员状态", // 组织

        // 仪表板右上方看板
        "The world’s fair of software is here.": "世界软件博览会就在这里。",
        "The GitHub Universe call for sessions is now open! Apply to share your expertise by submitting a session proposal today. Plus, get 35% off your tickets to GitHub Universe only for a limited time.": "GitHub Universe 的会议征集现已开启！立即提交您的会议提案，分享您的专业知识。此外，现在限时可享 35% 的 GitHub Universe 会议门票折扣。",

        // 教育看板（申请教育包才有
        "Learn. Collaborate. Grow.": "学习，协作，成长。",
        "GitHub Education gives you the tools and community support to take on tech challenges and turn them into opportunities. Your future in tech starts here!": "GitHub 教育提供工具和社区支持，帮助您应对技术挑战并将其转化为机遇。您科技领域的未来从这里开始！",
        "Go to GitHub Education": "前往 GitHub 教育",

        // 用户 浮动信息卡
        "Member of": "隶属组织",
        // [/, and (\d+) more/, "，以及其他 $1 个组织"],

        // 组织  浮动信息卡
        // [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        // [/(\d+) members?/, "$1 个成员"],

        "Switch dashboard context": "切换默认身份", // 组织
        "Manage organizations": "管理组织", // 组织
        "Create organization": "创建组织", // 组织

        // 首次加入组织通知
        "You’ve been added to the": "您已经被添加到",
        "organization!": "组织！",
        "Here are some quick tips for a first-time organization member.": "以下是首次加入组织的一些提示。",
        "Use the switch context button in the upper left corner of this page to switch between your personal context (": "使用页面左上角的切换身份按钮，您可以在（",
        ") and organizations you are a member of.": "）和组织身份之间进行切换。",
        "After you switch contexts you’ll see an organization-focused dashboard that lists out organization repositories and activities.": "当您切换身份，您会看到一个组织为中心的页面，其中列出了组织库和活动。",

        // 快捷键
        "Dashboards": "仪表板",
        "Go to your issues": "跳转到您的议题",
        "Go to your pull requests": "跳转到您的拉取请求",

        // 新版首页（已登录）2025-10-29
            "Your personal account": "我的个人账户",

            "Started": "开始于",
            "Completed": "完成于",
            "In progress": "进行中",

            "Unable to load agent tasks, try again later.": "无法加载智能体任务，请稍后重试。",
            "Unable to load pull requests, try again later.": "无法加载拉取请求，请稍后重试。",

            "Updated": "更新于",
            "Ready for review": "准备审查",
            "Assigned to Copilot": "分配给 Copilot",
    },
    "regexp": [ // 正则翻译
        [/added (\d+) repositor(y|ies) to/, "添加 $1 个仓库到"],
        [/, and (\d+) more/, "，以及其他 $1 个组织"], // 用户 浮动信息卡
        [/(\d+) repositor(y|ies)/, "$1 个仓库"], // 组织  浮动信息卡
        [/(\d+) of your repositor(y|ies)/, "您的 $1 个仓库"],
        [/(\d+) members?/, "$1 个成员"], // 组织  浮动信息卡
        [/is being deleted./, "正在被删除。"], // 仓库 组织被删除
        [/Your repository \"([^ ]+)\" was successfully deleted./, "您的仓库 “$1” 已成功删除。"], // 仓库删除
        [/(\d+) releases?/, "$1 个发行版"],
        [/(\d+k?) followers?/, "$1 个关注者"],
        [/(\d+) users?/, "$1 个用户"],
        [/(\d+) comments?/, "$1 条评论"],
        [/(\d+) commits? to/, "$1 个提交到"],
        [/(\d+) more commits? »/, "$1 个更多提交到"],
        [/(\d+) issues? needs? help/, "$1 个议题需要帮助"],
        [/Join discussion/, "加入讨论"],
        // [/Updated/, "更新于"],
        // 创建于
        [/Created/, "创建于"],
        [/You’re an owner of the ([^ ]+) organization!/, "您是 $1 组织的所有者！"], // 组织
        [/Create a repository for ([^ ]+)/, "为 $1 创建仓库"], // 组织
        [/Edit ([^ ]+)’s settings/, "编辑 $1 的设置"], // 组织
        [/Check out ([^ ]+)’s public profile/, "查看 $1 的公开资料"], // 组织
        [/and (\d+) more/, "和另外 $1 个"],
        [/You're seeing this because you collaborated with ([^ ]+)/, "您看到这个是因为您与 $1 有过合作"],
        [/You're seeing this because you starred ([^ ]+)/, "您看到这个，是因为您标星了 $1"],
        [/You're seeing this because you follow ([^ ]+)/, "您看到这个，是因为您关注了 $1"],
        [/You and/, "您和另外"],
        [/You reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes)/,function (all, reacted) {
            var reactedKey = {'thumbs up': "点赞", 'thumbs down': "点踩", laugh: "大笑", hooray: "欢呼", confused: "表示困惑", heart: "比心", rocket: "发送火箭", eyes: "表示关注"};

            return '您' + reactedKey[reacted];
        }],
        [/(\d+) (?:people|person) reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes)/, function (all, number, reacted) {
            var reactedKey = {'thumbs up': "点赞", 'thumbs down': "点踩", laugh: "大笑", hooray: "欢呼", confused: "表示困惑", heart: "比心", rocket: "发送火箭", eyes: "表示关注"};

            return number + ' 人' + reactedKey[reacted];
        }],
        [/Support ([^ ]+)'s open source work/, "支持 $1 的开源工作"],
        [/Start a new repository for/, "创建一个仓库为"],
        [/([^ ]+) requested changes, you commented/, "$1 要求更改，您发表评论"], // 拉取请求 浮动信息卡
        // 顶部提醒
        // 继任者相关
        [/You are now the designated successor for ([^ ]+)'s account./, "您现在是 $1 的指定继任者了。"],
        [/You have declined to become the designated successor for ([^ ]+)'s account./, "您已经谢绝了成为 $1 账户指定继任者的邀请。"],
        // 拉取请求状态
        [/merged (\d+) commits?/, "合并 $1 个提交"],
        // 新版首页
        [/Good morning, ([^ ]+)!/, "早上好，$1！"],
        [/Good afternoon, ([^ ]+)!/, "下午好，$1！"],
        [/Good evening, ([^ ]+)!/, "晚上好，$1！"],
        [/Switch dashboard: ([^ ]+)/, "切换仪表板：$1"],
        [/(.+)\#(\d+) · Opened by ([^ ]+) ·/, "$1#$2 · 打开者 $3"],
    ],
    "title": {
        "static": {
            "GitHub Dashboard": "GitHub 仪表盘",
            "Feed": "动态",
        },
    },
};
I18N["zh-CN"]["dashboard"] = I18N["zh-CN"]["page-dashboard"];
I18N["zh-CN"]["feed"] = I18N["zh-CN"]["page-dashboard"];
I18N["zh-CN"]["orgs/dashboard"] = I18N["zh-CN"]["page-dashboard"];

I18N["zh-CN"]["page-profile-public"] = { // 个人首页（含组织）
    "static": { // 静态翻译
        // 左侧用户信息栏
            "Change your avatar": "修改头像",
            "they/them": "他们",
            "she/her": "她",
            "he/him": "他",
            "You have blocked this user": "您已拉黑此用户",
            "Follow": "关注",
            "Sponsor": "赞助",
            "follower": "关注者",
            "followers": "关注者",
            "following": "关注",
            "Followed by": "共同关注者：",
            "Joined": "加入于",
            "Achievements": "成就",
            "Highlights": "高光时刻",
                "Label: Pro": "标签：专业版",
            "Developer Program Member": "开发者计划成员",
            "security advisory credits": "个安全咨询分",
            "security advisory credit": "个安全咨询分",
            "Organizations": "组织",
            "Block or Report": "拉黑或举报",
            "Unblock or report user": "取消拉黑或举报",
            "- same time": "- 时间相同",

            // 编辑个人资料
                "Edit profile": "编辑个人资料",
                "Name": "名称",
                "Display": "显示",
                    "badge.": "徽章。",
                "Bio": "个人简介",
                "Add a bio": "添加个人简介",
                    "You can": "您可",
                    "@mention": "@用户名或组织名",
                    "other users and organizations to link to them.": "链接到其他用户和组织。",
                "Pronouns": "代词",
                    "Don't specify": "不说明",
                    "they/them": "他们",
                    "she/her": "她",
                    "he/him": "他",
                    "Custom": "自定义",
                "Company": "公司",
                "Location": "位置",
                "Display current local time": "显示当前当地时间",
                "same time": "相同时间",
                "Website": "网站",
                "Social accounts": "社交账户",
                "Link to social profile": "链接到社交账户",
                "Link to social profile 1": "链接到社交账户",
                "Link to social profile 2": "链接到社交账户",
                "Link to social profile 3": "链接到社交账户",
                "Link to social profile 4": "链接到社交账户",

            // 成就浮动界面
                // 北极代码库贡献者
                    "Arctic Code Vault Contributor": "北极代码库贡献者",
                        "History": "历史",
                        "100% unlocked": "100% 解锁",
                        "· Unlocked": "· 解锁于",
                        "these repositories, and more, were archived": "这些仓库以及更多仓库已存档",
                // YOLO
                    "You want it? You merge it.": "您想要它？您合并它。",
                    "inaccessible": "已删库",
                    "Merged without a review": "未经审查就合并",
                // Pull Shark
                    "Pull Shark": "鲨鱼拉",
                    "Bronze unlocked": "青铜已解锁",
                    "Bronze and Silver unlocked": "青铜和白银已解锁",
                    "· First unlocked": "· 首次解锁于",
                    "2nd pull request merged": "2 个拉取请求被合并",
                    "16th pull request merged": "16 个拉取请求被合并",
                    "128th pull request merged": "128 个拉取请求被合并",
                    "1024th pull request merged": "1024 个拉取请求被合并",
                // Starstruck
                    "Starstruck": "追星族",
                    "⭐️ 16 stars": "⭐️ 16 个星标",
                    "⭐️ 128 stars": "⭐️ 128 个星标",
                    "⭐️ 512 stars": "⭐️ 512 个星标",
                    "⭐️ 4096 stars": "⭐️ 4096 个星标",
                // Pair Extraordinaire
                    "Pair Extraordinaire": "非凡搭档",
                    "Unlocked": "解锁于",
                    "Coauthored with": "与下列用户共同合作",
                    "Coauthored with an unknown user": "与未知用户共同合作",
                // Quickdraw
                    "Quickdraw": "快速关闭",
                    "Gitty up!": "赶快开始！",
                    "Closed within 5 minutes of opening": "在打开的 5 分钟内关闭",
                // Galaxy Brain
                    "Galaxy Brain": "银河大脑",
                    "2nd accepted answer": "2 个答案被接受",
                    "8th accepted answer": "8 个答案被接受",
                    "16th accepted answer": "16 个答案被接受",
                    "32nd accepted answer": "32 个答案被接受",
                // Public Sponsor
                    "Public Sponsor": "公共赞助者",
                    "1st sponsorship": "1 次赞助",
                // Mars 2020 Contributor
                    "Mars 2020 Contributor": "火星 2020 贡献者",
                    "Mars 2020 Helicopter Mission": "2020 火星无人直升机首飞计划",
                    "this repository was included": "该仓库已收录",

                // ?tab=achievements
                    "Hide from profile": "从个人资料中隐藏",
                    "Hidden from your profile.": "已从您的个人资料中隐藏",
                    "Show on profile": "在个人资料中显示",
                    "Copy share link": "复制共享链接",
                    "Preview on Twitter": "在 Twitter 上预览",

                    // 顶部提醒
                        // [/The (.+) achievement will now be hidden from your profile./, "现在，将从您的个人资料中隐藏 “$1” 成就。"],
                        // [/The (.+) achievement will now be shown in your profile./, "现在，将在您的个人资料中显示 “$1” 成就。"],

                "Send feedback": "发送反馈",

            // 拉黑 & 举报用户对话框
                // [/Block or report ([^ ]+)/, "拉黑或举报 $1"],
                "Block user": "拉黑用户",
                "Prevent this user from interacting with your repositories and sending you notifications. Learn more about": "防止该用户与您的仓库互动并向您发送通知。了解更多关于",
                "blocking users": "拉黑用户",

                "Add an optional note:": "添加可选备注：",
                    "Please don't include any personal information such as legal names or email addresses. Maximum 100 characters, markdown supported. This note will be visible to only you.": "请勿包含任何个人信息，如法定姓名或电子邮件地址。最多 100 个字符，支持标记符。此备注只有您本人可见。",

                "Unblock user": "取消拉黑",
                "Allow this user to interact with your repositories and send you notifications. Learn more about": "允许该用户与您的仓库互动并向您发送通知。了解更多关于",

                "Report abuse": "举报滥用",
                    "Contact GitHub support about this user’s behavior. Learn more about": "就该用户的行为联系 GitHub 支持部门。了解更多关于",
                    "reporting abuse": "举报滥用",

        // 仓库
            "Forked from": "复刻自",
            "Updated": "更新于",

            // 许可证
                "GNU General Public License v3.0": "GNU 通用公共许可证 v3.0",
                "GPL-3.0 License": "GPL-3.0 许可证",
                "AGPL-3.0 License": "AGPL-3.0 许可证",
                "LGPL-3.0 License": "LGPL-3.0 许可证",
                "MIT License": "MIT 许可证",
                "Apache License 2.0": "Apache-2.0 许可证",
                "OFL-1.1 License": "OFL-1.1 许可证",
                "0BSD License": "0BSD 许可证",
                "BSD-3-Clause License": "BSD-3-Clause 许可证",
                "BSD 3-Clause \"New\" or \"Revised\" License": "BSD-3-Clause 许可证",
                "CC0-1.0 License": "CC0-1.0 许可证",
                "WTFPL License": "WTFPL 许可证",
                "Other": "其他",
                "Unknown": "未知",

        // 标签栏
            "Sponsoring": "赞助",
    },
    "regexp": [ // 正则翻译
        [/(\d+) discussions? answered/, "$1 个讨论已回答"], // 高光时刻
        [/Block or report ([^ ]+)/, "拉黑或举报 $1"],
        [/contributed code to several repositories in the/, "为多个仓库贡献了代码，在"],
        [/(\d+) GitHub Archive Program/, "$1 GitHub 存档计划"], // 成就浮动款
        [/opened pull requests that have been merged./, "打开的拉取请求已被合并。"], // Pull Shark
        [/created a repository that has many stars./, "创建了一个拥有很多星标的仓库。"], // Starstruck
        [/coauthored commits on merged pull requests./, "与他人共同提交了合并的拉取请求。"], // Pair Extraordinaire
        [/answered discussions./, "回答了讨论。"], // Galaxy Brain
        [/(\@[^ ]+) (?:is sponsoring|has sponsored) (\d+) organizations? or users?./, "$1 赞助了 $2 个组织或用户。"], // Public Sponsor
        [/contributed code to (\d+) repositor(y|ies) used in the/, "贡献于 $1 个仓库收录于"], // Mars 2020 Helicopter Mission.
        [/The (.+) achievement will now be hidden from your profile./, "现在，将从您的个人资料中隐藏 “$1” 成就。"],
        [/The (.+) achievement will now be shown in your profile./, "现在，将在您的个人资料中显示 “$1” 成就。"],
        [/^(\d+) repositor(y|ies)/, "$1 仓库"],
        [/(\d+) members?/, "$1 成员"],
        [/and (\d+) more/, "等 $1 人"],
        [/- (\d+)h (ahead|behind)/, function(all, num, compare){
            var compareKey = {ahead: '早', behind: '晚'};

            return '- ' + compareKey[compare] + num + '小时';
        }],
    ],
    "title": {
        "static": {
            "Your Followers": "我的关注者",
            "Who You’re Following": "我关注的人",
        },
        "regexp": [
            [/Achievements/, "成就"],
            [/Followers/, "关注者"],
            [/Following/, "关注"],
        ],
    },
};
I18N["zh-CN"]["page-profile/achievements"] = I18N["zh-CN"]["page-profile-public"]; // ?tab=achievements
I18N["zh-CN"]["page-profile/followers"] = I18N["zh-CN"]["page-profile-public"]; // ?tab=followers
I18N["zh-CN"]["page-profile/following"] = I18N["zh-CN"]["page-profile-public"]; // ?tab=following

I18N["zh-CN"]["page-profile"] = { // 个人首页
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 概述标签卡 即主页 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Customize your pins": "自定义置顶",
            // 设置置顶项目对话框
            "Edit pinned items": "设置置顶项目",
            "Select up to six public repositories or gists you'd like to show to anyone.": "最多选择 6 个您想向任何人展示的公共仓库或代码片段。",
            "Select up to six public repositories you'd like to show.": "最多选择 6 个要显示的公共仓库。", // 组织页
            "Filter repositories and gists": "筛选仓库和代码片段",
            "Repositories": "仓库",
            "Gists": "代码片段",
            "Filter repositories": "筛选仓库", // 组织页
            "Show:": "显示：",
            "Save pins": "保存置顶",

            "Drag to reorder": "拖动重新排序",

            // 顶部提醒
            "You unlocked new Achievements with private contributions! Show them off by including private contributions in your Profile in": "您通过私人贡献解锁了新成就！通过在您的个人资料中包含私人贡献来展示它们。",
            "You unlocked new Achievements! Show them off by including achievements and private contributions in your Profile in": "您通过私人贡献解锁了新成就！通过在您的个人资料中包含私人贡献来展示它们。",
            "Your pins have been updated. Drag and drop to reorder them.": "您的置顶已更新。拖放来重新排列它们。",
            "Your popular repositories will now be shown instead of your pins.": "现在将显示您的热门仓库，而不是您的置顶。",

            "Only you can see your full profile.": "只有您可以查看完整的个人资料。",
                "You have marked your profile as private, which limits what activity other people can see.": "您已将个人资料设为私密，这会限制其他人查看您的活动。",
                "Update profile settings": "更新个人资料设置",
            "View what others see": "以他人视角查看",
            "View full profile": "查看完整个人资料",

            "Your pins have been updated.": "您的置顶已更新。",
            // 拖拽排序提醒
            "Order updated.": "置顶已更新。",

            "Pinned": "已置顶",
            "Top repositories": "置顶的仓库",
            "Popular repositories": "热门仓库",

            "Learn how we count contributions": "了解我们如何计算贡献",
            "Contribution settings": "贡献设置",

            // 复刻仓库特有
            "Forked from": "复刻自",
            // 贡献设置下拉菜单
            "Private contributions": "私人贡献",
            "Turning on private contributions will show anonymized private activity on your profile.": "开启私人贡献则将在您的个人资料上显示匿名的私人活动。",
            "Visitors will now see your public and anonymized private contributions.": "访客现在将看到您的公开和匿名的私人贡献。",
            "Turning off private contributions will show only public activity on your profile.": "关闭私人贡献则将仅在您的个人资料中显示公开活动。",
            "Visitors will now see only your public contributions.": "访客现在将只能看到您的公开贡献。",
            "Activity overview": "活动概况",
            "Turning off the activity overview will hide the section on your profile.": "关闭活动概况则将隐藏您的个人资料中的部分内容。",
            "The 'Activity overview' section will no longer appear on your profile.": "“活动概况” 部分将不再出现在您的个人资料中。",
            "Turning on the activity overview will show an overview of your activity across organizations and repositories.": "开启活动概况将显示跨组织和仓库的活动概况。",
            "Others will now see 'Activity overview' when they view your profile.": "其他人在查看您的资料时，现在会看到 “活动概况”。",

            "Contribution activity": "贡献活动",
                "Year:": "年份：", // 小屏模式

            "Search by name": "搜索组织名",
            "Contributed to": "贡献给了",
            "Activity in": "活动在",
            "No activity overview available.": "没有可用的活动概况。",

            "open": "打开",
            "closed": "已关闭",
            "merged": "已合并",
            "pull request": "拉取请求",

            "commits": "次提交",
            "comments": "次评论",
            "Commits": "提交",
            "Code review": "代码审查",
            "Built by": "构建者",

            "Created their first repository": "创建了他们的第一个仓库",
            "Created an issue in": "创建一个议题在",
            "a private repository": "私有仓库",
            "Created a pull request in": "创建一个拉取请求在",
                "lines changed": "行更改",
            "First repository": "第一个仓库",
            "First pull request": "第一次拉取请求",
            "First issue": "第一次议题",
            "Opened their first issue on GitHub in": "打开了他们第一个议题",
            "Opened their first pull request on GitHub in": "打开了他们第一个拉取请求",
            "Opened their first pull request on GitHub in a private repository": "在私有仓库中打开了他们第一个拉取请求",
            "Joined GitHub": "刚加入 GitHub",
            "Joined the": "加入",
            "organization": "组织",
            "Show more activity": "加载更多动态",

            "Seeing something unexpected? Take a look at the": "看到了一些意想不到的东西？请看一下",
            "GitHub profile guide": "GitHub 个人资料指南",

    },
    "regexp": [ // 正则翻译
        [/(\d+) discussions? answered/, "$1 个讨论已回答"], // 高光时刻
        [/Block or report ([^ ]+)/, "拉黑或举报 $1"],
        [/(\d+) GitHub Archive Program/, "$1 GitHub 存档计划"], // 成就浮动款
        [/(\d+) remaining/, "$1 剩余"], // 置顶项目 剩余
        [/([^ ]+) doesn('|’)t have any public repositories yet./, "$1 尚无任何公共仓库。"],
        [/([\d,]+) contributions? in the last year in ([^ ]+)/, "在过去的一年中向 $2 贡献 $1 次"],
        [/([\d,]+) contributions? in the last year/, "在过去的一年中贡献 $1 次"],
        [/([\d,]+) contributions? in (\d+) in ([^ ]+)/, "在 $2 年中向 $3, 贡献 $1 次"],
        [/([\d,]+) contributions? in (\d+)/, "在 $2 年中贡献 $1 次"],
        [/(\d+) contributions? in private repositor(y|ies)/, "私有仓库 $1 个贡献"],
        [/Only people who can see (.+) can see this contribution/, "只有能看到 $1 的人才能看到此贡献"],
        [/(\d+|No) contribution(?:s)? on (.+)(?:st|nd|rd|th)./, (match, number, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            //return optKey[opt] + `${translatedDate}`;
            return number === 'No' ? `${translatedDate}，无贡献` : `${translatedDate}，` + number + ` 次贡献`;
        }],// 贡献日历
        //[/A graph representing ([^ ]+)'s contributions from ( .+) to ( .+)./, "$1 从 $2 到 $3 的贡献图。"],
        [/and (\d+) other repositor(y|ies)/, "和 $1 个其他仓库"], // 活动概览
        // 贡献信息
        [/Created ([\d,]+) commits? in (\d+) repositor(y|ies)/, "在 $2 个仓库中创建了 $1 次提交"],
        [/Created (\d+) (other)? repositor(y|ies)/, "创建了 $1 个仓库"],
        [/Opened (\d+) pull requests? in (\d+) repositor(y|ies)/, "在 $2 个仓库中打开了 $1 个拉取请求"],
        [/Opened (\d+) other pull requests? in (\d+) repositor(y|ies)/, "在 $2 个其他仓库中打开了 $1 个拉取请求"],
        [/Opened (\d+) issues? in (\d+) repositor(y|ies)/, "在 $2 个仓库中打开了 $1 个议题"],
        [/Opened (\d+) other issues? in (\d+) repositor(y|ies)/, "在 $2 个其他仓库中打开了 $1 个其他议题"],
        [/Reviewed (\d+) pull requests? in (\d+) repositor(y|ies)/, "在 $2 个仓库中审查了 $1 个拉取请求"],
        [/Answered (\d+) discussions? in (\d+) repositor(y|ies)/, "在 $2 个仓库中答复了 $1 个讨论"],
        [/Started (\d+) discussions? in (\d+) repositor(y|ies)/, "在 $2 个仓库中发起了 $1 个讨论"],
        [/(\d+) commits?/, "$1 次提交"],
        [/(\d+) pull requests?/, "$1 次拉取请求"],
        [/that received (\d+) comments?/  , "收到 $1 条评论"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 个任务"],
        [/(\d+) comments?/, "$1 条评论"],
        [/(\d+) tasks? done/, "$1 个任务完成"],
        [/([^ ]+) doesn't have any projects yet./, "$1 目前还没有任何项目。"],
        [/([^ ]+) has no activity yet for this period./, "$1 目前还没有活动。"],
        [/([^ ]+) had no activity during this period./, "$1 在此期间没有活动。"],
        [/Contribution activity in ([^ ]+)/, "在 $1 中的贡献活动"],
        [/([^ ]+) had no activity in ([^ ]+) during this period./, "在此期间，$1 在 $2 中没有活动。"],
        [/([^ ]+) has no activity in ([^ ]+) yet for this period./, "在此期间，$1 在 $2 中没有活动。"],
        [/@([^ ]+)'s activity is private/, "$1 的活动不可见"],
        [/Created (\d+\+?) repositor(y|ies)/, "创建了 $1 个仓库"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
        [/(\d+) tasks?/, "$1 任务"], // 带任务议题
        [/and (\d+) more/, "等 $1 人"],
        [/- (\d+)h (ahead|behind)/, function(all, num, compare){
            var compareKey = {ahead: '早', behind: '晚'};

            return '- ' + compareKey[compare] + num + '小时';
        }],
        [/(?:on )?(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        //[/A graph representing ([^ ]+)'s contributions from (.+) to (.+). The contributions are (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review)./, function(all, user, date1, date2, cd1, c1, cd2, c2, cd3, c3, cd4, c4){
        //    var c1Key, c2Key ,c3Key, c4Key = {
        //        'commits': '提交',
        //        'pull requests': '拉取请求',
        //        'code review': '代码审查',
        //        'issues': '议题',
        //    };
        //    return user + '从' + date1 + '到' + date2 + '的贡献图。其中' + cd1 + c1Key[c1] + '，' + cd2 + c2Key[c2] + '，' +cd3 + c3Key[c3] + '，' + cd4 + c4Key[c4]+ '。';
        //}],
        // 成就
        [/answered discussions./, "回答了讨论。"], // Galaxy Brain
        [/opened pull requests that have been merged./, "打开的拉取请求已被合并。"], // Pull Shark
        [/created a repository that has many stars./, "创建了一个拥有很多星标的仓库。"], // Starstruck
        [/coauthored commits on merged pull requests./, "与他人共同提交了合并的拉取请求。"], // Pair Extraordinaire
        [/(\@[^ ]+) contributed code to several repositories in the/, "$1 为多个仓库贡献了代码，在"], // 北极代码库贡献者
    ],
};
I18N["zh-CN"]["page-profile/overview"] = I18N["zh-CN"]["page-profile"];

I18N["zh-CN"]["page-profile/repositories"] = { // 个人首页 - 仓库标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 仓库标签卡 ?tab=repositories >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

            // 顶部提醒
                // [/Your repository \"([^ ]+)\" was successfully deleted./, "您的仓库 “$1” 已成功删除。"],

            // "Search repositories…": "搜索这些查库…",
            // "Search starred repositories…": "搜索星标仓库…",

            // 搜索, 筛选 & 排序工具栏
            "Find a repository…": "搜索仓库…",
            // "Type": "类型", // 与全局冲突 使用 Selector 规则翻译
                // 下拉菜单
                "Select type": "选择类型",
                "All": "全部",
                "Public": "公共",
                "Private": "私有",
                "Sources": "源码",
                "Forks": "复刻",
                "Archived": "存档",
                "Can be sponsored": "可赞助",
                "Mirrors": "镜像",
                "Templates": "模板",
            "Language": "语言",
                // 下拉菜单
                "Select language": "选择语言",
                "All languages": "所有语言",
            "Sort": "排序",
                // 下拉菜单
                "Select order": "选择排序",
                "Last updated": "最近更新",
                // "Name": "仓库名",
                // "Recently starred": "最近星标",
                // "Recently active": "最近活跃",
                // "Most stars": "最多星标",
                // "Unstar": "取消星标",
            "New": "新建",

            // 筛选结果
            "result for": "个结果在",
            "results for": "个结果在",
                "public": "公共",
                "private": "私有",
                "source": "源码",
                "forked": "复刻",
                "archived": "存档",
                "sponsorable": "可赞助",
                "mirror": "镜像",
                "template": "模板",
            "repositories matching": "仓库中匹配了",
            "result for repositories matching": "个结果在仓库中匹配了",
            "results for repositories matching": "个结果在仓库中匹配了",
            "repositories sorted by": "仓库，排序按",
            "written in": "，使用语言",
            "results for repositories written in": "个结果在仓库中使用语言",
            "star matching": "个星标匹配", //?tab=stars
            "stars matching": "个星标匹配", //?tab=stars
            "star written in": "个星标使用语言", //?tab=stars
            "stars written in": "个星标使用语言", //?tab=stars
            "sorted by": "，排序按",
                "last updated": "最近更新",
                "name": "仓库名",
                "stars": "星标",

            "Clear filter": "清除筛选",

            // [/([^ ]+) doesn’t have any repositories that match./, "$1 没有任何匹配的仓库"],
            "This organization doesn’t have any repositories that match.": "该组织没有任何匹配的仓库。", // 组织仓库

            "This organization has no public repositories.": "该组织没有公共仓库。", //组织仓库

            "No repositories matched your search.": "没有与您的搜索匹配的仓库。", // 无匹配仓库

            // 项目 状态词
            "Updated": "更新于",
            "Forked from": "复刻自",

            // 曲线图提示
            "Past year of activity": "过去一年的活动",

        // 新版 组织 - 仓库概述 https://github.com/orgs/<orgs-name>/repositories
            "Filter": "筛选",
                "Advanced filters": "高级筛选器",
                    "Build complex filter queries": "构建复杂的筛选查询",
                        "To start building your query add your first filter using the button below.": "要开始创建查询，请使用下面的按钮添加第一个筛选器。",
                    "Add a filter": "新增筛选器",
                    "Apply": "应用",
                    "Qualifier": "限定词",
                        "Created": "已创建",
                        "Total forks": "复刻总数",
                        "Total good-first issues": "好的首发议题总数",
                        "Has": "包含文件",
                        "Total help-wanted issues": "求助议题总数",
                        "License": "许可证",
                        "Mirror": "镜像",
                        "Size (Kb)": "大小 (Kb)",
                        "Sponsorable": "可接受赞助",
                        "Text": "文本",
                        "Total topics": "主题总数",
                        "Total stars": "星标总数",
                        "Template": "模板",
                        "Topic": "话题",
                        "Visibility": "可见性",
                    "Operator": "操作符",
                        "is": "是",
                        "is not": "不是",
                        "before": "之前",
                        "after": "之后",
                        "between": "之间",
                            "From": "起",
                            "To": "至",
                        "is one of": "包括",
                        "is not one of": "不包含",
                        "greater than": "大于",
                        "less than": "小于",
                        "greater than or equal to": "大于或等于",
                        "less than or equal to": "小于或等于",
                        "equal to": "等于",
                    "Value": "值",
                        "Enter a number": "输入数字",
                        "Enter search text": "输入搜索文本",
                        "Make a selection": "进行选择",
                            "Select items": "选择项目",
                            "Select an item": "选择项目",
                                "Filter values": "筛选值",
                                    // 复刻
                                        "Only forks": "仅复刻",
                                        "Exclude forks": "排除复刻",
                                    // 排序
                                        "Recently pushed": "最近推送",
                                        "Topics": "话题",
                                        "Size": "尺寸",
                                        "Recently pushed (descending)": "最近推送（降序）",
                                        "Name (descending)": "名称（降序）",
                                        "Language (descending)": "语言（降序）",
                                        "License (descending)": "许可证（降序）",
                                        "Topics (ascending)": "主题（升序）",
                                        "Size (ascending)": "大小（降序）",
                                        "Total stars (ascending)": "星标总数（降序）",
                                        "Total forks (ascending)": "复刻总数（降序）",
                                        "Help-wanted issues (ascending)": "求助议题总数（升序）",
                                        "Help-wanted issues (descending)": "求助议题总数（降序）",
                                    // 可见性
                                        "Internal": "内部",
                "Discard changes?": "放弃更改？",
                    "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您确定要放弃它们吗？",
                    "Keep editing": "继续编辑",
                    "Close and discard": "关闭并放弃",
            "Search repositories": "搜索仓库",
                "No repositories matched your search": "没有与您的查询相匹配的仓库",
                    "Try a different search query": "尝试不同的搜索查询",

            "Last pushed": "最近提送",
                "Ascending": "升序",
                "Descending": "降序",
            "repository": "仓库",
            "No language": "无语言",

            "Compact display density": "紧凑显示密度",
            "Comfortable display density": "舒适显示密度",
    },
    "regexp": [ // 正则翻译
        [/(\d+(k|M|B)?) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
        [/([^ ]+) doesn’t have any repositories that match./, "$1 没有任何匹配的仓库"], // 仓库标签卡
        [/([^ ]+) doesn’t have any public repositories yet./, "$1 没有任何公共仓库。"],
        [/Your repository \"([^ ]+)\" was successfully deleted./, "您的仓库 “$1” 已成功删除。"],
        [/(\d+) issues? needs? help/, "$1 个议题需要帮助"],
        [/and (\d+) more/, "等 $1 人"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "selector": [ // 元素筛选器规则
        ["#type-options > summary > span:nth-child(1)", "类型"], // 个人主页 --> 仓库标签页-->类型筛选器 Type
    ],
    "title": {
        "static": {
            "Your Repositories": "我的仓库",
        },
        "regexp": [
            [/(R|r)epositories/, "仓库"],
        ],
    },
};

I18N["zh-CN"]["page-profile/projects"] = { // 个人首页- 项目标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 项目标签卡 ?tab=projects >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "There aren't any projects yet": "尚无任何项目",
            "Provide quick access to relevant projects.": "提供快速访问相关项目的途径。",
            "Add projects to view them here.": "将项目添加到此处查看。",

            "Welcome to projects": "欢迎访问项目页面",
            "Built like a spreadsheet, project tables give you a live canvas to filter, sort, and group issues and pull requests. Tailor them to your needs with custom fields and saved views.": "构建像电子表格一样的项目表，给您一个实时的画布来对议题和拉取请求进行筛选、排序和分组。通过自定义字段和保存的视图，使它们符合您的需要。",

            "Learn more about projects": "了解更多关于项目的信息", // ?tab=projects

            "Create your first GitHub project": "创建您的第一个 GitHub 项目",
            "Projects are a customizable, flexible tool for planning and tracking your work.": "项目是一个可定制的、灵活的工具，用于规划和跟踪您的工作。",

            "Sort": "排序",
                // 排序下拉菜单
                "Newest": "最新",
                "Oldest": "最早",
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新",
            // 清除筛选
            "Clear current search query and sorts": "清除当前的搜索查询和分类",

            "No open projects": "无已打开的项目",

            "Plan and track work across repositories with custom fields and multiple views": "通过自定义字段和多个视图来计划和跟踪整个仓库的工作",
            "Kanban-style project board": "看板式项目面板",

            "You don't have any projects yet.": "您还没有任何项目。",
            "There are no projects matching your search.": "没有符合您搜索条件的项目。",
            "Learn More": "了解更多",

            "No description": "无描述",

            // 顶部提醒
            "Project closed.": "项目已关闭。",
            "Project reopened.": "项目已重新打开。",

            // 组织
            "Created by me": "由我创建",
            "Create your first GitHub project template": "创建您的第一个 GitHub 项目模板",
            "Templates can be used to quickly get started with a new project.": "模板可以用于快速新建项目。",
            "New template": "新建模版",

        // https://github.com/users/<user-name>/projects/<id>
            "New view": "新建视图",
            "Layout": "布局",
            "Board": "面板",
            "Roadmap": "时间线",
            "Duplicate view": "复制视图",
            "Configuration": "配置",
            "Group by": "分组",
            "No grouping": "不进行分组",
            "Markers": "标记",
            "Sort by": "排序",
            "No sorting": "不进行排序",
            "Zoom level": "缩放级别",
            "Field sum": "字段总和",
            "Slice by": "切片",
            "No slicing": "不进行切片",
            "Fields": "字段",
            "Generate chart": "生成图表",
            "Rename view": "重命名视图",
            "Delete view": "删除视图",
            "Export view data": "导出视图数据",
            "Assignees": "负责人",
            "Project templates": "项目模板",
            "Featured": "特色",
            "Iteration": "迭代",
            "Dates": "日期",
            "User settings": "用户设置",
            "Truncate titles": "截断标题",
            "Show date fields": "显示日期字段",
            "Add status update": "添加状态更新",
            "Project details": "项目详情",
            "View more options": "查看更多选项",
            "Date fields": "日期字段",
            "Month": "月",
            "Quarter": "季度",
            "Year": "年",
            "Today": "今天",
            "Add item": "添加项目",
            "Start typing to create a draft, or type # to select a repository": "开始输入以创建草案，或输入 # 选择一个仓库",
            "Scroll to previous date range": "滚动到上一个日期范围",
            "Scroll to next date range": "滚动到下一个日期范围",
            "Filter by keyword or by field": "按关键字或字段筛选",
            "Discard": "放弃",
            "Save changes to new view": "保存更改到新视图",
            "Visible fields": "可见字段",
            "Hidden fields": "隐藏字段",
            "New field": "新建字段",
            "Column by": "栏目",
            "Workflows": "工作流",
            "Archived items": "已存档项目",
            "Make a copy": "复制",
            "GitHub Projects": "GitHub 项目",
            "What’s new": "新功能",
            "Project settings": "项目设置",
            "Project name": "项目名称",
            "Short description": "简短描述",
            "More options": "更多选项",
            "Make a copy of this project.": "复制此项目",
            "Danger zone": "危险区",
            "This project is currently private.": "此项目当前为私有.",
            "Closing a project will disable its workflows & remove it from the list of open projects.": "关闭项目将禁用其工作流程，并将其从打开项目列表中删除.",
            "Close this project": "关闭此项目",
            "Manage access": "管理访问权限",
            "Who has access": "谁有访问权限",
            "Private project": "私有项目",
            "Only those with access to this project can view it.": "只有有权访问此项目的人才能查看它.",
            "Invite collaborators": "邀请协作者",
            "Manage access": "管理访问权限",
            "Custom fields": "自定义字段",
            "Field name": "字段名称",
            "Field type": "字段类型",
            "Text": "文本",
            "Number": "数字",
            "Date": "日期",
            "Single select": "单选",
            "Starts on": "开始于",
            "Duration": "持续时间",
            "days": "天",
            "weeks": "周",
            "Save and create": "保存并创建",
            "You don't have any collaborators yet.": "您还没有任何协作者.",
            "Add a collaborator to see them here.": "添加协作者以在此处查看他们.",
            "Make template": "制作模板",
            "Copy as template": "复制为模板",
            "Visibility": "可见性",
            "Close project": "关闭项目",
            "Delete project": "删除项目",
            "Delete this project": "删除此项目",
            "Status chart": "状态图表",
            "This chart shows the current status for the total number of items in your project.": "此图表显示了项目中所有项目的当前状态.",
            "Default charts": "默认图表",
            "Custom charts": "自定义图表",
            "Configure": "配置",
            "Configure chart": "配置图表",
            "Group by (optional)": "分组 (可选)",
            "X-axis": "X 轴",
            "Y-axis": "Y 轴",
            "Save to new chart": "保存到新图表",
            "Add a project status update": "添加项目状态更新",
            "Add update": "添加更新",
            "Status updates are brief reports tracking your project's health and progress. Begin by adding an update.": "状态更新是跟踪项目健康和进度的简要报告. 从添加更新开始.",
            "Let everyone know what this project is about, how to use it and link to important resources.": "让每个人都知道这个项目是关于什么的，如何使用它，并链接到重要资源.",
            "A short description about this project.": "关于此项目的简短描述.",
    },
    "regexp": [ // 正则翻译
        [/View (\d+)/, "视图 $1"],
        [/([\d,]+) Open/, "$1 打开"], // 项目标签卡
        [/([\d,]+) Closed/, "$1 已关闭"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Your Projects": "我的项目",
        },
        "regexp": [
            [/Projects/, "项目"],
        ],
    },
};

I18N["zh-CN"]["page-profile/sponsoring"] = { // 个人首页- 赞助标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],
            "has sponsored": "曾赞助",
            "organization or maintainer in the past": "个组织或维护者",
            "organization or maintainer": "个组织或维护者",
            "Bulk Sponsor": "批量赞助",
            "Sponsor multiple maintainers in one easy transaction.": "一次交易即可赞助多个维护者。",
            "Get started": "前去赞助",
            "Past sponsorship": "曾经赞助",
            "Sponsored": "赞助于",
            "organizations and maintainers and has sponsored": "个组织和维护者，过去曾赞助过",
                "in the past": "个",
    },
    "regexp": [ // 正则翻译
        [/is sponsoring/, "正在赞助"],
        [/Sponsoring since (.+)/, (match ,p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `赞助自 ${translatedDate}`;
        }],
        [/Sponsored/, "赞助于"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
    ],
    "title": {
        "regexp": [
            [/Sponsoring/, "赞助"],
        ],
    },
};

I18N["zh-CN"]["page-profile/packages"] = { // 个人首页 - 软件包标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 软件包标签卡 ?tab=packages >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Get started with GitHub Packages": "开始使用 GitHub 软件包",
            "Safely publish packages, store your packages alongside your code, and share your packages privately with your team.": "安全地发布包，将您的包与您的代码一起存储，并与您的团队私下共享您的包。",
            "Choose a registry": "选择注册表",
            "A software platform used for building applications based on containers — small and lightweight execution environments.": "用于构建基于容器的应用的软件平台——小型轻量级执行环境。",
            "A default package manager used for the Java programming language and the Java runtime environment.": "用于 Java 编程语言和 Java 运行环境的一个默认包管理器。",
            "A free and open source package manager used for the Microsoft development platforms including .NET.": "一个自由和开源的开源包管理器，用于包括 .NET 在内的 Microsoft 开发平台。",
            "A standard format for distributing Ruby programs and libraries used for the Ruby programming language.": "分发用于 Ruby 编程语言的 Ruby 程序和库的标准格式。",
            "A package manager for JavaScript, included with Node.js. npm makes it easy for developers to share and reuse code.": "npm 是一个 JavaScript 的包管理器，包含在 Node.js 中。它使开发人员能够轻松地分享和重用代码。",
            "Containers": "容器",
            "A single place for your team to manage Docker images and decide who can see and access your images.": "为您的团队提供一个管理 Docker 镜像的单一场所，并决定谁可以看到和访问您的镜像。",

            "Type:": "类型:",
                // 下拉菜单
                "Select type": "选择类型",
                "All": "全部",
            "Search packages…": "搜索软件包…",
            "Visibility:": "可见性:",
                "Select visibility": "选择可见性",
                "Internal": "内部",
            "Sort by:": "排序方式:",
                "Select sort view": "选择排序视图",
                "Most downloads": "最多下载",
                "Least downloads": "最少下载",

            "Clear current search query, filters, and sorts": "清除当前的搜索查询、筛选器和排序方式",
            // 筛选结果
            "No results matched your search.": "没有与您的搜索匹配的结果。",
            "Try": "尝试",
            "browsing all packages": "浏览所有软件包",
            "to find what you're looking for.": "，以找寻您想要的内容。",

            "Published": "发布于",

    },
    "regexp": [ // 正则翻译
        [/(\d+) packages?/, "$1 软件包"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Your Packages": "我的软件包",
        },
        "regexp": [
            [/Packages/, "软件包"],
        ],
    },
};

I18N["zh-CN"]["page-profile/sponsors"] = { // 个人首页 - 赞助标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 赞助标签卡 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // [/is sponsoring/, "正在赞助"],
            "organization or developer:": "个组织或开发者：",
    },
    "regexp": [ // 正则翻译
        [/is sponsoring/, "正在赞助"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
    ],
};

I18N["zh-CN"]["page-profile/stars"] = { // 个人首页 - 星标标签卡
    "static": { // 静态翻译
        ...I18N["zh-CN"]["page-profile-public"]["static"],

        // 星标标签卡 ?tab=stars >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Show all lists...": "显示所有列表…",

            "Sort by": "排序方式",
            // 排序补充
                "Name ascending (A-Z)": "名称升序 (A-Z)",
                "Name descending (Z-A)": "名称降序 (Z-A)",
                "Newest": "最新",
                "Oldest": "最早",
                "Last updated": "最后更新",

            "Create your first list": "创建您的第一个清单",
            "Lists make it easier to organize and curate repositories that you have starred.": "列表可使您更容易组织和策划您的星标仓库。",
            "Create your first list.": "创建您的第一个清单。",

            // 搜索, 筛选 & 排序工具栏
            "Search stars": "搜索星标",
            "Type: All"    : "类型：全部",
            "Type: Public" : "类型：公共",
            "Type: Private": "类型：私有",
            "Type: Sources": "类型：源码",
            "Type: Forks"  : "类型：复刻",
            "Type: Mirrors": "类型：镜像",
            "Type: Templates": "类型：模板",
                "All"    : "全部",
                "Public" : "公共",
                "Private": "私有",
                "Sources": "源码",
                "Forks"  : "复刻",
                "Can be sponsored": "可赞助",
                "Mirrors": "镜像",
                "Templates": "模板",
            "Language": "语言",
                // 下拉菜单
                "Select language": "选择语言",
                "All languages": "所有语言",
            "Sort": "排序",
                // 下拉菜单
            "Sort by: Recently starred": "排序：最近星标",
            "Sort by: Recently active": "排序：最近活跃",
            "Sort by: Most stars": "排序：最多星标",
                "Recently starred": "最近星标",
                "Recently active": "最近活跃",
                "Most stars": "最多星标",
                "Languages": "语言",

            // 筛选结果
            "result for": "个结果在",
            "results for": "个结果在",
                "public": "公共",
                "private": "私有",
                "source": "源码",
                "forked": "复刻",
                "sponsorable": "可赞助",
                "archived": "存档",
                "mirror": "镜像",
                "template": "模板",
            "star matching": "个星标匹配", //?tab=stars
            "stars matching": "个星标匹配", //?tab=stars
            "star written in": "个星标使用语言", //?tab=stars
            "stars written in": "个星标使用语言", //?tab=stars
            "starred repositories": "星标仓库",
            "starred repositories written in": "星标仓库使用语言",

            "Clear filter": "清除筛选",

            // 项目 状态词
            "Updated": "更新于",
            "Forked from": "复刻自",

            "That’s it. You’ve reached the end of your stars.": "而已。您已经到了星海的尽头。",

            "Topics": "主题",

            "Add to list": "添加到清单",
            "Lists": "清单",
            "You don't have any lists yet.": "您尚无任何清单。",

            // [/(\d+) repositor(y|ies)/, "$1 个仓库"],

            // 他人库 星标页 补充
            "Search starred repositories": "搜索星标仓库",
            "Starred repositories": "星标仓库",
            "Starred topics": "星标主题",
            "See all starred topics": "查看所有星标主题",

            // [/That’s it. You’ve reached the end of ([^ ]+)’s stars./, "而已。您已经到了$1 星海的尽头。"], // 他人星标页 搜索结果

        // https://github.com/stars/<user-name>/lists/<清单>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Edit list": "编辑清单",
                "Delete list": "删除清单",
                    "Are you sure you want to delete this list?": "您确定要删除此清单吗？",
                        // 顶部提醒
                        // [/Deleted \"(.*)\"./, "已删除 “$1”。], // 删除星标清单
                "Save list": "保存清单",
            "Add repositories to this list": "添加仓库到此清单",
            "Star repositories on GitHub to keep track of your favorite projects and inspirational code.": "GitHub 上的星标仓库可以跟踪您最喜欢的项目和鼓舞人心的代码。",
            "Explore repositories.": "探索仓库。",
    },
    "regexp": [ // 正则翻译
        [/Deleted \"(.*)\"./, "已删除 “$1”。"], // 删除星标清单 顶部提醒
        [/doesn’t have any starred repositories yet./, "尚无任何星标仓库。"],
        [/That’s it. You’ve reached the end of ([^ ]+)’s stars./, "而已。您已经到了$1 星海的尽头。"], // 他人星标页 搜索结果
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members?/, "$1 成员"], // 组织 浮动信息卡
        [/Language: /, "语言："],
    ],
    "title": {
        "static": {
            "Your Stars": "我的星标",
        },
        "regexp": [
            [/Your list/, "我的清单"],
            [/Starred/, "星标"],
            [/'s list/, " 的清单"],
        ],
    },
};

I18N["zh-CN"]["confirm-access"] = { // “授权访问” 对话框
    "static": { // 静态翻译
        // 授权访问 sudo 模式身份验证
            "Confirm access": "授权访问",
            "Signed in as": "登录身份为",
            "Authentication code": "验证码",
                "More information about sudo mode authentication": "更多关于 sudo 模式身份验证的信息",
            "Open your two-factor authenticator (TOTP) app or browser extension to view your authentication code.": "打开您的双因素身份验证器 (TOTP) 应用或浏览器扩展以查看您的身份验证码。",
            "Verify": "验证",
            "Verify": "验证",
            "Verifying…": "验证中…",
            "Your authentication code has been sent.": "您的验证码已发送。",

            "Having problems?": "有问题吗？",
            "Use GitHub Mobile": "使用 GitHub Mobile",
            "Use your passkey": "使用您的通行密钥",
            "Use your authenticator app": "使用您的身份验证器应用",
            "Send a code via email": "通过电子邮件发送验证码",
            "Use your password": "使用您的密码",

            "GitHub Mobile": "GitHub Mobile",
            "Creating a verification request for your GitHub Mobile app.": "为您的 GitHub Mobile 应用创建验证请求。",
            "We sent you a verification request on your GitHub Mobile app. Enter the digits shown below to enter sudo mode.": "我们向您的 GitHub Mobile 应用发送了一个验证请求。输入下面显示的数字以进入 sudo 模式。",
            "We could not verify your identity": "我们无法核实您的身份",
            "Retry": "请重试",

            "Password": "密码",
            "Forgot password?": "忘记密码？",
            "Confirm": "确认",

            "Passkey": "通行密钥",
            "When you are ready, authenticate using the button below.": "准备好后，请使用下面的按钮进行身份验证。",
            "This browser or device does not fully support passkeys.": "此浏览器或设备不完全支持通行密钥。",
            "Use passkey": "使用通行密钥",

            "Authentication failed.": "认证失败。",
            "Retry passkey": "重试通行密钥",

            "Unable to verify with your passkey?": "无法验证您的通行密钥？",
    },
};

I18N["zh-CN"]["payment-module"] = { // 通用账单及支付信息模块
    "static": { // 静态翻译
        "Account": "账户",
            "Personal account": "个人账户",

        "Billing information": "账单信息",
            "You have not added any billing information.": "您尚未添加账单信息。",
               "Add your information to show on every invoice": "在每张发票上添加您的信息",

            // 添加/编辑账单信息
                "First name": "名字",
                    "First name can't be blank.": "名字不能为空。",
                    "First name can't be blank": "名字不能为空",
                "Last name": "姓氏",
                    "Last name can't be blank.": "姓氏不能为空。",
                    "Last name can't be blank": "姓氏不能为空",
                "Address": "地址",
                    "(Street, P.O. box)": "（街道，邮政信箱）",
                    "Address can't be blank.": "地址不能为空。",
                    "Address can't be blank": "地址不能为空",
                "Address line 2": "地址第 2 行",
                    "(Apartment, suite, unit)": "（公寓、套房、单元）",
                "City": "城市",
                    "City can't be blank.": "城市不能为空。",
                    "City can't be blank": "城市不能为空",
                "Country/Region": "国家/地区",
                "State/Province": "州/省",
                    "Required for certain countries": "某些国家/地区需要",
                "Postal/Zip code": "邮政编码",
                    "(9-digit zip code for US)": "（美国为 9 位邮政编码）",
                "VAT/GST ID": "增值税/消费税编号",

                "Save billing information": "保存账单信息",
                "Save and continue": "保存并继续",

            // 顶部提醒
                "You have not added any billing information.": "您尚未添加账单信息。",
                "Successfully updated billing information.": "保存账单信息成功。",
                "An error occurred while saving billing information.": "保存账单信息发生错误。",

            // 组织设置
                "This organization is linked with your billing information:": "该组织与您的账单信息相关联：",

                "An organization owner or billing manager must link their personal billing information with this organization account. You can switch to a business account to use your business’ billing information by": "组织所有者或账单管理者必须将其个人账单信息与该组织账户关联。您可以切换到企业账户，以使用企业的账单信息通过",
                "signing": "签署",
                "the": " ",
                "GitHub Customer Agreement": "GitHub 客户协议",

                "Allow my billing information to be linked with this organization": "允许我的账单信息与该组织关联",

                    "Confirm your details shown below. To make changes,": "确认以下显示的详细信息。要做出更改，",
                    "edit your billing information": "请编辑您的账单信息",

                "Update your billing information": "更新您的账单信息",
                "to be able to link it with this organization.": "以便与该组织关联。",
                    // 顶部提醒
                        "You have successfully linked your billing information with this organization.": "您已成功将您的账单信息与该组织关联。",

                // 移除对话框
                    "Remove": "移除",
                    "Remove your billing information?": "确定移除您的账单信息？",
                        "You are about to remove the billing information for this organization. Are you sure you want to do this?": "您即将移除此组织的账单信息。确定要继续此操作吗？",
                    "Remove billing information": "移除账单信息",
                    // 顶部提醒
                        "Successfully removed billing information.": "已成功移除账单信息。",

            // 其他
                // 来自 https://github.com/marketplace/<app-name>/order/<order-id>?account=<account-name>
                    "Please confirm your billing details to continue. You only need to do this once.": "请确认您的账单详情以继续。您只需确认一次。",

        "payment method": "支付方式",
        "Payment method": "支付方式",
        "Payment Method": "支付方式",
            "You have not added a payment method.": "您尚未添加支付方式。",

        "Payment information": "支付信息",
            "Pay with": "支付方式：",
                "Loading payment information…": "正在加载支付信息…",

                "Credit or debit card": "信用卡或借记卡",
                    "Card Number *": "卡号",
                    "Expiration Date (YYYY) *": "终止日期 (YYYY) *",
                        "- Select One -": "- 选择一个 -",
                    "Save payment information": "保存付款信息",
                    "You are currently paying with your PayPal account": "您目前正在使用您的 PayPal 账户支付",
                    ", but you can switch to using a credit or debit card at any time.": "，但是您随时可以切换到使用信用卡或借记卡支付。",

                "PayPal account": "PayPal 账户",
                "Paypal account": "PayPal 账户",
                    "Sign in to": "登录到",
                    "Connecting to PayPal…": "正在连接到 PayPal…",
                    "Sorry, we’re having trouble with PayPal right now, please try again a bit later.": "抱歉，我们目前与 PayPal 的连接遇到问题，请稍后再试。",
                    "PayPal update": "",
                    "Charge to": "收费至",
                    "Sign in to PayPal to use a different account.": "登录 PayPal 以使用其他账户。",
                    "You are currently paying with a credit card, but you can switch to using PayPal at any time.": "您目前使用信用卡付款，但您可以随时切换为使用 PayPal。",

                // 顶部提醒
                    "An error occurred while saving payment information.": "保存支付信息时发生错误。",
                    "Your PayPal account has been successfully added.": "您的 PayPal 账户已成功添加。",
                    "Your credit card has been successfully updated.": "您的信用卡已成功更新。",

                "504 Gateway Time-out": "504 网关超时",
                "We may place a temporary hold on your payment method to verify its validity. This is not a charge, and it will be released automatically after verification.": "我们可能会暂时冻结您的支付方式以验证其有效性。这不是收费，验证后将会自动解除。",
    },
};

I18N["zh-CN"]["settings-menu"] = { // 设置 - 公共部分
    "static": { // 静态翻译
        "Settings": "设置", // 新版全局导航

        "Your personal account": "我的个人账户",
        "Switch settings context": "切换设置上下文", // 存在组织时
        "Go to your personal profile": "去我的个人资料",
        // 左侧菜单
        "Public profile": "基本资料",
        "Account": "账户",
        "Appearance": "外观",
        "Accessibility": "无障碍",
        "Notifications": "通知",

        "Access": "访问",
            "Billing and licensing": "账单和许可",
                "Usage": "使用情况",
                "Premium request analytics": "高级请求分析",
                "Budgets and alerts": "预算和警报",
                "Licensing": "许可",
                "Payment information": "支付信息",
                "Payment history": "支付历史",
                "Additional billing details": "其他账单",
                "Education benefits": "教育福利",
            "Emails": "电子邮箱",
            "Password and authentication": "密码和身份验证",
            "Sessions": "会话",
            "SSH and GPG keys": "SSH 与 GPG 公钥",
            "Organizations": "组织",
            "Enterprises": "企业版",
            "Moderation": "节制",
                "Blocked users": "黑名单",
                "Interaction limits": "互动限制",
                "Code review limits": "代码审查限制",

        "Code, planning, and automation": "代码、规划和自动化",
            // "Repository": "仓库"
            // 代码空间
            "Models": "模型",
            "Packages": "软件包",
            "Copilot": "GitHub Copilot",
                "Features": "功能",
                "Coding agent": "编程智能体",
            "Pages": "GitHub Pages",
            "Saved replies": "快捷回复",

        // "Security": "安全",
            "Code security": "代码安全性",

        "Integrations": "集成",
            "Applications": "应用",
            "Scheduled reminders": "定时提醒",

        "Archives": "存档",
            "Security log": "安全日志",
            "Sponsorship log": "赞助日志",

        "Developer settings": "开发者设置",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
};

I18N["zh-CN"]["orgs-settings-menu"] = { // 组织设置 公共部分
    "static": { // 静态翻译
        ...I18N["zh-CN"]["orgs-public"]["static"],

        // 公用部分
            "Organization": "组织",
            "Switch settings context": "切换设置上下文", // 存在组织时
            "Go to your organization profile": "去我的组织主页",
        // 左侧菜单
            "General": "常规",
            "Policies": "策略",
            "Access": "访问",
                "Billing and licensing": "账单和许可",
                    "Usage": "使用情况",
                    "Budgets and alerts": "预算和警报",
                    "Licensing": "许可",
                    "Payment information": "支付信息",
                    "Payment history": "支付历史",
                    "Additional billing details": "其他账单",
                "Organization roles": "组织角色",
                    "Role management": "角色管理",
                    "Role assignments": "角色分配",
                "Repository roles": "仓库角色",
                "Member privileges": "成员权限",
                // "Team discussions": "团队讨论",
                "Import/Export": "导入/导出",
                "Moderation": "节制",
                    "Blocked users": "黑名单",
                    "Interaction limits": "互动限制",
                    "Code review limits": "代码审查限制",
                    "Moderators": "版主",

            "Code, planning, and automation": "代码、规划和自动化",
                "Repository": "仓库",
                    "Topics": "主题",
                    "Rulesets": "规则集",
                    "Rule insights": "规则洞察",
                    "Custom properties": "自定义属性",
                "Codespaces": "代码空间",
                "Planning": "计划",
                    "Issue types": "议题类型",
                "Copilot": "GitHub Copilot",
                    "Access": "访问",
                    "Coding agent": "编程智能体",
                "Actions": "操作",
                    "Runners": "运行器",
                    "Runner groups": "运行器组",
                    "Custom images": "自定义镜像",
                    "Caches": "缓存",
                "Models": "模型",
                    "Development": "开发",
                    "Custom models": "自定义模型",
                "Webhooks": "Web 钩子",
                "Packages": "软件包",
                "Projects": "项目",

            "Security": "安全",
                "Authentication security": "身份验证安全",
                "Advanced Security": "高级安全",
                    "Configurations": "配置",
                    "Global settings": "全局设置",
                "Deploy keys": "部署密钥",
                "Compliance": "承诺",
                "Verified and approved domains": "经验证和批准的域名",
                "Secrets and variables": "机密和变量",
                    "Private registries": "私有注册表",

            "Third-party Access": "第三方访问",
                "GitHub Apps": "GitHub 应用",
                "OAuth app policy": "OAuth 应用策略",
                "Personal access tokens": "个人访问令牌",
                    "Active tokens": "活跃的令牌",
                    "Pending requests": "待处理的请求",

            "Integrations": "集成",
                "Scheduled reminders": "定时提醒",

            "Archive": "存档",
                "Logs": "日志",
                    "Sponsorship log": "赞助日志",
                    "Audit log": "审计日志",
                "Deleted repositories": "删除的仓库",

            "Developer settings": "开发者设置",
                "OAuth Apps": "OAuth 应用",
                "Publisher Verification": "发布者验证",
            "Account settings": "账户设置",

            "Developer Settings": "开发者设置"
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
};

I18N["zh-CN"]["settings/profile"] = { // 设置 - 个人资料
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Profile 个人资料 https://github.com/settings/profile
            "Public profile": "基本资料",
            "Profile picture": "我的头像",
                "Edit": "编辑",
                "Upload a photo…": "上传图片…",
                "Remove photo": "删除图片",
                "Are you sure you want to reset your current avatar?": "您确定要重置当前的头像吗？",
                "Your profile picture has been reset. It may take a few minutes to update across the site.": "您的个人头像已重置，整个网站的更新可能需要几分钟的时间。",
                "Your profile picture has been updated. It may take a few minutes to update across the site.": "您的个人头像已更新，整个网站的更新可能需要几分钟的时间。",
                // 裁剪个人头像对话框
                "Crop your new profile picture": "裁剪个人头像",
                "Set new profile picture": "设置新的个人头像",
            //"You can also drag and drop a picture from your computer.": "您也可以直接拖拽照片镜像上传.",
            "Name": "昵称",
            "Your name may appear around GitHub where you contribute or are mentioned. You can remove it at any time.": "您的昵称可能会出现在 GitHub 上，您的贡献或被提及的地方。您可以随时删除它。",
            "Public email": "公开电子邮箱",
            "Remove": "移除",
            "Select a verified email to display": "选择显示一个已验证的电子邮箱",
            "You have set your email address to private. To toggle email privacy, go to": "您已将电子邮箱地址设置为私密。需要切换电子邮箱地址的私密性，请转到",
            "email settings": "邮箱设置",
            "and uncheck \"Keep my email address private.\"": "并取消 “保持我的电子邮箱地址的私密性”。",
            "You can manage verified email addresses in your": "您可以管理已验证的电子邮箱地址在您的",
            //"Don’t show my email address": "不显示我的邮箱",
            //"You can add or remove verified email addresses in your": "您可以添加或删除邮件地址在您的",
            //"personal email settings": "邮箱设置",
            "Bio": "个人简介",
            "Tell us a little bit about yourself": "自我介绍一下您自己的相关信息",
            "You can": "您可以",
            "@mention": "@用户名或组织名",
            "other users and organizations to link to them.": "链接到其他用户和组织。",
            "URL": "网站",
            "Social accounts": "社交账户",
                "Link to social profile 1": "链接到社交账户",
                "Link to social profile 2": "链接到社交账户",
                "Link to social profile 3": "链接到社交账户",
                "Link to social profile 4": "链接到社交账户",
            "Company": "公司",
            "your company’s GitHub organization to link it.": "链接到您所在公司的 GitHub 组织。",
             //"your company's GitHub organization to link it.": "贵公司和GitHub的组织联系起来。",
            "Pronouns": "代词",
                "Don't specify": "不说明",
                "they/them": "他们",
                "she/her": "她",
                "he/him": "他",
                "Custom": "自定义",
            "Location": "位置",
            "Display current local time": "显示当前当地时间",
                "Other users will see the time difference from their local time.": "其他用户将看到与本地时间的时差。",
                "Time zone": "时区",

            "All of the fields on this page are optional and can be deleted at any time, and by filling them out, you're giving us consent to share this data wherever your user profile appears. Please see our": "此页面上的所有字段都是可选的，可以随时删除，填写这些字段，即表示您同意我们在您的个人资料出现的任何地方共享此数据。请参阅我们的",
            "privacy statement": "隐私声明",
            "to learn more about how we use this information.": "以了解更多关于我们如何使用这些信息。",
            "Update profile": "更新资料",
            // 顶部提醒
                "Profile updated successfully": "资料更新成功。",
                "Profile updated successfully —": "资料更新成功 —",
                "view your profile.": "查看您的个人资料。",

            "Contributions & activity": "贡献与活动",
                "Make profile private and hide activity": "将个人资料设置为私密，并隐藏活动",
                    "Enabling this will hide your contributions and activity from your GitHub profile and from social features like followers, stars, feeds, leaderboards and releases.": "启用此功能后，您的贡献和活动将会从您的 GitHub 个人资料中隐藏起来，也不会被关注者、观星者、动态提要、排行榜和发布等社交功能所发现。",
                "Include private contributions on my profile": "在我的个人资料显示私人贡献",
                    "Your contribution graph, achievements, and activity overview will show your private contributions without revealing any repository or organization information.": "您的贡献图、成就和活动概览将显示您的私人贡献，而不会透露任何仓库或组织信息。",
                    "Read more": "了解更多",
            "Update preferences": "更新设置",

            "Profile settings": "个人资料设置",
                "Display PRO badge": "显示 PRO 徽章",
                    "This will display the": "将会显示",
                    "badge on your public profile page.": "徽章在您的个人资料中。",
                "Show Achievements on my profile": "在我的个人资料上显示成就",
                    "Your achievements will be shown on your profile.": "您的成就将显示在您的个人资料中。",

            "GitHub Developer Program": "GitHub 开发者计划",
                "has guides, API and webhook references, information about creating GitHub Apps and other resources for building applications that integrate with GitHub. Make sure your contact information is up-to-date below. Thanks for being a member!": "包含指南、API 和 Web 钩子、有关创建 GitHub 应用的信息以及用于构建与 GitHub 集成的应用的其他资源。确保您的联系信息是最新的。感谢您的加入！",

                "Support email address": "技术支持电子邮件地址",
                    "An email address where GitHub users can contact you for support.": "供 GitHub 用户联系您寻求支持的电子邮件地址。",
                "Product or company website": "产品或公司网站",
                    "The URL for the product, company, or service that integrates with GitHub.": "与 GitHub 集成的产品、公司或服务的网址。",
                "Update contact information": "更新联系信息",
                "Leave the program": "退出计划",

                "Building an application, service, or tool that integrates with GitHub?": "构建与 GitHub 集成的应用、服务或工具？",
                "Join the GitHub Developer Program": "加入 GitHub 开发者计划",
                ", or read more about it at our": "，或了解更多信息在我们的",
                "GitHub developer program": "GitHub 开发者计划",
                "Developer site": "开发者站点",

            "Jobs profile": "就业状态",
            "Available for hire": "求 HR 带走",
            "Save jobs profile": "保存状态",
                // 顶部提醒
                "Profile updated successfully —": "个人资料更新成功 —",
                "view your profile.": "查看您的个人资料。",
                "Visitors will now see your public and anonymized private contributions.": "现在访客可以看到您的公开和匿名私人贡献。",
                "Visitors will now see only your public contributions.": "现在访客只能看到您的公开贡献",

            "Trending settings": "趋势设置",
            "Preferred spoken language": "首选语言",
            "No Preference": "未设置",
            "We'll use this language preference to filter the trending repository lists on": "我们将使用此语言偏好来过滤趋势仓库列表在",
            "our": "我们的",
            "Trending Repositories": "趋势仓库",
            "page.": "页面。",
            "Save Trending settings": "保存趋势设置",

            "ORCID provides a persistent identifier - an ORCID iD - that distinguishes you from other researchers. Learn more at": "ORCID 提供持久标识符 - ORCID iD - 将您与其他开发人员区分，了解更多信息请访问",
            "Connect your ORCID iD": "关联您的 ORCID iD",
            "Successfully connected your GitHub account with ORCID.": "已成功将您的 GitHub 账户与 ORCID 关联。",
            "You have a connected ORCID iD": "您的 ORCID iD",
            "for the account": "已关联账户",
            "Display your ORCID iD on your GitHub profile": "在您的 GitHub 个人资料上显示 ORCID iD",
            "Disconnecting your ORCID iD may affect areas of your profile where your ORCID iD is displayed.": "解除关联 ORCID iD 可能会影响您个人资料中显示 ORCID iD 的区域。",
            "Disconnect your ORCID iD": "解除关联您的 ORCID iD",
            "Successfully disconnected ORCID from your GitHub Account.": "已成功解除 ORCID 与您的 GitHub 账户的连接。",
    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Your profile": "个人资料",
        },
    },
};
I18N["zh-CN"]["settings"] = I18N["zh-CN"]["settings/profile"];

I18N["zh-CN"]["settings/admin"] = { // 设置 - 账户
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Account settings 账户设置 https://github.com/settings/admin
            "Change username": "更改用户名",
            "Changing your username can have": "更改您的用户名可能会有",
            "unintended side effects": "意想不到的副作用",
                "Really change your username?": "确定要更改您的用户名？",
                "Unexpected bad things will happen if you don’t read this!": "请仔细阅读以下提示信息！！！",
                "We": "我们",
                "will not": "不会",
                "will": "会",
                "set up redirects for your old profile page.": "为您的旧资料页设置重定向",
                "set up redirects for Pages sites.": "为 GitHub Pages 站点设置重定向。",
                "create redirects for your repositories (web and git access).": "为您的仓库设置重定向（ web 和 git 访问）。",
                "Renaming may take a few minutes to complete.": "重命名可能需要几分钟的时间来完成。",
                "I understand, let’s change my username": "我明白了，依然更改我的用户名",

                "Enter a new username": "输入新用户名",
                "Choose a new username": "选择新用户名",
                "Change my username": "更改我的用户名",
                "Trademark Policy": "商标政策",
                "are available.": "都可以使用。",
                "Username may only contain alphanumeric characters or single hyphens, and cannot begin or end with a hyphen.": "用户名只能包含字母数字字符或单个连字符，不能以连字符开始或结束。",
            "Looking to manage account security settings? You can find them in the": "想管理账户安全设置？您可以在",
            "page.": "页面找到它们。",

            "Link Patreon account": "关联 Patreon 账户",
                "Connect a Patreon account for": "关联",
                "to sponsor maintainers with. Get recognition on GitHub for sponsorships made on Patreon when the sponsored person has linked Patreon and GitHub, too, and has a public GitHub Sponsors profile.": "的 Patreon 账户，以便赞助维护者。当被赞助者也关联 Patreon 和 GitHub 账户时，在 Patreon 上获得的赞助也会显示在 GitHub 上，并显示 GitHub 赞助者的公开个人资料。",
                "Connect with Patreon": "关联 Patreon 账户",
                "Successfully connected your GitHub account with Patreon.": "已成功将您的 GitHub 账户与 Patreon 关联。",

            "Unlink Patreon account": "取消关联 Patreon 账户",
                "Disconnect the Patreon account": "取消 Patreon 账户",
                "for": "和",
                "to sponsor maintainers with. Any sponsorships made on Patreon will no longer receive recognition on GitHub.": "的关联，在 Patreon 上进行的任何赞助将不会在 GitHub 显示。",
                "Successfully disconnected your GitHub account from Patreon.": "已成功解除您的 GitHub 账户与 Patreon 的关联。",

            "Export account data": "导出账户数据",
            "Export all repositories and profile metadata for": "导出所有仓库和配置元数据，自",
            ". Exports will be available for 7 days.": "。导出结果将有 7 天有效期。",
            "Start export": "开始导出",
            "Recent exports": "近期导出",
            "New export": "新建导出",
            "We're preparing your export! We'll send you an email when it's finished.": "我们正在为您准备导出！我们完成后会发一封电子邮件。",
            "New exports cannot be requested while an export is currently in progress": "当前正在导出中，无法请求新的导出",
            "Resend email with link": "重新发送带有链接的邮件",
            "Download deleted": "导出内容已删除",
            "Job queued to delete file.": "正在排队删除文件的作业。",

            "Successor settings": "设置继任者",
            // 未指定
            "designated below": "（下面指定的）",
            ", in the event of my death. I understand that this appointment of a successor does not override legally binding next-of-kin rules or estate laws of any relevant jurisdiction, and does not create a binding will.": "。我明白，这种指定继任者的做法并不凌驾于具有法律约束力的近亲规则或任何相关司法管辖区的遗产法，也不产生具有约束力的遗嘱。",
            "Learn more about account successors.": "了解更多关于账户继任者的信息。",
            "Add Successor": "添加继任者",
            "Search by username, full name, or email address": "搜索用户名、全名、或电子邮箱",
            "You have not designated a successor.": "您还没有指定继任者。",
            // 等待回应
            "Pending": "待处理",
            "Copy invite link": "复制邀请链接",
            // 已指定
            "Learn more about account successors": "了解更多关于账户继任者的信息",
            "Revoke": "撤销",
            // 被谢绝
            "Declined": "被谢绝",

            "Delete account": "删除账户",
            "Once you delete your account, there is no going back. Please be certain.": "您一旦删除了您的账户，将再也无法恢复。请确认！",
                "Your account is currently an owner in these organizations:": "您的账户目前是以下组织的所有者：", // 存在组织
                "You must": "您必须先",
                "remove yourself": "删除您自己",
                "transfer ownership": "转让所有权",
                "delete these organizations": "删除这些组织",
                "before you can delete your user.": "，您才可以删除您的用户。",
            "Delete your account": "删除账户",
            "Are you sure you don’t want to just": "您确定不希望仅仅是",
            "downgrade your account": "降级您的账户",
            "to a": "为",
            "FREE": "免费",
            "account? We won’t charge your credit card anymore.": "账户吗？我们不会再向您信用卡账户扣款。",
            "account? We won’t charge your payment information anymore.": "账户吗？我们不会再向您支付账户扣款。",
            "account? We won’t charge your PayPal account anymore.": "账户吗？我们将不再向您 PayPal 账户扣款。",
                "Are you sure you want to do this?": "您确定要这么做吗？",
                "This is extremely important.": "这是极其重要的。",
                "We will": "我们将",
                ", along with all of your forks, wikis, issues, pull requests, and GitHub Pages sites.": "以及您所有的复刻、Wiki、议题、拉取请求和 GitHub Pages 站点。",
                "You will no longer be billed, and after 90 days your username will be available to anyone on GitHub.": "您将不再被收取费用，并且 90 天后您的用户名将被 GitHub 上的任何人使用。",
                "For more help, read our article \"": "如需更多帮助，请阅读我们的文章 “",
                "Deleting your user account": "删除您的账户",
                "\".": "”。",
                "Your username or email:": "您的用户名或电子邮箱：",
                "To verify, type": "为了验证，请输入",
                "below:": "在下面：",
                "Confirm your password:": "确认您的密码：",
                "Cancel plan and delete this account": "取消计划并删除此账户",

    },
    "regexp": [ // 正则翻译
        [/is available\./, "可用。"],
        [/Username ([^ ]+) is not available\. Please choose another\. To submit a trademark claim, please see our/, "用户名 $1 不可用。请重新选择。要提交商标索赔，请看我们的"],
        [/immediately delete all of your repositor(y|ies) \((\d+)\)/, "立即删除您所有的仓库（$1个）"],

        // 设置继任者
        [/By clicking \"Add Successor\" below, I acknowledge that I am the owner of the([^@]+@[^\n]+) account, and am authorizing GitHub to transfer content within that account to my GitHub Successor,/, "通过点击下面的 “添加继任者”，我确认我是 $1 账户的所有者，并授权 GitHub 在我死亡的情况下将此账户内的内容转让给我的 GitHub 继任者"],
        [/This link will only work for ([^ ]+)./, "此链接仅对 $1 有效。"],

        // 顶部提醒
        [/You have successfully sent the successor invitation to ([^ ]+)./, "您已经成功向 $1 发送了继任者邀请。"],
        [/You have revoked the successor invitation to ([^ ]+)./, "您已经撤销了对 $1 的继任者邀请。"],
        [/You have canceled the invitation to ([^ ]+) to be your designated successor./, "您已经取消了让 $1 成为您的指定继任者的邀请。"],
    ],
    "title": {
        "static": {
            "Account settings": "账户设置",
        },
    },
};

I18N["zh-CN"]["succession/invitation"] = { // 账户继任者邀请  users/<邀请者的 user-name>/succession/invitation
    "static": { // 静态翻译
        // 受邀者
        "invited you to be their account successor": "邀请您成为其账户继任者",
        "Learn more about account successors": "了解更多关于账户继任者的信息",
        //[/By clicking \"Accept invitation\" below, I acknowledge that I agree to serve as the successor for ([^ ]+), in such ways authorized by their successor request. I agree to abide by GitHub's/, "通过点击下面的 “接受邀请”，我确认我同意按照其继任者要求所授权的方式担任 $1 的继任者。我同意在使用和维护其帐户内容时遵守 GitHub 的"],
        "Terms of Service": "服务条款",
        "and the user's written requests, if any, in my use and maintaining of their account's content.": "和用户的书面请求（如果有）。",
        "I understand that accepting this appointment as successor does not override legally binding next-of-kin rules or estate laws of any relevant jurisdiction, and does not create a binding will, and I agree to comply or assist with a valid request by an individual with legal authority over the user's property (such as next-of-kin, an estate's executor, and/or a beneficiary of their will).": "我明白，接受此继任者任命的做法并不凌驾于具有法律约束力的近亲规则或任何相关司法管辖区的遗产法，也不产生具有约束力的遗嘱，并且我同意遵守或协助对用户财产拥有合法权力的个人（例如近亲、遗产执行人和/或其遗嘱受益人）的有效请求。",
        "Accept invitation": "接受邀请",
        "Decline": "谢绝",
        // 已接受
        "This invitation has already been accepted.": "此邀请已被接受。",
        // 已谢绝
        "This invitation has already been declined.": "此邀请已被谢绝。",
        // 不存在
        "Invitation not found": "此邀请已被谢绝。",
        "Your invitation could not be found, or is not valid.": "找不到您的邀请，或是其已不再有效。",
    },
    "regexp": [ // 正则翻译
        [/As an account successor, you would be able to manage ([^ ]+)'s repositories if they're not able to./, "作为账户继任者，在 $1 再也无法管理其仓库时，您将能够管理其仓库。"],
        [/By clicking \"Accept invitation\" below, I acknowledge that I agree to serve as the successor for ([^ ]+), in such ways authorized by their successor request. I agree to abide by GitHub's/, "通过点击下面的 “接受邀请”，我确认我同意按照其继任者要求所授权的方式担任 $1 的继任者。我同意在使用和维护其帐户内容时遵守 GitHub 的"],
    ]
};

I18N["zh-CN"]["settings/appearance"] = { // 设置 - 外观
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Appearance 外观 https://github.com/settings/appearance
            "Theme preferences": "主题首选项",
            "Choose how GitHub looks to you. Select a single theme, or sync with your system and automatically switch between day and night themes. Selections are applied immediately and saved automatically.": "选择 GitHub 在您眼中的样子。选择单一主题，或与您的系统同步并自动在白天和夜晚的主题之间切换。选择将立即生效并自动保存。",
            "Theme mode": "主题模式",
                "Single theme": "单一主题",
                "Sync with system": "与系统同步",
            "GitHub will use your selected theme": "GitHub 将使用您选择的主题",
            "GitHub theme will match your system active settings": "GitHub 主题将匹配您的系统设置",
            "Light default": "浅色 - 默认",
            "Light colorblind": "浅色 - 色盲",
            "Light Tritanopia": "浅色 - 蓝色盲",
            "Dark default": "深色 - 默认",
            "Dark colorblind": "深色 - 色盲",
            "Dark Tritanopia": "深色 - 蓝色盲",
            "Soft dark": "深色 - 柔和",
            "Light theme": "浅色主题",
            "Dark theme": "深色主题",
            "Active": "激活",
            "This theme will be active when your system is set to “light mode”": "当您的系统设置为 “浅色模式” 时，该主题将被激活。",
            "This theme will be active when your system is set to “dark mode”": "当您的系统设置为 “深色模式” 时，该主题将被激活。",
            "Beta":"预览",

            "Contrast": "对比度",
                "Increase contrast": "增加对比度",
                    "Enable high contrast for light or dark mode (or both) based on your system settings": "根据您的系统设置启用对浅色或深色模式（或两者）的高对比度",
                    "Light mode": "浅色模式",
                    "Dark mode": "深色模式",
                    "Off": "关闭",
                    "On": "开启",

            "Emoji skin tone preference": "表情符号肤色首选项",
            "Preferred default emoji skin tone": "默认的表情符号肤色",

            "Tab size preference": "制表符首选项",
            "Choose the number of spaces a tab is equal to when rendering code": "在渲染代码时，选择一个制表符等于多少个空格",
            "4 (Default)": "4 (默认)",

            "Markdown editor font preference": "Markdown 编辑器字体首选项",
            "Font preference for plain text editors that support Markdown styling (e.g. pull request and issue descriptions, comments.)": "支持 Markdown 样式的纯文本编辑器的字体首选项（例如拉取请求和议题描述、评论。）",
            "Use a fixed-width (monospace) font when editing Markdown": "编辑 Markdown 时使用固定宽度（等宽）字体",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Appearance": "外观",
        },
    },
};

I18N["zh-CN"]["settings/accessibility"] = { // 设置 - 无障碍
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Accessibility 无障碍 https://github.com/settings/accessibility
            "General": "通常",
            "Character keys": "字符键",
                "GitHub shortcuts": "GitHub 快捷键",
                "that don't use modifier keys in their activation. For example, the": "，这些快捷键在激活时不使用修改键。例如，",
                "shortcut to navigate notifications, or": "快捷键来导航到通知，或",
                "to view context relevant shortcuts.": "查看与上下文相关的快捷键。",
                "Learn more about character key shortcuts": "了解更多关于字符快捷键的信息",
                "Save keyboard shortcut preferences": "保存键盘快捷键首选项",

            // 顶部提醒
                "Keyboard shortcut preference successfully saved.": "键盘快捷键首选项已成功保存。",

            "Command palette": "命令面板",
                "Modify the shortcuts to trigger the Command Palette for the default search mode and the command mode": "修改快捷键以触发默认搜索模式和命令模式的命令面板",
                "Search mode": "搜索模式",
                    "control + k or control + alt + k (default)": "control + k 或 control + alt + k (默认)",
                    "Disabled": "禁用",
                "Command mode": "命令模式",
                    "control + shift + k (default)": "control + shift + k (默认)",
                "Save command palette preferences": "保存命令面板首选项",

            "Motion": "动态",
                "Autoplay animated images": "自动播放动态图片",
                    "Select whether animated images should play automatically.": "选择是否需要自动播放动态图片。",
                "Sync with system": "与系统同步",
                    "Adopts your system preference for reduced motion": "采用您的系统偏好以减少运动",
                "Enabled": "启用",
                    "Automatically plays animated images": "自动播放动态图片",
                // 禁用
                    "Prevents animated images from playing automatically": "防止自动播放动态图片",
                "Save motion preferences": "保存动态首选项",

            // 顶部提醒
                "Motion preferences successfully saved.": "动态首选项已成功保存。",

            "Content": "内容",
                "Link underlines": "链接下划线",
                    "Toggle the visibility of underlines on links that are adjacent to text.": "切换文本相邻链接上下划线的可见性。",
                "Hide link underlines": "隐藏链接下划线",
                "Show link underlines": "显示链接下划线",
                "Save content preferences": "保存内容首选项",

            // 顶部提醒
                "Link underline preferences successfully saved.": "链接下划线首选项已成功保存。",

            "Hovercards": "悬浮卡",
                "preview information about other parts of GitHub.": "预览 GitHub 其他部分的信息。",
                "Show hovercards": "显示悬浮卡",
                    "Enable previewing link content via mouse hover or keyboard focus before navigation. Move focus to hovercard content using": "在导航之前，可通过鼠标悬停或键盘聚焦预览链接内容。使用以下方法将焦点移至悬停卡片内容",
                "Save hovercard preferences": "保存悬浮卡偏好设置",
            // 顶部提醒
                "Hovercard preferences successfully saved.": "悬浮卡首选项已成功保存。",

            "Editor settings": "编辑器设置",
                "URL paste behavior": "URL 粘贴行为",
                "Select if URLs should be formatted on paste. You can use": "选择是否应在粘贴时格式化 URL。您可以使用",
                "to paste a link in the opposite way.": "以相反的方式粘贴链接。",
                "Formatted link": "格式化链接",
                    "Pasting a URL while having text selected will format to a Markdown link": "在选择了文本的情况下，粘贴 URL 将格式化为 Markdown 链接",
                "Plain text": "纯文本",
                    "Pasting a URL while having text selected will replace the text": "在选择了文本的情况下，粘贴 URL 将替换文本",
                "Save editor settings": "保存编辑器设置",
            // 顶部提醒
                    "Paste behavior preferences successfully saved.": "粘贴行为首选项已成功保存。",

            "Assistive technology hints": "辅助技术提示",
                "Add or remove instructions for how to operate complex controls.": "添加或删除如何操作复杂控件的说明。",
                // 悬浮卡
                    "Enable screen reader hint": "启用屏幕阅读器提示",
                    "Disable screen reader hint": "禁用屏幕阅读器提示",
                "Save assistive technology hint preferences": "保存辅助技术提示首选项",
            // 顶部提醒
                "Hovercard assistive technology hint preferences successfully saved.": "悬浮卡辅助技术提示首选项已成功保存。",
    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Accessibility": "无障碍",
        },
    },
};

I18N["zh-CN"]["settings/notifications"] = { // 设置 - 通知
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Notification center 通知 https://github.com/settings/notifications
            "Default notifications email": "默认邮件通知设置",
                "Choose where you'd like emails to be sent. You can add more email addresses. Use custom routes to specify different email addresses to be used for individual organizations.": "请选择希望接收通知邮件的邮箱。您可以添加多个邮箱地址。可借助自定义路由为不同的组织指定不同的邮箱地址。",
                "Custom routing": "自定义路由",

            "Automatically watch repositories": "自动关注仓库",
                "When you're given push access to a repository, automatically receive notifications for it.": "当您给一个仓库推送权限时，自动接收相关通知。",
            "Automatically watch teams": "自动关注团队",
                "Anytime you join a new team, you will automatically be subscribed to updates and receive notification when that team is @mentioned.": "当您加入新团队时，您将自动订阅更新，并在该团队 @提及 时收到通知。",

                "On": "开启",
                "Off": "关闭",

            "Subscriptions": "订阅",
                "Watching": "关注仓库",
                    "Notifications for all repositories, teams, or conversations you're watching.": "所有您正在关注的仓库、团队或对话所发出的通知。",
                    "View watched repositories": "查看正在关注的仓库",
                    "Notify me:": "提醒我：",
                    "Select notification channels": "选择通知渠道",
                    "on GitHub, Email, CLI": "在 GitHub、电子邮件、CLI 上",
                    "on GitHub, CLI": "在 GitHub、CLI 上",
                    "on GitHub, Email, CLI": "在 GitHub、电子邮件、CLI 上",
                    "on GitHub, Email": "在 GitHub、电子邮件 上",
                    "On GitHub": "在 GitHub 上",
                    "on GitHub": "在 GitHub 上",
                "Don't notify": "取消通知",

                "Participating, @mentions and custom": "参与、@提及和自定义",
                    "Notifications for the conversations you are participating in, or if someone cites you with an @mention. Also for all activity when subscribed to specific events.": "您参与的对话、或有人 @您、以及您订阅的特定事件所发出的通知。",

                "Customize email updates": "自定义电子邮件更新",
                    "Choose which additional events you'll receive emails for when participating or watching.": "选择参与或关注时，您将收到哪些额外活动的电子邮件。",
                    "Select events": "选择事件",
                    "Reviews": "审查",
                    "Reviews, Pushes": "审查、推送",
                    "Reviews, Pushes, Comments": "审查、推送、评论",
                    "Reviews, Pushes, Comments, My own updates": "审查、推送、评论、自我更新",
                    "Pull Request reviews": "拉取请求审核",
                    "Pull Request pushes": "拉取请求推送",
                    "Comments on Issues and Pull Requests": "关于议题和拉取请求的评论",
                    "Includes your own updates": "包括您自己的更新",
                "Ignored repositories": "忽略的仓库",
                "You'll never be notified.": "您将永远不会收到通知。",
                "View ignored repositories": "查看忽略的仓库",

            "System": "系统",
                "Actions": "操作",
                    "Notifications for workflow runs on repositories set up with": "仓库的工作流程通知，设置在",
                    ". (": "。（",
                    "Failed workflows only": "仅工作流程失败时",
                    "Only notify for failed workflows": "只对失败的工作流程进行通知",

            "Dependabot alerts: New vulnerabilities": "Dependabot 警报：新漏洞",
                "When you're given access to": "当您获得",
                "Dependabot alerts": "Dependabot 警报",
                "automatically receive notifications when a new vulnerability is found in one of your dependencies.": " 访问权限时，当您的某个依赖项中发现新的漏洞时，就会自动收到通知。",

            "Dependabot alerts: Email digest": "Dependabot 警报：电子邮件摘要",
                "Email a regular summary of Dependabot alerts for up to 10 of your repositories.": "通过电子邮件发送最多 10 个仓库库的 Dependabot 警报定期摘要。",
                "Don't send": "不发送",
                "Send weekly": "每周发送",
                "Send daily": "每日发送",

            "Security campaign emails": "安全活动电子邮件",
                "Receive email notifications about security campaigns in repositories where you have access to security alerts.": "接收有关您有权访问安全警报的仓库中的安全活动的电子邮件通知。",

            "\'Deploy key\' alert email": "“部署密钥” 警报电子邮件",
                "When you are given admin permissions to an organization, automatically receive notifications when a new deploy key is added.": "当您获得组织的管理员权限时，会在添加新部署密钥时自动接收通知。",

            "In-product messages": "产品消息",
                "Get tips, solutions and exclusive offers from GitHub about products, services and events we think you might find interesting.": "从 GitHub 获取有关我们认为您可能感兴趣的产品、服务和活动的提示、解决方案和独家优惠。",

        // 通知 自定义路由 https://github.com/settings/notifications/custom_routing
                "/ Custom Routing": "/ 自定义路由",
                    "You can send notifications to different": "您可借助自定义路由为不同的组织指定不同的邮箱地址",
                    "verified": "（经验证的邮箱）",
                    "email addresses depending on the organization that owns the repository.": "。",
                    "is your current default email for notifications.": "是您目前默认的通知邮箱。",

                    "No custom routes yet.": "尚无自定义路由",
                    "Add new route": "添加新路由",
                        "Pick organization": "挑选组织",
                            "Select an item": "选择一项",
                        "Search organizations": "搜索组织",
                        "Select Email": "选择邮箱",
                        "Saved": "已保存",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Notification settings": "通知设置",
        },
    },
};

I18N["zh-CN"]["settings/billing"] = { // 设置 - 账单和计划
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置

        // 概况 https://github.com/settings/billing
            // 顶部提示
                "Successfully updated billing information.": "成功更新支付信息。",

                "For more information on using these billing pages": "有关使用这些账单页面的更多信息，",
                    "please refer to the docs content here": "请参阅此处的文档内容",

            // 概况
                "Current metered usage": "当前计费用量",
                    "Gross metered usage for": " ",
                    "Showing gross metered usage for your account.": "显示您账户的总计费用量。",
                    "Showing gross metered usage for your organization.": "显示您组织的总计费用量。", // 组织

                "Current included usage": "当前包含用量",
                    "More details": "详情",
                    "Included usage discounts for": " ",
                    "Showing currently applied discounts for your account.": "显示您账户当前应用的折扣。",
                    "Showing currently applied discounts for your organization.": "显示您组织当前应用的折扣。", // 组织
                    "* As per current pricing": "* 根据当前定价方案",
                    "Download your Copilot premium request usage report": "下载您的 Copilot 高级请求使用报告：",
                        "here": "下载",

                // 当前包含用量详情
                    "Included usage and credits": "包含用量和额度",
                        "Showing currently applied usage and credits for your account.": "显示您账户当前的使用情况和额度。", // 后续走正则

                        "Included usage*": "包含用量*",
                            "Included premium requests": "包含高级请求",
                            "Free usage**": "免费使用**",
                                "100% off per month": "100%减免/每月",

                        "* Included usage is an approximate amount based on current pricing.": "* 所包含的用量是基于当前定价的预估值。",
                        "** GitHub Packages usage is free for public packages. For details on free Actions usage, see": "** GitHub 软件包对公共包的使用是免费的。有关 GitHub Actions 免费使用的详细信息，请参阅",
                        "Free use of GitHub Actions": "Github Actions 的免费使用",

            "Next payment due": "下一次应付款",

            "Subscriptions": "订阅",
                "Manage subscriptions": "管理订阅",
                "per": "/",
                "month": "月",

            "Metered usage": "计费用量",
                "Usage by products": "按产品分类", // 省略重复内容
                // 时间段，这部分走正则
                    "Today": "今天",
                    "Current month": "这个月",
                    "Last month": "上个月",
                    // 后 2 项正则

                    "Billable usage": "计费",
                        // 操作
                        "consumed usage": "使用",
                        "discounts": "减免",

                        "Billable spend for Actions and Actions Runners for the selected timeframe. Applicable discounts cover Actions usage in public repositories and included usage for Actions minutes and storage.": "在所选时间范围内，Actions 和 Actions 运行器的可计费支出。适用的折扣涵盖公共仓库中的 Actions 使用，以及包含的 Actions 分钟数和存储用量。",
                        "Billable spend for Codespaces for the selected timeframe.": "所选时间范围内代码空间的可计费支出。",
                        "Billable spend for Git LFS for the selected timeframe. Applicable discounts cover included usage for Git LFS bandwidth and storage.": "所选时间范围内 Git LFS 的可计费支出。适用的折扣涵盖 Git LFS 带宽和存储的包含用量。",
                        "Billable spend for Packages for the selected timeframe. Applicable discounts cover Packages usage in public repositories and included usage for Packages data transfer and storage.": "所选时间范围内软件包的可计费支出。适用的折扣涵盖公共仓库中的软件包使用，以及包含的软件包数据传输和存储用量。",
                    "Included usage": "包含",
                        "Manage budgets": "管理预算",
                        "Actions minutes": "操作分钟数",
                        "Git LFS bandwidth": "Git LFS 带宽",
                        "Git LFS storage": "Git LFS 存储",
                        "Packages data transfer": "软件包数据传输",
                        "Packages storage": "软件包存储",
                        "Included usage limits reset in": "将重置于",
                        "days": "天内",
                        "day": "天内",
                "Chart options": "图表选项",
                    "View as table": "以表格形式查看",
                        "DateTime": "日期时间",
                    "Download CSV": "下载 CSV",
                    "Download PNG": "下载 PNG",
                "All usage": "全部",
                    // 某单位
                    "Gross:": "总计：",
                    "Billed:": "计费：",
                    "Discount:": "优惠：",
                "Usage by repository": "按仓库统计",
                    "Top three repositories today": "今日排名前三的仓库",
                    "Top three repositories this month": "本月排名前三的仓库",
                    "Top four repositories last month": "上月排名前四的仓库",
                    "Top four repositories this year": "今年排名前四的仓库",
                    "Top four repositories this month": "上年排名前四的仓库",

                    "usage": "用量",
                    "Gross amount": "总计",
                    "All other repositories": "其他",

                "No usage found": "无数据",

                // 底下计算部分
                    "View details": "详情",
                    "consumed usage -": "计费 -",
                    "in discounts =": "折扣 =",
                    "in billable usage": "计费",
                    "Usage for Actions and Actions Runners.": "操作（运行器）用量。", // 后半句走正则
                    "Copilot usage": "Copilot 用量",
                        "Total spend on Copilot for the selected timeframe, excluding applicable discounts.": "所选时间段内 Copilot 的总支出，不含适用折扣。",
                    "Billable licenses": "计费许可数",
                        "Billable licenses info": "计费许可信息",
                            "If a user stops consuming a license within the month, the adjustment will be reflected in your next month's bill.": "如果用户在当月停止使用许可，相关调整将体现在您下个月的账单中。",
                            "Billable licenses are only available for the 'Current month' timeframe.": "计费许可仅适用于“当前月”时间段。",
                            "Learn more about billable licenses": "了解更多关于可计费许可证的信息",
                        "Showing total unique licenses billed for your enterprise. Actual billed amount for each license is prorated based on when it is added during the billing cycle.": "显示您企业所计费的唯一许可证总数。每个许可证的实际计费金额将根据其在计费周期内添加的时间按比例分摊。",
                    "Copilot premium requests": "Copilot 高级请求",
                        "About Copilot premium requests": "关于 Copilot 高级请求",
                        "If enabled, additional premium requests beyond the included amount for each license will be billed.": "若启用此功能，每个许可证所包含额度之外的额外高级请求将另行计费。",
                        "Manage Copilot policy": "管理 Copilot 策略",
                    // 模型
                        "About GitHub Models rate limits": "关于 GitHub 模型速率限制",
                            "GitHub Models rate limits": "GitHub 模型速率限制",
                                "The playground and free API usage are rate limited by requests per minute, requests per day, tokens per request, and concurrent requests.": "操场和免费 API 的使用受到以下限制：每分钟请求数、每天请求数、每次请求的令牌数以及并发请求数。",
                                "Learn more about GitHub Models rate limits": "了解更多", // 有上下文，故省略

                    // Spark
                        "Spark premium requests": "Spark 高级请求",

            // 代码空间超限
            "You've used 90% of included services for GitHub Codespaces storage.": "您已使用 90% 代码空间存储。",
            "You've used 100% of included services for GitHub Codespaces storage.": "您已使用 100% 代码空间存储。",
                "When your allotment is exhausted, you won't be able to use Codespaces until you set up a spending limit or your free Codespaces allotment is reset next month. If you want to access your in progress work from a codespace, you can": "当您的额度耗尽后，您将无法使用代码空间，直到您设置支出上限或下月重置您的免费额度。如果您想访问代码空间中正在进行的工作，您可以",
                "export your unpushed work to a branch.": "将未推送的工作导出到分支。",
                "To see a full list of your usage, obtain a copy of your": "要查看所有使用情况，请获取您的",
                "usage report": "使用报告",
                "to see the codespaces and prebuilds created by your account. The usage report is the only place where prebuild usage is visible. If you see charges you'd like to stop going forward, you can delete a": "，以查看您的账户创建的代码空间和预构建。使用报告是唯一能显示预构建使用情况的地方。如果您看到希望以后停止的费用，您可以删除一个",
                "codespace": "代码空间",
                "delete prebuilds for a repository.": "删除某个仓库的预构建。",
            "Update spending limit": "更新支出限额",

        // 使用情况 https://github.com/settings/billing/usage
            "Get usage report": "获取使用情况报告",
                "Metered billing usage report": "计费用量",
                    "Provides a breakdown of all metered usage": "提供所有计量使用情况的详细分解",
                    // 窗口
                    "Select report type:": "选择报告类型：", // 下方小字走正则
                        "Summarized": "总结",
                            "Metered usage by repository for up to 1 year": "每个仓库的计量使用情况，最长可追溯至一年",
                        "Detailed": "详细",
                            "Metered usage by username and workflow for up to 31 days": "每个用户和工作流的计量使用情况，最长可追溯至 31 天",
                        "Legacy": "传统",
                            "Metered usage before the billing transition, until April 04, 2025": "计费切换前的计量使用情况，截至2025年4月4日",
                    "Select time frame": "选择时间段",
                        "This year": "今年",
                        "Custom range": "自定义",
                            "Up to 1 year": "最长 1 年",
                            "Up to 31 days": "最长 31 天",
                            "Choose date...": "选择日期…",
                                "Su": "日",
                                "Mo": "一",
                                "Tu": "二",
                                "We": "三",
                                "Th": "四",
                                "Fr": "五",
                                "Sa": "六",
                    "Email me the report": "发送",
                "Copilot premium requests usage report": "Copilot 高级请求",
                    "Provides a per user breakdown of requests exhausted and their monthly quota for the current billing period.": "提供每个用户的请求耗尽情况及其当前计费周期的月度配额。",
            "Search or filter usage": "搜索或筛选使用情况",

            //"Group: None": "分组：无",
            //"Group: Product": "分组：产品",
            //"Group: SKU": "分组：库存单位",
            //"Group: Repository": "分组：仓库",
                "None": "无",
                // "SKU": "库存单位",
            "Metered usage grouped by Product": "分组：产品",
                "actions": "操作",
                "codespaces": "代码空间",

                "Products": "产品",
            "Metered usage grouped by SKU": "分组：库存单位",
                "Actions storage": "操作存储",
                "Codespaces storage": "代码空间存储",
                "Actions Windows": "操作 Windows",
                "Actions Linux": "操作 Linux",
                "Actions macOS 3-core": "操作 macOS 三核",
                "Codespaces compute 2-core": "代码空间 - 双核",
                "Copilot Premium Request": "Copilot 高级请求",
            "Metered usage grouped by Repository": "分组：仓库",
                "All other": "其他",

            "For license-based products, the price/unit is a prorated portion of the monthly price.": "对于基于许可证的产品，每单位价格为月度价格按比例分摊的部分。",

            // 有上下文，后面重复部分直接省略
            "Actions usage": "操作",
            "Actions usage grouped by SKU": "操作 - 详细",
            "Copilot usage": "Copilot",
            "Copilot usage grouped by SKU": "Copilot - 详细",
            "Codespaces usage": "代码空间",
            "Codespaces usage grouped by SKU": "代码空间 - 详细",
            "Git_lfs usage": "Git LFS",
            "Git_lfs usage grouped by SKU": "Git LFS - 详细",
            "Packages usage": "软件包",
            "Packages usage grouped by SKU": "软件包 - 详细",

            "Usage breakdown": "用量分析",
                "Date": "日期",
                "SKUs": "库存单位",
                "Products": "产品",
                "Repositories": "仓库",
                "Units": "单位",
                "Price/unit": "单价",
                "Billed amount": "计费",

        // 高级请求分析 https://github.com/settings/billing/premium_requests_usage
            "Usage analytics for premium requests in your personal account.": "在您的个人账户中针对高级请求的使用分析。",

            "Billed premium requests": "计费高级请求",
                "Increase your budget": "提高您的预算",
                    "to use premium requests beyond your included request limit.": "以便在超出包含请求额度后继续使用。",

            "Included premium requests consumed": "包含高级请求",
                "included": " ", // 多余原文，直接删除
                "Premium requests included in your": "高级请求包含在您的",
                    "Copilot plan": "Copilot 计划中",
                    // 后续走正则

            // 用量分析
                "Model": "模型",
                    "Included requests": "包含请求",
                    "Billed requests": "计费请求",
                    "Code Review model": "代码审查模型",
                    "Coding Agent model": "编程智能体模型",

            // 获取使用情况报告
                "Premium requests usage report": "高级请求使用报告",
                    "Detailed per-user breakdown of premium requests consumed.": "详细列出每位用户消耗的高级请求数量。",
                "Legacy usage report": "旧版使用报告",

        // 预算和警报 https://github.com/settings/billing/budgets
           "Account budgets": "账户预算",
                "New budget": "新建",
                // "On": "开",
                // "Off": "关",
                "Stop usage": "停止使用",
                "Yes": "是",
                "spent": "支出",
                "budget": "预算",
            "Budgets let you set monthly usage limits for specific GitHub products or SKUs. If no budget is set, usage for that product is unlimited.":"预算允许您为特定的 GitHub 产品或 SKU 设置每月使用限制。如果未设置预算，该产品的使用量将不受限制。",
            "Product":"产品类型",

        // 新建/更新预算 https://github.com/settings/billing/budgets/new
        // https://github.com/settings/billing/budgets/<id>/edit
            // 提醒栏
                "Info": "信息",
                "SKU level budgets are only available for products that have > 1 SKU.": "只有拥有大于 1个 SKU 的产品才有 SKU 级别的预算。",

            "Budgets and Alerts": "预算和警报",
            "New monthly budget": "新建月度预算",
            "Edit monthly budget": "编辑每月预算", // edit
                "Create a budget to track spending for a selected product and scope.": "创建预算以跟踪选定产品和范围的支出。",
            // 缺失支付方式
                "Payment method is missing":"支付方式缺失",
                "Please set up a valid payment method before creating or adjusting your budget.": "请在创建或调整预算前设置有效的付款方式。",
                "Add payment method":"添加支付方式",

            "Budget type": "预算类型",
                "Set budget for either a product or individual SKU within a product.": "为产品或产品中的单个 SKU 设置预算。",
                "Product-level budget": "产品级预算",
                    "Codespaces": "代码空间",
                    "Actions": "操作",
                    "Models": "模型",
                        "Enable billing to set a budget. See": "启用计费以设置预算。查看",
                        "Models policy configuration": "模型策略配置",
                    "Packages": "软件包",
                    "Select 1 product": "选择产品",
                "SKU-level budget": "SKU 级预算",
                    "Select": "选择",
                    "Select an item": "选择项目",

            "Next: Configure budget": "下一步：配置预算",

            "All Premium Request SKUs":"所有高级请求 SKU",
            "A budget for all SKUs that consume premium requests":"所有消耗高级请求的 SKU 的预算",
            "Supported SKUs:":"支持的 SKUs：",
                "Coding Agent premium requests":"Coding Agent 高级请求",

            "Budget scope": "预算范围",
                "Select the scope of spending for this budget.": "选择此预算的支出范围。",
                // 仓库
                    "Scoped budgets track spending for a single repository": "范围预算跟踪单个仓库的支出",

                        "Select repository": "选择仓库",
                        "Select the": "选择",
                        "to include in this": "包含在此",
                        ". You can only add/remove the": "您只能添加/删除您可以访问的",
                        "that you have access to.": "。",
                        "Search repository": "搜索仓库",
                        "Showing": "显示",
                        "of": "/",
                        // [/(\d+) selected/, "$1 个选定"],
                // 账户
                    "Scoped budgets track spending for all repositories owned by your account": "范围预算跟踪您账户下所有仓库的支出",
                    "Scoped budgets track all spending for your account": "范围预算跟踪您账户的所有支出",

            "Budget": "预算",
                "Set a budget amount to track your spending on a monthly basis.": "设置预算金额以按月跟踪您的支出。",
                "Usage before budget creation isn't counted in the current billing cycle.": "预算创建前的使用情况不会计入当前计费周期。",
                "Budget amount": "预算金额",
                    "Stop usage when budget limit is reached": "达到预算上限时停止使用",
                        "Spending won't exceed your set budget": "支出不会超出您设定的预算",

            // 警示
                "Get emails and GitHub notifications when your spending has reached 75%, 90%, and 100% of the budget threshold.": "当您的支出达到预算阈值的 75%、90% 和 100% 时，接收电子邮件和 GitHub 通知。",
                "Receive emails when usage reaches 75%, 90%, and 100% of the budget amount.":"当您的支出达到预算阈值的 75%、90% 和 100% 时，接收电子邮件通知。",

                "Receive budget threshold alerts": "接收预算阈值警报",

            "Create budget": "创建预算",
            "Update budget": "更新预算", // edit

            // 左下角提示
                "Please add a payment method to use budgets.": "请添加付款方式，以便使用预算。",

        // 许可 https://github.com/settings/billing/licensing
            // Github Copllot
                "Your AI pair programmer": "您的 AI 编程助理",
                    "You are eligible to use GitHub Copilot for free.": "您有资格免费使用 GitHub Copilot。",

            "Current plan": "当前计划",
                "Compare all plans": "比较所有计划",
                    "per month": "每月",

                "GitHub Free": "GitHub 免费版",
                "The basics for all developers": "基础计划（所有开发者）",
                //"GitHub Pro": "GitHub 专业",

                "The basics for organizations and developers": "组织和开发者的基本计划", // 组织设置
                "Unlimited public/private repos": "无限的公共/私有仓库",
                "Unlimited collaborators": "无限协作者",
                "2,000 Actions minutes/month": "每月 2,000 分钟 GitHub Actions",
                "500MB of Packages storage": "500MB 的 GitHub Packages 存储空间",
                "120 core-hours of Codespaces compute per developer": "每位开发者拥有 120 个核心小时的代码空间计算能力",
                "15GB of Codespaces storage per developer": "每位开发者拥有 15GB 的代码空间存储空间",
                "Community support": "社区支持",
                // pro
                    "Downgrade to Free": "降级至免费版",
                "3,000 Actions minutes/month": "每月 3,000 分钟 GitHub Actions",
                "2GB of Packages storage": "2GB 的 GitHub Packages 存储空间",
                "180 core-hours of Codespaces compute": "180 核心小时的代码空间计算时长",
                "20GB of Codespaces storage": "20GB 的代码空间存储空间",
                "Code owners, required reviewers, GitHub Pages,": "代码所有者、所需审核者、GitHub Pages，",
                "and more": "以及更多",
                "advanced tools": "高级工具",

                "Not included:": "不包含：",
                "Free Codespaces usage per organization": "每个组织的免费代码空间使用量",
                "Protected branches on all repos": "所有仓库上的受保护分支",
                "Increase Codespaces": "提高代码空间",
                "spend limits": "消费限额",
                "Multiple reviewers in pull requests": "拉取请求中多个审查者",
                "Required status checks": "状态检查",
                "Code owners": "代码所有者",
                "Required reviewers": "所需的审查者",
                "Pages for static website hosting": "静态网站页面托管",
                "Web-based support": "基于网络的支持",
                "See all features and compare plans": "查看所有功能并比较计划",

            "Active subscription": "当前订阅",
                "Copilot Free": "Copilot 免费版",
                    "Upgrade Copilot": "升级 Copilot",
                    "You can upgrade to Copilot Pro at any time. Check out this": "您可以随时升级至 Copilot 专业版。详情查看",
                        "documentation": "文档",
                        "for more details.": "。",

            "Current GitHub base plan": "当前 GitHub 基础计划",
                "Compare base plans": "比较基础计划",
                "Upgrade to GitHub Pro": "升级至 GitHub 专业版",
                // 有付费计划
                    "Switch to yearly billing": "切换至年度计费",
                    "Switch to monthly billing": "切换至月度计费",

            "Current Copilot plan": "当前 Copilot 计划",
                "Monthly payment": "每月支付",
                "Next payment": "下次支付",
                "You can upgrade your subscription to yearly billing or cancel any time." : "您可以随时将订阅升级为年度计费或取消订阅。",
                "Read billing documentation": "阅读计费文档",

            "Compare Copilot plans": "比较 Copilot 计划",
            "Upgrade to Copilot Pro+" : "升级至 Copilot Pro+",
            "Manage subscription": "管理订阅",
            "Switch to annual billing": "切换至年度计费",
            "Cancel subscription": "取消订阅",

        // 支付信息 https://github.com/settings/billing/payment_information
            ...I18N["zh-CN"]["payment-module"]["static"], // 调用通用账单及支付信息模块

            "Last payment": "最后一次支付",
                "You have not made any payments.": "您尚未支付任何款项。",

            "Coupon": "优惠劵",
                "Redeem a coupon": "兑换优惠券",
                "You don't have an active coupon.": "您没有有效的优惠券。",
                "* Discount only applies for GitHub Pro": "* 优惠仅限 GitHub Pro。",

            "Additional information": "附加信息",
                "Add specific contact or tax information to your receipts, like your full business name, VAT/GST identification number, or address of record here. We’ll make sure it shows up on every receipt.": "在您的收据上添加具体的联系方式或税务信息，例如您的企业全称、VAT/GST 识别号码或记录地址。我们将确保它显示在每张收据上。",
                "Add information": "添加信息",
                "No additional information added to your receipts.": "您的收据上没有添加任何额外的信息。",
                "Extra information": "附加信息",

                // “额外账单信息” 对话框
                    "Extra billing information": "额外的账单信息",
                    "This information will appear on all your receipts.": "此信息将出现在您的所有收据上。",
                    "For your security, do not include any confidential or financial information (like credit card numbers).": "为了您的安全，请勿包含任何机密或财务信息（如信用卡号）。",
                    "To update the information that appears on": "要更新显示在",
                        "invoices": "发票",
                        "(if enabled), visit the": "上的信息（如果已启用），请访问",
                    "Full business name or address of record": "企业全称或记录地址",
                    "Save contact information": "保存联系信息",
                    "Saving contact information…": "正在保存联系信息…",
                    // 顶部提醒
                        "Updated your optional contact information, it will show up on your next receipt.": "已更新您的可选联系信息，该信息将显示在您的下一张收据上。",

            // 组织
            "Invoice": "发票",
                "Receive an invoice for your GitHub purchases": "接收 GitHub 购物发票",

                "The data from Billing Information, such as your address and VAT/GST ID will appear on your invoices.": "账单信息中的数据，如您的地址和增值税/消费税 ID，将显示在您的发票上。",
                "Update your information displayed on your invoices in the": "更新发票上显示信息中的",
                "billing information section": "账单信息栏",

                "Automatically receive an invoice alongside the payment receipt": "在收到付款收据的同时自动接收发票",
                    "* Enables invoices for all NEW payments.": "* 为所有新付款启用发票。",
                "Save invoice preference": "保存发票首选项",

            // 组织
            "Metered billing via Azure": "通过 Azure 计量计费",
                "Add Azure Subscription": "添加 Azure 订阅",
                "To manage metered billing for this account through Microsoft Azure an Azure Subscription ID must be added to your account.": "通过 Microsoft Azure 管理此账户的计量计费，必须将 Azure 订阅 ID 添加到您的账户中。",

        // 支付历史 https://github.com/account/billing/history
            "Amounts shown in USD": "以美元显示的金额",

        // 其他账单 https://github.com/settings/billing/subscriptions
            // [/In addition to your personal account, you manage (\d+) organizations?./, "除个人账户外，您还可以管理 $1 个组织。"],
            "Manage your organizations": "管理您的组织",
                "Create a new organization": "创建新组织",

            "Start your first organization": "开始您的第一个组织",
                "With CI/CD, Dependabot, and the world's largest developer community, GitHub gives your team everything they need to ship better software faster": "通过 CI/CD、Dependabot 以及全球最大的开发者社区，GitHub 为您的团队提供了交付更优质软件所需的一切，让开发更高效、更快捷。",
                "Create an organization": "创建组织",

            "Marketplace apps": "市场应用",
                "Change plan": "更改计划",
                "Cancel plan": "取消计划",
                    "Are you sure you want to cancel this integration?": "您确定要取消此集成吗？",
                    // 顶部提醒
                        // [/You've cancelled your subscription to (.*). This plan change will take effect on (.*)./, "您已取消对 $1 的订阅。此计划变更将于 $2 生效。"],
                        "Dismiss": "忽略",
                "Do you have any questions? Contact": "您有任何问题吗？请联系",

            // 组织设置
            "Billing Contacts": "账单联系人",
                "Receipts are sent to billing managers and email recipients.": "收据会被发送给账单管理员和邮件接收者。",

                "Billing managers": "账单管理员",
                    "You have not invited any billing managers": "您尚未邀请任何账单管理员",
                    "Invite": "邀请",

                "Email recipients": "邮件接收者",
                    "Add": "添加",
                    "Primary": "主账户",

                    // 编辑账单电子邮箱对话框
                        "Edit billing email address": "编辑账单电子邮箱",
                        "Billing primary email": "账单主账户邮箱",
                        "(Private)": "（私密）",

                    // 添加账单接收者对话框
                        "Add billing recipient": "添加账单接收者",
                        "Add billing recipient email": "添加账单接收者邮箱",

            "Sponsorships": "赞助",
                "GitHub Sponsors": "GitHub 赞助",
                    "Connect with the community that builds the tools you use": "与构建您使用的工具的社区联系",
                    "Start sponsoring": "开始赞助",
                    "You're currently not sponsoring anyone.": "您目前没有赞助任何人。",
                    "Learn more about GitHub Sponsors": "了解更多关于 GitHub 赞助的信息",
                    "Switch to invoiced billing": "切换到发票账单", // 组织

        // 比较计划 https://github.com/account/billing/plans
            "Compare plans": "比较计划",
            "Free": "免费版",
                "All the basics": "所有基础",
            "Pro": "专业版",
                "Advanced tools for private repos": "用于私人仓库的高级工具",
            // 具体内容
                "Code management": "代码管理",
                    "Public repositories": "公共仓库",
                        "Host open source projects in public GitHub repositories, accessible via web or command line. Public repositories are accessible to anyone at GitHub.com.": "在 GitHub 公共仓库中托管开源项目，可通过网络或命令行访问。任何人都可以访问 GitHub.com 上的公共仓库。",
                    "Private repositories": "私有仓库",
                        "Host code in private GitHub repositories, accessible via appliance, web, and command line. Private repositories are only accessible to you and people you share them with.": "在私有 GitHub 仓库中托管代码，可通过设备、网络和命令行访问。只有您和与您共享的人才能访问私有仓库。",

                "Code workflow": "代码工作流",
                    "GitHub Codespaces": "GitHub 代码空间",
                        "Spin up fully configured dev environments in the cloud with the power of your favorite editor. A \"core hour\" denotes compute usage. On a 2-core machine, you would get 60 hours free. On a 4-core machine, you would get 30 hours free, etc. Free hours are assigned to personal accounts, rather than free organizations.": "利用您喜爱的编辑器的强大功能，在云中快速配置完整的开发环境。“核心小时” 表示计算使用量。在双核机器上，您将获得 60 小时的免费时长。在 4 核机器上，您将获得 30 小时的免费时长，以此类推。免费时长数分配给个人账户，而不是免费组织。",
                    "GitHub Actions": "Github 操作",
                        "Use execution minutes with GitHub Actions to automate your software development workflows. Write tasks and combine them to build, test, and deploy any code project on GitHub. Minutes are free for public repositories.": "利用 GitHub Actions 的几分钟执行时间，实现软件开发工作流程自动化。编写任务并组合它们，即可在 GitHub 上构建、测试和部署任何代码项目。对于公共仓库，执行时间是免费的。",
                        "Learn more about billing": "了解更多关于账单的信息",
                    "GitHub Packages": "Github 软件包",
                        "Host your own software packages or use them as dependencies in other projects. Both private and public hosting available. Packages are free for public repositories.": "托管您的软件包，或将其用作其他项目的依赖项。提供私有和公共托管。对于公共仓库，软件包是免费的。",
                    "Code reviews": "代码审查",
                        "Review new code, see visual code changes, and confidently merge code changes with automated status checks.": "审查新代码，查看可视化的代码更改，并通过自动化状态检查自行地合并代码更改。",
                    // 拉取请求
                        "Allow contributors to easily notify you of changes they've pushed to a repository – with access limited to the contributors you specify. Easily merge changes you accept.": "允许贡献者轻松通知您他们推送到仓库的更改，访问权限仅限于您指定的贡献者。轻松合并您接受的更改。",
                    "Protected branches": "受保护的分支",
                    "Repository rules":"仓库规则",
                        "Enforce restrictions on how code branches are merged, including requiring reviews by selected collaborators, or allowing only specific contributors to work on a particular branch.": "对代码分支的合并方式实施限制，包括要求由选定的协作者进行审查，或仅允许特定的贡献者在特定分支上工作。",
                    // 代码所有者
                        "Automatically request reviews – or require approval – by selected contributors when changes are made to sections of code that they own.": "当选定的贡献者对其拥有的代码部分进行修改时，自动要求审查或要求批准。",
                    "Draft pull requests": "拉取请求草案",
                        "Easily discuss and collaborate on pull requests before submitting to formal review.": "在提交正式审查之前，轻松讨论和协作拉取请求。",
                    "Multiple pull request assignees": "多个拉取请求受理人",
                        "Assign more than one person to a pull request.": "为拉取请求指派多人受理。",
                    "Repository insights": "仓库洞察",
                        "See data about activity and contributions within your repositories, including trends. You can use this data to improve collaboration and make development faster and more effective.": "查看有关仓库中的活动和贡献数据，包括趋势。您可以利用这些数据来改善协作，使开发更加迅速和有效。",
                    // 定时提醒
                        "Send scheduled messages to you or your team listing open pull requests.": "按计划的向您或您的团队发送信息，列出打开的拉取请求。",
                    "Automatic code review assignment": "自动代码审查分配",
                        "Automatically assign code reviews to members of your team based on one of two algorithms.": "根据两种算法之一，自动为团队成员分配代码审查。",
                    "Environment protection rules": "环境保护规则",
                        "When a workflow job references an environment, the job won't start until all of the environment's protection rules pass.": "当工作流作业引用环境时，只有环境的所有保护规则都通过后，作业才会启动。",
                    "Environment deployment branches and secrets": "环境部署分支和机密",
                        "A job cannot access secrets that are defined in an environment unless it is running on the specified branch.": "除非作业在指定的分支上运行，否则无法访问环境中定义的机密。",

                "Collaboration": "协作",
                    "Collaborators for public repositories": "公共仓库协作者",
                        "Invite any GitHub member, or all GitHub members, to work with you on code in a public repository you control – including making changes and opening issues.": "邀请任何 GitHub 成员或所有 GitHub 成员，在您控制的公共仓库上与您共同处理代码，包括进行更改和提出议题。",
                    "Collaborators for private repositories": "私有仓库协作者",
                        "Invite any GitHub member, or all GitHub members, to work with you on code in a private repository you control – including making changes and opening issues.": "邀请任何 GitHub 成员或所有 GitHub 成员，在您控制的私有仓库上与您共同处理代码，包括进行更改和提出议题。",
                    // 议题
                        "Track bugs, enhancements, and other requests, prioritize work, and communicate with stakeholders as changes are proposed and merged.": "跟踪漏洞、增强功能和其他请求，确定工作的优先级，并在提出和合并变更时与利益相关者沟通。",
                    // 项目
                        "Visualize and manage issues and pull requests across tables, boards, and roadmaps with custom fields and views that you can arrange to suit your workflow.": "通过自定义字段和视图，在表格、面板和路线图上可视化管理议题和拉取请求，以适应您的工作流程。",
                    "Milestones": "里程碑",
                        "Track progress on groups of issues or pull requests in a repository, and map groups to overall project goals.": "跟踪仓库中议题或拉取请求组的进展，并将组映射到整体项目目标。",
                    // 团队讨论
                    "Team discussions": "团队讨论",
                        "Discuss any topic, unattached to a specific project or issue. Control who has access, notify discussion participants with updates, and link from anywhere.": "讨论任何主题，不与特定项目或议题相关。控制访问权限，通知讨论参与者最新情况，并从任何地方进行链接。",
                    "Organization and team management": "组织和团队管理",
                        "Manage access to projects on a team-by-team, or individual user, basis.": "以团队或个人用户为基础管理对项目的访问。",
                    "Pages and wikis": "GitHub Pages 和 Wiki",
                        "Host documentation and simple websites for your project in a wiki format that contributors can easily edit either on the web or command line.": "以 Wiki 格式为您的项目托管文档和简单网站，贡献者可以轻松在网络或命令行上进行编辑。",
                    "Multiple issue assignees": "多个议题受理人",
                        "Assign more than one person to an issue.": "为议题指派多人受理",
                    "GitHub organizations give you team-based access control and discussions.": "GitHub 组织为您提供基于团队的访问控制和讨论。",
                        "Learn more about organizations": "了解更多关于组织的信息",

                "Platform security and compliance": "平台安全性与合规性",
                    "Repository rulesets": "仓库规则集",
                        "Enforce consistent code standards, security, and compliance across branches and tags.": "跨仓库分支和标签，一致的代码标准、安全性和合规性。",
                    // SBOMs
                        "Export a software bill of materials (SBOM) for your repository.": "为仓库导出软件物料清单 (SBOM)。",
                    "Artifact attestations": "附件证明",
                        "Ensure unfalsifiable provenance and integrity for your software.": "确保软件的不可篡改性和完整性。",
                    "GitHub Security Advisories": "GitHub 安全公告",
                    "Role-based access control": "基于角色的访问控制",
                        "Define users' level of access to your code, data and settings.": "定义用户访问代码、数据和设置的级别。",
                    "Required 2FA": "双因素身份验证（2FA）",
                        "Use an extra layer of security with two factor authentication (2FA) when logging into GitHub.": "登录 GitHub 时，使用双因素身份验证（2FA）作为额外的安全层。",
                    // 审计日志
                        "Quickly review the actions performed by members of your organization.": "快速审查组织成员执行的操作。",
                    "Enterprises can connect to advanced systems like LDAP and SAML single sign-on (SSO).": "企业可以连接到如 LDAP 和 SAML 单一登录 (SSO) 等高级系统。",
                        "Learn more about GitHub Enterprise": "了解更多关于 GitHub 企业版的信息。",

                "Marketplace and integrations": "市场和集成",
                    // Github应用
                        "Install apps that integrate directly with GitHub's API to improve development workflows – or build your own for private use or publication in the GitHub Marketplace.": "安装直接与 GitHub API 集成的应用，改进开发工作流程，或创建自己的应用，供个人使用或在 GitHub 市场发布。",
                    "Status checks": "状态检查",
                        "Define tests that GitHub automatically runs against code being committed to your repository, and get details about failures and what is causing them.": "定义 GitHub 针对提交到仓库的代码自动运行的测试，并获取有关失败和失败原因的详细信息。",
                    "Enterprise Server customers create pre-receive hooks to automatically accept or reject a push.": "企业服务器客户创建预接收挂钩，以自动接受或拒绝推送。",
                        "Learn more about pre-receive hooks": "了解更多关于预接收挂钩的信息。",

                "Support and deployment": "支持与部署",
                    "Community Support": "社区支持",
                        "Get help with most of your GitHub questions and issues in our Community Forum.": "在我们的社区论坛中，获取大多数有关 GitHub 问题和议题的帮助。",
                    "Standard Support": "标准支持",
                        "GitHub Support can help you troubleshoot issues you run into while using GitHub. Get support via the web.": "GitHub 支持可帮助您解决使用 GitHub 时遇到的问题。通过网络获取支持。",
                    "Enterprises also get Premium Support, invoice billing, and self-hosted deployment.": "企业还可以获得高级支持、发票计费和自托管部署。",
                       // "Learn more about GitHub Enterprise": "了解更多关于 GitHub 企业版的信息。",

                // 表格中内容
                    "per user/month": "每人/月",
                    "Upgrade to Pro": "升级到专业版",
                    "Unlimited": "无限",
                    "$0 spend limit": "$0 支出限额",
                        "With policies and controls": "带策略及限制",
                    "180 core-hours compute/month and 20GB storage": "每月 180 个核心小时计算和 20GB 存储",
                    "2,000 minutes/month": "2000 分钟/月",
                        "Free for public repositories": "免费用于公共仓库",
                    "3,000 minutes/month": "3,000 分钟/月",
                    "Public repositories": "公共仓库",

        // 组织设置 邀请账单管理员 '/organizations/<org-login>/billing_managers/new'
            "Billing": "账单",
            "/ Add a billing manager": "/ 添加账单管理员",
            "A": " ",
            "billing manager": "账单管理员",
            "is a user who manages the billing settings of your organization.": "是管理您组织的账单设置的用户。",
            "will": "会",
            "will not": "不会",
            "have the ability to:": "具备以下能力：",
                "Change the billing plan": "更改账单计划",
                "Add, update, or remove payment methods": "添加、更新或删除支付方式",
                "View payment history": "查看支付记录",
                "Download, and receive receipts": "下载并接收收据",
                "View a list of billing managers": "查看账单管理员列表",
                "Invite additional billing managers": "邀请其他账单管理员",
                "Remove other existing billing managers": "移除其他现有的账单管理员",
                "Start, modify, or cancel sponsorships": "开始、修改或取消赞助",
            "be able to:": "能够：",
                "Create or access repositories in your organization": "在您的组织中创建或访问仓库",
                "See private members of your organization": "查看您组织的私人成员",
                "Be seen in the list of organization members": "在组织成员列表中可见",
                "Use the organization’s payment method": "使用组织的支付方式",
                "Enable or manage Copilot": "启用或管理 GitHub Copilot",
                "Purchase, edit, or cancel Marketplace subscriptions": "购买、编辑或取消市场订阅",

            "Search by username, full name or email address": "搜索用户名、全名、或电子邮箱",
            "Send invitation": "发送邀请",

            // 加载
            "Loading Actions data...": "加载操作数据…",
            "Loading Packages data...": "加载软件包数据…",
            "Loading Shared Storage data...": "加载共享存储数据…",
            "Loading Codespaces data...": "加载代码空间数据…",
            "Loading usage breakdown…": "正在加载使用明细…",

    },
    "regexp": [ // 正则翻译
        // 高级请求分析（词条打架调整位置） https://github.com/settings/billing/premium_requests_usage
        [/. Monthly limit resets in (\d+) days? on (.+)./, "。将在 $1 天后（$2）重置。"],
        [/Usage for (.+) - (.+). Price per premium request is \$0.04./, (match, p1, p2) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `${translatedP1}-${translatedP2}用量。高级请求价格为 $0.04 / 个。`;
        }],
        [/Per-user breakdown of premium requests in the last 45 days. Sunsetting(.*)\./, (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `过去 45 天内每用户高级请求明细。${translatedDate} 日落`;
        }],

        // billing 概况页面
        [/(?:Gross metered usage|Included usage discounts) for (.+) - (.+).$/, (match, p1, p2) => { // 概况下方小字，过于啰嗦直接省略
            //const translatedP1 = I18N["zh-CN"]["public"]["time-regexp"][p1] || p1;
            //const translatedP2 = I18N["zh-CN"]["public"]["time-regexp"][p2] || p2;
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `${translatedP1}-${translatedP2}`;
        }],
        //[/Included usage discounts for (.+) - (.+)./, (match, p1, p2) => {
        //    const translatedP1 = I18N["zh-CN"]["public"]["time-regexp"][p1] || p1;
        //    const translatedP2 = I18N["zh-CN"]["public"]["time-regexp"][p2] || p2;
        //    return `${translatedP1}-${translatedP2}`;
        //}],
        [/([\d,]+) min used \/ ([\d,]+) min included/, "$1 / $2 分钟"],
        //(\d+) min used \/ ([\d,+]) min included
        [/(\d+) GB used \/ (\d+) GB included/, "$1/$2 GB"],
        // 当前包含用量 - 详情 对话框
            [/Current usage for (.+) - (.+). Monthly quota resets in (\d+) day\(s\)./, (match, p1, p2, p3) => {
                const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
                const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
                return `统计时间段：${translatedP1}-${translatedP2}。本月配额将在${p3}天内重置。`;
            }],
            [/([\d,+]) included Actions minutes \(~(\$\d+\.\d+) off\*\)/, "$1 操作分钟数（~$2 减免*）"],
            [/~(\$\d+\.\d+) off\*/, "~$1 减免*"],
            [/~(\$\d+(\.\d+)?) off/, "~$1 减免"],

            [/([\d,+]) included Actions minutes/, "$1 操作分钟数"],
            [/(\d+) GB included Actions storage/, "$1 GB 操作存储"],
            [/(\d+) GB included Git LFS bandwidth/, "$1 GB Git LFS 带宽"],
            [/(\d+) GB included Git LFS storage/, "$1 GB Git LFS 存储"],
            [/(\d+) GB included Packages data transfer/, "$1 GB 软件包数据传输"],
            [/(\d+) GB included Packages storage/, "$1 GB 软件包存储"],
            [/Discount for usage in public repositories \((\d+%) off\)/, "公共仓库使用折扣（$1 减免）"],
            [/(\d+) GB included Codespaces storage/, "$1 GB 代码空间存储"],
            [/(\d+) included Codespaces core hours/, "$1 代码空间核心小时数"],
            [/(\d+) requests/, "$1 请求"],
            [/Cost calculated based on (\d+) Spark premium requests? that exceed the premium request usage included with your Copilot licenses./, "根据您的 Copilot 许可证中包含的高级请求使用量，计算出 $1 个超出部分的 Spark 高级请求费用。"],

        // 计费用量 - 右上角时间选项
            [/^Timeframe: (Today|Current month|Last month|This year \((\d+)\)|Last year \((\d+)\))$/, (match, p1, p2, p3) => {
                switch (p1) {
                  case 'Today':
                    return '时间段：今天';
                  case 'Current month':
                    return '时间段：本月';
                  case 'Last month':
                    return '时间段：上个月';
                  case `This year (${p2})`:
                    return `时间段：今年（${p2}）`;
                  case `Last year (${p3})`:
                    return `时间段：去年（${p3}）`;
                  default:
                    return match;
                }
            }],
            //Timeframe: Current month
            [/This year \((\d+)\)/, "今年（$1）"],
            [/Last year \((\d+)\)/, "去年（$1）"],
        // 计费用量 - 今天 日期标题
            [/(.+) \(All times in UTC\)/, (match, p1) => {
                const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}（UTC时间）`;
            }],
        // 计费用量图表 数据卡
            [/(Usage|codespaces|actions|Codespaces storage|Codespaces compute 2-core|Actions Windows|Actions macOS 3-core|Actions Linux|Actions storage|All other) (?:[^ ]+), (.+)/, (match, s1, p1) => {
                //const translatedP1 = I18N["zh-CN"]["public"]["time-regexp"][p1] || p1;
                //const translatedP2 = I18N["zh-CN"]["public"]["time-regexp"][p2] || p2;
                var s1Key = {'Usage': '用量','actions': '操作', 'codespaces': '代码空间', 'Codespaces storage': '代码空间存储', 'Codespaces compute 2-core': '代码空间 - 双核','Actions Windows': '操作 Windows', 'Actions Linux': '操作 Linux','Actions macOS 3-core': '操作 macOS 三核','Actions storage': "操作存储",'All other': '其他'};
                const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}` + s1Key[s1];// 星期几暂时省略
            }],
        // 计费用量 - 今天 X轴
            [/(\d+)(AM|PM)/, (match, p1, p2) => {
                // 运行规则：非12AM照搬，PM数字加12，12AM=0
                let hour = parseInt(p1, 10);
                if (p2 === "PM" && hour !== 12) {
                    hour += 12;
                } else if (p2 === "AM" && hour === 12) {
                    hour = 0;
                }
                return `${hour}:00`;
            }],

        // 计费用量 - 按仓库统计
            [/Top (three|four|five) repositories (today|this month|last month|this year|)/, function(all , num, time) {
                var numKey = {"three": "三", "four": "四", "five": "五"}
                var timeKey = {"today": "今天","this month": "这个月","last month": "上个月","this year": "今年","last year": "去年"};
                return timeKey[time] + "排名前" + numKey[num] + "的仓库";
            }],

        // 计费用量 - 底下计算部分
            [/Cost calculated based on additional (\d+) premium requests?/, "费用计算基于额外的 $1 高级请求"],
            [/Cost calculated based on additional (\d+) premium requests for Copilot and Spark./, "费用计算基于 Copilot 和 Spark 的 $1 项额外高级请求。"],
            [/Cost calculated based on additional (\d+) token units/, "费用根据额外的 $1 项令牌单位计算"],

        // [/The plan change was successful. @([^ ]+) has been updated to the pro yearly plan./, "计划变更成功。@$1 已更新为专业版年度计费。"],
        // [/The plan change was successful. @([^ ]+) has been updated to the pro monthly plan./, "计划变更成功。@$1 已更新为专业版月度计费。"],
        // [/We're preparing your report! We’ll send an email to ([^@]+@[^\n]+) when it’s ready./, "我们正在准备您的报告！完成后，我们将发送电子邮件至 $1。"], //顶部提醒
        // [/Included minutes quota resets? in (\d+) days?./, "包含的分钟配额将在 $1 天之内重置"],
        // [/Data transfer quota resets? in (\d+) days?./, "数据传输配额将在 $1 天之内重置"],
        // //[/Included minutes quota resets/, ""],
        // [/Included quotas resets? in (\d+) days?./, "包含的配额将在 $1 天之内重置"],
        // [/Bandwidth quota resets? in (\d+) days?./, "带宽使用配额将在 $1 天之内重置"],
        // [/In addition to your personal account, you manage (\d+) organizations?./, "除了您的个人账户之外，您还管理 $1 个组织。"],
        // [/Leaving it at (\$\d+\.\d{2}) will avoid any extra expenses/, "将其限制在 $1 美元将避免任何额外的费用。"],
        // [/isn’t a GitHub member/, "不是 GitHub 成员"], // 组织设置
        // [/of ([\d,]+\.\d{2}) min included/, "/ $1 分钟"],
        // [/(?:GB )?of ([^ ]+) GB(?: included)?/, "/ $1 GB"],
        // //[/of ([^ ]+) GB( included)?/, "/ $1 GB"],
        // [/of (\d+\.\d{2}) included core hours used/, "/ $1 核心小时数"],
        // [/of (\d+\.\d{2}) included GB-month used/, "/ $1 GB/每月"],
        // [/Last (\d+) days/, "最近 $1 天"],
        // [/Included minutes quota only applies to Ubuntu 2-core, Windows 2-core and macOS 3-core runners\. Windows 2-core and macOS 3-core runners consume included minutes at higher rates\. Your (\d+\.\d+) included minutes used consists of (.*)/, "包含的分钟配额仅适用于双核 Ubuntu、双核 Windows 和三核 macOS 运行器。双核 Windows 和三核 macOS 运行器以更高的速度消耗包括的分钟数。您已使用的 $1 分钟包含分钟数由 $2 组成。"],
        // [/(\$\d+\.\d{2})\/month/, "$1/月"],
        // [/(\$\d+\.\d{2}) off \/ month/, "-$1/月"],
        // [/(\$\d+\.\d{2})\/year/, "$1/年"],
        // [/(\$\d+\.\d{2}) off \/ year/, "-$1/年"],
        // [/(Due by|On|Expires) (.+)/, (match, opt, p1) => {
        //     var optKey = {"Due by": "结算", "On": "开始", "Expires": "到期"};
        //     const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
        //     const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
        //     return `${translatedDate}` + optKey[opt];
        // }],

        // 计费用量 https://github.com/settings/billing/usage + 高级请求分析 https://github.com/settings/billing/premium_requests_usage
            [/^Group(?: by)?: (None|Product|SKU|Repository|Models)$/, function(all, group) {
                var groupKey = {'None': '无','Product': '产品','SKU': 'SKU','Repository': '仓库', 'Models': '模型'};
                return '分组：' + groupKey[group];
            }],
            [/Usage for (.+)./, (match, p1) => {
                const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}`; // 有标题作为上下文，直接省略，只剩日期
            }],
            [/(\d+) min$/, "$1 分"],
            [/([\d,+]\.\d+|[\d,+]) GB-hr/, "$1 GB/时"],
            [/(\d+\.\d+) hr/, "$1 小时"],

        // 使用情况
            [/We're preparing your usage report. It may take ~30 minutes to see usage in your report. We'll send an email to ([^@]+@[^\n]+) when it's ready./, "我们正在准备您的使用报告。可能需要大约 30 分钟。报告准备好后，我们会发送电子邮件到 $1。"],
            [/We're preparing your usage report. We'll send an email to ([^@]+@[^\n]+) when it's ready./, "我们正在准备您的使用报告。报告准备好后，我们会发送电子邮件到 $1。"],
            [/Your usage report request is already in progress. Check ([^@]+@[^\n]+) for the report when it's ready./, "您的使用报告请求正在处理。报告准备好后，请到 $1 查收。"],
            // 获取使用报告窗口
            [/The usage report will be emailed when it's ready to ([^@]+@[^\n]+)./, "使用报告准备好后，将通过电子邮件发送到 $1。"],
              // 传统选项
              //[/Metered usage before the billing transition, until (.+)/, (match, p1) => {
              //  const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
              //  const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
              //  return `计费切换前的计量使用情况，截至${translatedDate}`;
              //}],

        // 账户预算 https://github.com/settings/billing/budgets
            [/(\d+) budgets?/, "$1 预算"],

        // 支付信息 https://github.com/settings/billing/payment_information
            [/(\$\d+\.\d{2}) off per month for (\d+) years/, "每月优惠 $1，为期 $2 年"],
            [/until (.+)./, (match, p1) => {
                const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `直到 ${translatedDate}。`;
            }],

        // 其他账单 https://github.com/settings/billing/subscriptions
            [/In addition to your personal account, you manage (\d+) organizations?./, "除个人账户外，您还可以管理 $1 个组织。"],
            [/([^ ]+) support/, "$1 支持"],
            [/You've cancelled your subscription to (.*). This plan change will take effect on (.*)./, "您已取消对 $1 的订阅。此计划变更将于 $2 生效。"],

        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Billing Overview": "账单概览",
            "Billing Usage": "计费用量",
            "Premium request analytics": "高级请求分析",
            "Budgets": "预算",
            "Billing": "账单",
            "Payment Information": "支付信息",
            "Payment history": "支付历史",
        },
    },
};
I18N["zh-CN"]["account/billing/history"] = I18N["zh-CN"]["settings/billing"];
I18N["zh-CN"]["orgs/settings/billing"] = I18N["zh-CN"]["settings/billing"];
I18N["zh-CN"]["orgs/billing_managers/new"] = I18N["zh-CN"]["settings/billing"];
I18N["zh-CN"]["orgs/billing/history"] = I18N["zh-CN"]["settings/billing"];
I18N["zh-CN"]["orgs/billing/plans"] = I18N["zh-CN"]["settings/billing"];

I18N["zh-CN"]["settings/education/benefits"] = {  // 设置 - 账单和计划（新）- 教育福利
    "static": {
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置

        "GitHub Education": "GitHub 教育",

        "Education Benefits": "教育福利",
            "Complete a teacher or student application to unlock tools and resources for your educational journey.": "完成教师或学生申请，解锁教育旅程所需的工具和资源。",
            //"You have a current student coupon applied.": "您当前已应用学生优惠券。",
            "You have a current student coupon applied. Find more information on your benefits": "您当前已应用学生优惠券。详情查看",
                "here": "这里",
            "Start an application": "申请",
                "You have not submitted an application for education benefits.": "没有申请",

                "Education Benefits Application": "教育福利申请",
                    "Select your role in education: *": "选择您的角色：*",
                        "Teacher": "教师",
                        "Student": "学生",

                        "What is the name of your school? *": "学校名称 *",
                            "If your school is not listed, then enter the full school name and continue. You will be asked to provide further information about your school on the next page. A minimum of two characters is required to find your school.": "如果您的学校未在列表中，请输入完整的学校名称并继续。下一页将要求您提供有关学校的更多信息。查找学校至少需要输入两个字符。",
                            // 提醒设置学校邮箱
                                "We require applicants of": "我们要求申请者",
                                "to use one of these school-issues email addresses to apply:": "使用以下学校发放的电子邮箱地址进行申请：",
                                "add and verify your": "添加并验证您的",
                                "school-issued email address": "学校发放的电子邮箱地址",
                                "in your account settings -- or a contact email if you do not have one. Once your email is verified, you can try applying again.": "在您的账户设置中——若未设置邮箱，请填写联系邮箱。邮箱验证通过后，即可重新尝试申请。",

                        "What is your school email address?": "教育邮箱地址",
                            "Have a different email address you use with your school?": "您是否有其他在校使用的电子邮件地址？",
                            "Add it here.": "添加",

                        "You have verified the email address": "您已验证邮件",
                        "on your GitHub account. This academic domain is associated with the school": "。该域名属于：",
                        "Unselect this school": "取消选择此学校",

                        "Share Location": "位置共享",
                        "Location shared": "位置已共享",
                        "Continue": "继续",

                        "Please select the type of proof you would like to provide *": "请选择您希望提供的证明类型 *",
                        "1. Dated school ID - Good": "1. 注明日期的学校证件 - 完整",
                        "What is a valid proof of education?": "什么是有效的教育证明？",
                        "Good": "完整",
                            "proof requires infinite academic affiliation documentation most likely to help you be approved.": "的证明需要详尽的学术关系文件，以最大限度地帮助您通过审核。",
                        "For": "部分",
                            "proof types may lower your chances of being approved.": "证明类型可能会降低您的审核通过概率。",
                        "Poor": "无效",
                            "proof types are unlikely to be acceptable.": "的证明类型通常无法被接受。",

                        "There was an error creating the discount request. Errors: Discount request could not be created. Discount request errors: School email must be verified on your GitHub account": "创建折扣请求时出错。错误信息：无法创建折扣请求。折扣请求错误：学校邮箱必须在您的 GitHub 账户中完成验证",

                "Application Type:": "申请类型：",

            "Approved": "批准",
                // 等待
                    "Coupon applied": "优惠券已应用",
                    "Expires in almost 2 years": "有效期大约 2年",
                    "Your academic status has been verified. Congratulations!": "您的学术状态已验证。恭喜！",
                    "Your academic benefits, including Partner offers, will become available after 72 hours of your verification.": "您的学术福利，包括合作伙伴优惠，将在您资格审核通过后的 72 小时内生效。",
                    "Once the benefits become available, you will be able to access the Students Developer Pack offers": "权益生效后，您将可以访问学生开发者礼包优惠在",
                    "To redeem your Copilot Pro coupon, please sign up via this": "要兑换您的 Copilot Pro 优惠券，请访问此",
                    "link": "链接",
                    "We hope you enjoy your GitHub Education benefits.": "希望您享受 GitHub 教育权益。",
                // 结束
                    "Congratulations! Your application has been approved and the coupon code has been applied to your account.": "恭喜！您的申请已获批准，优惠码已成功应用到您的账户。",
                    "Please visit the": "请访问",
                    "Developer Pack": "开发者包",
                    "page to view your benefits.": "页面查看您的权益。",
                "Your benefits will expire on": "您的福利过期时间：",
            "Loading details": "加载详情",
            "Revoked": "撤销",
            "Denied": "拒绝",
                "Reason(s):": "拒绝原因：",

                    "Please complete your": "请完善您的",
                    "GitHub billing information": "GitHub 账单信息",
                    "with your full name exactly as it appears in your academic affiliation document. You do not have to add a payment method. You may need to log out and log back in to GitHub before reapplying. If you have only a single legal name, enter it in both the first and last name fields.": "，并确保其中的姓名与您学籍证明文件中的姓名完全一致。您无需添加支付方式。您可能需要先登出 GitHub，然后重新登录后再申请。如果您只有一个法定姓名，请在名字和姓氏字段中填写相同的姓名。",

                    "You are unlikely to be verified until you have completed your": "在您用学籍证明文件上的全名完善",
                    "GitHub user profile": "GitHub 用户资料",
                    "with your full name exactly as it appears in your academic affiliation document. Please do not use a variation of your name or a nickname. Once you have updated your profile information log out and log back into GitHub before re-applying.": "之前，您不可能通过验证。请不要使用姓名的变体或昵称。更新资料信息后，请先登出 GitHub，然后重新登录后再申请。",
    },
    "regexp": [
        [/Submitted(?: about)? (.+)/, (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `提交于 ${translatedDate}`;
        }],
        [/Expires in almost (\d+) years?/, "有效期大约 $1 年"],
    ],
};

I18N["zh-CN"]["settings/emails"] = { // 设置 - 电子邮箱
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Emails 电子邮箱 https://github.com/settings/emails
            // 黄框警告
                "You have a single verified email associated with your GitHub account. Add an additional verified email address in case you lose access to your primary email.": "您的 GitHub 账户只有一个经过验证的电子邮箱。添加另一个经过验证的电子邮箱地址吧，那样即使主电子邮箱无法使用也不要紧。",
            // 顶部提示信息
                "Emails you can use to sign in to your account. Verified emails can be used as the author or committer addresses for web-based Git operations, e.g. edits and merges.":"可用于登录账户的电子邮箱。经过验证的电子邮箱可以用作基于网页的 Git 操作（如编辑和合并）的作者或提交者地址。",
            // [/Emails you can use to sign in to your account. Your emails will not be used as the 'from' address for web-based Git operations, e.g. edits and merges. All web-based Git operations will be linked to ([^@]+@users.noreply.github.com)/, "可用于登录账户的电子邮箱。这些邮箱不会用作基于网页的 Git 操作（如编辑和合并）的 “发件人” 地址。所有基于网页的 Git 操作都将关联至 $1。"],

            "Primary": "主账户",
                "Backup": "备用",
                "This email address is the default for GitHub notifications, such as replies to issues, pull requests, and similar activity.": "此电子邮箱地址是 GitHub 通知的默认地址，例如对议题、拉取请求和类似活动的回复。",
                // [/Manage email/, "管理邮箱地址"],
                "Manage email preferences": "管理电子邮件首选项",
                "Resend verification email": "重新发送验证邮件",
                // 删除按钮 提醒信息
                    "Are you sure you want to remove this email from your account? Once removed, commits attributed to this email address will no longer be associated with your account.": "您确定要从账户中移除此邮箱吗？移除后，该邮箱地址关联的提交记录将不再与您的账户关联。。",
                    "Are you sure you want to remove this email from your account? Once removed, commits attributed to this email address will no longer be associated with your account. One of your other emails will become your primary address.": "您确定要从账户中移除此邮箱吗？移除后，该邮箱地址关联的提交记录将不再与您的账户关联。您其他邮箱中的一个将自动成为主要地址。",
                    "At least one email is required.": "至少需要一个电子邮箱。",
                    "At least one verified email is required.": "至少需要一个已验证的电子邮箱。",
                    // 顶部提醒
                        // [/Removed email ([^@]+@[^\n]+) from your account./, "已将邮箱 $1 从您的账户中移除。"],

            "Add email address": "添加电子邮箱",
                "Email address": "电子邮箱",
                    // 顶部提醒
                        // [/We sent a verification email to ([^@]+@[^\s]+)\. Please follow the instructions in it\./, "我们已向 $1 发送了验证邮件，请登录邮箱已完成验证。"],

            "Primary email address": "主电子邮箱",
                "Select an email to be used for account-related notifications and can be used for password reset.": "选择用于帐户相关通知的电子邮件地址，并可用于密码重置。",
                // 顶部提醒
                    "Your primary email was changed to": "您的主电子邮箱已更改为",
                    ". Your default notification email address is still set to": "。您的默认通知电子邮箱仍然设置为",
                    ". Would you like to update that as well?": "。您也想更新它吗？",
                    "Yes, update my notification email": "是的，更新我的通知电子邮箱",

            "Backup email address": "备用电子邮箱",
                "Your backup GitHub email address will be used as an additional destination for security-relevant account notifications and can also be used for password resets.": "您的备用 GitHub 电子邮箱将用作接收账户安全相关通知的额外方式，也可以用于密码重置。",
                    "Allow all verified emails": "允许所有已验证的电子邮箱",
                        // 顶部提醒
                            "All verified emails can now be used for password resets.": "所有已验证的电子邮箱现在均可用于密码重置。",
                    "Only allow primary email": "仅允许主电子邮箱",
                        // 顶部提醒
                            "Only your primary email address can now be used for password resets.": "现在只有您的主电子邮箱可用于密码重置。",

            "Keep my email addresses private": "保持我的电子邮箱地址的私密性",
                "We’ll remove your public profile email and use": "我们将删除您的公开个人资料中的电子邮箱，并使用",
                "when performing web-based Git operations (e.g. edits and merges) and sending email on your behalf. If you want command line Git operations to use your private email you must": "执行基于 Web 的 Git 操作（例如：编辑和合并）并以您的名义发送电子邮件。如果您想在命令行 Git 操作中使用您的私人电子邮箱，您必须",
                "set your email in Git": "在 Git 中设置您的电子邮箱",
                "Previously authored commits associated with a public email will remain public.": "以前创建的与公共电子邮件相关的提交将保持公开状态。",
                "Off": "禁用",
                "On": "启用",

                // 顶部提醒
                    "Your primary email address is now public. To select which email to display on your profile, visit": "您的主电子邮箱地址现已公开。要选择在您的个人资料中显示哪个电子邮箱，请访问",
                    "profile settings.": "个人资料设置。",
                    "Your primary email address is now private. If you previously made your email public, we’ve removed it from your profile.": "您的主电子邮箱地址现已设为私密。如果您以前公开过您的电子邮箱，我们已经从您的个人资料中删除了它。",

            "Block command line pushes that expose my email": "阻止在命令行推送中暴露我的电子邮箱",
                "When you push to GitHub, we’ll check the most recent commit. If the author email on that commit is a private email on your GitHub account, we will block the push and warn you about exposing your private email.": "当您推送到 GitHub 时，我们会检查最近的提交。如果该提交的作者电子邮箱是您 GitHub 账户上的私人电子邮箱，我们会阻止推送并警告您不要暴露您的私人电子邮箱。",
                // 顶部提醒
                    "Commits pushed with a private email will no longer be blocked.": "使用私人电子邮箱推送的提交将不再被阻止。",
                    "Commits pushed with a private email will now be blocked and you will see a warning.": "使用私人电子邮箱推送的提交将被阻止，您会看到一个警告。",

        // 订阅偏好 https://github.com/settings/emails/subscriptions
            "Subscription preferences for": "订阅首选项",
            "⏳Please wait while we find your subscriptions...⌛": "⏳请稍候，我们正在查找您的订阅...⌛",
            "No subscriptions found": "未找到订阅信息",
            "Save subscription preferences": "保存订阅首选项",
            "Back to email settings": "返回电子邮件设置",
            "To stop receiving emails for the topics below, uncheck any topics you don't want to receive, then click Save subscription preferences": "要停止接收以下主题的电子邮件，请取消选中您不想接收的任何主题，然后单击保存订阅首选项",
            "General info and offers from GitHub": "GitHub 上的一般信息和优惠",
                "Get tips, solutions and exclusive offers from GitHub about products, services and events we think you might find interesting.": "从 GitHub 获取有关我们认为您可能感兴趣的产品、服务和活动的提示、解决方案和独家优惠。",
            "Unsubscribe from all topics": "取消订阅所有主题",

    },
    "regexp": [ // 正则翻译
        [/Emails you can use to sign in to your account. Your emails will not be used as the 'from' address for web-based Git operations, e.g. edits and merges. All web-based Git operations will be linked to ([^@]+@users.noreply.github.com)./, "可用于登录账户的电子邮箱。该邮箱不会用作基于网页的 Git 操作（如编辑和合并）的 “发件人” 地址。所有基于网页的 Git 操作都将关联至 $1。"],
        [/Manage email/, "管理邮箱地址"],
        [/We sent a verification email to ([^@]+@[^\s]+)\. Please follow the instructions in it\./, "我们已向 $1 发送了验证邮件，请登录邮箱已完成验证。"],
        [/Your primary email was changed to ([^@]+@[^\n]+)\./, "您的主电子邮箱已更改为 $1"],
        [/Subscription preferences for ([^@]+@[^\n]+)/, "$1 的订阅偏好"],
        [/Removed email ([^@]+@[^\n]+) from your account./, "已将邮箱 $1 从您的账户中移除。"],
    ],
    "title": {
        "static": {
            "Email settings": "邮箱设置",
        },
    },
};

I18N["zh-CN"]["settings/security"] = { // 设置 - 密码和身份身份验证
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["confirm-access"]["static"],

        // 密码和身份身份验证 - 账户安全 https://github.com/settings/security
            "Change password": "更改密码",
            "Old password": "旧密码",
            "New password": "新密码",
            "Confirm new password": "确认新密码",
            "Make sure it's": "请确保",
            "at least 15 characters": "至少需要15个字符",
            "OR": " 或者",
            "at least 8 characters": "至少需要8个字符",
            "including a number": "包括数字",
            "and a lowercase letter": "和小写字母",
            "Password is too short (minimum is 8 characters)": "密码太短（最少8个字符）",
            "Password is too short (minimum is 8 characters), needs at least 1 lowercase letter, and is in a list of passwords commonly used on other websites": "密码太短（最少8个字符），至少需要1个小写字母，而且已在其他网站常用密码列表中",
            "Password is too short (minimum is 8 characters), needs at least 1 lowercase letter, cannot include your login, and is in a list of passwords commonly used on other websites": "密码太短（最少为8个字符），至少需要1个小写字母，而且不能包括您的登录名，以及在其他网站常用的密码列表中。",
            "Password is too short (minimum is 8 characters), needs at least 1 number, cannot include your login, and is in a list of passwords commonly used on other websites": "密码太短（最少8个字符），需要至少1个数字，不能包含您的登录名，以及在其他网站常用的密码列表中",
            "Password is too short (minimum is 8 characters) and is in a list of passwords commonly used on other websites": "密码太短（最少为8个字符），而且已在其他网站常用的密码列表中。",
            "Password needs at least 1 lowercase letter and is in a list of passwords commonly used on other websites": "密码需要至少 1 个小写字母，而且已在其他网站常用的密码列表中",
            "Password is in a list of passwords commonly used on other websites": "密码在其他网站常用的密码列表中",
            "Update password": "更新密码",
            "I forgot my password": "我忘记了我的密码",

            "Strengthen your account by ensuring your password is strong.": "确保密码的安全性，以保护您的账户。",
            "Learn more about creating a strong password": "了解更多关于创建强密码的信息",

            "Passkeys": "通行密钥",
                "Passwordless sign-in with passkeys": "使用通行密钥进行无密码登录",
                "Passkeys are webauthn credentials that validate your identity using touch, facial recognition, a device password, or a PIN. They can be used as a password replacement or as a 2FA method. Passkeys can be used for sign-in as a simple and secure alternative to your password and two-factor credentials.": "通行密钥是一种 WebAuthn 凭证，可以使用触摸、面部识别、设备密码或 PIN 码验证您的身份。它们可以作为密码替代品或作为双因素身份验证（2FA）方法使用。通行密钥可以作为一种简单且安全的替代方式用于登录，替代您的密码和双因素身份验证凭证。",
                "This browser or device does not fully support passkeys - you may be able to use a passkey from another device.": "此浏览器或设备不完全支持通行密钥 - 您可以尝试使用来自其他设备的通行密钥。",
                "This browser or device is reporting partial passkey support, but you may be able to use a passkey from a nearby device.": "此浏览器或设备不完全支持通行密钥 - 您可以尝试使用来自其他设备的通行密钥。",
                "Add a passkey": "添加通行密钥",

                "Passkeys are webauthn credentials that validate your identity using touch, facial recognition, a device password, or a PIN. They can be used as a password replacement or as a 2FA method.": "通行密钥是一种 WebAuthn 凭证，可以使用触摸、面部识别、设备密码或 PIN 码验证您的身份。它们可以作为密码替代品或作为双因素身份验证（2FA）方法使用。",
                "Learn more about passkeys": "了解更多关于通行密钥的信息",

                "Your passkeys": "您的通行密钥",
                "Edit passkey nickname": "编辑通行密钥昵称",
                // [/Delete `([^ ]+)` passkey/, "删除 “$1” 通行密钥"],

                // 删除密钥对话框
                    "Delete passkey?": "删除通行密钥？",
                    // [Are you sure you want to delete your `([^ ]+)` passkey?/, "您确定要删除您的 “$1” 通行密钥吗？"],
                    "You will no longer be able to use it to sign-in to your account.": "您将无法再使用它登录您的账户。",
                    "Note: You may continue to see this passkey as an option during sign-in until you also delete it from your browser, device or associated account's password management settings.": "注意：您可能会在登录过程中继续看到此通行密钥作为一个选项，直到您将其从浏览器、设备或关联账户的密码管理设置中删除。",
                    "Deleting…": "删除中…",

            // Google
                "1 account connected": "已连接 1 个帐户",
                "Google sign in method dropdown": "Google 登录方法下拉菜单",

            // 双因素身份验证
                // 顶部提醒
                    "You can now manage your two-factor authentication methods from this page.": "您现在可以从此页面管理您的双因素身份验证方法。",
                    "Two-factor authentication successfully disabled.": "成功禁用双因素身份验证。",
                    "SMS/Text message successfully configured.": "短信/文本信息配置成功。",
                    "Authenticator app successfully reconfigured.": "验证器重配置成功。",

            "Sign in methods": "登录方式",
                "Email": "电子邮件", // 下行内容走正则
                    "Manage": "管理",
                // 通行密钥
                    "Passwordless sign-in with biometrics or security keys": "使用生物识别或安全密钥进行无密码登录",
                    "Add passkey": "添加通行密钥",
                    "Seen from this browser": "在此浏览器中可见",
                    "Synced": "已同步",
                // Google
                    "Sign in with your Google account": "使用 Google 账户登录",
                    "Connect": "连接",
                // Apple
                    "Sign in with your Apple account": "使用 Apple 账户登录",

            "Two-factor authentication": "双因素身份验证",
                "Two-factor authentication is not enabled yet.": "尚未启用双因素身份验证。",
                "Enable two-factor authentication": "启用双因素身份验证",

                "Because of your contributions on GitHub, two-factor authentication is required for your account. Thank you for helping keep the ecosystem safe!": "基于您在 GitHub 上的贡献，您的账户需要双因素身份验证。感谢您帮助维护生态系统安全！",
                "Because of your contributions on GitHub, two-factor authentication will be required for your account starting": "基于您在 GitHub 上的贡献，从",
                ". Thank you for helping keep the ecosystem safe!": " 开始，您的账户将需要双因素身份验证，感谢您帮助维护生态系统的安全！",
                "Learn more about our two-factor authentication initiative": "了解更多关于我们的双因素身份验证的倡议",

                "Two-factor authentication adds an additional layer of security to your account by requiring more than just a password to sign in.": "双因素身份验证不仅仅要求密码登录，还为您的账户增加了一层额外的安全性。",
                "Learn more about two-factor authentication": "了解更多关于双因素身份验证的信息",


                "Enable": "启用",
                "Enabled": "启用",
                    "Two-factor authentication is required for at least one organization or enterprise account you're affiliated with.": "至少有一个您所属的组织或企业账户需要进行双因素身份验证。",
                "Disable": "停用",

            "Preferred 2FA method": "首选 2FA 方法",
                "Set your preferred method to use for two-factor authentication when signing into GitHub.": "设置登录 GitHub 时用于双因素身份验证的首选方法。",
                "Passkeys should be used primarily for standalone, password-less authentication.":"通行密钥应主要用于独立的无密码身份验证。",

            "Two-factor methods": "双因素身份验证方式",
                "Configured": "已配置",

                "Authenticator app": "身份验证器应用",
                    "Use an authentication app or browser extension to get two-factor authentication codes when prompted.": "在出现提示时，使用身份验证器应用或浏览器扩展获取双因素身份验证码。",
                    "Use an authentication app or browser extension to generate one-time codes.": "使用身份验证应用或浏览器扩展生成一次性代码。",

                    "Manage Authenticator app": "管理身份验证器应用",

                    "Authenticator apps and browser extensions like": "身份验证器应用和浏览器扩展，例如",
                    ", etc. generate one-time passwords that are used as a second factor to verify your identity when prompted during sign-in.": "等生成一次性密码，在登录过程中出现提示时用作第二验证因素来验证您的身份。",

                    "Scan the QR code": "扫描二维码",
                    "Re-scan the QR code": "重新扫描二维码",
                    "Use an authenticator app or browser extension to scan.": "请使用身份验证器应用或浏览器扩展进行扫描。",
                    "Learn more about enabling 2FA": "了解更多关于启用 2FA 的信息",

                    "Unable to scan? You can use the": "无法扫描？您可以使用",
                    "setup key": "设置密钥",
                    "to manually configure your authenticator app.": "手动配置您的身份验证器应用。",
                        "Your two-factor secret": "您的双因素密钥",

                    "Verify the code from the app": "验证来自身份验证器应用的验证码",
                    "Two-factor code verification failed. Please try again.": "双因素身份验证码验证失败。请重试。",

                "SMS/Text message": "短信/文字信息",
                    "Manage SMS/Text message": "管理短信/文字信息",
                    "Less secure": "不安全",

                    "Get one-time codes sent to your phone via SMS to complete authentication requests. We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. It is recommended to use an Authenticator app instead of SMS.": "通过短信向您的手机送达一次性验证码，以完成身份验证请求。我们强烈建议不要使用短信，因为短信容易受到拦截，无法抵御钓鱼攻击，且送达率可能不可靠。建议使用身份验证器应用代替短信。",

                    "Get authentication codes by SMS on your mobile phone when signing into GitHub. Make sure that": "登录 GitHub 时通过手机短信获取验证码。确保",
                    "your country or region is supported": "支持您的国家/地区",
                    "for SMS delivery.": "用于短信发送。",

                    "Verify account": "验证账户",
                    "Before setting up SMS, please verify that you're a human.": "在设置短信之前，请验证您是人类。",

                    "Country or region code": "国家/地区代码",
                    "Your phone number": "您的手机号码",
                    "Send authentication code": "发送验证码",

                    "Sent. It may take a minute for the SMS to arrive.": "已发送。短信可能需要一分钟时间才能送达。",
                    "Verify the code sent to your phone": "验证发送到您手机的验证码",

                    // [/We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. Instead, we recommend configuring an authenticator app and disabling SMS as a 2FA method. You will receive one-time codes at this phone number:/, "我们强烈建议不要使用短信，因为短信容易受到拦截，无法抵御钓鱼攻击，而且送达率可能不可靠。相反，我们建议配置一个身份验证器应用，并禁用短信作为双因素身份验证。您将通过以下电话号码收到一次性验证码："], // 已设置短信/文字信息

                    // 顶部提醒
                        "SMS/Text message successfully disabled.": "短信/文字消息已成功禁用。",

                "Security keys": "安全密钥",
                    "Security keys are webauthn credentials that can only be used as a second factor of authentication.": "安全密钥是 WebAuthn 凭证，只能用作第二验证因素。",
                    "Hide": "隐藏",
                    "No security keys": "没有安全密钥",

                    "Register new security key": "注册新安全密钥",
                    "Enter a nickname for this security key": "输入安全密钥的昵称",
                    "Waiting for input from browser interaction...": "等待来自浏览器交互的输入…",
                    "Security key registration failed.": "安全密钥注册失败。",
                    "Try again": "请重试",

                "GitHub Mobile": "GitHub Mobile",
                    "GitHub Mobile can be used for two-factor authentication by installing the GitHub Mobile app and signing in to your account.": "通过安装 GitHub Mobile 应用并登录账户，可以使用 GitHub Mobile 来进行双因素身份验证。",
                    "Manage GitHub Mobile": "管理 GitHub Mobile",

                    // [/(\d+) devices?/, "$1 设备"], // 设置--> 密码和身份验证页
                    "Show": "显示",

            "Recovery options": "恢复选项",
                "Your two-factor authentication recovery codes have not been downloaded or printed in the last one year. Make sure your recovery codes are up-to-date by viewing and downloading or printing them again.": "您的双因素身份验证恢复码在过去一年中未被下载或打印。请通过查看并再次下载或打印恢复码，确保您的恢复码是最新的。",

                "Recovery codes": "恢复码",
                    "Recovery codes can be used to access your account in the event you lose access to your device and cannot receive two-factor authentication codes.": "恢复码可用于在您无法访问设备且无法接收双因素身份验证码的情况下访问您的账户。",
                    "Viewed": "已查看",

    },
    "regexp": [ // 正则翻译
        [/(\d+) devices?/, "$1 个设备"], // 设置--> 密码和身份验证页
        [/We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. Instead, we recommend configuring an authenticator app and disabling SMS as a 2FA method. You will receive one-time codes at this phone number:/, "我们强烈建议不要使用短信，因为短信容易受到拦截，无法抵御钓鱼攻击，而且送达率可能不可靠。相反，我们建议配置一个身份验证器应用，并禁用短信作为双因素身份验证。您将通过以下电话号码收到一次性验证码："], // 已设置短信/文字信息
        [/Delete `([^ ]+)` passkey/, "删除 “$1” 通行密钥"],
        [/Are you sure you want to delete your `([^ ]+)` passkey?/, "您确定要删除您的 “$1” 通行密钥吗？"],
        [/(\d+) verified emails? configured/, "已配置 $1 个已验证的邮箱"],
        // 1 passkey configured
        [/(\d+) passkeys? configured/, "已配置 $1 个通行密钥"],
        [/Added (.*) \| Last used (.*)/, (match, p1, p2) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const dateAdded = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const dateLastUsed = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `添加于 ${dateAdded} | 最后使用 ${dateLastUsed}`;
        }]
    ],
    "title": {
        "static": {
            "Account security": "账户安全",
        },
    },
};

I18N["zh-CN"]["settings/auth"] = {
    "static": { // 静态翻译

        // 查看恢复码 https://github.com/settings/auth/recovery-codes
            // 顶部提醒
                "New two-factor recovery codes successfully generated. Save them in a safe, durable location and discard your previous codes.": "已成功生成新的双因素身份验证恢复码。将它们保存在安全、耐用的位置，并丢弃以前的恢复码。", // 生成新恢复码

            "Two-factor recovery codes": "双因素身份验证恢复码",
                "Recovery codes can be used to access your account in the event you lose access to your device and cannot receive two-factor authentication codes.": "恢复码可用于在您无法访问设备且无法接收双因素身份验证码的情况下访问您的账户。",
                "Your two-factor authentication recovery codes have not been downloaded or printed in the last one year. Make sure your recovery codes are up-to-date by downloading or printing them again.": "您的双因素身份验证恢复码在过去一年中没有下载或打印过。请重新下载或打印恢复代码，确保您的恢复代码是最新的。",

            "Recovery codes": "恢复码",
                "Keep your recovery codes as safe as your password. We recommend saving them with a password manager such as": "保持您的恢复码与您的密码一样安全。我们建议使用密码管理器保存它们，例如",
                "Keep your recovery codes in a safe spot.": "将您的恢复码保存在一个安全的地方。",
                "These new codes have replaced your old codes. Save them in a safe spot.": "这些新恢复码已取代您的旧恢复。请将它们保存在安全的地方。", // 生成新恢复码
                "These codes are the last resort for accessing your account in case you lose your password and second factors. If you cannot find these codes, you": "这些恢复码是在您丢失密码和第二验证因素的情况下访问您账户的最后手段。如果您找不到这些恢复码，您",
                "will": "将",
                "lose access to your account.": "无法访问您的账户。",

                "Print": "打印",

            "Generate new recovery codes": "生成新恢复码",
                "When you generate new recovery codes, you must download or print the new codes.": "当您生成新恢复码时，您必须下载或打印新恢复码。",
                "Your old codes won't work anymore.": "您的旧恢复码将失效。",

            "Back to settings": "返回设置",
    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["settings/sessions"] = {
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 会话详情 https://github.com/settings/sessions
            "Web sessions": "网络会话",
            "GitHub Mobile can be used to verify your identity when signing in from a new device and as a two-factor authentication method.": "GitHub Mobile 可用于从新设备登录时验证您的身份，并作为一种双因素身份验证方法。",
            "Learn more about authentication with GitHub Mobile.": "了解更多关于 GitHub Mobile 身份验证的信息。",
            "To get started, install GitHub Mobile for": "首先，安装 GitHub Mobile 适用于",
            "and sign in to your account.": "并登录您的账户。",

            "This is a list of devices that have logged into your account. Revoke any sessions that you do not recognize.": "这是已登录您账户的设备列表。 撤销任何您不认识的会话。",
            "See more": "查看更多",
            "Your current session": "您当前的会话",
            "Last accessed on": "最后访问日期：",
            "active": "激活",
            "stale": "闲置",

            "GitHub Mobile sessions": "GitHub Mobile 会话",
            "This is a list of devices that have logged into your account via the GitHub Mobile app. Revoke any session that you do not recognize or you can": "这是已通过 GitHub Mobile 应用登录到您账户的设备列表。撤销任何您不认识的会话，或者您可以",
            "revoke": "撤消",
            "your GitHub Mobile app authorization to sign out of all your devices.": "您的 GitHub Mobile 应用授权，以登出您的所有设备。",
            "Revoke": "撤消",
            "Registered -": "注册于 -",
            "Last accessed -": "最后访问 -",
            "Last used for authentication -": "最后一次认证 -",
            "Never used": "未使用",

        // 会话详情 https://github.com/settings/sessions/<id>
            "Session details": "会话详情",
            "Revoke session": "撤销会话",
            "Device:": "设备：",
            "Last location:": "最后的位置：",
            "Signed in:": "登录：",
            "View all sessions": "查看所有会话",
    },
    "regexp": [ // 正则翻译
        [/Seen in/, "登录于"],
    ],
    "title": {
        "static": {
            "Sessions": "会话",
        },
    },
};

I18N["zh-CN"]["settings/keys"] = { // 设置 - SSH 与 GPG 公钥
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // SSH and GPG keys SSH 与 GPG 公钥 https://github.com/settings/keys
            "SSH keys": "SSH 密钥",
            "New SSH key": "新建 SSH 密钥",
            "Authentication keys": "认证密钥",
            "Signing keys": "签名密钥",
            "Signing": "签名",
            "There are no SSH keys associated with your account.": "没有与您的账户关联的 SSH 密钥。",
            "This is a list of SSH keys associated with your account. Remove any keys that you do not recognize.": "这是与您的账户相关的 SSH 密钥的列表。删除任何您无法识别的密钥。",
            "Never used": "从未使用",
                "— Read/write": "- 读写",
            "Last used within the last week": "上周内最后一次使用",
            "Check out our guide to": "请看我们的指南",
            "connecting to GitHub using SSH keys": "使用 SSH 密钥连接到 GitHub",
            "or troubleshoot": "或解决",
            "common SSH problems": "常见的 SSH 问题",

            "GPG keys": "GPG 密钥",
            "New GPG key": "新建 GPG 密钥",
            "There are no GPG keys associated with your account.": "没有与您的账户关联的 GPG 密钥。",
            "This is a list of GPG keys associated with your account. Remove any keys that you do not recognize.": "这是与您的账户相关的 GPG 密钥的列表。删除任何您无法识别的密钥。",

            "Email address:": "电子邮件地址：",
            "Key ID:": "密钥 ID：",
            "Subkeys:": "子密钥：",
            "Added": "添加于",

            "Learn how to": "了解如何",
            "generate a GPG key and add it to your account": "生成 GPG 密钥并将其添加到您的账户",

            "Vigilant mode": "警戒模式",
            "Flag unsigned commits as unverified": "将未签名的提交标记为未验证",
            "This will include any commit attributed to your account but not signed with your GPG or S/MIME key.": "这将包括任何归属于您的账户但没有用您的 GPG 或 S/MIME 密钥签名的提交。",
            "Note that this will include your existing unsigned commits.": "请注意，这将包括您现有的未签名的提交。",
            "Learn about vigilant mode": "了解警戒模式",

            // SSH 密钥删除 对话框
            "Are you sure you want to delete this SSH key?": "您确定要删除此 SSH 密钥吗？",
            "This action": "该操作",
            "CANNOT": "不能",
            "be undone. This will permanently delete the SSH key and if you’d like to use it in the future, you will need to upload it again.": "被撤销。这将永久地删除 SSH 密钥，如果您想在未来使用它，您将需要再次上传它。",
            "I understand, delete this SSH key": "我明白了，删除此 SSH 密钥",

            // GPG 密钥删除 对话框
            "Are you sure you want to delete this GPG key?": "您确定要删除此 GPG 密钥吗？",
            "be undone. This will permanently delete the GPG key, and if you’d like to use it in the future, you will need to upload it again.": "被撤销。这将永久地删除 GPG 密钥，如果您想在未来使用它，您将需要再次上传它。",
            "Any commits you signed with this key will become unverified after removing it.": "删除后，您使用此密钥签名的任何提交都将变成未验证。",
            "Commits you signed with this key may become unverified after removing it.": "移除此密钥后，您使用它签署的提交可能会变为未验证状态。",
            "Learn more about persistent commit signature verification.": "了解更多关于持久性提交签名验证的信息。",
            "I understand, delete this GPG key": "我明白了，删除此 GPG 密钥",
            "Okay, you have successfully deleted that key.": "好的，您已成功删除该密钥。",
            "cannot": "不能",

            // 顶部提醒
            "Key is invalid. You must supply a key in OpenSSH public key format": "密钥无效。您必须提供 OpenSSH 公钥格式的密钥",
            "We got an error doing that.": "我们在这样做时出错了。",
            "We got an error adding your GPG key. Please verify the input is a valid GPG key.": "添加您的 GPG 密钥时出错。请确认输入的是有效的 GPG 密钥。",

    },
    "regexp": [ // 正则翻译
        [/You have successfully added the key \'([^ ]+)\'./, "成功添加密钥 “$1”。"],
        [/Last used within the last (\d+) weeks?/, "$1 周内最后一次使用"],
    ],
    "title": {
        "static": {
            "SSH and GPG keys": "SSH 和 GPG 密钥",
        },
    },
};

I18N["zh-CN"]["settings/ssh"] = { // 设置 - SSH 与 GPG 公钥 - 添加 SSH 公钥
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 添加 SSH 公钥 https://github.com/settings/ssh/new
            "Add new SSH Key": "添加新 SSH 密钥",
            "Title": "标题",
            "Key type": "密钥类型",
                "Authentication Key": "认证密钥",
                "Signing Key": "签名密钥",
            "Key": "密钥",
            "Add SSH key": "添加 SSH 密钥",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["settings/gpg"] = { // 设置 - SSH 与 GPG 公钥 - 添加 GPG 公钥
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 添加 GPG 公钥 https://github.com/settings/gpg/new
            "Add new GPG key": "添加新 GPG 密钥",
            "Title": "标题",
            "Key": "密钥",
            "Add GPG key": "添加 GPG 密钥",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["settings/organizations"] = { // 设置 - 组织
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Organizations 组织 https://github.com/settings/organizations
            "You are not a member of any organizations.": "您暂无任何组织。",

            "Owner": "所有者",
            "Member": "成员",
            "Compare plans": "比较计划",
            "Leave": "离开",
            "Leave organization":"离开组织",

            "Transform account": "账户变更",
            "You cannot transform this account into an organization until you leave all organizations that you’re a member of.": "在您离开您所属的所有组织之前，您无法将此账户转换为组织。", // 存在所属组织时
            "You cannot transform this account into an organization because you have an active GitHub Sponsors account.": "由于您有一个活跃的 GitHub 赞助者账户，因此您无法将此账户转换为组织。", // 存在赞助者账户时
            "Account Transformation Warning": "账户变更警告",
            "What you are about to do is an irreversible and destructive process. Please be aware:": "这将是一个不可逆转的过程，请确认：",
            "Any user-specific information (OAuth tokens, SSH keys, Job Profile, etc) will be erased": "任何用户特定的信息（OAuth 令牌, SSH 密钥, 职位简介, 等）将被删除。",
            "You will no longer be able to create or modify gists owned by the converted personal account": "您将无法再创建或修改已转换的个人账户所拥有的代码片段",
            "create a new personal account": "创建一个新的个人账户",
            "The total amount of collaborators across private repositories will be the total amount of seats for the organization": "跨私人仓库的协作者总数将是该组织的席位总数",

    },
    "regexp": [ // 正则翻译
        [/Turn ([^ ]+) into an organization/, "变更 $1 为组织"],
        [/You will no longer be able to sign in to ([^ ]+) \(all administrative privileges will be bestowed upon the owners you choose\)/, "您将无法再登录 $1（所有管理权限都将授予您选择的所有者）"],
        [/Any commits and comments credited to ([^ ]+) will no longer be linked to this GitHub account/, "任何归功于 $1 的提交和评论将不再与此 GitHub 账户相关联"],
        [/Any GitHub Apps installed on ([^ ]+) will be uninstalled/, "$1 上安装的任何 GitHub 应用程序都将被卸载"],
        [/If you are using ([^ ]+) as a personal account, you should/, "如果您将 $1 用作个人账户，您应该在将 $1 转变为组织之前先"],
        [/before transforming ([^ ]+) into an organization./, "。"],
        [/Outside collaborator on (\d+) repositor(y|ies)/, "$1 个仓库的外部协作者"], // 设置 - 组织
        [/Member and collaborator on (\d+) repositor(y|ies)/, "$1 个仓库的成员和协作者"],
        [/Are you positive you want to leave ([^ ]+)\? You will lose access to all repositories and teams./, "您确定要离开 $1 吗？您将失去对所有仓库和团队的访问权。"], // 设置 - 组织 离开按钮 提醒
        [/Are you positive you want to leave ([^ ]+)\? You will lose access to all repositories./, "您确定要离开 $1 吗？您将失去对所有仓库的访问权。"], // 设置 - 组织 离开按钮 提醒
        [/You left ([^ ]+)\. It may take a few minutes to process\./, "您已离开 $1。可能需要几分钟处理。"], //设置，离开组织后的提示
    ],
    "title": {
        "static": {
            "Organizations": "组织",
        },
    },
};

I18N["zh-CN"]["settings/enterprises"] = { // 设置 - 企业版
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 企业版 https://github.com/settings/enterprises
        "Enterprises": "企业版",
        "You don't have any enterprises": "您还没有任何企业版",
        "Designed for businesses or teams who collaborate on GitHub.com": "专为在 GitHub.com 上协作的企业或团队而设计",

        "Start free for 30 days": "免费试用 30 天",
        "Start a free trial": "开启免费体验",
        "Learn more about enterprises": "了解更多关于企业版信息",
    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Enterprises": "企业版",
        },
    },
};

I18N["zh-CN"]["settings/blocked_users"] = { // 设置 - 黑名单
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Blocked users 黑名单 https://github.com/settings/blocked_users
            "Block a user": "拉黑用户",
            "Blocking a user prevents the following on all your repositories:": "拉黑用户可以防止所有仓库中的以下操作：",
            "opening or commenting on issues or pull requests": "打开或评论议题或拉取请求",
            "starring, forking, or watching": "标星、复刻、关注",
            "adding or editing wiki pages": "添加或编辑 Wiki 页面",
            "Additionally, blocked users are not able to:": "此外，被拉黑用户无法：",
            "invite you as a collaborator to their repositories": "邀请您作为其仓库的协作者",
            "follow your account’s public activity": "关注您的账户的公共活动",
            "send you notifications by @mentioning your username in public repositories": "在公共仓库中通过 @您 向您发送通知",
            "Search by username, full name or email address": "搜索用户名、全名、或电子邮箱",
                "Learn more about blocking a user": "了解更多关于拉黑用户的信息",
            "Block user": "拉黑用户",
            "You have not blocked any users.": "您还没有拉黑任何用户。",
            "Unblock": "取消拉黑",
            "Warn me when a blocked user is a prior contributor to a repository": "请警告我，当被拉黑的用户是仓库的先前贡献者时",
            "On repositories you haven’t contributed to yet, we’ll warn you when a user you’ve blocked has previously made contributions.": "在您还没有贡献的仓库里，当您拉黑的用户之前有贡献时，我们会警告您。",
            "You can block a user to deny them access to repositories and more.": "您可以拉黑用户，以拒绝他们访问仓库和其他功能。",
            "On repositories you haven't contributed to yet, we'll warn you when a user you've blocked has previously made contributions.": "在您还没有贡献的仓库里，当您拉黑的用户之前有贡献时，我们会警告您。",
            "All blocked users": "所有被拉黑的用户",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Blocked users": "黑名单",
        },
    },
};

I18N["zh-CN"]["settings/interaction_limits"] = { // 设置 - 互动限制
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Interaction limits 互动限制 https://github.com/settings/interaction_limits
            "Temporary interaction limits": "临时互动限制",
            "Temporarily restrict which external users can interact with your repositories (comment, open issues, or create pull requests) for a configurable period of time.": "在配置的时间段内，可临时限制哪些外部用户与您的仓库互动（评论、打开议题或创建拉取请求）。",
            "This may be used to force a \"cool-down\" period during heated discussions or prevent unwanted interactions.": "可用于在激烈讨论期间，强制进入 “冷静” 期或防止不必要的互动。",
            "Interaction limits may already exist in your account's": "互动限制可能已经存在于您的",
            "public repositories": "公开仓库",
            ". Any changes here will override those limits.": " 的设置中。此处的全局设置将覆盖那些仓库的局部设置。",
            "Limit to existing users": "仅限现有用户",
                "Users that have recently created their account will be unable to interact with your repositories.": "最近创建账户的用户将无法与您的仓库互动。",
            "Limit to prior contributors": "仅限于先前的贡献者",
                "Users that have not previously committed to the default branch of one of your repositories will be unable to interact with that repository.": "以前从未提交到您某个仓库默认分支的用户将无法与该仓库互动。",
            "Limit to repository collaborators": "仅限仓库协作者",
                "Users that are not collaborators of one of your repositories will not be able to interact with that repository.": "不是您某个仓库的协作者将无法与该仓库互动。",
            "New users": "新用户",
            "Users": "用户",
            "Contributors": "贡献者",
            "Collaborators": "协作者",
            // 交互限制时间 下拉菜单
            "Enable interaction limits for:": "启用交互限制：",
            "24 hours": "24 小时",
            "3 days": "3 天",
            "1 week": "1 周",
            "1 month": "1 个月",
            "6 months": "6 个月",
            // 顶部提醒
            "User interaction limit settings saved.": "用户交互限制设置已保存。",

    },
    "regexp": [ // 正则翻译
        [/Enabled with (.+) remaining./, "已启用，还剩 $1。"],
    ],
    "title": {
        "static": {
            "Temporary interaction limits": "临时互动限制",
        },
    },
};

I18N["zh-CN"]["settings/code_review_limits"] = { // 设置 - 代码审查限制
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 顶部提示
            "Code review limit settings saved.": "代码审查限制设置已保存。",

        // Code review limits 代码审查限制 https://github.com/settings/code_review_limits
            "Restrict users who are permitted to approve or request changes on pull requests in your public repositories.": "限制允许批准或请求更改公共仓库中拉取请求的用户。",
            "Code review limits may already be specified by individual repositories. Any changes here will override those limits until unset.": "代码审查限制可能已经由各个仓库指定。此处的任何更改都将覆盖这些限制，直至取消设置。",
            "Code review limits are currently managed individually for all repositories. Enable limits to permit only users who have explicitly been granted access to each repository to submit reviews that \"approve\" or \"request changes\". Remove limits to allow all users to submit pull request reviews. All users able to submit comment pull request reviews will continue to be able to do so.": "目前，所有仓库代码审查限制都是单独管理的。启用限制，只允许明确授予每个仓库访问权的用户提交 “批准” 或 “请求更改” 的审查。删除限制，允许所有用户提交拉取请求审查。所有能够提交评论拉取请求审查的用户将继续能够这样做。",
            "Code review limits are currently": "目前，所有仓库都",
            "enabled": "启用",
            "disabled": "禁用",
            "for all repositories. Only users explicitly granted access to these repositories may submit pull request reviews that \"approve\" or \"request changes\". All users able to submit comment pull request reviews continue to be able to do so.": "代码审查限制。只有被明确授予访问这些仓库权限的用户才能提交 “批准” 或 “请求更改” 的拉取请求审查。所有能够提交评论拉取请求审查的用户仍可继续提交。",
            "for all repositories. All users are able to submit pull request reviews, including those that \"approve\" or \"request changes\". Limit reviews to only permit users who have explicitly been granted access to each repository to submit reviews that \"approve\" or \"request changes\".": "代码审查限制。所有用户都可以提交拉取请求审查，包括那些 “批准” 或 “请求更改” 的审查。限制审查，只允许明确授予每个仓库访问权的用户提交 “批准” 或 “请求更改” 的审查。",
            "Unset": "撤销",
            "Limit reviews on all repositories": "限制对所有仓库的审查",
            "Remove review limits from all repositories": "取消对所有仓库的审查限制",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Code review limits": "代码审查限制",
        },
    },
};

I18N["zh-CN"]["settings/repositories"] = { // 设置 - 仓库
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Repository 仓库 https://github.com/settings/repositories
            "Repository default branch": "仓库默认分支",
            "Choose the default branch for your new personal repositories. You might want to change the default name due to different workflows, or because your integrations still require “master” as the default branch name. You can always change the default branch name on individual repositories.": "为您新的个人仓库选择默认的分支。由于工作流程的不同，或者由于您的集成仍然需要 “master” 作为默认分支名，您可能想改变默认名称。您可以随时改变个人仓库的默认分支名称。",
            "Learn more about default branches.": "了解更多关于默认分支的信息。",
            "Deleted repositories": "删除的仓库",
            "Leave": "离开",

    },
    "regexp": [ // 正则翻译
        [/(\d+) collaborators?/, "$1 位协作者"]
    ],
    "title": {
        "static": {
            "Repositorys": "仓库",
        },
    },
};

I18N["zh-CN"]["settings/deleted_repositories"] = { // 设置 - 仓库 - 删除的仓库
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 删除的仓库 https://github.com/settings/deleted_repositories
            "Deleted repositories": "删除的仓库",
            "It may take up to an hour for repositories to be displayed here. You can only restore repositories that are not forks, or have not been forked.": "仓库可能需要一个小时的时间才能显示在这里。您只能恢复不是复刻或没有被复刻的仓库。",
            "Learn more about restoring deleted repositories": "了解更多关于恢复已删除仓库的信息",

            "These repositories were deleted, but can't be restored by you. Contact support if you want to restore them.": "这些仓库已被删除，但您无法恢复。如果您想恢复它们，请联系 GitHub 支持人员。",

            "Deleted": "删除于",
            // [/by/, "由"], // 删除的仓库
            "Restore": "恢复",
            "Queue…": "排队中…",
            "Done!": "完成!",

            // 恢复仓库 对话框
            // [/Are you sure you want to restore ([^ ]+)?/, "您确定要恢复 $1 吗？"],
            "This repository will be in a private state when it is restored. To change this state, go to settings once the repo is restored.": "此仓库在恢复时将处于私有状态。要更改此状态，请在仓库恢复后转到设置。",
            "Any team or collaborator permissions that previously existed for this repository will not be restored. If you require specific team or collaborator permissions, you will need to configure them in settings.": "此仓库以前存在的任何团队或协作者的权限将不会被恢复。如果您需要特定的团队或协作者权限，则需要在设置中配置。",
            "I understand, restore this repository": "我明白了，依然恢复该仓库。",

    },
    "regexp": [ // 正则翻译
        [/No recoverable repositories were found for ([^ ]+)\./, "没有找到 $1 的可恢复仓库。"],
        [/by/, "由"], // 删除的仓库
        [/Are you sure you want to restore ([^ ]+)?/, "您确定要恢复 $1 吗？"], // 删除的仓库
    ],
};

I18N["zh-CN"]["settings/codespaces"] = { // 设置 - 代码空间
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 代码空间 https://github.com/settings/codespaces
            "Dotfiles": "点文件",
            "Automatically install dotfiles": "自动安装点文件",
            "Codespaces can automatically install your dotfiles into every codespace you create.": "代码空间可以自动将您点文件安装到您创建的每个代码空间。",
            "Learn how to set up your dotfiles for Codespaces.": "了解如何为代码空间设置点文件。",
            "Select repository": "选择仓库",
            "Search for a repository": "搜索仓库",
            "Changes saved": "更改已保存",

            "Secrets": "机密",
            "Codespace user secrets": "代码空间用户机密",
            "New secret": "新建机密",
            "Development environment secrets are environment variables that are encrypted. They are available to any codespace you create using repositories with access to that secret.": "开发环境机密是加密的环境变量。它们可用于您可访问该机密的仓库创建的任何代码空间。",
            "There are no Codespace secrets.": "尚无代码空间机密",
            "Secrets created at the user level can be shared with specified repositories.": "在用户级别创建的机密可以与指定的仓库共享。",

            // [/(\d+) repositor(y|ies)/, "$1 个仓库"],
            "Updated": "更新于",
            // [/Are you sure you want to delete ([^ ]+)\?/, "您确定要删除 $1 吗？"],

            "GPG verification": "GPG 验证",
                "Codespaces can have GPG commit signing capabilities so that GitHub can verify that commits made in the codespace come from a trusted source. When enabled, this setting will be applied to your list of trusted repositories.": "代码空间可以具有 GPG 提交签名功能，以便 GitHub 可以验证代码空间中的提交是来自受信任的来源。启用后，该设置将被应用到您的受信任仓库列表中。",
                // "Enabled": "启用",
                    "GPG signing will be available in Codespaces": "GPG 签名将在代码空间中可用",

            "Settings Sync": "设置同步",
                "By enabling, your codespaces will be able to pull from VS Code Settings Sync service and push only for the trusted repositories you specify. Only enable this for repositories that you trust.": "通过启用，您的代码空间将能够从 VS Code 设置同步服务中提取数据，并仅推送您指定的受信任仓库。请只对您信任的仓库启用此功能。",
                // "Enabled": "启用",
                    "VS Code Settings Sync will be available in Codespaces": "VS Code 设置同步将在代码空间中可用",

            // 通知
            "When enabled, you will receive emails when your codespaces are nearing deletion due to inactivity.": "启用后，当您的代码空间因长时间未使用而即将被删除时，您将收到电子邮件通知。",
            "Warning notifications for codespace deletions will be enabled": "代码空间删除警告通知将启用",

            "Trusted repositories": "受信任仓库",
                "The following repositories will be referenced by GPG verification and Settings Sync.": "以下仓库将被 GPG 验证和设置同步所引用。",

                "All repositories": "所有仓库",
                    "GPG signing and VS Code Settings Sync will be available for codespaces for all repositories": "GPG 签名和 VS Code 设置同步将适用于所有仓库的代码空间",
                "Selected repositories": "选定的仓库",
                    "GPG signing and VS Code Settings Sync will be available for codespaces from the selected repositories": "GPG 签名和 VS Code 设置同步将适用于选定仓库的代码空间",
                    "Select repositories": "选择仓库",
                    // [/Selected (\d+) repositor(y|ies)./, "选定 #1 个仓库"],
                    "GPG and VS Code Settings Sync will be available for Codespaces from these repositories.": "GPG 和 VS Code 设置同步将可用于这些仓库的代码空间。",

                "Submit": "确定",

            "Access and security": "访问和安全",
            "Deprecated": "弃用",
            "Codespaces you create for your personal account can either be restricted to accessing the repository it was opened for, or granted read access to other repositories you own.": "您为您个人账户创建的代码空间可以限制访问已启用的仓库或您其他被赋予读取权限的仓库",
            "Disabled": "禁用",
            "Limit access of personal Codespaces to the repository they were opened for": "限制个人代码空间只能访问对其打开的仓库",
            "All Codespaces can access other repositories I own": "所有代码空间都可以访问我拥有的其它仓库",
            "Personal Codespaces created for specific repositories can access other repositories I own": "为特定仓库创建的个人代码空间可以访问我拥有的其它仓库",

            "Editor preference": "编辑器偏好",
                // VS code
                    "Connect to the cloud from your local desktop client. Requires": "从本地桌面客户端连接到云。要求",
                    "with the": "安装",
                    "GitHub Codespaces": "GitHub 代码空间",
                    "extension.": "插件。",

                "Visual Studio Code for the Web": "网络版的 Visual Studio Code",
                    "Edit and preview changes straight from the browser.": "直接从浏览器编辑和预览更改。",

                // "JetBrains Gateway": "",
                    "Connect to the cloud from your local desktop client. Requires the": "从本地桌面客户端连接到云。要求",
                    "plugin, and a JetBrains license.": "插件和 JetBrains 许可证。",

                // JupyterLab
                    "Edit and run notebooks from the browser with JupyterLab.": "使用 JupyterLab 从浏览器编辑和运行笔记本。",

            "Default idle timeout": "默认空闲超时",
                "A codespace will suspend after a period of inactivity. You can specify a default idle timeout value, which will apply to all codespaces created after the default is changed. You will be charged for the entire time your codespace is running, even if it is idle. The maximum value is": "一段时间不活动后，代码空间将暂停。您可以指定一个默认的空闲超时值，该值将应用于更改默认值后创建的所有代码空间。您将在代码空间运行的整个过程中付费，即使它是空闲的。最大值是",
                "minutes (4 hours).": "分钟（4小时）。",
                "minutes": "分钟",

            "Default retention period": "默认保留期",
                "Inactive codespaces are automatically deleted 30 days after the last time they were stopped. A shorter retention period can be set, and will apply to all codespaces created going forward. The default and maximum value is": "不活跃的代码空间在上次停止后 30 天自动删除。可以设置更短的保留期，并将应用于以后创建的所有代码空间。默认值和最大值是",
                "days.": "天。",
                "Learn about retention setting": "了解关于保留时间的设置",
                "days": "天",

            "Host image version preference": "主机镜像版本偏好",
                "The host image defines the operating system in which development containers run. These images receive periodic upgrades for security, functionality, and performance. GitHub Codespaces offers early access to beta images to ensure compatibility with existing development container configurations. Any codespace created or resumed after changing this setting will use the specified image configuration.": "主机镜像定义了开发容器运行的操作系统。这些镜像会定期进行安全、功能和性能升级。GitHub 代码空间提供对测试版镜像的早期访问，以确保与现有开发容器配置的兼容性。更改此设置后创建或恢复的代码空间都将使用指定的镜像配置。",
                "Learn more about host images": "了解更多关于主机镜像的信息",
                "Stable": "稳定版",
                    "Always use the latest stable configuration.": "始终使用最新的稳定版。",
                "Beta": "测试版",
                    "Use a beta image configuration when available. Otherwise, use the latest stable configuration.": "如果可用，请使用测试版映像配置。否则，请使用最新的稳定配置。",

            "Region": "地区",
                "Your default region will be used to designate compute resources to your codespaces. GitHub can set your region automatically based on your location, or you can set it yourself. Codespaces are deployed to a subset of Azure regions.": "您的默认区域将被用来为您的代码空间指定计算资源。 GitHub 可以根据您的位置自动设置您的区域，您也可以自己设置。代码空间部署到 Azure 区域的子集。",
                "Set automatically": "自动设置",
                "We will determine the closest available region based on your location (IP address) at codespace creation time.": "我们将在创建代码空间时根据您的位置（IP地址）确定最近的可用区域。",
                "Set manually": "手动设置",
                "Choose your default region": "选择您的默认区域",
                    "United States": "美国",
                        "US West": "美国西部",
                        "US East": "美国东部",
                    "Europe": "欧洲",
                        "Europe West": "欧洲西部",
                    "Asia Pacific": "亚太地区",
                        "Southeast Asia": "东南亚",
                    "Australia": "澳大利亚",

            // 顶部提醒
                "Secret added.": "机密已添加。",
                "Secret deleted.": "机密已删除。",
                "Secret updated.": "机密已更新。",

        // 代码空间 机密新建 https://github.com/settings/codespaces/secrets/new
            "/ New secret": "/ 新建机密",
            "Add secret": "添加机密",
                "Adding…": "添加中…",

            "Name": "名称",
                "YOUR_SECRET_NAME": "您的机密名称",
                "Secret name is required and must not start with GITHUB": "机密名称是必需的，并且不能以 GITHUB 开头",
            "Value": "值",

            "Repository access": "仓库权限",
            "Available to": "适用于",
            "repository": "仓库",
            "This secret will not be active until at least 1 repository is selected.": "至少选择 1 个仓库，否则此机密不会处于活动状态。",

        // 编辑机密 https://github.com/settings/codespaces/secrets/<机密名称>/edit
            "/ Update secret": "/ 更新机密",
            "Secret values are encrypted and cannot be displayed, but you can": "机密值已加密，无法显示，但您可以",
            "enter a new value.": "输入一个新值。",
            "Update secret": "更新机密",

    },
    "regexp": [ // 正则翻译
        [/Selected (\d+) repositor(y|ies)./, "选定 $1 个仓库"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/Are you sure you want to delete ([^ ]+)\?/, "您确定要删除 $1 吗？"],
        [/Remove ([^ ]+)/, "移除 $1"],
    ],
    "title": {
        "static": {
            "Codespaces": "代码空间",
        },
    },
};

I18N["zh-CN"]["settings/models"] = {
    "static": {
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置

        "Billing": "账单",

        "Models paid usage": "使用付费模型",
            "If enabled, usage beyond the free tier will be billed per token based on model pricing from your Models budget.": "如果启用，超出免费额度的使用将根据您模型预算中的模型定价按令牌计费。",
            "Models pricing": "模型价格",

            "To enable Models paid usage, a payment method is needed.": "要启用付费模型，需要添加支付方式。",
                "Add payment method": "添加支付方式",

            "You currently have": "您当前有",
                "free rate limits": "免费额度",
                ". Enable paid usage to avoid interruption and add tokens.": "。启用付费使用以避免中断并添加令牌。",
    },
    "regexp": [],
    "title": {
        "static": {
            "Models": "模型",
        },
    },
};

I18N["zh-CN"]["settings/packages"] = { // 设置 - 软件包
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置

        // Packages 软件包 https://github.com/settings/packages
            "Packages permissions": "软件包权限",

            // 组织设置
                "Package creation": "包的创建",
                "Members will be able to publish only the selected visibility types for packages and containers. Outside collaborators can never publish packages or containers.": "成员只能发布选定可见性类型的软件包和容器。外部协作者永远不能发布软件包或容器。",
                "Public": "公共",
                    "Members will be able to create public packages, visible to anyone.": "成员将能够创建公共包，对任何人都可见。",
                "Private": "私有",
                    "Members will be able to create private packages, visible to organization members with permission.": "成员将能够创建私有包，对具有权限的组织成员可见。",
                "Internal": "内部",
                    "Members will be able to create internal packages, visible to all organization/enterprise members.": "成员将能够创建内部包，对所有组织/企业成员可见。",

            "Default Package Setting": "默认软件包设置",
            "Default package settings": "默认软件包设置", // 组织
            "This setting will be applied to new Container, npm, rubygems and NuGet packages.": "此设置将应用于新的容器、npm、rubygems 和 NuGet 软件包。",
            "Inherit access from source repository": "从源仓库继承访问权限",
            "Save": "保存",

            "Deleted Packages": "删除的软件包",
            "Deleted packages": "删除的软件包", // 组织
            "These are packages that have been previously deleted belonging to you. You can restore a package deleted within the last 30 days.": "这些是先前已删除的属于您的软件包。您可以恢复在过去 30 天内删除的包。",
            "These are packages that have been previously deleted belonging to this organization. You can restore a package deleted within the last 30 days.": "这些是先前已删除的属于您组织的软件包。您可以恢复在过去 30 天内删除的包。", // 组织设置
            "Search deleted packages": "搜索已删除的软件包",

    },
    "regexp": [ // 正则翻译
        [/No recoverable packages were found for ([^ ]+)./, "没有找到 $1 的可恢复包。"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Packages": "软件包",
        },
    },
};
I18N["zh-CN"]["orgs/settings/packages"] = I18N["zh-CN"]["settings/packages"];

I18N["zh-CN"]["settings/copilot"] = { // 设置 - GitHub Copilot
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // GitHub Copilot https://github.com/settings/copilot/features
            "Trained on billions of lines of code,": "经过数十亿行代码的训练，",
            "turns natural language prompts into coding suggestions across dozens of languages.": "将自然语言提示转换为多种语言的编码建议。",
            "Start free trial": "开始免费试用",
            "After that $10/month": "结束试用后 $10 / 月",
            "Get Copilot from an organization": "从组织中获取 GitHub Copilot",
            "Organizations can provide their members (including you) and their teams access to GitHub Copilot.": "组织可以为其成员（包括您）及其团队提供使用 GitHub Copilot 的权限。",
            "Organizations owned by enterprise accounts": "企业账户拥有的组织",
            "are not currently listed.": "目前未包含在此计划中。",
            "You do not belong to any organizations.": "您不属于任何组织。",
            "Create an organization": "创建一个组织",

            "Ask admin for access": "向管理员请求访问权限",
            "Requesting...": "请求中…",
            "Remove request": "撤销请求",
            "Cancelling...": "撤销中…",
            "Buy Copilot Business": "购买 GitHub Copilot 企业版",
            "Owner": "所有者",
            "Member": "成员",

            "Getting started": "开始使用",
                "complete": "完成",
                "Remove section":"移除区域",
            "Install Copilot in your editor": "在您的编辑器中安装 Copilot",
            "Ask about coding problems and get code completions while you work.": "在工作时询问问题并获得代码补全。",
            "Chat with Copilot anywhere": "随时随地与 Copilot 聊天",
            "Open": "在 GitHub 的任何位置打开导航栏中的",
            "Copilot chat in the navigation from anywhere on GitHub. Try asking": "按钮，即可与 Copilot 聊天。尝试询问",
            "“what can I do with Copilot?”": "“我能用 Copilot 做什么？”",
            "to get started.": "来开始聊天。",
            "Go to Copilot": "前往 Copilot",
            "Start building with Copilot": "使用 Copilot 开始构建项目",
            "Learn how to build with Copilot in Visual Studio Code or Visual Studio.": "学习如何在 Visual Studio Code 或 Visual Studio 中使用 Copilot 来构建项目",
            "Get started": "开始",

        // 免费版
            "You are using Copilot for free": "您正在使用 Copilot 免费版",
                "Responses are limited to 2,000 code completions and 50 chat messages per month.": "回复上限为每月 2,000 次代码完成和 50 条聊天信息。",
                "Upgrade for higher limits, premium models, AI reviews. Free responses reset in 20 days.": "升级以获得更高的限制、高级模型和 AI 评审。免费版的会话将在 20 天后重置。",
            "Get unlimited usage with Copilot Pro": "通过 Copilot Pro 无限制使用",
                "Unlimited messages and interactions": "信息和互动无限制",
                "Access to the latest models": "访问最新模型",
                "Customize conversations to your private codebase and extensions": "为您的私人代码库和扩展定制会话",
                "Start a free trial": "免费试用",
                "Code completions":"代码补全",
                "Chat messages":"聊天信息",

            "Copilot policies": "Copilot 规则",
                "Copilot Chat in GitHub.com": "在 GitHub.com 中使用 Copilot Chat",
                    "You can use Copilot Chat in GitHub.com. Copilot code review and preview features are only available for paid licenses.": "您可以在 GitHub.com 中使用 Copilot Chat。Copilot 代码审查和预览功能仅适用于付费版。",
                    "You can use Copilot Chat in GitHub.com. Preview features are only available for paid licenses.": "您可以在 GitHub.com 中使用 Copilot Chat。预览功能仅适用于付费版。",
                    "Learn more about Copilot in GitHub.com": "了解更多关于在 GitHub.com 中使用 Copilot 的信息",
                "Editor preview features": "编辑器预览功能",
                    "You can use preview features in your editor.": "您可以在编辑器中使用预览功能。",
                "Suggestions matching public code": "公共代码匹配的建议",
                    "Copilot can allow or block suggestions matching public code. Learn more about": "Copilot 可允许或阻止与公共代码匹配的建议。了解更多关于",
                    "code suggestions": "代码建议",
                    "Allowed": "允许",
                        "GitHub Copilot will show suggestions matching public code.": "GitHub Copilot 将显示与公共代码匹配的建议。",
                    "Blocked": "阻止",
                        "GitHub Copilot won't show suggestions matching public code.": "GitHub Copilot 不会显示与公共代码匹配的建议。",
                "Allow GitHub to use my data for product improvements": "允许 GitHub 将数据用于产品改进",
                //"Allow GitHub to use my code snippets from the code editor for product improvements": "允许 GitHub 将代码编辑器中的代码片段用于产品改进",
                    "Allow GitHub, its affiliates and third parties to use my data, including Prompts, Suggestions, and Code Snippets, for product improvements. More information in the": "允许GitHub、其关联公司和第三方使用我的数据，包括提示、建议和代码片段，以改进产品。更多信息请查看",
                    //"Allow GitHub, its affiliates and third parties to use my code snippets to research and improve GitHub Copilot suggestions, related models and product features. More information in the": "允许 GitHub、其附属机构和第三方使用我的代码片段来研究和改进 GitHub Copilot 建议、相关模型和产品功能。更多",
                    "About GitHub Copilot privacy.": "关于 GitHub Copilot 隐私的信息。",
                "Allow GitHub to use my data for AI model training": "允许 GitHub 将数据用于训练 AI 模型",
                    "Allow GitHub, its affiliates and third parties to use my data, including Prompts, Suggestions, and Code Snippets, for AI model training. More information in the": "允许GitHub、其关联公司和第三方使用我的数据，包括提示、建议和代码片段，以训练 AI 模型。更多信息请查看",
                "Copilot can search the web": "网络搜索",
                    "Copilot can answer questions about new trends and give improved answers, via Bing. See": "Copilot 可以回答有关新趋势的问题并给出改进的答案，通过必应。请参阅",
                    "Microsoft Privacy Statement": "微软隐私声明",

                    "GitHub Copilot will answer questions about new trends and give improved answers": "GitHub Copilot 将回答有关新趋势的问题并给出改进的答案",
                    "GitHub Copilot won't answer questions about new trends and give improved answers": "GitHub Copilot 将不会回答有关新趋势的问题并给出改进的答案",
                    "Select an option": "选择",
                        "You will have access to the feature": "您将能够访问此功能",
                        "You won’t have access to the feature": "您将不能访问此功能",
                "Learn more about how GitHub Copilot serves OpenAI GPT-5-Codex and confirm compatibility with your IDE in our documentation.": "了解更多关于 GitHub Copilot 如何为 OpenAI GPT-5-Codex 提供服务，并确认与您的 IDE 的兼容性。",
                "Dashboard entry point": "仪表板入口",
                    "Allows instant chatting when landing on GitHub.com": "允许登录 GitHub.com 时即时聊天",
                "Copilot code review": "Copilot 代码审查",
                    "Use Copilot to": "使用 Copilot",
                    "review your code": "审查代码",
                    "and generate": "并生成",
                    "pull request summaries": "拉取请求总结",

                    "Automatically request Copilot code review": "自带请求 Copilot 代码审查",
                        "Use Copilot to automatically review all the pull requests you've created.": "使用 Copilot 自动审查您创建的拉取请求。",

            "For more information about the data your organization receives regarding your use of GitHub Copilot, please review": "如需了解贵机构在使用 GitHub Copilot 时会收到哪些数据，请查看",
                "GitHub's Privacy Statement": "GitHub 的《隐私声明》",
            "It can take up to 30 minutes for the changes to take effect. Restart your code editor for the changes to take effect immediately.": "更改可能需要 30 分钟才能生效。重新启动代码编辑器，更改会立即生效。",

            "Visibility": "可见度",
                "Show Copilot": "显示 Copilot",
                "Enable Copilot for all GitHub features, including navigation bar, search, and dashboard.": "为所有 GitHub 功能启用 Copilot，包括导航栏、搜索和仪表板。",
                "When disabled, Copilot will be hidden and unavailable. This setting does not apply to Copilot search on GitHub Docs.": "禁用后，Copilot 将隐藏且不可用。此设置不适用于 GitHub Docs 中的 Copilot 搜索。",

        // 专业版
            // 顶部提醒
                "It appears you are not eligible to sign up to GitHub Copilot for free": "您似乎没有资格免费注册 GitHub Copilot",
            "Your GitHub Copilot setup is incomplete. Select your preferences below to start using GitHub Copilot.": "您的 GitHub Copilot 设置不完整。请在下面选择您的偏好，开始使用 GitHub Copilot。",

            "GitHub Copilot Pro is active for your account": "您的 GitHub Copilot Pro 帐户已激活",
                "You currently have an active": "您当前拥有有效的",
                "Copilot Pro subscription": "GitHub Copilot Pro 订阅",
                "Get started by installing the extension in your preferred IDE.": "首先在您首选的 IDE 中安装扩展。",
                "Get started by installing the extension in your preferred environment.": "首先在您首选环境中安装扩展。",
                "Copilot in your IDE": "集成在 IDE",
                "Copilot in the CLI": "在终端中使用",
                "Chat in GitHub Mobile": "在 GitHub Mobile 中使用",
                "More features": "更多功能",

            "Premium requests": "高级请求",
                "Please note that there may be a delay in the displayed usage percentage. The premium request entitlement for your plan will reset at the start of next month. You can enable additional premium requests in the": "请注意，显示的使用百分比可能会有延迟。您计划的高级请求权限将在下个月初重置。您可以在以下位置启用额外的高级请求：",
                "Billing settings": "账单设置",
                "Please note that there may be a delay in the displayed usage percentage. The premium request entitlement for your plan will reset at the start of next month. To enable additional premium requests,": "请注意，显示的使用百分比可能会有延迟。您计划的高级请求权限将在下个月初重置。要启用额外的高级请求，请",
                "update your Copilot premium request budget": "更新您的 Copilot 高级请求预算",

            "Features": "功能",
                // "Copilot in github.com": "在 github.com 中使用 Copilot",
                    //"You can use Copilot Chat in Github.com, Copilot for pull requests, and all of the preview features.": "您可以在 Github.com 中使用 Copilot Chat，也可以使用 Copilot 拉取请求和所有预览功能。",
                    "You can use Copilot Chat in GitHub.com, Copilot for pull requests, and all of the preview features.": "您可以在 GitHub.com 中使用 Copilot Chat，Copilot 拉取请求和所有预览功能。",
                    "You can use Copilot Chat in GitHub.com and Copilot for pull requests. Copilot code review and preview features are only available for paid licenses.": "您可以在 GitHub.com 上使用 Copilot Chat，也可以在拉取请求中使用 Copilot。Copilot 的代码审查和预览功能仅对付费许可证用户开放。",

                // "Copilot in the CLI": "在终端中使用",
                    "You can use": "您可以",
                    "GitHub Copilot for assistance in terminal": "GitHub Copilot 终端辅助工具",
                "Copilot Chat in the IDE": "在 IDE 中使用 Copilot Chat",
                    "GitHub Copilot Chat in the IDE": "在 IDE 中使用 Copilot Chat",
                    "to explain a piece of code, propose bug fixes, or generate unit tests in a chat interface from your editor.": "在编辑器的聊天界面上解释代码、提出错误修复建议或生成单元测试。",
                "Copilot Chat in GitHub Mobile": "在 GitHub Mobile 中使用 Copilot Chat",
                    "personalized to a codebase.": "，个性化代码。",
                "Copilot in GitHub Desktop": "在 GitHub Desktop 中使用",
                    "GitHub Copilot for assistance in GitHub Desktop": "在 GitHub Desktop 中获得 Copilot 的协助",
                "Automatic Copilot code review": "自动 Copilot 代码审查",
                    "Copilot will automatically review your pull requests.": "Copilot 将自动审查您的拉取请求。",
                    "Learn more about configuring automatic code reviews.": "了解如何配置自动代码审查。",
                "Copilot coding agent": "Copilot 编程智能体",
                    "With Copilot coding agent, you can delegate tasks to Copilot, freeing you to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request your review, then leave feedback on the pull request to iterate.": "使用 Copilot 编程智能体，您可以将任务委托给 Copilot，从而让您专注于最具创造性的、复杂且影响深远的工作。只需将问题分配给 Copilot，等待智能体请求您审查，然后在拉取请求中留下反馈以进行迭代。",
                    "Delegate tasks to Copilot coding agent in repositories where it is enabled": "将任务委托给已启用 Copilot 编程智能体的仓库",
                "MCP servers in Copilot": "Copilot 中的 MCP 服务器",
                    "Connect MCP servers to Copilot in all Copilot editors and Coding Agent.": "在所有 Copilot 编辑器和编程智能体中连接 MCP 服务器。",
                // Grok
                    "If enabled, you can access and send data to xAI Grok Code Fast 1.": "若启用，您可以访问 xAI Grok Code Fast 1 并发送数据。",
                "Copilot-generated commit messages" : "Copilot 生成的提交消息",
                    "Allow Copilot to suggest commit messages when you make changes on GitHub.com.": "允许 Copilot 在您于 GitHub.com 上进行更改时提供提交消息建议。",
                    "Learn more about Copilot-generated commit messages.": "了解更多关于 Copilot 生成的提交消息。",
                "Copilot Spaces": "Copilot 空间",
                    "If enabled, you can view and create": "若启用，您可以查看和创建",
                    "Copilot Spaces": "Copilot 空间",
                    ". When disabled, you cannot view or create any Copilot Spaces.": "。当禁用时，您无法查看或创建任何 Copilot 空间。",
                "Choose which repositories Copilot coding agent should be enabled in. Copilot coding agent will only be available where it is enabled for the repository and in the Copilot license policies.": "选择要在其中启用 Copilot 编程智能体的仓库。Copilot 编程智能体仅在为该仓库启用并符合 Copilot 许可证政策的情况下可用。",
                "Copilot Spaces Individual Access":"Copilot Spaces 个人访问权限",
                    "If enabled, you can create individually owned":"若启用，您可以创建个人拥有的",
                    "Copilot Spaces": "Copilot 空间",
                    ". When disabled, you cannot create individual spaces.":"。当禁用时，您无法创建个人空间。",
                "Copilot Spaces Individual Sharing":"Copilot Spaces 个人分享",
                    "If enabled, you can share individually owned": "若启用，您可以分享个人拥有的",
                    "Copilot Spaces": "Copilot 空间",
                    ". When disabled, you cannot share individual spaces.":"。当禁用时，您无法分享个人空间。",



        // 编程智能体(预览 https://github.com/settings/copilot/coding_agent
            // 顶部提示
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro+ or Copilot Enterprise license.": "您可以为其他用户启用 Copilot 编程智能体，但由于您没有 Copilot Pro+ 或 Copilot 企业版许可证，因此无法向 Copilot 分配任务。",
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because the Copilot coding agent policy has been disabled by an administrator.":  "您可以为其他用户启用 Copilot 编程智能体，但由于管理员已禁用 Copilot 编程智能体策略，您将无法向 Copilot 分配任务。",
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro, Copilot Pro+, Copilot Business or Copilot Enterprise license.": "虽然您可以为其他用户启用 Copilot 编码代理，但由于您未持有 Copilot Pro、Copilot Pro+、Copilot Business、Copilot Enterprise 许可证，因此无法向 Copilot 分配任务。",

            "With Coding agent, you can delegate tasks to Copilot, freeing you to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request your review, then leave feedback on the pull request to iterate.": "使用编程智能体，您可以将任务委派给 Copilot，从而让您专注于最具创造性的、复杂且影响深远的工作。只需将问题分配给 Copilot，等待智能体请求您审查，然后在拉取请求中留下反馈以进行迭代。",
                "Learn more in the docs.": "详情",

            "Repository access": "仓库访问",
                "Choose which repositories Coding agent should be enabled in. Coding agent will only be available where it is enabled for the repository and in the Copilot license policies.": "选择要启用编程智能体的仓库。编程智能体仅在为该仓库启用并符合 Copilot 许可证政策的情况下可用。",

                "No repositories": "无仓库",
                // 所有
                    "Include all current and future repositories": "包括所有当前和未来的仓库",
                "Only selected repositories": "手动选择",
                    "Applies only to specifically selected repositories": "仅适用于您选择的仓库",

                    "Search or filter": "搜索或筛选",
                        "Mirror": "镜像",
                        "Custom properties": "自定义属性",
                        "Language": "语言",
                        "License": "许可证",
                        "Exclude": "排除",

                    "Select all": "全选",

                    "of": "/",
                    "items shown.": "仓库显示。",
                    "Use the search to find specific items": "搜索查找特定仓库",

                    "Select": "选择",

            "Use of Copilot coding agent is subject to the": "使用 Copilot 编程智能体需遵守",
                "pre-release terms": "预发行条款",

    },
    "regexp": [ // 正则翻译
        [/Outside collaborator on (\d+) repositor(y|ies)/, "$1 个仓库的外部协作者"],
        [/Member and collaborator on (\d+) repositor(y|ies)/, "$1 个仓库的成员和协作者"],
        [/Upgrade for higher limits, premium models, AI reviews. Free responses reset in (\d+) days.?/, "升级以获取更高的限制、高级模型和 AI 审核。免费额度将在 $1 天内重置。"], // 免费版额度
        [/You can use the latest (.+) model\./, "您可以使用最新的 $1 模型。"],
        [/Learn more about how GitHub Copilot serves (.+)\./, "了解更多关于 GitHub Copilot 如何为 $1 提供服务。"],
    ],
    "title": {
        "static": {
            "Copilot coding agent": "Copilot 编程智能体",
        },
    },
};

I18N["zh-CN"]["settings/pages"] = { // 设置 - GitHub Pages
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置菜单

        // GitHub Pages https://github.com/settings/pages
            "Verified domains": "经验证的域名",
            "Add a domain": "添加域名",
            "There are no verified domains.": "暂无经验证的域名",
            "There are no verified domains for this organization.": "此组织暂无经验证的域名", // 组织设置
            "Verify domains to restrict who can publish GitHub Pages on them.": "验证域名以限制谁可以在上面发布 GitHub Pages。",
            "One of your domains is unverified. Please verify it to prevent others from claiming it for their Pages sites.": "您添加的域名之一未经验证，请对其进行验证，以防止其他人在其主页网站上声明该信息。",
            "Please verify your domain": "请验证您的域名",
            "Continue verifying": "继续验证",
            "Review verification steps": "查看验证步骤",

            // 域名删除对话框
            "Delete verified domain": "删除已验证的域名",
            "This is a destructive action. Your GitHub Pages sites may lose their custom domains.": "这是一个破坏性的操作，您的 GitHub Pages 网站可能会失去自定义域名。",
            "Your GitHub Pages sites may be unpublished from their custom domains if another organization claims ownership of this domain.": "如果其他组织声称拥有此域名的所有权，您的 GitHub Pages 网站可能会被从此自定义域名中取消发布。",
            "Please type": "请输入",
            "to confirm.": "进行确认",
            "I understand, delete verified domain": "我明白了，依然删除已验证的域名",

        // GitHub Pages - 添加域名 https://github.com/settings/pages_verified_domains/new
            "Add a verified domain": "经验证的域名",
            "What domain would you like to add?": "您想添加什么域名？",
            "Add domain": "添加域名",
            "Domain name has already been added": "域名已添加",
            "Add a DNS TXT record": "添加 DNS TXT 记录",
            "Before we can verify": "在我们验证",
            ", you'll need to complete these steps:": " 之前，您需要完成以下步骤：",
            "Create a TXT record in your DNS configuration for the following hostname:": "在 DNS 配置中为以下主机创建 TXT 记录：",
            "Use this code for the value of the TXT record:": "使用以下代码作为 TXT 记录的值：",
            "Wait until your DNS configuration changes. This could take up to 24 hours to propagate.": "等待您的 DNS 变更解析生效，最长可能需要 24 小时。",
            "Verify": "验证",
            "Copy verification steps": "复制验证步骤",
            "Your domain is verified. No further action is needed.": "您的域名已验证，无需其它操作。",
    },
    "regexp": [ // 正则翻译
        [/Successfully verified/, "已成功验证"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
};
I18N["zh-CN"]["orgs/settings/pages"] = I18N["zh-CN"]["settings/pages"];

I18N["zh-CN"]["settings/replies"] = { // 设置 - 快捷回复
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Saved replies 快捷回复 https://github.com/settings/replies
            "Saved replies are re-usable text snippets that you can use throughout GitHub comment fields. Saved replies can save you time if you’re often typing similar responses.": "快捷回复是可重复使用的文本片段，您可以在整个 GitHub 评论区使用。如果您经常输入类似的回复，快捷回复可以节省您的时间。",
            "Learn more about working with saved replies": "了解更多关于使用快捷回复的信息",
            "No saved replies yet.": "暂时没有快捷回复。",
            "Add a saved reply": "添加快捷回复",
            "Saved reply title": "快捷回复的标题",
            "Add a short title to your reply": "为您的快捷回复添加简短的标题",
            "Add your saved reply": "添加您的快捷回复",
            "Add saved reply": "添加快捷回复",
            "Your saved reply was created successfully.": "您的快捷回复已成功创建。",
            "Edit saved reply": "编辑快捷回复",
            "Update saved reply": "更新快捷回复",
            "Your saved reply was updated successfully.": "您的快捷回复已成功更新。",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Saved replies": "快捷回复",
        },
    },
};

I18N["zh-CN"]["settings/security_analysis"] = { // 设置 - 代码安全性与分析
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 代码安全性与分析 https://github.com/settings/security_analysis
            "Security and analysis features help keep your repositories secure and updated. By enabling these features, you're granting us permission to perform read-only analysis on your repositories.": "安全和分析功能有助于确保您的仓库安全和更新。通过启用这些功能，您授予我们对您的仓库执行只读分析的权限。",

            "User": "用户",
                "Security and analysis features help keep you secure and updated, wherever you are.": "无论您身在何处，安全和分析功能都可以帮助您保持安全并及时更新。",

                "Keep your public pushes safe with push protection": "通过推送保护确保您的公共推送安全",
                "GitHub will enable push protection for all GitHub Free individuals in January 2024. Enable below to try it now in beta.": "GitHub 将于 2024 年 1 月为所有 GitHub 免费用户启用推送保护。在下面启用以立即在测试版中尝试。",
                    "Dismiss": "忽略",

                "Push protection for yourself": "启用推送保护",
                    "Block commits that contain": "阻止提交，包含",
                    "supported secrets": "受支持的机密",
                    "across all public repositories on GitHub.": "涵盖 GitHub 上的所有公共仓库。",

                    // 对话框
                        "Enable push protection for yourself": "为自己启用推送保护",
                            "Pushes that contain secrets will be blocked on public repositories. You'll have the option to bypass the block.": "包含机密的推送将在公共仓库中被阻止。您可以选择绕过该阻止。",
                            "Enable push protection": "启用推送保护",

                        "Disable push protection for yourself": "为自己禁用推送保护",
                            "Pushes that contain secrets will not be blocked.": "包含机密的推送将不会被阻止。",
                            "Disable push protection": "禁用推送保护",

                        // 顶部提醒
                            // [/Security settings updated for ([^ ]+)\'s repositories./, "更新了 $1 的仓库的安全设置。"],

            // 仓库
                 "Security and analysis features help keep your repositories secure and updated.": "安全和分析功能有助于确保您的代码仓库安全且保持更新。",

            "Disable all": "禁用全部",
            "Enable all": "启用全部",

            "Private vulnerability reporting": "私下漏洞报告",
                "Allow your community to privately report potential security vulnerabilities to maintainers and repository owners.": "允许您的社区向维护者和仓库所有者私下报告潜在的安全漏洞。",
                "Learn more about private vulnerability reporting": "了解更多关于私下漏洞报告的信息",
                "Automatically enable for new public repositories": "为新公共仓库自动启用",

                // 对话框
                    "Disable private vulnerability reporting": "禁用私下漏洞报告",
                        // [/You're about to disable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即将在 $1 的所有公共仓库中禁用私下漏洞报告。"],
                        "Enable by default for new public repositories": "默认启用新公共仓库",

                    "Enable private vulnerability reporting": "启用私下漏洞报告",
                        // [/You're about to enable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即将在 $1 的所有公共仓库中启用私下漏洞报告。"],

            "Dependency graph": "依赖项关系图",
                "Understand your dependencies.": "了解您的依赖项。",
                "Automatically enable for new private repositories": "为新私有仓库自动启用",

                // 对话框
                    "Enable dependency graph": "启用依赖项关系图",
                        "You're about to enable dependency graph on all your private repositories.": "您即将启用您所有私有仓库上的依赖项关系图。",
                        "Enable by default for new private repositories": "默认为新私有仓库启用",

                    "Disable dependency graph": "禁用依赖项关系图",
                        "You're about to disable dependency graph on all your private repositories. This will also disable Dependabot alerts and Dependabot security updates on those repositories.": "您即将禁用您所有私有仓库上的依赖项关系图。这也将禁用这些仓库的 Dependabot 警报和 Dependabot 安全更新。",

            // Dependabot
                "Keep your dependencies secure and up-to-date.": "保持您的依赖项的安全和最新",
                "Learn more about Dependabot": "了解更多关于 Dependabot 的信息",

                "Dependabot alerts": "Dependabot 警报",
                    "Receive alerts for vulnerabilities that affect your dependencies and manually generate Dependabot pull requests to resolve these vulnerabilities.": "接收影响您的依赖项的漏洞警报，并手动生成 Dependabot 拉取请求以解决这些漏洞。",
                        "Configure alert notifications": "配置警报通知",
                    "Automatically enable for new repositories": "为新仓库自动启用",

                    // 对话框
                        "Enable Dependabot alerts": "启用 Dependabot 警报",
                            "You're about to enable Dependabot alerts on all your repositories. Alerts require the dependency graph, so we'll also turn that on for all repositories. No notifications will be sent while Dependabot alerts are being enabled.": "您即将启用您所有仓库上的 Dependabot 警报。Dependabot 警报需要依赖项关系图，因此我们还将为所有仓库开启它。启用 Dependabot 警报时不会发送任何通知。",
                                "Enable by default for new repositories": "默认为新仓库启用",

                        "Disable Dependabot alerts": "禁用 Dependabot 警报",
                            "You're about to disable Dependabot alerts on all your repositories. This will also disable Dependabot security updates on those repositories.": "您即将禁用您所有仓库上的 Dependabot 警报。这也将禁用这些仓库的 Dependabot 安全更新。",

                "Dependabot security updates": "Dependabot 安全更新",
                    "Enabling this option will result in Dependabot automatically attempting to open pull requests to resolve every open Dependabot alert with an available patch.": "启用后，Dependabot 会自动尝试打开拉取请求，以使用可用补丁解决每个打开的 Dependabot 警报。",
                        "Dependabot rules": "Dependabot 规则",

                    // 对话框
                        "Enable Dependabot security updates": "启用 Dependabot 安全更新",
                            "You're about to enable Dependabot security updates on all your repositories. Dependabot security updates require the dependency graph and Dependabot alerts, so we'll also turn that on for all repositories.": "您即将启用您所有仓库上的 Dependabot 安全更新。Dependabot 安全更新需要依赖项关系图和 Dependabot 警报，因此我们也将为所有仓库启用他们。",

                        "Disable Dependabot security updates": "禁用 Dependabot 安全更新",
                            "You're about to disable Dependabot security updates on all your repositories.": "您即将禁用您所有仓库上的 Dependabot 安全更新。",

                "Grouped security updates": "分组安全更新",
                    "Groups all available updates that resolve a Dependabot alert into one pull request (per package manager and directory of requirement manifests). This option may be overridden by group rules specified in dependabot.yml -": "将解决可靠警报的所有可用更新分组为一个拉取请求（每个包管理器和需求清单目录）。此选项可能会被 dependentabot.yml 中指定的分组规则覆盖 -",
                    "Learn how to group updates.": "了解如何配置分组更新",

                    // 对话框
                        "Enable grouped security updates": "启用分组安全更新",
                            "You're about to enable grouped security updates on all your repositories. Grouped security updates require the dependency graph, Dependabot alerts and Dependabot security updates, so we'll also turn that on for all repositories.": "您即将启用您所有仓库上的分组安全更新。分组安全更新需要依赖项关系图、Dependabot 警报和 Dependabot 安全更新，因此我们也将为所有仓库启用他们。",

                        "Disable grouped security updates": "禁用分组安全更新",
                            "You're about to disable grouped security updates on all your repositories.": "您即将禁用您所有仓库上的分组安全更新。",

                "Dependabot on Actions runners": "Dependabot 应用于操作运行器",
                    "Run Dependabot security and version updates on Actions runners.": "在操作运行器上运行 Dependabot 安全和版本更新。",

                    // 对话框
                        "Enable dependabot on actions": "在操作中启用 Dependabot",
                            "You're about to enable dependabot on actions on all your repositories. Dependabot on actions requires Actions so we'll also turn that on for all repositories.": "您将要在所有仓库操作中启用 dependabot 。操作中的 Dependabot需要操作，因此我们还将为所有仓库启用它。",

                        "Disable dependabot on actions": "在操作中禁用 Dependabot",
                            "You're about to disable dependabot on actions on all your repositories.": "您将要在所有仓库操作中禁用 Dependabot。",

                "Dependabot on self-hosted runners": "Dependabot 应用于自托管运行器",
                    "Run Dependabot security and version updates on self-hosted Actions runners.": "在自托管运行程序上运行 Dependabot 安全和版本更新。",

                    // 对话框
                        "Enable dependabot self-hosted": "在自托管运行器上启用 Dependabot",
                            "You're about to enable dependabot self-hosted on all your repositories. Dependabot self-hosted depends on Dependabot on Actions so we'll also turn that on for all repositories.": "您将在所有仓库上启用 dependabot 自托管。Dependabot 自托管依赖于操作中的 Dependabot，因此我们还将为所有仓库启用它。",

                        "Disable dependabot self-hosted": "在自托管运行器上禁用 Dependabot",
                            "You're about to disable dependabot self-hosted on all your repositories.": "您将在所有仓库上禁用 dependabot 自托管。",

            "Secret scanning": "机密扫描",
                "Receive alerts on GitHub for detected secrets, keys, or other tokens.": "在 GitHub 上接收有关检测到的机密、密钥或其他令牌的警报。",
                "GitHub will always send alerts to partners for detected secrets in public repositories.": "GitHub 会随时向合作伙伴发送公共仓库中检测到的机密警报。",
                "Learn more about partner patterns": "了解更多关于合作伙伴模式的信息",

                // 对话框
                    "Enable secret scanning for eligible repositories?": "启用符合条件的仓库的机密扫描？",
                        "This will turn on secret scanning for all public repositories.": "这将为所有公共仓库启用机密扫描。",
                        "Enable for eligible repositories": "启用符合条件的仓库",

                    "Disable secret scanning?": "禁用机密扫描？",
                        "This will disable secret scanning on all repositories where it is enabled.": "这将禁用所有仓库的机密扫描。",
                        "Disable secret scanning": "禁用机密扫描",

                "Push protection": "推送保护",
                    // "Block commits that contain": "阻止提交，包含",
                    // "supported secrets": "受支持的机密",
                    "Automatically enable for repositories added to secret scanning": "自动启用对添加到机密扫描的仓库进行扫描",

                    // 对话框
                        "Enable push protection for eligible repositories?": "启用符合条件的仓库的推送保护？",
                            "This will turn on push protection for all repositories that have secret scanning enabled.": "这将为所有已启用秘密扫描的仓库启用推送保护。",

                        "Disable push protection?": "禁用推送保护？",
                            "This will disable push protection on all repositories where it is enabled.": "这将禁用所有仓库的推送保护。",
                            "You can still enable push protection at the repository level.": "您仍然可以在仓库级别启用推送保护。",

    },
    "regexp": [ // 正则翻译
        [/You're about to disable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即将在 $1 的所有公共仓库中禁用私下漏洞报告。"],
        [/You're about to enable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即将在 $1 的所有公共仓库中启用私下漏洞报告。"],
        [/Security settings updated for ([^ ]+)\'s repositories./, "更新了$1 的仓库的安全设置。"],
    ],
    "title": {
        "static": {
            "Security & analysis": "安全与分析",
        },
    },
};

I18N["zh-CN"]["settings/installations"] = { // 设置 - 应用/安装的 GitHub 应用
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"],

        "Installed GitHub Apps": "安装的 GitHub 应用",
        "Authorized GitHub Apps": "授权的 GitHub 应用",
        "Authorized OAuth Apps": "授权的 OAuth 应用",

        // 安装的 GitHub 应用 https://github.com/settings/installations
            // 顶部提醒
                // [/You're all set! (.*) has been uninstalled./, "一切就绪！$1 已被卸载。"],
                // [/You're all set! A job has been queued to uninstall the \'(.*)\' app./, "一切就绪！卸载 “$1” 应用的任务已排队等候。"],
                // [/Okay, (.*) was installed on the (@[^ ]+) account./, "好的，$1 已安装在 $2 账户上。"],
                // [/Okay, (.*) was updated for the (@[^ ]+) account./, "好的，$1 账户的 $1 已更新。"],

            // "Installed GitHub Apps": "安装的 GitHub 应用",
                "GitHub Apps augment and extend your workflows on GitHub with commercial, open source, and homegrown tools.": "GitHub 应用通过商业、开源和自主开发的工具来增强和扩展您在 GitHub 上的工作流程。",
                "Permission updates requested.": "待处理的 GitHub 权限请求",

            "Pending GitHub Apps installation requests": "待处理的 GitHub 应用安装请求", // 组织设置
                "Members in your organization can request that GitHub Apps be installed. Pending requests are listed below.": "您组织中的成员可以请求安装 GitHub 应用。下面列出了待处理的请求。",

            "No installed GitHub Apps": "没有已安装的 GitHub 应用",
            "You have no GitHub Apps installed on this account.": "此账户上没有安装任何 GitHub 应用。",
            "Configure": "配置",
            "Suspended": "已暂停",
            "Visit Marketplace": "访问市场",
            "My GitHub Apps": "我的 GitHub 应用",

        // 安装的 GitHub 应用设置 https://github.com/settings/installations/<id>
            // 顶部提醒
                // [/Your installation was suspended by you on/, "您的安装已暂停于"],
                "Your app has been unsuspended": "您的应用已被取消暂停",

            "Installed": "安装于",
            "Developed by": "开发者",
            "App settings": "应用设置",
            "Permissions": "权限",
                // [/is requesting an update to its permissions./, "正在请求更新其权限。"],
                "Read": "读取",
                "write": "写入",
                "access to metadata": "元数据的权限",
                "Review request": "审核请求",
                "Access public information (read-only)": "访问公开信息（只读）",
                "Access user email addresses (read-only)": "访问用户电子邮件地址（只读）",
                "Read all user profile data": "读取所有用户个人资料数据",
                "Create gists": "创建代码片段",
                "Full control of private repositories": "完全控制私有仓库",
                "Update github action workflows": "更新 GitHub Action 工作流",
                "Update all user data": "更新所有用户数据",
                "Full control of codespaces": "完全控制 Codespaces",
                "Read all user profile data": "读取所有用户个人资料数据",

            "Repository access": "仓库访问权限",
            "All repositories": "所有仓库",
                "This applies to all current and future repositories owned by the resource owner. Also includes public repositories (read-only).": "这适用于资源所有者拥有的所有当前和未来的仓库。还包括公共仓库（只读）。",
            "Only select repositories": "仅选定的仓库",
                "Select at least one repository. Also includes public repositories (read-only).": "至少选择一个仓库。还包括公共仓库（只读）。",
                // [/Selected (\d+) repositor(y|ies)./, "选择了 $1 个仓库。"],
            "Select repositories": "选择仓库",
            "Search for a repository": "搜索仓库",

            "Danger zone": "危险区",
            "Suspend your installation": "暂停使用",
            "This will block the app access to your resources.": "这将阻止应用访问您的资源。",
            "Suspend": "暂停",
                // 取消按钮 提醒信息
                "Are you sure you want to suspend this GitHub App?": "您确定要暂停此 GitHub 应用吗？",
            "This will remove the app and revoke access to all resources.": "这将删除应用并撤销对所有资源的访问权限。",
            // [/Uninstall "(.*)"/, "卸载 “$1”"],
            "Uninstall": "卸载",
                // 取消按钮 提醒信息
                // [/This action cannot be undone. Are you sure you want to uninstall this GitHub App from (\d+) repositor(y|ies)?/, "此操作无法撤消。您确定要从 1 个仓库中卸载此 GitHub 应用吗？"],
            "Unsuspend your installation": "取消暂停",
                "This grant the app access to your resources.": "这将授予应用访问您的资源。",
                "Unsuspend": "取消暂停",

            "Report abuse": "举报滥用",
            "Revoke": "撤销",
            "Read more about connecting with third-party applications at": "了解更多关于与第三方应用连接的信息，请访问",
            "GitHub Help": "GitHub 帮助",

        // 安装的 GitHub 应用授权更新 https://github.com/settings/installations/<id>/permissions/update
            // [/The (.*) app by/, "$1 应用（由"],
            "is requesting updated permissions": "创建）正在请求更新权限",

            "Read and write": "读写权限",
            "Read-only": "只读权限",
            "Admin": "管理员权限",
            "access to": "针对",
            "New request": "新请求",
            "Show unchanged permissions": "显示未更改的权限",
            "Hide unchanged permissions": "隐藏未更改的权限",
            "Accept new permissions": "接受新权限",
            // [/The (.*) app will retain its current permissions if you choose not to accept the new permissions./, "如果您选择不接受新权限，“$1” 应用将保留其当前权限。"],

        // 授权的 GitHub 应用 https://github.com/settings/apps/authorizations
            // "Authorized GitHub Apps": "授权的 GitHub 应用",
            "No authorized applications": "无授权申请",
            "You have no applications authorized to access your account.": "您没有授权访问您的账户的应用。",

        // 授权的 OAuth 应用 https://github.com/settings/applications
            // "Authorized OAuth Apps": "授权的 OAuth 应用",
            "You have granted": "您已经授权",
            "access to your account.": "访问您的账户。",
            "Revoke all": "撤销全部",
            "Sort": "排序",
            "Sort by": "排序方式",
            "Alphabetical": "按字母排列",
            "Recently used": "最近使用的",
            "Least recently used": "最近使用最少的",

            "Never used · Owned by": "从未使用 · 作者",
            "Last used within the last week · Owned by": "最后一次使用是最近 1 周之内 · 作者",

            "Report abuse": "举报滥用",
            "Revoke": "撤销",

            // 撤销对话框
            "Are you sure you want to revoke authorization?": "您确定要撤销授权吗？",
            "I understand, revoke access": "我明白了，依然撤销访问",

            // 全部撤销对话框
            "Are you sure you want to revoke access for all applications?": "您确定要撤销对所有应用的访问权限吗？",
            "This will revoke access for": "这将撤销访问",
            "all third-party": "所有第三方",
            "OAuth applications. This action cannot be undone.": "OAuth 应用。此操作无法撤消。",
            "Any SSH keys created on your behalf by applications will also be deleted.": "任何由应用代表您创建的 SSH 密钥也将被删除。",
            "Type your username to confirm.": "输入您的用户名进行确认。",
            "I understand, revoke access for everything": "我明白了，依然撤销对一切的访问",

            // 举报滥用对话框
            "Report Abuse": "举报滥用",
            "More options": "更多选项",
            "Revoking will deny future access to your account": "撤销授权，将拒绝今后访问您的账户",

        // 授权的 GitHub 应用授权设置 https://github.com/settings/connections/applications/<client-id>
        // 授权的 OAuth 应用授权设置 https://github.com/settings/connections/applications/<id>
            "Never used": "从未使用",
            "Last used within the last week": "最后一次使用是最近一周之内",

            "Developed by": "开发者:",
            "Permissions": "权限",
            "Revoke access": "撤销授权",
                "Are you sure you want to revoke authorization?": "您确定要撤销授权吗？",
                    // [/(.+) will no longer be able to access the GitHub API. You cannot undo this action./, "$1 将无法再访问 GitHub API。您无法撤销此操作。"],
                "I understand, revoke access": "我明白了，依然撤销授权",
                    "Revoking…": "撤消中…",

            "Applications act on your behalf to access your data based on the permissions you grant them. Organizations control which applications are allowed to access their private data. Applications you authorize will always have access to public data in your organizations.": "应用根据您授予的权限代表您访问数据。组织可控制允许哪些应用访问其私人数据。您授权的应用始终可以访问您组织中的公共数据。",
            "Read about third-party access.": "了解关于第三方访问的信息。",

            "Organization access": "组织权限",
                "Grant": "批准",
                "This organization allows the application to access organization data as described in the permissions above.": "该组织允许应用访问上述权限中所述的组织数据。",
                "Request": "请求",
                    "Until access is granted by an owner, the application cannot access the organization’s private data or modify its public data.": "在所有者授予访问权限之前，应用无法访问组织的私有数据或修改其公共数据。",

        // 组织 OAuth 应用策略设置 /orgs/<orgs-name>/policies/applications/<id>
            "approval requested by": "请求批准:",
            "Currently:": "当前",
                "No private access": "无法访问私有",
                "Approved": "已批准",
            "Review third-party application access request": "审查第三方应用访问请求",
                "Grant access": "批准访问",
                "Granting access will give this application the ability to request access to private data in the": "授权该应用访问私有数据在",
                "organization.": "组织。",

                "Deny access": "拒绝访问",
                "Denying access will remove this application’s ability to request access to private data in the": "拒绝该应用访问数据在",

            // 顶部提醒
                // [/(.*) is authorized to access this organization’s resources/, "$1 已获授权访问该组织的资源"],
                // [/(.*) is denied access this organization’s resources/, "$1 被拒绝访问该组织的资源"],

            "Applications act on your behalf to access your data based on the permissions you grant them. Organizations control which applications are allowed to access their private data. Applications authorized by members will always have access to public data in your organization.": "应用根据您授予的权限代表您访问数据。组织可控制允许哪些应用访问其私有数据。成员授权的应用始终可以访问组织中的公共数据。",
            "Read about organization OAuth app access restrictions.": "了解有关组织 OAuth 应用访问限制的信息。",

    },
    "regexp": [ // 正则翻译
        [/Your installation was suspended by you on/, "您的安装已暂停于"],
        [/This action cannot be undone. Are you sure you want to uninstall this GitHub App from (\d+) repositor(y|ies)?/, "此操作无法撤消。您确定要从 $1 个仓库中卸载此 GitHub 应用吗？"],
        [/Uninstall "(.*)"/, "卸载 “$1”"],
        [/You will no longer be able to sign in to ([^ ]+) \(all administrative privileges will be bestowed upon the owners you choose\)/, "您将无法再登录 $1（所有管理权限都将授予您选择的所有者）"],
        [/(\d+) applications?/, "$1 个应用"],
        [/([^ ]+) will no longer be able to access your GitHub account. You cannot undo this action./, "$1 将无法再访问您的 GitHub 账户。您无法撤消此操作。"],
        [/([^ ]+) has been revoked from your account./, "$1 已经从您的账户中被撤销了。"],
        [/Last used within the last (\d+) weeks? · Owned by/, "最后一次使用是最近 $1 周之内 · 作者"],
        [/Last used within the last (\d+) months? · Owned by/, "最后一次使用是最近 $1 月之内 · 作者"],
        [/Selected (\d+) repositor(y|ies)./, "选择了 $1 个仓库。"],
        [/You're all set! (.*) has been uninstalled./, "一切就绪！$1 已被卸载。"],
        [/You're all set! A job has been queued to uninstall the \'(.*)\' app./, "一切就绪！卸载 “$1” 应用的任务已排队等候。"],
        [/Okay, (.*) was installed on the (@[^ ]+) account./, "好的，$1 已安装在 $2 账户上。"],
        [/Okay, (.*) was updated for the (@[^ ]+) account./, "好的，$2 账户的 $1 已更新。"],
        [/Last used within the last (\d+) weeks?/, "最后一次使用是最近 $1 周之内"],
        [/Last used within the last (\d+) months?/, "最后一次使用是最近 $1 月之内"],
        [/(.+) will no longer be able to access the GitHub API. You cannot undo this action./, "$1 将无法再访问 GitHub API。您无法撤销此操作。"],
        [/is requesting an update to its permissions./, "正在请求更新其权限。"],
        [/The (.*) app by/, "$1 应用（由"],
        [/The (.*) app will retain its current permissions if you choose not to accept the new permissions./, "如果您选择不接受新权限，“$1” 应用将保留其当前权限。"],
        [/(.*) is authorized to access this organization’s resources/, "$1 已获授权访问该组织的资源"],
        [/(.*) is denied access this organization’s resources/, "$1 被拒绝访问该组织的资源"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Installed GitHub Apps": "已安装的 GitHub 应用",
            "Authorized GitHub Apps": "授权的 GitHub 应用",
            "Authorized OAuth Apps": "授权的 OAuth 应用",
        },
    },
};
I18N["zh-CN"]["settings/apps/authorizations"] = I18N["zh-CN"]["settings/installations"];
I18N["zh-CN"]["settings/applications"] = I18N["zh-CN"]["settings/installations"];
I18N["zh-CN"]["settings/connections/applications"] = I18N["zh-CN"]["settings/installations"];
I18N["zh-CN"]["orgs/settings/installations"] = I18N["zh-CN"]["settings/installations"];
I18N["zh-CN"]["orgs/policies/applications"] = I18N["zh-CN"]["settings/installations"];

I18N["zh-CN"]["settings/reminders"] = { // 设置 - 定时提醒
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // 定时提醒 https://github.com/settings/reminders
            "Reminders allow you to push certain events to authorized instances of Microsoft Teams or Slack.": "提醒功能允许您将特定事件推送到 Microsoft Teams 或 Slack 的授权实例。",
            "To use scheduled reminders, make sure that the Slack or Microsoft Teams integration is installed and up-to-date. If you need help with this, please contact your organization's owner.": "要使用定时提醒，请确保已安装 Slack 或 Microsoft Teams 集成并且是最新版本，如果您需要这方面的帮助，请联系您组织的所有者。",
            "Available organizations": "可用的组织",
            "Unavailable organizations": "不可用的组织",
            "Configure Reminder": "配置提醒",
            "No reminders": "没有提醒",
            "Needs installing": "需要安装",

        // 新的预定提醒 https://github.com/settings/reminders/<orgs-name>
            "New scheduled reminder": "新建预定提醒",
            "Slack workspace": "Slack 工作区",
            "Authorize Slack workspace": "授权 Slack 工作区",
            "Days": "天",
                "Weekdays": "工作日",
                "Monday"    : "周一",
                "Tuesday"   : "周二",
                "Wednesday" : "周三",
                "Thursday"  : "周四",
                "Friday"    : "周五",
                "Saturday"  : "周六",
                "Sunday"    : "周日",
            "Times": "时间",
                "Filter": "筛选",
            "Review requests assigned to you": "审查分配给您的请求",
                "Receive reminders for reviews waiting on you.": "接收等待您的审查提醒。",
            "Review requests assigned to your team": "审查分配给您团队的请求",
                "Receive reminders for reviews waiting on your team.": "接收等待您的团队的审查提醒。",
            "Enable real-time alerts": "启用实时警报",
                "Receive immediate Slack messages when certain events happen": "当某些事件发生时，会立即收到 Slack 消息",

            "You will only receive notifications from public repositories in this organization because the current plan for": "您将只收到来自该组织中公共仓库的通知，因为目前",
            "does not support reminders for private repositories.": "的计划不支持私人仓库的提醒。",
            "Upgrade to Team": "升级为团队",
            "Create reminder": "创建提醒者",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Scheduled reminders": "定时提醒",
        },
    },
};

I18N["zh-CN"]["settings/security-log"] = { // 设置 - 安全日志
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Security log 安全日志 https://github.com/settings/security-log
            "Loading audit log entries…": "正在加载日志条目…",
            "Filters": "筛选",
                "Filter audit logs": "筛选审计日志",
                "Yesterday's activity": "昨天的活动",
                "Repository management": "仓库管理",
                "Billing updates": "账单更新",
                "Copilot activity": "Copilot 活动",
                "Personal access token activity": "个人访问令牌活动",
                "View advanced search syntax": "查看高级搜索语法",
            "Filter by Member": "按用户筛选",
            "Filter by Action": "按事件筛选",
            "Search audit logs": "搜索审计日志",
            "Search your security log": "搜索您的安全日志",
            "Clear current search query": "清除当前的搜索查询",
            "Events matching search query": "搜索查询匹配结果",
            "Export": "导出",
            "Recent events": "最近的事件",
            "Unknown IP address": "未知 IP 地址",
            "Unknown location": "未知位置",
            // [/Found (\d+) events?/, "发现 $1 个活动"],
            "Newer": "新的",
            "Older": "旧的",
            "ProTip!": "专业提示！",
                "View all events created yesterday": "查看昨天创建的所有事件",
                "View all events where you created something": "查看所有您创建内容时产生的事件",
            "Country changed from your previous session": "国家或地区与上一次会话有所不同",
            "Logged in": "登录",
            "User signed in from an unrecognized device.": "用户从无法识别的设备登录。",
            "User signed in from an unrecognized device and location.": "用户从无法识别的设备与位置登录。",
            "New Device Used": "使用新设备",
            "Created the repository": "创建了仓库",
            "Deleted the repository": "删除了仓库",
            "Created GitHub Pages site in": "创建了 GitHub Pages 在",
            "Modified GitHub Pages source in": "修改了 GitHub Pages 源代码在",
            "Created environment": "创造环境",
            "Added": "添加",
            "to the": "至",
            "repository": "仓库",
                "organization with": "组织，使用",
                "read": "读取",
                "permission": "权限",
            "Added the following repositories to the": "添加以下仓库到",
            "Removed the following repositories from the": "删除以下仓库到",
            "integration:": "集成：",
            "Enabled GitHub Actions for": "启用仓库操作：",
            "Created a secret for": "创建机密：",
            "Created a token for": "创建令牌：",
            "Regenerated a token for": "重新生成令牌：",
            "Revoked a token for": "撤销令牌：",
                "ending in": "结尾",
                "for the": "用于",
                "GitHub App": "GitHub 应用",

            "We couldn’t find any events matching your search.": "无匹配结果。",

    },
    "regexp": [ // 正则翻译
        [/Found (\d+) events?/, "发现 $1 个活动"],
        [/View ([^ ]+)'s profile/, "查看 $1 的资料"],
    ],
    "title": {
        "static": {
            "Security log": "安全日志",
        },
    },
};

I18N["zh-CN"]["settings/sponsors-log"] = { // 设置 - 赞助日志
    "static": { // 静态翻译
        ...I18N["zh-CN"]["settings-menu"]["static"],

        // Sponsorship log 赞助日志 https://github.com/settings/sponsors-log
            "Sponsors log": "赞助日志",
            "New sponsorships, changes, and cancellations": "新的赞助、更改和取消",
            "Period:": "周期：",
            "Filter activity": "筛选活动",
            "All-time": "所有时间",
            "Past day": "过去一天",
            "Past week": "过去一周",
            "Past month": "过去一月",
            "Past year": "过去一年",
            "No sponsorship activity in this time period": "这段时间没有赞助活动",
            "This is where you can review activity from your sponsorships.": "您可以在此处查看您的赞助活动。",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Sponsorship Log": "赞助日志",
        },
    },
};

I18N["zh-CN"]["settings/apps"] = { // 设置 - 开发者设置/GitHub 应用
    "static": { // 静态翻译
        "Developer Settings": "开发者设置",
        "GitHub Apps": "GitHub 应用",
        "OAuth Apps": "OAuth 应用",
        "Personal access tokens": "个人访问令牌",
            "Fine-grained tokens": "精细化的令牌",
            "Tokens (classic)": "令牌（经典）",

        // GitHub 应用 https://github.com/settings/apps
            // 顶部提醒
                "Job queued to revoke all user tokens": "撤销所有用户令牌的任务已排队等待",

            "Register a new GitHub App": "注册新的 GitHub 应用",
            "Want to build something that integrates with and extends GitHub?": "想要构建与 GitHub 集成和扩展的东西吗？",
            "New GitHub App": "注册新 GitHub 应用",
            "to get started developing on the GitHub API. You can also read more about building GitHub Apps in our": "，开始在 GitHub API 上进行开发。您还可以在我们的文档中阅读更多关于构建 GitHub 应用的信息",
            "developer documentation": "开发者文档",
            "A GitHub App can act on its own behalf, taking actions via the API directly instead of impersonating a user. Read more in our": "GitHub 应用可以代表自己执行操作，直接通过 API 执行操作，而不是冒充用户。阅读我们的更多内容", // 存在 app时

            // 无应用提示
                "No GitHub Apps": "无 GitHub 应用",
                    "Want to build something that integrates with and extends GitHub? Register a new GitHub App to get started developing on the GitHub API.": "想创建与 GitHub 集成并扩展 GitHub 的应用程序吗？注册一个新的 GitHub 应用程序，开始使用 GitHub API 进行开发。",

                "View documentation": "查看文档",

        // 注册 GitHub 应用 https://github.com/settings/apps/new
            "Register new GitHub App": "注册新 GitHub 应用",
            "GitHub App name": "GitHub 应用名称",
            "The name of your GitHub App.": "您的 GitHub 应用的名称。",
            "Markdown supported": "支持 Markdown 语法",
            "This is displayed to users of your GitHub App": "展示给 GitHub 应用的使用者",
            "Homepage URL": "主页地址",
                "The full URL to your GitHub App’s website.": "GitHub 应用网站的主页地址",

            "Identifying and authorizing users": "识别并授权用户",
                "The full URL to redirect to after a user authorizes an installation.": "用户授权安装后重定向到的完整地址。",
                "Callback URL documentation": "回调地址文档",
                "Add Callback URL": "添加回调地址",

                "Callback URL": "回调地址",
                "Expire user authorization tokens": "用户授权令牌",
                    "This will provide a": "这将提供一个",
                    "which can be used to request an updated access token when this access token expires.": "，用于在此访问令牌到期时，请求更新访问令牌。",
                "Request user authorization (OAuth) during installation": "在安装期间请求用户授权 (OAuth)",
                    "Requests that the installing user grants access to their identity during installation of your App": "请求用户在安装应用期间授予其身份访问权限。",
                    "Identifying and authorizing users for GitHub Apps documentation": "关于 GitHub 应用识别并授权用户的文档",
                "Enable Device Flow": "启用设备流",
                    "Allow this GitHub App to authorize users via the Device Flow.": "允许此 GitHub 应用通过设备流程授权用户。",
                    "Read the": "阅读",
                    "Device Flow documentation": "设备流程文档",

            "Post installation": "安装完成后",
                "Setup URL (optional)": "设置网址 (可选)",
                    "Users will be redirected to this URL after installing your GitHub App to complete additional setup.": "用户在安装完 GitHub 应用后，会被重定向到这个网址，以完成额外的设置。",
                    "Unavailable when requesting OAuth during installation.": "安装过程中请求 OAuth 时不可用。",
                    "Users will be redirected to the 'User authorization callback URL' to complete additional setup.": "用户将被重定向到 “用户授权回调网址” 以完成其他设置。",
                "Redirect on update": "更新时重定向",
                    "Redirect users to the 'Setup URL' after installations are updated (E.g. repositories added/removed).": "在安装后更新时将用户重定向到 “设置网址”（例如: 添加/删除仓库）。",
                    "Redirect users to the 'User authorization callback URL' after installations are updated (E.g repositories added/removed).": "在安装后更新时将用户重定向到 “用户授权回调网址”（例如: 添加/删除仓库）。",

            "Webhook": "Web 钩子",
                "Active": "激活",
                    "We will deliver event details when this hook is triggered.": "当钩子被触发时，我们将提供事件详细信息。",
                "Webhook URL": "Web 钩子网址",
                    "Events will POST to this URL. Read our": "事件将 POST 到此网址。阅读",
                    "webhook documentation": "关于 Web 钩子",
                    "for more information.": "以获取更多信息。",
                "Secret": "机密",
                    "Read our": "阅读我们",
                    "webhook secret documentation": "Web 钩子机密文档",

            "Permissions": "权限",
                "User permissions are granted on an individual user basis as part of the": "用户权限的授予是以单个用户为基础的，是一个环节",
                "User authorization flow": "用户授权流程",
                "permissions documentation": "权限文档",
                "for information about specific permissions.": "以了解关于特定权限的信息。",

                "Access:": "访问权限：",
                "Select an access level": "选择访问级别",
                "No access": "禁止访问",
                "Read-only": "只读",
                "Read and write": "读写",
                "Admin": "管理员",

                  "Selected": "项被选中",
                  "mandatory": "强制",

                "Repository permissions": "仓库权限",
                    "Repository permissions permit access to repositories and related resources.": "仓库权限允许访问仓库和相关资源。",

                    "Actions": "操作",
                        "Workflows, workflow runs and artifacts.": "工作流程、工作流程的运行和工件。",
                    "Administration": "管理",
                        "Repository creation, deletion, settings, teams, and collaborators.": "仓库创建、删除、设置、团队和协作者。",
                    "Attestations": "证书",
                        "Create and retrieve attestations for a repository.": "创建和检索仓库的证书。",
                    "Checks": "检查",
                        "Checks on code.": "检查代码。",
                    "Code scanning alerts": "代码扫描警报",
                        "View and manage code scanning alerts.": "查看和管理代码扫描警报。",
                    // "": "代码空间",
                        "Create, edit, delete and list Codespaces.": "创建、编辑、删除和列出代码空间。",
                    "Codespaces lifecycle admin": "代码空间的生命周期管理",
                        "Manage the lifecycle of Codespaces, including starting and stopping.": "管理代码空间的生命周期，包括启动和停止。",
                    "Codespaces metadata": "代码空间元数据",
                        "Access Codespaces metadata including the devcontainers and machine type.": "访问代码空间元数据，包括开发容器和机器类型。",
                    "Codespaces secrets": "代码空间机密",
                        "Restrict Codespaces user secrets modifications to specific repositories.": "限制代码空间的用户机密对特定仓库的修改。",
                    "Commit statuses": "提交状态",
                        "Commit statuses.": "提交状态。",
                    "Contents": "内容",
                        "Repository contents, commits, branches, downloads, releases, and merges.": "仓库内容、提交、分支、下载、发布和合并。",
                    // 自定义属性
                        "View and set values for a repository's custom properties, when allowed by the property.": "在属性允许的情况下，查看和设置仓库自定义属性的值。",
                    "Dependabot alerts": "Dependabot 警报",
                        "Retrieve Dependabot alerts.": "检索 Dependabot 警报。",
                    "Dependabot secrets": "Dependabot 机密",
                        "Manage Dependabot repository secrets.": "管理 Dependabot 仓库的机密。",
                    "Deployments": "部署",
                        "Deployments and deployment statuses.": "部署和部署状态。",
                    "Discussions": "讨论",
                        "Discussions and related comments and labels.": "讨论及相关评论和标签。",
                    "Environments": "环境",
                        "Manage repository environments.": "管理仓库环境。",
                    "Issues": "议题",
                        "Issues and related comments, assignees, labels, and milestones.": "议题及相关评论、受理人、标签和里程碑。",
                    "Merge queues": "合并列队",
                        "Manage a repository's merge queues": "管理仓库的合并队列。",
                    "Metadata": "元数据",
                        "Search repositories, list collaborators, and access repository metadata.": "搜索仓库、列出协作者，访问仓库元数据。",
                    "Packages": "软件包",
                        "Packages published to the GitHub Package Platform.": "发布软件包到 GitHub Package 平台。",
                    "Pages": "GitHub Pages",
                        "Retrieve Pages statuses, configuration, and builds, as well as create new builds.": "检索页面状态、配置和构建，以及创建新的构建。",
                    "Projects": "项目",
                        "Manage classic projects within a repository.": "管理仓库中的经典项目。",
                    "Pull requests": "拉取请求",
                        "Pull requests and related comments, assignees, labels, milestones, and merges.": "拉取请求及相关评论、受让人、标签、里程碑和合并。",
                    "Repository security advisories": "仓库安全公告",
                        "View and manage repository security advisories.": "查看和管理安全公告",
                    "Secret scanning alerts": "机密扫描警报",
                        "View and manage secret scanning alerts.": "查看和管理机密扫描警报。",
                    "Secrets": "机密",
                        "Manage Actions repository secrets.": "管理操作仓库机密。",
                    "Single file": "单个文件",
                        "Manage just a single file.": "只管理单个文件。",
                        "Path": "路径",
                        "The content paths to single files your app can access.": "应用可以访问的单个文件的内容路径。",
                    "Variables": "变量",
                        "Manage Actions repository variables.": "管理操作仓库变量。",
                    "Webhooks": "Web 钩子",
                        "Manage the post-receive hooks for a repository.": "管理仓库的接收后钩子。",
                    "Workflows": "工作流程",
                        "Update GitHub Action workflow files.": "更新 GitHub Action 工作流程文件。",

                "Organization permissions": "组织权限",
                    "Organization permissions permit access to organization related resources.": "组织权限允许访问组织相关资源。",

                    "API Insights": "API 洞察",
                        "View statistics on how the API is being used for an organization.": "查看有关组织如何使用 API 的统计信息。",
                    // 管理
                        "Manage access to an organization.": "管理对组织的访问。",
                    "Blocking users": "拉黑用户",
                        "View and manage users blocked by the organization.": "查看和管理被组织拉黑的用户。",
                    "Custom organization roles": "自定义组织角色",
                        "Create, edit, delete and list custom organization roles. View system organization roles.": "创建、编辑、删除和列出自定义组织角色。查看系统组织角色。",
                    "Custom properties": "自定义属性",
                        "View custom properties, write repository values, and administer definitions.": "查看自定义属性、写入仓库值并管理定义。",
                    "Custom repository roles": "自定义仓库角色",
                        "Create, edit, delete and list custom repository roles.": "创建、编辑、删除和列出自定义仓库角色。",
                    "Events": "活动",
                        "View events triggered by an activity in an organization.": "查看组织中某项活动所触发的事件。",
                    "GitHub Copilot Business": "GitHub Copilot 商业版",
                        "Manage Copilot Business seats and settings": "管理 GitHub Copilot 商业版席位和设置",
                    "Knowledge bases": "知识库",
                        "View and manage knowledge bases for an organization.": "查看和管理组织的知识库。",
                    "Members": "成员",
                        "Organization members and teams.": "组织成员和团队。",
                    "Organization announcement banners": "组织公告横幅",
                        "View and modify announcement banners for an organization.": "查看并修改组织的公告横幅。",
                    "Organization codespaces": "组织代码空间",
                        "Manage Codespaces for an organization.": "管理组织的代码空间。",
                    "Organization codespaces secrets": "组织代码空间机密",
                        "Manage Codespaces Secrets for an organization.": "管理组织的代码空间机密。",
                    "Organization codespaces settings": "组织代码空间设置",
                        "Manage Codespaces settings for an organization.": "管理组织的代码空间设置。",
                    "Organization dependabot secrets": "组织 Dependabot 机密",
                        "Manage Dependabot organization secrets.": "管理 Dependabot 组织的机密。",
                    "Organization private registries": "组织私有注册表",
                        "Manage private registries for an organization.": "管理组织的私有注册表。",
                    "Personal access token requests": "个人访问令牌请求",
                        "Manage personal access token requests from organization members.": "管理来自组织成员的个人访问令牌请求。",
                    "Personal access tokens": "个人访问令牌",
                        "View and revoke personal access tokens that have been granted access to an organization.": "查看和撤销已被授予组织访问权限的个人访问令牌。",
                    "Plan": "计划",
                        "View an organization's plan.": "查看组织的计划。",
                    // 项目
                        "Manage projects for an organization.": "管理组织的项目。",
                    // 机密
                        "Manage Actions organization secrets.": "管理操作组织机密",
                    "Self-hosted runners": "自托管运行器",
                        "View and manage Actions self-hosted runners available to an organization.": "查看和管理组织可用的 “操作自托管运行器”。",
                    "Team discussions": "团队讨论",
                        "Manage team discussions and related comments.": "管理团队讨论及相关评论。",
                    // 变量
                        "Manage Actions organization variables.": "管理操作组织变量。",
                    // Web 钩子
                        "Manage the post-receive hooks for an organization.": "管理组织的接收后钩子。",

                "Account permissions": "账户权限",
                    "These permissions are granted on an individual user basis as part of the User authorization flow.": "这些权限是在单个用户的基础上授予的，作为用户授权流程的一部分",

                    "Block another user": "拉黑其他用户",
                        "View and manage users blocked by the user.": "查看和管理被用户拉黑的用户。",
                    "Codespaces user secrets": "代码空间用户机密",
                        "Manage Codespaces user secrets.": "管理代码空间用户机密。",
                    "Copilot Chat ": "",
                        "This application will receive your GitHub ID, your GitHub Copilot Chat session messages (not including messages sent to another application), and timestamps of provided GitHub Copilot Chat session messages. This permission must be enabled for Copilot Extensions.": "此应用将接收您的 GitHub ID、GitHub Copilot Chat 会话消息（不包括发送到其他应用的消息）以及所提供的 GitHub Copilot Chat 会话消息的时间戳。Copilot 扩展必须启用此权限。",
                    "Copilot Editor Context": "Copilot 编辑器语境",
                        "This application will receive bits of Editor Context (e.g. currently opened file) whenever you send it a message through Copilot Chat.": "每当您通过 Copilot Chat 向应用发送消息时，该应用都会收到一些编辑器上下文（例如当前打开的文件）。",
                    "Email addresses": "电子邮箱地址",
                        "Manage a user's email addresses.": "管理用户的电子邮箱地址。",
                    // 活动
                        "View events triggered by a user's activity.": "查看用户活动触发的事件。",
                    // 关注者
                        "A user's followers": "用户的关注者",
                    "GPG keys": "GPG 密钥",
                        "View and manage a user's GPG keys.": "查看和管理用户的 GPG 密钥。",
                    // Gist
                        "Create and modify a user's gists and comments.": "创建和修改用户的代码片段和评论。",
                    "Git SSH keys": "Git SSH 密钥",
                    "Interaction limits": "交互限制",
                        "Interaction limits on repositories": "仓库的交互限制",
                    // 计划
                        "View a user's plan.": "查看用户的计划。",
                    "Profile": "个人信息",
                        "Manage a user's profile settings.": "管理用户的个人信息设置。",
                    "SSH signing keys": "SSH 签名密钥",
                        "View and manage a user's SSH signing keys.": "查看和管理用户的 SSH 签名密钥。",
                    "Starring": "星标",
                        "List and manage repositories a user is starring.": "列出和管理用户标星的仓库。",
                    "Watching": "关注",
                        "List and change repositories a user is subscribed to.": "列出和更改用户订阅的仓库。",

            // 以下的事件 与 钩子页面 一致
            // 添加钩子 页面 /<user-name>/<repo-name>/settings/hooks/new
            "Subscribe to events": "订阅事件",
                "Based on the permissions you’ve selected, what events would you like to subscribe to?": "根据您选择的权限，您想订阅哪些事件？",
                "Installation target": "安装目标",
                    "A GitHub App installation target is renamed.": "GitHub 应用安装目标已重命名。",
                "Meta": "元数据",
                    "When this App is deleted and the associated hook is removed.": "当该应用被删除和相关的钩子被删除时。",
                "Security advisory": "安全提示",
                    "Security advisory published, updated, or withdrawn.": "安全提示的发布、更新或撤销。",
                "Branch protection configuration": "分支保护配置",
                    "All branch protections disabled or enabled for a repository.": "禁用或启用仓库的所有分支保护。",
                "Branch protection rule": "分支保护规则",
                    "Branch protection rule created, deleted or edited.": "分支保护规则的创建、删除或编辑。",
                "Code scanning alert": "代码扫描警报",
                    "Code Scanning alert created, fixed in branch, or closed": "代码扫描警报的创建、在分支中修复或关闭。",
                "Check run": "检查运行",
                    "Check run is created, requested, rerequested, or completed.": "检查运行的创建、请求、重新请求或完成。",
                "Check suite": "检查套件",
                    "Check suite is requested, rerequested, or completed.": "检查套件的请求、重新请求或完成。",
                "Commit comment": "提交评论",
                    "Commit or diff commented on.": "提交或差异评论。",
                //"创建": "",
                    "Branch or tag created.": "分支或标签的创建。",
                "Custom property": "自定义属性",
                    "Custom property is created, updated, or deleted.": "自定义属性的创建、更新或删除。",
                "Custom property values": "自定义属性值",
                    "Custom property values are changed for a repository": "仓库自定义属性值的更改。",
                "Discussion": "讨论",
                    "Discussion created, edited, closed, reopened, pinned, unpinned, locked, unlocked, transferred, answered, unanswered, labeled, unlabeled, had its category changed, or was deleted.": "讨论的创建、编辑、关闭、重新打开、置顶、取消置顶、锁定、解锁、转移、答复、取消答复、标记、取消标记、更改其类别或删除。",
                "Discussion comment": "讨论评论",
                    "Discussion comment created, edited, or deleted.": "讨论评论的创建、编辑或删除。",
                //"删除": "",
                    "Branch or tag deleted.": "分支或标签的删除。",
                "Dependabot alert": "Dependabot 警报",
                    "Dependabot alert auto_dismissed, auto_reopened, created, dismissed, reopened, fixed, or reintroduced.": "Dependabot 警报的自动解除、自动重新打开、创建、解除、重新打开、修复或重新引入。",
                "Deploy key": "部署密钥",
                    "A deploy key is created or deleted from a repository.": "在仓库中部署密钥的创建或删除。",
                "Deployment": "部署",
                    "Repository was deployed or a deployment was deleted.": "仓库的部署或删除部署。",
                "Deployment protection rule": "部署保护规则",
                    "Deployment protection rule requested for an environment.": "环境请求部署保护规则。",
                "Deployment review": "部署审查",
                    "Deployment review requested, approved or rejected": "部署审查的请求、批准或拒绝",
                "Deployment status": "部署状态",
                    "Deployment status updated from the API.": "通过 API 更新部署状态。",
                "Exemption request push ruleset": "推送规则集豁免请求",
                    "Push ruleset bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push rules is currently in beta and subject to change.": "推送规则集旁路请求已创建、取消、完成、收到响应或驳回响应。注：推送规则的委托旁路目前处于测试阶段，可能会有更改。",
                "Exemption request secret scanning": "秘密扫描豁免请求",
                    "Secret scanning push protection bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push protection is currently in beta and subject to change.": "秘密扫描推送保护旁路请求已创建、取消、完成、收到响应或驳回响应。注：推送保护的授权旁路目前处于测试阶段，可能会有更改。",
                //"复刻": "",
                    "Repository forked.": "仓库复刻。",
                "Gollum": "咕噜",
                    "Wiki page updated.": "Wiki 页面的更新。",
                "Issue comment": "议题评论",
                    "Issue comment created, edited, or deleted.": "议题评论的创建、编辑或删除。",
                //"议题": "",
                    "Issue opened, edited, deleted, transferred, pinned, unpinned, closed, reopened, assigned, unassigned, labeled, unlabeled, milestoned, demilestoned, locked, unlocked, typed, or untyped.": "议题的打开、编辑、删除、转移、置顶、取消置顶、关闭、重新打开、分配、取消分配、标记、取消标记、设置里程碑、取消里程碑、锁定、解锁。",
                "Label": "标签",
                    "Label created, edited or deleted.": "标签的创建、编辑或删除。",
                "Milestone": "里程碑",
                    "Milestone created, closed, opened, edited, or deleted.": "里程碑的创建、关闭、打开、编辑或删除。",
                "Member": "成员",
                    "Collaborator added to, removed from, or has changed permissions for a repository.": "协作者添加到仓库、从仓库中删除或更改了仓库的权限。",
                "Membership": "团队成员",
                    "Team membership added or removed.": "团队成员的添加或删除。",
                "Merge group": "合并组",
                    "Merge Group requested checks, or was destroyed.": "合并组的请求检查或销毁。",
                "Merge queue entry": "合并队列条目",
                    "Merge Queue entry added": "合并队列条目的添加。",
                "Organization": "组织",
                    "Organization deleted, renamed, member invited, member added, or member removed.": "组织的删除、重命名以及成员的邀请、添加或删除。",
                "Page build": "构建 GitHub Pages",
                    "Pages site built.": "GitHub Pages 站点的建立。",
                "Personal access token request": "个人访问令牌请求",
                    "Personal access token request created, approved, denied, or cancelled.": "个人访问令牌请求的创建、批准、拒绝或取消。",
                "Project": "项目",
                    "Project created, updated, or deleted.": "项目的创建、更新或删除。",
                "Project card": "项目面板卡",
                    "Project card created, updated, or deleted.": "项目面板卡的创建、更新或删除",
                "Project column": "项目栏目",
                    "Project column created, updated, moved or deleted.": "项目栏目的创建、更新、移动或删除。",
                "Projects v2 item": "项目 v2 条目",
                    "Project item created, edited, deleted, archived, restored, converted, or reordered.": "项目条目的创建、编辑、删除、归档、恢复、转换或重新排序。",
                "Projects v2": "项目 v2",
                    "Project created, updated, deleted, closed, or reopened.": "项目的创建、更新、删除、关闭或重新打开。",
                "Projects v2 status update": "项目 v2 状态更新",
                    "Project status updates created, updated, or deleted.": "项目状态更新的创建、更新或删除。",
                // 公共
                    "Repository changes from private to public.": "仓库从私有更改为公共。",
                "Pull request": "拉取请求",
                    "Pull request assigned, auto merge disabled, auto merge enabled, closed, converted to draft, demilestoned, dequeued, edited, enqueued, labeled, locked, milestoned, opened, ready for review, reopened, review request removed, review requested, synchronized, unassigned, unlabeled, or unlocked.": "拉取请求的分配、禁用自动合并、启用自动合并、关闭、转换为草案、取消里程碑、取消队列、编辑、队列、标记、锁定、设置里程碑、打开、准备审查、重新打开、取消审查请求、请求审查、同步、取消分配、取消标记或解锁。",
                "Pull request review": "拉取请求审查",
                    "Pull request review submitted, edited, or dismissed.": "拉取请求审查的提交、编辑或驳回。",
                "Pull request review comment": "拉取请求审查意见",
                    "Pull request diff comment created, edited, or deleted.": "拉取请求差异评论的创建、编辑或删除。",
                "Pull request review thread": "拉取请求线程",
                    "A pull request review thread was resolved or unresolved.": "拉取请求的审查线程解决或未解决。",
                "Push": "推送",
                    "Git push to a repository.": "Git 推送到仓库。",
                "Registry package": "注册软件包",
                    "Registry package published or updated in a repository.": "仓库中注册软件包的发布或更新。",
                "Release": "发行版",
                    "Release created, edited, published, unpublished, or deleted.": "发行版的创建、编辑、发布、取消发布或删除。",
                "Repository": "仓库",
                    "Repository created, deleted, archived, unarchived, publicized, privatized, edited, renamed, or transferred.": "仓库的创建、删除、归档、取消归档、公开、私有化、编辑、重命名或转让。",
                "Repository dispatch": "仓库调度",
                    "When a message is dispatched from a repository.": "当信息从仓库发出时。",
                "Repository ruleset": "仓库规则集",
                    "Repository ruleset created, deleted or edited.": "仓库规则集的创建、删除或编辑。",
                "Security and analysis": "安全和分析",
                    "Code security features enabled or disabled for a repository.": "启用或禁用仓库的代码安全功能。",
                "Secret scanning alert": "机密扫描警报",
                    "Secrets scanning alert created, resolved, reopened, validated, or publicly leaked.": "机密扫描警报的创建、解决、重新打开、验证或公开泄露。",
                "Secret scanning alert location": "机密扫描警报位置",
                    "Secrets scanning alert location created.": "机密扫描警报位置的创建。",
                "Secret scanning scan": "机密扫描",
                    "Secrets scanning scan completed.": "机密扫描已完成",
                // 星标
                    "A star is created or deleted from a repository.": "标星或取消仓库星标。",
                //"状态": "",
                    "Commit status updated from the API.": "通过 API 更新提交状态。",
                //"团队": "",
                    "Team is created, deleted, edited, or added to/removed from a repository.": "团队的创建、删除、编辑以及向仓库添加团队、从仓库中移除团队。",
                "Sub issues": "子议题",
                    "Sub-issues added or removed, and parent issues added or removed.": "子议题和父议题的添加或删除。",
                "Team add": "团队添加",
                    "Team added or modified on a repository.": "仓库团队的添加或修改。",
                "Watch": "关注",
                    "User stars a repository.": "用户标星仓库。",
                "Workflow dispatch": "工作流程调度",
                    "A manual workflow run is requested.": "请求手动运行工作流程。",
                "Workflow job": "工作流程作业",
                    "Workflow job queued, waiting, in progress, or completed on a repository.": "仓库中工作流作业的队列、等待、正在进行或完成。",
                "Workflow run": "工作流程运行",
                    "Workflow run requested or completed on a repository.": "仓库中工作流程运行的请求或完成。",
                "Org block": "组织黑名单", // 组织设置
                    "A user has been blocked or unblocked.": "用户拉黑或解除拉黑。",
                "Repository advisory": "仓库公告",
                    "Repository advisory published or reported.": "仓库公告发布或报告。",
                "Sub issues": "子提议",
                    "Sub-issues added or removed, and parent issues added or removed.": "子议题和父议题的添加或删除。",

            "Where can this GitHub App be installed?": "这款 GitHub 应用可以安装在哪里？",
                "Only on this account": "仅在当前账户",
                    // [/Only allow this GitHub App to be installed on the (@[^ ]+) account./, "仅允许在 $1 帐户上安装此 GitHub 应用。"],
                "Any account": "任何账户",
                    "Allow this GitHub App to be installed by any user or organization.": "允许任何用户或组织安装此 GitHub 应用。",

            "Create GitHub App": "创建 GitHub 应用",

        // 某个 GitHub 应用 https://github.com/settings/apps/<app-name>
            // 顶部提醒
                // GitHub App 注册成功
                "Registration successful. You must": "注册成功。您必须",
                "generate a private key": "生成私钥",
                "in order to install your GitHub App.": "才能安装 GitHub 应用。",
                // GitHub App 已更新
                "Got it. Your GitHub App has been updated.": "GitHub 应用已更新。",
                "The GitHub App is now public. Anyone is free to install it.": "GitHub 应用已公开化。任何人都可以自由安装。",
                "The GitHub App is now private. It can only be installed on this account.": "GitHub 应用已私有化。只能安装在此账户上。",

            "Developer settings": "开发者设置",
            // 左侧栏
                "General": "通常",
                "Permissions & events": "权限与事件",
                "Install App": "安装应用",
                "Advanced": "高级",
                "Optional features": "可选功能",
                "Public page": "公共页面",

            // 关于
                "Owned by:": "拥有者：",
                "Using your App ID to get installation tokens? You can now": "使用您的 App ID 获取安装令牌？您现在可以",
                "use your Client ID instead": "使用您的 Client ID",
                "Revoke all user tokens": "撤销所有用户令牌",
                "GitHub Apps can use OAuth credentials to identify users. Learn more about identifying users by reading our": "GitHub 应用可以使用 OAuth 凭据来识别用户。了解更多关于识别用户的信息，请阅读我们的",
                "integration developer documentation": "集成开发者文档",

                "Public link": "公共链接",

                // 撤销所有用户令牌对话框
                "Revoke all user tokens?": "撤销所有用户令牌？",
                    "Are you sure you want to revoke": "您确定要撤销此应用的",
                    "all": "所有",
                    "user tokens for this application?": "用户令牌吗？",
                    "All users of this application will be forced back through the": "该应用的所有用户都将被迫返回",
                    "authorization flow": "授权流程",
                    "before they can use your application again.": "，然后才能再次使用您的应用。",
                    "All SSH keys created by this application will also be deleted.": "此应用创建的所有 SSH 密钥也将被删除。",
                    "This action is not reversible.": "此操作不可逆转。",
                    "I understand, revoke all user tokens": "我明白了，依然撤销所有用户令牌",

            "Client secrets": "客户端机密",
                "Generate a new client secret": "生成客户端机密",
                "You need a client secret to authenticate as the application to the API.": "您需要一个客户端机密，才能以应用的身份验证 API。",

            "Basic information": "基本信息",

            "Display information": "显示信息",
                "Drag & drop": "拖放",
                "Upload a logo...": "上传 Logo 图片…",
                    "Uploading...": "上传中…",
                "You can also drag and drop a picture from your computer.": "您也可以从电脑中拖放图片。",
                        "Only images, please. Try again.": "仅限图片，请重试。",
                        "1MB or less, please. Try again.": "请上传 1MB 以内的文件，请重试。",
                        "Whoops! Try again.": "哎呀！请重试。",
                        "File contents don’t match the file extension. Try again.": "文件内容与扩展名不符，请重试。",

                "Delete this image": "删除图片",
                "Badge background color": "徽章背景颜色",
                "The hex value of the badge background color. Hex colors should only contain numbers and letters from a-f.": "徽章背景颜色的十六进制值。十六进制颜色只能包含 a-f 之间的数字和字母。",
                // 剪裁对话框
                    "Crop your new avatar": "裁剪您的新头像",
                    "Set new avatar": "设置新头像",
                // 顶部提醒
                    "Your avatar has been updated. It may take a few minutes to update across the site.": "您的头像已更新。整个网站的更新可能需要几分钟的时间。",
                    "This avatar has been deleted.": "该头像已被删除。",

            // 市场
                "List your GitHub App in the": "上架您的 GitHub 应用到",
                "GitHub Marketplace": "GitHub 市场",
                "so that other users can discover it.": "以便其他用户可以发现它。",
                "List in Marketplace": "上架应用",

                "Edit how your GitHub App is presented in the Marketplace directory, including screenshots and links.": "编辑 GitHub 应用在市场索引中的展示方式，包括截图和链接。",
                "Edit Marketplace listing": "编辑市场上架信息",

            "Private keys": "私钥",
                "Generate a private key": "生成私钥",
                "You need a private key to sign access token requests.": "您需要私钥来签署访问令牌请求。",

                "Learn more about private keys": "了解更多关于私钥的信息",
                "Private key": "私钥",
                "Added": "已添加于",

            "IP allow list": "IP 允许列表",
                "Enter the IP addresses of your GitHub App to allow organizations with": "输入 GitHub 应用的 IP 地址，以便在安装时允许在",
                "IP allow lists": "IP 允许列表",
                "to selectively inherit the App's IP allow list when installed.": "的组织有选择地继承应用的 IP 允许列表。",
                "Learn more about App IP allow lists": "了解更多关于应用 IP 允许列表的信息",

                "There are no IP addresses on the allow list yet.": "允许列表中尚无 IP 地址。",
                "IP address or range in CIDR notation": "以 CIDR 表示的 IP 地址或范围",
                "Short description of IP address or range": "IP 地址或范围的简短描述",

                "Check IP address": "检查 IP 地址",
                    "Enter an IP address to check whether it is permitted by enabled entries on the IP allow list.": "输入 IP 地址，检查 IP 允许列表中的启用条目是否允许该地址。",

        // 某个 GitHub 应用 - 权限 https://github.com/settings/apps/<app-name>/permissions
            "Changes to permissions will be applied to all future installations. Current users will be prompted to accept any changes and enable the new permissions on their installation.": "对权限的更改将应用于今后的所有安装。系统将提示当前用户接受任何更改，并在其安装中启用新权限。",

            "Add a note to users": "为用户添加注释",
                "This note will be displayed on the permissions update approval page.": "该注释将显示在权限更新批准审查页面上。",
                    "Add a note to your users explaining why you are requesting these changes.": "向您的用户添加注释，解释您请求这些更改的原因。",

                "Are you sure you want to update permissions?": "您确定要更新权限吗？",
                    "Current users will be prompted to accept these changes and enable the new permissions on their installation.": "系统将提示当前用户接受这些更改，并在其安装中启用新权限。",

        // 某个 GitHub 应用 - 智能体 https://github.com/settings/apps/<app-name>/agent
            "A Copilot configuration allows your GitHub App to integrate with Copilot. Learn more about building GitHub Copilot Extensions in the": "Copilot 配置允许您的 GitHub 应用与 Copilot 集成。了解更多关于构建 GitHub Copilot 扩展的信息，请访问",
            "documentation": "文档",

            "Accept the Marketplace Developer agreement to create your Copilot Extension": "接受市场开发者协议以创建您的 Copilot 扩展",
                "By clicking \"Accept Terms\" below, you agree to the": "点击下面的 “接受条款”，即表示您同意以下条款",
                "GitHub Copilot Extension Developer Policy": "GitHub Copilot 扩展开发者政策",
                "Pre-release License terms": "预发布许可条款",
                "on behalf of": "代表",
                ". Please check to make sure that you are agreeing to these terms on behalf of the correct account.": "。请检查以确保您代表正确的帐户同意这些条款。",
                "Accept Terms": "接受条款",

            "To enable Copilot functionality, you must first accept the Marketplace Developer agreement": "要启用 Copilot 功能，您必须首先接受市场开发者协议",
            "To enable Copilot functionality, you must first grant your app permission to read Copilot Messages. To do so, navigate to Permissions & Events > Account Permissions > Read-only for Copilot Chat": "要启用 Copilot 功能，必须先授予应用读取 Copilot 消息的权限。为此，请导航至权限和事件 > 帐户权限 > Copilot 聊天 - 只读",

        // 某个 GitHub 应用 - 安装 https://github.com/settings/apps/<app-name>/installations
            // [/Install (.*)/, "安装 $1"],
            // [/Choose an account to install (.*) on:/, "选择要安装 $1 的账户："],
            "Install": "安装",
            // [/Install (.*) on this account./, "安装 $1 到此账户上。"],
            "Installed": "已安装",
            // [/(.*) is installed on this account./, "$1 已安装在此账户上。"],

        // 某个 GitHub 应用 - 高级 https://github.com/settings/apps/<app-name>/advanced
            "Danger zone": "危险区",
                "Transfer ownership of this GitHub App": "转让此 GitHub 应用的所有权",
                    "Transferring may be delayed until the new owner approves the transfer.": "转让可能会延迟，直至新所有者批准转让",
                    "Transfer ownership": "转让所有权",
                        // [/Where should we transfer (.*)\?/, "将 $1 转让给谁？"],
                        "Type the name of the GitHub App to confirm": "键入要确认的 GitHub 应用名称",
                        "New owner’s GitHub username or organization name": "新所有者的 GitHub 用户名或组织名称",
                        "Transfer this GitHub App": "转让所有权",
                "Delete this GitHub App": "删除此 GitHub 应用",
                    "This cannot be undone. Please be certain.": "此操作无法撤销。请确认。",

                    "Delete GitHub App": "删除 GitHub 应用",
                        "Delete GitHub App?": "删除 GitHub 应用？",
                            "Unexpected bad things will happen if you don’t read this!": "请仔细阅读以下提示信息！！！",
                            "This action": "此操作",
                            "CANNOT": "无法",
                            "be undone. This will permanently delete the": "撤销。这将永久删除",
                            "GitHub App.": "GitHub 应用。",

                            "This will also uninstall the GitHub App from": "这还将卸载 GitHub 应用从",
                            // [/(\d+) accounts?/, "$1 个账户"],

                            "Please type in the name of the GitHub App to confirm.": "请键入 GitHub 应用的名称进行确认。",
                            "I understand the consequences, delete this GitHub App": "我明白后果，依然删除该 GitHub 应用",
                "Make this GitHub App public": "公开 GitHub 应用",
                    "Allow this GitHub App to be installed on other accounts.": "允许在其他账户中安装此 GitHub 应用。",

                    "Make public": "转为公开",
                        // [/Any user or organization will be able to install this GitHub App. Are you sure you want to make (.*) public\?/, "任何用户或组织都可以安装此 GitHub 应用。您确定要公开 $1 吗？"],
                "Make this GitHub App private": "私有化 GitHub 应用",
                    "Private GitHub Apps cannot be installed on other accounts.": "私有 GitHub 应用不能安装在其他账户上。",
                    "Make private": "转为私有",
                        "This integration cannot be made private since it is already installed on other accounts.": "此应用无法转为私有，因为它已安装在其他账户上。",
                "Make this application private": "私有化应用",
                    "Private applications cannot be installed on other accounts.": "私有应用不能安装在其他账户上。",
                        // [/This GitHub app will only be installable on the ([^ ]+) account. Are you sure you want to make (.*) private\?/, "此 GitHub 应用只能安装在 $1 账户上。您确定要将 $2 设为私有吗？"],

        // 某个 GitHub 应用 - 可选功能 https://github.com/settings/apps/<app-name>/beta
            // [/Activate optional features for (.*)/, "激活 $1 的可选功能"],
            // [/Choose a feature to activate for (.*):/, "选择要为 $1 激活的功能："],

            "User-to-server token expiration": "用户到服务器访问令牌过期",
                "User-to-server access tokens will expire after 8 hours. A Refresh Token will be provided which can be exchanged for a new access token.": "用户到服务器访问令牌将在 8 小时后过期。我们将提供一个刷新令牌，用户可以用它换取新的访问令牌。",
                "Opt-out": "选择退出",
                "Opt-in": "选择加入",
                    "Disable user-to-server token expiration for this app.": "禁用此应用的用户到服务器访问令牌过期。",

    },
    "regexp": [ // 正则翻译
        [/Only allow this GitHub App to be installed on the (@[^ ]+) account./, "仅允许在 $1 帐户上安装此 GitHub 应用。"],
        [/Choose an account to install (.*) on:/, "选择要安装 $1 的账户："],
        [/Install (.*) on this account./, "安装 $1 到此账户上。"],
        [/Install (.*)/, "安装 $1"],
        [/(.*) is installed on this account./, "$1 已安装在此账户上。"],
        [/Where should we transfer (.*)\?/, "将 $1 转让给谁？"],
        [/Any user or organization will be able to install this GitHub App. Are you sure you want to make (.*) public\?/, "任何用户或组织都可以安装此 GitHub 应用。您确定要公开 $1 吗？"],
        [/This GitHub app will only be installable on the ([^ ]+) account. Are you sure you want to make (.*) private\?/, "此 GitHub 应用只能安装在 $1 账户上。您确定要将 $2 设为私有吗？"],
        [/(\d+) accounts?/, "$1 个账户"],
        [/Activate optional features for (.*)/, "激活 $1 的可选功能"],
        [/Choose a feature to activate for (.*):/, "选择要为 $1 激活的功能："],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "GitHub Apps": "GitHub 应用",
            "New OAuth Application": "新 OAuth 应用",
        },
    },
};
I18N["zh-CN"]["orgs/settings/apps/new"] = I18N["zh-CN"]["settings/apps"];

I18N["zh-CN"]["settings/developers"] = { // 设置 - 开发者设置/OAuth 应用
    "static": { // 静态翻译
            "Developer Settings": "开发者设置",
            "GitHub Apps": "GitHub 应用",
            "OAuth Apps": "OAuth 应用",
            "Personal access tokens": "个人访问令牌",
                "Fine-grained tokens": "精细化的令牌",
                "Tokens (classic)": "令牌（经典）",

        // OAuth 应用 https://github.com/settings/developers
            "No OAuth applications": "没有 OAuth 应用",
            "OAuth applications are used to access the GitHub API.": "OAuth 应用用于访问 GitHub API。",
            "Read the docs": "阅读文档",
            "to find out more.": "以了解更多情况。",
            "Register a new application": "注册新 OAuth 应用",

            "No OAuth apps": "无 OAuth 应用",
            "OAuth apps are used to access the GitHub API. Read the docs to find out more.": "OAuth 应用程序用于访问 GitHub API。阅读文档了解详情。",
            "New OAuth app": "注册新 OAuth 应用",

            "View documentation": "查看文档",

    },
    "regexp": [ // 正则翻译
    ],
    "title": {
        "static": {
            "Developer applications": "开发者应用",
        },
    },
};

I18N["zh-CN"]["settings/applications/new"] = { // 设置 - 开发者设置/OAuth 应用
    "static": { // 静态翻译

        // 注册 OAuth 应用 https://github.com/settings/applications/new
            "Developer Settings": "开发者设置",

            "Register a new OAuth app": "注册 OAuth 应用",
            "Application name": "应用名",
            "Something users will recognize and trust.": "让用户识别和信任。",
            "Homepage URL": "主页地址",
            "The full URL to your application homepage.": "您的应用主页地址。",
            "Application description": "应用描述",
            "Application description is optional": "应用描述 (可选)",
            "This is displayed to all users of your application.": "所有用户都能看到您的应用描述。",
            "Authorization callback URL": "认证回调地址",
            "Your application’s callback URL. Read our": "您的应用授权回调地址。阅读我们",
            "OAuth documentation": "OAuth 文档",
            "for more information.": "了解更多信息。",
            "Enable Device Flow": "启用设备流程",
            "Allow this OAuth App to authorize users via the Device Flow.": "允许此 OAuth 应用通过设备流程授权用户。",
            "Read the": "阅读",
            "Device Flow documentation": "设备流程文档",
            "Register application": "注册应用",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
};
I18N["zh-CN"]["orgs/settings/applications/new"] = I18N["zh-CN"]["settings/applications/new"];

I18N["zh-CN"]["settings/personal-access-tokens"] = { // 设置 - 开发者设置/个人访问令牌
    "static": { // 静态翻译
            "Developer Settings": "开发者设置",
            "GitHub Apps": "GitHub 应用",
            "OAuth Apps": "OAuth 应用",
            "Personal access tokens": "个人访问令牌",
                "Fine-grained tokens": "精细化的令牌",
                "Tokens (classic)": "令牌（经典）",

        // 开发者设置 - 精细化的个人访问令牌 https://github.com/settings/personal-access-tokens
            "Fine-grained personal access tokens": "精细化的个人访问令牌",
            // 未创建时
                "No fine-grained tokens created": "没有创建精细化的个人访问令牌",
                "Need an API token for scripts or testing? Generate a personal access token for quick access to the GitHub API.": "需要用于脚本或测试的 API 令牌？生成个人访问令牌，快速访问 GitHub API。",

            "These are fine-grained, repository-scoped tokens suitable for personal": "这些都是精细化的、仓库域的令牌，适合个人",
            "use and for using Git over HTTPS.": "使用和通过 HTTPS 使用 Git。",

            "Never used •": "从未使用过 •",
            "Last used within the last week": "最后一次使用是最近 1 周之内",
            // [/Last used within/, "最后一次使用是"],

            "Loading expiration ...": "载入有效期 …",
            "This token has expired.": "此令牌已过期。",
                "To set a new expiration date, you must regenerate the token.": "要设置新的有效期，您必须重新生成令牌。",
            "Regenerate": "重新生成",

            // 生成令牌后提醒复制
                "Make sure to copy your personal access token now as you will not be able to see this again.": "请务必立即复制您的个人访问令牌，因为您将无法再次看到它。",

            // 删除令牌对话框
                "Are you sure you want to delete this token?": "您确定要删除此令牌吗？",
                "Any applications or scripts using this token will no longer be able to access the GitHub API. You cannot undo this action.": "任何使用此令牌的应用或脚本将无法再访问 GitHub API。您无法撤消此操作。",
                "I understand, delete this token": "我明白了，依然删除该令牌。",

            // 顶部提醒
                "Deleted personal access token": "已删除个人访问令牌",

        // 创建精细化个人访问令牌 https://github.com/settings/personal-access-tokens/new
            "New fine-grained personal access token": "新建精细化个人访问令牌",
            "Create a fine-grained, repository-scoped token suitable for personal API use and for using Git over HTTPS.": "创建精细化的、仓库域的令牌，适合个人 API 使用和通过 HTTPS 使用 Git。",

            "Token name": "令牌名称",
                "A unique name for this token. May be visible to resource owners or users with possession of the token.": "此令牌的唯一名称。可能对资源所有者或持有该令牌的用户可见。",
                "Name can't be blank": "名称不能为空",
                "' is available.": "' 可用。",
                "' is not available. The token name has already been taken.": "' 不可用。令牌名称已被占用。",
                "Name has already been taken": "名称已被占用",
            "Description": "描述",
            "Resource owner": "资源所有者",
                "The token will only be able to make changes to resources owned by the selected resource owner. Tokens can always read all public repositories.": "该令牌只能修改所选资源所有者拥有的资源。令牌始终可以读取所有公共仓库。",

                    "Select resource owner": "选择资源所有者",
                        "You may only select resource owners with fine-grained PATs enabled.": "您只能选择已启用精细化个人访问令牌（PAT）的资源所有者。",
            "Authorizing...": "授权中…",

            "Expiration": "有效期",
                "7 days": "7 天",
                "30 days": "30 天",
                "60 days": "60 天",
                "90 days": "90 天",
                "Custom": "自定义",
                    "Select date *": "选择日期 *",
                    "Expiration date can't be blank": "过期时间不能为空",
                "No expiration": "无有效期",
                // [/Limit set by ([^ ]+) organization/, "由 $1 组织设定的限制"],
                "between 1 and 366 days": "1~366 天",

                "The token will expire on the selected date": "此令牌将在指定日期过期",
                "GitHub strongly recommends that you set an expiration date for your token to help keep your information secure.": "GitHub 强烈建议您为令牌设置有效期，以帮助确保您的信息安全。",

            "Repository access": "仓库访问",
                "Select the repositories this token can access. Personal access tokens can always read from all public repositories on GitHub.com": "选择此令牌可以访问的仓库。个人访问令牌始终可以读取 GitHub.com 上所有公共仓库中的内容。", // 更新模式下

                "Public repositories": "公共仓库",
                    "Read-only access to public repositories.": "对公共仓库的只读访问权限。",
                "All repositories": "所有仓库",
                    "This applies to all current and future repositories you own. Also includes public repositories (read-only).": "规则适用于您所有现有及未来仓库。同时包括公共仓库（只读）。",
                    "This applies to all current and future repositories that you can access in this organization. Also includes public repositories (read-only).": "此规则适用于您在此组织内可访问的所有现有及未来仓库，同时包括公共仓库（只读）。",
                "Only select repositories": "仅选定的仓库",
                    "Select at least one repository. Max 50 repositories. Also includes public repositories (read-only).": "至少选择一个仓库，最多可选择 50 个仓库。同时包括公共仓库（只读）。",
                    "Select repositories": "选择仓库",
                        // [/Selected (\d+) repositor(y|ies)./, "选定 #1 个仓库"],
                        "Select at least one repository.": "至少选择一个仓库。",
                            "No repositories found.": "未找到仓库。",

            "Permissions": "权限",
                "Choose the minimal permissions necessary for your needs.": "选择满足您需求的最低权限。",
                "Learn more about permissions.": "了解更多关于权限的信息。",

                "Access:": "访问权限：",
                "Read and write": "读写",
                "Read-only": "只读",
                "Access: Read-only": "访问权限: 只读",
                    "Read access required to use other repository permissions.": "使用其他仓库权限需要读取权限。",
                    "Read access required to use other repository permissions": "使用其他仓库权限需要读取权限。",

                "Add permissions": "添加权限",
                    "Select repository permissions": "选择仓库权限",
                        "No items available": "尚无可用项目",
                    "Select account permissions": "选择账户权限",
                    "Select organization permissions": "选择组织权限",

            // 仓库权限
                "No repository permissions added yet": "尚未添加仓库权限",
                "Repository permissions permit access to repositories and related resources.": "仓库权限允许访问仓库和相关资源。",

                "Actions": "操作",
                    "Workflows, workflow runs and artifacts.": "工作流程、工作流程的运行和工件。",
                "Administration": "管理",
                    "Repository creation, deletion, settings, teams, and collaborators.": "仓库创建、删除、设置、团队和协作者。",
                "Artifact metadata": "附件元数据",
                    "Create and retrieve artifact metadata for a repository.": "创建和检索仓库附件的元数据。",
                "Attestations": "证书",
                    "Create and retrieve attestations for a repository.": "创建和检索仓库的证书。",
                // "Checks": "检查",
                //     "Checks on code.": "检查代码。",
                "Code scanning alerts": "代码扫描警报",
                    "View and manage code scanning alerts.": "查看和管理代码扫描警报。",
                // "": "代码空间",
                    "Create, edit, delete and list Codespaces.": "创建、编辑、删除和列出代码空间。",
                "Codespaces lifecycle admin": "代码空间的生命周期管理",
                    "Manage the lifecycle of Codespaces, including starting and stopping.": "管理代码空间的生命周期，包括启动和停止。",
                "Codespaces metadata": "代码空间元数据",
                    "Access Codespaces metadata including the devcontainers and machine type.": "访问代码空间元数据，包括开发容器和机器类型。",
                "Codespaces secrets": "代码空间机密",
                    "Restrict Codespaces user secrets modifications to specific repositories.": "限制代码空间的用户机密对特定仓库的修改。",
                "Commit statuses": "提交状态",
                    "Commit statuses.": "提交状态。",
                "Contents": "内容",
                    "Repository contents, commits, branches, downloads, releases, and merges.": "仓库内容、提交、分支、下载、发布和合并。",
                // 自定义属性
                    "Read and write repository custom properties values at the repository level, when allowed by the property.": "在属性允许的情况下，在仓库级别读取和写入仓库自定义属性值。",
                "Dependabot alerts": "Dependabot 警报",
                    "Retrieve Dependabot alerts.": "检索 Dependabot 警报。",
                "Dependabot secrets": "Dependabot 机密",
                    "Manage Dependabot repository secrets.": "管理 Dependabot 仓库的机密。",
                "Deployments": "部署",
                    "Deployments and deployment statuses.": "部署和部署状态。",
                "Discussions": "讨论",
                    "Discussions and related comments and labels.": "讨论及相关评论和标签。",
                "Environments": "环境",
                    "Manage repository environments.": "管理仓库环境。",
                "Issues": "议题",
                    "Issues and related comments, assignees, labels, and milestones.": "议题及相关评论、受理人、标签和里程碑。",
                "Merge queues": "合并列队",
                    "Manage a repository's merge queues": "管理仓库的合并队列。",
                "Metadata": "元数据",
                    "Search repositories, list collaborators, and access repository metadata.": "搜索仓库、列出协作者，访问仓库元数据。",
                // "Packages": "软件包",
                //     "Packages published to the GitHub Package Platform.": "发布软件包到 GitHub Package 平台。",
                "Pages": "GitHub Pages",
                    "Retrieve Pages statuses, configuration, and builds, as well as create new builds.": "检索页面状态、配置和构建，以及创建新的构建。",
                // "Projects": "项目",
                //     "Manage classic projects within a repository.": "管理仓库中的经典项目。",
                "Pull requests": "拉取请求",
                    "Pull requests and related comments, assignees, labels, milestones, and merges.": "拉取请求及相关评论、受让人、标签、里程碑和合并。",
                "Repository security advisories": "仓库安全公告",
                    "View and manage repository security advisories.": "查看和管理安全公告",
                "Secret scanning alert dismissal requests": "机密扫描警报解除请求",
                    "View and manage secret scanning alert dismissal requests":"查看和管理机密扫描警报解除请求",
                "Secret scanning alerts": "机密扫描警报",
                    "View and manage secret scanning alerts.": "查看和管理机密扫描警报。",
                "Secret scanning push protection bypass requests": "机密扫描推送保护绕过请求",
                    "Review and manage repository secret scanning push protection bypass requests.": "审查和管理仓库机密扫描推送保护绕过请求。",
                "Secrets": "机密",
                    "Manage Actions repository secrets.": "管理操作仓库机密。",
                "Variables": "变量",
                    "Manage Actions repository variables.": "管理操作仓库变量。",
                "Webhooks": "Web 钩子",
                    "Manage the post-receive hooks for a repository.": "管理仓库的接收后钩子。",
                "Workflows": "工作流程",
                    "Update GitHub Action workflow files.": "更新 GitHub Actions 工作流程文件。",

            // 账户权限
                "Account": "账户",
                "No account permissions added yet": "尚未添加账户权限",
                "User permissions permit access to resources under your personal GitHub account.": "用户权限允许访问您个人 GitHub 账户下的资源。",

                "Block another user": "拉黑其他用户",
                    "View and manage users blocked by the user.": "查看和管理被用户拉黑的用户。",
                "Codespaces user secrets": "代码空间用户机密",
                    "Manage Codespaces user secrets.": "管理代码空间用户机密。",
                "Copilot Chat": "Copilot 聊天",
                    "This application will receive your GitHub ID, your GitHub Copilot Chat session messages (not including messages sent to another application), and timestamps of provided GitHub Copilot Chat session messages. This permission must be enabled for Copilot Extensions.": "该应用程序将获取您的 GitHub ID、您的 GitHub Copilot 聊天会话消息（不包括发送到其他应用程序的消息），以及提供的 GitHub Copilot 聊天会话消息的时间戳。必须启用此权限才能使用 Copilot 扩展功能。",
                "Copilot Editor Context": "Copilot 编辑器上下文",
                    "This application will receive bits of Editor Context (e.g. currently opened file) whenever you send it a message through Copilot Chat.": "每当您通过 Copilot Chat 向该应用发送消息时，该应用将接收部分编辑器上下文（例如当前打开的文件）。",
                "Copilot Requests": "Copilot 请求",
                    "Send Copilot requests.": "发送 Copilot 请求",
                "Email addresses": "电子邮箱地址",
                    "Manage a user's email addresses.": "管理用户的电子邮箱地址。",
                // 活动
                    "View events triggered by a user's activity.": "查看由用户活动触发的事件。",
                // 关注者
                    "A user's followers": "用户的关注者",
                "GPG keys": "GPG 密钥",
                    "View and manage a user's GPG keys.": "查看和管理用户的 GPG 密钥。",
                // Gist
                    "Create and modify a user's gists and comments.": "创建和修改用户的代码片段和评论。",
                "Git SSH keys": "Git SSH 密钥",
                "Interaction limits": "交互限制",
                    "Interaction limits on repositories": "仓库的交互限制",
                "Knowledge bases": "知识库",
                    "View knowledge bases for a user.": "为用户查看知识库。",
                "Models": "模型",
                    "Allows access to GitHub Models.": "允许访问 GitHub 模型。",
                "Plan": "计划",
                    "View a user's plan.": "查看用户的计划。",
                "Private repository invitations": "私有仓库邀请",
                    "View a user's invitations to private repositories": "查看用户对私有仓库的邀请",
                "Profile": "个人信息",
                    "Manage a user's profile settings.": "管理用户的个人信息设置。",
                "SSH signing keys": "SSH 签名密钥",
                    "View and manage a user's SSH signing keys.": "查看和管理用户的 SSH 签名密钥。",
                "Starring": "星标",
                    "List and manage repositories a user is starring.": "列出和管理用户标星的仓库。",
                "Watching": "关注",
                    "List and change repositories a user is subscribed to.": "列出和更改用户订阅的仓库。",

            // 组织权限
                "No organization permissions added yet": "尚未组织账户权限",
                "Organization permissions permit access to organization related resources.": "组织权限允许访问组织相关资源。",

                "API Insights": "API 洞察",
                    "View statistics on how the API is being used for an organization.": "查看 API 在组织中的使用统计。",
                // 管理
                    "Manage access to an organization.": "管理对组织的访问。",
                "Blocking users": "拉黑用户",
                    "View and manage users blocked by the organization.": "查看和管理被组织拉黑的用户。",
                "Campaigns": "活动",
                    "Manage campaigns.": "管理活动。",
                "Custom organization roles": "自定义组织角色",
                    "Create, edit, delete and list custom organization roles. View system organization roles.": "创建、编辑、删除和列出自定义组织角色。查看系统组织角色。",
                "Custom properties": "自定义属性",
                    "Read and write repository custom properties values and administer definitions at the organization level.": "读取和写入组织级别的仓库自定义属性值并管理定义。",
                "Custom properties for organizations": "自定义组织属性",
                    "Read and write organization custom properties values at the organization level, when allowed by the property.": "在属性允许的情况下，读取和写入组织级别的自定义属性值。",
                "Custom repository roles": "自定义仓库角色",
                    "Read and write repository custom properties values and administer definitions at the organization level.": "读取和写入组织级别的仓库自定义属性值并管理定义。",
                "Events": "事件",
                    "View events triggered by an activity in an organization.": "查看组织中某项活动所触发的事件。",
                "GitHub Copilot Business": "GitHub Copilot 商业版",
                    "Manage Copilot Business seats and settings": "管理 GitHub Copilot 商业版席位和设置",
                "Hosted runner custom images": "托管的运行器自定义镜像",
                    "View and manage hosted runner custom images available to an organization.": "查看和管理组织可用的托管运行器自定义镜像。",
                "Issue Fields": "议题字段",
                    "Manage issue fields for an organization.": "管理组织的议题字段。",
                "Issue Types": "议题类型",
                    "Manage issue types for an organization.": "管理组织的议题类型。",
                // 知识库
                    "View and manage knowledge bases for an organization.": "查看和管理组织的知识库。",
                "Members": "成员",
                    "Organization members and teams.": "组织成员和团队。",
                // 模型
                    "Manage model access for an organization.": "管理组织的模型访问。",
                "Network configurations": "网络配置",
                    "View and manage hosted compute network configurations available to an organization.": "查看和管理组织可用的托管计算网络配置。",
                "Organization announcement banners": "组织公告横幅",
                    "View and modify announcement banners for an organization.": "查看并修改组织的公告横幅。",
                "Organization bypass requests for secret scanning": "组织绕过机密扫描请求",
                    "Review and manage secret scanning push protection bypass requests.": "审查和管理机密扫描推送保护绕过请求。",
                "Organization codespaces": "组织代码空间",
                    "Manage Codespaces for an organization.": "管理组织的代码空间。",
                "Organization codespaces secrets": "组织代码空间机密",
                    "Manage Codespaces Secrets for an organization.": "管理组织的代码空间机密。",
                "Organization codespaces settings": "组织代码空间设置",
                    "Manage Codespaces settings for an organization.": "管理组织的代码空间设置。",
                "Organization dependabot secrets": "组织 Dependabot 机密",
                    "Manage Dependabot organization secrets.": "管理 Dependabot 组织的机密。",
                "Organization dismissal requests for code scanning": "组织代码扫描的解除请求",
                    "Review and manage code scanning alert dismissal requests.": "审查和管理代码扫描警报解除请求。",
                "Organization private registries": "组织私有注册表",
                    "Manage private registries for an organization.": "管理组织的私有注册表。",
                "Plan": "计划",
                    "View an organization's plan.": "查看组织的计划。",
                // 项目
                    "Manage projects for an organization.": "管理组织的项目。",
                // 机密扫描警报解除请求
                    "Review and manage secret scanning alert dismissal requests": "审查和管理机密扫描警报解除请求",
                // 机密
                    "Manage Actions organization secrets.": "管理操作组织机密",
                "Self-hosted runners": "自托管运行器",
                    "View and manage Actions self-hosted runners available to an organization.": "查看和管理组织可用的 “操作自托管运行器”。",
                "Team discussions": "团队讨论",
                    "Manage team discussions and related comments.": "管理团队讨论及相关评论。",
                // 变量
                    "Manage Actions organization variables.": "管理操作组织变量。",
                // Web 钩子
                    "Manage the post-receive hooks for an organization.": "管理组织的接收后钩子。",

            "This token will be ready for use immediately.": "该令牌将即可可用。",

            "New personal access token": "新建个人访问令牌",
                "Your new personal access token": "您的新个人访问令牌",
                "will be ready for use immediately. It will expire on": "将立即准备就绪，可供使用。其有效期至",
                // [/(.+) grants you/, "$1 授予您"],
                // [/(\d+) account permissions?/, "$1 项账户权限"],
                // [/(\d+) permissions? for all repositories:/, "所有仓库的 $1 项权限"],
                // [/(\d+) permissions? for (\d+) repositori(y|es):/, "$1 个仓库的 $2 项权限"],
                // [/(\d+) organization permissions?/, "$1 项组织权限"],
                "Generating...": "生成中…",

        // 查看、更新精细化个人访问令牌 https://github.com/settings/personal-access-tokens/<id>
            "No description": "暂无描述",
            "Created": "创建于",
                "today": "今日",

            "Access on": "访问:",
            "Access on the": "访问:",
            "organization": "组织",

            "User permissions": "用户权限",
            "Repository permissions": "仓库权限",
            "Organization permissions": "组织权限",

            // 具体权限暂时翻译 太麻烦 主要他将读/写具体的权限合并描述

            // 顶部提醒
                "Your personal access token has been updated": "您的个人访问令牌已更新",

        // 重新生成精细化个人访问令牌 https://github.com/settings/personal-access-tokens/<id>/regenerate
            "Regenerate fine-grained personal access token": "重新生成精细化个人访问令牌",

        // 开发者设置 - 个人访问令牌（经典） https://github.com/settings/tokens
            "Personal access tokens (classic)": "个人访问令牌（经典）",
            "Generate new token": "生成新令牌",
                "Fine-grained, repo-scoped": "精细化、 仓库域",
                "Generate new token (classic)": "生成新令牌（经典）",
                    "For general use": "一般用途",

            "Tokens you have generated that can be used to access the": "生成令牌用于访问",

            "Expires": "有效期至",
            "This token has no expiration date": "此令牌未设置有效期",
            "This token has expired": "此令牌已过期",
            "Never used": "从未使用",

            // 生成令牌后提醒复制
                "Make sure to copy your personal access token now. You won’t be able to see it again!": "确保立即复制您的个人访问令牌。您将无法再看到它！",

            "Personal access tokens (classic) function like ordinary OAuth access tokens. They can be used instead of a password for Git over HTTPS, or can be used to": "个人访问令牌（经典）的功能类似于普通的 OAuth 访问令牌。它们可以用来代替 HTTPS 上 Git 的密码，或者可以用来",
            "authenticate to the API over Basic Authentication": "通过 ‘基本身份验证’ 对 API 进行身份验证",

        // 创建新个人访问令牌（经典） https://github.com/settings/tokens/new
            "New personal access token (classic)": "新建个人访问令牌（经典）",
            "Note": "备注",
                "Note can't be blank": "备注不能为空",
            "What’s this token for?": "这个令牌有什么用？",

            "Expiration": "有效期",
            // "This token expires": "该令牌有效期至",
            ". To set a new expiration date, you must": "。要设置一个新的有效期，您必须",


            "Select scopes": "选择作用域",
                "Scopes define the access for personal tokens.": "作用域定义了个人令牌的访问范围。",
                "Read more about OAuth scopes.": "了解更多关于 OAuth 作用域的信息。",

            // 权限
                "Full control of private repositories": "完全控制私有仓库",
                "Access commit status": "访问提交状态",
                "Access deployment status": "访问部署状态",
                "Access public repositories": "访问公共仓库",
                "Access repository invitations": "访问仓库邀请",
                "Read and write security events": "读写安全事件",
                "Update GitHub Action workflows": "更新 GitHub Actions 工作流程",
                "Upload packages to GitHub Package Registry": "将包上传到 GitHub Packages 包注册",
                "Download packages from GitHub Package Registry": "从 GitHub Packages 包注册表下载包",
                "Delete packages from GitHub Package Registry": "从 GitHub Packages 包注册表中删除包",
                "Full control of orgs and teams, read and write org projects": "完全控制组织和团队，读写组织项目",
                "Read and write org and team membership, read and write org projects": "读写组织和团队成员，读写组织项目",
                "Read org and team membership, read org projects": "读取组织和团队成员，读取组织项目",
                "Manage org runners and runner groups": "管理组织运行器和运行器组",
                "Full control of user public keys": "完全控制用户公钥",
                "Write user public keys": "写入用户公钥",
                "Read user public keys": "读取用户公钥",
                "Full control of repository hooks": "完全控制仓库钩子",
                "Write repository hooks": "写入仓库钩子",
                "Read repository hooks": "读取仓库钩子",
                "Full control of organization hooks": "完全控制组织钩子",
                "Create gists": "创建代码片段",
                "Access notifications": "访问通知",
                "Update ALL user data": " 更新所有用户数据",
                "Read ALL user profile data": "读取所有用户个人资料数据",
                "Access user email addresses (read-only)": "访问用户电子邮箱地址（只读）",
                "Follow and unfollow users": "关注和取消关注用户",
                "Delete repositories": "删除仓库",
                "Read and write team discussions": "读写团队讨论",
                "Read team discussions": "读取团队讨论",
                "Full control of enterprises": "完全控制企业",
                "Manage enterprise runners and runner groups": "管理企业运行器和运行器组",
                "Read and write enterprise billing data": "读写企业计费数据",
                "Read enterprise profile data": "读取企业个人数据",
                "Provisioning of users and groups via SCIM": "通过 SCIM 配置用户和组",
                "Full control of audit log": "完全控制审核日志",
                "Read access of audit log": "读取审核日志",
                "Full control of codespaces": "完全控制代码空间",
                "Ability to create, read, update, and delete codespace secrets": "创建、读取、更新和删除代码空间机密",
                "Full control of GitHub Copilot settings and seat assignments": "完全控制 GitHub Copilot 设置和席位分配",
                "View and edit Copilot Business seat assignments": "查看和编辑 GitHub Copilot 商业版席位分配",
                "Write org hosted compute network configurations": "写入组织托管计算网络配置",
                "Read org hosted compute network configurations": "读取组织托管计算网络配置",
                "Full control of projects": "完全控制项目",
                "Read access of projects": "读取项目",
                "Full control of public user GPG keys": "完全控制公共用户 GPG 密钥",
                "(Developer Preview)": "（开发者预览版）",
                "Write public user GPG keys": "写入公共用户 GPG 密钥",
                "Read public user GPG keys": "读取公共用户 GPG 密钥",
                "Full control of public user SSH signing keys": "完全控制公共用户 SSH 签名密钥",
                "Write public user SSH signing keys": "写入公共用户 SSH 签名密钥",
                "Read public user SSH signing keys": "读取公共用户 SSH 签名密钥",

            "Generate token": "生成令牌",
                // 顶部提醒
                "Some of the scopes you’ve selected are included in other scopes. Only the minimum set of necessary scopes has been saved.": "您选择的一些作用域包含在其他作用域中。只保存了必要作用域的最小集合。",
                "Note has already been taken": "备注已存在",

        // 重新生成个人访问令牌（经典） https://github.com/settings/tokens/<id>/regenerate
            "Regenerate personal access token (classic)": "重新生成个人访问令牌（经典）",
                "Submitting this form will generate a new token. Be aware that any scripts or applications using this token will need to be updated.": "提交此表单将产生一个新的令牌。请注意，任何使用该令牌的脚本或应用将需要更新。",
            "Regenerate token": "重新生成令牌",

    },
    "regexp": [ // 正则翻译
        [/Expires on ([^ ]+), ([^ ]+) (\d+) (\d+)/, function(all, week, month, day, year){
            var weekKey = {
                "Sun"  : "周日",
                "Mon"  : "周一",
                "Tue"  : "周二",
                "Wed"  : "周三",
                "Thu"  : "周四",
                "Fri"  : "周五",
                "Sat"  : "周六"
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            return '有效期至 ' + year + '年' + monthKey[month] + day + '日，' + weekKey[week];
        }],
        [/(\d+) days? \((.+)\)/, (match, d , p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return d + `天（${translatedDate}）`;
        }],
        [/Last used within the last (\d+) weeks?/, "最后一次使用是最近 $1 周之内"],
        [/Last used within the last (\d+) months?/, "最后一次使用是最近 $1 月之内"],
        [/Last used within the last (\d+) years?/, "最后一次使用是最近 $1 年之内"],
        [/Limit set by ([^ ]+) organization/, "由 $1 组织设定的限制"],
        [/Selected (\d+) repositor(y|ies)./, "选定 $1 个仓库"],
        // 新建个人访问令牌对话框
            [/(.+) grants you/, "$1 授予您"],
            [/(\d+) account permissions?/, "$1 项账户权限"],
            [/(\d+) permissions? for all repositories:/, "所有仓库的 $1 项权限"],
            [/(\d+) permissions? for (\d+) repositori(y|es):/, "$1 个仓库的 $2 项权限"],
            [/(\d+) organization permissions?/, "$1 项组织权限"],
    ],
    "title": {
        "static": {
            "Fine-grained Personal Access Tokens": "精细化的个人访问令牌",
            "New Fine-grained Personal Access Token": "新建精细化个人访问令牌",
            "Personal Access Tokens (Classic)": "个人访问令牌（经典）",
            "New Personal Access Token (Classic)": "新建个人访问令牌（经典）",
        },
    },
};
I18N["zh-CN"]["settings/tokens"] = I18N["zh-CN"]["settings/personal-access-tokens"];

// 仓库相关==
I18N["zh-CN"]["repository-public"] = { // 仓库 - 公共部分
    "static": { // 静态翻译
        // 仓库页面 /<user-name>/<repo-name>/
            // 被 GitHub 官方禁用
            "This repository has been disabled.": "此仓库已被禁用。",
            "Access to this repository has been disabled by GitHub Staff due to a violation of GitHub's terms of service. If you are the owner of the repository, you may reach out to GitHub Support for more information.": "由于违反了 GitHub 的服务条款，GitHub 已禁止访问此仓库。如果您是仓库的所有者，您可以联系 GitHub 支持以获取更多信息。",

            // 仓库地址-浮动信息窗口(仅 Android UA)
            "Navigate back to": "返回到",

            // 顶部提示
            "Sorry, that branch already exists.": "抱歉，该分支已存在。",
            "has invited you to collaborate on this repository": "邀请您成为该仓库协作者",
                "View invitation": "查看",
            "Updated issue templates for this repository": "已为此仓库更新议题模板",

            // 存档
            "This repository has been archived by the owner. It is now read-only.": "此仓库已被所有者存档。它现在是只读的。",

            "Appearance settings": "外观设置", // 未登录时出现
                "Increase contrast": "高对比度",
                    "Enable high contrast for light or dark mode (or both) based on your system settings": "根据您的系统设置，为浅色或深色模式（或两者）启用高对比度",
                    "Light mode": "浅色模式",
                    "Dark mode": "深色模式",
                    "On": "开",
                    "Off": "关",

            // 仓库违反 DMCA
            "Repository unavailable due to DMCA takedown.": "由于 DMCA 删除，仓库不可用。",
            "This repository is currently disabled due to a DMCA takedown notice. We have disabled public access to the repository. The notice has been": "由于 DMCA 删除通知，此仓库当前已被禁用。我们已经禁止公众访问该仓库。该通知已",
            "publicly posted": "公开发布",
            "If you are the repository owner, and you believe that your repository was disabled as a result of mistake or misidentification, you have the right to file a counter notice and have the repository reinstated. Our help articles provide more details on our": "如果您是仓库所有者，并且您认为您的仓库由于错误或误认而被禁用，您有权提交反通知并恢复仓库。我们的帮助文章提供了关于我们的更多详细信息",
            "DMCA takedown policy": "DMCA 删除政策",
            "how to file a counter notice": "如何提交反通知",
            ". If you have any questions about the process or the risks in filing a counter notice, we suggest that you consult with a lawyer.": "。如果您对提交反通知的流程或风险有任何疑问，我们建议您咨询律师。",

             // 用户 浮动信息卡
                "- same time": "- 时间相同",
                "Recently edited these files": "最近编辑过这些文件",
                "Owns this repository": "拥有该仓库",
                "Left a review": "留下了一个评论",
                "Committed to this repository": "已提交过这个仓库",
                "Committed to this repository in the past day": "最近一天里已提交过这个仓库",
                "Committed to this repository in the past week": "最近一周里已提交过这个仓库",
                "Committed to this repository in the past month": "最近一个月里已提交过这个仓库",
                "Member of": "隶属组织",
                // [/, and (\d+) more/, "，以及其他 $1 个组织"],
                "Opened this issue": "打开了该议题",
                "Opened this pull request": "打开了该拉取请求",
                "Opened this pull request (their first ever)": "打开了该拉取请求（他们有史以来的第一个请求）",
                "Started this discussion": "开启了该讨论",

            // 组织  浮动信息卡
                // [/(\d+) repositor(y|ies)/, "$1 个仓库"],
                // [/(\d+) members?/, "$1 个成员"],

            "Some checks haven't completed yet": "部分检查还未完成",

            "Jump to bottom": "跳到底部", //小屏模式
            "Forked from": "复刻自", // 同上（发行版未登录页面）

            "people": "人", // 提交
            "committed": "提交于", // 提交浮窗
            "authored": "撰写于",
            "authored and": "撰写和", // 1 编写，由 2 提交

            // 标签栏
            "Code": "代码",
            "Pull requests": "拉取请求",
            "Discussions": "讨论",
            "Actions": "操作",
            "Projects": "项目",
            "Models": "模型",
            "Security": "安全",
            "Insights": "洞察",
            "Settings": "设置",

            "Additional navigation options": "更多导航选项", // 小屏
            "View all files": "查看所有文件", //Android UA 下出现

            // "Pulse": "统计",
            // "Graphs": "图表",

            // 返回通知页状态条
            "Back to notifications": "回到通知",
            "Done": "已完成",
            "Subscribe": "订阅",
            "Unsubscribe": "退订",
            "Mark as read": "标记为已读",
            "Mark as unread": "标记为未读",
            "Move to inbox": "移动到收件箱",
            "Save": "保存",
            "Unsave": "未保存",

            // 评论框头部栏 (议题 & 拉取请求)
                "Contributor": "贡献者",
                "Owner": "所有者",
                "Author": "作者",
                    "You are the author of this issue": "您是这个议题的作者。",  // 议题
                    "You are the author of this pull request.": "您是这个拉取请求的作者。", // 拉取请求
                    "This user is the author of this issue": "该用户是这个议题的作者。",  // 议题
                    "This user is the author of this issue.": "该用户是这个议题的作者。",// 拉取请求
                    "This user is the author of this pull request.": "该用户是这个拉取请求的作者。",// 拉取请求
                "Member": "成员",
                    //[/This user is a member of the ([^ ]+)./, "该用户是 $1 组织的成员。"],
                "Collaborator": "协作者",
                    //[/This user has been invited to collaborate on the ([^ ]+) repository./, "该用户已被邀请在 $1 仓库上进行协作。"],
                "Pick your reaction": "选择您的表情",
                "Copy link": "复制链接",
                "Quote reply": "引用回复",
                "Reference in new issue": "引用到新议题",
                    // 引用到新议题 对话框
                    "Body": "正文",
                    "Issue title": "议题标题",
                    "Issue body": "议题正文",
                    "Select repository": "选择仓库",
                    "Repository:": "仓库：",
                    "No matching repositories.": "没有匹配的仓库。",
                "Report content": "举报内容",
                "Report": "举报",
                // 评论删除提醒
                    "Are you sure you want to delete this?": "您定要删除这个吗？",

                "commented": "评论于",
                "commented on behalf of": "评论，代表",
                "— with": "— 通过",
                "Update comment": "更新评论",
                "Hide": "隐藏",
                    "via email": "通过邮件",

                "created": "创建",
                "edited": "编辑",
                "(most recent)": "(最近的)",
                "(deleted)": "(已删除)",
                "deleted this content": "删除了该内容",
                // 评论历史查看
                "Options": "选项",
                // 选项下拉菜单
                "More options": "更多选项",
                "The most recent revision cannot be deleted. Need to delete sensitive information? Go to the specific edit where the information was added.": "最近的修订版不能被删除。需要删除敏感信息？请到信息的具体编辑处修改。",
                "Delete revision from history": "从历史记录中删除修订",
                "This edit’s content will no longer be visible.": "此修改的内容将不再可见。",
                    "Delete revision": "删除修订",
                // 评论状态
                "This comment has been hidden.": "此评论被隐藏。",
                "This comment was marked as abuse.": "此评论被标记为滥用。",
                "This comment was marked as spam.": "此评论被标记为垃圾信息。",
                "This comment was marked as off-topic.": "此评论被标记为偏离主题。",
                "This comment was marked as outdated.": "此评论被标记为已过时。",
                "This comment was marked as duplicate.": "此评论被标记为重复。",
                "This comment was marked as resolved.": "此评论被标记为已解决。",
                "Sign in to view": "登录后查看", // 未登录

            // 切换分支/标签 下拉菜单
                "Switch branches/tags": "切换分支/标签",
                "Find or create a branch…": "查找或创建分支…",
                "Find a branch...": "查找分支…",
                "Filter branches/tags": "搜索分支/标签",
                "Branches": "分支",
                "default": "默认",
                "View all branches": "查看全部分支",
                "Find a tag": "查找标签",
                "Tags": "标签",
                "Tag": "标签",
                "Search for a tag": "搜索标签",
                "Nothing to show": "暂无",
                "View all tags": "查看全部标签",

                "Find or create a branch...": "查找或创建分支…",
                "Search or create a new tag": "搜索或创建新标签",
                "View all": "查看全部",
                "branches": "分支",
                "Find a tag...": "查找标签…",
                "Nothing to show": "暂无",
                "tags": "标签",

                "View all rules": "查看全部规则",

            // 键盘快捷键
                "Open in codespace"  : "在代码空间中打开",
                "Open in github.dev editor"  : "在 github.dev 编辑器中打开",
                "Open github.dev editor in a new tab"  : "在新标签页中打开 github.dev 编辑器",
                "Open cs.github.com in a new tab": "在新标签页中打开 cs.github.com",
                "Focus secondary search bar" : "聚焦二级搜索栏",
                "Go to Code"                 : "跳转到代码",
                "Go to Issues"               : "跳转到议题",
                "Go to Pull Requests"        : "跳转到拉取请求",
                "Go to Actions"              : "跳转到操作",
                "Go to Projects"             : "跳转到项目",
                "Go to Wiki"                 : "跳转到 Wiki",
                "Go to Discussions"          : "跳转到讨论",

                "Copilot chat": "Copilot 聊天",
                "Open Copilot chat": "打开 Copilot 聊天",
                "Close Copilot chat": "关闭 Copilot 聊天",
                "Expand/collapse Copilot chat": "展开/折叠 Copilot 聊天",

            // 议题
                "Submit comment": "提交评论",
                "Submit comment and close issue": "提交评论并关闭议题",
                "Preview comment": "预览评论",
                "Create issue": "创建议题",
                // "筛选用户": "",
                "Filter by or edit assignees"  : "按受理人筛选或编辑受理人",
                "Filter by or edit labels"     : "按标签筛选或编辑标签",
                "Filter by or edit projects"   : "按项目筛选或编辑项目",
                "Filter by or edit milestones" : "按里程碑筛选或编辑里程碑",
                "Reply (quoting selected text)": "答复（引用所选文本）",
                "Open saved replies": "打开快捷回复（引用所选文本）",
                "Insert saved reply (with open saved replies)": "插入快捷回复（打开快捷回复）",

                "Pull request list": "拉取请求列表",
                    "Open pull request"  : "打开拉取请求",
                "Pull request - Conversation tab": "拉取请求 - 对话标签卡",
                    "Submit comment and close or open pull request": "提交评论和关闭或打开拉取请求",
                    "Request reviewers": "请求审查者",
                    "Link an issue or pull request from the same repository": "链接同一仓库的议题或拉取请求",
                    "Toggle visibility of all collapsed review comments instead of just the current one": "切换所有折叠审查意见的可见性，而不仅仅是当前的审查意见",
                "Pull request - Files changed tab": "拉取请求 - 文件更改标签卡",
                    "Open commits list": "打开提交列表",
                    "Open files list": "打开文件列表",
                    "Next commit": "下一个提交",
                    "Previous commit": "上一个提交",
                    "Show or hide annotations": "显示或隐藏批注",
                    "Show or hide comments": "显示或隐藏评论",
                    "Submit a review comment": "提交审查意见",
                    "Collapse or expand all files instead of just the current one": "折叠或展开所有文件，而不仅仅是当前文件",
                    "and click": "和点击",

            // 高频词
                "Merged": "已合并",
                "Draft": "草案",
                "Branch": "分支",
                "Branches": "分支",
                "Tags": "标签",

            "Compare & pull request": "比较 & 拉取请求",

        // 仓库 404 页面（非删库状态）
            "404 - page not found": "404 - 找不到页面",
            "The": "该",
            "branch of": "分支",
            "does not contain the path": "仓库，不包含路径",
            "Return to the repository overview": "返回仓库概述",
            "Cannot find a valid ref in": "未找到有效的引用",
            "Go to default branch": "跳转到默认分支",

        // 500 页面
            "Looks like something went wrong!": "好像出了什么问题！",
            "We track these errors automatically, but if the problem persists feel free to contact us. In the meantime, try refreshing.": "我们会自动跟踪这些错误，但如果问题仍然存在，请随时与我们联系。与此同时，尝试刷新。",
            "Contact Support": "联系 GitHub 支持",
            "GitHub Status": "GitHub 状态",

        // 页面加载异常(仓库)
            "Error loading page": "加载页面出错",
            "It looks like your internet connection is down. Please check it.": "您的网络连接似乎出现故障。请检查一下。",

        // 邀请继任者提醒
            "Ensure the future of your work!": "确保您工作的未来！",
            "Consider inviting another GitHub user to be your successor.": "考虑邀请另一位 GitHub 用户作为您的继任者。",
            "Inviting a successor helps ensure the continuity of your work in case you are unable to access your account.": "邀请继任者有助于在您无法访问账户时确保工作的连续性。",
            "Invite a successor": "邀请继任者",

        // 仓库赞助
            "Couldn't load subscription status.": "无法加载赞助状态。",
            "Retry": "重试",

        // 提交检查对话框
            "Some checks haven’t completed yet": "部分检查尚未完成",
            "Some checks were not successful": "部分检查未成功",
            "All checks have passed": "所有检查通过",
            "All checks have failed": "所有检查失败",
            "Waiting to run this check...": "正在等待运行此检查…",
            "Queued": "队列中",
            "Skipped": "已跳过",
            "Deployed": "已部署",
            "Pending": "待处理",
            "Build Failed": "构建失败",
            "Build Passed": "构建通过",
            "Build Errored": "构建错误",
            "Build Canceled": "构建取消",
            "Waiting for build": "等待构建",

        // 未登录浮窗
            "You must be signed in to change notification settings": "您必须登录后才能更改通知设置",
            "You must be signed in to star a repository": "您必须登录后才能标星仓库",
            "You must be signed in to add this repository to a list": "您必须登录后才能将此仓库添加到列表中",
            "You must be logged in to vote": "您必须登录后才能投票",

        "Open commit details": "打开提交详情",
        "failure": "失败",
    },
    "regexp": [ // 正则翻译
        [/Started (\d+) discussions? in this repository in the past day/, "过去一天内在此仓库中开启了 $1 个讨论"], // 用户 浮动信息卡
        [/Started (\d+) discussions? in this repository in the past week/, "过去一周内在此仓库中开启了 $1 个讨论"], // 用户 浮动信息卡
        [/Started (\d+) discussions? in this repository in the past month/, "过去一个月内在此仓库中开启了 $1 个讨论"], // 用户 浮动信息卡
        [/Started (\d+) discussions? in this repository/, "在此仓库中开启了 $1 个讨论"], // 用户 浮动信息卡
        [/Opened this pull request \(their first in ([^ ]+)\)/, "打开了这个拉取请求（首次在 $1 发表）"], // 用户 浮动信息卡
        [/([^ ]+) requested changes, you commented/, "$1 要求更改，您发表评论"], // 拉取请求 浮动信息卡
        [/(\d+) successful checks?/, "$1 个成功的检查"],
        [/(\d+) successful/, "$1 成功"],
        [/(@\S+) generated this status\./, "$1 创建了这个状态"],
        [/Successful in (\d+)s/, "在 $1 秒内成功"],
        [/Successful in (\d+)m/, "在 $1 分内成功"],
        [/(\d+) failing checks?/, "$1 个失败的检查"],
        // 3 skipped
        [/(\d+) skipped/, "$1 个跳过"],
        [/Failing after (\d+)s/, "在 $1 秒后失败"],
        [/(\d+) in progress check/, "$1 个正在运行的检查"],
        // [/ and /, " 和 "],
        [/, and (\d+) more/, "，以及其他 $1 个组织"], // 用户 浮动信息卡
        [/^(\d+) repositor(y|ies)/, "$1 个仓库"], // 组织  浮动信息卡
        [/(\d+) members?/, "$1 个成员"], // 组织  浮动信息卡
        [/Answered (\d+) discussions? in this repository in the past month/, "过去一个月内在此仓库中回答了 $1 个讨论"], // 用户 浮动信息卡
        [/Answered (\d+) discussions? in this repository in the past week/, "过去一周内在此仓库中回答了 $1 个讨论"], // 用户 浮动信息卡
        [/Answered (\d+) discussions? in this repository/, "在此仓库中回答了 $1 个讨论"], // 用户 浮动信息卡
        [/had recent pushes (\d+) seconds? ago/, "分支有了最新的推送，$1 秒之前"],
        [/had recent pushes (\d+) minutes? ago/, "分支有了最新的推送，$1 分钟之前"],
        [/had recent pushes less than (\d+) minutes? ago/, "分支有了最新的推送，不到 $1 分钟"],
        [/had recent pushes about/, "分支有了最新的推送，大约"],
        [/This user is a member of the ([^ ]+) organization./, "该用户是 $1 组织的成员。"],
        [/This user has been invited to collaborate on the ([^ ]+) repository./, "该用户已被邀请在 $1 仓库上进行协作。"],
        [/You are the owner of the (.*) repository./, "您是 $1 仓库的所有者。"],
        [/This user is the owner of the (.*) repository./, "该用户是 $1 仓库的所有者。"],
        [/You have been invited to collaborate on the (.*) repository./, "您已受邀参与 $1 仓库的协作。"],
        [/You have previously committed to the (.*) repository./, "您之前有提交到 $1 仓库。"],
        [/This user has previously committed to the (.*) repository./, "该用户之前有提交到 $1 仓库。"],
        [/This repository was archived by the owner on (.+). It is now read-only./, (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `此仓库已由所有者于${translatedDate}存档。它现在是只读的。`;
        }],
        [/, and ([^ ]+)/, ", 和 $1"],
        [/reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes) emoji/, function (all, reacted) {
            var reactedKey = {'thumbs up': "点赞", 'thumbs down': "点踩", laugh: "大笑", hooray: "欢呼", confused: "表示困惑", heart: "比心", rocket: "发送火箭", eyes: "表示关注"};

            return reactedKey[reacted];
        }],
        // 成为协作者提示
        [/You now have push access to the ([^ ]+) repository./, "您现在拥有推送至 $1 仓库的权限"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
        // 提交 - 作者窗
        [/(\d+) authors?/, "$1 作者"],
    ],
};

I18N["zh-CN"]["page-new-repo"] = {// 仓库 - 新建/导入/复刻仓库
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 新建仓库 https://github.com/new
            "Create a new repository": "新建仓库",
                "A repository contains all project files, including the revision history.": "仓库包含项目中的所有文件，包括修订历史记录。",
                "Already have a project repository elsewhere?": "在其他地方已有仓库？",
                "Import a repository": "导入仓库",
                "Required fields are marked with an asterisk (*).": "带星号 (*) 的为必填项。",

            "🎉 Try the new experience": "🎉 尝试新版页面",

            "Repository template": "仓库模板",
                "Fetching templates…": "正在获取模板…",
                "No template": "不设置模板",
                "No templates available.": "无可用模板。",
                "Start your repository with a template repository's contents.": "使用模板仓库的内容新建仓库。",

            "Owner": "所有者",
            "Repository name": "仓库名称",
            "Great repository names are short and memorable. Need inspiration? How about": "好的仓库名称应该简单且容易记忆。需要灵感吗？这个怎么样：",
                "Checking availability…": "检查可用性…",
                "is available.": "名称可用。",
                "The repository": "仓库",
                "already exists on this account": "已经存在于此账户",
                "Your new repository will be created as": "您的新仓库将被创建为",
                "New repository name must not be blank": "新仓库名称不能为空",

                // 用户名同名仓库
                "You found a secret!": "您发现了一个秘密！",
                "is a ✨": "是一个 ✨",
                "special": "特别的",
                "✨ repository that you can use to add a": "✨ 仓库，您可以用它来添加一个",
                "to your GitHub profile. Make sure it’s public and initialize it with a": "到您的 GitHub 个人资料。确保它是公开的，并在初始化时加入一个",
                "to get started.": "以便开始工作。",
                 // 组织 .github 仓库
                "to your organization's GitHub profile. Make sure it’s public and initialize it with a": "到您组织的 GitHub 个人资料。确保它是公开的，并在初始化时加入一个",
                "in the": "在",
                "directory to get started.": "目录下以便开始工作。",

                // 组织仓库
                "You may not create private repositories by organization policy.": "根据组织政策，您不能创建私有仓库。",

            "Description": "描述",
                "(optional)": "(可选)",
            "Public": "公共",
                "Anyone on the internet can see this repository. You choose who can commit.": "任何人都可以看到这个仓库，您可以选择谁能提交。",
            "Private": "私有",
                "You choose who can see and commit to this repository.": "您可以选择谁可以看和提交到该仓库。",
            "Initialize this repository with:": "使用以下方式初始化此仓库：",
                // "Skip this step if you’re importing an existing repository.": "如果您要导入现有仓库，请跳过此步骤。",
                "Add a README file": "添加 README 文件",
                    "This is where you can write a long description for your project.": "您可以在此处为您的项目编写详细描述。",
                    "Learn more about READMEs.": "了解更多关于 README 的信息。",
            "Add .gitignore": "添加 .gitignore 文件",
                "Choose which files not to track from a list of templates.": "从模板列表中选择哪些文件不需要跟踪。",
                "Learn more about ignoring files.": "了解更多关于忽略文件的信息。",
                ".gitignore template:": ".gitignore 模板：",
                    ".gitignore template": ".gitignore 模板",
                    "Filter…": "筛选…",
                    "None": "无",

                    // 筛选 - 无模板
                    "You haven't created any items yet": "您尚未创建任何项目",
                        "Please add or create new items to populate the list.": "请添加或创建新项目以填充列表。",
            "Choose a license": "选择许可证",
                "A license tells others what they can and can't do with your code.": "许可证告诉其他人，他们可以使用您的代码做什么和不能做什么。",
                "Learn more about licenses.": "了解更多关于许可证的信息。",

                "License:": "许可证：",
                    "License": "许可证",

            // 市场应用列表
            "Grant your Marketplace apps access to this repository": "授予市场应用访问该仓库的权限",
            "You are": "您",
            "subscribed to": "订阅了",
            "Marketplace app": "个市场应用",
            "s": " ",

            "You are creating a public repository in your personal account.": "您正在个人账户中创建公共仓库",
            "You are creating a private repository in your personal account.": "您正在个人账户中创建私有仓库",

            "This will set": "这将设置",
            "as the default branch.": "为默认分支。",
            "Change the default name in": "变更默认名称在",
            "your": "您的",
            "settings": "设置",

            "Create repository": "创建仓库",
            "Creating repository...": "创建仓库中…",

        // 依据模板新建仓库 https://github.com/new?template_owner=<template-owner>&template_name=<template-name>
            "Include all branches": "包括所有分支",
                "Copy all branches from": "复制所有",
                "and not just the default branch.": "仓库分支，而不仅仅是默认分支。",

                "If enabled, all branches from the template repository will be included.": "如果启用，将包含来自模板仓库的所有分支。",

        // 导入仓库 第一页 https://github.com/new/import
            "Import your project to GitHub": "将您的项目导入到 GitHub",
                "Import all the files, including revision history, from another version control system.": "导入的所有文件，包括修订历史记录，来自其他版本控制系统。",
                "Support for importing Mercurial, Subversion and Team Foundation Version Control (TFVC) repositories ended on April 12, 2024. For more details, see the": "对导入 Mercurial、Subversion 和 Team Foundation 版本控制 (TFVC) 仓库的支持已结束于 2024 年 4 月 12 日。有关详细信息，请参阅",
                "changelog": "更新日志",

            "Your source repository details": "您源仓库的详情",
            "The URL for your source repository": "您源仓库的 URL",
                "Learn more about the types of": "了解更多关于",
                "importing git repositories": "导入 Git 仓库",

            "Please enter your credentials if required for cloning your remote repository.": "如果需要克隆远程仓库，请输入您的凭据。",
            "Your username for your source repository": "源仓库用户名",
            "Your access token or password for your source repository": "源仓库的访问令牌或密码",

            "Your new repository details": "新仓库详情",
            //"Owner": "所有者",
            // "Repository name": "仓库名称",
                // "is available.": "名称可用。",
                //"The repository": "仓库",
                //"already exists on this account.": "已经存在于此账户。",
                //"Your new repository will be created as": "您的新仓库将被创建为",
            //"Public": "公共",
            //"Anyone on the internet can see this repository. You choose who can commit.": "任何人都可以看到这个仓库，您可以选择谁能提交。",
            //"Private": "私有",
            //"You choose who can see and commit to this repository.": "您可以选择谁可以看和提交到该仓库。",
            "Cancel": "取消",
            "Begin import": "开始导入",
            "Preparing import…": "准备导入…",
            "Importing commits and revision history to GitHub...": "导入提交和修订历史到 GitHub…",

        // 导入仓库 第一页 /<user-name>/<repo-name>/import
            "Import all the files, including the revision history, from another version control system.": "导入的所有文件，包括修订历史记录，来自其他版本控制系统。",
            "Your old repository’s clone URL": "您旧仓库的克隆地址",
            "supported VCS.": "VCS 的支持。",
            "Your existing repository": "您已存在的仓库",
            "Change repository": "选择仓库",

        // 导入仓库 第二页 /<user-name>/<repo-name>/import
            "Your import will begin shortly...": "导入即将开始…",
            "Preparing your new repository": "准备您的新仓库",
                "There is no need to keep this window open, we’ll email you when the import is done.": "无需保持此窗口，导入完成后我们会通过电子邮件通知您。",
                "There is no need to keep this window open. We'll email you when the import is done.": "无需保持此窗口，导入完成后我们会通过电子邮件通知您。",
            "Detecting your project’s version control system…": "正在检测项目的版本控制系统…",
            "Importing commits and revision history…": "导入提交和修订历史…",
            // [/Updating branches and (\d) commit authors?…/, "更新分支和 $1 个提交者…"],
            "Optimizing repository and pushing commits to GitHub…": "优化仓库并将提交推送到 GitHub…",
            "Importing complete! Your new repository": "导入完成！您的新仓库",
            "is ready.": "已准备就绪。",

        // 复刻仓库 /<user-name>/<repo-name>/fork
            "Create a new fork": "创建新复刻",
                "A": " ",
                "fork": "复刻",
                "is a copy of a repository. Forking a repository allows you to freely experiment with changes without affecting the original project.": "是一个仓库的副本。复刻仓库可以让您在不影响原项目的情况下自由地进行修改实验。",
                "View existing forks.": "查看现有复刻。",

            "No available destinations to fork this repository.": "没有复刻此仓库的可用目标。",
            "Creating fork…": "正在创建复刻…",

            // "Owners": "所有者",
                "Search owners": "搜索",
                "Choose an owner": "选择所有者",
                    "(fork already exists)": "(复刻已存在)",
            // "Repository name": "仓库名称",

                // "The repository": "仓库",
                // "already exists on this account.": "已经存在于此账户。",
                "Your new repository will be created as": "您的新仓库将被创建为",
                    "The repository name can only contain ASCII letters, digits, and the characters": "仓库名称只能包含 ASCII 字母、数字和字符",

            "By default, forks are named the same as their upstream repository. You can customize the name to distinguish it further.": "默认情况下，复刻的名称与他们的上游仓库相同。您可以自定义名称以进一步区分它。",

            "Copy the": "仅复制",
            "branch only": "分支",

            "Contribute back to": "回馈给",
            "by adding your own branch.": "通过添加您自己的分支。",

            "You are creating a fork in your personal account.": "您正在向您的个人账户中创建一个复刻。",
            "Create fork": "创建复刻",

        // 新版新建仓库页
            "Switch back to classic experience": "回到经典页面",
            "Repositories contain a project's files and version history.": "仓库包含项目的文件和版本历史。",
            "Have a project elsewhere?": "在其他地方已有仓库？",

            "General": "通常",
                "Great repository names are short and memorable. How about": "好的仓库名称应该简单且容易记忆。这个怎么样：",

            "Configuration": "配置",
                "Choose visibility": "选择可见性",
                    "Choose who can see and commit to this repository": "选择谁可以查看并提交此仓库",
                "Start with a template": "使用模板开始",
                    "Templates pre-configure your repository with files.": "模板会用文件预先配置您的仓库。",
                "Add README": "添加自述文件",
                    "READMEs can be used as longer descriptions.": "自述文件可以用作更长的描述。",
                    "About READMEs": "关于自述文件",
                // gitignore
                    ".gitignore tells git which files not to track.": ".gitignore 告诉 git 不追踪哪些文件。",
                    "About ignoring files": "关于忽略文件",

                    "Choose a .gitignore template": "选择 .gitignore 模板",
                        "Search templates": "搜索模板",
                        "No .gitignore": "无",
                "Add license": "添加许可证",
                    "Licenses explain how others can use your code.": "许可证解释其他人如何使用您的代码。",
                    "About licenses": "关于许可证",

                    "Search licenses": "选择许可证",
                    "No license": "无",
                "Connect GitHub Apps": "连接 GitHub 应用",
                    "Connect this repository to apps": "将此仓库连接到",
                    "is subscribed to": "订阅的应用",

                    "Choose GitHub Apps": "选择 GitHub 应用",
                    "Search apps": "搜索应用",
                    "Cancel and close": "关闭",

            "Jumpstart your project with Copilot (optional)": "用 Copilot 快速启动您的项目（可选）",
                "Tell Copilot what you want to build in this repository. After creation, Copilot will open a pull request with generated files - such as a basic app, starter code, or other features you describe - then request your review when it's ready.": "告诉 Copilot 您想在此仓库中构建什么。在创建完成后，Copilot 会打开一个包含生成文件的拉取请求（例如基础应用、起始代码或您描述的其他功能），然后在准备好后请求您进行审核。",
                "About Copilot coding agent": "关于 Copilot 编程智能体",

                "Prompt": "提示词",
                    "Describe what you want Copilot to build": "描述您想让 Copilot 做什么",

    },
    "regexp": [ // 正则翻译
        // [/([^ ]+) is available\./,"$1 名称可用。"],
        [/You are creating a public repository in the ([^ ]+) organization./,"您正在 $1 组织中创建一个公共仓库。"], // 创建组织的公共仓库
        [/You are creating a private repository in the ([^ ]+) organization./,"您正在 $1 组织中创建一个私有仓库。"], // 创建组织的私有仓库
        // [/\(fork already exists\)/, "（复刻已存在）"], // 复刻页面
        // [/\(repository already exists\)/, "（仓库已存在）"], // 复刻页面
        [/You are creating a fork in the ([^ ]+) organization./, "您正在 $1 组织中创建一个复刻。"], // 复刻页面
        [/Updating branches and (\d+) commit authors?…/, "更新分支和 $1 个提交者…"], // 仓库导入第二页
        //[/Connect this repository to apps ([^ ]+) is subscribed to/, "将此仓库连接到 $1 订阅的应用程序"],
        [/Auto-installed by ([^ ]+)/, "由 $1 自动安装"],
        [/(\d+) apps? selected/, "已选择 $1 个应用"],
        [/The repository ([^ ]+) already exists on this account/, "仓库 $1 已存在于此账户"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        // [/, and (\d+) more/, "，以及其他 $1 个组织"], // 用户 浮动信息卡
        // [/(\d+) repositor(y|ies)/, "$1 个仓库"], // 组织  浮动信息卡
        // [/(\d+) members?/, "$1 个成员"], // 组织  浮动信息卡
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "New repository": "新建仓库",
            "Import repository": "导入仓库",
        },
        "regexp": [
            [/Fork/, "复刻"],
        ],
    },
};
I18N["zh-CN"]["new"] = I18N["zh-CN"]["page-new-repo"];
I18N["zh-CN"]["new/import"] = I18N["zh-CN"]["page-new-repo"];
I18N["zh-CN"]["repository/import"] = I18N["zh-CN"]["page-new-repo"];
I18N["zh-CN"]["repository/fork"] = I18N["zh-CN"]["page-new-repo"];
I18N["zh-CN"]["orgs/repositories/new"] = I18N["zh-CN"]["page-new-repo"];

I18N["zh-CN"]["repository"] = { // 仓库页面 /<user-name>/<repo-name>/
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 顶部
            "Help us improve GitHub Codespaces": "帮助我们改进 GitHub 代码空间",
                "Tell us how to make GitHub Codespaces work better for you with three quick questions.": "通过三个简单的问题告诉我们如何让 GitHub 代码空间更适合您。",

            "Sorry, couldn’t delete that branch.": "抱歉，无法删除此分支。",
            "Copilot will begin working on your prompt in a draft pull request, and will request review from you when ready.": "Copilot 将起草一个拉取请求开始处理您的需求，并在准备好后请求您进行审核。",

        // 代码标签卡 & 仓库首页 /<user-name>/<repo-name>/ 和 /<user-name>/<repo-name>/tree/<branch>
            // [/Branch ([^ ]+) was renamed to ([^ ]+)./, "分支 $1 已更名为 $2。"],

            // 快捷键
                "Commands": "命令",
                "Clone repository: Copy HTTPS": "克隆仓库：复制 HTTPS",
                "Clone repository: Copy SSH": "克隆仓库：复制 SSH",
                "Clone repository: Copy GitHub CLI": "克隆仓库：复制 GitHub CLI",
                "Copy file permalink": "复制文件永久链接",

            // 操作条
                "forked from": "复刻自",
                "Public repository · Forked from": "公共仓库 · 复刻自", // Android UA 下出现
                "Public repository · Generated from": "公共仓库 · 创建自", // 同上
                "Public archive repository": "公共存档仓库",
                "Public archive repository · Forked from": "公共存档仓库 · 复刻自",
                "generated from": "创建自",
                "mirrored from": "镜像自",

                "Pin": "置顶",
                    "Pin this repository to your profile": "置顶此仓库到您的个人资料",
                    "No pin slots remaining in your profile": "您的个人资料中没有剩余的置顶位",
                "Edit Pins": "编辑置顶",
                    "Pin to…": "置顶到…",
                    "Profile": "个人资料页",
                        "Pin this to your personal profile, visible to everyone": "将此置顶到您的个人资料，对所有人可见",
                        "Limit reached": "已达上限",
                    // 组织仓库
                    "Public pins in this organization": "该组织的公共置顶",
                        "Visible to anyone": "对任何人可见",
                    "Private pins in this organization": "该组织的私有置顶",
                        "Visible to members only": "仅对成员可见",
                "Unpin": "取消置顶",

                "Ignoring": "忽略",
                "Stop ignoring": "取消忽略",
                "Watch": "关注",
                "Unwatch": "取消关注",

                "Star": "星标",
                "Unstar": "已加星标",
                "Fork": "复刻",
                "Unfork": "取消复刻",

                "Sponsor": "赞助",
                // 赞助对话框
                // [/Sponsor ([^ ]+)?/, "赞助 $1"], // 赞助按钮 对话框 标题
                "External links": "外部链接",
                "Learn more about funding links in repositories": "了解更多关于仓库中的赞助链接的信息",
                "Report abuse": "举报滥用",

                // 提交栏 GitHub Action
                "All checks have passed": "已通过所有检查",


                // 关注 & 订阅通知设置 下拉菜单
                "Notification settings": "通知设置", //小屏模式
                "Subscribe to events for": "订阅事件",
                "Notifications": "通知类型",
                "Participating and @mentions": "参与和 @您",
                    "Only receive notifications from this repository when participating or @mentioned.": "仅在参与或 @您 时接收来自此仓库的通知。",
                "All Activity": "所有活动",
                    "Notified of all notifications on this repository.": "接收来自此仓库所有通知。",
                "Ignore": "忽略",
                    "Never be notified.": "永不接收通知。",
                "Custom": "自定义",
                    "Select events you want to be notified of in addition to participating and @mentions.": "选择除参与和 @您 之外还要接收通知的事件。",
                "Get push notifications on": "要获取推送通知，使用",
                "Releases": "发行版",
                    //"Issues are not enabled for this repository": "此仓库未启用议题功能",
                "Discussions": "讨论",
                    //"Discussions are not enabled for this repository": "该仓库未启用讨论功能",
                    //"Discussions are not enabled for this repo": "此仓库未启用讨论功能",
                    "are not enabled for this repository": "功能未启用",
                "Security alerts": "安全警报",
                //"Cancel": "取消",
                "Apply": "应用",

                // 复刻下拉
                "Cannot fork because repository is empty.": "无法复刻，因为仓库是空的。",
                "Cannot fork because you own this repository and are not a member of any organizations.": "不能复刻，因为您拥有该仓库，而且不是任何组织的成员。",
                "Existing forks": "现有的复刻",
                "You don't have any forks of this repository.": "您没有此仓库的任何复刻。",
                "Create a new fork": "创建复刻",

                //
                "Star this repository": "标星仓库", //小屏模式
                "Unstar this repository": "取消仓库星标", //小屏模式

            // 仓库主页 分支保护
                // [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保护"], // 仓库主页 分支保护
                "Your": "您的",
                "branch isn't protected": "分支不受保护", // 新版仓库概述
                "Protect this branch from force pushing or deletion, or require status checks before merging.": "保护此分支免受强制推送或删除，或在合并前要求状态检查。",
                "View documentation.": "查看文档",
                "Protect this branch": "保护该分支",
                "Dismiss": "忽略",

            // 仓库主页 Dependabot 警告框
                "We found potential security vulnerabilities in your dependencies.": "我们在您的依赖项中发现了潜在的安全漏洞。",
                "Only the owner of this repository can see this message.": "仅此仓库的所有者可以看到此消息。",
                "See Dependabot alerts": "查看 Dependabot 警报",

            // 空仓库
                "This repository is empty.": "此仓库是空的。",
                "Care to check out the": "是否愿意查看",
                "GitHub Channel on YouTube": "YouTube 上的 GitHub 频道",
                "while you wait?": "在您等待的时候？",

            // 已上架的 GitHub Action 项目
                "Use this GitHub action with your project": "将此 GitHub Actions 用于您的项目",
                "Add this Action to an existing workflow or create a new one": "将此操作添加到现有工作流程或创建新工作流程",
                "View on Marketplace": "去市场查看",

            // 未上架的 GitHub Action 项目
                "You can publish this Action to the GitHub Marketplace": "您可以将此 Action 发布到 GitHub 市场",
                "Draft a release": "起草发布",

            // 访问已删除的分支
            "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "这个提交不属于本仓库的任何分支，可能属于仓库以外的分支。",

            // 最近有了新提交提醒
            // [/had recent pushes less than/, "有了最近的推送，不到"], //最近有了新提交提醒
            // [/had recent pushes/, "有了最近的推送，"], //最近有了新提交提醒

            "Navigate back to": "导航回", // 小屏模式

            // 左侧正文

            // 文档栏目(仅 Andoid UA)
            "Menu": "菜单",

            // 自述文件(README.md)
            "Filter headings": "筛选标题",
            "Edit file": "编辑文件",

            // 默认分支被重命名提醒框
                "The default branch has been renamed!": "默认分支已重命名!",
                "is now named": "已重命名为",
                "If you have a local clone, you can update it by running the following commands.": "如果您有一个本地克隆，您可以通过运行以下命令来更新它。",
                "OK, got it": "好的，我知道了！",

                // 上游仓库分支重命名
                    "The default branch on the parent repository has been renamed!": "上游仓库默认分支已被重新命名!",
                    "renamed its default branch": "默认分支重命名为",
                    "You can rename this fork's default branch to match in": "您可以重命名此复刻默认分支以匹配，在",
                    "branch settings": "分支设置",

            "branch": "分支",
            "branches": "分支",
            "tag": "标签",
            "tags": "标签",

            "Go to file": "转到文件",
                "No matches found": "未找到匹配项",
                "Go to folder": "转到文件夹",
                "See all results": "查看所有结果",
            "Add file": "添加文件",
                // 添加文件 下拉菜单
                "Create new file": "新建文件",
                "Upload files": "上传文件",
                "Upload file": "上传文件", // Android UA

            // 代码 下拉菜单
                "Local": "本地",
                    "Clone": "克隆",
                        // HTTPS
                        "Clone using the web URL.": "使用 Web URL 克隆。",
                        // SSH
                        "You don't have any public SSH keys in your GitHub account.": "您的 GitHub 账户中没有任何公共 SSH 密钥。",
                        "You can": "您可以",
                        "add a new public key": "添加新的公共密钥",
                        ", or try cloning this repository via HTTPS.": "，或尝试通过 HTTPS 克隆此仓库。",

                        "Use a password-protected SSH key.": "使用受密码保护的 SSH 密钥。",
                        // GitHub CLI
                        "Work fast with our official CLI.": "使用我们的官方 CLI 快速工作。",
                        "Learn more about the CLI": "了解更多关于 CLI 的信息",

                    "Open with GitHub Desktop": "在 GitHub Desktop 中打开",
                        "Launching GitHub Desktop": "GitHub Desktop 启动中",
                            "If nothing happens,": "如果没有响应",
                            "download GitHub Desktop": "下载 GitHub Desktop",
                            "and try again.": "并重试",
                    "Open with Visual Studio": "在 Visual Studio 中打开",
                    "Download ZIP": "下载 ZIP 压缩包",

                    "Code 55% faster with AI pair programming.": "与 AI 一起编程，写代码速度提高55%。",
                        "Start my free trial": "开始我的免费试用",
                        "Don't show again": "不再显示",

                    "Which remote URL should I use?": "我应该使用哪个远程 URL ?",
                    "Copy url to clipboard": "复制链接到剪贴板",
                    // "Copy to clipboard": "复制到剪切板",
                    // "Copied!": "✅ 复制成功!",

                // 代码空间
                    // 维护提示
                        "Codespaces is undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "代码空间正在维护。在此期间，用户可能会遇到连接问题。更多详情请访问",
                        "Codespaces will be undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "代码空间将进行维护。在此期间，用户可能会遇到连接问题。更多详情请访问",
                        "this announcement": "此公告",
                    "Your workspaces in the cloud": "您在云端的工作空间",
                    //[/Create a codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
                    "Codespace repository configuration": "代码空间仓库配置",
                        "New with options...": "新建（选项）…",
                        "Configure dev container": "配置开发容器",
                        "Set up prebuilds": "设置预构建",
                        "Manage codespaces": "管理代码空间",
                        "Share a deep link": "分享深度链接",
                            "Share codespace configuration": "共享代码空间配置",
                            "Choose which settings from this configuration to include when sharing": "选择共享时要包含此配置中的哪些设置",
                            "Quick start": "快速开始",
                            "Automatically create or reuse the most recent matching codespace.": "自动创建或使用最新匹配的代码空间。",
                            "Read more about creating a link.": "阅读有关创建链接的更多信息。",
                            "Snippets": "片段",
                            "Use the following snippets to embed an “Open in Codespaces” button for this configuration in your own page or README.": "使用以下代码片段在您自己的页面或 README 中嵌入此配置的 “在 Codespaces 中打开” 按钮。",
                        "What are codespaces?": "什么是代码空间？",
                    "No codespaces": "尚无代码空间",
                    "You don't have any codespaces with this repository checked out": "您没有检出此仓库的任何代码空间",
                    "Opening in codespace": "正在打开代码空间",
                    //[/Create codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
                    "Learn more about codespaces...": "了解更多关于代码空间的信息…",
                    "Codespace usage for this repository is paid for by": "该仓库的代码空间使用费由以下人员支付",

                    "On current branch": "在当前分支",
                        "No codespaces on current branch": "当前分支上没有代码空间",
                    "On other branches": "在其他分支",
                    "miniature adventure": "迷你探险",
                    "Open miniature adventure in web": "在网络中打开迷你探险",
                    "Active": "激活",
                        "Open in ...": "打开…",
                            "Open in browser": "在浏览器中打开",
                            "Open in Visual Studio Code": "在 Visual Studio Code 中打开",
                            "Open in JetBrains Gateway": "在 JetBrains Gateway 中打开",
                            "Open in JupyterLab": "在 JupyterLab 中打开",
                        "Rename": "重命名",
                            "Change codespace display name to...": "将代码空间显示名称更改为…",
                        "Export changes to a branch": "将更改导出到分支",
                            "This will create a new branch with any unpushed changes": "这将创建一个包含任何未推送更改的新分支",
                            "Create branch": "创建分支",
                        "Change machine type": "更改机器类型",
                            "Change codespace machine type": "更改代码空间机器类型",
                            "Machine type": "机器类型",
                                "2-core": "双核",
                                "4-core": "四核",
                            "Need even more power?": "需要更多的力量？",
                            "Contact our team": "联系我们团队",
                            "to enable 32-core or GPU machines.": "启用 32 核或 GPU 机器。",
                            "Update codespace": "升级代码空间",
                        "Stop codespace": "停止代码空间",
                    "Show more actions for codespace": "显示代码空间的更多操作",
                        "Open in Browser": "在浏览器中打开",
                        "Open in Visual Studio Code": "在 Visual Studio Code 中打开",
                        "Open in JetBrains Gateway": "在 JetBrains Gateway 中打开",
                        "Open in JupyterLab": "在 JupyterLab 中打开",
                        "Rename": "重命名",
                            "Rename codespace": "重命名代码空间",
                            "Name": "名称",
                        "Auto-delete codespace": "自动删除代码空间",
                        "Export changes to a branch": "将更改导出到分支",
                            "This will create a new branch with any unpushed changes": "这将创建一个包含任何未推送更改的新分支",
                            "Checking branch status": "检查分支情况",
                            "Create branch": "创建分支",
                        "Export changes to a fork": "将更改导出到复刻",
                            "You do not have write access to this codespace's repository. This will create a new fork of the repository at": "您没有对此代码空间的仓库的写访问权限。这将创建一个新的仓库分支在",
                            ", reassign your codespace to that fork, and export your changes to a new branch.": "，将代码空间重新分配给该复刻，并将更改导出到新分支。",
                            "Create fork": "创建复刻",
                        "Change machine type": "修改机器类型",
                            "Change codespace machine type": "修改代码空间机器类型",
                            "Update codespace": "更新代码空间",
                        "Stop codespace": "停止代码空间",
                    "No changes": "未更改",
                    "Uncommitted changes": "未提交更改",

                    "You seem to have a billing issue. Please adjust your billing settings to continue using codespaces.": "您似乎遇到了账单问题。请调整您的账单设置以继续使用代码空间。",

                    // 删除对话框
                        "Are you sure?": "您确定吗？",

                // Copilot
                    "Describe a task...": "描述任务…",
                    "Start task": "开始任务",

                    // [/Codespace \"(.+)\" stopped./, "代码空间 “$1” 已停止。"],
                    // [/Codespace \"(.+)\" deleted./, "代码空间 “$1” 已删除。"],
                    // [/Are you sure you want to delete (.+)\?/, "您确定要删除 $1 吗？"],


            "Use this template": "使用此模板",
                "Create a new repository": "新建仓库",
                "Open in a codespace": "在代码空间中打开",

            // 个人仓库 当前分支状态
            "This branch is": "该分支",
            "ahead of": "领先于", // 新版仓库概述
            "behind": "落后", // 新版仓库概述
            "This branch is up to date with": "该分支保持同步与", // 新版仓库概述

            "Contribute": "贡献",
                // 贡献按钮下拉菜单
                "This branch is not ahead of the upstream": "这个分支不领先于上游",
                "No new commits yet. Enjoy your day!": "尚无新提交。祝您愉快！",
                "Open a pull request to contribute your changes upstream.": "打开拉取请求以向上游贡献您的更改。",
                "This branch is not behind the upstream": "这个分支不落后于上游",
                "Open pull request": "打开拉取请求",

            "Sync fork": "同步复刻",
                // 同步复刻按钮下拉菜单
                "This branch is out-of-date": "此分支已过时",
                "Update branch to merge the latest changes from the upstream repository into this branch.": "更新分支，将上游仓库的最新修改合并到本分支。",
                // [/Update branch to keep this branch up-to-date by syncing (\d+) commits? from the upstream repository./, "通过从上游仓库同步 $1 个提交来更新分支，以使该分支保持最新。"], // 同步复刻
                "Update branch to keep this branch up-to-date by syncing": "更新分支以保持该分支与最新状态同步，需要同步",
                "from the upstream repository.": "来自上游仓库。",
                "Learn more about syncing a fork": "了解更多关于复刻同步的信息",
                // [/This branch is not behind the upstream ([^ ]+)/, "该分支不落后与上游 $1"], // 同步复刻
                "No new commits to fetch. Enjoy your day!": "尚无新提交。祝您愉快！", //相同
                "Compare": "对比",
                "Update branch": "更新分支",

                "This branch has conflicts that must be resolved": "该分支有必须解决的冲突",
                // [/Discard (\d+) commits? to make this branch match the upstream repository. (\d+)commits? will be removed from this branch./, "丢弃 $1 个提交，以使本分支与上游仓库一致。$2 个提交将从本分支中删除。"],
                "Discard": "丢弃", // 新版仓库概述
                "to make this branch match the upstream repository.": "，以使本分支与上游仓库一致。", // 新版仓库概述
                "will be removed from this branch.": "将从本分支中删除。", // 新版仓库概述
                "You can resolve merge conflicts using the command line and a text editor.": "您可以使用命令行和文本编辑器解决合并冲突。",
                // [/Discard (\d+) commits?/, "丢弃 $1 个提交"],
                "Discarding changes...": "放弃更改…",

                // 顶部提醒
                    // [/Successfully fetched and merged from upstream ([^ ]+)/, "成功从上游 $1 获取并合并。"],

            // "Choose a head ref": "选择一个头引用",

            // "There isn’t anything to compare.": "没有什么可比较的。",
            // "and": "和",
            // "are entirely different commit histories.": "是完全不同的提交历史。",
            // "No commit comments for this range": "在此范围内没有提交评论",
            // "No new commits yet. enjoy your day!": "尚无新提交。祝您愉快！",
            // "Find a branch": "查找分支",

            // 正文
            "commit": "次提交",
            "commits": "次提交",
            "failure": "失败",
            "success": "成功",
            "Approved": "已批准",
            // [/([\d,]+) Commits?/, "$1 次提交"], // 新版仓库概述
            "Open commit details": "打开提交详细信息", // TODO: 修复该词条翻译不生效问题

            "Failed to load latest commit information.": "载入最新提交信息失败。",

            "View code": "查看代码", //小屏模式

            // 仓库缺失 README 提醒
            "Help people interested in this repository understand your project by adding a README.": "通过添加 README，帮助对此仓库感兴趣的人了解您的项目。",
            "Help people interested in this repository understand your project.": "帮助对此仓库感兴趣的人了解您的项目。",
            "Add a README": "添加 README",

            // 右侧栏

            // 与用户名同名仓库 编辑 README
            "is a special repository.": "是一个特殊的仓库。",
            "Its": "它的",
            "will appear on your public profile.": "将出现在您的公开个人资料中。",
            "Edit README": "编辑 README",
            "Visit profile": "查看资料",

            "is special. If you": "是特殊的。如果您",
            "make this a public repository": "将仓库设置为公开",
            ", its": "，它的",
            "Go to Settings": "前往设置",

            // 组织下.github 仓库 README
                "is a special repository. Create a": "是一个特殊的仓库。创建",
                "and it will appear on the organization's profile!": "并将出现在该组织资料中!",
                "Add profile README": "添加 profile/README",

                "is a special repository.": "是一个特殊的仓库。",
                "will appear on the organization's profile.": "将出现在该组织资料中。",

            // 组织下.github-private 仓库 README
                "Add a README with an overview of your project.": "为您项目添加一个概述 README 文件。",
                "The": " ",
                // [/will appear on ([^ ]+)'s member profile, visible only to organization members./, "将出现在 $1 的成员资料中，仅对组织成员可见。"],

            // "About": "关于"，
            "No description, website, or topics provided.": "未提供描述、网站或主题。",
            "Readme": "自述文件",
            "README": "自述文件",
            "Contributing": "贡献指南",
            "View license": "查看许可证",
                "GPL-3.0 license": "GPL-3.0 许可证",
                "AGPL-3.0 license": "AGPL-3.0 许可证",
                "LGPL-3.0 license": "LGPL-3.0 许可证",
                "MIT license": "MIT 许可证",
                "Apache-2.0 license": "Apache-2.0 许可证",
                "OFL-1.1 license": "OFL-1.1 许可证",
                "0BSD license": "0BSD 许可证",
                "BSD-3-Clause license": "BSD-3-Clause 许可证",
                "CC0-1.0 license": "CC0-1.0 许可证",
                "WTFPL license": "WTFPL 许可证",
                "Unknown": "未知",
            "Code of conduct": "行为准则",
            "Security policy": "安全政策",
            "Cite this repository": "引用此仓库",
                "If you use this software in your work, please cite it using the following metadata.": "如果您使用此软件，请使用以下元数据进行引用。",
                "Learn more about CITATION files.": "了解更多关于引用文件的信息。",
                "View citation file": "查看引用文件",
            "Activity": "活动",
            "Custom properties": "自定义属性",
            "star": "星标",
            "stars": "星标",
            "watching": "关注",
            "fork": "复刻",
            "forks": "复刻",
            "Report repository": "举报仓库",
            "Public repository": "公共仓库", //小屏模式
            "Private repository": "私有仓库", //小屏模式


            // 仓库描述编辑 对话框
            "Edit repository details": "编辑仓库简述",
            "Description": "描述",
            "Short description of this repository": "简短的描述下您的仓库",
            "Website": "网址",
            "Enter a valid URL": "请输入有效的 URL",
            "Use your GitHub Pages website": "使用您的 GitHub Pages 站点",
            "Topics": "主题",
            "(separate with spaces)": "（空格分隔）",
            "Suggested:": "建议：",
                "Add this topic": "接受该建议",
                "Decline this topic": "拒绝该建议",
                    "This isn’t relevant": "这并不相关",
                    "This is too specific": "这太具体了",
                    "This is too general": "这太笼统了",
                    "I just don’t like it": "我只是不喜欢它",
            "Include in the home page": "包含在主页中",

                // 顶部提醒
                "Your repository details have been saved.": "您的仓库简述已保存。",

            "Releases": "发行版",
                "No releases published": "未发布任何版本",
                "Latest": "最新",
                "Create a new release": "创建发行版",
            // "Packages": "软件包",
                "No packages published": "未发布软件包",
                "Publish your first package": "发布软件包",
            "Sponsor this project": "赞助本项目",
                "Learn more about GitHub Sponsors": "了解更多关于 GitHub 赞助者的信息",
            "Used by": "使用者",
            "Contributors": "贡献者",
            "Environments": "环境",
            "Deployments": "部署",
                "+ more deployments": "+ 更多部署",
            "Languages": "语言",

            // "branch": "分支",
            // "branches": "分支",
            // "release": "次发布",
            // "releases": "次发布",
            // "contributor": "个贡献者",
            // "contributors": "个贡献者",

        // 新版仓库概述
            // /<user-name>/<repo-name>#coc
                "Add a code of conduct": "添加行为准则",
                "Define community standards, signal a welcoming and inclusive project, and outline procedures for handling abuse by adding a code of conduct.": "通过添加行为准则，明确社区标准，体现项目的欢迎和包容性，并概述处理滥用行为的程序。",

            // /<user-name>/<repo-name>#license
                "License": "许可证",
                "Add a license": "添加许可证",
                "Add a license to your repository to make it clear how others can use, change, and contribute to your project.": "向仓库中添加许可证，以明确其他人可以如何使用、更改您的项目并为您的项目做出贡献。",

            // /<user-name>/<repo-name>#security
                "Add a security policy": "添加安全策略",
                "Help your community understand how to securely report security vulnerabilities for your project.": "帮助您的社区了解如何安全地报告项目的安全漏洞。",

        // Action 仓库 右侧栏
            "Suggested workflows": "建议的工作流程",
            "Based on your tech stack": "基于您的技术堆栈",
            "Set up": "设立",
            "Configure": "设置",
            "More workflows": "更多工作流程",
            "Dismiss suggestions": "隐藏建议",

        // 仓库复刻中...
            // [/Forking ([^ ]+)/, "复刻 $1 中"], // 复刻中...
            "Generating your repository...": "正在创建您的仓库…",
            "It should only take a few seconds.": "应该只需要几秒钟的时间。",
            "Refresh": "刷新",

        // 初始化空仓库 /<user-name>/<repo-name>/
            "Start coding with Codespaces": "使用代码空间开始编程",
                "Add a README file and start coding in a secure, configurable, and dedicated development environment.": "添加 README 文件并在安全、可配置和专用的开发环境中开始编码。",
                "Create a codespace": "创建代码空间",
            // 组织仓库
            "Set up GitHub Copilot": "设置 GitHub Copilot",
                "Use GitHub's AI pair programmer to autocomplete suggestions as you code.": "使用 GitHub 的 AI 配对程序员在您编码时自动完成建议。",
                "Get started with GitHub Copilot": "开始使用 GitHub Copilot",
            "Add collaborators to this repository": "将协作者添加到此仓库",
                "Search for people using their GitHub username or email address.": "使用 GitHub 用户名或电子邮件地址搜索人员。",
                "Invite collaborators": "邀请协作者",
            "Quick setup": "快速安装",
            "— if you’ve done this kind of thing before": "- 如果您以前做过这样的事",
            "Set up in Desktop": "安装到 GitHub Desktop",
            "Get started by": "通过",
            "creating a new file": "创建一个新文件",
            "uploading an existing file": "上传一个现有的文件",
            ". We recommend every repository include a": "来开始。我们推荐每个仓库都包括",
            ", and": "，和",
            "…or create a new repository on the command line": "…或在命令行上创建一个新的仓库",
            "…or push an existing repository from the command line": "…或从命令行中推送现有的仓库",
            "…or import code from another repository": "…或从另一个仓库导入代码",
            "You can initialize this repository with code from a Subversion, Mercurial, or TFS project.": "您可以初始化此仓库从一个 Subversion，Mercurial 或 TFS 项目导入。",
            "Import code": "导入代码",
            "ProTip!": "专业提示！",
                "Use the URL for this page when adding GitHub as a remote.": "将 GitHub 添加为远程时，请使用此页面上的 URL。",

        // 文件管理器 /<user-name>/<repo-name>/tree/<branch>/<文件夹路径>/
          // /<user-name>/<repo-name>/?search=1
          // /<user-name>/<repo-name>/tree/?search=1
            // 文件树侧边栏
                "Expand file tree": "展开文件树",
                "Collapse file tree": "折叠文件树",
                "Search this repository": "搜索此仓库",

                // 搜索框
                    "Go to file": "转到文件",
                        "No matches found": "未找到匹配项",
                        "Go to folder": "转到文件夹",
                        "See all results": "查看所有结果",

            "Add file": "添加文件",
                // 添加文件 下拉菜单
                "Create new file": "新建文件",
                "Upload files": "上传文件",

            // 新三个点
                "Copy path": "复制路径",
                "Copy permalink": "复制永久链接",
                "Delete directory": "删除文件夹",
                "View options": "查看选项",
                    "Center content": "核心内容",

            "Copied path!": "✅ 路径已复制！",

            "History": "历史",

            "Top": "顶部",
            "Jump to file": "跳转到文件",

            "Name": "文件名",
            "Last commit message": "最后提交消息",
            "Last commit date": "最后提交时间",

            // 编辑按钮
            "Edit README": "编辑 README", // md 文件

        // 文件管理器 - 议题模板 /<user-name>/<repo-name>/tree/<branch>/.github/ISSUE_TEMPLATE
            "Customize the issue creation experience with a": "自定义议题的创建模板使用一个",
            "file.": "文件。",
            "Learn more about configuring a template chooser.": "了解更多关于配置模板选择器的信息。",

    },
    "regexp": [ // 正则翻译
        // 个人仓库 贡献和同步复刻操作后 信息提示条
        [/Successfully fetched and fast-forwarded from upstream ([^ ]+)\./, "成功从上游 $1 中获取并快速转发。"],
        [/Successfully discarded changes and synchronized branch to match upstream ([^ ]+)\./, "成功丢弃更改，并将分支与上游 $1 保持同步。"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/commits by (.+)/, "由 $1 提交"],
        [/Signed-off-by: (.*)/, "签字人：$1"], // TODO: 修复该词条翻译不生效问题
        [/Branch ([^ ]+) was renamed to ([^ ]+)./, "分支 $1 已更名为 $2。"],
        [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保护"], // 仓库主页 分支保护
        [/([\d,]+) Commits?/, "$1 次提交"], // 新版仓库概述
        [/Create a codespace on (.+)/, "在 $1 上创建代码空间"], // 仓库主页 创建代码空间
        [/Create codespace on (.+)/, "在 $1 上创建代码空间"],
        [/Codespace \"(.+)\" stopped./, "代码空间 “$1” 已停止。"],
        [/Codespace \"(.+)\" deleted./, "代码空间 “$1” 已删除。"],
        [/Are you sure you want to delete (.+)\?/, "您确定要删除 $1 吗？"],
        [/Sponsor ([^ ]+)?/, "赞助 $1"], // 赞助按钮 对话框 标题
        [/\+ ([\d,]+) releases?/, "+ $1 个发行版"], // 仓库首页右侧栏 发行版
        [/\+ ([\d,]+) packages?/, "+ $1 个软件包"], // 仓库首页右侧栏 软件包
        [/\+ ([\d,]+) contributors?/, "+ $1 位贡献者"], // 仓库首页右侧栏 贡献者
        [/\+ ([\d,]+) environments?/, "+ $1 个环境"], // 仓库首页右侧栏 环境
        [/\+ ([\d,]+) deployments?/, "+ $1 个部署"], // 仓库首页右侧栏 部署
        // 同步复刻
        [/Update branch to keep this branch up-to-date by syncing (\d+) commits? from the upstream repository./, "通过从上游仓库同步 $1 个提交来更新分支，以使该分支保持最新。"],
        [/This branch is not behind the upstream ([^ ]+)/, "该分支不落后与上游 $1"],
        [/Discard (\d+) commits? to make this branch match the upstream repository. (\d+) commits? will be removed from this branch./, "丢弃 $1 个提交，以使本分支与上游仓库一致。$2 个提交将从本分支中删除。"],
        [/Discard (\d+) commits?/, "丢弃 $1 个提交"],
        [/Successfully fetched and merged from upstream ([^ ]+)/, "成功从上游 $1 获取并合并。"],
        // 贡献
        [/This branch is not ahead of the upstream ([^ ]+)\./, "该分支并不领先上游 $1。"],
        [/This branch is (\d+) commits? ahead of ([^ ]+)\./, "该分支领先上游 $2 $1个提交。"],
        // 个人仓库当前分支状态
        [/This branch is up to date with ([^ ]+)\./, "该分支与上游 $1 保持同步。"],
        [/(\d+) commits? ahead/, "领先 $1 个提交"],
        [/(\d+) commits? behind/, "落后 $1 个提交"],
        [/(\d+) commits?/, "$1 个提交"], // 新版仓库概述
        [/Save (.+?) to your computer and use it in GitHub Desktop./, "使用 GitHub Desktop，保存 $1 到您的电脑。"],
        [/Forking ([^ ]+)/, "复刻 $1 中"], // 复刻中...
        [/Fork your own copy of ([^ ]+)/, "复刻成您自己的 $1 副本"], // 复刻按钮提示
        [/will appear on ([^ ]+)'s member profile, visible only to organization members./, "将出现在 $1 的成员资料中，仅对组织成员可见。"],
        [/and ([^ ]+) were installed on this repository/, "和 $1 已安装到此仓库"], // 顶部提示：市场应用（如果有）
        [/([^ ]+) and (\d+) other licenses found/, function(all, lic, num){
            var licKey = {'Unknown': '未知'};
            return licKey[lic] + '和另外' + num + '个许可证';
        }],
        [/First (\d+) files? shown./, "显示前 $1 个文件。"],
        [/Copy \"(.+)\" to clipboard/, "复制“$1”到剪切板"],
        // 代码 -> 代码空间
        [/(\d+) changes?/, "$1 个更改"],
        [/(.+) has unpushed changes, are you sure you want to delete\?/, "$1 有未提交更改，您确定要删除吗？"],
    ],
    "title": {
        "regexp": [
            [/(.+) at (.+?) · (.+)/, "$1 在分支 $2 · $3"],
            [/(.+) at (.+)/, "$1 在分支 $2"],
        ],
    },
};
I18N["zh-CN"]["repository/tree"] = I18N["zh-CN"]["repository"];

I18N["zh-CN"]["repository/milestones"] = { // 仓库 - 里程碑页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 里程碑页面 /<user-name>/<repo-name>/milestones
            "Labels": "标签",
            "Milestones": "里程碑",

            "You haven’t created any Milestones.": "您尚未创建任何里程碑。",
            "Use Milestones to create collections of Issues and Pull Requests for a particular release or project.": "使用里程碑为特定版本或项目创建议题和拉取请求的集合。",

            // 组织 仓库 里程碑
            "No Milestones found!": "没有发现里程碑!",
            "If this project had milestones, we’d show you them here. Promise!": "如果该项目有里程碑，我们会在此处向您展示。",

            "Create a Milestone": "创建里程碑",

            "Sort": "排序",
            "Sort by": "排序",
                "Recently updated": "最近更新",
                "Furthest due date": "最迟到期日",
                "Closest due date": "最近到期日",
                "Least complete": "最不完整",
                "Most complete": "最完整",
                "Alphabetical": "按字母顺序",
                "Reverse alphabetical": "按字母倒序",
                "Most issues": "最多的议题",
                "Fewest issues": "最少的议题",

            "No due date": "没有截止日期",
            "issues closed": "议题关闭",
            // [/Due by (.*)/, "截止日期 $1"], // 里程碑截止日期
            "Last updated": "最后更新",
            "(more)": "（更多）",
            // 完成进度条
            "complete": "已完成",
            "open": "打开",
            "closed": "关闭",

        // 新建里程碑页面 /<user-name>/<repo-name>/milestones/new
            "New milestone": "新建里程牌",
                "Create a new milestone to help organize your issues and pull requests. Learn more about": "创建一个新的里程碑来帮助组织您的议题和拉取请求。了解更多关于",
                "milestones and issues": "里程碑和议题",
            "Title": "标题",
            "Due date (optional)": "截止日期（可选）",
            "Description": "描述",
            "Create milestone": "创建里程碑",

        // 单个里程碑页 /<user-name>/<repo-name>/milestones
            "opened": "打开于",
            "was closed": "关闭于",

            "There are no open issues in this milestone": "此里程碑没有打开议题",
            "Add issues to milestones to help organize your work for a particular release or project. Find and add": "将议题添加到里程碑，有助于为特定的版本或项目组织您的工作。在此仓库中查找并添加",
            "issues with no milestones": "没有里程碑的议题。",
            "in this repo.": " ",

            "There are no closed issues in this milestone": "此里程碑没有已关闭议题",
            "Issues will automatically be moved here when they are closed.": "议题在关闭后会自动移到这里。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/([\d,]+) Open/, "$1 打开"],
        [/([\d,]+) Closed/, "$1 已关闭"],
        [/(\d+\%) completed/, "$1 已完成"],
    ],
};

I18N["zh-CN"]["repository/milestone"] = I18N["zh-CN"]["repository/milestones"]; // 仓库 - 某里程碑

I18N["zh-CN"]["repository/pull_issue_public"] = { // 仓库 - 议题和拉取请求页面公共部分
    "static": { // 静态翻译
        // pull 与 request 公共词条
            "Filters": "筛选",
                // 筛选下拉菜单
                "Filter Issues": "筛选议题",
                "Open issues and pull requests": "打开的议题和拉取请求",
                "Your issues": "您提出的议题",
                "Your pull requests": "您的拉取请求",
                "Everything assigned to you": "任何分配给您的",
                "Everything mentioning you": "任何提及您的",
                "View advanced search syntax": "查看高级搜索语法",

            "Search all issues": "搜索所有议题",
            "Clear current search query, filters, and sorts": "清除当前的搜索查询、筛选器和排序方式",

            "ProTip!": "专业提示！",
                "Find everything you created by searching": "通过搜索查找您创建的所有内容：",
                "Exclude your own issues with": "排除您自己创建的议题：",
                "Mix and match filters to narrow down what you’re looking for.": "通过混合和匹配筛选器以缩小查找范围。",
                "Exclude everything labeled": "排除所有标有",
                "with": "标签的内容，使用：",
                "Follow long discussions with": "要跟进长讨论，请使用：",
                "on any issue or pull request to go back to the pull request listing page.": "在任何议题或拉取请求上使用以返回拉取请求列表页面。",
                "Filter pull requests by the default branch with": "通过默认分支过滤拉取请求：",
                "to see everything that’s not assigned.": "以查看所有未分配的内容。",
                "Find all pull requests that aren't related to any open issues with": "查找所有未关联任何打开议题的拉取请求，使用：",
                "Add comments to specific lines under": "在以下特定行添加注释：",
                "will show everything without a milestone.": "将显示所有没有里程碑的内容。",
                "Updated in the last three days:": "最近 3 天更新：",
                "Notify someone on an issue with a mention, like:": "在议题中通过 @ 提及通知某人，例如：",
                "Adding": "添加",
                "will show everything without a label.": "将显示所有无标签的内容。",
                "on any issue or pull request to go back to the issue listing page.": "在任何议题或拉取请求上使用以返回议题列表页面。",
                "Click a checkbox on the left to edit multiple issues at once.": "单击左侧复选框即可同时编辑多个议题。",
                // [/Ears burning? Get @([^ ]+) mentions with/, "耳朵要炸了？如果只需要查看提及了 $1 的内容，请使用"]


            "Labels": "标签",
                "No labels": "无标签",
            "Milestones": "里程碑",
            "New issue": "创建议题",
            "New": "创建", // 小屏

            // 筛选工作条
            // "Author": "作者",
                "Filter by author": "按用户筛选",
                "Filter users": "筛选用户名",

            "Label": "标签",
                "Filter by label": "按标签筛选",
                "Filter labels": "筛选标签",
                "Unlabeled": "无标签",
                "to exclude labels": "排除标签",
                "for logical OR": "表示逻辑“或”",

            // "Projects": "项目",
                "Filter by project": "按项目筛选",
                "Filter projects": "筛选项目",
                "Repository": "仓库",
                "Organization": "组织",
                "No projects found. Sorry about that.": "很抱歉，未找到任何项目。",

            // "Milestones": "里程碑",
                "Filter by milestone": "按里程碑筛选",
                "Filter milestones": "筛选里程碑",
                "Issues with no milestone": "无里程碑的议题",
                "Pull requests with no milestone": "无里程碑的拉取请求", // pulls
                "Nothing to show": "暂无",

            "Assignee": "受理人",
                "Filter by who’s assigned": "按受理人筛选",
                "Filter assignees": "筛选受理人",
                "Assigned to nobody": "无受理人",
                // [/Awaiting requested review from ([^ ]+)/, "正在等待 $1 审查请求"],
                "Requested changes must be addressed to merge this pull request.": "要合并这个拉取请求，必须先解决所要求的更改。",
                "No one -": "无人 -",
                    "Assign yourself": "分配给自己",

            "Relationships": "关系",
                "Parent issue": "父议题",

            "Sort": "排序",
                "Sort by": "排序",
                "Newest": "最新的",
                "Oldest": "最早的",
                "Most commented": "最多评论",
                "Least commented": "最少评论",
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新", //?
                "Most reactions": "多数反应",
                "Best match": "最佳匹配",

            // 选中模式
                "selected": "选中",
                "Mark as": "标记为",
                "Apply labels": "应用标签",
                "Assign": "分配",
                    "Assign someone": "分配给某人",
                    "Assign to nobody": "分配给任何人",

            // 筛选结果
            "No results matched your search.": "没有与您的搜索匹配的结果。",
            "You could search": "您可以搜索",
            "all of GitHub": "所有 GitHub",
            "or try an": "或者尝试",
            "advanced search": "高级搜索",

            // 状态词
            "was merged": "合并于",
            "was closed": "关闭于",
            "closed this": "关闭了这个",
            "reopened this": "重新打开了这个",
            "Approved": "已批准",
            "Review required": "需要审查", // 拉取请求 页面状态词
                "Review required before merging": "合并前需要审查",
            "outdated": "陈旧的",
            "Pending": "待定",
            "Draft": "草案",
            "deployed": "部署",
                "View deployment": "查看部署",
            "This was referenced": "被引用于",
            "locked as": "锁定为",
                "spam": "垃圾信息",
            "and limited conversation to collaborators": "并限制与协作者对话",
            "assigned": "分配给",
            "labels": "标签",

            // 图标浮窗
            "Open issue": "议题已打开",
            "Closed issue": "议题已完成",
            "Closed as not planned issue": "议题已关闭因未计划",
            "Open Pull Request": "拉取请求已打开",
            "Draft Pull Request": "拉取请求草案",
            "Merged Pull Request": "拉取请求已合并",
            "Closed Pull Request": "拉取请求已关闭",

            // [/(\d+) linked pull requests?/, "链接 $1 个拉取请求"],

        // 某个拉取请求和某个议题 公共词条
            // 顶部提醒
                "You’ve been unsubscribed from this thread.": "您已退订该主题。",

            // 右侧栏
                "Reviewers": "审查者",
                    "No reviews": "无人审查",
                    "Loading suggestions…": "载入推荐…",
                    // [/([^ ]+) left review comments/, "$1 发表了审查意见"],
                    // [/At least (\d+) approving reviews? is required to merge this pull request./, "合并此拉取请求至少需要 $1 次批准审核。"], // 具体的拉取请求 审查者
                    "No reviews—at least 1 approving review is required.": "未经审查—至少需要 1 次批准审查。",
                    "Re-request review": "重新请求审核",
                    "Still in progress?": "仍在进行中吗？",
                    // [/Awaiting requested review from ([^ ]+)/, "等待 $1 的审查请求"]
                    "Learn about draft PRs": "了解拉取请求草案",
                        "Try draft pull requests": "尝试拉取请求草案",
                        "Open an in-progress pull request without asking for formal review or risking an unwanted merge. When you're ready for code review, you can mark your draft pull request as ready for review, which will request reviews from any code owners.": "打开正在进行的拉取请求，无需请求正式审核，也不必冒不必要的合并风险。当您准备好进行代码审核时，您可以将拉取请求草案标记为已准备好审核，这将请求任何代码所有者进行审核。",
                        "Ask admin for access": "向管理员请求权限",
                    "Convert to draft": "设置为草案",
                        // 设置草案对话框
                            "Convert this pull request to draft?": "将此拉取请求转换为草案？", // 拉取请求
                            "People who are already subscribed will not be unsubscribed.": "已订阅的用户将不会被取消订阅。",
                    // 下拉
                    "Request up to 15 reviewers": "最多请求 15 个审查者",
                    // [/([^ ]+) approved these changes/, "$1 批准这些更改"], // 具体的拉取请求 审查者
                    "Request": "请求",
                    // [/Request review from ([^ ]+)/, "请求 $1 审查"], // 具体的拉取请求 审查者
                    "This pull request is waiting on your review.": "此拉取请求正在等待您的审核。",

                "Assignees": "受理人",
                    "No one assigned": "无人受理",
                    "No one—": "无人 - ",
                    "assign yourself": " 受理自己",
                    // 下拉框
                    "Assign up to 10 people to this issue": "最多指定 10 人", // 议题
                    "Assign up to 10 people to this pull request": "最多指定 10 人", // 拉取请求
                    "Clear assignees": "清除受理人",
                    "Type or choose a user": "输入或选择用户",
                    "Suggestions": "建议",

                // "Labels": "标签",
                    "None yet": "暂无",
                    // 下拉
                    "bug": "BUG",
                        "Something isn't working": "有些东西不工作",
                    "dependencies": "依赖性",
                        "Pull requests that update a dependency file": "更新一个依赖文件的拉取请求",
                    "documentation": "文档",
                        "Improvements or additions to documentation": "文档的改进或补充",
                    "duplicate": "重复",
                        "This issue or pull request already exists": "这个议题或拉取请求已经存在",
                    "enhancement": "增强",
                        "New feature or request": "新功能或请求",
                    "good first issue": "好的首发议题",
                        "Good for newcomers": "适合新人",
                    "help wanted": "需要帮助",
                        "Extra attention is needed": "需要特别关注",
                    "invalid": "无效",
                        "This doesn't seem right": "这似乎不对",
                    "question": "问题",
                        "Further information is requested": "要求提供更多信息",
                    "wontfix": "不会修复",
                        "This will not be worked on": "这将不会被处理",

                    "Apply labels to this issue": "应用标签", // 议题
                    "Apply labels to this pull request": "应用标签", // 拉取请求
                    "Edit labels": "编辑标签",

                    // 拉取请求
                    "dependencies": "依赖项",
                        "Pull requests that update a dependency file": "更新依赖文件的拉取请求",

                // 项目
                    "Recent": "最近",
                    "User": "用户",
                    "No projects": "无项目",

                "Milestone": "里程碑",
                    "No milestone": "无里程碑",
                    //下拉
                    "Set milestone": "设置里程碑",
                        "Nothing to show": "暂无",

                "Development": "进展",
                    "Successfully merging this pull request may close these issues.": "成功合并此拉取请求可能会关闭这些议题。",
                    "Successfully merging a pull request may close this issue.": "成功合并一个拉取请求可能会关闭此议题。",
                    // 下拉
                    "Link an issue from this repository": "关联来自此仓库的议题",
                    "Filter": "筛选",
                    "No results": "无结果",
                    "Open in Workspace": "在工作区打开",

                // "Notifications": "通知类型",
                "Customize": "自定义",
                "Subscribe": "订阅",
                // "Unsubscribe": "取消订阅",
                "You’re not receiving notifications from this thread.": "您没有收到来自该话题的通知。",
                "You're not receiving notifications from this thread.": "您没有收到来自该话题的通知。",
                "You're receiving notifications because you're subscribed to this thread.": "您收到通知是因为您订阅了该话题。",
                "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因为您订阅了该话题。",
                "You’re receiving notifications because you’re watching this repository.": "您收到通知是因为您正在关注此仓库。",
                "You’re receiving notifications because you authored the thread.": "您收到通知是因为您提出了该话题。",
                "You’re receiving notifications because you were mentioned.": "您收到通知是因为有人 @您。",
                "You’re receiving notifications because you commented.": "您收到通知是因为您发表了评论。",
                "You’re receiving notifications because you are watching pull requests on this repository.": "您收到通知是因为您正在关注此仓库上的拉取请求。",
                "You’re receiving notifications because you are watching issues on this repository.": "您收到通知是因为您正在关注此仓库上的议题。",
                "You’re receiving notifications because you modified the open/close state.": "您收到通知是因为您修改了打开/关闭状态。",
                "You’re receiving notifications because you were assigned.": "您收到通知是因为您受理了它。",
                "You’re ignoring this repository.": "您忽略了这个仓库。",

                    // 通知设置对话框
                    "Notification settings": "通知设置",
                    "Notifications settings": "通知设置", // 新版议题页面
                    "Not subscribed": "未订阅",
                        "Only receive notifications from this pull request when you have participated or have been @mentioned.": "只有在您参与或被 @您 时才会收到来自此拉取请求的通知。",
                        "Only receive notifications from this issue when you have participated or have been @mentioned.": "只有在您参与或被 @您 时才会收到来自此议题的通知。", // 议题页面
                    "Subscribed": "订阅",
                        "Receive all notifications from this pull request.": "接收来自此拉取请求的所有通知。",
                        "Receive all notifications from this issue.": "接收来自此议题的所有通知。",  // 议题页面
                    "Custom": "自定义",
                        "You will only be notified for events selected from the list below. If you participate or are @mentioned you will be subscribed.": "您只会收到从以下列表中选择的事件的通知。如果您参与或 @您 时，将自动订阅。",
                        "You will only be notified for the events selected from the list below.": "您只会收到从以下列表中选择的事件的通知。",
                        "If you participate or are @mentioned you will be subscribed.": "如果您参与或 @您 时，将自动订阅。",
                    // 议题
                        "Receive a notification when this issue has been closed.": "当议题被关闭时，收到通知。",
                        "Reopened": "重新打开",
                            "Receive a notification when this issue has been reopened.": "当议题被重新打开时，收到通知。",
                    // 拉取请求
                        "Receive a notification when this pull request has been merged.": "当拉取请求被合并时，收到通知。",
                        "Receive a notification when this pull request has been closed.": "当拉取请求被关闭时，收到通知。",
                        "Receive a notification when this pull request has been reopened.": "当拉取请求被重新打开时，收到通知。",

                "Lock conversation": "锁定对话",
                    "Lock conversation on this issue": "锁定此议题的对话",
                    "Lock conversation on this pull request": "锁定此拉取请求的对话",
                    "Other users": "其他用户",
                    "can’t add new comments": "无法添加新评论",
                    "to this issue.": "到该议题。",
                    "to this pull request.": "到该拉取请求。",
                    "You and other collaborators": "您和其他协作者",
                    "with access": "有权限访问",
                    "to this repository": "该仓库",
                    "can still leave comments": "仍然可以发表评论",
                    "that others can see.": "其他人可以看到。",
                    "You can always unlock this issue again in the future.": "您今后仍可以随时再次解锁此议题。",
                    "You can always unlock this pull request again in the future.": "您今后仍可以随时再次解锁此拉取请求。",
                    "Other users can't add new comments to this issue. You and other members of teams with": "其他用户无法在此议题下添加新评论。您及",
                    "write access": "有权访问",
                    "to this repository can still leave comments that others can see. You can always unlock this issue again in the future.": "该仓库的团队成员仍可发表其他用户可见的评论。您随时可以在未来重新解锁此议题。",
                    "Reason for locking": "锁定原因",
                    "Choose a reason": "选择原因",
                    "Reason": "原因",
                        "No reason": "无",
                        "Off-topic": "偏离主题",
                        "Too heated": "争论不休",
                        "Resolved": "已解决",
                        "Spam": "垃圾信息",
                    "Optionally, choose a reason for locking that others can see. Learn more about when it’s appropriate to": "或者，选择其他人可以看到的锁定原因。详细了解何时适合",
                    "lock conversations": "锁定对话",
                    // "Lock conversation on this issue": "锁定对话",
                "Unlock conversation": "解锁对话",
                    "Unlock conversation on this issue": "解锁此议题的对话",
                    "Unlock conversation on this pull request": "解锁此拉取请求的对话",
                    "Everyone": "任何人",
                    "will be able to comment on this issue once more.": "将能够再次对这个议题发表评论。",
                    "will be able to comment on this pull request once more.": "将能够再次对这个拉取请求发表评论。",
                    "You can always lock this pull request again in the future.": "您今后仍可以随时再次锁定此拉取请求。",
                    "You can always lock this issue again in the future.": "您今后仍可以随时再次锁定此议题。",
                    "Everyone will be able to comment on this issue once more. You can always lock this issue again in the future.": "任何人将能够再次对这个议题发表评论。您今后仍可以随时再次锁定此议题。",

                // 隐藏评论对话框
                "The reason will be displayed to describe this comment to others.": "将显示原因，以便向其他人描述此评论。",
                "Learn more about hiding comments": "了解更多关于隐藏评论的信息",
                "comment": "评论",
                "Unhide": "取消隐藏",
                "Choose a reason for hiding this comment": "选择隐藏此评论原因",
                "Choose a reason": "选择原因",
                    "Abuse": "滥用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏离主题",
                    "Outdated": "过时",
                    "Duplicate": "重复",
                    "Resolved": "已解决",

                "This comment has been minimized.": "此评论已最小化。",
                    "Show comment": "显示评论",
                    "Hide comment": "隐藏评论",

            "Remember, contributions to this repository should follow our": "请记住，对该仓库的贡献应遵循我们的",
            "GitHub Community Guidelines": "GitHub 社区准则",
            "Remember, contributions to this repository should follow its": "请记住，对该仓库的贡献应遵循",
            "contributing guidelines": "贡献指南",
            "security policy": "安全政策",
            "code of conduct": "行为准则",
            "contributing guidelines": "贡献准则",

            // 被锁定
                "This conversation has been locked as": "此对话已锁定为",
                    "and limited to collaborators.": "，并限制与协作者对话。",
                "You can't perform this action at this time.": "您此时不能操作。",

            // 底部赞助
                "Show your support for": "通过赞助来表达您对",
                "by sponsoring them.": "的支持。",
                "Sponsor": "赞助",

            // 底部提示栏 (未登录)
                "Sign up for free": "免费注册",
                "to subscribe to this conversation on GitHub": "在 GitHub 上订阅这个讨论",
                "to join this conversation on GitHub": "加入 GitHub 上的这个讨论",
                ". Already have an account?": "。已经有账户？",
                "Sign in to comment": "登录后发表评论",
    },
    "regexp": [ // 正则翻译
        // [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有写入权限的审查者至少需要 $1 次批准审查。"],
        [/(\+\d+) more reviewers?/, "$1 个审查者"],
        [/(\d+) linked issues?/, "链接 $1 个议题"],
        [/Assigned to (.*)/, "分配给 $1"],
        [/Edited (\d+) times?/, "编辑 $1 次"],
        [/Open issues created by ([^ ]+)/, "$1 创建议题"],
        [/issues opened by ([^ ]+)/, "$1 打开议题"],
        [/Open pull requests created by ([^ ]+)/, "$1 创建拉取请求"],
        [/pull requests opened by ([^ ]+)/, "$1 打开拉取请求"],
        [/(\d+) hidden conversations/, "$1 条隐藏对话"],
        [/Ears burning\? Get @([^ ]+) mentions with/, "耳朵要炸了？如果只需要查看提及了 $1 的内容，请使用"]
    ]
};

I18N["zh-CN"]["repository/issues"] = { // 仓库 - 议题页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["static"],

        // 仓库 --> 议题 标签卡/<user-name>/<repo-name>/issues
        // /<user-name>/<repo-name>/labels/<label-name>
            // 欢迎信息
            "Welcome to issues!": "欢迎关注议题！",
            "Issues are used to track todos, bugs, feature requests, and more. As issues are created, they’ll appear here in a searchable and filterable list. To get started, you should": "议题用于跟踪待办事项、错误、功能请求等。创建议题后，它们将出现在可搜索和可筛选的列表中。要开始，您应该",
            "create an issue": "创建议题",
                "Open issue creation in fullscreen": "全屏", // 有议题模板时

            "Label issues and pull requests for new contributors": "标记新贡献者的议题和拉取请求",
            "Now, GitHub will help potential first-time contributors": "现在，GitHub 将帮助潜在的首次贡献者",
            "discover issues": "探索议题",
            "labeled with": "标记为",
                "Completed": "已完成",
            "Project": "项目",

            "Clear filter": "清除筛选",
            "Filter authors": "筛选作者",
            "Filter by assignees": "筛选受理人",
                "No assignees": "无人受理",
            // 新版内容
                // 顶部
                    "👋 Want to contribute to": "👋 想做贡献给",
                // 排序
                    "Created on": "创建时间",
                    "Comments": "评论",
                    "Total comments": "评论数",
                    "Reactions": "看法数",
                    "Total reactions": "总看法数",
                    "Thumbs up": "点赞",
                    "Thumbs down": "点踩",
                    "Rocket": "火箭",
                    "Hooray": "欢呼",
                    "Eyes": "关注",
                    "Heart": "比心",
                    "Laugh": "大笑",
                    "Confused": "拒绝",
                    "Ascending": "递增",
                    "Descending": "递减",

                "Types": "类型",
                "Issue type": "议题类型",
                    "Filter by issue type": "按议题类型筛选",
                    "Select issue type": "选择议题类型",
                    "Filter types": "筛选类型",
                        "No type": "无类型",
                            "Issues with no type": "无类型议题",
                            "No issue type": "无议题类型",
                // 搜索
                "Try adjusting your search filters.": "尝试调整搜索筛选器。",

            // [/Want to contribute to ([^ ]+)/, "想为 $1 做贡献吗？"], /issues
            "If you have a bug or an idea, read the": "如果您发现一个错误或有任何想法，请阅读",
            "before opening an issue.": "，在打开议题之前。",
            "If you have a bug or an idea, browse the open issues before opening a new one. You can also take a look at the": "如果您发现一个错误或有任何想法，请在打开新议题之前浏览未解决的议题。您也可以看看",
            "Open Source Guide": "开源指南",
                "Learn about Open Source and how to contribute": "了解开源和如何贡献",
            "If you're ready to tackle some open issues,": "如果您准备好解决一些未解决的议题，",
            "we've collected some good first issues for you": "我们已为您收集了一些好的首发议题",
            "we've collected some good first issues for you.": "我们已为您收集了一些好的首发议题。", // 新版议题页

            "Dismiss": "忽略",
                // 忽略 下拉
                "Dismiss for this repository only": "仅对该仓库不在提示",
                "Dismiss for all repositories": "对所有仓库均不在提示",


            "There aren’t any open issues.": "暂无开放的议题。",

            // 状态词
            "Merged": "已合并",
            // "open": "打开",
            // "Opened": "打开",
            "opened": "打开于",
            // "closed": "已关闭",
            // 新版
                "Closed as not planned": "关闭因未计划",
                "Closed as duplicate": "关闭因重复",
                "of": "于",
                "Not planned": "未计划",

            // 父级议题
            "Parent:": "父级：",
            // 子级议题
            "Create sub-issue": "创建子议题",
                //"Create sub-issue": "创建子议题",
                    // 窗口
                        "Create new issue": "新建议题",
                            "Select an item": "选择一项",
                                "Select repository": "选择仓库",
                            "Templates and forms": "模板和表单",
                                // 空白议题
                                    "Create a new issue from scratch": "从头开始创建新议题",
                "Add existing issue": "添加现有议题",
                    "Search issues": "搜索议题",
                        "Group selected": "分组选择",


                "Blank issue": "空白议题",
                    "in": "在",
                "Type your description here…": "在此键入介绍…",
                "Create more sub-issues": "创建更多子议题",

                // 警告
                    "Are you sure?": "您确定吗？",
                        "Sub-issues are limited to one parent. Confirm you want to proceed with this change.": "子议题仅允许关联一个父议题。请确认是否要继续进行此更改？",
                        "Change parent issue": "更改父议题",

            "Sub-issues": "子议题",
                "Collapse Sub-issues": "折叠子议题",
                "Expand Sub-issues": "展开子议题",

                "More list item action bar": "更多操作",
                    "Remove sub-issue": "移除子议题",

            "Invalid value": "无效值",
            "for": "，",
            //"parent-issue": "父议题",

            "You commented on and opened this issue": "您打开了此议题并发表了评论",
            "You were mentioned on and commented on this issue": "您被提及并对此议题发表了评论",
            "You commented on this issue": "您对此议题发表了评论",
            "You opened this issue": "您打开了此议题",

            // 置顶议题
            "Pinned issues": "置顶议题",
            "Drag to reorder": "拖拽排序",
            "Pinned issue options": "置顶选项",

            "Unpin": "取消置顶",
            "Advanced move...": "高级移动…",
                "Move selected item": "移动选中项",
                    "Item": "标题",
                    "Action": "操作",
                    "Move item before": "移动到…之前",
                    "Move item after": "移动到…之后",
                    "Move to position": "指定位置",
                    "Move": "移动",
            "Search Issues": "搜索议题",
                // 仓库
                    "No repository": "无仓库",
                    "Has repository": "包含仓库",
                    "Exclude repo": "排除仓库",
                // 组织
                    "Has organization": "包含组织",
                    "Exclude org": "排除组织",
                "Is": "类型为",
                    "Exclude is": "排除类型为",
                    "Issue": "议题",
                    "Pull Request": "拉取请求",
                    "Unmerged": "未合并",
                    "Locked": "已锁定",
                    "Unlocked": "未锁定",
                    "Blocked": "已阻塞",
                "State": "状态",
                    "Exclude state": "排除状态",
                // 标签
                    "No label": "无标签",
                    "Has label": "包含标签",
                    "Exclude label": "排除标签",
                    "aesthetics": "美化",
                    "bug": "缺陷",
                    "dependencies": "依赖项",
                    "development": "开发中",
                    "discuss": "讨论",
                    "documentation": "文档",
                    "duplicate": "重复",
                    "enhancement": "功能增强",
                    "forums": "论坛",
                    "good first issue": "适合新手",
                    "help wanted": "求助",
                    "invalid": "无效",
                    "question": "提问",
                    "website": "网站",
                    "wontfix": "不会修复",
                // 类型
                    "No type": "无类型",
                    "Has type": "包含类型",
                "Project": "项目",
                    "No project": "无项目",
                    "Has project": "包含项目",
                    "Exclude project": "排除项目",
                "Milestone": "里程碑",
                    "No milestone": "无里程碑",
                    "Has milestone": "包含里程碑",
                    "Exclude milestone": "排除里程碑",
                // 受理人
                    "No assignee": "无受理人",
                    "Has assignee": "包含受理人",
                    "Me": "我",
                        "Signed-in user": "已登录用户",
                    // Copilot
                        "Your AI pair programmer": "您的 AI 编程助理",
                    "Exclude assignee": "排除受理人",
                "Author": "作者",
                    "Has author": "包含作者",
                    "Exclude author": "排除作者",
                "Involves": "涉及",
                    "Has involves": "包含涉及",
                    "Exclude involves": "排除涉及",
                "Mentions": "提及",
                    "Has mentions": "包含提及",
                    "Exclude mentions": "排除提及",
                "Parent issue": "父议题",
                    "No parent issue": "无父议题",
                    "Has parent issue": "包含父议题",
                    "Exclude parent-issue": "排除父议题",
                "Blocking": "阻塞",
                    "No blocking": "无阻塞",
                    "Has blocking": "包含阻塞",
                    "Exclude blocking": "排除阻塞",
                "Blocked by": "被…阻塞",
                    "No blocked by": "无被阻塞",
                    "Has blocked by": "包含被阻塞",
                    "Exclude blocked-by": "排除被阻塞",
                "Sub-issue": "子议题",
                    "No sub-issue": "无子议题",
                    "Has sub-issue": "包含子议题",
                    "Exclude sub-issue": "排除子议题",
                "Update date": "更新日期",
                    "Exclude updated": "排除更新日期",
                    "Today": "今天",
                    "Yesterday": "昨天",
                    "Past 7 days": "过去 7 天",
                    "Past 30 days": "过去 30 天",
                    "Past year": "过去 1 年",
                "Creation date": "创建日期",
                    "Has creation date": "包含创建日期",
                    "Exclude created": "排除创建日期",
                "Closed date": "关闭日期",
                    "Has closed date": "包含关闭日期",
                    "Exclude closed": "排除关闭日期",
                "Merge date": "合并日期",
                    "Has merge date": "包含合并日期",
                    "Exclude merged": "排除合并日期",
                "Review requested": "已请求评审",
                    "Has review requested": "包含已请求评审",
                    "Exclude review-requested": "排除已请求评审",
                "In": "在",
                    "Has in": "包含在",
                    "Exclude in": "排除在",
                    "Body": "正文",
                    "Comments": "评论",
                "Commenter": "评论者",
                    "Has commenter": "包含评论者",
                    "Exclude commenter": "排除评论者",
                "User": "用户",
                    "Has user": "包含用户",
                    "Exclude user": "排除用户",
                "User review requested": "已请求用户评审",
                    "Has user review requested": "包含已请求用户评审",
                    "Exclude user-review-requested": "排除已请求用户评审",
                "Reviewed by": "评审者",
                    "Has reviewed by": "包含评审者",
                    "Exclude reviewed-by": "排除评审者",
                "Comment count": "评论数",
                    "Has comment count": "有评论数",
                    "Less than 10": "少于 10",
                    "More than 10": "多于 10",
                    "Between 10 and 100": "10 到 100",
                "Interactions count": "互动数",
                    "Has interactions count": "有互动数",
                "Closed reason": "关闭原因",
                    "Exclude reason": "排除原因",
                    "Completed": "已完成",
                    "Not planned": "未计划",
                    "Duplicate": "重复",
                "Linked": "已链接",
                    "Has linked": "包含已链接",
                    "Exclude linked": "排除已链接",
                "Archived": "已归档",
                    "Has archived": "包含已归档",
                    "Exclude archived": "排除已归档",
                    "True": "是",
                    "False": "否",
                "Reaction count": "表情回应数",
                    "Has reaction count": "有表情回应数",
                // 草案
                    "Has draft": "包含草案",
                    "Exclude draft": "排除草案",
                "Review state": "评审状态",
                    "Has review state": "包含评审状态",
                    "Exclude review": "排除评审状态",
                    "No reviews": "无评审",
                "Code language": "代码语言",
                    "Has code language": "包含代码语言",
                    "Exclude language": "排除代码语言",
                "Commit SHA": "提交 SHA",
                    "Has commit sha": "包含提交 SHA",
                    "Exclude sha": "排除提交 SHA",
                "Base": "基础分支",
                    "Has base": "包含基础分支",
                    "Exclude base": "排除基础分支",
                "Head": "对比分支",
                    "Has head": "包含对比分支",
                    "Exclude head": "排除对比分支",
                // 状态 (Status)
                    "Has status": "包含状态检查",
                    "Exclude status": "排除状态检查",
                    "Pending": "待处理",
                    "Success": "成功",
                    "Failure": "失败",
                    "Queued": "排队中",
                    "Waiting": "等待中",
                    "Cancelled": "已取消",
                    "Skipped": "已跳过",
                "Team": "团队",
                    "Has team": "包含团队",
                    "Exclude team": "排除团队",
                "Team review requested": "已请求团队评审",
                    "Has team review requested": "包含已请求团队评审",
                    "Exclude team-review-requested": "排除已请求团队评审",
                // 排序
                    "Has sort": "包含排序",
                    "Exclude sort": "排除排序",
                    "Least reactions": "最少回应",
                    "Most thumbs up (👍) reactions": "👍 回应最多",
                    "Least thumbs up (👍) reactions": "👍 回应最少",
                    "Most thumbs down (👎) reactions": "👎 回应最多",
                    "Least thumbs down (👎) reactions": "👎 回应最少",
                    "Most laugh (😄) reactions": "😄 回应最多",
                    "Least laugh (😄) reactions": "😄 回应最少",
                    "Most confused (😕) reactions": "😕 回应最多",
                    "Least confused (😕) reactions": "😕 回应最少",
                    "Most tada (🎉) reactions": "🎉 回应最多",
                    "Least tada (🎉) reactions": "🎉 回应最少",
                    "Most heart (❤️) reactions": "❤️ 回应最多",
                    "Least heart (❤️) reactions": "❤️ 回应最少",
                    "Most eyes (👀) reactions": "👀 回应最多",
                    "Least eyes (👀) reactions": "👀 回应最少",
                "AND": "且",
                "OR": "或",
                "Exclude": "排除",
            // 过滤器问题
                "Empty value for": "空值",
                "Invalid value": "无效值",
                "for": "对于",

            "Order": "顺序",

        // 新建议题 选择议题模板  /<user-name>/<repo-name>/issues/new/choose
            "Get started": "开始",
            "Don’t see your issue here?": "在这里没有看到您的议题？",
            "Open a blank issue.": "打开一个空白议题。",
            "Edit templates": "编辑模板",
            "Report abuse": "举报滥用",

            "View organization templates": "查看组织模板", // 组织仓库

            // 警告
                "Discard changes?": "丢弃更改？",
                "Close and discard": "丢弃并关闭",

        // 新建空白议题  /<user-name>/<repo-name>/issues/new
            "Title": "标题",
            "Helpful resources": "帮助性资源",
            "Create more": "创建多个",
            "Write with Copilot": "请 Copilot 编写",
                "Navigate to Copilot Chat": "导航到 Copilot 聊天",
                    "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您确定要放弃它们吗？",
                    "Keep editing": "否", // 实际作用：返回编写页面
                    "Go to Copilot": "是", // 实际作用：前往 Copilot 页面

            "Choose a different template": "切换模板",

        // 从讨论创建议题  /<user-name>/<repo-name>/issues/new?created_from_discussion_number=<id>
            "Documentation has changed since you last contributed": "自您上次贡献以来，文档已更改",
            ". Take a look before submitting an issue:": "。在提交议题之前先看一下：",
            "Contributing guidelines": "贡献指南",
            "Last updated": "最后更新",

        // 某条具体的议题 /<user-name>/<repo-name>/issues/<id> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 快捷键
                "Convert issue to discussion…": "将议题转化为讨论…",

            "This issue was moved to a discussion.": "这个议题被转移到讨论中。",
            "You can continue the conversation there.": "您可以在那里继续讨论。",
            "Go to discussion →": "转到讨论→",

            "Edit": "编辑",
            "Issue body actions": "菜单", // 原文过于啰嗦，直接省略

            // 状态词 同 /<user-name>/<repo-name>/pull/<id>
            "changed the title": "修改了标题",
            "opened this issue": "打开了该议题",
            "· Fixed by": "· 修复了",
            "mentioned this issue": "提及了该议题",
            "mentioned this": "提及此",
            "opened this": "打开了这个",
            "linked a pull request": "关联了一个拉取请求",
            "linked a pull request that will close this issue": "关联了一个关闭此议题的拉取请求",
            //"that will": "这将会",
            //"close": "关闭",
            //"this issue": "这个议题",
            // "that will close this issue": "这将会关闭这个议题",
            // "Issue": "议题",
            "added a commit that closed this issue": "在提交时关闭了这个议题",
            "closed this in": "关闭于",
            "added the": "添加了",
            "added": "添加了",
            "and removed": "并移除了",
            "removed the": "移除了",
            "removed": "移除了",
            "label": "标签",
            "labels": "标签",
            "self-assigned this": "自己受理了该议题",
            // "edited": "编辑的",
            "added this to the": "添加到",
            "added this to": "添加到",
            "milestone": "里程碑",
            "moved this to": "移动到",
            "closed this": "关闭了",
            "as": "因",
            "as a": "因",
            "closed this as": "已关闭因",
                "not planned": "非计划中",
                "completed": "已完成",
            "reopened this": "重新打开了这个",
            "This was referenced": "这是引用",
            "deleted a comment from": "删除了评论，来自",
            "· May be fixed by": " · 可通过该方案修复",
            "pinned this issue": "置顶议题",
            "unpinned this issue": "取消置顶",
            "Repository owner": "仓库所有者",
            "Repository owner locked and limited conversation to collaborators": "仓库所有者锁定并限制与协作者对话",
            "Repository owner locked as": "仓库所有者锁定为",
            "Repository owner deleted a comment": "仓库所有者删除了评论",
            "Repository owner deleted a comment from": "仓库所有者删除了评论来自",
            "locked": "锁定",
            "locked as": "锁定为",
                "off-topic": "偏离主题",
                "too heated": "争论不休",
                "resolved": "已解决",
                "spam": "垃圾信息",
            "and limited conversation to collaborators": "并限制与协作者对话",
            "unlocked this conversation": "解锁了对话",
            "merged commit": "已合并提交",
            // "into": "到",
            "deleted the": "删除了",
            "locked and limited conversation to collaborators": "锁定并限制与协作者对话",
            "converted this issue into discussion": "此议题已转化为讨论",
            "converted this issue into a discussion": "此议题已转化为讨论",
            "removed their assignment": "取消了他们的任务",
            "assigned": "分配给了",
            "unassigned": "取消分配给",
            "and unassigned": "和取消了分配给",
            "marked this pull request as draft": "将此拉取请求标记为草案",
            "marked this pull request as ready for review": "将此拉取请求标记为可供审查",
            "dismissed a stale review via": "驳回了一个陈旧的审查，通过",
            "requested changes": "请求了更改",
            "added a commit that referenced this issue": "添加了一个引用此问题的提交",
            "referenced this issue": "提及这个议题",
            "closed this as completed": "已完成，关闭",
            "added a parent issue": "添加了一个父议题",
            "added a commit that references this issue": "添加了一个引用此议题的提交",
            "transferred this issue from": "将此议题转移，从",
            "as off topic": "为偏离主题",
            "as too heated": "为争论不休",
            "as spam": "为垃圾信息",
            "as resolved": "为已解决",
            "added a sub-issue": "添加子议题",
            "added sub-issues": "添加子议题",
            "removed a parent issue": "移除父议题",
            "removed a sub-issue": "移除子议题",
            "marked": "标记",
                "as a duplicate of this issue": "议题同此重复", // 示例 https://github.com/maboloshi/github-chinese/issues/405

            // 右侧栏 补充
            "Metadata": "元数据", // 小屏模式
                // "Development": "进展",
                    "Code with agent mode": "智能体模式编程",
                        "Select code repository": "选择仓库",
                        "Start a codespace with Copilot agent mode for this issue in another repository.": "为另一个仓库中的此议题启动使用 Copilot 智能体模式的代码空间。",
                    "No branches or pull requests": "没有分支或拉取请求",
                    "Shows branches and pull requests linked to this issue.": "显示与该议题相关的分支和拉取请求。",
                    "Create a branch": "创建分支",
                    "for this issue or link a pull request.": "为这个议题或关联一个拉取请求",
                    "When branches are created from issues, their pull requests are automatically linked.": "当从议题中创建分支时，它们的拉取请求会自动关联。",

                    // 关系
                        "Add parent": "添加父议题",
                        "Select a repository": "选择一个仓库",
                        "Change or remove parent": "更改或移除父议题",
                            "Selected": "当前",

                    // 参与者数大于2
                        "and others": "等",

                    // 下拉
                    "Link a pull request from this repository": "关联来自此仓库的拉取请求",

                    // "linked a pull request that will": "关联一个拉取请求, 将会",
                    // "close": "关闭",
                    // "this issue": "这个议题",

                    // 第一次打开议题
                    "It looks like this is your first time opening an issue in this project!": "看起来这是您第一次在此项目中打开议题！",
                    "Be sure to review the": "请务必查阅",

                    // 议题表单
                    "You're using an": "您正在使用",
                    "issue form": "议题表单",
                    ", a new type of issue template.": "，一种新型议题模板。",

                    // 创建分支 对话框
                        "Create a branch for this issue": "为该议题创建一个分支",
                        "Branch name": "分支名称",
                        "Repository destination": "仓库目的地",
                            "Search for a repository": "搜索仓库",
                        "Change branch source": "更改分支源",
                        "What's next?": "下一步是什么？",
                            "Checkout locally": "检出本地",
                            "Open branch with GitHub Desktop": "使用 GitHub Desktop 打开分支",
                        "Create branch": "创建分支",

                    // 在本地仓库检出对话框
                        "Checkout in your local repository": "在本地仓库检出",
                        "Run the following commands in your local clone.": "在您的本地克隆中运行以下指令。",

                    // 项目
                        "Select projects": "选择项目",

                    // 进展
                        "Link a branch or pull request": "关联分支或拉取请求",
                        "Select a repository to search for branches and pull requests or": "选择一个仓库来搜索分支和拉取请求或",
                        "create a branch": "创建一分支",
                        "Search pull requests": "搜索拉取请求",
                        "Search for repositories": "搜索仓库",
                        "Link a branch, pull request, or": "关联分支、拉取请求或",
                        "Search for branches or pull requests": "搜索分支或拉取请求",
                        "no pull request": "无拉取请求",

                "Duplicate issue": "复制议题",
                    // [/Duplicate current issue in ([^ ]+\/[^ ]+)/, "在 $1 中复制当前议题"],
                    "Changing the repository may remove Milestone, Labels, Type, and Assignees from the duplicate issue.": "更改仓库可能会从重复议题中移除里程碑、标签、类型和分配人员。",
                    "This issue is being duplicated across repositories. The following metadata might not be copied: Milestone, Labels.": "该议题正跨仓库中被复制创建。以下元数据可能不会被复制：里程碑、标签。",
                "Pin issue": "置顶议题",
                    "Up to 3 issues can be pinned and they will appear publicly at the top of the issues page": "最多可以置顶 3 个议题，它们将公开显示在议题页面的顶部",
                    "Up to 3 issues can be pinned to the top of the issues page": "最多可以在议题页面置顶 3 个议题",
                    "This will unpin this issue from the top of the issues page": "将从议题页面取消置顶该议题",
                    // 顶部提醒
                    "The issue has been pinned.": "该议题已置顶。",
                "Unpin issue": "取消置顶",
                    "Up to 3 issues can be pinned and they will appear at the top of the issues page": "最多可以置顶 3 个议题，它们将显示在议题页面的顶部",
                    "3/3 issues already pinned. Unpin an issue to pin this one.": "已有3/3个议题被置顶。请先取消置顶其中一个议题，才能置顶当前议题。",
                    // 顶部提醒
                    "The issue has been unpinned.": "该议题已取消置顶。",
                "Transfer issue": "转移议题",
                    // 转移议题 对话框
                        "Transfer this issue": "转移议题",
                            "This does not scrub any issue content. Content such as text references to other issues, pull requests, projects and teams will still appear in the description or comments. Labels will be transferred.": "该操作不会清除任何议题内容。对其它议题、拉取请求、项目和团队的文本引用仍会保留在描述或评论中。标签将会被转移。",
                            "Repository projects assigned to this issue will not transfer to the new location": "分配给此议题的仓库项目不会转移到新位置",
                        "Choose a repository": "选择仓库",
                        "Find a repository": "搜索仓库",
                        "Warning!": "警告！",
                            "Transferring an issue does not scrub any issue content. Content such as text references to other issues, pull requests, projects, teams will remain in this issue's descriptions and comments.": "转移议题不会清除任何议题内容。诸如对其他议题、拉取请求、项目、团队的文本引用等内容将保留在此议题的描述和评论中。",
                            "Assignees, labels and milestones will be transferred if they are present in the target repository.": "如果目标仓库中存在受让人、标签和里程碑，它们将被转移。",
                "Convert to discussion": "转为讨论",
                    // 转换议题为讨论 对话框
                    "Convert issue to a discussion": "转换议题为讨论",
                        "Are you sure you want to convert this issue to a discussion?": "您确定要将议题转换为讨论吗？",
                        "What happens when an issue is converted into a discussion:": "将议题转化为讨论时，会发生什么：",
                        "Issue will be closed and locked": "议题将被关闭并锁定",
                        "Title, description, and author will be the same as the issue": "标题、描述和作者将与议题相同",
                        "All comments and reactions will be the same as the issue": "所有评论和反应将与议题相同",
                        "Category for new discussion": "新讨论的类别",
                            "Announcements": "公告",
                            "General": "通常",
                            "Ideas": "想法",
                            "Polls": "投票",
                            "Q&A": "问与答",
                            "Show and tell": "展示与讲述",
                        "I understand, convert this issue": "我明白了，依然转化该议题",
                "Delete issue": "删除议题",
                    "Delete issue?": "删除议题？",
                    "Are you sure you want to delete this issue?": "您确定要删除此议题吗？",
                    "This cannot be undone": "这不能被撤消",
                    "Only adminstrators can delete issues": "只有管理员可以删除议题",
                    "Deletion will remove the issue from search and previous references will point to a placeholder": "删除将会从搜索中删除议题，以前的引用将指向一个占位符",
                    "Delete this issue": "删除议题",
                    "Deleting issue…": "议题删除中…",
                    // 顶部提醒
                    "The issue was successfully deleted.": "该议题已成功删除。",

                "Participants": "参与者",
                    "No participants": "尚无参与者",

            // 新版议题页面
            "remaining": "剩余",
            "items": "项",
            "Load more": "载入更多",

            "This conversation has been locked and limited to collaborators.": "此对话已锁定并限制与协作者对话。",
            "This issue has been deleted.": "该议题已被删除。",
            "deleted this from": "删除了这个，从",

            "Reference in a new issue": "在新议题中提及",

            // 评论框
            "edited by": "编辑者",
            "Hidden as": "隐藏因",
                "abuse": "滥用",
                "show comment": "显示评论",
                "hide comment": "隐藏评论",
            "Edits": "编辑",
                "Most recent": "最近",
                "Viewing edit": "查看编辑",
                "Delete revision": "删除修订",
            "Reopen Issue": "重新打开议题",
                "You do not have permissions to reopen this issue": "您没有权限重新打开此议题",
            // 评论删除对话框
                "Delete comment": "删除评论",
                "Are you sure you'd like to delete this comment?": "您确定要删除这条评论吗？",
            // 关闭议题
                "You do not have permissions to close this issue": "您没有权限关闭此议题",
            "Comment can not be empty": "评论不能为空",
            "Add files": "添加文件", // 小屏模式

        // 议题标签管理 /<user-name>/<repo-name>/issues/labels
        // 仓库 --> 标签页面 /<user-name>/<repo-name>/labels
            "Labels": "标签",
            "Milestones": "里程碑",
            "Search all labels": "搜索所有标签",

            "labels": "标签",

            "New label": "新建标签",
                "Label preview": "标签预览",
                "Label name": "标签名",
                "Description": "描述",
                "Description (optional)": "描述（可选）",
                "Color": "颜色",
                    "Get a new color": "获得新颜色",
                    "Choose from default colors:": "从默认颜色中选择：",
                "Create label": "创建标签",

            "Sort": "排序",
                "Alphabetically": "按字母顺序",
                "Reverse alphabetically": "按字母倒序",
                "Most issues": "最多的议题",
                "Fewest issues": "最少的议题",

            // 标签
                "bug": "BUG",
                    "Something isn't working": "有些东西不工作",
                "dependencies": "依赖性",
                    "Pull requests that update a dependency file": "更新一个依赖文件的拉取请求",
                "documentation": "文档",
                    "Improvements or additions to documentation": "文档的改进或补充",
                "duplicate": "重复",
                    "This issue or pull request already exists": "这个议题或拉取请求已经存在",
                "enhancement": "增强",
                    "New feature or request": "新功能或请求",
                "good first issue": "好的首发议题",
                    "Good for newcomers": "适合新人",
                "help wanted": "需要帮助",
                    "Extra attention is needed": "需要特别关注",
                "invalid": "无效",
                    "This doesn't seem right": "这似乎不对",
                "question": "问题",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不会修复",
                    "This will not be worked on": "这将不会被处理",

            // [/open issues? and pull requests?/, "个打开的议题和拉取请求"], // 标签页面
            // [/open issues? or pull requests?/, "个打开的议题或拉取请求"], // 标签页面

            "Convert to discussions": "转为讨论",
                // 转换议题为讨论 对话框
                "Convert issue to discussion": "转换议题为讨论",
                "Convert issues to discussions": "转换议题为讨论",
                    // [/Are you sure you want to convert (\d+) issues? with the following label to (?:a |)discussions?\?/, "您确定要将带有以下标签的 $1 条议题转换为讨论吗？"],
                    // "What happens when an issue is converted into a discussion:": "将议题转化为讨论时，会发生什么：",
                    "Issue will be locked": "议题将被锁定",
                    // "Title, description, and author will be the same as the issue": "标题、描述和作者将与议题相同",
                    "Existing links will redirect to the new discussion": "现有链接将重定向至新讨论",
                    // "All comments and reactions will be the same as the issue": "所有评论和反应将与议题相同",
                    "Discussions do not have tasklists": "讨论没有任务列表",
                    "Discussions do not have assignees": "讨论没有受理人",
                    "Discussions cannot be added to projects": "讨论无法添加到项目",
                    "Discussions do not have milestones": "讨论没有里程碑",
                    "You must choose a category for the discussion to belong to. You will be able to change this after the conversion is complete.": "您必须为讨论选择一个所属类别。转换完成后，您可以更改类别。",
                    "Choose a category": "选择类别",
                        "Announcements": "公告",
                        "General": "通常",
                        "Ideas": "想法",
                        "Polls": "投票",
                        "Q&A": "问与答",
                        "Show and tell": "展示与讲述",
                    "I understand, convert issue to discussion": "我明白了，依然将议题转换为讨论",
                    "I understand, convert issues to discussions": "我明白了，依然将议题转换为讨论",
                    "Future issues with this label will not be automatically converted into discussions.": "今后带有此标签的议题不会自动转换为讨论。",

        // 添加/编辑议题模板 /<user-name>/<repo-name>/issues/templates/edit
            "Propose changes": "提出更改",
            "Add template:": "添加模板：",
            "select": "选择",
            "Bug report": "错误报告",
                "Standard bug report template": "标准错误报告模板",
                "Create a report to help us improve": "创建报告以帮助我们改进",
            "Feature request": "功能要求",
                "Standard feature request template": "标准功能请求模板",
                "Suggest an idea for this project": "为这个项目提出想法",
            "Custom template": "自定义模板",
                "Blank template for other issue types": "其他议题类型的空白模板",
                "Custom issue template": "自定义议题模板",
                "Describe this issue template's purpose here.": "在此处描述此议题模板的用途。",

            "Preview and edit": "预览和编辑",
            "Close preview": "关闭预览",

            "Template name": "模板名称",
            "This file lives in": "该文件位于",
            "Template content": "模板内容",
                "Styling with Markdown is supported": "支持 Markdown 格式",
            "Optional additional items": "可选附加项目",
            "Issue default title": "议题默认标题",
            "This will be suggested as the issue title": "建议作为议题标题",
                "Add a placeholder for issue title, ex. [BUG]": "设置默认议题标题，例如：[BUG]",

            "Commit changes": "提交更改",
                "Commit message": "提交信息",
                "Extended commit message": "扩展描述",
                    "Add an optional extended description": "添加描述... (可选)",
                "Commit directly to the": "提交到",
                "branch.": "分支。",

                "Some rules will be bypassed by committing directly": "直接提交可以绕过一些规则",
                "Bypass rules and commit changes": "绕过规则并提交更改",

                "Create a": "创建",
                "new branch": "新分支",
                "for this commit and start a pull request.": "为这个提交，并且发起一个拉取请求。",

        // Copilot 浮窗 独有词条
            "Ask about the issue:": "讨论此议题：",

        // 底部提示栏（未登录
        "to join this conversation on GitHub.": "加入 GitHub 上的这个讨论。",
            "Already have an account?": "已经有账户？",

    },
    "regexp": [ // 正则翻译
        [/Want to contribute to ([^ ]+)\?/, "想为 $1 做贡献？"],
        [/Awaiting requested review from ([^ ]+)/, "正在等待 $1 审查请求"],
        [/([\d,]+) Open/, "$1 打开"],
        [/([\d,]+) Closed/, "$1 已关闭"],
        [/(#\d+) opened/, "$1 打开于"],
        [/(#\d+) by/, "$1 打开者"],
        [/(\d+) linked pull requests?/, "链接 $1 个拉取请求"],
        [/([\d,]+) linked issues?/, "$1 个关联议题"],
        [/(\d+) tasks? done/, "$1 个任务完成"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 个任务"],
        [/(\d+) tasks?/, "$1 个任务"],
        [/First time contributing to ([^ ]+)\?/, "首次为 $1 做贡献？"],

        // 具体某条议题 /<user-name>/<repo-name>/issues/<id>
        [/· ([\d,]+) comments?/, "• $1 条评论"],
        [/([\d,]+) participants?/, "$1 位参与者"],
        [/(\d+) similar comments?/, "$1 条类似评论"],
        [/(\d+) hidden items?/, "$1 条隐藏项目"],
        [/added a commit to ([^ ]+) that referenced this issue/, "为 $1 添加了引用这个议题的提交"],
        [/Only people who can see ([^ ]+) will see this reference./, "只有能看到 $1 的人才能看到这个参考。"],
        [/Sponsor ([^ ]+)?/, "赞助 $1"], // 赞助按钮 对话框 标题
        [/Notify someone on an issue with a mention, like: @([^ ]+)./, "在议题中通过 @ 提及通知某人，例如：@$1。"], // 专业提示
        [/Edited (\d+) times?/, "已编辑 $1 次"],
        [/edited by ([^ ]+)/, "由 $1 编辑"],
        [/This issue will close when (#?\d+) is merged/, "此议题将在 $1 合并时关闭"],
        [/Opened this issue \(their first in ([^ ]+)\)/, "打开了这个议题（首次在 $1 发表）"],
        [/Duplicate current issue in ([^ ]+\/[^ ]+)/, "在 $1 中复制当前议题"],
        [/added (\d+) commits? that reference this issue/, "添加 $1 个引用此议题的提交"],
        [/This issue will close once commit ([a-f0-9]{7}) is merged into the \'([^ ]+)\' branch./, "此议题将在提交 $1 合并到 '$2' 分支后关闭。"],

        // 标签页面
        [/open issues? and pull requests?/, "个打开的议题和拉取请求"],
        [/open issues? or pull requests?/, "个打开的议题或拉取请求"],
        [/Are you sure you want to convert (\d+) issues? with the following label to (?:a |)discussions?\?/, "您确定要将带有以下标签的 $1 条议题转换为讨论吗？"],
        [/(\d+) labels/, "$1 个标签"],

        // 子议题
        [/Create new sub-issue in ([^ ]+)/, "在 $1 中新建子议题"],
        [/(\d+) of (\d+)/, "$1 / $2"],
        [/Filter contains (\d+) issues?\:/, "筛选包含 $1 个议题："],

        // 新版议题
        [/(.+) will be between (.+) and (.+)./, "“$1” 将在 “$2” 和 “$3” 之间。"],
        [/(.+) will not be moved./, "“$1” 将不会被移动。"],
        [/(.+) will be first item in the list./, "“$1” 将移至最前。"],
        [/(.+) will be last item in the list./, "“$1” 将移至最后。"],
        [/of (\d+) selected/, "/ $1 选中"],
        [/(\d+\%) completed/, "$1 完成"],
        [/Issue (#\d+) created/, "议题 $1 已创建"],
        [/Lines (\d+) to (\d+) in/, "第 $1 - $2 行，"],
        [/mentioned this in (\d+) issues?/, "在 $1 个议题中提及"],
        [/Create new issue in (.+)/, "在 $1 新建议题"],
        [/Close as duplicate of (\#\d+)/, "因同 $1 重复关闭"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["regexp"],
    ],
    "title": {
        "static": {
            "New Issue": "创建议题",
        },
        "regexp": [
            [/Issues?/, "议题"],
        ],
    },
};
I18N["zh-CN"]["repository/labels"] = I18N["zh-CN"]["repository/issues"];

I18N["zh-CN"]["repository/pulls"] = { // 仓库 - 拉取请求页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["static"],

        // 仓库 --> 拉取请求 标签卡 /<user-name>/<repo-name>/pulls
            // 欢迎信息
            "Welcome to pull requests!": "欢迎使用拉取请求！",
            "Pull requests help you collaborate on code with other people. As pull requests are created, they’ll appear here in a searchable and filterable list. To get started, you should": "拉取请求可帮助您与其他人协作处理代码。创建拉取请求后，它们将出现在可搜索和可筛选的列表中。要开始，您应该",
            "create a pull request": "创建拉取请求",

            // [/First time contributing to ([^ ]+)?/, "首次为 $1 做贡献？"], // /pulls
            "If you know how to fix an": "如果您知道如何修复一个",
            "issue": "议题",
            ", consider opening a pull request for it.": "，可考虑为它打开一个拉取请求。",
            "You can read this repository’s": "您可以阅读该仓库的",
            "to learn how to open a good pull request.": "，去学习如何打开一个好的拉取请求。",
            "If you would like to submit code to this repository, consider opening a pull request.": "如果您想向这个仓库提交代码，请考虑打开一个拉取请求。",
            "If you would like to submit code to this repository, consider opening a pull request. You can read this repository’s": "如果您想向这个仓库提交代码，请考虑打开一个拉取请求。您可以阅读该仓库的",

            "Label issues and pull requests for new contributors": "标记新贡献者的议题和拉取请求",
            "Now, GitHub will help potential first-time contributors": "现在，GitHub 将帮助潜在的首次贡献者",
            "discover issues": "探索议题",
            "labeled with": "标记为",

            "Dismiss": "忽略",
                // 忽略 下拉
                "Dismiss for this repository only": "仅对该仓库不在提示",
                "Dismiss for all repositories": "对所有仓库均不在提示",

            "New pull request": "发起拉取请求",

            "Reviews": "审查",
                // 筛选工作条
                "Filter by reviews": "按审查筛选",
                "No reviews": "未经审查",
                // "Review required": "需要审查",
                "Approved review": "已批准的审查",
                "Changes requested": "已请求更改",
                "Reviewed by you": "由您审查",
                "Not reviewed by you": "您未审查",
                "Awaiting review from you": "等待您审查",
                "Awaiting review from you or your team": "等待您或您的团队的审查",
                "Awaiting review from you specifically": "特别等待您审查",

                // 筛选结果
                "There aren’t any open pull requests.": "暂无拉取请求。",

                "You commented on and opened this pull request": "您打开了此拉取请求并发表了评论",
                "You were mentioned on and commented on this pull request": "您被提及并对此拉取请求发表了评论",
                "You commented on this pull request": "您对此拉取请求发表了评论",
                "You opened this pull request": "您打开了此拉取请求",

                "Suggested change": "建议更改",

    },
    "regexp": [
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["regexp"],

        [/(\d+) reviews? requesting changes?/, "$1 个请求审查更改"],
        [/(\d+) linked issues?/, "链接 $1 个议题"],
        [/([\d,]+) Open/, "$1 打开"],
        [/([\d,]+) Closed/, "$1 已关闭"],
        [/(#\d+) opened/, "$1 打开于"],
        [/(#\d+) by/, "$1 打开者"],
        [/(\d+) tasks? done/, "$1 个任务完成"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 个任务"],
        [/(\d+) tasks?/, "$1 个任务"],
        [/(\d+) Total/, "$1 总计"],
        [/(\d+) review requesting changes/, "$1 个要求修改的审查"],
        [/First time contributing to ([^ ]+)\?/, "首次为 $1 做贡献？"],
        [/Suggested change/, "建议更改"],
        [/Ears burning\? Get\@([^ ]+) mentions with/, "耳朵痒吗？使用 @$1 查看提及："], // 专业提示
        [/Notify someone on an issue with a mention, like: \@([^ ]+)/, "在议题中通过 @ 提及通知某人，例如：@$1"],
    ],
    "title": {
        "regexp": [
            [/Pull requests/, "拉取请求"],
        ],
    },
};

I18N["zh-CN"]["repository/pull"] = { // 仓库 - 某个拉取请求页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["static"],

        // 某条具体的拉取请求 /<user-name>/<repo-name>/pull/<id> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 顶部提醒
                "The head ref may contain hidden characters:": "头部引用可能包含隐藏字符：",
                "Your review was submitted on a merged pull request.": "您的审查已提交，一个合并的拉取请求。",
                "Marked pull request as ready for review.": "标记拉取请求为可审核。",
                "Your review was submitted successfully.": "您的审查已成功提交。",
                "requested your review on this pull request.": "请求审核此拉取请求。",
                // Dependabot 打开的拉取请求
                    "Merging this pull request will resolve": "合并此拉取请求将解决", // 后面警报数走正则
                    //"on rollup including a": "，包括 1 个",
                    "severity alert.": "风险警报。",

            // 快捷键
                "Edit pull request title": "编辑拉取请求标题",
                "Edit pull request body": "编辑拉取请求主体",

            // 编辑 -> 选择基础库
            "Choose a base branch": "选择基础分支",
            "base:": "基础：",
                // 更改基础分支对话框
                "Find a branch": "搜索分支",
                "Are you sure you want to change the base?": "您确定要更改基础分支吗？",
                "Some commits from the old base branch may be removed from the timeline, and old review comments may become outdated.": "旧的基础分支的一些提交可能会从时间线上删除，而旧的审查意见可能会变得过时。",
                "Change base": "更改基础分支",

            // 代码 下拉菜单
                "Code 55% faster with AI pair programming.": "与 AI 一起编程，写代码速度提高55%。",
                    "Start my free trial": "开始我的免费试用",
                    "Don't show again": "不再显示",

                "Local": "本地",
                    "Checkout with GitHub CLI": "使用 GitHub CLI 检出",
                    "Work fast with our official CLI.": "使用我们的官方 CLI 快速工作。",
                    "Checkout with GitHub Desktop": "使用 GitHub Desktop 检出",
                        "Launching GitHub Desktop": "GitHub Desktop 启动中",
                        "If nothing happens,": "如果没有响应",
                            "download GitHub Desktop": "下载 GitHub Desktop",
                            "and try again.": "并重试",

                // 代码空间
                    // 维护提示
                        "Codespaces is undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "代码空间正在维护。在此期间，用户可能会遇到连接问题。更多详情请访问",
                        "Codespaces will be undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "代码空间将进行维护。在此期间，用户可能会遇到连接问题。更多详情请访问",
                        "this announcement": "此公告",
                    "This pull request must be reopened to create new codespaces on it.": "必须重新打开此拉取请求才能在其上创建新的代码空间。",
                    "Your workspaces in the cloud": "您在云端的工作空间",
                    //[/Create a codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
                    "Codespace repository configuration": "代码空间仓库配置",
                        "New with options...": "新建（选项）…",
                        "Configure dev container": "配置开发容器",
                        "Set up prebuilds": "设置预构建",
                        "Manage codespaces": "管理代码空间",
                        "Share a deep link": "分享深度链接",
                            "Share codespace configuration": "共享代码空间配置",
                            "Choose which settings from this configuration to include when sharing": "选择共享时要包含此配置中的哪些设置",
                            "Quick start": "快速开始",
                            "Automatically create or reuse the most recent matching codespace.": "自动创建或使用最新匹配的代码空间。",
                            "Read more about creating a link.": "阅读有关创建链接的更多信息。",
                            "Snippets": "片段",
                            "Use the following snippets to embed an “Open in Codespaces” button for this configuration in your own page or README.": "使用以下代码片段在您自己的页面或 README 中嵌入此配置的 “在 Codespaces 中打开” 按钮。",
                        "What are codespaces?": "什么是代码空间？",
                    "No codespaces": "尚无代码空间",
                    "You don't have any codespaces with this repository checked out": "您没有检出此仓库的任何代码空间",
                    //[/Create codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
                    "Learn more about codespaces...": "了解更多关于代码空间的信息…",

                    "On current branch": "在当前分支",
                        "No codespaces on current branch": "当前分支上没有代码空间",
                    "On other branches": "在其他分支",
                    "miniature adventure": "迷你探险",
                    "Open miniature adventure in web": "在网络中打开迷你探险",
                    "Active": "激活",
                        "Open in ...": "打开…",
                            "Open in browser": "在浏览器中打开",
                            "Open in Visual Studio Code": "在 Visual Studio Code 中打开",
                            "Open in JetBrains Gateway": "在 JetBrains Gateway 中打开",
                            "Open in JupyterLab": "在 JupyterLab 中打开",
                        "Rename": "重命名",
                            "Change codespace display name to...": "将代码空间显示名称更改为…",
                        "Export changes to a branch": "将更改导出到分支",
                            "This will create a new branch with any unpushed changes": "这将创建一个包含任何未推送更改的新分支",
                            "Create branch": "创建分支",
                        "Change machine type": "更改机器类型",
                            "Change codespace machine type": "更改代码空间机器类型",
                            "Machine type": "机器类型",
                                "2-core": "双核",
                                "4-core": "四核",
                            "Need even more power?": "需要更多的力量？",
                            "Contact our team": "联系我们团队",
                            "to enable 32-core or GPU machines.": "启用 32 核或 GPU 机器。",
                            "Update codespace": "升级代码空间",
                        "Stop codespace": "停止代码空间",
                    "Codespace configuration": "代码空间设置",
                    "No changes": "未更改",

                    "Codespace usage for this repository is paid for by": "该仓库的代码空间使用费由以下人员支付",

                    "You seem to have a billing issue. Please adjust your billing settings to continue using codespaces.": "您似乎遇到了账单问题。请调整您的账单设置以继续使用代码空间。",

                    // 被拉黑
                        "Repository access limited": "仓库访问受限",
                            "You do not have access to push to this repository and its owner has disabled forking.": "您无权推送到此仓库，其所有者已禁用了复刻。",

                    // [/Codespace \"(.+)\" stopped./, "代码空间 “$1” 已停止。"],
                    // [/Codespace \"(.+)\" deleted./, "代码空间 “$1” 已删除。"],
                    // [/Are you sure you want to delete (.+)\?/, "您确定要删除 $1 吗？"],

                // Copilot
                    "Describe a change you'd like to make to this pull request, such as adding tests or documentation...": "描述您想对此拉取请求进行的更改，例如添加测试或文档…",
                    "Start task": "开始任务",
                    "You can ask Copilot to make changes to this pull request by mentioning @copilot in a comment.": "您可以在评论中提及 @copilot，让 Copilot 对此拉取请求进行更改。",
                    "Copilot generated this review using guidance from": "Copilot 生成此次审查，使用",
                        "repository custom instructions": "仓库自定义指令",

            // 自动修复漏洞 提示
                "This automated pull request fixes a": "这个自动拉取请求将修复了一个",
                "security vulnerability": "安全漏洞",
                "Only users with access to Dependabot alerts can see this message.": "只有有权访问 Dependabot 警报的用户才能看到此消息。",
                "Learn more about Dependabot security updates": "了解更多关于 Dependabot 安全更新的信息",
                "opt out": "选择退出",
            // 顶部提醒
                "Opted out of Dependabot security updates.": "选择退出 Dependabot 安全更新。",

            // Dependabot 警报 拉取请求 提示
                "Merging this pull request will resolve a": "合并此拉取请求将解决",
                "high": "高",
                "severity": "严重性",
                "Dependabot alert": "Dependabot 警报",
                "on": "：",
                // 首次弹窗
                    "Your first automated security update": "您的第一个自动安全更新",
                        "Dependabot security updates keep your projects secure and up-to-date.": "Dependabot 安全更新使您的项目安全且最新。",
                        "You can opt out at any time in": "您可以在任何时候选择退出在",
                        "this repository’s settings": "仓库设置",
                        "Got it!": "我知道了",

                // 合并后顶部提醒
                    // [/This pull request resolved a Dependabot alert on ([^ ]+)./, "该请求解决了 $1 的 Dependabot 警报问题。"],

            // 状态词
            // [/merged (\d+) commits? into/, "将 4 个提交合并到"],
            "into": "到",
            // "merged": "已合并",
            "wants to merge": "希望合并",
            "commit into": "个提交到",
            "commits into": "个提交到",
            "from": "来自",
            "closed this": "关闭了这个",
            "reopened this": "重新打开了这个",
            "added a commit that referenced this pull request": "添加了引用此拉取请求的提交",
            "removed the request for review from": "取消请求审查",
            "pushed a commit that referenced this pull request": "推送了一个引用此拉取请求的提交",
            "suggested changes": "建议更改",
            "deleted the branch": "删除了分支",
            "deleted a comment from": "删除了评论从",
            // Copilot 专属状态词
            "started work": "开工",
            "on behalf of": "代表",
                "View session": "查看",
            "finished work on behalf of": "完工，代表",
            "stopped work on behalf of": "停工，代表",
                "due to an error": "因为错误",

            // 标签栏
            "Conversation": "讨论",
            // 提交
                "No new commits": "无新提交", // 下方句子走正则
                "was force-pushed and no longer has any new commits. Pushing new commits will allow the pull request to be re-opened.": "分支已强制推送，并且不再包含任何新的提交。推送新的提交将允许重新打开拉取请求。",
            "Checks": "检查",
                "Search logs": "搜索日志",
                "Pushing new commits will allow the pull request to be re-opened.": "推送新的提交将允许重新打开拉取请求。", // 上面的句子走正则
            "Files changed": "更改的文件",
                "No changes to show.": "无更改显示。", // 删除复刻仓库的提交时出现
                "This commit has no content.": "该提交无内容。", // 同上
              "authored": "撰写于",

            // 右侧栏 补充
                // 审查者
                "Reviewers whose approvals may not affect merge requirements": "审查者的批准可能不影响合并要求。",

                "Allow edits by maintainers": "允许维护者进行编辑",
                    "Allowing edits by maintainers": "允许维护者进行编辑",
                    "If checked, users with write access to": "若勾选此项，拥有对",
                    "can add new commits to": "具有写入权限的用户可以在您的",
                    "branch.": "分支上添加新的提交。",
                    "You can always change this setting later.": "您可以随时修改此设置。",
                    "Note: By granting write access, maintainers could potentially edit your repository's workflows to reveal values of secrets and gain access to other branches.": "注意：通过授予写入权限，维护者可能会编辑您仓库的工作流程以揭示机密值，并获取对其他分支的访问权限。",
                    "Got it": "知道了",
                    "If checked,": "如果选中，",
                    // [/users with write access to ([^ ]+) can add new commits/, "对 $1 具有写权限的用户可以添加新的提交"], // 具体拉取请求
                    "to your": "到您的",
                    "branch. You can always change this setting later.": "分支。您以后可以随时更改此设置。",
                "Allow edits and access to secrets by maintainers": "允许维护者编辑和访问机密",
                    "Maintainers could potentially edit this repository's workflows to reveal values of secrets and gain access to other branches.": "维护者有可能编辑这个仓库的工作流程来获取机密值，并获得对其他分支的访问。",

                "Maintainers are allowed to edit this pull request.": "允许维护者编辑此拉取请求。",

                // 进展
                    "In progress": "进行中",
                    "started": "开始于",
                    "Copilot is done": "Copilot 已完成",
                    "Copilot has failed": "Copilot 已失败",
                    "completed after": "总耗时", // 示例：总耗时 11分45秒
                    "failed after": "失败于",

            // 讨论标签卡 主页
            "Refresh": "刷新",

            "marked this pull request as draft": "将此拉取请求标记为草案",
            "First-time contributor": "首次贡献者",
            // [/This user is a first-time contributor to the ([^ ]+) repository./, "该用户是第一次为 $1 仓库做贡献。"]
            "View changes": "查看更改",
            "Outdated": "陈旧的",
            "Resolve conversation": "转为已解决对话",
                "Resolving conversation…": "正在转为已解决对话……",
            "Unresolve conversation": "转为未解决对话",
                "Unresolving conversation…": "正在转为未解决对话……",
                "marked this conversation as resolved.": "已将此对话标记为已解决。",
            "Changes requested": "更改请求",
            "Change requested": "更改请求",
            "Show resolved": "显示已解决",
            "Hide resolved": "隐藏已解决",
            "Reviews": "审查",
            "Show all reviewers": "显示所有审查者",
            "Hide all reviewers": "隐藏所有审查者",
            "New changes since you last viewed": "自您上次查看以来的新变化",
            "mentioned this pull request": "提及这个拉取请求",
            "linked an issue": "链接议题",
            "that may be": "将在该拉取请求合并时",
            "closed": "关闭",  // 浮动小字走正则
            "by this pull request": " ",
            "dismissed": "驳回",
            "\’s": " 的",
            "stale review": "陈旧审查",
            "via": "通过",
            "force-pushed": "强制推送",
            "enabled auto-merge (squash)": "启用自动合并（压缩）",
            "the": " ",
            "branch from": "分支从",
            "and others": "和其他成员",
            "previously": "预先",
            "approved these changes": "批准这些更改",
            "previously approved these changes": "预先批准这些更改",
                "See review": "查看审查",
                "Dismiss review": "驳回审查",
            "started a review": "开始审查",
                "View reviewed changes": "查看已审核的更改",
            "self-requested a review": "自我要求审查",
            "self-assigned this": "已自我审查",
            "unassign me": "取消自我分配",
            "marked this pull request as ready for review": "已将此拉取请求标记为可审核",
            "merged commit": "合并提交",
            "left a comment": "发表评论",
            "Add more commits by pushing to the": "添加更多提交，通过推送到",
            "branch on": "分支在",
            "requested review from": "请求审查",
                "a team": "团队",
                "as a": "作为",
                "code owner": "代码所有者",
            "started reviewing": "开始审查",
            "finished reviewing on behalf of": "完成审查，代表",
            "This pull request was": "此拉取请求已",
            "Compare": "比较",
            "deleted the": "删除",
            "branch": "分支",
            "added": "添加",
            "requested changes": "要求更改",
            "changed the title": "修改了标题",
            "changed the base branch from": "更改基础分支从",
            "added the": "添加",
            "label": "标签",
            "closed this": "已关闭",
            "reopened this": "已重新打开",
            "closed this by deleting the head repository": "已关闭因仓库已删除",
            "Requested changes": "请求更改",
            "restored the": "恢复",
            "unlocked this conversation": "解锁此对话",
            "added this to the": "添加到",
            "milestone": "里程碑",
            "review requested due to automatic review settings": "因设置自动审查",

            //
            "This branch has not been deployed": "该分支尚未部署",
            "No deployments": "未部署",

            // 拉取请求状态
            "Review requested": "请求审查",
            "Review has been requested on this pull request. It is not required to merge.": "此拉取请求已请求进行审查。这不是合并的必要条件。",
            "Learn more about requesting a pull request review.": "了解更多关于申请拉取请求审核的信息。",
            // [/(\d+) pending reviewers?/, "$1 名待审者"],
            "was requested for review": "被请求审查",

            "Changes reviewed": "更改已审查",
                "No applicable reviews submitted by reviewers with write access.": "没有具有写入权限的审查者提交适用的审查意见。",

            // 已请求更改
                // [/(\d+) reviews? requesting changes by reviewers with write access./, "$1 条评论请求更改由具有写入权限的审查者进行更改。"], // 拉取请求

            "All conversations are resolved": "所有对话均已解决",
                // [/(\d+) resolved conversations?/, "2 条对话已解决"], // 拉取请求

            "No unresolved conversations": "没有未解决的对话",
                "There aren't yet any conversations on this pull request.": "此拉取请求尚无任何对话。",

            "This pull request is still a work in progress": "此拉取请求仍在进行中",
                "Ready for review": "准备审核",
                "Draft pull requests cannot be merged.": "拉取请求草案不能合并。",
            "This pull request can be automatically merged by project collaborators": "此拉取请求可以由项目协作者自动合并",
                "Only those with": "只有对此仓库具有",
                "write access": "写入访问权限",
                "to this repository can merge pull requests.": "的才可合并拉取请求。",
                "to this repository can mark a draft pull request as ready for review.": "的才可将拉取请求草案标记为可供审查。",

            // "Review required": "需要审查", // 拉取请求 页面状态词
                "Add your review": "添加您的评论",
                // [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有写入权限的审查者至少需要 $1 次批准审查。"],
            "Code owner review required": "需要代码所有者审核",
                "was requested for review as a code owner": "要求以代码所有者身份进行审查",
            "Conversation resolution required": "需要解决对话",
                "A conversation must be resolved before this pull request can be merged.": "在合并此拉取请求前，必须先解决对话。",
            "Learn more about pull request reviews.": "了解更多关于拉取请求审核的信息。",
            "Changes approved": "变更已获批准",
            "Approval not required": "不需要批准",
            "This pull request may be merged without approvals.": "可以在没有批准的情况下合并此拉取请求。",
            // [/(\d+) approving reviews? by reviewers? with write access./, "$1 个批准的审查由具有写入权限的审查者进行审查。"],
            // [/(\d+) approvals?/, "$1 项批准"],
            "Some checks haven’t completed yet": "有些检查还没有完成",
            // [/1 in progress check/, "$1个正在进行的检查"],
            "Some checks were not successful": "有些检查不成功",
            // [/1 skipped, 4 successful, and 2 failing checks/, "$1 个跳过, $2 个成功, $3 失败"],
            // [/1 skipped, 4 successful, and 2 expected checks/, "$1 个跳过, $2 个成功, $3 个预先检查"],
            "All checks have passed": "所有检查均已通过",
            "All checks have failed": "所有检查均失败",
            // [/5 successful checks/, ""],
            // [/6 checks passed/, ""],
                "Show all checks": "显示所有检查",
                "Hide all checks": "隐藏所有检查",
                "Details": "细节",
                "Required": "必须",
                "Checks settings": "检查设置",
                    "Group by status": "按状态分组",
                    "No grouping": "不分组",
            "Unresolved conversations": "未解决的讨论",
                // [/(\d+) conversations? must be resolved before merging./, "合并之前必须解决 $1 个对话。"],
            "No conflicts with base branch": "与基础分支没有冲突",
                "Changes can be cleanly merged.": "更改可以被干净地合并。",

                "Update branch options": "更新分支选项",
            "Merging is blocked": "合并被阻止",
                "Commits must have verified signatures.": "提交必须验证签名。",
                "The base branch requires all conversations on code to be resolved.": "基础分支要求解决所有关于代码的对话。",
                "The base branch requires all commits to be signed.": "基础分支要求所有提交都经过签名。",
                "Learn more about signing commits.": "了解更多关于签名提交的信息。",
                "View rules": "查看规则",
                // 无权提交
                "You're not authorized to push to this branch. Visit": "您没有权限推送到此分支。请访问",
                    "for more information.": "获取更多信息。",
                // 新版合并界面
                "Merge is not an allowed merge method in this repository.": "合并不是此仓库允许的合并方法。",
                "Pull request cannot be merged because it has a merge conflict.": "由于存在合并冲突，无法合并拉取请求。",
                "User does not have push access to the repository.": "用户无权推送到此仓库。",
                "You're not authorized to push to this branch. Visit https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-protected-branches/about-protected-branches for more information.": "您无权推送到该分支。请访问 https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-protected-branches/about-protected-branches 了解更多信息。",

                // 绕过规则合并
                "Merge without waiting for requirements to be met (bypass rules)": "无需等待满足要求即可合并（绕过规则）",
                "Bypass rules and merge": "绕过规则合并",
                    "Confirm bypass rules and merge": "确认绕过规则合并",
                "Bypass rules and merge (squash)": "绕过规则合并（压缩）",
                    "Confirm bypass rules and merge (squash)": "确认绕过规则合并（压缩）",
                "Bypass rules and merge (rebase)": "绕过规则合并（变基）",
                    "This will rebase your changes and merge them into": "将更改变基合并到",
                    "Confirm bypass rules and merge (rebase)": "确认绕过规则合并（变基）",

            "Merging can be performed automatically once the requested changes are addressed.": "一旦请求的更改得到解决，合并就可以自动执行。",
            "This branch is out-of-date with the base branch": "此分支相比基础分支已过时",
                "Merge the latest changes from": "将",
                "into this branch.": "的最新更改合并到此分支中。",
                    "Update branch": "更新分支",
                        "Update with merge commit": "使用合并提交更新",
                            "The latest changes will be merged into this branch with a merge commit.": "最新的更改将通过合并提交合并到此分支中。",
                            "The merge commit will be associated with your account.": "合并提交将与您的账户相关联。",
                        "Update with rebase": "使用变基更新",
                            "This branch cannot be rebased due to conflicts.": "由于冲突，此分支不能变基。",
                            "This pull request will be rebased on top of the latest changes and then force pushed.": "此拉取请求将会在最新的更改之上进行变基，并且会使用强制推送的方式提交。",
                            "This branch cannot be rebased due to conflicts": "由于冲突，无法对此分支执行变基操作。",
                // [/Merge the latest changes from ([^ ]+) into this branch. This merge commit will be associated with ([^ ]+)./, "将最新更改从 $1 分支合并到当前分支。该合并提交将与用户 $2 相关联。"],

            "The base branch restricts merging to authorized users.": "基础分支合并仅限于授权用户。",
            "Learn more about protected branches.": "了解更多关于受保护分支的信息。",
            // [/Merging can be performed automatically with (\d+) approving review./, "合并可以通过 $1 次批准审查自动执行。"],
            "Merge without waiting for requirements to be met (bypass branch protections)": "合并而无需等待需求满足（绕过分支保护）。",
                "Extended description": "扩展描述",
                "Add an optional extended description…": "添加可选的扩展描述…",
                // [/This commit will be authored by ([^@]+@[^\n]+)/, "此提交的作者是 $1"],
            "Checks awaiting conflict resolution": "等待冲突解决",

            // 合并失败提示
                "Merge attempt failed": "合并尝试失败",
                "We couldn’t merge this pull request. Reload the page before trying again.": "我们无法合并此请求。重新加载页面后再试。",

            // [/(\d+) workflow awaiting approval/, "$1 个工作流等待批准"],
            "First-time contributors need a maintainer to approve running workflows.": "首次贡献者需要维护者来批准正在运行的工作流。",
            "The base branch does not accept merge commits. Alternate merge methods are preferred.": "基础分支不接受合并提交。其他合并方法是首选。",
            // [/The ([^ ]+) branch requires linear history/, "$1 分支为要求线性历史记录"],
            "Learn more about required linear history.": "了解更多关于要求线性历史记录的信息。",

            "Checking for the ability to merge automatically...": "检测自动合并的能力…",
            "Hang in there while we check the branch's status.": "请等待，我们正在检查该分支的状态",

            "Required statuses must pass before merging": "合并前必须通过所需的状态",
            "All required": "所有必需",
            "statuses": "状态",
            "and check runs on this pull request must run successfully to enable automatic merging.": "和检查运行在该拉取请求上必须成功运行，才能启用自动合并。",

            "Continuous integration has not been set up": "尚未设置持续集成",
            "several other apps": "其他一些应用",
            "can be used to automatically catch bugs and enforce style.": "可用于自动捕获错误和强制执行样式。",

            "This branch has no conflicts with the base branch": "该分支与基础分支没有冲突",
            "No conflicts with base branch": "与基本分支无冲突",
                "Merging can be performed automatically.": "可以自动地执行合并。",
                "Changes can be cleanly merged.": "可以干净地合并更改。",

            "This branch has no conflicts with the base branch when rebasing": "该分支基变时与基础分支没有冲突。",
                "Rebase and merge can be performed automatically.": "可以自动执行变基和合并。",

                "You’re not": "您无",
                "authorized": "权限",
                "to merge this pull request.": "合并此拉取请求。",

            "Merge pull request": "合并拉取请求",
                "Merging is blocked due to failing merge requirements": "由于未满足合并要求，合并已被阻止。",
            // 合并拉取请求 按钮下拉
            "Select merge method": "选择合并方式",
                "Create a merge commit": "创建合并提交",
                    "All commits from this branch will be added to the base branch via a merge commit.": "该分支的所有提交都将通过合并提交加入到基础分支中。",
                    "Not enabled for this repository": "未为此仓库启用",
                "Squash and merge": "压缩合并",
                    // [/The (\d+) commits? from this branch will be added to the base branch./, "该分支的 $1 个提交将合并到基本分支中。"],
                "Rebase and merge": "变基合并",
                    // [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "该分支的 $1 个提交将变基合并到基础分支中。"],
                    "Failed to load repo merge settings": "无法加载仓库合并设置",

            //确认合并 对话框
                // 新版合并界面
                "Commit header": "提交标题",
                "Commit message": "提交信息",
                "This commit will be authored by": "此提交的作者是",
            "Confirm merge": "确认合并",
            "Confirm squash and merge": "确认压缩合并",
            "Confirm rebase and merge": "确认变基合并",
            "Merging…": "合并中…",

            "You can also": "您也可以",
            "open this in GitHub Desktop": "在 GitHub Desktop 中打开",
            "or view": "，或查看",
            "You can also merge this with the command line, view": "您也可以使用命令行合并，查看",
            "command line instructions": "命令行指令",
            "You can also merge this with the command line.": "您也可以使用命令行合并。",
            "View command line instructions.": "查看命令行指令。",

            // "Merged": "已合并",
            "More actions": "更多操作",
            "View details": "查看详情",
            "Hide details": "隐藏详情",
            "Revert": "还原",
                "Create a new pull request to revert these changes": "创建一个新的拉取请求以恢复这些更改",
            "Closed with unmerged commits": "已关闭的未合并的提交",
                "This pull request is closed.": "此拉取请求已关闭。",

            "Pull request successfully merged and closed": "拉取请求已成功合并并关闭",
                "You're all set — the": "一切就绪",
                "branch has been merged and deleted.": "分支已合并并删除。",
                "You're all set — the branch has been merged.": "一切就绪 - 该分支已合并。",
            "Delete branch": "删除分支",
            "Restore branch": "恢复分支",

            "Pull request closed": "拉取请求已关闭",
            "This pull request is closed, but the": "此拉取请求已关闭，但是",
            "branch has unmerged commits.": "分支具有未合并的提交。",
            "branch has unmerged commits. You can delete this branch if you wish.": "分支具有未合并的提交。您可以根据需要删除此分支。",
            "If you wish, you can also delete this fork of": "如果需要，还可以删除此复刻",
            "If you wish, you can delete this fork of": "如果需要，可以删除此复刻",
            "in the": "在",
            "settings": "设置",

            // "Only those with": "只有对此仓库具有",
            // "write access": "写入访问权限",
            // "to this repository can merge pull requests.": "的才可合并拉取请求。",
            "You’re all set — the": "一切就绪 —",
            "You’re all set—the": "一切就绪 —",
            "branch can be safely deleted.": "分支可以被安全删除。",
            "This branch has conflicts that must be resolved": "该分支存在冲突，必须解决",
                "Resolve conflicts then push again. These conflicts are too complex to resolve in the web editor. Actions workflows will not trigger on activity from this pull request while it has merge conflicts.": "解决冲突后再次推送。这些冲突过于复杂，无法在 Web 编辑器中解决。当该拉取请求存在合并冲突时，操作工作流将不会触发该拉取请求的活动。",
                "These conflicts are too complex to resolve in the web editor.": "这些冲突过于复杂，无法在网页编辑器中解决。",
                "You do not have permission to push to the head branch.": "您没有权限向主分支推送。",
                "Use the command line": "使用命令行",
                "to resolve conflicts before continuing.": "解决冲突后再继续。",
                "or the command line to resolve conflicts before continuing. Actions workflows will not trigger on activity from this pull request while it has merge conflicts.": "或通过命令行解决冲突。在此拉取请求仍存在合并冲突的情况下，操作工作流不会因该拉取请求的活动而触发。",
                "or the command line to resolve conflicts before continuing.": "或通过命令行解决冲突后再继续。",
                "Use the command line to resolve conflicts before continuing.": "使用命令行解决冲突后再继续。",

                "Checkout via command line": "通过命令行检出",
                "Checkout via the command line": "通过命令行检出", // 新版合并界面
                "If the conflicts on this branch are too complex to resolve in the web editor, you can check it out via command line to resolve the conflicts.": "如果该分支上的冲突过于复杂，无法在 Web 编辑器中解决，您可以通过命令行检出来解决冲突。",
                "If you do not want to use the merge button or an automatic merge cannot be performed, you can perform a manual merge on the command line. However, the following steps are not applicable if the base branch is protected.": "如果不想使用合并按钮或无法执行自动合并，可以在命令行上执行手动合并。但若基本分支受到保护，则不适用以下步骤。", //新版合并界面
                "Step": "步骤", // 新版合并界面
                "Step 1:": "第 1 步：",
                    "From your project repository, check out a new branch and test the changes.": "从项目仓库中，检出新分支并测试更改。",
                    "Clone the repository or update your local repository with the latest changes.": "克隆仓库或使用最新更改更新本地仓库。",
                "Step 2:": "第 2 步：",
                    "Merge the changes and update on GitHub.": "合并更改并在 GitHub 上更新。",
                    "Switch to the head branch of the pull request.": "切换到拉取请求的头部分支。",
                "Step 3:": "第 3 步：",
                    "Merge the base branch into the head branch.": "将基础分支合并至头部分支。",
                "Step 4:": "第 4 步：",
                    "Fix the conflicts and commit the result.": "修复冲突并提交。",
                    "See": "查阅",
                        "Resolving a merge conflict using the command line": "使用命令行解决合并冲突",
                        "for step-by-step instructions on resolving merge conflicts.": "的分步说明。",
                "Step 5:": "第 5 步：",
                    "Push the changes.": "推送更改。",
                // 新版合并界面 复制按钮
                    "Copy clone URL": "复制克隆链接",
                    "Copy clone command": "复制克隆命令",
                    "Copy checkout command": "复制切换命令",
                    "Copy merge command": "复制合并命令",
                    "Copy push command": "复制推送命令",

            "Resolve conflicts": "解决冲突",
                "Use the": "使用",
                "web editor": "Web 编辑器",
                "or the": "或",
                "command line": "命令行",
                "to resolve conflicts.": "来解决冲突。",
                "These conflicts are too complex to resolve in the web editor": "这些冲突过于复杂，无法在网页编辑器中解决",
            "Conflicting files": "冲突的文件:",

            "Require approval from specific reviewers before merging": "合并前需要特定审查者的批准",
                "Branch protection rules": "分支保护规则",
                "Rulesets": "规则集",
                "ensure specific people approve pull requests before they're merged.": "确保特定人员在合并之前批准拉取请求。",
            "Add rule": "添加规则",
            // [/Ensure specific people or teams approve pull requests before they're merged into your ([^ ]+) branch./, "确保特定的人或团队在拉取请求被合并到您的 $1 分支之前批准它们。"], // 合并拉取请求

            // [/(\d+) workflows? awaiting approval/, "$1 个工作流程等待批准"],
            "This workflow requires approval from a maintainer.": "此工作流程需要维护者批准。",
            "Learn more about approving workflows.": "了解更多关于批准工作流程的信息。",
            "Approve and run": "批准并运行",
            "Approve and run workflows": "批准并运行工作流程",
            "Approve workflows to run": "批准运行工作流程",

            // 状态词
            "reviewed": "审查",
            "requested a review from": "请求审查",
            "Reply...": "回复…",

            // 代码审查回复
            "Suggestions cannot be applied on outdated comments.": "建议不要应用于过时的评论。",
            "Suggested change": "更改建议",
            "This code change can be committed by users with write permissions.": "具有写入权限的用户可以提交此代码更改。",

            "This branch was successfully deployed": "该分支已成功部署",
            "Show environments": "显示环境",
            // [/(\d+) active deployments?/, "$1 个活动的部署"],

            // 评论输入框选项，仅PR界面有
                "Copilot actions": "Copilot 操作",
                   "Generate": "生成",
                   "Summary": "总结",
                   "Generate a summary of the changes in this pull request.": "生成此拉取请求的更改摘要。",
                "Summarizing changes… this might take a minute": "总结更改…这可能需要 1 分钟",

        // 拉取请求 --> 提交 标签卡 /<user-name>/<repo-name>/pull/<id>/commits
            // 顶部提示
                "This pull request is big! We're only showing the most recent 250 commits": "该拉取请求过大！仅显示最近 250 次提交",
            "Commits": "提交",
            // [/Commits (.+)/, "提交于 $1"]
            "committed": "提交于",

            "Copy the full SHA": "复制完整的 SHA",
            "View commit details": "查看提交详情",
            "Browse the repository at this point in the history": "浏览该阶段的历史仓库内容",

        // 拉取请求--> 提交 --> 某提交详情/<user-name>/<repo-name>/pull/<id>/commits/<full SHA>
            "commit": "提交",
            // 修改的文件 左侧 展开按钮
            "Expand all": "展开全部",
            "Expand All": "展开全部",
            "Collapse expanded lines": "折叠展开行",
            "Expand Up": "向上展开",
            "Expand Down": "向下展开",

            // 修改的 yaml 文件，预览窗口
            "Loading Dependency Review...": "正在加载依赖审查…",
            "No dependencies changed.": "未更改依赖。",
                "The changes to this file likely do not affect the dependencies": "对此文件的更改可能不会影响依赖",

            "Give feedback on": "提交反馈，在",
                "dependency review": "依赖项审查",

            // 修改的文件 右侧下拉
            "Show comments": "显示评论",
            "Show annotations": "显示注释",
            "View file": "查看文件",
            "Edit file": "编辑文件",
            "Delete file": "删除文件",
            "Open in desktop": "在 GitHub Desktop 中打开",
            "Copilot is not available for this file type": "Copilot 不支持此文件类型",

            // 上一页
            "You are viewing the earliest commit": "您正在查看最早的提交",
            // 下一页
            "You are viewing the latest commit": "您正在查看最新的提交",

            "This merge commit was added into this branch cleanly.": "该合并提交被干净利落地添加到该分支中。",
                "There are no new changes to show, but you can still": "没有新的更改可显示，但您仍然可以",
                "view the diff.": "查看差异。",

            // 中间
            "Loading branch information": "正在加载分支信息",

            "Some comments aren't visible on the classic Files Changed page.": "某些评论在传统更改的文件页不可见。",

        // 拉取请求 --> 更改的文件 标签卡 /<user-name>/<repo-name>/pull/<id>/files
            // 网络错误
            "There was an issue loading this file": "加载此文件时出错",
                "Try refreshing the page or if the problem persists": "请尝试刷新页面，如果问题仍然存在，请",
                    "contact support": "联系支持人员",

            "Try the new experience": "尝试新体验",
            // 工具条
            "Browse files": "浏览文件", // 两个提交的比较页面

            "Show file tree": "显示文件树",
            "Hide file tree": "隐藏文件树",
            "Changes from": "更改自",
                "all commits": "所有提交",
                // 下拉
                "Show all changes": "显示所有更改",
                // [/(\d+) commits?/, "$1 条提交"],
                "Show changes since your last review": "显示自您上次评论以来的更改",
                // "You haven‘t reviewed this pull requeste": "您尚未审查过此请求请求",
                "You haven’t reviewed this pull request yet": "您尚未审查此请求请求",
                "Select commit": "选择提交",
                "Hold shift + click to select a range": "按住 shift + 单击以选择一个范围",
            "File filter": "文件筛选",
                "Filter by extension": "按文件后缀名筛选",
                    "No extension": "无后缀名",
                    // [/All (\d+) file types? selected/, "所有 $1 种文件类型被选中"],
                    // [/Select all 1 file types?/, "选择所有 $1 种文件类型"],
                    "Only manifest files": "仅清单文件",
                "There are no files selected for viewing": "没有选择要查看的文件",
                "Viewed files": "查看过的文件",
                // "filter file types": "筛选文件类型",
                // "filter viewed files": "筛选已查看文件",
                // "hide viewed files": "隐藏已查看文件",
                // "filter by context": "按内容筛选",
            "Clear filters": "清除筛选",
            "Conversations": "讨论",
            "Jump to conversation": "跳转到讨论",
                "Give feedback": "反馈",
                // [/Unresolved conversations/, "未解决的讨论"],
                "Nice work!": "干得好！",
                "All of your conversations have been resolved.": "您的所有讨论都已解决。",
                // [/Resolved conversations/, "已解决的讨论"],
                "No conversations yet": "尚无讨论",
                "Review conversations will show up here.": "审查讨论将显示在这里。",
            // "Jump to": "跳转到",
                "Jump to file": "跳转到文件",
                "Filter changed files": "筛选已更改文件",
                    "No files found.": "未找到文件。",
            // 差异视图
                "Diff view": "差异视图",
                // "Always": "总是",
                "Unified": "同屏",
                "Split": "分屏",
                // "Just for now": "仅当前",
                // "Hide whitespace changes": "隐藏空白更改",
                "Hide whitespace": "隐藏空白",
                "Apply and reload": "应用并重新加载",
            "Show whitespace": "显示空白",
            "Expand file": "展开文件",
            "Collapse file": "折叠文件",
            // "Refresh": "刷新",
            // 复制文件按钮
                "Copy file name to clipboard": "复制文件名到剪切板",
            
            "Open overview side panel": "打开概览侧边栏",
                "Close overview panel": "关闭", // 过于啰嗦省略
            // 评论
                "No replies": "无回复",

            "files viewed": "查看过的文件",
                "Marking files as viewed can help keep track of your progress, but will not affect your submitted review": "将文件标记为已查看可以帮助您跟踪进度，但不会纠正您提交的审查",
            // 咨询 Copilot
                "Loading Copilot features…": "加载 Copilot 功能…",
                "Copilot is not available for this pull request": "Copilot 不可用于此拉取请求",
            "Review in codespace": "在代码空间中审查",
            // "Review changes": "审查更改", // 使用 Selector 规则翻译
                // 下拉
                "Finish your review": "完成审查",
                    "Submit general feedback without explicit approval.": "未批准，并提出一般性反馈意见。",
                "Approve": "批准",
                    "Submit feedback approving these changes.": "批准，并提出反馈意见。",
                    "Submit feedback and approve merging these changes.": "提交反馈意见并批准合并这些更改。",
                    "Pull request authors can’t approve their own pull request.": "拉取请求作者无法批准自己的拉取请求。",
                    "Only users with explicit access to this repository may approve pull requests": "只有对这个仓库有明确访问权限的用户才能批准拉取请求",
                "Request changes": "请求更改",
                    "Submit feedback suggesting changes.": "请求更改，并提出更改反馈意见。",
                    "Submit feedback that must be addressed before merging.": "提交合并前必须解决的反馈意见",
                    "Pull request authors can’t request changes on their own pull request.": "拉取请求作者不能在自己的拉取请求上请求更改。",
                    "Only users with explicit access to this repository may request changes to pull requests": "只有对这个仓库有明确访问权限的用户才能请求更改拉取请求",
                "Abandon review": "放弃审核",
                "Submit review": "提交审查",
                    // 顶部提醒
                        "You need to leave a comment indicating the requested changes.": "您需要留下评论，说明所要求的更改。",
                "Cancel review": "取消审核",
                "pending": "条待处理",
                "comment": "评论",
                "comments": "评论",

            "Review changes": "审查更改",
                // 被锁定
                "This conversation has been locked and limited to collaborators.": "此对话已锁定，并限制与协作者对话。",

            "Viewed": "已查看",
            "Comment on this file": "评论此文件",
            "Comment on file": "评论此文件",

            "No changes to show": "没有更改",
                "This commit does not include any file changes": "此提交未包含文件更改",

            "Load diff": "载入差异", // old 待清理
            "Load Diff": "载入差异", // new
            "This file was deleted.": "该文件已被删除",
            "Large diffs are not rendered by default.": "默认情况下，大的差异不会被呈现。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默认不呈现。了解更多信息关于",
            "how customized files appear on GitHub": "更改文件在 GitHub 中的显示方式", // old 待清理
            "customizing how changed files appear on GitHub.": "自定义更改文件在 GitHub 中的显示方式。", // new
            "File renamed without changes.": "文件仅重命名，内容没有更改。",
            "File renamed without changes": "文件仅重命名，内容没有更改",
            "Binary file not shown.": "不显示二进制文件。",
            "Display the source diff": "显示源差异",
            "Display the rich diff": "显示富差异",
                "Added": "增加",
                "Deleted": "删除",
                "2-up": "并排",
                "Swipe": "拖拽",
                "Onion Skin": "渐变",

            "These merge commits were added into this branch cleanly.": "这些合并提交已被干净利落地添加到该分支中。",
                "There are no new changes to show.": "没有任何新的变化。",

            // 未更改文件检查注释(GA 检查)
                "Unchanged files with check annotations": "带检查注释的未更改文件",
                    "View workflow job for this annotation": "查看此注释的工作流程作业",

            // 代码评论
                "Comment on lines": "评论行",
                "Commenting on lines": "评论行",

            // Copilot 菜单
                "Ask Copilot about this diff": "与 Copilot 讨论此差异",
                    "Copilot is not available for this file type": "Copilot 不支持此文件类型",
                "Ask Copilot about this file-diff": "与 Copilot 讨论此文件差异",
                "Copilot menu": "Copilot 菜单",
                    "Explain": "解释",
                    "Attach to current thread": "附加到当前主题",
                    "Reference added to thread": "已附加至主题", // 左下角浮窗
                    "Ask about this diff": "询问此差异",

                "Select files to discuss": "选择文件讨论",
                    "Copilot is not available for this file": "Copilot 不支持此文件",
                    "Start chat": "开始聊天",

            // 建议更改
                "Suggested change": "建议更改",
                "Sign off and commit suggestion": "签署并提交建议",
                    "Suggestions cannot be applied from pending reviews.": "无法应用待审核中的更改",
                    "This suggestion has been applied or marked resolved.": "该建议已被应用或标记为已解决。",
                    "Outdated suggestions cannot be applied.": "过时建议不能应用。",
                "Add suggestion to batch": "批量添加建议",
                    "Add this suggestion to a batch that can be applied as a single commit.": "将此建议添加到可批量处理的单个提交中。",
                    "Batching suggestions must be done from the files tab.": "批处理建议必须在 “文件” 选项卡中进行。",
                "Commit suggestion": "提交建议",

                "Pending in batch": "待批量处理",
                "Remove from batch": "从批量处理中移除",
                    "Remove this suggestion from those to be applied in batch": "从批量应用的建议中删除此建议",
                "Sign off and commit suggestions": "签署并提交建议",
                    "Apply all batched suggestions as a single commit": "将所有批量建议作为单个提交应用",
                "Sign off and commit changes": "签署并提交更改",
                    "Applying commit...": "正在应用提交…",

                "This diff has recently been updated.": "该差异最近已更新。",
                "Refresh and try again.": "刷新并重试。",

                "Multiple suggested changes can be batched together in a single commit. Each suggestion author will be attributed in the commit as a co-author.": "多个建议更改可以在一次提交中批量处理。每个建议作者都将在提交中被归为共同作者。",

            // 新版
                "Switch back": "返回旧版",
                "Feedback": "反馈",

                "Collapse file tree": "折叠文件树",
                "Expand file tree": "展开文件树",

                "All changes": "所有更改",
                "All commits": "所有提交",
                "Changes since your last review": "自您上次审核以来的更改",
                "Specific commit…": "特定提交…",
                    "Pick one or more commits": "选择多个提交",
                    "Clear selection": "清除选择",
                        "Picking a range will select commits in between.": "选择一个范围将会选中其间的提交。",

                "viewed": "已审查",

                "Comments": "评论",
                "Submit": "提交",
                    "review": "审查",

                "Filter files…": "筛选文件…",
                "Filter options": "选项",
                    "File extensions": "文件扩展名",

                "Layout": "结构",
                "Minimize comments": "最小化评论",
                "Compact line height": "紧凑行高",

                "Select all": "全选",
                "Expand above": "向上展开",
                "Expand below": "向下展开",
                "Go to next hunk": "下一块",

        // 拉取请求 --> 更改的文件 标签卡 /<user-name>/<repo-name>/pull/<id>/files/<full SHA>
            "You are viewing a condensed version of this merge commit. You can view the": "您正在查看该合并提交的浓缩版本。您可以查看",
            "full changes here": "完整的更改",

            "We went looking everywhere, but couldn’t find those commits.": "我们尝试寻找，就是找不到那些提交者。",
            "Sometimes commits can disappear after a force-push. Head back to the": "有时提交会在强推后消失。头部回到",
            "latest changes here": "最新的更改",

            "Previous file (K)": "上个文件 (K)",
            "Next file (J)": "下个文件 (J)",

            "Comment on line": "评论行",
            "Expand comment": "展开评论",
            "Collapse comment": "折叠评论",
            "Unresolve comment": "取消解决评论",
                "marked this comment as resolved": "标记为已解决",
            "Resolve comment": "解决评论",
                "Apply suggestion": "应用建议",
                    "More suggestion batching options": "更多选项",
                        "This feature is not supported yet.": "此功能尚未支持。",
            "Return to code": "返回代码",
            "Reference in a new issue": "在新议题中引用",

            // 图片压缩
            "You're in single-file mode": "当前为单文件模式",
                "Due to the large number of changes in this pull request, only one file is being shown at a time.": "由于此拉取请求中的更改数量较多，因此一次只显示一个文件。",

                "buttons to move between files.": "按钮在文件之间移动。",

                "OK, got it": "知道了",

            // 评论
                "Filter comments": "筛选评论",
                    "Show resolved comments": "显示已解决评论",
                    "Show outdated comments": "显示陈旧的评论",

                "No comments on changes yet": "还没有评论",
                    "Comments will show up here as soon as there are some.": "评论将在此显示。",

                // Copilot
                    "Implement suggestion": "采纳建议",
                    "Mention Copilot": "提及 Copilot",
                        "Copilot isn't available for cross-repository pull requests": "Copilot 在跨仓库的拉取请求中不可用",

        // 拉取请求 --> 解决冲突 /<user-name>/<repo-name>/pull/<id>/conflicts
            "Resolving conflicts": "解决冲突",
            "between": " ",
            "and committing changes": "并提交更改",
            // [/(\d+) conflicting files?/, "$1 个冲突文件"],
            // [/(\d+) conflicts?/, "$1 处冲突"],

            "Keyboard hints": "快捷键",
                "How to interact with code conflict editor via keyboard": "如何通过键盘与代码冲突编辑器交互",
                    "Toggle between edit mode and tab focus mode": "切换编辑模式和标签焦点模式",
                    "Navigation between elements with tab focus mode on": "在 Tab 焦点模式下在元素之间导航",
                    "Move to next conflict control after accepting suggestion": "接受建议后移动到下一个冲突控件",
                    "Exit editor": "退出编辑器",
                        "then": "以及",

            "Mark as resolved": "标记为已解决",
                "Remove all conflict markers to resolve this file": "删除所有冲突标记以解决此文件冲突",
            "Indent mode": "缩进模式",
                "Spaces": "空格",
                "Tabs": "制表符",
            "Indent size": "缩进尺寸",
            "Line wrap mode": "换行模式",
                "No wrap": "不换行",
                "Soft wrap": "软换行",

            "Commit merge": "提交合并",
            "Sign off and commit merge": "签署并提交合并",
                "Heads up, this will commit to": "请注意，这将提交到",
                "Commit updates to the": "提交更改到",
                "branch.": "分支。",
                "Create a": "创建",
                "new branch": "新分支",
                "and commit updates. Your pull request will be updated automatically.": "并提交更改。您的拉取请求将自动更新。",
                // [/I understand, sign off and update/, "我明白了，依然签署并更新"],
                "You are": "您将",
                "signing off": "签署",
                // [/on this commit as ([^@]+@[^\n]+)/, "该提交以 $1 身份"],
                "Committing merge…": "正在提交合并…",

                "conflict": "冲突",
                "conflicts": "冲突",

            "Accept current change": "接受当前更改",
            "Accept incoming change": "接受传入更改",
            "Accept both changes": "接受全部更改",

        // 拉取请求 - 由 Copilot 编写 https://github.com/用户名/仓库名/pull/编号/agent-sessions
            "Back to pull request #": "返回到拉取请求 #",

            "Copilot coding agent now uses fewer premium requests!": "Copilot 编程智能体现在使用更少的高级请求！",
                "From now on, each session uses just one premium request.": "从现在起，每个会话只会使用一次高级请求。",

            // 状态
                "Failed": "失败",
            "Sessions": "进度",
            "Duration": "总时长",
            "Premium requests": "高级请求",
                "Learn more about premium requests": "关于高级请求",

            "premium": "高级",
            "request": "请求",
            "requests": "请求",
            "used in": "被用于",
            "session": "任务",
            "sessions": "任务",

            "Stop session": "停止任务",
            "Open menu": "操作",
                "View verbose logs": "查看日志",

            "Spinning up dev environment…": "正在启动开发环境…",
            "Starting MCP servers…": "正在启动 MCP 服务器…",
            "Making sure Copilot feels comfortable in the cockpit…": "确保 Copilot 在驾驶舱中感到舒适…",
            "Fueling the runtime engines…": "为运行时引擎加油…",
            "Copilot is working…": "Copilot 工作中…",

            "Copilot stopped work due to an error": "Copilot 因错误停工",
                "Copilot has encountered an error. See logs for additional details.": "Copilot 遇到错误。请查看日志以获取更多详细信息。",
                // 内部错误，走正则
                "View detailed logs": "查看详细日志",

            // 进度
            "View repository": "查看仓库",

        // 新版拉取请求提交页面
            "authored and": "撰写和",
            "Browse repository at this point": "查看此时间点的仓库",

        "ProTip!": "专业提示！",
            "to the end of URLs for Git’s plaintext views.": "到 Git 纯文本视图的 URL 结尾。",
            "Add comments to specific lines under": "为以下特定行添加注释于",
        "Switch back to the classic merge experience": "切换回经典的合并界面",
        "Try the new merge experience": "尝试新的合并界面",

        "Repository owner locked as": "仓库所有者锁定为",
            "resolved": "已解决",
            "too heated": "争论不休",
            "off-topic": "偏离主题",

        "Merge status cannot be loaded": "合并状态加载出错",
            "Try reloading the page, or if the problem persists": "尝试重新加载页面，或者如果问题仍然存在",
                "contact support": "请联系支持人员",
            "GitHub status": "GitHub 状态",

        "Mention \@copilot in a comment to make changes to this pull request.": "在评论中提及 @copilot 以对该拉取请求进行更改。",


    },
    "regexp": [ // 正则翻译
        [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "该分支的 $1 次提交将变基并添加到基本分支。"],
        [/([^ ]+):([^ ]+)% was force-pushed and no longer has any new commits./, "$1:$2 分支被强制推送，现在没有新的提交。"], // 放这里是因为跟现有词条冲突
        // 建议更改（词条打架移动至此）
        [/on this commit as ([^@]+@[^\n]+)/, "该提交以 $1 身份"],
        // Dependabot 打开的拉取请求
        [/This pull request resolved a Dependabot alert on ([^ ]+)./, "此拉取请求解决了 1 个 Dependabot 警报，在 $1 上。"],
        [/(\d+) Dependabot alerts?/, "$1 个 Dependabot 警报"],
        [/^on ([^ ]+) including a/, "在 $1 上，包括 1 个"],
        [/^on ([^ ]+)./, "在 $1 上。"],

        // 提交时展开收缩的描述
        [/Show description for ([a-f0-9]{7})/, "显示提交 $1 的描述"],
        [/Hide description for ([a-f0-9]{7})/, "隐藏提交 $1 的描述"],

        // 新版 PR 提交页
        [/wants to merge (\d+) commits? into/, "希望合并 $1 条提交到"],
        [/Commits on (.+)/,  (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `提交于${translatedDate}`;
        }],
        [/Add(?: a)? comment on line ((L|R)(\d+))/, "在 $1 行评论"],
        [/Suggest change on line ((L|R)(\d+))/, "建议更改 $1 行"],
        [/Expand all lines: (.+)/, "展开所有行：$1"],
        [/Collapse non-diff lines: (.+)/, "折叠未更改行：$1"],
        // CODEOWNERS 文件指定所有者
        [/Owned by (\@.+) \(from CODEOWNERS line (\d+)\)/, "由 $1 拥有（来自 CODEOWNERS 第 $2 行）"],

        // 具体某条拉取请求
        [/edited by ([^ ]+)/, "由 $1 编辑"],
        [/At least (\d+) approving reviews? is required to merge this pull request./, "合并此拉取请求至少需要 $1 次批准审核。"],
        [/Commits?/, "提交"],
        [/Files? changed/, "文件更改"],
        [/merged (\d+) commits? into/, "将 $1 个提交合并到"],
        [/Copy full SHA for ([^ ]+)/, "复制 $1 完整的 SHA"], // Android UA ? 提交卡
        [/View checks?/, "查看检查"], // Android UA ?
        [/([^ ]+) left review comments?/, "$1 发表了审查意见"],
        [/([^ ]+) approved these changes?/, "$1 批准这些更改"], // 具体的拉取请求 审查者
        [/Request review from ([^ ]+)/, "请求 $1 审查"], // 具体的拉取请求 审查者
        [/users with write access to ([^ ]+) can add new commits/, "对 $1 具有写权限的用户可以添加新的提交"], // 具体拉取请求
        [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准审查才能合并此拉取请求。"], // 具体的拉取请求 审查者
        [/This user is a first-time contributor to the ([^ ]+) repository./, "该用户是第一次为 $1 仓库做贡献。"],
        [/(\d+) pending reviewers?/, "$1 名待审者"],
        [/([\d,]+) participants?/, "$1 位参与者"],
        [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有写入权限的审查者至少需要 $1 次批准审查。"],
        [/(\d+) approving reviews? by reviewers? with write access./, "$1 个批准的审查由具有写入权限的审查者进行审查。"],
        [/(\d+) review requesting changes by reviewers? with write access./, "$1 个请求审查更改由具有写入权限的审查者进行审查。"],
        [/(\d+) approvals?/, "$1 项批准"],
        [/(\d+) reviews? requesting changes by reviewers with write access/, "$1 项审查，要求有写入权限的审查者进行更改"], // 拉取请求
        [/(\d+) changes? requested by reviewers with write access/, "具有写入权限的审查者提出 $1 项更改请求"],
        [/(\d+) changes? requested/, "$1 项更改请求"],
        [/This pull request closes issue (#\d+)./, "该拉取请求将关闭议题 $1。"], // 死活不翻译
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "$1 处增加，$2 处删除未显示，因为差异太大。请使用本地 Git 客户端查看这些更改。"],
        [/(\d+) requested change/, "$1 项请求更改"],

        // 状态
        [/branch (\d+) times, most recently from/, "分支 $1 次，最近一次从"],
        [/pushed a commit to ([^ ]+) that referenced this pull request/, " 向 $1 推送一次提交，其中引用了此拉取请求"],
        [/added a commit to ([^ ]+) that referenced this pull request/, "向 $1 添加一个提交，其中引用了此拉取请求"],
        [/Missing successful active ([^ ]+) deployment./, "未成功激活 $1 部署。"], // 新本合并页面

        [/(\d+) in progress checks?/, "$1 个正在进行的检查"],
        [/(\d+) skipped and (\d+) successful checks?/, "$1 个跳过, $2 个成功检查"],
        [/(\d+) successful and (\d+) failing checks?/, "$1 个成功, $2 个失败检查"],
        [/(\d+) skipped, (\d+) successful, and (\d+) failing checks?/, "$1 个跳过, $2 个成功, $3 个失败检查"],
        [/(\d+) skipped, (\d+) successful, (\d+) cancelled, and (\d+) failing checks?/, "$1 个跳过, $2 个成功, $3 个取消, $4 个失败检查"],
        [/(\d+) skipped, (\d+) successful, and (\d+) expected checks?/, "$1 个跳过, $2 个成功, $3 个预先检查"],
        [/(\d+) skipped, (\d+) successful, (\d+) queue, and (\d+) expected checks?/, "$1 个跳过, $2 个成功, $3 个排队, $4 个预先检查"],
        [/(\d+) skipped, (\d+) successful, (\d+) in progress, and (\d+) expected checks?/, "$1 个跳过, $2 个成功, $3 个正在进行, $4 个预先检查"],
        [/(\d+) neutral checks?/, "$1 次中立检查"],
        [/(\d+) successful checks?/, "$1 次成功检查"],
        [/(\d+) of (\d+) checks? passed/, "$1/$2 次检查通过"],
        [/(\d+) checks? passed/, "$1 次检查通过"],

        [/Merge the latest changes from ([^ ]+) into this branch. This merge commit will be associated with ([^ ]+)./, "将最新更改从 $1 分支合并到当前分支。该合并提交将与用户 $2 相关联。"],
        [/Merging can be performed automatically with (\d+) approving review./, "合并可以通过 $1 次批准审查自动执行。"],
        [/(\d+) workflow awaiting approval/, "$1 个工作流等待批准"],
        [/The ([^ ]+) branch requires linear history/, "$1 分支为要求线性历史记录"],
        [/The (\d+) commits? from this branch will be added to the base branch./, "该分支的 $1 个提交将合并到基本分支中。"], // 合并拉取请求 按钮下拉
        [/The (\d+) commits? from this branch will be combined into one commit in the base branch./, "该分支的 $1 个提交将合并到基础分支中。"], // 合并拉取请求 按钮下拉
        [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "该分支的 $1 个提交将变基合并到基础分支中。"], // 合并拉取请求 按钮下拉
        [/Ensure specific people or teams approve pull requests before they're merged into your ([^ ]+) branch./, "确保特定的人或团队在拉取请求被合并到您的 $1 分支之前批准它们。"], // 合并拉取请求
        [/(\d+) commits?/, "$1 条提交"],
        [/All (\d+) file types? selected/, "所有 $1 种文件类型被选中"], // 文件筛选
        [/Select all (\d+) file types?/, "选择所有 $1 种文件类型"],
        [/Unresolved conversations/, "未解决的讨论"],
        [/Resolved conversations/, "已解决的讨论"],
        // [/Commits (.+)/, "提交于 $1"], // 提交标签卡
        [/(#\d+) will be closed when this pull request is merged/, "$1 将在该拉取请求合并时关闭"],
        // 代码空间
        [/Create a codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
        [/Create codespace on ([^ ]+)/, "在 $1 上创建代码空间"],
        [/Codespace \"(.+)\" stopped./, "代码空间 “$1” 已停止。"],
        [/Codespace \"(.+)\" deleted./, "代码空间 “$1” 已删除。"],
        [/Are you sure you want to delete (.+)\?/, "您确定要删除 $1 吗？"],
        [/(\d+) conflicting files?/, "$1 个冲突文件"], //conflicts
        [/(\d+) conflicts?/, "$1 处冲突"],  //conflicts
        [/Awaiting requested review from ([^ ]+)/, "等待 $1 审查请求"], // 具体的拉取请求
        [/([^ ]+) is a code owner/, "$1 是代码所有者"], // 具体的拉取请求
        [/This commit will be authored by ([^@]+@[^\n]+)/, "此提交的作者是 $1"], // 具体的拉取请求
        [/This pull request resolved a Dependabot alert on ([^ ]+)./, "该请求解决了 $1 的 Dependabot 警报问题。"],
        [/(\d+) workflows? awaiting approval/, "$1 个工作流程等待批准"],
        [/(\d+) resolved conversations?/, "$1 条对话已解决"], // 拉取请求
        [/I understand, continue updating ([^ ]+)/, "我明白了，继续更新 $1"],
        [/I understand, sign off and update/, "我明白了，依然签署并更新"],
        [/Notify someone on an issue with a mention, like: @([^ ]+)./, "在议题中通过 @ 提及通知某人，例如：@$1。"], // 专业提示
        [/(\d+) conversations? must be resolved before merging./, "合并之前必须解决 $1 个对话。"],
        [/(\d+) hidden items?/, "$1 条隐藏项目"],
        [/([^ ]+) requested changes/, "$1 要求更改"],
        [/(\d+) active deployments?/, "$1 个活动的部署"],
        [/Check failure on line (\d+)/, "第 $1 行检查失败："],

        // 命令行解决冲突页面
        [/Copy (.+?) to clipboard/, "复制 $1 到剪切板"],

        // 文件差异过大 参考 https://github.com/maboloshi/github-chinese/pull/306/files
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "差异过大，不会显示 $1 行添加以及 $2 行删除。请使用本地 Git 客户端查看更改。"],

        // 任务
        [/(\d+) tasks?/, "$1 个任务"],

        // 评论
        [/Lines (\d+) to (\d+) in/, "第 $1 - $2 行，"],

        // 建议更改
        //[/on this commit as ([^@]+@[^\n]+)/, "提交，身份为 $1"],

        // Copilot
        [/Copilot has encountered an internal error. If the problem persists, please contact GitHub Support, including the request ID `([^ ]+)`. To retry, leave a comment on this pull request asking Copilot to try again./, "Copilot 遇到了内部错误。如果问题仍然存在，请联系 GitHub 支持，并附上请求 ID `$1`。要重试，请在此拉取请求中发表评论，要求 Copilot 再试一次。"],

        // 解决冲突编辑器（似乎又是 F12 才会翻译）
        [/Search:/, "搜索："],
        [/\(Use \/re\/ syntax for regexp search\)/, "(使用 /re/ 进行正则搜索)"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        ...I18N["zh-CN"]["repository/pull_issue_public"]["regexp"],
    ],
    "selector": [ // 元素筛选器规则
        ["span[data-message='Review changes']", "审查更改"], // 拉取请求 --> 更改的文件
    ],
    "title": {
        "regexp": [
            [/(.+) by (.+) · Pull Request #(\d+) · (.+)/, "$1 作者：$2 · 拉取请求 #$3 · $4"],
        ],
    },
};

I18N["zh-CN"]["repository/compare"] = { // 仓库 - 比较并创建拉取请求
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 变更比较 页面 /<user-name>/<repo-name>/compare@
            "Compare changes": "比较变更",
            "Compare changes across branches, commits, tags, and more below. If you need to, you can also": "比较跨分支，提交，标签，和更多的变更。如果您需要，也可以",
            "compare across forks": "比较复刻库和源仓库",
            "Learn more about diff comparisons here": "点击此处了解更多关于差异比较的信息",
            "This is a direct comparison between two commits made in this repository or its related repositories.": "这是本仓库或其相关仓库中两次提交的直接比较。",
            "View the default comparison": "查看此范围的默认比较",
            "for this range or": "或",

            // 分支选择栏
            "base repository:": "基础仓库：",
                "Choose a Base Repository": "选择基础仓库",
                "Filter repos": "筛选仓库",
            "head repository:": "头部仓库：",
                "Choose a Head Repository": "选择头部仓库",

            "base:": "基础分支：",
                "Choose a base ref": "选择基础引用",
                "Find a branch": "搜索分支",
                "Find a tag": "搜索标签",
            "compare:": "比较分支：",
                "Choose a head ref": "选择头部引用",

            "Choose different branches or forks above to discuss and review changes.": "选择不同的分支或复刻来讨论和查看变化。",
            "Learn about pull requests": "了解拉取请求",

            "Create pull request": "创建拉取请求",

            "Compare and review just about anything": "比较和审查任何文件",
            "Branches, tags, commit ranges, and time ranges. In the same repository and across forks.": "分支，标签，提交范围和时间范围。在同一仓库和复刻的仓库。",
            "Example comparisons": "比较例子",

            "Commit": "提交",
            "Commits": "提交",
            "File changed": "更改的文件",
            "Files changed": "更改的文件",

        // 提出合并分支 /<user-name>/<repo-name>/compare/<branch>...<user-name-1>:<branch-1>
        // /<user-name>/<repo-name>/compare/<branch>...<branch-1>
        // <user-name>/<repo-name>/compare/<branch>...<user-name-1>:<repo-name-1>:<branch-1>
            "Comparing changes": "比较变更",
            "Choose two branches to see what’s changed or to start a new pull request. If you need to, you can also": "选择两个分支，看看发生了什么改变，或发起一个新的拉请求。如果您需要，您也可以",
            "learn more about diff comparisons": "了解更多关于差异比较的信息",
            // "base fork:": "基复刻：",
            "Documentation has changed since you last contributed": "文件已发生变化，自您上次提交文件于",
            ". Take a look before submitting a pull request:": "。在提交拉取请求前，请先看一下：",
            "Contributing guidelines": "贡献指南",
            "Last updated": "最近更新于",

            "There isn’t anything to compare.": "没有任何东西可比较。",
                "We couldn’t figure out how to compare these references, do they point to valid commits?": "我们不知道如何比较这些引用，它们是否指向有效的提交？",

                "You’ll need to use two different branch names to get a valid comparison.": "您需要使用两个不同的分支名称来进行有效的比较。",
                "Check out some of these sample comparisons.": "看看这些比较的例子吧。",

                "is up to date with all commits from": "已是最新，提交于",
                ". Try": "。尝试",
                "switching the base": "切换基础库",
                "for your comparison.": "来进行比较。",

                "are entirely different commit histories.": "是完全不同的提交历史。",

            "Discuss and review the changes in this comparison with others.": "与他人讨论并回顾此次对比中的变化。",

            "This comparison is big! We’re only showing the most recent 250 commits": "这个比较是很大的! 我们只显示最近的 250 个提交。",

            "You’ll need to use two different branch names to get a valid comparison.": "您需要使用两个不同的分支名称来进行有效的比较。",

            "are identical.": "是相同的。",

            "Create another pull request to discuss and review the changes again.": "创建另一个拉取请求，再次讨论和审查这些更改。",

            // 修改的文件 左侧 展开按钮
            "Expand all": "展开全部",
            "Expand All": "展开全部",
            "Expand Up": "向上展开",
            "Expand Down": "向下展开",

            "Unified": "同屏",
            "Split": "分屏",

            "Load diff": "载入差异",
            "This file was deleted.": "该文件已被删除",
            "Large diffs are not rendered by default.": "默认情况下，大的差异不会被呈现。",
            "File renamed without changes": "文件仅重命名，内容没有更改",
            "Binary file not shown.": "不显示二进制文件。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默认不会呈现。详细了解",
                "how customized files appear on GitHub": "自定义文件在 GitHub 上的显示方式",
            "Empty file.": "空文件。",

            // 提交相关
            "Copy the full SHA": "复制完整 SHA",
            "View commit details": "查看提交详情",
            "Browse the repository at this point in the history": "浏览该阶段的历史仓库内容",

        // 直接提交拉取请求 /<user-name>/<repo-name>/compare/<branch>...<branch-1>?quick_pull=1
            "Open a pull request": "新建一个拉取请求",
            "The change you just made was written to a new branch named": "您刚刚所做的更改已写入新分支",
            ". Create a pull request below to propose these changes.": ". 请在下方创建拉取请求，提出这些更改。",
            "Create a new pull request by comparing changes across two branches. If you need to, you can also": "通过比较两个分支的更改来创建一个新的拉请求。如果需要，还可以",

            // 提示框（第一次提交拉取请求时）
            "It looks like this is your first time opening a pull request in this project!": "看起来这是您在这个项目中首次发起的拉取请求呢！",
            "Be sure to review the": "请务必查阅",
            "contributing guidelines": "贡献指南",
            "Reporting a security vulnerability?": "报告安全漏洞？",
            "Check out the project's": "查看本项目的",
            "Looking for help?": "需要帮助？",
                "Check out the project’s": "查看本项目的",
                "instructions for getting support": "支持说明",

            "Checking mergeability…": "检查可合并性…",
            "Don’t worry, you can still create the pull request.": "别担心，您仍然可以创建拉取请求。",
            "Able to merge.": "可被合并。",
            "Can’t automatically merge.": "无法自动合并。",
            "These branches can be automatically merged.": "该分支可被自动合并。",

            "View pull request": "查看拉取请求", //存在拉取请求时
                "No description available": "无说明", // 拉取请求无评论时

            "commit": "次提交",
            "commits": "次提交",
            "file changed": "个文件变更",
            "files changed": "个文件变更",
            "contributor": "位贡献者",
            "contributors": "位贡献者",
            // "No commit comments for this range": "该范围变更没有提交注释",

            "Reviewers": "审查者",
                "No reviews": "未经审查",
                "Loading suggestions…": "载入推荐…",
                // [/([^ ]+) left review comments/, "$1 发表了审查意见"],
                // [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准审查才能合并此拉取请求。"],
                "No reviews—at least 0 approving review is required.": "未经审查 — 至少需要 0 次批准审查。",
                "Re-request review": "重新请求审核",
                "Still in progress?": "仍在进行中吗？",
                // [/Awaiting requested review from ([^ ]+)/, "等待 $1 的审查请求"]
                "Learn about draft PRs": "了解拉取请求草案",
                    "Try draft pull requests": "尝试拉取请求草案",
                    "Open an in-progress pull request without asking for formal review or risking an unwanted merge. When you're ready for code review, you can mark your draft pull request as ready for review, which will request reviews from any code owners.": "打开正在进行的拉取请求，无需请求正式审核，也不必冒不必要的合并风险。当您准备好进行代码审核时，您可以将拉取请求草案标记为已准备好审核，这将请求任何代码所有者进行审核。",
                    "Ask admin for access": "向管理员请求权限",
                "Convert to draft": "设置为草案",
                "Request up to 15 reviewers": "最多请求 15 个审查者",
                // [/([^ ]+) approved these changes/, "$1 批准这些更改"], // 具体的拉取请求 审查者
                "Request": "请求",
                // [/Request review from ([^ ]+)/, "请求 $1 审查"], // 具体的拉取请求 审查者
                "This pull request is waiting on your review.": "此拉取请求正在等待您的审核。",
                // Copilot
                    "Copilot can review pull requests": "Copilot 可以审查拉取请求",
                    "Request a review from Copilot to get fast, actionable feedback on your code, so you can start iterating before you receive a human review.": "向 Copilot 请求代码审查，即可获得快速且可操作的反馈，让您能在收到人工审查前就开始迭代优化。",
                    "OK, dismiss": "关闭",

            "Assignees": "受理人",
                "No one assigned": "无人受理",
                "No one—": "无人 - ",
                "assign yourself": " 受理自己",
                "Assign up to 10 people to this issue": "最多指定 10 人", // 议题
                "Assign up to 10 people to this pull request": "最多指定 10 人", // 拉取请求
                "Clear assignees": "清除受理人",
                "Type or choose a user": "输入或选择用户",
                "Suggestions": "建议",

            "Labels": "标签",
                "None yet": "暂无",
                "bug": "BUG",
                    "Something isn't working": "有些东西不工作",
                "confirmed": "已确认",
                    "Issue confirmed to exist and the reason is known": "问题已确认存在，原因已知",
                "dependencies": "依赖性",
                    "Pull requests that update a dependency file": "更新依赖文件的拉取请求",
                "documentation": "文档",
                    "Improvements or additions to documentation": "文档的改进或补充",
                "duplicate": "重复",
                    "This issue or pull request already exists": "这个议题或拉取请求已经存在",
                "enhancement": "增强",
                    "New feature or request": "新功能或请求",
                "good first issue": "好的首发议题",
                    "Good for newcomers": "适合新人",
                "help wanted": "需要帮助",
                    "Extra attention is needed": "需要特别关注",
                "invalid": "无效",
                    "This doesn't seem right": "这似乎不对",
                "question": "问题",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不会修复",
                    "Not going to fix it": "不打算修复",
                    "This will not be worked on": "这将不会被处理",

                "Apply labels to this issue": "应用标签", // 议题
                "Apply labels to this pull request": "应用标签", // 拉取请求
                "Edit labels": "编辑标签",

                "dependencies": "依赖项",
                    "Pull requests that update a dependency file": "更新依赖文件的拉取请求",
                "Recent": "最近",
                "User": "用户",
                "No projects": "无项目",

            "Milestone": "里程碑",
                "No milestone": "无里程碑",
                "Set milestone": "设置里程碑",
                    "Nothing to show": "暂无",

        "Allow edits and access to secrets by maintainers": "允许维护人员编辑和访问机密",
            "If checked,": "如果勾选，",
            "users with write access to": "则拥有",
            "can add new commits": "写访问权限的用户可以向您的",
            "to your": "向您的",
            "branch.": "分支添加新提交。",
            "You can always change this setting later.": "您可以随时更改这一设置。",
            "Note: By granting write access, maintainers could potentially edit your repository's workflows to reveal values of secrets and gain access to other branches.": "注意：通过授予写入权限，维护者可能会编辑您仓库的工作流程以揭示机密值，并获取对其他分支的访问权限。",
            "Got it": "知道了",
        // 创建拉取请求 按钮下拉
            "Open a pull request that is ready for review": "打开一个准备好进行审核的拉取请求",
            "Automatically requests reviews from code owners": "自动请求代码所有者进行审查",
            "Create draft pull request": "创建拉取请求草案",
            "Cannot be merged until marked ready for review": "在标记为准备好进行审核之前无法合并",
            "Doesn't request code owners review and cannot be merged": "不请求代码所有者审核并且无法合并",
            "Draft pull request": "拉取请求草案",
        "Remember, contributions to this repository should follow its": "请记住，对该仓库的贡献应遵循其",
        "security policy": "安全政策",
        "code of conduct": "行为准则",
        "Remember, contributions to this repository should follow our": "请记住，对此仓库的贡献应遵循我们的",
        "GitHub Community Guidelines": "GitHub 社区准则",
        "Support": "支持",

        // 右侧栏补充
        "Development": "进展",
            "Use": "使用",
            "Closing keywords": "关闭关键词",
            "in the description to automatically close issues": "在描述中，以自动关闭议题",
            "Use Closing keywords to add a closing reference": "使用关闭关键词添加一个关闭引用",

        "Helpful resources": "帮助性资源",
            // "GitHub Community Guidelines": "GitHub 社区准则",
            "Contributing": "贡献准则",
            "Code of conduct": "行为准则",
            "Security policy": "安全政策",

        // 标签对应版本比较 /<user-name>/<repo-name>/compare/<tag-id1>...<tag-id2>
            // 仅限 MD文件
            "Display the source diff": "显示源差异",
            "Display the rich diff": "显示富差异",

            "Load more commits": "载入更多的提交",

        // /<user-name>/<repo-name>/compare/<tag>...<branch>
            "Commit comments": "提交评论",

        "Showing": "显示",
        "with": "包含",

        // 编辑器右上角三点，“显示评论”走正则
        "View file": "查看文件",
        "Edit file": "编辑文件",
        "Delete file": "删除文件",

        // 加载差异失败
        "This comparison is taking too long to generate.": "生成比较结果的时间过长。",
        "Unfortunately it looks like we can’t render this comparison for you right now. It might be too big, or there might be something weird with your repository.": "不幸的是，我们现在无法为您提供这种比较。它可能太大了，或者您的仓库有什么奇怪的地方。",
        "You can try running this command locally to see the comparison on your machine:": "您可以尝试在本地运行此命令以查看比较结果：",

        // 评论输入框选项
        "Copilot actions": "Copilot 操作",
            "Generate": "生成",
                "Summary": "总结",
                    "Generate a summary of the changes in this pull request.": "生成此拉取请求的更改摘要。",
        "Summarizing changes… this might take a minute": "总结更改…这可能需要 1 分钟",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Show comments?/, "显示评论"], // 编辑器右上角三点
        [/committed/, "提交于"],
        [/(\d+) contributors?/, "$1 贡献者"],
        [/Allow(ing)? edits by maintainers/, "允许维护人员编辑"],
        [/users with write access to ([^ ]+) can add new commits/, "则拥有 $1 写访问权限的用户可以向您的"],
        [/(\d+) changed files?/, "更改的文件"],
        [/(\d+) additions?/, "$1 处增加"],
        [/(\d+) deletions?/, "$1 处删除"],
        [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准审查才能合并此拉取请求。"], // 创建拉取请求
    ],
    "title": {
        "regexp": [
            [/Compare/, "比较"],
        ],
    },
};

I18N["zh-CN"]["repository/commit"] = { // 仓库 - 提交页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 具体某个提交页面 /<user-name>/<repo-name>/commit/<full SHA>
            "Commit": "提交",

            // 快捷键
            "Browsing commits": "浏览提交",
            // "": "提交评论",
            "Close form": "关闭评论",
            "Parent commit": "父提交",
            "Other parent commit": "其他父提交",

            // 访问已删除的提交
            "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "这个提交不属于本仓库的任何分支，可能属于仓库以外的分支。",

            "Browse files": "浏览文件",
            "Loading branch information": "载入分支信息",

            // [/This commit closes issue (#\d+)./, "此提交关闭了提议 $1。"], //具体提交页面
            "committed": "提交于",
            "commit": "提交",

            "Showing": "显示",
            "with": "包含",
            "always": "总是",
            "Whitespace": "显示空白字符差异",
            "Ignore whitespace": "忽略空白字符差异",
            "Unified": "同屏",
            "Split": "分屏",
            "Minimize comments": "最小化评论",

            "Display the source diff": "显示源差异",
            "Display the rich diff": "显示富差异",
            "Comment on this file": "评论此文件", // new code view

            "Filter changed files": "筛选已更改的文件", // new code view 侧栏
            "Show file tree": "显示文件树", // new code view 侧栏
            "Hide file tree": "隐藏文件树", // new code view 侧栏

            "Submodule": "子模块",
            "updated": "已更新",
            // [/from ([^ ]+) to ([^ ]+)/, "从 $1 到 $2。"], //具体提交页面

            "Binary file not shown.": "不显示二进制文件",
            "Empty file.": "空文件。",
            "File renamed without changes.": "文件仅重命名，内容没有更改。",
            "Whitespace-only changes.": "仅空白字符更改。",

            "Some content is hidden": "某些内容被隐藏",
                "Large Commits have some content hidden by default. Use the searchbox below for content that may be hidden.": "大型提交默认隐藏部分内容。使用下面的搜索框查找可能隐藏的内容。",
            "Dismiss banner": "关闭",

            "Load diff": "载入差异",
            "Load Diff": "载入差异",
            "This file was deleted.": "该文件已被删除",
            "Large diffs are not rendered by default.": "默认情况下，大的差异不会被呈现。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默认不呈现。了解更多信息关于",
            "how customized files appear on GitHub": "更改文件在 GitHub 中的显示方式",
            "customizing how changed files appear on GitHub.": "自定义更改文件在 GitHub 上显示方式。",
            "File renamed without changes.": "文件仅重命名，内容没有更改。",
            "File renamed without changes": "文件仅重命名，内容没有更改",
            "Binary file not shown.": "不显示二进制文件。",
            "Diff is too big to render. To view,": "差异过大，",
            "check out this pull request locally.": "请在本地查看拉取请求。",

            // 修改的文件 左侧 展开按钮
            "Expand all": "展开全部",
            "Expand Up": "向上展开",
            "Expand Down": "向下展开",
            "Collapse expanded lines": "折叠展开的线",

            // 修改的 yaml 文件，预览窗口
            "Loading Dependency Review...": "正在加载依赖审查…",
            "No dependencies changed.": "未更改依赖。",
                "The changes to this file likely do not affect the dependencies": "对此文件的更改可能不会影响依赖",

            "Give feedback on": "提交反馈，在",
                "dependency review": "依赖项审查",

            // 修改的文件 右侧下拉
            "Show comments": "显示评论",
            "Show annotations": "显示注释",
            "View file": "查看文件",
            "Edit file": "编辑文件",
            "Delete file": "删除文件",
            "Open in desktop": "在 GitHub Desktop 中打开",
            "Copilot is loading...": "Copilot 加载中…",
            "Ask about this diff": "询问此差异",
                "Explain": "解释",
                "Attach to current thread": "附加至当前话题",

            //底部评论框上部
            "Lock conversation": "锁定对话",
                "Lock conversation on this commit": "锁定关于此提交的对话",
                "Locking the conversation means:": "锁定对话意味着：",
                    "Other users": "其他用户",
                    "can’t add new comments": "无法添加新评论",
                    "to this commit.": "到这个提交。",
                    "You and other collaborators": "您和其他协作者",
                    "with access": "有权限访问",
                    "to this repository": "该仓库",
                    "can still leave comments": "仍然可以发表评论",
                    "that others can see.": "其他人可以看到。",
                "You can always unlock this commit again in the future.": "您可以随时再次解锁此提交。",
            "Unlock conversation": "解锁对话",
                "Unlock conversation on this commit": "解锁关于此提交的对话",
                "Unlocking the conversation means:": "解锁对话意味着：",
                "will be able to comment on this commit once more.": "将能够再次对此提交发表评论。",
                "You can always lock this commit again in the future.": "您可以随时再次锁定此提交。",

                "Reply…": "回复…",

            "commented on": "评论于",
            "Comment on line": "评论行",

            "Paste, drop, or click to add files": "粘贴、拖放或点击添加文件",

            // 隐藏评论
            "Choose a reason for hiding this comment": "选择隐藏此评论原因",
            "The reason will be displayed to describe this comment to others.": "将显示原因，以便向其他人描述此评论。",
                "Choose a reason for hiding this comment": "选择隐藏此评论原因",
                "Unhide": "取消隐藏",
                "comment": "评论",
                "Choose a reason": "选择原因",
                    "Abuse": "滥用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏离主题",
                    "Outdated": "过时",
                    "Duplicate": "重复",
                    "Resolved": "已解决",

            "Subscribe": "订阅",
            "Unsubscribe": "取消订阅",
            "You’re not receiving notifications from this thread.": "您没有收到来自该话题的通知。",
            "You’re receiving notifications because you authored the thread.": "您收到通知是因为您编写了提交。",
            "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因为您订阅了该话题。",
            "You’re receiving notifications because you’re watching this repository.": "您收到通知是因为您关注了该仓库。",

        // 提交 commits 页面 /<user-name>/<repo-name>/commits/<branch> 或 /<user-name>/<repo-name>/commits
            "Commits": "提交",
            "commit": "提交",
            // 快捷键
                "Copy file permalink": "复制文件永久链接",

            "Copy full SHA for": "复制该提交的完整 SHA", // Android UA
            "View commit details": "查看提交详情",
            "Browse the repository at this point in the history": "浏览该阶段的历史仓库内容",

            "Newer": "新的",
            "Older": "旧的",

            // 拉取请求悬浮卡
                "You were mentioned on and commented on this pull request": "您在该请求中被提及并发表了评论",
                "You left a review": "您发表了评论",

            // 议题悬浮卡
                "You commented on this issue": "您对此议题发表了评论",
                "You commented on and opened this issue": "您评论并打开了此议题",

        // /commits?since=<start-date XXXX-XX-XX>&until=<end-date XXXX-XX-XX>&author=<author-name>
            "No commits history": "尚无提交历史记录",
            "There isn't any commit history to show here": "此处没有可显示",
            "for the selected date range": "所选日期范围内的任何提交历史记录",
            "There isn't any commit history to show here for the selected date range": "这里没有显示所选日期范围内的任何提交历史记录",

        // 新版提交 commits 页面 /<user-name>/<repo-name>/commits/<branch> 或 /<user-name>/<repo-name>/commits
            // 用户筛选
                "All users": "所有用户",
                "Find a user...": "寻找一个用户……",
                "View commits for all users": "查看所有用户的提交",
            // 时间筛选
                "All time": "所有时间",
                "Today": "今天",
            "Clear": "清除",
            "Browse repository at this point": "查看此时间点的仓库",
            "View code at this point": "查看此时间点的代码",

            // 日历
                "Su": "一",
                "Mo": "二",
                "Tu": "三",
                "We": "四",
                "Th": "五",
                "Fr": "六",
                "Sa": "日",

            // [/Copy full SHA for ([a-f0-9]{7})/, "复制提交 $1 的完整 SHA"],
            // [/Show description for ([a-f0-9]{7})/, "显示提交 $1 的描述"],
            // [/Hide description for ([a-f0-9]{7})/, "隐藏提交 $1 的描述"],

        // 提交中文件历史 /<user-name>/<repo-name>/commits/<branch>/<file> 或 /<user-name>/<repo-name>/commits/<full SHA>/<file>
            "History for": "历史：",
            "View at this point in the history": "在这一历史节点上查看",

            // [/Renamed from/, "重命名自"], // 提交中文件历史
            "(Browse History)": "（浏览历史）",

        // 提交中文件夹历史 /<user-name>/<repo-name>/commits/<branch>/<folder> 或 /<user-name>/<repo-name>/commits/<full SHA>/<folder>
            "End of commit history for this file": "此文件的提交历史结束",

        // 2/commits?author=maboloshi&since=2021-09-30&until=2021-10-13
            "Seeing something unexpected? Take a look at the": "看到了一些意想不到的东西？请看一下",
            "GitHub commits guide": "GitHub 提交指南",

        // 新版提交页
            "More actions": "更多操作",
            // 具体某条提交
            "authored and": "撰写和",
            "authored": "撰写于",

            // 左侧文件管理器
            "Filter options": "筛选…",
            "Filter files…": "筛选文件…",
                "File extensions": "文件扩展名",
                "No extension": "无扩展名",

            // 中间
            "file": "个文件",
                "s": " ",
                "changed": "更改",

            // 展开/收起文件树按钮
                "Collapse file tree": "收起文件树",
                "Expand file tree": "展开文件树",

            // 展开/收起文件按钮
                "Collapse file": "收起文件",
                "Expand file": "展开文件",
            // 复制文件按钮
                "Copy file name to clipboard": "复制文件名到剪切板",

            "There are no files selected for viewing": "没有更改",

            // 右侧
            "Search within code": "在代码中搜索",
            "Top": "顶部",
            "Open diff view settings": "打开差异视图设置",
                "Layout": "布局",
                    "Hide whitespace": "隐藏空白",
                    "Compact line height": "自定义行高",

                "View comments": "查看评论",
                    "Loading comments": "加载评论中",
                    "Comment on lines": "评论于行",

                "Select all": "全选",
                "Expand above": "向上展开",
                "Expand below": "向下展开",
                "Go to previous hunk": "上一块",
                "Go to next hunk": "下一块",

            "Customizable line height": "自定义行高",
                "The default line height has been increased for improved accessibility. You can choose to enable a more compact line height from the view settings menu.": "默认行高已增加，以提高可访问性。您可以从视图设置菜单中选择启用更紧凑的行高。",
                "Enable compact line height": "启用自定义行高",
                "Dismiss": "禁用",

            // 底部评论
            "Comments": "评论",
            "edited by": "编辑者",
            "Edits": "编辑",
                "Most recent": "最近",
                "Deleted": "已删除",
            "Lock": "锁定",
                "conversation": "对话",
                "Off-topic": "偏离主题",
            "Load more comments": "加载更多评论",
            "Reference in a new issue": "在新议题中提及",
            "Add Files": "添加文件",
            "You're not receiving notifications from this thread.": "您没有收到来自此主题的通知。",
            "You're receiving notifications because you're subscribed to this thread.": "您收到通知是因为您订阅了此主题。",
            "Return to code": "返回代码",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) parents?/, "$1 个父"],
        [/lines? changed/, "行更改"],//新版提交页面
        [/(\d+) changed files?/, "$1 个更改的文件"],
        [/(\d+) changes?: (\d+) additions? & (\d+) deletions?$/, "$1 处更改：$2 处增加和 $3 处删除"],
        [/(\d+) additions?$/, "$1 处增加"],
        [/(\d+) deletions?$/, "$1 处删除"],
        [/This commit closes issue (#\d+)./, "此提交关闭了议题 $1。"], //具体提交页面
        [/from ([^ ]+) to ([^ ]+)/, "从 $1 到 $2。"], //具体提交页面
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "$1 处增加，$2 处删除未显示，因为差异太大。请使用本地 Git 客户端查看这些更改。"],
        [/(\d+) comments? on commit/, "该提交有 $1 条评论"],
        [/Edited (\d+) times?/, "编辑 $1 次"],
        // [/Commits (.+)/, "提交于 $1"], // 提交页面 /<user-name>/<repo-name>/commits/<branch
        [/Renamed from/, "重命名自"], // 提交中文件历史
        [/Copy full SHA for ([a-f0-9]{7})/, "复制提交 $1 的完整 SHA"],
        [/Show description for ([a-f0-9]{7})/, "显示提交 $1 的描述"],
        [/Hide description for ([a-f0-9]{7})/, "隐藏提交 $1 的描述"],
        [/View (\d+) commit comments?/, "查看 $1 条提交评论"], // 新版提交 commits 页面 /<user-name>/<repo-name>/commits/<branch>
        [/View checks?/, "查看检查"], // Android UA
        [/Add a comment on line (L|R)(\d+)/, "在 $1$2 行添加评论"], // 新版提交详情页
        [/Add a comment on lines (L|R)(\d+) to (L|R)(\d+)/, "在 $1$2 行到 $3$4 行上添加评论"],
        [/Start conversation on line (L|R)(\d+)/, "在 $1$2 行开始讨论"], // 新版提交详情页
        [/Expand all lines: ([^ ]+)/, "展开全部：$1"],
        [/Collapse file: ([^ ]+)/, "折叠文件：$1"],
        [/Collapse non-diff lines: ([^ ]+)/, "折叠无差异行：$1"],
        [/(\d+) tags?/, "$1 标签"], // 出现位置：某提交所跨标签数
    ],
    "title": {
        "regexp": [
            [/Commits/, "提交"],
        ],
    },
};

I18N["zh-CN"]["repository/blob"] = { // 仓库 - 浏览代码
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 公共部分
            // 许可证文件 中间栏 顶部 权限信息
                "the": "为：", // 上半句走正则

                // 许可证类型
                    "GNU General Public License v3.0": "GNU 通用公共许可证 v3.0",
                    "GPL-3.0 License": "GPL-3.0 许可证",
                    "AGPL-3.0 License": "AGPL-3.0 许可证",
                    "LGPL-3.0 License": "LGPL-3.0 许可证",
                    "MIT License": "MIT 许可证",
                    "Apache License 2.0": "Apache-2.0 许可证",
                    "OFL-1.1 License": "OFL-1.1 许可证",
                    "0BSD License": "0BSD 许可证",
                    "BSD-3-Clause License": "BSD-3-Clause 许可证",
                    "BSD 3-Clause \"New\" or \"Revised\" License": "BSD-3-Clause 许可证",
                    "CC0-1.0 License": "CC0-1.0 许可证",
                    "WTFPL License": "WTFPL 许可证",
                    "Unknown": "未知",

                // 许可证概述 懒得翻译 O(∩_∩)O哈哈~

                // 许可证范围, 限制, 条件
                    "Permissions": "许可事项",
                    "Limitations": "限制条件",
                        "Commercial use": "商业用途",
                        "Modification": "修改",
                        "Distribution": "分布",
                        "Patent use": "专利使用",
                        "Private use": "私人使用",
                        "Trademark use": "商标使用",
                        "Liability": "责任",
                        "Warranty": "担保",
                        "Disclose source": "开源",
                        "Same license": "相同的许可证",
                    "Conditions": "条件",
                        "License and copyright notice": "许可和版权声明",
                        "State changes": "状态变化",
                        "License and copyright notice for source": "来源许可和版权声明",
                        "Network use is distribution": "网络使用即分发",
                        "Same license (library)": "相同的许可证（库）",
                        "Same license (file)": "相同的许可证（文件）",

                "This is not legal advice.": "这并不是法律建议。",
                "Learn more about repository licenses": "了解更多关于仓库许可证的信息",


        // 文件代码页面 /<user-name>/<repo-name>/blob/<brach>/<file>
            // 顶部提醒
                "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "此提交不属于该仓库上的任何分支，并且可能属于仓库的外部分支。",

            // 快捷键
                "Source code browsing": "源代码浏览",
                    "Jump to line": "跳转到行",
                    "Switch branch/tag": "切换分支/标签",
                    "Expand URL to its canonical form": "将 URL 扩展为其规范形式",
                    "Show/hide all inline notes": "显示/隐藏所有内嵌注释",
                    "Open blame": "打开追溯视图",
                    "Copy file path": "复制文件路径",
                    "Toggle symbols panel": "切换符号面板",
                    "Toggle file tree": "切换文件树",
                    "Open code view": "打开代码视图",
                    "Open preview": "打开预览",
                    "Open raw file": "打开源文件",
                "File tree": "文件树",
                    "Move focus to row starting with string": "将焦点移至字符串",
                    "Focus previous row": "聚焦上一行",
                    "Focus next row": "聚焦下一行",
                    "Collapse row, or focus parent row": "折叠行或聚焦父行",
                    "Expand row, or focus child row": "展开行或聚焦子行",

            // 文件树侧边栏
                "Expand file tree": "展开文件树",
                "Collapse file tree": "折叠文件树",
                // 搜索框
                    "Go to file": "转到文件",
                        "No matches found": "未找到匹配项",
                        "Go to folder": "转到文件夹",
                        "See all results": "查看所有结果",

            // Git LFS 托管的文件
                "Stored with Git LFS": "Git LFS 托管",

            // Action的 action.yml 文件
                "You can publish this Action to the GitHub Marketplace": "您可以将此 Action 发布到 GitHub 市场",
                "Draft a release": "起草发布",
            // 工作流程文件 /blob/<brach>/.github/workflows/xxxx.yml
                "View Runs": "查看运行情况",
            // 议题模板 /blob/<brach>/.github/ISSUE_TEMPLATE/xxxx.yml
                "This file is used as an Issue Form template.": "该文件用作议题表单模板。",
                "Give Feedback.": "提交反馈。",
            // 议题模板 /blob/<brach>/.github/ISSUE_TEMPLATE/xxxx.md
                "info": "信息",
                "This file is used as a markdown issue template.": "该文件用作 Markdown 议题模板。",
            // 添加文件按钮, 文件夹模式下
                "Add file": "添加文件",
            // 三个点
                "Raw file content": "原始文件内容",
                    // "Jump to line": "跳转到行",
                    "Find in file": "在文件中查找", // 激活 “换行” 时显示
                    "Copy path": "复制路径",
                    "Copy permalink": "复制永久链接",
                    "View options": "查看选项",
                        "Show code folding buttons": "显示代码折叠按钮",
                        "Wrap lines": "换行",
                        "Center content": "核心内容",
                        "Open symbols on click": "单击打开符号",
                    "Ask about this file": "讨论此文件",
                    "Delete file": "删除文件",

            "Copied path!": "✅ 路径已复制！",

            "History": "历史",

            "Top": "顶部",
            "Jump to file": "跳转到文件",

            // 正文 - 错误信息，例如某些二进制文件
                "Error rendering embedded code": "嵌入代码渲染错误",
                    "Invalid PDF": "无效 PDF",

            // 代码操作栏
                "Blame": "追溯",
                "Your blame took too long to compute.": "追溯花了太长时间来计算。",
                // [/(\d+) lines? \((\d+) loc\) ·/, "$1 行 ($1 个位置) ·"],
                // Copilot 广告
                    "Code 55% faster with GitHub Copilot": "使用 GitHub Copilot 编码速度提高 55%",
                        "Spend less time creating boilerplate and repetitive code patterns, and more time building great software. Try it in Codespaces or your favorite file editor.": "花更少的时间创建模板和重复的代码模式，花更多的时间构建优秀的软件。在 GitHub 代码空间或您最喜欢的文件编辑器中尝试一下哈。",
                        "Get GitHub Copilot": "获取 GitHub Copilot",
                        "Don't show again": "不再显示",

                "Executable File": "可执行文件",
                "executable file": "可执行文件",

                // Copilot
                "Ask Copilot about this file": "与 Copilot 讨论此文件",

                "Raw": "源码",
                // 文件复制图标
                    "Copy raw file": "复制原始文件",
                    "Copy raw content": "复制原始文件",
                // 文件下载图标
                    "Download raw file": "下载原始文件",
                // 文件编辑图标
                    "More file actions": "更多文件操作",
                    "Edit this file": "编辑本文件",
                        "More edit options": "更多编辑选项",
                            "Edit file...": "编辑文件…",
                            "In place": "就地编辑",
                    "Edit the file in your fork of this project": "在您的复刻中编辑文件",
                        "Edit file": "编辑文件",
                            "Edit in place": "就地编辑",
                        "Open with...": "打开…",
                            "You must be on a branch to make or propose changes to this file": "您必须在分支上才能对该文件进行修改或提出修改建议",

                    // 按钮提示
                    "Fork this repository and edit the file": "复刻此仓库并编辑文件",
                // 符号面板图标
                    "Open symbols panel": "打开符号面板",
                    "Close symbols panel": "关闭符号面板",

            // 代码视图 行号栏 菜单
                "Copy line": "复制行",
                "Copy lines": "复制行",
                "Copy permalink": "复制永久链接",
                "View git blame": "浏览 Git 追溯",
                "Reference in new issue": "引用到新议题",
                "Reference in new discussion": "引用到新讨论",
                "View file in GitHub.dev": "在 GitHub.dev 中查看文件",
                "View file in different branch/tag": "查看不同分支/标签中的文件",

            // 提醒
                "This file contains bidirectional Unicode text that may be interpreted or compiled differently than what appears below. To review, open the file in an editor that reveals hidden Unicode characters.": "此文件包含双向 Unicode 文本，其解释或编译方式可能与下面的显示不同。要查看，请在一个能显示隐藏的 Unicode 字符的编辑器中打开文件。",
                "Learn more about bidirectional Unicode characters": "了解更多关于双向 Unicode 字符的信息",
                "Show hidden characters": "显示隐藏字符",
                "Code view is read-only.": "代码视图只读。",
                    "Switch to the editor.": "切换到编辑器。",

            // 代码视图底部
                "View remainder of file in raw view": "以原码视图查看文件剩余部分",

            // 正文部分
                // 只读模式
                    "Code view is read-only. ": "代码视图是只读的。",
                    "Switch to the editor.": "请切换至编辑器。",
                // csv 文件
                    "Search this file": "搜索这个文件", // csv 文件
                    // 提醒
                        "We can make this file": "如果纠正此错误，我们可以使该文件",
                        "beautiful and searchable": "美观且可搜索",
                        "if this error is corrected: No commas found in this CSV file in line 0.": "：在此 CSV 文件中的第 0 行中找不到逗号。",

                // 大文件
                    "View raw": "查看原始数据",
                    "(Sorry about that, but we can’t show files that are this big right now.)": "（很抱歉，但我们现在无法显示这么大的文件。）",
                // 无法渲染
                    "Sorry, something went wrong.": "抱歉，出了一些问题。",
                    "Reload?": "重新加载？",
                    "Unable to render code block": "无法渲染代码块",

            "More Pages": "更多页面",

            // Markdown 文件右侧大纲面板
                "Outline": "大纲",
                    "Close outline": "关闭大纲",
                    "Filter headings": "筛选标题",

            // 右侧符号面板
                "Symbols": "符号",
                    "Close symbols": "关闭符号面板",
                    "Symbol outline not available for this file": "大纲不适用于此文件",
                    "To inspect a symbol, try clicking on the symbol directly in the code view.": "要检查一个符号，可以尝试在代码视图中直接点击该符号。",
                    "Code navigation supports a limited number of languages.": "代码导航支持有限数量的语言。",
                    "See which languages are supported.": "查看支持哪些语言。",

                    "Find definitions and references for functions and other symbols in this file by clicking a symbol below or in the code.": "通过点击下方或代码中的符号，查找此文件中函数和其他符号的定义和引用。",
                    "Filter symbols": "筛选符号",

                "All Symbols": "所有符号",
                    "Search for this symbol in this repository": "在此仓库中搜索此符号",
                    "all repositories.": "所有仓库。",
                    "In this file": "在这个文件中",
                    "Definition": "定义",
                    "search-based": "基于搜索",
                    "References": "引用",
                    "Reference": "引用",
                    "No definitions or references found": "未找到定义或引用",
                    "Search for this symbol": "搜索此符号",

        // 代码追溯页面 /<user-name>/<repo-name>/blame/<branch>/<file>
            "Newer": "新的",
            "Older": "旧的",

            "Contributor": "贡献者",
            "Contributors": "贡献者",

            // 浮动搜索框
                "Find": "查找",
                "Press": "按",
                "again to open the browser's find menu": "打开浏览器的查找菜单",
                "Search this file": "搜索此文件",

            "Ask Copilot about this snippet": "向 Copilot 询问此片段",
                "Explain": "解释",
                "Suggest improvements": "提出优化建议",
                "Attach to current thread": "附加至当前话题",

    },
    "regexp": [ // 正则翻译
        [/(\d+) lines? \((\d+) loc\) ·/, "$1 行（$2 非空行）·"],  // loc = 代码行（line of code）= 行数 - 空行数（lines - blank lines）
        [/(\d+) References?/, "$1 次引用"],
        [/Blame prior to change ([a-f0-9]{7}), made on ([^ ]+)/, "追溯提交 $1，创建于 $2"],

        // 代码追溯页面
        [/(\d+) contributors?/, "$1 位贡献者"],
        [/(\d+) commits?/, "$1 个提交"],

        // 许可证
        [/([^ ]+) is licensed under/, "$1 的许可证"],

        [/First (\d+) files? shown./, "显示前 $1 个文件。"],

        [/Line (\d+) options/, "行 $1 选项"], // TODO: 修复翻译未生效问题

        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/(.+) at (.+?) · (.+)/, "$1 在分支 $2 · $3"],
        ],
    },
};
I18N["zh-CN"]["repository/blame"] = I18N["zh-CN"]["repository/blob"];

I18N["zh-CN"]["repository/discussions"] = { // 讨论页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["orgs-public"]["static"],

        // 没有任何讨论时
            "Get started with GitHub Discussions": "开始使用 GitHub 讨论",
                "Discussions is a central gathering space for your community to ask questions, share ideas, and build connections with each other—all right next to your code.": "讨论是一个社区成员集中交流的空间，大家可以在这里提问、分享想法，并彼此建立联系——而且这一切都在您的代码旁边完成。",

                "Get Started": "开始使用",
                "Not now": "暂不",

                "Only maintainers can see this page and enable Discussions": "只有维护者能看到此页面并启用讨论",

            // 用法介绍
                // 自定义分类
                    "Create custom categories and discussion types to suit your community's unique needs.": "创建自定义类别和讨论类型，以满足您社区的独特需求。",
                "Mark the most helpful answer": "标记答案",
                    "Highlight quality responses and make the best answer super discoverable.": "突出优质回答，让最佳答案易于被发现。",
                "Pin big announcements": "置顶功能",
                    "Direct the community’s attention to important announcements or popular discussions.": "将社区的关注引导至重要公告或热门讨论。",
                "Label your discussions": "标签功能",
                    "Organize and triage discussions to keep your space tidy and help contributors filter to areas of interest.": "组织和筛选讨论内容，以保持社区空间整洁，并帮助参与者过滤到感兴趣的领域。",
                "Respond on-the-go with mobile": "通过移动端随时响应",
                    "Check in and respond to discussions whenever and wherever is convenient for you.": "随时随地在方便的时候查看并回复讨论。",
                "Connect to your apps": "链接应用",
                    "Integrate with your existing workflows and GitHub Actions via the GraphQL API and webhooks.": "通过 GraphQL API 和 Web 钩子与现有工作流程及 GitHub Actions 集成。",
                "Thread your conversations": "串联对话",
                    "Keep conversations on track and encourage collaboration with threaded comments.": "通过串联评论让对话保持正轨并促进协作。",
                "Monitor community insights": "社区数据看板",
                    "Track the health and growth of your community with a dashboard full of actionable data.": "通过充满可操作数据的仪表盘，追踪社区的健康状况与发展情况。",
                "Ask your community with polls": "社区投票",
                    "Gauge interest in a feature, vote on a meetup time, or learn more about your community with polls.": "通过投票来衡量对某项功能的兴趣、对聚会时间进行表决，或进一步了解您的社区情况。",

            "Communities using Discussions": "使用讨论交流",

            "Ready to try Discussions?": "准备尝试讨论？",
                "Click “get started” to enable it for your community and start your first discussion. Now is not the right time? Click “not now” to dismiss this tab. You can always turn Discussions on in your repository settings later.": "点击 “开始使用” 即可为您的社区启用该功能，并发起您的首次讨论。现在不方便操作？点击 “暂不” 可关闭此标签页。您也可以稍后在仓库设置中随时开启讨论功能。",

            "Read about best practices for setting up Discussions for your community.": "了解为社区设置讨论功能的最佳实践。",
                "Visit the docs": "查看",

        // 讨论页面 /<user-name>/<repo-name>/discussions
        // 组织讨论页 /orgs/<orgs-name>/discussions
            // 顶部提示
                "You can't perform that action at this time.": "您现在不能执行该操作。",

            "Start a new discussion": "开始新的讨论",
            "Get started by creating the first": "开始吧，为您的社区创建",
            "discussion for your community.": "第一个讨论。",
            "Got it": "知道了",

            "About pinned discussions": "关于置顶讨论",
            "When you start a discussion,": "当您开始讨论时，",
            "you can choose to feature it": "您可以选择将",
            "here by pinning it.": "其置顶在此处。",

            "Personalize your categories": "自定义您的分类",
            "Choose categories that fit your community. These could be announcements, Q&A with marked answers, open-ended conversations, or polls for community voting.": "选择适合您社区的类别。这些可以是公告、带有标记答案的问答、开放式对话或用于调查的社区投票。",

            "Welcome to discussions!": "欢迎参与讨论！",
            "Discussions are to share announcements, create conversation in your community, answer questions, and more.": "讨论是为了分享公告，在您的社区创造对话，回答问题，以及更多。",
            "Discussions are to share announcements, create conversation in your community, answer questions, and more. To get started, you can create a": "讨论是为了分享公告，在您的社区创造对话，回答问题，以及更多。首先，您可以创建一个",

            // 组织讨论
            "Welcome to Organization Discussions!": "欢迎参与组织讨论！",
            "There are no discussions here yet": "这里还没有讨论",
            "Organization discussions are to broadcast news, create conversation in your community, answer questions, and share ideas. To get started, you can": "组织讨论是为了广播新闻，在您的社区创造对话，回答问题，并分享想法。要开始，您可以",
            "create a new discussion.": "创建新的讨论。",

            // 左侧栏
            "Submit search": "提交搜索",
            "Search all discussions": "搜索所有讨论",
            "Suggested filters": "推荐的筛选器",
            "filter by discussion author": "按讨论作者筛选",
            "filter by discussion category": "按讨论分类筛选",
            "filter by answered or unanswered": "按已答复或未答复筛选",

            "Categories": "分类",
            "View all discussions": "查看全部讨论", // 组织讨论
            "View all": "查看全部", // 仓库讨论

            "Most helpful": "最有帮助",
                "Be sure to mark someone’s comment as an answer if it helps you resolve your question — they deserve the credit!": "如果某人的评论有助于您解决问题，请务必将其标记为答案——他们值得称赞！",
            "Last 30 days": "最近 30 天",
            "Community guidelines": "社区指南",
            "Community insights": "社区见解",

            //
            "Sort by:": "排序方式：",
                "Latest activity": "最新活动",
                "Date created": "创建日期",
                "Top: Past week": "置顶：过去一周",
                "Top: Past month": "置顶：过去一月",
                "Top: Past day": "置顶：过去一天",
                "Top: Past year": "置顶：过去一年",
                "Top: All": "置顶：所有",
            "Label": "标签",
                "Filter by label": "按标签筛选",
                "Filter labels": "筛选标签",
                "Unlabeled": "无标签",

                "bug": "BUG",
                    "Something isn't working": "有些东西不工作",
                "dependencies": "依赖性",
                    "Pull requests that update a dependency file": "更新一个依赖文件的拉取请求",
                "documentation": "文档",
                    "Improvements or additions to documentation": "文档的改进或补充",
                "duplicate": "重复",
                    "This issue or pull request already exists": "这个议题或拉取请求已经存在",
                "enhancement": "增强",
                    "New feature or request": "新功能或请求",
                "good first issue": "好的首发议题",
                    "Good for newcomers": "适合新人",
                "help wanted": "需要帮助",
                    "Extra attention is needed": "需要特别关注",
                "invalid": "无效",
                    "This doesn't seem right": "这似乎不对",
                "question": "问题",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不会修复",
                    "This will not be worked on": "这将不会被处理",

                "Edit labels": "编辑标签",
            "Filter": "筛选",
            "Filter:": "筛选:",
                "Closed": "已关闭",
                "Answered": "已答复",
                "Unanswered": "未答复",
                "Locked": "锁定",
                "Unlocked": "未锁定",
                "All": "所有",

            "New discussion": "新建讨论",

            "There aren't any discussions.": "暂无任何讨论。",
            "There are no matching discussions.": "没有匹配的讨论。",
            "There are no matching answered discussions.": "没有匹配的已答复讨论。",
            "There are no matching unanswered discussions.": "没有匹配的未答复讨论。",
            "You can open a": "您可以打开一个",
            "new discussion": "新讨论",
            "to ask questions about this repository or get help.": "，询问关于这个仓库的问题或获得帮助。",

            "asked": "回复",
            "started": "开始于",
            "· Unanswered": " · 未答复",
            "· Answered": " · 已答复",

            // 下拉补充
            "Use": "使用",
            "click/return": "点击/回车",
            "to exclude labels.": "去排除标签。",

            // 状态词
            "asked a question in": "提出了一个问题在",
            "Unanswered Question": "未解答的问题",
            "announced": "公布于",
            "in": "在",

        // 讨论分类 /<user-name>/<repo-name>/discussions/categories
            "Manage discussion categories": "管理讨论分类",
                "Sections are a dropdown of categories. Categories have types of discussions, and discussions within them.": "本栏目是类别的下拉菜单。类别中包含讨论类型和讨论内容。",
            // [/(\d+) categories?/, "$1 个分类"],
            "Categories without section": "无栏目分类",
            "Announcements": "公告",
                "Updates from maintainers": "维护者的更新信息",
            "General": "通常",
                "Chat about anything and everything here": "在这里谈论任何事情",
            "Ideas": "想法",
                "Share ideas for new features": "分享对新功能的想法",
            "Polls": "投票",
                "Take a vote from the community": "社区中进行投票",
            "Q&A": "问答",
                "Ask the community for help": "向社会寻求帮助",
                "Answers enabled": "已启用答案",
            "Show and tell": "展示与讲述",
                "Show off something you've made": "炫耀您所做的事情",

            "New section": "新建栏目",
            "New category": "新建分类",

            "Edit Announcements category": "编辑 “公告” 分类",
            "Edit General category": "编辑 “通常” 分类",
            "Edit Ideas category": "编辑 “想法” 分类",
            "Edit Polls category": "编辑 “投票” 分类",
            "Edit Q&A category": "编辑 “问与答” 分类",
            "Edit Show and tell category": "编辑 “展示与讲述” 分类",

            "Delete Announcements category": "删除 “公告” 分类",
            "Delete General category": "删除 “通常” 分类",
            "Delete Ideas category": "删除 “想法” 分类",
            "Delete Polls category": "删除 “投票” 分类",
            "Delete Q&A category": "删除 “问与答” 分类",
            "Delete Show and tell category": "删除 “展示与讲述” 分类",

            // 删除分类
                "If this category has discussions associated, where would you like to reassign them?": "如果此类别有相关的讨论，您希望将它们重新分配到何处？",
                "Delete and move": "删除并移动",

            // 删除栏目
                // [/Delete (.*) section/, "删除 “$1” 栏目"],
                "Are you sure you want to delete this section? All categories in this section will no longer belong to a section.": "您确定要删除此栏目吗？此栏目中的所有分类将不再属于一个栏目。",

        // 新建 & 编辑 分类 /<user-name>/<repo-name>/discussions/categories/new
        // /<user-name>/<repo-name>/discussions/categories/<id>/edit
            "Create category": "创建分类",
            "Edit category": "编辑分类",
            "Category name": "分类名称",
            "Description": "描述",
            "Add a description (optional)": "添加描述（可选）",
            "Discussion Format": "讨论形式",
                "Open-ended discussion": "开放式讨论",
                    "Enable your community to have conversations that don't require a definitive answer to a question. Great for sharing tips and tricks or just chatting.": "使您的社区能够进行对话，不需要对问题作出明确的回答。很适合分享技巧和窍门，或者只是聊天。",
                "Question / Answer": "问 / 答",
                    "Enable your community to ask questions, suggest answers, and vote on the best suggested answer.": "使您的社区能够提出问题、建议答案并投票选出最佳建议答案。",
                "Announcement": "公告",
                    "Share updates and news with your community. Only maintainers and admins can post new discussions in these categories, but anyone can comment and reply.": "与您的社区分享更新和新闻。只有维护者和管理员可以在这些类别中发布新讨论，但任何人都可以发表评论和回复。",
                "Poll": "投票",
                    "Gauge interest, vote, and interact with other community members using polls.": "调查兴趣，投票，并使用投票与其他社区成员互动。",
                    "Cannot be changed to polls. Please create a new category for polls.": "不能更改为投票。请为投票创建一个新类别。",
            "Add this category to a section (optional)": "将此分类添加到一个栏目（可选）",
                "No section": "无栏目",

            "Submitting": "提交中",

            // 顶部提醒
                "Category Announcements has been created.": "分类 “公告” 已创建",
                "Category General has been created.": "分类 “通常” 已创建",
                "Category Ideas has been created.": "分类 “想法” 已创建",
                "Category Polls has been created.": "分类 “投票” 已创建",
                "Category Q&A has been created.": "分类 “问与答” 已创建",
                "Category Show and tell has been created.": "分类 “展示与讲述” 已创建",

                "Category Announcements has been updated.": "分类 “公告” 已更新",
                "Category General has been updated.": "分类 “通常” 已更新",
                "Category Ideas has been updated.": "分类 “想法” 已更新",
                "Category Polls has been updated.": "分类 “投票” 已更新",
                "Category Q&A has been updated.": "分类 “问与答” 已更新",
                "Category Show and tell has been updated.": "分类 “展示与讲述” 已更新",

                "Category Announcements has been deleted.": "分类 “公告” 已删除",
                "Category General has been deleted.": "分类 “通常” 已删除",
                "Category Ideas has been deleted.": "分类 “想法” 已删除",
                "Category Polls has been deleted.": "分类 “投票” 已删除",
                "Category Q&A has been deleted.": "分类 “问与答” 已删除",
                "Category Show and tell has been deleted.": "分类 “展示与讲述” 已删除",

                // [/Category \"(.*)\" has been created./, "分类 “$1” 已创建。"],
                // [/Category \"(.*)\" has been updated./, "分类 “$1” 已更新。"],
                // [/Category \"(.*)\" has been deleted./, "分类 “$1” 已删除。"],

        // 新建 & 编辑栏目 /<user-name>/<repo-name>/discussions/sections/new
            "Create section": "创建栏目",
            "Section name": "栏目名称",
            "Add categories to this section": "向栏目添加分类",
            "A category can only belong to one section at a time.": "一个分类一次只能属于一个栏目。",

            // 顶部提醒
                // [/Section \"(.*)\" has been created./, "栏目 “$1” 已创建。"],
                // [/Section \"(.*)\" has been updated./, "栏目 “$1” 已更新。"],
                // [/Section \"(.*)\" has been deleted./, "栏目 “$1” 已删除。"],

        // 新建讨论页面 /<user-name>/<repo-name>/discussions/new
            "Start a new discussion": "开始新的讨论",
            "Select a discussion category": "选择讨论分类",
            "Get started": "开始",
            "Category:": "分类：",
            "Contributing": "贡献",
            "It looks like this is your first time starting a discussion in this repository!": "看起来这是您第一次在此仓库中开始讨论！",
            "This is a community we build together. Please be welcoming and open minded.": "这是我们共同建立的社区。请保持热情和开放的态度。",

            // 投票类
            "Poll question": "投票问题",
            "Ask your question here (required)": "在此提出您的问题（必填）。",
            "Poll options": "投票选项",
            "Option 1 (required)": "选项 1（必填）",
            "Option 2 (required)": "选项 2（必填）",
            "Option": "选项",
            "+ Add an option": "+ 增加选项",

            // 右侧栏
            "Labels": "标签",
                "None yet": "暂无",
            "Helpful resources": "帮助性资源",
            "Code of conduct": "行为准则",
            "Security policy": "安全政策",
            "Support": "支持",
            "GitHub Community Guidelines": "GitHub 社区准则",

            "Ask a question, start a conversation, or make an announcement": "提出问题、开始对话或发布公告",

        // 新建讨论页面 /<user-name>/<repo-name>/discussions/new?category=general
            "If this doesn’t look right you can": "如果这个看起来不对，您可以",
            "choose a different category.": "选择不同的类别。",
            "Fields marked with an asterisk (*) are required.": "标有星号（*）的字段是必填字段。",
            "Discussion title": "讨论标题",

        // 新建讨论页面 /<user-name>/<repo-name>/discussions/new?category=announcements&welcome_text=true
            "Since you're new here, we're helping you to get started by generating your first post to the community. Don't worry, you can edit this discussion after you post!": "由于您是新来的，我们正在帮助您开始向社区发布您的第一个帖子。不用担心，您可以在发布后编辑此讨论！",

        // 某个讨论页面 /<user-name>/<repo-name>/discussions/<id>
            // [/Congratulations, you've created the first discussion in ([^ ]+)!/, "恭喜您，您已经在 $1 中创建了第一个讨论!"],

            // 顶部提醒
                "Discussion has successfully been pinned.": "讨论已成功置顶。",
                "Discussion has been unpinned.": "讨论已取消置顶。",
                "Discussion pinned to Announcements": "在 “公告” 上置顶讨论",
                "Discussion pinned to General": "在 “通常” 上置顶讨论",
                "Discussion pinned to Ideas": "在 “想法” 上置顶讨论",
                "Discussion pinned to Polls": "在 “投票” 上置顶讨论",
                "Discussion pinned to Q&A": "在 “问与答” 上置顶讨论",
                "Discussion pinned to Show and tell": "在 “展示与讲述” 上置顶讨论",
                "Discussion unpinned from Announcements": "取消在 “公告” 上置顶讨论",
                "Discussion unpinned from General": "取消在 “通常” 上置顶讨论",
                "Discussion unpinned from Ideas": "取消在 “想法” 上置顶讨论",
                "Discussion unpinned from Polls": "取消在 “投票” 上置顶讨论",
                "Discussion unpinned from Q&A": "取消在 “问与答” 上置顶讨论",
                "Discussion unpinned from Show and tell": "取消在 “展示与讲述” 上置顶讨论",

            "Pinned": "已置顶",

            "announced in": "宣布于",
            "started this conversation in": "开始了这次讨论，在",
            "asked this question in": "提出了这个问题，在",
            "Maintainer": "维护者",
            "Sponsor": "赞助者",
            "Discussion options": "讨论选项",
            "Category": "分类",

            "You are a maintainer on this repository.": "您是这个仓库的维护者。",
            "You are the author of this discussion.": "您是这个讨论的作者。",

            // [/(\d+) answers?/, "$1 位答复者"],
            "Return to top": "返回顶部",
            // [/(\d+) comments?/, "$1 条评论"],
            // [/(\d+) replies?/, "$1 条答复"],
            // [/(\d+) suggested answer/, "$1 个建议答案"],

            "Answered by": "答复者：",
            "View full answer": "查看完整答案",
            "Oldest": "最早",
            "Newest": "最新",
            "Top": "置顶",
            "Comment options": "评论选项",


            "Events": "活动",
            "Marked": "标记为",
            "an": "一个",
            "Marked then unmarked an answer": "标记后，又取消标记",
            "Marked as answer": "标记为答案",
            "Mark as answer": "标记为答案",
            "Answer selected by": "被标记答案由",
            "Unmark as answer": "取消标记为答案",
            "Answer": "答案",

            "This comment has been minimized.": "此评论被最小化。",
            "This comment was marked as off-topic.": "此评论被标记为偏离主题。",
            "Show comment": "显示评论",
            "Hide comment": "隐藏评论",

            // 隐藏评论对话框
                "The reason will be displayed to describe this comment to others.": "将显示原因，以便向其他人描述此评论。",
                "Learn more about hiding a comment": "了解更多关于隐藏评论的信息",
                "Choose a reason for hiding this comment": "选择隐藏此评论原因",
                "Unhide": "取消隐藏",
                "Choose a reason": "选择原因",
                    "Abuse": "滥用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏离主题",
                    "Outdated": "过时",
                    "Duplicate": "重复",
                    "Resolved": "已解决",

            // 取消隐藏评论
                "Unhide": "取消隐藏",
                "Unhide comment": "取消隐藏评论",
                "Are you sure you want to unhide this comment?": "您确定要取消隐藏此评论吗？",

            // [/Show (\d+) previous repl(y|ies)/, "显示 $1 条之前的答复"],
            // [/(\d+) hidden items?/, "$1 条隐藏项目"],

            "Loading more replies...": "载入更多回复中…",

            "Remember, contributions to this repository should follow its": "请记住，对该仓库的贡献应遵循",
            "Remember, contributions to this repository should follow our": "请记住，对该仓库的贡献应遵循我们的",
            "code of conduct": "行为准则",
            "contributing guidelines": "贡献准则",

            // [/(\d+) new suggested answers?/, "$1 个新的建议答案"],
            "Answer selected": "已选择答案",

            // 右侧栏
            // /([\d,]+) participants?/, "$1 位参与者"
            "and others": "和其它",
            "Reopened": "重新打开",
            "Closed as resolved": "关闭为已解决",

            "Change category": "更改类别",
            "Converted from issue": "由议题转化而来",
                // [/This discussion was converted from issue/, "本讨论由以下议题转换而来"],

            "Notifications": "通知类型",
                "Subscribe": "订阅",
                "Unsubscribe": "退订",
                "You’re not receiving notifications from this thread.": "您没有收到来自该话题的通知。",
                "You’re receiving notifications because you’re watching this repository.": "您收到通知是因为您正在关注此仓库。",
                "You’re receiving notifications because you authored the thread.": "您收到通知是因为您提出了该话题。",
                "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因为您订阅了该话题。",
                "You’re receiving notifications because you were mentioned.": "您收到通知是因为有人 @您。",
                "You’re receiving notifications because you commented.": "您收到通知是因为您发表了评论。",
                "You’re receiving notifications because you are watching pull requests on this repository.": "您收到通知是因为您正在关注此仓库上的拉取请求。",
                "You’re receiving notifications because you are watching issues on this repository.": "您收到通知是因为您正在关注此仓库上的议题。",
                "You’re receiving notifications because you modified the open/close state.": "您收到通知是因为您修改了打开/关闭状态。",
                "You’re ignoring this repository.": "您忽略了这个仓库。",

            // 锁定对话
            "Lock conversation": "锁定对话",
                "Are you sure you want to lock conversation on this discussion?": "您确定要锁定此讨论的对话吗？",
                "Other users": "其他用户",
                "can’t add new comments": "无法添加新评论",
                "to this discussion.": "到该讨论。",
                "You and other collaborators": "您和其他协作者",
                "with access": "具有访问权限",
                "to this repository": "该仓库",
                "can still leave comments": "仍然可以留下评论",
                "that others can see.": "，其他人可以看到。",
                "You can always unlock this discussion again in the future.": "您今后仍可以随时再次解锁此讨论。",
                "This conversation has been locked and limited to collaborators.": "此对话已锁定，仅协作者可评论。",
            "Unlock conversation": "解锁对话",
                "Are you sure you want to unlock conversation on this discussion?": "您确定要解锁此讨论的对话吗？",
                "Everyone": "任何人",
                "will be able to comment on this discussion once more.": "将能够再次对这个讨论发表评论。",
                "You can always lock this discussion again in the future.": "您今后仍可以随时再次锁定此讨论。",
            "Transfer this discussion": "转移讨论",
                // 转移议题 对话框
                "Results are limited to top repositories, search to find more.": "结果仅限于置顶仓库，请搜索以查找更多信息。",
                "Move this discussion to another repository owned by": "将此讨论移至另一个拥有的仓库由",
                "Move this discussion to another repository you own.": "将此讨论移至您拥有的另一个仓库。",
                "Search repositories": "搜索仓库",
                "There aren't any eligible repositories that match your query.": "没有任何符合条件的仓库与您的查询匹配。",
                "There aren't any eligible repositories to transfer this discussion to.": "没有任何符合条件的仓库可以将此讨论转移到其他仓库。",
                "Transfer discussion": "转移讨论",
            "Pin discussion": "置顶讨论",
                "You can pin up to 4 discussions. They will appear publicly at the top of the discussions page.": "您最多可以置顶 4 个讨论。它们将公开显示在讨论页面的顶部。",
                "Configure pinned discussion": "设置置顶讨论",
                    "Background": "背景色",
                    "Pattern": "图案",
                "Pinning discussion…": "置顶讨论…",
            "Edit pinned discussion": "编辑置顶讨论",
            "Unpin discussion": "取消置顶讨论",
                "Are you sure you want to unpin this discussion?": "您确定要取消置顶讨论吗？",
                "The discussion itself won't be deleted, it just won't be shown prominently above the list of discussions.": "讨论本身不会被删除，只是不会突出显示在讨论列表上方。",
                // 顶部提醒
                // [/Discussion \"([^ ]+)\" has been unpinned./, "讨论 “$1” 已取消置顶。"],
            "Pin discussion to Announcements": "将讨论置顶到 “公告”",
                "Pin this discussion to this category": "将此讨论置顶到此类别",
                    "This will pin this discussion to the top of the Announcements category.": "这将此讨论置顶到 “公告” 类别顶部。",
                    "Pin to Announcements": "置顶到 “公告”",
            "Pin discussion to General": "将讨论置顶到 “通常”",
                    "This will pin this discussion to the top of the General category.": "这将此讨论置顶到 “通常” 类别顶部。",
                    "Pin to General": "置顶到 “通常”",
            "Pin discussion to Ideas": "将讨论置顶到 “想法”",
                    "This will pin this discussion to the top of the Ideas category.": "这将此讨论置顶到 “想法” 类别顶部。",
                    "Pin to Ideas": "置顶到 “想法”",
            "Pin discussion to Polls": "将讨论置顶到 “投票”",
                    "This will pin this discussion to the top of the Polls category.": "这将此讨论置顶到 “投票” 类别顶部。",
                    "Pin to Polls": "置顶到 “投票”",
            "Pin discussion to Q&A": "将讨论置顶到 “问与答”",
                    "This will pin this discussion to the top of the Q&A category.": "这将此讨论置顶到 “问与答” 类别顶部。",
                    "Pin to Q&A": "置顶到 “问与答”",
            "Pin discussion to Show and tell": "将讨论置顶到 “展示与讲述”",
                    "This will pin this discussion to the top of the Show and tell category.": "这将此讨论置顶到 “展示与讲述” 类别顶部。",
                    "Pin to Show and tell": "置顶到 “展示与讲述”",
            "Unpin discussion from this category": "从此类别取消置顶",
                "Are you sure you want to unpin this discussion from Announcements?": "您确定要从 “公告” 中取消置顶此讨论吗？",
                "Are you sure you want to unpin this discussion from General?": "您确定要从 “通常” 中取消置顶此讨论吗？",
                "Are you sure you want to unpin this discussion from Ideas?": "您确定要从 “想法” 中取消置顶此讨论吗？",
                "Are you sure you want to unpin this discussion from Polls?": "您确定要从 “投票” 中取消置顶此讨论吗？",
                "Are you sure you want to unpin this discussion from Q&A?": "您确定要从 “问与答” 中取消置顶此讨论吗？",
                "Are you sure you want to unpin this discussion from Show and tell?": "您确定要从 “展示与讲述” 中取消置顶此讨论吗？",
                "The discussion itself won't be deleted, it just won't be shown at the top of this category.": "讨论本身不会被删除，只是不会显示在该类别的顶部。",
            "Create issue from discussion": "从讨论中创建议题",
            "Delete discussion": "删除讨论",
                "Delete discussion?": "删除讨论？",
                "The discussion will be deleted permanently. You will not be able to restore the discussion or its comments.": "该讨论将被永久删除。您将无法恢复该讨论或其评论。",
                "Deleting discussion…": "正在删除讨论…",
                // 顶部提醒
                "The discussion was successfully deleted.": "该讨论已成功删除。",

            "The original post will be copied into a new issue, and the discussion will remain active.": "原帖将被复制到一个新的议题中，讨论将保持活跃。",
            "OK, got it!": "好的，我知道了！",

            // 评论删除对话框
                "Delete comment": "删除评论",
                "Are you sure you want to delete this comment?": "您确定要删除这条评论吗？",

            // 底部提示栏 (未登录)
                "Sign up for free": "免费注册",
                "to join this conversation on GitHub": "加入 GitHub 上的这个讨论",
                ". Already have an account?": "。已经有账户？",
                "Sign in to comment": "登录后发表评论",

        // 转移议题到讨论 /<user-name>/<repo-name>discussions/<id>?converting=<讨论id>
            "This discussion is being migrated": "此讨论正在迁移",
                "The issue and any comments are still being copied to this discussion thread, please check back later.": "该议题和所有评论仍在复制到此讨论话题中，请稍后查看",
                "Refresh": "刷新",

        // /<user-name>/community/discussions
            // [/This is a ✨special✨ repository containing the organization level discussions for ([^ ]+). Everything posted here will also be visible at the organization level./, "这是一个 ✨ 特别的 ✨ 仓库，包含 $1 的组织层面的讨论。这里发布的所有内容在组织层面上也是可见的。"],
            "View organization discussions": "查看组织讨论",

        // 标签浮动文本
            "This user is a collaborator on this repository.": "该用户是此仓库的协作者。",
            "This user is a maintainer on this repository.": "该用户是此仓库的维护者。",
            "This user is the author of this discussion.": "该用户是此讨论的作者。",

        // 开始讨论按钮上方小字
            "I have done a": "我已", // 与下条二选一展示
            "Reminder to": "记得", // 同上
            "search for similar discussions": "搜索相似话题先",

        // 评论框编辑
            "Edited": "编辑于",
            "'s edit": " 编辑",
        // 反应相关
            "You can't vote on a locked discussion": "您不能在锁定讨论投票",
            "Uh oh! You can't vote right now.": "哎呀！您现在不能投票。",

        // 投票
            "Show Results": "显示结果",
            "Hide Results": "隐藏结果",
            "Vote": "投票",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) categories?/, "$1 个分类"],
        [/Congratulations, you've created the first discussion in ([^ ]+)!/, "恭喜您，您已经在 $1 中创建了第一个讨论!"],
        [/(\d+) answers?/, "$1 位答复者"],
        [/(\d+) comments?/, "$1 条评论"],
        [/(\d+) repl(y|ies)/, "$1 条答复"],
        [/(\d+) suggested answers?/, "$1 个建议答案"],
        [/(\d+) participants?/, "$1 位参与者"],
        [/Show (\d+) previous repl(y|ies)/, "显示 $1 条之前的答复"],
        [/(\d+) hidden items?/, "$1 条隐藏项目"],
        [/Discussion \"([^ ]+)\" has been unpinned./, "讨论 “$1” 已取消置顶。"],
        [/Edited (\d+) times?/,"编辑 $1 次"], //评论框编辑次数
        [/edited by ([^ ]+)/,"被 $1 编辑"], //评论框 被他人编辑
        [/This is a ✨special✨ repository containing the organization level discussions for ([^ ]+). Everything posted here will also be visible at the organization level./, "这是一个 ✨ 特别的 ✨ 仓库，包含 $1 的组织层面的讨论。这里发布的所有内容在组织层面上也是可见的。"],
        [/Category \"(.*)\" has been created./, "分类 “$1” 已创建。"],
        [/Category \"(.*)\" has been updated./, "分类 “$1” 已更新。"],
        [/Category \"(.*)\" has been deleted./, "分类 “$1” 已删除。"],
        [/Section \"(.*)\" has been created./, "栏目 “$1” 已创建。"],
        [/Section \"(.*)\" has been updated./, "栏目 “$1” 已更新。"],
        [/Section \"(.*)\" has been deleted./, "栏目 “$1” 已删除。"],
        [/Edit (.*) category/, "编辑 “$1” 分类"],
        [/Delete (.*) category/, "删除分类 “$1”"],
        [/Edit section (.*)/, "编辑栏目 “$1”"],
        [/Delete section (.*)/, "删除栏目 “$1”"],
        [/Delete (.*) section/, "删除 “$1” 栏目"],
        [/(\d+) new suggested answers?/, "$1 个新的建议答案"],
        [/This discussion was converted from issue (#\d+) on (.+)/, "本讨论由以下议题转换而来：$1 ，$2"],
        [/(\d+) new comments?/, "$1 条新评论"],
        [/Show (\d+) more repl(y|ies)/, "显示剩余 $1 条答复"],
        [/(\d+) new/, "$1 新"],
        [/Filter:\s*(Open|Closed|Locked|Unlocked|Answered|Unanswered)(?:,\s*(Open|Closed|Locked|Unlocked|Answered|Unanswered))*\s*/, function (all, stat) {
            var statKey = {Open: '打开', Closed: '关闭', Locked: '锁定', Unlocked: '未锁定', Answered: '已答复', Unanswered: '未答复', " ,": "，"};

            return '筛选：' + statKey[stat];
        }],
        [/This user is sponsoring ([^ ]+)./, "该用户正在赞助 $1。"],
        [/(\d+) votes?/, "$1 投票"],
    ],
    "title": {
        "regexp": [
            [/Discussions/, "讨论"],
            [/New Discussion · (.+) · Category selection/, "新讨论 · $1 · 分类选择"],
        ],
    },
};
I18N["zh-CN"]["repository/orgs/discussions"] = I18N["zh-CN"]["repository/discussions"] ;

I18N["zh-CN"]["repository/actions"] = { // 仓库 - 操作页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 顶部提示
            "Actions Enabled.": "操作已启用。",

        // 复刻仓库操作页面提示
            "Workflows aren’t being run on this forked repository": "这个分支仓库并未运行任何工作流程。",
            "Workflows aren't being run on this forked repository": "这个分支仓库并未运行任何工作流程。",
            "Because this repository contained workflow files when it was forked, we have disabled them from running on this fork. Make sure you understand the configured workflows and their expected usage before enabling Actions on this repository.": "因为这个仓库在被分支时含有工作流文件，我们已禁止在此分支上运行它们。在开启此仓库的操作之前，请务必理解配置的工作流程及其预期的使用方式。",
            "Because this repository contained workflow files when it was forked, we have disabled them from running on this fork. Make sure you understand the configured workflows and their expected usage before enabling Actions on this repository. Some GitHub features that depend on Actions may still be able to run.": "因为这个仓库在被分支时含有工作流文件，我们已禁止在此分支上运行它们。在开启此仓库的操作之前，请务必理解配置的工作流程及其预期的使用方式。一些依赖于 Actions 的 GitHub 功能可能可以运行。",
            "I understand my workflows, go ahead and enable them": "我已理解我的工作流程，可以放心启用它们。",
            "View the workflows directory": "查看工作流程目录",

        //无工作流程
            "There are no workflow runs yet.": "无工作流程运行。",

        // 新建操作 /<user-name>/<repo-name>/actions/new
            "Get started with GitHub Actions": "开始使用 GitHub Actions",
            "Choose a workflow": "选择工作流程",
            "Build, test, and deploy your code. Make code reviews, branch management, and issue triaging work the way you want. Select a workflow to get started.": "构建、测试和部署您的代码。以您想要的方式进行代码审查、分支管理和议题分类。选择一个工作流以开始使用。",
            "Skip this and": "跳过并",
            "set up a workflow yourself": "建立工作流程",
            "Search workflows": "搜索工作流",

            "Suggested for this repository": "建议该仓库采用",
            "Categories": "类别",
            "Configure": "设置",
            "Deployment": "部署",
            "Continuous integration": "持续集成",
            "Automation": "自动化",
            "Browse all categories": "浏览所有类别",
                "Code scanning": "代码扫描",
            "View all": "查看全部",

            "Learn more about GitHub Actions": "了解更多关于 GitHub Actions 的信息",
            "Getting started and core concepts": "入门和核心概念",
            "New to Actions? Start here. Learn the core concepts and how to get started.": "初次接触 Actions？从这里开始。了解核心概念和如何开始。",
            "Configuring and managing workflows": "配置和管理工作流程",
            "Create custom workflows to control your project's life cycle processes.": "创建自定义工作流程以控制项目的生命周期过程。",
            "Language and framework guides": "语言与框架指南",
            "Guides for projects written in many programming languages.": "项目指南由多种编程语言编写。",

            "Didn't find what you're looking for?": "没有找到您需要的？",
            "Fill out a 2-minute survey to request a new workflow template for GitHub Actions." :"填写一份 2 分钟的调查，为 GitHub Actions 申请一个新的工作流模板。",
            "Request": "申请",

        // 新建操作 /<user-name>/<repo-name>/actions/new?category=xxxx
            // [/Found (\d+) workflows?/, "发现 $1 个工作流程"],

        // 操作 /<user-name>/<repo-name>/actions
            // 快捷键
                "Go to usage": "跳转到运用",
                "Go to workflow file": "跳转到工作流程文件", // /actions/runs/<id>
                "Toggle timestamps in logs": "切换日志中的时间戳",
                "Toggle fullscreen logs": "切换全屏日志",
                "Exit fullscreen logs": "退出全屏日志",
                "Actions main view search bar": "操作主视图搜索栏",

            "Automate your workflow from idea to production": "从创意到产品，使您的工作流程自动化",
            "GitHub Actions makes it easy to automate all your software workflows, now with world-class CI/CD. Build, test, and deploy your code right from GitHub.": "GitHub Actions 现在可以使用世界一流的 CI/CD 轻松自动化所有软件工作流程。直接从 GitHub 构建、测试和部署您的代码。",
            "Learn more about getting started with Actions.": "了解更多关于开始使用 GitHub Actions 的信息。",
            "Linux, macOS, Windows, ARM, and containers": "Linux、macOS、Windows、ARM 和容器",
            "Hosted runners for every major OS make it easy to build and test all your projects. Run directly on a VM or inside a container. Use your own VMs, in the cloud or on-prem, with self-hosted runners.": "为每一个主要的操作系统提供的托管运行程序，使您能够轻松地构建和测试您的所有项目。直接在虚拟机上或容器内运行。在云端或本地使用您自己的虚拟机，以及自托管的运行器。",

            "Matrix builds": "矩阵式构建",
            "Save time with matrix workflows that simultaneously test across multiple operating systems and versions of your runtime.": "使用矩阵工作流程可同时跨多个操作系统和版本运行，节省时间",

            "Any language": "任何语言",
            "GitHub Actions supports Node.js, Python, Java, Ruby, PHP, Go, Rust, .NET, and more. Build, test, and deploy applications in your language of choice.": "GitHub Actions 支持 Node.js、Python、Java、Ruby、PHP、Go、Rust、.NET 等。以您选择的语言构建、测试和部署应用。",

            "Live logs": "实时日志",
            "See your workflow run in realtime with color and emoji. It’s one click to copy a link that highlights a specific line number to share a CI/CD failure.": "使用颜色和表情符号实时查看您的工作流程。只需单击即可复制突出显示特定行号的链接以共享 CI/CD 故障。",

            "Built-in secret store": "内置的机密存储",
            "Automate your software development practices with workflow files embracing the Git flow by codifying it in your repository.": "通过将工作流程文件编码到您的仓库，您的软件开发实践，包括 Git 流程自动化。",

            "Multi-container testing": "多容器测试",
            "Test your web service and its DB in your workflow by simply adding some": "在您的工作流程中测试您的网络服务和它的数据库，只需添加一些",
            "docker-compose": "docker-组合",
            "to your workflow file.": "到您的工作流程文件。",

            // 左侧栏
                "New workflow": "新建工作流程",
                "Management": "管理",
                    "Caches": "缓存",
                    "Deployments": "部署",
                    "Attestations": "证书",
                    "Runners": "运行器",
                    "Usage metrics": "使用情况",
                    "Performance metrics": "数据看板",
                "Disabled": "已禁用",

                // 顶部提醒
                    // [/Workflow (.*) pinned./, "工作流程 $1 已置顶"],
                    // [/Workflow (.*) unpinned./, "工作流程 $1 已取消置顶"],

                // 取消置顶对话框
                    "Unpin this workflow?": "取消工作流程置顶？",
                        "This action will unpin the workflow for all viewers of this repository.": "此操作将为该仓库的所有查看者取消置顶工作流程。",
                    "Yes, unpin": "是的，取消固定",

            // 工作流文件不存在
            "Not found": "未找到",
                "This workflow does not exist.": "此工作流不存在。",

            "All workflows": "全部工作流程",
                "Show more workflows...": "显示更多工作流程…",
                "Showing runs from all workflows": "显示所有工作流程的运行情况",

            "Codespaces Prebuilds": "代码空间预构建",
                "Showing all prebuild configuration runs for Codespaces. Learn about": "显示代码空间所有预构建设置的运行情况。了解",
                "prebuilding your codespaces.": "代码空间预构建。",

            // 筛选条
                "Filter workflow runs": "筛选工作流程",
                    "Narrow your search": "缩小搜索范围",

            // 反馈提醒
                "Help us improve GitHub Actions": "帮助我们改进 GitHub Actions",
                    "Tell us how to make GitHub Actions work better for you with three quick questions.": "通过三个快速问题告诉我们如何让 GitHub Actions 更好地为您服务。",


            // [/(\d+) workflow runs?$/, "$1 个工作流程运行"],
            // [/(\d+) workflow runs results/, "$1 个工作流程运行结果"],

            "Event": "事件",
                "Filter by Event": "按事件筛选",
                "No matching events.": "无匹配事件。",
                //"Filter by event": "按事件筛选",
                "Find an event": "查找事件",
                    "issue_comment": "议题评论",
                    "pull_request": "拉取请求",
                    "pull_request_target": "拉取请求目标",
                    "push": "推送",
                    "schedule": "日程",
                    "watch": "关注",
                    "workflow_dispatch": "工作流程调度",
                    "repository_dispatch": "仓库调度",
                    "dynamic": "动态",
            // 状态
                "Filter by Status": "按状态筛选",
                "Find a status": "查找状态",
                    "queued": "排队",
                    "in progress": "正在进行中",
                    "waiting": "等待中",
                    "completed": "已完成",
                    "neutral": "中立",
                    "success": "成功",
                    "failure": "失败",
                    "failed": "失败",
                    "cancelled": "已取消",
                    "action required": "需要采取行动",
                    "timed out": "已超时",
                    "skipped": "跳过",
                    "stale": "陈旧",
                    "required action": "需要操作",
            "Branch": "分支",
                "Filter by Branch": "按分支筛选",
                "Find a branch": "查找分支",
                "Default": "默认",
            "Actor": "角色",
                "Filter by Actor": "按角色筛选",
                "Find a user": "查找用户",

            // 日志 右侧按钮
                // 时间补丁 25年9月24日更新
                "Today at": "今天",
            "Cancel run": "取消运行",
            "View workflow file": "查看工作流程文件",
            "Delete workflow run": "删除工作流程运行",
                // 删除工作流程运行 对话框
                    "Are you sure you want to permanently delete this workflow run?": "您确定要永久删除此工作流程运行吗？",
                    "This action cannot be undone.": "此操作无法撤消。",
                    "Yes, delete this workflow run": "是的，删除此工作流程",
                // 顶部提醒
                    "Workflow run deleted successfully.": "工作流程运行删除成功。",

            // 筛选结果
                "No results matched your search.": "没有与您的搜索匹配的结果。",
                "You could search": "您可以搜索",
                "all workflow runs": "所有工作流程运行",
                "or try different filters.": "或尝试不同的筛选器。",

            // 列表区域
                // 工作流程运行状态
                "In progress": "进行中",
                "Queued": "排队中",
                "Pending": "待定中",

            // 顶部提醒
                "You have successfully requested the workflow to be canceled.": "您已成功请求取消工作流。",

        // /<user-name>/<repo-name>/actions/workflows/<file>.yml
            //右侧三个点
                "Show workflow options": "显示工作流程选项",
                    "Create status badge": "创建状态徽章",
                        // 对话框
                            "Default branch": "默认分支",
                                "Filter branches": "筛选分支",
                            "Copy status badge Markdown": "复制状态徽章 Markdown 代码",
                    "Pin workflow": "固定工作流程",
                    "Disable workflow": "禁用工作流程",
                        // 顶部提醒
                        "Workflow disabled successfully.": "工作流程已成功禁用。",

            "This workflow has a": "这个工作流程有一个",
            "event trigger.": "事件触发器。",

            "Run workflow": "运行工作流程",
                "Use workflow from": "使用工作流程来自：",
                "Branch:": "分支：",
                "Select branch": "选择分支",
                "Select ref": "选择引用",
                "Select a tag": "选择标签",
                    "Nothing to show": "暂无",

                    "Workflow does not exist or does not have a": "工作流程不存在或没有",
                    "trigger in this branch.": "触发在此分支。",
                    "Learn more about manual workflows": "了解更多关于手工工作流程的信息",
                "Running workflow...": "正在运行工作流程…",
                // 顶部提醒
                    "Workflow run was successfully requested.": "工作流程已成功请求运行。",

            "This scheduled workflow is disabled because there hasn't been activity in this repository for at least 60 days.": "此计划工作流程已禁用，因为此仓库至少 60 天没有活动。",
            "This scheduled workflow is disabled because there hasn't been activity in this repository for at least 60 days. Enable this workflow to resume scheduled runs.": "此计划的工作流程已禁用，因为此仓库至少有 60 天没有活动。启用此工作流程可恢复计划运行。",
            "This scheduled workflow is disabled because scheduled workflows are disabled by default in forks.": "此计划工作流程已被禁用，因为计划工作流程在复刻仓库中默认被禁用。",
            "This workflow was disabled manually.": "工作流程已被手动禁用。",
            "This workflow is": "此工作流程正在等待维护者",
                "awaiting approval": "批准",
                "from a maintainer in": "在",
            "Enable workflow": "启用工作流程",
                // 顶部提醒
                    "Workflow enabled successfully.": "工作流程已成功启用。",
            "Re-run jobs": "重新运行作业",
                "Re-running...": "重新运行中…",

            // 重新运行对话框
            "Re-run single job": "重新运行单个作业",
                "A new attempt of this workflow will be started, including": "将开始此工作流程的新尝试，包括",
                "all the jobs": "所有作业",
                "all failed jobs": "所有失败作业",
                "and dependents:": "和依赖：",
                "debug logging": "调试日志",

            "This workflow has no runs yet.": "此工作流程尚未运行。",

        // 缓存 /<user-name>/<repo-name>/actions/caches
            "Showing caches from all workflows.": "显示所有工作流程的缓存。",
            "Learn more about managing caches.": "了解更多关于管理缓存的信息。",
            "Filter caches": "筛选缓存",
            "Filter by branch": "按分支筛选",
            "Approaching total cache storage limit": "接近总缓存存储限制",
            "Least recently used caches will be automatically evicted to limit the total cache storage to 10 GB.": "最近最少使用的缓存将被自动驱逐，以限制总缓存存储为 10 GB。",
            "Learn more about cache usage.": "了解更多关于缓存使用的信息。",

            // [/(\d+) caches?/, "$1 个缓存"],
            "Sort": "排序",
            "Sort by": "排序方式",
                // 排序下拉菜单
                "Recently used": "最近使用",
                "Least recently used": "最近最少使用",
                "Newest": "最新",
                "Oldest": "最早",
                "Largest size": "最大尺寸",
                "Smallest size": "最小尺寸",
            "No caches": "尚无缓存",
            "Nothing has been cached by workflows running in this repository.": "在此仓库中运行的工作流程尚未缓存任何内容。",
            "Learn more about caching": "了解更多关于缓存的信息",
            "dependencies and build outputs to improve workflow execution time.": "依赖项和构建输出以缩短工作流执行时间。",
            "Last used": "最近使用",

            // [/(\d+) cache results?/, "$1 个缓存结果"],
            "No caches matched your search": "没有与您的搜索相匹配的缓存",
            // [/No caches matched your search branch:([^ ]+)/, "没有与您搜索的分支: $1 相匹配的缓存"],
            "Remove the filters": "删除筛选器",
            "or try a different search query.": "或尝试不同的搜索查询。",

            "Delete cache": "删除缓存",
                "Remove cache": "删除缓存",
                "Are you sure you want to delete this cache?": "您确定要删除此缓存吗？",
                "This action cannot be undone": "此操作无法撤消",
                "Yes, permanently delete this cache": "是的，永久删除此缓存",

                "Deleting Cache...": "删除缓存中…",
                // 顶部提醒
                "Cache deleted successfully.": "缓存已成功删除。",

        // 运行器 /<user-name>/<repo-name>/actions/runners
            "Runners available to this repository": "此仓库可用的运行器",
            "New runner": "新建运行器",
            "GitHub-hosted runners": "GitHub 托管的运行器",
                // [/(\d+) available runners?/, "$1 个可用运行器"],
                "Larger GitHub-hosted runners": "大型 GitHub 托管运行程序",
                "Unprovisioned": "未配置",
                "Team & Enterprise": "团队与企业",
                "Sizes up to:": "尺寸可达：",
                "Standard GitHub-hosted runners": "标准 GitHub 托管的运行器",
                "Ready-to-use runners managed by GitHub.": "由 GitHub 管理的即用型运行器。",
                "Learn more about GitHub-hosted runners.": "了解更多关于 GitHub 托管运行器的信息。",
                "Copy ubuntu-latest": "复制 ubuntu-latest",
                "Copy windows-latest": "复制 windows-latest",
                "Copy macos-latest": "复制 macos-latest",

                "View larger runner docs": "查看大型运行器文档",
                "See pricing": "查看定价",
            "Self-hosted runners": "自托管运行器",
                "You don't have any": "此仓库尚无任何",
                "self-hosted": "自托管",
                "runners for this repository": "运行器",
                    "Self-hosted runners are virtual machines for GitHub Actions workflows that you manage and maintain outside of GitHub.": "自托管运行器是您在 GitHub 外部管理和维护的 GitHub Actions 工作流程的虚拟机。",

        // /<user-name>/<repo-name>/actions/runs/<id>
            // 顶部提醒
                "Logs deleted successfully.": "日志已成功删除。",

            // 标题
            "Re-run all jobs": "重新运行所有作业",
            "Re-run failed jobs": "重新运行失败作业",
            "Cancel workflow": "取消工作流程",

            //"Latest attempt": "最后运行",
            //"Attempt": "运行",
            "Explain error": "解释错误",
            //右侧按钮
            "View workflow runs": "查看工作流程运行",
            "Workflow run options": "工作流程运行选项",
            "Delete all logs": "删除所有日志",
            "Sign in to view logs": "登录后查看日志",

            // 左侧栏
            "Summary": "摘要",
            "All jobs": "所有作业",
                "Filter by job status": "由作业状态筛选",
                    "Filter by status": "状态筛选",
            "Jobs": "作业",
            "Run details": "运行详情",
            "Usage": "运用",

            //状态条
            "Triggered via pull request": "通过拉取请求触发",
            "Triggered via issues": "通过议题触发",
            "Triggered via push": "通过推送触发",
            "Triggered via schedule": "通过计划表触发",
            "Triggered via dynamic": "通过动态触发",
            "Triggered via GitHub Pages": "通过 GitHub 页面触发",
            "Triggered via repository dispatch": "通过仓库调度触发",
            "Triggered via release": "通过发行版触发",
            "Triggered via issue": "通过议题触发",
            "Triggered via discussion": "通过讨论触发",
            "Triggered via discussion comment": "通过讨论评论触发",
            "Triggered via workflow run": "通过工作流运行触发",
            "Re-run triggered": "重新触发",
            "Manually triggered": "手动触发",

            "pushed": "推送",
            "opened": "打开",
            "reopened": "重新打开",
            "commented on": "评论于",

            // 状态
                "Success": "成功",
                "Failure": "失败",
                "Startup failure": "失败",
                "Cancelled": "取消",
                "Action required": "请求操作",
                "Waiting": "等待",
            "Total duration": "总时长",
            "Billable time": "计费时间",

            "This workflow is waiting for": "该工作流程正在等待",
                "to complete before running.": "完成后再运行。",
                "Learn more about concurrency": "了解有关并发执行的更多信息",

            "Job summary generated at run-time": "运行时生成的工作摘要",

            // 右侧中间栏
                "This workflow graph cannot be shown": "无法显示此工作流图表",
                "A graph will be generated the next time this workflow is run.": "下次运行此工作流时将生成一个图表。",

                "This run and associated checks have been archived and are scheduled for deletion.": "此运行和相关检查已存档并计划删除。",
                "Learn more about checks retention": "了解更多关于检查保留的信息",

            "Artifacts": "附件",
                "Produced during runtime": "在运行期间生成",
                "Name": "名称",
                "Size": "大小",
                "Digest": "校验值",
                // [/Delete artifact ([^ ]+)/, "删除附件 $1"],
                "Expired": "已过期",
                    "This artifact has expired and you can no longer download it": "此附件已过期，您无法再下载",
            "Annotations": "说明",
                // [/1 error/, "$1 个错误"],

        // /<user-name>/<repo-name>/actions/runs/<id>/job/<job-id>
            "The logs for this run have expired and are no longer available.": "此运行日志已过期，不再可用。",
            "This job was cancelled": "作业已取消",

            "Started": "开始于",
            "succeeded": "成功于",
            "ago": "之前",

            "Search logs": "搜索日志",
            "Re-run this job": "重新运行此作业",
            // 设置按钮
                "Show timestamps": "显示时间戳",
                "Show full screen (Shift+F)": "全屏显示（Shift+F）",
                "Download log archive": "下载日志存档",
                "View raw logs": "查看原始日志",
                "View job summary": "查看作业摘要",

            "Try broadening your search filters.": "尝试扩大您的搜索筛选器。",

            "Re-run all checks": "重新运行所有检查",

        // /<user-name>/<repo-name>/actions/runs/<id>/usage
            "Run and billable time": "运行和计费时间",
            "Learn about OS pricing on GitHub Actions": "了解 GitHub Actions 上的操作系统定价",
            "Job": "工作",
            "Run time": "运行时间",
            "Billable": "计费",
            "time": "时间",

        // /<user-name>/<repo-name>/actions/runs/<id>/workflow
            "Workflow file": "工作流程文件",
            "Workflow file for this run": "本次运行的工作流程文件",

        // 操作面板
            "Show all jobs": "显示所有工作",
            "Scheduled": "计划运行",
            "Commit": "提交",
                "pushed by": "推送者",
            "Manually run by": "手动运行由",
            "The run was canceled by": "取消由", // 原文过于啰嗦
            "Pull request": "拉取请求",
                "synchronize by": "同步者",
                "opened by": "打开者",
                "reopened by": "重新打开者",
            "The operation was canceled.": "已取消。",
            "Release": "发行版",
                "published by": "发布者",
            "created by": "创建者",
            "completed by": "完成者",
            //"Process completed with exit code 1.": "进程完成，退出代码为 1。",
            "Cache not found": "找不到缓存",
            "Starting job": "作业启动中",
            "This job failed": "此作业失败",
            "This job was skipped": "此作业被跳过",
            "Waiting for pending jobs": "等待中",
            "Input required and not supplied: token": "需要输入但未提供：令牌",
            "The deployment was rejected or didn't satisfy other protection rules.": "部署被拒绝或不符合其他保护规则。",
            "Fit to window": "适合",
            "Zoom out": "缩小",
            "Zoom in": "放大",

        // 摘要窗口
            "Unable to load summary": "无法加载摘要",
            "This job summary has expired and is no longer available": "此作业摘要已过期，不再可用",
                // 右侧三个点
                "View job logs": "查看日志",
                "View raw markdown": "查看原始 Markdown",
                "Copy permalink": "复制永久链接",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Back to pull request (#\d+)/, "返回拉取请求 $1"],
        [/Workflow (.*) pinned./, "工作流程 $1 已置顶"],
        [/Workflow (.*) unpinned./, "工作流程 $1 已取消置顶"],
        [/Found (\d+) workflows?/, "发现 $1 个工作流程"],
        [/(\d+) workflow runs?$/, "$1 个工作流程运行"],
        [/(\d+) workflow runs? results?/, "$1 个工作流程运行结果"],
        [/Download ([^ ]+)/, "下载 $1"],
        [/Delete ([^ ]+)/, "删除 $1"],
        [/(\d+) errors?/, "$1 个错误"],
        [/(\d+) cache results?/, "$1 个缓存结果"],
        [/(\d+) caches?/, "$1 个缓存"],
        [/No caches matched your search branch:([^ ]+)/, "没有与您搜索的分支: $1 相匹配的缓存"],
        [/(\d+) available runners?/, "$1 个可用运行器"],
        [/(\d+)\/(\d+) jobs? completed/, "$1/$2 个工作完成"],
        [/(\d+) jobs? completed/, "$1 个工作完成"],
        [/(\d+) warnings?/, "$1 个警告"],
        [/Latest attempt (#\d+)/, "最后运行 $1"],
        [/Latest (#\d+)/, "最新 $1"],
        [/Attempt (#\d+)/, "运行 $1"],
        [/cached/, "被缓存"],
        [/(\d+)-cores · (\d+) GB RAM · (\d+) GB SSD Storage/, "$1 核心 · $2 GB内存 · $3 GB SSD 存储"],
        [/Process completed with exit code (\d+)/, "进程已结束，退出代码为 $1"],
        [/([^ ]+) value is not set/, "$1 值未设置"],
        [/([^ ]+) summary/, "$1 摘要"],
        [/By ([^ ]+)/, "创建：$1"],
        [/Branch "([^ ]+)" is not allowed to deploy to ([^ ]+) due to environment protection rules./, "由于环境保护规则，“$1”分支不允许部署到 $2 上。"],
        // 时间
        [/(\d+)d (\d+)h (\d+)m (\d+)s/, "$1天$2时$3分$4秒"],
        [/(\d+)h (\d+)m (\d+)s/, "$1时$2分$3秒"],
        [/(\d+)h (\d+)m/, "$1时$2分"],
    ],
    "title": {
        "regexp": [
            [/Workflow runs/, "工作流程运行"],
            [/Caches/, "缓存"],
        ],
    },
};
I18N["zh-CN"]["repository/runs"] = I18N["zh-CN"]["repository/actions"];

I18N["zh-CN"]["repository/deployments"] = { // 仓库 - 部署页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // /<user-name>/<repo-name>/deployments
            // 左侧栏
                "Deployed": "部署",
                    "All deployments": "所有部署",
                    "Environments": "环境",
                    "Manage environments": "管理环境",

            // 面板
                // 所有部署
                    "Latest deployments from pinned environments": "来自固定环境的最新部署",
                //具体某一项
                    "Latest deployments": "最新部署",
                    "Last": "最后",
                    "deployed": "部署于",
                // 中间面板
                    "Your search did not match any deployments": "您的搜索未匹配任何部署",
                    "Try a different search query": "尝试不同的搜索查询",

                // 筛选条
                    "Filter": "筛选",
                        "Filter deployments": "筛选部署",
                        // 搜索框菜单
                            "State": "状态",
                                "success": "成功",
                                "failure": "失败",
                                "error": "错误",
                                "inactive": "不活跃",
                                "pending": "待定",
                                "queued": "排队",
                                "in progress": "进行中",
                                "waiting": "等待中",
                            "Creator": "创建者",
                            "Environment": "环境",
                            "Ref": "引用",
                            "Text": "文本",

                    // 筛选器窗口
                        "Advanced filters": "高级筛选",
                        "Build complex filter queries": "建立复杂的筛选器查询",
                        "To start building your query add your first filter using the button below.": "要开始建立查询，请使用下面的按钮添加第一个筛选器。",

                        "Qualifier": "限定",
                        "Operator": "操作",
                            "is one of": "之中的",
                            "is": "是",
                        "Value": "值",
                            "Make a selection": "请选择",
                            "Select items": "请选择项目",
                            "Filter values": "筛选值",
                            "Enter search text": "键入任意文本",
                                "Me": "我",
                                "Signed-in user": "已登录用户",
                        "Add a filter": "添加筛选器",
                        "Apply": "应用",

                    // 关闭弹窗
                        "Discard changes?": "是否放弃更改？",
                            "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您确定要放弃它们吗？",
                            "Keep editing": "继续编辑",
                            "Close and discard": "关闭并放弃",

                    //筛选器报错窗口
                        "Empty value for": "空值：",
                        "Text will be ignored since log searching is not yet available:": "由于尚未提供日志搜索功能，文本将被忽略：",

                // 列表
                    "Active": "活跃",
                    "Inactive": "不活跃",
                    "Abandoned": "废弃",
                    "Deployed to": "部署到",
                    "Failed to deploy to": "无法部署到",

                    "View logs": "查看日志",
                    "View workflow run": "查看工作流程运行",

        // /<user-name>/<repo-name>/deployments/activity_log?environment=github-pages
            "Deployments": "部署",
            "/ History": "/ 历史",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/deployments?/, "部署"],
        [/Filter contains (\d+) issues?:/, "过滤器包含 $1 个问题："], // 过滤器报错窗口
        [/via/, "通过"],
    ],
    "title": {
        "regexp": [
            [/Deployments/, "部署"],
        ],
    },
};

I18N["zh-CN"]["repository/attestations"] = { // 仓库 - 证书页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // <user-name>/repo-name>/attestations 证书
            "Attestations": "证书",

            "No attestations": "尚无证书",
                "Create attestations using the": "创建证书，请使用",
                "action": "操作工作流",

            "Filter": "筛选",
                "Sort by:": "排序方式：",
                    "Newest": "最新",
                    "Oldest": "最早",
                "Search or filter": "搜索或筛选",
                "Advanced filters": "高级筛选",
                "Build complex filter queries": "建立复杂的筛选器查询",
                "To start building your query add your first filter using the button below.": "要开始建立查询，请使用下面的按钮添加第一个筛选器。",
                "Add a filter": "添加筛选器",
                "Apply": "应用",
                "Created": "创建于",
                    "before": "之前",
                    "after": "之后",
                    "before and including": "之前包括",
                    "after and including": "之后包括",
                    "between": "之间",
                    "is one of": "之中的",
                    "is not one of": "不包含",
                    "is": "是",
                "Has": "包含",
                "Predicate type": "谓词类型",
                "Exclude": "排除",
                "Text": "文本",
                    "Enter search text": "键入任意文本",


            "Qualifier": "条件",
            "Operator": "操作",
            "Value": "值",
                "Make a selection": "请选择",
                "Select items": "请选择项目",
                "Select an item": "请选择一个项目",
                "Filter values": "筛选值",
    },
    "title": {
        "regexp": [
            [/Attestations/, "证书"],
        ],
    },
};

I18N["zh-CN"]["repository/watchers"] = { // 仓库 - 关注者页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 关注者页面  /<user-name>/<repo-name>/watchers
            "Watchers": "关注者",
            "No one’s watching this repository yet. You could be the first.": "暂无关注者。您可以成为第一个",
            "Learn more about how watching repositories works on GitHub": "了解更多关于如何在 GitHub 上关注仓库的工作方式",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        // [/Joined/,"加入于"], // 追星者，关注者页面
    ],
};

I18N["zh-CN"]["repository/stargazers"] = { // 仓库 - 追星者页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 追星者页面  /<user-name>/<repo-name>/stargazers
            "Stargazers": "追星者",
            "All": "全部",
            "You know": "您关注的",
            "Be the first to star this repository": "成为第一个为这个仓库标星的人",
            "about how starring works on GitHub.": "关于如何在 GitHub 上标星。",
            "Be the first of your friends to star this repository.": "成为第一个为这个仓库标星的朋友。",

        // /<user-name>/<repo-name>/stargazers/you_know
            "No one you follow has starred this repository yet.": "您关注的任何人都未标星此仓库。",
            "Learn more about how starring works on GitHub.": "了解更多关于在 GitHub 上标星的工作原理。",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        // [/Joined/,"加入于"], // 追星者，关注者页面
    ],
};

I18N["zh-CN"]["repository/new"] = { // 仓库 - 新建/编辑/上传/删除文件页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 新建文件页面 /<user-name>/<repo-name>/new/<branch>
            // 文件树侧边栏
                "Expand file tree": "展开文件树",
                "Collapse file tree": "折叠文件树",
                "Add file": "添加文件",
                // 搜索框
                    "Search this repository": "搜索此仓库",
                    "Go to file": "转到文件",
                        "No matches found": "未找到匹配项",
                        "Go to folder": "转到文件夹",
                        "See all results": "查看所有结果",

            "Name your file...": "文件名…",
            "in": "在",

            "Cancel changes": "取消更改",
                "You have unsaved changes. Do you want to discard them?": "您有未保存的更改。您想丢弃它们吗？",
            "Commit changes...": "提交更改…",

            "Preview": "预览",
                "Loading preview…": "载入预览…",
                    "There is no content to preview.": "没有可预览的内容。",
                    "There has been an error generating the preview.": "生成预览时发生错误。",
                    "Unable to load this preview, sorry.": "抱歉，无法加载此预览。",
                    "There are no changes to show.": "没有要显示的更改。",
                    "But you can preview the whole file.": "但您可以预览整个文件。", // new code view

            // 代码编辑框
                // Copilot 广告
                    "Code 55% faster with GitHub Copilot": "使用 GitHub Copilot 编码速度提高 55%",
                        "Spend less time creating boilerplate and repetitive code patterns, and more time building great software. Try it in Codespaces or your favorite file editor.": "花更少的时间创建模板和重复的代码模式，花更多的时间构建优秀的软件。在 GitHub 代码空间或您最喜欢的文件编辑器中尝试一下哈。",
                        "Get GitHub Copilot": "获取 GitHub Copilot",
                        "Don't show again": "不再显示",

                "Indent mode": "缩进模式",
                    "Spaces": "空格",
                    "Tabs": "Tab",
                "Indent size": "缩进大小",
                "Line wrap mode": "换行模式",
                    "No wrap": "不换行",
                    "Soft wrap": "软换行",

            "Show Diff": "显示差异",

            // 提交对话框
                "Commit changes": "提交更改",
                    "There was an error committing your changes:": "在提交您的更改时出现错误：",
                    "A file with the same name already exists. Please choose a different name and try again.": "已存在同名文件。请选择其他名称并重试。",
                    "File could not be edited": "文件不能编辑",
                    "See what changed": "查看更改",
                "Sign off and commit changes": "提交更改并签署",
                "Propose changes": "提出更改建议", // 向他人仓库提交
                "Sign off and propose changes": "提出更改建议并签署", // 向他人仓库提交
                    "Commit message": "提交信息",
                    "Extended description": "扩展描述",
                        "Add an optional extended description...": "添加描述... (可选)",

                    "Message and description suggested by Copilot.": "Copilot建议的消息和描述。",
                        "Send feedback": "提交反馈",

                    "You are": "您将",
                    "signing off": "签署",
                    // [/on this commit as/,"该提交以"],

                    "You can’t commit to": "您不能提交到",
                    "because its is a": "，因为它是一个",
                    "protected branch": "受保护分支",

                    "Commit directly to the": "提交到",
                    "branch": "分支",

                    "Some rules will be bypassed by committing directly": "直接提交可以绕过一些规则",
                    "Bypass rules and commit changes": "绕过规则并提交更改",

                    "Create a": "创建",
                    "new branch": "新分支",
                    "for this commit and start a pull request": "为这个提交，并且发起一个拉取请求",
                    "Learn more about pull requests": "了解更多关于拉取请求的信息",

                "Something went wrong. Please fork the project, then try from your fork.": "出错了。请复刻该项目，然后从您的复刻处尝试。",

            // 底部栏
                "Use": "使用",
                "to toggle the": "切换",
                "key moving focus. Alternatively, use": "键移动对焦。或者使用",
                "then": "键，然后",
                "to move to the next interactive element on the page.": "键移动到页面上的下一个交互元素。",

            // 顶部提醒
            // [/Your license is ready. Please review it below and either commit it to the ([^ ]+) branch or to a new branch./, "您的许可证已准备就绪。请在下面审查它并将其提交到 $1 分支或新分支。"],

        // 编辑文件页面 /<user-name>/<repo-name>/edit/<branch>/<file>
            // 非本人仓库
                "You need to fork this repository to propose changes.": "您需要复刻此仓库以提出更改。",
                    "Sorry, you’re not able to edit this repository directly—you need to fork it and propose your changes from there instead.": "抱歉，您无法直接编辑此仓库——您需要将其复刻并从那里提出您的更改。",
                "Fork this repository": "复刻此仓库",
                    "Learn more about forks": "了解更多关于复刻的信息",

                "You have unsaved changes on this file that can be restored.": "您可以恢复该文件上未保存的更改。",
                    "Discard": "丢弃",
                    "Restore": "恢复",

                "You’re making changes in a project you don’t have write access to. Submitting a change will write it to a new branch in your fork": "您正在对没有写入权限的项目进行更改。提交更改会将其写入您的复刻",
                ", so you can send a pull request.": " 中的新分支，这样您就可以发送拉取请求。",

            // 复刻仓库过旧
                "Sorry, it looks like your fork is outdated!": "抱歉，您的复刻好像过时了！",
                "You’ll have to bring it up to date before you can propose changes.": "在提出修改意见之前，您必须对其进行更新。",
                "Update your fork": "更新您的复刻",

            // 组织仓库 编辑文件页面
                "You’re making changes in a project you don’t have write access to. We’ve": "您正在对没有写入权限的项目进行更改。我们已经",
                "created a fork of this project": "为该项目创建复刻",
                "for you to commit your proposed changes to. Submitting a change will write it to a new branch in your fork, so you can send a pull request.": "供您提交建议的更改。提交更改会将其写入复刻中的新分支，这样您就可以发送拉取请求。",

            // 混合换行符
                "We’ve detected the file has mixed line endings. When you commit changes we will normalize them to": "我们检测到该文件具有混合行结尾。当您提交更改时，我们会将它们标准化为",
                "Windows-style": "Windows 样式",

            // 与用户名同名仓库 编辑 README.md 文件
                "is a special repository: its": "是一个特殊的仓库：它的",
                "will appear on your profile!": "将出现在您的个人资料中！",

                "is now a special repository: its": "现在是一个特殊的仓库：它的",

            // 组织下.github 仓库 编辑 /profile/README.md 文件
                "is a special repository: this": "是一个特殊的仓库：这个",
                "will appear on your organization's profile!": "将出现在您的组织资料中!",

            // 编辑 .gitignore 文件
                "Choose .gitignore template": "选择 .gitignore 模板",
                    ".gitignore template": ".gitignore 模板",
                    "Filter…": "筛选…",
                    "None": "无",

            // 编辑 工作流程文件 .github/workflows/xxxx.yml
                "Collapse help panel": "折叠帮助面板",

                // 帮助面板侧边栏
                    "Search Marketplace for Actions": "搜索 Actions 市场",
                    "Featured Actions": "特色 Actions",
                    "Featured categories": "特色分类",
                        "Code quality": "代码质量",
                        "Monitoring": "监控",
                        "Continuous integration": "持续集成",
                        "Project management": "项目管理",
                        "Deployment": "部署",
                        "Project management": "项目管理",
                        "Testing": "测试",
                    "\/ Search results": "\/搜索结果",
                    "Browse all actions on the GitHub Marketplace": "浏览 GitHub 市场 上的所有 Actions",

                    // 具体某个操作
                        "View full Marketplace listing": "去市场查看详细信息", // 跳转去市场对应页面
                        "Installation": "安装",
                        "Copy and paste the following snippet into your": "将以下代码段复制并粘贴到您的",
                            "file.": "文件。",
                        "Version:": "版本：",

                // 底部栏补充
                    "Space": "空格",
                    "to trigger autocomplete in most situations.": "在大多数情况下将触发自动完成。",
                    "Documentation": "文档",

            // 编辑 LICENSE 许可证文件
                "Choose a license template": "选择许可证模板",

            // 编辑 议题表单模板文件 .github/ISSUE_TEMPLATE/xxxx.yml
                // 顶部提示
                "Looks like this file is an issue template. Need help?": "此文件是一个议题模板。需要帮助？",
                "Learn more about issue templates.": "了解更多关于议题模板的信息。",
                "Give feedback.": "提交反馈。",
                // 右侧帮助说明
                "Top-level configuration options": "顶层配置选项",
                    "Required Fields": "必填项",
                        "(String): The template's name. Must be unique across all templates, including Markdown templates.": "（字符串）模板名。不能与其他模板名重复，包括 Markdown 模板",
                        "(String): A description of this template's intended use. This will be shown in the issue template chooser interface.": "(字符串）：该模板预期用途的说明。这将显示在议题模板选择界面中。",
                    "Optional Fields": "可选项",
                        "(Array or String): This issue will be automatically assigned to these users. Can be array of usernames or comma-delimited string, e.g. \"monalisa,nat\"": "(数组或字符串）：此议题将自动分配给这些用户。可以是用户名数组或以逗号分隔的字符串，例如 “monalisa,nat”。",
                        "(Array or String): This issue will automatically receive these labels upon creation. Can be array of labels or comma-delimited string, e.g. \"bug,needs-triage\"": "(数组或字符串）：该议题在创建时将自动接收这些标签。可以是标签数组或以逗号分隔的字符串，例如 “bug,needs-triage”（错误，需要分流）。",
                        "(Array or String): This issue will be automatically added to these projects. Can be array of projects or comma-delimited string, e.g. \"github\/1,github\/2\"": "(数组或字符串）：该议题将自动添加到这些项目中。可以是项目数组或以逗号分隔的字符串，如 “github\/1,github\/2”。",
                        "(String): Default title that will be pre-populated in the issue submission form.": "(字符串）：将在议题表单中预填的默认标题。",
                        "(Array): Definition of user inputs.": "(数组）：用户输入的定义。",
                "Input type configuration options": "输入类型配置项",
                    // Markdown
                        "Markdown blocks contain arbitrary text that a maintainer can add to a template, to provide extra context or guidance to a contributor. Supports Markdown formatting. This text will": "Markdown 块包含任意文本，维护者可将其添加到模板中，为贡献者提供额外的上下文或指导。支持 Markdown 格式。这些文本",
                        "not be rendered in the submitted issue body": "不会在提交的议题正文中呈现。",
                        // 必填项
                            "(String): The text that will be rendered. Markdown formatting is supported.": "(字符串）：将渲染的文本。支持 Markdown 格式。",
                        "Tip #1: YAML processing will cause the hash symbol to be treated as a comment. To insert Markdown headers, wrap your text in quotes.": "提示 1：YAML 处理会将 # 号视为注释。要插入 Markdown 标题，请用引号将文本包起来。",
                        "Tip #2: For multi-line text, you can use the pipe operator.": "提示 2：对于多行文本，可以使用管道运算符。",
                        "Example": "示例",
                    "Input": "输入",
                        "Inputs are single-line form input fields. Contributors may use markdown formatting in their responses.": "输入为单行表单输入字段。贡献者可在回复中使用标记符格式。",
                        "Required Attributes": "必要属性",
                            "(String): A brief description of the expected user input.": "(字符串）： 预期用户输入的简要说明。",
                        "Optional Attributes": "可选属性",
                            "(String): Extra context or guidance about filling out this form input. Supports Markdown.": "(字符串）：有关填写此表单输入的额外上下文或指导。支持 Markdown。",
                            "(String): Renders as semi-transparent \"placeholder\" element in the input field when it's empty.": "(字符串）：当输入框为空时，渲染为半透明的 “placeholder”元素。",
                            "(String): Default text that is pre-populated in the input field.": "(字符串）：输入字段中预填的默认文本。",
                        // ID
                            "(String): Optional unique identifier. Can only contain alphanumeric characters,": "(字符串）：可选的唯一标识符。只能包含字母数字字符、",
                        "Validations": "验证",
                            "(Boolean): If": "(布尔值）：若",
                            ", the form will not be submittable until this is filled out. Only for public repositories.": "，则填写此信息后才能提交表格。仅适用于公共仓库。",
                    "Textarea": "文本区域",
                        "Very similar to inputs, textareas are multiple-line form input fields. Typically used if you'd like a contributor to provide an answer longer than a few words. Contributors may use markdown formatting in their responses.": "文本区域与输入非常相似，都是多行表单输入字段。如果希望贡献者提供长于几个单词的答案，通常会使用文本区域。贡献者可以在回复中使用标记符格式。",
                        // 可选属性
                            "(String): If a value is provided, user-submitted text will be formatted into a codeblock automatically.": "(字符串）：如果提供该值，用户提交的文本将自动格式化为代码块。",
                    "Dropdown": "下拉菜单",
                        "Users can select their answer from options defined by the maintainer.": "用户可以从维护者定义的选项中选择答案。",
                            "(String Array): Set of values that user can select from to answer. Cannot be empty, and all choices must be distinct.": "(字符串数组）：用户可从中选择回答的一组值。不能为空，且所有选择必须是不同的。",
                        // 可选属性
                            ", users can submit multiple selections.": "则用户可提交多选项。",
                        // 验证
                            ", the form will not be submittable until at least one choice is selected. Only for public repositories.": "则至少选择一个选项后才能提交表单。仅适用于公共仓库。",
                    "Checkboxes": "勾选框",
                    "A group of one or more checkboxes. This will be saved as a Markdown checkbox, and will continue to support interactive updating.": "由一个或多个复选框组成的组。这将被保存为 Markdown 复选框，并将继续支持交互式更新。",
                        "(Array): Set of values that user can select from to answer. Cannot be empty. Each item must have a": "(数组）：用户可从中选择回答的数值集合。不能为空。每个项目必须有一个",
                        ", described below.": "，如下所述。",
                    "Within each item in": "对于任何带",
                        ", the following fields are supported:": "元素则支持以下字段：",
                        "(String): The text that will appear beside the checkbox. Markdown is supported for bold or italic text formatting, and hyperlinks.": "(字符串）：复选框旁边显示的文本。Markdown 支持粗体或斜体文本格式以及超链接。",
                    "Optional": "可选",
                        "(Boolean): If required, the form will not be submittable unless checked. Only for public repositories.": "(布尔值）：如果需要，除非选中，否则表单将无法提交。仅适用于公共仓库。",

            // 查找工具栏
                "Find": "查找",
                "next": "下一处",
                "previous": "上一处",
                "all": "全部",
                "match case": "区分大小写",
                "regexp": "正则",
                "by word": "全字匹配",
                "Replace": "替换",
                "replace": "替换",
                "replace all": "全部替换",

        // 删除文件页面 /<user-name>/<repo-name>/delete/<branch>/<file>
            // 顶部提醒
            "File successfully deleted.": "文件已成功删除。",

            "Copy path to clipboard": "复制路径到剪切板",

            "Load diff": "加载差异",
            "This file was deleted.": "此文件已删除。",

        // 上传文件页面 /<user-name>/<repo-name>/upload/<branch>
            // 自有仓库
                "Drag files here to add them to your repository": "拖拽文件添加到当前仓库",
                "Drag additional files here to add them to your repository": "拖拽其他文件添加到当前仓库",
                "Or": "或",
                "choose your files": "选择文件",
                "Drop to upload your files": "拖拽上传您的文件",
                // 处理反馈
                "Yowza, that’s a big file. Try again with a file smaller than 25MB.": "我勒个擦，这么大的文件，单文件不得超过25MB",
                "Yowza, that’s a lot of files. Try again with fewer than 100 files.": "我勒个擦，这么多文件，一次不能超过100个",
                "This file is": "这个文件是",
                "empty": "空的",
                "Something went really wrong, and we can’t process that file.": "遇到错误，我们无法处理这个文件。",

                // 文件上传进度条
                "Uploading": "文件上传中",
                "of": "/",

                // 提交框 补充
                    "Add files via upload": "通过上传添加文件",
                    "Add an optional extended description…": "添加可选的扩展描述…",

                    "branch.": "分支。", // 上传页面
                    "for this commit and start a pull request.": "为这个提交，并且发起一个拉取请求。", // 上传页面
                    "Learn more about pull requests.": "了解更多关于拉取请求的信息。", // 上传页面

                // 提交后处理页面
                    "Processing your files…": "正在处理您的文件…",

            // 他人仓库
                "Uploads are disabled.": "上传功能已禁用。",
                "File uploads require push access to this repository.": "文件上传需要推送访问此仓库。",

        // new code view
            "Top": "顶部",
            "Jump to file": "跳转到文件",

    },
    "regexp": [ // 正则翻译
        [/on this commit as/,"该提交以"],
        [/Commit changes?/, "提交更改"], // 提交对话框
        [/Your license is ready. Please review it below and either commit it to the ([^ ]+) branch or to a new branch./, "您的许可证已准备就绪。请在下面审查它并将其提交到 $1 分支或新分支。"],
        [/Your search has returned (\d+) results?./, "您的搜索返回了 $1 条结果。"],
        [/First (\d+) files? shown./, "显示前 $1 个文件。"],
        [/([^ ]+) has committed since you started editing./, "$1 自您开始编辑以来已提交。"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/New File at/, "新建文件在"],
            [/Editing (.+) at (.+) · (.+)/, "编辑文件 $1 在分支 $2 · $3"],
        ],
    },
};
I18N["zh-CN"]["repository/edit"] = I18N["zh-CN"]["repository/new"];
I18N["zh-CN"]["repository/delete"] = I18N["zh-CN"]["repository/new"];
I18N["zh-CN"]["repository/upload"] = I18N["zh-CN"]["repository/new"];

I18N["zh-CN"]["repository/find"] = { //  仓库 - 查找文件页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // Find file 页面 /<user-name>/<repo-name>/find/<branch>
            "You’ve activated the": "您已激活",
            "file finder": "文件搜索模式",
            ". Start typing to filter the file list. Use": "。输入关键词查找您的文件。使用",
            "and": "和",
            "to navigate,": "选择文件",
            "to view files,": "查看文件",
            "to exit.": "返回。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
};

I18N["zh-CN"]["repository/models"] = { // 仓库 - 模型
    "static": {
        ...I18N["zh-CN"]["repository-public"]["static"],
        "Public Preview": "公共预览",
        "Expand menu": "展开目录",
        "Collapse menu": "折叠目录",
        "Catalog": "目录",
        "Share feedback": "反馈",
        "Filter items": "筛选项目",

        // 概况
            "Build your AI products—right inside GitHub. Create prompts, test models, and ship AI-powered features with built-in tools for model access, prompt collaboration, and lightweight evaluation.": "在 GitHub 内部构建您的 AI 产品。利用内置的模型接入、提示协作和轻量级评估工具，创建提示词、测试模型，并发布 AI 驱动的功能。",
                "Read the docs": "阅读文档",
                "to learn more.": "了解详情。",

            "You do not have access to GitHub Models on this repository": "您无权访问此仓库上的 GitHub 模型",
                "You need write permissions or higher for this repository to use GitHub Models.": "您需要拥有此仓库写入权限或更高权限，才能使用 GitHub 模型。",
                "Learn more about GitHub Models.": "了解更多。",

            "Get started": "开始使用",
                "Watch the models demo": "观看模型演示",
                "Watch this 3-minute demo reel to learn everything you can do with GitHub Models": "观看这个 3 分钟的演示视频，了解您可以使用 GitHub 模型完成的所有操作",

            "Prompts": "提示词",
                "Create, evaluate, and iterate on prompts right inside your repo.": "在您的仓库内直接创建、评估和迭代提示词。",
                "Get write permissions or higher for this repository to create and manage prompts.": "获得对此仓库的写入权限或更高权限，才能创建和管理提示词。",
                "Create a prompt": "创建提示词",
                "Build with natural language or using": "使用自然语言或使用",
                "prompt.yml files": "prompt.yml 文件",
                "Test sample prompt": "测试示例提示词",
                "Manage prompts stored in your repo using": "管理您仓库中的提示词，使用",
                "Get started with Models in your codebase": "开始使用模型您的代码库", // 还有一些部分未翻译

            "Add AI to your project now": "立即添加 AI 到您的项目",
                "Drop this snippet into your code to start using AI instantly.": "将此代码片段插入您的代码中，即可立即开始使用 AI。",
                "Get API Key": "获取 API 密钥",

            "Explore 40+ models in the catalog": "在目录中探索 40+ 模型",
                "Compare models in the playground—test parameters, token usage, and latency to find the right fit for your use case.": "在游乐场中对比模型——测试参数、令牌使用量和延迟，以找到最适合您用例的模型。",
            "Power your prompt with the right model": "为您的提示词选择合适的模型",
                "Test and compare models against your prompt to find the best fit, then commit it directly to your project when you're ready.": "针对您的提示词测试和对比不同模型，以找到最合适的模型，然后在准备好后将其直接提交到您的项目中。",
            "Instrument your Actions workflow with models": "使用模型为您的 Actions 工作流提供支持",
                "Set up a new GitHub Actions workflow using models.": "使用模型新建 Actions 工作流。",

        // 提示词
            "Manage": "管理",
                "prompts stored in your repo using": "您仓库中的提示词，使用",
                ".prompt.yml file": ".prompt.yml 文件",
                "format.": "格式。",
    },
    "regexp": [
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) prompts? found/, "$1 条提示词"],
    ],
    "title": {
        "regexp": [
            [/Models/, "模型"],
            [/Prompts/, "提示词"],
        ],
    },
}

I18N["zh-CN"]["repository/wiki"] = { // 仓库 - wiki 页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // wiki 页面  /<user-name>/<repo-name>/wiki
            // [/Welcome to the ([^ ]+) wiki!/, "欢迎访问 $1 的 Wiki"], // wiki页面
            "You do not have permission to update this wiki.": "您无权更新此 wiki。",
            "Wikis provide a place in your repository to lay out the roadmap of your project, show the current status, and document software better, together.": "Wiki 为您的仓库提供了一个更好的文档资料。",
            "Create the first page": "创建第一个页面",

            // [/edited this page/, "编辑此页"], // wiki
            // [/(\d+) revisions?/, "$1 次修订"], // wiki
            "New page": "新建页面",
            "Add a custom footer": "添加自定义页脚",

            // 右侧栏
            "Pages": "页面",
                "Toggle table of contents": "折叠/展开目录",
                "Find a page…": "搜索页面…",
            "Add a custom sidebar": "添加自定义侧边栏",
            "Clone this wiki locally": "在本地克隆这个 Wiki",

            "Last updated": "最后更新",

        // 新建 wiki 页面 /<user-name>/<repo-name>/wiki/_new
            "Create new page": "创建新页面",
            "Title": "标题",
            "Write": "编辑",
            "Preview": "预览",
            "Edit mode:": "标记语言：",
            "Edit message": "提交信息",

            "Write a small message here explaining this change. (Optional)": "请简要描述所作修改(可选)",
            "Save page": "保存页面",
            // 顶部提醒
                "Your Wiki was created.": "您的 Wiki 已创建。",

        // 编辑 wiki 页面 /<user-name>/<repo-name>/wiki/<page name>/_edit
            // [/Editing/, "编辑"], //编辑 wiki
            "Page history": "页面历史",
            "Delete page": "删除页面",
                "Are you sure you want to delete this page?": "您确定要删除此页面吗？",

            "Someone has edited the wiki since you started. Please reload this page and re-apply your changes.": "此页面已被其他用户修改。请重新加载此页面并重新应用您的更改。",

            // 顶部提醒
                "The wiki page was successfully deleted.": "Wiki 页面已成功删除。",

        // wiki页面历史 /<user-name>/<repo-name>/wiki/<page name>/_history
            "History": "历史",
            "Edit page": "编辑页面",
            "Revisions": "修订",
            "Compare revisions": "对比修订",
                "Invalid or empty diff.": "无效或无差异。",

        // wiki修订间差异 /<user-name>/<repo-name>/wiki/<page name>/_compare
            "Revert changes": "撤销更改",
            "Back to top": "回到顶部",
            "Showing": "显示",
            "with": "包含",
            "Unified": "同屏",
            "Split": "分屏",
            // 差异按钮
                "Display the source diff": "显示源差异",
                "Display the rich diff": "显示富差异",
            // 修改的文件 右侧下拉
                "Show comments": "显示评论",
                "Show annotations": "显示注释",
                "View file": "查看文件",
                "Edit file": "编辑文件",
                "Delete file": "删除文件",

        // wiki 编辑器（补全未翻译部分
            // 工具栏
                "Header 1": "1 级标题",
                "Header 2": "2 级标题",
                "Header 3": "3 级标题",

                "Image": "图片",
                    "Insert Image": "插入图片",
                        "Image URL": "图片 URL",
                        "Alt Text": "文本",

                "Unordered List": "无序列表",
                "Ordered List": "有序列表",
                "Blockquote": "整段引用",
                "Horizontal Rule": "水平规则",

                "Help": "帮助",
                    "Block Elements": "段落元素",
                        "Paragraphs & Breaks": "图表 & 段落",
                            "To create a paragraph, simply create a block of text that is not separated by one or more blank lines. Blocks of text separated by one or more blank lines will be parsed as paragraphs.": "要创建一个段落，只需创建一个没有一个或多个空行分隔的文本块即可。被一个或多个空行分隔的文本块将被解析为段落。",
                            "If you want to create a line break, end a line with two or more spaces, then hit Return/Enter.": "如果要创建换行符，请在行尾空两格或更多格，然后按 Return/Enter 键。",
                        "Headers": "标题",
                            // Markdown 支持两种标题格式。维基编辑器使用“atx”样式的标题。只需在标题文本前加上 # 字符数即可指定标题深度。例如：# 1 级标题，## 2 级标题 和 ### 3 级标题 的标题将逐渐变小。您可以用任意数量的#号结束标题。
                            "Markdown supports two header formats. The wiki editor uses the “atx”-style headers. Simply prefix your header text with the number of": "Markdown 支持两种标题格式。维基编辑器使用“atx”样式的标题。只需在标题文本前加上",
                            "characters to specify heading depth. For example:": "字符数即可指定标题深度。例如：",
                            "will be progressively smaller headers. You may end your headers with any number of hashes.": "的标题将逐渐变小。您可以用任意数量的#号结束标题。",
                        "Blockquotes": "整段引用",
                            // Markdown 通过在每行前加上 > 来创建电子邮件风格的 “楷体引号”。如果您决定硬包文本并在每行前加上 > 字符，这种方法看起来效果最好，但 Markdown 也支持在段落前加上 >。
                                "Markdown creates blockquotes email-style by prefixing each line with the": "Markdown 通过在每行前加上",
                                ". This looks best if you decide to hard-wrap text and prefix each line with a": "来创建电子邮件风格的 “楷体引号”。如果您决定硬包文本并在每行前加上",
                                "character, but Markdown supports just putting": "字符，这种方法看起来效果最好，但 Markdown 也支持在段落前加上",
                                "before your paragraph.": "。",
                        // 清单
                            // Markdown 支持有序和无序列表。要创建有序列表，只需在每行前加上一个数字（任何数字都可以，这就是编辑器只使用一个数字的原因）。要创建无序列表，可以在每行前加上 *、+ 或 -。
                                "Markdown supports both ordered and unordered lists. To create an ordered list, simply prefix each line with a number (any number will do — this is why the editor only uses one number.) To create an unordered list, you can prefix each line with": "Markdown 支持有序和无序列表。要创建有序列表，只需在每行前加上一个数字（任何数字都可以，这就是编辑器只使用一个数字的原因）。要创建无序列表，可以在每行前加上",
                                "or": "或",
                            // 列表项可以包含多个段落，但每个段落必须缩进至少 4 个空格或一个制表符。
                                "List items can contain multiple paragraphs, however each paragraph must be indented by at least 4 spaces or a tab.": "列表项可以包含多个段落，但每个段落必须缩进至少 4 个空格或一个制表符。",
                        "Code Blocks": "代码块",
                            "Markdown wraps code blocks in pre-formatted tags to preserve indentation in your code blocks. To create a code block, indent the entire block by at least 4 spaces or one tab. Markdown will strip the extra indentation you’ve added to the code block.": "Markdown 将代码块封装在预设格式的标签中，以保留代码块的缩进。要创建代码块，请将整个代码块缩进至少 4 个空格或一个制表符。Markdown 会去掉您添加到代码块中的额外缩进。",
                        "Horizontal Rules": "水平规则",
                            "Horizontal rules are created by placing three or more hyphens, asterisks or underscores on a line by themselves. Spaces are allowed between the hyphens, asterisks or underscores.": "横线规则是将三个或三个以上的连字符、星号或下划线单独放在一行中。连字符、星号或下划线之间允许有空格。",
                    "Span Elements": "引用元素",
                        "Links": "链接",
                            // Markdown 有两种链接类型：内联和引用。对于这两种类型的链接，您希望向用户显示的文本都放在方括号中。例如，如果您想让链接显示文本 “GitHub”，您可以写成 [GitHub]。
                                "Markdown has two types of links:": "Markdown 有两种链接类型：",
                                "inline": "内联",
                                "reference": "引用",
                                ". For both types of links, the text you want to display to the user is placed in square brackets. For example, if you want your link to display the text “GitHub”, you write": "。对于这两种类型的链接，您希望向用户显示的文本都放在方括号中。例如，如果您想让链接显示文本 “GitHub”，您可以写成",
                            // 要创建内嵌链接，请在括号后创建一组括号，并在括号内写入 URL。(例如，[GitHub](https://github.com/)）。内联链接允许使用相对路径。
                                "To create an inline link, create a set of parentheses immediately after the brackets and write your URL within the parentheses. (e.g.,": "要创建内嵌链接，请在括号后创建一组括号，并在括号内写入 URL。(例如，",
                                "). Relative paths are allowed in inline links.": "）。内联链接允许使用相对路径。",
                            // 要创建引用链接，请使用两组方括号。[[我的内部链接|内部引用]]将链接到内部引用。
                                "To create a reference link, use two sets of square brackets.": "要创建引用链接，请使用两组方括号。",
                                "will link to the internal reference": "将链接到",
                        "Emphasis": "强调",
                            // 星号（*）和下划线（_）被视为强调，并用 `<em>` 标签包裹，这在大多数浏览器中通常显示为斜体。双星号（**）或双下划线（__）被视为使用 `<strong>` 标签的粗体。要创建斜体或粗体文本，只需用单个/双个星号/下划线包裹您的单词。例如，**我的双重强调文本** 变成我的双重强调文本，*我的单一强调文本* 变成我的单一强调文本。
                                "Asterisks (": "星号（",
                                ") and underscores (": "）和下划线（",
                                ") are treated as emphasis and are wrapped with an": "）被视为强调，并用",
                                "tag, which usually displays as italics in most browsers. Double asterisks (": "标签包裹，这在大多数浏览器中通常显示为斜体。双星号（",
                                ") or double underscores (": "）或双下划线（",
                                ") are treated as bold using the": "）被视为使用",
                                "tag. To create italic or bold text, simply wrap your words in single/double asterisks/underscores. For example,": "标签的粗体。要创建斜体或粗体文本，只需用单个/双个星号/下划线包裹您的单词。例如，",
                                "becomes": "变成",
                                ", and": "，",
                        // 代码
                            // 要创建内联代码，只需用反标 (`) 将代码包起来即可。Markdown 会将 `myFunction` 变成 myFunction。
                                "To create inline spans of code, simply wrap the code in backticks (": "要创建内联代码，只需用反标",
                                "). Markdown will turn": ") 将代码包起来即可。Markdown 会将",
                                "into": "变成",
                        "Images": "图片",
                            // Markdown 的图像语法与链接语法很相似；基本上是相同的语法，前面加上一个感叹号（!）。例如，如果您想链接到 https://github.com/unicorn.png 网站上的图片，并使用另一文本 “我的独角兽”，您可以写成 ![My Unicorn](https://github.com/unicorn.png)。
                            "Markdown image syntax looks a lot like the syntax for links; it is essentially the same syntax preceded by an exclamation point (": "Markdown 的图像语法与链接语法很相似；基本上是相同的语法，前面加上一个感叹号（",
                            "). For example, if you want to link to an image at": "）。例如，如果您想链接到",
                            "with the alternate text": "网站上的图片，并使用另一文本",
                            ", you would write": "，您可以写成",
                    "Miscellaneous": "杂项",
                        "Automatic Links": "自动链接",
                            // 如果您想创建一个能显示实际 URL 的链接，markdown 允许您用 < 和 > 来快速封装 URL。例如，只要写入 <https://github.com/>，就能轻松创建 https://github.com/ 链接。
                            "If you want to create a link that displays the actual URL, markdown allows you to quickly wrap the URL in": "如果您想创建一个能显示实际 URL 的链接，markdown 允许您用",
                            "to do so. For example, the link": "来快速封装 URL。例如，创建链接",
                            "is easily produced by writing": "只需写入",
                        "Escaping": "忽略",
                            "If you want to use a special Markdown character in your document (such as displaying literal asterisks), you can escape the character with the backslash (": "如果您想在文档中使用特殊的 Markdown 字符（例如显示星号），可以用反斜杠 (",
                            "). Markdown will ignore the character directly after a backslash.": ") 来转义该字符。Markdown 将忽略反斜线后的字符。",
                            //"If you want to use a special Markdown character in your document (such as displaying literal asterisks), you can escape the character with the backslash (\). Markdown will ignore the character directly after a backslash.": "如果您想在文档中使用特殊的 Markdown 字符（例如显示星号），可以用反斜杠 (\) 来转义该字符。Markdown 将忽略反斜线后的字符。",

            // 底部
                "Attach files by dragging & dropping, selecting or pasting them.": "通过拖放、选择或粘贴来添加文件。",
                "Styling with Markdown is supported": "支持使用 Markdown 创建样式",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Welcome to the ([^ ]+) wiki!/, "欢迎访问 $1 的 Wiki"], // wiki页面
        [/edited this page/, "编辑此页"], // wiki
        [/(\d+) revisions?/, "$1 次修订"], // wiki
        [/Editing/, "编辑"], //编辑 wiki
        [/Could not find version "([^ ]+)"/, "找不到版本 “$1”"],
        [/Compare:/, "对比："],
        [/(\d+) additions?/, "$1 处增加"],
        [/(\d+) deletions?/, "$1 处删除"],
    ],
};

I18N["zh-CN"]["repository/branches"] = { // 仓库 - 分支页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 分支页面 branches  /<user-name>/<repo-name>/branches
            // 标签卡栏
            "Overview": "概况",
            "Yours": "您的",
            "Active": "活跃的",
            "Stale": "陈旧的",
            "All branches": "所有分支",
            "All": "所有",
            "branches": "分支",
            "New branch": "新建分支",
                // 创建分支对话框
                "Branch source": "源分支",
                    "Choose from this fork or its upstream repository.": "从此复刻或其上游仓库中进行选择。",
                    "Choose a source branch": "选择源分支",
                "Share feedback": "分享反馈",
            "Search branches…": "搜索分支…",
            "Copy branch name to clipboard": "复制分支名到剪切板",

            "Default branch": "默认分支",
            "Switch default branch": "切换默认分支",
            "View branch activity": "查看分支活动",
            "Default": "默认",

            // [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保护"],
            "Your": "您的",
            "branch isn't protected": "分支不受保护",
            "Protect this branch from force pushing or deletion, or require status checks before merging.": "保护此分支不被强制推送或删除，或在合并之前要求状态检查。",
            "Dismiss": "驳回",
            "Protect this branch": "保护该分支",

            "Updated": "更新于",
            "New pull request": "发起拉取请求",

                // 重命名分支对话框
                "Rename default branch": "重命名默认分支", // 重命名默认分支 标题
                "Rename this branch": "重命名分支", // 重命名其他分支 标题
                "Rename": "重命名",
                "to:": "为：",
                "Most projects name the default branch": "大多数项目将默认分支名为",
                "Renaming this branch:": "重命名此分支：",
                    // 该分支存在来自其他分支的拉取请求时
                        "Will update": "将更新",
                        "pull request targeting this branch.": "条针对该分支的拉取请求。",
                        "pull": "条拉取请求",
                        "request": " ",
                        "targeting this": "针对",
                        "branch.": "该分支。",
                        "branch protection rule that explicitly targets": "条分支保护规则明确针对",

                    // 该分支存在用于其他分支的拉取请求时
                        "Will close": "将关闭",
                        "open pull request for this branch.": "个该分支的拉取请求。",
                        "open pull": "个打开的拉取请求",
                        "for this branch.": "针对该分支。",

                    // 重命名 GitHub Pages 所在分支
                        "Will unpublish current GitHub Pages site.": "将取消当前发布的 GitHub Pages 站点。",
                            "Your current GitHub Pages site will become unpublished. A new commit on the renamed branch will publish the GitHub Pages site again.": "您当前的 GitHub Pages 站点将被取消发布。重命名分支上的新提交将再次发布 GitHub Pages 站点。",

                    "Will not update your members' local environments.": "不会更新您成员的本地环境。",
                "Renaming this branch will not update your members' local environments.": "重命名此分支不会更新您成员的本地环境。",
                    "Your members will have to manually update their local environments. We'll let them know when they visit the repository, or you can share the following commands.": "您的成员将不得不手动更新他们的本地环境。我们会在他们访问仓库时通知他们，或者您可以共享以下命令。",

                "Rename branch": "重命名分支",
                "Saving…": "保存中…",

                "Deleted": "已删除",
                // 删除分支后
                "Restore": "还原",
                "Deleted just now by": "刚刚被删除",

                // 删除对话框 仅当该分支存在拉取请求
                "The branch": "分支",
                // [/is associated with (\d+) open pull requests?:/, "与 $1 个拉取请求相关联："], // 分支页面
                "is associated with an open pull request:": "与 1 个拉取请求相关联：", // 分支页面
                "If you delete this branch, the pull request will be closed.": "如果您删除此分支，则拉取请求将被关闭。",
                "Are you sure you want to delete this branch?": "您确定要删除此分支吗？",

                // 顶部提醒
                // [/Branch ([^ ]+) will be renamed to ([^ ]+) shortly./,"分支 $1 将很快重命名为 $2。"], //分支重命名成功

            "Your branches": "您的分支",
            "You haven’t pushed any branches to this repository.": "您没有推送任何分支到该仓库。",
            "Active branches": "活跃的分支",
            "There aren’t any active branches.": "没有任何活跃的分支。",
            "Stale branches": "陈旧的分支",
            "There aren’t any stale branches.": "没有任何陈旧的分支。",
            "View more active branches": "查看更多活跃的分支",
            "View more stale branches": "查看更多陈旧的分支",

            // [/(\d+) commits? ahead, (\d+) commits? behind ([^ ]+)/, "领先 $1 个提交，落后 $2 个提交于 $3"],

            // 新版分支视图
                // 创建分支对话框
                "Create a branch": "创建分支",
                    "New branch name": "新分支名称",
                    "Source": "源分支",
                        "Switch branches": "切换分支",
                        "Find a branch...": "查找分支…",
                        "default": "默认",
                    "Create new branch": "创建新分支",

                "Search branches...": "搜索分支…",

                // 无匹配结果
                    "No branches": "没有分支",
                    "No branches match the search": "没有符合搜索条件的分支",

                "Check status": "检查状态",
                "Behind": "落后",
                "Ahead": "领先",
                "Pull request": "拉取请求",

                "Copy branch name to clipboard": "将分支名称复制到剪贴板",
                "This branch is protected by branch protections": "该分支受分支保护的保护",

                "Branch menu": "分支菜单",
                    "Activity": "活动",
                    "View rules": "查看规则",
                        "There are no rulesets associated with this branch.": "该分支没有相关的规则集。",

                "View more branches": "查看更多分支",

                // 底部提醒
                    "You can't delete this protected branch.": "您无法删除此受保护分支。",
                    "You can't delete the default branch.": "您不能删除默认分支。",
                    "Branch could not be deleted.": "不能删除分支。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保护"],
        [/Rename default branch/, "重命名默认分支"],
        [/Rename branch/, "重命名分支"],
        [/Your branch name will be ([^ ]+)/, "分支将重命名为 $1"],
        [/Delete branch/, "删除分支"],
        // [/is associated with (\d+) open pull requests?:/, "与 $1 个拉取请求相关联："],
        [/Branch ([^ ]+) will be renamed to ([^ ]+) shortly./,"分支 $1 将很快重命名为 $2。"], //分支重命名成功
        [/(\d+) commits? ahead, (\d+) commits? behind ([^ ]+)/, "领先 $1 个提交，落后 $2 个提交于 $3"],
        [/(\d+) commits? behind ([^ ]+)/, "落后 $1 个提交于 $2"],
        [/(\d+) commits? ahead ([^ ]+)/, "领先 $1 个提交于 $2"],
        [/Ahead behind count: (\d+)/, "领先落后数：$1"],
    ],
    "selector": [ // 元素筛选器规则
        ["a[data-target='branch-filter.allFilter']", "所有分支"],
    ],
    "title": {
        "regexp": [
            [/Branches/, "分支"],
        ],
    },
};

I18N["zh-CN"]["repository/activity"] = { // 仓库 - 活动页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 活动页面 /<user-name>/<repo-name>/activity
            "Activity": "活动",

            "All branches": "所有分支",
                "Switch branches": "切换分支",
                "Find a branch...": "查找分支…",
                "Branches": "分支",
                "default": "默认",
                "View activity for all branches": "查看所有分支的活动",

            "All activity": "所有活动",
                "Direct pushes": "直接推送",
                "Pull request merges": "拉取请求合并",
                "Merge queue merges": "合并队列合并",
                "Force pushes": "强制推送",
                "Branch creations": "创建分支",
                "Branch deletions": "删除分支",

            "All users": "所有用户",
                "Find a user...": "查找用户…",
                "View activity for all users": "查看所有用户的活动",

            "All time": "所有时间",
                "Last 24 hours": "过去 24 小时",
                "Last week": "上星期",
                "Last month": "上个月",
                "Last quarter": "上季度",
                "Last year": "去年",


            "Showing oldest first": "显示最早的",
            "Showing most recent first": "显示最近的",

            "Compare changes": "比较变更",
            "Restore Branch": "恢复分支",

            "Previous": "上一页",
            "Next": "下一页",

            "Direct push": "直接推送",
            "Pull request merge": "拉取请求合并",
            "Force push": "强制推送",
            "Branch creation": "创建分支",
            "Branch deletion": "删除分支",

            "force pushed to": "强制推送到",
            "deleted": "删除",

            "Share feedback about this page": "分享关于此页面的反馈",

        // 活动页面 - 指定分支 /<user-name>/<repo-name>/activity?ref=<branch-name>
            "created this branch": "创建此分支",
            "deleted this branch": "删除此分支",
            "force pushed": "强制推送",

            "No activity matched your search.": "没有与您搜索相匹配的活动。",
            "Try expanding your search by selecting a different branch, activity type, user, or timeframe.": "尝试通过选择不同的分支、活动类型、用户或时间范围来扩大搜索范围。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/pushed (\d+) commits? to/, "推送 $1 个提交到"],
        [/pushed (\d+) commits?/, "推送 $1 个提交"],
    ],
};

I18N["zh-CN"]["repository/releases"] = { // 仓库 - 发行版页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 发行版 页面 /<user-name>/<repo-name>/releases
            "Releases": "发行版",
            // 无发行版时
            "There aren’t any releases here": "没有任何发行版",
            "You can create a release to package software, along with release notes and links to binary files, for other people to use. Learn more about releases in": "您可以创建一个发行版来打包软件，以及发行说明和二进制文件链接，供其他人使用。了解更多关于发行版的信息，查看",
            "our docs": "文档",
            "Releases are powered by": "发行版是指通过对仓库中",
            "tagging specific points of history": "特定历史点",
            "in a repository. They’re great for marking release points like": "进行标记来发布。用于发布的版本号类似",
            "Create a new release": "创建发行版",

            // 有发行版时
            "Draft a new release": "起草发行版",
            "Find a release": "搜索发行版",

                // 搜索未找到
                "No releases found": "无匹配结果",
            // 左侧栏
            "Pre-release": "预发行版",
            "Latest": "最新发行版",
            "Draft": "草案",

            "Compare": "对比",
                "Choose a tag to compare": "选择标签进行比较",
                "Find a tag": "搜索标签",
                "View all tags": "查看全部标签",

            "Read more": "阅读更多内容",
            "Contributors": "贡献者",
            "Assets": "资源",
            // [/Show all (\d+) assets?/, "显示所有 $1 个资产？"],

            "Join discussion": "加入讨论",

            // [/Edit: (.*)/, "编辑：$1"],
            // [/Delete: (.*)/, "删除：$1"],

        // 发行版 标签卡 /<user-name>/<repo-name>/tags
            "Create release": "创建发行版",
            "Edit release": "编辑发行版",

            "Toggle commit message": "显示/隐藏提交消息",

            "Notes": "说明",
            "Downloads": "下载",

            "Delete tag": "删除标签",
                // 删除标签 对话框
                    "Delete this tag?": "删除此标签？",
                    "This will delete the information for the tag": "这将删除标签信息",
                    "and cannot be undone.": "而且无法撤销。",
                    "Delete this tag": "删除此标签",

        // 某个发行版标签 /<user-name>/<repo-name>/releases/tag/<tag>
            // 不存在发行版时
            // "Create release": "创建发行版",
            "from tag": "来自该标签",
            // "Edit": "编辑",
            "release": "发行版",

            // "Read release notes": "阅读发布说明",
            // 状态词
            "released this": "发布于",
            "tagged this": "标记了",
            "drafted this": "起草了",

            // 删除标签对话框
            "Delete tag?": "删除标签？",
            "This will delete the information for this tag and cannot be undone.": "将删除该标签的所有信息，并且无法撤消。",
            "I understand, delete this tag": "我明白了，依然删除该标签",

            // 存在发行版时
            // 15 commits to master since this release

            "Delete release": "删除发行版",
            // 删除发行版对话框
            "Delete this release?": "删除该发行版？",
            // "This will delete the information for this release.": "这将会删除该发行版的信息。",
                "This will delete the information for the release": "这将删除该发行版信息：",
            "Delete this release": "删除发行版",

            // 顶部提醒框
            "Your tag was removed": "您的标签已删除",
            "Your release was removed": "您的发行版已删除",

        // 创建发行版 /releases/new 和 编辑发行版 /releases/edit/<tag>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 提醒条
            "This is a draft and won’t be seen by the public unless it’s published.": "这是一个草案，除非发布，否则不会被公众看到。",
            "This is a draft and won’t be seen by the public unless it is published": "这是一个草案，除非发布，否则不会被公众看到。",
            "Discard draft": "丢弃草案",

            "New Release": "新建发行版", // 上方
            "New release": "新建发行版", // 下方

            "Release notes": "发行版说明",
                "Select a previous tag to create generated release notes": "选择一个先前的标签以生成发行说明",

            "Choose a tag": "选择标签",
                "Find or create a new tag": "查找或创建新标签",
                "Search or create a new tag": "查找或新建标签",
            "Tag:": "标签：",
                "Select tag": "选择标签",
                "Create new tag": "新建标签",
            "Target:": "目标：",
                "Pick a branch or recent commit": "选择分支或最近的提交",
                "Filter branches…": "筛选分支…",
                "Filter recent commits…": "筛选最近提交…",
                "Recent Commits": "最近提交…",
            "Choose an existing tag, or create a new tag on publish": "选择现有的标签，或在发布时创建新标签",
            "Choose an existing tag, or create a new tag when you publish this release.": "选择现有的标签，或在您发布这个版本时，创建新标签。",

            "Loading tag information…": "载入标签信息…",
            // 在筛选标签框输入 标签时
            "Create new tag:": "创建新标签：",
            "on publish": "发布时",
            // 输入结果
            "Duplicate tag name": "重复的标签名",
                "This tag already has release notes. Would you like to": "这个标签已经有发行说明。您是否愿意",
                "edit them?": "编辑它们？",
                "edit the existing notes": "编辑现有注释",
                "Existing tag": "已存在的标签",
            "Invalid tag name": "无效的标签名",
                "We weren’t able to create the release for you. Make sure you have a valid tag.": "我们无法为您创建发行版。请确保您有一个有效的标签。",
                "There was an error creating your Release: tag name can't be blank, tag name is not well-formed, published releases must have a valid tag.": "创建发行版时出错：标签名称不能为空，标签名称格式不正确，已发布的发行版必须有一个有效的标签。",
                "We can’t create a tag with this name. Take a look at the suggestions in the sidebar for example tag names.": "我们不能用这个名字创建标签。看看侧边栏的建议，看看标签名称的例子。",
            "Excellent! This tag will be created from the target when you publish this release.": "优秀! 当您发布这个版本时，这个标签将从目标创建。",

            "Release title": "发行版标题",

            "Previous tag:": "上一个标签：",
            "Previous tag": "上一个标签",
                "Auto": "自动",
                "auto": "自动",
                "Select previous tag to compare": "选择上一个标签进行比较",
                    "Find previous tag": "筛选上一个标签",
            "Generate release notes": "生成发行版说明",
                "Select a valid tag to automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "选择一个有效的标签，以自动为该差异中的所有合并拉取请求和该版本的贡献者添加至 Markdown 说明",
                "Automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "自动为来自此差异和此发行版贡献者的所有已合并拉取请求，添加 Markdown 说明。",
                "Clear existing notes to automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "清除现有的注释，以自动添加来自此差异和此版本贡献者的所有合并的拉取请求的标记。",

                "There were no pull requests associated with the commits included in this release.": "此版本中没有与提交相关的拉取请求。",

            "Describe this release": "描述此发行版",

            // 编辑器按钮(老版)
                "Add heading text": "添加标题文本",
                "Add bold text, <Ctrl+b>": "添加粗体文本 <Ctrl+b>",
                "Add italic text, <Ctrl+i>": "添加斜体文本 <Ctrl+i>",
                "Add a quote, <Ctrl+Shift+.>": "添加引用 <Ctrl+Shift+.>",
                "Add code, <Ctrl+e>": "添加代码 <Ctrl+e>",
                "Add a link, <Ctrl+k>": "添加链接 <Ctrl+k>",
                "Add a bulleted list, <Ctrl+Shift+8>": "添加无序列表 <Ctrl+Shift+8>",
                "Add a numbered list, <Ctrl+Shift+7>": "添加有序列表 <Ctrl+Shift+7>",
                "Add a task list, <Ctrl+Shift+l>": "添加任务列表 <Ctrl+Shift+l>",
                "Directly mention a user or team": "直接提及用户或团队",
                "Reference an issue, pull request or discussion": "引用议题，拉取请求或讨论",
                "Add saved reply": "添加快捷回复",
                    "Select a reply": "选择回复",
                        "Filter saved replies": "筛选快捷回复",
                        "Create a new saved reply": "创建新快捷回复",
                "Attach files by dragging & dropping, selecting or pasting them.": "通过拖拽、选择或粘贴来附加文件。",

            // 附加文件
            "Attach binaries by dropping them here or selecting them.": "拖拽文件到这来或选择它们来附加文件。",
            "Uploading your release now…": "正在上传到您的发行版…",
            "Uploading your file now…": "正在上传您的文件…",
            "An attachment with that filename already exists.": "同名附件已经存在。",
            "Try a different file.": "请尝试不同的文件。",
            "We don’t support that file type.  try zipping it.": "我们不支持该文件类型，请尝试压缩它。",
            "Try another file.": "请尝试另一个文件。",
            "Yowza, that’s a big file.": "哟，这可是个大文件。",
            "Try again": "请尝试",
            "With a file smaller than 2GB.": "一个小于 2GB 的文件。",
            "This file is empty.": "这是一个空文件。",
            "with a file that’s not empty.": "一个非空的文件。",
            "Something went really wrong, and we can’t process that file.": "确实出了点问题，我们无法处理该文件。",
            "Try again.": "请重试。",

            // "Delete and try uploading this file again.": "删除并重新上传。",
            "Upload failed. Delete and try uploading this file again.": "上传失败。请删除并重新上传。",
            "will be deleted": "将被删除",
            "Remove": "删除",
            "Undo": "撤销",

            "Set as a pre-release": "设置为预发布版本",
                "This release is labeled as non-production ready.": "此版本标记为非正式版本。",
                "This release will be labeled as non-production ready": "此版本将被标记为非正式版本。",
            "Create a discussion for this release": "为此版本创建讨论",
                "People will be able to leave comments and reactions on this release using Discussions.": "人们将能够使用“讨论”对此版本发表评论和反应。",
                        "Category:": "类别：",
                            "Announcements": "公告",
                            "General": "通常",
                            "Ideas": "想法",
                            "Polls": "投票",
                            "Q&A": "问与答",
                            "Show and tell": "展示与讲述",
            "Set as the latest release": "设置为最新版本", //edit
                "This release is labeled as the latest for this repository.": "此版本将被标记为此仓库的最新版本。",
                "This release will be labeled as the latest for this repository.": "此版本将被标记为此仓库的最新版本。",

            "Publish release": "发布发行版",
                "Publishing…": "发布中…",
            "Update release": "更新发行版",
                "Saving release…": "保存中…",
            "Save draft": "保存草案",
            "Saved!": "已保存",
            "Saving draft failed. Try again?": "保存草案失败。请重试？",

            // 丢弃草案 对话框
            "Are you sure?": "您确定哇?",
            "This will delete the information for this draft.": "这将会删除该草案的信息。",
            "Delete this draft": "删除草案",

            // 右侧栏
            "Tagging suggestions": "标签建议",
            "It’s common practice to prefix your version names with the letter": "通常的做法是在版本名称前加上字母",
            ". Some good tag names might be": "。一些好的标签名称可能是",
            "If the tag isn’t meant for production use, add a pre-release version after the version name. Some good pre-release versions might be": "如果标签不是用于生产的，就在版本名后面加上预发布版本。一些好的预发布版本可能是",

            "Semantic versioning": "语义版本管理",
            "If you’re new to releasing software, we highly recommend to": "如果您是发布新手，我们强烈您",
            "learn more about semantic versioning.": "了解更多关于语义版本管理的信息。",

            "A newly published release will automatically be labeled as the latest release for this repository.": "新发布的版本将自动标记为该仓库的最新版本。",
            "If \'Set as the latest release\' is unchecked, the latest release will be determined by higher semantic version and creation date.": "如果未选中 “设置为最新版本”，则最新版本将由更高语义版本和创建日期确定。",
            "Learn more about release settings.": "了解更多关于发行版设置的信息。",

       // 创建 Action 发行版到市场 /releases/new?marketplace 和 编辑 /releases/edit/... >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Release Action": "发布 Action",
                "Publish this release to the GitHub Marketplace": "将此版本发布到 GitHub 市场",
                "You must": "您必须",
                "accept the GitHub Marketplace Developer Agreement": "接受 GitHub 市场开发者协议",
                "before publishing an Action.": "在发布之前。",

                "Publish this Action to the GitHub Marketplace": "将此 Action 发布到 GitHub  市场",
                "Your Action will be discoverable in the Marketplace and available in GitHub search.": "您的 Action 将在市场中被发现，并可在 GitHub 搜索中找到。",

                "Your action.yml needs changes before it can be published.": "您的 action.yml 需要更改才能发布。",
                "Everything looks good! You have all the required information.": "一切看起来都不错！您拥有所有必需的信息。",

                "Name": "名称",
                    "- Name must be unique. Cannot match an existing action, user or organization name.": "- 名称必须唯一。不能与现有的操作、用户或组织名称相匹配。",
                "Description": "描述",
                "Icon": "图标",
                "Color": "颜色",

                "A README exists.": "已经存在 README 文件。",

                "Primary Category": "主要类别",
                    "Choose an option": "请选择",
                "Another Category": "其他分类",
                    "— optional": "— 可选",

        // 发行版评论
            "No significant changes": "无重大变化", // GitHub Action 生成的发行版

        // 反应相关
            "You reacted": "您表达看法",
            "All reactions": "所有看法", // Android UA

    },
    "regexp": [ // 正则翻译
        [/Show all (\d+) assets?/, "显示所有 $1 个资产"],
        [/(\d+) commits?/, "$1 个提交"],
        [/to ([^ ]+) since this release/, "在此发行版之后进入 $1 分支"],  // $1 分支在此发行版之后有 xxx 个提交
        [/This will delete the information for the release ([^ ]+)./, "这将删除发行版 $1 的信息。"],
        [/Toggle (.*)'s commit message/, "切换 $1 的提交消息"],
        [/Edit: (.*)/, "编辑：$1"],
        [/Delete: (.*)/, "删除：$1"],
        [/Remove attached binary ([^ ]+)/, "删除 $1"],
        [/and (\d+) other contributors/, "和另外 $1 个贡献者"],
        [/You and (\d+) others? reacted/, "您和另外 $1 人表达看法"],
        [/^([^ ]+) and ([^ ]+)/, "$1 和 $2"], // 发行版 - 贡献者（2位
        [/(\d+) (people|person) reacted/, "$1 人表达看法"],
        [/There are no releases containing \"([^ ]+)\"./, "没有发行版包含“$1”。"],
        [/Edit (.+)/, "编辑 $1"],
        [/^([^ ]+) will be created on publish/, "$1 将在发布时创建"],
        [/^([^ ]+) is used by another release/, "$1 已存在"], // 省略部分内容
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Releases?/, "发行版"],
            [/Tags/, "标签"],
            [/New release/, "新建发行版"],
        ],
    },
};
I18N["zh-CN"]["repository/tags"] = I18N["zh-CN"]["repository/releases"];

I18N["zh-CN"]["repository/packages"] = { // 仓库 - 软件包页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // /<user-name>/<repo-name>/packages
            "Get started with GitHub Packages": "开始使用 GitHub 软件包",
            "Safely publish packages, store your packages alongside your code, and share your packages privately with your team.": "安全地发布包，将您的包与您的代码一起存储，并与您的团队私下共享您的包。",
             "Choose a registry": "选择注册表",

            "A software platform used for building applications based on containers — small and lightweight execution environments.": "用于构建基于容器的应用的软件平台——小型轻量级执行环境。",
            "A default package manager used for the Java programming language and the Java runtime environment.": "用于 Java 编程语言和 Java 运行环境的一个默认包管理器。",
            "A free and open source package manager used for the Microsoft development platforms including .NET.": "一个自由和开源的开源包管理器，用于包括 .NET 在内的 Microsoft 开发平台。",
            "A standard format for distributing Ruby programs and libraries used for the Ruby programming language.": "分发用于 Ruby 编程语言的 Ruby 程序和库的标准格式。",
            "A package manager for JavaScript, included with Node.js. npm makes it easy for developers to share and reuse code.": "npm 是一个 JavaScript 的包管理器，包含在 Node.js 中。它使开发人员能够轻松地分享和重用代码。",
            "Containers": "容器",
            "A single place for your team to manage Docker images and decide who can see and access your images.": "为您的团队提供一个管理 Docker 镜像的单一场所，并决定谁可以看到和访问您的镜像。",

            "Package settings": "软件包设置",
            "Repository source": "仓库来源",
            "This is the repository where the package's source code is stored. This is defined in the repository's package.json file using the": "这是软件包源代码的仓库。这是在仓库中的 package.json 文件使用字段",
            "field.": "定义的。",
            "A GitHub repository has been identified as the source for this package. This package will be displayed in this repositories package list.": "GitHub 仓库已被确定为该软件包的来源，该软件包将显示在此仓库的软件包列表中。",
            "You have referenced a non-GitHub source for this package that cannot be verified.": "您引用了一个无法验证的非 GitHub 来源的软件包。",
            "Manage Actions access": "操作访问权限管理",
            "Add Repository": "添加仓库",
            "Pick the repositories that can access this package using": "选择可以访问此软件包的仓库，用于",
            "Role:": "角色:",
            "Choose role": "选择角色",
            "Change role": "更改角色",
            "Read": "只读",
            "Write": "编辑",
            "Admin": "管理",
            "Remove": "删除",
            "Actions repository access": "操作仓库访问",
            "Pick the repositories that can access this package using GitHub Actions.": "选择可以使用 GitHub Actions 访问此软件包的仓库。",
            "Permissions added for selected repositories.": "为选定的仓库添加了权限。",
            "Permissions updated for selected repositories.": "更新了选定仓库的权限。",
            "Can upload and download this package. Can read and write package metadata.": "可以上传和下载此软件包，并且可以读取和写入元数据。",
            "Can download this package and read package metadata.": "可以下载此软件包并读取元数据。",
            "Can upload, download, and manage this package. Can read and write package metadata. Can delete and restore packages.": "可以上传、下载和管理此软件包，可以读取和写入元数据，可以删除和恢复此软件包。",
            "Can upload, download, and manage this package. Can read and write package metadata. Can grant package permissions.": "可以上传、下载和管理此软件包，可以读取和写入元数据，可以授予软件包权限。",
            "Manage Codespaces access": "代码空间访问管理",
            "Codespaces repository access": "代码空间仓库访问",
            "Pick the repositories that can read this package using GitHub Codespaces.": "选择可以使用 GitHub 代码空间 读取此软件包的仓库。",
            "Pick the repositories that can read this package using": "选择可以读取此软件包的仓库，用于",
            "Inherited access": "继承访问",
            "Inherit access from source repository (recommended)": "从源仓库继承访问权限 (推荐)",
            "Go to": "转到",
            "to change access, or remove inherited access to manage it separately. Inherited access is recommended.": "的访问设置以更改访问权限，或删除继承的访问权限以单独管理它，建议使用继承访问权限。",
            "Danger Zone": "危险操作",
            "Change package visibility": "更改软件包可见性",
            "This package is currently public.": "该软件包当前是公开的",
            "This package is currently private.": "该软件包当前是私有的",
            "Change visibility": "更改可见性",
            "Delete this package": "删除软件包",
            "Once you delete a package, there is no going back. Please be certain.": "您一旦删除了软件包，将再也无法恢复，请确认！",
            "Manage access": "访问管理",
            "Invite teams or people": "邀请团队或人员",

        // 仓库链接对话框
            "Confirm you want to unlink this repository": "确认您要取消与此仓库的链接",
            "Yes, unlink this repository": "是的，取消链接此仓库",

        // 添加仓库对话框
            "Select repository that can access this package using GitHub actions": "选择可以使用 GitHub 操作访问此软件包的仓库",
            "Add repositories": "添加仓库",

        // 删除仓库对话框
            "Confirm you want to remove this repository": "确认要删除此仓库",
            "Once removed,": "删除后，",
            "will no longer have access to the": "将无法再访问",
            "package.": "软件包。",

        // 代码空间添加仓库对话框
            "Select repository that can access this package using GitHub codespaces": "选择可以使用 GitHub 代码空间访问此软件包的仓库",

        // 更改软件包可见性对话框
            "Make this package visible to anyone.": "使这个软件包对所有人都可见。",
            "Make this package visible privately, to organization members that have access.": "仅这个软件包有权访问的组织成员可见。",
            "Please type": "请输入",
            "to confirm:": "进行确认：",
            "I understand the consequences, change package visibility.": "我明白后果，依然更改软件包可见性",

        // 删除软件包对话框
            "Are you absolutely sure?": "您真的确定吗？",
            "Once this package is deleted, it will no longer be accessible.": "一旦删除了这个软件包，您将无法再访问它。",
            "This action will delete package": "此操作将删除软件包",
            ". Versions of this package will no longer be accessible, and it will not appear in searches or package listings.": "。此软件包的版本将不再可访问，并且不会出现在搜索结果或软件包列表中。",
            "I understand the consequences, delete this package": "我明白后果，依然删除这个软件包",

        // 更改仓库角色对话框
            "Select a new role": "选择新角色",
            "Recommended for non-code contributors who want to view or discuss your package.": "推荐给想要查看或讨论您的软件包的非代码贡献者。",
            "Recommended for contributors who actively push to your package.": "推荐给积极推送代码到您的软件包的贡献者。",

        // 更改成员角色对话框
            "Recommended for people who need full access to the package, including sensitive and destructive actions like managing security and package visibility.": "建议需要完全访问软件包的人员使用，包括管理安全性和软件包可见性等敏感和破坏性操作。",

        // 访问管理删除对话框
            "Confirm you want to remove this user": "确认删除该用户",

        // 邀请团队或人员对话框
            "Invite teams or people to": "邀请团队或人员参与",
            "Search by username, full name, or email": "搜索用户名、全名或电子邮件"
    },
    "regexp": [
        [/Are you sure you want to unlink (.*) from (.*)\?/, "您确定要取消 $1 与 $2 的链接吗？"],
        [/(\d+) repositor(y|ies) selected…/, "选中 $1 个仓库"],
        [/Change the role of (\d+) repositor(y|ies)\?/, "更改 $1 个仓库的角色？"],
        [/(\d+) repositor(y|ies)/, "$1 个仓库"],
        [/(\d+) members? selected…/, "选中 $1 个成员"],
        [/Change the role of (\d+) members?\?/, "更改 $1 个成员的角色？"],
        [/(\d+) members?/, "$1 个成员"],
        [/(.*)'s access settings/, "$1 访问设置"],
        [/Removed access from repository (.*)\./, "删除了仓库 $1 的访问权限。"],
        [/Removed (.*) as a package collaborator\./, "删除了 $1 作为软件包的协作者。"],

        // 删除仓库对话框
        [/Remove (.*) from (.*)/, "从 $2 中删除 $1"],

        // 更改仓库角色对话框
        [/Change (\d+) Roles?/, "更改 $1 个角色"],
    ],
}

I18N["zh-CN"]["repository/pkgs"] = { // 仓库 - 软件包
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository/packages"]["static"],

        // /<user-name>/<repo-name>/pkgs/container/<pag name>
            "Installation": "安装",
                "OS / Arch": "系统 / 架构",
                    "unknown/unknown": "未知/未知",
            "Learn more about packages": "了解更多关于软件包的信息",
            "Learn more about npm packages": "了解更多关于 npm 软件包的信息",
            "Install from the command line": "从命令行安装",
            "Install from the command line:": "从命令行安装：",
            "Install via package.json:": "通过 package.json 安装：",
            "Use as base image in Dockerfile:": "在 Dockerfile 中用作基础镜像：",
            "Recent tagged image versions": "最近被标记的映像版本",
            "latest": "最新",
            "Latest": "最新",
            // [/Published (.*) · Digest/, "发布于 $1 · 摘要"],
            "View all tagged versions": "查看所有被标记的版本",

            "Details": "详细信息",
                "stars": "星标",
            "Readme": "自述文件",
            "Last published": "最新发布",
            "Total downloads": "总下载量",
            "Start a discussion": "开始讨论",
            "Contributors": "贡献者",
            "Open an issue": "打开一个议题",
            "Package settings": "软件包设置",

            "Recent Versions": "最近版本",
            "View and manage all versions": "查看和管理所有版本",

            "Add a Readme to the linked repository": "添加一个 README 自述文件到链接的仓库",
            "The linked repository's Readme will be shown here.": "链接仓库中的 README 自述文件将在此处显示。",

        // 全部版本 /<user-name>/<repo-name>/pkgs/container/<pag name>/versions
            "All versions": "所有版本",
            // [/Published (*)/, "发布于 $1"],
            // [/(\d+) tagged/, "$1 个标记"],
            // [/(\d+) untagged/, "$1 个未标记"],

        // 某个版本 /<user-name>/<repo-name>/pkgs/container/<pag name>/<version id>
            "About this version": "关于这个版本",
            "Manifest": "清单",
            "No description provided": "未提供说明",
            "This package version was published": "此版本软件包发布于",

            "To provide a description, add the following line to your Dockerfile:": "要提供描述，请将以下行添加到您的 Dockerfile 中：",
            "For multi-arch images, set a value for the": "对于多架构镜像，请设置",
            "key in the": "值在",
            "field of the manifest:": "字段：",
            "Learn more about labelling container images": "了解更多关于标记容器镜像的信息",

            "Download activity": "下载活动",
                "Download activity of this version": "此版本的下载活动",
            "Last 30 days": "最近 30 天",
            "Last week": "最近一周",
            "Today": "今天",

            "Other tags on this version": "此版本的其他标签",
            "View all versions": "查看全部版本",

        // 版本删除对话框
            "Are you absolutely sure?": "您真的确定吗？",
            "This cannot be undone. This will permanently delete the version": "这个操作不能撤销，这将永久删除版本",
            "so users and processes won’t be able to download this version.": "，用户和程序将无法再下载该版本。",
            "Please type": "请输入",
            "to confirm:": "进行确认：",
            "I understand the consequences, delete this version": "我明白后果，依然删除此版本"
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository/packages"]["regexp"],

        //[/Published (.*) · Digest/, "发布于 $1 · 摘要"],
        [/Published (.*) · Digest/, (match, p1) => { // p1为(.+)
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `发布于 ${translatedDate} · 摘要`;
        }],
        [/Published (.*)/, "发布于 $1"],
        [/(\d+) tagged/, "$1 个标记"],
        [/(\d+) untagged/, "$1 个未标记"],
        [/(\d+) dependencies/, "$1 个依赖包"],
        [/(\d+) active/, "$1 个可用"],
        [/(\d+) deleted/, "$1 个已删除"],
        [/(\d+) contributors?/, "$1 位贡献者"],
    ],
};
I18N["zh-CN"]["packages"] = { // 软件包 - 未链接仓库的软件包
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository/pkgs"]["static"],

        "Link this package to a repository": "将此软件包链接到仓库",
        "By linking to a repository, you can automatically add a Readme, link discussions, and show contributors on this page.": "通过链接到仓库，您可以自动添加 README 自述文件、链接讨论、在此页面上显示贡献者。",
        "Connect Repository": "关联仓库",

        // 关联仓库对话框
        "Select a repository to link to this package.": "选择一个仓库以链接到此软件包。"
    },
    "regexp": [  // 正则翻译
        ...I18N["zh-CN"]["repository/pkgs"]["regexp"],
    ],
};

I18N["zh-CN"]["repository/security"] = { // 仓库 - 安全页面
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],

        // 安全标签卡 & 安全概述 /<user-name>/<repo-name>/security

            // 公共部分
            "Reporting": "报告",
                "Policy": "政策",
                "Advisories": "咨询",
            "Vulnerability alerts": "漏洞警报",
                "Code scanning": "代码扫描",
                "Secret scanning": "机密扫描",

            "Disabled": "禁用",
            "Enabled": "启用",
            "Needs setup": "需要设置",

            "Security overview": "安全概述",
            "Report a vulnerability": "报告漏洞",
            "Fork this repository and edit the file": "复刻此仓库并编辑文件",
            "Security policy •": "安全政策 •",
                "Define how users should report security vulnerabilities for this repository": "定义用户应如何报告此仓库的安全漏洞",

                "Suggest how users should report security vulnerabilities for this repository": "建议用户应如何报告此仓库的安全漏洞",
                "Suggest a security policy": "安全政策建议",

                "View how to securely report security vulnerabilities for this repository": "查看如何安全地报告此仓库的安全漏洞",
                "View security policy": "查看安全策略",

            "Security advisories •": "安全公告 •",
                "View or disclose security advisories for this repository": "查看或公开此仓库的安全公告",
                "View security advisories": "查看安全公告",
                "View security advisories for this repository": "查看此仓库的安全公告",

            "Private vulnerability reporting •": "私下漏洞报告 •",
                "Allow users to privately report potential security vulnerabilities": "允许用户私下报告潜在的安全漏洞",
                "Enable vulnerability reporting": "启用漏洞报告",
                "See reported vulnerabilities": "查看报告的漏洞",

            "Dependabot alerts •": "Dependabot 警报 •",
                "— Active": "— 激活",
                "Get notified when one of your dependencies has a vulnerability": "当您的一个依赖项存在漏洞时得到通知",
                "Enable Dependabot alerts": "启用 Dependabot 警报",
                "View Dependabot alerts": "查看 Dependabot 警报",
                "You don't have permissito enable this feature":"您没有启用此功能的权限。",

            "Code scanning alerts •": "代码扫描警报 •",
                "Automatically detect common vulnerability and coding errors": "自动检测常见漏洞和编码错误",
                "Set up code scanning": "设置代码扫描",
                "View alerts": "查看警报",
                // 私有库
                "Advanced Security is only available for Organizations": "高级安全只适用于组织",
                "Find out more": "了解更多",
                "Code scanning for private repositories is part of GitHub Advanced Security": "私有仓库的代码扫描是 GitHub 高级安全的一部分", //组织仓库
                "Contact sales": "联系销售", //组织仓库

            "Secret scanning alerts •": "机密扫描警报 •",
                "Get notified when a secret is pushed to this repository": "当机密被推送到仓库时得到通知",
                "Enable in settings": "在设置中启用",
                "View detected secrets": "查看检测到的机密",

            // "Vulnerability details": "漏洞详情",
            "High severity": "高风险",
            "Moderate severity": "中风险",
            "Low severity": "低风险",
            // "Create dependabot security update": "创建可靠的安全更新",

            "Suggest a policy": "建议政策",

            "Code scanning configuratierror": "代码扫描配置错误",
                "CodeQL is reporting errors. Check the": "CodeQL 出错。检查",
                "status page": "状态页",
                "for help.": "以寻求帮助",

            "Checking code scanning status...": "正在检查代码扫描状态",

        // 安全政策 /<user-name>/<repo-name>/security/policy
            "Set up a security policy": "制定安全政策",
            "Help your community understand how to securely report security vulnerabilities for your project.": "帮助您的社区了解如何安全地报告项目的安全漏洞。",
            "Start setup": "开始设置",

            "No security policy detected": "未检测到安全策略",
            "This project has not set up a": "该项目尚未设置",
            "file yet.": "文件。",

        // 安全公告 /<user-name>/<repo-name>/security/advisories
            "Security Advisories": "安全公告",
            "Privately discuss, fix, and publish information about security vulnerabilities in your repository's code.": "私人讨论，修复和发布仓库代码中的安全漏洞的信息。",
            "New draft security advisory": "新的安全建议草案",

            // [/(\d+) Draft/, "$1 项草案"],
            // [/(\d+) Published/, "$1 项已发布"],
            // [/(\d+) Closed/, "$1 项已关闭"],

            "There aren’t any triage security advisories": "没有任何安全建议通知",
            "There aren’t any draft security advisories": "没有任何安全建议草案",
            "There aren’t any published security advisories": "没有任何已发布的安全公告",
            "There aren’t any closed security advisories": "没有任何已关闭的安全公告",

            // 他人库
            "View information about security vulnerabilities from this repository's maintainers.": "查看仓库维护者提供的安全漏洞信息。",

        // Dependabot 警报 /<user-name>/<repo-name>/security/dependabot
            "Dependabot alerts": "Dependabot 警报",
            "Dependency files checked": "检查依赖文件",

            "Ignore the false alarms": "忽略误报",
            "To help you focus on the alerts that matter, Dependabot now proactively dismisses low impact alerts. These alerts may only have limited effects (e.g. long-running builds or tests) or are unlikely to be exploitable.": "为了帮助您专注于重要的警报，Dependabot 现在会主动消除低影响警报。这些警报可能只会产生有限的影响（例如长时间运行的构建或测试）或不太可能被利用。",
            "Opt out": "设置",
            "learn more about auto-dismissing alerts.": "了解更多关于自动撤消警报的信息。",

            "Auto-triage your alerts": "自动分类您的警报",
                "Control how Dependabot opens pull requests, ignores false positives and snoozes alerts. Rules can be enforced at the organization level. Free for open source and available for private repos through": "控制 Dependabot 如何打开拉取请求、忽略误报和推迟警报。规则可以在组织层面强制执行。免费供开源项目使用，私有仓库需要通过",
                "GitHub Advanced Security.": "GitHub 高级安全性。",
                "Learn more about auto-triage": "了解更多关于自动分类的信息",

            "opened": "打开于",

            "Dependabot alerts are disabled.": "Dependabot 警报已禁用。",
            "To receive Dependabot alerts, you must first enable Dependabot alerts in": "要接收 Dependabot 警报，必须首先启用 Dependabot 警报",
            "this repository’s settings": "在仓库的设置中",

            "Welcome to Dependabot alerts!": "欢迎使用 Dependabot 警报！",
            "Dependabot alerts track security vulnerabilities that apply to your repository's dependencies. As alerts are created, they’ll appear here.": "Dependabot 警报跟踪适用于仓库依赖项的安全漏洞。一旦创建警报后，它们将显示在此处。",

            "Configure": "设置",
                "Manage repository vulnerability settings": "管理仓库漏洞设置",
                "Manage Dependabot rules": "管理 Dependabot 规则",
                "Manage account notification settings": "管理账户通知设置",
                "Refresh Dependabot alerts": "刷新 Dependabot 警报",
                    "Reprocess your project's current dependency files.": "重新处理项目当前的依赖项文件。",
                    // 顶部提醒
                        "Refresh queued, it may take several minutes to see changes reflected in your alerts.": "刷新队列后，可能需要几分钟才能看到警报中反映的更改。",
                        "Refreshed recently, available again in about 1 hour.": "最近刷新，约 1 小时后可再次使用。",

            "Search all Dependabot alerts": "搜索所有 Dependabot 警报",
                "- submit": "- 提交",
                "Narrow your search": "缩小搜索范围",
                    "fix-started, no-bandwidth, tolerable-risk, inaccurate, not-used, fixed, auto-dismissed": "修复启动、无带宽、可容忍风险、不准确、未使用、已修复、自动忽略",
                    "critical, high, moderate, low": "严重、高、中、低",
                    "package-name": "软件包名称",
                    "ecosystem-name": "生态系统名称",
                    "most-important, newest, oldest, severity, manifest-path, package-name, epss-percentage": "最重要、最新、最旧、严重性、清单路径、软件包名称、EPSS-百分比",
                    "open, closed": "打开、关闭",
                    "patch": "补丁",
                    "runtime, development": "运行时、开发",
                    "direct": "直接",
                    "team-name": "团队名称",
                    "topic-name": "主题名称",
                    "CVE exploitation likelihood. `n`, `>n`, `<n`, `>=n`, `<=n`, or range `n..n`, where `n` is a number from 0.0 to 1.0": "CVE 被利用的可能性。`n`, `>n`, `<n`, `>=n`, `<=n` 或范围 `n...n`，其中 `n` 为 0.0 至 1.0 之间的数字",
                    "manifest-name": "清单名称",

            // 筛选条
                "Closed as": "关闭",
                    "Filter by resolution": "按决议筛选",
                    "Clear resolution": "清除决议筛选",
                        "A fix has already been started": "修复已经开始",
                        "No bandwidth to fix this": "没有带宽来修复",
                        "Risk is tolerable to this project": "风险可承受",
                        "This alert is inaccurate or incorrect": "此警报不准确或不正确",
                        "Vulnerable code is not actually used": "漏洞代码实际未使用",
                        "Dismissal comment": "忽略评论",
                        "Dismiss Alerts": "忽略警报",
                        "Fixed": "已修复",
                        "fixed": "已修复",
                        "Auto-dismissed": "自动忽略",
            "Package": "软件包",
                "Filter by packages": "按软件包筛选",
                "Clear package filter": "清除软件包筛选器",
                "No results found": "未找到结果",
            "Ecosystem": "生态系统",
                "Filter by ecosystem": "按生态系统筛选",
                "Clear ecosystem filter": "清除生态系统筛选器",
            "Manifest": "清单",
                "Filter by manifest": "按清单筛选",
                "Clear manifest filter": "清除清单筛选器",
            "Severity": "严重等级",
                "Filter by severity": "按严重性筛选",
            "Sort": "排序",
                "Most important": "最重要的",
                "Newest": "最新的",
                "Oldest": "最早的",
                "Manifest path": "表现路径",
                "Package name": "包名称",

            "selected": "条被选中",
            "Dismiss alerts": "忽略警报",
                "Select a reason to dismiss": "选择忽略理由",

            "opened": "打开于",

            "No results matched your search.": "没有与您的搜索匹配的结果。",
            "Clear current search filters.": "清除当前搜索筛选器。",

            "ProTip!": "专业提示！",
                "See auto-dismissed alerts with": "要查看自动解除的警报，请使用",
                "to see alerts without an available fix.": "来查看没有可用修复程序的警报。",
                "Find alerts on your dev dependencies using": "使用以下命令查找开发依赖项的警报：",
                "to see alerts with calls to vulnerable functions.": "查看调用易受攻击函数的警报。",

         // 具体某条 Dependabot 警报 /security/dependabot/<id>
            "Dismiss alert": "忽略警报",

            "Opened": "打开",
            // [/Upgrade ([^ ]+) to fix/, "升级 $1 去修复"], // 某个 Dependabot 警报
            // [/Upgrade ([^ ]+) to version/, "升级 $1 到版本"], // 某个 Dependabot 警报
            "Create Dependabot security update": "创建 Dependabot 安全更新",

            // [/Dependabot cannot update ([^ ]+) to a non-vulnerable version/, "Dependabot 无法将 $1 更新为无漏洞的版本"],
            "The latest possible version that can be installed is": "最新可以安装版本是",
            "because of the following conflicting dependency:": "，但是存在以下冲突的依赖项：",
            "because of the following conflicting dependencies:": "，但是存在以下冲突的依赖项：",
            "The earliest fixed version is": "最早修复版本为",
            "Try again": "再试一次",
            "View logs": "查看日志",
            "about troubleshooting Dependabot errors": "关于排除 Dependabot 错误的信息",

            "Transitive dependency": "通过",
            "is introduced via": "传递依赖性",

            "Patched version": "补丁版本",

            "Impact": "影响",
            "Patches": "补丁",
            "Workarounds": "解决方法",
            "Workarounds / Mitigations": "解决方法/缓解措施",
            "References": "参考信息",
            "For more information": "更多信息",

            // [/Bump ([^ ]+) from ([^ ]+) to ([^ ]+)/, "将 $1 从 $2 升级到 $3"],
            "Merging this pull request would fix": "合并此拉取请求将修复",
            "Review security update": "审查安全更新",

            "opened this": "打开了这个",

            // 右侧栏
                "This score calculates overall vulnerability severity from 0 to 10 and is based on the Common Vulnerability Scoring System (CVSS).": "该分数以通用漏洞评分系统 (CVSS) 为基础，从 0 到 10 计算总体漏洞严重性。",
                "CVSS v4 base metrics": "CVSS v4 基本指标",
                    "Exploitability Metrics": "可利用性指标",
                        "Attack Vector": "攻击载体",
                            "Network": "网络",
                            "Local": "本地",
                        "Attack Complexity": "攻击复杂性",
                        "Attack Requirements": "攻击要求",
                        "Privileges Required": "所需权限",
                            "None": "无",
                        "User interaction": "用户交互",
                            "Required": "必须",
                    "Vulnerable System Impact Metrics": "脆弱系统影响指标",
                        "Confidentiality": "保密性",
                        "Integrity": "完整性",
                        "Availability": "可利用性",
                    "Subsequent System Impact Metrics": "后续系统影响指标",
                    "Learn more about base metrics": "了解更多关于基础指标的信息",

                    // CVSS v4 基本指标 对话框 // BUG: 详细解释文本翻译不生效
                    // 可利用性指标
                        "Attack Vector:": "攻击载体：",
                            "This metric reflects the context by which vulnerability exploitation is possible. This metric value (and consequently the resulting severity) will be larger the more remote (logically, and physically) an attacker can be in order to exploit the vulnerable system. The assumption is that the number of potential attackers for a vulnerability that could be exploited from across a network is larger than the number of potential attackers that could exploit a vulnerability requiring physical access to a device, and therefore warrants a greater severity.": "该指标反映漏洞被利用的可能性的上下文。攻击者距离越远（逻辑上和物理上），该指标值（以及由此得出的严重性）就越高。假设可以从网络上利用的漏洞比需要物理访问设备的漏洞拥有更多的潜在攻击者，因此严重性更高。",
                        "Attack Complexity:": "攻击复杂性：",
                            "This metric captures measurable actions that must be taken by the attacker to actively evade or circumvent existing built-in security-enhancing conditions in order to obtain a working exploit. These are conditions whose primary purpose is to increase security and/or increase exploit engineering complexity. A vulnerability exploitable without a target-specific variable has a lower complexity than a vulnerability that would require non-trivial customization. This metric is meant to capture security mechanisms utilized by the vulnerable system.": "该指标衡量攻击者为绕过或规避现有内置安全机制而必须采取的可量化操作。这些机制的主要目的是提升安全性或增加利用难度。不需要目标特定变量的漏洞比需要非平凡定制的漏洞复杂性更低。",
                        "Attack Requirements:": "攻击要求：",
                            "This metric captures the prerequisite deployment and executiconditions or variables of the vulnerable system that enable the attack. These differ from security-enhancing techniques/technologies (ref Attack Complexity) as the primary purpose of these conditions is not to explicitly mitigate attacks, but rather, emerge naturally as a consequence of the deployment and execution of the vulnerable system.": "该指标衡量使攻击成为可能的先决部署和执行条件或变量。这些条件与安全增强技术不同（参见攻击复杂性），它们并非专门用于缓解攻击，而是脆弱系统部署和运行的自然结果。",
                        "Privileges Required:": "所需权限：",
                            "This metric describes the level of privileges an attacker must possess prior to successfully exploiting the vulnerability. The method by which the attacker obtains privileged credentials prior to the attack (e.g., free trial accounts), is outside the scope of this metric. Generally, self-service provisioned accounts do not constitute a privilege requirement if the attacker can grant themselves privileges as part of the attack.": "该指标描述攻击者在成功利用漏洞前必须拥有的权限级别。攻击者在攻击前获取特权凭据的方式（如免费试用账户）不在本指标范围内。",
                        "User interaction:": "用户交互：",
                            "This metric captures the requirement for a human user, other than the attacker, to participate in the successful compromise of the vulnerable system. This metric determines whether the vulnerability can be exploited solely at the will of the attacker, or whether a separate user (or user-initiated process) must participate in some manner.": "该指标衡量除攻击者外是否需要其他人类用户参与才能成功攻破脆弱系统。",
                    // 脆弱系统影响指标
                        "Confidentiality:": "机密性：",
                            "This metric measures the impact to the confidentiality of the informatimanaged by the VULNERABLE SYSTEM due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, as well as preventing access by, or disclosure to, unauthorized ones.": "该指标衡量成功利用漏洞后对脆弱系统所管理信息的机密性影响。",
                        "Integrity:": "完整性：",
                            "This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information. Integrity of the VULNERABLE SYSTEM is impacted when an attacker makes unauthorized modificatiof system data. Integrity is also impacted when a system user can repudiate critical actions taken in the context of the system (e.g. due to insufficient logging).": "该指标衡量成功利用漏洞后对信息的可信度和准确性的影响。",
                        "Availability:": "可用性：",
                            "This metric measures the impact to the availability of the VULNERABLE SYSTEM resulting from a successfully exploited vulnerability. While the Confidentiality and Integrity impact metrics apply to the loss of confidentiality or integrity of data (e.g., information, files) used by the system, this metric refers to the loss of availability of the impacted system itself, such as a networked service (e.g., web, database, email). Since availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of a system.": "该指标衡量成功利用漏洞后对脆弱系统本身可用性的影响（如网络服务被打挂）。",
                    // 后续系统影响指标
                        // 机密性
                            "This metric measures the impact to the confidentiality of the informatimanaged by the SUBSEQUENT SYSTEM due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, as well as preventing access by, or disclosure to, unauthorized ones.": "该指标衡量成功利用漏洞后对后续系统所管理信息的机密性影响。",
                        // 完整性
                            "This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information. Integrity of the SUBSEQUENT SYSTEM is impacted when an attacker makes unauthorized modificatiof system data. Integrity is also impacted when a system user can repudiate critical actions taken in the context of the system (e.g. due to insufficient logging).": "该指标衡量成功利用漏洞后对后续系统数据完整性的影响。",
                        // 可用性
                            "This metric measures the impact to the availability of the SUBSEQUENT SYSTEM resulting from a successfully exploited vulnerability. While the Confidentiality and Integrity impact metrics apply to the loss of confidentiality or integrity of data (e.g., information, files) used by the system, this metric refers to the loss of availability of the impacted system itself, such as a networked service (e.g., web, database, email). Since availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of a system.": "该指标衡量成功利用漏洞后对后续系统本身可用性的影响。",

                "EPSS score": "EPSS 得分",
                "Weaknesses": "缺陷",
                "Related alerts": "相关警报",
                "See advisory in GitHub Advisory Database": "请参阅 GitHub 咨询数据库中的咨询",
                "See all of your affected repositories": "查看您所有受影响的仓库",
                "See something to contribute?": "看到有什么可贡献的吗？",
                "Suggest improvements for this advisory on the GitHub Advisory Database.": "在 GitHub 咨询数据库上建议改进此咨询。",

            // 生成安全更新
                // 顶部提醒
                    // [/Started generating a security update for ([^ ]+)./, "开始为 $1 生成安全更新。"],
                // [/Creating a security update for ([^ ]+)/, "为 $1 创建安全更新"],
                "Dependabot is creating a security update to fix": "Dependabot 正在创建一个安全更新来修复",
                // [/(\d+) Dependabot alerts?/, "$1 个 Dependabot 警报"],
                // [/on ([^ ]+) in/, "关于 $1 在"],
                // [/Or, manually upgrade ([^ ]+) to version/, "或者，手动将 $1 升级到版本"],
                "or later. For example:": "或更高。例如：",

         // 具体某条Dependabot 警报 日志 /security/dependabot/<id>/update-logs/<id2>
            "Update logs": "更新日志",

        // 代码扫描器 /<user-name>/<repo-name>/security/code-scanning
            "Automatically detect vulnerabilities in your code.": "自动检测您代码中的漏洞。",
            "Configure tools that integrate with Code Scanning to keep the quality of your code under control. Learn more about": "配置与代码扫描集成的工具，以控制代码质量。了解更多关于",
            "Code Scanning": "代码扫描",

            "Configure scanning tool": "配置扫描工具",

            "All tools are working as expected": "所有工具均按预期运行",
            "Tools": "工具",
            "Add tool": "添加工具",

            // 搜索条
                "Available filters": "可用筛选器",
                    "filter by open/closed state": "按打开/关闭状态筛选",
                    "filter by tool": "按工具筛选",
                    "filter by branch name": "按分支名称筛选",
                    "filter by pr number": "按 PR 号筛选",
                    "filter by ref (e.g. branches/tags)": "按引用筛选（例如 分支/标签）",
                    "filter by rule": "按规则筛选",
                    "filter by rule tag": "按规则标签筛选",
                    "filter by severity": "按严重程度筛选",
                    "sort by": "排序方式",
                    "only show alerts in application code": "仅在应用程序代码中显示警报",
                    "filter by closure reason": "按关闭原因筛选",
                    "filter by file path (e.g. lib/crypto or *_test.js)": "按文件路径筛选（例如 lib/crypto or *_test.js）",
                    "filter by language": "按语言筛选",
                    "filter by assignee": "按受理人过滤",
                    "filter by presence of a property": "按属性的存在进行过滤",
                    "filter by absence of a property": "按不存在属性进行过滤",
                "Filter alerts": "筛选警报",

            "Language": "语言",
                "Filter by language": "筛选语言",
            "Tool": "工具",
                "Filter by tool": "筛选工具",
            // 分支
                "Filter by branch": "筛选分支",
            "Rule": "规则",
                "Filter by rule": "筛选规则",
                "Filter rules": "筛选规则",
            // 严重等级
                "Medium": "中风险",
                "Error": "错误",
                "Warning": "警告",
                "Note": "注意",

            "Looking good!": "看起来不错！",
                "No new code scanning alerts.": "没有新的代码扫描警报。",
            "No code scanning alerts here!": "尚无代码扫描警报！",
                "Keep up the good work!": "继续努力！",
            "No code scanning alerts found.": "尚无代码扫描警报。",
                "We'll keep watching out for new ones.": "我们会继续关注新的消息。",

            "Detected by": "检测者",
            "in": "在",

            "CodeQL is reporting errors.": "CodeQL 出错。",
            "Check the": "检查",

            // 专业提示
                "You can run CodeQL locally from the command line.": "您可以从命令行在本地运行 CodeQL。",
                "You can run CodeQL locally using Visual Studio Code.": "您可以使用 Visual Studio Code 在本地运行 CodeQL。",
                "CodeQL queries are developed by an open-source coaliticalled the": "CodeQL 查询由一个开源联盟开发：", // BUG: 翻译不生效
                    "GitHub Security Lab": "GitHub 安全实验室",
                "The libraries and queries that power CodeQL are open-source.": "支持 CodeQL 的库和查询是开源的。",
                "You can upload code scanning analyses from other third-party tools using GitHub Actions.": "您可以使用 GitHub Actions 从其他第三方工具上传代码扫描分析。",
                "You can configure CodeQL to run with additional queries.": "您可以配置 CodeQL 以运行其他查询。",

        // 具体某条 代码扫描 警报/<user-name>/<repo-name>/security/security/code-scanning/<id>
            "Code scanning alerts": "代码扫描警报",
            "Speed up the remediatiof this alert with": "加快修复此警报的速度，使用", // BUG: 翻译不生效
                "Copilot Autofix for CodeQL": "CodeQL 的 Copilot 自动修复",
            "Generate fix": "创建修复",
            "Affected branches": "受影响分支",
            "Rule ID": "规则 ID",
            "Query": "查询",
            "View source": "查看源代码",
            "First detected in commit": "首次在提交中检测到",
            "Assignees": "受理人",
                "No one -": "无人 -",
                "Assign yourself": "分配给自己",
                "Assign up to 10 people to this alert": "最多为 10 人分配此警报",
                "Filter assignees": "筛选受理人",
                // Copilot
                    "bot": "机器人",
                    "Ensure a fix has been generated.": "确保已生成修复程序。",
            "Development": "开发",
                "Link a branch, pull request, or": "链接分支、拉取请求或",
                    "create a new branch": "创建新分支",
                    "to start working this alert.": "以开始处理此警报。", // BUG: 翻译不生效
                "Link a branch or pull request": "链接分支或拉取请求",
                "Search pull requests": "搜索拉取请求",
                "Group selected": "已选择组",
            // 受影响的分支
                "Configurations analyzing": "配置分析",
                    "The following configurations have reported this alert.": "以下配置已报告此警报。",
                    "Last updated": "最后更新",
            "Appeared in branch": "出现在分支",

        // /<user-name>/<repo-name>/security/code-scanning/tools/CodeQL/status
            "Scanned files": "扫描文件",
                "Download language CSV report": "下载语言 CSV 报告",
            "Setup types": "设置类型",
            "Default setup": "默认设置",
            "· Last scan": "· 最近一次扫描",
            "Menu": "菜单",
            "View setup type": "查看设置类型",

        // 机密扫描警报 /<user-name>/<repo-name>/security/secret-scanning
            // 顶端窗口
            "Can you give us some feedback?": "您能给我们一些反馈意见吗？",
            "We want to better understand our users' needs and experiences.": "我们希望更好地了解用户的需求和体验。",
            "Book some time with us": "与我们预约时间，",
            "to discuss the GitHub secret scanning experience.": "讨论 GitHub 机密扫描体验。",

            "Secret scanning alerts": "机密扫描警报",
            "Secret scanning disabled": "机密扫描已停用",
                "To scan for secrets, you must first enable secret scanning in": "要扫描机密，您必须首先启用机密扫描在",
                "this repository's settings": "此仓库设置",

            // 关闭
                "Revoked": "已撤销",
                "False positive": "假阳性",
                "Used in tests": "仅测试",
                "Won't fix": "不会修复",
                "Ignored by configuration": "配置忽略",
                "Clear closure reasons": "全部",

            "Bypassed": "绕行",
                "True": "是",
            "Validity": "有效性",
                "Active": "活跃",
                "Inactive": "不活跃",
                "Unknown": "未知",
            "Secret type": "机密类型",
                "Service Providers": "服务提供商",
                "Custom Patterns": "自定义模式",
                "Filter by secret type": "按机密类型筛选",
                "Filter secret type": "筛选机密类型",
                "Nothing to show": "暂无",

            "Provider": "提供者",
                "Filter by provider": "按提供者筛选",
                "Filter provider": "筛选提供者",

            // 排序
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新",

            "Clear current search query, filters, and sorts": "清除当前搜索查询、过滤器和排序",

            "No secrets found.": "没有发现任何机密",
            "Try": "尝试",
            "clearing filters": "清除过滤器",
            "to view all of this repository's secret alerts.": "以查看此仓库的所有机密警报。",
            "Your repository doesn't have any unresolved secrets.": "您的仓库没有任何未解决的机密。",

            // 具体某条信息 https://github.com/<user-name>/<repo-name>/security/secret-scanning/<id>
                "detected a": "检测到",
                    "secret": "机密",
                "Give us feedback": "提交反馈",

                "Close as": "关闭为",
                    "Select a close reason": "选择关闭原因",
                    "This secret has been revoked": "机密被撤销",
                    "This secret is not in production code": "机密不在生产代码中",
                    "This alert is not valid": "警报无效",
                    "This alert is not relevant": "警报无关",

                "Reopen alert": "重新打开",

                    "Close alert": "关闭警报",

                "Secret detected": "检测到",
                "Possibly active secret": "可能活跃",
                    "Copy token": "复制令牌",

                "Remediation steps": "补救措施",
                    "Follow the steps below before you close this alert.": "关闭此警报前，请按照以下步骤操作。",
                    "Rotate the secret if it's in use to prevent breaking workflows.": "如果正在使用，请轮换机密以防中断工作流程。",
                    "Revoke this": "撤销",
                    "through": "通过",
                    "to prevent unauthorized access.": "，以防止未经授权的访问。",
                    //"Revoke this Google API Key through Google to prevent unauthorized access.": "通过 Google 撤销此 Google API 密钥，以防止未经授权的访问。",
                    "Check security logs for potential breaches.": "检查安全日志，查找潜在漏洞。",
                    "Close the alert as revoked.": "关闭已撤销的警报。",

                // 检测到位置
                    "Preview unavailable": "预览不可用",
                    "This file is too large to show a preview": "文件过大，无法显示预览",

                    // 复制
                        "to clipboard": "到剪切板",

                    "View file": "浏览文件",
                    "View git blame": "浏览 Git 追溯",

                // 状态词
                    "opened this alert": "打开此警报",
                    "reopened this": "重新打开",
                    "closed this as": "将其关闭为",
                    "closed as": "关闭为",
                        "used in tests": "仅测试",
                        "won't fix": "不会修复",
                        "revoked": "忽略",
                        "false positive": "假阳性",
                    "closed this as completed in": "将其关闭为已完成",

                "hidden item": "条隐藏项目",
                "s": " ",
                "Load all...": "加载全部…",

        // 新建安全公告草案 /<user-name>/<repo-name>/security/advisories/new
            "Open a draft security advisory": "打开一个安全公告草案",
            "After the draft security advisory is open, you can privately discuss it with collaborators and create a temporary private fork where you can collaborate on a fix. If you've already fixed the vulnerability, just fill out the draft security advisory and then publish it.": "在安全公告草案打开后，您可以与协作者私下讨论，并创建一个临时的私有复刻，在那里您们可以协作进行修复。如果您已经修复了该漏洞，只需填写安全公告草案，然后发布即可。",

            "Advisory Details": "公告详情",
            "Title *": "标题 *",
            "CVE identifier": "CVE 标识符",
                "Request CVE ID later": "稍后请求 CVE ID",
                "I have an existing CVE ID": "我有一个现有的 CVE ID",
            "Description *": "描述 *",

            "Affected products": "受影响的产品",
            "Ecosystem *": "生态系统 *",
                "Don't see the ecosystem you're looking for? It may not be supported yet.": "没有看到您正在寻找的生态系统？可能还不支持。",
                "Select an ecosystem": "选择一个生态系统",
                "Go": "",
                "Other": "其他",
            "Affected versions": "受影响的版本",
            "Patched versions": "补丁版本",
            "Add another affected product": "添加另一个受影响的产品",

            // 严重等级
            "Pending selection": "待选择",

            "Select severity": "选择严重程度",
                "Low": "低风险",
                "Moderate": "中风险",
                "High": "高风险",
                "Critical": "关键风险",
                "Assess severity using CVSS": "使用 CVSS 评估严重程度",

            "Vector string": "矢量字符串",

            "Calculator": "计算器",
                "Learn more about CVSS scoring": "了解更多关于 CVSS 计分的信息",

                "Adjacent": "邻近",
                "Physical": "物理",

            "Common weakness enumerator (CWE)": "常见弱点枚举器 (CWE)",
                "Search by CWE": "按 CWE 搜索",

            "Credits": "用户",
                "Add a user by username, full name, or email": "通过用户名、全名或电子邮件添加用户",

            "Create draft security advisory": "创建安全公告草案",

            // 右侧栏
            "Access and visibility": "访问和可见性",
                "Until it is published, this draft security advisory will only be visible to the maintainers of": "在发布之前，此安全公告草案仅对以下的所有者可见",
                ". Other users and teams may be added once the advisory is created.": "。 其他用户和团队可以在咨询创建后加入。",
            "Once published, security advisories on public repositories are visible to everyone.": "一旦发布，公共仓库上的安全公告对所有人都是可见的。",
            "Once reviewed by GitHub, security advisories may be broadcast on the": "一旦通过 GitHub 的审查，安全公告就可以出现在",
            "GitHub Advisory Database": "GitHub 咨询数据库",
            ". They may also trigger Dependabot alerts to users that depend on this repository.": "。它们还可能向依赖此仓库的用户触发 Dependabot 警报。",

            "Security policy": "安全政策",
            "Glossary and documentation": "词汇表和文档",
            "Dependabot language support": "Dependabot 语言支持",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/([\d,]+) Triages?/, "$1 分类"],
        [/([\d,]+) Draft/, "$1 草案"],
        [/([\d,]+) Published/, "$1 发布"],
        [/([\d,]+) Open/, "$1 打开"],
        [/(#\d+) opened/, "$1 打开于"],
        [/([\d,]+) Closed/, "$1 关闭"],
        [/(#\d+) closed as/, "$1 关闭为"],
        [/(\d+) selected/, "$1 条被选中"],
        [/Detected in (\d+) locations?/, "在 $1 个位置检测到"],
        [/Detected in ([^ ]+)/, "在 $1 中检测到"],
        [/Upgrade ([^ ]+) to fix/, "升级 $1 去修复"], // 某个 Dependabot 警报
        [/Upgrade ([^ ]+) to version/, "升级 $1 到版本"], // 某个 Dependabot 警报
        [/Dependabot cannot update ([^ ]+) to a non-vulnerable version/, "Dependabot 无法将 $1 更新为无漏洞的版本"],
        [/Bump ([^ ]+) from ([^ ]+) to ([^ ]+)/, "将 $1 从 $2 升级到 $3"],
        [/Started generating a security update for ([^ ]+)./, "开始为 $1 生成安全更新。"],
        [/Creating a security update for ([^ ]+)/, "为 $1 创建安全更新"],
        [/(\d+) Dependabot alerts?/, "$1 个 Dependabot 警报"],
        [/on ([^ ]+) in/, "关于 $1 在"],
        [/Or, manually upgrade ([^ ]+) to version/, "或者，手动将 $1 升级到版本"],
        [/on (.+)/, "$1"],
        [/(\d+)\/(\d+) files? scanned/, "$1/$2 文件已扫描"],
        //[/Copy ([^/]\/(?:[^/]+\/)*[^/]+$) to clipboard/, "复制 $1 到剪切板"],
        [/Prototype Pollution in ([^ ]+)/, "$1 上游污染"],
        [/First detected (.+)/, (match, p1) => { // 受影响的分支 // BUG: 翻译不生效
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `初次检测 ${translatedDate}`;
        }],
    ],
    "title": {
        "regexp": [
            [/Security Overview/, "安全概述"],
            [/Security Policy/, "安全政策"],
            [/Security Advisories/, "安全咨询"],
            [/Dependabot alerts?/, "Dependabot 警报"],
            [/Code scanning alerts?/, "代码扫描警报"],
            [/Secret scanning/, "机密扫描"],
        ],
    },
};

I18N["zh-CN"]["repository/contribute"] = { // 仓库 - 贡献页面
    "static": { // 静态翻译

        // 贡献页面 /<user-name>/<repo-name>/contribute
            "Contribute to": "贡献于",
            "Make your first contribution to this repository by tackling one of the issues listed below.": "通过解决下面列出的一个议题，为这个仓库做出您的第一个贡献。",
            "Each issue displayed here is a \"good first issue,\" selected for its relative approachability for first-time contributors.": "此处显示的每个议题都是 “好的首发议题”，因其对首次贡献者来说相对容易。",

            "Read the contributing guidelines": "阅读贡献指南",

            "Good first issues": "好的首发议题",
            "See all issues": "查看所有议题",

            "This repo doesn't have any good first issues, yet": "该仓库暂无任何好的首发议题",
            "Once its maintainers label issues and pull requests for new contributors, they will begin to appear here.": "一旦它的维护者为新的贡献者标记了议题和拉取请求，它们就会开始出现在这里。",
            "All issues in this repository": "此仓库中的所有议题",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["repository/subscription"] = { // 仓库 - 通知状态页面
    "static": { // 静态翻译

        // 仓库通知状态管理 /<user-name>/<repo-name>/subscription
            "Your": "您的",
            "notifications status": "通知状态",
            "A notification is created every time someone discusses something inside of the repository — Pull Requests, Issues, Comments, and Commit discussions. Whether you are watching the repository, not watching it, or ignoring it determines which notifications you receive.": "每当有人在仓库内讨论什么，比如拉取请求、议题、评论和提交讨论，都会产生一个通知。无论您是关注仓库、不关注还是忽略它，都决定了您会收到哪些通知。",
            "Not watching": "不关注",
                "You will only receive notifications when you participate or are @mentioned.": "只有当您参与或被 @您 时，您才会收到通知。",
            "Releases only": "仅发行版",
                "You will only receive notifications for new releases, or when you participate or are @mentioned.": "您只会收到新版本的通知，或者当您参与或被 @您 时。",
            "Watching": "关注",
                "You will receive all notifications for this repository.": "您将收到此仓库的所有通知。",
            "Ignored": "忽略",
                "You will not receive any notifications for this repository.": "您将不会收到有关此仓库的任何通知。",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["repository/invitations"] = { // 仓库 - 接受邀请页面
    "static": { // 静态翻译

        // 接受邀请 /<user-name>/<repo-name>/invitations
            "invited you to collaborate": "邀请您进行协作",
            "invited you to collaborate on": "邀请您进行协作",
            "Accept invitation": "接受邀请",
            "Decline": "拒绝",
            "Decline invitation": "拒绝",
            "Owners": "所有者",
            "Your public profile information": "您的公开个人资料信息",
            "Certain activity": "某些活动",
            "within this repository": "在这个仓库中",
            "Country of request origin": "请求来源国家/地区",
            "Your access level for this repository": "您对该仓库的访问等级",
            "Your IP address": "您的 IP 地址",
            "Is this user sending spam or malicious content?": "此用户是否发送垃圾邮件或恶意内容？",

    },
    "regexp": [ // 正则翻译
        [/of ([^ ]+) will be able to see:/, "$1 将能够看到："], // 邀请页
        [/Block ([^ ]+)/, "拉黑 $1"],
    ],
};


// 洞察 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

I18N["zh-CN"]["repository-insights-menu"] = { // 仓库 -> 洞察 - 公共部分
    "static": { // 静态翻译
        // 公共部分
            // 左侧菜单
            "Pulse": "统计",
            "Contributors": "贡献者",
            "Community": "社区",
            "Community Standards": "社区准则",
            "Community standards": "社区准则",
            "Traffic": "流量",
            "Commits": "提交",
            "Code frequency": "代码频率",
            "Dependency graph": "依赖项关系图",
            // "Punch card": "时刻",
            "Network": "网络",
            // "Members": "成员",
            "Forks": "复刻",
            "Actions Usage Metrics": "操作使用情况",
            "Actions Performance Metrics": "操作数据看板",
            "Actions usage metrics": "操作使用情况",
            "Actions performance metrics": "操作数据看板",

            "People": "成员", //组织仓库

            // 私有库禁用部分功能的提醒
            "Upgrade to GitHub Pro or make this repository public to enable this feature.": "升级到 GitHub Pro 或将此仓库设为公开以启用此功能。",
            // 他人私有库
            "Contact an administrator to upgrade to GitHub Team or make this repository public to enable this feature.": "请联系管理员升级到 GitHub 团队或将此设为仓库公开以启用此功能。",

            "We want to know how these insights are helping you and where they could be improved.": "我们想知道这些洞察如何帮助您，以及在哪些方面可以改进。",
            "Give us your feedback": "向我们提供反馈意见",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["repository/pulse"] = { // 仓库 -> 洞察 - 统计
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 统计 /<user-name>/<repo-name>/pulse
            "Period:": "周期：",
                "Filter activity": "筛选活动",
                "24 hours": "24 小时",
                "3 days": "3 天",
                "1 week": "1 周",
                "1 month": "1 个月",
            "Active pull request": "活跃的拉取请求",
            "Active pull requests": "活跃的拉取请求",
            "Active issue": "活跃的议题",
            "Active issues": "活跃的议题",
            "Merged pull request": "合并的拉取请求",
            "Merged pull requests": "合并的拉取请求",
            "Open pull request": "打开的拉取请求",
            "Open pull requests": "打开的拉取请求",
            "Closed issue": "关闭的议题",
            "Closed issues": "关闭的议题",
            "New issue": "新议题",
            "New issues": "新议题",

            "Excluding merges,": "不包括合并，",
            // [/(\d+) authors?/, "$1 位作者"],
            "have pushed": "推送了",
            "has pushed": "推送了",
            "commit": "次提交",
            "commits": "次提交",
            // [/to ([^ ]+), and/, "到 $1 分支和"],
            // [/to all branches. On ([^ ]+),/, "到全部分支。在 $1 分支，"],
            // [/(\d+) files?/, "$1 个文件"],
            "have changed and there have been": "已经发生了变化，并且有",
            "has changed and there have been": "已经发生了变化，并且有",
            "additions": "处增加",
            "deletions": "处删除",

            "commit authored by": "次提交，作者：",
            "commits authored by": "次提交，作者：",

            "Want to help out?": "想帮忙吗？",
            "Fork this repository": "复刻仓库",
            "Release published by": "个发行版已发布由",
            "Releases published by": "个发行版已发布由",
            "published": "发布",
            "Pull request merged by": "个拉取请求已合并由",
            "Pull requests merged by": "个拉取请求已合并由",
            "Pull request opened by": "个拉取请求打开由",
            "Pull requests opened by": "个拉取请求打开由",
            "Issue closed by": "个议题已关闭由",
            "Issues closed by": "个议题已关闭由",
            "Issue opened by": "个议题打开由",
            "Issues opened by": "个议题打开由",
            "person": "人",
            "people": "人",
            "Sometimes conversations happen on old items that aren’t yet closed. Here is a list of all the Issues and Pull Requests with unresolved conversations.": "有时会针对尚未关闭的旧项目进行讨论。以下是所有未解决的讨论的议题和拉取请求的列表。",
            // [/• (\d+) new comments/, "• $1 个新评论"],
            "Unresolved conversation": "个未解决的讨论",
            "Unresolved conversations": "个未解决的讨论",

            "merged": "已合并",
            "opened": "打开",
            "closed": "已关闭",

            // 新版（2025/9）
            "There hasn't been any commit activity on": "没有任何提交活动于",
            "over the last": "在最近",

            "Summary": "总结",
                "author": "位作者",
                "authors": "位作者",
                "have": " ",
                "has": " ",
                "pushed": "推送",
                "to all branches.": "到所有分支。",

                "On": "在",
                "file": "文件",
                "changed and there have been": "已经发生了变化，并且有",

            "Top Committers": "提交排行",
                "Chart options": "图表选项",
                    "View as table": "以表格形式查看",
                        "Category": "作者", // 此处原文错误
                    "Download CSV": "下载 CSV",
                    "Download PNG": "下载 PNG",

                "Customization settings": "自定义设置",
                    "Column & bar chart settings": "柱状图设置",
                        "Increase Contrast": "增加对比度",
                            "Adds gradients and outlines to increase contrast in charts.": "为图表添加渐变效果和轮廓，以增强对比度",
                        "Show data labels": "显示数据标签",
                            "Show labels for each data point in column and bar charts.": "在柱状图中显示每个数据点的标签",

            "Sometimes conversations happen on old items that aren't yet closed. Here is a list of all the Issues and Pull Requests with unresolved conversations.": "有时对尚未关闭的旧项目会有新的讨论。以下是所有有未解决讨论的议题和拉取请求列表。",
                "commented on": "评论于",
                "new comments": "新评论",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) authors?/, "$1 位作者"],
        [/to ([^ ]+) and/, "到 $1 分支和"],
        [/to all branches. On ([^ ]+),/, "到全部分支。在 $1 分支，"],
        [/(\d+) files?/, "$1 个文件"],
        [/(\d+) commented on/, "$1 评论于",],
        [/• (\d+) new comments?/, "• $1 个新评论"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last 24 hours./, "在过去的 24 小时里，$1 没有任何提交活动。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last 3 days./, "在过去的 3 天里，$1 没有任何提交活动。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last week./, "在过去的 1 周里，$1 没有任何提交活动。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last month./, "在过去的 1 月里，$1 没有任何提交活动。"],
        [/releases? published/, "发行版已发布"],
        [/pull requests? opened/, "拉取请求打开"],
        [/pull requests? merged/, "拉取请求合并"],
        [/issues? opened/, "议题打开"],
        [/issues? closed/, "议题关闭"],
        [/(\d+) commits? authored by ([^ ]+)/, "$2 提交 $1 次"],
    ],
    "title": {
        "regexp": [
            [/Pulse/, "洞察"],
        ],
    },
};

I18N["zh-CN"]["repository/graphs/contributors"] = { // 仓库 -> 洞察 - 贡献者
    "static": { // 静态翻译

        // 贡献者 /<user-name>/<repo-name>/graphs/contributors
            "Loading contributions…": "载入贡献者…",
            // [/Contributions to (.*), excluding merge commits/, "贡献到 $1 分支，不包括合并提交"],
            "Contributions:": "贡献者：",
                // 下拉菜单
                "Filter contributions": "筛选贡献者",
                "Additions": "添加数量",
                "Deletions": "删除数量",
                // [/Contributions to (.*), excluding merge commits and bot accounts/, "贡献到 $1 分支，不包括合并提交和机器人账户"],
            "Crunching the latest data, just for you. Hang tight…": "正在为您准备最新数据，请稍后…",

        // 新版
            // 标题
                "Contributions per week to": "每周贡献到",
                ", excluding merge commits": " 分支，不包括合并提交",
                ", line counts have been omitted because commit count exceeds 10,000.": " 分支，由于提交次数超过 10,000 次，因此省略行数。",
            // 筛选栏
                "Period": "时间",
                    "All": "全部",
                    "Last month": "上月",
            // 日期
                "Weekly from": " 每周从",
                "From": "从",
            // 提交图表
                "over time": "总览",
                "commit": "次提交",
                    "s": " ",
                "Contributions": "贡献", // 图表旁竖写
                "Chart options": "图表选项",
                    "View as table": "以表格形式查看",
                    "Download CSV": "下载 CSV",
                    "Download PNG": "下载 PNG",
                    // 表格窗口
                        "Commits over time": "提交总览",
                        "DateTime": "日期时间",
                        "Week of": "周",

        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],
    },
    "regexp": [ // 正则翻译
        [/Contributions to (.*), excluding merge commits/, "贡献到 $1 分支，不包括合并提交"],
        [/Contributions to (.*), excluding merge commits and bot accounts/, "贡献到 $1 分支，不包括合并提交和机器人账户"],
        [/Contributions to (.*), line counts have been omitted because commit count exceeds 10,000./, "贡献到 $1 分支，由于提交次数超过 10,000 次，因此省略行数。"],
        //[/Contributions per week to (.*), excluding merge commits/, "每周贡献到 $1 分支，不包括合并提交"],
        [/([\d,]+) commits?/, "$1 次提交"],
        // 新版
        [/Last (\d+) months?/, "最后 $1 个月"],
        [/([^ ]+)'s (Commits|Additions|Deletions)/, function(all, user, cont){

            var contKey = {Commits: '提交', Additions: '添加数量', Deletions: '删除数量'};

            return user + ' 的' + contKey[cont];
        }],
        [/Week (?:of|from) (?:Monday,)?(.+)/, (match, p1) => { // p1为(.+)
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}当周`; // 无论如何都是星期一
        }],
        [/([^ ]+)-([^ ]+) (\d+)/, (match, p1, p2 ,p3) => { // 出现位置：具体某贡献者 - 贡献数柱形图日期，原文格式为 月-月 年
            const translatedP1 = I18N["zh-CN"]["public"]["static"][p1] || p1;
            const translatedP2 = I18N["zh-CN"]["public"]["static"][p2] || p2;
            return `${p3}年 ${translatedP1}-${translatedP2}`; // 此处修改格式为 年 月-月
        }],
        [/(\d+) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)/, function(all, d, m){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        [/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) '(\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Contributors to (.+)/, "$1 的贡献者"],
        ],
    },
};

I18N["zh-CN"]["repository/graphs/community"] = { // 仓库 -> 洞察 - 社区
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 社区 /<user-name>/<repo-name>/graphs/community
            "Enable Discussions to unlock Community Insights!": "启用讨论，以解锁社区见解！",
            "Discussions is the central space for your community to share announcements, ask questions, and host conversations.": "讨论是您的社区共享公告、提出问题和主持对话的中心空间。",
            "Set up discussions": "建立讨论",

            "Community insights": "社区见解",
            "Period:": "周期：",
                "Filter activity": "筛选活动",
                "Last 30 days": "最近 30 天",
                "Last 3 months": "最近 3 个月",
                "Last year": "最近 1 年",

            "Contribution activity": "贡献活动",
                "Count of total contribution activity to Discussions, Issues, and PRs": "对讨论、议题和拉取请求的总贡献活动计数",
                "discussions": "讨论",
                "Quantity": "数量",
                "Timeline": "时间轴",
                // [/(\d+) pull requests created/, "$1 个拉取请求创建"],
            "We tried our best, but the graph wouldn’t load. Try reloading the page.": "我们尽了最大努力，但图表无法加载。尝试重新加载页面。",
            "Discussions page views": "讨论页面浏览量",
                "Total page views to Discussions segmented by logged in vs anonymous users.": "按登录用户与匿名用户划分的讨论的总页面浏览量。",
                "logged in": "登录",
                "anonymous": "匿名",

                "Not enough data yet.": "还没有足够的数据。",
                "It usually takes about a week to populate this chart.": "填充此图表通常需要大约一周的时间。",
                "Read more about insights": "阅读更多关于见解的信息",

            "Discussions daily contributors": "每日讨论的贡献者",
                "Count of unique users who have reacted, upvoted, marked an answer, commented, or posted in the selected period.": "在所选时间段内，作出反应、投票、标记答案、评论或发帖的唯一用户的数量。",
            "Discussions new contributors": "讨论的新贡献者",
                "Count of unique new users to Discussions who have reacted, upvoted, marked an answer, commented, or posted in the selected period.": "在所选时间段内，对讨论作出反应、投票、标记答案、评论或发帖的唯一新用户的数量。",

            "Crunching the latest data, just for you. Hang tight…": "正在为您准备最新数据，请稍后…",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) pull requests? created/, "$1 个拉取请求创建"],
        [/(\d+) issues? created/, "$1 个议题创建"],
        [/(\d+) discussions? created/, "$1 个讨论创建"],
        [/(\d+) contributors?/, "$1 贡献者"],
    ],
};

I18N["zh-CN"]["repository/community"] = { // 仓库 -> 洞察 - 社区准则
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 社区准则 /<user-name>/<repo-name>/community
            "Here’s how this project compares to": "以下是该项目内容，不同于",
            "recommended community standards": "推荐的社区标准",
            "Checklist": "检查清单",
            "Add": "添加",
            "Propose": "提议",

            "Description": "描述",
                "Add a description to your repository so people understand the goals of your project.": "向您的仓库添加描述，以便人们了解您项目的目标。",
            "README": "自述文件（README）",
                "Writing a README": "编写自述文件（README）",
            "Code of conduct": "行为准则",
                "What is a code of conduct?": "什么是行为准则？",
            "Contributing": "贡献",
                "Writing contributing guidelines": "编写贡献指南",
            "License": "许可证",
                "Choosing a license": "选择许可证",
            "Security policy": "安全政策",
                "Set up a security policy": "设置安全策略",
            "Issue templates": "议题模板",
            "Pull request template": "拉取请求模板",
            "Repository admins accept content reports": "仓库管理员接受内容报告", // 组织仓库?
            "What is": "什么是",
            "the community profile": "社区简介",

        // 添加许可证 /<user-name>/<repo-name>/community/license/new?branch=main
            "Add a license to your project": "为您的项目添加许可证",
            "Choose a license to add to your project": "选择要添加到项目的许可证",
            "Select a template on the left to get started.": "在左侧选择一个模板开始。",
            "Learn more about": "了解更多关于",
            "which license best fits your project": "哪种许可证最适合您的项目",

        // 添加许可证 /<user-name>/<repo-name>/community/license/new?branch=<branch name>&template=<template name>
            // 右侧栏
                "You’ll have a chance to review before committing a": "您将有机会在提交之前进行审查",
                "file to a new branch or the root of your project.": "文件到新分支或项目的根目录。",

                "To adopt": "采用",
                ", enter your details. You’ll have a chance to review before committing a": "，输入您的详细信息。您将有机会在提交之前进行审查",
                "Year": "年份",
                    "The current year": "当前年份",
                "Full name": "全名",
                    "The full name or username of the repository owner": "仓库所有者的全名或用户名",
                "Review and submit": "审查并提交",

            // 中间栏 顶部 权限信息
                "Permissions": "许可事项",
                "Limitations": "限制条件",
                    "Commercial use": "商业用途",
                    "Modification": "修改",
                    "Distribution": "分布",
                    "Patent use": "专利使用",
                    "Private use": "私人使用",
                    "Trademark use": "商标使用",
                    "Liability": "责任",
                    "Warranty": "担保",
                    "Disclose source": "开源",
                    "Same license": "相同的许可证",
                "Conditions": "条件",
                    "License and copyright notice": "许可和版权声明",
                    "State changes": "状态变化",
                    "License and copyright notice for source": "来源许可和版权声明",
                    "Network use is distribution": "网络使用即分发",
                    "Same license (library)": "相同的许可证（库）",
                    "Same license (file)": "相同的许可证（文件）",

                "This is not legal advice.": "这并不是法律建议。",
                "Learn more about repository licenses": "了解更多关于仓库许可证的信息",

        // 添加行为准则 /<user-name>/<repo-name>/community/code-of-conduct/new
            "Add a code of conduct to your project": "为您的项目添加行为准则",
            "Choose a code of conduct to add to your project": "选择要添加到项目中的行为准则",
            "what a code of conduct is": "什么是行为准则",
            "and how to enforce it.": "以及如何执行。",
            "Contributor Covenant": "贡献者协议",
                "Recommended for projects of all sizes": "建议用于各种规模的项目",
                "Contact method": "联系方式",
            "Citizen Code Of Conduct": "公民行为准则",
                "Suitable for large communities and events": "适合大型社区和活动",
                "Link to reporting guidelines": "报告指南链接",
                "Link to policy": "政策链接",
                "Note": "注释",
                "Contact info": "联系信息",
                "Community name": "团队名称",
                "Governing body": "管理机构",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Community Standards": "社区准则",
        },
    },
};

I18N["zh-CN"]["repository/graphs/traffic"] = { // 仓库 -> 洞察 - 流量
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 流量 /<user-name>/<repo-name>/graphs/traffic
            "Git clones": "Git 克隆",
            "Clones": "克隆",
            "Unique cloners": "唯一克隆者",
            "clones": "次克隆",
            "clone": "次克隆",
            "unique cloners": "个唯一克隆者",
            "unique cloner": "个唯一克隆者",
            "Visitors": "访客",

            "Referring sites": "引荐网站",
            "Site": "站点",
            "Domains": "域名",
            "Views": "浏览",
            "Unique visitors": "唯一访客",
            "Unique Visits": "唯一访问",
            "views": "次浏览",
            "view": "次浏览",
            "Visits": "访问",
            "unique visitors": "个唯一访客",
            "unique visitor": "个唯一访客",
            "Popular content": "热门内容",
            "Content": "内容",
            "Path": "路径",

            "We don’t have enough data to show anything useful.": "我们没有足够的数据来显示任何有用的东西。",
            "It usually takes about a week to populate this graph.": "通常需要一周左右的时间来填充此图表。",
            "It looks like traffic to your repository is a little light. Go spread the word and check back later!": "看起来您的仓库的流量有点少呀。去宣传一下吧，稍后再回来查看！",

            "Crunching the latest data, just for you. Hang tight…": "正在为您准备最新数据，请稍后…",

        // 新版
            "Referring sites and popular content are temporarily unavailable or may not display accurately. We're actively working to resolve the issue.": "引用网站和热门内容暂时无法使用或可能无法准确显示。我们正在积极解决该问题。",

            "Clones in last 14 days": "最近 14 天克隆数",
            "Unique cloners in last 14 days": "最近 14 天唯一克隆者",
                "Cloners": "克隆者",
            "Total views in last 14 days": "最近 14 天访问数",
                "Total views": "总访问数",
            "Unique visitors in last 14 days": "最近 14 天唯一访客",

            "Chart options": "图表选项",
                "View as table": "以表格形式查看",
                "Download CSV": "下载 CSV",
                "Download PNG": "下载 PNG",

            "Customization settings": "自定义设置",
                "Line chart settings": "折线图设置",
                    "Differentiate by line style": "折线样式区分",
                        "Use unique line styles (dashed, dotted, etc.) to differentiate lines in charts.": "使用独特的线条样式（如虚线、点线等）在图表中区分不同的线条。",
                    "Show data labels": "显示数据标签",
                        "Show labels for each data point in line chart.": "在折线图每个数据点显示标签。",

            // 表格
            "Category": "日期", // 实际上为日期
            "Total": "总计",
            "Unique": "唯一",

            "We don't have enough data to show anything useful.": "我们没有足够的数据来显示任何有用的东西。",
            "It usually takes about a week to populate this table.": "通常需要一周左右的时间来填充此图表。",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) Clones?/, "$1 次克隆"],
        [/(\d+) Unique cloners?/, "$1 位唯一克隆者"],
        [/(\d+) Views?/, "$1 次访问"],
        [/(\d+) Unique visitors?/, "$1 位唯一访客"],
    ],
};

I18N["zh-CN"]["repository/graphs/commit-activity"] = { // 仓库 -> 洞察 - 提交
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 提交 /<user-name>/<repo-name>/graphs/commit-activity
            "Sunday"    : "周日",
            "Monday"    : "周一",
            "Tuesday"   : "周二",
            "Wednesday" : "周三",
            "Thursday"  : "周四",
            "Friday"    : "周五",
            "Saturday"  : "周六",

            "Crunching the latest data, just for you. Hang tight…": "正在为您准备最新数据，请稍后…",

        // 新版
            "Commits over the last year of": "最近一年内提交到",

            "Number of commits per week": "每周提交数",
            "Customization settings": "自定义设置",
                "Column & bar chart settings": "柱状图设置",
                    "Increase Contrast": "增加对比度",
                    "Adds gradients and outlines to increase contrast in charts.": "为图表添加渐变效果和轮廓，以增强对比度",
                    "Show data labels": "显示数据标签",
                    "Show labels for each data point in column and bar charts.": "在柱状图中显示每个数据点的标签",

            "Chart options": "图表选项",
                "View as table": "以表格形式查看",
                "Download CSV": "下载 CSV",
                "Download PNG": "下载 PNG",

                "DateTime": "日期",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/commits? the week of (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d+)/, function(all, month, day){
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            return '次提交本周，' + monthKey[month] + day + '日';
        }],
        [/Week of (.+)/, (match, p1) => { // p1为(.+)
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}当周` ; // 这里写翻译结果
        }],
    ],
    "title": {
        "regexp": [
            [/Commits/, "提交"],
        ],
    },
};

I18N["zh-CN"]["repository/graphs/code-frequency"] = { // 仓库 -> 洞察 - 代码频率
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 代码频率 /<user-name>/<repo-name>/graphs/code-frequency
            "Code frequency over the history of": "历史上的代码频率",
            "Additions": "添加数量",
            "Deletions": "删除数量",
            "per week": "每周",
            "Crunching the latest data, just for you. Hang tight…": "正在为您准备最新数据，请稍后…",

            // 过多
            "There are too many commits to generate this graph.": "提交次数过多，无法生成图表。",
            "More information about this data can be found in the": "有关这些数据的更多信息，请参阅",
            "activity documentation": "活动文档",

        // 新版
        "Additions and deletions per week": "添加数量和删除数量/每周",
        "Chart options": "图表选项",
            "View as table": "以表格形式查看",
            "Download CSV": "下载 CSV",
            "Download PNG": "下载 PNG",
            // 图表本体
                "DateTime": "日期时间",
                "Frequency": "频率",
                "Values": "值",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Week (?:of|from) (?:Monday,)?(.+)/, (match, p1) => { // p1为(.+)
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}当周`; // 无论如何都是星期一
        }],
        [/(\d+) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)/, function(all, d, m){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        [/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) '(\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
    ],
    "title": {
        "regexp": [
            [/Code frequency/, "代码频率"],
        ],
    },
};

I18N["zh-CN"]["repository/network/dependencies"] = { // 仓库 -> 洞察 - 依赖项关系图 - 依赖项
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        "Dependencies": "依赖项",
        "Dependents": "依赖者",
        // 依赖项关系图 - 依赖项 /network/dependencies
            "Tell us how to make the Dependency Graph work better for you with a few quick questions.": "请通过几个简单的问题告诉我们，如何使 “依赖项关系图” 更好地为您工作。",

            "Dependency graph is disabled": "依赖项关系图未启用",
            "The owner of this repository has not yet enabled the dependency graph. Once enabled, you can": "此仓库的所有者尚未启用依赖项关系图。一旦启用，您可以", //个人仓库
            "Dependency graph has not been enabled by an organization owner or a user with admin permissions for this repository. Once enabled, you can": "依赖项关系图还没有被组织所有者或具有该仓库管理权限的用户启用。一旦启用，您可以", // 组织仓库
            "track this repository’s dependencies": "追踪此仓库的依赖项",
            "Learn more about how we use your data.":"深入了解我们对您数据的使用方式。",

            "Enable the dependency graph": "启用依赖项关系图",
            "Track this repository’s": "追踪该仓库的",
            "dependencies and sub-dependencies": "依赖项和子依赖项",
            "The": " ",
            "is not enabled for this repository. Click on \"Enable the dependency graph\" below to enable it.": "暂未启用。单击下面的 “启用依赖项关系图” 以启用它。",
            "If you’d like to enable the": "如果您想启用",
            "dependency graph": "依赖项关系图",
            "vulnerability alerting": "漏洞警报",
            "click on \"Allow access\" below to enable it.": "点击下面的 “允许访问” 来启用它。",
            "Learn more about how we use your data": "了解更多关于我们如何使用您的数据的信息",
            "Allow access": "允许访问",

            "No dependencies found.": "未找到依赖项",
            "To view your dependency graph, your repository must define dependencies in": "要查看依赖项关系图，您的仓库必须定义依赖项存在",
            "one of the supported manifest file types": "一个支持的清单文件",
            ", like": "，例如",
            ", and": "，和",

            "Export SBOM": "导出 SBOM",

            "Detect additional dependencies with GitHub Actions": "使用 GitHub Actions 检测额外的依赖项",
                // 并非所有依赖项都会自动检测到，例如 Gradle 这样的生态系统。GitHub Actions 会通过依赖项提交 API 添加您的依赖项，这样您就可以收到有关已知漏洞的 Dependabot 警报。
                "Not all dependencies are automatically detected for ecosystems like Gradle. GitHub Actions adds your dependencies using the": "并非所有依赖项都会自动检测到，例如 Gradle 这样的生态系统。GitHub Actions 会通过",
                "dependency submission API": "依赖项提交 API",
                "so you can receive Dependabot alerts for known vulnerabilities.": "添加您的依赖项，这样您就可以收到有关已知漏洞的 Dependabot 警报。",
            "View in Marketplace": "去市场查看",

            // "Dependencies": "依赖项",
            "Search all dependencies": "搜索所有依赖项",
                "Suggested filters": "建议筛选",

            "These dependencies are defined in": "这些依赖项被定义在",
            "’s manifest files, such as": "的清单文件，例如",
            "Dependencies defined in": "依赖项被定义在",

            // 发现已知漏洞
            "Dependencies defined in these manifest files have known security vulnerabilities and should be updated:": "这些清单文件中定义的依赖项具有已知的安全漏洞，应更新：",
            // [/(\d+) vulnerabilities? found/, "发现 $1 个漏洞"],
            "Known security vulnerability in": "已知的安全漏洞，在",
                "Known vulnerability found": "发现已知漏洞",
                "update suggested:": "更新建议：",
                "Always verify the validity and compatibility of suggestions with your codebase.": "始终验证建议与代码库的有效性和兼容性。",

            // [/(\d+) more dependencies/, "更多 $1 个依赖项"],
            // [/Load (\d+) more…/, "加载更多 $1个…"],
            "Ecosystem": "生态系统",
                "Filter by ecosystem": "按生态系统筛选",

            "ProTip!": "专业提示！",
            "What’s not been updated": "未更新内容",
                "Supported ecosystems will have transitivity labels on their packages.": "受支持的生态系统将在其包上有传递性标签。",

            "View transitive paths": "查看传递路径",
            "You can view transitive paths for packages within supported ecosystems.": "您可以在受支持的生态系统中查看包的传递路径。",
            "OK, got it": "好的，明白了",
            "Show dependency options": "显示依赖选项",
                "Show paths": "显示路径",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/View Dependabot alerts?/, "查看 Dependabot 警报"],
        //[/Detected automatically on (.+)/, "自动检测于$1"],
        [/· Detected automatically on (.+)/, (match, p1) => {
            const dateRegExp = I18N["zh-CN"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `· 自动检测于 ${translatedDate}`;
        }],
        [/(\d+) Total/, "$1 总计"],
        [/(\d+) vulnerabilities? found/, "发现 $1 个漏洞"],
        [/(\d+) more dependencies/, "更多 $1 个依赖项"],
        [/(\d+) moderate · (\d+) total/, "$1 中风险 · $2 总计"],
        [/(\d+) high · (\d+) total/, "$1 高风险 · $2 总计"],
        [/(\d+) high/, "$1 高风险"],
        [/(\d+) moderate/, "$1 中风险"],
        [/Load (\d+) more…/, "加载更多 $1个…"],
    ],
    "title": {
        "regexp": [
            [/Dependencies/, "依赖项"],
        ],
    },
};

I18N["zh-CN"]["repository/network/dependents"] = { // 仓库 -> 洞察 - 依赖项关系图 - 依赖者
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        "Dependencies": "依赖项",
        "Dependents": "依赖者",
        // 依赖项关系图 - 依赖者 /network/dependents
            "GitHub does not currently determine the dependents of private repositories": "GitHub 目前无法确定私有仓库的依赖者",

            "Export SBOM": "导出 SBOM",
            // "Dependents": "依赖者",
            "We haven’t found any dependents for this repository yet.": "我们尚未找到此仓库的任何依赖者。",
            "We’ll keep looking!": "我们会继续寻找！",

            "Repositories that depend on": "依赖的仓库包括",
            "Package:": "软件包：",

            "These counts are approximate and may not exactly match the dependents shown below.": "这些计数是近似值，可能与下方显示的依赖项不完全匹配。",

            // [/(\d+) Repositor(y|ies)/, "$1 仓库"],
            // [/(\d+) Packages?/, "$1 软件包"],

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) Repositor(y|ies)/, "$1 仓库"],
        [/(\d+) Packages?/, "$1 软件包"],
    ],
    "title": {
        "regexp": [
            [/Network Dependents/, "网络依赖者"],
        ],
    },
};

I18N["zh-CN"]["repository/network/updates"] = { // 仓库 -> 洞察 - 依赖项关系图 - Dependabot
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        "Dependencies": "依赖项",
        "Dependents": "依赖者",

        "Export SBOM": "导出 SBOM",
        // 依赖项关系图 - Dependabot /network/updates
            "Enable Dependabot": "启用 Dependabot",
            "Dependabot isn't enabled": "未启用 Dependabot",
            "Dependabot isn't enabled on forks by default": "默认情况下，Dependabot 不会在复刻上启用。",

            "Dependabot version updates aren't configured yet": "尚未配置 Dependabot 版本更新",
            "Dependabot creates pull requests to keep your dependencies up-to-date.": "Dependabot 创建拉取请求以保持您的依赖项是最新的。",
            "Create config file": "创建配置文件",

            "Recent update jobs": "最近更新的工作",

            "Dependabot version updates": "Dependabot 版本更新",
            "automatically keep your application up-to-date by periodically updating dependencies to their latest versions.": "通过定期将依赖项更新到最新版本，自动保持应用的最新状态。",
            "Dependabot security updates": "Dependabot 版本更新",
            "can also help keep dependencies updated.": "还可以帮助保持依赖项更新。",

            "Monitored dependency files": "受监控的依赖文件",
            "Check for updates": "检查更新",
            "Recent jobs": "近期工作",
            "view logs": "查看日志",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
};

I18N["zh-CN"]["repository/network"] = { // 仓库 -> 洞察 - 网络图
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 网络图 /<user-name>/<repo-name>/network
            // 键盘快捷键
                "Scroll left": "向左滑动",
                "Scroll right": "向右滑动",
                "Scroll up": "向上滑动",
                "Scroll down": "向下滑动",
                "Toggle visibility of the head labels": "切换头部标签的可见性",
                "Scroll all the way left": "一直向左滑动",
                "Scroll all the way right": "一直向右滑动",
                "Scroll all the way up": "一直向上滑动",
                "Scroll all the way down": "一直向下滑动",

            "Network graph": "网络图",
            "Timeline of the most recent commits to this repository and its network ordered by most recently pushed to.": "最近提交到此仓库的时间轴及其网络图按最近推送的顺序排序。",

            "The repository network shows the 100 most recently pushed forks.": "仓库网络图显示最近推送的 100 个复刻。",

            "Loading graph data": "加载网络图数据",
            "Keyboard shortcuts available": "可用的键盘快捷键",

            "Sorry, your browser doesn’t support the <canvas> element.": "抱歉，您的浏览器不支持 <canvas> 元素。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Network Graph/, "网络图"],
        ],
    },
};

I18N["zh-CN"]["repository/network/members"] = { // 仓库 -> 洞察 - 复刻
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 复刻 - 树形视图 /<user-name>/<repo-name>/network/members
            "switch to list view": "切换到列表视图",

            "No one has forked this repository yet.": "目前，暂无人复刻该仓库。",
            "Forks are a great way to contribute to a repository. After": "复刻是给该仓库做贡献的好方法。首先",
            "forking a repository": "复刻仓库",
            ", you can send the original author a": "，然后您可向原作者发送",
            "pull request": "拉取请求",

            "Woah, this network is huge! We’re showing only some of this network’s repositories.": "哇，这个网络太庞大了! 我们只展示了这个网络中的一部分仓库。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
};

I18N["zh-CN"]["repository/forks"] = { // 仓库 -> 洞察 - 复刻
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-insights-menu"]["static"],

        // 复刻 - 列表视图 /<user-name>/<repo-name>/forks
            "Switch to tree view": "切换到树形视图",

            "No one has forked this repository yet": "目前，暂无人复刻该仓库",
            "Forks are a great way to contribute to a repository. After": "复刻是给该仓库做贡献的好方法。首先",
            "forking a repository": "复刻仓库",
            ", you can send the original author a": "，然后您可向原作者发送",
            "pull request": "拉取请求",

            "No forked repositories found": "尚无复刻仓库",
            "Try changing your filters, or search for": "尝试更改筛选器，或搜索",
            "active forked repositories": "活跃的复刻仓库",

            "Period:": "周期:",
                "Filter by period": "筛选周期",
                "1 month": "1 个月",
                "6 months": "6 个月",
                "1 year": "1 年",
                "2 years": "2 年",
                "5 years": "5 年",
                "All time": "所有时间",

                "Any repository that has not been created or updated during this period will be excluded.": "在此期间未被创建或更新的任何仓库将被排除在外。",
            "Repository type:": "仓库类型:",
                "Filter by repository type": "筛选仓库类型",
                "None": "无",
                "Active": "活跃",
                    "Repositories with push activity": "有推送活动的仓库",
                "Inactive": "不活跃",
                    "Repositories with no push activity": "无推送活动的仓库",
                "Network": "网络",
                    "Forks of other forks": "其他复刻的复刻",
                "Archived": "存档",
                    "Archived repositories": "已存档的仓库",
                "Starred": "星标",
                    "Repositories with at least 1 star": "至少有 1 个星标的仓库",
            "Sort:": "排序:",
                "Sort by": "排序方式",
                    "Most starred": "最多星标",
                    "Recently updated": "最近更新",
                    "Open issues": "打开的议题",
                    "Open pull requests": "打开的拉取请求",
                "Defaults Saved": "默认值已保存",
                "Save Defaults": "保存默认值",

            "Never updated": "从未更新",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Created/, "创建于"],
        [/Updated/, "更新于"],
        [/(Active|Inactive|Network|Archived|Starred) (\+\d+)/, function(all, type, num){
            var typeKey = {"Active": "活跃","Inactive": "不活跃","Network": "网络","Archived": "存档","Starred": "星标"};
            return typeKey[type] + ' ' + num;
        }],
    ],
    "title": {
        "regexp": [
            [/Forks/, "复刻"],
        ],
    },
};

// 洞察 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

I18N["zh-CN"]["repository-settings-menu"] = { // 仓库设置公共部分
    "static": { // 静态翻译
        // >>>>>>>>>>>>>>>>>>   仓库设置 公共部分  <<<<<<<<<<<<<<<<<<<
            // 顶部提醒栏
            "Most repository settings are hidden for archived repositories. This repository must be unarchived to change them.": "对于存档的仓库，大多数仓库设置都是隐藏的。 必须解除仓库存档才能更改它们。",
            "This repository has been archived by the owner. It is now read-only.": "此仓库已由所有者存档。它现在是只读的。",
            "Repository settings saved.": "仓库设置已保存。",


            // 左侧菜单
            "General": "通常",

            "Access": "访问",
                // "Collaborators": "协作者",
                "Collaborators and teams": "协作者和团队", // 组织仓库
                "Team and member roles": "团队和成员职责",  // 组织仓库
                "Moderation options": "节制选项",
                    "Interaction limits": "互动限制",
                    "Code review limits": "代码审查限制",

            "Code and automation": "代码与自动化",
                "Branches": "分支",
                "Tags": "标签",
                "Rules": "规则",
                    "Rulesets": "规则集",
                // "Actions": "操作",
                    // "General": "通常",
                    "Runners": "运行器",
                "Models": "模型",
                "Webhooks": "Web 钩子",
                // Copilot
                    "Code review": "代码审查",
                    "Coding agent": "编程智能体",
                "Environments": "环境",
                "Pages": "GitHub Pages",
                "Custom properties": "自定义属性",  // 组织仓库

            // "Security": "安全",
                "Advanced Security": "高级安全",
                "Deploy keys": "部署密钥",
                "Secrets and variables": "机密和变量",

            "Integrations": "集成",
                "GitHub Apps": "GitHub 应用",
                "Email notifications": "邮件通知",
                "Autolink references": "自动链接引用",

    },
    "regexp": [ // 正则翻译
    ],
};

I18N["zh-CN"]["repository/settings"] = { // 仓库设置 - 通常 /<user-name>/<repo-name>/settings
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 通常 - 设置页面 /<user-name>/<repo-name>/settings ====================================
            "Repository name": "仓库名称",
            "Rename": "重命名",
                // [/is available./, "名称可用。"],
                "The repository": "仓库",
                "already exists on this account.": "已经存在于此账户。",
                "Your new repository will be created as": "您的新仓库将被创建为",
                // 顶部提醒
                "Repository name was not changed": "仓库名称未更改",

            "Template repository": "模板库",
                "Template repositories let users generate new repositories with the same directory structure and files.": "模板仓库允许用户生成具有相同目录结构和文件的新仓库。",
                "A repository with LFS content cannot be used as a template.": "带有 LFS 内容的仓库不能作为模板使用。",
                "Learn more about template repositories": "了解更多关于模板库的信息",

                "Require contributors to sign off on web-based commits": "要求贡献者在基于 Web 的提交上签署",
                "Enabling this setting will require contributors to sign off on commits made through GitHub’s web interface. Signing off is a way for contributors to affirm that their commit complies with the repository's terms, commonly the": "启用此设置将要求贡献者签署通过 GitHub 的 Web 界面所做的提交。签署是贡献者确认他们的提交符合仓库条款的一种方式，通常是",
                "Developer Certificate of Origin (DCO)": "开发者来源证书（DCO）",
                "Learn more about signing off on commits": "了解更多关于签署提交的信息",

            "This setting is enabled on the upstream repository. Disabling this setting may block commits from being merged upstream.": "此设置在上游仓库中启用。禁用此设置可能会阻止提交向上游合并。",

            "Default branch": "默认分支",
            "The default branch is considered the “base” branch in your repository, against which all pull requests and code commits are automatically made, unless you specify a different branch.": "默认分支被认为是仓库中的 “基础” 分支，所有的拉取请求和代码提交都是针对该分支进行的，除非您指定一个不同的分支。",
            "Rename branch": "重命名分支",
                // 重命名分支对话框
                "Rename this branch": "重命名分支",
                "Rename": "重命名",
                "to:": "为：",
                // [/is already the branch name./, "已经是分支的名称了。"],
                // [/Your branch name will be/, "您的分支的名称将重命名为"],
                "Most projects name the default branch": "大多数项目将默认分支名为",
                "Renaming this branch:": "重命名此分支：",
                    // 该分支存在来自其他分支的拉取请求时
                        "Will update": "将更新",
                        "pull request targeting this branch.": "条针对该分支的拉取请求。",
                        "pull requests targeting this branch.": "条针对该分支的拉取请求。",
                        "branch protection rule that explicitly targets": "条分支保护规则明确针对",

                    // 该分支存在用于其他分支的拉取请求时
                        "Will close": "将关闭",
                        "open pull request for this branch.": "个该分支的拉取请求。",

                    // 重命名 GitHub Pages 所在分支
                        "Will unpublish current GitHub Pages site.": "将取消当前发布的 GitHub Pages 站点。",
                            "Your current GitHub Pages site will become unpublished. A new commit on the renamed branch will publish the GitHub Pages site again.": "您当前的 GitHub Pages 站点将被取消发布。重命名分支上的新提交将再次发布 GitHub Pages 站点。",

                    "Will not update your members' local environments.": "不会更新您成员的本地环境。",
                "Renaming this branch will not update your members' local environments.": "重命名此分支不会更新您成员的本地环境。",
                    "Your members will have to manually update their local environments. We'll let them know when they visit the repository, or you can share the following commands.": "您的成员将不得不手动更新他们的本地环境。我们会在他们访问仓库时通知他们，或者您可以共享以下命令。",
                "Saving…": "保存中…",

            "Switch to another branch": "切换到另一分支",
                // 分支切换对话框
                "Switch default branch to another branch": "将默认分支切换到另一分支",
                // [/Choose another branch to use as the default branch of ([^ ]+) instead of/,"选择另一分支作为 $1 的默认分支而不是"], // 分支切换 对话框
                "Switch default branch": "切换默认分支",
                "Filter branches": "筛选分支",
                "default": "默认",
                // 更新默认分支对话框
                "Update default branch": "更新默认分支",
                "Changing your default branch": "更改您的默认分支",
                "can have unintended consequences that can affect new pull requests and clones.": "可能会产生意想不到的后果，影响新的拉取请求和克隆。",
                "I understand, update the default branch.": "我明白了，依然更新默认分支",
                // 顶部提醒
                    // [/Default branch changed to ([^ ])/, "默认分支更改为 $1"]

            // 发行版
                "Enable release immutability": "启用发行版不可修改",
                    "Disallow assets and tags from being modified once a release is published.": "禁止在发布发行版后修改资产和标签。",

            "Social preview": "社交预览",
            // 关于私有库提醒
            "You can upload a social image, but it will not be visible publicly while": "您可以上传社交图片，但当",
            "is private.": "是私密时，它不会公开显示。",
            "Upload an image to customize your repository’s social media preview.": "上传图像以自定义仓库的社交媒体预览。",
            "Images should be at least 640×320px (1280×640px for best display).": "图片至少应为 640×320 像素（1280×640 像素以获得最佳显示效果）。",
            "Download template": "下载模板",
            "Edit": "编辑",
                "Upload an image…": "上传图片…",
                "Remove image": "删除图片",

            "Features": "功能",
            // "Wikis": "",
                "Wikis host documentation for your repository.": "Wikis 为您的仓库托管文档。",
                "Restrict editing to collaborators only": "仅限协作者进行编辑",
                "Restrict editing to users in teams with push access only": "仅限具有推送访问权限的团队中的成员进行编辑", //组织仓库
                    "Public wikis will still be readable by everyone.": "公共 Wikis 仍然可供所有人阅读。",

            // 私人库 启用 Wiki 提醒
                "Upgrade or make this repository public to enable Wikis": "升级或公开此仓库，以启用 Wiki",
                "GitHub Wikis is a simple way to let others contribute content. Any GitHub user can create and edit pages to use for documentation, examples, support, or anything you wish.": "GitHub Wikis 是一种让他人贡献内容的简单方法。任何 GitHub 用户都可以创建和编辑页面，用于文档、示例、支持或任何您想要的东西。",
                // "Upgrade": "升级",
                    "Learn more about wikis": "了解更多关于 Wiki 的信息",

            // 议题
            "Issues integrate lightweight task tracking into your repository. Keep projects on track with issue labels and milestones, and reference them in commit messages.": "议题将轻量级任务跟踪集成到您的仓库中。使用议题标签和里程碑保持项目正常运行，并在提交消息中引用它们。",
            "Get organized with issue templates": "使用议题模板进行组织",
            "Give contributors issue templates that help you cut through the noise and help them push your project forward.": "为贡献者提供议题模板，帮助您消除干扰并帮助他们推进您的项目。",
            "Set up templates": "设置模板",

            "Allow forking": "允许复刻", // 组织仓库
            "If disabled, existing forks will be unaffected.": "如果禁用，现有复刻将不受影响。", // 组织仓库

            // 赞助
            "Sponsorships": "赞助",
            "Sponsorships help your community know how to financially support this repository.": "赞助可帮助您的社区了解如何在资金上支持此仓库。",
            "Display a \"Sponsor\" button": "显示 “赞助” 按钮",
            "Add links to GitHub Sponsors or third-party methods your repository accepts for financial contributions to your project.": "添加指向 GitHub 赞助者或您的仓库接受的第三方收款链接，以便为您的项目提供资金捐助。",
            "Set up sponsor button": "设置赞助按钮",
            "Edit funding links": "编辑赞助链接",

            // 项目
            "Projects on GitHub help you organize and prioritize your work. You can create projects for specific feature work, comprehensive roadmaps, or even release checklists.": "GitHub 上的项目可以帮助您组织工作并确定其优先次序。您可以为特定的功能工作、全面的路线图、甚至是发布清单创建项目",

            "Preserve this repository": "保留这个仓库",
            "Include this code in the": "将此代码包含在",
            "GitHub Archive Program": "GitHub 存档计划中",

            "Table of contents": "目录",
            "Autogenerate table of contents for markdown files in this repository. the table of contents will be displayed near the top of the file.": "自动生成此仓库中 Markdown 文件的目录。目录将显示在文件顶部附近。",

            // "Discussions": "讨论",
            "Discussions is the space for your community to have conversations, ask questions and post answers without opening issues.": "讨论是您的社区进行对话、提问和发布答案的地方，而无需打开议题。",
            "Get started with Discussions": "开始讨论",
            "Engage your community by having discussions right in your repository, where your community already lives": "通过在您的社区已经存在的仓库中进行讨论来吸引您的社区",
            "Set up discussions": "建立讨论",

            // 项目
            "Projects on GitHub are created at the repository owner's level (organization or user) and can be linked to a repository's Projects tab. Projects are suitable for cross-repository development efforts such as feature work, complex product roadmaps or even Issue triage.": "GitHub 上的项目是在仓库所有者级别（组织或用户）创建的，并且可以链接到仓库的项目选项卡。项目适用于跨仓库的开发工作，例如功能工作、复杂的产品路线图，甚至问题分流。",

            // "Pull Requests": "拉取请求",
                "When merging pull requests, you can allow any combination of merge commits, squashing, or rebasing. At least one option must be enabled. If you have linear history requirement enabled on any protected branch, you must enable squashing or rebasing.": "当合并拉取请求时，您可以允许合并提交、压缩或变基的任意组合。必须至少启用一个选项。如果您在任何受保护分支上启用了线性历史要求，则必须启用压缩或变基。",

                "You must select at least one option": "您必须至少选择一个选项",
                "Allow merge commits": "允许合并提交",
                    "Add all commits from the head branch to the base branch with a merge commit.": "使用合并提交将所有从头部分支的提交添加到基础分支。",
                        "Default commit message": "默认提交信息",
                            "Presented when merging a pull request with merge.": "当合并拉取请求时时出现。",
                        "Default message": "默认信息",
                        "Pull request title": "拉取请求标题",
                        "Pull request title and commit details": "拉取请求标题和提交详情",
                        "Pull request title and description": "拉取请求标题和描述",

                "Allow squash merging": "允许压缩合并",
                    "Combine all commits from the head branch into a single commit in the base branch.": "将来自头部分支的所有提交合并到基础分支中的单个提交中。",
                        // "Default commit message": "默认提交信息",
                            "Presented when merging a pull request with squash.": "当使用压缩合并拉取请求时显示。",
                        "Default to pull request title and commit details": "默认为拉取请求标题和提交详细信息",

                    "Default to PR title for squash merge commits": "默认将拉取请求的标题作为压缩合并提交的信息",
                    "This will pre-populate the commit message with the PR title when performing a squash merge.": "在执行压缩合并时，将在提交信息中添加拉取请求的标题。",

                "Allow rebase merging": "允许变基合并",
                    "Add all commits from the head branch onto the base branch individually.": "将来自头部分支的所有提交单独添加到基础分支。",

                "Control how and when users are prompted to update their branches if there are new changes available in the base branch.": "如果基础分支中有可用的新更改，则控制提示用户更新其分支的方式和时间。",
                "Always suggest updating pull request branches": "始终建议更新拉取请求分支",
                    "Whenever there are new changes available in the base branch, present an “update branch” option in the pull request.": "每当基础分支中有可用的新更改时，就在拉取请求中显示 “更新分支” 选项。",

                "You can allow setting pull requests to merge automatically once all required reviews and status checks have passed.": "一旦所有必需的审查和状态检查都通过，您可以允许设置拉取请求自动合并。",

                "Allow auto-merge": "允许自动合并",
                    "Waits for merge requirements to be met and then merges automatically.": "等待满足合并要求，然后自动合并。",
                    "Why is this option disabled?": "为什么该选项被禁用？",

                "After pull requests are merged, you can have head branches deleted automatically.": "合并拉取请求后，您可以自动删除头部分支。",

                    "Automatically delete head branches": "自动删除头部分支",
                        "Deleted branches will still be able to be restored.": "删除的分支仍然可以恢复。",

            "Archives": "档案",
            "When creating source code archives, you can choose to include files stored using Git LFS in the archive.": "创建源代码存档时，您可以选择在存档中包含使用 Git LFS 存储的文件。",

            "Include Git LFS objects in archives": "在档案中包含 Git LFS 对象",
            "Git LFS usage in archives is billed at the same rate as usage with the client.": "归档中的 Git LFS 使用率与客户端的使用率相同。",

            "Pushes": "推送",
            "Limit how many branches and tags can be updated in a single push": "限制一次推送中可以更新多少个分支和标签",
                "Pushes will be rejected if they attempt to update more than this.": "如果推送尝试更新超过该值，则推送将被拒绝。",
                "Learn more about this setting": "了解更多关于此设置的信息",
                ", and send us your": "，并向我们发送您的",
                "feedback": "反馈",

                "Up to": "在一次推送中最多可以更新",
                "branches and tags can be updated in a push": "个分支和标签",

                // 提醒
                "Must be a whole number between 2 and 1000": "必须是 2 到 1000 之间的整数",

            // 议题
                "After merging a pull request, linked issues can be closed automatically.": "合并拉取请求后，可以自动关闭关联议题。",
                    "Auto-close issues with merged linked pull requests": "使用已合并的关联拉取请求自动关闭议题",
                        "Whenever linked pull requests have merged, auto-close the issue.": "当关联的拉取请求被合并时，自动关闭该议题。",

            "Danger Zone": "危险区",
            "Change repository visibility": "更改仓库可见性",
            "You cannot change the visibility of a fork. please": "您无法更改复刻仓库的可见性。请",
            "Duplicate the repository": "复制仓库",
            "For security reasons, you cannot change the visibility of a fork.": "出于安全原因，您无法更改复刻仓库的可见性。",

            // 更改仓库可见性对话框
            "Change visibility": "更改可见性",
                "Change to private": "更改为私有",
                "Change to public": "更改为公开",
            "This repository is currently public.": "该仓库当前是公开的。",
            "This repository is currently private.": "该仓库当前是私有的。",
            "I want to make this repository public": "我想将此仓库设为公开",
                "The code will be visible to everyone who can visit https://github.com": "所有可以访问 https://github.com 的人都可以看到代码",
                "Attachments uploaded to this repository's issues and pull requests will not be accessible unless it is made private again.": "上传到此仓库的议题和拉取请求的附件将无法访问，除非再次设为私有。",
                "Anyone can fork your repository.": "任何人都可以复刻您的仓库。",
                "All push rulesets will be disabled.": "所有推送规则集都将被禁用。",
                "Your changes will be published as activity.": "您的更改将作为活动发布。",
                "Actions history and logs will be visible to everyone.": "操作历史和日志将对所有人可见。",
                "Make this repository public": "我想将此仓库设为公开",
            "I want to make this repository private": "我想将此仓库设为私有",
                "Making this repository private could permanently erase these counts by removing stars and watchers associated to users that will no longer have access to this repository:": "该仓库私有化，将会通过解除星标者和关注者，删除这些计数。他们将无法访问该仓库：",
                    "star": "星标者",
                    "stars": "星标者",
                    "watcher": "关注者",
                    "watchers": "关注者",
                "If you decide to make this repository public in the future, it will not be possible to restore these stars and watchers and this will affect its repository rankings.": "即使您决定将来公开此仓库，也无法恢复这些星标者和关注者，这将影响其仓库排名。",
                "Dependency graph and Dependabot alerts will remain enabled with permission to perform read-only analysis on this repository.": "依赖项关系图和 Dependabot 警报将保持启用，并有权限对该仓库进行只读分析。",
                "Dependency graph and Dependabot alerts will remain enabled with permission to perform read-only analysis on this repository. Any custom Dependabot alert rules will be disabled unless GitHub Advanced Security is enabled for this repository.": "依赖项关系图和 Dependabot 警报将继续启用，并允许对该仓库执行只读分析。除非为该仓库启用了 GitHub 高级安全功能，否则任何自定义的 Dependabot 警报规则都将被禁用。",
                "Code scanning will become unavailable.": "代码扫描将变得不可用。",
                "Current forks will remain public and will be detached from this repository.": "当前的复刻将保持公开，并将从该仓库中分离出来。",
                "Make this repository private": "将此仓库设为私有",
                "I have read and understand these effects": "我已阅读并理解这些影响",

                "Warning: this is a destructive action": "警告：这是一个破坏性的行为",
                "To confirm, type the number of stars on this repository in the box below": "要确认，请在下面的框中输入此仓库的星标数",

            "Disable branch protection rules": "禁用分支保护规则",
                "Disable branch protection rules enforcement and APIs": "禁用分支保护规则执行和 API",

                // 顶部提醒
                    "Branch protection settings saved.": "分支保护设置已保存。",

            // 禁用分支保护对话框
                "This will hide the branch protection settings and disable branch protection rules for this repository.": "这将隐藏分支保护设置，并禁用该仓库的分支保护规则。",
                "Disabling branch protection rules allows you to enforce branch and tag protections exclusively with Repository Rules.": "禁用分支保护规则后，允许您仅使用仓库规则来执行分支和标签保护。",

                "This action will disable:": "此操作将禁用：",
                    "Branch protection rule enforcement": "分支保护执行",
                    "Branch protection rule APIs": "分支保护 API",
                // [/(\d+) branch protection rules?/, "$1 项分支保护规则"],
                "will be disabled as part of this action": "作为此操作的一部分将被禁用",

            "Re-enable branch protection rules": "重新启用分支保护规则",
                "Re-enable branch protection rules enforcement and APIs": "重新启用分支保护规则执行和 API",

            // 重新启用分支保护对话框
                "Re-enable branch protection": "重新启用分支保护",
                "will be re-enabled as part of this action": "作为此操作的一部分将被重新启用",

            "Transfer ownership": "转让所有权",
            "Transfer": "转让",
            "Transfer this repository to another user or to an organization where you have the ability to create repositories.": "将此仓库转让给另一位用户或您可以创建仓库的组织。",
            "Organization members cannot transfer repositories": "组织成员没有转让所有权的权限",

            "Leave fork network": "离开复刻网络",
            "Can't leave the fork network because this fork has child forks.": "无法离开复刻网络，因为此复刻有子复刻。",
            "Can't detach forks larger than 1 GB.": "无法解除大于 1 GB 的复刻关联。",
            "Unlink this repository from the fork network and make it standalone.": "将该仓库从复刻网络中解除关联，使其成为独立仓库。",
            "Detach is in progress.": "分离中。",
            // 顶部提醒
                "Detaching this repository.": "分离此仓库…",

            "Archive this repository": "存档仓库",
            "Mark this repository as archived and read-only.": "将此仓库标记为已存档和只读。",

            // 存档仓库对话框
            "Archive repository": "存档仓库",
            "This repository will become read-only.": "该仓库将设置为只读。",
            "You will still be able to fork the repository and unarchive it at any time.": "您仍然可以随时访问复刻仓库并取消存档。",
            "Unexpected bad things will happen if you don’t read this!": "如果您不阅读此说明，将会发生意想不到的事情！",
            "All scheduled workflows will stop running.": "所有预定的工作流程将停止运行。",
            "Security features will be unavailable:": "安全功能将无法使用：",
            "Code scanning": "代码扫描",
            "Before you archive, please consider:": "在您存档之前，请考虑：",
            "Updating any repository settings": "更新仓库设置",
            "Closing all open issues and pull requests": "关闭所有打开的议题和拉取请求",
            "Making a note in your README": "在您的 README 中做个说明",
            "Please type": "请键入",
            "to confirm.": "进行确定。",
            "I understand the consequences, archive this repository": "我明白后果，依然存档该仓库",
            // "This repository has been archived by the owner. It is now read-only.": "此仓库已由所有者存档。它现在是只读的。",

            // 顶部提醒
            // [/Your repository \"([^ ]+)\" was successfully archived./, "您的仓库 “$1” 已成功存档。"], //仓库存档

            "Unarchive this repository": "解除仓库存档",
            "Mark this repository as unarchived and read-write.": "将此仓库标记为未存档和可读写。",

            // 解除仓库存档对话框
            "Unarchive repository": "解除仓库存档",
            "This will make": "这将使",
            "read-write.": "可读写。",
            "Once unarchived, the following can be modified and commented on:": "一旦解除存档，就可以对以下内容进行修改和评论：",
            "Pull Requests": "拉取请求",
            "Labels": "标签",
            "Releases": "发行版",
            "Milestones": "里程碑",
            "Past due by": "已经过期于",
            "Security features will become available:": "安全功能将不可用：",
            "I understand the consequences, unarchive this repository": "我明白后果，依然解除该仓库存档",

            "Delete this repository": "删除仓库",
            "Once you delete a repository, there is no going back. Please be certain.": "您一旦删除仓库，将再也无法恢复。请确认。",
            "Organization members cannot delete repositories.": "组织成员没有删除仓库的权限",

            // 离开复刻网络对话框
                "This will permanently remove the fork relationship to the upstream repository": "这将永久移除与上游仓库的复刻关系：",
                "will become a standalone repository and will no longer be able to fetch upstream updates or propose changes to the upstream repository": "将成为独立仓库，无法再获取上游更新，也无法向原仓库提交更改：",
                "cannot rejoin the fork network.": "不能重新加入复刻网络。",

            // 顶部提醒
            // [/Your repository \"([^ ]+)\" was successfully unarchived./, "您的仓库 “$1” 已成功解除存档。"], //仓库解除存档

            // 删除仓库对话框
                // [/Delete/, "删除"],
                "I want to delete this repository": "我想删除这个仓库",

                "This will permanently delete the": "这将永久删除",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all collaborator associations will be permanently deleted.": "仓库、Wiki、议题、评论、软件包、机密、工作流程，并删除所有协作者关联。",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all collaborator associations.": "仓库、Wiki、议题、评论、软件包、机密、工作流程，并删除所有协作者关联。",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all team associations.": "仓库、Wiki、议题、评论、软件包、机密、工作流程，并删除所有团队关联。", // 组织仓库
                "This will not change your billing plan. If you want to downgrade, you can do so in your Billing Settings.": "这并不会更改您的结算方案。 如果您想降级，可以在结算设置中进行降级。",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/is available./, "名称可用。"],
        [/Make ([^ ]+) private/, "将 $1 设为私有"],
        [/Make ([^ ]+) public/, "将 $1 设为公开"],
        [/(\d+) stars?/, "$1 位星标者"],
        [/(\d+) watchers?/, "$1 位关注者"],
        [/To confirm, type \"([^ ]+)\" in the box below/, "要确认，请在下面的方框中输入 \"$1\""],
        [/Your repository \"([^ ]+)\" was successfully archived./, "您的仓库 “$1” 已成功存档。"], //仓库存档
        [/Your repository \"([^ ]+)\" was successfully unarchived./, "您的仓库 “$1” 已成功解除存档。"], //仓库解除存档
        [/is already the branch name./, "已经是分支的名称了。"],
        [/Your branch name will be/, "您的分支的名称将重命名为"],
        [/Choose another branch to use as the default branch of ([^ ]+) instead of/,"选择另一分支作为 $1 的默认分支而不是"], // 分支切换 对话框
        [/(\d+) branch protection rules?/, "$1 项分支保护规则"], // 禁用/重启启用分支保护
        [/Delete/, "删除"],
        [/Default branch changed to ([^ ])/, "默认分支更改为 $1"],
        // 离开复刻网络
        [/Forked from ([^ ])/, "复刻自 $1"],
    ],
    "title": {
        "static": {
            "General": "通常",
        },
    },
};

I18N["zh-CN"]["repository/settings/access"] = { // 仓库设置 - 协作者/(组织仓库 协作者和团队) /<user-name>/<repo-name>/settings/access
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 协作者 / 协作者和团队 - 访问管理页面 /<user-name>/<repo-name>/settings/access ====================================
            // 顶部提醒
                "Repository invitation URLs work for invited users only. You may only share this URL with an invited user.": "仓库邀请 URL 仅适用于受邀请的用户。您只能与受邀请的用户共享此 URL。",

                // [/Removed ([^ ]+) as a collaborator of ([^ ]+\/[^ ]+)/, "删除 $1 为 $2 的协作者"],

            "Who has access": "谁有权访问",
            "public repository": "公共仓库",
            "Public repository": "公共仓库",
            "This repository is public and visible to anyone": "该仓库是公开的，对任何人都可见",
            "This repository is public and visible to anyone.": "该仓库是公开的，对任何人都可见。",
            "private repository": "私有仓库",
            "Only those with access to this repository can view it.": "只有拥有该仓库访问权的用户才能查看。",
            "Manage": "管理",
            "Manage visibility": "管理", // 内容重复，直接省略

            "Direct access": "直接访问",
            "collaborators have access to this repository. Only you can contribute to this repository.": "个协作者有权访问此仓库。 只有您可以对此仓库做出贡献。",
            "has access to this repository.": "位有权访问此仓库。",
            "have access to this repository.": "有权访问此仓库。",
            // 组织仓库
            "teams or members have access to this repository. Only": "团队或成员有权访问此仓库。只有",
            "Owners": "所有者",
            "can contribute to this repository.": "可以为此仓库做出贡献。",

            // 组织仓库
            "Base role": "基本角色",
            "All": "所有",
            // [/(\d+) members?/, "$1 位成员"],
            "can access this repository.": "可以访问此仓库。",

            "Manage access": "访问管理",
            "You haven't invited any collaborators yet": "您尚未邀请任何协作者",
            // "invite a collaborator": "邀请协作者",
            "Add people": "添加他人",
                // 邀请对话框
                    "Add people to": "添加成员到",
                    "Search by username, full name, or email": "搜索用户名、全名、或电子邮箱",
                    "Find people": "查找",
                    "Invite collaborator": "邀请协作者",
                    "Add to repository": "添加到仓库",
                    // 顶部提醒
                        // [/([^ ]+) has been added as a collaborator on the repository./, "$1 已被添加为仓库的协作者。"],


            "Select all": "全选",
                // [/(\d+) members? selected…/, "已选择 $1 名成员..."],
                "Change role": "切换角色",
                "Remove Access": "删除访问权限",
            "Type": "类型",
                "Filter by member type": "按成员类型筛选",
                    "Organization Members": "组织成员",
                    "Outside Collaborators": "外部协作者",
                    "Pending Invitations": "待处理邀请",
            "Find a collaborator…": "寻找协作者……",
            "Find people or a team…": "寻找用户或一个团队……",
            "No Results": "无结果",

            "Pending Invite": "待处理邀请",
            "Invite expired": "已过期",
            // [/Awaiting ([^ ]+)’s response/, "等待 $1 的回复"],
            "Remove": "移除",

            // 移除邀请对话框
                "Confirm you want to remove this invitation": "确认移除邀请",
                "Once canceled,": "取消后，",
                "will no longer be invited to access the": "将不再被邀请访问",
                "repository.": "仓库。",
                // [/Cancel ([^ ]+)'s invitation/, "取消邀请 $1"],
                // 顶部提醒
                    // [/([^ ]+) is no longer invited to this repository./, "$1 不再受邀访问该仓库。"],

            // 删除协助者对话框
                "Confirm you want to remove this member": "确认要删除此成员？",
                "Once removed,": "一旦删除，",
                "will no longer have direct access to this repository. However, they may still have access to this repository if they are a member of a team that is granted access.": "将不再能直接访问此仓库。但是，如果他们是获准访问该仓库的团队成员，则仍可访问该仓库。",
                // 顶部提醒
                    // [/Remove ([^ ]+) from this repository/, "从该仓库移除 $1"],

            // 组织仓库
            "Create team": "创建组织",
            "You haven't added any teams or people yet": "您尚未添加团队或成员",
            "Organization owners can manage individual and team access to the organization's repositories. Team maintainers can also manage a team's repository access.": "组织所有者可以管理成员和团队对组织仓库的访问。团队维护者也可以管理一个团队的仓库访问。",
            "Learn more about organization access": "了解更多关于组织访问权限的信息",
            "Add teams": "添加团队",

            // "Add people to": "添加成员到",
            "Select a member above": "在上面选择一名成员",
            "Add teams to": "添加团队",
            "Search by team name": "按团队名称搜索",
            "Select a team above": "在上面选择一个团队",

    },
    "regexp": [ // 正则翻译
        [/(\d+) members? selected…/, "已选择 $1 名成员..."],
        [/(\d+) members?/, "$1 位成员"],
        [/(\d+) collaborators?/, "$1 位协作者"],
        [/(\d+) invitations?/, "$1 个邀请"],
        [/Awaiting ([^ ]+)’s response/, "等待 $1 的回复"],
        [/([^ ]+) • Collaborator/, "$1 • 协作者"],
        [/([^ ]+) • Invite collaborator/, "$1 • 邀请协作者"],
        [/(\d+) users?/, "$1 个用户"],
        [/(\d+) teams?/, "$1 个团队"],
        [/Add people to ([^ ]+)/, "添加人员到 $1"],
        [/([^ ]+) has been added as a collaborator on the repository./, "已将 $1 添加为仓库协作者。"],
        [/Cancel ([^ ]+)'s invitation/, "取消邀请 $1"],
        [/([^ ]+) is no longer invited to this repository./, "$1 不再受邀访问该仓库。"],
        [/Remove ([^ ]+) from this repository/, "从该仓库移除 $1"],
        [/Removed ([^ ]+) as a collaborator of ([^ ]+\/[^ ]+)/, "删除 $1 为 $2 的协作者"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Manage access": "访问管理",
        },
    },
};

I18N["zh-CN"]["repository/settings/interaction_limits"] = { // 仓库设置 - 互动限制 /<user-name>/<repo-name>/settings/interaction_limits
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 审查设置 (仓库)互动限制 /<user-name>/<repo-name>/settings/interaction_limits
        // 同全局 同组织仓库
            "Temporary interaction limits": "临时互动限制",
            "Temporarily restrict which external users can interact with your repository (comment, open issues, or create pull requests) for a configurable period of time.": "在配置的时间段内，可临时限制哪些外部用户与您的仓库互动（评论、打开议题或创建拉取请求）。",
            "This may be used to force a \"cool-down\" period during heated discussions or prevent unwanted interactions.": "可用于在激烈讨论期间，强制进入 “冷静” 期或防止不必要的互动。",

            "You can restrict repository interactions across your account in your": "您可以限制仓库交互，在您的账户设置中的",
            "account settings": "互动限制",

            // [/You can restrict repository interactions across the ([^ ]+) organization in your/, "您可以在您的 $1 组织中限制仓库交互"],

            "Limit to existing users": "仅限现有用户",
                "Users that have recently created their account will be unable to interact with the repository.": "最近创建账户的用户将无法与该仓库互动。",
            "Limit to prior contributors": "仅限于先前的贡献者",
                "Users that have not previously": "以前从未",
                "committed": "提交",
                // [/to the ([^ ]+) branch of this repository will be unable to interact with the repository./, "到该仓库的 $1 分支的用户将无法与该仓库互动。"],
            "Limit to repository collaborators": "仅限仓库协作者",
                "Users that are not": "不是",
                // "collaborators": "",
                // "of one of your repositories will not be able to interact with that repository.": "",
                "will not be able to interact with the repository.": "将无法与该仓库互动。",

            "New users": "新用户",
            "Users": "用户",
            "Contributors": "贡献者",
            "Collaborators": "协作者",
            "Organization members": "组织成员", //组织仓库

            "Enable": "启用",
            "Disable": "禁用",
            // 交互限制时间 下拉菜单
            "Enable interaction limits for:": "启用交互限制：",
            "24 hours": "24 小时",
            "3 days": "3 天",
            "1 week": "1 周",
            "1 month": "1 个月",
            "6 months": "6 个月",

            // 顶部提醒
            "Repository interaction limit settings saved.": "仓库交互限制设置已保存。",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
            [/You can restrict repository interactions across the ([^ ]+) organization in your/, "您可以在您的 $1 组织中限制仓库交互"],
            [/to the ([^ ]+) branch of this repository will be unable to interact with the repository./, "到该仓库的 $1 分支的用户将无法与该仓库互动。"],
    ],
    "title": {
        "static": {
            "Temporary interaction limits": "临时互动限制",
        },
    },
};

I18N["zh-CN"]["repository/settings/code_review_limits"] = { // 仓库设置 - 代码审查限制 /<user-name>/<repo-name>/settings/code_review_limits
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // Code review limits 代码审查限制 /<user-name>/<repo-name>/settings/code_review_limits
            "Restrict users who are permitted to approve or request changes on pull requests in this repository.": "限制允许批准或请求更改该仓库中拉取请求的用户。",
            "Limit to users explicitly granted": "限于明确授予",
            "read": "读取",
            "or higher access": "或 更高权限的用户",
                "When enabled, only users explicitly granted access to this repository will be able to submit pull request reviews that \"approve\" or \"request changes\". All users able to submit comment pull request reviews will continue to be able to do so.": "启用后，只有被明确授予该仓库访问权的用户才能提交 “批准” 或 “请求更改” 的拉取请求审查。所有能够提交评论拉取请求审查的用户将继续能够这样做。",

            // 顶部提醒
                "Code review limit settings saved.": "代码审查限制设置已保存。",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Code review limits": "代码审查限制",
        },
    },
};

I18N["zh-CN"]["repository/settings/branches"] = { // 仓库设置 - 分支 /<user-name>/<repo-name>/settings/branches
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 分支管理页面 /<user-name>/<repo-name>/settings/branches====================================
            "Branch protection rules": "分支保护规则",
            "Add rule": "添加规则",

            "Define branch protection rules to disable force pushing, prevent branches from being deleted, and optionally require status checks before merging. New to branch protection rules?": "定义分支保护规则，以禁止强制推送，防止分支被删除，并可选择要求在合并前进行状态检查。初次接触分支保护规则？",

            "No branch protection rules defined yet.": "尚未定义分支保护规则。",

            "You haven't protected any of your branches": "您没有保护任何分支",
            "Classic branch protections have not been configured": "未配置经典分支保护",
            "Define branch rules to disable force pushing, prevent branches from being deleted, or require pull requests before merging. Learn more about": "定义分支规则，以禁止强制推送、防止分支被删除或在合并前要求提交拉取请求。了解更多：",
            //"Define a protected branch rule to disable force pushing, prevent branches from being deleted, and optionally require status checks before merging.": "定义分支保护规则，以禁用强制推送，防止分支被删除，并可选择在合并前进行状态检查。",
            "repository rules": "仓库规则",
            "protected branches": "受保护分支",
            "Add branch ruleset": "添加分支规则集",
            "Add classic branch protection rule": "添加经典分支保护规则",
            //"Learn more about protected branches": "了解更多关于受保护分支的信息",
            //"Add branch protection rule": "添加分支保护规则",

            // 私有库 分支保护 未执行 提醒
            "Your protected branch rules won't be enforced on this private repository until you move to a GitHub Team or Enterprise organization account.": "您的受保护分支规则不会在这个私有仓库上执行，直到您迁移至 GitHub 团队或企业组织账户。",
            "Move to an organization": "转移到组织",

            "Not enforced": "未执行",
                "Rules on your private repos can't be enforced until you upgrade to GitHub Team or Enterprise.": "在您升级到 GitHub 团队或企业版之前，您的私有仓库的规则不能被执行。",

            // [/Currently applies to (\d+) branchs?/, "目前适用于 $1 个分支"], // 仓库设置-->分支-->分支保护规则

            // 删除分支保护规则
            "Delete this branch protection rule?": "删除此分支保护规则？",
            "This action cannot be undone.": "此操作无法撤消。",
            "I understand, delete this rule.": "我明白了，依然删除此规则。",

            // 顶部提醒
            "Branch protection rule settings saved.": "分支保护规则设置已保存。",
            "Branch protection rule created.": "分支保护规则已创建。",
            "Branch protection rule was successfully deleted.": "分支保护规则已成功删除。",


    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Currently applies to (\d+) branch(?:es|)/, "目前适用于 $1 个分支"], // 仓库设置-->分支-->分支保护规则
    ],
    "title": {
        "regexp": [
            [/Settings · Branches/, "设置 · 分支"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/branch_protection_rules"] = { // 仓库设置 - 分支/分支保护 /<user-name>/<repo-name>/settings/branch_protection_rules
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 新建分支保护规则 页面 /<user-name>/<repo-name>/settings/branch_protection_rules/new====================================
            "Branch protection rule": "分支保护规则",

            "Protect your most important branches": "保护您最重要的分支",
                "Branch protection rules": "分支保护规则",
                "define whether collaborators can delete or force push to the branch and set requirements for any pushes to the branch, such as passing status checks or a linear commit history.": "定义协作者是否可以删除或强制推送到分支，并对任何推送到分支的内容设置要求，如通过状态检查或线性提交历史。",

                "Your GitHub Free plan": "您的 GitHub 免费计划",
                "Your organization's GitHub Free plan": "您组织的 GitHub 免费计划", // 组织仓库
                "can only enforce rules on its public repositories, like this one.": "只能对其公共仓库执行规则，例如这个。",

                "Your rules won't be enforced on this private repository until you": "您的规则将不会在此私有仓库上强制执行，直到您",
                "move to a GitHub Team or Enterprise organization account": "迁移至 GitHub 团队或企业组织账户",
                "upgrade this organization to GitHub Team or Enterprise": "升级组织至 GitHub 团队或企业版", // 组织仓库

            "Branch name pattern": "分支名称模式",
            "Protect matching branches": "保护匹配的分支",
                "Require a pull request before merging": "要求在合并前提交拉取请求",
                    "When enabled, all commits must be made to a non-protected branch and submitted via a pull request before they can be merged into a branch that matches this rule.": "启用后，所有提交都必须提交到不受保护的分支，并通过拉取请求提交，然后才能将它们合并到与此规则匹配的分支中。",
                    "Require approvals": "要求批准审查",
                        "When enabled, pull requests targeting a matching branch require a number of approvals and no changes requested before they can be merged.": "启用后，针对匹配分支的拉取请求需要若干次批准审查，并且在合并之前无需请求更改。",
                        "Required number of approvals before merging:": "合并前所需的批准审查数量：",
                    "Dismiss stale pull request approvals when new commits are pushed": "当新的提交被推送时，撤销陈旧的拉取请求批准审查",
                        "New reviewable commits pushed to a matching branch will dismiss pull request review approvals.": "推送到匹配分支的新的可审查提交将撤销之前的拉取请求的批准审查。",
                    "Require review from Code Owners": "要求代码所有者进行审查",
                        "Require an approved review in pull requests including files with a designated code owner.": "要求在拉取请求中进行批准审查，包括有指定代码所有者的文件。",
                    "Restrict who can dismiss pull request reviews": "限制谁可以驳回拉取请求审查", // 组织仓库
                        "Specify people, teams, or apps allowed to dismiss pull request reviews.": "指定允许驳回拉取请求审查的人员、团队或应用。",
                        "People, teams, or apps that can dismiss reviews.": "允许驳回审查的人员、团队或应用。",
                            "Organization and repository administrators": "组织和仓库管理员",
                                "These members can always dismiss.": "这些成员总是允许驳回。",
                                "These members cannot dismiss.": "这些成员不允许驳回。",
                    "Allow specified actors to bypass required pull requests": "允许指定的参与者绕过所需的拉取请求", //组织仓库
                        "Specify people, teams, or apps who are allowed to bypass required pull requests.": "指定允许绕过所需拉取请求的人员、团队或应用。",
                        "People, teams, or apps who can bypass required pull requests": "允许绕过所需拉取请求的人员、团队或应用",
                            // "Organization and repository administrators": "组织和仓库管理员",
                                "These members can always bypass required pull requests.": "这些成员始终允许绕过所需的拉取请求。",
                                "These members cannot bypass.": "这些成员不允许绕过。",
                    "Require approval of the most recent reviewable push": "要求批准最新的可审查推送",
                        "Whether the most recent reviewable push must be approved by someone other than the person who pushed it.": "最新的可审核推送是否必须得到推送者以外的其他人批准。",
                "Require status checks to pass before merging": "要求在合并前通过状态检查",
                    "Choose which": "选择那些",
                    "status checks": "状态检查",
                    "must pass before branches can be merged into a branch that matches this rule. When enabled, commits must first be pushed to another branch, then merged or pushed directly to a branch that matches this rule after status checks have passed.": "必须通过，才能将分支合并到符合此规则的分支。启用后，提交的内容必须先推送到另一个分支，然后在状态检查通过后再合并或直接推送到符合此规则的分支。",

                    "Require branches to be up to date before merging": "要求分支在合并前必须是最新的",
                        "This ensures pull requests targeting a matching branch have been tested with the latest code. This setting will not take effect unless at least one status check is enabled (see below).": "这可确保针对匹配分支的拉取请求已使用最新的代码进行了测试。除非启用了至少一个状态检查，否则这个设置不会生效（见下文）。",

                    "Do not require status checks on creation": "不要求在创建时进行状态检查",
                        "Allow repositories and branches to be created if a check would otherwise prohibit it.": "允许创建仓库和分支，否则检查将禁止创建。",

                    "Search for status checks in the last week for this repository": "搜索此仓库最近一周的状态检查",
                    "Status checks that are required.": "需要进行的状态检查。",

                    "No status checks found": "尚无状态检查",
                        "Sorry, we couldn’t find any status checks in the last week for this repository.": "抱歉，我们最近一周未找此仓库的任何状态检查。",
                    "Learn more about status checks": "了解更多关于状态检查的信息",
                "Require conversation resolution before merging": "要求在合并前解决对话",
                    "When enabled, all conversations on code must be resolved before a pull request can be merged into a branch that matches this rule.": "启用后，必须先解决所有有关代码的对话，然后才能将拉取请求合并到与此规则匹配的分支中。",
                    "Learn more about requiring conversation completion before merging": "了解更多关于合并前要求完成对话的信息",
                "Require signed commits": "要求带签名的提交",
                    "Commits pushed to matching branches must have verified signatures.": "推送到匹配分支的提交必须带有经过验证的签名。",
                "Require linear history": "要求线性历史记录",
                    "Prevent merge commits from being pushed to matching branches.": "防止合并后的提交被推送到匹配的分支。",
                "Require merge queue": "要求合并队列", // 组织仓库
                    "Merges to matching branches must be performed via a merge queue.": "对匹配分支的合并必须通过合并队列执行。",
                    "Make sure to configure your CI to build branches created by the queue.": "确保您配置 CI 以构建由队列创建的分支",
                    "Merge method": "合并模式",
                        "Method to use when merging changes from queued pull requests.": "合并来自列队拉取请求的更改时使用的模式。",
                        "Method:": "模式：",
                            "Merge commit": "合并提交",
                            "Squash and merge": "压缩合并",
                            "Rebase and merge": "变基合并",
                    "Build concurrency": "构建并发",
                        "Limit the number of queued pull requests building at the same time.": "限制同时构建的列队拉取请求的数量。",
                        "Maximum pull requests to build:": "构建的最大拉取请求：",
                    "Merge limits": "合并限制",
                        "Limit the number of pull requests merged into the protected branch in a single merge operation.": "限制在单个合并操作中合并到受保护分支的拉取请求的数量。",
                        "Minimum pull requests to merge:": "合并的最小拉取请求：",
                            "or after": "或",
                            "minutes": "分钟之后",
                        "Maximum pull requests to merge:": "合并的最大拉取请求：",
                        "Only merge non-failing pull requests": "仅合并未失败的拉取请求",
                    "Status check timeout": "状态检查超时",
                        "Time (in minutes) a required status check must report a conclusion within to not be considered failed.": "所需的状态检查必须在规定的时间（以分钟为单位）内报告结论才不会被视为失败。",
                        "Consider check failed after:": "考虑检查失败：",
                "Require deployments to succeed before merging": "要求部署成功后再合并",
                    "Choose which environments must be successfully deployed to before branches can be merged into a branch that matches this rule.": "选择必须成功部署到哪些环境才能将分支合并到与此规则匹配的分支中。",
                            "No deployment environments found": "尚无部署环境",
                            "Sorry, we couldn’t find any deployments for this repository.": "抱歉，我们未找到此仓库的任何部署。",
                            "Deployment environments found in this repository": "在此仓库中找到的部署环境",
                                "Required": "必须",
                "Lock branch": "锁定分支",
                    "Branch is read-only. Users cannot push to the branch.": "分支为只读。用户无法推送到该分支。",
                "Do not allow bypassing the above settings": "不允许绕过上述设置",
                    "The above settings will apply to administrators and custom roles with the \"bypass branch protections\" permission.": "上述设置将应用于具有 “绕过分支保护” 权限的管理员和自定义角色。",
                "Restrict who can push to matching branches": "限制谁可以推送到匹配的分支", // 组织仓库
                    "Specify people, teams, or apps allowed to push to matching branches. Required status checks will still prevent these people, teams, and apps from merging if the checks fail.": "指定允许推送到匹配分支的人员、团队或应用。如果检查失败，所需的状态检查仍然会阻止这些人、团队和应用的合并。",

                    "Restrict pushes that create matching branches": "限制创建匹配分支的推送",
                        "Only people, teams, or apps allowed to push will be able to create new branches matching this rule.": "只有允许推送的人员、团队或应用才能创建符合此规则的新分支。",
                        "People, teams, or apps with push access": "允许推送的人员、团队或应用",
                            "Organization administrators, repository administrators, and users with the Maintain role.": "组织管理员、仓管理员和具有维护角色的用户。",
                            "Organization administrators, repository administrators, the merge queue, and users with the Maintain role.": "组织管理员、仓管理员、合并队列和具有维护角色的用户。", // 开启需要合并队列
                                "Admins can always push. Users with the Maintain role can push when required status checks pass.": "管理员始终允许推送。具有维护角色的用户允许在所需状态检查通过时推送。",
                                "These members can push when required status checks pass.": "这些成员允许在所需状态检查通过时推送。",

            "Rules applied to everyone including administrators": "规则适用于每个人，包括管理员",
                "Allow force pushes": "允许强制推送",
                    "Everyone": "所有人",
                        "Permit force pushes for all users with push access.": "允许所有有推送权限的用户强制推送。",
                    "Specify who can force push": "指定谁允许强制推送",
                        "Only these people, teams, or apps are allowed to force push.": "仅允许这些人、团队或应用强制推送。",
                        "Search for people, teams, or apps": "搜索人员、团队或应用",
                        "People, teams, or apps who can force push": "允许强制推送的人员、团队或应用",
                            "Organization and repository administrators (automatic)": "组织和仓库管理员（自动）",
                "Allow deletions": "允许删除",
                    "Allow users with push access to delete matching branches.": "允许具有推送权限的用户删除匹配的分支。",

            // 顶部提醒
            "Branch protection rule created.": "分支保护规则已创建。",

        // 编辑分支保护规则 页面 /<user-name>/<repo-name>/settings/branch_protection_rules/<id>===================================
            // [/Applies to (\d+) branchs?/, "应用于 $1 个分支"], //仓库设置-->分支-->分支保护规则-->编辑

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Applies to (\d+) branch(?:es|)/, "应用于 $1 个分支"], //仓库设置-->分支-->分支保护规则-->编辑
    ],
    "title": {
        "regexp": [
            [/Settings · Branches · New branch protection rule/, "设置 · 分支 · 新建分支保护规则"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/tag_protection"] = { // 仓库设置 - 标签 /<user-name>/<repo-name>/settings/tag_protection
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 标签 页面 /<user-name>/<repo-name>/settings/tag_protection===============================
            // 顶部提醒
                "Tag protection rule created.": "标签保护规则已创建。",
                "Tag protection rule deleted.": "标签保护规则已删除。",

            // 顶部窗口
            "Level up your tag protections with Repository Rules": "利用仓库规则提升标签保护级别",
            "Protected tags are being deprecated. To continue protecting tags, please migrate to a tag ruleset by August 30th. You can learn more about the sunset in our": "受保护的标签将被废弃。要继续保护标签，请在 8 月 30 日前迁移到标签规则集。您可以在我们的",
            "changelog": "更改日志",
            "and can get started now by migrating to rulesets.": "中了解更多信息，并且可以立即开始迁移到规则集。",

            "Protected tags": "受保护的标签",
            "Protected tags are available to Pro, Team, and Enterprise users": "专业版、团队版和企业版用户均可使用受保护的标签", //私有库
            "Protected tags can only be created or deleted by users with enhanced permissions defined by your organization owners.": "受保护的标签只能由具有由组织所有者定义的增强权限的用户创建或删除。",
            "Learn more about protected tags": "了解更多关于受保护标签的信息",
            "No protected tag rules exist yet": "尚无受保护的标签规则存在",
            "Protected tags have been deprecated": "受保护的标签已弃用",
            "Go to rulesets to create new tag rules": "转到规则集创建新标签规则",
            "New rule": "新建规则",
            "Import to rulesets": "导入规则集",
                "Import your tag protection rules into repository rules": "将您的标签保护规则导入仓库规则集",
                    "Migrate your protected tags to one or more repository rulesets. This will implement the same tag protections you currently have today. Once created, the tag rulesets can take advantage of new ruleset features:": "将受保护的标签迁移到一个或多个仓库规则集。这将实现与当前相同的标签保护。创建后，标签规则集可利用规则集的新功能：",
                        "Requiring status checks to pass": "要求通过状态检查",
                        "Signed commits": "要求签名提交",
                        "Requiring linear history": "需要线性历史",
                        "and more": "和更多",
                    "Create separate rulesets for creating and deleting protected tags": "为创建和删除受保护的标签创建单独的规则集",
                        "Users and Teams with at least Maintainer role will be able to create new protected tags. Administrators will be able to delete protected tags. This is the same behavior as existing tag protections.": "至少具有维护者角色的用户和团队可以创建新的受保护标签。管理员可以删除受保护标签。这与现有标签保护的行为相同。",
                    "Create one ruleset for all protected tag operations": "为所有受保护的标签操作创建规则集",
                        "Administrators will be able to create and delete protected tags.": "管理员可以创建和删除受保护的标签。",

                    "Learn more about tag rulesets": "了解更多关于标签规则集的信息",
                    "Import": "导入",

            "Delete tag protection rule": "删除标签保护规则",
                "Delete tag protection rule?": "删除标签保护规则？",
                    "Are you sure you want to delete this tag protection rule? Anyone who can write to this repository will be able to create tags with this pattern.": "您确定要删除此标签保护规则吗？任何可以写入此仓库的人都能够使用此模式创建标签。",
                    "Yes, remove this tag protection rule": "是的，删除此标签保护规则",

            // [/(\d+) rules?/, "$1 条规则"],

        // 新建标签规则 页面 /<user-name>/<repo-name>/settings/tag_protection/new===============================
            "/ New rule": "/ 新建规则",
            "Tag name pattern": "标签名称模式",
            "Example: You can use": "示例：您可以使用",
            "to target tags named": "来锁定名为",
            ", and so on.": "等的标签。",

            "Add rule": "添加规则",

    },
    "regexp": [ // 正则翻译
        [/(\d+) rules?/, "$1 条规则"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Settings · Tags/, "设置 · 标签"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/rules"] = { // 仓库设置 - 规则 - 规则集 /<user-name>/<repo-name>/settings/rules
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"], // 组织设置
        ...I18N["zh-CN"]["confirm-access"]["static"],

        // 仓库规则集页面 /<user-name>/<repo-name>/rules
        // 规则集 页面 /<user-name>/<repo-name>/settings/rules
            "Your rulesets won't be enforced on this private repository until you upgrade this organization account to GitHub Team.": "在您将此组织账户升级到 GitHub Team 之前，您的规则集不会在此私有仓库上强制执行。", // 组织 私有仓库

            "Organization rulesets won't be enforced": "在您将该组织账户升级到 GitHub 企业版之前，", // 组织设置
            "until you upgrade this organization account to GitHub Enterprise.": "组织规则集将不会强制执行。", // 组织设置

            "You haven't created any rulesets": "您尚未创建任何规则集",
                "Define whether collaborators can delete or force push and set requirements for any pushes, such as passing status checks or a linear commit history.": "定义协作者是否可以删除或强制推送，并为任何推送设置要求，如通过状态检查或线性提交历史。",
                "Learn more about rulesets.": "了解更多关于规则集的信息。",

            "Rulesets": "规则集",
            "New ruleset": "新建规则集",
                "New branch ruleset": "新建分支规则集",
                    "New tag ruleset": "新建标签规则集",
                    "Import a ruleset": "导入规则集",
                        "Choose a JSON file to upload": "选择 JSON 文件上传",

            "Ruleset": "规则集",

            "No rulesets have been added yet": "尚未添加任何规则集",

            "All": "全部",
            "• targeting": "• 针对",
            ", targeting": ", 针对",

            "Ruleset menu": "菜单",
                "Export ruleset": "导出规则集",
                "Delete ruleset": "删除规则",

            // 删除规则对话框
                "Delete ruleset?": "删除规则？",
                "Are you sure you want to delete this ruleset? This action cannot be undone.": "您确定要删除此规则集吗？此操作无法撤消。",

        // 新建分支规则 /<user-name>/<repo-name>/settings/rules/new?target=branch&enforcement=disabled
        // 新建标签规则 /<user-name>/<repo-name>/settings/rules/new?target=tag&enforcement=disabled
        // 编辑规则 /<user-name>/<repo-name>/settings/rules/<id>

            "Protect your most important branches": "保护您最重要的分支",
                "define whether collaborators can delete or force push and set requirements for any pushes, such as passing status checks or a linear commit history.": "定义协作者是否可以删除或强制推送，并为任何推送设置要求，如通过状态检查或线性提交历史。",

            "Tag": "标签",
            "tags": "标签",

            "Open additional options": "打开其他选项",
            "Export": "导出",
            "ruleset": "规则",

            "Name": "名称",
                "Ruleset name cannot be empty": "规则集名称不能为空",
            "Enforcement status": "执行状态",
                "Active": "激活",
                    "This ruleset will be enforced": "规则将被执行",
                    "Rules will be enforced": "规则将被执行",
                    "Enable Organization Ruleset": "启用组织规则集", // 组织设置
                        "I want rules enforced on targeted repositories in this ruleset.": "我希望此规则集中强制执行针对目标仓库的规则。",
                "Evaluate": "评估", // 组织设置
                    "Evaluate Rulesets to trial rules and view insights": "评估规则集，以试用规则并查看洞察",
                    "Evaluate mode is only available to Enterprise organizations.": "评估模式仅适用于企业组织。",
                        "Upgrade to Enterprise to use this mode.": "升级到企业版即可使用此模式。",
                "Disabled": "禁用",
                    "Do not evaluate or enforce rules": "不评估或执行规则",
                    "This ruleset will not be enforced": "规则将不被执行",

            "Bypass list": "旁路列表",
                "Exempt roles, teams, and apps from this ruleset by adding them to the bypass list.": "通过将角色、团队和应用程序添加到旁路列表，使其免受此规则集的约束。",
                "Exempt roles, teams, or apps from this ruleset by adding them to the bypass list.": "通过将角色、团队或应用程序添加到旁路列表，使其免受此规则集的约束。",
                "Exempt roles or teams from this ruleset by adding them to the bypass list": "通过将角色或团队添加到旁路列表，使其免受此规则集的约束", // 组织设置
                "Add bypass": "添加旁路",

                 // 添加旁路对话框
                    "Choose which roles, teams, and apps can bypass this ruleset": "选择哪些角色、团队和应用可绕过此规则集",

                    "Filter items": "筛选",
                    "Filter bypass actors": "筛选旁路参与者",

                    "No suggestions": "暂无建议",

                    "Suggestions": "建议",
                        "Role": "角色",
                        "App": "应用",
                        "Organization admin": "组织管理员",
                        "Repository admin": "仓库管理员",
                        "Maintain": "维护",
                        "triage": "分类",
                        "maintain": "维持",
                        "read": "读取",
                        "write": "写入",
                        "vulnerability_reporter": "漏洞报告员",
                        "Add selected": "添加所选",

                "Always allow": "总是允许",
                "Allow for pull requests only": "仅允许拉取请求",
                    "Allow": "允许",
                        "Always": "总是",
                        "For pull requests only": "仅适用于拉取请求",
                    "Delete bypass": "删除旁路",

                "Bypass list is empty": "旁路列表为空",

            "Target branches": "目标分支",
                "Which branches should be matched?": "哪些分支应匹配？",
                "Which branches do you want to make a ruleset for?": "您想为哪些分支制定规则集？",
                "Which tags do you want to make a ruleset for?": "您想为哪些标签制定规则集？", // 标签
                "Which repositories and branches do you want to make a ruleset for?": "您想为哪些仓库和分支创建规则集？", // 组织设置

                // 组织设置
                    "Target repositories": "目标仓库",
                        "Repository targeting determines which repositories will be protected by this ruleset. Use inclusion patterns to expand the list of repositories under this ruleset. Use exclusion patterns to exclude repositories.": "仓库目标确定哪些仓库将受此规则集保护。使用包含模式来扩展此规则集下的仓库列表。使用排除模式来排除仓库。",
                    "Target:": "目标：",
                        "All repositories": "所有仓库",
                            "Target all repositories within the organization": "组织内的所有仓库",
                        "Dynamic list by name": "按名称动态列表",
                            "Target repositories based on name": "基于名称的目标仓库",
                        "Dynamic list by property": "按属性动态列表",
                            "Target repositories based on properties": "基于属性的目标仓库",
                        "Select repositories": "选择仓库",
                            "Target a specific list of selected repositories": "以选定仓库列表为目标",

                    "Targeting criteria": "目标规则",
                        "No repository targets have been added yet": "尚未添加仓库目标",

                        "Prevent renaming of target repositories": "防止重命名目标仓库",
                            "When checked, target repositories can only be renamed by those with bypass permission.": "选中后，目标仓库只能由具有绕过权限的成员重命名。",

                            "Repositories that match the matching pattern will be targeted by this ruleset.": "与匹配规则相匹配的仓库将成为该规则集的目标。",
                            "Repositories that do not match the matching pattern will be targeted by this ruleset.": "与匹配规则不匹配的仓库将成为该规则集的目标。",

                    "Target by repository properties": "目标仓库属性",
                        "Repository targeting determines which repositories will be protected by this ruleset.": "仓库目标确定哪些仓库将受此规则集保护",

                        "Add a target": "添加目标",
                            "Include by property": "包含属性",
                            "Exclude by property": "排除属性",

                        "Include repositories by custom property": "按自定义属性包含仓库",
                            "Custom properties allow you to create your own metadata for repositories": "自定义属性允许您为仓库创建自己的元数据，",
                            "include": "包括",
                            "exclude": "排除",
                            "Property": "属性",
                                "Select property": "选择属性",
                                    "Select an item": "选择项目",
                                        "Search for properties": "搜索属性",

                    // 仓库
                        "Select items": "选择项目",
                            "Repos": "仓库",

                "Target": "目标",
                    "Branch targeting determines which branches will be protected by this ruleset. Use inclusion patterns to expand the list of branches under this ruleset. Use exclusion patterns to exclude branches.": "分支目标确定哪些分支将受此规则集保护。使用包含模式来扩展该规则集下的分支列表。使用排除模式来排除分支。",
                    "Tag targeting determines which tags will be protected by this ruleset. Use inclusion patterns to expand the list of tags under this ruleset. Use exclusion patterns to exclude tags.": "标签目标确定哪些标签将受此规则集保护。使用包含模式来扩展该规则集下的标签列表。使用排除模式来排除标签。", // 标签

                    "Branch targeting criteria": "目标分支规则",
                    "Tag targeting criteria": "目标标签规则", // 标签
                        "Add target": "添加目标",
                            "Include default branch": "包含默认分支",
                            "Include all branches": "包含所有分支",
                            "Include all tags": "包含所有标签", // 标签
                            "Target by inclusion or exclusion pattern": "通过包含或排除规则确定目标",
                            "Include by pattern": "包含规则",
                            "Exclude by pattern": "排除规则",

                        "Branch targeting has not been configured": "尚未配置分支目标",
                        "Tag targeting has not been configured": "尚未配置标签目标", // 标签

                        "Default": "默认",
                        "All branches": "所有分支",
                        "All tags": "所有标签", // 标签

                        "Applies to": "适用于",
                        "target:": "个目标：",
                        "targets:": "个目标：",
                        "Targets have changed and branch match list will update on save.": "目标已更改，分支匹配列表将在保存时更新。",
                            "Targets have changed and": "目标已更改，",
                            "branch": "分支",
                            "branches": "分支",
                            "match list will update on save.": "匹配列表将在保存时更新。",
                        "targets including": "个目标，包括",
                        "Targets have changed and repository match list will update on save.": "目标已更改，仓库匹配列表将在保存时更新。", // 组织设置

                        // 包含规则 对话框
                            "Branches that match the matching pattern will be targeted by this ruleset.": "与匹配规则相匹配的分支将成为该规则集的目标。",
                            "Tags that match the matching pattern will be targeted by this ruleset.": "与匹配规则相匹配的标签将成为该规则集的目标。", // 标签
                            "naming pattern": "命名规则",
                                "Pattern cannot be empty": "规则不能为空",
                            "Example patterns: \"": "示例：\"",
                            "Learn more about fnmatch": "了解更多关于 fnmatch 的信息",
                            "Add Inclusion pattern": "添加包含规则",

                        // 排除规则 对话框
                            "Branches that do not match the matching pattern will be targeted by this ruleset.": "与匹配规则不匹配的分支将成为该规则集的目标。",
                            "Tags that do not match the matching pattern will be targeted by this ruleset.": "与匹配规则不匹配的标签将成为该规则集的目标。", // 标签
                            "Add Exclusion pattern": "添加排除规则",

            // 规则
            "Branch rules": "分支规则",
            "rules": "规则",
                "Which rules should be applied to the targets that you have selected?": "哪些规则应适用于您选择的目标？",
                "Which rules should be applied?": "应适用哪些规则？",

                "protections": "保护",
                    "Restrict creations": "限制创建",
                        "Only allow users with bypass permission to create matching refs.": "只允许具有绕过权限的用户创建匹配的引用。",
                    "Restrict updates": "限制更新",
                        "Only allow users with bypass permission to update matching refs.": "只允许具有绕过权限的用户更新匹配的引用。",
                            "Allow fork syncing": "允许复刻仓库同步",
                                 "Branch can pull changes from its upstream repository": "分支可从上游仓库中拉取更改",
                    "Restrict deletions": "限制删除",
                        "Only allow users with bypass permissions to delete matching refs.": "只允许具有绕过权限的用户删除匹配的引用。",
                    "Require linear history": "需要线性历史",
                        "Prevent merge commits from being pushed to matching refs.": "防止合并后的提交被推送到匹配的引用。",
                    "Require merge queue": "要求合并队列", // 组织仓库
                        "Merges must be performed via a merge queue.": "合并必须通过合并队列进行。",
                        "Merge method": "合并模式",
                            "Method to use when merging changes from queued pull requests.": "合并来自列队拉取请求的更改时使用的模式。",

                                "Merge commit": "合并提交",
                                "Squash and merge": "压缩合并",
                                "Rebase and merge": "变基合并",
                        "Build concurrency": "构建并发",
                            "Limit the number of queued pull requests requesting checks and workflow runs at the same time.": "限制同时请求检查和工作流运行的队列拉取请求数量。",
                        "Minimum group size": "最小分组数",
                            "The minimum number of PRs that will be merged together in a group.": "将合并为一组的拉取请求的最小数量。",
                        "Maximum group size": "最大分组数",
                            "The maximum number of PRs that will be merged together in a group.": "将合并为一组的拉取请求的最大数量。",
                        "Wait time to meet minimum group size (minutes)": "达到最小分组数的等待时间（分钟）",
                            "The time merge queue should wait after the first PR is added to the queue for the minimum group size to be met. After this time has elapsed, the minimum group size will be ignored and a smaller group will be merged.": "第一个拉取请求添加到队列后，合并队列为达到最小分组规模所需的等待时间。超过这一时间后，将忽略最小分组大小，合并一个较小的分组",
                        "Require all queue entries to pass required checks": "要求所有队列条目通过必要的检查",
                            "When this setting is disabled, only the commit at the head of the merge group, i.e. the commit containing changes from all of the PRs in the group, must pass its required checks to merge.": "禁用此设置后，只有位于合并组头部的提交（即包含组内所有拉取请求变更的提交）必须通过合并所需的检查。",
                        "Status check timeout (minutes)": "状态检查超时（分钟）",
                            "Maximum time for a required status check to report a conclusion. After this much time has elapsed, checks that have not reported a conclusion will be assumed to have failed": "报告结论所需的状态检查的最长时间。超过此时间后，未报告结论的检查将被视为失败",
                    "Require deployments to succeed": "要求部署成功",
                        "Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.": "选择必须成功部署到哪些环境，之后才能将引用推送到与此规则匹配的引用中。",
                        "Hide additional settings": "隐藏附加设置",
                        "Show additional settings": "显示附加设置",
                            "Search for deployment environments": "搜索部署环境",
                            "No deployment environments have been added": "未添加部署环境",
                            "Learn more about deployment environments": "了解更多关于部署环境的信息",
                    "Require signed commits": "要求带签名的提交",
                        "Commits pushed to matching refs must have verified signatures.": "推送到匹配引用的提交必须带有经过验证的签名。",
                    "Require a pull request before merging": "要求在合并前提交拉取请求",
                        "Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.": "要求所有的提交都必须在非目标分支上进行，并在合并前通过拉取请求提交。",
                            "Required approvals": "要求批准审查",
                                "The number of approving reviews that are required before a pull request can be merged.": "拉取请求合并前所需的批准审查次数。",
                            "Dismiss stale pull request approvals when new commits are pushed": "当新的提交被推送时，撤销陈旧的拉取请求批准审查",
                                "New, reviewable commits pushed will dismiss previous pull request review approvals.": "推送新的可审查提交将撤销之前的拉取请求的批准审查。",
                            "Require review from Code Owners": "要求代码所有者进行审查",
                                "Require an approving review in pull requests that modify files that have a designated code owner.": "要求对具有指定代码所有者的文件修改的拉取请求中进行批准审查。",
                            "Require approval of the most recent reviewable push": "要求批准最新的可审查推送",
                                "Whether the most recent reviewable push must be approved by someone other than the person who pushed it.": "最新的可审核推送是否必须得到推送者以外的其他人批准。",
                            "Require conversation resolution before merging": "要求在合并前解决对话",
                                "All conversations on code must be resolved before a pull request can be merged.": "在合并拉取请求之前，必须解决有关代码的所有对话。",
                            "Request pull request review from Copilot": "请求 Copilot 进行拉取请求审查",
                                "Automatically request review from Copilot for new pull requests, if the author has access to Copilot code review.": "如果作者有权访问 Copilot 代码审查，则自动请求 Copilot 对新拉取请求进行审查。",

                            "Allowed merge methods": "允许合并方法",
                                "Merge, Squash": "合并，压缩",
                                "Merge, Squash, Rebase": "合并，压缩，变基",
                                "Merge, Rebase, Squash": "合并，变基，压缩",
                                "Merge, Rebase, Squash": "合并，变基，压缩",
                                "Merge, Rebase": "合并，变基",
                                "Squash, Rebase": "压缩，变基",
                                "Squash, Rebase, Merge": "压缩，变基，合并",
                                "Squash, Merge": "压缩，合并",
                                "Squash, Merge, Rebase": "压缩，合并，变基",
                                "Rebase, Merge": "变基，合并",
                                "Rebase, Squash": "变基，压缩",
                                "Rebase, Squash, Merge": "变基，压缩，合并",
                                "Rebase, Merge, Squash": "变基，合并，压缩",
                                "Merge": "合并",
                                    "Add all commits from the head branch to the base branch with a merge commit.": "将所有来自头部分支的提交通过一次合并提交添加到基础分支。",
                                "Squash": "压缩",
                                    "Combine all commits from the head branch into a single commit in the base branch.": "将头部分支上的所有提交合并为一个提交，然后将其集成到基础分支。",
                                "Rebase": "变基",
                                    "Add all commits from the head branch onto the base branch individually.": "将头部分支中的所有提交逐个添加到基础分支上。",
                                "When merging pull requests, you can allow any combination of merge commits, squashing, or rebasing. At least one option must be enabled.": "在合并拉取请求时，您可以允许合并提交、压缩或变基这三种方式中的任意组合。至少启用其中一种选项。",
                    "Require status checks to pass": "要求通过状态检查",
                        "Choose which status checks must pass before the ref is updated. When enabled, commits must first be pushed to another ref where the checks pass.": "更新引用之前必须选择通过哪些状态检查。启用后，提交必须首先推送到检查通过的另一个引用。",
                            "Require branches to be up to date before merging": "要求分支在合并前必须是最新的",
                                "Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled.": "针对匹配分支的拉取请求，使用最新代码进行测试。至少启用一项状态检查，否则此设置不会生效。",
                                "Do not require status checks on creation": "不要求在创建时进行状态检查",
                                    "Allow repositories and branches to be created if a check would otherwise prohibit it.": "允许创建仓库和分支，否则检查将禁止创建。",
                                // "Enter the name of a status check": "输入状态检查的名称",
                                    // [/Add '(.*)'/, "添加 $1"],
                                "No required checks": "无需进行必要的检查",
                                    "Add checks": "添加检查",
                                        "Add Checks": "添加检查",
                                            "Search for checks": "搜索检查",
                                            "No results": "无结果",
                                "No checks have been added": "未添加任何检查",
                                "Learn more about status checks": "了解更多关于状态检查的信息",
                    "Block force pushes": "阻止强制推送",
                        "Prevent users with push access from force pushing to refs.": "防止具有推送权限的用户强制推送到引用。",
                    "Require code scanning results": "需要代码扫描结果",
                        "Choose which tools must provide code scanning results before the reference is updated. When configured, code scanning must be enabled and have results for both the commit and the reference being updated.": "选择哪些工具必须在更新引用之前提供代码扫描结果。配置后，代码扫描必须启用，并为提交和正在更新的引用提供结果。",
                        "Required tools and alert thresholds": "所需工具和警报阈值",
                            "Add tool": "添加工具",
                                "Tool name": "工具名称",
                                "Enter the name of a code scanning tool": "输入代码扫描工具名称",
                        "Security alerts": "安全警报",
                            "None": "无",
                            "Critical": "关键",
                            "High or higher": "高风险及以上",
                            "Medium or higher": "中风险及以上",
                        "Alerts": "警报",
                            "Errors": "仅错误",
                            "Errors and Warnings": "错误和警告",
                        "Delete Tool": "删除工具",
                        "Tools that must provide code scanning results for this rule to pass.": "必须提供代码扫描结果才能通过此规则的工具。",
                        "Learn more about enabling code scanning.": "了解更多关于启用代码扫描的信息。",

                    "Require code quality results": "要求代码质量结果",
                        "Choose which severity levels of code quality results should block pull request merges. When configured, a code quality analysis must be done on the pull request before the changes can be merged.": "选择哪些代码质量结果严重级别应阻止拉取请求合并。配置后，必须在拉取请求上进行代码质量分析，才能合并更改。",
                        "Severity": "严重级别",
                            "Error": "错误",
                            "Warning": "警告",
                            "Warnings and higher": "警告及以上",
                            "Notes and higher": "备注及以上",
                        "The lowest severity level at which code quality reviews need to be resolved before commits can be merged.": "在合并提交之前，需要解决的最低严重级别代码质量审查。",

                    "Automatically request Copilot code review": "自动请求 Copilot 代码审查",
                        "Request Copilot code review for new pull requests automatically if the author has access to Copilot code review and their premium requests quota has not reached the limit.": "如果作者有权访问 Copilot 代码审查并且其高级请求配额尚未达到限制，则自动请求 Copilot 对新拉取请求进行代码审查。",
                        "Review new pushes": "审查新的推送",
                        "Copilot automatically reviews each new push to the pull request.": "Copilot 自动审查每个新的推送请求。",
                        "Review draft pull requests": "审查草稿拉取请求",
                        "Copilot automatically reviews draft pull requests before they are marked as ready for review.": "Copilot 自动审查草稿拉取请求，在标记为准备好审查之前。",

                    "Manage static analysis tools in Copilot code review": "在 Copilot 代码审查中管理静态分析工具",
                        "Copilot code review will include findings from the selected static analysis tools in its review comments.": "Copilot 代码审查将在其审查意见中包括所选静态分析工具的结果。",

                    // 组织设置
                    "Require workflows to pass before merging": "要求合并前，工作流通过状态检查",
                        "Require all changes made to a targeted branch to pass the specified workflows before they can be merged.": "要求目标分支上的所有更改在合并前通过指定的工作流",
                        "Workflow configurations": "工作流程配置",
                            "No workflow configurations found": "尚无工作流配置",

                        "Add workflow": "添加工作流",
                            "Add required workflow": "添加所需的工作流",
                                // 仓库
                                    "Select a repository": "选择仓库",
                                "Select branch or tag": "选择分支或标签",
                                    "Branch or tag": "分支或标签",
                                    "Pin to commit": "固定到提交",
                                        "Always reference the current commit": "始终引用当前提交",
                                "Enter a SHA": "输入 SHA",
                                    "Enter a valid SHA": "输入有效的 SHA",
                                    "Enter the SHA for the commit you want to reference": "输入要引用的提交的 SHA",
                                    "Invalid SHA": "无效的 SHA",
                                "Pick a workflow file": "选择工作流文件",
                                    "Please select a workflow path": "请选择工作流路径",

            "Restrictions": "限制", // 组织设置
                "Restrict commit metadata": "限制提交元数据",
                    "Restrict commit author email addresses, committer email addresses, commit message content, and other metadata": "限制提交作者电子邮箱地址、提交者电子邮箱地址、提交消息内容和其他元数据",

                    "Metadata restrictions": "元数据限制",
                        "No metadata restrictions have been added": "尚无元素限制",
                        "Learn more about": "了解更多关于",
                        "metadata": "元素",
                        "restrictions": "限制",

                        "Add restriction": "添加限制",
                            // 添加元数据限制 对话框
                                "Add a metadata restriction": "添加元数据限制",
                                    "Applies To": "适用于",
                                        "Commit message": "提交信息",
                                        "Author email": "作者电子邮箱地址",
                                        "Committer email": "提交者电子邮箱地址",
                                        "Branch name": "分支名称",
                                    "Requirement": "要求",
                                        "Must": "必须",
                                        "start with a matching pattern": "以匹配规则开头",
                                        "end with a matching pattern": "以匹配规则结束",
                                        "contain a matching pattern": "包含匹配规则",
                                        "match a given regex pattern": "匹配给定的正则表达式规则",
                                        "Must not": "不得",
                                    "Matching pattern": "匹配规则",
                                    "Description": "描述",
                                        // [/Commit message must start with a matching pattern/, "提交信息必须以匹配规则开头"],
                                        // [/Commit message must end with a matching pattern/, "提交信息必须以匹配规则结束"],
                                        // [/Commit message must contain with a matching pattern/, "提交信息必须包含匹配规则"],
                                        // [/Commit message must match a given regex pattern/, "提交信息必须匹配给定的正则表达式规则"],
                                        // [/Commit message must not start with a matching pattern/, "提交信息不得以匹配规则开头"],
                                        // [/Commit message must not end with a matching pattern/, "提交信息不得以匹配规则结束"],
                                        // [/Commit message must not contain a matching pattern/, "提交信息不得包含匹配规则"],
                                        // [/Commit message must not match a given regex pattern/, "提交信息不得匹配给定的正则表达式规则"],

                                        // [/Author email must start with a matching pattern/, "作者电子邮箱地址必须以匹配规则开头"],
                                        // [/Author email must end with a matching pattern/, "作者电子邮箱地址必须以匹配规则结束"],
                                        // [/Author email must contain a matching pattern/, "作者电子邮箱地址必须包含匹配规则"],
                                        // [/Author email must match a given regex pattern/, "作者电子邮箱地址必须匹配给定的正则表达式规则"],
                                        // [/Author email must not start with a matching pattern/, "作者电子邮箱地址不得以匹配规则开头"],
                                        // [/Author email must not end with a matching pattern/, "作者电子邮箱地址不得以匹配规则结束"],
                                        // [/Author email must not contain a matching pattern/, "作者电子邮箱地址不得包含匹配规则"],
                                        // [/Author email must not match a given regex pattern/, "作者电子邮箱地址不得匹配给定的正则表达式规则"],

                                        // [/Committer email must start with a matching pattern/, "提交者电子邮箱地址必须以匹配规则开头"],
                                        // [/Committer email must end with a matching pattern/, "提交者电子邮箱地址必须以匹配规则结束"],
                                        // [/Committer email must contain a matching pattern/, "提交者电子邮箱地址必须包含匹配规则"],
                                        // [/Committer email must match a given regex pattern/, "提交者电子邮箱地址必须匹配给定的正则表达式规则"],
                                        // [/Committer email must not start with a matching pattern/, "提交者电子邮箱地址不得以匹配规则开头"],
                                        // [/Committer email must not end with a matching pattern/, "提交者电子邮箱地址不得以匹配规则结束"],
                                        // [/Committer email must not contain a matching pattern/, "提交者电子邮箱地址不得包含匹配规则"],
                                        // [/Committer email must not match a given regex pattern/, "提交者电子邮箱地址不得匹配给定的正则表达式规则"],

                                        // [/Branch name must start with a matching pattern/, "分支名称必须以匹配规则开头"],
                                        // [/Branch name must end with a matching pattern/, "分支名称必须以匹配规则结束"],
                                        // [/Branch name must contain a matching pattern/, "分支名称必须包含匹配规则"],
                                        // [/Branch name must match a given regex pattern/, "分支名称必须匹配给定的正则表达式规则"],
                                        // [/Branch name must not start with a matching pattern/, "分支名称不得以匹配规则开头"],
                                        // [/Branch name must not end with a matching pattern/, "分支名称不得以匹配规则结束"],
                                        // [/Branch name must not contain a matching pattern/, "分支名称不得包含匹配规则"],
                                        // [/Branch name must not match a given regex pattern/, "分支名称不得匹配给定的正则表达式规则"],

                                    "How this rule will appear to your": "这个规则将如何在您的",
                                    "organization": "组织",
                                    "'s users throughout": "内的用户中显示",
                "Restrict branch names": "限制分支名",

            "Revert": "撤销",
            "Reverting...": "撤销…",
            "changes": "更改",
            "change": "更改",

            // 右下角提示
                "Unauthorized": "未经授权",
                "Ruleset created": "规则集已创建",
                "Changes reverted": "更改已恢复",
                "No changes have been made": "未作任何更改",
                "Invalid rules: 'Required status checks'": "无效规则：“必需的状态检查”",
                "This": "此",
                    "does not target any resources and will not be applied.": "未针对任何资源，将不会生效。",
                "Ruleset updated": "规则已更新",


    },
    "regexp": [ // 正则翻译
        [/Applies to (\d+) target/, "适用于 $1 个目标"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) branch rules? • targeting (\d+) branch(es)?/, "$1 条分支规则 • 针对 $1 个分支"],
        [/(\d+) branch rules?/, "$1 条分支规则"],
        [/(\d+) rules?/, "$1 条规则"],
        [/(\d+) branch(?:es|)?/, "$1 个分支"],
        [/(\d+) tags?/, " $1 个标签"],
        [/Add '(.*)'/, "添加 $1"],
        [/Commit message must start with a matching pattern/, "提交信息必须以匹配规则开头"],
        [/Commit message must end with a matching pattern/, "提交信息必须以匹配规则结束"],
        [/Commit message must contain with a matching pattern/, "提交信息必须包含匹配规则"],
        [/Commit message must match a given regex pattern/, "提交信息必须匹配给定的正则表达式规则"],
        [/Commit message must not start with a matching pattern/, "提交信息不得以匹配规则开头"],
        [/Commit message must not end with a matching pattern/, "提交信息不得以匹配规则结束"],
        [/Commit message must not contain a matching pattern/, "提交信息不得包含匹配规则"],
        [/Commit message must not match a given regex pattern/, "提交信息不得匹配给定的正则表达式规则"],
        [/Author email must start with a matching pattern/, "作者电子邮箱地址必须以匹配规则开头"],
        [/Author email must end with a matching pattern/, "作者电子邮箱地址必须以匹配规则结束"],
        [/Author email must contain a matching pattern/, "作者电子邮箱地址必须包含匹配规则"],
        [/Author email must match a given regex pattern/, "作者电子邮箱地址必须匹配给定的正则表达式规则"],
        [/Author email must not start with a matching pattern/, "作者电子邮箱地址不得以匹配规则开头"],
        [/Author email must not end with a matching pattern/, "作者电子邮箱地址不得以匹配规则结束"],
        [/Author email must not contain a matching pattern/, "作者电子邮箱地址不得包含匹配规则"],
        [/Author email must not match a given regex pattern/, "作者电子邮箱地址不得匹配给定的正则表达式规则"],
        [/Committer email must start with a matching pattern/, "提交者电子邮箱地址必须以匹配规则开头"],
        [/Committer email must end with a matching pattern/, "提交者电子邮箱地址必须以匹配规则结束"],
        [/Committer email must contain a matching pattern/, "提交者电子邮箱地址必须包含匹配规则"],
        [/Committer email must match a given regex pattern/, "提交者电子邮箱地址必须匹配给定的正则表达式规则"],
        [/Committer email must not start with a matching pattern/, "提交者电子邮箱地址不得以匹配规则开头"],
        [/Committer email must not end with a matching pattern/, "提交者电子邮箱地址不得以匹配规则结束"],
        [/Committer email must not contain a matching pattern/, "提交者电子邮箱地址不得包含匹配规则"],
        [/Committer email must not match a given regex pattern/, "提交者电子邮箱地址不得匹配给定的正则表达式规则"],
        [/Branch name must start with a matching pattern/, "分支名称必须以匹配规则开头"],
        [/Branch name must end with a matching pattern/, "分支名称必须以匹配规则结束"],
        [/Branch name must contain a matching pattern/, "分支名称必须包含匹配规则"],
        [/Branch name must match a given regex pattern/, "分支名称必须匹配给定的正则表达式规则"],
        [/Branch name must not start with a matching pattern/, "分支名称不得以匹配规则开头"],
        [/Branch name must not end with a matching pattern/, "分支名称不得以匹配规则结束"],
        [/Branch name must not contain a matching pattern/, "分支名称不得包含匹配规则"],
        [/Branch name must not match a given regex pattern/, "分支名称不得匹配给定的正则表达式规则"],
        ...I18N["zh-CN"]["orgs-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Settings · Rulesets?/, "设置 · 规则集"],
        ],
    },
};
I18N["zh-CN"]["orgs/settings/rules"] = I18N["zh-CN"]["repository/settings/rules"];
I18N["zh-CN"]["repository/rules"] = I18N["zh-CN"]["repository/settings/rules"];

I18N["zh-CN"]["repository/settings/actions"] = { // 仓库设置 - 操作 /<user-name>/<repo-name>/settings/actions
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 操作页面 /<user-name>/<repo-name>/settings/actions
            "Actions permissions": "操作权限",
                "This setting has been disabled by organization administrators.": "此设置已被组织管理员禁用。", // 组织仓库
                "Allow all actions and reusable workflows": "允许所有操作和可复用的工作流程",
                    "Any action or reusable workflow can be used, regardless of who authored it or where it is defined.": "可以使用任何操作或可复用的工作流程，而不管它是谁创作的或在哪里定义的。",
            "Disable actions": "禁用操作",
                "The Actions tab is hidden and no workflows can run.": "“操作” 选项卡将被隐藏，无法运行任何工作流程。",
            // [/Allow ([^ ]+) actions and reusable workflows/, "允许 $1 的操作和可复用的工作流程"],
                // [/Any action or reusable workflow defined in a repository within ([^ ]+) can be used./, "可以使用在 $1 的仓库中定义的任何操作或可复用的工作流程。"], // 操作页面
            // [/Allow ([^ ]+), and select non-([^ ]+), actions and reusable workflows/, "允许 $1，并选择非 $2、操作和可复用的工作流程"],
                // [/Any action or reusable workflow that matches the specified criteria, plus those defined in a repository within ([^ ]+), can be used./, "可以使用符合指定条件的操作或工作流程，以及在 $1 的仓库中定义的操作或可复用的工作流程。"], // 操作页面
                "Learn more about allowing specific actions and reusable workflows to run.": "了解更多关于允许运行特定操作和可复用的工作流程的信息。",
                "Allow actions created by GitHub": "允许由 GitHub 创建的操作",
                "Allow actions by Marketplace": "允许来自市场的操作，",
                "verified creators": "由经验证的创建者创建",
                "Allow specified actions and reusable workflows": "允许指定的操作和可复用的工作流程",
                "Enter a comma-separated list of actions and reusable workflows": "输入以逗号分隔的操作和可复用的工作流程列表",
                "Wildcards, tags, and SHAs are allowed.": "允许使用通配符、标签和 SHA。",
                "Action examples:": "操作示例：",
                "Reusable workflow examples:": "可复用的工作流程示例：",
                "Entire organization or repository examples:": "整个组织或仓库的示例：",
                // "Save": "保存",
                // 顶部提醒
                    "Actions policy updated.": "操作政策已更新",
            "Require actions to be pinned to a full-length commit SHA": "要求将操作固定到完整的提交 SHA",

            "Artifact and log retention": "工件和日志保留",
                "Choose the repository settings for artifacts and logs.": "选择工件和日志的仓库设置。",
                "There is a maximum limit of": "最大限制为",
                "days.": "天。",
                "Your organization has set a maximum limit of": "您的组织已将上限设置为", //组织仓库
                "Learn more about the artifact and log retention policy.": "了解更多关于工件和日志保留政策的信息。",

                // 输入框提示
                "Duration must be 1 or more.": "不能小于 1",
                "Duration must be 90 or less": "不能大于 90",
                "There is a maximum limit of": "最多",

                "days": "天",

            "Fork pull request workflows": "复刻拉取请求工作流程",
                "Run workflows from fork pull requests": "从复刻拉取请求运行工作流程",
                    "This tells Actions to run workflows from pull requests originating from repository forks. Note that doing so will give maintainers of those forks the ability to use tokens with read permissions on the source repository.": "这告诉 Actions 运行工作流程，来自仓库复刻的拉取请求。请注意，这样做将使这些复刻的维护者有能力在源码库上使用具有读取权限的令牌。",
                "Send write tokens to workflows from fork pull requests.": "从复刻拉取请求，发送可写令牌到工作流程",
                    "This tells Actions to send tokens with": "这告诉 Actions 发送令牌",
                    "write": "写入",
                    "permissions to workflows from pull requests originating from repository forks. Note that doing so will give maintainers of those forks": "权限到工作流程，来自仓库复刻的拉取请求。请注意，这样做将授予这些复刻的维护者",
                    "permissions against the source repository.": "权限，针对源仓库。",
                "Send secrets to workflows from fork pull requests.": "从复刻拉取请求，发送机密到工作流程",
                    "This tells Actions to send repository secrets to workflows from pull requests originating from repository forks.": "这告诉 Actions 发送仓库机密到工作流程，来自仓库复刻的拉取请求。",

            "Approval for running fork pull request workflows from contributors": "允许贡献者运行复刻拉取请求工作流",
                "Choose which subset of users will require approval before running workflows on their pull requests. Both the pull request author and the actor of the pull request event triggering the workflow will be checked to determine if approval is required. If approval is required, a user with write access to the repository must": "选择在拉取请求上运行工作流之前需要批准的用户子集。将检查拉取请求作者和触发工作流的拉取请求事件的行为者，以确定是否需要批准。如果需要批准，则必须由具有写权限的用户",
                "approve the pull request workflow to be run.": "批准才能运行拉取请求工作流。",
            "Fork pull request workflows from outside collaborators": "从外部协作者，复刻拉取请求工作流程",
                "Choose which subset of outside collaborators will require approval to run workflows on their pull requests.": "选择哪些外部协作者的子集需要批准才能对他们的拉取请求运行工作流程。",
                "Learn more about approving workflow runs from public forks.": "了解更多关于批准来自公共复刻的工作流运行的信息。",
            "Require approval for first-time contributors who are new to GitHub": "要求对首次加入 GitHub 的贡献者进行批准审查",
                "Only first-time contributors who recently created a GitHub account will require approval to run workflows.": "只有最近创建 GitHub 账户的首次贡献者才需要获得批准才能运行工作流程。",
                "Only users who are both new on GitHub and who have never had a commit or pull request merged into this repository will require approval to run workflows.": "只有新加入 GitHub 和从未有提交或拉取请求合并到该仓库的用户才需要批准运行工作流。",
            "Require approval for first-time contributors": "要求对首次贡献者进行批准审查",
                "Only first-time contributors will require approval to run workflows.": "只有首次贡献者才需要获得批准才能运行工作流程。",
                "Only users who have never had a commit or pull request merged into this repository will require approval to run workflows.": "只有从未有提交或拉动请求合并到该仓库的用户才需要批准运行工作流。",
            "Require approval for all outside collaborators": "要求对所有外部协作者进行批准审查",
                "All outside collaborators will always require approval to run workflows on their pull requests.": "所有外部协作者将始终需要批准才能在他们的拉取请求上运行工作流程。",
            "Require approval for all external contributors": "要求对所有外部贡献者进行批准审查",
                "All users that are not a member or owner of this repository will require approval to run workflows.": "所有不是该仓库成员或所有者的用户，均需获得批准才能运行工作流。",
                // [/All users that are not a member or owner of this repository and not a member of the ([^ ]+) organization will require approval to run workflows./, "所有不是该仓库成员或所有者，且未加入 $1 组织的用户，均需获得批准才能运行工作流。"], // 组织

            "Workflow permissions": "工作流程权限",
                "Choose the default permissions granted to the GITHUB_TOKEN when running workflows in this repository. You can specify more granular permissions in the workflow using YAML.": "在仓库中运行工作流程时，选择授予 GITHUB_TOKEN 的默认权限。您可以使用 YAML 在工作流程中指定更细化的权限。",
                "Learn more about managing permissions.": "了解更多关于管理权限的信息。",
                "Read and write permissions": "读取和写入权限",
                    "Workflows have read and write permissions in the repository for all scopes.": "工作流程在仓库中对所有作用域具有读和写的权限。",
                "Read repository contents and packages permissions": "读取仓库的内容和软件包的权限",
                    "Workflows have read permissions in the repository for the contents and packages scopes only.": "工作流程在仓库中仅对内容和软件包作用域具有只读的权限。",
                    "Choose whether GitHub Actions can create pull requests or submit approving pull request reviews.": "选择 GitHub Actions 是否可以创建拉取请求或提交批准拉取请求审查。",
                        "Allow GitHub Actions to create and approve pull requests": "允许 GitHub Actions 创建和批准拉取请求",

                // 顶部提醒
                    "Default workflow permissions settings saved.": "已保存默认工作流程权限设置。",

        // 运行器页面 /<user-name>/<repo-name>/settings/actions/runners
            "New self-hosted runner": "新建自托管运行器",
            "Host your own runners and customize the environment used to run jobs in your GitHub Actions workflows.": "托管您自己的运行器，并定制用于在您的 GitHub Actions 工作流程中运行作业的环境。",
            "Learn more about self-hosted runners": "了解更多关于自托管运行器的信息",
            "There are no runners configured": "暂无设置运行器",
            "Learn more about using runners": "了解更多关于使用运行器的信息",
            "to run actions on your own servers.": "在您自己的服务器上运行操作的信息。",

        // 创建运行器页面 /<user-name>/<repo-name>/settings/actions/runners/new
            // [/\/ Add new self-hosted runner ·/, "/ 创建自托管运行器 ·"],
            "Adding a self-hosted runner requires that you download, configure, and execute the GitHub Actions Runner. By downloading and configuring the GitHub Actions Runner, you agree to the": "添加一个自托管运行器需要您下载、配置并执行 GitHub Actions 运行器。下载并配置 GitHub Actions 运行器 后，您同意",
                "GitHub Terms of Service": "GitHub 服务条款",
                "GitHub Corporate Terms of Service": "GitHub 企业服务条款",
                ", as applicable.": "，如适用。",
            "Runner image": "运行器镜像",
            "Architecture": "架构",
            "Download": "下载",
            "We recommend configuring the runner under \"\\actions-runner\". This will help avoid issues related to service identity folder permissions and long path restrictions on Windows.": "我们建议在 “\\actions-runner” 下配置运行器。这将有助于避免与 Windows 上的服务标识文件夹权限和长路径限制相关的议题。",
            "Configure": "设置",
            "Using your self-hosted runner": "使用您的自托管运行器",
            "For additional details about configuring, running, or shutting down the runner, please check out our": "关于配置、运行或关闭运行器的其他细节，请查看我们的",
            "product docs": "产品文档",
            "Add new self-hosted runner": "添加新的自托管运行器",
            "Using self-hosted runners in public repositories is not recommended.": "在公共仓库中使用自托管运行器不推荐。",
            "Forks of your public repository can potentially run dangerous code on your self-hosted runner by creating a pull request.": "公共仓库的复刻可以潜在地在您的自托管运行器上运行危险代码，通过创建拉取请求。",
            "Learn more about security hardening for self-hosted runners": "了解更多关于自托管运行器的安全强化",
            "Adding a self-hosted runner requires that you download, configure, and execute the GitHub Actions Runner. If you do not already have an existing volume licensing agreement for your GitHub purchases, by downloading and configuring the GitHub Actions Runner, you agree to the": "添加一个自托管运行器需要您下载、配置并执行 GitHub Actions 运行器。如果您还没有现有的 GitHub 购买量许可证协议，通过下载并配置 GitHub 操作运行器，您同意",
            "GitHub Customer Agreement": "GitHub 客户协议",

    },
    "regexp": [ // 正则翻译
        [/\/ Add new self-hosted runner ·/, "/ 创建自托管运行器 ·"],
        [/Allow ([^ ]+) actions and reusable workflows/, "允许 $1 的操作和可复用的工作流程"],
        [/Any action or reusable workflow defined in a repository within ([^ ]+) can be used./, "可以使用在 $1 的仓库中定义的任何操作或可复用的工作流程。"], // 操作页面
        [/Allow ([^ ]+), and select non-([^ ]+), actions and reusable workflows/, "允许 $1，并选择非 $2、操作和可复用的工作流程"],
        [/Any action or reusable workflow that matches the specified criteria, plus those defined in a repository within ([^ ]+), can be used./, "可以使用符合指定条件的操作或工作流程，以及在 $1 的仓库中定义的操作或可复用的工作流程。"], // 操作页面
        [/All users that are not a member or owner of this repository and not a member of the ([^ ]+) organization will require approval to run workflows./, "所有不是该仓库成员或所有者，且未加入 $1 组织的用户，均需获得批准才能运行工作流。"], // 组织
        [/Add new self-hosted runner · (.+)/, "添加自托管运行器 · $1"],
        ...I18N["zh-CN"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Actions settings/, "操作设置"],
            [/Runners/, "运行器"],
            [/Add new self-hosted runner/, "添加自托管运行器"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/models/access-policy"] = { // 仓库设置 - 模型 /<user-name>/<repo-name>/settings/models/access-policy
    "static": {
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"],

        //"Models": "模型",

        "Models in this repository": "此仓库模型",
            "If disabled, the Models tab will be hidden, and the prompt editor and comparison tooling evaluations will be unavailable.": "如果禁用，模型选项卡将被隐藏，提示编辑器和对比工具评估也将不可用。",
            "Learn more about Models.": "了解更多。",
    },
    "regexp": [],
    "title": {
        "regexp": [
            [/settings · GitHub Models access policy/, "设置 · GitHub 模型访问政策"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/hooks"] = { // 仓库设置 - Web 钩子 /<user-name>/<repo-name>/settings/hooks
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"],

        // Web 钩子 页面 /<user-name>/<repo-name>/settings/hooks====================================
            "Add webhook": "添加 Web 钩子",
            "Webhooks allow external services to be notified when certain events happen. When the specified events happen, we'll send a POST request to each of the URLs you provide. Learn more in our": "Web 钩子允许在发生某些事件时通知外部服务。当指定的事件发生时，我们将向您提供的每个 URL 发送 POST 请求。了解更多信息，在我们的",
            "Webhooks Guide": "Web 钩子指南",

            "We will also send events from this repository to your": "我们还将把这个仓库的事件发送到您的", // 组织仓库
            "organization webhooks": "组织 Web 钩子", // 组织仓库

            "This hook has never been triggered.": "此钩子从未被触发过。",
            "Last delivery was successful.": "上次触发成功。",

            // 删除对话框
                "Delete webhook?": "删除 Web 钩子？",
                "This action cannot be undone. Future events will no longer be delivered to this webhook": "此操作无法撤消。未来的事件将不再传递到此 Web 钩子",
                "Yes, delete webhook": "是的，删除 Web 钩子",

        // 添加钩子 页面 /<user-name>/<repo-name>/settings/hooks/new ====================================
            "Webhooks /": "Web 钩子 /",
            "Add webhook": "添加 Web 钩子",
            "We'll send a": "我们将",
            "request to the URL below with details of any subscribed events. You can also specify which data format you'd like to receive (JSON,": "请求到以下 URL，其中包含任何订阅事件的详细信息。您还可以指定要接收的数据格式（JSON、",
            "etc": "等",
            "). More information can be found in": "）。更多信息可以在",
            "our developer documentation": "开发人员文档",

            "Payload URL": "有效负载 URL",
            "Content type": "内容类型",
            "Secret": "机密",
                "Leave blank to remove secret": "留空以删除机密",
            "There is currently a secret configured for this webhook. If you've lost or forgotten this secret, you can change it, but be aware that any integrations using this secret will need to be updated.": "目前 Web 钩子已配置了一个机密。如果您丢失或忘记了这个机密，可以更改它，但请注意，任何使用此机密的集成将需要更新",
            "Change secret": "修改机密",

            "SSL verification": "SSL 验证",
            "By default, we verify SSL certificates when delivering payloads.": "默认情况下，我们在交付有效负载时验证 SSL 证书。",
            "Enable SSL verification": "启用 SSL 验证",
            "Disable": "禁用",
            "(not recommended)": "（不推荐）",
                "Are you sure?": "您确定吗？",
                "Warning": "警告",
                ": Disabling SSL verification has serious implications.": "：禁用 SSL 验证具有严重的影响。",
                "SSL verification helps ensure that hook payloads are delivered to your URL endpoint securely, keeping your data away from prying eyes. Disabling this option is": "SSL 验证有助于确保钩子有效负载安全地传送到您的 URL 端点，使您的数据远离窥探。禁用此选项是",
                "not recommended": "不推荐的",
                "Disable, I understand my webhooks may not be secure": "禁用，我明白我的 web 钩子可能不安全",

            "Which events would you like to trigger this webhook?": "您希望哪些事件触发此 Web 钩子？",
                "Just the": "仅",
                "push": "推送",
                "event.": "事件。",
                "Send me": "发送给我",
                "everything": "所有",
                "Let me select individual events.": "让我选择单个事件。",
                    "Branch or tag creation": "分支或标签创建",
                        "Branch or tag created.": "分支或标签的创建。",
                    "Branch or tag deletion": "分支或标签删除",
                        "Branch or tag deleted.": "分支或标签的删除。",
                    "Branch protection configurations": "分支保护配置",
                        "All branch protections disabled or enabled for a repository.": "禁用或启用仓库的所有分支保护。",
                    "Branch protection rules": "分支保护规则",
                        "Branch protection rule created, deleted or edited.": "分支保护规则的创建、删除或编辑。",
                    "Bypass requests for push rulesets": "绕过推送规则集的请求",
                        "Push ruleset bypass request was created, cancelled, completed, received a response, or a response was dismissed.": "推送规则集旁路请求已创建、取消、完成、收到回复或回复被驳回。",
                    "Bypass requests for secret scanning push protections": "绕过机密扫描推送保护请求",
                        "Secret scanning push protection bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push protection is currently in beta and subject to change.": "机密扫描推送保护旁路请求的创建、取消、完成、收到回复或回复被驳回。注意：推送保护的委托旁路目前处于测试阶段，可能会有更改。",
                    "Check runs": "检查运行",
                        "Check run is created, requested, rerequested, or completed.": "检查运行的创建、请求、重新请求或完成。",
                    "Check suites": "检查套件",
                        "Check suite is requested, rerequested, or completed.": "检查套件的请求、重新请求或完成。",
                    "Code scanning alerts": "代码扫描警报",
                        "Code Scanning alert created, fixed in branch, or closed": "代码扫描警报的创建、在分支中的修复或关闭。",
                    "Collaborator add, remove, or changed": "协作者的添加、删除或更改",
                        "Collaborator added to, removed from, or has changed permissions for a repository.": "协作者添加到仓库、从仓库中删除或更改了仓库的权限。",
                    "Commit comments": "提交评论",
                        "Commit or diff commented on.": "提交或差异评论。",
                    "Custom property": "自定义属性",
                        "Custom property is created, updated, or deleted.": "自定义属性的创建、更新或删除。",
                    "Custom property values": "自定义属性值",
                        "Custom property values are changed for a repository": "仓库自定义属性值的更改。",
                    "Dependabot alerts": "Dependabot 警报",
                        "Dependabot alert auto_dismissed, auto_reopened, created, dismissed, reopened, fixed, or reintroduced.": "Dependabot 警报自动解除、自动重新打开、创建、解除、重新打开、修复或重新引入。",
                    "Deploy keys": "部署密钥",
                        "A deploy key is created or deleted from a repository.": "在仓库中部署密钥的创建或删除。",
                    "Deployment statuses": "部署状态",
                        "Deployment status updated from the API.": "通过 API 更新部署状态。",
                    "Deployments": "部署",
                        "Repository was deployed or a deployment was deleted.": "仓库的部署或删除部署。",
                    "Discussion comments": "讨论评论",
                        "Discussion comment created, edited, or deleted.": "讨论评论的创建、编辑或删除。",
                    // "Discussion": "讨论",
                        "Discussion created, edited, closed, reopened, pinned, unpinned, locked, unlocked, transferred, answered, unanswered, labeled, unlabeled, had its category changed, or was deleted.": "讨论的创建、编辑、关闭、重新打开、置顶、取消置顶、锁定、解锁、转移、答复、取消答复、标记、取消标记、更改其类别或删除。",
                    "Forks": "复刻",
                        "Repository forked.": "仓库复刻。",
                    "Issue comments": "议题评论",
                        "Issue comment created, edited, or deleted.": "议题评论的创建、编辑或删除。",
                    // "Issue": "议题",
                        "Issue opened, edited, deleted, transferred, pinned, unpinned, closed, reopened, assigned, unassigned, labeled, unlabeled, milestoned, demilestoned, locked, or unlocked.": "议题的打开、编辑、删除、转移、置顶、取消置顶、关闭、重新打开、分配、取消分配、标记、取消标记、设置里程碑、取消里程碑、锁定或解锁。",
                    "Labels": "标签",
                        "Label created, edited or deleted.": "标签的创建、编辑或删除。",
                    "Memberships": "团队成员", // 组织设置
                        "Team membership added or removed.": "团队成员的添加或删除。",
                    "Merge groups": "合并组",
                        "Merge Group requested checks, or was destroyed.": "合并组的请求检查或销毁。",
                    "Meta": "元数据",
                        "This particular hook is deleted.": "这个特定的钩子被删除。",
                    "Milestones": "里程碑",
                        "Milestone created, closed, opened, edited, or deleted.": "里程碑的创建、关闭、打开、编辑或删除。",
                    "Org blocks": "组织黑名单", // 组织设置
                        "A user has been blocked or unblocked.": "用户拉黑或解除拉黑。",
                    "Organizations": "组织", // 组织设置
                        "Organization deleted, renamed, member invited, member added, or member removed.": "组织的删除、重命名以及成员的邀请、添加或删除。",
                    // "Packages": "软件包",
                        "GitHub Packages published or updated in a repository.": "仓库中 GitHub 软件包的发布或更新 。",
                    "Page builds": "构建 GitHub Pages",
                        "Pages site built.": "GitHub Pages 站点的建立。",
                    "Project cards": "项目面板卡",
                        "Project card created, updated, or deleted.": "项目面板卡的创建、更新或删除。",
                    "Project columns": "项目栏目",
                        "Project column created, updated, moved or deleted.": "项目列目的创建、更新、移动或删除。",
                    "Project v2 items": "项目项 v2", // 组织设置
                        "Project item created, edited, deleted, archived, restored, converted, or reordered. Feedback is welcome in": "项目条目的创建、编辑、删除、归档、恢复、转换或重新排序。欢迎提供反馈意见在",
                        "this discussion": "这个讨论",
                    // "": "项目",
                        "Project created, updated, or deleted.": "项目的创建、更新或删除。",
                    "Projects v2": "项目 v2", // 组织设置
                        "Project created, updated, deleted, closed, or reopened. Feedback is welcome in": "项目的创建、更新、删除、关闭或重新打开。欢迎提供反馈意见在",
                    "Pull request review comments": "拉取请求审查意见",
                        "Pull request diff comment created, edited, or deleted.": "拉取请求差异评论的创建、编辑或删除。",
                    "Pull request review threads": "拉取请求的审查线程",
                        "A pull request review thread was resolved or unresolved.": "拉取请求的审查线程的解决或未解决。",
                    "Pull request reviews": "拉取请求审查",
                        "Pull request review submitted, edited, or dismissed.": "拉取请求审查的提交、编辑或驳回。",
                    // "": "拉取请求",
                        "Pull request assigned, auto merge disabled, auto merge enabled, closed, converted to draft, demilestoned, dequeued, edited, enqueued, labeled, locked, milestoned, opened, ready for review, reopened, review request removed, review requested, synchronized, unassigned, unlabeled, or unlocked.": "拉取请求的分配、禁用自动合并、启用自动合并、关闭、转换为草案、取消里程碑、取消队列、编辑、队列、标记、锁定、设置里程碑、打开、准备审查、重新打开、取消审查请求、请求审查、同步、取消分配、取消标记或解锁。",
                    "Pushes": "推送",
                        "Git push to a repository.": "Git 推送到仓库。",
                    "Registry packages": "注册软件包",
                        "Registry package published or updated in a repository.": "仓库中注册软件包的发布或更新。",
                    "Releases": "发行版",
                        "Release created, edited, published, unpublished, or deleted.": "发行版的创建、编辑、发布、取消发布或删除。",
                    // "": "仓库",
                        "Repository created, deleted, archived, unarchived, publicized, privatized, edited, renamed, or transferred.": "仓库的创建、删除、归档、取消归档、公开、私有化、编辑、重命名或转让。",
                    "Repository advisories": "仓库公告",
                        "Repository advisory published or reported.": "仓库公告发布或报告。",
                    "Repository imports": "仓库导入",
                        "Repository import succeeded, failed, or cancelled.": "仓库导入的成功、失败或取消。",
                    "Repository rulesets": "仓库规则集",
                        "Repository ruleset created, deleted or edited.": "仓库规则集的创建、删除或编辑。",
                    "Repository vulnerability alerts": "仓库漏洞警报",
                        "Dependabot alert (aka dependency vulnerability alert) created, resolved, or dismissed on a repository.": "Dependabot 警报（又名依赖漏洞警报）在仓库上的创建、解决或解除。",
                    "Secret scanning alert locations": "机密扫描警报位置",
                        "Secrets scanning alert location created.": "机密扫描警报位置的创建。",
                    "Secret scanning alerts": "机密扫描警报",
                        "Secrets scanning alert created, resolved, reopened, validated, or publicly leaked.": "机密扫描警报的创建、解决、重新打开、验证或公开泄露。",
                    "Security and analyses": "安全和分析",
                        "Code security features enabled or disabled for a repository.": "启用或禁用仓库的代码安全功能。",
                    "Secret scanning scans": "机密扫描",
                        "Secrets scanning scan completed.": "机密扫描已完成",
                    // "": "星标",
                        "A star is created or deleted from a repository.": "标星或取消仓库星标。",
                    "Statuses": "状态",
                        "Commit status updated from the API.": "通过 API 更新提交状态。",
                    "Team adds": "团队添加",
                        "Team added or modified on a repository.": "在仓库上添加或修改的团队。",
                    "Teams": "团队",  // 组织设置
                        "Team is created, deleted, edited, or added to/removed from a repository.": "团队的创建、删除、编辑以及向仓库添加团队、从仓库中移除团队。",
                    "Visibility changes": "可见性变化",
                        "Repository changes from private to public.": "仓库从私有更改为公共。",
                    "Watches": "关注",
                        "User stars a repository.": "用户标星仓库。",
                    "Wiki": "",
                        "Wiki page updated.": "Wiki 页面的更新。",
                    "Workflow jobs": "工作流程作业",
                        "Workflow job queued, waiting, in progress, or completed on a repository.": "仓库中工作流作业的队列、等待、正在进行或完成。",
                    "Workflow runs": "工作流程运行",
                        "Workflow run requested or completed on a repository.": "仓库中工作流程运行的请求或完成。",
                "Active": "激活",
                "We will deliver event details when this hook is triggered.": "当钩子被触发时，我们将提供事件详细信息。",

            // 顶部提醒
            "Okay, that hook was successfully created. We sent a ping payload to test it out! Read more about it at https://docs.github.com/webhooks/#ping-event.": "好的，这个钩子已经成功创建。我们发送了一个 ping 负载来测试它! 阅读更多关于它的信息，请访问 https://docs.github.com/webhooks/#ping-event。",

        // 管理 钩子 /<user-name>/<repo-name>/settings/hooks/<id>
            "Manage webhook": "管理 Web 钩子",
            "If you've lost or forgotten this secret, you can change it, but be aware that any integrations using this secret will need to be updated. —": "如果您丢失或忘记了此机密，则可以更改它，但请注意，使用此机密的任何集成都需要更新。 —",
            "Change Secret": "更改机密",
            "Update webhook": "更新 Web 钩子",
            // 顶部提醒
                "Okay, the hook was successfully updated.": "好的，Web 钩子已经成功更新。",
            "Delete webhook": "删除 Web 钩子",

        // 最近交付标签 /<user-name>/<repo-name>/settings/hooks/<id>?tab=deliveries
            "Recent Deliveries": "最近交付",
                "redelivery": "再交付",
            "Loading deliveries…": "载入交付…",
            "Detailed delivery information will be shown here once the hook has been triggered.": "一旦触发钩子，详细的交付信息将在此处显示。",

            "Request": "请求",
            "Response": "应答",
            "Redeliver": "重新交付",
                "Redeliver payload?": "重新交付有效负载？",
                "The payload will be delivered to": "该有效负载将被发送到",
                "using the current webhook configuration.": "使用当前的 Web 钩子 配置。",
                "Yes, redeliver this payload": "是的，重新发送此有效负载",
                    "Delivering payload…": "交付有效载荷…",
    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/Completed in (\d+(\.\d+)) seconds?./, "在 $1 秒内完成。"],
    ],
    "title": {
        "static": {
            "Add webhook": "添加 Web 钩子",
        },
        "regexp": [
            [/Webhooks · Settings/, "Web 钩子 · 设置"],
        ],
    },
};
I18N["zh-CN"]["orgs/settings/hooks"] = I18N["zh-CN"]["repository/settings/hooks"];

I18N["zh-CN"]["repository/settings/copilot/code_review"] = {
    "static": {
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"],

        // 代码审查
            "Enable automatic code review": "启用自动代码审查",
                "You can enable Copilot to automatically review pull requests by enabling it inside Repository rules.": "您可以在仓库规则中启用 Copilot，从而让 Copilot 自动审查拉取请求。",
                "Learn more about automatic code reviews.": "了解更多关于自动代码生成的信息。",
                "Go to repository rules": "前往仓库规则",

        "General settings": "常规设置",
            "Use custom instructions when reviewing pull requests": "在审查拉取请求时使用自定义指令",
                "Copilot references": "Copilot 在审查拉取请求时会参考",
                "repository custom instructions": "仓库自定义指令",
                "when reviewing pull requests.": "。",

        "With Copilot code review, you can add Copilot as a reviewer to your pull requests, including drafts. You can also select lines in Visual Studio Code and ask Copilot to review and comment on specific sections.": "使用 Copilot 代码审查，您可以将 Copilot 添加为拉取请求的审查者，包括草稿。您还可以在 Visual Studio Code 中选择行，并请求 Copilot 审查和评论特定部分。",
        "Learn more about Copilot code reviews.": "了解更多关于 Copilot 代码审查的信息。",

        "Automated code reviews using rulesets": "使用规则集自动代码审查",
            "Use rulesets to configure Copilot to review pull requests automatically.": "使用规则集配置 Copilot 自动审查拉取请求。",
            "Learn how to set up rulesets.": "了解如何设置规则集。",

        "Go to rulesets": "前往规则集",
        "No rulesets set up for automated reviews": "尚无设置自动代码审查的规则集",
        "Create a ruleset to automate code reviews for pull requests targeting your default branch": "创建一个规则集，自动代码审查针对您的默认分支的拉取请求",
        "Create ruleset for default branch": "创建针对默认分支的规则集",
    },
    "regexp": [
        // 1 repository ruleset
        [/(\d+) repository rulesets?/, "$1 仓库规则集"],
        // 3 branch rules • targeting 1 branch
        [/(\d+) branch rules? • targeting (\d+) branch(?:es)?/, "$1 分支规则 • 针对 $2 分支"],
    ],
    "title": {
        "regexp": [
            [/Settings · Code review/, "设置 · 代码审查"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/copilot/coding_agent"] = {
    "static": {
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],
        ...I18N["zh-CN"]["orgs-settings-menu"]["static"],

        "Copilot coding agent": "Copilot 编程智能体",

        "You can configure Copilot coding agent for other users with access to this repository, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro+ or Copilot Enterprise license.": "您可以为其他具有此仓库访问权限的用户配置 Copilot 编程智能体，但由于您没有 Copilot Pro+ 或 Copilot 企业版许可证，因此无法向 Copilot 分配任务。",

        "With Copilot coding agent, developers can delegate tasks to Copilot, freeing them to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request review, then leave feedback on the pull request to iterate. To learn more, see the": "使用 Copilot 编程智能体，开发者可以将任务委托给 Copilot，从而专注于更具创造性、复杂性和高影响力的重要工作。只需将议题分配给 Copilot，等待助手发起评审请求，然后在拉取请求上留下反馈进行迭代。更多信息请参阅",
        "With Copilot coding agent, developers can delegate tasks to Copilot, freeing them to focus on the creative, complex, and high-impact work that matters most. Assign an issue to Copilot, wait for the agent to request review, then leave feedback on the pull request to iterate.": "借助 Copilot 编程智能体，开发者可以将任务委托给 Copilot，从而有更多时间专注于最重要的创造性、复杂和高影响力的工作。只需将议题分配给 Copilot，等待请求代码审查，然后在拉取请求上留下反馈，进行迭代即可。",
        "Learn more about Copilot coding agent": "了解更多",

        "Internet access": "访问互联网",
            "Ensure that the agent only accesses approved network resources during code generation and execution.": "确保智能体在代码生成和执行过程中只访问已批准的网络资源。",
                "Learn more about customizing network access": "了解更多",

            "Enable firewall": "启用防火墙",
                "Recommended": "推荐",
                "Limit Copilot coding agent’s Internet access to only allow access to allowlisted locations": "将 Copilot 编程智能体的互联网访问权限限制为仅允许访问白名单中的位置。",
            "Recommended allowlist": "推荐白名单",
                "Allow access to locations frequently used to install tools, packages, and dependencies": "允许访问常用于安装工具、软件包和依赖项的位置",
            "Custom allowlist": "自定义白名单",
                "Allow access to specific domains, IP addresses, or URLs.": "允许访问特定域名、IP 地址或 URL。",

            // settings/copilot/coding_agent/allowlist 自定义白名单
                "Add items to the allowlist to enable Copilot coding agent to access specific domains, IP addresses, or URLs.": "将项目添加到允许列表，以便 Copilot 智能体能够访问特定的域名、IP 地址或 URL。",
                    "See the GitHub Docs for syntax and examples.": "请参阅 GitHub 文档以获取语法和示例。",

                "e.g. https://example.com/a/path or example.com": "例：https://example.com/a/path 或 example.com",
                "Add rule": "添加规则",
                "Rule must be a valid domain, IP address, or URL": "规则必须是有效域名、IP 地址或 URL",

                "No rules yet": "无规则",
                    "Tip: Paste a list of rules into the input to add them all at once.": "提示：将规则列表粘贴到输入框中，可以一次性添加所有规则。",
                "Delete rule": "删除规则",

                // 保存
                    "Allowlist settings saved successfully!": "白名单设置保存成功！",

        "Model Context Protocol (MCP)": "模型上下文协议（MCP）",
            "The MCP is an open standard that defines how applications share context with large language models (LLMs). MCP provides a standardized way to connect AI models to different data sources and tools, enabling them to work together more effectively.": "MCP 是一个开放标准，定义了应用程序如何与大型语言模型（LLM）共享上下文。MCP 提供了一种标准化的方法，将 AI 模型与不同的数据源和工具连接起来，使它们能够更高效地协同工作。",
            "You can use MCP to extend the capabilities of Copilot coding agent by connecting it to other tools and services. For information on how to write your JSON MCP configuration, see the": "您可以使用 MCP 通过将其连接到其他工具和服务，来扩展 Copilot 编程智能体的功能。有关如何编写您的 JSON MCP 配置的详细信息，请参见",
            "You can use MCP to extend the capabilities of Copilot coding agent by connecting it to other tools and services.": "您可以使用 MCP 通过将其连接到其他工具和服务，来扩展 Copilot 编程智能体的功能。",
                "Learn how to write your JSON MCP configuration": "了解如何编写您的 JSON MCP 配置",

            "MCP configuration": "MCP 配置",
                // 代码窗 - 底部栏
                  "to toggle the": "切换",
                  "key moving focus. Alternatively, use": "键移动对焦。或者使用",
                  "then": "键，然后",
                  "to move to the next interactive element on the page.": "键移动到页面上的下一个交互元素。",

            "Your configuration will be validated on save.": "您的配置将在保存时进行验证。",

            "Save MCP configuration": "保存",

            "Use of Copilot coding agent is subject to the": "使用 Copilot 编程智能体需遵守",
                "pre-release terms": "预发行条款",
    },
    "regexp": [
        [/(\d+) rules?/, "$1 规则"],
    ],
    "title": {
        "static": {
            "Copilot coding agent": "Copilot 编程智能体",
        },
    },
};

I18N["zh-CN"]["repository/settings/environments"] = { // 仓库设置 - 环境 /<user-name>/<repo-name>/settings/environment
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 仓库 环境 /<user-name>/<repo-name>/settings/environments
            "New environment": "新建环境",
            "You can configure environments with protection rules, variables, and secrets.": "您可以使用保护规则，变量和机密配置环境。",
            "Learn more about configuring environments.": "了解更多关于配置环境的信息。",

            "There are no environments for this repository": "此仓库尚无环境",
            "Environments are used by your workflows for deployments.": "您的工作流程使用环境进行部署。",
            "You can configure environments with protection rules and secrets.": "您可以使用保护规则和机密配置环境。",

            "Delete environment": "删除环境",
            // 删除环境对话框
            "Are you sure you want to delete this environment?": "您确定要删除此环境吗？",
                "Deleting an environment will delete all associated secrets, variables, and protection rules.": "删除环境将删除所有关联的机密、变量和保护规则。",
                "I understand, delete this environment": "我明白了，依然删除这个环境",
            // 顶部提醒
                "Environment deleted.": "环境已删除。",
                "There was an error saving your new environment.": "保存新环境时出错。",

        // 仓库 新建环境 /<user-name>/<repo-name>/settings/environments/new
            "/ Add": "/ 添加",
            "Name": "名称",
            "Configure environment": "设置环境",
            "Name can't be blank": "名称不能为空",

        // 编辑环境 /<user-name>/<repo-name>/settings/environments/<id>/edit
            // 顶部提醒
                // [/Environment \"([^ ]+)\" created./, "环境 “$1” 已创建。"],
                // [/Environment \"([^ ]+)\" updated./, "环境 “$1” 已更新。"],

            "/ Configure": "/ 设置",

            "Deployment protection rules": "部署保护规则",
                "Configure reviewers, timers, and custom rules that must pass before deployments to this environment can proceed.": "配置审查者、计时器和自定义规则，在继续部署到此环境之前必须通过这些规则。",

                "Required reviewers": "所需的审查者",
                    "Specify people or teams that may approve workflow runs when they access this environment.": "指定访问此环境时可以批准工作流运行的人员或团队。",
                        "Add up to": "最多添加",
                        "more": " ",
                        "reviewers": "位审查者",
                        "Search for people or teams...": "搜索人员或团队…",

                    "Prevent self-review": "防止自我审查",
                        "Require a different approver than the user who triggered the workflow run.": "要求与触发工作流程运行的用户不同的批准审查者。",
                "Wait timer": "等待计时器",
                    "Set an amount of time to wait before allowing deployments to proceed.": "设置允许部署继续之前等待的时间。",
                    "minutes": "分钟",
                "Enable custom rules with GitHub Apps": "使用 GitHub Apps 启用自定义规则",
                    "Learn about existing apps": "了解现有应用",
                    "create your own protection rules": "创建您自己的保护规则",
                    "so you can deploy with confidence.": "以便您可以放心地进行部署。",
                "Allow administrators to bypass configured protection rules": "允许管理员绕过配置的保护规则",
                "Save protection rules": "保存保护规则",

            "Deployment branches and tags": "部署分支和标签",
                "Limit which branches and tags can deploy to this environment based on rules or naming patterns.": "根据规则或命名模式限制哪些分支和标签可以部署到此环境。",
                "No restriction": "没有限制",
                    "No restriction to which branch or tag from this repository can deploy.": "不限制仓库中的分支或标签进行部署。",
                "Protected branches only": "仅受保护的分支",
                    "Deployment limited to branches with protection rules.": "部署仅限于具有保护规则的分支。",
                "Selected branches and tags": "选中的分支和标签",
                    "Specify a list of branches and tags using naming patterns.": "使用命名模式指定分支和标签的列表。",

                "Applies to": "适用于",
                // [/(\d+) branch(?:es|)/, "$1 个分支"],
                ". Based on the existing": "。基于已有的",
                "repository branch protection rules": "仓库分支保护规则",
                // [/Currently applies to (\d+) branch(?:es|)/, "目前适用于 $1 个分支"],

                "No branch or tag rules applied yet:": "尚未应用分支或标签规则：",
                "all branches and tags are still allowed to deploy.": "仍允许所有分支和标签进行部署。",

                // [/(\d+) branch(?:es|) allowed/, "允许 $1 个分支"],
                // [/(\d+) branch(?:es|) and (\d+)  tags? allowed/, "允许 $1 个分支和 $2 个标签"],
                "Add deployment branch or tag rule": "添加部署分支或标签规则",
                    // 添加部署分支规则 对话框
                    "Ref type:": "引用类型：",
                        "Tag": "标签",
                    "Name pattern:": "名称的模式：",
                    "Add rule": "添加规则",
                "Update deployment branch rule": "更新部署分支规则",
                    "Update rule": "更新规则",
                "Remove": "删除",

                // 顶部提醒
                    "Environment changes successfully saved: all branches can deploy.": "环境更改已成功保存：所有分支都可以部署。",
                    "Environment changes successfully saved: only protected branches can deploy.": "环境更改已成功保存：只有受保护的分支才能部署。",
                    "Environment changes successfully saved: only selected branches and tags can deploy.": "环境更改已成功保存：只有选定的分支和标签才能部署。",
                    // [/Deployment branch rule \"([^ ]+)\" saved successfully./ ,"部署分支规则 “$1” 已成功保存。"],
                    // [/Deployment branch rule \"([^ ]+)\" removed./, "部署分支规则 “$1” 已删除。",]

            "Environment secrets": "环境机密",
                "Secrets are encrypted environment variables. They are accessible only by GitHub Actions in the context of this environment by using the": "机密是加密的环境变量。它们只能由 GitHub Actions 在这个环境中访问",
                    "secret context": "机密上下文",

                "Name": "名称",
                "Value": "值",
                "Last updated": "最后更新",

                "This environment has no secrets.": "该环境尚无机密。",
                "Add environment secret": "添加环境机密",
                    // 添加机密对话框
                    "Add secret": "添加机密",
                    "Secret value": "机密值",
                    // 提醒
                        "Failed to add secret: Secret names can only contain alphanumeric characters ([a-z], [A-Z], [0-9]) or underscores (_). Spaces are not allowed. Must start with a letter ([a-z], [A-Z]) or underscores (_).": "添加机密失败：机密名称只能包含字母、数字字符 ([a-z], [A-Z], [0-9]) 或下划线 (_)。不允许使用空格。必须以字母 ([a-z], [A-Z]) 或下划线 (_) 开头。",
                        "Name and value are required": "名称和值是必填项。",

                "Update secret": "更新机密",
                // 删除机密 对话框
                    "Delete secret": "删除机密",
                        "Are you sure you want to delete": "您确定要删除",
                        "Yes, delete this": "是的，删除该",
                        "secret": "机密",

            "Environment variables": "环境变量",
                "Variables are used for non-sensitive configuration data. They are accessible only by GitHub Actions in the context of this environment by using the": "变量用于非敏感配置数据。它们只能由 GitHub Actions 在此环境中访问",
                    "variable context": "变量上下文",

                "This environment has no variables.": "该环境尚无变量。",
                "Add environment variable": "添加环境变量",
                    // 添加变量对话框
                    "Add variable": "添加变量",
                    "Variable value": "变量值",
                    // 提醒
                        "Failed to add variable: Variable names can only contain alphanumeric characters ([a-z], [A-Z], [0-9]) or underscores (_). Spaces are not allowed. Must start with a letter ([a-z], [A-Z]) or underscores (_).": "添加变量失败： 变量名只能包含字母、数字字符（[a-z]、[A-Z]、[0-9]）或下划线 (_)。不允许使用空格。必须以字母 ([a-z], [A-Z]) 或下划线 (_) 开头。",

                "Update variable": "更新变量",
                // 删除变量 对话框
                    "Delete variable": "删除变量",
                    "variable": "变量",

    },
    "regexp": [ // 正则翻译
        ...I18N["zh-CN"]["repository-public"]["regexp"],
        [/(\d+) protection rules?/, "$1 个保护规则"], // /environments
        [/(\d+) secrets?/, "$1 个机密"], // /environments
        [/(\d+) variables?/, "$1 个变量"], // /environments
        [/Environment \"([^ ]+)\" created./, "环境 “$1” 已创建。"],
        [/Environment \"([^ ]+)\" updated./, "环境 “$1” 已更新。"],
        [/Currently applies to (\d+) branch(?:es|)/, "目前适用于 $1 个分支"],
        [/(\d+) branch(?:es|) and (\d+) tags? allowed/, "允许 $1 个分支和 $2 个标签"],
        [/(\d+) branch(?:es|) allowed/, "允许 $1 个分支"],
        [/(\d+) branch(?:es|)/, "$1 个分支"],
        [/Deployment branch rule \"([^ ]+)\" saved successfully./ ,"部署分支规则 “$1” 已成功保存。"],
        [/Deployment branch rule \"([^ ]+)\" removed./, "部署分支规则 “$1” 已删除。",]
    ],
    "title": {
        "regexp": [
            [/Environments/, "环境"],
            [/Create environment/, "创建环境"],
            [/Configure environment/, "配置环境"],
        ],
    },
};

I18N["zh-CN"]["repository/settings/codespaces"] = { // 仓库设置 - 代码空间 /<user-name>/<repo-name>/settings/codespaces
    "static": { // 静态翻译
        ...I18N["zh-CN"]["repository-public"]["static"],
        ...I18N["zh-CN"]["repository-settings-menu"]["static"],

        // 代码空间 /<user-name>/<repo-name>/settings/codespaces
            // 顶部提醒
                "Prebuild configuration created": "预构建设置已创建",
                "Prebuild configuration deleted": "预构建设置已删除",
            "Prebuild configuration": "预构建设置",

            "Set up prebuild": "设置预构建",
            "There are no prebuilds configured for this repository": "尚无预构建设置",
            "Prebuild configurations speed up Codespace creations significantly by pre-executing all the tasks required to build your development environment.": "预构建设置通过预先执行构建开发环境所需的所有任务，大大加快了代码空间的创建。",
            "Learn more about setting up prebuilds": "了解更多关于预构建设置的信息",

            // 状态
                "Currently Running": "正在运行中",
                "Disabled": "禁用",
            "See output": "查看输出结果",

            "Configuration menu": "设置菜单",
                "Manually trigger": "手动触发",
                "View runs": "查看运行日志",
                "Disable runs":"暂停运行",
                "Enable runs":"恢复运行",

            // 删除对话框
                "Are you sure?": "您确定吗？",
                "Are you sure you want to delete this prebuild configuration? Running workflow may fail and templates associated with this configuration will be deleted.": "您确定要删除这个预构建设置吗？运行中的工作流可能会失败，与此设置相关的模板将被删除。",

        // 代码空间-新建预构建设置 /<user-name>/<repo-name>/settings/codespaces/prebuild_configurations/new
            "/ New prebuild configuration": "/ 新建预构建设置",
            // 黄色警告
                "Prebuilds consume storage space that will incur a billable charge. Learn more about": "预构建会占用存储空间，可能会产生费用。了解更多关于",
                "prebuild configurations": "预构建设置",

            "Configuration": "设置",
            "Your prebuild will be built from the branch and configuration file selected below. Learn more about": "您的预构建将从下面选择的分支和配置文件中构建。了解更多关于",
            "prebuild configuration.": "预构建的设置。",
            "Select branch": "选择分支",
      