/*******************************************************************************

    locals.js - 搭配用戶腳本插件`GitHub 中文化插件`的頁面匹配規則, 翻譯忽略規則,
                詞條庫文件
    Copyright (C) 2016-2021 樓教主 (https://github.com/52cik)
    Copyright (C) 2021-當前 沙漠之子 (https://github.com/maboloshi)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>.

    Home: https://github.com/maboloshi/github-chinese
*/
var I18N = {};

I18N.conf = {

    /**
     * 匹配 pathname 頁面的正則
     *
     * 註冊頁面 /signup
     * 登錄二步驗證 /login/oauth
     * 登錄頁面 /login
     * 密碼重置 /password_reset
     * 組織頁面 /orgs
     * 探索頁面 /explore
     * 訂閱頁面 /notifications/subscriptions
     * 通知頁面 /notifications
     * 關注頁面 /watching
     * 星標頁面 /stars
     * 議題頁面 /issues
     * 拉取請求 /pulls
     * 搜索頁面 /search
     * 趨勢頁面 /trending
     * 展示頁面 /showcases
     * 導入倉庫 /new/import
     * ...
     */
    rePagePath: /^\/($|home|dashboard|feed|copilot|spark|signup|account_verifications|login\/oauth|login|logout|sessions?|password_reset|orgs|explore|topics|notifications\/subscriptions|notifications|watching|stars|issues|pulls|repos|search|trending|showcases|new\/(import|project)|new|import|settings\/(profile|admin|appearance|accessibility|notifications|billing|emails|security_analysis|security-log|security|auth|sessions|keys|ssh|gpg|organizations|enterprises|blocked_users|interaction_limits|code_review_limits|repositories|codespaces|models|codespaces\/allow_permissions|deleted_repositories|packages|copilot|pages|replies|installations|apps\/authorizations|reminders|sponsors-log|apps|(?:personal-access-|)tokens|developers|applications\/new|applications|connections\/applications|education\/benefits)|settings|installations\/new|marketplace|apps|account\/(organizations\/new|choose|upgrade|billing\/history)|projects|redeem|discussions|collections|sponsors|sponsoring|github-copilot\/(signup|free_signup|code-review-waitlist|pro)|codespaces|developer\/register|features|security|sitemap|education|mcp)|^\/users\/[^\/]+\/(projects|packages|succession\/invitation)/,

    // 倉庫路徑
    rePagePathRepo: /^\/[^\/]+\/[^\/]+\/(issues|pulls|pull|tree|watchers|stargazers|new|edit|delete|upload|find|models|wiki|branches|discussions|activity|rules|releases|packages|tags|labels|milestones?|compare|commit|blob|blame|actions(\/metrics\/(usage|performance))?|runs|deployments|security|pulse|community|forks|fork|import|graphs\/(contributors|community|traffic|commit-activity|code-frequency)|network$|network\/(dependencies|dependents|updates|members)|settings\/(access|code_review_limits|interaction_limits|branches|branch_protection_rules|tag_protection|rules|actions|models\/access-policy|hooks|copilot\/(code_review|coding_agent)|environments|codespaces|pages|security_analysis|dependabot_rules|keys|secrets|variables|installations|notifications|key_links)|settings|transfer|projects\/new|projects|pkgs|contribute|subscription|invitations|codespaces|attestations|custom-properties|reported_content)/,

    // 組織路徑
    rePagePathOrg: /^\/[^\/]+\/[^\/]+\/(repositories\/new|repositories|sponsoring|discussions|projects|packages|teams|new-team|people|outside-collaborators|pending_collaborators|dashboard|billing_managers\/new|invitations?|settings\/(profile|billing|roles|member_privileges|teams|import-export|blocked_users|interaction_limits|code_review_limits|moderators|repository-defaults|rules|codespaces|copilot|actions|hooks|discussions|packages|pages|projects|security_analysis|security|dependabot_rules|domains|secrets|variables|oauth_application_policy|installations|personal-access-token|reminders|sponsors-log|audit-log|deleted_repositories|applications\/new|applications|apps\/new|apps|publisher|policies\/repositories)|topics|domain\/new|audit-log\/event_settings|billing\/(history|plans)|policies\/applications)|^\/[^\/]+\/(enterprise_plan|sponsoring)/,

    // 特定頁面，啟用`字符數據`監測
    characterDataPage: ['repository/new', 'repository/edit', 'new', 'new/import', 'orgs/repositories/new', 'repository/blob', 'repository/pull', 'marketplace', 'homepage', 'repository/issues', 'repository/commit', 'copilot', 'spark', 'repository/settings/rules'],

    // 特定頁面，忽略突變元素規則
    ignoreMutationSelectorPage: {
        'repository/new': [".cm-scroller"], // 程式碼編輯器
        'repository/edit': [".cm-scroller", "table"], // 程式碼編輯器
        'repository/pull': [
            "td.blob-code", // 程式碼差異 分屏/同屏
            '.js-full-logs-container', // 工作流運行日誌
        ],
        'repository/compare': [
            "tbody", // 程式碼差異
            ".js-preview-body", // 新建拉取請求 - 正文編輯器預覽
        ],
        'repository/commit': ["td.blob-code"], // 程式碼差異 分屏/同屏
        'repository/blob': [
            "#highlighted-line-menu-positioner", // 程式碼視圖 存在
            "#repos-sticky-header", // 程式碼視圖 置頂標題
            'nav[data-testid="breadcrumbs"]', // 麵包屑導航
            'div[data-testid="breadcrumbs-filename"]', // 麵包屑導航 文件名部分
        ],
        'repository/blame': ["#highlighted-line-menu-positioner"], // 程式碼視圖
        'repository': [
            ".AppHeader-context",
            "table",
            "article.markdown-body",
        ],
        'repository/tree': [
            'nav[data-testid="breadcrumbs"]', // 麵包屑導航
            'div[data-testid="breadcrumbs-filename"]', // 麵包屑導航 文件名部分
            'tr.react-directory-row', // 文件列表中文件夾和文件條目
        ],
        'repository/releases': [".Box-footer"], // 附件清單
        'repository/issues': [
            'div[aria-live="polite"]>div.markdown-body', // 新建議題 - 正文編輯器預覽
            '.markdown-body[data-team-hovercards-enabled="true"]', // 某個議題 - 正文以及正文編輯器、添加評論編輯器預覽
        ],
        'repository/actions': [
            'table.highlight', // 工作流程文件 源碼視圖
            '.js-full-logs-container', // 工作流運行日誌
        ],
        'copilot':[
            '.cm-line',
        ],
        'spark':[
            '.cm-line',
        ],
        '*': [
            'div.QueryBuilder-StyledInputContainer', // 頂部搜索欄 關鍵詞
            '#qb-input-query span', // 搜索頁面 搜索欄 關鍵詞
			'div.styled-input-content', // 篩選條
        ],
    },

    // 特定頁面，忽略元素規則
    ignoreSelectorPage: {
        'page-profile': [
            'span.p-nickname', // 用戶暱稱
            'span.p-name', // 同上
        ],
        'page-profile/followers': [
            'span.f4.Link--primary',
            "span.Link--secondary.pl-1",
        ],
        'page-profile/repositories': [
            'a[itemprop="name codeRepository"]', // 倉庫名稱
        ],
        'page-profile/stars': [
            '.mb-1.d-inline-block > h3', // 倉庫名稱
        ],
        'repository': [
            '.AppHeader-context-full', // 頂部 <username>/<repo_name>
            'strong[itemprop="name"]', // 倉庫名稱
            // 'ul.list-style-none', // 右側 部署列表 無效
            'div[data-testid="latest-commit"]', // 最新的提交
            'tr.react-directory-row', // 文件列表中文件夾和文件條目
            'p.f4.my-3', // 倉庫簡介正文
            '#translate-me',
            '.my-3.d-flex.flex-items-center', // 倉庫簡介中的鏈接
            'article.markdown-body', // 自述文件正文
            'li.mt-2',
        ],
        'repository/tree': [
            '.AppHeader-context-full', // 頂部 <username>/<repo_name>
            'div.react-tree-show-tree-items', // 左側文件樹專案
            'span.PRIVATE_TreeView-item-content-text', // 左側文件樹專案 - 子文件夾
            'article.markdown-body', // Markdown 正文
            'nav[data-testid="breadcrumbs"]', // 麵包屑導航
            'div[data-testid="breadcrumbs-filename"]', // 麵包屑導航 文件名部分
            'tr.react-directory-row', // 文件列表中文件夾和文件條目
        ],
        'repository/blob': [
            '.AppHeader-context-full', // 頂部 <username>/<repo_name>
            'article.markdown-body', // Markdown 正文
            'div.react-tree-show-tree-items', // 左側文件樹專案
            '[id^="offset"]', // 符號-->引用
            '#highlighted-line-menu-positioner', // 程式碼視圖
            '#filter-results', // 右側 符號篩選
            '.Text__StyledText-sc-17v1xeu-0', // 右側 符號篩選
            'nav[data-testid="breadcrumbs"]', // 麵包屑導航
            'div[data-testid="breadcrumbs-filename"]', // 麵包屑導航 文件名部分
        ],
        'repository/issues': [
            'div[aria-live="polite"]>div.markdown-body', // 新建議題 - 正文編輯器預覽
            '.markdown-body[data-team-hovercards-enabled="true"]', //  某個議題 - 正文以及正文編輯器、添加評論編輯器預覽
        ],
        'repository/commit': [
            'td.blob-code', // 程式碼差異 分屏/同屏
            'span.ws-pre-wrap', // 提交說明
            "h4[class^='Title-module__heading']", // 提交標題
        ],
        'repository/pull': [
            'td.blob-code', // 程式碼差異 分屏/同屏
            '.js-full-logs-container', // 工作流運行日誌
        ],
        'repository/compare': [
            'td.blob-code', // 程式碼差異 分屏/同屏
        ],
        'repository/edit': [
            '.cm-scroller', // 程式碼編輯器
            'table', // 程式碼差異預覽
        ],
        'repository/new': [
            '.cm-scroller', // 程式碼編輯器
            'table', // 程式碼差異預覽
        ],
        'repository/actions': [
            'table.highlight', // 工作流程文件 源碼視圖
            '.js-full-logs-container', // 工作流運行日誌
        ],
        'repository/releases': [
            'div.Box-body>div.markdown-body', // 發佈版正文
        ],
        'repository/wiki': [
            '#wiki-body', // wiki 正文
            'ul.list-style-none.mx-4.px-1', // 右側目錄
        ],
        'orgs': [
            'a[itemprop="name codeRepository"]', // 倉庫名稱
        ],
        'search': [
            'span.search-match', // 搜索匹配信息
            'div.code-list', // 程式碼片段預覽
            'optgroup > option', // 下拉菜單列表
        ],
        'dashboard': [
            '.js-notice-dismiss', // 右側欄 廣告
            '.TimelineItem', // 右側欄 最新變化
            'section.comment-body', // 發佈版正文
        ],
        'gist': [
            '.gist-content[itemprop="about"]', // Gist 簡介
            'div.js-blob-code-container', // 程式碼框
            'table.js-diff-table', // 程式碼差異
        ],
        'topics': [
            'h3.f3.color-fg-muted.text-normal.lh-condensed', // 倉庫名稱
        ],
        'marketplace': [
            '.markdown-body',
        ],
        'copilot':[
            '.cm-line',
        ],
        'spark': [
            '.Table',
            '.monaco-editor',
        ],
        '*': [
            '.comment-body', '.js-preview-body',
            '.markdown-title',
            'span.ActionListItem-descriptionWrap',  // 頂部搜索欄 關鍵詞
            'CODE', 'SCRIPT', 'STYLE', 'LINK', 'IMG', 'MARKED-TEXT', 'PRE', 'KBD', 'SVG', 'MARK', // 特定元素標籤
			'div.styled-input-content', // 篩選條
        ],
    },

    // 以下兼容 1.9.2 版本，且凍結 等待 1.9.3 明顯 Bug 修復
    /**
     * 要翻譯的頁面正則(不含倉庫頁)
     *
     * 2021-10-07 11:53:34
     * GitHub 網站更新 調整 Class 過濾規則
     * 且過濾 Class 並不是總是生效，增加 PathName 規則補充
     */
    rePageClass: /\b(page-(profile|new-repo|create-org)|session-authentication)\b/,

    /**
     * 忽略區域的 class 正則
     *
     * 程式碼編輯器 內容 程式碼高亮 CodeMirror
     * 程式碼編輯器 最小單元 cm-line ͼ.*
     * 程式碼高亮 blob-code
     * 倉庫名和用戶名 repo-and-owner (已知出現在：應用安裝授權頁和設置頁 選定倉庫)
     * 文件,目錄位置欄 |js-path-segment|final-path
     * 文件列表 files js-navigation-container js-active-navigation-container
     * 評論內容等 js-comment-body
     * 評論預覽 js-preview-body
     * 評論編輯區域 comment-form-textarea
     * 文件搜索模式 js-tree-finder-virtual-filter
     * 倉庫文件列表 js-navigation-open Link--primary
     * 快捷鍵 按鍵 js-modifier-key
     * 洞察-->流量-->熱門內容列表 capped-list-label
     * realease 頁面 描述主體 markdown-body my-3
     * 倉庫頁 倉庫描述 f4 my-3
     * 提交的用戶名 commit-author$
     * 搜索頁 搜索結果 search-match
     * 追溯 視圖 程式碼 react-code-text
     * tree 視圖 文件名 react-directory-filename-column 提交信息 react-directory-commit-message
     * 程式碼差異頁面 程式碼 pl-s1|pl-smi|pl-token|pl-c1|pl-kos|pl-k|pl-c|pl-en
     */
    reIgnoreClass: /(cm-line|ͼ.*|pl-s1|pl-smi|pl-token|pl-c1|pl-kos|pl-k|pl-c|pl-en|CodeMirror|blob-code|highlight-.*|repo-and-owner|js-path-segment|final-path|files js-navigation-container|js-comment-body|js-preview-body|comment-form-textarea|markdown-title|js-tree-finder-virtual-filter|js-navigation-open Link--primary|js-modifier-key|capped-list-label|blob-code blob-code-inner js-file-line|markdown-body my-3|f4 my-3|commit-author$|search-match|react-directory-filename-column|react-directory-commit-message|react-code-text|zausi)/,

    /**
     * 忽略區域的 itemprop 屬性正則
     * name 列表頁 倉庫名
     * author 倉庫頁 作者名稱
     * additionalName 個人主頁 附加名稱
     */
    reIgnoreItemprop: /(name|author|additionalName)/,

    /**
     * 忽略區域的 特定元素id 正則
     * /blob頁面 offset  符號-->引用
     * /blob頁面 右側 符號篩選 filter-results
     * fix repo詳情頁文件路徑breadcrumb
     */
    reIgnoreId: /(readme|^offset|breadcrumb|file-name-id|filter-results)/,

    /**
     * 忽略區域的 標籤 正則
     * /i 規則不區分大小寫
     */
    reIgnoreTag: ['CODE', 'SCRIPT', 'STYLE', 'LINK', 'IMG', 'MARKED-TEXT', 'PRE', 'KBD'],
    // marked-text --> 文件搜索模式/<user-name>/<repo-name>/find/<branch> 文件列表條目
    // ^script$ --> 避免勿過濾 notifications-list-subscription-form
    // ^pre$ --> 避免勿過濾
};

I18N["zh-TW"] = {};

I18N["zh-TW"]["title"] = { // 標題翻譯
    "static": { // 靜態翻譯
        "Sign up to GitHub · GitHub": "註冊 · GitHub",
        "Sign in to GitHub · GitHub": "登錄 GitHub · GitHub",
        "Join GitHub · GitHub": "加入 GitHub · GitHub",
        "Forgot your password? · GitHub": "忘記您的密碼了嗎？· GitHub",
        "Forgot your password?": "忘記您的密碼了嗎？",
        "GitHub · Where software is built": "GitHub · 軟體構建的地方",
        "Create a New Repository": "新建倉庫",
        "Import a Repository": "導入倉庫",
        "New Project": "創建專案",
        "Your Repositories": "我的倉庫",
        "Your Projects": "我的專案",
        "Your Packages": "我的軟體包",
        "Your Stars": "我的星標頁面",
        "Your profile": "個人資料",
        "Your Achievements": "我的成就",
        "Your Followers": "我的關注者",
        "Who You’re Following": "我關注的人",
        "Account settings": "賬戶設置",
        "Appearance": "外觀",
        "Accessibility": "無障礙",
        "Notification settings": "通知設置",
        "Billing": "賬單",
        "Email settings": "郵箱設置",
        "Account security": "賬戶安全",
        "SSH and GPG keys": "SSH 與 GPG 公鑰",
        "Organizations": "組織",
        //"Blocked users": "拉黑用戶",
        "Temporary interaction limits": "臨時互動限制",
        "Code review limits": "程式碼審查限制",
        "Repositorys": "倉庫",
        "Deleted Packages": "刪除的軟體包",
        "Pages": "GitHub 頁面",
        "Saved replies": "快捷回覆",
        "Security & analysis": "安全與分析",
        "Installed GitHub Apps": "已安裝的 GitHub 應用",
        "Issue search results": "議題搜索結果",
        "Scheduled reminders": "定時提醒",
        "Security log": "安全日誌",
        "Sponsorship Log": "贊助日誌",
        "GitHub Apps": "GitHub 應用",
        "Developer applications": "開發者應用",
        "Personal Access Tokens": "個人訪問令牌",
        "Register new GitHub App": "註冊新 GitHub 應用",
        "New OAuth Application": "新 OAuth 應用",
        "Create a new Gist": "創建新程式碼片段",
        "Discover gists": "探索程式碼片段",
        "Enable two-factor authentication": "啟用雙因素身份驗證",
        "Manage two-factor authentication": "管理雙因素身份驗證",
        "Options": "倉庫 · 選項",
        "Confirm access": "授權訪問",
        "General": "通常",
        "Manage access": "訪問管理",
        "Branches": "分支",
        "Tags": "標籤",
        "Webhooks": "Web 鉤子",
        "Environments": "環境",
        "Security & analysis": "安全性與分析",
        "Deploy keys": "部署密鑰",
        "Add deploy key": "添加部署密鑰",
        "Actions secrets": "操作機密",
        "Dependabot secrets": "Dependabot 機密",
        "Configure email notifications": "配置郵件通知",
        "Community Standards": "社區準則",
        "General Organization Settings": "常規組織設置",
        "Member privileges": "成員權限",
        "Teams": "團隊",
        "Trending repositories on GitHub today": "今日熱門倉庫",
        "Trending repositories on GitHub this week": "本週熱門倉庫",
        "Trending repositories on GitHub this month": "本月熱門倉庫",
        "Repository defaults": "倉庫默認值",
        "Repository search results": "倉庫搜索結果",
        "Runners": "運行器",
        "Runner Groups": "運行器組",
        "Packages": "軟體包",
        "Package": "軟體包",
        "Payment Information": "支付信息",
        "Security": "安全",
        "Verified & approved domains": "經驗證和批准的域名",
        "Add a Pages verified domain": "添加一個經驗證的 GitHub Pages 域名",
        "Third-party application access policy": "第三方應用訪問策略",
        "Audit log": "審計日誌",
        "Deleted Repositories": "已刪除的倉庫",
        "GitHub Publisher Verification": "GitHub 發佈者驗證",
        "Notifications": "通知",
        "Confirm your account recovery settings": "確認您的賬戶恢復設置",
        "Your stars": "我的星標",
        "Your starred repositories": "我的星標倉庫",
        "Your starred topics": "我的星標主題",
        "Register for the GitHub Developer Program": "註冊 GitHub 開發者計劃",
        "Codespaces": "程式碼空間",
        "Codespace Templates": "程式碼空間模版",
        "Create new codespace": "創建程式碼空間",
        "Error": "錯誤",
        "Discover gists · GitHub": "探索程式碼片段 · GitHub",
        "Explore GitHub Sponsors": "探索 GitHub 贊助者",
        "Actions Usage Metrics": "操作使用情況",
        "Actions usage metrics": "操作使用情況",
        "Fine-grained Personal Access Tokens": "精細化的個人訪問令牌",
        "Import repository": "導入倉庫",
        "Explore GitHub": "探索 GitHub",
        //"Rate limit · GitHub": "速率限制 · GitHub",
        //"GitHub: Let’s build from here · GitHub": "GitHub: 讓我們從這裡開始",
        "GitHub · Build and ship software on a single, collaborative platform · GitHub": "GitHub · 在單一協作平臺上構建和發佈軟體",
        "GitHub · Build and ship software on a single, collaborative platform": "GitHub · 在單一協作平臺上構建和發佈軟體",
        "Topics on GitHub · GitHub": "GitHub 上的主題",
        "Code security": "程式碼安全",
        "Deploy keys": "部署密鑰",
        "Actions Performance Metrics": "操作數據看板",
        "Actions performance metrics": "操作數據看板",
        "GitHub Sitemap · GitHub": "GitHub 網站地圖",
        "Code search results": "程式碼搜索結果",
        "Enterprises": "企業版",
        "Blocked users": "黑名單",
        "New conversation · GitHub Copilot": "新聊天 · GitHub Copilot",
        "Models · GitHub Marketplace": "模型 · GitHub 市場",
        "GitHub Education": "GitHub 教育",
        "GitHub Student Developer Pack - GitHub Education": "學生開發包 - GitHub 教育",
        "Get your GitHub benefits - GitHub Education": "獲取福利 - GitHub 教育",
        "Signup to GitHub Copilot": "註冊 GitHub Copilot",
        "Device Activation": "設備激活",
        "Spending Limit": "支付限額",
        "Autolink references": "自動鏈接引用",
        "Add autolink reference": "添加自動鏈接引用",
        "Billing Overview": "賬單概覽",
        "Billing Usage": "計費用量",
        "Budgets": "預算",
        "Code Security": "程式碼安全性",
        "New Fine-grained Personal Access Token": "新建精細化個人訪問令牌",
        "Coding agent": "編程智能體",
        "Get Started With GitHub Discussions": "開始使用 GitHub 討論",
        "SSH and GPG keys": "SSH 和 GPG 密鑰",
        "MCP Registry": "MCP 互聯",
        "User repositories": "用戶倉庫",
    },
    "regexp": [ // 正則翻譯
        [/Authorized OAuth Apps/, "授權的 OAuth 應用"],
        [/Authorized GitHub Apps/, "授權的 GitHub 應用"],
        [/Installed GitHub Apps/, "已安裝的 GitHub 應用"],
        [/Accessibility/, "無障礙"],
        [/Environments/, "環境"],
        [/New repository/, "新倉庫"],
        [/([^ ]+) \((.+)\) \/ Repositories/, "$1 / 倉庫"], // github 賬戶名/ 成就
        [/([^ ]+) \((.+)\) \/ Starred/, "$1($2) / 星標"], // github 賬戶名（暱稱）/ 星標
        [/Repositories/, "倉庫"],
        [/Starred/, "星標頁面"],
        [/starred repositories/, "星標倉庫"],
        [/starred topics/, "星標主題"],
        [/starred/, "星標"],
        [/Commits · ([^ ]+)/, "提交 · $1"],
        [/New Issue/, "新建議題"],
        [/Issues?/, "議題"],
        [/Pull (R|r)equests?/, "拉取請求"],
        [/Actions secrets · ([^ ]+)/, "操作機密 · $1"],
        [/Actions settings · ([^ ]+)/, "操作設置 · $1"],
        [/Actions/, "操作"],
        [/Projects/, "專案"],
        [/Packages?/, "軟體包"],
        [/Settings · Rulesets/, "設置 · 規則集"],
        [/Security Overview/, "安全概述"],
        [/Security Policy/, "安全政策"],
        [/Security Advisories/, "安全公告"],
        [/Dependabot alerts/, "Dependabot 警報"],
        [/Pulse/, "統計"],
        //[/Contributors to/, "貢獻者 ·"],
        [/Dashboard/, "儀表板"],
        [/Deployments/, "部署"],
        [/Community/, "社區"],
        [/Traffic/, "流量"],
        [/Commit Activity/, "提交活動"],
        [/Code frequency/, "程式碼頻率"],
        [/Created/, "已創建"],
        [/Dependencies/, "依賴項"],
        [/Network Dependents/, "網絡依賴者"],
        [/Network Graph/, "網絡圖"],
        [/Revisions/,"修訂"],
        [/GitHub Skills Quickstart Guide/, "GitHub 技能快速入門指南"],
        [/Skills/, "技能"],
        [/Sponsoring/, "捐助"],
        [/Stargazers/, "追星者"],
        [/Forks?/, "複刻"],
        [/Settings · Tags · ([^ ]+)/, "設置 · 標籤 · $1"],
        [/Tags?/, "標籤"],
        [/Edit release/, "編輯發行版"],
        [/Releases?/, "發行版"],
        [/Draft Advisory/, "安全公告草案"],
        [/Code scanning alerts/, "程式碼掃描警報"],
        [/Repository topics/, "倉庫主題"],
        [/Scheduled reminders/, "定時提醒"],
        [/Sponsorship Log/, "贊助日誌"],
        [/Sponsor @([^ ]+) on GitHub Sponsors/, "在 GitHub 上贊助 $1"],
        [/OAuth applications/, "OAuth 應用"],
        [/People · Pending Collaborators/, "成員 · 待定協作者"],
        [/Members · People · ([^ ]+)/, "成員 · $1"],
        [/People/, "成員"],
        [/Outside collaborators/, "外部協作者"],
        [/New Discussion/, "新討論"],
        [/Discussions/, "討論"],
        [/Workflow runs/, "工作流運行"],
        [/Webhooks · Settings/, "Web 鉤子 · 設置"],
        [/Add a code of conduct to/, "添加程式碼行為準則到"],
        [/Caches?/, "緩存"],
        [/Runners?/, "運行器"],
        [/Attestations?/, "證書"],
        [/Activit(y|ies)/, "活動"],
        [/Rate limit/, "速率限制"],
        [/Comparing/, "比較"],
        [/History for ([^ ]+)/, "$1 的歷史"],
        [/Compare plans for ([^ ]+)/, "為 $1 比較計劃"],
        [/([^ ]+)’s gists/, "$1 的程式碼片段"],
        [/Secret scanning · ([^ ]+)/, "機密掃描 · $1"],
        [/Dependabot secrets · ([^ ]+)/, "Dependabot 機密 · $1"],
        [/Contributors to ([^ ]+)/, "貢獻者 · $1"],
        [/([^ ]+) repositories^/, "$1 的倉庫"],
        [/Create new page · ([^ ]+) Wiki/, "新建頁面 · $1 的 Wiki"],
        [/Settings · Branches · ([^ ]+)/, "設置 · 分支 · $1"],
        [/Webhooks · Settings · ([^ ]+)/, "Web 鉤子  · 設置 · $1"],
        [/Environments · ([^ ]+)/, "環境 · $1"],
        [/Branches · ([^ ]+)/, "分支 · $1"],
        [/([^ ]+) · GitHub Topics/, "$1 · GitHub 主題"],
        [/New release · ([^ ]+)/, "新發行版 · $1"],
        [/Codespaces secrets · ([^ ]+)/, "程式碼空間機密 · $1"],
        [/Dependabot secrets · ([^ ]+)/, "Dependabot 機密 · $1"],
        [/Invitation to join ([^ ]+)/, "加入 $1 邀請"],
        [/Security Managers for · ([^ ]+)/, "安全管理員 · $1"],
        [/New File at \/ · ([^ ]+)/, "新建文件 · $1"],
        [/Blaming ([^ ]+) at ([^ ]+) · ([^ ]+)/, "追溯 $1（$2） · $3"],
        [/Deleting ([^ ]+)\/([^ ]+) at ([^ ]+) · ([^ ]+)/, "刪除 $3/$2 · $4"], // 簡化部分內容
        [/([^ ]+)'s list \/ (.+)/, "$1 的列表 / $2"],
        [/([^ ]+) \((.+)\) \/ Achievements/, "$1($2) / 成就"], // github 賬戶名（暱稱）/ 成就
        [/Teams · ([^ ]+)/, "團隊 · $1"],
        [/Create new team · ([^ ]+)/, "新建團隊 · $1"],
        ["_regexp_end", "end"]
    ],
};

I18N["zh-TW"]["public"] = { // 公共區域翻譯
    "static": { // 靜態翻譯
        // 錯誤頁面
            "Find code, projects, and people on GitHub:": "在 GitHub 上查找程式碼、專案和人員：",
            "Access has been restricted": "訪問被限制",
                "You have triggered a rate limit.": "您已觸發速率限制。",
                "Please wait a few minutes before you try again;": "請稍等幾分鐘再重試；",
                "in some cases this may take up to an hour.": "在某些情況下，這可能最多需要一個小時。",
            "No server is currently available to service your request.": "當前服務器無法為您的請求提供服務。",
            "This page is taking too long to load.": "此頁面加載時間過長。",
            "We had issues producing the response to your request.": "我們在響應您的請求時遇到了問題。",
            "Sorry about that. Please try refreshing and contact us if the problem persists.": "對此我們很抱歉。請嘗試刷新，如果問題仍然存在，請聯繫我們。",
            "Error": "錯誤",
            "Looks like network is down!": "看起來網絡未連接！",
            "Contact Support": "聯繫 GitHub 支持",
            "GitHub Status": "GitHub 狀態",

        // 底部紅條
            "You can’t perform that action at this time.": "此時無法執行該操作。",

        // 速率限制 - 短時間頻繁訪問網頁，至少包括 https://github.com/issues
            "Whoa there!": "請停一下！",
            "You have exceeded a secondary rate limit.": "您已經超出次要速率限制。",
            "Please wait a few minutes before you try again;": "請稍等幾分鐘再重試；",
            "in some cases this may take up to an hour.": "在某些情況下，這可能最多需要一個小時。",

        // 議題、拉取請求、討論浮動信息卡（在任一引用這些鏈接的頁面都會出現
            "You opened this issue": "您打開了這個議題",
            "You opened this pull request": "您打開了這個拉取請求",
            "You commented on this issue": "您對此議題發表了評論",
            "You commented on and opened this issue": "您打開了這個議題並發表評論",
            "You commented on this pull request": "您對此拉取請求發表了評論",
            "You commented on and opened this pull request": "您打開了這個拉取請求並發表評論",
            "You were mentioned on and commented on this issue": "您在此議題上被提及並發表評論",
            "You were mentioned on and commented on this pull request": "您在此拉取請求上被提及並發表評論",
            "You were mentioned on and opened this pull request": "您被提及並打開了此拉取請求",
            "You are assigned to this pull request": "您被指派處理此拉取請求",
            "You are assigned to and opened this pull request": "您打開並被指派處理此拉取請求",
            "You left a review": "您已評論",
            "Changes requested": "請求更改", // 拉取請求
            "Review required": "請求審查", // 拉取請求
            "Approved": "已批准", // 拉取請求
            "replied": "已回覆", // 討論

        // 頂部欄 (未登錄)
            "Platform": "平臺",
                "AI CODE CREATION": "AI 程式碼生成",
                    // Copilot
                        "Write better code with AI": "藉助 AI 寫出更好的程式碼",
                    // Spark
                        "Build and deploy intelligent apps": "構建和部署智能應用",
                    "GitHub Models": "GitHub 模型",
                        "Manage and compare prompts": "管理和比較提示詞",
                    "MCP Registry": "MCP 互聯",
                        "Integrate external tools": "集成外部工具",
                "DEVELOPER WORKFLOWS": "開發者工作流",
                    // 操作
                        "Automate any workflow": "自動化任何工作流程",
                    // 程式碼空間
                        "Instant dev environments": "即時開發環境",
                    // 議題
                        "Plan and track work": "計劃和追蹤工作",
                    "Code Review": "程式碼審查",
                        "Manage code changes": "管理程式碼更改",
                "APPLICATION SECURITY": "應用安全",
                    "GitHub Advanced Security": "GitHub 高級安全",
                        "Find and fix vulnerabilities": "查找並修復漏洞",
                    "Code security": "程式碼安全",
                        "Secure your code as you build": "邊開發邊保障程式碼安全",
                    "Secret protection": "密鑰保護",
                        "Stop leaks before they start": "在洩露發生前就阻止它們",

                "EXPLORE": "探索",
                    "Why GitHub": "為什麼選擇 GitHub",
                    "Changelog": "更新日誌",
                    "GitHub Marketplace": "GitHub 市場",

                "View all features": "查看所有功能",

            "Solutions": "解決方案",
                "BY COMPANY SIZE": "企業規模",
                    "Enterprises": "企業",
                    "Small and medium teams": "中小團隊",
                    "Startups": "初創公司",
                    "Nonprofits": "非盈利組織",
                "BY USE CASE": "使用案例",
                    "App Modernization": "應用現代化",
                    "DevSecOps": "開發安全運維",
                    "DevOps": "開發運維",
                    "CI/CD": "持續集成/持續部署",
                    "View all use cases": "查看所有使用案例",
                "BY INDUSTRY": "工業",
                    "Healthcare": "健康護理",
                    "Financial services": "金融服務",
                    "Manufacturing": "製造業",
                    "Government": "政府",
                    "View all industries": "查看所有工業",
                "View all solutions": "查看所有解決方案",

            "Resources": "資源",
                "EXPLORE BY TOPIC": "按主題探索",
                    "Software Development": "軟體開發",
                    "View all topics": "查看所有主題",
                "EXPLORE BY TYPE": "按類型探索",
                    "Customer Stories": "客戶案例",
                    "Customer stories": "客戶案例",
                    "Events & webinars": "活動與網絡研討會",
                    "Ebooks & reports": "電子書與報告",
                    "Business insights": "商業洞察",
                    "GitHub Skills": "GitHub 技能課程",
                "SUPPORT & SERVICES": "支持與服務",
                    "Partners": "合作洽談",
                    "Customer support": "客戶支持",
                    "Community forum": "社區論壇",
                    "Trust center": "信任中心",

            "Open Source": "開源",
                "COMMUNITY": "社區",
                    "GitHub Sponsors": "GitHub 贊助者",
                        "Fund open source developers": "資助開源開發人員",
                "PROGRAMS": "專案",
                    "Security Lab": "安全實驗室",
                    "Maintainer Community": "維護者社區",
                    "Accelerator": "加速器計劃",
                    "Archive Program": "存檔計劃",
                "REPOSITORIES": "倉庫",
                    "Topics": "主題",
                    "Trending": "趨勢",
                    "Collections": "集合",

            "Enterprise": "企業",
                "ENTERPRISE SOLUTIONS": "企業級解決方案",
                    "Enterprise platform": "企業平臺",
                        "AI-powered developer platform": "AI 驅動的開發者平臺",
                "AVAILABLE ADD-ONS": "可選附加組件",
                    // GitHub 高級安全
                        "Enterprise-grade security features": "企業級安全功能",
                    "Copilot for Business": "Copilot 企業版",
                        "Enterprise-grade AI features": "企業級 AI 功能",
                    "Premium Support": "高級支持",
                        "Enterprise-grade 24/7 support": "企業級 24 小時全天候支持",
            "Pricing": "價格",
            "Search": "搜索",
            "Sign in": "登錄",
            "Sign up": "註冊",

        // 搜索欄
            "Search or jump to...": "搜索或跳轉到…",
            "Type": "請鍵入",
            "to search": "去搜索",
            "Command palette": "命令面板",
            "Saved queries": "已保存的搜索",
            "All of GitHub": "整個 GitHub",
            "Autocomplete": "自動完成",
            "Search all of GitHub": "搜索整個 GitHub",
            "Search in this directory": "在文件夾中搜索",
            "Search in this repository": "在該倉庫中搜索",
            "Search in this owner": "在該所有者中搜索",
            "Search in this organization": "在該組織中搜索",
            "Owners": "所有者",
            "Languages": "語言",
            "Search syntax tips": "搜索語法提示",
            "Jump to": "跳轉到",

            "Ask Copilot": "詢問 Copilot",
            "Start a new Copilot thread": "啟動新的 Copilot 對話",

            // 未登錄時
                "Enterprise": "企業",
                "Security": "安全",
                "Pricing": "價格",

        // 左上角下拉欄 (已登錄)
            "Close menu": "關閉菜單",
            "Home": "主頁",
            "Feed": "動態",
            "Issues": "議題",
            "Pull requests": "拉取請求",
            "Projects": "專案",
            "Discussions": "討論",
            "Codespaces": "程式碼空間",
            "Explore": "探索",
            "Marketplace": "市場",
            "MCP registry": "MCP 互聯",

            "Top repositories": "熱門倉庫",
                "Search for repositories": "搜索倉庫",
                "Close search": "關閉搜索",
                // 團隊
                "Search for teams": "搜索團隊",

        // 頂部提示橫幅
            "Don't get locked out of your account.": "不要被鎖定在您的賬戶之外。",
            "Download your recovery codes": "下載您的恢復碼",
            "add a passkey": "添加通行密鑰",
            "so you don't lose access when you get a new device.": "這樣您在登錄新設備時就不會失去訪問權限。",
            "GitHub users are": "GitHub 用戶",  //下半句正則
            "now required": "現在被要求",  //下半句正則
            "Enable 2FA": "啟用 2FA",

            "You only have a single verified email address. We recommend verifying at least one more email address to ensure you can recover your account if you lose access to your primary email.": "您只有一個經過驗證的電子郵件地址。我們建議您至少再驗證一個電子郵件地址，以確保在失去主郵箱訪問權限時可以恢復賬戶。",
            "Email settings": "電子郵件設置",
            "Your recovery codes have not been saved in the past year. Make sure you still have them stored somewhere safe by viewing and downloading them again.": "如果您在過去一年中沒有保存恢復密碼。請確保將其保存在安全的地方，並再次查看和下載。",
                "View recovery codes": "查看恢復碼",
            "You can also": "您也可以",
            "view this object as it appeared at the time of the comment": "查看此對象在評論時的狀態",


        "Your issues": "您的議題",
        "Your pull requests": "您的拉取請求",

        // 右上角通知按鈕提示
            "You have no unread notifications": "您沒有未讀通知",
            "You have unread notifications": "您有未讀通知",

        // 右上角新建按鈕下拉菜單
            "Create new...": "新建…",
            "Create new…": "新建…",
                "New repository": "新建倉庫",
                "Import repository": "導入倉庫",
                "New spark": "新建 spark",
                "New agent task": "新建智能體任務",
                "New codespace": "新建程式碼空間",
                "New gist": "新建程式碼片段",
                "New organization": "新建組織",
                "New project": "新建專案",
                "This organization": "本組織", // 組織
                "New team": "新建團隊", // 組織
                // 新建議題 對話框
                    "Create new issue": "新建議題",
                    "Copy link": "複製鏈接",
                    "Templates and forms": "模板和表單",
                    "Blank issue": "空白議題",
                        "Create a new issue from scratch": "從頭開始創建新議題",

        // 右上角 Copilot 下拉菜單
            "Agents":"智能體",
            "Chat with Copilot": "與 Copilot 聊天",
            "Learn more about Copilot coding agent": "瞭解有關 Copilot 編程智能體的更多信息",
            "Start a new task with Copilot": "使用 Copilot 啟動新任務",
            "Describe a coding task to work on": "描述要完成的編程任務",
            "Open Copilot…": "打開 Copilot…",
                "New conversation in": "新聊天",
                "New conversation": "新聊天",
                    "Assistive": "小窗",
                    "Spaces": "空間",
                    "Immersive": "全屏",
                "Download for": "下載插件",

            "Open agents panel": "打開智能體面板",
                "Start a task with Copilot coding agent": "使用 Copilot 編程智能體開始任務",
                    "Describe your task in natural language. Copilot will work in the background and open a pull request for your review.": "請用自然語言描述您的任務。Copilot 會在後臺工作，並創建一個拉取請求供您審核。",

                "Agent tasks": "智能體任務",
                    "Switch branches": "切換分支",
                        "Filter branches": "查找分支",
                        "default": "默認",

                "Recent tasks": "近期任務",

        // 右上角個人圖標下拉菜單
            "Account switcher": "賬戶切換",
                "Add account": "添加賬戶",
                "Switch account": "切換賬戶",
                "Sign out...": "登出…",
            "Set status": "狀態設置",
            "Profile": "個人資料",
            "Gists": "程式碼片段",

            "Settings": "設置",
            "Copilot settings": "Copilot 設置",
            "Feature preview": "功能預覽",
            "Feature Preview": "功能預覽",
                "Get early access to new features and give feedback": "測試新功能並提交反饋",
                "Help us improve this and make your experience even better.": "幫我們改進此功能，提升您的體驗。",
                "On": "開",
                "Off": "關",
                // 對話框
                "Feature preview dialog": "功能預覽對話框",
                "Enable": "啟用",
                "Enabled": "啟用",
                "Disable": "禁用",
                "Disabled": "禁用",
                "Documentation": "文檔",

                "Colorblind themes": "色盲主題",
                    "Varying by gender and geography, color blindness can affect on average 8% of men and up to 0.5% of women. Our previous colorblind theme has been split into two new themes:": "色盲會因性別和地域的不同而有所不同，平均而言，色盲會影響約 8% 的男性和約 0.5% 的女性。我們之前的色盲主題被分為兩個新主題：",
                    "Light/dark Protanopia & Deuteranopia for red/green color blindness.": "明/暗 - 紅綠色盲主題適用於紅綠色盲。",
                    "Light/dark Tritanopia for blue/yellow color blindness.": "明/暗 - 藍色盲主題適用於藍黃色盲。",
                "Command Palette": "命令面板",
                    "Quickly navigate and jump between your organizations or repositories and search recent issues, pull requests, projects and more with the new command palette. You can also execute time saving commands all without lifting your fingers off the keyboard!": "使用新的命令面板，可以快速導航並跳轉到您所在的組織或倉庫，並搜索最近的議題、拉取請求、專案等等。您還可以執行節省時間的命令，而無需將手指從鍵盤上移開！",
                    "To open the command palette:": "打開命令面板：",
                        "other:": "其他：",
                "Organization Custom Instructions": "組織自定義指令",
                    "Organization administrators can apply custom instructions across all Copilot chats in github.com.": "組織管理員可以在 GitHub.com 的所有 Copilot 聊天中應用自定義指令。",
                "New Dashboard Experience": "新儀表板體驗",
                    "The updated home dashboard introduces enhanced agent workflows, making it easier to create and manage agent sessions, issues, and pull requests directly from your personalized dashboard. Once enabled, please refresh to see the changes.": "更新後的主頁儀表板引入了增強的智能體工作流，使您可以更輕鬆地直接從個性化儀表板創建和管理智能體會話、議題和拉取請求。啟用後，請刷新以查看更改。",
                "Rich Jupyter Notebook Diffs": "Jupyter Notebook 的豐富差異視圖",
                    "Enables rich diffs of Jupyter Notebooks in pull requests": "在拉取請求中啟用 Jupyter Notebook 的豐富差異視圖",
                    "Note: commenting on rich diff views of notebooks is not yet supported": "注意：尚不支持對 Jupyter Notebook 的豐富差異視圖進行評論",
                "New Files Changed Experience": "新版文件更改體驗",
                    "Feature enabling the new Files Changed Page": "啟用新版更改的文件頁",
                "Slash Commands": "斜槓命令",
                    "Slash commands make it easier to type more complex Markdown, such as tables, tasklists, and code blocks.": "斜線命令可以讓您更輕鬆地輸入更複雜的 Markdown，如表格、任務列表和程式碼塊。",
                    "Simply type": "只需在議題、拉取請求和討論中鍵入",
                    "on Issues, PRs and Discussions to check out a list of available commands!": "，即可查看可用命令的列表！",
                "Feature disabled.": "功能已禁用。",
                    "Please": "請",
                    "give feedback": "提交反饋",
                    "so we can improve it!": "以便我們加以改進！",
                // 出錯提示
                    "Sorry, something went wrong and we were not able to fetch the feature previews": "對不起，出了點問題，我們無法獲取功能預覽",
            "Appearance": "外觀",
            "Accessibility": "無障礙",
            "Upgrade": "升級",
            "Try Enterprise": "試用企業版",
                "Free": "免費",
            "Sign out": "退出",

        // 狀態設置對話框
        // 出現位置: 個人資料頁, Gist 個人主頁, 倉庫頁右上角個人圖標下拉菜單
            "Edit status": "編輯狀態",
            "What's happening?": "發生了什麼？",

            "Suggestions": "建議",
                "On vacation": "在度假",
                "Out sick": "生病",
                "Working from home": "在家工作",
                "Focusing": "專注中",

            "Busy": "繁忙中",
                "When others mention you, assign you, or request your review, GitHub will let them know that you have limited availability.": "當其他人提及您、指派您或請求您進行評論時，GitHub 會告知他們您很忙。",
                "I may be slow to respond.": "我的回覆可能比較慢。",

            "Clear status": "清除狀態",
                "Never": "永不",
                "in 30 minutes": "30 分鐘",
                "in 1 hour": "1 小時",
                "in 4 hours": "4 小時",
                "after today": "今日之後",
                "after this week": "本週之後",
                "after a month": "本月之後",
                "How long until this status will automatically clear.": "多久後狀態自動清除。",
            "Visible to": "可見",
                "Everyone": "任何人",
                    "Scope status visibility to a single organization.": "將狀態可視範圍擴大到單個組織。",
            "Filter emoji": "篩選表情符號",
                "Search results": "篩選結果",

        // 底部條
            "Terms": "服務條款",
            "Privacy": "隱私",
            "Security": "安全",
            "Status": "狀態",
            "Community": "社區",
            "Docs": "文檔",
            "Contact": "聯繫我們",
            "Manage cookies": "管理 Cookies",
            "Do not share my personal information": "請勿分享我的個人信息",

        // 左側欄底部條
            "About": "關於",
            "Blog": "博客",
            "Manage Cookies": "管理 Cookies",

        // 其他
            "Contact GitHub": "聯繫 GitHub",
            "Training": "培訓",

        // 描述、評論編輯器翻譯
            "Add a comment": "添加評論",
            "Add a body": "添加內容",
            "Write": "撰寫",
                "Use Markdown to format your comment": "使用 Markdown 格式編寫評論",
                "Add your comment here...": "在此添加您的評論…",
                "Add your answer here...": "在此添加您的答覆…", // 具體討論頁
                "Text field is empty": "文本框為空",
            "Preview": "預覽",
                "Nothing to preview": "沒有可預覽的內容。",
                "This file is empty.": "這是一個空文件。",
                "Try again with a file that’s not empty.": "使用非空文件重試。",
            "Leave a comment": "發表評論",
            "Write a reply": "發表回覆", // 具體討論頁
            "Write a comment": "發表評論", // 具體討論頁
            "Suggest an answer": "提出答覆", // 具體討論頁
            "Ask a question, start a conversation, or make an announcement": "提出問題、開始討論或發佈公告", // 新建討論
            "Nothing to preview": "沒有什麼可預覽",
            "This repository has been archived.": "此倉庫已存檔。", // 已存檔倉庫 某個提交的評論框
            "Add review comment": "添加審查意見", // 具體拉取請求 文件審查意見
            "Failed to save comment: Body can't be blank": "保存評論失敗：正文內容不能為空", // 具體拉取請求 文件審查意見
            "Start a review": "開始審查", // 具體拉取請求 文件審查意見
            // 取消按鈕 提醒信息
            "Are you sure you want to discard your unsaved changes?": "您確定要放棄未保存的更改嗎？",

            "Apply Suggestion": "添加建議",
            "Add a title": "添加標題",
                "Title": "標題",
            "Add a description": "添加描述",
                "Add your description here...": "在此添加您的描述…",
                "Add an optional description...": "添加可選描述…",
            "There was an error trying to commit changes: Failed to submit suggested changes": "提交更改時出錯：提交建議更改失敗",

            // 網絡錯誤
                "There was a problem saving your comment. Please try again.": "保存您的評論時出現問題。請再試一次。",

            // 拉取請求 程式碼審查 回覆對話框
                "Add a suggestion, <Ctrl+g>": "添加建議, <Ctrl+g>",
                "Heading": "標題",
                "Bold": "粗體",
                "Italic": "斜體",
                "Quote": "摘引",
                "Link": "鏈接",
                "Menu": "菜單", // Android UA 下出現
                "Numbered list": "有序列表",
                "Unordered list": "無序列表",
                "Task list": "任務列表",
                "Attach files": "附件",
                "Mention": "提及",
                "Reference": "引用",
                "Saved replies": "快速回復",
                    "Select a reply": "選擇回覆",
                    "Create a new saved reply": "創建新的快速回復",
                "Slash commands": "斜槓命令",
                    "Alerts": "警示",
                        "Add a markdown alert to emphasize important information": "添加 MarkDown 警示標記，強調重要信息",
                    "Code block": "程式碼塊",
                        "Insert a code block formatted for a chosen syntax": "插入針對所選語法格式化的程式碼塊",
                    "Details": "詳細信息",
                        "Add a details tag to hide content behind a visible heading": "添加詳情標籤，將內容隱藏在可見標題後面",
                    // "快速回復": "",
                        "Insert one of your saved replies": "插入您快速回復",
                    "Table": "表格",
                        "Add markdown table": "添加 Markdown 表格",
                    "Templates": "模板",
                        "Insert one of your issue templates": "插入您的議題模板",

                    "Slash": "斜槓",
                    // 程式碼塊
                        "No Syntax": "無語法",
                    // 快速回復
                        "No saved replies": "尚無快速回復",
                        "You can create one in your": "您可以創建一個在您的",
                        "settings": "設置",
                    // 表格
                        "Columns": "列",
                        "1 column": "1 列",
                        "2 columns": "2 列",
                        "3 columns": "3 列",
                        "4 columns": "4 列",
                        "5 columns": "5 列",

                        "Rows": "行",
                        "1 row": "1 行",
                        "2 rows": "2 行",
                        "3 rows": "3 行",
                        "4 rows": "4 行",
                        "5 rows": "5 行",

                    // 模板
                        "No issue templates": "尚無議題模板",
                        "Learn more about": "瞭解更多關於",
                        "issue templates": "議題模板",

                // 小屏 插入鏈接 對話框
                    "Insert Link": "插入鏈接",
                    "Link Text": "鏈接文本",
                    "Add": "添加",

            "Attach files by": "通過",
            "dragging & dropping,": "拖放，",
            "selecting or pasting them.": "選擇或粘貼來附加文件。",
            "Markdown is supported": "支持 Markdown 語法",
            "Styling with Markdown is supported.": "支持 Markdown 語法。",
            "Paste, drop, or click to add files": "粘貼、拖放或點擊添加文件",
            "Write with Copilot": "使用 Copilot 撰寫",
            "Type your description here…": "在此輸入描述…",
            "Assignee": "受理人",
            "Label": "標籤",
            "Create more": "添加更多",
            "Start typing to create an item, or type # to select a repository": "開始輸入以創建專案，或輸入 # 選擇倉庫",
            "Uploading your files…": "正在上傳您的文件…",
            // 文件過大
                "This video is too big.": "該影片過大。",
                "Try again": "請上傳",
                "with a file size less than 10MB.": "體積小於10MB的文件",

            "Close issue": "關閉議題", // issue頁 評論框
                "Close as completed": "完成後關閉",
                    "Done, closed, fixed, resolved": "已完成、已關閉、已修復、已解決",
                "Close as not planned": "非計劃中關閉",
                    "Won't fix, can't repro, duplicate, stale": "不會修復，無法重現，重複，陳舊",
                    "Won't fix, can't repro, stale": "不會修復，無法重現，陳舊", // 新版議題頁
                // 因重複而關閉（新版議題頁）
                    "Duplicate of another issue": "重複議題",
            "Close with comment": "評論並關閉", // 議題/拉取請求 評論框
            "Close pull request": "關閉拉取請求", // 拉取請求頁 評論框
            "Reopen discussion": "重新打開討論", // discussion頁 評論框
            "Close discussion": "關閉討論", // discussion頁 評論框
                "Close as resolved": "因解決而關閉",
                    "The discussion has been resolved": "討論已解決",
                "Close as outdated": "因過時而關閉",
                    "The discussion is no longer relevant": "討論不再相關",
                "Close as duplicate": "因重複而關閉",
                    "The discussion is a duplicate of another": "討論與另一個討論重複",
            "Comment": "評論",
            "comment": "評論",
            "Submit new issue": "提交新議題",
            "Comment on this commit": "評論",
            "Close and comment": "提交並關閉",
            "Reopen and comment": "提交並重新打開",
            "Reopen issue": "重新打開議題", // 具體議題
            "Reopen with comment": "重新打開評論", // 具體議題
            "Reopen pull request": "重新打開拉取請求", //具體拉取請求
            "Add single comment": "評論", // 具體提交頁 進行某條程式碼評論
            "Reply": "回覆", // 具體討論頁
            "Answer": "答覆", // 具體討論頁
            "Start discussion": "開始討論", // 新建討論
            "discussion": "討論", // 新建討論
            "discussions": "討論", // 新建討論

            "Spammy": "僅自己可見",
                "This user is marked as spammy. Their comments will onlyshow in staff mode.": "該用戶已被封號，評論僅自己可見。",

        // 添加到清單
            "Add to list": "添加到清單",
                "You don't have any lists yet.": "您尚無任何清單。",
                "Lists": "清單",
                    "Search lists": "搜索清單",
                    "🔮 Future ideas": "🔮 超前想法",
                    "🚀 My stack": "🚀 技術棧",
                    "✨ Inspiration": "✨ 靈感",
                    "No results found.": "未找到結果。",
                "Create list": "創建清單",
                    "Create a list to organize your starred repositories.": "創建一個清單來組織您的星標倉庫。",
                    "⭐️ Name this list": "⭐️ 清單名稱",
                    "Write a description": "簡單描述",
                    // 小貼士
                        "type": "輸入",
                        "to add emoji to the name or description.": "在名稱或描述中添加表情符號",
                    "Lists are currently in beta.": "清單目前處於測試階段。",
                    "Share feedback and report bugs.": "分享反饋意見和報告錯誤。",
                    "Creating...": "創建中…",
                    // 私有
                        "Enabling this makes the list visible only to you.": "啟用此選項將使該列表僅對您可見。",

        // 全局快捷鍵對話框 - 快捷鍵 ? 打開
            "Keyboard shortcuts": "鍵盤快捷鍵",
            "Site-wide shortcuts": "全站快捷鍵",
                "Open command palette": "打開命令面板",
                "Open command palette in command mode": "在命令模式下打開命令面板",
                "Focus search bar": "聚焦搜索欄", // gist
                "Open search bar": "打開搜索欄",
                "Go to notifications": "跳轉到通知",
                "Go to dashboard": "跳轉到儀表板",
                "Go to your issues": "跳轉到議題",
                "Go to your pull requests": "跳轉到拉取請求",
                "Bring up this help dialog": "彈出這個幫助對話框",
                "Move selection down": "向下移動選擇",
                "Move selection up": "向上移動選擇",
                "Toggle selection": "切換選擇",
                "Open selection": "打開選擇",
                "Expand and move focus into focused link's hovercard": "展開並將焦點移至聚焦鏈接的懸浮卡",
            "View all keyboard shortcuts": "查看所有鍵盤快捷鍵",

        // 命令面板 - ctrl k 或 ctrl alt k 打開
            "Clear Command Palette": "清除命令面板",
            "Tip:": "小貼士：",
                "Go to your accessibility settings to change your keyboard shortcuts": "跳轉到您的無障礙設置，以更改您的鍵盤快捷鍵",
                "to search discussions": "搜索討論", // 鍵入 #
                "to search issues": "搜索議題", // 鍵入 #
                "to search pull requests": "搜索拉取請求", // 鍵入 #
                "to search projects": "搜索專案", // 鍵入 !
                "to search people and organizations": "搜索成員和組織", // 鍵入 @
                "to search teams": "搜索團隊", // 鍵入 @
                "to activate command mode": "激活命令模式", // 鍵入 >
                "Type is:issue to filter to issues": "鍵入 is:issue 以篩選議題",
                "Type is:pr to filter to pull requests": "鍵入 is:pr 以篩選拉取請求",
                "Type is:open to filter to open content": "鍵入 is:open 以篩選打開的內容",
                "Type author:@me to search your content": "鍵入 author:@me 以篩選您的內容",
                "for help and tips": "尋求幫助和提示", // 鍵入 ?

            "Pages": "GitHub Pages",
            "Dashboard": "儀表板",
            "Notifications": "通知",
            // "Discussions": "討論",
            "Actions": "操作",
            "Insights": "洞察",
            "Organizations": "組織",
            "Repositories": "倉庫",
            "Packages": "軟體包",
            "Users": "用戶",
            "to jump to": "去跳轉",

            "Top result": "最佳結果",
            "No results matched your search": "沒有與您的搜索相符的結果",
            // [/in ([\w]+/[\w]+)/, "在 $1"],

            // # 模式
                "Search issues and pull requests": "搜索議題和拉取請求",
                "Search issues, pull requests, discussions, and projects": "搜索議題、拉取請求、討論和專案",
                "Issues, pull requests, and discussions": "議題、拉取請求和討論",

            // ! 模式
                "Search projects": "搜索專案",

            // @ 模式
                "Search or jump to a repository": "搜索或跳轉到倉庫",
                "Search or jump to a user, organization, or repository": "搜索或跳轉到用戶、組織或倉庫",

            // / 文件模式
                "Search files": "搜索文件",
                "Files": "文件",

            // > 命令模式
                "Run a command": "運行命令",
                "Run command": "運行命令",
                "Commands": "命令",
                "Global Commands": "全局命令",
                "Type > to filter": "鍵入 > 去篩選",
                "– New repository": "- 新建倉庫",
                "– Import repository": "- 導入倉庫",
                "– New project": "- 新建專案",
                "– New discussion": "- 新建討論",
                "– New organization": "- 新建組織",
                "– New gist": "- 新建程式碼片段",
                "– New issue": "- 新建議題",
                "– New file": "- 新建文件",
                "– Change tab size rendering": "- 切換製表符尺寸",
                "– Switch theme": "- 切換主題",

                "New issue": "新建議題",
                "New discussion": "新建討論",
                "New file": "新建文件",
                "Change tab size rendering": "切換製表符尺寸",
                "Change tab size r...": "切換製表符尺寸",
                    "2 spaces": "2 個空格",
                    "3 spaces": "3 個空格",
                    "4 spaces": "4 個空格",
                    "5 spaces": "5 個空格",
                    "6 spaces": "6 個空格",
                    "7 spaces": "7 個空格",
                    "8 spaces": "8 個空格",
                    "9 spaces": "9 個空格",
                    "10 spaces": "10 個空格",
                    "12 spaces": "12 個空格",
                "Switch theme": "切換主題",
                    "Default dark": "暗 - 默認",
                    "Default light": "亮 - 默認",
                    "Dark dimmed": "昏暗",
                    "Switch theme to dark high contrast": "切換主題為 暗 - 高對比",
                    "Sync with system settings": "與系統設置同步",

            // ? 模式
                "Modes": "模式",
                "Search for": "搜索",
                "across all of GitHub": "在整個 GitHub 中",
                "issues, pull requests, discussions,": "議題、拉取請求、討論",
                "organizations, repositories,": "組織、倉庫",
                "projects": "專案",
                "files": "文件",
                "issues": "議題",
                "pull requests": "拉取請求",
                "organizations": "組織",
                "repositories": "倉庫",
                "users": "用戶",
                "Activate": "激活",
                "command mode": "命令模式",

                "Use filters in issues, pull requests, discussions, and projects": "在議題、拉取請求、討論和專案中使用過濾器",
                "Search your issues, pull requests, and discussions": "搜索您的議題、拉取請求和討論",
                "Filter to pull requests": "篩選拉取請求",
                "Filter to issues": "篩選議題",
                "Filter to discussions": "篩選討論",
                "Filter to projects": "篩選專案",
                "Filter to open issues, pull requests, and discussions": "篩選打開的議題、拉取請求和討論",

            // 議題頁面
                "Edit issue title": "編輯議題標題",
                "Edit issue body": "編輯議題內容",
                "Transfer issue…": "轉移議題…",
                "Delete issue…": "刪除議題…",

        // 公共詞 高頻詞
            "Follow": "關注",
            "Unfollow": "取消關注",
            "Star": "星標",
            "Stars": "星標",
            "Unstar": "已加星標",
            "Starred": "已加星標",
            "Fork": "複刻",
            "Save": "保存",
            "Saving…": "保存中…",
            "Saving...": "保存中…",
            "Save changes": "保存更改",
            "Update": "更新",
            "Updating": "更新中",
            "Updating…": "更新中…",
            "Updating...": "更新中…",
            "Delete": "刪除",
            "Cancel": "取消",
            "Edit": "編輯",
            "Added on": "添加於",
            "Loading": "加載中",
            "Loading…": "載入中…",
            "Loading...": "載入中…",
            "Copy": "複製",
            "Copied!": "✅ 複製成功!",
            "Copy to clipboard": "複製到剪切板",
            "Give feedback": "反饋",
            "Give us your feedback": "向我們提供反饋意見",
            "Download": "下載",
            "View": "查看",
            "Create": "創建",

            "Close": "關閉",
            "Closed": "已關閉",
            "Open": "打開",
            "Reopen": "重新打開",

            "and": "和",
            ", and": "，和",
            "or": "或",
            ", or": "，或",
            "to": "到",
            "by": "由",
            "on": "於",
            "Use": "使用",
            "New": "新",

            "Learn more": "瞭解更多",
            "Learn More": "瞭解更多",
            "Learn more.": "瞭解更多。",
            ",": "，",
            ".": "。",

            "Prev": "上一頁",
            "Previous": "上一頁",
            "Next": "下一頁",

            "Less": "更少",
            "More": "更多",

            "Show more": "顯示更多",
            "Show less": "顯示更少",

            "Load more…": "載入更多…",
            "Loading more…": "載入更多…",
            "Loading more...": "載入更多…",

            // 名詞
                "Public": "公共",
                "Private": "私有",
                "Public archive": "公共存檔",
                "Private archive": "私有存檔",
                "Public template": "公共模板",
                "Public mirror": "公共鏡像",
                "Code": "程式碼",
                "Overview": "概況",
                "Followers": "關注者",
                "Collaborators": "協作者",
                "collaborators": "協作者",
                "Sponsors": "贊助者",
                "Sponsoring": "贊助者",
                "commit": "提交",
                "commits": "提交",
                "Organization": "組織",
                "People": "成員",
                "Teams": "團隊",

            // 相對時間
                "just now": "剛剛",
                "now": "當前",
                "yesterday": "昨天",
                "last month": "上個月",

        // 驗證標記浮動信息
            "This commit was created on GitHub.com and signed with GitHub’s": "此提交在 GitHub.com 上創建並簽名，使用 GitHub 的",
            "This commit was created on GitHub.com and signed with GitHub's": "此提交在 GitHub.com 上創建並簽名，使用 GitHub 的",
            "This commit was created on GitHub.com and signed with GitHub’s verified signature": "此提交在 GitHub.com 上創建並簽名，使用 GitHub 的",
            "This commit was signed with the committer's": "此提交已簽名，使用提交者的",
            "This tag was signed with the committer's": "此標籤已簽署，使用提交者的", // /<user-name>/<repo-name>/releases
            "This commit was signed with the committer’s": "此提交已簽名，使用提交者的",
            "This tag was signed with the committer’s": "此標籤已簽署，使用提交者的", //
            "This commit is signed with the committer’s": "此提交已簽名，使用提交者的",
            "’s contribution has been verified via GPG key.": "的貢獻已通過 GPG 密鑰驗證。",
            "verified signature": "已驗證簽名",
            "The key has expired": "密鑰已過期",
            "This commit is not signed, but one or more authors requires that any commit attributed to them is signed.": "此提交未簽名，但一位或多位作者要求對歸屬於他們的任何提交進行簽名。",
            "We had a problem verifying this signature. Please try again later.": "我們在驗證此簽名時遇到問題。請稍後再試。",
            "We were unable to verify this signature.": "我們無法驗證此簽名。",
            "This user has not yet uploaded their public signing key.": "此用戶尚未上傳其公共簽名密鑰。",

            "GPG key ID:": "GPG 密鑰 ID：",
            "GPG Key ID:": "GPG 密鑰 ID：",
            "SSH key Fingerprint:": "SSH 密鑰指紋：",
            "SSH Key Fingerprint:": "SSH 密鑰指紋：",
            "Learn about vigilant mode": "瞭解警戒模式",
            "The email in this signature doesn’t match the committer email.": "此簽名中的電子郵箱與提交者的電子郵箱不相符。",
            "No user is associated with the committer email.": "提交者的電子郵箱未與用戶相關聯。",

            "Verified": "已驗證",
            "Expired": "已過期",
            "Partially verified": "部分驗證",
                "We cannot verify signatures from co-authors, and some of the co-authors attributed to this commit require their commits to be signed.": "我們無法驗證來自共同作者的簽名，並且此提交的某些共同作者要求對其提交進行簽名。",
            "Unverified": "未驗證",
                "Upload your public signing GPG key": "上傳您的公共簽名 GPG 密鑰",
                "to verify your signature.": "以驗證您的簽名。",

        // 郵箱驗證提示
            "Please verify your email address to access all of GitHub's features.": "請驗證您的電子郵箱地址以便開啟所有 GitHub 功能。",
            "Configure email settings": "修改電子郵箱設置",
            "Your email was verified.": "您的電子郵箱地址驗證成功！",

        // 標籤提示
            "New feature or request": "新功能或要求",

        // 更換新手機, 要求重新下載恢復碼的全局提醒
            "Don't get locked out - if you get a new phone this season, be sure to transfer your authenticator app data to the new phone. Enable cloud back up if your authenticator app supports it and consider": "不要被鎖在門外——如果您在這個季節買了一部新手機，請務必將您的身份驗證器應用數據傳輸到新手機。如果您的身份驗證器應用支持雲備份，請啟用它並考慮",
            "redownloading your recovery codes": "重新下載您的恢復碼",
            ", just to be safe.": "，以確保安全。",

        // 刷新會話提示條
            "You signed in with another tab or window.": "您使用其他標籤頁或窗口登錄。",
            "Reload": "重新加載",
            "to refresh your session.": "以刷新您的會話",

        // Cookie 設置
            "Manage cookie preferences": "管理 Cookie 偏好設置",
            "Most GitHub websites use cookies. Cookies are small text files placed on your device to store data so web servers can use it later. GitHub and our third-party partners use cookies to remember your preferences and settings, help you sign in, show you personalized ads, and analyze how well our websites are working. For more info, see the Cookies and similar technologies section of the": "大多數 GitHub 網站都使用 Cookie。Cookie 是保存在您的設備上的小型文本文件，用於存儲數據，以便 Web 服務器稍後使用。GitHub 和我們的第三方合作伙伴使用 Cookie 來記住您的偏好和設置、幫助您登錄、向您顯示個性化廣告以及分析我們網站的運行情況。有關更多信息，請參閱隱私聲明中的",
            "Privacy Statement": "Cookie 和類似技術部分",
            "Accept": "接受",
            "Reject": "拒絕",
            "Reset all": "重置全部",
            "Required": "必要的",
            "GitHub uses required cookies to perform essential website functions and to provide the services. For example, cookies are used to log you in, save your language preferences, provide a shopping cart experience, improve performance, route traffic between web servers, detect the size of your screen, determine page load times, improve user experience, and for audience measurement. These cookies are necessary for our websites to work.": "GitHub 使用必需的 Cookie 來執行基本網站功能並提供服務。例如，Cookie 用於登錄、保存您的語言偏好、提供購物車體驗、提高性能、在 Web 服務器之間路由流量、檢測屏幕大小、確定頁面加載時間、改善用戶體驗以及用於受眾測量。這些 Cookie 是我們網站正常運行所必需的。",
            "Analytics": "分析",
            "We allow third parties to use analytics cookies to understand how you use our websites so we can make them better. For example, cookies are used to gather information about the pages you visit and how many clicks you need to accomplish a task. We also use some analytics cookies to provide personalized advertising.": "我們允許第三方使用分析性 Cookie 來了解您如何使用我們的網站，以便我們改進網站。例如，Cookie 用於收集有關您訪問的頁面以及完成任務所需的點擊次數的信息。我們還使用一些分析性 Cookie 來提供個性化廣告。",
            "Social Media": "社交媒體",
            "GitHub and third parties use social media cookies to show you ads and content based on your social media profiles and activity on GitHub's websites. This ensures that the ads and content you see on our websites and on social media will better reflect your interests. This also enables third parties to develop and improve their products, which they may use on websites that are not owned or operated by GitHub.": "GitHub 和第三方使用社交媒體 Cookie 根據您的社交媒體個人資料和 GitHub 網站上的活動向您顯示廣告和內容。這可以確保您在我們的網站和社交媒體上看到的廣告和內容將更好地反映您的興趣。還使第三方能夠開發和改進它們的產品，它們可能會在不由 GitHub 擁有或運營的網站上使用這些產品。",
            "Advertising": "廣告",
            "In addition, GitHub and third parties use advertising cookies to show you new ads based on ads you've already seen. Cookies also track which ads you click or purchases you make after clicking an ad. This is done to show you ads that are more relevant to you and for business purposes with our advertising partners. For example, cookies are used to detect when you click an ad and to show you ads based on your social media interests and website browsing history.": "此外，GitHub 和第三方使用廣告 Cookie 根據您已經看過的廣告向您顯示新廣告。Cookie 還會跟蹤您點擊的廣告或點擊廣告後進行的購買。這樣做是為了向您顯示與您更相關的廣告，並用於與我們的廣告合作伙伴開展業務。例如，Cookie 用於檢測您何時點擊廣告，並根據您的社交媒體興趣和網站瀏覽歷史記錄向您顯示廣告。",

        // 日曆
            "Jan": "1月",
            "Feb": "2月",
            "Mar": "3月",
            "Apr": "4月",
            "May": "5月",
            "Jun": "6月",
            "Jul": "7月",
            "Aug": "8月",
            "Sep": "9月",
            "Oct": "10月",
            "Nov": "11月",
            "Dec": "12月",

            "January"   : "1月",
            "February"  : "2月",
            "March"     : "3月",
            "April"     : "4月",
            "June"      : "6月",
            "July"      : "7月",
            "August"    : "8月",
            "September" : "9月",
            "October"   : "10月",
            "November"  : "11月",
            "December"  : "12月",

            "Sun"  : "週日",
            "Mon"  : "週一",
            "Tue"  : "週二",
            "Wed"  : "週三",
            "Thu"  : "週四",
            "Fri"  : "週五",
            "Sat"  : "週六",

        // 語言名稱（僅適配熱門語言
            "Arabic": "阿拉伯文",
            "Chinese": "中文",
            "English": "英文",
            "French": "法文",
            "German": "德文",
            "Greek, Modern": "希臘文",
            "Italian": "意大利文",
            "Japanese": "日文",
            "Korean": "韓文",
            "Latin": "拉丁文",
            "Portuguese": "葡萄牙文",
            "Russian": "俄文",
            "Sichuan Yi, Nuosu": "彝文", // 存疑
            "Spanish, Castilian": "西班牙文",
            "Thai": "泰文",
            "Tibetan": "藏文",
            "Vietnamese": "越南文",
            "Zhuang, Chuang": "壯文", // 存疑

        // Copilot 窗口
            // 頂部
            "All repositories": "所有倉庫",
            "Back": "返回",
            "Conversation options": "選項",
                "Enable custom instructions": "啟用個人指導",
                "Disable custom instructions": "禁用個人指導",
                "Personal instructions": "個人指導",
                    "Set up Copilot to align with your workflows and preferences. These instructions will only impact your personal conversation.": "設置 Copilot 以符合您的工作流程和偏好。這些指導僅影響您的個人對話。",
                    "Your instructions": "您的指導",
                        "Role": "角色",
                        "Communication": "通信",
                        "Code preferences": "程式碼偏好",
                    "characters": "字符",
                "Delete conversation": "刪除對話",
                "View all conversations": "查看全部對話",
                    "Active conversations": "最近對話",
                    "All conversations": "所有對話",
                    // 刪除
                        "Are you sure? This can’t be undone.": "您確定嗎？此操作無法撤銷。",
            "Continue in immersive": "全屏對話",
            "Close chat": "關閉",

            "public": "公共",
            "repository": "倉庫",

            "Ask Copilot": "詢問 Copilot",
                "Select a repository to get started. Ask questions about your codebase to get answers fast and learn your way around.": "選擇一個倉庫即可開始。詢問有關程式碼庫的問題，以快速獲得答案並瞭解相關知識。",
                "uses AI. Check for mistakes.": "使用 AI。請檢查錯誤。",
            "Search repositories to chat about": "搜索要討論的倉庫",
            "Recent repositories": "最近訪問",
            "General purpose chat": "普通對話",

            "Loading Conversation": "加載中",
            "Chatting about code and programming": "討論關於程式碼和編程",
            // 對話框
            "Ask about the repository:": "詢問關於此倉庫的信息：",
            "Ask about the tree comparison:": "詢問關於比較的信息：",
            "How can I help you?": "有什麼可以幫忙？",
            "Attach": "附件",
            "Attach files or symbols": "附加文件或符號",
                "Fetching files, folders, and symbols…": "正在獲取文件（夾）和符號…",
            "Add an extension": "添加擴展",
                //"Files and symbols…": "文件和符號…",
                "Files, folders, and symbols": "文件（夾）和符號…",
                    "First attach a repository": "請先附加倉庫",
                    "Select files, folders, and symbols": "選擇文件（夾）和符號",
                    "Choose a repository to browse for files, folders, and symbols.": "選擇倉庫以瀏覽文件（夾）和符號。",
                    //"Attach files and symbols": "附加文件和符號",
                        //"Choose which files and symbols you want to chat about. Use fewer references for more accurate responses.": "選擇您想要討論的文件和符號。使用較少的參考資料即可獲得更準確的回覆。",
                        "Choose what you want to chat about. Use fewer references for more accurate responses.": "選擇您想要討論的內容。使用較少的參考資料即可獲得更準確的回覆。",
                        "Search files and symbols": "搜索文件和符號",
                        "Current attachments": "當前附件",
                        "Symbols": "符號",
                "Repository…": "倉庫…",
                    "Attach a repository": "附加倉庫",
                        "Search repositories": "搜索倉庫",
                        "Fetching repositories…": "正在獲取倉庫",
                "Repository": "倉庫",
                "Repositories…": "倉庫…",
                    "Select a repository": "選擇倉庫",
                    "Select repositories": "選擇倉庫",
                        "Choose repositories to chat about.": "選擇以聊天",
                        "Choose a repository to chat about.": "選擇以聊天",
                "Remove topic": "移除主題",
                "Add repositories, files, and spaces": "添加倉庫、文件和空間",
                "Upload from computer": "上傳本機文件",
                "Files and folders": "文件和文件夾",
                "Spaces…": "空間…",
                "Create your first space": "創建您的第一個空間",
                "Extensions…": "擴展…",
                "Extensions": "擴展",
                    "Chat with your favorite tools and services": "使用您最喜歡的工具和服務聊天",
                    "Browse the marketplace to find extensions for the tools and services you rely on": "瀏覽市場以查找您所依賴的工具和服務的擴展",
                    "Browse marketplace": "前往市場",
            "Add attachment": "添加附件",
            "Remove topic": "移除主題",
            "Convert to file": "轉成文件",
            "Remove": "移除",
            "Attachments options": "附件選項",
                "Remove attachments": "移除附件",
            "Send now": "發送",
            "Stop response": "停止響應",
            // 反饋
            "Rate your experience": "反饋",
            // 四個表情
                "Love it": "優",
                "It’s ok": "良",
                "Not great": "中",
                "Hate it": "差",

            "Tell us what you liked or what could be better": "告訴我們您喜歡什麼或可以改進的地方",

            // 響應狀態
                "Copilot is responding…": "Copilot 響應中…",
                "creating plan": "創建計劃中",
                "getting data": "獲取數據中",
                "Using the GitHub API to search pull requests": "正在使用 GitHub API 搜索拉取請求",
                "Using the GitHub API to get latest release": "正在使用 GitHub API 獲取最新發行版",
                    "Copilot used the": "Copilot 已使用",
                    "Issue API": "議題 API",
                    "tool": "工具",

            // 聊天內容 - 創建拉取請求
                "Are you sure?": "您確定嗎？",
                    "Are you sure you wish to execute the \"Create pull request with Copilot coding agent\" tool?": "您確定要執行“使用 Copilot 編程智能體創建拉取請求”工具嗎？",
                    "Allow": "允許",
                    "Dismiss": "拒絕",

                "accepted": "允許",
                    "the action": "此操作",

            // 引用
                "More reference options": "更多引用選項",
                    "Attach to chat": "附加至聊天",
                    "Raw": "源碼",
                    "Show content": "顯示內容",
                        "above": "上方",
                        "below": "下方",
                    "Reference details": "引用信息",
                        "contributor": "貢獻者",
                        "contributors": "貢獻者",
                        "updated": "更新於",

            // 報錯
                "Copilot was interrupted before it could finish this message.": "Copilot 在完成此消息之前被中斷。",

            "Please don’t include sensitive, confidential, or personal data. Your anonymous feedback helps us improve our services in line with our": "請不要包含敏感、機密或個人數據。您的匿名反饋有助於我們改進服務，根據",
            "Privacy Policy": "隱私政策",
            "Send": "發送",
            "Task": "任務",
            "Create task": "創建任務",
            "uses AI. Check for mistakes.": "使用 AI。請檢查錯誤。",

            "Copy code": "複製程式碼",
            "Copied!": "複製成功！",

            "Good response": "點贊",
                "positive feedback submitted": "已提交正面反饋",
            "Bad response": "點踩",
            "Retry": "重試",

            "Give additional feedback": "提交額外反饋",
                "Would you like to participate in our research?": "您願意參與我們的研究嗎？",
                "You will be compensated for your time": "您的時間將得到補償。",
                "Book a session": "預約",
                "No, thanks": "不，謝謝",

            "Chats": "聊天",
            "No chats yet": "還沒有聊天",
            "Ask Copilot anything on the right to start your first chat.": "在右側詢問 Copilot 任何問題，開始您的第一次聊天。",

            "Agent sessions": "智能體任務",
                "New agent session": "新智能體任務",
                "No agents running": "沒有智能體任務運行",
                "You can now ask Copilot to work on a task for you in the background, creating a pull request which you can review.": "您現在可以請求 Copilot 在後臺處理任務，創建一個拉取請求供您審查。",

            "Explore the latest Copilot launches from Universe ’25": "探索 Universe ’25 的最新 Copilot 啟動",
            "See what’s new": "查看最新內容",
            "Explore GitHub’s latest tools shaping agentic software and developer choice.": "探索 GitHub 最新的工具，塑造智能化的軟體和開發者選擇。",

            "Select a custom agent": "選擇自定義智能體",
                "Create an agent": "新建智能體",

            "Start task": "開始任務",

            "Recent agent sessions": "最近智能體任務",
            "Recent sessions": "最近任務",
                "No sessions found. Create one by sending a prompt above.": "沒有找到任務。通過發送提示來創建一個。",

            // 空間
            "Duplicate": "複製",
            "Duplicate Space": "複製空間",
            "Spaces are now available through the GitHub MCP in VSCode.": "空間現在可以通過 VSCode 的 GitHub MCP 使用。",
            "Install": "安裝",
            "Spaces organize your files, pull requests, issues, and standards so Copilot can give more relevant help for your work.": "空間組織您的文件、拉取請求、議題和標準，以便 Copilot 為您的工作提供更相關的幫助。",
            "Create space": "創建空間",
            "Search...": "搜索…",
            "Shared with me":"與我共享的空間",
            "Start your first space": "開始您的第一個空間",
            "Need help? Read the docs": "需要幫助？閱讀文檔",
            "Generate code": "生成程式碼",
            "Produce code that follows your team's patterns.": "生成符合團隊規範的程式碼。",
            "Share knowledge": "分享知識",
            "Centralize docs so your team can quickly find answers.": "集中管理文檔，讓團隊快速找到答案。",
            "Plan projects": "規劃專案",
            "Create requirements and issues your team can ship.": "創建團隊可交付的需求與議題。",
            "New Space": "新空間",
            "Space name": "空間名稱",
            "Choose a name that describes your project or use case": "選擇一個描述您的專案或用例的名稱",
            "Only you will be able to see this space.": "只有您可以看到此空間。",
            "Create Space": "創建空間",
            "Install MCP": "安裝 MCP",
            "Add a short description to explain this space's purpose (e.g., 'Frontend design system' or 'API docs hub').": "添加一個簡短的描述，解釋此空間的用途（例如，'前端設計系統'或'API 文檔中心'）。",
            "Add files": "添加文件",
            "Define Copilot’s role, focus, and what to avoid in this space. Ex. “You are a [role]. Follow our [framework/patterns] to [type of task]. Avoid [practices or tools] unless specified”.": "定義 Copilot 的角色、焦點和在此空間中避免的內容。例如，“您是 [角色]。遵循我們的 [框架/規範] 來 [任務類型]。除非另有說明，否則避免 [實踐或工具]。”",
            "Sources": "來源",
            "Conversations": "對話",
            "Add sources": "添加來源",
                "Add repository": "添加倉庫",
                "Add files from repository": "從倉庫添加文件",
                "Link files, pull requests, and issues": "鏈接文件、拉取請求和議題",
                "Local": "本地",
                "Upload a file": "上傳文件",
                "Add text content": "添加文本內容",
            "Add sources to get started": "添加來源以開始",
            "Provide files, docs, issues, or repositories so Copilot can give more relevant answers.": "提供文件、文檔、議題或倉庫，以便 Copilot 為您提供更相關的答案。",
            "Start a new conversation in this space by typing in the input box at the top.": "通過在頂部輸入框中輸入，開始在此空間中的新對話。",
            "Space not found": "空間未找到",
            "This URL may be incorrect, you're signed out of your organization, or the Space may have been deleted.": "此 URL 可能不正確，您已退出組織，或空間可能已被刪除。",
            "Manage session": "管理會話",
            "View pull request": "查看拉取請求",
            "View verbose logs": "查看詳細日誌",
            "More actions": "更多操作",
            "Copilot started work": "Copilot 開始工作",
            "Summary": "摘要",
            "Copy head branch name to clipboard": "複製頭分支名稱到剪貼板",

    },
    "regexp": [ // 正則翻譯
        // Copilot 窗口
        [/Chatting about ([^ ]+)/, "關於 $1 的對話"],
        [/Chatting with (\d+) attachments?/, "附加 $1 個附件"],
        //[/Public code references from 4 repositories/, ""],
        [/Public code references from (\d+) repositor(y|ies)/, "公共程式碼，引用自 $1 個倉庫"],
        [/(\d+) references?/, "$1 條引用"],
        [/(\d+) lines? \((\d+) loc\) ·/, "$1 行（$2 非空行）·"],  // loc = 程式碼行（line of code）= 行數 - 空行數（lines - blank lines）
        [/Using the GitHub API to search for issues assigned to user ([^ ]+)/, "使用 GitHub API 搜索分配給用戶 $1 的議題"],
        [/Chatting with (\d+) attachments?/, "附件 $1 個"],
        [/Choose items from ([^ ]+) to chat about. Use fewer references for more accurate responses./, "從 $1 中選擇專案來進行交流。使用較少的引用以獲得更準確的回答。"],
        [/Choose files, folders, and symbols from ([^ ]+) to chat about. Use fewer references for more accurate responses./, "選擇 $1 中的文件（夾）和符號進行聊天。引用越少，回覆越準確。"],
        [/Delete conversation: \"(.+)\"/, "刪除對話：“$1”"],
        // 智能體
        [/Branch: (.+)/, "分支：$1"],
        /**
         * 匹配時間格式
         *
         * 月 日 或 月 日, 年
         * Mar 19, 2015 – Mar 19, 2016
         * January 26 – March 19
         * March 26
         *
         * 不知道是否穩定, 暫時先試用著. 2016-03-19 20:46:45
         *
         * 更新於 2021-10-04 15:19:18
         * 增加 帶介詞 on 的格式，on 翻譯不體現
         * on Mar 19, 2015
         * on March 26
         *
         * 更新於 2021-10-10 13:44:36
         * on 星期(簡寫), 月 日 年  // 個人訪問令牌 有效期
         * on Tue, Nov 9 2021
         *
         * 2021-10-19 12:04:19 融合更多規則
         *
         * 4 Sep
         * 30 Dec 2020
         *
         * on 4 Sep
         * on 30 Dec 2020
         *
         * 2021-11-22 12:51:57 新增 格式
         *
         * 星期(全稱), 月 日, 年 // 倉庫-->洞察-->流量 圖示標識
         * Sunday, November 14, 2021
         *
         * 星期(全稱), 日 月 年// 倉庫-->洞察-->貢獻者 和 倉庫-->洞察-->程式碼頻率
         * Sunday, 4 Jul 2023
         *
         * 更新於 2023-07-04 13:19:21
         * 新增前綴詞, 減少二次組織翻譯
         *  Updated Jul 4            // 儀表板頁面 倉庫標籤卡
         *  Commits on Jul 4, 2023   // 提交頁面、倉庫拉取請求頁->提交卡
         *  Joined on Jul 4, 2023    // 追星者，關注者頁面
         *
         * 更新於 2023-11-11 16:48:02
         * 個人資料頁->貢獻卡
         * 日期帶後綴
         * on March 19th.
         * on August 22nd.
         * on August 21st.
         *
         * Tip:
         * 正則中的 ?? 前面的字符 重複0次或1次
         * 正則中的 ?: 非捕獲符號(即關閉圓括號的捕獲能力) 使用方法 (?: 匹配規則) -->該匹配不會被捕獲 為 $數字
         */
        [/(^Updated (?:on )?|^Commits on |^Joined on |on )?(?:(Sun(?:day)?|Mon(?:day)?|Tue(?:sday)?|Wed(?:nesday)?|Thu(?:rsday)?|Fri(?:day)?|Sat(?:urday)?)?,? )?(?:(\d{1,2})(?:st.|nd.|rd.|th.)?)? ?(Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:tember)?|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?) ?(\d{1,2})?,? (\d{4})?/g, function (all, prefix, week, date1, month, date2, year) {
            var prefixKey = {
                "Updated "   : "更新於 ",
                "Commits on ": "提交於 ",
                "Joined on " : "加入於 ",
                //"Submitted ": "提交於 ", // 教育
            };
            var weekKey = {
                "Sun"  : "週日",
                "Mon"  : "週一",
                "Tue"  : "週二",
                "Wed"  : "週三",
                "Thu"  : "週四",
                "Fri"  : "週五",
                "Sat"  : "週六"
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            // 處理日期
            var date = date1 ? date1 : date2;
            var formattedDate = (year ? year + '年' : '') + monthKey[month.substring(0, 3)] + (date ? date + '日' : '');

            // 處理星期
            var formattedWeek = week ? '，' + weekKey[week.substring(0, 3)] : '';

            // 返回翻譯結果
            return (prefixKey[prefix] ? prefixKey[prefix] : '') + formattedDate + formattedWeek;
        }],
        /**
         * 相對時間格式處理
         *
         * 更新於 2021-11-21 16:47:14
         * 1. 添加 前綴詞
         *    over xxx ago // 里程碑頁面 最後更新時間
         *    about xxx ago // 里程碑頁面 最後更新時間
         *    almost xxx ago // 里程碑頁面 最後更新時間
         *    less than xxx ago // 導出賬戶數據
         * 2. xxx之內的相對時間格式
         *  in 6 minutes // 拉取請求頁面
         *
         * 更新於 2021-11-22 11:54:30
         * 1. 修復 Bug: 意外的擴大了匹配範圍(不帶前綴與後綴的時間) 干擾了帶有相對時間的其他規則
         *  7 months
         */
         [/^just now|^now|^last month|^yesterday|(?:(over|about|almost|in) |)(an?|\d+)(?: |)(second|minute|hour|day|month|year)s?( ago|)/, function (all, prefix, count, unit, suffix) {
            if (all === 'now') {
                return '現在';
            }
            if (all === 'just now') {
                return '剛剛';
            }
            if (all === 'last month') {
                return '上個月';
            }
            if (all === 'yesterday') {
                return '昨天';
            }
            if (count[0] === 'a') {
                count = '1';
            } // a, an 修改為 1

            var unitKey = {second: '秒', minute: '分鐘', hour: '小時', day: '天', month: '個月', year: '年'};

            if (suffix) {
                return (prefix === 'about' || prefix === 'almost' ? '大約 ' : prefix === 'less than' ? '不到 ' : '') + count + ' ' + unitKey[unit] + (prefix === 'over' ? '多之前' : '之前');
            } else {
                return count + ' ' + unitKey[unit] + (prefix === 'in' ? '之內' : '之前');
            }
        }],
        /**
         * 匹配時間格式 2
         *
         * in 5m 20s
         */
        [/^(?:(in) |)(?:(\d+)m |)(\d+)s/,function (all, prefix, minute, second) {
            all = minute ? minute + '分' + second + '秒' : second + '秒';
            return (prefix ? all + '之內' : all);
        }],

        // 其他翻譯
        [/to enable two-factor authentication as an additional security measure. Your activity on GitHub includes you in this requirement. You will need to enable two-factor authentication on your account before ([^ ]+), or be restricted from account actions./, "啟用雙因素身份驗證（2FA）作為額外安全措施。您在 GitHub 上的活動讓您接收到此要求。您將需要在 $1 前啟用雙因素身份驗證，否則會被限制賬戶操作。"],
    ],
    "time-regexp": [ // 時間正則翻譯專項
        /**
         * 匹配時間格式
         *
         * 月 日 或 月 日, 年
         * Mar 19, 2015 – Mar 19, 2016
         * January 26 – March 19
         * March 26
         *
         * 不知道是否穩定, 暫時先試用著. 2016-03-19 20:46:45
         *
         * 更新於 2021-10-04 15:19:18
         * 增加 帶介詞 on 的格式，on 翻譯不體現
         * on Mar 19, 2015
         * on March 26
         *
         * 更新於 2021-10-10 13:44:36
         * on 星期(簡寫), 月 日 年  // 個人訪問令牌 有效期
         * on Tue, Nov 9 2021
         *
         * 2021-10-19 12:04:19 融合更多規則
         *
         * 4 Sep
         * 30 Dec 2020
         *
         * on 4 Sep
         * on 30 Dec 2020
         *
         * 2021-11-22 12:51:57 新增 格式
         *
         * 星期(全稱), 月 日, 年 // 倉庫-->洞察-->流量 圖示標識
         * Sunday, November 14, 2021
         *
         * Tip:
         * 正則中的 ?? 前面的字符 重複0次或1次
         * 正則中的 ?: 非捕獲符號(即關閉圓括號的捕獲能力) 使用方法 (?: 匹配規則) -->該匹配不會被捕獲 為 $數字
         */
        [/(?:on |)(?:(\d{1,2}) |)(?:(Sun(?:day)?|Mon(?:day)?|Tue(?:sday)?|Wed(?:nesday)?|Thu(?:rsday)?|Fri(?:day)?|Sat(?:urday)?), |)(?:(Jan(?:uary)?|Feb(?:ruary)?|Mar(?:ch)?|Apr(?:il)?|May(?:)??|Jun(?:e)?|Jul(?:y)?|Aug(?:ust)?|Sep(?:tember)?|Oct(?:ober)?|Nov(?:ember)?|Dec(?:ember)?)(?:,? |$))(\d{4}|)(\d{1,2}|)(?:,? (\d{4})|)/g, function (all, date1, week, month, year1, date2, year2) {
            var weekKey = {
                "Sun"  : "週日",
                "Mon"  : "週一",
                "Tue"  : "週二",
                "Wed"  : "週三",
                "Thu"  : "週四",
                "Fri"  : "週五",
                "Sat"  : "週六",
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };
            var date = date1 ? date1 : date2;
            var year = year1 ? year1 : year2;
            return (year ? year + '年' : '') + monthKey[month.substring(0, 3)] + (date ? date + '日' : '') + (week ? ', ' + weekKey[week.substring(0, 3)] : '');
        }],
        /**
         * 相對時間格式處理
         *
         * 更新於 2021-11-21 16:47:14
         * 1. 添加 前綴詞
         *    over xxx ago // 里程碑頁面 最後更新時間
         *    about xxx ago // 里程碑頁面 最後更新時間
         *    almost xxx ago // 里程碑頁面 最後更新時間
         *    less than xxx ago // 導出賬戶數據
         * 2. xxx之內的相對時間格式
         *  in 6 minutes // 拉取請求頁面
         *
         * 更新於 2021-11-22 11:54:30
         * 1. 修復 Bug: 意外的擴大了匹配範圍(不帶前綴與後綴的時間) 干擾了帶有相對時間的其他規則
         *  7 months
         */
        [/^just now|^now|^last year|^last month|^last week|^yesterday|(?:(over|about|almost|in) |)(an?|\d+)(?: |)(second|minute|hour|day|month|year|week)s?( ago|)/, function (all, prefix, count, unit, suffix) {
            if (all === 'now') {
                return '現在';
            }
            if (all === 'just now') {
                return '剛剛';
            }
            if (all === 'last year') {
                return '最近 1 年';
            }
            if (all === 'last month') {
                return '上個月';
            }
            if (all === 'last week') {
                return '上週';
            }
            if (all === 'yesterday') {
                return '昨天';
            }
            if (count[0] === 'a') {
                count = '1';
            } // a, an 修改為 1

            var unitKey = {second: '秒', minute: '分鐘', hour: '小時', day: '天', month: '個月', year: '年', week: '周'};

            if (suffix) {
                return (prefix === 'about' || prefix === 'almost' ? '大約 ' : prefix === 'less than' ? '不到 ' : '') + count + ' ' + unitKey[unit] + (prefix === 'over' ? '多之前' : '之前');
            } else {
                return count + ' ' + unitKey[unit] + (prefix === 'in' ? '之內' : '之前');
            }
        }],
        [/(\d+)(y|h|d|w|m)/, function (all, count, suffix) {
            var suffixKey = {y: '年', h: '小時', d: '天', w: '周', m: '個月'};

            return count + ' ' + suffixKey[suffix] + '之前';
        }],
    ],
    "title": {
        "static": {
            "GitHub · Where software is built": "GitHub · 軟體構建的地方",
            "Page not found · GitHub": "找不到頁面 · GitHub",
        },
        "regexp": [],
    },
};

I18N["zh-TW"]["orgs-public"] = { // 組織公共部分
    "static": { // 靜態翻譯
    },
    "regexp": [ // 正則翻譯
        [/Invite someone to/, "邀請加入到組織"],
        [/New team in/, "新建團隊在組織"],
        [/New repository in/, "新建倉庫在組織"],
        [/This organization was marked as archived by an administrator on (.+). It is no longer maintained./, (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `該組織已由管理員於 ${translatedDate} 存檔。不再維護。`;
        }],
        [/You are now a member of ([^ ]+)!/, "您現在是 $1 的成員了！"],
    ],
};

I18N["zh-TW"]["page-dashboard"] = { // 已登錄的首頁 - 儀表板（含組織）
    "static": { // 靜態翻譯
        // 頂部 GPT 聊天窗口
        "Ask anything": "詢問任何事",
        "Send": "發送",
        "Feedback": "反饋",
            "Message": "消息",
            "Tell us your feedback on the new dashboard experience":"告訴我們您對新儀表板體驗的反饋",
            "Please don’t include sensitive, confidential, or personal data. Your feedback helps us improve our services in line with our":"請不要包含敏感、機密或個人信息。您的反饋有助於改進我們的服務",

        // 新版首頁功能區
        "Task": "任務",
        "Create issue": "創建議題",
            "First, create a new draft issue. Then ask for additional information to fill out the issue.":"首先，創建一個新的草稿議題。然後，要求提供更多信息來完善議題。",
            "First, create an issue with sub issues. Then ask for additional information to fill out these issues.":"首先，創建一個包含子議題的議題。然後，要求提供更多信息來完善這些子議題。",
        "Write code": "編寫程式碼",
        "Models": "模型",
            "Create a profile README":"個人資料",
            "Generate a simple calculator":"簡易計算器",
            "Make a Pong game":"乒乓球遊戲",
            "Design a Mermaid architecture overview":"Mermaid 架構預覽",
        // Git
            "Basic Git commands":"基本 Git 命令",
            "Git branching":"Git 分支",
            "Advanced Git commands":"高級 Git 命令",
        // 拉取請求
            "My open pull requests":"我打開的",
            "Summarize my latest PR":"總結最近",

        "Fast and cost-efficient": "快速、經濟高效",
        "Versatile and highly intelligent": "多功能、高智能",
        "Most powerful at complex tasks": "在複雜任務中最強大",
        "Agent sessions": "智能體任務",
        "No sessions found. Try a different filter, or": "沒有找到會話。嘗試不同的過濾器，或",
        "start a session": "開始任務",
        "Agent sessions options": "智能體任務選項",
        "Agent sessions to include": "智能體任務包含",
        "View all": "查看全部",
        "Number of results": "結果數量",
        "Pull request options": "拉取請求選項",
        "Pull requests to include": "拉取請求包含",
            "Authored": "由您創建",
            "Mentioned": "被提及",
            "Review requested": "請求審查",
            "Reviewed": "已審查",
        "Issue options": "議題選項",
        "Issues to include": "議題包含",
            "Assigned to me": "分配給我",
            "Involves me": "涉及我",
        "Open in Copilot chat": "在 Copilot Chat 中打開",
        "Assign to Copilot": "分配給 Copilot",
        "uses AI. Check for mistakes.": "使用 AI。請檢查錯誤。",

            // 選項
                "Task": "任務",
                "Create issue": "創建議題",

            "Models": "模型",
                    "Fast and cost-efficient": "快速、經濟高效",
                    "Versatile and highly intelligent": "多功能、高智能",
                    "Most powerful at complex tasks": "執行複雜任務",

        "Try the new experience": "嘗試新版",
        "Try the new dashboard experience": "試用新儀表板",
        "Switch back": "切回舊版",

        // 新手幫助
        "Learn Git and GitHub without any code!": "瞭解 Git 和 GitHub 無需任何程式碼！",
        "Using the Hello World guide, you’ll create a repository, start a branch,": "使用 Hello World 指南，您將創建一個倉庫，開始一個分支，",
        "write comments, and open a pull request.": "寫評論，並創建一個拉取請求。(教程內容就不翻譯了...)",
        "Let's get started!": "讓我們開始吧！",
        "Hide this notice forever": "永久的隱藏該信息",

        "Welcome to GitHub! What’s next?": "歡迎來到 GitHub！下一步幹什麼？",
        "Create a repository": "創建一個倉庫",
        "Tell us about yourself": "介紹一下您自己",
        "Browse interesting repositories": "瀏覽有趣的倉庫",
        "on Twitter": "在 Twitter 上",

        "You don’t have any repositories yet!": "您目前還沒有任何倉庫！",
        "Create your first repository": "創建您的第一個倉庫",
        "or": "或者",
        "Learn more about Git and GitHub": "瞭解更多關於 Git 和 GitHub 的信息",

        // 教育版
        "Join GitHub Education!": "加入 GitHub 教育！",
            "GitHub Education opens doors to new skills, tools, and a collaborative community eager to drive innovation. Join us and build a foundation for your future in technology.": "GitHub 教育為您打開通往新技能、新工具以及渴望推動創新的協作社區的大門。加入我們，為您的技術未來打下基礎。",
        "Join GitHub Education": "加入 GitHub 教育",

        // 組織
        // [/You’re an owner of the ([^ ]+) organization!/, "您是 $1 組織的所有者！"],
        // [/Create a repository for ([^ ]+)/, "為 $1 創建倉庫"],
        "Welcome to the": "歡迎來到",
        "View your teams": "查看您的團隊",
        "View and create teams": "查看並創建團隊",
        "See all owners": "查看全部所有者",
        "You've been added to the": "您已被添加至",
        "organization.": "組織",
        // [/Edit ([^ ]+)’s settings/, "編輯 $1 的設置"],
        "Return to your personal dashboard": "返回到您的個人儀表板",

        // 已有倉庫的專案
        // 左側欄
        "View organization": "查看組織", // 組織
        "Browse organization's repositories": "瀏覽組織的倉庫", // 組織
        "Top repositories": "置頂倉庫",
        "Top Repositories": "置頂倉庫", // 安卓UA
        "New": "新建",
        "Find a repository…": "搜索倉庫…",
        "Your teams": "您的團隊",
            "You don’t belong to any teams yet!": "您還不屬於任何團隊！",
        "Find a team…": "搜索團隊…",
        "Recent activity": "近期活動",
            "When you take actions across GitHub, we’ll provide links to that activity here.": "當您在 GitHub 上採取行動時，我們會在這裡提供該活動的鏈接。", // 組織

        "Create your first project": "創建您的第一個專案",
            "Ready to start building? Create a repository for a new idea or bring over an existing repository to keep contributing to it.": "準備好開始構建了嗎？為新想法創建一個倉庫或使用現有倉庫繼續為其做出貢獻。",
            "Create repository": "創建倉庫",

        "Forked from": "複刻自", // 複刻倉庫

        // 中間欄
        "Feed": "動態",
        "The home for all developers — including you.": "所有開發者的家園——包括您。",
        "Welcome to your personal dashboard, where you can find an introduction to how GitHub works, tools to help you build software, and help merging your first lines of code.": "歡迎來到您的個人儀表板，在這裡您可以看到關於 GitHub 工作原理的介紹，幫助您構建軟體的工具，以及幫助您合併您的第一行程式碼。",
        "Learn with a tutorial project": "通過教程專案學習",
            "Introduction to GitHub": "GitHub 簡介",
            "Get started using GitHub in less than an hour.": "一個小時內學會如何使用 GitHub。",
            "Create a site or blog from your GitHub repositories with GitHub Pages.": "使用 GitHub Pages 從您的 GitHub 倉庫創建網站或博客。",
            "Code with Copilot": "使用 Copilot 編程",
            "Develop with AI-powered code suggestions using GitHub Copilot, Codespaces, and VS Code.": "使用 GitHub Copilot、程式碼空間和 VS Code 通過 AI 驅動的程式碼建議進行開發。",
            "Hello GitHub Actions": "您好 GitHub Actions",
            "Create a GitHub Action and use it in a workflow.": "創建一個 GitHub Actions 並在工作流中使用它 ",
            "See more tutorial projects": "查看更多的教程專案",
        "Start writing code": "開始編寫程式碼",
            "A repository contains all of your project's files, revision history, and collaborator discussion.": "倉庫包含專案的所有文件、修訂歷史記錄和協作者討論。",
            "Repository name": "倉庫名稱",
            "name your new repository...": "命名您的新倉庫……",
            "Anyone on the internet can see this repository": "任何人都可以看到這個倉庫，您可以選擇誰能提交。",
            "You choose who can see and commit to this repository": "您可以選擇誰可以看和提交到該倉庫。",
            "Create a new repository": "創建新的倉庫",
            "You're seeing this because you haven't created a repository in a while.": "您看到這個是因為您有一段時間沒有創建倉庫了。",
            "You're seeing this because you haven't used repositories, issues, and pull requests recently.": "您看到這個是因為您最近沒有使用倉庫、議題和拉取請求。",
            "Remove from dashboard": "從儀表板中刪除",
            "Repositories that need your help": "這些倉庫需要您的幫助",
            "See more repos with good first issues": "查看更多適合新手提交議題的倉庫",
        "Use tools of the trade": "使用貿易工具",
            "You're seeing this because you haven't opened a pull request in a while.": "您看到這個是因為您有一段時間沒有打開拉取請求了。",
                "Simplify your development workflow with a GUI": "使用 GUI 簡化開發工作流程",
                "Install GitHub Desktop": "安裝 GitHub Desktop",
                "to visualize, commit, and push changes without ever touching the command line.": "來可視化、提交和推送更改，而無需使用命令行。",
            "Get AI-based coding suggestions": "獲取基於 AI 的編碼建議",
                "Try GitHub Copilot free for 30 days,": "免費試用 GitHub Copilot 30 天，",
                "which suggests entire functions in real time, right from your editor.": "它可以直接從您的編輯器實時建議所有函數。",
            "Write code in your web browser": "在您的網絡瀏覽器中編寫程式碼",
                "Use": "使用",
                "the github.dev web-based editor": "基於 github.dev 的網絡編輯器",
                "from your repository or pull request to create and commit changes.": "從您的倉庫或拉取請求中創建和提交更改。",
        "Install a powerful code editor": "安裝一個強大的程式碼編輯器",
            "is a multi-platform code editor optimized for building and debugging software.": "是針對構建和調試軟體進行了優化的多平臺程式碼編輯器。",
        "Set up your local dev environment": "設置本地開發環境",
            "set up Git": "設置 Git",
            ", simplify your dev workflow with": "，簡化您的開發工作流程，使用",
            ", or": "，或",
            "bring GitHub to the command line": "將 GitHub 引入命令行",
        "Get started on GitHub": "開始使用 GitHub",
            "You're seeing this because you haven't used GitHub's core features, yet.": "您看到這個是因為您有一段時間沒有使用過 GitHub 的核心功能了。",
        "Introduce yourself with a profile README": "使用 README 介紹自己",
            "Share information about yourself by creating a profile README, which appears at the top of your profile page.": "通過創建個人資料自述文件（README）來分享有關您自己的信息，該信息將顯示在您的個人資料頁面頂部。",
        "Follow this exercise to try the GitHub flow": "按照此練習嘗試 GitHub 流程",
            "GitHub's “Hello World” tutorial teaches you essentials, where you create your own repository and learn GitHub's pull request workflow for creating and reviewing code.": "GitHub 的 “Hello World” 教程會教您基本知識，您可以在其中創建自己的倉庫並學習 GitHub 用於創建和審查程式碼的拉取請求工作流程。",
            "Try the GitHub flow": "嘗試 GitHub 流程",
        "About version control and Git": "關於版本控制和 Git",
        "Learn about the version control system, Git, and how it works with GitHub.": "瞭解版本控制系統、Git 以及它如何與 GitHub 一起工作。",
        "The GitHub Flow": "GitHub 流程",
        "Adopt GitHub's lightweight, branch-based workflow to collaborate on projects.": "採用 GitHub 的輕量級、基於分支的工作流程來協作處理專案。",

        "One moment please...": "稍等一會兒…",
        "Loading activity...": "載入活動…",
        "All activity": "所有活動",

        "Welcome to the new feed!": "歡迎來到新的動態提要!",
        "We’re updating the cards and ranking all the time, so check back regularly. At first, you might need to follow some people or star some repositories to get started": "我們一直在更新卡片和排名，所以請定期查看。一開始，您可能需要關注一些人或標星一些倉庫才能開始",
        "Send feedback": "發送反饋",

        "Updates to your homepage feed": "主頁動態摘要的更新",
        "We've combined the power of the Following feed with the For you feed so there’s one place to discover content on GitHub. There’s improved filtering so you can customize your feed exactly how you like it, and a shiny new visual design. ✨": "我們將 “關注動態提要” 與 “您的動態提要” 的強大功能結合在一起，讓您在一個地方就能發現 GitHub 上的內容。此外，我們還改進了篩選功能，讓您可以完全按照自己的喜好定製動態提要，並採用全新的視覺設計。 ✨",
        "Learn more": "瞭解更多",

        "Explore GitHub": "探索 GitHub",
            "to receive personalized suggestions.": "以獲取個性化建議。",

        // 提要篩選
        "Filter": "篩選器",
            "Feed filters": "提要篩選器",
            "Events": "事件",
                "Activity you want to see on your feed": "您想在提要上看到的活動",
            "Announcements": "公告",
                "Special discussion posts from repositories": "來自倉庫的特別討論帖",
            "Releases": "發行版",
                "Update posts from repositories": "來自倉庫的更新帖",
            // 贊助
                "Relevant projects or people that are being sponsored": "獲得贊助的相關專案或人員",
            "Stars": "星標",
                "Repositories being starred by people": "被人們標星的倉庫",
            "Repositories": "倉庫",
                "Repositories that are created or forked by people": "由人們創建或複刻的倉庫",
            "Repository activity": "倉庫活動",
                "Issues and pull requests from repositories": "來自倉庫的議題和拉取請求",
            "Follows": "關注",
                "Who people are following": "人們在關注誰",
            "Recommendations": "推薦",
                "Repositories and people you may like": "您可能喜歡的倉庫和人",

            "Include events from starred repositories": "包括來自星標倉庫中的事件",
                "By default, the feed shows events from repositories you sponsor or watch, and people you follow.": "默認情況下，動態提要顯示的事件來自您贊助或關注的倉庫，以及您關注的人。",
            "Reset to default": "重置",
            "Save": "保存",

        "Show all": "顯示所有",

        "Uh oh!": "哎呀！",
        "There was an error in loading the activity feed.": "載入動態提要時發生錯誤。",
        "Reload this page": "重載此頁面",

        // 動態 狀態詞
        "starred": "標星了",
        "created": "創建了",
        "forked from": "複刻自",
        "generated from": "創建自",
        "mirrored from": "鏡像自",
        "forked": "複刻了",
        "from": "來自",
        "for": "",
        "pushed to": "推送到",
        "released": "發佈了",
        "published": "發佈了",
        "started sponsoring": "贊助給",
        "started following": "已關注",
        "you": "您",
        "Updated": "更新於",
        "a repository": "1 個倉庫",
        "has a new repository": "創建了倉庫",
        "created a repository": "創建了倉庫",
        "created a branch in": "創建了一個分支在",
        "in": "分支在",
        "Forked to": "複刻為",
        "of": "",
        "made": "將",
        "public": "設為公共",
        "committed": "提交於",
        "posted a discussion in": "發表討論於",
        "made this repository public": "將此倉庫公開",
        "labeled a pull request": "將標籤添加到拉取請求中",
        "launched their sponsorship page 💖": "推出了他們的贊助頁面 💖",
        //[/and (\d+) more/, "和另外 $1 個"],
        "All reactions": "所有看法",

        "published a release": "發佈發行版",
        "forked a repository": "複刻倉庫",
        "starred a repository": "星標倉庫",
        "sponsored": "贊助了",
        "followed": "關注了",
        "added a repository to": "已將倉庫添加到",
        "contributed to": "貢獻給",
            // 現在會顯示拉取請求狀態
            "Merged": "已合併",

        "your repository": "您的倉庫",

        "Read more": "閱讀更多內容",

        "Subscribe to your news feed": "訂閱您的新聞提要",
        "Subscribe to the": "訂閱", // 組織
        "organization news feed": "組織的新聞提要", // 組織

        //主頁上倉庫3個點
        "Feed item options": "推送選項",
        "You're seeing this because of your activity.": "您看到這個是因為您的活動。",
        "Show less activity like this": "顯示較少這類活動",
        // [/You're seeing this because you collaborated with ([^ ]+)/, "您看到這個是因為您與 $1 有過合作"],
        // [/You're seeing this because you starred ([^ ]+)/, "您看到這個，是因為您標星了 $1"],
        "Unstar this repository": "取消標星此倉庫",
        // [/You're seeing this because you follow ([^ ]+)/, "您看到這個，是因為您關注了 $1"],
        "Unfollow this user": "取消關注此用戶",

        "Contributors": "貢獻者",
        "Report": "舉報",
        "Recommended for you": "為您推薦",
        "Trending repositories": "熱門倉庫",
        "Latest from our changelog":"來自我們的更新日誌",
        "Try the new experience": "嘗試新體驗",
        "See more": "查看更多",
        "Read more": "閱讀更多",
        "You're seeing this based on GitHub-wide trends.": "您看到的是基於 GitHub-wide 的趨勢。",
        "Recommended based on people you follow": "根據您關注的人推薦",
        "has a new discussion in": "有一條新討論，在",
        "Join discussion": "參與討論",
        "Popular among": "很受歡迎",
        "Popular projects among": "熱門專案",
        "people you follow": "在您關注的人中",
        "Sponsor": "贊助",
        "added": "添加",

        // 右側欄
        "Latest changes": "最新變化",
        "View changelog →": "查看更新日誌 →",
        "Explore repositories": "探索倉庫",
        "Explore more →": "探索更多 →",

        "Member statuses": "成員狀態", // 組織

        // 儀表板右上方看板
        "The world’s fair of software is here.": "世界軟體博覽會就在這裡。",
        "The GitHub Universe call for sessions is now open! Apply to share your expertise by submitting a session proposal today. Plus, get 35% off your tickets to GitHub Universe only for a limited time.": "GitHub Universe 的會議徵集現已開啟！立即提交您的會議提案，分享您的專業知識。此外，現在限時可享 35% 的 GitHub Universe 會議門票折扣。",

        // 教育看板（申請教育包才有
        "Learn. Collaborate. Grow.": "學習，協作，成長。",
        "GitHub Education gives you the tools and community support to take on tech challenges and turn them into opportunities. Your future in tech starts here!": "GitHub 教育提供工具和社區支持，幫助您應對技術挑戰並將其轉化為機遇。您科技領域的未來從這裡開始！",
        "Go to GitHub Education": "前往 GitHub 教育",

        // 用戶 浮動信息卡
        "Member of": "隸屬組織",
        // [/, and (\d+) more/, "，以及其他 $1 個組織"],

        // 組織  浮動信息卡
        // [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        // [/(\d+) members?/, "$1 個成員"],

        "Switch dashboard context": "切換默認身份", // 組織
        "Manage organizations": "管理組織", // 組織
        "Create organization": "創建組織", // 組織

        // 首次加入組織通知
        "You’ve been added to the": "您已經被添加到",
        "organization!": "組織！",
        "Here are some quick tips for a first-time organization member.": "以下是首次加入組織的一些提示。",
        "Use the switch context button in the upper left corner of this page to switch between your personal context (": "使用頁面左上角的切換身份按鈕，您可以在（",
        ") and organizations you are a member of.": "）和組織身份之間進行切換。",
        "After you switch contexts you’ll see an organization-focused dashboard that lists out organization repositories and activities.": "當您切換身份，您會看到一個組織為中心的頁面，其中列出了組織庫和活動。",

        // 快捷鍵
        "Dashboards": "儀表板",
        "Go to your issues": "跳轉到您的議題",
        "Go to your pull requests": "跳轉到您的拉取請求",

        // 新版首頁（已登錄）2025-10-29
            "Your personal account": "我的個人賬戶",

            "Started": "開始於",
            "Completed": "完成於",
            "In progress": "進行中",

            "Unable to load agent tasks, try again later.": "無法加載智能體任務，請稍後重試。",
            "Unable to load pull requests, try again later.": "無法加載拉取請求，請稍後重試。",

            "Updated": "更新於",
            "Ready for review": "準備審查",
            "Assigned to Copilot": "分配給 Copilot",
    },
    "regexp": [ // 正則翻譯
        [/added (\d+) repositor(y|ies) to/, "添加 $1 個倉庫到"],
        [/, and (\d+) more/, "，以及其他 $1 個組織"], // 用戶 浮動信息卡
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"], // 組織  浮動信息卡
        [/(\d+) of your repositor(y|ies)/, "您的 $1 個倉庫"],
        [/(\d+) members?/, "$1 個成員"], // 組織  浮動信息卡
        [/is being deleted./, "正在被刪除。"], // 倉庫 組織被刪除
        [/Your repository \"([^ ]+)\" was successfully deleted./, "您的倉庫 “$1” 已成功刪除。"], // 倉庫刪除
        [/(\d+) releases?/, "$1 個發行版"],
        [/(\d+k?) followers?/, "$1 個關注者"],
        [/(\d+) users?/, "$1 個用戶"],
        [/(\d+) comments?/, "$1 條評論"],
        [/(\d+) commits? to/, "$1 個提交到"],
        [/(\d+) more commits? »/, "$1 個更多提交到"],
        [/(\d+) issues? needs? help/, "$1 個議題需要幫助"],
        [/Join discussion/, "加入討論"],
        // [/Updated/, "更新於"],
        // 創建於
        [/Created/, "創建於"],
        [/You’re an owner of the ([^ ]+) organization!/, "您是 $1 組織的所有者！"], // 組織
        [/Create a repository for ([^ ]+)/, "為 $1 創建倉庫"], // 組織
        [/Edit ([^ ]+)’s settings/, "編輯 $1 的設置"], // 組織
        [/Check out ([^ ]+)’s public profile/, "查看 $1 的公開資料"], // 組織
        [/and (\d+) more/, "和另外 $1 個"],
        [/You're seeing this because you collaborated with ([^ ]+)/, "您看到這個是因為您與 $1 有過合作"],
        [/You're seeing this because you starred ([^ ]+)/, "您看到這個，是因為您標星了 $1"],
        [/You're seeing this because you follow ([^ ]+)/, "您看到這個，是因為您關注了 $1"],
        [/You and/, "您和另外"],
        [/You reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes)/,function (all, reacted) {
            var reactedKey = {'thumbs up': "點贊", 'thumbs down': "點踩", laugh: "大笑", hooray: "歡呼", confused: "表示困惑", heart: "比心", rocket: "發送火箭", eyes: "表示關注"};

            return '您' + reactedKey[reacted];
        }],
        [/(\d+) (?:people|person) reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes)/, function (all, number, reacted) {
            var reactedKey = {'thumbs up': "點贊", 'thumbs down': "點踩", laugh: "大笑", hooray: "歡呼", confused: "表示困惑", heart: "比心", rocket: "發送火箭", eyes: "表示關注"};

            return number + ' 人' + reactedKey[reacted];
        }],
        [/Support ([^ ]+)'s open source work/, "支持 $1 的開源工作"],
        [/Start a new repository for/, "創建一個倉庫為"],
        [/([^ ]+) requested changes, you commented/, "$1 要求更改，您發表評論"], // 拉取請求 浮動信息卡
        // 頂部提醒
        // 繼任者相關
        [/You are now the designated successor for ([^ ]+)'s account./, "您現在是 $1 的指定繼任者了。"],
        [/You have declined to become the designated successor for ([^ ]+)'s account./, "您已經謝絕了成為 $1 賬戶指定繼任者的邀請。"],
        // 拉取請求狀態
        [/merged (\d+) commits?/, "合併 $1 個提交"],
        // 新版首頁
        [/Good morning, ([^ ]+)!/, "早上好，$1！"],
        [/Good afternoon, ([^ ]+)!/, "下午好，$1！"],
        [/Good evening, ([^ ]+)!/, "晚上好，$1！"],
        [/Switch dashboard: ([^ ]+)/, "切換儀表板：$1"],
        [/(.+)\#(\d+) · Opened by ([^ ]+) ·/, "$1#$2 · 打開者 $3"],
    ],
    "title": {
        "static": {
            "GitHub Dashboard": "GitHub 儀表盤",
            "Feed": "動態",
        },
    },
};
I18N["zh-TW"]["dashboard"] = I18N["zh-TW"]["page-dashboard"];
I18N["zh-TW"]["feed"] = I18N["zh-TW"]["page-dashboard"];
I18N["zh-TW"]["orgs/dashboard"] = I18N["zh-TW"]["page-dashboard"];

I18N["zh-TW"]["page-profile-public"] = { // 個人首頁（含組織）
    "static": { // 靜態翻譯
        // 左側用戶信息欄
            "Change your avatar": "修改頭像",
            "they/them": "他們",
            "she/her": "她",
            "he/him": "他",
            "You have blocked this user": "您已拉黑此用戶",
            "Follow": "關注",
            "Sponsor": "贊助",
            "follower": "關注者",
            "followers": "關注者",
            "following": "關注",
            "Followed by": "共同關注者：",
            "Joined": "加入於",
            "Achievements": "成就",
            "Highlights": "高光時刻",
                "Label: Pro": "標籤：專業版",
            "Developer Program Member": "開發者計劃成員",
            "security advisory credits": "個安全諮詢分",
            "security advisory credit": "個安全諮詢分",
            "Organizations": "組織",
            "Block or Report": "拉黑或舉報",
            "Unblock or report user": "取消拉黑或舉報",
            "- same time": "- 時間相同",

            // 編輯個人資料
                "Edit profile": "編輯個人資料",
                "Name": "名稱",
                "Display": "顯示",
                    "badge.": "徽章。",
                "Bio": "個人簡介",
                "Add a bio": "添加個人簡介",
                    "You can": "您可",
                    "@mention": "@用戶名或組織名",
                    "other users and organizations to link to them.": "鏈接到其他用戶和組織。",
                "Pronouns": "代詞",
                    "Don't specify": "不說明",
                    "they/them": "他們",
                    "she/her": "她",
                    "he/him": "他",
                    "Custom": "自定義",
                "Company": "公司",
                "Location": "位置",
                "Display current local time": "顯示當前當地時間",
                "same time": "相同時間",
                "Website": "網站",
                "Social accounts": "社交賬戶",
                "Link to social profile": "鏈接到社交賬戶",
                "Link to social profile 1": "鏈接到社交賬戶",
                "Link to social profile 2": "鏈接到社交賬戶",
                "Link to social profile 3": "鏈接到社交賬戶",
                "Link to social profile 4": "鏈接到社交賬戶",

            // 成就浮動界面
                // 北極程式碼庫貢獻者
                    "Arctic Code Vault Contributor": "北極程式碼庫貢獻者",
                        "History": "歷史",
                        "100% unlocked": "100% 解鎖",
                        "· Unlocked": "· 解鎖於",
                        "these repositories, and more, were archived": "這些倉庫以及更多倉庫已存檔",
                // YOLO
                    "You want it? You merge it.": "您想要它？您合併它。",
                    "inaccessible": "已刪庫",
                    "Merged without a review": "未經審查就合併",
                // Pull Shark
                    "Pull Shark": "鯊魚拉",
                    "Bronze unlocked": "青銅已解鎖",
                    "Bronze and Silver unlocked": "青銅和白銀已解鎖",
                    "· First unlocked": "· 首次解鎖於",
                    "2nd pull request merged": "2 個拉取請求被合併",
                    "16th pull request merged": "16 個拉取請求被合併",
                    "128th pull request merged": "128 個拉取請求被合併",
                    "1024th pull request merged": "1024 個拉取請求被合併",
                // Starstruck
                    "Starstruck": "追星族",
                    "⭐️ 16 stars": "⭐️ 16 個星標",
                    "⭐️ 128 stars": "⭐️ 128 個星標",
                    "⭐️ 512 stars": "⭐️ 512 個星標",
                    "⭐️ 4096 stars": "⭐️ 4096 個星標",
                // Pair Extraordinaire
                    "Pair Extraordinaire": "非凡搭檔",
                    "Unlocked": "解鎖於",
                    "Coauthored with": "與下列用戶共同合作",
                    "Coauthored with an unknown user": "與未知用戶共同合作",
                // Quickdraw
                    "Quickdraw": "快速關閉",
                    "Gitty up!": "趕快開始！",
                    "Closed within 5 minutes of opening": "在打開的 5 分鐘內關閉",
                // Galaxy Brain
                    "Galaxy Brain": "銀河大腦",
                    "2nd accepted answer": "2 個答案被接受",
                    "8th accepted answer": "8 個答案被接受",
                    "16th accepted answer": "16 個答案被接受",
                    "32nd accepted answer": "32 個答案被接受",
                // Public Sponsor
                    "Public Sponsor": "公共贊助者",
                    "1st sponsorship": "1 次贊助",
                // Mars 2020 Contributor
                    "Mars 2020 Contributor": "火星 2020 貢獻者",
                    "Mars 2020 Helicopter Mission": "2020 火星無人直升機首飛計劃",
                    "this repository was included": "該倉庫已收錄",

                // ?tab=achievements
                    "Hide from profile": "從個人資料中隱藏",
                    "Hidden from your profile.": "已從您的個人資料中隱藏",
                    "Show on profile": "在個人資料中顯示",
                    "Copy share link": "複製共享鏈接",
                    "Preview on Twitter": "在 Twitter 上預覽",

                    // 頂部提醒
                        // [/The (.+) achievement will now be hidden from your profile./, "現在，將從您的個人資料中隱藏 “$1” 成就。"],
                        // [/The (.+) achievement will now be shown in your profile./, "現在，將在您的個人資料中顯示 “$1” 成就。"],

                "Send feedback": "發送反饋",

            // 拉黑 & 舉報用戶對話框
                // [/Block or report ([^ ]+)/, "拉黑或舉報 $1"],
                "Block user": "拉黑用戶",
                "Prevent this user from interacting with your repositories and sending you notifications. Learn more about": "防止該用戶與您的倉庫互動並向您發送通知。瞭解更多關於",
                "blocking users": "拉黑用戶",

                "Add an optional note:": "添加可選備註：",
                    "Please don't include any personal information such as legal names or email addresses. Maximum 100 characters, markdown supported. This note will be visible to only you.": "請勿包含任何個人信息，如法定姓名或電子郵件地址。最多 100 個字符，支持標記符。此備註只有您本人可見。",

                "Unblock user": "取消拉黑",
                "Allow this user to interact with your repositories and send you notifications. Learn more about": "允許該用戶與您的倉庫互動並向您發送通知。瞭解更多關於",

                "Report abuse": "舉報濫用",
                    "Contact GitHub support about this user’s behavior. Learn more about": "就該用戶的行為聯繫 GitHub 支持部門。瞭解更多關於",
                    "reporting abuse": "舉報濫用",

        // 倉庫
            "Forked from": "複刻自",
            "Updated": "更新於",

            // 許可證
                "GNU General Public License v3.0": "GNU 通用公共許可證 v3.0",
                "GPL-3.0 License": "GPL-3.0 許可證",
                "AGPL-3.0 License": "AGPL-3.0 許可證",
                "LGPL-3.0 License": "LGPL-3.0 許可證",
                "MIT License": "MIT 許可證",
                "Apache License 2.0": "Apache-2.0 許可證",
                "OFL-1.1 License": "OFL-1.1 許可證",
                "0BSD License": "0BSD 許可證",
                "BSD-3-Clause License": "BSD-3-Clause 許可證",
                "BSD 3-Clause \"New\" or \"Revised\" License": "BSD-3-Clause 許可證",
                "CC0-1.0 License": "CC0-1.0 許可證",
                "WTFPL License": "WTFPL 許可證",
                "Other": "其他",
                "Unknown": "未知",

        // 標籤欄
            "Sponsoring": "贊助",
    },
    "regexp": [ // 正則翻譯
        [/(\d+) discussions? answered/, "$1 個討論已回答"], // 高光時刻
        [/Block or report ([^ ]+)/, "拉黑或舉報 $1"],
        [/contributed code to several repositories in the/, "為多個倉庫貢獻了程式碼，在"],
        [/(\d+) GitHub Archive Program/, "$1 GitHub 存檔計劃"], // 成就浮動款
        [/opened pull requests that have been merged./, "打開的拉取請求已被合併。"], // Pull Shark
        [/created a repository that has many stars./, "創建了一個擁有很多星標的倉庫。"], // Starstruck
        [/coauthored commits on merged pull requests./, "與他人共同提交了合併的拉取請求。"], // Pair Extraordinaire
        [/answered discussions./, "回答了討論。"], // Galaxy Brain
        [/(\@[^ ]+) (?:is sponsoring|has sponsored) (\d+) organizations? or users?./, "$1 贊助了 $2 個組織或用戶。"], // Public Sponsor
        [/contributed code to (\d+) repositor(y|ies) used in the/, "貢獻於 $1 個倉庫收錄於"], // Mars 2020 Helicopter Mission.
        [/The (.+) achievement will now be hidden from your profile./, "現在，將從您的個人資料中隱藏 “$1” 成就。"],
        [/The (.+) achievement will now be shown in your profile./, "現在，將在您的個人資料中顯示 “$1” 成就。"],
        [/^(\d+) repositor(y|ies)/, "$1 倉庫"],
        [/(\d+) members?/, "$1 成員"],
        [/and (\d+) more/, "等 $1 人"],
        [/- (\d+)h (ahead|behind)/, function(all, num, compare){
            var compareKey = {ahead: '早', behind: '晚'};

            return '- ' + compareKey[compare] + num + '小時';
        }],
    ],
    "title": {
        "static": {
            "Your Followers": "我的關注者",
            "Who You’re Following": "我關注的人",
        },
        "regexp": [
            [/Achievements/, "成就"],
            [/Followers/, "關注者"],
            [/Following/, "關注"],
        ],
    },
};
I18N["zh-TW"]["page-profile/achievements"] = I18N["zh-TW"]["page-profile-public"]; // ?tab=achievements
I18N["zh-TW"]["page-profile/followers"] = I18N["zh-TW"]["page-profile-public"]; // ?tab=followers
I18N["zh-TW"]["page-profile/following"] = I18N["zh-TW"]["page-profile-public"]; // ?tab=following

I18N["zh-TW"]["page-profile"] = { // 個人首頁
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 概述標籤卡 即主頁 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Customize your pins": "自定義置頂",
            // 設置置頂專案對話框
            "Edit pinned items": "設置置頂專案",
            "Select up to six public repositories or gists you'd like to show to anyone.": "最多選擇 6 個您想向任何人展示的公共倉庫或程式碼片段。",
            "Select up to six public repositories you'd like to show.": "最多選擇 6 個要顯示的公共倉庫。", // 組織頁
            "Filter repositories and gists": "篩選倉庫和程式碼片段",
            "Repositories": "倉庫",
            "Gists": "程式碼片段",
            "Filter repositories": "篩選倉庫", // 組織頁
            "Show:": "顯示：",
            "Save pins": "保存置頂",

            "Drag to reorder": "拖動重新排序",

            // 頂部提醒
            "You unlocked new Achievements with private contributions! Show them off by including private contributions in your Profile in": "您通過私人貢獻解鎖了新成就！通過在您的個人資料中包含私人貢獻來展示它們。",
            "You unlocked new Achievements! Show them off by including achievements and private contributions in your Profile in": "您通過私人貢獻解鎖了新成就！通過在您的個人資料中包含私人貢獻來展示它們。",
            "Your pins have been updated. Drag and drop to reorder them.": "您的置頂已更新。拖放來重新排列它們。",
            "Your popular repositories will now be shown instead of your pins.": "現在將顯示您的熱門倉庫，而不是您的置頂。",

            "Only you can see your full profile.": "只有您可以查看完整的個人資料。",
                "You have marked your profile as private, which limits what activity other people can see.": "您已將個人資料設為私密，這會限制其他人查看您的活動。",
                "Update profile settings": "更新個人資料設置",
            "View what others see": "以他人視角查看",
            "View full profile": "查看完整個人資料",

            "Your pins have been updated.": "您的置頂已更新。",
            // 拖拽排序提醒
            "Order updated.": "置頂已更新。",

            "Pinned": "已置頂",
            "Top repositories": "置頂的倉庫",
            "Popular repositories": "熱門倉庫",

            "Learn how we count contributions": "瞭解我們如何計算貢獻",
            "Contribution settings": "貢獻設置",

            // 複刻倉庫特有
            "Forked from": "複刻自",
            // 貢獻設置下拉菜單
            "Private contributions": "私人貢獻",
            "Turning on private contributions will show anonymized private activity on your profile.": "開啟私人貢獻則將在您的個人資料上顯示匿名的私人活動。",
            "Visitors will now see your public and anonymized private contributions.": "訪客現在將看到您的公開和匿名的私人貢獻。",
            "Turning off private contributions will show only public activity on your profile.": "關閉私人貢獻則將僅在您的個人資料中顯示公開活動。",
            "Visitors will now see only your public contributions.": "訪客現在將只能看到您的公開貢獻。",
            "Activity overview": "活動概況",
            "Turning off the activity overview will hide the section on your profile.": "關閉活動概況則將隱藏您的個人資料中的部分內容。",
            "The 'Activity overview' section will no longer appear on your profile.": "“活動概況” 部分將不再出現在您的個人資料中。",
            "Turning on the activity overview will show an overview of your activity across organizations and repositories.": "開啟活動概況將顯示跨組織和倉庫的活動概況。",
            "Others will now see 'Activity overview' when they view your profile.": "其他人在查看您的資料時，現在會看到 “活動概況”。",

            "Contribution activity": "貢獻活動",
                "Year:": "年份：", // 小屏模式

            "Search by name": "搜索組織名",
            "Contributed to": "貢獻給了",
            "Activity in": "活動在",
            "No activity overview available.": "沒有可用的活動概況。",

            "open": "打開",
            "closed": "已關閉",
            "merged": "已合併",
            "pull request": "拉取請求",

            "commits": "次提交",
            "comments": "次評論",
            "Commits": "提交",
            "Code review": "程式碼審查",
            "Built by": "構建者",

            "Created their first repository": "創建了他們的第一個倉庫",
            "Created an issue in": "創建一個議題在",
            "a private repository": "私有倉庫",
            "Created a pull request in": "創建一個拉取請求在",
                "lines changed": "行更改",
            "First repository": "第一個倉庫",
            "First pull request": "第一次拉取請求",
            "First issue": "第一次議題",
            "Opened their first issue on GitHub in": "打開了他們第一個議題",
            "Opened their first pull request on GitHub in": "打開了他們第一個拉取請求",
            "Opened their first pull request on GitHub in a private repository": "在私有倉庫中打開了他們第一個拉取請求",
            "Joined GitHub": "剛加入 GitHub",
            "Joined the": "加入",
            "organization": "組織",
            "Show more activity": "加載更多動態",

            "Seeing something unexpected? Take a look at the": "看到了一些意想不到的東西？請看一下",
            "GitHub profile guide": "GitHub 個人資料指南",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) discussions? answered/, "$1 個討論已回答"], // 高光時刻
        [/Block or report ([^ ]+)/, "拉黑或舉報 $1"],
        [/(\d+) GitHub Archive Program/, "$1 GitHub 存檔計劃"], // 成就浮動款
        [/(\d+) remaining/, "$1 剩餘"], // 置頂專案 剩餘
        [/([^ ]+) doesn('|’)t have any public repositories yet./, "$1 尚無任何公共倉庫。"],
        [/([\d,]+) contributions? in the last year in ([^ ]+)/, "在過去的一年中向 $2 貢獻 $1 次"],
        [/([\d,]+) contributions? in the last year/, "在過去的一年中貢獻 $1 次"],
        [/([\d,]+) contributions? in (\d+) in ([^ ]+)/, "在 $2 年中向 $3, 貢獻 $1 次"],
        [/([\d,]+) contributions? in (\d+)/, "在 $2 年中貢獻 $1 次"],
        [/(\d+) contributions? in private repositor(y|ies)/, "私有倉庫 $1 個貢獻"],
        [/Only people who can see (.+) can see this contribution/, "只有能看到 $1 的人才能看到此貢獻"],
        [/(\d+|No) contribution(?:s)? on (.+)(?:st|nd|rd|th)./, (match, number, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            //return optKey[opt] + `${translatedDate}`;
            return number === 'No' ? `${translatedDate}，無貢獻` : `${translatedDate}，` + number + ` 次貢獻`;
        }],// 貢獻日曆
        //[/A graph representing ([^ ]+)'s contributions from ( .+) to ( .+)./, "$1 從 $2 到 $3 的貢獻圖。"],
        [/and (\d+) other repositor(y|ies)/, "和 $1 個其他倉庫"], // 活動概覽
        // 貢獻信息
        [/Created ([\d,]+) commits? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中創建了 $1 次提交"],
        [/Created (\d+) (other)? repositor(y|ies)/, "創建了 $1 個倉庫"],
        [/Opened (\d+) pull requests? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中打開了 $1 個拉取請求"],
        [/Opened (\d+) other pull requests? in (\d+) repositor(y|ies)/, "在 $2 個其他倉庫中打開了 $1 個拉取請求"],
        [/Opened (\d+) issues? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中打開了 $1 個議題"],
        [/Opened (\d+) other issues? in (\d+) repositor(y|ies)/, "在 $2 個其他倉庫中打開了 $1 個其他議題"],
        [/Reviewed (\d+) pull requests? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中審查了 $1 個拉取請求"],
        [/Answered (\d+) discussions? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中答覆了 $1 個討論"],
        [/Started (\d+) discussions? in (\d+) repositor(y|ies)/, "在 $2 個倉庫中發起了 $1 個討論"],
        [/(\d+) commits?/, "$1 次提交"],
        [/(\d+) pull requests?/, "$1 次拉取請求"],
        [/that received (\d+) comments?/  , "收到 $1 條評論"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 個任務"],
        [/(\d+) comments?/, "$1 條評論"],
        [/(\d+) tasks? done/, "$1 個任務完成"],
        [/([^ ]+) doesn't have any projects yet./, "$1 目前還沒有任何專案。"],
        [/([^ ]+) has no activity yet for this period./, "$1 目前還沒有活動。"],
        [/([^ ]+) had no activity during this period./, "$1 在此期間沒有活動。"],
        [/Contribution activity in ([^ ]+)/, "在 $1 中的貢獻活動"],
        [/([^ ]+) had no activity in ([^ ]+) during this period./, "在此期間，$1 在 $2 中沒有活動。"],
        [/([^ ]+) has no activity in ([^ ]+) yet for this period./, "在此期間，$1 在 $2 中沒有活動。"],
        [/@([^ ]+)'s activity is private/, "$1 的活動不可見"],
        [/Created (\d+\+?) repositor(y|ies)/, "創建了 $1 個倉庫"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
        [/(\d+) tasks?/, "$1 任務"], // 帶任務議題
        [/and (\d+) more/, "等 $1 人"],
        [/- (\d+)h (ahead|behind)/, function(all, num, compare){
            var compareKey = {ahead: '早', behind: '晚'};

            return '- ' + compareKey[compare] + num + '小時';
        }],
        [/(?:on )?(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        //[/A graph representing ([^ ]+)'s contributions from (.+) to (.+). The contributions are (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review), (\d+\%) (commits|pull requests|issues|code review)./, function(all, user, date1, date2, cd1, c1, cd2, c2, cd3, c3, cd4, c4){
        //    var c1Key, c2Key ,c3Key, c4Key = {
        //        'commits': '提交',
        //        'pull requests': '拉取請求',
        //        'code review': '程式碼審查',
        //        'issues': '議題',
        //    };
        //    return user + '從' + date1 + '到' + date2 + '的貢獻圖。其中' + cd1 + c1Key[c1] + '，' + cd2 + c2Key[c2] + '，' +cd3 + c3Key[c3] + '，' + cd4 + c4Key[c4]+ '。';
        //}],
        // 成就
        [/answered discussions./, "回答了討論。"], // Galaxy Brain
        [/opened pull requests that have been merged./, "打開的拉取請求已被合併。"], // Pull Shark
        [/created a repository that has many stars./, "創建了一個擁有很多星標的倉庫。"], // Starstruck
        [/coauthored commits on merged pull requests./, "與他人共同提交了合併的拉取請求。"], // Pair Extraordinaire
        [/(\@[^ ]+) contributed code to several repositories in the/, "$1 為多個倉庫貢獻了程式碼，在"], // 北極程式碼庫貢獻者
    ],
};
I18N["zh-TW"]["page-profile/overview"] = I18N["zh-TW"]["page-profile"];

I18N["zh-TW"]["page-profile/repositories"] = { // 個人首頁 - 倉庫標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 倉庫標籤卡 ?tab=repositories >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

            // 頂部提醒
                // [/Your repository \"([^ ]+)\" was successfully deleted./, "您的倉庫 “$1” 已成功刪除。"],

            // "Search repositories…": "搜索這些查庫…",
            // "Search starred repositories…": "搜索星標倉庫…",

            // 搜索, 篩選 & 排序工具欄
            "Find a repository…": "搜索倉庫…",
            // "Type": "類型", // 與全局衝突 使用 Selector 規則翻譯
                // 下拉菜單
                "Select type": "選擇類型",
                "All": "全部",
                "Public": "公共",
                "Private": "私有",
                "Sources": "源碼",
                "Forks": "複刻",
                "Archived": "存檔",
                "Can be sponsored": "可贊助",
                "Mirrors": "鏡像",
                "Templates": "模板",
            "Language": "語言",
                // 下拉菜單
                "Select language": "選擇語言",
                "All languages": "所有語言",
            "Sort": "排序",
                // 下拉菜單
                "Select order": "選擇排序",
                "Last updated": "最近更新",
                // "Name": "倉庫名",
                // "Recently starred": "最近星標",
                // "Recently active": "最近活躍",
                // "Most stars": "最多星標",
                // "Unstar": "取消星標",
            "New": "新建",

            // 篩選結果
            "result for": "個結果在",
            "results for": "個結果在",
                "public": "公共",
                "private": "私有",
                "source": "源碼",
                "forked": "複刻",
                "archived": "存檔",
                "sponsorable": "可贊助",
                "mirror": "鏡像",
                "template": "模板",
            "repositories matching": "倉庫中匹配了",
            "result for repositories matching": "個結果在倉庫中匹配了",
            "results for repositories matching": "個結果在倉庫中匹配了",
            "repositories sorted by": "倉庫，排序按",
            "written in": "，使用語言",
            "results for repositories written in": "個結果在倉庫中使用語言",
            "star matching": "個星標匹配", //?tab=stars
            "stars matching": "個星標匹配", //?tab=stars
            "star written in": "個星標使用語言", //?tab=stars
            "stars written in": "個星標使用語言", //?tab=stars
            "sorted by": "，排序按",
                "last updated": "最近更新",
                "name": "倉庫名",
                "stars": "星標",

            "Clear filter": "清除篩選",

            // [/([^ ]+) doesn’t have any repositories that match./, "$1 沒有任何匹配的倉庫"],
            "This organization doesn’t have any repositories that match.": "該組織沒有任何匹配的倉庫。", // 組織倉庫

            "This organization has no public repositories.": "該組織沒有公共倉庫。", //組織倉庫

            "No repositories matched your search.": "沒有與您的搜索匹配的倉庫。", // 無匹配倉庫

            // 專案 狀態詞
            "Updated": "更新於",
            "Forked from": "複刻自",

            // 曲線圖提示
            "Past year of activity": "過去一年的活動",

        // 新版 組織 - 倉庫概述 https://github.com/orgs/<orgs-name>/repositories
            "Filter": "篩選",
                "Advanced filters": "高級篩選器",
                    "Build complex filter queries": "構建複雜的篩選查詢",
                        "To start building your query add your first filter using the button below.": "要開始創建查詢，請使用下面的按鈕添加第一個篩選器。",
                    "Add a filter": "新增篩選器",
                    "Apply": "應用",
                    "Qualifier": "限定詞",
                        "Created": "已創建",
                        "Total forks": "複刻總數",
                        "Total good-first issues": "好的首發議題總數",
                        "Has": "包含文件",
                        "Total help-wanted issues": "求助議題總數",
                        "License": "許可證",
                        "Mirror": "鏡像",
                        "Size (Kb)": "大小 (Kb)",
                        "Sponsorable": "可接受贊助",
                        "Text": "文本",
                        "Total topics": "主題總數",
                        "Total stars": "星標總數",
                        "Template": "模板",
                        "Topic": "話題",
                        "Visibility": "可見性",
                    "Operator": "操作符",
                        "is": "是",
                        "is not": "不是",
                        "before": "之前",
                        "after": "之後",
                        "between": "之間",
                            "From": "起",
                            "To": "至",
                        "is one of": "包括",
                        "is not one of": "不包含",
                        "greater than": "大於",
                        "less than": "小於",
                        "greater than or equal to": "大於或等於",
                        "less than or equal to": "小於或等於",
                        "equal to": "等於",
                    "Value": "值",
                        "Enter a number": "輸入數字",
                        "Enter search text": "輸入搜索文本",
                        "Make a selection": "進行選擇",
                            "Select items": "選擇專案",
                            "Select an item": "選擇專案",
                                "Filter values": "篩選值",
                                    // 複刻
                                        "Only forks": "僅複刻",
                                        "Exclude forks": "排除複刻",
                                    // 排序
                                        "Recently pushed": "最近推送",
                                        "Topics": "話題",
                                        "Size": "尺寸",
                                        "Recently pushed (descending)": "最近推送（降序）",
                                        "Name (descending)": "名稱（降序）",
                                        "Language (descending)": "語言（降序）",
                                        "License (descending)": "許可證（降序）",
                                        "Topics (ascending)": "主題（升序）",
                                        "Size (ascending)": "大小（降序）",
                                        "Total stars (ascending)": "星標總數（降序）",
                                        "Total forks (ascending)": "複刻總數（降序）",
                                        "Help-wanted issues (ascending)": "求助議題總數（升序）",
                                        "Help-wanted issues (descending)": "求助議題總數（降序）",
                                    // 可見性
                                        "Internal": "內部",
                "Discard changes?": "放棄更改？",
                    "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您確定要放棄它們嗎？",
                    "Keep editing": "繼續編輯",
                    "Close and discard": "關閉並放棄",
            "Search repositories": "搜索倉庫",
                "No repositories matched your search": "沒有與您的查詢相匹配的倉庫",
                    "Try a different search query": "嘗試不同的搜索查詢",

            "Last pushed": "最近提送",
                "Ascending": "升序",
                "Descending": "降序",
            "repository": "倉庫",
            "No language": "無語言",

            "Compact display density": "緊湊顯示密度",
            "Comfortable display density": "舒適顯示密度",
    },
    "regexp": [ // 正則翻譯
        [/(\d+(k|M|B)?) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
        [/([^ ]+) doesn’t have any repositories that match./, "$1 沒有任何匹配的倉庫"], // 倉庫標籤卡
        [/([^ ]+) doesn’t have any public repositories yet./, "$1 沒有任何公共倉庫。"],
        [/Your repository \"([^ ]+)\" was successfully deleted./, "您的倉庫 “$1” 已成功刪除。"],
        [/(\d+) issues? needs? help/, "$1 個議題需要幫助"],
        [/and (\d+) more/, "等 $1 人"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "selector": [ // 元素篩選器規則
        ["#type-options > summary > span:nth-child(1)", "類型"], // 個人主頁 --> 倉庫標籤頁-->類型篩選器 Type
    ],
    "title": {
        "static": {
            "Your Repositories": "我的倉庫",
        },
        "regexp": [
            [/(R|r)epositories/, "倉庫"],
        ],
    },
};

I18N["zh-TW"]["page-profile/projects"] = { // 個人首頁- 專案標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 專案標籤卡 ?tab=projects >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "There aren't any projects yet": "尚無任何專案",
            "Provide quick access to relevant projects.": "提供快速訪問相關專案的途徑。",
            "Add projects to view them here.": "將專案添加到此處查看。",

            "Welcome to projects": "歡迎訪問專案頁面",
            "Built like a spreadsheet, project tables give you a live canvas to filter, sort, and group issues and pull requests. Tailor them to your needs with custom fields and saved views.": "構建像電子表格一樣的專案表，給您一個實時的畫布來對議題和拉取請求進行篩選、排序和分組。通過自定義字段和保存的視圖，使它們符合您的需要。",

            "Learn more about projects": "瞭解更多關於專案的信息", // ?tab=projects

            "Create your first GitHub project": "創建您的第一個 GitHub 專案",
            "Projects are a customizable, flexible tool for planning and tracking your work.": "專案是一個可定製的、靈活的工具，用於規劃和跟蹤您的工作。",

            "Sort": "排序",
                // 排序下拉菜單
                "Newest": "最新",
                "Oldest": "最早",
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新",
            // 清除篩選
            "Clear current search query and sorts": "清除當前的搜索查詢和分類",

            "No open projects": "無已打開的專案",

            "Plan and track work across repositories with custom fields and multiple views": "通過自定義字段和多個視圖來計劃和跟蹤整個倉庫的工作",
            "Kanban-style project board": "看板式專案面板",

            "You don't have any projects yet.": "您還沒有任何專案。",
            "There are no projects matching your search.": "沒有符合您搜索條件的專案。",
            "Learn More": "瞭解更多",

            "No description": "無描述",

            // 頂部提醒
            "Project closed.": "專案已關閉。",
            "Project reopened.": "專案已重新打開。",

            // 組織
            "Created by me": "由我創建",
            "Create your first GitHub project template": "創建您的第一個 GitHub 專案模板",
            "Templates can be used to quickly get started with a new project.": "模板可以用於快速新建專案。",
            "New template": "新建模版",

        // https://github.com/users/<user-name>/projects/<id>
            "New view": "新建視圖",
            "Layout": "佈局",
            "Board": "面板",
            "Roadmap": "時間線",
            "Duplicate view": "複製視圖",
            "Configuration": "配置",
            "Group by": "分組",
            "No grouping": "不進行分組",
            "Markers": "標記",
            "Sort by": "排序",
            "No sorting": "不進行排序",
            "Zoom level": "縮放級別",
            "Field sum": "字段總和",
            "Slice by": "切片",
            "No slicing": "不進行切片",
            "Fields": "字段",
            "Generate chart": "生成圖表",
            "Rename view": "重命名視圖",
            "Delete view": "刪除視圖",
            "Export view data": "導出視圖數據",
            "Assignees": "負責人",
            "Project templates": "專案模板",
            "Featured": "特色",
            "Iteration": "迭代",
            "Dates": "日期",
            "User settings": "用戶設置",
            "Truncate titles": "截斷標題",
            "Show date fields": "顯示日期字段",
            "Add status update": "添加狀態更新",
            "Project details": "專案詳情",
            "View more options": "查看更多選項",
            "Date fields": "日期字段",
            "Month": "月",
            "Quarter": "季度",
            "Year": "年",
            "Today": "今天",
            "Add item": "添加專案",
            "Start typing to create a draft, or type # to select a repository": "開始輸入以創建草案，或輸入 # 選擇一個倉庫",
            "Scroll to previous date range": "滾動到上一個日期範圍",
            "Scroll to next date range": "滾動到下一個日期範圍",
            "Filter by keyword or by field": "按關鍵字或字段篩選",
            "Discard": "放棄",
            "Save changes to new view": "保存更改到新視圖",
            "Visible fields": "可見字段",
            "Hidden fields": "隱藏字段",
            "New field": "新建字段",
            "Column by": "欄目",
            "Workflows": "工作流",
            "Archived items": "已存檔專案",
            "Make a copy": "複製",
            "GitHub Projects": "GitHub 專案",
            "What’s new": "新功能",
            "Project settings": "專案設置",
            "Project name": "專案名稱",
            "Short description": "簡短描述",
            "More options": "更多選項",
            "Make a copy of this project.": "複製此專案",
            "Danger zone": "危險區",
            "This project is currently private.": "此專案當前為私有.",
            "Closing a project will disable its workflows & remove it from the list of open projects.": "關閉專案將禁用其工作流程，並將其從打開專案列表中刪除.",
            "Close this project": "關閉此專案",
            "Manage access": "管理訪問權限",
            "Who has access": "誰有訪問權限",
            "Private project": "私有專案",
            "Only those with access to this project can view it.": "只有有權訪問此專案的人才能查看它.",
            "Invite collaborators": "邀請協作者",
            "Manage access": "管理訪問權限",
            "Custom fields": "自定義字段",
            "Field name": "字段名稱",
            "Field type": "字段類型",
            "Text": "文本",
            "Number": "數字",
            "Date": "日期",
            "Single select": "單選",
            "Starts on": "開始於",
            "Duration": "持續時間",
            "days": "天",
            "weeks": "周",
            "Save and create": "保存並創建",
            "You don't have any collaborators yet.": "您還沒有任何協作者.",
            "Add a collaborator to see them here.": "添加協作者以在此處查看他們.",
            "Make template": "製作模板",
            "Copy as template": "複製為模板",
            "Visibility": "可見性",
            "Close project": "關閉專案",
            "Delete project": "刪除專案",
            "Delete this project": "刪除此專案",
            "Status chart": "狀態圖表",
            "This chart shows the current status for the total number of items in your project.": "此圖表顯示了專案中所有專案的當前狀態.",
            "Default charts": "默認圖表",
            "Custom charts": "自定義圖表",
            "Configure": "配置",
            "Configure chart": "配置圖表",
            "Group by (optional)": "分組 (可選)",
            "X-axis": "X 軸",
            "Y-axis": "Y 軸",
            "Save to new chart": "保存到新圖表",
            "Add a project status update": "添加專案狀態更新",
            "Add update": "添加更新",
            "Status updates are brief reports tracking your project's health and progress. Begin by adding an update.": "狀態更新是跟蹤專案健康和進度的簡要報告. 從添加更新開始.",
            "Let everyone know what this project is about, how to use it and link to important resources.": "讓每個人都知道這個專案是關於什麼的，如何使用它，並鏈接到重要資源.",
            "A short description about this project.": "關於此專案的簡短描述.",
    },
    "regexp": [ // 正則翻譯
        [/View (\d+)/, "視圖 $1"],
        [/([\d,]+) Open/, "$1 打開"], // 專案標籤卡
        [/([\d,]+) Closed/, "$1 已關閉"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Your Projects": "我的專案",
        },
        "regexp": [
            [/Projects/, "專案"],
        ],
    },
};

I18N["zh-TW"]["page-profile/sponsoring"] = { // 個人首頁- 贊助標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],
            "has sponsored": "曾贊助",
            "organization or maintainer in the past": "個組織或維護者",
            "organization or maintainer": "個組織或維護者",
            "Bulk Sponsor": "批量贊助",
            "Sponsor multiple maintainers in one easy transaction.": "一次交易即可贊助多個維護者。",
            "Get started": "前去贊助",
            "Past sponsorship": "曾經贊助",
            "Sponsored": "贊助於",
            "organizations and maintainers and has sponsored": "個組織和維護者，過去曾贊助過",
                "in the past": "個",
    },
    "regexp": [ // 正則翻譯
        [/is sponsoring/, "正在贊助"],
        [/Sponsoring since (.+)/, (match ,p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `贊助自 ${translatedDate}`;
        }],
        [/Sponsored/, "贊助於"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
    ],
    "title": {
        "regexp": [
            [/Sponsoring/, "贊助"],
        ],
    },
};

I18N["zh-TW"]["page-profile/packages"] = { // 個人首頁 - 軟體包標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 軟體包標籤卡 ?tab=packages >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Get started with GitHub Packages": "開始使用 GitHub 軟體包",
            "Safely publish packages, store your packages alongside your code, and share your packages privately with your team.": "安全地發佈包，將您的包與您的程式碼一起存儲，並與您的團隊私下共享您的包。",
            "Choose a registry": "選擇註冊表",
            "A software platform used for building applications based on containers — small and lightweight execution environments.": "用於構建基於容器的應用的軟體平臺——小型輕量級執行環境。",
            "A default package manager used for the Java programming language and the Java runtime environment.": "用於 Java 編程語言和 Java 運行環境的一個默認包管理器。",
            "A free and open source package manager used for the Microsoft development platforms including .NET.": "一個自由和開源的開源包管理器，用於包括 .NET 在內的 Microsoft 開發平臺。",
            "A standard format for distributing Ruby programs and libraries used for the Ruby programming language.": "分發用於 Ruby 編程語言的 Ruby 程式和庫的標準格式。",
            "A package manager for JavaScript, included with Node.js. npm makes it easy for developers to share and reuse code.": "npm 是一個 JavaScript 的包管理器，包含在 Node.js 中。它使開發人員能夠輕鬆地分享和重用程式碼。",
            "Containers": "容器",
            "A single place for your team to manage Docker images and decide who can see and access your images.": "為您的團隊提供一個管理 Docker 鏡像的單一場所，並決定誰可以看到和訪問您的鏡像。",

            "Type:": "類型:",
                // 下拉菜單
                "Select type": "選擇類型",
                "All": "全部",
            "Search packages…": "搜索軟體包…",
            "Visibility:": "可見性:",
                "Select visibility": "選擇可見性",
                "Internal": "內部",
            "Sort by:": "排序方式:",
                "Select sort view": "選擇排序視圖",
                "Most downloads": "最多下載",
                "Least downloads": "最少下載",

            "Clear current search query, filters, and sorts": "清除當前的搜索查詢、篩選器和排序方式",
            // 篩選結果
            "No results matched your search.": "沒有與您的搜索匹配的結果。",
            "Try": "嘗試",
            "browsing all packages": "瀏覽所有軟體包",
            "to find what you're looking for.": "，以找尋您想要的內容。",

            "Published": "發佈於",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) packages?/, "$1 軟體包"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Your Packages": "我的軟體包",
        },
        "regexp": [
            [/Packages/, "軟體包"],
        ],
    },
};

I18N["zh-TW"]["page-profile/sponsors"] = { // 個人首頁 - 贊助標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 贊助標籤卡 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // [/is sponsoring/, "正在贊助"],
            "organization or developer:": "個組織或開發者：",
    },
    "regexp": [ // 正則翻譯
        [/is sponsoring/, "正在贊助"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
    ],
};

I18N["zh-TW"]["page-profile/stars"] = { // 個人首頁 - 星標標籤卡
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["page-profile-public"]["static"],

        // 星標標籤卡 ?tab=stars >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Show all lists...": "顯示所有列表…",

            "Sort by": "排序方式",
            // 排序補充
                "Name ascending (A-Z)": "名稱升序 (A-Z)",
                "Name descending (Z-A)": "名稱降序 (Z-A)",
                "Newest": "最新",
                "Oldest": "最早",
                "Last updated": "最後更新",

            "Create your first list": "創建您的第一個清單",
            "Lists make it easier to organize and curate repositories that you have starred.": "列表可使您更容易組織和策劃您的星標倉庫。",
            "Create your first list.": "創建您的第一個清單。",

            // 搜索, 篩選 & 排序工具欄
            "Search stars": "搜索星標",
            "Type: All"    : "類型：全部",
            "Type: Public" : "類型：公共",
            "Type: Private": "類型：私有",
            "Type: Sources": "類型：源碼",
            "Type: Forks"  : "類型：複刻",
            "Type: Mirrors": "類型：鏡像",
            "Type: Templates": "類型：模板",
                "All"    : "全部",
                "Public" : "公共",
                "Private": "私有",
                "Sources": "源碼",
                "Forks"  : "複刻",
                "Can be sponsored": "可贊助",
                "Mirrors": "鏡像",
                "Templates": "模板",
            "Language": "語言",
                // 下拉菜單
                "Select language": "選擇語言",
                "All languages": "所有語言",
            "Sort": "排序",
                // 下拉菜單
            "Sort by: Recently starred": "排序：最近星標",
            "Sort by: Recently active": "排序：最近活躍",
            "Sort by: Most stars": "排序：最多星標",
                "Recently starred": "最近星標",
                "Recently active": "最近活躍",
                "Most stars": "最多星標",
                "Languages": "語言",

            // 篩選結果
            "result for": "個結果在",
            "results for": "個結果在",
                "public": "公共",
                "private": "私有",
                "source": "源碼",
                "forked": "複刻",
                "sponsorable": "可贊助",
                "archived": "存檔",
                "mirror": "鏡像",
                "template": "模板",
            "star matching": "個星標匹配", //?tab=stars
            "stars matching": "個星標匹配", //?tab=stars
            "star written in": "個星標使用語言", //?tab=stars
            "stars written in": "個星標使用語言", //?tab=stars
            "starred repositories": "星標倉庫",
            "starred repositories written in": "星標倉庫使用語言",

            "Clear filter": "清除篩選",

            // 專案 狀態詞
            "Updated": "更新於",
            "Forked from": "複刻自",

            "That’s it. You’ve reached the end of your stars.": "而已。您已經到了星海的盡頭。",

            "Topics": "主題",

            "Add to list": "添加到清單",
            "Lists": "清單",
            "You don't have any lists yet.": "您尚無任何清單。",

            // [/(\d+) repositor(y|ies)/, "$1 個倉庫"],

            // 他人庫 星標頁 補充
            "Search starred repositories": "搜索星標倉庫",
            "Starred repositories": "星標倉庫",
            "Starred topics": "星標主題",
            "See all starred topics": "查看所有星標主題",

            // [/That’s it. You’ve reached the end of ([^ ]+)’s stars./, "而已。您已經到了$1 星海的盡頭。"], // 他人星標頁 搜索結果

        // https://github.com/stars/<user-name>/lists/<清單>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Edit list": "編輯清單",
                "Delete list": "刪除清單",
                    "Are you sure you want to delete this list?": "您確定要刪除此清單嗎？",
                        // 頂部提醒
                        // [/Deleted \"(.*)\"./, "已刪除 “$1”。], // 刪除星標清單
                "Save list": "保存清單",
            "Add repositories to this list": "添加倉庫到此清單",
            "Star repositories on GitHub to keep track of your favorite projects and inspirational code.": "GitHub 上的星標倉庫可以跟蹤您最喜歡的專案和鼓舞人心的程式碼。",
            "Explore repositories.": "探索倉庫。",
    },
    "regexp": [ // 正則翻譯
        [/Deleted \"(.*)\"./, "已刪除 “$1”。"], // 刪除星標清單 頂部提醒
        [/doesn’t have any starred repositories yet./, "尚無任何星標倉庫。"],
        [/That’s it. You’ve reached the end of ([^ ]+)’s stars./, "而已。您已經到了$1 星海的盡頭。"], // 他人星標頁 搜索結果
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members?/, "$1 成員"], // 組織 浮動信息卡
        [/Language: /, "語言："],
    ],
    "title": {
        "static": {
            "Your Stars": "我的星標",
        },
        "regexp": [
            [/Your list/, "我的清單"],
            [/Starred/, "星標"],
            [/'s list/, " 的清單"],
        ],
    },
};

I18N["zh-TW"]["confirm-access"] = { // “授權訪問” 對話框
    "static": { // 靜態翻譯
        // 授權訪問 sudo 模式身份驗證
            "Confirm access": "授權訪問",
            "Signed in as": "登錄身份為",
            "Authentication code": "驗證碼",
                "More information about sudo mode authentication": "更多關於 sudo 模式身份驗證的信息",
            "Open your two-factor authenticator (TOTP) app or browser extension to view your authentication code.": "打開您的雙因素身份驗證器 (TOTP) 應用或瀏覽器擴展以查看您的身份驗證碼。",
            "Verify": "驗證",
            "Verify": "驗證",
            "Verifying…": "驗證中…",
            "Your authentication code has been sent.": "您的驗證碼已發送。",

            "Having problems?": "有問題嗎？",
            "Use GitHub Mobile": "使用 GitHub Mobile",
            "Use your passkey": "使用您的通行密鑰",
            "Use your authenticator app": "使用您的身份驗證器應用",
            "Send a code via email": "通過電子郵件發送驗證碼",
            "Use your password": "使用您的密碼",

            "GitHub Mobile": "GitHub Mobile",
            "Creating a verification request for your GitHub Mobile app.": "為您的 GitHub Mobile 應用創建驗證請求。",
            "We sent you a verification request on your GitHub Mobile app. Enter the digits shown below to enter sudo mode.": "我們向您的 GitHub Mobile 應用發送了一個驗證請求。輸入下面顯示的數字以進入 sudo 模式。",
            "We could not verify your identity": "我們無法核實您的身份",
            "Retry": "請重試",

            "Password": "密碼",
            "Forgot password?": "忘記密碼？",
            "Confirm": "確認",

            "Passkey": "通行密鑰",
            "When you are ready, authenticate using the button below.": "準備好後，請使用下面的按鈕進行身份驗證。",
            "This browser or device does not fully support passkeys.": "此瀏覽器或設備不完全支持通行密鑰。",
            "Use passkey": "使用通行密鑰",

            "Authentication failed.": "認證失敗。",
            "Retry passkey": "重試通行密鑰",

            "Unable to verify with your passkey?": "無法驗證您的通行密鑰？",
    },
};

I18N["zh-TW"]["payment-module"] = { // 通用賬單及支付信息模塊
    "static": { // 靜態翻譯
        "Account": "賬戶",
            "Personal account": "個人賬戶",

        "Billing information": "賬單信息",
            "You have not added any billing information.": "您尚未添加賬單信息。",
               "Add your information to show on every invoice": "在每張發票上添加您的信息",

            // 添加/編輯賬單信息
                "First name": "名字",
                    "First name can't be blank.": "名字不能為空。",
                    "First name can't be blank": "名字不能為空",
                "Last name": "姓氏",
                    "Last name can't be blank.": "姓氏不能為空。",
                    "Last name can't be blank": "姓氏不能為空",
                "Address": "地址",
                    "(Street, P.O. box)": "（街道，郵政信箱）",
                    "Address can't be blank.": "地址不能為空。",
                    "Address can't be blank": "地址不能為空",
                "Address line 2": "地址第 2 行",
                    "(Apartment, suite, unit)": "（公寓、套房、單元）",
                "City": "城市",
                    "City can't be blank.": "城市不能為空。",
                    "City can't be blank": "城市不能為空",
                "Country/Region": "國家/地區",
                "State/Province": "州/省",
                    "Required for certain countries": "某些國家/地區需要",
                "Postal/Zip code": "郵政編碼",
                    "(9-digit zip code for US)": "（美國為 9 位郵政編碼）",
                "VAT/GST ID": "增值稅/消費稅編號",

                "Save billing information": "保存賬單信息",
                "Save and continue": "保存並繼續",

            // 頂部提醒
                "You have not added any billing information.": "您尚未添加賬單信息。",
                "Successfully updated billing information.": "保存賬單信息成功。",
                "An error occurred while saving billing information.": "保存賬單信息發生錯誤。",

            // 組織設置
                "This organization is linked with your billing information:": "該組織與您的賬單信息相關聯：",

                "An organization owner or billing manager must link their personal billing information with this organization account. You can switch to a business account to use your business’ billing information by": "組織所有者或賬單管理者必須將其個人賬單信息與該組織賬戶關聯。您可以切換到企業賬戶，以使用企業的賬單信息通過",
                "signing": "簽署",
                "the": " ",
                "GitHub Customer Agreement": "GitHub 客戶協議",

                "Allow my billing information to be linked with this organization": "允許我的賬單信息與該組織關聯",

                    "Confirm your details shown below. To make changes,": "確認以下顯示的詳細信息。要做出更改，",
                    "edit your billing information": "請編輯您的賬單信息",

                "Update your billing information": "更新您的賬單信息",
                "to be able to link it with this organization.": "以便與該組織關聯。",
                    // 頂部提醒
                        "You have successfully linked your billing information with this organization.": "您已成功將您的賬單信息與該組織關聯。",

                // 移除對話框
                    "Remove": "移除",
                    "Remove your billing information?": "確定移除您的賬單信息？",
                        "You are about to remove the billing information for this organization. Are you sure you want to do this?": "您即將移除此組織的賬單信息。確定要繼續此操作嗎？",
                    "Remove billing information": "移除賬單信息",
                    // 頂部提醒
                        "Successfully removed billing information.": "已成功移除賬單信息。",

            // 其他
                // 來自 https://github.com/marketplace/<app-name>/order/<order-id>?account=<account-name>
                    "Please confirm your billing details to continue. You only need to do this once.": "請確認您的賬單詳情以繼續。您只需確認一次。",

        "payment method": "支付方式",
        "Payment method": "支付方式",
        "Payment Method": "支付方式",
            "You have not added a payment method.": "您尚未添加支付方式。",

        "Payment information": "支付信息",
            "Pay with": "支付方式：",
                "Loading payment information…": "正在加載支付信息…",

                "Credit or debit card": "信用卡或借記卡",
                    "Card Number *": "卡號",
                    "Expiration Date (YYYY) *": "終止日期 (YYYY) *",
                        "- Select One -": "- 選擇一個 -",
                    "Save payment information": "保存付款信息",
                    "You are currently paying with your PayPal account": "您目前正在使用您的 PayPal 賬戶支付",
                    ", but you can switch to using a credit or debit card at any time.": "，但是您隨時可以切換到使用信用卡或借記卡支付。",

                "PayPal account": "PayPal 賬戶",
                "Paypal account": "PayPal 賬戶",
                    "Sign in to": "登錄到",
                    "Connecting to PayPal…": "正在連接到 PayPal…",
                    "Sorry, we’re having trouble with PayPal right now, please try again a bit later.": "抱歉，我們目前與 PayPal 的連接遇到問題，請稍後再試。",
                    "PayPal update": "",
                    "Charge to": "收費至",
                    "Sign in to PayPal to use a different account.": "登錄 PayPal 以使用其他賬戶。",
                    "You are currently paying with a credit card, but you can switch to using PayPal at any time.": "您目前使用信用卡付款，但您可以隨時切換為使用 PayPal。",

                // 頂部提醒
                    "An error occurred while saving payment information.": "保存支付信息時發生錯誤。",
                    "Your PayPal account has been successfully added.": "您的 PayPal 賬戶已成功添加。",
                    "Your credit card has been successfully updated.": "您的信用卡已成功更新。",

                "504 Gateway Time-out": "504 網關超時",
                "We may place a temporary hold on your payment method to verify its validity. This is not a charge, and it will be released automatically after verification.": "我們可能會暫時凍結您的支付方式以驗證其有效性。這不是收費，驗證後將會自動解除。",
    },
};

I18N["zh-TW"]["settings-menu"] = { // 設置 - 公共部分
    "static": { // 靜態翻譯
        "Settings": "設置", // 新版全局導航

        "Your personal account": "我的個人賬戶",
        "Switch settings context": "切換設置上下文", // 存在組織時
        "Go to your personal profile": "去我的個人資料",
        // 左側菜單
        "Public profile": "基本資料",
        "Account": "賬戶",
        "Appearance": "外觀",
        "Accessibility": "無障礙",
        "Notifications": "通知",

        "Access": "訪問",
            "Billing and licensing": "賬單和許可",
                "Usage": "使用情況",
                "Premium request analytics": "高級請求分析",
                "Budgets and alerts": "預算和警報",
                "Licensing": "許可",
                "Payment information": "支付信息",
                "Payment history": "支付歷史",
                "Additional billing details": "其他賬單",
                "Education benefits": "教育福利",
            "Emails": "電子郵箱",
            "Password and authentication": "密碼和身份驗證",
            "Sessions": "會話",
            "SSH and GPG keys": "SSH 與 GPG 公鑰",
            "Organizations": "組織",
            "Enterprises": "企業版",
            "Moderation": "節制",
                "Blocked users": "黑名單",
                "Interaction limits": "互動限制",
                "Code review limits": "程式碼審查限制",

        "Code, planning, and automation": "程式碼、規劃和自動化",
            // "Repository": "倉庫"
            // 程式碼空間
            "Models": "模型",
            "Packages": "軟體包",
            "Copilot": "GitHub Copilot",
                "Features": "功能",
                "Coding agent": "編程智能體",
            "Pages": "GitHub Pages",
            "Saved replies": "快捷回覆",

        // "Security": "安全",
            "Code security": "程式碼安全性",

        "Integrations": "集成",
            "Applications": "應用",
            "Scheduled reminders": "定時提醒",

        "Archives": "存檔",
            "Security log": "安全日誌",
            "Sponsorship log": "贊助日誌",

        "Developer settings": "開發者設置",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
};

I18N["zh-TW"]["orgs-settings-menu"] = { // 組織設置 公共部分
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["orgs-public"]["static"],

        // 公用部分
            "Organization": "組織",
            "Switch settings context": "切換設置上下文", // 存在組織時
            "Go to your organization profile": "去我的組織主頁",
        // 左側菜單
            "General": "常規",
            "Policies": "策略",
            "Access": "訪問",
                "Billing and licensing": "賬單和許可",
                    "Usage": "使用情況",
                    "Budgets and alerts": "預算和警報",
                    "Licensing": "許可",
                    "Payment information": "支付信息",
                    "Payment history": "支付歷史",
                    "Additional billing details": "其他賬單",
                "Organization roles": "組織角色",
                    "Role management": "角色管理",
                    "Role assignments": "角色分配",
                "Repository roles": "倉庫角色",
                "Member privileges": "成員權限",
                // "Team discussions": "團隊討論",
                "Import/Export": "導入/導出",
                "Moderation": "節制",
                    "Blocked users": "黑名單",
                    "Interaction limits": "互動限制",
                    "Code review limits": "程式碼審查限制",
                    "Moderators": "版主",

            "Code, planning, and automation": "程式碼、規劃和自動化",
                "Repository": "倉庫",
                    "Topics": "主題",
                    "Rulesets": "規則集",
                    "Rule insights": "規則洞察",
                    "Custom properties": "自定義屬性",
                "Codespaces": "程式碼空間",
                "Planning": "計劃",
                    "Issue types": "議題類型",
                "Copilot": "GitHub Copilot",
                    "Access": "訪問",
                    "Coding agent": "編程智能體",
                "Actions": "操作",
                    "Runners": "運行器",
                    "Runner groups": "運行器組",
                    "Custom images": "自定義鏡像",
                    "Caches": "緩存",
                "Models": "模型",
                    "Development": "開發",
                    "Custom models": "自定義模型",
                "Webhooks": "Web 鉤子",
                "Packages": "軟體包",
                "Projects": "專案",

            "Security": "安全",
                "Authentication security": "身份驗證安全",
                "Advanced Security": "高級安全",
                    "Configurations": "配置",
                    "Global settings": "全局設置",
                "Deploy keys": "部署密鑰",
                "Compliance": "承諾",
                "Verified and approved domains": "經驗證和批准的域名",
                "Secrets and variables": "機密和變量",
                    "Private registries": "私有註冊表",

            "Third-party Access": "第三方訪問",
                "GitHub Apps": "GitHub 應用",
                "OAuth app policy": "OAuth 應用策略",
                "Personal access tokens": "個人訪問令牌",
                    "Active tokens": "活躍的令牌",
                    "Pending requests": "待處理的請求",

            "Integrations": "集成",
                "Scheduled reminders": "定時提醒",

            "Archive": "存檔",
                "Logs": "日誌",
                    "Sponsorship log": "贊助日誌",
                    "Audit log": "審計日誌",
                "Deleted repositories": "刪除的倉庫",

            "Developer settings": "開發者設置",
                "OAuth Apps": "OAuth 應用",
                "Publisher Verification": "發佈者驗證",
            "Account settings": "賬戶設置",

            "Developer Settings": "開發者設置"
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
};

I18N["zh-TW"]["settings/profile"] = { // 設置 - 個人資料
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Profile 個人資料 https://github.com/settings/profile
            "Public profile": "基本資料",
            "Profile picture": "我的頭像",
                "Edit": "編輯",
                "Upload a photo…": "上傳圖片…",
                "Remove photo": "刪除圖片",
                "Are you sure you want to reset your current avatar?": "您確定要重置當前的頭像嗎？",
                "Your profile picture has been reset. It may take a few minutes to update across the site.": "您的個人頭像已重置，整個網站的更新可能需要幾分鐘的時間。",
                "Your profile picture has been updated. It may take a few minutes to update across the site.": "您的個人頭像已更新，整個網站的更新可能需要幾分鐘的時間。",
                // 裁剪個人頭像對話框
                "Crop your new profile picture": "裁剪個人頭像",
                "Set new profile picture": "設置新的個人頭像",
            //"You can also drag and drop a picture from your computer.": "您也可以直接拖拽照片鏡像上傳.",
            "Name": "暱稱",
            "Your name may appear around GitHub where you contribute or are mentioned. You can remove it at any time.": "您的暱稱可能會出現在 GitHub 上，您的貢獻或被提及的地方。您可以隨時刪除它。",
            "Public email": "公開電子郵箱",
            "Remove": "移除",
            "Select a verified email to display": "選擇顯示一個已驗證的電子郵箱",
            "You have set your email address to private. To toggle email privacy, go to": "您已將電子郵箱地址設置為私密。需要切換電子郵箱地址的私密性，請轉到",
            "email settings": "郵箱設置",
            "and uncheck \"Keep my email address private.\"": "並取消 “保持我的電子郵箱地址的私密性”。",
            "You can manage verified email addresses in your": "您可以管理已驗證的電子郵箱地址在您的",
            //"Don’t show my email address": "不顯示我的郵箱",
            //"You can add or remove verified email addresses in your": "您可以添加或刪除郵件地址在您的",
            //"personal email settings": "郵箱設置",
            "Bio": "個人簡介",
            "Tell us a little bit about yourself": "自我介紹一下您自己的相關信息",
            "You can": "您可以",
            "@mention": "@用戶名或組織名",
            "other users and organizations to link to them.": "鏈接到其他用戶和組織。",
            "URL": "網站",
            "Social accounts": "社交賬戶",
                "Link to social profile 1": "鏈接到社交賬戶",
                "Link to social profile 2": "鏈接到社交賬戶",
                "Link to social profile 3": "鏈接到社交賬戶",
                "Link to social profile 4": "鏈接到社交賬戶",
            "Company": "公司",
            "your company’s GitHub organization to link it.": "鏈接到您所在公司的 GitHub 組織。",
             //"your company's GitHub organization to link it.": "貴公司和GitHub的組織聯繫起來。",
            "Pronouns": "代詞",
                "Don't specify": "不說明",
                "they/them": "他們",
                "she/her": "她",
                "he/him": "他",
                "Custom": "自定義",
            "Location": "位置",
            "Display current local time": "顯示當前當地時間",
                "Other users will see the time difference from their local time.": "其他用戶將看到與本地時間的時差。",
                "Time zone": "時區",

            "All of the fields on this page are optional and can be deleted at any time, and by filling them out, you're giving us consent to share this data wherever your user profile appears. Please see our": "此頁面上的所有字段都是可選的，可以隨時刪除，填寫這些字段，即表示您同意我們在您的個人資料出現的任何地方共享此數據。請參閱我們的",
            "privacy statement": "隱私聲明",
            "to learn more about how we use this information.": "以瞭解更多關於我們如何使用這些信息。",
            "Update profile": "更新資料",
            // 頂部提醒
                "Profile updated successfully": "資料更新成功。",
                "Profile updated successfully —": "資料更新成功 —",
                "view your profile.": "查看您的個人資料。",

            "Contributions & activity": "貢獻與活動",
                "Make profile private and hide activity": "將個人資料設置為私密，並隱藏活動",
                    "Enabling this will hide your contributions and activity from your GitHub profile and from social features like followers, stars, feeds, leaderboards and releases.": "啟用此功能後，您的貢獻和活動將會從您的 GitHub 個人資料中隱藏起來，也不會被關注者、觀星者、動態提要、排行榜和發佈等社交功能所發現。",
                "Include private contributions on my profile": "在我的個人資料顯示私人貢獻",
                    "Your contribution graph, achievements, and activity overview will show your private contributions without revealing any repository or organization information.": "您的貢獻圖、成就和活動概覽將顯示您的私人貢獻，而不會透露任何倉庫或組織信息。",
                    "Read more": "瞭解更多",
            "Update preferences": "更新設置",

            "Profile settings": "個人資料設置",
                "Display PRO badge": "顯示 PRO 徽章",
                    "This will display the": "將會顯示",
                    "badge on your public profile page.": "徽章在您的個人資料中。",
                "Show Achievements on my profile": "在我的個人資料上顯示成就",
                    "Your achievements will be shown on your profile.": "您的成就將顯示在您的個人資料中。",

            "GitHub Developer Program": "GitHub 開發者計劃",
                "has guides, API and webhook references, information about creating GitHub Apps and other resources for building applications that integrate with GitHub. Make sure your contact information is up-to-date below. Thanks for being a member!": "包含指南、API 和 Web 鉤子、有關創建 GitHub 應用的信息以及用於構建與 GitHub 集成的應用的其他資源。確保您的聯繫信息是最新的。感謝您的加入！",

                "Support email address": "技術支持電子郵件地址",
                    "An email address where GitHub users can contact you for support.": "供 GitHub 用戶聯繫您尋求支持的電子郵件地址。",
                "Product or company website": "產品或公司網站",
                    "The URL for the product, company, or service that integrates with GitHub.": "與 GitHub 集成的產品、公司或服務的網址。",
                "Update contact information": "更新聯繫信息",
                "Leave the program": "退出計劃",

                "Building an application, service, or tool that integrates with GitHub?": "構建與 GitHub 集成的應用、服務或工具？",
                "Join the GitHub Developer Program": "加入 GitHub 開發者計劃",
                ", or read more about it at our": "，或瞭解更多信息在我們的",
                "GitHub developer program": "GitHub 開發者計劃",
                "Developer site": "開發者站點",

            "Jobs profile": "就業狀態",
            "Available for hire": "求 HR 帶走",
            "Save jobs profile": "保存狀態",
                // 頂部提醒
                "Profile updated successfully —": "個人資料更新成功 —",
                "view your profile.": "查看您的個人資料。",
                "Visitors will now see your public and anonymized private contributions.": "現在訪客可以看到您的公開和匿名私人貢獻。",
                "Visitors will now see only your public contributions.": "現在訪客只能看到您的公開貢獻",

            "Trending settings": "趨勢設置",
            "Preferred spoken language": "首選語言",
            "No Preference": "未設置",
            "We'll use this language preference to filter the trending repository lists on": "我們將使用此語言偏好來過濾趨勢倉庫列表在",
            "our": "我們的",
            "Trending Repositories": "趨勢倉庫",
            "page.": "頁面。",
            "Save Trending settings": "保存趨勢設置",

            "ORCID provides a persistent identifier - an ORCID iD - that distinguishes you from other researchers. Learn more at": "ORCID 提供持久標識符 - ORCID iD - 將您與其他開發人員區分，瞭解更多信息請訪問",
            "Connect your ORCID iD": "關聯您的 ORCID iD",
            "Successfully connected your GitHub account with ORCID.": "已成功將您的 GitHub 賬戶與 ORCID 關聯。",
            "You have a connected ORCID iD": "您的 ORCID iD",
            "for the account": "已關聯賬戶",
            "Display your ORCID iD on your GitHub profile": "在您的 GitHub 個人資料上顯示 ORCID iD",
            "Disconnecting your ORCID iD may affect areas of your profile where your ORCID iD is displayed.": "解除關聯 ORCID iD 可能會影響您個人資料中顯示 ORCID iD 的區域。",
            "Disconnect your ORCID iD": "解除關聯您的 ORCID iD",
            "Successfully disconnected ORCID from your GitHub Account.": "已成功解除 ORCID 與您的 GitHub 賬戶的連接。",
    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Your profile": "個人資料",
        },
    },
};
I18N["zh-TW"]["settings"] = I18N["zh-TW"]["settings/profile"];

I18N["zh-TW"]["settings/admin"] = { // 設置 - 賬戶
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Account settings 賬戶設置 https://github.com/settings/admin
            "Change username": "更改用戶名",
            "Changing your username can have": "更改您的用戶名可能會有",
            "unintended side effects": "意想不到的副作用",
                "Really change your username?": "確定要更改您的用戶名？",
                "Unexpected bad things will happen if you don’t read this!": "請仔細閱讀以下提示信息！！！",
                "We": "我們",
                "will not": "不會",
                "will": "會",
                "set up redirects for your old profile page.": "為您的舊資料頁設置重定向",
                "set up redirects for Pages sites.": "為 GitHub Pages 站點設置重定向。",
                "create redirects for your repositories (web and git access).": "為您的倉庫設置重定向（ web 和 git 訪問）。",
                "Renaming may take a few minutes to complete.": "重命名可能需要幾分鐘的時間來完成。",
                "I understand, let’s change my username": "我明白了，依然更改我的用戶名",

                "Enter a new username": "輸入新用戶名",
                "Choose a new username": "選擇新用戶名",
                "Change my username": "更改我的用戶名",
                "Trademark Policy": "商標政策",
                "are available.": "都可以使用。",
                "Username may only contain alphanumeric characters or single hyphens, and cannot begin or end with a hyphen.": "用戶名只能包含字母數字字符或單個連字符，不能以連字符開始或結束。",
            "Looking to manage account security settings? You can find them in the": "想管理賬戶安全設置？您可以在",
            "page.": "頁面找到它們。",

            "Link Patreon account": "關聯 Patreon 賬戶",
                "Connect a Patreon account for": "關聯",
                "to sponsor maintainers with. Get recognition on GitHub for sponsorships made on Patreon when the sponsored person has linked Patreon and GitHub, too, and has a public GitHub Sponsors profile.": "的 Patreon 賬戶，以便贊助維護者。當被贊助者也關聯 Patreon 和 GitHub 賬戶時，在 Patreon 上獲得的贊助也會顯示在 GitHub 上，並顯示 GitHub 贊助者的公開個人資料。",
                "Connect with Patreon": "關聯 Patreon 賬戶",
                "Successfully connected your GitHub account with Patreon.": "已成功將您的 GitHub 賬戶與 Patreon 關聯。",

            "Unlink Patreon account": "取消關聯 Patreon 賬戶",
                "Disconnect the Patreon account": "取消 Patreon 賬戶",
                "for": "和",
                "to sponsor maintainers with. Any sponsorships made on Patreon will no longer receive recognition on GitHub.": "的關聯，在 Patreon 上進行的任何贊助將不會在 GitHub 顯示。",
                "Successfully disconnected your GitHub account from Patreon.": "已成功解除您的 GitHub 賬戶與 Patreon 的關聯。",

            "Export account data": "導出賬戶數據",
            "Export all repositories and profile metadata for": "導出所有倉庫和配置元數據，自",
            ". Exports will be available for 7 days.": "。導出結果將有 7 天有效期。",
            "Start export": "開始導出",
            "Recent exports": "近期導出",
            "New export": "新建導出",
            "We're preparing your export! We'll send you an email when it's finished.": "我們正在為您準備導出！我們完成後會發一封電子郵件。",
            "New exports cannot be requested while an export is currently in progress": "當前正在導出中，無法請求新的導出",
            "Resend email with link": "重新發送帶有鏈接的郵件",
            "Download deleted": "導出內容已刪除",
            "Job queued to delete file.": "正在排隊刪除文件的作業。",

            "Successor settings": "設置繼任者",
            // 未指定
            "designated below": "（下面指定的）",
            ", in the event of my death. I understand that this appointment of a successor does not override legally binding next-of-kin rules or estate laws of any relevant jurisdiction, and does not create a binding will.": "。我明白，這種指定繼任者的做法並不凌駕於具有法律約束力的近親規則或任何相關司法管轄區的遺產法，也不產生具有約束力的遺囑。",
            "Learn more about account successors.": "瞭解更多關於賬戶繼任者的信息。",
            "Add Successor": "添加繼任者",
            "Search by username, full name, or email address": "搜索用戶名、全名、或電子郵箱",
            "You have not designated a successor.": "您還沒有指定繼任者。",
            // 等待回應
            "Pending": "待處理",
            "Copy invite link": "複製邀請鏈接",
            // 已指定
            "Learn more about account successors": "瞭解更多關於賬戶繼任者的信息",
            "Revoke": "撤銷",
            // 被謝絕
            "Declined": "被謝絕",

            "Delete account": "刪除賬戶",
            "Once you delete your account, there is no going back. Please be certain.": "您一旦刪除了您的賬戶，將再也無法恢復。請確認！",
                "Your account is currently an owner in these organizations:": "您的賬戶目前是以下組織的所有者：", // 存在組織
                "You must": "您必須先",
                "remove yourself": "刪除您自己",
                "transfer ownership": "轉讓所有權",
                "delete these organizations": "刪除這些組織",
                "before you can delete your user.": "，您才可以刪除您的用戶。",
            "Delete your account": "刪除賬戶",
            "Are you sure you don’t want to just": "您確定不希望僅僅是",
            "downgrade your account": "降級您的賬戶",
            "to a": "為",
            "FREE": "免費",
            "account? We won’t charge your credit card anymore.": "賬戶嗎？我們不會再向您信用卡賬戶扣款。",
            "account? We won’t charge your payment information anymore.": "賬戶嗎？我們不會再向您支付賬戶扣款。",
            "account? We won’t charge your PayPal account anymore.": "賬戶嗎？我們將不再向您 PayPal 賬戶扣款。",
                "Are you sure you want to do this?": "您確定要這麼做嗎？",
                "This is extremely important.": "這是極其重要的。",
                "We will": "我們將",
                ", along with all of your forks, wikis, issues, pull requests, and GitHub Pages sites.": "以及您所有的複刻、Wiki、議題、拉取請求和 GitHub Pages 站點。",
                "You will no longer be billed, and after 90 days your username will be available to anyone on GitHub.": "您將不再被收取費用，並且 90 天后您的用戶名將被 GitHub 上的任何人使用。",
                "For more help, read our article \"": "如需更多幫助，請閱讀我們的文章 “",
                "Deleting your user account": "刪除您的賬戶",
                "\".": "”。",
                "Your username or email:": "您的用戶名或電子郵箱：",
                "To verify, type": "為了驗證，請輸入",
                "below:": "在下面：",
                "Confirm your password:": "確認您的密碼：",
                "Cancel plan and delete this account": "取消計劃並刪除此賬戶",

    },
    "regexp": [ // 正則翻譯
        [/is available\./, "可用。"],
        [/Username ([^ ]+) is not available\. Please choose another\. To submit a trademark claim, please see our/, "用戶名 $1 不可用。請重新選擇。要提交商標索賠，請看我們的"],
        [/immediately delete all of your repositor(y|ies) \((\d+)\)/, "立即刪除您所有的倉庫（$1個）"],

        // 設置繼任者
        [/By clicking \"Add Successor\" below, I acknowledge that I am the owner of the([^@]+@[^\n]+) account, and am authorizing GitHub to transfer content within that account to my GitHub Successor,/, "通過點擊下面的 “添加繼任者”，我確認我是 $1 賬戶的所有者，並授權 GitHub 在我死亡的情況下將此賬戶內的內容轉讓給我的 GitHub 繼任者"],
        [/This link will only work for ([^ ]+)./, "此鏈接僅對 $1 有效。"],

        // 頂部提醒
        [/You have successfully sent the successor invitation to ([^ ]+)./, "您已經成功向 $1 發送了繼任者邀請。"],
        [/You have revoked the successor invitation to ([^ ]+)./, "您已經撤銷了對 $1 的繼任者邀請。"],
        [/You have canceled the invitation to ([^ ]+) to be your designated successor./, "您已經取消了讓 $1 成為您的指定繼任者的邀請。"],
    ],
    "title": {
        "static": {
            "Account settings": "賬戶設置",
        },
    },
};

I18N["zh-TW"]["succession/invitation"] = { // 賬戶繼任者邀請  users/<邀請者的 user-name>/succession/invitation
    "static": { // 靜態翻譯
        // 受邀者
        "invited you to be their account successor": "邀請您成為其賬戶繼任者",
        "Learn more about account successors": "瞭解更多關於賬戶繼任者的信息",
        //[/By clicking \"Accept invitation\" below, I acknowledge that I agree to serve as the successor for ([^ ]+), in such ways authorized by their successor request. I agree to abide by GitHub's/, "通過點擊下面的 “接受邀請”，我確認我同意按照其繼任者要求所授權的方式擔任 $1 的繼任者。我同意在使用和維護其帳戶內容時遵守 GitHub 的"],
        "Terms of Service": "服務條款",
        "and the user's written requests, if any, in my use and maintaining of their account's content.": "和用戶的書面請求（如果有）。",
        "I understand that accepting this appointment as successor does not override legally binding next-of-kin rules or estate laws of any relevant jurisdiction, and does not create a binding will, and I agree to comply or assist with a valid request by an individual with legal authority over the user's property (such as next-of-kin, an estate's executor, and/or a beneficiary of their will).": "我明白，接受此繼任者任命的做法並不凌駕於具有法律約束力的近親規則或任何相關司法管轄區的遺產法，也不產生具有約束力的遺囑，並且我同意遵守或協助對用戶財產擁有合法權力的個人（例如近親、遺產執行人和/或其遺囑受益人）的有效請求。",
        "Accept invitation": "接受邀請",
        "Decline": "謝絕",
        // 已接受
        "This invitation has already been accepted.": "此邀請已被接受。",
        // 已謝絕
        "This invitation has already been declined.": "此邀請已被謝絕。",
        // 不存在
        "Invitation not found": "此邀請已被謝絕。",
        "Your invitation could not be found, or is not valid.": "找不到您的邀請，或是其已不再有效。",
    },
    "regexp": [ // 正則翻譯
        [/As an account successor, you would be able to manage ([^ ]+)'s repositories if they're not able to./, "作為賬戶繼任者，在 $1 再也無法管理其倉庫時，您將能夠管理其倉庫。"],
        [/By clicking \"Accept invitation\" below, I acknowledge that I agree to serve as the successor for ([^ ]+), in such ways authorized by their successor request. I agree to abide by GitHub's/, "通過點擊下面的 “接受邀請”，我確認我同意按照其繼任者要求所授權的方式擔任 $1 的繼任者。我同意在使用和維護其帳戶內容時遵守 GitHub 的"],
    ]
};

I18N["zh-TW"]["settings/appearance"] = { // 設置 - 外觀
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Appearance 外觀 https://github.com/settings/appearance
            "Theme preferences": "主題首選項",
            "Choose how GitHub looks to you. Select a single theme, or sync with your system and automatically switch between day and night themes. Selections are applied immediately and saved automatically.": "選擇 GitHub 在您眼中的樣子。選擇單一主題，或與您的系統同步並自動在白天和夜晚的主題之間切換。選擇將立即生效並自動保存。",
            "Theme mode": "主題模式",
                "Single theme": "單一主題",
                "Sync with system": "與系統同步",
            "GitHub will use your selected theme": "GitHub 將使用您選擇的主題",
            "GitHub theme will match your system active settings": "GitHub 主題將匹配您的系統設置",
            "Light default": "淺色 - 默認",
            "Light colorblind": "淺色 - 色盲",
            "Light Tritanopia": "淺色 - 藍色盲",
            "Dark default": "深色 - 默認",
            "Dark colorblind": "深色 - 色盲",
            "Dark Tritanopia": "深色 - 藍色盲",
            "Soft dark": "深色 - 柔和",
            "Light theme": "淺色主題",
            "Dark theme": "深色主題",
            "Active": "激活",
            "This theme will be active when your system is set to “light mode”": "當您的系統設置為 “淺色模式” 時，該主題將被激活。",
            "This theme will be active when your system is set to “dark mode”": "當您的系統設置為 “深色模式” 時，該主題將被激活。",
            "Beta":"預覽",

            "Contrast": "對比度",
                "Increase contrast": "增加對比度",
                    "Enable high contrast for light or dark mode (or both) based on your system settings": "根據您的系統設置啟用對淺色或深色模式（或兩者）的高對比度",
                    "Light mode": "淺色模式",
                    "Dark mode": "深色模式",
                    "Off": "關閉",
                    "On": "開啟",

            "Emoji skin tone preference": "表情符號膚色首選項",
            "Preferred default emoji skin tone": "默認的表情符號膚色",

            "Tab size preference": "製表符首選項",
            "Choose the number of spaces a tab is equal to when rendering code": "在渲染程式碼時，選擇一個製表符等於多少個空格",
            "4 (Default)": "4 (默認)",

            "Markdown editor font preference": "Markdown 編輯器字體首選項",
            "Font preference for plain text editors that support Markdown styling (e.g. pull request and issue descriptions, comments.)": "支持 Markdown 樣式的純文本編輯器的字體首選項（例如拉取請求和議題描述、評論。）",
            "Use a fixed-width (monospace) font when editing Markdown": "編輯 Markdown 時使用固定寬度（等寬）字體",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Appearance": "外觀",
        },
    },
};

I18N["zh-TW"]["settings/accessibility"] = { // 設置 - 無障礙
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Accessibility 無障礙 https://github.com/settings/accessibility
            "General": "通常",
            "Character keys": "字符鍵",
                "GitHub shortcuts": "GitHub 快捷鍵",
                "that don't use modifier keys in their activation. For example, the": "，這些快捷鍵在激活時不使用修改鍵。例如，",
                "shortcut to navigate notifications, or": "快捷鍵來導航到通知，或",
                "to view context relevant shortcuts.": "查看與上下文相關的快捷鍵。",
                "Learn more about character key shortcuts": "瞭解更多關於字符快捷鍵的信息",
                "Save keyboard shortcut preferences": "保存鍵盤快捷鍵首選項",

            // 頂部提醒
                "Keyboard shortcut preference successfully saved.": "鍵盤快捷鍵首選項已成功保存。",

            "Command palette": "命令面板",
                "Modify the shortcuts to trigger the Command Palette for the default search mode and the command mode": "修改快捷鍵以觸發默認搜索模式和命令模式的命令面板",
                "Search mode": "搜索模式",
                    "control + k or control + alt + k (default)": "control + k 或 control + alt + k (默認)",
                    "Disabled": "禁用",
                "Command mode": "命令模式",
                    "control + shift + k (default)": "control + shift + k (默認)",
                "Save command palette preferences": "保存命令面板首選項",

            "Motion": "動態",
                "Autoplay animated images": "自動播放動態圖片",
                    "Select whether animated images should play automatically.": "選擇是否需要自動播放動態圖片。",
                "Sync with system": "與系統同步",
                    "Adopts your system preference for reduced motion": "採用您的系統偏好以減少運動",
                "Enabled": "啟用",
                    "Automatically plays animated images": "自動播放動態圖片",
                // 禁用
                    "Prevents animated images from playing automatically": "防止自動播放動態圖片",
                "Save motion preferences": "保存動態首選項",

            // 頂部提醒
                "Motion preferences successfully saved.": "動態首選項已成功保存。",

            "Content": "內容",
                "Link underlines": "鏈接下劃線",
                    "Toggle the visibility of underlines on links that are adjacent to text.": "切換文本相鄰鏈接上下劃線的可見性。",
                "Hide link underlines": "隱藏鏈接下劃線",
                "Show link underlines": "顯示鏈接下劃線",
                "Save content preferences": "保存內容首選項",

            // 頂部提醒
                "Link underline preferences successfully saved.": "鏈接下劃線首選項已成功保存。",

            "Hovercards": "懸浮卡",
                "preview information about other parts of GitHub.": "預覽 GitHub 其他部分的信息。",
                "Show hovercards": "顯示懸浮卡",
                    "Enable previewing link content via mouse hover or keyboard focus before navigation. Move focus to hovercard content using": "在導航之前，可通過鼠標懸停或鍵盤聚焦預覽鏈接內容。使用以下方法將焦點移至懸停卡片內容",
                "Save hovercard preferences": "保存懸浮卡偏好設置",
            // 頂部提醒
                "Hovercard preferences successfully saved.": "懸浮卡首選項已成功保存。",

            "Editor settings": "編輯器設置",
                "URL paste behavior": "URL 粘貼行為",
                "Select if URLs should be formatted on paste. You can use": "選擇是否應在粘貼時格式化 URL。您可以使用",
                "to paste a link in the opposite way.": "以相反的方式粘貼鏈接。",
                "Formatted link": "格式化鏈接",
                    "Pasting a URL while having text selected will format to a Markdown link": "在選擇了文本的情況下，粘貼 URL 將格式化為 Markdown 鏈接",
                "Plain text": "純文本",
                    "Pasting a URL while having text selected will replace the text": "在選擇了文本的情況下，粘貼 URL 將替換文本",
                "Save editor settings": "保存編輯器設置",
            // 頂部提醒
                    "Paste behavior preferences successfully saved.": "粘貼行為首選項已成功保存。",

            "Assistive technology hints": "輔助技術提示",
                "Add or remove instructions for how to operate complex controls.": "添加或刪除如何操作複雜控件的說明。",
                // 懸浮卡
                    "Enable screen reader hint": "啟用屏幕閱讀器提示",
                    "Disable screen reader hint": "禁用屏幕閱讀器提示",
                "Save assistive technology hint preferences": "保存輔助技術提示首選項",
            // 頂部提醒
                "Hovercard assistive technology hint preferences successfully saved.": "懸浮卡輔助技術提示首選項已成功保存。",
    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Accessibility": "無障礙",
        },
    },
};

I18N["zh-TW"]["settings/notifications"] = { // 設置 - 通知
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Notification center 通知 https://github.com/settings/notifications
            "Default notifications email": "默認郵件通知設置",
                "Choose where you'd like emails to be sent. You can add more email addresses. Use custom routes to specify different email addresses to be used for individual organizations.": "請選擇希望接收通知郵件的郵箱。您可以添加多個郵箱地址。可藉助自定義路由為不同的組織指定不同的郵箱地址。",
                "Custom routing": "自定義路由",

            "Automatically watch repositories": "自動關注倉庫",
                "When you're given push access to a repository, automatically receive notifications for it.": "當您給一個倉庫推送權限時，自動接收相關通知。",
            "Automatically watch teams": "自動關注團隊",
                "Anytime you join a new team, you will automatically be subscribed to updates and receive notification when that team is @mentioned.": "當您加入新團隊時，您將自動訂閱更新，並在該團隊 @提及 時收到通知。",

                "On": "開啟",
                "Off": "關閉",

            "Subscriptions": "訂閱",
                "Watching": "關注倉庫",
                    "Notifications for all repositories, teams, or conversations you're watching.": "所有您正在關注的倉庫、團隊或對話所發出的通知。",
                    "View watched repositories": "查看正在關注的倉庫",
                    "Notify me:": "提醒我：",
                    "Select notification channels": "選擇通知渠道",
                    "on GitHub, Email, CLI": "在 GitHub、電子郵件、CLI 上",
                    "on GitHub, CLI": "在 GitHub、CLI 上",
                    "on GitHub, Email, CLI": "在 GitHub、電子郵件、CLI 上",
                    "on GitHub, Email": "在 GitHub、電子郵件 上",
                    "On GitHub": "在 GitHub 上",
                    "on GitHub": "在 GitHub 上",
                "Don't notify": "取消通知",

                "Participating, @mentions and custom": "參與、@提及和自定義",
                    "Notifications for the conversations you are participating in, or if someone cites you with an @mention. Also for all activity when subscribed to specific events.": "您參與的對話、或有人 @您、以及您訂閱的特定事件所發出的通知。",

                "Customize email updates": "自定義電子郵件更新",
                    "Choose which additional events you'll receive emails for when participating or watching.": "選擇參與或關注時，您將收到哪些額外活動的電子郵件。",
                    "Select events": "選擇事件",
                    "Reviews": "審查",
                    "Reviews, Pushes": "審查、推送",
                    "Reviews, Pushes, Comments": "審查、推送、評論",
                    "Reviews, Pushes, Comments, My own updates": "審查、推送、評論、自我更新",
                    "Pull Request reviews": "拉取請求審核",
                    "Pull Request pushes": "拉取請求推送",
                    "Comments on Issues and Pull Requests": "關於議題和拉取請求的評論",
                    "Includes your own updates": "包括您自己的更新",
                "Ignored repositories": "忽略的倉庫",
                "You'll never be notified.": "您將永遠不會收到通知。",
                "View ignored repositories": "查看忽略的倉庫",

            "System": "系統",
                "Actions": "操作",
                    "Notifications for workflow runs on repositories set up with": "倉庫的工作流程通知，設置在",
                    ". (": "。（",
                    "Failed workflows only": "僅工作流程失敗時",
                    "Only notify for failed workflows": "只對失敗的工作流程進行通知",

            "Dependabot alerts: New vulnerabilities": "Dependabot 警報：新漏洞",
                "When you're given access to": "當您獲得",
                "Dependabot alerts": "Dependabot 警報",
                "automatically receive notifications when a new vulnerability is found in one of your dependencies.": " 訪問權限時，當您的某個依賴項中發現新的漏洞時，就會自動收到通知。",

            "Dependabot alerts: Email digest": "Dependabot 警報：電子郵件摘要",
                "Email a regular summary of Dependabot alerts for up to 10 of your repositories.": "通過電子郵件發送最多 10 個倉庫庫的 Dependabot 警報定期摘要。",
                "Don't send": "不發送",
                "Send weekly": "每週發送",
                "Send daily": "每日發送",

            "Security campaign emails": "安全活動電子郵件",
                "Receive email notifications about security campaigns in repositories where you have access to security alerts.": "接收有關您有權訪問安全警報的倉庫中的安全活動的電子郵件通知。",

            "\'Deploy key\' alert email": "“部署密鑰” 警報電子郵件",
                "When you are given admin permissions to an organization, automatically receive notifications when a new deploy key is added.": "當您獲得組織的管理員權限時，會在添加新部署密鑰時自動接收通知。",

            "In-product messages": "產品消息",
                "Get tips, solutions and exclusive offers from GitHub about products, services and events we think you might find interesting.": "從 GitHub 獲取有關我們認為您可能感興趣的產品、服務和活動的提示、解決方案和獨家優惠。",

        // 通知 自定義路由 https://github.com/settings/notifications/custom_routing
                "/ Custom Routing": "/ 自定義路由",
                    "You can send notifications to different": "您可藉助自定義路由為不同的組織指定不同的郵箱地址",
                    "verified": "（經驗證的郵箱）",
                    "email addresses depending on the organization that owns the repository.": "。",
                    "is your current default email for notifications.": "是您目前默認的通知郵箱。",

                    "No custom routes yet.": "尚無自定義路由",
                    "Add new route": "添加新路由",
                        "Pick organization": "挑選組織",
                            "Select an item": "選擇一項",
                        "Search organizations": "搜索組織",
                        "Select Email": "選擇郵箱",
                        "Saved": "已保存",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Notification settings": "通知設置",
        },
    },
};

I18N["zh-TW"]["settings/billing"] = { // 設置 - 賬單和計劃
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置

        // 概況 https://github.com/settings/billing
            // 頂部提示
                "Successfully updated billing information.": "成功更新支付信息。",

                "For more information on using these billing pages": "有關使用這些賬單頁面的更多信息，",
                    "please refer to the docs content here": "請參閱此處的文檔內容",

            // 概況
                "Current metered usage": "當前計費用量",
                    "Gross metered usage for": " ",
                    "Showing gross metered usage for your account.": "顯示您賬戶的總計費用量。",
                    "Showing gross metered usage for your organization.": "顯示您組織的總計費用量。", // 組織

                "Current included usage": "當前包含用量",
                    "More details": "詳情",
                    "Included usage discounts for": " ",
                    "Showing currently applied discounts for your account.": "顯示您賬戶當前應用的折扣。",
                    "Showing currently applied discounts for your organization.": "顯示您組織當前應用的折扣。", // 組織
                    "* As per current pricing": "* 根據當前定價方案",
                    "Download your Copilot premium request usage report": "下載您的 Copilot 高級請求使用報告：",
                        "here": "下載",

                // 當前包含用量詳情
                    "Included usage and credits": "包含用量和額度",
                        "Showing currently applied usage and credits for your account.": "顯示您賬戶當前的使用情況和額度。", // 後續走正則

                        "Included usage*": "包含用量*",
                            "Included premium requests": "包含高級請求",
                            "Free usage**": "免費使用**",
                                "100% off per month": "100%減免/每月",

                        "* Included usage is an approximate amount based on current pricing.": "* 所包含的用量是基於當前定價的預估值。",
                        "** GitHub Packages usage is free for public packages. For details on free Actions usage, see": "** GitHub 軟體包對公共包的使用是免費的。有關 GitHub Actions 免費使用的詳細信息，請參閱",
                        "Free use of GitHub Actions": "Github Actions 的免費使用",

            "Next payment due": "下一次應付款",

            "Subscriptions": "訂閱",
                "Manage subscriptions": "管理訂閱",
                "per": "/",
                "month": "月",

            "Metered usage": "計費用量",
                "Usage by products": "按產品分類", // 省略重複內容
                // 時間段，這部分走正則
                    "Today": "今天",
                    "Current month": "這個月",
                    "Last month": "上個月",
                    // 後 2 項正則

                    "Billable usage": "計費",
                        // 操作
                        "consumed usage": "使用",
                        "discounts": "減免",

                        "Billable spend for Actions and Actions Runners for the selected timeframe. Applicable discounts cover Actions usage in public repositories and included usage for Actions minutes and storage.": "在所選時間範圍內，Actions 和 Actions 運行器的可計費支出。適用的折扣涵蓋公共倉庫中的 Actions 使用，以及包含的 Actions 分鐘數和存儲用量。",
                        "Billable spend for Codespaces for the selected timeframe.": "所選時間範圍內程式碼空間的可計費支出。",
                        "Billable spend for Git LFS for the selected timeframe. Applicable discounts cover included usage for Git LFS bandwidth and storage.": "所選時間範圍內 Git LFS 的可計費支出。適用的折扣涵蓋 Git LFS 帶寬和存儲的包含用量。",
                        "Billable spend for Packages for the selected timeframe. Applicable discounts cover Packages usage in public repositories and included usage for Packages data transfer and storage.": "所選時間範圍內軟體包的可計費支出。適用的折扣涵蓋公共倉庫中的軟體包使用，以及包含的軟體包數據傳輸和存儲用量。",
                    "Included usage": "包含",
                        "Manage budgets": "管理預算",
                        "Actions minutes": "操作分鐘數",
                        "Git LFS bandwidth": "Git LFS 帶寬",
                        "Git LFS storage": "Git LFS 存儲",
                        "Packages data transfer": "軟體包數據傳輸",
                        "Packages storage": "軟體包存儲",
                        "Included usage limits reset in": "將重置於",
                        "days": "天內",
                        "day": "天內",
                "Chart options": "圖表選項",
                    "View as table": "以表格形式查看",
                        "DateTime": "日期時間",
                    "Download CSV": "下載 CSV",
                    "Download PNG": "下載 PNG",
                "All usage": "全部",
                    // 某單位
                    "Gross:": "總計：",
                    "Billed:": "計費：",
                    "Discount:": "優惠：",
                "Usage by repository": "按倉庫統計",
                    "Top three repositories today": "今日排名前三的倉庫",
                    "Top three repositories this month": "本月排名前三的倉庫",
                    "Top four repositories last month": "上月排名前四的倉庫",
                    "Top four repositories this year": "今年排名前四的倉庫",
                    "Top four repositories this month": "上年排名前四的倉庫",

                    "usage": "用量",
                    "Gross amount": "總計",
                    "All other repositories": "其他",

                "No usage found": "無數據",

                // 底下計算部分
                    "View details": "詳情",
                    "consumed usage -": "計費 -",
                    "in discounts =": "折扣 =",
                    "in billable usage": "計費",
                    "Usage for Actions and Actions Runners.": "操作（運行器）用量。", // 後半句走正則
                    "Copilot usage": "Copilot 用量",
                        "Total spend on Copilot for the selected timeframe, excluding applicable discounts.": "所選時間段內 Copilot 的總支出，不含適用折扣。",
                    "Billable licenses": "計費許可數",
                        "Billable licenses info": "計費許可信息",
                            "If a user stops consuming a license within the month, the adjustment will be reflected in your next month's bill.": "如果用戶在當月停止使用許可，相關調整將體現在您下個月的賬單中。",
                            "Billable licenses are only available for the 'Current month' timeframe.": "計費許可僅適用於“當前月”時間段。",
                            "Learn more about billable licenses": "瞭解更多關於可計費許可證的信息",
                        "Showing total unique licenses billed for your enterprise. Actual billed amount for each license is prorated based on when it is added during the billing cycle.": "顯示您企業所計費的唯一許可證總數。每個許可證的實際計費金額將根據其在計費週期內添加的時間按比例分攤。",
                    "Copilot premium requests": "Copilot 高級請求",
                        "About Copilot premium requests": "關於 Copilot 高級請求",
                        "If enabled, additional premium requests beyond the included amount for each license will be billed.": "若啟用此功能，每個許可證所包含額度之外的額外高級請求將另行計費。",
                        "Manage Copilot policy": "管理 Copilot 策略",
                    // 模型
                        "About GitHub Models rate limits": "關於 GitHub 模型速率限制",
                            "GitHub Models rate limits": "GitHub 模型速率限制",
                                "The playground and free API usage are rate limited by requests per minute, requests per day, tokens per request, and concurrent requests.": "操場和免費 API 的使用受到以下限制：每分鐘請求數、每天請求數、每次請求的令牌數以及並發請求數。",
                                "Learn more about GitHub Models rate limits": "瞭解更多", // 有上下文，故省略

                    // Spark
                        "Spark premium requests": "Spark 高級請求",

            // 程式碼空間超限
            "You've used 90% of included services for GitHub Codespaces storage.": "您已使用 90% 程式碼空間存儲。",
            "You've used 100% of included services for GitHub Codespaces storage.": "您已使用 100% 程式碼空間存儲。",
                "When your allotment is exhausted, you won't be able to use Codespaces until you set up a spending limit or your free Codespaces allotment is reset next month. If you want to access your in progress work from a codespace, you can": "當您的額度耗盡後，您將無法使用程式碼空間，直到您設置支出上限或下月重置您的免費額度。如果您想訪問程式碼空間中正在進行的工作，您可以",
                "export your unpushed work to a branch.": "將未推送的工作導出到分支。",
                "To see a full list of your usage, obtain a copy of your": "要查看所有使用情況，請獲取您的",
                "usage report": "使用報告",
                "to see the codespaces and prebuilds created by your account. The usage report is the only place where prebuild usage is visible. If you see charges you'd like to stop going forward, you can delete a": "，以查看您的賬戶創建的程式碼空間和預構建。使用報告是唯一能顯示預構建使用情況的地方。如果您看到希望以後停止的費用，您可以刪除一個",
                "codespace": "程式碼空間",
                "delete prebuilds for a repository.": "刪除某個倉庫的預構建。",
            "Update spending limit": "更新支出限額",

        // 使用情況 https://github.com/settings/billing/usage
            "Get usage report": "獲取使用情況報告",
                "Metered billing usage report": "計費用量",
                    "Provides a breakdown of all metered usage": "提供所有計量使用情況的詳細分解",
                    // 窗口
                    "Select report type:": "選擇報告類型：", // 下方小字走正則
                        "Summarized": "總結",
                            "Metered usage by repository for up to 1 year": "每個倉庫的計量使用情況，最長可追溯至一年",
                        "Detailed": "詳細",
                            "Metered usage by username and workflow for up to 31 days": "每個用戶和工作流的計量使用情況，最長可追溯至 31 天",
                        "Legacy": "傳統",
                            "Metered usage before the billing transition, until April 04, 2025": "計費切換前的計量使用情況，截至2025年4月4日",
                    "Select time frame": "選擇時間段",
                        "This year": "今年",
                        "Custom range": "自定義",
                            "Up to 1 year": "最長 1 年",
                            "Up to 31 days": "最長 31 天",
                            "Choose date...": "選擇日期…",
                                "Su": "日",
                                "Mo": "一",
                                "Tu": "二",
                                "We": "三",
                                "Th": "四",
                                "Fr": "五",
                                "Sa": "六",
                    "Email me the report": "發送",
                "Copilot premium requests usage report": "Copilot 高級請求",
                    "Provides a per user breakdown of requests exhausted and their monthly quota for the current billing period.": "提供每個用戶的請求耗盡情況及其當前計費週期的月度配額。",
            "Search or filter usage": "搜索或篩選使用情況",

            //"Group: None": "分組：無",
            //"Group: Product": "分組：產品",
            //"Group: SKU": "分組：庫存單位",
            //"Group: Repository": "分組：倉庫",
                "None": "無",
                // "SKU": "庫存單位",
            "Metered usage grouped by Product": "分組：產品",
                "actions": "操作",
                "codespaces": "程式碼空間",

                "Products": "產品",
            "Metered usage grouped by SKU": "分組：庫存單位",
                "Actions storage": "操作存儲",
                "Codespaces storage": "程式碼空間存儲",
                "Actions Windows": "操作 Windows",
                "Actions Linux": "操作 Linux",
                "Actions macOS 3-core": "操作 macOS 三核",
                "Codespaces compute 2-core": "程式碼空間 - 雙核",
                "Copilot Premium Request": "Copilot 高級請求",
            "Metered usage grouped by Repository": "分組：倉庫",
                "All other": "其他",

            "For license-based products, the price/unit is a prorated portion of the monthly price.": "對於基於許可證的產品，每單位價格為月度價格按比例分攤的部分。",

            // 有上下文，後面重複部分直接省略
            "Actions usage": "操作",
            "Actions usage grouped by SKU": "操作 - 詳細",
            "Copilot usage": "Copilot",
            "Copilot usage grouped by SKU": "Copilot - 詳細",
            "Codespaces usage": "程式碼空間",
            "Codespaces usage grouped by SKU": "程式碼空間 - 詳細",
            "Git_lfs usage": "Git LFS",
            "Git_lfs usage grouped by SKU": "Git LFS - 詳細",
            "Packages usage": "軟體包",
            "Packages usage grouped by SKU": "軟體包 - 詳細",

            "Usage breakdown": "用量分析",
                "Date": "日期",
                "SKUs": "庫存單位",
                "Products": "產品",
                "Repositories": "倉庫",
                "Units": "單位",
                "Price/unit": "單價",
                "Billed amount": "計費",

        // 高級請求分析 https://github.com/settings/billing/premium_requests_usage
            "Usage analytics for premium requests in your personal account.": "在您的個人賬戶中針對高級請求的使用分析。",

            "Billed premium requests": "計費高級請求",
                "Increase your budget": "提高您的預算",
                    "to use premium requests beyond your included request limit.": "以便在超出包含請求額度後繼續使用。",

            "Included premium requests consumed": "包含高級請求",
                "included": " ", // 多餘原文，直接刪除
                "Premium requests included in your": "高級請求包含在您的",
                    "Copilot plan": "Copilot 計劃中",
                    // 後續走正則

            // 用量分析
                "Model": "模型",
                    "Included requests": "包含請求",
                    "Billed requests": "計費請求",
                    "Code Review model": "程式碼審查模型",
                    "Coding Agent model": "編程智能體模型",

            // 獲取使用情況報告
                "Premium requests usage report": "高級請求使用報告",
                    "Detailed per-user breakdown of premium requests consumed.": "詳細列出每位用戶消耗的高級請求數量。",
                "Legacy usage report": "舊版使用報告",

        // 預算和警報 https://github.com/settings/billing/budgets
           "Account budgets": "賬戶預算",
                "New budget": "新建",
                // "On": "開",
                // "Off": "關",
                "Stop usage": "停止使用",
                "Yes": "是",
                "spent": "支出",
                "budget": "預算",
            "Budgets let you set monthly usage limits for specific GitHub products or SKUs. If no budget is set, usage for that product is unlimited.":"預算允許您為特定的 GitHub 產品或 SKU 設置每月使用限制。如果未設置預算，該產品的使用量將不受限制。",
            "Product":"產品類型",

        // 新建/更新預算 https://github.com/settings/billing/budgets/new
        // https://github.com/settings/billing/budgets/<id>/edit
            // 提醒欄
                "Info": "信息",
                "SKU level budgets are only available for products that have > 1 SKU.": "只有擁有大於 1個 SKU 的產品才有 SKU 級別的預算。",

            "Budgets and Alerts": "預算和警報",
            "New monthly budget": "新建月度預算",
            "Edit monthly budget": "編輯每月預算", // edit
                "Create a budget to track spending for a selected product and scope.": "創建預算以跟蹤選定產品和範圍的支出。",
            // 缺失支付方式
                "Payment method is missing":"支付方式缺失",
                "Please set up a valid payment method before creating or adjusting your budget.": "請在創建或調整預算前設置有效的付款方式。",
                "Add payment method":"添加支付方式",

            "Budget type": "預算類型",
                "Set budget for either a product or individual SKU within a product.": "為產品或產品中的單個 SKU 設置預算。",
                "Product-level budget": "產品級預算",
                    "Codespaces": "程式碼空間",
                    "Actions": "操作",
                    "Models": "模型",
                        "Enable billing to set a budget. See": "啟用計費以設置預算。查看",
                        "Models policy configuration": "模型策略配置",
                    "Packages": "軟體包",
                    "Select 1 product": "選擇產品",
                "SKU-level budget": "SKU 級預算",
                    "Select": "選擇",
                    "Select an item": "選擇專案",

            "Next: Configure budget": "下一步：配置預算",

            "All Premium Request SKUs":"所有高級請求 SKU",
            "A budget for all SKUs that consume premium requests":"所有消耗高級請求的 SKU 的預算",
            "Supported SKUs:":"支持的 SKUs：",
                "Coding Agent premium requests":"Coding Agent 高級請求",

            "Budget scope": "預算範圍",
                "Select the scope of spending for this budget.": "選擇此預算的支出範圍。",
                // 倉庫
                    "Scoped budgets track spending for a single repository": "範圍預算跟蹤單個倉庫的支出",

                        "Select repository": "選擇倉庫",
                        "Select the": "選擇",
                        "to include in this": "包含在此",
                        ". You can only add/remove the": "您只能添加/刪除您可以訪問的",
                        "that you have access to.": "。",
                        "Search repository": "搜索倉庫",
                        "Showing": "顯示",
                        "of": "/",
                        // [/(\d+) selected/, "$1 個選定"],
                // 賬戶
                    "Scoped budgets track spending for all repositories owned by your account": "範圍預算跟蹤您賬戶下所有倉庫的支出",
                    "Scoped budgets track all spending for your account": "範圍預算跟蹤您賬戶的所有支出",

            "Budget": "預算",
                "Set a budget amount to track your spending on a monthly basis.": "設置預算金額以按月跟蹤您的支出。",
                "Usage before budget creation isn't counted in the current billing cycle.": "預算創建前的使用情況不會計入當前計費週期。",
                "Budget amount": "預算金額",
                    "Stop usage when budget limit is reached": "達到預算上限時停止使用",
                        "Spending won't exceed your set budget": "支出不會超出您設定的預算",

            // 警示
                "Get emails and GitHub notifications when your spending has reached 75%, 90%, and 100% of the budget threshold.": "當您的支出達到預算閾值的 75%、90% 和 100% 時，接收電子郵件和 GitHub 通知。",
                "Receive emails when usage reaches 75%, 90%, and 100% of the budget amount.":"當您的支出達到預算閾值的 75%、90% 和 100% 時，接收電子郵件通知。",

                "Receive budget threshold alerts": "接收預算閾值警報",

            "Create budget": "創建預算",
            "Update budget": "更新預算", // edit

            // 左下角提示
                "Please add a payment method to use budgets.": "請添加付款方式，以便使用預算。",

        // 許可 https://github.com/settings/billing/licensing
            // Github Copllot
                "Your AI pair programmer": "您的 AI 編程助理",
                    "You are eligible to use GitHub Copilot for free.": "您有資格免費使用 GitHub Copilot。",

            "Current plan": "當前計劃",
                "Compare all plans": "比較所有計劃",
                    "per month": "每月",

                "GitHub Free": "GitHub 免費版",
                "The basics for all developers": "基礎計劃（所有開發者）",
                //"GitHub Pro": "GitHub 專業",

                "The basics for organizations and developers": "組織和開發者的基本計劃", // 組織設置
                "Unlimited public/private repos": "無限的公共/私有倉庫",
                "Unlimited collaborators": "無限協作者",
                "2,000 Actions minutes/month": "每月 2,000 分鐘 GitHub Actions",
                "500MB of Packages storage": "500MB 的 GitHub Packages 存儲空間",
                "120 core-hours of Codespaces compute per developer": "每位開發者擁有 120 個核心小時的程式碼空間計算能力",
                "15GB of Codespaces storage per developer": "每位開發者擁有 15GB 的程式碼空間存儲空間",
                "Community support": "社區支持",
                // pro
                    "Downgrade to Free": "降級至免費版",
                "3,000 Actions minutes/month": "每月 3,000 分鐘 GitHub Actions",
                "2GB of Packages storage": "2GB 的 GitHub Packages 存儲空間",
                "180 core-hours of Codespaces compute": "180 核心小時的程式碼空間計算時長",
                "20GB of Codespaces storage": "20GB 的程式碼空間存儲空間",
                "Code owners, required reviewers, GitHub Pages,": "程式碼所有者、所需審核者、GitHub Pages，",
                "and more": "以及更多",
                "advanced tools": "高級工具",

                "Not included:": "不包含：",
                "Free Codespaces usage per organization": "每個組織的免費程式碼空間使用量",
                "Protected branches on all repos": "所有倉庫上的受保護分支",
                "Increase Codespaces": "提高程式碼空間",
                "spend limits": "消費限額",
                "Multiple reviewers in pull requests": "拉取請求中多個審查者",
                "Required status checks": "狀態檢查",
                "Code owners": "程式碼所有者",
                "Required reviewers": "所需的審查者",
                "Pages for static website hosting": "靜態網站頁面託管",
                "Web-based support": "基於網絡的支持",
                "See all features and compare plans": "查看所有功能並比較計劃",

            "Active subscription": "當前訂閱",
                "Copilot Free": "Copilot 免費版",
                    "Upgrade Copilot": "升級 Copilot",
                    "You can upgrade to Copilot Pro at any time. Check out this": "您可以隨時升級至 Copilot 專業版。詳情查看",
                        "documentation": "文檔",
                        "for more details.": "。",

            "Current GitHub base plan": "當前 GitHub 基礎計劃",
                "Compare base plans": "比較基礎計劃",
                "Upgrade to GitHub Pro": "升級至 GitHub 專業版",
                // 有付費計劃
                    "Switch to yearly billing": "切換至年度計費",
                    "Switch to monthly billing": "切換至月度計費",

            "Current Copilot plan": "當前 Copilot 計劃",
                "Monthly payment": "每月支付",
                "Next payment": "下次支付",
                "You can upgrade your subscription to yearly billing or cancel any time." : "您可以隨時將訂閱升級為年度計費或取消訂閱。",
                "Read billing documentation": "閱讀計費文檔",

            "Compare Copilot plans": "比較 Copilot 計劃",
            "Upgrade to Copilot Pro+" : "升級至 Copilot Pro+",
            "Manage subscription": "管理訂閱",
            "Switch to annual billing": "切換至年度計費",
            "Cancel subscription": "取消訂閱",

        // 支付信息 https://github.com/settings/billing/payment_information
            ...I18N["zh-TW"]["payment-module"]["static"], // 調用通用賬單及支付信息模塊

            "Last payment": "最後一次支付",
                "You have not made any payments.": "您尚未支付任何款項。",

            "Coupon": "優惠劵",
                "Redeem a coupon": "兌換優惠券",
                "You don't have an active coupon.": "您沒有有效的優惠券。",
                "* Discount only applies for GitHub Pro": "* 優惠僅限 GitHub Pro。",

            "Additional information": "附加信息",
                "Add specific contact or tax information to your receipts, like your full business name, VAT/GST identification number, or address of record here. We’ll make sure it shows up on every receipt.": "在您的收據上添加具體的聯繫方式或稅務信息，例如您的企業全稱、VAT/GST 識別號碼或記錄地址。我們將確保它顯示在每張收據上。",
                "Add information": "添加信息",
                "No additional information added to your receipts.": "您的收據上沒有添加任何額外的信息。",
                "Extra information": "附加信息",

                // “額外賬單信息” 對話框
                    "Extra billing information": "額外的賬單信息",
                    "This information will appear on all your receipts.": "此信息將出現在您的所有收據上。",
                    "For your security, do not include any confidential or financial information (like credit card numbers).": "為了您的安全，請勿包含任何機密或財務信息（如信用卡號）。",
                    "To update the information that appears on": "要更新顯示在",
                        "invoices": "發票",
                        "(if enabled), visit the": "上的信息（如果已啟用），請訪問",
                    "Full business name or address of record": "企業全稱或記錄地址",
                    "Save contact information": "保存聯繫信息",
                    "Saving contact information…": "正在保存聯繫信息…",
                    // 頂部提醒
                        "Updated your optional contact information, it will show up on your next receipt.": "已更新您的可選聯繫信息，該信息將顯示在您的下一張收據上。",

            // 組織
            "Invoice": "發票",
                "Receive an invoice for your GitHub purchases": "接收 GitHub 購物發票",

                "The data from Billing Information, such as your address and VAT/GST ID will appear on your invoices.": "賬單信息中的數據，如您的地址和增值稅/消費稅 ID，將顯示在您的發票上。",
                "Update your information displayed on your invoices in the": "更新發票上顯示信息中的",
                "billing information section": "賬單信息欄",

                "Automatically receive an invoice alongside the payment receipt": "在收到付款收據的同時自動接收發票",
                    "* Enables invoices for all NEW payments.": "* 為所有新付款啟用發票。",
                "Save invoice preference": "保存發票首選項",

            // 組織
            "Metered billing via Azure": "通過 Azure 計量計費",
                "Add Azure Subscription": "添加 Azure 訂閱",
                "To manage metered billing for this account through Microsoft Azure an Azure Subscription ID must be added to your account.": "通過 Microsoft Azure 管理此賬戶的計量計費，必須將 Azure 訂閱 ID 添加到您的賬戶中。",

        // 支付歷史 https://github.com/account/billing/history
            "Amounts shown in USD": "以美元顯示的金額",

        // 其他賬單 https://github.com/settings/billing/subscriptions
            // [/In addition to your personal account, you manage (\d+) organizations?./, "除個人賬戶外，您還可以管理 $1 個組織。"],
            "Manage your organizations": "管理您的組織",
                "Create a new organization": "創建新組織",

            "Start your first organization": "開始您的第一個組織",
                "With CI/CD, Dependabot, and the world's largest developer community, GitHub gives your team everything they need to ship better software faster": "通過 CI/CD、Dependabot 以及全球最大的開發者社區，GitHub 為您的團隊提供了交付更優質軟體所需的一切，讓開發更高效、更快捷。",
                "Create an organization": "創建組織",

            "Marketplace apps": "市場應用",
                "Change plan": "更改計劃",
                "Cancel plan": "取消計劃",
                    "Are you sure you want to cancel this integration?": "您確定要取消此集成嗎？",
                    // 頂部提醒
                        // [/You've cancelled your subscription to (.*). This plan change will take effect on (.*)./, "您已取消對 $1 的訂閱。此計劃變更將於 $2 生效。"],
                        "Dismiss": "忽略",
                "Do you have any questions? Contact": "您有任何問題嗎？請聯繫",

            // 組織設置
            "Billing Contacts": "賬單聯繫人",
                "Receipts are sent to billing managers and email recipients.": "收據會被發送給賬單管理員和郵件接收者。",

                "Billing managers": "賬單管理員",
                    "You have not invited any billing managers": "您尚未邀請任何賬單管理員",
                    "Invite": "邀請",

                "Email recipients": "郵件接收者",
                    "Add": "添加",
                    "Primary": "主賬戶",

                    // 編輯賬單電子郵箱對話框
                        "Edit billing email address": "編輯賬單電子郵箱",
                        "Billing primary email": "賬單主賬戶郵箱",
                        "(Private)": "（私密）",

                    // 添加賬單接收者對話框
                        "Add billing recipient": "添加賬單接收者",
                        "Add billing recipient email": "添加賬單接收者郵箱",

            "Sponsorships": "贊助",
                "GitHub Sponsors": "GitHub 贊助",
                    "Connect with the community that builds the tools you use": "與構建您使用的工具的社區聯繫",
                    "Start sponsoring": "開始贊助",
                    "You're currently not sponsoring anyone.": "您目前沒有贊助任何人。",
                    "Learn more about GitHub Sponsors": "瞭解更多關於 GitHub 贊助的信息",
                    "Switch to invoiced billing": "切換到發票賬單", // 組織

        // 比較計劃 https://github.com/account/billing/plans
            "Compare plans": "比較計劃",
            "Free": "免費版",
                "All the basics": "所有基礎",
            "Pro": "專業版",
                "Advanced tools for private repos": "用於私人倉庫的高級工具",
            // 具體內容
                "Code management": "程式碼管理",
                    "Public repositories": "公共倉庫",
                        "Host open source projects in public GitHub repositories, accessible via web or command line. Public repositories are accessible to anyone at GitHub.com.": "在 GitHub 公共倉庫中託管開源專案，可通過網絡或命令行訪問。任何人都可以訪問 GitHub.com 上的公共倉庫。",
                    "Private repositories": "私有倉庫",
                        "Host code in private GitHub repositories, accessible via appliance, web, and command line. Private repositories are only accessible to you and people you share them with.": "在私有 GitHub 倉庫中託管程式碼，可通過設備、網絡和命令行訪問。只有您和與您共享的人才能訪問私有倉庫。",

                "Code workflow": "程式碼工作流",
                    "GitHub Codespaces": "GitHub 程式碼空間",
                        "Spin up fully configured dev environments in the cloud with the power of your favorite editor. A \"core hour\" denotes compute usage. On a 2-core machine, you would get 60 hours free. On a 4-core machine, you would get 30 hours free, etc. Free hours are assigned to personal accounts, rather than free organizations.": "利用您喜愛的編輯器的強大功能，在雲中快速配置完整的開發環境。“核心小時” 表示計算使用量。在雙核機器上，您將獲得 60 小時的免費時長。在 4 核機器上，您將獲得 30 小時的免費時長，以此類推。免費時長數分配給個人賬戶，而不是免費組織。",
                    "GitHub Actions": "Github 操作",
                        "Use execution minutes with GitHub Actions to automate your software development workflows. Write tasks and combine them to build, test, and deploy any code project on GitHub. Minutes are free for public repositories.": "利用 GitHub Actions 的幾分鐘執行時間，實現軟體開發工作流程自動化。編寫任務並組合它們，即可在 GitHub 上構建、測試和部署任何程式碼專案。對於公共倉庫，執行時間是免費的。",
                        "Learn more about billing": "瞭解更多關於賬單的信息",
                    "GitHub Packages": "Github 軟體包",
                        "Host your own software packages or use them as dependencies in other projects. Both private and public hosting available. Packages are free for public repositories.": "託管您的軟體包，或將其用作其他專案的依賴項。提供私有和公共託管。對於公共倉庫，軟體包是免費的。",
                    "Code reviews": "程式碼審查",
                        "Review new code, see visual code changes, and confidently merge code changes with automated status checks.": "審查新程式碼，查看可視化的程式碼更改，並通過自動化狀態檢查自行地合併程式碼更改。",
                    // 拉取請求
                        "Allow contributors to easily notify you of changes they've pushed to a repository – with access limited to the contributors you specify. Easily merge changes you accept.": "允許貢獻者輕鬆通知您他們推送到倉庫的更改，訪問權限僅限於您指定的貢獻者。輕鬆合併您接受的更改。",
                    "Protected branches": "受保護的分支",
                    "Repository rules":"倉庫規則",
                        "Enforce restrictions on how code branches are merged, including requiring reviews by selected collaborators, or allowing only specific contributors to work on a particular branch.": "對程式碼分支的合併方式實施限制，包括要求由選定的協作者進行審查，或僅允許特定的貢獻者在特定分支上工作。",
                    // 程式碼所有者
                        "Automatically request reviews – or require approval – by selected contributors when changes are made to sections of code that they own.": "當選定的貢獻者對其擁有的程式碼部分進行修改時，自動要求審查或要求批准。",
                    "Draft pull requests": "拉取請求草案",
                        "Easily discuss and collaborate on pull requests before submitting to formal review.": "在提交正式審查之前，輕鬆討論和協作拉取請求。",
                    "Multiple pull request assignees": "多個拉取請求受理人",
                        "Assign more than one person to a pull request.": "為拉取請求指派多人受理。",
                    "Repository insights": "倉庫洞察",
                        "See data about activity and contributions within your repositories, including trends. You can use this data to improve collaboration and make development faster and more effective.": "查看有關倉庫中的活動和貢獻數據，包括趨勢。您可以利用這些數據來改善協作，使開發更加迅速和有效。",
                    // 定時提醒
                        "Send scheduled messages to you or your team listing open pull requests.": "按計劃的向您或您的團隊發送信息，列出打開的拉取請求。",
                    "Automatic code review assignment": "自動程式碼審查分配",
                        "Automatically assign code reviews to members of your team based on one of two algorithms.": "根據兩種算法之一，自動為團隊成員分配程式碼審查。",
                    "Environment protection rules": "環境保護規則",
                        "When a workflow job references an environment, the job won't start until all of the environment's protection rules pass.": "當工作流作業引用環境時，只有環境的所有保護規則都通過後，作業才會啟動。",
                    "Environment deployment branches and secrets": "環境部署分支和機密",
                        "A job cannot access secrets that are defined in an environment unless it is running on the specified branch.": "除非作業在指定的分支上運行，否則無法訪問環境中定義的機密。",

                "Collaboration": "協作",
                    "Collaborators for public repositories": "公共倉庫協作者",
                        "Invite any GitHub member, or all GitHub members, to work with you on code in a public repository you control – including making changes and opening issues.": "邀請任何 GitHub 成員或所有 GitHub 成員，在您控制的公共倉庫上與您共同處理程式碼，包括進行更改和提出議題。",
                    "Collaborators for private repositories": "私有倉庫協作者",
                        "Invite any GitHub member, or all GitHub members, to work with you on code in a private repository you control – including making changes and opening issues.": "邀請任何 GitHub 成員或所有 GitHub 成員，在您控制的私有倉庫上與您共同處理程式碼，包括進行更改和提出議題。",
                    // 議題
                        "Track bugs, enhancements, and other requests, prioritize work, and communicate with stakeholders as changes are proposed and merged.": "跟蹤漏洞、增強功能和其他請求，確定工作的優先級，並在提出和合併變更時與利益相關者溝通。",
                    // 專案
                        "Visualize and manage issues and pull requests across tables, boards, and roadmaps with custom fields and views that you can arrange to suit your workflow.": "通過自定義字段和視圖，在表格、面板和路線圖上可視化管理議題和拉取請求，以適應您的工作流程。",
                    "Milestones": "里程碑",
                        "Track progress on groups of issues or pull requests in a repository, and map groups to overall project goals.": "跟蹤倉庫中議題或拉取請求組的進展，並將組映射到整體專案目標。",
                    // 團隊討論
                    "Team discussions": "團隊討論",
                        "Discuss any topic, unattached to a specific project or issue. Control who has access, notify discussion participants with updates, and link from anywhere.": "討論任何主題，不與特定專案或議題相關。控制訪問權限，通知討論參與者最新情況，並從任何地方進行鏈接。",
                    "Organization and team management": "組織和團隊管理",
                        "Manage access to projects on a team-by-team, or individual user, basis.": "以團隊或個人用戶為基礎管理對專案的訪問。",
                    "Pages and wikis": "GitHub Pages 和 Wiki",
                        "Host documentation and simple websites for your project in a wiki format that contributors can easily edit either on the web or command line.": "以 Wiki 格式為您的專案託管文檔和簡單網站，貢獻者可以輕鬆在網絡或命令行上進行編輯。",
                    "Multiple issue assignees": "多個議題受理人",
                        "Assign more than one person to an issue.": "為議題指派多人受理",
                    "GitHub organizations give you team-based access control and discussions.": "GitHub 組織為您提供基於團隊的訪問控制和討論。",
                        "Learn more about organizations": "瞭解更多關於組織的信息",

                "Platform security and compliance": "平臺安全性與合規性",
                    "Repository rulesets": "倉庫規則集",
                        "Enforce consistent code standards, security, and compliance across branches and tags.": "跨倉庫分支和標籤，一致的程式碼標準、安全性和合規性。",
                    // SBOMs
                        "Export a software bill of materials (SBOM) for your repository.": "為倉庫導出軟體物料清單 (SBOM)。",
                    "Artifact attestations": "附件證明",
                        "Ensure unfalsifiable provenance and integrity for your software.": "確保軟體的不可篡改性和完整性。",
                    "GitHub Security Advisories": "GitHub 安全公告",
                    "Role-based access control": "基於角色的訪問控制",
                        "Define users' level of access to your code, data and settings.": "定義用戶訪問程式碼、數據和設置的級別。",
                    "Required 2FA": "雙因素身份驗證（2FA）",
                        "Use an extra layer of security with two factor authentication (2FA) when logging into GitHub.": "登錄 GitHub 時，使用雙因素身份驗證（2FA）作為額外的安全層。",
                    // 審計日誌
                        "Quickly review the actions performed by members of your organization.": "快速審查組織成員執行的操作。",
                    "Enterprises can connect to advanced systems like LDAP and SAML single sign-on (SSO).": "企業可以連接到如 LDAP 和 SAML 單一登錄 (SSO) 等高級系統。",
                        "Learn more about GitHub Enterprise": "瞭解更多關於 GitHub 企業版的信息。",

                "Marketplace and integrations": "市場和集成",
                    // Github應用
                        "Install apps that integrate directly with GitHub's API to improve development workflows – or build your own for private use or publication in the GitHub Marketplace.": "安裝直接與 GitHub API 集成的應用，改進開發工作流程，或創建自己的應用，供個人使用或在 GitHub 市場發佈。",
                    "Status checks": "狀態檢查",
                        "Define tests that GitHub automatically runs against code being committed to your repository, and get details about failures and what is causing them.": "定義 GitHub 針對提交到倉庫的程式碼自動運行的測試，並獲取有關失敗和失敗原因的詳細信息。",
                    "Enterprise Server customers create pre-receive hooks to automatically accept or reject a push.": "企業服務器客戶創建預接收掛鉤，以自動接受或拒絕推送。",
                        "Learn more about pre-receive hooks": "瞭解更多關於預接收掛鉤的信息。",

                "Support and deployment": "支持與部署",
                    "Community Support": "社區支持",
                        "Get help with most of your GitHub questions and issues in our Community Forum.": "在我們的社區論壇中，獲取大多數有關 GitHub 問題和議題的幫助。",
                    "Standard Support": "標準支持",
                        "GitHub Support can help you troubleshoot issues you run into while using GitHub. Get support via the web.": "GitHub 支持可幫助您解決使用 GitHub 時遇到的問題。通過網絡獲取支持。",
                    "Enterprises also get Premium Support, invoice billing, and self-hosted deployment.": "企業還可以獲得高級支持、發票計費和自託管部署。",
                       // "Learn more about GitHub Enterprise": "瞭解更多關於 GitHub 企業版的信息。",

                // 表格中內容
                    "per user/month": "每人/月",
                    "Upgrade to Pro": "升級到專業版",
                    "Unlimited": "無限",
                    "$0 spend limit": "$0 支出限額",
                        "With policies and controls": "帶策略及限制",
                    "180 core-hours compute/month and 20GB storage": "每月 180 個核心小時計算和 20GB 存儲",
                    "2,000 minutes/month": "2000 分鐘/月",
                        "Free for public repositories": "免費用於公共倉庫",
                    "3,000 minutes/month": "3,000 分鐘/月",
                    "Public repositories": "公共倉庫",

        // 組織設置 邀請賬單管理員 '/organizations/<org-login>/billing_managers/new'
            "Billing": "賬單",
            "/ Add a billing manager": "/ 添加賬單管理員",
            "A": " ",
            "billing manager": "賬單管理員",
            "is a user who manages the billing settings of your organization.": "是管理您組織的賬單設置的用戶。",
            "will": "會",
            "will not": "不會",
            "have the ability to:": "具備以下能力：",
                "Change the billing plan": "更改賬單計劃",
                "Add, update, or remove payment methods": "添加、更新或刪除支付方式",
                "View payment history": "查看支付記錄",
                "Download, and receive receipts": "下載並接收收據",
                "View a list of billing managers": "查看賬單管理員列表",
                "Invite additional billing managers": "邀請其他賬單管理員",
                "Remove other existing billing managers": "移除其他現有的賬單管理員",
                "Start, modify, or cancel sponsorships": "開始、修改或取消贊助",
            "be able to:": "能夠：",
                "Create or access repositories in your organization": "在您的組織中創建或訪問倉庫",
                "See private members of your organization": "查看您組織的私人成員",
                "Be seen in the list of organization members": "在組織成員列表中可見",
                "Use the organization’s payment method": "使用組織的支付方式",
                "Enable or manage Copilot": "啟用或管理 GitHub Copilot",
                "Purchase, edit, or cancel Marketplace subscriptions": "購買、編輯或取消市場訂閱",

            "Search by username, full name or email address": "搜索用戶名、全名、或電子郵箱",
            "Send invitation": "發送邀請",

            // 加載
            "Loading Actions data...": "加載操作數據…",
            "Loading Packages data...": "加載軟體包數據…",
            "Loading Shared Storage data...": "加載共享存儲數據…",
            "Loading Codespaces data...": "加載程式碼空間數據…",
            "Loading usage breakdown…": "正在加載使用明細…",

    },
    "regexp": [ // 正則翻譯
        // 高級請求分析（詞條打架調整位置） https://github.com/settings/billing/premium_requests_usage
        [/. Monthly limit resets in (\d+) days? on (.+)./, "。將在 $1 天后（$2）重置。"],
        [/Usage for (.+) - (.+). Price per premium request is \$0.04./, (match, p1, p2) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `${translatedP1}-${translatedP2}用量。高級請求價格為 $0.04 / 個。`;
        }],
        [/Per-user breakdown of premium requests in the last 45 days. Sunsetting(.*)\./, (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `過去 45 天內每用戶高級請求明細。${translatedDate} 日落`;
        }],

        // billing 概況頁面
        [/(?:Gross metered usage|Included usage discounts) for (.+) - (.+).$/, (match, p1, p2) => { // 概況下方小字，過於囉嗦直接省略
            //const translatedP1 = I18N["zh-TW"]["public"]["time-regexp"][p1] || p1;
            //const translatedP2 = I18N["zh-TW"]["public"]["time-regexp"][p2] || p2;
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `${translatedP1}-${translatedP2}`;
        }],
        //[/Included usage discounts for (.+) - (.+)./, (match, p1, p2) => {
        //    const translatedP1 = I18N["zh-TW"]["public"]["time-regexp"][p1] || p1;
        //    const translatedP2 = I18N["zh-TW"]["public"]["time-regexp"][p2] || p2;
        //    return `${translatedP1}-${translatedP2}`;
        //}],
        [/([\d,]+) min used \/ ([\d,]+) min included/, "$1 / $2 分鐘"],
        //(\d+) min used \/ ([\d,+]) min included
        [/(\d+) GB used \/ (\d+) GB included/, "$1/$2 GB"],
        // 當前包含用量 - 詳情 對話框
            [/Current usage for (.+) - (.+). Monthly quota resets in (\d+) day\(s\)./, (match, p1, p2, p3) => {
                const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
                const translatedP1 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                const translatedP2 = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
                return `統計時間段：${translatedP1}-${translatedP2}。本月配額將在${p3}天內重置。`;
            }],
            [/([\d,+]) included Actions minutes \(~(\$\d+\.\d+) off\*\)/, "$1 操作分鐘數（~$2 減免*）"],
            [/~(\$\d+\.\d+) off\*/, "~$1 減免*"],
            [/~(\$\d+(\.\d+)?) off/, "~$1 減免"],

            [/([\d,+]) included Actions minutes/, "$1 操作分鐘數"],
            [/(\d+) GB included Actions storage/, "$1 GB 操作存儲"],
            [/(\d+) GB included Git LFS bandwidth/, "$1 GB Git LFS 帶寬"],
            [/(\d+) GB included Git LFS storage/, "$1 GB Git LFS 存儲"],
            [/(\d+) GB included Packages data transfer/, "$1 GB 軟體包數據傳輸"],
            [/(\d+) GB included Packages storage/, "$1 GB 軟體包存儲"],
            [/Discount for usage in public repositories \((\d+%) off\)/, "公共倉庫使用折扣（$1 減免）"],
            [/(\d+) GB included Codespaces storage/, "$1 GB 程式碼空間存儲"],
            [/(\d+) included Codespaces core hours/, "$1 程式碼空間核心小時數"],
            [/(\d+) requests/, "$1 請求"],
            [/Cost calculated based on (\d+) Spark premium requests? that exceed the premium request usage included with your Copilot licenses./, "根據您的 Copilot 許可證中包含的高級請求使用量，計算出 $1 個超出部分的 Spark 高級請求費用。"],

        // 計費用量 - 右上角時間選項
            [/^Timeframe: (Today|Current month|Last month|This year \((\d+)\)|Last year \((\d+)\))$/, (match, p1, p2, p3) => {
                switch (p1) {
                  case 'Today':
                    return '時間段：今天';
                  case 'Current month':
                    return '時間段：本月';
                  case 'Last month':
                    return '時間段：上個月';
                  case `This year (${p2})`:
                    return `時間段：今年（${p2}）`;
                  case `Last year (${p3})`:
                    return `時間段：去年（${p3}）`;
                  default:
                    return match;
                }
            }],
            //Timeframe: Current month
            [/This year \((\d+)\)/, "今年（$1）"],
            [/Last year \((\d+)\)/, "去年（$1）"],
        // 計費用量 - 今天 日期標題
            [/(.+) \(All times in UTC\)/, (match, p1) => {
                const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}（UTC時間）`;
            }],
        // 計費用量圖表 數據卡
            [/(Usage|codespaces|actions|Codespaces storage|Codespaces compute 2-core|Actions Windows|Actions macOS 3-core|Actions Linux|Actions storage|All other) (?:[^ ]+), (.+)/, (match, s1, p1) => {
                //const translatedP1 = I18N["zh-TW"]["public"]["time-regexp"][p1] || p1;
                //const translatedP2 = I18N["zh-TW"]["public"]["time-regexp"][p2] || p2;
                var s1Key = {'Usage': '用量','actions': '操作', 'codespaces': '程式碼空間', 'Codespaces storage': '程式碼空間存儲', 'Codespaces compute 2-core': '程式碼空間 - 雙核','Actions Windows': '操作 Windows', 'Actions Linux': '操作 Linux','Actions macOS 3-core': '操作 macOS 三核','Actions storage': "操作存儲",'All other': '其他'};
                const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}` + s1Key[s1];// 星期幾暫時省略
            }],
        // 計費用量 - 今天 X軸
            [/(\d+)(AM|PM)/, (match, p1, p2) => {
                // 運行規則：非12AM照搬，PM數字加12，12AM=0
                let hour = parseInt(p1, 10);
                if (p2 === "PM" && hour !== 12) {
                    hour += 12;
                } else if (p2 === "AM" && hour === 12) {
                    hour = 0;
                }
                return `${hour}:00`;
            }],

        // 計費用量 - 按倉庫統計
            [/Top (three|four|five) repositories (today|this month|last month|this year|)/, function(all , num, time) {
                var numKey = {"three": "三", "four": "四", "five": "五"}
                var timeKey = {"today": "今天","this month": "這個月","last month": "上個月","this year": "今年","last year": "去年"};
                return timeKey[time] + "排名前" + numKey[num] + "的倉庫";
            }],

        // 計費用量 - 底下計算部分
            [/Cost calculated based on additional (\d+) premium requests?/, "費用計算基於額外的 $1 高級請求"],
            [/Cost calculated based on additional (\d+) premium requests for Copilot and Spark./, "費用計算基於 Copilot 和 Spark 的 $1 項額外高級請求。"],
            [/Cost calculated based on additional (\d+) token units/, "費用根據額外的 $1 項令牌單位計算"],

        // [/The plan change was successful. @([^ ]+) has been updated to the pro yearly plan./, "計劃變更成功。@$1 已更新為專業版年度計費。"],
        // [/The plan change was successful. @([^ ]+) has been updated to the pro monthly plan./, "計劃變更成功。@$1 已更新為專業版月度計費。"],
        // [/We're preparing your report! We’ll send an email to ([^@]+@[^\n]+) when it’s ready./, "我們正在準備您的報告！完成後，我們將發送電子郵件至 $1。"], //頂部提醒
        // [/Included minutes quota resets? in (\d+) days?./, "包含的分鐘配額將在 $1 天之內重置"],
        // [/Data transfer quota resets? in (\d+) days?./, "數據傳輸配額將在 $1 天之內重置"],
        // //[/Included minutes quota resets/, ""],
        // [/Included quotas resets? in (\d+) days?./, "包含的配額將在 $1 天之內重置"],
        // [/Bandwidth quota resets? in (\d+) days?./, "帶寬使用配額將在 $1 天之內重置"],
        // [/In addition to your personal account, you manage (\d+) organizations?./, "除了您的個人賬戶之外，您還管理 $1 個組織。"],
        // [/Leaving it at (\$\d+\.\d{2}) will avoid any extra expenses/, "將其限制在 $1 美元將避免任何額外的費用。"],
        // [/isn’t a GitHub member/, "不是 GitHub 成員"], // 組織設置
        // [/of ([\d,]+\.\d{2}) min included/, "/ $1 分鐘"],
        // [/(?:GB )?of ([^ ]+) GB(?: included)?/, "/ $1 GB"],
        // //[/of ([^ ]+) GB( included)?/, "/ $1 GB"],
        // [/of (\d+\.\d{2}) included core hours used/, "/ $1 核心小時數"],
        // [/of (\d+\.\d{2}) included GB-month used/, "/ $1 GB/每月"],
        // [/Last (\d+) days/, "最近 $1 天"],
        // [/Included minutes quota only applies to Ubuntu 2-core, Windows 2-core and macOS 3-core runners\. Windows 2-core and macOS 3-core runners consume included minutes at higher rates\. Your (\d+\.\d+) included minutes used consists of (.*)/, "包含的分鐘配額僅適用於雙核 Ubuntu、雙核 Windows 和三核 macOS 運行器。雙核 Windows 和三核 macOS 運行器以更高的速度消耗包括的分鐘數。您已使用的 $1 分鐘包含分鐘數由 $2 組成。"],
        // [/(\$\d+\.\d{2})\/month/, "$1/月"],
        // [/(\$\d+\.\d{2}) off \/ month/, "-$1/月"],
        // [/(\$\d+\.\d{2})\/year/, "$1/年"],
        // [/(\$\d+\.\d{2}) off \/ year/, "-$1/年"],
        // [/(Due by|On|Expires) (.+)/, (match, opt, p1) => {
        //     var optKey = {"Due by": "結算", "On": "開始", "Expires": "到期"};
        //     const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
        //     const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
        //     return `${translatedDate}` + optKey[opt];
        // }],

        // 計費用量 https://github.com/settings/billing/usage + 高級請求分析 https://github.com/settings/billing/premium_requests_usage
            [/^Group(?: by)?: (None|Product|SKU|Repository|Models)$/, function(all, group) {
                var groupKey = {'None': '無','Product': '產品','SKU': 'SKU','Repository': '倉庫', 'Models': '模型'};
                return '分組：' + groupKey[group];
            }],
            [/Usage for (.+)./, (match, p1) => {
                const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `${translatedDate}`; // 有標題作為上下文，直接省略，只剩日期
            }],
            [/(\d+) min$/, "$1 分"],
            [/([\d,+]\.\d+|[\d,+]) GB-hr/, "$1 GB/時"],
            [/(\d+\.\d+) hr/, "$1 小時"],

        // 使用情況
            [/We're preparing your usage report. It may take ~30 minutes to see usage in your report. We'll send an email to ([^@]+@[^\n]+) when it's ready./, "我們正在準備您的使用報告。可能需要大約 30 分鐘。報告準備好後，我們會發送電子郵件到 $1。"],
            [/We're preparing your usage report. We'll send an email to ([^@]+@[^\n]+) when it's ready./, "我們正在準備您的使用報告。報告準備好後，我們會發送電子郵件到 $1。"],
            [/Your usage report request is already in progress. Check ([^@]+@[^\n]+) for the report when it's ready./, "您的使用報告請求正在處理。報告準備好後，請到 $1 查收。"],
            // 獲取使用報告窗口
            [/The usage report will be emailed when it's ready to ([^@]+@[^\n]+)./, "使用報告準備好後，將通過電子郵件發送到 $1。"],
              // 傳統選項
              //[/Metered usage before the billing transition, until (.+)/, (match, p1) => {
              //  const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
              //  const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
              //  return `計費切換前的計量使用情況，截至${translatedDate}`;
              //}],

        // 賬戶預算 https://github.com/settings/billing/budgets
            [/(\d+) budgets?/, "$1 預算"],

        // 支付信息 https://github.com/settings/billing/payment_information
            [/(\$\d+\.\d{2}) off per month for (\d+) years/, "每月優惠 $1，為期 $2 年"],
            [/until (.+)./, (match, p1) => {
                const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
                const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
                return `直到 ${translatedDate}。`;
            }],

        // 其他賬單 https://github.com/settings/billing/subscriptions
            [/In addition to your personal account, you manage (\d+) organizations?./, "除個人賬戶外，您還可以管理 $1 個組織。"],
            [/([^ ]+) support/, "$1 支持"],
            [/You've cancelled your subscription to (.*). This plan change will take effect on (.*)./, "您已取消對 $1 的訂閱。此計劃變更將於 $2 生效。"],

        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Billing Overview": "賬單概覽",
            "Billing Usage": "計費用量",
            "Premium request analytics": "高級請求分析",
            "Budgets": "預算",
            "Billing": "賬單",
            "Payment Information": "支付信息",
            "Payment history": "支付歷史",
        },
    },
};
I18N["zh-TW"]["account/billing/history"] = I18N["zh-TW"]["settings/billing"];
I18N["zh-TW"]["orgs/settings/billing"] = I18N["zh-TW"]["settings/billing"];
I18N["zh-TW"]["orgs/billing_managers/new"] = I18N["zh-TW"]["settings/billing"];
I18N["zh-TW"]["orgs/billing/history"] = I18N["zh-TW"]["settings/billing"];
I18N["zh-TW"]["orgs/billing/plans"] = I18N["zh-TW"]["settings/billing"];

I18N["zh-TW"]["settings/education/benefits"] = {  // 設置 - 賬單和計劃（新）- 教育福利
    "static": {
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置

        "GitHub Education": "GitHub 教育",

        "Education Benefits": "教育福利",
            "Complete a teacher or student application to unlock tools and resources for your educational journey.": "完成教師或學生申請，解鎖教育旅程所需的工具和資源。",
            //"You have a current student coupon applied.": "您當前已應用學生優惠券。",
            "You have a current student coupon applied. Find more information on your benefits": "您當前已應用學生優惠券。詳情查看",
                "here": "這裡",
            "Start an application": "申請",
                "You have not submitted an application for education benefits.": "沒有申請",

                "Education Benefits Application": "教育福利申請",
                    "Select your role in education: *": "選擇您的角色：*",
                        "Teacher": "教師",
                        "Student": "學生",

                        "What is the name of your school? *": "學校名稱 *",
                            "If your school is not listed, then enter the full school name and continue. You will be asked to provide further information about your school on the next page. A minimum of two characters is required to find your school.": "如果您的學校未在列表中，請輸入完整的學校名稱並繼續。下一頁將要求您提供有關學校的更多信息。查找學校至少需要輸入兩個字符。",
                            // 提醒設置學校郵箱
                                "We require applicants of": "我們要求申請者",
                                "to use one of these school-issues email addresses to apply:": "使用以下學校發放的電子郵箱地址進行申請：",
                                "add and verify your": "添加並驗證您的",
                                "school-issued email address": "學校發放的電子郵箱地址",
                                "in your account settings -- or a contact email if you do not have one. Once your email is verified, you can try applying again.": "在您的賬戶設置中——若未設置郵箱，請填寫聯繫郵箱。郵箱驗證通過後，即可重新嘗試申請。",

                        "What is your school email address?": "教育郵箱地址",
                            "Have a different email address you use with your school?": "您是否有其他在校使用的電子郵件地址？",
                            "Add it here.": "添加",

                        "You have verified the email address": "您已驗證郵件",
                        "on your GitHub account. This academic domain is associated with the school": "。該域名屬於：",
                        "Unselect this school": "取消選擇此學校",

                        "Share Location": "位置共享",
                        "Location shared": "位置已共享",
                        "Continue": "繼續",

                        "Please select the type of proof you would like to provide *": "請選擇您希望提供的證明類型 *",
                        "1. Dated school ID - Good": "1. 註明日期的學校證件 - 完整",
                        "What is a valid proof of education?": "什麼是有效的教育證明？",
                        "Good": "完整",
                            "proof requires infinite academic affiliation documentation most likely to help you be approved.": "的證明需要詳盡的學術關係文件，以最大限度地幫助您通過審核。",
                        "For": "部分",
                            "proof types may lower your chances of being approved.": "證明類型可能會降低您的審核通過概率。",
                        "Poor": "無效",
                            "proof types are unlikely to be acceptable.": "的證明類型通常無法被接受。",

                        "There was an error creating the discount request. Errors: Discount request could not be created. Discount request errors: School email must be verified on your GitHub account": "創建折扣請求時出錯。錯誤信息：無法創建折扣請求。折扣請求錯誤：學校郵箱必須在您的 GitHub 賬戶中完成驗證",

                "Application Type:": "申請類型：",

            "Approved": "批准",
                // 等待
                    "Coupon applied": "優惠券已應用",
                    "Expires in almost 2 years": "有效期大約 2年",
                    "Your academic status has been verified. Congratulations!": "您的學術狀態已驗證。恭喜！",
                    "Your academic benefits, including Partner offers, will become available after 72 hours of your verification.": "您的學術福利，包括合作伙伴優惠，將在您資格審核通過後的 72 小時內生效。",
                    "Once the benefits become available, you will be able to access the Students Developer Pack offers": "權益生效後，您將可以訪問學生開發者禮包優惠在",
                    "To redeem your Copilot Pro coupon, please sign up via this": "要兌換您的 Copilot Pro 優惠券，請訪問此",
                    "link": "鏈接",
                    "We hope you enjoy your GitHub Education benefits.": "希望您享受 GitHub 教育權益。",
                // 結束
                    "Congratulations! Your application has been approved and the coupon code has been applied to your account.": "恭喜！您的申請已獲批准，優惠碼已成功應用到您的賬戶。",
                    "Please visit the": "請訪問",
                    "Developer Pack": "開發者包",
                    "page to view your benefits.": "頁面查看您的權益。",
                "Your benefits will expire on": "您的福利過期時間：",
            "Loading details": "加載詳情",
            "Revoked": "撤銷",
            "Denied": "拒絕",
                "Reason(s):": "拒絕原因：",

                    "Please complete your": "請完善您的",
                    "GitHub billing information": "GitHub 賬單信息",
                    "with your full name exactly as it appears in your academic affiliation document. You do not have to add a payment method. You may need to log out and log back in to GitHub before reapplying. If you have only a single legal name, enter it in both the first and last name fields.": "，並確保其中的姓名與您學籍證明文件中的姓名完全一致。您無需添加支付方式。您可能需要先登出 GitHub，然後重新登錄後再申請。如果您只有一個法定姓名，請在名字和姓氏字段中填寫相同的姓名。",

                    "You are unlikely to be verified until you have completed your": "在您用學籍證明文件上的全名完善",
                    "GitHub user profile": "GitHub 用戶資料",
                    "with your full name exactly as it appears in your academic affiliation document. Please do not use a variation of your name or a nickname. Once you have updated your profile information log out and log back into GitHub before re-applying.": "之前，您不可能通過驗證。請不要使用姓名的變體或暱稱。更新資料信息後，請先登出 GitHub，然後重新登錄後再申請。",
    },
    "regexp": [
        [/Submitted(?: about)? (.+)/, (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `提交於 ${translatedDate}`;
        }],
        [/Expires in almost (\d+) years?/, "有效期大約 $1 年"],
    ],
};

I18N["zh-TW"]["settings/emails"] = { // 設置 - 電子郵箱
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Emails 電子郵箱 https://github.com/settings/emails
            // 黃框警告
                "You have a single verified email associated with your GitHub account. Add an additional verified email address in case you lose access to your primary email.": "您的 GitHub 賬戶只有一個經過驗證的電子郵箱。添加另一個經過驗證的電子郵箱地址吧，那樣即使主電子郵箱無法使用也不要緊。",
            // 頂部提示信息
                "Emails you can use to sign in to your account. Verified emails can be used as the author or committer addresses for web-based Git operations, e.g. edits and merges.":"可用於登錄賬戶的電子郵箱。經過驗證的電子郵箱可以用作基於網頁的 Git 操作（如編輯和合併）的作者或提交者地址。",
            // [/Emails you can use to sign in to your account. Your emails will not be used as the 'from' address for web-based Git operations, e.g. edits and merges. All web-based Git operations will be linked to ([^@]+@users.noreply.github.com)/, "可用於登錄賬戶的電子郵箱。這些郵箱不會用作基於網頁的 Git 操作（如編輯和合併）的 “發件人” 地址。所有基於網頁的 Git 操作都將關聯至 $1。"],

            "Primary": "主賬戶",
                "Backup": "備用",
                "This email address is the default for GitHub notifications, such as replies to issues, pull requests, and similar activity.": "此電子郵箱地址是 GitHub 通知的默認地址，例如對議題、拉取請求和類似活動的回覆。",
                // [/Manage email/, "管理郵箱地址"],
                "Manage email preferences": "管理電子郵件首選項",
                "Resend verification email": "重新發送驗證郵件",
                // 刪除按鈕 提醒信息
                    "Are you sure you want to remove this email from your account? Once removed, commits attributed to this email address will no longer be associated with your account.": "您確定要從賬戶中移除此郵箱嗎？移除後，該郵箱地址關聯的提交記錄將不再與您的賬戶關聯。。",
                    "Are you sure you want to remove this email from your account? Once removed, commits attributed to this email address will no longer be associated with your account. One of your other emails will become your primary address.": "您確定要從賬戶中移除此郵箱嗎？移除後，該郵箱地址關聯的提交記錄將不再與您的賬戶關聯。您其他郵箱中的一個將自動成為主要地址。",
                    "At least one email is required.": "至少需要一個電子郵箱。",
                    "At least one verified email is required.": "至少需要一個已驗證的電子郵箱。",
                    // 頂部提醒
                        // [/Removed email ([^@]+@[^\n]+) from your account./, "已將郵箱 $1 從您的賬戶中移除。"],

            "Add email address": "添加電子郵箱",
                "Email address": "電子郵箱",
                    // 頂部提醒
                        // [/We sent a verification email to ([^@]+@[^\s]+)\. Please follow the instructions in it\./, "我們已向 $1 發送了驗證郵件，請登錄郵箱已完成驗證。"],

            "Primary email address": "主電子郵箱",
                "Select an email to be used for account-related notifications and can be used for password reset.": "選擇用於帳戶相關通知的電子郵件地址，並可用於密碼重置。",
                // 頂部提醒
                    "Your primary email was changed to": "您的主電子郵箱已更改為",
                    ". Your default notification email address is still set to": "。您的默認通知電子郵箱仍然設置為",
                    ". Would you like to update that as well?": "。您也想更新它嗎？",
                    "Yes, update my notification email": "是的，更新我的通知電子郵箱",

            "Backup email address": "備用電子郵箱",
                "Your backup GitHub email address will be used as an additional destination for security-relevant account notifications and can also be used for password resets.": "您的備用 GitHub 電子郵箱將用作接收賬戶安全相關通知的額外方式，也可以用於密碼重置。",
                    "Allow all verified emails": "允許所有已驗證的電子郵箱",
                        // 頂部提醒
                            "All verified emails can now be used for password resets.": "所有已驗證的電子郵箱現在均可用於密碼重置。",
                    "Only allow primary email": "僅允許主電子郵箱",
                        // 頂部提醒
                            "Only your primary email address can now be used for password resets.": "現在只有您的主電子郵箱可用於密碼重置。",

            "Keep my email addresses private": "保持我的電子郵箱地址的私密性",
                "We’ll remove your public profile email and use": "我們將刪除您的公開個人資料中的電子郵箱，並使用",
                "when performing web-based Git operations (e.g. edits and merges) and sending email on your behalf. If you want command line Git operations to use your private email you must": "執行基於 Web 的 Git 操作（例如：編輯和合併）並以您的名義發送電子郵件。如果您想在命令行 Git 操作中使用您的私人電子郵箱，您必須",
                "set your email in Git": "在 Git 中設置您的電子郵箱",
                "Previously authored commits associated with a public email will remain public.": "以前創建的與公共電子郵件相關的提交將保持公開狀態。",
                "Off": "禁用",
                "On": "啟用",

                // 頂部提醒
                    "Your primary email address is now public. To select which email to display on your profile, visit": "您的主電子郵箱地址現已公開。要選擇在您的個人資料中顯示哪個電子郵箱，請訪問",
                    "profile settings.": "個人資料設置。",
                    "Your primary email address is now private. If you previously made your email public, we’ve removed it from your profile.": "您的主電子郵箱地址現已設為私密。如果您以前公開過您的電子郵箱，我們已經從您的個人資料中刪除了它。",

            "Block command line pushes that expose my email": "阻止在命令行推送中暴露我的電子郵箱",
                "When you push to GitHub, we’ll check the most recent commit. If the author email on that commit is a private email on your GitHub account, we will block the push and warn you about exposing your private email.": "當您推送到 GitHub 時，我們會檢查最近的提交。如果該提交的作者電子郵箱是您 GitHub 賬戶上的私人電子郵箱，我們會阻止推送並警告您不要暴露您的私人電子郵箱。",
                // 頂部提醒
                    "Commits pushed with a private email will no longer be blocked.": "使用私人電子郵箱推送的提交將不再被阻止。",
                    "Commits pushed with a private email will now be blocked and you will see a warning.": "使用私人電子郵箱推送的提交將被阻止，您會看到一個警告。",

        // 訂閱偏好 https://github.com/settings/emails/subscriptions
            "Subscription preferences for": "訂閱首選項",
            "⏳Please wait while we find your subscriptions...⌛": "⏳請稍候，我們正在查找您的訂閱...⌛",
            "No subscriptions found": "未找到訂閱信息",
            "Save subscription preferences": "保存訂閱首選項",
            "Back to email settings": "返回電子郵件設置",
            "To stop receiving emails for the topics below, uncheck any topics you don't want to receive, then click Save subscription preferences": "要停止接收以下主題的電子郵件，請取消選中您不想接收的任何主題，然後單擊保存訂閱首選項",
            "General info and offers from GitHub": "GitHub 上的一般信息和優惠",
                "Get tips, solutions and exclusive offers from GitHub about products, services and events we think you might find interesting.": "從 GitHub 獲取有關我們認為您可能感興趣的產品、服務和活動的提示、解決方案和獨家優惠。",
            "Unsubscribe from all topics": "取消訂閱所有主題",

    },
    "regexp": [ // 正則翻譯
        [/Emails you can use to sign in to your account. Your emails will not be used as the 'from' address for web-based Git operations, e.g. edits and merges. All web-based Git operations will be linked to ([^@]+@users.noreply.github.com)./, "可用於登錄賬戶的電子郵箱。該郵箱不會用作基於網頁的 Git 操作（如編輯和合併）的 “發件人” 地址。所有基於網頁的 Git 操作都將關聯至 $1。"],
        [/Manage email/, "管理郵箱地址"],
        [/We sent a verification email to ([^@]+@[^\s]+)\. Please follow the instructions in it\./, "我們已向 $1 發送了驗證郵件，請登錄郵箱已完成驗證。"],
        [/Your primary email was changed to ([^@]+@[^\n]+)\./, "您的主電子郵箱已更改為 $1"],
        [/Subscription preferences for ([^@]+@[^\n]+)/, "$1 的訂閱偏好"],
        [/Removed email ([^@]+@[^\n]+) from your account./, "已將郵箱 $1 從您的賬戶中移除。"],
    ],
    "title": {
        "static": {
            "Email settings": "郵箱設置",
        },
    },
};

I18N["zh-TW"]["settings/security"] = { // 設置 - 密碼和身份身份驗證
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["confirm-access"]["static"],

        // 密碼和身份身份驗證 - 賬戶安全 https://github.com/settings/security
            "Change password": "更改密碼",
            "Old password": "舊密碼",
            "New password": "新密碼",
            "Confirm new password": "確認新密碼",
            "Make sure it's": "請確保",
            "at least 15 characters": "至少需要15個字符",
            "OR": " 或者",
            "at least 8 characters": "至少需要8個字符",
            "including a number": "包括數字",
            "and a lowercase letter": "和小寫字母",
            "Password is too short (minimum is 8 characters)": "密碼太短（最少8個字符）",
            "Password is too short (minimum is 8 characters), needs at least 1 lowercase letter, and is in a list of passwords commonly used on other websites": "密碼太短（最少8個字符），至少需要1個小寫字母，而且已在其他網站常用密碼列表中",
            "Password is too short (minimum is 8 characters), needs at least 1 lowercase letter, cannot include your login, and is in a list of passwords commonly used on other websites": "密碼太短（最少為8個字符），至少需要1個小寫字母，而且不能包括您的登錄名，以及在其他網站常用的密碼列表中。",
            "Password is too short (minimum is 8 characters), needs at least 1 number, cannot include your login, and is in a list of passwords commonly used on other websites": "密碼太短（最少8個字符），需要至少1個數字，不能包含您的登錄名，以及在其他網站常用的密碼列表中",
            "Password is too short (minimum is 8 characters) and is in a list of passwords commonly used on other websites": "密碼太短（最少為8個字符），而且已在其他網站常用的密碼列表中。",
            "Password needs at least 1 lowercase letter and is in a list of passwords commonly used on other websites": "密碼需要至少 1 個小寫字母，而且已在其他網站常用的密碼列表中",
            "Password is in a list of passwords commonly used on other websites": "密碼在其他網站常用的密碼列表中",
            "Update password": "更新密碼",
            "I forgot my password": "我忘記了我的密碼",

            "Strengthen your account by ensuring your password is strong.": "確保密碼的安全性，以保護您的賬戶。",
            "Learn more about creating a strong password": "瞭解更多關於創建強密碼的信息",

            "Passkeys": "通行密鑰",
                "Passwordless sign-in with passkeys": "使用通行密鑰進行無密碼登錄",
                "Passkeys are webauthn credentials that validate your identity using touch, facial recognition, a device password, or a PIN. They can be used as a password replacement or as a 2FA method. Passkeys can be used for sign-in as a simple and secure alternative to your password and two-factor credentials.": "通行密鑰是一種 WebAuthn 憑證，可以使用觸摸、面部識別、設備密碼或 PIN 碼驗證您的身份。它們可以作為密碼替代品或作為雙因素身份驗證（2FA）方法使用。通行密鑰可以作為一種簡單且安全的替代方式用於登錄，替代您的密碼和雙因素身份驗證憑證。",
                "This browser or device does not fully support passkeys - you may be able to use a passkey from another device.": "此瀏覽器或設備不完全支持通行密鑰 - 您可以嘗試使用來自其他設備的通行密鑰。",
                "This browser or device is reporting partial passkey support, but you may be able to use a passkey from a nearby device.": "此瀏覽器或設備不完全支持通行密鑰 - 您可以嘗試使用來自其他設備的通行密鑰。",
                "Add a passkey": "添加通行密鑰",

                "Passkeys are webauthn credentials that validate your identity using touch, facial recognition, a device password, or a PIN. They can be used as a password replacement or as a 2FA method.": "通行密鑰是一種 WebAuthn 憑證，可以使用觸摸、面部識別、設備密碼或 PIN 碼驗證您的身份。它們可以作為密碼替代品或作為雙因素身份驗證（2FA）方法使用。",
                "Learn more about passkeys": "瞭解更多關於通行密鑰的信息",

                "Your passkeys": "您的通行密鑰",
                "Edit passkey nickname": "編輯通行密鑰暱稱",
                // [/Delete `([^ ]+)` passkey/, "刪除 “$1” 通行密鑰"],

                // 刪除密鑰對話框
                    "Delete passkey?": "刪除通行密鑰？",
                    // [Are you sure you want to delete your `([^ ]+)` passkey?/, "您確定要刪除您的 “$1” 通行密鑰嗎？"],
                    "You will no longer be able to use it to sign-in to your account.": "您將無法再使用它登錄您的賬戶。",
                    "Note: You may continue to see this passkey as an option during sign-in until you also delete it from your browser, device or associated account's password management settings.": "注意：您可能會在登錄過程中繼續看到此通行密鑰作為一個選項，直到您將其從瀏覽器、設備或關聯賬戶的密碼管理設置中刪除。",
                    "Deleting…": "刪除中…",

            // Google
                "1 account connected": "已連接 1 個帳戶",
                "Google sign in method dropdown": "Google 登錄方法下拉菜單",

            // 雙因素身份驗證
                // 頂部提醒
                    "You can now manage your two-factor authentication methods from this page.": "您現在可以從此頁面管理您的雙因素身份驗證方法。",
                    "Two-factor authentication successfully disabled.": "成功禁用雙因素身份驗證。",
                    "SMS/Text message successfully configured.": "短信/文本信息配置成功。",
                    "Authenticator app successfully reconfigured.": "驗證器重配置成功。",

            "Sign in methods": "登錄方式",
                "Email": "電子郵件", // 下行內容走正則
                    "Manage": "管理",
                // 通行密鑰
                    "Passwordless sign-in with biometrics or security keys": "使用生物識別或安全密鑰進行無密碼登錄",
                    "Add passkey": "添加通行密鑰",
                    "Seen from this browser": "在此瀏覽器中可見",
                    "Synced": "已同步",
                // Google
                    "Sign in with your Google account": "使用 Google 賬戶登錄",
                    "Connect": "連接",
                // Apple
                    "Sign in with your Apple account": "使用 Apple 賬戶登錄",

            "Two-factor authentication": "雙因素身份驗證",
                "Two-factor authentication is not enabled yet.": "尚未啟用雙因素身份驗證。",
                "Enable two-factor authentication": "啟用雙因素身份驗證",

                "Because of your contributions on GitHub, two-factor authentication is required for your account. Thank you for helping keep the ecosystem safe!": "基於您在 GitHub 上的貢獻，您的賬戶需要雙因素身份驗證。感謝您幫助維護生態系統安全！",
                "Because of your contributions on GitHub, two-factor authentication will be required for your account starting": "基於您在 GitHub 上的貢獻，從",
                ". Thank you for helping keep the ecosystem safe!": " 開始，您的賬戶將需要雙因素身份驗證，感謝您幫助維護生態系統的安全！",
                "Learn more about our two-factor authentication initiative": "瞭解更多關於我們的雙因素身份驗證的倡議",

                "Two-factor authentication adds an additional layer of security to your account by requiring more than just a password to sign in.": "雙因素身份驗證不僅僅要求密碼登錄，還為您的賬戶增加了一層額外的安全性。",
                "Learn more about two-factor authentication": "瞭解更多關於雙因素身份驗證的信息",


                "Enable": "啟用",
                "Enabled": "啟用",
                    "Two-factor authentication is required for at least one organization or enterprise account you're affiliated with.": "至少有一個您所屬的組織或企業賬戶需要進行雙因素身份驗證。",
                "Disable": "停用",

            "Preferred 2FA method": "首選 2FA 方法",
                "Set your preferred method to use for two-factor authentication when signing into GitHub.": "設置登錄 GitHub 時用於雙因素身份驗證的首選方法。",
                "Passkeys should be used primarily for standalone, password-less authentication.":"通行密鑰應主要用於獨立的無密碼身份驗證。",

            "Two-factor methods": "雙因素身份驗證方式",
                "Configured": "已配置",

                "Authenticator app": "身份驗證器應用",
                    "Use an authentication app or browser extension to get two-factor authentication codes when prompted.": "在出現提示時，使用身份驗證器應用或瀏覽器擴展獲取雙因素身份驗證碼。",
                    "Use an authentication app or browser extension to generate one-time codes.": "使用身份驗證應用或瀏覽器擴展生成一次性程式碼。",

                    "Manage Authenticator app": "管理身份驗證器應用",

                    "Authenticator apps and browser extensions like": "身份驗證器應用和瀏覽器擴展，例如",
                    ", etc. generate one-time passwords that are used as a second factor to verify your identity when prompted during sign-in.": "等生成一次性密碼，在登錄過程中出現提示時用作第二驗證因素來驗證您的身份。",

                    "Scan the QR code": "掃描二維碼",
                    "Re-scan the QR code": "重新掃描二維碼",
                    "Use an authenticator app or browser extension to scan.": "請使用身份驗證器應用或瀏覽器擴展進行掃描。",
                    "Learn more about enabling 2FA": "瞭解更多關於啟用 2FA 的信息",

                    "Unable to scan? You can use the": "無法掃描？您可以使用",
                    "setup key": "設置密鑰",
                    "to manually configure your authenticator app.": "手動配置您的身份驗證器應用。",
                        "Your two-factor secret": "您的雙因素密鑰",

                    "Verify the code from the app": "驗證來自身份驗證器應用的驗證碼",
                    "Two-factor code verification failed. Please try again.": "雙因素身份驗證碼驗證失敗。請重試。",

                "SMS/Text message": "短信/文字信息",
                    "Manage SMS/Text message": "管理短信/文字信息",
                    "Less secure": "不安全",

                    "Get one-time codes sent to your phone via SMS to complete authentication requests. We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. It is recommended to use an Authenticator app instead of SMS.": "通過短信向您的手機送達一次性驗證碼，以完成身份驗證請求。我們強烈建議不要使用短信，因為短信容易受到攔截，無法抵禦釣魚攻擊，且送達率可能不可靠。建議使用身份驗證器應用代替短信。",

                    "Get authentication codes by SMS on your mobile phone when signing into GitHub. Make sure that": "登錄 GitHub 時通過手機短信獲取驗證碼。確保",
                    "your country or region is supported": "支持您的國家/地區",
                    "for SMS delivery.": "用於短信發送。",

                    "Verify account": "驗證賬戶",
                    "Before setting up SMS, please verify that you're a human.": "在設置短信之前，請驗證您是人類。",

                    "Country or region code": "國家/地區程式碼",
                    "Your phone number": "您的手機號碼",
                    "Send authentication code": "發送驗證碼",

                    "Sent. It may take a minute for the SMS to arrive.": "已發送。短信可能需要一分鐘時間才能送達。",
                    "Verify the code sent to your phone": "驗證發送到您手機的驗證碼",

                    // [/We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. Instead, we recommend configuring an authenticator app and disabling SMS as a 2FA method. You will receive one-time codes at this phone number:/, "我們強烈建議不要使用短信，因為短信容易受到攔截，無法抵禦釣魚攻擊，而且送達率可能不可靠。相反，我們建議配置一個身份驗證器應用，並禁用短信作為雙因素身份驗證。您將通過以下電話號碼收到一次性驗證碼："], // 已設置短信/文字信息

                    // 頂部提醒
                        "SMS/Text message successfully disabled.": "短信/文字消息已成功禁用。",

                "Security keys": "安全密鑰",
                    "Security keys are webauthn credentials that can only be used as a second factor of authentication.": "安全密鑰是 WebAuthn 憑證，只能用作第二驗證因素。",
                    "Hide": "隱藏",
                    "No security keys": "沒有安全密鑰",

                    "Register new security key": "註冊新安全密鑰",
                    "Enter a nickname for this security key": "輸入安全密鑰的暱稱",
                    "Waiting for input from browser interaction...": "等待來自瀏覽器交互的輸入…",
                    "Security key registration failed.": "安全密鑰註冊失敗。",
                    "Try again": "請重試",

                "GitHub Mobile": "GitHub Mobile",
                    "GitHub Mobile can be used for two-factor authentication by installing the GitHub Mobile app and signing in to your account.": "通過安裝 GitHub Mobile 應用並登錄賬戶，可以使用 GitHub Mobile 來進行雙因素身份驗證。",
                    "Manage GitHub Mobile": "管理 GitHub Mobile",

                    // [/(\d+) devices?/, "$1 設備"], // 設置--> 密碼和身份驗證頁
                    "Show": "顯示",

            "Recovery options": "恢復選項",
                "Your two-factor authentication recovery codes have not been downloaded or printed in the last one year. Make sure your recovery codes are up-to-date by viewing and downloading or printing them again.": "您的雙因素身份驗證恢復碼在過去一年中未被下載或打印。請通過查看並再次下載或打印恢復碼，確保您的恢復碼是最新的。",

                "Recovery codes": "恢復碼",
                    "Recovery codes can be used to access your account in the event you lose access to your device and cannot receive two-factor authentication codes.": "恢復碼可用於在您無法訪問設備且無法接收雙因素身份驗證碼的情況下訪問您的賬戶。",
                    "Viewed": "已查看",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) devices?/, "$1 個設備"], // 設置--> 密碼和身份驗證頁
        [/We strongly advise against using SMS because it is susceptible to interception, does not provide resistance against phishing attacks, and deliverability can be unreliable. Instead, we recommend configuring an authenticator app and disabling SMS as a 2FA method. You will receive one-time codes at this phone number:/, "我們強烈建議不要使用短信，因為短信容易受到攔截，無法抵禦釣魚攻擊，而且送達率可能不可靠。相反，我們建議配置一個身份驗證器應用，並禁用短信作為雙因素身份驗證。您將通過以下電話號碼收到一次性驗證碼："], // 已設置短信/文字信息
        [/Delete `([^ ]+)` passkey/, "刪除 “$1” 通行密鑰"],
        [/Are you sure you want to delete your `([^ ]+)` passkey?/, "您確定要刪除您的 “$1” 通行密鑰嗎？"],
        [/(\d+) verified emails? configured/, "已配置 $1 個已驗證的郵箱"],
        // 1 passkey configured
        [/(\d+) passkeys? configured/, "已配置 $1 個通行密鑰"],
        [/Added (.*) \| Last used (.*)/, (match, p1, p2) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const dateAdded = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            const dateLastUsed = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p2);
            return `添加於 ${dateAdded} | 最後使用 ${dateLastUsed}`;
        }]
    ],
    "title": {
        "static": {
            "Account security": "賬戶安全",
        },
    },
};

I18N["zh-TW"]["settings/auth"] = {
    "static": { // 靜態翻譯

        // 查看恢復碼 https://github.com/settings/auth/recovery-codes
            // 頂部提醒
                "New two-factor recovery codes successfully generated. Save them in a safe, durable location and discard your previous codes.": "已成功生成新的雙因素身份驗證恢復碼。將它們保存在安全、耐用的位置，並丟棄以前的恢復碼。", // 生成新恢復碼

            "Two-factor recovery codes": "雙因素身份驗證恢復碼",
                "Recovery codes can be used to access your account in the event you lose access to your device and cannot receive two-factor authentication codes.": "恢復碼可用於在您無法訪問設備且無法接收雙因素身份驗證碼的情況下訪問您的賬戶。",
                "Your two-factor authentication recovery codes have not been downloaded or printed in the last one year. Make sure your recovery codes are up-to-date by downloading or printing them again.": "您的雙因素身份驗證恢復碼在過去一年中沒有下載或打印過。請重新下載或打印恢復程式碼，確保您的恢復程式碼是最新的。",

            "Recovery codes": "恢復碼",
                "Keep your recovery codes as safe as your password. We recommend saving them with a password manager such as": "保持您的恢復碼與您的密碼一樣安全。我們建議使用密碼管理器保存它們，例如",
                "Keep your recovery codes in a safe spot.": "將您的恢復碼保存在一個安全的地方。",
                "These new codes have replaced your old codes. Save them in a safe spot.": "這些新恢復碼已取代您的舊恢復。請將它們保存在安全的地方。", // 生成新恢復碼
                "These codes are the last resort for accessing your account in case you lose your password and second factors. If you cannot find these codes, you": "這些恢復碼是在您丟失密碼和第二驗證因素的情況下訪問您賬戶的最後手段。如果您找不到這些恢復碼，您",
                "will": "將",
                "lose access to your account.": "無法訪問您的賬戶。",

                "Print": "打印",

            "Generate new recovery codes": "生成新恢復碼",
                "When you generate new recovery codes, you must download or print the new codes.": "當您生成新恢復碼時，您必須下載或打印新恢復碼。",
                "Your old codes won't work anymore.": "您的舊恢復碼將失效。",

            "Back to settings": "返回設置",
    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["settings/sessions"] = {
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 會話詳情 https://github.com/settings/sessions
            "Web sessions": "網絡會話",
            "GitHub Mobile can be used to verify your identity when signing in from a new device and as a two-factor authentication method.": "GitHub Mobile 可用於從新設備登錄時驗證您的身份，並作為一種雙因素身份驗證方法。",
            "Learn more about authentication with GitHub Mobile.": "瞭解更多關於 GitHub Mobile 身份驗證的信息。",
            "To get started, install GitHub Mobile for": "首先，安裝 GitHub Mobile 適用於",
            "and sign in to your account.": "並登錄您的賬戶。",

            "This is a list of devices that have logged into your account. Revoke any sessions that you do not recognize.": "這是已登錄您賬戶的設備列表。 撤銷任何您不認識的會話。",
            "See more": "查看更多",
            "Your current session": "您當前的會話",
            "Last accessed on": "最後訪問日期：",
            "active": "激活",
            "stale": "閒置",

            "GitHub Mobile sessions": "GitHub Mobile 會話",
            "This is a list of devices that have logged into your account via the GitHub Mobile app. Revoke any session that you do not recognize or you can": "這是已通過 GitHub Mobile 應用登錄到您賬戶的設備列表。撤銷任何您不認識的會話，或者您可以",
            "revoke": "撤消",
            "your GitHub Mobile app authorization to sign out of all your devices.": "您的 GitHub Mobile 應用授權，以登出您的所有設備。",
            "Revoke": "撤消",
            "Registered -": "註冊於 -",
            "Last accessed -": "最後訪問 -",
            "Last used for authentication -": "最後一次認證 -",
            "Never used": "未使用",

        // 會話詳情 https://github.com/settings/sessions/<id>
            "Session details": "會話詳情",
            "Revoke session": "撤銷會話",
            "Device:": "設備：",
            "Last location:": "最後的位置：",
            "Signed in:": "登錄：",
            "View all sessions": "查看所有會話",
    },
    "regexp": [ // 正則翻譯
        [/Seen in/, "登錄於"],
    ],
    "title": {
        "static": {
            "Sessions": "會話",
        },
    },
};

I18N["zh-TW"]["settings/keys"] = { // 設置 - SSH 與 GPG 公鑰
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // SSH and GPG keys SSH 與 GPG 公鑰 https://github.com/settings/keys
            "SSH keys": "SSH 密鑰",
            "New SSH key": "新建 SSH 密鑰",
            "Authentication keys": "認證密鑰",
            "Signing keys": "簽名密鑰",
            "Signing": "簽名",
            "There are no SSH keys associated with your account.": "沒有與您的賬戶關聯的 SSH 密鑰。",
            "This is a list of SSH keys associated with your account. Remove any keys that you do not recognize.": "這是與您的賬戶相關的 SSH 密鑰的列表。刪除任何您無法識別的密鑰。",
            "Never used": "從未使用",
                "— Read/write": "- 讀寫",
            "Last used within the last week": "上週內最後一次使用",
            "Check out our guide to": "請看我們的指南",
            "connecting to GitHub using SSH keys": "使用 SSH 密鑰連接到 GitHub",
            "or troubleshoot": "或解決",
            "common SSH problems": "常見的 SSH 問題",

            "GPG keys": "GPG 密鑰",
            "New GPG key": "新建 GPG 密鑰",
            "There are no GPG keys associated with your account.": "沒有與您的賬戶關聯的 GPG 密鑰。",
            "This is a list of GPG keys associated with your account. Remove any keys that you do not recognize.": "這是與您的賬戶相關的 GPG 密鑰的列表。刪除任何您無法識別的密鑰。",

            "Email address:": "電子郵件地址：",
            "Key ID:": "密鑰 ID：",
            "Subkeys:": "子密鑰：",
            "Added": "添加於",

            "Learn how to": "瞭解如何",
            "generate a GPG key and add it to your account": "生成 GPG 密鑰並將其添加到您的賬戶",

            "Vigilant mode": "警戒模式",
            "Flag unsigned commits as unverified": "將未簽名的提交標記為未驗證",
            "This will include any commit attributed to your account but not signed with your GPG or S/MIME key.": "這將包括任何歸屬於您的賬戶但沒有用您的 GPG 或 S/MIME 密鑰簽名的提交。",
            "Note that this will include your existing unsigned commits.": "請注意，這將包括您現有的未簽名的提交。",
            "Learn about vigilant mode": "瞭解警戒模式",

            // SSH 密鑰刪除 對話框
            "Are you sure you want to delete this SSH key?": "您確定要刪除此 SSH 密鑰嗎？",
            "This action": "該操作",
            "CANNOT": "不能",
            "be undone. This will permanently delete the SSH key and if you’d like to use it in the future, you will need to upload it again.": "被撤銷。這將永久地刪除 SSH 密鑰，如果您想在未來使用它，您將需要再次上傳它。",
            "I understand, delete this SSH key": "我明白了，刪除此 SSH 密鑰",

            // GPG 密鑰刪除 對話框
            "Are you sure you want to delete this GPG key?": "您確定要刪除此 GPG 密鑰嗎？",
            "be undone. This will permanently delete the GPG key, and if you’d like to use it in the future, you will need to upload it again.": "被撤銷。這將永久地刪除 GPG 密鑰，如果您想在未來使用它，您將需要再次上傳它。",
            "Any commits you signed with this key will become unverified after removing it.": "刪除後，您使用此密鑰簽名的任何提交都將變成未驗證。",
            "Commits you signed with this key may become unverified after removing it.": "移除此密鑰後，您使用它簽署的提交可能會變為未驗證狀態。",
            "Learn more about persistent commit signature verification.": "瞭解更多關於持久性提交簽名驗證的信息。",
            "I understand, delete this GPG key": "我明白了，刪除此 GPG 密鑰",
            "Okay, you have successfully deleted that key.": "好的，您已成功刪除該密鑰。",
            "cannot": "不能",

            // 頂部提醒
            "Key is invalid. You must supply a key in OpenSSH public key format": "密鑰無效。您必須提供 OpenSSH 公鑰格式的密鑰",
            "We got an error doing that.": "我們在這樣做時出錯了。",
            "We got an error adding your GPG key. Please verify the input is a valid GPG key.": "添加您的 GPG 密鑰時出錯。請確認輸入的是有效的 GPG 密鑰。",

    },
    "regexp": [ // 正則翻譯
        [/You have successfully added the key \'([^ ]+)\'./, "成功添加密鑰 “$1”。"],
        [/Last used within the last (\d+) weeks?/, "$1 周內最後一次使用"],
    ],
    "title": {
        "static": {
            "SSH and GPG keys": "SSH 和 GPG 密鑰",
        },
    },
};

I18N["zh-TW"]["settings/ssh"] = { // 設置 - SSH 與 GPG 公鑰 - 添加 SSH 公鑰
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 添加 SSH 公鑰 https://github.com/settings/ssh/new
            "Add new SSH Key": "添加新 SSH 密鑰",
            "Title": "標題",
            "Key type": "密鑰類型",
                "Authentication Key": "認證密鑰",
                "Signing Key": "簽名密鑰",
            "Key": "密鑰",
            "Add SSH key": "添加 SSH 密鑰",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["settings/gpg"] = { // 設置 - SSH 與 GPG 公鑰 - 添加 GPG 公鑰
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 添加 GPG 公鑰 https://github.com/settings/gpg/new
            "Add new GPG key": "添加新 GPG 密鑰",
            "Title": "標題",
            "Key": "密鑰",
            "Add GPG key": "添加 GPG 密鑰",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["settings/organizations"] = { // 設置 - 組織
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Organizations 組織 https://github.com/settings/organizations
            "You are not a member of any organizations.": "您暫無任何組織。",

            "Owner": "所有者",
            "Member": "成員",
            "Compare plans": "比較計劃",
            "Leave": "離開",
            "Leave organization":"離開組織",

            "Transform account": "賬戶變更",
            "You cannot transform this account into an organization until you leave all organizations that you’re a member of.": "在您離開您所屬的所有組織之前，您無法將此賬戶轉換為組織。", // 存在所屬組織時
            "You cannot transform this account into an organization because you have an active GitHub Sponsors account.": "由於您有一個活躍的 GitHub 贊助者賬戶，因此您無法將此賬戶轉換為組織。", // 存在贊助者賬戶時
            "Account Transformation Warning": "賬戶變更警告",
            "What you are about to do is an irreversible and destructive process. Please be aware:": "這將是一個不可逆轉的過程，請確認：",
            "Any user-specific information (OAuth tokens, SSH keys, Job Profile, etc) will be erased": "任何用戶特定的信息（OAuth 令牌, SSH 密鑰, 職位簡介, 等）將被刪除。",
            "You will no longer be able to create or modify gists owned by the converted personal account": "您將無法再創建或修改已轉換的個人賬戶所擁有的程式碼片段",
            "create a new personal account": "創建一個新的個人賬戶",
            "The total amount of collaborators across private repositories will be the total amount of seats for the organization": "跨私人倉庫的協作者總數將是該組織的席位總數",

    },
    "regexp": [ // 正則翻譯
        [/Turn ([^ ]+) into an organization/, "變更 $1 為組織"],
        [/You will no longer be able to sign in to ([^ ]+) \(all administrative privileges will be bestowed upon the owners you choose\)/, "您將無法再登錄 $1（所有管理權限都將授予您選擇的所有者）"],
        [/Any commits and comments credited to ([^ ]+) will no longer be linked to this GitHub account/, "任何歸功於 $1 的提交和評論將不再與此 GitHub 賬戶相關聯"],
        [/Any GitHub Apps installed on ([^ ]+) will be uninstalled/, "$1 上安裝的任何 GitHub 應用程式都將被卸載"],
        [/If you are using ([^ ]+) as a personal account, you should/, "如果您將 $1 用作個人賬戶，您應該在將 $1 轉變為組織之前先"],
        [/before transforming ([^ ]+) into an organization./, "。"],
        [/Outside collaborator on (\d+) repositor(y|ies)/, "$1 個倉庫的外部協作者"], // 設置 - 組織
        [/Member and collaborator on (\d+) repositor(y|ies)/, "$1 個倉庫的成員和協作者"],
        [/Are you positive you want to leave ([^ ]+)\? You will lose access to all repositories and teams./, "您確定要離開 $1 嗎？您將失去對所有倉庫和團隊的訪問權。"], // 設置 - 組織 離開按鈕 提醒
        [/Are you positive you want to leave ([^ ]+)\? You will lose access to all repositories./, "您確定要離開 $1 嗎？您將失去對所有倉庫的訪問權。"], // 設置 - 組織 離開按鈕 提醒
        [/You left ([^ ]+)\. It may take a few minutes to process\./, "您已離開 $1。可能需要幾分鐘處理。"], //設置，離開組織後的提示
    ],
    "title": {
        "static": {
            "Organizations": "組織",
        },
    },
};

I18N["zh-TW"]["settings/enterprises"] = { // 設置 - 企業版
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 企業版 https://github.com/settings/enterprises
        "Enterprises": "企業版",
        "You don't have any enterprises": "您還沒有任何企業版",
        "Designed for businesses or teams who collaborate on GitHub.com": "專為在 GitHub.com 上協作的企業或團隊而設計",

        "Start free for 30 days": "免費試用 30 天",
        "Start a free trial": "開啟免費體驗",
        "Learn more about enterprises": "瞭解更多關於企業版信息",
    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Enterprises": "企業版",
        },
    },
};

I18N["zh-TW"]["settings/blocked_users"] = { // 設置 - 黑名單
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Blocked users 黑名單 https://github.com/settings/blocked_users
            "Block a user": "拉黑用戶",
            "Blocking a user prevents the following on all your repositories:": "拉黑用戶可以防止所有倉庫中的以下操作：",
            "opening or commenting on issues or pull requests": "打開或評論議題或拉取請求",
            "starring, forking, or watching": "標星、複刻、關注",
            "adding or editing wiki pages": "添加或編輯 Wiki 頁面",
            "Additionally, blocked users are not able to:": "此外，被拉黑用戶無法：",
            "invite you as a collaborator to their repositories": "邀請您作為其倉庫的協作者",
            "follow your account’s public activity": "關注您的賬戶的公共活動",
            "send you notifications by @mentioning your username in public repositories": "在公共倉庫中通過 @您 向您發送通知",
            "Search by username, full name or email address": "搜索用戶名、全名、或電子郵箱",
                "Learn more about blocking a user": "瞭解更多關於拉黑用戶的信息",
            "Block user": "拉黑用戶",
            "You have not blocked any users.": "您還沒有拉黑任何用戶。",
            "Unblock": "取消拉黑",
            "Warn me when a blocked user is a prior contributor to a repository": "請警告我，當被拉黑的用戶是倉庫的先前貢獻者時",
            "On repositories you haven’t contributed to yet, we’ll warn you when a user you’ve blocked has previously made contributions.": "在您還沒有貢獻的倉庫裡，當您拉黑的用戶之前有貢獻時，我們會警告您。",
            "You can block a user to deny them access to repositories and more.": "您可以拉黑用戶，以拒絕他們訪問倉庫和其他功能。",
            "On repositories you haven't contributed to yet, we'll warn you when a user you've blocked has previously made contributions.": "在您還沒有貢獻的倉庫裡，當您拉黑的用戶之前有貢獻時，我們會警告您。",
            "All blocked users": "所有被拉黑的用戶",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Blocked users": "黑名單",
        },
    },
};

I18N["zh-TW"]["settings/interaction_limits"] = { // 設置 - 互動限制
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Interaction limits 互動限制 https://github.com/settings/interaction_limits
            "Temporary interaction limits": "臨時互動限制",
            "Temporarily restrict which external users can interact with your repositories (comment, open issues, or create pull requests) for a configurable period of time.": "在配置的時間段內，可臨時限制哪些外部用戶與您的倉庫互動（評論、打開議題或創建拉取請求）。",
            "This may be used to force a \"cool-down\" period during heated discussions or prevent unwanted interactions.": "可用於在激烈討論期間，強制進入 “冷靜” 期或防止不必要的互動。",
            "Interaction limits may already exist in your account's": "互動限制可能已經存在於您的",
            "public repositories": "公開倉庫",
            ". Any changes here will override those limits.": " 的設置中。此處的全局設置將覆蓋那些倉庫的局部設置。",
            "Limit to existing users": "僅限現有用戶",
                "Users that have recently created their account will be unable to interact with your repositories.": "最近創建賬戶的用戶將無法與您的倉庫互動。",
            "Limit to prior contributors": "僅限於先前的貢獻者",
                "Users that have not previously committed to the default branch of one of your repositories will be unable to interact with that repository.": "以前從未提交到您某個倉庫默認分支的用戶將無法與該倉庫互動。",
            "Limit to repository collaborators": "僅限倉庫協作者",
                "Users that are not collaborators of one of your repositories will not be able to interact with that repository.": "不是您某個倉庫的協作者將無法與該倉庫互動。",
            "New users": "新用戶",
            "Users": "用戶",
            "Contributors": "貢獻者",
            "Collaborators": "協作者",
            // 交互限制時間 下拉菜單
            "Enable interaction limits for:": "啟用交互限制：",
            "24 hours": "24 小時",
            "3 days": "3 天",
            "1 week": "1 周",
            "1 month": "1 個月",
            "6 months": "6 個月",
            // 頂部提醒
            "User interaction limit settings saved.": "用戶交互限制設置已保存。",

    },
    "regexp": [ // 正則翻譯
        [/Enabled with (.+) remaining./, "已啟用，還剩 $1。"],
    ],
    "title": {
        "static": {
            "Temporary interaction limits": "臨時互動限制",
        },
    },
};

I18N["zh-TW"]["settings/code_review_limits"] = { // 設置 - 程式碼審查限制
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 頂部提示
            "Code review limit settings saved.": "程式碼審查限制設置已保存。",

        // Code review limits 程式碼審查限制 https://github.com/settings/code_review_limits
            "Restrict users who are permitted to approve or request changes on pull requests in your public repositories.": "限制允許批准或請求更改公共倉庫中拉取請求的用戶。",
            "Code review limits may already be specified by individual repositories. Any changes here will override those limits until unset.": "程式碼審查限制可能已經由各個倉庫指定。此處的任何更改都將覆蓋這些限制，直至取消設置。",
            "Code review limits are currently managed individually for all repositories. Enable limits to permit only users who have explicitly been granted access to each repository to submit reviews that \"approve\" or \"request changes\". Remove limits to allow all users to submit pull request reviews. All users able to submit comment pull request reviews will continue to be able to do so.": "目前，所有倉庫程式碼審查限制都是單獨管理的。啟用限制，只允許明確授予每個倉庫訪問權的用戶提交 “批准” 或 “請求更改” 的審查。刪除限制，允許所有用戶提交拉取請求審查。所有能夠提交評論拉取請求審查的用戶將繼續能夠這樣做。",
            "Code review limits are currently": "目前，所有倉庫都",
            "enabled": "啟用",
            "disabled": "禁用",
            "for all repositories. Only users explicitly granted access to these repositories may submit pull request reviews that \"approve\" or \"request changes\". All users able to submit comment pull request reviews continue to be able to do so.": "程式碼審查限制。只有被明確授予訪問這些倉庫權限的用戶才能提交 “批准” 或 “請求更改” 的拉取請求審查。所有能夠提交評論拉取請求審查的用戶仍可繼續提交。",
            "for all repositories. All users are able to submit pull request reviews, including those that \"approve\" or \"request changes\". Limit reviews to only permit users who have explicitly been granted access to each repository to submit reviews that \"approve\" or \"request changes\".": "程式碼審查限制。所有用戶都可以提交拉取請求審查，包括那些 “批准” 或 “請求更改” 的審查。限制審查，只允許明確授予每個倉庫訪問權的用戶提交 “批准” 或 “請求更改” 的審查。",
            "Unset": "撤銷",
            "Limit reviews on all repositories": "限制對所有倉庫的審查",
            "Remove review limits from all repositories": "取消對所有倉庫的審查限制",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Code review limits": "程式碼審查限制",
        },
    },
};

I18N["zh-TW"]["settings/repositories"] = { // 設置 - 倉庫
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Repository 倉庫 https://github.com/settings/repositories
            "Repository default branch": "倉庫默認分支",
            "Choose the default branch for your new personal repositories. You might want to change the default name due to different workflows, or because your integrations still require “master” as the default branch name. You can always change the default branch name on individual repositories.": "為您新的個人倉庫選擇默認的分支。由於工作流程的不同，或者由於您的集成仍然需要 “master” 作為默認分支名，您可能想改變默認名稱。您可以隨時改變個人倉庫的默認分支名稱。",
            "Learn more about default branches.": "瞭解更多關於默認分支的信息。",
            "Deleted repositories": "刪除的倉庫",
            "Leave": "離開",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) collaborators?/, "$1 位協作者"]
    ],
    "title": {
        "static": {
            "Repositorys": "倉庫",
        },
    },
};

I18N["zh-TW"]["settings/deleted_repositories"] = { // 設置 - 倉庫 - 刪除的倉庫
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 刪除的倉庫 https://github.com/settings/deleted_repositories
            "Deleted repositories": "刪除的倉庫",
            "It may take up to an hour for repositories to be displayed here. You can only restore repositories that are not forks, or have not been forked.": "倉庫可能需要一個小時的時間才能顯示在這裡。您只能恢復不是複刻或沒有被複刻的倉庫。",
            "Learn more about restoring deleted repositories": "瞭解更多關於恢復已刪除倉庫的信息",

            "These repositories were deleted, but can't be restored by you. Contact support if you want to restore them.": "這些倉庫已被刪除，但您無法恢復。如果您想恢復它們，請聯繫 GitHub 支持人員。",

            "Deleted": "刪除於",
            // [/by/, "由"], // 刪除的倉庫
            "Restore": "恢復",
            "Queue…": "排隊中…",
            "Done!": "完成!",

            // 恢復倉庫 對話框
            // [/Are you sure you want to restore ([^ ]+)?/, "您確定要恢復 $1 嗎？"],
            "This repository will be in a private state when it is restored. To change this state, go to settings once the repo is restored.": "此倉庫在恢復時將處於私有狀態。要更改此狀態，請在倉庫恢復後轉到設置。",
            "Any team or collaborator permissions that previously existed for this repository will not be restored. If you require specific team or collaborator permissions, you will need to configure them in settings.": "此倉庫以前存在的任何團隊或協作者的權限將不會被恢復。如果您需要特定的團隊或協作者權限，則需要在設置中配置。",
            "I understand, restore this repository": "我明白了，依然恢復該倉庫。",

    },
    "regexp": [ // 正則翻譯
        [/No recoverable repositories were found for ([^ ]+)\./, "沒有找到 $1 的可恢復倉庫。"],
        [/by/, "由"], // 刪除的倉庫
        [/Are you sure you want to restore ([^ ]+)?/, "您確定要恢復 $1 嗎？"], // 刪除的倉庫
    ],
};

I18N["zh-TW"]["settings/codespaces"] = { // 設置 - 程式碼空間
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 程式碼空間 https://github.com/settings/codespaces
            "Dotfiles": "點文件",
            "Automatically install dotfiles": "自動安裝點文件",
            "Codespaces can automatically install your dotfiles into every codespace you create.": "程式碼空間可以自動將您點文件安裝到您創建的每個程式碼空間。",
            "Learn how to set up your dotfiles for Codespaces.": "瞭解如何為程式碼空間設置點文件。",
            "Select repository": "選擇倉庫",
            "Search for a repository": "搜索倉庫",
            "Changes saved": "更改已保存",

            "Secrets": "機密",
            "Codespace user secrets": "程式碼空間用戶機密",
            "New secret": "新建機密",
            "Development environment secrets are environment variables that are encrypted. They are available to any codespace you create using repositories with access to that secret.": "開發環境機密是加密的環境變量。它們可用於您可訪問該機密的倉庫創建的任何程式碼空間。",
            "There are no Codespace secrets.": "尚無程式碼空間機密",
            "Secrets created at the user level can be shared with specified repositories.": "在用戶級別創建的機密可以與指定的倉庫共享。",

            // [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
            "Updated": "更新於",
            // [/Are you sure you want to delete ([^ ]+)\?/, "您確定要刪除 $1 嗎？"],

            "GPG verification": "GPG 驗證",
                "Codespaces can have GPG commit signing capabilities so that GitHub can verify that commits made in the codespace come from a trusted source. When enabled, this setting will be applied to your list of trusted repositories.": "程式碼空間可以具有 GPG 提交簽名功能，以便 GitHub 可以驗證程式碼空間中的提交是來自受信任的來源。啟用後，該設置將被應用到您的受信任倉庫列表中。",
                // "Enabled": "啟用",
                    "GPG signing will be available in Codespaces": "GPG 簽名將在程式碼空間中可用",

            "Settings Sync": "設置同步",
                "By enabling, your codespaces will be able to pull from VS Code Settings Sync service and push only for the trusted repositories you specify. Only enable this for repositories that you trust.": "通過啟用，您的程式碼空間將能夠從 VS Code 設置同步服務中提取數據，並僅推送您指定的受信任倉庫。請只對您信任的倉庫啟用此功能。",
                // "Enabled": "啟用",
                    "VS Code Settings Sync will be available in Codespaces": "VS Code 設置同步將在程式碼空間中可用",

            // 通知
            "When enabled, you will receive emails when your codespaces are nearing deletion due to inactivity.": "啟用後，當您的程式碼空間因長時間未使用而即將被刪除時，您將收到電子郵件通知。",
            "Warning notifications for codespace deletions will be enabled": "程式碼空間刪除警告通知將啟用",

            "Trusted repositories": "受信任倉庫",
                "The following repositories will be referenced by GPG verification and Settings Sync.": "以下倉庫將被 GPG 驗證和設置同步所引用。",

                "All repositories": "所有倉庫",
                    "GPG signing and VS Code Settings Sync will be available for codespaces for all repositories": "GPG 簽名和 VS Code 設置同步將適用於所有倉庫的程式碼空間",
                "Selected repositories": "選定的倉庫",
                    "GPG signing and VS Code Settings Sync will be available for codespaces from the selected repositories": "GPG 簽名和 VS Code 設置同步將適用於選定倉庫的程式碼空間",
                    "Select repositories": "選擇倉庫",
                    // [/Selected (\d+) repositor(y|ies)./, "選定 #1 個倉庫"],
                    "GPG and VS Code Settings Sync will be available for Codespaces from these repositories.": "GPG 和 VS Code 設置同步將可用於這些倉庫的程式碼空間。",

                "Submit": "確定",

            "Access and security": "訪問和安全",
            "Deprecated": "棄用",
            "Codespaces you create for your personal account can either be restricted to accessing the repository it was opened for, or granted read access to other repositories you own.": "您為您個人賬戶創建的程式碼空間可以限制訪問已啟用的倉庫或您其他被賦予讀取權限的倉庫",
            "Disabled": "禁用",
            "Limit access of personal Codespaces to the repository they were opened for": "限制個人程式碼空間只能訪問對其打開的倉庫",
            "All Codespaces can access other repositories I own": "所有程式碼空間都可以訪問我擁有的其它倉庫",
            "Personal Codespaces created for specific repositories can access other repositories I own": "為特定倉庫創建的個人程式碼空間可以訪問我擁有的其它倉庫",

            "Editor preference": "編輯器偏好",
                // VS code
                    "Connect to the cloud from your local desktop client. Requires": "從本地桌面客戶端連接到雲。要求",
                    "with the": "安裝",
                    "GitHub Codespaces": "GitHub 程式碼空間",
                    "extension.": "插件。",

                "Visual Studio Code for the Web": "網絡版的 Visual Studio Code",
                    "Edit and preview changes straight from the browser.": "直接從瀏覽器編輯和預覽更改。",

                // "JetBrains Gateway": "",
                    "Connect to the cloud from your local desktop client. Requires the": "從本地桌面客戶端連接到雲。要求",
                    "plugin, and a JetBrains license.": "插件和 JetBrains 許可證。",

                // JupyterLab
                    "Edit and run notebooks from the browser with JupyterLab.": "使用 JupyterLab 從瀏覽器編輯和運行筆記本。",

            "Default idle timeout": "默認空閒超時",
                "A codespace will suspend after a period of inactivity. You can specify a default idle timeout value, which will apply to all codespaces created after the default is changed. You will be charged for the entire time your codespace is running, even if it is idle. The maximum value is": "一段時間不活動後，程式碼空間將暫停。您可以指定一個默認的空閒超時值，該值將應用於更改默認值後創建的所有程式碼空間。您將在程式碼空間運行的整個過程中付費，即使它是空閒的。最大值是",
                "minutes (4 hours).": "分鐘（4小時）。",
                "minutes": "分鐘",

            "Default retention period": "默認保留期",
                "Inactive codespaces are automatically deleted 30 days after the last time they were stopped. A shorter retention period can be set, and will apply to all codespaces created going forward. The default and maximum value is": "不活躍的程式碼空間在上次停止後 30 天自動刪除。可以設置更短的保留期，並將應用於以後創建的所有程式碼空間。默認值和最大值是",
                "days.": "天。",
                "Learn about retention setting": "瞭解關於保留時間的設置",
                "days": "天",

            "Host image version preference": "主機鏡像版本偏好",
                "The host image defines the operating system in which development containers run. These images receive periodic upgrades for security, functionality, and performance. GitHub Codespaces offers early access to beta images to ensure compatibility with existing development container configurations. Any codespace created or resumed after changing this setting will use the specified image configuration.": "主機鏡像定義了開發容器運行的操作系統。這些鏡像會定期進行安全、功能和性能升級。GitHub 程式碼空間提供對測試版鏡像的早期訪問，以確保與現有開發容器配置的兼容性。更改此設置後創建或恢復的程式碼空間都將使用指定的鏡像配置。",
                "Learn more about host images": "瞭解更多關於主機鏡像的信息",
                "Stable": "穩定版",
                    "Always use the latest stable configuration.": "始終使用最新的穩定版。",
                "Beta": "測試版",
                    "Use a beta image configuration when available. Otherwise, use the latest stable configuration.": "如果可用，請使用測試版映像配置。否則，請使用最新的穩定配置。",

            "Region": "地區",
                "Your default region will be used to designate compute resources to your codespaces. GitHub can set your region automatically based on your location, or you can set it yourself. Codespaces are deployed to a subset of Azure regions.": "您的默認區域將被用來為您的程式碼空間指定計算資源。 GitHub 可以根據您的位置自動設置您的區域，您也可以自己設置。程式碼空間部署到 Azure 區域的子集。",
                "Set automatically": "自動設置",
                "We will determine the closest available region based on your location (IP address) at codespace creation time.": "我們將在創建程式碼空間時根據您的位置（IP地址）確定最近的可用區域。",
                "Set manually": "手動設置",
                "Choose your default region": "選擇您的默認區域",
                    "United States": "美國",
                        "US West": "美國西部",
                        "US East": "美國東部",
                    "Europe": "歐洲",
                        "Europe West": "歐洲西部",
                    "Asia Pacific": "亞太地區",
                        "Southeast Asia": "東南亞",
                    "Australia": "澳大利亞",

            // 頂部提醒
                "Secret added.": "機密已添加。",
                "Secret deleted.": "機密已刪除。",
                "Secret updated.": "機密已更新。",

        // 程式碼空間 機密新建 https://github.com/settings/codespaces/secrets/new
            "/ New secret": "/ 新建機密",
            "Add secret": "添加機密",
                "Adding…": "添加中…",

            "Name": "名稱",
                "YOUR_SECRET_NAME": "您的機密名稱",
                "Secret name is required and must not start with GITHUB": "機密名稱是必需的，並且不能以 GITHUB 開頭",
            "Value": "值",

            "Repository access": "倉庫權限",
            "Available to": "適用於",
            "repository": "倉庫",
            "This secret will not be active until at least 1 repository is selected.": "至少選擇 1 個倉庫，否則此機密不會處於活動狀態。",

        // 編輯機密 https://github.com/settings/codespaces/secrets/<機密名稱>/edit
            "/ Update secret": "/ 更新機密",
            "Secret values are encrypted and cannot be displayed, but you can": "機密值已加密，無法顯示，但您可以",
            "enter a new value.": "輸入一個新值。",
            "Update secret": "更新機密",

    },
    "regexp": [ // 正則翻譯
        [/Selected (\d+) repositor(y|ies)./, "選定 $1 個倉庫"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/Are you sure you want to delete ([^ ]+)\?/, "您確定要刪除 $1 嗎？"],
        [/Remove ([^ ]+)/, "移除 $1"],
    ],
    "title": {
        "static": {
            "Codespaces": "程式碼空間",
        },
    },
};

I18N["zh-TW"]["settings/models"] = {
    "static": {
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置

        "Billing": "賬單",

        "Models paid usage": "使用付費模型",
            "If enabled, usage beyond the free tier will be billed per token based on model pricing from your Models budget.": "如果啟用，超出免費額度的使用將根據您模型預算中的模型定價按令牌計費。",
            "Models pricing": "模型價格",

            "To enable Models paid usage, a payment method is needed.": "要啟用付費模型，需要添加支付方式。",
                "Add payment method": "添加支付方式",

            "You currently have": "您當前有",
                "free rate limits": "免費額度",
                ". Enable paid usage to avoid interruption and add tokens.": "。啟用付費使用以避免中斷並添加令牌。",
    },
    "regexp": [],
    "title": {
        "static": {
            "Models": "模型",
        },
    },
};

I18N["zh-TW"]["settings/packages"] = { // 設置 - 軟體包
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置

        // Packages 軟體包 https://github.com/settings/packages
            "Packages permissions": "軟體包權限",

            // 組織設置
                "Package creation": "包的創建",
                "Members will be able to publish only the selected visibility types for packages and containers. Outside collaborators can never publish packages or containers.": "成員只能發佈選定可見性類型的軟體包和容器。外部協作者永遠不能發佈軟體包或容器。",
                "Public": "公共",
                    "Members will be able to create public packages, visible to anyone.": "成員將能夠創建公共包，對任何人都可見。",
                "Private": "私有",
                    "Members will be able to create private packages, visible to organization members with permission.": "成員將能夠創建私有包，對具有權限的組織成員可見。",
                "Internal": "內部",
                    "Members will be able to create internal packages, visible to all organization/enterprise members.": "成員將能夠創建內部包，對所有組織/企業成員可見。",

            "Default Package Setting": "默認軟體包設置",
            "Default package settings": "默認軟體包設置", // 組織
            "This setting will be applied to new Container, npm, rubygems and NuGet packages.": "此設置將應用於新的容器、npm、rubygems 和 NuGet 軟體包。",
            "Inherit access from source repository": "從源倉庫繼承訪問權限",
            "Save": "保存",

            "Deleted Packages": "刪除的軟體包",
            "Deleted packages": "刪除的軟體包", // 組織
            "These are packages that have been previously deleted belonging to you. You can restore a package deleted within the last 30 days.": "這些是先前已刪除的屬於您的軟體包。您可以恢復在過去 30 天內刪除的包。",
            "These are packages that have been previously deleted belonging to this organization. You can restore a package deleted within the last 30 days.": "這些是先前已刪除的屬於您組織的軟體包。您可以恢復在過去 30 天內刪除的包。", // 組織設置
            "Search deleted packages": "搜索已刪除的軟體包",

    },
    "regexp": [ // 正則翻譯
        [/No recoverable packages were found for ([^ ]+)./, "沒有找到 $1 的可恢復包。"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Packages": "軟體包",
        },
    },
};
I18N["zh-TW"]["orgs/settings/packages"] = I18N["zh-TW"]["settings/packages"];

I18N["zh-TW"]["settings/copilot"] = { // 設置 - GitHub Copilot
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // GitHub Copilot https://github.com/settings/copilot/features
            "Trained on billions of lines of code,": "經過數十億行程式碼的訓練，",
            "turns natural language prompts into coding suggestions across dozens of languages.": "將自然語言提示轉換為多種語言的編碼建議。",
            "Start free trial": "開始免費試用",
            "After that $10/month": "結束試用後 $10 / 月",
            "Get Copilot from an organization": "從組織中獲取 GitHub Copilot",
            "Organizations can provide their members (including you) and their teams access to GitHub Copilot.": "組織可以為其成員（包括您）及其團隊提供使用 GitHub Copilot 的權限。",
            "Organizations owned by enterprise accounts": "企業賬戶擁有的組織",
            "are not currently listed.": "目前未包含在此計劃中。",
            "You do not belong to any organizations.": "您不屬於任何組織。",
            "Create an organization": "創建一個組織",

            "Ask admin for access": "向管理員請求訪問權限",
            "Requesting...": "請求中…",
            "Remove request": "撤銷請求",
            "Cancelling...": "撤銷中…",
            "Buy Copilot Business": "購買 GitHub Copilot 企業版",
            "Owner": "所有者",
            "Member": "成員",

            "Getting started": "開始使用",
                "complete": "完成",
                "Remove section":"移除區域",
            "Install Copilot in your editor": "在您的編輯器中安裝 Copilot",
            "Ask about coding problems and get code completions while you work.": "在工作時詢問問題並獲得程式碼補全。",
            "Chat with Copilot anywhere": "隨時隨地與 Copilot 聊天",
            "Open": "在 GitHub 的任何位置打開導航欄中的",
            "Copilot chat in the navigation from anywhere on GitHub. Try asking": "按鈕，即可與 Copilot 聊天。嘗試詢問",
            "“what can I do with Copilot?”": "“我能用 Copilot 做什麼？”",
            "to get started.": "來開始聊天。",
            "Go to Copilot": "前往 Copilot",
            "Start building with Copilot": "使用 Copilot 開始構建專案",
            "Learn how to build with Copilot in Visual Studio Code or Visual Studio.": "學習如何在 Visual Studio Code 或 Visual Studio 中使用 Copilot 來構建專案",
            "Get started": "開始",

        // 免費版
            "You are using Copilot for free": "您正在使用 Copilot 免費版",
                "Responses are limited to 2,000 code completions and 50 chat messages per month.": "回覆上限為每月 2,000 次程式碼完成和 50 條聊天信息。",
                "Upgrade for higher limits, premium models, AI reviews. Free responses reset in 20 days.": "升級以獲得更高的限制、高級模型和 AI 評審。免費版的會話將在 20 天后重置。",
            "Get unlimited usage with Copilot Pro": "通過 Copilot Pro 無限制使用",
                "Unlimited messages and interactions": "信息和互動無限制",
                "Access to the latest models": "訪問最新模型",
                "Customize conversations to your private codebase and extensions": "為您的私人程式碼庫和擴展定製會話",
                "Start a free trial": "免費試用",
                "Code completions":"程式碼補全",
                "Chat messages":"聊天信息",

            "Copilot policies": "Copilot 規則",
                "Copilot Chat in GitHub.com": "在 GitHub.com 中使用 Copilot Chat",
                    "You can use Copilot Chat in GitHub.com. Copilot code review and preview features are only available for paid licenses.": "您可以在 GitHub.com 中使用 Copilot Chat。Copilot 程式碼審查和預覽功能僅適用於付費版。",
                    "You can use Copilot Chat in GitHub.com. Preview features are only available for paid licenses.": "您可以在 GitHub.com 中使用 Copilot Chat。預覽功能僅適用於付費版。",
                    "Learn more about Copilot in GitHub.com": "瞭解更多關於在 GitHub.com 中使用 Copilot 的信息",
                "Editor preview features": "編輯器預覽功能",
                    "You can use preview features in your editor.": "您可以在編輯器中使用預覽功能。",
                "Suggestions matching public code": "公共程式碼匹配的建議",
                    "Copilot can allow or block suggestions matching public code. Learn more about": "Copilot 可允許或阻止與公共程式碼匹配的建議。瞭解更多關於",
                    "code suggestions": "程式碼建議",
                    "Allowed": "允許",
                        "GitHub Copilot will show suggestions matching public code.": "GitHub Copilot 將顯示與公共程式碼匹配的建議。",
                    "Blocked": "阻止",
                        "GitHub Copilot won't show suggestions matching public code.": "GitHub Copilot 不會顯示與公共程式碼匹配的建議。",
                "Allow GitHub to use my data for product improvements": "允許 GitHub 將數據用於產品改進",
                //"Allow GitHub to use my code snippets from the code editor for product improvements": "允許 GitHub 將程式碼編輯器中的程式碼片段用於產品改進",
                    "Allow GitHub, its affiliates and third parties to use my data, including Prompts, Suggestions, and Code Snippets, for product improvements. More information in the": "允許GitHub、其關聯公司和第三方使用我的數據，包括提示、建議和程式碼片段，以改進產品。更多信息請查看",
                    //"Allow GitHub, its affiliates and third parties to use my code snippets to research and improve GitHub Copilot suggestions, related models and product features. More information in the": "允許 GitHub、其附屬機構和第三方使用我的程式碼片段來研究和改進 GitHub Copilot 建議、相關模型和產品功能。更多",
                    "About GitHub Copilot privacy.": "關於 GitHub Copilot 隱私的信息。",
                "Allow GitHub to use my data for AI model training": "允許 GitHub 將數據用於訓練 AI 模型",
                    "Allow GitHub, its affiliates and third parties to use my data, including Prompts, Suggestions, and Code Snippets, for AI model training. More information in the": "允許GitHub、其關聯公司和第三方使用我的數據，包括提示、建議和程式碼片段，以訓練 AI 模型。更多信息請查看",
                "Copilot can search the web": "網絡搜索",
                    "Copilot can answer questions about new trends and give improved answers, via Bing. See": "Copilot 可以回答有關新趨勢的問題並給出改進的答案，通過必應。請參閱",
                    "Microsoft Privacy Statement": "微軟隱私聲明",

                    "GitHub Copilot will answer questions about new trends and give improved answers": "GitHub Copilot 將回答有關新趨勢的問題並給出改進的答案",
                    "GitHub Copilot won't answer questions about new trends and give improved answers": "GitHub Copilot 將不會回答有關新趨勢的問題並給出改進的答案",
                    "Select an option": "選擇",
                        "You will have access to the feature": "您將能夠訪問此功能",
                        "You won’t have access to the feature": "您將不能訪問此功能",
                "Learn more about how GitHub Copilot serves OpenAI GPT-5-Codex and confirm compatibility with your IDE in our documentation.": "瞭解更多關於 GitHub Copilot 如何為 OpenAI GPT-5-Codex 提供服務，並確認與您的 IDE 的兼容性。",
                "Dashboard entry point": "儀表板入口",
                    "Allows instant chatting when landing on GitHub.com": "允許登錄 GitHub.com 時即時聊天",
                "Copilot code review": "Copilot 程式碼審查",
                    "Use Copilot to": "使用 Copilot",
                    "review your code": "審查程式碼",
                    "and generate": "並生成",
                    "pull request summaries": "拉取請求總結",

                    "Automatically request Copilot code review": "自帶請求 Copilot 程式碼審查",
                        "Use Copilot to automatically review all the pull requests you've created.": "使用 Copilot 自動審查您創建的拉取請求。",

            "For more information about the data your organization receives regarding your use of GitHub Copilot, please review": "如需瞭解貴機構在使用 GitHub Copilot 時會收到哪些數據，請查看",
                "GitHub's Privacy Statement": "GitHub 的《隱私聲明》",
            "It can take up to 30 minutes for the changes to take effect. Restart your code editor for the changes to take effect immediately.": "更改可能需要 30 分鐘才能生效。重新啟動程式碼編輯器，更改會立即生效。",

            "Visibility": "可見度",
                "Show Copilot": "顯示 Copilot",
                "Enable Copilot for all GitHub features, including navigation bar, search, and dashboard.": "為所有 GitHub 功能啟用 Copilot，包括導航欄、搜索和儀表板。",
                "When disabled, Copilot will be hidden and unavailable. This setting does not apply to Copilot search on GitHub Docs.": "禁用後，Copilot 將隱藏且不可用。此設置不適用於 GitHub Docs 中的 Copilot 搜索。",

        // 專業版
            // 頂部提醒
                "It appears you are not eligible to sign up to GitHub Copilot for free": "您似乎沒有資格免費註冊 GitHub Copilot",
            "Your GitHub Copilot setup is incomplete. Select your preferences below to start using GitHub Copilot.": "您的 GitHub Copilot 設置不完整。請在下面選擇您的偏好，開始使用 GitHub Copilot。",

            "GitHub Copilot Pro is active for your account": "您的 GitHub Copilot Pro 帳戶已激活",
                "You currently have an active": "您當前擁有有效的",
                "Copilot Pro subscription": "GitHub Copilot Pro 訂閱",
                "Get started by installing the extension in your preferred IDE.": "首先在您首選的 IDE 中安裝擴展。",
                "Get started by installing the extension in your preferred environment.": "首先在您首選環境中安裝擴展。",
                "Copilot in your IDE": "集成在 IDE",
                "Copilot in the CLI": "在終端中使用",
                "Chat in GitHub Mobile": "在 GitHub Mobile 中使用",
                "More features": "更多功能",

            "Premium requests": "高級請求",
                "Please note that there may be a delay in the displayed usage percentage. The premium request entitlement for your plan will reset at the start of next month. You can enable additional premium requests in the": "請注意，顯示的使用百分比可能會有延遲。您計劃的高級請求權限將在下個月初重置。您可以在以下位置啟用額外的高級請求：",
                "Billing settings": "賬單設置",
                "Please note that there may be a delay in the displayed usage percentage. The premium request entitlement for your plan will reset at the start of next month. To enable additional premium requests,": "請注意，顯示的使用百分比可能會有延遲。您計劃的高級請求權限將在下個月初重置。要啟用額外的高級請求，請",
                "update your Copilot premium request budget": "更新您的 Copilot 高級請求預算",

            "Features": "功能",
                // "Copilot in github.com": "在 github.com 中使用 Copilot",
                    //"You can use Copilot Chat in Github.com, Copilot for pull requests, and all of the preview features.": "您可以在 Github.com 中使用 Copilot Chat，也可以使用 Copilot 拉取請求和所有預覽功能。",
                    "You can use Copilot Chat in GitHub.com, Copilot for pull requests, and all of the preview features.": "您可以在 GitHub.com 中使用 Copilot Chat，Copilot 拉取請求和所有預覽功能。",
                    "You can use Copilot Chat in GitHub.com and Copilot for pull requests. Copilot code review and preview features are only available for paid licenses.": "您可以在 GitHub.com 上使用 Copilot Chat，也可以在拉取請求中使用 Copilot。Copilot 的程式碼審查和預覽功能僅對付費許可證用戶開放。",

                // "Copilot in the CLI": "在終端中使用",
                    "You can use": "您可以",
                    "GitHub Copilot for assistance in terminal": "GitHub Copilot 終端輔助工具",
                "Copilot Chat in the IDE": "在 IDE 中使用 Copilot Chat",
                    "GitHub Copilot Chat in the IDE": "在 IDE 中使用 Copilot Chat",
                    "to explain a piece of code, propose bug fixes, or generate unit tests in a chat interface from your editor.": "在編輯器的聊天界面上解釋程式碼、提出錯誤修復建議或生成單元測試。",
                "Copilot Chat in GitHub Mobile": "在 GitHub Mobile 中使用 Copilot Chat",
                    "personalized to a codebase.": "，個性化程式碼。",
                "Copilot in GitHub Desktop": "在 GitHub Desktop 中使用",
                    "GitHub Copilot for assistance in GitHub Desktop": "在 GitHub Desktop 中獲得 Copilot 的協助",
                "Automatic Copilot code review": "自動 Copilot 程式碼審查",
                    "Copilot will automatically review your pull requests.": "Copilot 將自動審查您的拉取請求。",
                    "Learn more about configuring automatic code reviews.": "瞭解如何配置自動程式碼審查。",
                "Copilot coding agent": "Copilot 編程智能體",
                    "With Copilot coding agent, you can delegate tasks to Copilot, freeing you to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request your review, then leave feedback on the pull request to iterate.": "使用 Copilot 編程智能體，您可以將任務委託給 Copilot，從而讓您專注於最具創造性的、複雜且影響深遠的工作。只需將問題分配給 Copilot，等待智能體請求您審查，然後在拉取請求中留下反饋以進行迭代。",
                    "Delegate tasks to Copilot coding agent in repositories where it is enabled": "將任務委託給已啟用 Copilot 編程智能體的倉庫",
                "MCP servers in Copilot": "Copilot 中的 MCP 服務器",
                    "Connect MCP servers to Copilot in all Copilot editors and Coding Agent.": "在所有 Copilot 編輯器和編程智能體中連接 MCP 服務器。",
                // Grok
                    "If enabled, you can access and send data to xAI Grok Code Fast 1.": "若啟用，您可以訪問 xAI Grok Code Fast 1 並發送數據。",
                "Copilot-generated commit messages" : "Copilot 生成的提交消息",
                    "Allow Copilot to suggest commit messages when you make changes on GitHub.com.": "允許 Copilot 在您於 GitHub.com 上進行更改時提供提交消息建議。",
                    "Learn more about Copilot-generated commit messages.": "瞭解更多關於 Copilot 生成的提交消息。",
                "Copilot Spaces": "Copilot 空間",
                    "If enabled, you can view and create": "若啟用，您可以查看和創建",
                    "Copilot Spaces": "Copilot 空間",
                    ". When disabled, you cannot view or create any Copilot Spaces.": "。當禁用時，您無法查看或創建任何 Copilot 空間。",
                "Choose which repositories Copilot coding agent should be enabled in. Copilot coding agent will only be available where it is enabled for the repository and in the Copilot license policies.": "選擇要在其中啟用 Copilot 編程智能體的倉庫。Copilot 編程智能體僅在為該倉庫啟用並符合 Copilot 許可證政策的情況下可用。",
                "Copilot Spaces Individual Access":"Copilot Spaces 個人訪問權限",
                    "If enabled, you can create individually owned":"若啟用，您可以創建個人擁有的",
                    "Copilot Spaces": "Copilot 空間",
                    ". When disabled, you cannot create individual spaces.":"。當禁用時，您無法創建個人空間。",
                "Copilot Spaces Individual Sharing":"Copilot Spaces 個人分享",
                    "If enabled, you can share individually owned": "若啟用，您可以分享個人擁有的",
                    "Copilot Spaces": "Copilot 空間",
                    ". When disabled, you cannot share individual spaces.":"。當禁用時，您無法分享個人空間。",



        // 編程智能體(預覽 https://github.com/settings/copilot/coding_agent
            // 頂部提示
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro+ or Copilot Enterprise license.": "您可以為其他用戶啟用 Copilot 編程智能體，但由於您沒有 Copilot Pro+ 或 Copilot 企業版許可證，因此無法向 Copilot 分配任務。",
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because the Copilot coding agent policy has been disabled by an administrator.":  "您可以為其他用戶啟用 Copilot 編程智能體，但由於管理員已禁用 Copilot 編程智能體策略，您將無法向 Copilot 分配任務。",
                "You can enable Copilot coding agent for other users, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro, Copilot Pro+, Copilot Business or Copilot Enterprise license.": "雖然您可以為其他用戶啟用 Copilot 編碼代理，但由於您未持有 Copilot Pro、Copilot Pro+、Copilot Business、Copilot Enterprise 許可證，因此無法向 Copilot 分配任務。",

            "With Coding agent, you can delegate tasks to Copilot, freeing you to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request your review, then leave feedback on the pull request to iterate.": "使用編程智能體，您可以將任務委派給 Copilot，從而讓您專注於最具創造性的、複雜且影響深遠的工作。只需將問題分配給 Copilot，等待智能體請求您審查，然後在拉取請求中留下反饋以進行迭代。",
                "Learn more in the docs.": "詳情",

            "Repository access": "倉庫訪問",
                "Choose which repositories Coding agent should be enabled in. Coding agent will only be available where it is enabled for the repository and in the Copilot license policies.": "選擇要啟用編程智能體的倉庫。編程智能體僅在為該倉庫啟用並符合 Copilot 許可證政策的情況下可用。",

                "No repositories": "無倉庫",
                // 所有
                    "Include all current and future repositories": "包括所有當前和未來的倉庫",
                "Only selected repositories": "手動選擇",
                    "Applies only to specifically selected repositories": "僅適用於您選擇的倉庫",

                    "Search or filter": "搜索或篩選",
                        "Mirror": "鏡像",
                        "Custom properties": "自定義屬性",
                        "Language": "語言",
                        "License": "許可證",
                        "Exclude": "排除",

                    "Select all": "全選",

                    "of": "/",
                    "items shown.": "倉庫顯示。",
                    "Use the search to find specific items": "搜索查找特定倉庫",

                    "Select": "選擇",

            "Use of Copilot coding agent is subject to the": "使用 Copilot 編程智能體需遵守",
                "pre-release terms": "預發行條款",

    },
    "regexp": [ // 正則翻譯
        [/Outside collaborator on (\d+) repositor(y|ies)/, "$1 個倉庫的外部協作者"],
        [/Member and collaborator on (\d+) repositor(y|ies)/, "$1 個倉庫的成員和協作者"],
        [/Upgrade for higher limits, premium models, AI reviews. Free responses reset in (\d+) days.?/, "升級以獲取更高的限制、高級模型和 AI 審核。免費額度將在 $1 天內重置。"], // 免費版額度
        [/You can use the latest (.+) model\./, "您可以使用最新的 $1 模型。"],
        [/Learn more about how GitHub Copilot serves (.+)\./, "瞭解更多關於 GitHub Copilot 如何為 $1 提供服務。"],
    ],
    "title": {
        "static": {
            "Copilot coding agent": "Copilot 編程智能體",
        },
    },
};

I18N["zh-TW"]["settings/pages"] = { // 設置 - GitHub Pages
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置菜單

        // GitHub Pages https://github.com/settings/pages
            "Verified domains": "經驗證的域名",
            "Add a domain": "添加域名",
            "There are no verified domains.": "暫無經驗證的域名",
            "There are no verified domains for this organization.": "此組織暫無經驗證的域名", // 組織設置
            "Verify domains to restrict who can publish GitHub Pages on them.": "驗證域名以限制誰可以在上面發佈 GitHub Pages。",
            "One of your domains is unverified. Please verify it to prevent others from claiming it for their Pages sites.": "您添加的域名之一未經驗證，請對其進行驗證，以防止其他人在其主頁網站上聲明該信息。",
            "Please verify your domain": "請驗證您的域名",
            "Continue verifying": "繼續驗證",
            "Review verification steps": "查看驗證步驟",

            // 域名刪除對話框
            "Delete verified domain": "刪除已驗證的域名",
            "This is a destructive action. Your GitHub Pages sites may lose their custom domains.": "這是一個破壞性的操作，您的 GitHub Pages 網站可能會失去自定義域名。",
            "Your GitHub Pages sites may be unpublished from their custom domains if another organization claims ownership of this domain.": "如果其他組織聲稱擁有此域名的所有權，您的 GitHub Pages 網站可能會被從此自定義域名中取消發佈。",
            "Please type": "請輸入",
            "to confirm.": "進行確認",
            "I understand, delete verified domain": "我明白了，依然刪除已驗證的域名",

        // GitHub Pages - 添加域名 https://github.com/settings/pages_verified_domains/new
            "Add a verified domain": "經驗證的域名",
            "What domain would you like to add?": "您想添加什麼域名？",
            "Add domain": "添加域名",
            "Domain name has already been added": "域名已添加",
            "Add a DNS TXT record": "添加 DNS TXT 記錄",
            "Before we can verify": "在我們驗證",
            ", you'll need to complete these steps:": " 之前，您需要完成以下步驟：",
            "Create a TXT record in your DNS configuration for the following hostname:": "在 DNS 配置中為以下主機創建 TXT 記錄：",
            "Use this code for the value of the TXT record:": "使用以下程式碼作為 TXT 記錄的值：",
            "Wait until your DNS configuration changes. This could take up to 24 hours to propagate.": "等待您的 DNS 變更解析生效，最長可能需要 24 小時。",
            "Verify": "驗證",
            "Copy verification steps": "複製驗證步驟",
            "Your domain is verified. No further action is needed.": "您的域名已驗證，無需其它操作。",
    },
    "regexp": [ // 正則翻譯
        [/Successfully verified/, "已成功驗證"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
};
I18N["zh-TW"]["orgs/settings/pages"] = I18N["zh-TW"]["settings/pages"];

I18N["zh-TW"]["settings/replies"] = { // 設置 - 快捷回覆
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Saved replies 快捷回覆 https://github.com/settings/replies
            "Saved replies are re-usable text snippets that you can use throughout GitHub comment fields. Saved replies can save you time if you’re often typing similar responses.": "快捷回覆是可重複使用的文本片段，您可以在整個 GitHub 評論區使用。如果您經常輸入類似的回覆，快捷回覆可以節省您的時間。",
            "Learn more about working with saved replies": "瞭解更多關於使用快捷回覆的信息",
            "No saved replies yet.": "暫時沒有快捷回覆。",
            "Add a saved reply": "添加快捷回覆",
            "Saved reply title": "快捷回覆的標題",
            "Add a short title to your reply": "為您的快捷回覆添加簡短的標題",
            "Add your saved reply": "添加您的快捷回覆",
            "Add saved reply": "添加快捷回覆",
            "Your saved reply was created successfully.": "您的快捷回覆已成功創建。",
            "Edit saved reply": "編輯快捷回覆",
            "Update saved reply": "更新快捷回覆",
            "Your saved reply was updated successfully.": "您的快捷回覆已成功更新。",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Saved replies": "快捷回覆",
        },
    },
};

I18N["zh-TW"]["settings/security_analysis"] = { // 設置 - 程式碼安全性與分析
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 程式碼安全性與分析 https://github.com/settings/security_analysis
            "Security and analysis features help keep your repositories secure and updated. By enabling these features, you're granting us permission to perform read-only analysis on your repositories.": "安全和分析功能有助於確保您的倉庫安全和更新。通過啟用這些功能，您授予我們對您的倉庫執行只讀分析的權限。",

            "User": "用戶",
                "Security and analysis features help keep you secure and updated, wherever you are.": "無論您身在何處，安全和分析功能都可以幫助您保持安全並及時更新。",

                "Keep your public pushes safe with push protection": "通過推送保護確保您的公共推送安全",
                "GitHub will enable push protection for all GitHub Free individuals in January 2024. Enable below to try it now in beta.": "GitHub 將於 2024 年 1 月為所有 GitHub 免費用戶啟用推送保護。在下面啟用以立即在測試版中嘗試。",
                    "Dismiss": "忽略",

                "Push protection for yourself": "啟用推送保護",
                    "Block commits that contain": "阻止提交，包含",
                    "supported secrets": "受支持的機密",
                    "across all public repositories on GitHub.": "涵蓋 GitHub 上的所有公共倉庫。",

                    // 對話框
                        "Enable push protection for yourself": "為自己啟用推送保護",
                            "Pushes that contain secrets will be blocked on public repositories. You'll have the option to bypass the block.": "包含機密的推送將在公共倉庫中被阻止。您可以選擇繞過該阻止。",
                            "Enable push protection": "啟用推送保護",

                        "Disable push protection for yourself": "為自己禁用推送保護",
                            "Pushes that contain secrets will not be blocked.": "包含機密的推送將不會被阻止。",
                            "Disable push protection": "禁用推送保護",

                        // 頂部提醒
                            // [/Security settings updated for ([^ ]+)\'s repositories./, "更新了 $1 的倉庫的安全設置。"],

            // 倉庫
                 "Security and analysis features help keep your repositories secure and updated.": "安全和分析功能有助於確保您的程式碼倉庫安全且保持更新。",

            "Disable all": "禁用全部",
            "Enable all": "啟用全部",

            "Private vulnerability reporting": "私下漏洞報告",
                "Allow your community to privately report potential security vulnerabilities to maintainers and repository owners.": "允許您的社區向維護者和倉庫所有者私下報告潛在的安全漏洞。",
                "Learn more about private vulnerability reporting": "瞭解更多關於私下漏洞報告的信息",
                "Automatically enable for new public repositories": "為新公共倉庫自動啟用",

                // 對話框
                    "Disable private vulnerability reporting": "禁用私下漏洞報告",
                        // [/You're about to disable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即將在 $1 的所有公共倉庫中禁用私下漏洞報告。"],
                        "Enable by default for new public repositories": "默認啟用新公共倉庫",

                    "Enable private vulnerability reporting": "啟用私下漏洞報告",
                        // [/You're about to enable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即將在 $1 的所有公共倉庫中啟用私下漏洞報告。"],

            "Dependency graph": "依賴項關係圖",
                "Understand your dependencies.": "瞭解您的依賴項。",
                "Automatically enable for new private repositories": "為新私有倉庫自動啟用",

                // 對話框
                    "Enable dependency graph": "啟用依賴項關係圖",
                        "You're about to enable dependency graph on all your private repositories.": "您即將啟用您所有私有倉庫上的依賴項關係圖。",
                        "Enable by default for new private repositories": "默認為新私有倉庫啟用",

                    "Disable dependency graph": "禁用依賴項關係圖",
                        "You're about to disable dependency graph on all your private repositories. This will also disable Dependabot alerts and Dependabot security updates on those repositories.": "您即將禁用您所有私有倉庫上的依賴項關係圖。這也將禁用這些倉庫的 Dependabot 警報和 Dependabot 安全更新。",

            // Dependabot
                "Keep your dependencies secure and up-to-date.": "保持您的依賴項的安全和最新",
                "Learn more about Dependabot": "瞭解更多關於 Dependabot 的信息",

                "Dependabot alerts": "Dependabot 警報",
                    "Receive alerts for vulnerabilities that affect your dependencies and manually generate Dependabot pull requests to resolve these vulnerabilities.": "接收影響您的依賴項的漏洞警報，並手動生成 Dependabot 拉取請求以解決這些漏洞。",
                        "Configure alert notifications": "配置警報通知",
                    "Automatically enable for new repositories": "為新倉庫自動啟用",

                    // 對話框
                        "Enable Dependabot alerts": "啟用 Dependabot 警報",
                            "You're about to enable Dependabot alerts on all your repositories. Alerts require the dependency graph, so we'll also turn that on for all repositories. No notifications will be sent while Dependabot alerts are being enabled.": "您即將啟用您所有倉庫上的 Dependabot 警報。Dependabot 警報需要依賴項關係圖，因此我們還將為所有倉庫開啟它。啟用 Dependabot 警報時不會發送任何通知。",
                                "Enable by default for new repositories": "默認為新倉庫啟用",

                        "Disable Dependabot alerts": "禁用 Dependabot 警報",
                            "You're about to disable Dependabot alerts on all your repositories. This will also disable Dependabot security updates on those repositories.": "您即將禁用您所有倉庫上的 Dependabot 警報。這也將禁用這些倉庫的 Dependabot 安全更新。",

                "Dependabot security updates": "Dependabot 安全更新",
                    "Enabling this option will result in Dependabot automatically attempting to open pull requests to resolve every open Dependabot alert with an available patch.": "啟用後，Dependabot 會自動嘗試打開拉取請求，以使用可用補丁解決每個打開的 Dependabot 警報。",
                        "Dependabot rules": "Dependabot 規則",

                    // 對話框
                        "Enable Dependabot security updates": "啟用 Dependabot 安全更新",
                            "You're about to enable Dependabot security updates on all your repositories. Dependabot security updates require the dependency graph and Dependabot alerts, so we'll also turn that on for all repositories.": "您即將啟用您所有倉庫上的 Dependabot 安全更新。Dependabot 安全更新需要依賴項關係圖和 Dependabot 警報，因此我們也將為所有倉庫啟用他們。",

                        "Disable Dependabot security updates": "禁用 Dependabot 安全更新",
                            "You're about to disable Dependabot security updates on all your repositories.": "您即將禁用您所有倉庫上的 Dependabot 安全更新。",

                "Grouped security updates": "分組安全更新",
                    "Groups all available updates that resolve a Dependabot alert into one pull request (per package manager and directory of requirement manifests). This option may be overridden by group rules specified in dependabot.yml -": "將解決可靠警報的所有可用更新分組為一個拉取請求（每個包管理器和需求清單目錄）。此選項可能會被 dependentabot.yml 中指定的分組規則覆蓋 -",
                    "Learn how to group updates.": "瞭解如何配置分組更新",

                    // 對話框
                        "Enable grouped security updates": "啟用分組安全更新",
                            "You're about to enable grouped security updates on all your repositories. Grouped security updates require the dependency graph, Dependabot alerts and Dependabot security updates, so we'll also turn that on for all repositories.": "您即將啟用您所有倉庫上的分組安全更新。分組安全更新需要依賴項關係圖、Dependabot 警報和 Dependabot 安全更新，因此我們也將為所有倉庫啟用他們。",

                        "Disable grouped security updates": "禁用分組安全更新",
                            "You're about to disable grouped security updates on all your repositories.": "您即將禁用您所有倉庫上的分組安全更新。",

                "Dependabot on Actions runners": "Dependabot 應用於操作運行器",
                    "Run Dependabot security and version updates on Actions runners.": "在操作運行器上運行 Dependabot 安全和版本更新。",

                    // 對話框
                        "Enable dependabot on actions": "在操作中啟用 Dependabot",
                            "You're about to enable dependabot on actions on all your repositories. Dependabot on actions requires Actions so we'll also turn that on for all repositories.": "您將要在所有倉庫操作中啟用 dependabot 。操作中的 Dependabot需要操作，因此我們還將為所有倉庫啟用它。",

                        "Disable dependabot on actions": "在操作中禁用 Dependabot",
                            "You're about to disable dependabot on actions on all your repositories.": "您將要在所有倉庫操作中禁用 Dependabot。",

                "Dependabot on self-hosted runners": "Dependabot 應用於自託管運行器",
                    "Run Dependabot security and version updates on self-hosted Actions runners.": "在自託管運行程式上運行 Dependabot 安全和版本更新。",

                    // 對話框
                        "Enable dependabot self-hosted": "在自託管運行器上啟用 Dependabot",
                            "You're about to enable dependabot self-hosted on all your repositories. Dependabot self-hosted depends on Dependabot on Actions so we'll also turn that on for all repositories.": "您將在所有倉庫上啟用 dependabot 自託管。Dependabot 自託管依賴於操作中的 Dependabot，因此我們還將為所有倉庫啟用它。",

                        "Disable dependabot self-hosted": "在自託管運行器上禁用 Dependabot",
                            "You're about to disable dependabot self-hosted on all your repositories.": "您將在所有倉庫上禁用 dependabot 自託管。",

            "Secret scanning": "機密掃描",
                "Receive alerts on GitHub for detected secrets, keys, or other tokens.": "在 GitHub 上接收有關檢測到的機密、密鑰或其他令牌的警報。",
                "GitHub will always send alerts to partners for detected secrets in public repositories.": "GitHub 會隨時向合作伙伴發送公共倉庫中檢測到的機密警報。",
                "Learn more about partner patterns": "瞭解更多關於合作伙伴模式的信息",

                // 對話框
                    "Enable secret scanning for eligible repositories?": "啟用符合條件的倉庫的機密掃描？",
                        "This will turn on secret scanning for all public repositories.": "這將為所有公共倉庫啟用機密掃描。",
                        "Enable for eligible repositories": "啟用符合條件的倉庫",

                    "Disable secret scanning?": "禁用機密掃描？",
                        "This will disable secret scanning on all repositories where it is enabled.": "這將禁用所有倉庫的機密掃描。",
                        "Disable secret scanning": "禁用機密掃描",

                "Push protection": "推送保護",
                    // "Block commits that contain": "阻止提交，包含",
                    // "supported secrets": "受支持的機密",
                    "Automatically enable for repositories added to secret scanning": "自動啟用對添加到機密掃描的倉庫進行掃描",

                    // 對話框
                        "Enable push protection for eligible repositories?": "啟用符合條件的倉庫的推送保護？",
                            "This will turn on push protection for all repositories that have secret scanning enabled.": "這將為所有已啟用秘密掃描的倉庫啟用推送保護。",

                        "Disable push protection?": "禁用推送保護？",
                            "This will disable push protection on all repositories where it is enabled.": "這將禁用所有倉庫的推送保護。",
                            "You can still enable push protection at the repository level.": "您仍然可以在倉庫級別啟用推送保護。",

    },
    "regexp": [ // 正則翻譯
        [/You're about to disable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即將在 $1 的所有公共倉庫中禁用私下漏洞報告。"],
        [/You're about to enable private vulnerability reporting on all public repositories in ([^ ]+)./, "您即將在 $1 的所有公共倉庫中啟用私下漏洞報告。"],
        [/Security settings updated for ([^ ]+)\'s repositories./, "更新了$1 的倉庫的安全設置。"],
    ],
    "title": {
        "static": {
            "Security & analysis": "安全與分析",
        },
    },
};

I18N["zh-TW"]["settings/installations"] = { // 設置 - 應用/安裝的 GitHub 應用
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"],

        "Installed GitHub Apps": "安裝的 GitHub 應用",
        "Authorized GitHub Apps": "授權的 GitHub 應用",
        "Authorized OAuth Apps": "授權的 OAuth 應用",

        // 安裝的 GitHub 應用 https://github.com/settings/installations
            // 頂部提醒
                // [/You're all set! (.*) has been uninstalled./, "一切就緒！$1 已被卸載。"],
                // [/You're all set! A job has been queued to uninstall the \'(.*)\' app./, "一切就緒！卸載 “$1” 應用的任務已排隊等候。"],
                // [/Okay, (.*) was installed on the (@[^ ]+) account./, "好的，$1 已安裝在 $2 賬戶上。"],
                // [/Okay, (.*) was updated for the (@[^ ]+) account./, "好的，$1 賬戶的 $1 已更新。"],

            // "Installed GitHub Apps": "安裝的 GitHub 應用",
                "GitHub Apps augment and extend your workflows on GitHub with commercial, open source, and homegrown tools.": "GitHub 應用通過商業、開源和自主開發的工具來增強和擴展您在 GitHub 上的工作流程。",
                "Permission updates requested.": "待處理的 GitHub 權限請求",

            "Pending GitHub Apps installation requests": "待處理的 GitHub 應用安裝請求", // 組織設置
                "Members in your organization can request that GitHub Apps be installed. Pending requests are listed below.": "您組織中的成員可以請求安裝 GitHub 應用。下面列出了待處理的請求。",

            "No installed GitHub Apps": "沒有已安裝的 GitHub 應用",
            "You have no GitHub Apps installed on this account.": "此賬戶上沒有安裝任何 GitHub 應用。",
            "Configure": "配置",
            "Suspended": "已暫停",
            "Visit Marketplace": "訪問市場",
            "My GitHub Apps": "我的 GitHub 應用",

        // 安裝的 GitHub 應用設置 https://github.com/settings/installations/<id>
            // 頂部提醒
                // [/Your installation was suspended by you on/, "您的安裝已暫停於"],
                "Your app has been unsuspended": "您的應用已被取消暫停",

            "Installed": "安裝於",
            "Developed by": "開發者",
            "App settings": "應用設置",
            "Permissions": "權限",
                // [/is requesting an update to its permissions./, "正在請求更新其權限。"],
                "Read": "讀取",
                "write": "寫入",
                "access to metadata": "元數據的權限",
                "Review request": "審核請求",
                "Access public information (read-only)": "訪問公開信息（只讀）",
                "Access user email addresses (read-only)": "訪問用戶電子郵件地址（只讀）",
                "Read all user profile data": "讀取所有用戶個人資料數據",
                "Create gists": "創建程式碼片段",
                "Full control of private repositories": "完全控制私有倉庫",
                "Update github action workflows": "更新 GitHub Action 工作流",
                "Update all user data": "更新所有用戶數據",
                "Full control of codespaces": "完全控制 Codespaces",
                "Read all user profile data": "讀取所有用戶個人資料數據",

            "Repository access": "倉庫訪問權限",
            "All repositories": "所有倉庫",
                "This applies to all current and future repositories owned by the resource owner. Also includes public repositories (read-only).": "這適用於資源所有者擁有的所有當前和未來的倉庫。還包括公共倉庫（只讀）。",
            "Only select repositories": "僅選定的倉庫",
                "Select at least one repository. Also includes public repositories (read-only).": "至少選擇一個倉庫。還包括公共倉庫（只讀）。",
                // [/Selected (\d+) repositor(y|ies)./, "選擇了 $1 個倉庫。"],
            "Select repositories": "選擇倉庫",
            "Search for a repository": "搜索倉庫",

            "Danger zone": "危險區",
            "Suspend your installation": "暫停使用",
            "This will block the app access to your resources.": "這將阻止應用訪問您的資源。",
            "Suspend": "暫停",
                // 取消按鈕 提醒信息
                "Are you sure you want to suspend this GitHub App?": "您確定要暫停此 GitHub 應用嗎？",
            "This will remove the app and revoke access to all resources.": "這將刪除應用並撤銷對所有資源的訪問權限。",
            // [/Uninstall "(.*)"/, "卸載 “$1”"],
            "Uninstall": "卸載",
                // 取消按鈕 提醒信息
                // [/This action cannot be undone. Are you sure you want to uninstall this GitHub App from (\d+) repositor(y|ies)?/, "此操作無法撤消。您確定要從 1 個倉庫中卸載此 GitHub 應用嗎？"],
            "Unsuspend your installation": "取消暫停",
                "This grant the app access to your resources.": "這將授予應用訪問您的資源。",
                "Unsuspend": "取消暫停",

            "Report abuse": "舉報濫用",
            "Revoke": "撤銷",
            "Read more about connecting with third-party applications at": "瞭解更多關於與第三方應用連接的信息，請訪問",
            "GitHub Help": "GitHub 幫助",

        // 安裝的 GitHub 應用授權更新 https://github.com/settings/installations/<id>/permissions/update
            // [/The (.*) app by/, "$1 應用（由"],
            "is requesting updated permissions": "創建）正在請求更新權限",

            "Read and write": "讀寫權限",
            "Read-only": "只讀權限",
            "Admin": "管理員權限",
            "access to": "針對",
            "New request": "新請求",
            "Show unchanged permissions": "顯示未更改的權限",
            "Hide unchanged permissions": "隱藏未更改的權限",
            "Accept new permissions": "接受新權限",
            // [/The (.*) app will retain its current permissions if you choose not to accept the new permissions./, "如果您選擇不接受新權限，“$1” 應用將保留其當前權限。"],

        // 授權的 GitHub 應用 https://github.com/settings/apps/authorizations
            // "Authorized GitHub Apps": "授權的 GitHub 應用",
            "No authorized applications": "無授權申請",
            "You have no applications authorized to access your account.": "您沒有授權訪問您的賬戶的應用。",

        // 授權的 OAuth 應用 https://github.com/settings/applications
            // "Authorized OAuth Apps": "授權的 OAuth 應用",
            "You have granted": "您已經授權",
            "access to your account.": "訪問您的賬戶。",
            "Revoke all": "撤銷全部",
            "Sort": "排序",
            "Sort by": "排序方式",
            "Alphabetical": "按字母排列",
            "Recently used": "最近使用的",
            "Least recently used": "最近使用最少的",

            "Never used · Owned by": "從未使用 · 作者",
            "Last used within the last week · Owned by": "最後一次使用是最近 1 周之內 · 作者",

            "Report abuse": "舉報濫用",
            "Revoke": "撤銷",

            // 撤銷對話框
            "Are you sure you want to revoke authorization?": "您確定要撤銷授權嗎？",
            "I understand, revoke access": "我明白了，依然撤銷訪問",

            // 全部撤銷對話框
            "Are you sure you want to revoke access for all applications?": "您確定要撤銷對所有應用的訪問權限嗎？",
            "This will revoke access for": "這將撤銷訪問",
            "all third-party": "所有第三方",
            "OAuth applications. This action cannot be undone.": "OAuth 應用。此操作無法撤消。",
            "Any SSH keys created on your behalf by applications will also be deleted.": "任何由應用代表您創建的 SSH 密鑰也將被刪除。",
            "Type your username to confirm.": "輸入您的用戶名進行確認。",
            "I understand, revoke access for everything": "我明白了，依然撤銷對一切的訪問",

            // 舉報濫用對話框
            "Report Abuse": "舉報濫用",
            "More options": "更多選項",
            "Revoking will deny future access to your account": "撤銷授權，將拒絕今後訪問您的賬戶",

        // 授權的 GitHub 應用授權設置 https://github.com/settings/connections/applications/<client-id>
        // 授權的 OAuth 應用授權設置 https://github.com/settings/connections/applications/<id>
            "Never used": "從未使用",
            "Last used within the last week": "最後一次使用是最近一週之內",

            "Developed by": "開發者:",
            "Permissions": "權限",
            "Revoke access": "撤銷授權",
                "Are you sure you want to revoke authorization?": "您確定要撤銷授權嗎？",
                    // [/(.+) will no longer be able to access the GitHub API. You cannot undo this action./, "$1 將無法再訪問 GitHub API。您無法撤銷此操作。"],
                "I understand, revoke access": "我明白了，依然撤銷授權",
                    "Revoking…": "撤消中…",

            "Applications act on your behalf to access your data based on the permissions you grant them. Organizations control which applications are allowed to access their private data. Applications you authorize will always have access to public data in your organizations.": "應用根據您授予的權限代表您訪問數據。組織可控制允許哪些應用訪問其私人數據。您授權的應用始終可以訪問您組織中的公共數據。",
            "Read about third-party access.": "瞭解關於第三方訪問的信息。",

            "Organization access": "組織權限",
                "Grant": "批准",
                "This organization allows the application to access organization data as described in the permissions above.": "該組織允許應用訪問上述權限中所述的組織數據。",
                "Request": "請求",
                    "Until access is granted by an owner, the application cannot access the organization’s private data or modify its public data.": "在所有者授予訪問權限之前，應用無法訪問組織的私有數據或修改其公共數據。",

        // 組織 OAuth 應用策略設置 /orgs/<orgs-name>/policies/applications/<id>
            "approval requested by": "請求批准:",
            "Currently:": "當前",
                "No private access": "無法訪問私有",
                "Approved": "已批准",
            "Review third-party application access request": "審查第三方應用訪問請求",
                "Grant access": "批准訪問",
                "Granting access will give this application the ability to request access to private data in the": "授權該應用訪問私有數據在",
                "organization.": "組織。",

                "Deny access": "拒絕訪問",
                "Denying access will remove this application’s ability to request access to private data in the": "拒絕該應用訪問數據在",

            // 頂部提醒
                // [/(.*) is authorized to access this organization’s resources/, "$1 已獲授權訪問該組織的資源"],
                // [/(.*) is denied access this organization’s resources/, "$1 被拒絕訪問該組織的資源"],

            "Applications act on your behalf to access your data based on the permissions you grant them. Organizations control which applications are allowed to access their private data. Applications authorized by members will always have access to public data in your organization.": "應用根據您授予的權限代表您訪問數據。組織可控制允許哪些應用訪問其私有數據。成員授權的應用始終可以訪問組織中的公共數據。",
            "Read about organization OAuth app access restrictions.": "瞭解有關組織 OAuth 應用訪問限制的信息。",

    },
    "regexp": [ // 正則翻譯
        [/Your installation was suspended by you on/, "您的安裝已暫停於"],
        [/This action cannot be undone. Are you sure you want to uninstall this GitHub App from (\d+) repositor(y|ies)?/, "此操作無法撤消。您確定要從 $1 個倉庫中卸載此 GitHub 應用嗎？"],
        [/Uninstall "(.*)"/, "卸載 “$1”"],
        [/You will no longer be able to sign in to ([^ ]+) \(all administrative privileges will be bestowed upon the owners you choose\)/, "您將無法再登錄 $1（所有管理權限都將授予您選擇的所有者）"],
        [/(\d+) applications?/, "$1 個應用"],
        [/([^ ]+) will no longer be able to access your GitHub account. You cannot undo this action./, "$1 將無法再訪問您的 GitHub 賬戶。您無法撤消此操作。"],
        [/([^ ]+) has been revoked from your account./, "$1 已經從您的賬戶中被撤銷了。"],
        [/Last used within the last (\d+) weeks? · Owned by/, "最後一次使用是最近 $1 周之內 · 作者"],
        [/Last used within the last (\d+) months? · Owned by/, "最後一次使用是最近 $1 月之內 · 作者"],
        [/Selected (\d+) repositor(y|ies)./, "選擇了 $1 個倉庫。"],
        [/You're all set! (.*) has been uninstalled./, "一切就緒！$1 已被卸載。"],
        [/You're all set! A job has been queued to uninstall the \'(.*)\' app./, "一切就緒！卸載 “$1” 應用的任務已排隊等候。"],
        [/Okay, (.*) was installed on the (@[^ ]+) account./, "好的，$1 已安裝在 $2 賬戶上。"],
        [/Okay, (.*) was updated for the (@[^ ]+) account./, "好的，$2 賬戶的 $1 已更新。"],
        [/Last used within the last (\d+) weeks?/, "最後一次使用是最近 $1 周之內"],
        [/Last used within the last (\d+) months?/, "最後一次使用是最近 $1 月之內"],
        [/(.+) will no longer be able to access the GitHub API. You cannot undo this action./, "$1 將無法再訪問 GitHub API。您無法撤銷此操作。"],
        [/is requesting an update to its permissions./, "正在請求更新其權限。"],
        [/The (.*) app by/, "$1 應用（由"],
        [/The (.*) app will retain its current permissions if you choose not to accept the new permissions./, "如果您選擇不接受新權限，“$1” 應用將保留其當前權限。"],
        [/(.*) is authorized to access this organization’s resources/, "$1 已獲授權訪問該組織的資源"],
        [/(.*) is denied access this organization’s resources/, "$1 被拒絕訪問該組織的資源"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Installed GitHub Apps": "已安裝的 GitHub 應用",
            "Authorized GitHub Apps": "授權的 GitHub 應用",
            "Authorized OAuth Apps": "授權的 OAuth 應用",
        },
    },
};
I18N["zh-TW"]["settings/apps/authorizations"] = I18N["zh-TW"]["settings/installations"];
I18N["zh-TW"]["settings/applications"] = I18N["zh-TW"]["settings/installations"];
I18N["zh-TW"]["settings/connections/applications"] = I18N["zh-TW"]["settings/installations"];
I18N["zh-TW"]["orgs/settings/installations"] = I18N["zh-TW"]["settings/installations"];
I18N["zh-TW"]["orgs/policies/applications"] = I18N["zh-TW"]["settings/installations"];

I18N["zh-TW"]["settings/reminders"] = { // 設置 - 定時提醒
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // 定時提醒 https://github.com/settings/reminders
            "Reminders allow you to push certain events to authorized instances of Microsoft Teams or Slack.": "提醒功能允許您將特定事件推送到 Microsoft Teams 或 Slack 的授權實例。",
            "To use scheduled reminders, make sure that the Slack or Microsoft Teams integration is installed and up-to-date. If you need help with this, please contact your organization's owner.": "要使用定時提醒，請確保已安裝 Slack 或 Microsoft Teams 集成並且是最新版本，如果您需要這方面的幫助，請聯繫您組織的所有者。",
            "Available organizations": "可用的組織",
            "Unavailable organizations": "不可用的組織",
            "Configure Reminder": "配置提醒",
            "No reminders": "沒有提醒",
            "Needs installing": "需要安裝",

        // 新的預定提醒 https://github.com/settings/reminders/<orgs-name>
            "New scheduled reminder": "新建預定提醒",
            "Slack workspace": "Slack 工作區",
            "Authorize Slack workspace": "授權 Slack 工作區",
            "Days": "天",
                "Weekdays": "工作日",
                "Monday"    : "週一",
                "Tuesday"   : "週二",
                "Wednesday" : "週三",
                "Thursday"  : "週四",
                "Friday"    : "週五",
                "Saturday"  : "週六",
                "Sunday"    : "週日",
            "Times": "時間",
                "Filter": "篩選",
            "Review requests assigned to you": "審查分配給您的請求",
                "Receive reminders for reviews waiting on you.": "接收等待您的審查提醒。",
            "Review requests assigned to your team": "審查分配給您團隊的請求",
                "Receive reminders for reviews waiting on your team.": "接收等待您的團隊的審查提醒。",
            "Enable real-time alerts": "啟用實時警報",
                "Receive immediate Slack messages when certain events happen": "當某些事件發生時，會立即收到 Slack 消息",

            "You will only receive notifications from public repositories in this organization because the current plan for": "您將只收到來自該組織中公共倉庫的通知，因為目前",
            "does not support reminders for private repositories.": "的計劃不支持私人倉庫的提醒。",
            "Upgrade to Team": "升級為團隊",
            "Create reminder": "創建提醒者",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Scheduled reminders": "定時提醒",
        },
    },
};

I18N["zh-TW"]["settings/security-log"] = { // 設置 - 安全日誌
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Security log 安全日誌 https://github.com/settings/security-log
            "Loading audit log entries…": "正在加載日誌條目…",
            "Filters": "篩選",
                "Filter audit logs": "篩選審計日誌",
                "Yesterday's activity": "昨天的活動",
                "Repository management": "倉庫管理",
                "Billing updates": "賬單更新",
                "Copilot activity": "Copilot 活動",
                "Personal access token activity": "個人訪問令牌活動",
                "View advanced search syntax": "查看高級搜索語法",
            "Filter by Member": "按用戶篩選",
            "Filter by Action": "按事件篩選",
            "Search audit logs": "搜索審計日誌",
            "Search your security log": "搜索您的安全日誌",
            "Clear current search query": "清除當前的搜索查詢",
            "Events matching search query": "搜索查詢匹配結果",
            "Export": "導出",
            "Recent events": "最近的事件",
            "Unknown IP address": "未知 IP 地址",
            "Unknown location": "未知位置",
            // [/Found (\d+) events?/, "發現 $1 個活動"],
            "Newer": "新的",
            "Older": "舊的",
            "ProTip!": "專業提示！",
                "View all events created yesterday": "查看昨天創建的所有事件",
                "View all events where you created something": "查看所有您創建內容時產生的事件",
            "Country changed from your previous session": "國家或地區與上一次會話有所不同",
            "Logged in": "登錄",
            "User signed in from an unrecognized device.": "用戶從無法識別的設備登錄。",
            "User signed in from an unrecognized device and location.": "用戶從無法識別的設備與位置登錄。",
            "New Device Used": "使用新設備",
            "Created the repository": "創建了倉庫",
            "Deleted the repository": "刪除了倉庫",
            "Created GitHub Pages site in": "創建了 GitHub Pages 在",
            "Modified GitHub Pages source in": "修改了 GitHub Pages 源程式碼在",
            "Created environment": "創造環境",
            "Added": "添加",
            "to the": "至",
            "repository": "倉庫",
                "organization with": "組織，使用",
                "read": "讀取",
                "permission": "權限",
            "Added the following repositories to the": "添加以下倉庫到",
            "Removed the following repositories from the": "刪除以下倉庫到",
            "integration:": "集成：",
            "Enabled GitHub Actions for": "啟用倉庫操作：",
            "Created a secret for": "創建機密：",
            "Created a token for": "創建令牌：",
            "Regenerated a token for": "重新生成令牌：",
            "Revoked a token for": "撤銷令牌：",
                "ending in": "結尾",
                "for the": "用於",
                "GitHub App": "GitHub 應用",

            "We couldn’t find any events matching your search.": "無匹配結果。",

    },
    "regexp": [ // 正則翻譯
        [/Found (\d+) events?/, "發現 $1 個活動"],
        [/View ([^ ]+)'s profile/, "查看 $1 的資料"],
    ],
    "title": {
        "static": {
            "Security log": "安全日誌",
        },
    },
};

I18N["zh-TW"]["settings/sponsors-log"] = { // 設置 - 贊助日誌
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["settings-menu"]["static"],

        // Sponsorship log 贊助日誌 https://github.com/settings/sponsors-log
            "Sponsors log": "贊助日誌",
            "New sponsorships, changes, and cancellations": "新的贊助、更改和取消",
            "Period:": "週期：",
            "Filter activity": "篩選活動",
            "All-time": "所有時間",
            "Past day": "過去一天",
            "Past week": "過去一週",
            "Past month": "過去一月",
            "Past year": "過去一年",
            "No sponsorship activity in this time period": "這段時間沒有贊助活動",
            "This is where you can review activity from your sponsorships.": "您可以在此處查看您的贊助活動。",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Sponsorship Log": "贊助日誌",
        },
    },
};

I18N["zh-TW"]["settings/apps"] = { // 設置 - 開發者設置/GitHub 應用
    "static": { // 靜態翻譯
        "Developer Settings": "開發者設置",
        "GitHub Apps": "GitHub 應用",
        "OAuth Apps": "OAuth 應用",
        "Personal access tokens": "個人訪問令牌",
            "Fine-grained tokens": "精細化的令牌",
            "Tokens (classic)": "令牌（經典）",

        // GitHub 應用 https://github.com/settings/apps
            // 頂部提醒
                "Job queued to revoke all user tokens": "撤銷所有用戶令牌的任務已排隊等待",

            "Register a new GitHub App": "註冊新的 GitHub 應用",
            "Want to build something that integrates with and extends GitHub?": "想要構建與 GitHub 集成和擴展的東西嗎？",
            "New GitHub App": "註冊新 GitHub 應用",
            "to get started developing on the GitHub API. You can also read more about building GitHub Apps in our": "，開始在 GitHub API 上進行開發。您還可以在我們的文檔中閱讀更多關於構建 GitHub 應用的信息",
            "developer documentation": "開發者文檔",
            "A GitHub App can act on its own behalf, taking actions via the API directly instead of impersonating a user. Read more in our": "GitHub 應用可以代表自己執行操作，直接通過 API 執行操作，而不是冒充用戶。閱讀我們的更多內容", // 存在 app時

            // 無應用提示
                "No GitHub Apps": "無 GitHub 應用",
                    "Want to build something that integrates with and extends GitHub? Register a new GitHub App to get started developing on the GitHub API.": "想創建與 GitHub 集成並擴展 GitHub 的應用程式嗎？註冊一個新的 GitHub 應用程式，開始使用 GitHub API 進行開發。",

                "View documentation": "查看文檔",

        // 註冊 GitHub 應用 https://github.com/settings/apps/new
            "Register new GitHub App": "註冊新 GitHub 應用",
            "GitHub App name": "GitHub 應用名稱",
            "The name of your GitHub App.": "您的 GitHub 應用的名稱。",
            "Markdown supported": "支持 Markdown 語法",
            "This is displayed to users of your GitHub App": "展示給 GitHub 應用的使用者",
            "Homepage URL": "主頁地址",
                "The full URL to your GitHub App’s website.": "GitHub 應用網站的主頁地址",

            "Identifying and authorizing users": "識別並授權用戶",
                "The full URL to redirect to after a user authorizes an installation.": "用戶授權安裝後重定向到的完整地址。",
                "Callback URL documentation": "回調地址文檔",
                "Add Callback URL": "添加回調地址",

                "Callback URL": "回調地址",
                "Expire user authorization tokens": "用戶授權令牌",
                    "This will provide a": "這將提供一個",
                    "which can be used to request an updated access token when this access token expires.": "，用於在此訪問令牌到期時，請求更新訪問令牌。",
                "Request user authorization (OAuth) during installation": "在安裝期間請求用戶授權 (OAuth)",
                    "Requests that the installing user grants access to their identity during installation of your App": "請求用戶在安裝應用期間授予其身份訪問權限。",
                    "Identifying and authorizing users for GitHub Apps documentation": "關於 GitHub 應用識別並授權用戶的文檔",
                "Enable Device Flow": "啟用設備流",
                    "Allow this GitHub App to authorize users via the Device Flow.": "允許此 GitHub 應用通過設備流程授權用戶。",
                    "Read the": "閱讀",
                    "Device Flow documentation": "設備流程文檔",

            "Post installation": "安裝完成後",
                "Setup URL (optional)": "設置網址 (可選)",
                    "Users will be redirected to this URL after installing your GitHub App to complete additional setup.": "用戶在安裝完 GitHub 應用後，會被重定向到這個網址，以完成額外的設置。",
                    "Unavailable when requesting OAuth during installation.": "安裝過程中請求 OAuth 時不可用。",
                    "Users will be redirected to the 'User authorization callback URL' to complete additional setup.": "用戶將被重定向到 “用戶授權回調網址” 以完成其他設置。",
                "Redirect on update": "更新時重定向",
                    "Redirect users to the 'Setup URL' after installations are updated (E.g. repositories added/removed).": "在安裝後更新時將用戶重定向到 “設置網址”（例如: 添加/刪除倉庫）。",
                    "Redirect users to the 'User authorization callback URL' after installations are updated (E.g repositories added/removed).": "在安裝後更新時將用戶重定向到 “用戶授權回調網址”（例如: 添加/刪除倉庫）。",

            "Webhook": "Web 鉤子",
                "Active": "激活",
                    "We will deliver event details when this hook is triggered.": "當鉤子被觸發時，我們將提供事件詳細信息。",
                "Webhook URL": "Web 鉤子網址",
                    "Events will POST to this URL. Read our": "事件將 POST 到此網址。閱讀",
                    "webhook documentation": "關於 Web 鉤子",
                    "for more information.": "以獲取更多信息。",
                "Secret": "機密",
                    "Read our": "閱讀我們",
                    "webhook secret documentation": "Web 鉤子機密文檔",

            "Permissions": "權限",
                "User permissions are granted on an individual user basis as part of the": "用戶權限的授予是以單個用戶為基礎的，是一個環節",
                "User authorization flow": "用戶授權流程",
                "permissions documentation": "權限文檔",
                "for information about specific permissions.": "以瞭解關於特定權限的信息。",

                "Access:": "訪問權限：",
                "Select an access level": "選擇訪問級別",
                "No access": "禁止訪問",
                "Read-only": "只讀",
                "Read and write": "讀寫",
                "Admin": "管理員",

                  "Selected": "項被選中",
                  "mandatory": "強制",

                "Repository permissions": "倉庫權限",
                    "Repository permissions permit access to repositories and related resources.": "倉庫權限允許訪問倉庫和相關資源。",

                    "Actions": "操作",
                        "Workflows, workflow runs and artifacts.": "工作流程、工作流程的運行和工件。",
                    "Administration": "管理",
                        "Repository creation, deletion, settings, teams, and collaborators.": "倉庫創建、刪除、設置、團隊和協作者。",
                    "Attestations": "證書",
                        "Create and retrieve attestations for a repository.": "創建和檢索倉庫的證書。",
                    "Checks": "檢查",
                        "Checks on code.": "檢查程式碼。",
                    "Code scanning alerts": "程式碼掃描警報",
                        "View and manage code scanning alerts.": "查看和管理程式碼掃描警報。",
                    // "": "程式碼空間",
                        "Create, edit, delete and list Codespaces.": "創建、編輯、刪除和列出程式碼空間。",
                    "Codespaces lifecycle admin": "程式碼空間的生命週期管理",
                        "Manage the lifecycle of Codespaces, including starting and stopping.": "管理程式碼空間的生命週期，包括啟動和停止。",
                    "Codespaces metadata": "程式碼空間元數據",
                        "Access Codespaces metadata including the devcontainers and machine type.": "訪問程式碼空間元數據，包括開發容器和機器類型。",
                    "Codespaces secrets": "程式碼空間機密",
                        "Restrict Codespaces user secrets modifications to specific repositories.": "限制程式碼空間的用戶機密對特定倉庫的修改。",
                    "Commit statuses": "提交狀態",
                        "Commit statuses.": "提交狀態。",
                    "Contents": "內容",
                        "Repository contents, commits, branches, downloads, releases, and merges.": "倉庫內容、提交、分支、下載、發佈和合併。",
                    // 自定義屬性
                        "View and set values for a repository's custom properties, when allowed by the property.": "在屬性允許的情況下，查看和設置倉庫自定義屬性的值。",
                    "Dependabot alerts": "Dependabot 警報",
                        "Retrieve Dependabot alerts.": "檢索 Dependabot 警報。",
                    "Dependabot secrets": "Dependabot 機密",
                        "Manage Dependabot repository secrets.": "管理 Dependabot 倉庫的機密。",
                    "Deployments": "部署",
                        "Deployments and deployment statuses.": "部署和部署狀態。",
                    "Discussions": "討論",
                        "Discussions and related comments and labels.": "討論及相關評論和標籤。",
                    "Environments": "環境",
                        "Manage repository environments.": "管理倉庫環境。",
                    "Issues": "議題",
                        "Issues and related comments, assignees, labels, and milestones.": "議題及相關評論、受理人、標籤和里程碑。",
                    "Merge queues": "合併列隊",
                        "Manage a repository's merge queues": "管理倉庫的合併隊列。",
                    "Metadata": "元數據",
                        "Search repositories, list collaborators, and access repository metadata.": "搜索倉庫、列出協作者，訪問倉庫元數據。",
                    "Packages": "軟體包",
                        "Packages published to the GitHub Package Platform.": "發佈軟體包到 GitHub Package 平臺。",
                    "Pages": "GitHub Pages",
                        "Retrieve Pages statuses, configuration, and builds, as well as create new builds.": "檢索頁面狀態、配置和構建，以及創建新的構建。",
                    "Projects": "專案",
                        "Manage classic projects within a repository.": "管理倉庫中的經典專案。",
                    "Pull requests": "拉取請求",
                        "Pull requests and related comments, assignees, labels, milestones, and merges.": "拉取請求及相關評論、受讓人、標籤、里程碑和合併。",
                    "Repository security advisories": "倉庫安全公告",
                        "View and manage repository security advisories.": "查看和管理安全公告",
                    "Secret scanning alerts": "機密掃描警報",
                        "View and manage secret scanning alerts.": "查看和管理機密掃描警報。",
                    "Secrets": "機密",
                        "Manage Actions repository secrets.": "管理操作倉庫機密。",
                    "Single file": "單個文件",
                        "Manage just a single file.": "只管理單個文件。",
                        "Path": "路徑",
                        "The content paths to single files your app can access.": "應用可以訪問的單個文件的內容路徑。",
                    "Variables": "變量",
                        "Manage Actions repository variables.": "管理操作倉庫變量。",
                    "Webhooks": "Web 鉤子",
                        "Manage the post-receive hooks for a repository.": "管理倉庫的接收後鉤子。",
                    "Workflows": "工作流程",
                        "Update GitHub Action workflow files.": "更新 GitHub Action 工作流程文件。",

                "Organization permissions": "組織權限",
                    "Organization permissions permit access to organization related resources.": "組織權限允許訪問組織相關資源。",

                    "API Insights": "API 洞察",
                        "View statistics on how the API is being used for an organization.": "查看有關組織如何使用 API 的統計信息。",
                    // 管理
                        "Manage access to an organization.": "管理對組織的訪問。",
                    "Blocking users": "拉黑用戶",
                        "View and manage users blocked by the organization.": "查看和管理被組織拉黑的用戶。",
                    "Custom organization roles": "自定義組織角色",
                        "Create, edit, delete and list custom organization roles. View system organization roles.": "創建、編輯、刪除和列出自定義組織角色。查看系統組織角色。",
                    "Custom properties": "自定義屬性",
                        "View custom properties, write repository values, and administer definitions.": "查看自定義屬性、寫入倉庫值並管理定義。",
                    "Custom repository roles": "自定義倉庫角色",
                        "Create, edit, delete and list custom repository roles.": "創建、編輯、刪除和列出自定義倉庫角色。",
                    "Events": "活動",
                        "View events triggered by an activity in an organization.": "查看組織中某項活動所觸發的事件。",
                    "GitHub Copilot Business": "GitHub Copilot 商業版",
                        "Manage Copilot Business seats and settings": "管理 GitHub Copilot 商業版席位和設置",
                    "Knowledge bases": "知識庫",
                        "View and manage knowledge bases for an organization.": "查看和管理組織的知識庫。",
                    "Members": "成員",
                        "Organization members and teams.": "組織成員和團隊。",
                    "Organization announcement banners": "組織公告橫幅",
                        "View and modify announcement banners for an organization.": "查看並修改組織的公告橫幅。",
                    "Organization codespaces": "組織程式碼空間",
                        "Manage Codespaces for an organization.": "管理組織的程式碼空間。",
                    "Organization codespaces secrets": "組織程式碼空間機密",
                        "Manage Codespaces Secrets for an organization.": "管理組織的程式碼空間機密。",
                    "Organization codespaces settings": "組織程式碼空間設置",
                        "Manage Codespaces settings for an organization.": "管理組織的程式碼空間設置。",
                    "Organization dependabot secrets": "組織 Dependabot 機密",
                        "Manage Dependabot organization secrets.": "管理 Dependabot 組織的機密。",
                    "Organization private registries": "組織私有註冊表",
                        "Manage private registries for an organization.": "管理組織的私有註冊表。",
                    "Personal access token requests": "個人訪問令牌請求",
                        "Manage personal access token requests from organization members.": "管理來自組織成員的個人訪問令牌請求。",
                    "Personal access tokens": "個人訪問令牌",
                        "View and revoke personal access tokens that have been granted access to an organization.": "查看和撤銷已被授予組織訪問權限的個人訪問令牌。",
                    "Plan": "計劃",
                        "View an organization's plan.": "查看組織的計劃。",
                    // 專案
                        "Manage projects for an organization.": "管理組織的專案。",
                    // 機密
                        "Manage Actions organization secrets.": "管理操作組織機密",
                    "Self-hosted runners": "自託管運行器",
                        "View and manage Actions self-hosted runners available to an organization.": "查看和管理組織可用的 “操作自託管運行器”。",
                    "Team discussions": "團隊討論",
                        "Manage team discussions and related comments.": "管理團隊討論及相關評論。",
                    // 變量
                        "Manage Actions organization variables.": "管理操作組織變量。",
                    // Web 鉤子
                        "Manage the post-receive hooks for an organization.": "管理組織的接收後鉤子。",

                "Account permissions": "賬戶權限",
                    "These permissions are granted on an individual user basis as part of the User authorization flow.": "這些權限是在單個用戶的基礎上授予的，作為用戶授權流程的一部分",

                    "Block another user": "拉黑其他用戶",
                        "View and manage users blocked by the user.": "查看和管理被用戶拉黑的用戶。",
                    "Codespaces user secrets": "程式碼空間用戶機密",
                        "Manage Codespaces user secrets.": "管理程式碼空間用戶機密。",
                    "Copilot Chat ": "",
                        "This application will receive your GitHub ID, your GitHub Copilot Chat session messages (not including messages sent to another application), and timestamps of provided GitHub Copilot Chat session messages. This permission must be enabled for Copilot Extensions.": "此應用將接收您的 GitHub ID、GitHub Copilot Chat 會話消息（不包括發送到其他應用的消息）以及所提供的 GitHub Copilot Chat 會話消息的時間戳。Copilot 擴展必須啟用此權限。",
                    "Copilot Editor Context": "Copilot 編輯器語境",
                        "This application will receive bits of Editor Context (e.g. currently opened file) whenever you send it a message through Copilot Chat.": "每當您通過 Copilot Chat 嚮應用發送消息時，該應用都會收到一些編輯器上下文（例如當前打開的文件）。",
                    "Email addresses": "電子郵箱地址",
                        "Manage a user's email addresses.": "管理用戶的電子郵箱地址。",
                    // 活動
                        "View events triggered by a user's activity.": "查看用戶活動觸發的事件。",
                    // 關注者
                        "A user's followers": "用戶的關注者",
                    "GPG keys": "GPG 密鑰",
                        "View and manage a user's GPG keys.": "查看和管理用戶的 GPG 密鑰。",
                    // Gist
                        "Create and modify a user's gists and comments.": "創建和修改用戶的程式碼片段和評論。",
                    "Git SSH keys": "Git SSH 密鑰",
                    "Interaction limits": "交互限制",
                        "Interaction limits on repositories": "倉庫的交互限制",
                    // 計劃
                        "View a user's plan.": "查看用戶的計劃。",
                    "Profile": "個人信息",
                        "Manage a user's profile settings.": "管理用戶的個人信息設置。",
                    "SSH signing keys": "SSH 簽名密鑰",
                        "View and manage a user's SSH signing keys.": "查看和管理用戶的 SSH 簽名密鑰。",
                    "Starring": "星標",
                        "List and manage repositories a user is starring.": "列出和管理用戶標星的倉庫。",
                    "Watching": "關注",
                        "List and change repositories a user is subscribed to.": "列出和更改用戶訂閱的倉庫。",

            // 以下的事件 與 鉤子頁面 一致
            // 添加鉤子 頁面 /<user-name>/<repo-name>/settings/hooks/new
            "Subscribe to events": "訂閱事件",
                "Based on the permissions you’ve selected, what events would you like to subscribe to?": "根據您選擇的權限，您想訂閱哪些事件？",
                "Installation target": "安裝目標",
                    "A GitHub App installation target is renamed.": "GitHub 應用安裝目標已重命名。",
                "Meta": "元數據",
                    "When this App is deleted and the associated hook is removed.": "當該應用被刪除和相關的鉤子被刪除時。",
                "Security advisory": "安全提示",
                    "Security advisory published, updated, or withdrawn.": "安全提示的發佈、更新或撤銷。",
                "Branch protection configuration": "分支保護配置",
                    "All branch protections disabled or enabled for a repository.": "禁用或啟用倉庫的所有分支保護。",
                "Branch protection rule": "分支保護規則",
                    "Branch protection rule created, deleted or edited.": "分支保護規則的創建、刪除或編輯。",
                "Code scanning alert": "程式碼掃描警報",
                    "Code Scanning alert created, fixed in branch, or closed": "程式碼掃描警報的創建、在分支中修復或關閉。",
                "Check run": "檢查運行",
                    "Check run is created, requested, rerequested, or completed.": "檢查運行的創建、請求、重新請求或完成。",
                "Check suite": "檢查套件",
                    "Check suite is requested, rerequested, or completed.": "檢查套件的請求、重新請求或完成。",
                "Commit comment": "提交評論",
                    "Commit or diff commented on.": "提交或差異評論。",
                //"創建": "",
                    "Branch or tag created.": "分支或標籤的創建。",
                "Custom property": "自定義屬性",
                    "Custom property is created, updated, or deleted.": "自定義屬性的創建、更新或刪除。",
                "Custom property values": "自定義屬性值",
                    "Custom property values are changed for a repository": "倉庫自定義屬性值的更改。",
                "Discussion": "討論",
                    "Discussion created, edited, closed, reopened, pinned, unpinned, locked, unlocked, transferred, answered, unanswered, labeled, unlabeled, had its category changed, or was deleted.": "討論的創建、編輯、關閉、重新打開、置頂、取消置頂、鎖定、解鎖、轉移、答覆、取消答覆、標記、取消標記、更改其類別或刪除。",
                "Discussion comment": "討論評論",
                    "Discussion comment created, edited, or deleted.": "討論評論的創建、編輯或刪除。",
                //"刪除": "",
                    "Branch or tag deleted.": "分支或標籤的刪除。",
                "Dependabot alert": "Dependabot 警報",
                    "Dependabot alert auto_dismissed, auto_reopened, created, dismissed, reopened, fixed, or reintroduced.": "Dependabot 警報的自動解除、自動重新打開、創建、解除、重新打開、修復或重新引入。",
                "Deploy key": "部署密鑰",
                    "A deploy key is created or deleted from a repository.": "在倉庫中部署密鑰的創建或刪除。",
                "Deployment": "部署",
                    "Repository was deployed or a deployment was deleted.": "倉庫的部署或刪除部署。",
                "Deployment protection rule": "部署保護規則",
                    "Deployment protection rule requested for an environment.": "環境請求部署保護規則。",
                "Deployment review": "部署審查",
                    "Deployment review requested, approved or rejected": "部署審查的請求、批准或拒絕",
                "Deployment status": "部署狀態",
                    "Deployment status updated from the API.": "通過 API 更新部署狀態。",
                "Exemption request push ruleset": "推送規則集豁免請求",
                    "Push ruleset bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push rules is currently in beta and subject to change.": "推送規則集旁路請求已創建、取消、完成、收到響應或駁回響應。注：推送規則的委託旁路目前處於測試階段，可能會有更改。",
                "Exemption request secret scanning": "秘密掃描豁免請求",
                    "Secret scanning push protection bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push protection is currently in beta and subject to change.": "秘密掃描推送保護旁路請求已創建、取消、完成、收到響應或駁回響應。注：推送保護的授權旁路目前處於測試階段，可能會有更改。",
                //"複刻": "",
                    "Repository forked.": "倉庫複刻。",
                "Gollum": "咕嚕",
                    "Wiki page updated.": "Wiki 頁面的更新。",
                "Issue comment": "議題評論",
                    "Issue comment created, edited, or deleted.": "議題評論的創建、編輯或刪除。",
                //"議題": "",
                    "Issue opened, edited, deleted, transferred, pinned, unpinned, closed, reopened, assigned, unassigned, labeled, unlabeled, milestoned, demilestoned, locked, unlocked, typed, or untyped.": "議題的打開、編輯、刪除、轉移、置頂、取消置頂、關閉、重新打開、分配、取消分配、標記、取消標記、設置里程碑、取消里程碑、鎖定、解鎖。",
                "Label": "標籤",
                    "Label created, edited or deleted.": "標籤的創建、編輯或刪除。",
                "Milestone": "里程碑",
                    "Milestone created, closed, opened, edited, or deleted.": "里程碑的創建、關閉、打開、編輯或刪除。",
                "Member": "成員",
                    "Collaborator added to, removed from, or has changed permissions for a repository.": "協作者添加到倉庫、從倉庫中刪除或更改了倉庫的權限。",
                "Membership": "團隊成員",
                    "Team membership added or removed.": "團隊成員的添加或刪除。",
                "Merge group": "合併組",
                    "Merge Group requested checks, or was destroyed.": "合併組的請求檢查或銷燬。",
                "Merge queue entry": "合併隊列條目",
                    "Merge Queue entry added": "合併隊列條目的添加。",
                "Organization": "組織",
                    "Organization deleted, renamed, member invited, member added, or member removed.": "組織的刪除、重命名以及成員的邀請、添加或刪除。",
                "Page build": "構建 GitHub Pages",
                    "Pages site built.": "GitHub Pages 站點的建立。",
                "Personal access token request": "個人訪問令牌請求",
                    "Personal access token request created, approved, denied, or cancelled.": "個人訪問令牌請求的創建、批准、拒絕或取消。",
                "Project": "專案",
                    "Project created, updated, or deleted.": "專案的創建、更新或刪除。",
                "Project card": "專案面板卡",
                    "Project card created, updated, or deleted.": "專案面板卡的創建、更新或刪除",
                "Project column": "專案欄目",
                    "Project column created, updated, moved or deleted.": "專案欄目的創建、更新、移動或刪除。",
                "Projects v2 item": "專案 v2 條目",
                    "Project item created, edited, deleted, archived, restored, converted, or reordered.": "專案條目的創建、編輯、刪除、歸檔、恢復、轉換或重新排序。",
                "Projects v2": "專案 v2",
                    "Project created, updated, deleted, closed, or reopened.": "專案的創建、更新、刪除、關閉或重新打開。",
                "Projects v2 status update": "專案 v2 狀態更新",
                    "Project status updates created, updated, or deleted.": "專案狀態更新的創建、更新或刪除。",
                // 公共
                    "Repository changes from private to public.": "倉庫從私有更改為公共。",
                "Pull request": "拉取請求",
                    "Pull request assigned, auto merge disabled, auto merge enabled, closed, converted to draft, demilestoned, dequeued, edited, enqueued, labeled, locked, milestoned, opened, ready for review, reopened, review request removed, review requested, synchronized, unassigned, unlabeled, or unlocked.": "拉取請求的分配、禁用自動合併、啟用自動合併、關閉、轉換為草案、取消里程碑、取消隊列、編輯、隊列、標記、鎖定、設置里程碑、打開、準備審查、重新打開、取消審查請求、請求審查、同步、取消分配、取消標記或解鎖。",
                "Pull request review": "拉取請求審查",
                    "Pull request review submitted, edited, or dismissed.": "拉取請求審查的提交、編輯或駁回。",
                "Pull request review comment": "拉取請求審查意見",
                    "Pull request diff comment created, edited, or deleted.": "拉取請求差異評論的創建、編輯或刪除。",
                "Pull request review thread": "拉取請求線程",
                    "A pull request review thread was resolved or unresolved.": "拉取請求的審查線程解決或未解決。",
                "Push": "推送",
                    "Git push to a repository.": "Git 推送到倉庫。",
                "Registry package": "註冊軟體包",
                    "Registry package published or updated in a repository.": "倉庫中註冊軟體包的發佈或更新。",
                "Release": "發行版",
                    "Release created, edited, published, unpublished, or deleted.": "發行版的創建、編輯、發佈、取消發佈或刪除。",
                "Repository": "倉庫",
                    "Repository created, deleted, archived, unarchived, publicized, privatized, edited, renamed, or transferred.": "倉庫的創建、刪除、歸檔、取消歸檔、公開、私有化、編輯、重命名或轉讓。",
                "Repository dispatch": "倉庫調度",
                    "When a message is dispatched from a repository.": "當信息從倉庫發出時。",
                "Repository ruleset": "倉庫規則集",
                    "Repository ruleset created, deleted or edited.": "倉庫規則集的創建、刪除或編輯。",
                "Security and analysis": "安全和分析",
                    "Code security features enabled or disabled for a repository.": "啟用或禁用倉庫的程式碼安全功能。",
                "Secret scanning alert": "機密掃描警報",
                    "Secrets scanning alert created, resolved, reopened, validated, or publicly leaked.": "機密掃描警報的創建、解決、重新打開、驗證或公開洩露。",
                "Secret scanning alert location": "機密掃描警報位置",
                    "Secrets scanning alert location created.": "機密掃描警報位置的創建。",
                "Secret scanning scan": "機密掃描",
                    "Secrets scanning scan completed.": "機密掃描已完成",
                // 星標
                    "A star is created or deleted from a repository.": "標星或取消倉庫星標。",
                //"狀態": "",
                    "Commit status updated from the API.": "通過 API 更新提交狀態。",
                //"團隊": "",
                    "Team is created, deleted, edited, or added to/removed from a repository.": "團隊的創建、刪除、編輯以及向倉庫添加團隊、從倉庫中移除團隊。",
                "Sub issues": "子議題",
                    "Sub-issues added or removed, and parent issues added or removed.": "子議題和父議題的添加或刪除。",
                "Team add": "團隊添加",
                    "Team added or modified on a repository.": "倉庫團隊的添加或修改。",
                "Watch": "關注",
                    "User stars a repository.": "用戶標星倉庫。",
                "Workflow dispatch": "工作流程調度",
                    "A manual workflow run is requested.": "請求手動運行工作流程。",
                "Workflow job": "工作流程作業",
                    "Workflow job queued, waiting, in progress, or completed on a repository.": "倉庫中工作流作業的隊列、等待、正在進行或完成。",
                "Workflow run": "工作流程運行",
                    "Workflow run requested or completed on a repository.": "倉庫中工作流程運行的請求或完成。",
                "Org block": "組織黑名單", // 組織設置
                    "A user has been blocked or unblocked.": "用戶拉黑或解除拉黑。",
                "Repository advisory": "倉庫公告",
                    "Repository advisory published or reported.": "倉庫公告發布或報告。",
                "Sub issues": "子提議",
                    "Sub-issues added or removed, and parent issues added or removed.": "子議題和父議題的添加或刪除。",

            "Where can this GitHub App be installed?": "這款 GitHub 應用可以安裝在哪裡？",
                "Only on this account": "僅在當前賬戶",
                    // [/Only allow this GitHub App to be installed on the (@[^ ]+) account./, "僅允許在 $1 帳戶上安裝此 GitHub 應用。"],
                "Any account": "任何賬戶",
                    "Allow this GitHub App to be installed by any user or organization.": "允許任何用戶或組織安裝此 GitHub 應用。",

            "Create GitHub App": "創建 GitHub 應用",

        // 某個 GitHub 應用 https://github.com/settings/apps/<app-name>
            // 頂部提醒
                // GitHub App 註冊成功
                "Registration successful. You must": "註冊成功。您必須",
                "generate a private key": "生成私鑰",
                "in order to install your GitHub App.": "才能安裝 GitHub 應用。",
                // GitHub App 已更新
                "Got it. Your GitHub App has been updated.": "GitHub 應用已更新。",
                "The GitHub App is now public. Anyone is free to install it.": "GitHub 應用已公開化。任何人都可以自由安裝。",
                "The GitHub App is now private. It can only be installed on this account.": "GitHub 應用已私有化。只能安裝在此賬戶上。",

            "Developer settings": "開發者設置",
            // 左側欄
                "General": "通常",
                "Permissions & events": "權限與事件",
                "Install App": "安裝應用",
                "Advanced": "高級",
                "Optional features": "可選功能",
                "Public page": "公共頁面",

            // 關於
                "Owned by:": "擁有者：",
                "Using your App ID to get installation tokens? You can now": "使用您的 App ID 獲取安裝令牌？您現在可以",
                "use your Client ID instead": "使用您的 Client ID",
                "Revoke all user tokens": "撤銷所有用戶令牌",
                "GitHub Apps can use OAuth credentials to identify users. Learn more about identifying users by reading our": "GitHub 應用可以使用 OAuth 憑據來識別用戶。瞭解更多關於識別用戶的信息，請閱讀我們的",
                "integration developer documentation": "集成開發者文檔",

                "Public link": "公共鏈接",

                // 撤銷所有用戶令牌對話框
                "Revoke all user tokens?": "撤銷所有用戶令牌？",
                    "Are you sure you want to revoke": "您確定要撤銷此應用的",
                    "all": "所有",
                    "user tokens for this application?": "用戶令牌嗎？",
                    "All users of this application will be forced back through the": "該應用的所有用戶都將被迫返回",
                    "authorization flow": "授權流程",
                    "before they can use your application again.": "，然後才能再次使用您的應用。",
                    "All SSH keys created by this application will also be deleted.": "此應用創建的所有 SSH 密鑰也將被刪除。",
                    "This action is not reversible.": "此操作不可逆轉。",
                    "I understand, revoke all user tokens": "我明白了，依然撤銷所有用戶令牌",

            "Client secrets": "客戶端機密",
                "Generate a new client secret": "生成客戶端機密",
                "You need a client secret to authenticate as the application to the API.": "您需要一個客戶端機密，才能以應用的身份驗證 API。",

            "Basic information": "基本信息",

            "Display information": "顯示信息",
                "Drag & drop": "拖放",
                "Upload a logo...": "上傳 Logo 圖片…",
                    "Uploading...": "上傳中…",
                "You can also drag and drop a picture from your computer.": "您也可以從電腦中拖放圖片。",
                        "Only images, please. Try again.": "僅限圖片，請重試。",
                        "1MB or less, please. Try again.": "請上傳 1MB 以內的文件，請重試。",
                        "Whoops! Try again.": "哎呀！請重試。",
                        "File contents don’t match the file extension. Try again.": "文件內容與擴展名不符，請重試。",

                "Delete this image": "刪除圖片",
                "Badge background color": "徽章背景顏色",
                "The hex value of the badge background color. Hex colors should only contain numbers and letters from a-f.": "徽章背景顏色的十六進制值。十六進制顏色只能包含 a-f 之間的數字和字母。",
                // 剪裁對話框
                    "Crop your new avatar": "裁剪您的新頭像",
                    "Set new avatar": "設置新頭像",
                // 頂部提醒
                    "Your avatar has been updated. It may take a few minutes to update across the site.": "您的頭像已更新。整個網站的更新可能需要幾分鐘的時間。",
                    "This avatar has been deleted.": "該頭像已被刪除。",

            // 市場
                "List your GitHub App in the": "上架您的 GitHub 應用到",
                "GitHub Marketplace": "GitHub 市場",
                "so that other users can discover it.": "以便其他用戶可以發現它。",
                "List in Marketplace": "上架應用",

                "Edit how your GitHub App is presented in the Marketplace directory, including screenshots and links.": "編輯 GitHub 應用在市場索引中的展示方式，包括截圖和鏈接。",
                "Edit Marketplace listing": "編輯市場上架信息",

            "Private keys": "私鑰",
                "Generate a private key": "生成私鑰",
                "You need a private key to sign access token requests.": "您需要私鑰來簽署訪問令牌請求。",

                "Learn more about private keys": "瞭解更多關於私鑰的信息",
                "Private key": "私鑰",
                "Added": "已添加於",

            "IP allow list": "IP 允許列表",
                "Enter the IP addresses of your GitHub App to allow organizations with": "輸入 GitHub 應用的 IP 地址，以便在安裝時允許在",
                "IP allow lists": "IP 允許列表",
                "to selectively inherit the App's IP allow list when installed.": "的組織有選擇地繼承應用的 IP 允許列表。",
                "Learn more about App IP allow lists": "瞭解更多關於應用 IP 允許列表的信息",

                "There are no IP addresses on the allow list yet.": "允許列表中尚無 IP 地址。",
                "IP address or range in CIDR notation": "以 CIDR 表示的 IP 地址或範圍",
                "Short description of IP address or range": "IP 地址或範圍的簡短描述",

                "Check IP address": "檢查 IP 地址",
                    "Enter an IP address to check whether it is permitted by enabled entries on the IP allow list.": "輸入 IP 地址，檢查 IP 允許列表中的啟用條目是否允許該地址。",

        // 某個 GitHub 應用 - 權限 https://github.com/settings/apps/<app-name>/permissions
            "Changes to permissions will be applied to all future installations. Current users will be prompted to accept any changes and enable the new permissions on their installation.": "對權限的更改將應用於今後的所有安裝。系統將提示當前用戶接受任何更改，並在其安裝中啟用新權限。",

            "Add a note to users": "為用戶添加註釋",
                "This note will be displayed on the permissions update approval page.": "該註釋將顯示在權限更新批准審查頁面上。",
                    "Add a note to your users explaining why you are requesting these changes.": "向您的用戶添加註釋，解釋您請求這些更改的原因。",

                "Are you sure you want to update permissions?": "您確定要更新權限嗎？",
                    "Current users will be prompted to accept these changes and enable the new permissions on their installation.": "系統將提示當前用戶接受這些更改，並在其安裝中啟用新權限。",

        // 某個 GitHub 應用 - 智能體 https://github.com/settings/apps/<app-name>/agent
            "A Copilot configuration allows your GitHub App to integrate with Copilot. Learn more about building GitHub Copilot Extensions in the": "Copilot 配置允許您的 GitHub 應用與 Copilot 集成。瞭解更多關於構建 GitHub Copilot 擴展的信息，請訪問",
            "documentation": "文檔",

            "Accept the Marketplace Developer agreement to create your Copilot Extension": "接受市場開發者協議以創建您的 Copilot 擴展",
                "By clicking \"Accept Terms\" below, you agree to the": "點擊下面的 “接受條款”，即表示您同意以下條款",
                "GitHub Copilot Extension Developer Policy": "GitHub Copilot 擴展開發者政策",
                "Pre-release License terms": "預發佈許可條款",
                "on behalf of": "代表",
                ". Please check to make sure that you are agreeing to these terms on behalf of the correct account.": "。請檢查以確保您代表正確的帳戶同意這些條款。",
                "Accept Terms": "接受條款",

            "To enable Copilot functionality, you must first accept the Marketplace Developer agreement": "要啟用 Copilot 功能，您必須首先接受市場開發者協議",
            "To enable Copilot functionality, you must first grant your app permission to read Copilot Messages. To do so, navigate to Permissions & Events > Account Permissions > Read-only for Copilot Chat": "要啟用 Copilot 功能，必須先授予應用讀取 Copilot 消息的權限。為此，請導航至權限和事件 > 帳戶權限 > Copilot 聊天 - 只讀",

        // 某個 GitHub 應用 - 安裝 https://github.com/settings/apps/<app-name>/installations
            // [/Install (.*)/, "安裝 $1"],
            // [/Choose an account to install (.*) on:/, "選擇要安裝 $1 的賬戶："],
            "Install": "安裝",
            // [/Install (.*) on this account./, "安裝 $1 到此賬戶上。"],
            "Installed": "已安裝",
            // [/(.*) is installed on this account./, "$1 已安裝在此賬戶上。"],

        // 某個 GitHub 應用 - 高級 https://github.com/settings/apps/<app-name>/advanced
            "Danger zone": "危險區",
                "Transfer ownership of this GitHub App": "轉讓此 GitHub 應用的所有權",
                    "Transferring may be delayed until the new owner approves the transfer.": "轉讓可能會延遲，直至新所有者批准轉讓",
                    "Transfer ownership": "轉讓所有權",
                        // [/Where should we transfer (.*)\?/, "將 $1 轉讓給誰？"],
                        "Type the name of the GitHub App to confirm": "鍵入要確認的 GitHub 應用名稱",
                        "New owner’s GitHub username or organization name": "新所有者的 GitHub 用戶名或組織名稱",
                        "Transfer this GitHub App": "轉讓所有權",
                "Delete this GitHub App": "刪除此 GitHub 應用",
                    "This cannot be undone. Please be certain.": "此操作無法撤銷。請確認。",

                    "Delete GitHub App": "刪除 GitHub 應用",
                        "Delete GitHub App?": "刪除 GitHub 應用？",
                            "Unexpected bad things will happen if you don’t read this!": "請仔細閱讀以下提示信息！！！",
                            "This action": "此操作",
                            "CANNOT": "無法",
                            "be undone. This will permanently delete the": "撤銷。這將永久刪除",
                            "GitHub App.": "GitHub 應用。",

                            "This will also uninstall the GitHub App from": "這還將卸載 GitHub 應用從",
                            // [/(\d+) accounts?/, "$1 個賬戶"],

                            "Please type in the name of the GitHub App to confirm.": "請鍵入 GitHub 應用的名稱進行確認。",
                            "I understand the consequences, delete this GitHub App": "我明白後果，依然刪除該 GitHub 應用",
                "Make this GitHub App public": "公開 GitHub 應用",
                    "Allow this GitHub App to be installed on other accounts.": "允許在其他賬戶中安裝此 GitHub 應用。",

                    "Make public": "轉為公開",
                        // [/Any user or organization will be able to install this GitHub App. Are you sure you want to make (.*) public\?/, "任何用戶或組織都可以安裝此 GitHub 應用。您確定要公開 $1 嗎？"],
                "Make this GitHub App private": "私有化 GitHub 應用",
                    "Private GitHub Apps cannot be installed on other accounts.": "私有 GitHub 應用不能安裝在其他賬戶上。",
                    "Make private": "轉為私有",
                        "This integration cannot be made private since it is already installed on other accounts.": "此應用無法轉為私有，因為它已安裝在其他賬戶上。",
                "Make this application private": "私有化應用",
                    "Private applications cannot be installed on other accounts.": "私有應用不能安裝在其他賬戶上。",
                        // [/This GitHub app will only be installable on the ([^ ]+) account. Are you sure you want to make (.*) private\?/, "此 GitHub 應用只能安裝在 $1 賬戶上。您確定要將 $2 設為私有嗎？"],

        // 某個 GitHub 應用 - 可選功能 https://github.com/settings/apps/<app-name>/beta
            // [/Activate optional features for (.*)/, "激活 $1 的可選功能"],
            // [/Choose a feature to activate for (.*):/, "選擇要為 $1 激活的功能："],

            "User-to-server token expiration": "用戶到服務器訪問令牌過期",
                "User-to-server access tokens will expire after 8 hours. A Refresh Token will be provided which can be exchanged for a new access token.": "用戶到服務器訪問令牌將在 8 小時後過期。我們將提供一個刷新令牌，用戶可以用它換取新的訪問令牌。",
                "Opt-out": "選擇退出",
                "Opt-in": "選擇加入",
                    "Disable user-to-server token expiration for this app.": "禁用此應用的用戶到服務器訪問令牌過期。",

    },
    "regexp": [ // 正則翻譯
        [/Only allow this GitHub App to be installed on the (@[^ ]+) account./, "僅允許在 $1 帳戶上安裝此 GitHub 應用。"],
        [/Choose an account to install (.*) on:/, "選擇要安裝 $1 的賬戶："],
        [/Install (.*) on this account./, "安裝 $1 到此賬戶上。"],
        [/Install (.*)/, "安裝 $1"],
        [/(.*) is installed on this account./, "$1 已安裝在此賬戶上。"],
        [/Where should we transfer (.*)\?/, "將 $1 轉讓給誰？"],
        [/Any user or organization will be able to install this GitHub App. Are you sure you want to make (.*) public\?/, "任何用戶或組織都可以安裝此 GitHub 應用。您確定要公開 $1 嗎？"],
        [/This GitHub app will only be installable on the ([^ ]+) account. Are you sure you want to make (.*) private\?/, "此 GitHub 應用只能安裝在 $1 賬戶上。您確定要將 $2 設為私有嗎？"],
        [/(\d+) accounts?/, "$1 個賬戶"],
        [/Activate optional features for (.*)/, "激活 $1 的可選功能"],
        [/Choose a feature to activate for (.*):/, "選擇要為 $1 激活的功能："],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "GitHub Apps": "GitHub 應用",
            "New OAuth Application": "新 OAuth 應用",
        },
    },
};
I18N["zh-TW"]["orgs/settings/apps/new"] = I18N["zh-TW"]["settings/apps"];

I18N["zh-TW"]["settings/developers"] = { // 設置 - 開發者設置/OAuth 應用
    "static": { // 靜態翻譯
            "Developer Settings": "開發者設置",
            "GitHub Apps": "GitHub 應用",
            "OAuth Apps": "OAuth 應用",
            "Personal access tokens": "個人訪問令牌",
                "Fine-grained tokens": "精細化的令牌",
                "Tokens (classic)": "令牌（經典）",

        // OAuth 應用 https://github.com/settings/developers
            "No OAuth applications": "沒有 OAuth 應用",
            "OAuth applications are used to access the GitHub API.": "OAuth 應用用於訪問 GitHub API。",
            "Read the docs": "閱讀文檔",
            "to find out more.": "以瞭解更多情況。",
            "Register a new application": "註冊新 OAuth 應用",

            "No OAuth apps": "無 OAuth 應用",
            "OAuth apps are used to access the GitHub API. Read the docs to find out more.": "OAuth 應用程式用於訪問 GitHub API。閱讀文檔瞭解詳情。",
            "New OAuth app": "註冊新 OAuth 應用",

            "View documentation": "查看文檔",

    },
    "regexp": [ // 正則翻譯
    ],
    "title": {
        "static": {
            "Developer applications": "開發者應用",
        },
    },
};

I18N["zh-TW"]["settings/applications/new"] = { // 設置 - 開發者設置/OAuth 應用
    "static": { // 靜態翻譯

        // 註冊 OAuth 應用 https://github.com/settings/applications/new
            "Developer Settings": "開發者設置",

            "Register a new OAuth app": "註冊 OAuth 應用",
            "Application name": "應用名",
            "Something users will recognize and trust.": "讓用戶識別和信任。",
            "Homepage URL": "主頁地址",
            "The full URL to your application homepage.": "您的應用主頁地址。",
            "Application description": "應用描述",
            "Application description is optional": "應用描述 (可選)",
            "This is displayed to all users of your application.": "所有用戶都能看到您的應用描述。",
            "Authorization callback URL": "認證回調地址",
            "Your application’s callback URL. Read our": "您的應用授權回調地址。閱讀我們",
            "OAuth documentation": "OAuth 文檔",
            "for more information.": "瞭解更多信息。",
            "Enable Device Flow": "啟用設備流程",
            "Allow this OAuth App to authorize users via the Device Flow.": "允許此 OAuth 應用通過設備流程授權用戶。",
            "Read the": "閱讀",
            "Device Flow documentation": "設備流程文檔",
            "Register application": "註冊應用",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
};
I18N["zh-TW"]["orgs/settings/applications/new"] = I18N["zh-TW"]["settings/applications/new"];

I18N["zh-TW"]["settings/personal-access-tokens"] = { // 設置 - 開發者設置/個人訪問令牌
    "static": { // 靜態翻譯
            "Developer Settings": "開發者設置",
            "GitHub Apps": "GitHub 應用",
            "OAuth Apps": "OAuth 應用",
            "Personal access tokens": "個人訪問令牌",
                "Fine-grained tokens": "精細化的令牌",
                "Tokens (classic)": "令牌（經典）",

        // 開發者設置 - 精細化的個人訪問令牌 https://github.com/settings/personal-access-tokens
            "Fine-grained personal access tokens": "精細化的個人訪問令牌",
            // 未創建時
                "No fine-grained tokens created": "沒有創建精細化的個人訪問令牌",
                "Need an API token for scripts or testing? Generate a personal access token for quick access to the GitHub API.": "需要用於腳本或測試的 API 令牌？生成個人訪問令牌，快速訪問 GitHub API。",

            "These are fine-grained, repository-scoped tokens suitable for personal": "這些都是精細化的、倉庫域的令牌，適合個人",
            "use and for using Git over HTTPS.": "使用和通過 HTTPS 使用 Git。",

            "Never used •": "從未使用過 •",
            "Last used within the last week": "最後一次使用是最近 1 周之內",
            // [/Last used within/, "最後一次使用是"],

            "Loading expiration ...": "載入有效期 …",
            "This token has expired.": "此令牌已過期。",
                "To set a new expiration date, you must regenerate the token.": "要設置新的有效期，您必須重新生成令牌。",
            "Regenerate": "重新生成",

            // 生成令牌後提醒複製
                "Make sure to copy your personal access token now as you will not be able to see this again.": "請務必立即複製您的個人訪問令牌，因為您將無法再次看到它。",

            // 刪除令牌對話框
                "Are you sure you want to delete this token?": "您確定要刪除此令牌嗎？",
                "Any applications or scripts using this token will no longer be able to access the GitHub API. You cannot undo this action.": "任何使用此令牌的應用或腳本將無法再訪問 GitHub API。您無法撤消此操作。",
                "I understand, delete this token": "我明白了，依然刪除該令牌。",

            // 頂部提醒
                "Deleted personal access token": "已刪除個人訪問令牌",

        // 創建精細化個人訪問令牌 https://github.com/settings/personal-access-tokens/new
            "New fine-grained personal access token": "新建精細化個人訪問令牌",
            "Create a fine-grained, repository-scoped token suitable for personal API use and for using Git over HTTPS.": "創建精細化的、倉庫域的令牌，適合個人 API 使用和通過 HTTPS 使用 Git。",

            "Token name": "令牌名稱",
                "A unique name for this token. May be visible to resource owners or users with possession of the token.": "此令牌的唯一名稱。可能對資源所有者或持有該令牌的用戶可見。",
                "Name can't be blank": "名稱不能為空",
                "' is available.": "' 可用。",
                "' is not available. The token name has already been taken.": "' 不可用。令牌名稱已被佔用。",
                "Name has already been taken": "名稱已被佔用",
            "Description": "描述",
            "Resource owner": "資源所有者",
                "The token will only be able to make changes to resources owned by the selected resource owner. Tokens can always read all public repositories.": "該令牌只能修改所選資源所有者擁有的資源。令牌始終可以讀取所有公共倉庫。",

                    "Select resource owner": "選擇資源所有者",
                        "You may only select resource owners with fine-grained PATs enabled.": "您只能選擇已啟用精細化個人訪問令牌（PAT）的資源所有者。",
            "Authorizing...": "授權中…",

            "Expiration": "有效期",
                "7 days": "7 天",
                "30 days": "30 天",
                "60 days": "60 天",
                "90 days": "90 天",
                "Custom": "自定義",
                    "Select date *": "選擇日期 *",
                    "Expiration date can't be blank": "過期時間不能為空",
                "No expiration": "無有效期",
                // [/Limit set by ([^ ]+) organization/, "由 $1 組織設定的限制"],
                "between 1 and 366 days": "1~366 天",

                "The token will expire on the selected date": "此令牌將在指定日期過期",
                "GitHub strongly recommends that you set an expiration date for your token to help keep your information secure.": "GitHub 強烈建議您為令牌設置有效期，以幫助確保您的信息安全。",

            "Repository access": "倉庫訪問",
                "Select the repositories this token can access. Personal access tokens can always read from all public repositories on GitHub.com": "選擇此令牌可以訪問的倉庫。個人訪問令牌始終可以讀取 GitHub.com 上所有公共倉庫中的內容。", // 更新模式下

                "Public repositories": "公共倉庫",
                    "Read-only access to public repositories.": "對公共倉庫的只讀訪問權限。",
                "All repositories": "所有倉庫",
                    "This applies to all current and future repositories you own. Also includes public repositories (read-only).": "規則適用於您所有現有及未來倉庫。同時包括公共倉庫（只讀）。",
                    "This applies to all current and future repositories that you can access in this organization. Also includes public repositories (read-only).": "此規則適用於您在此組織內可訪問的所有現有及未來倉庫，同時包括公共倉庫（只讀）。",
                "Only select repositories": "僅選定的倉庫",
                    "Select at least one repository. Max 50 repositories. Also includes public repositories (read-only).": "至少選擇一個倉庫，最多可選擇 50 個倉庫。同時包括公共倉庫（只讀）。",
                    "Select repositories": "選擇倉庫",
                        // [/Selected (\d+) repositor(y|ies)./, "選定 #1 個倉庫"],
                        "Select at least one repository.": "至少選擇一個倉庫。",
                            "No repositories found.": "未找到倉庫。",

            "Permissions": "權限",
                "Choose the minimal permissions necessary for your needs.": "選擇滿足您需求的最低權限。",
                "Learn more about permissions.": "瞭解更多關於權限的信息。",

                "Access:": "訪問權限：",
                "Read and write": "讀寫",
                "Read-only": "只讀",
                "Access: Read-only": "訪問權限: 只讀",
                    "Read access required to use other repository permissions.": "使用其他倉庫權限需要讀取權限。",
                    "Read access required to use other repository permissions": "使用其他倉庫權限需要讀取權限。",

                "Add permissions": "添加權限",
                    "Select repository permissions": "選擇倉庫權限",
                        "No items available": "尚無可用專案",
                    "Select account permissions": "選擇賬戶權限",
                    "Select organization permissions": "選擇組織權限",

            // 倉庫權限
                "No repository permissions added yet": "尚未添加倉庫權限",
                "Repository permissions permit access to repositories and related resources.": "倉庫權限允許訪問倉庫和相關資源。",

                "Actions": "操作",
                    "Workflows, workflow runs and artifacts.": "工作流程、工作流程的運行和工件。",
                "Administration": "管理",
                    "Repository creation, deletion, settings, teams, and collaborators.": "倉庫創建、刪除、設置、團隊和協作者。",
                "Artifact metadata": "附件元數據",
                    "Create and retrieve artifact metadata for a repository.": "創建和檢索倉庫附件的元數據。",
                "Attestations": "證書",
                    "Create and retrieve attestations for a repository.": "創建和檢索倉庫的證書。",
                // "Checks": "檢查",
                //     "Checks on code.": "檢查程式碼。",
                "Code scanning alerts": "程式碼掃描警報",
                    "View and manage code scanning alerts.": "查看和管理程式碼掃描警報。",
                // "": "程式碼空間",
                    "Create, edit, delete and list Codespaces.": "創建、編輯、刪除和列出程式碼空間。",
                "Codespaces lifecycle admin": "程式碼空間的生命週期管理",
                    "Manage the lifecycle of Codespaces, including starting and stopping.": "管理程式碼空間的生命週期，包括啟動和停止。",
                "Codespaces metadata": "程式碼空間元數據",
                    "Access Codespaces metadata including the devcontainers and machine type.": "訪問程式碼空間元數據，包括開發容器和機器類型。",
                "Codespaces secrets": "程式碼空間機密",
                    "Restrict Codespaces user secrets modifications to specific repositories.": "限制程式碼空間的用戶機密對特定倉庫的修改。",
                "Commit statuses": "提交狀態",
                    "Commit statuses.": "提交狀態。",
                "Contents": "內容",
                    "Repository contents, commits, branches, downloads, releases, and merges.": "倉庫內容、提交、分支、下載、發佈和合併。",
                // 自定義屬性
                    "Read and write repository custom properties values at the repository level, when allowed by the property.": "在屬性允許的情況下，在倉庫級別讀取和寫入倉庫自定義屬性值。",
                "Dependabot alerts": "Dependabot 警報",
                    "Retrieve Dependabot alerts.": "檢索 Dependabot 警報。",
                "Dependabot secrets": "Dependabot 機密",
                    "Manage Dependabot repository secrets.": "管理 Dependabot 倉庫的機密。",
                "Deployments": "部署",
                    "Deployments and deployment statuses.": "部署和部署狀態。",
                "Discussions": "討論",
                    "Discussions and related comments and labels.": "討論及相關評論和標籤。",
                "Environments": "環境",
                    "Manage repository environments.": "管理倉庫環境。",
                "Issues": "議題",
                    "Issues and related comments, assignees, labels, and milestones.": "議題及相關評論、受理人、標籤和里程碑。",
                "Merge queues": "合併列隊",
                    "Manage a repository's merge queues": "管理倉庫的合併隊列。",
                "Metadata": "元數據",
                    "Search repositories, list collaborators, and access repository metadata.": "搜索倉庫、列出協作者，訪問倉庫元數據。",
                // "Packages": "軟體包",
                //     "Packages published to the GitHub Package Platform.": "發佈軟體包到 GitHub Package 平臺。",
                "Pages": "GitHub Pages",
                    "Retrieve Pages statuses, configuration, and builds, as well as create new builds.": "檢索頁面狀態、配置和構建，以及創建新的構建。",
                // "Projects": "專案",
                //     "Manage classic projects within a repository.": "管理倉庫中的經典專案。",
                "Pull requests": "拉取請求",
                    "Pull requests and related comments, assignees, labels, milestones, and merges.": "拉取請求及相關評論、受讓人、標籤、里程碑和合併。",
                "Repository security advisories": "倉庫安全公告",
                    "View and manage repository security advisories.": "查看和管理安全公告",
                "Secret scanning alert dismissal requests": "機密掃描警報解除請求",
                    "View and manage secret scanning alert dismissal requests":"查看和管理機密掃描警報解除請求",
                "Secret scanning alerts": "機密掃描警報",
                    "View and manage secret scanning alerts.": "查看和管理機密掃描警報。",
                "Secret scanning push protection bypass requests": "機密掃描推送保護繞過請求",
                    "Review and manage repository secret scanning push protection bypass requests.": "審查和管理倉庫機密掃描推送保護繞過請求。",
                "Secrets": "機密",
                    "Manage Actions repository secrets.": "管理操作倉庫機密。",
                "Variables": "變量",
                    "Manage Actions repository variables.": "管理操作倉庫變量。",
                "Webhooks": "Web 鉤子",
                    "Manage the post-receive hooks for a repository.": "管理倉庫的接收後鉤子。",
                "Workflows": "工作流程",
                    "Update GitHub Action workflow files.": "更新 GitHub Actions 工作流程文件。",

            // 賬戶權限
                "Account": "賬戶",
                "No account permissions added yet": "尚未添加賬戶權限",
                "User permissions permit access to resources under your personal GitHub account.": "用戶權限允許訪問您個人 GitHub 賬戶下的資源。",

                "Block another user": "拉黑其他用戶",
                    "View and manage users blocked by the user.": "查看和管理被用戶拉黑的用戶。",
                "Codespaces user secrets": "程式碼空間用戶機密",
                    "Manage Codespaces user secrets.": "管理程式碼空間用戶機密。",
                "Copilot Chat": "Copilot 聊天",
                    "This application will receive your GitHub ID, your GitHub Copilot Chat session messages (not including messages sent to another application), and timestamps of provided GitHub Copilot Chat session messages. This permission must be enabled for Copilot Extensions.": "該應用程式將獲取您的 GitHub ID、您的 GitHub Copilot 聊天會話消息（不包括發送到其他應用程式的消息），以及提供的 GitHub Copilot 聊天會話消息的時間戳。必須啟用此權限才能使用 Copilot 擴展功能。",
                "Copilot Editor Context": "Copilot 編輯器上下文",
                    "This application will receive bits of Editor Context (e.g. currently opened file) whenever you send it a message through Copilot Chat.": "每當您通過 Copilot Chat 向該應用發送消息時，該應用將接收部分編輯器上下文（例如當前打開的文件）。",
                "Copilot Requests": "Copilot 請求",
                    "Send Copilot requests.": "發送 Copilot 請求",
                "Email addresses": "電子郵箱地址",
                    "Manage a user's email addresses.": "管理用戶的電子郵箱地址。",
                // 活動
                    "View events triggered by a user's activity.": "查看由用戶活動觸發的事件。",
                // 關注者
                    "A user's followers": "用戶的關注者",
                "GPG keys": "GPG 密鑰",
                    "View and manage a user's GPG keys.": "查看和管理用戶的 GPG 密鑰。",
                // Gist
                    "Create and modify a user's gists and comments.": "創建和修改用戶的程式碼片段和評論。",
                "Git SSH keys": "Git SSH 密鑰",
                "Interaction limits": "交互限制",
                    "Interaction limits on repositories": "倉庫的交互限制",
                "Knowledge bases": "知識庫",
                    "View knowledge bases for a user.": "為用戶查看知識庫。",
                "Models": "模型",
                    "Allows access to GitHub Models.": "允許訪問 GitHub 模型。",
                "Plan": "計劃",
                    "View a user's plan.": "查看用戶的計劃。",
                "Private repository invitations": "私有倉庫邀請",
                    "View a user's invitations to private repositories": "查看用戶對私有倉庫的邀請",
                "Profile": "個人信息",
                    "Manage a user's profile settings.": "管理用戶的個人信息設置。",
                "SSH signing keys": "SSH 簽名密鑰",
                    "View and manage a user's SSH signing keys.": "查看和管理用戶的 SSH 簽名密鑰。",
                "Starring": "星標",
                    "List and manage repositories a user is starring.": "列出和管理用戶標星的倉庫。",
                "Watching": "關注",
                    "List and change repositories a user is subscribed to.": "列出和更改用戶訂閱的倉庫。",

            // 組織權限
                "No organization permissions added yet": "尚未組織賬戶權限",
                "Organization permissions permit access to organization related resources.": "組織權限允許訪問組織相關資源。",

                "API Insights": "API 洞察",
                    "View statistics on how the API is being used for an organization.": "查看 API 在組織中的使用統計。",
                // 管理
                    "Manage access to an organization.": "管理對組織的訪問。",
                "Blocking users": "拉黑用戶",
                    "View and manage users blocked by the organization.": "查看和管理被組織拉黑的用戶。",
                "Campaigns": "活動",
                    "Manage campaigns.": "管理活動。",
                "Custom organization roles": "自定義組織角色",
                    "Create, edit, delete and list custom organization roles. View system organization roles.": "創建、編輯、刪除和列出自定義組織角色。查看系統組織角色。",
                "Custom properties": "自定義屬性",
                    "Read and write repository custom properties values and administer definitions at the organization level.": "讀取和寫入組織級別的倉庫自定義屬性值並管理定義。",
                "Custom properties for organizations": "自定義組織屬性",
                    "Read and write organization custom properties values at the organization level, when allowed by the property.": "在屬性允許的情況下，讀取和寫入組織級別的自定義屬性值。",
                "Custom repository roles": "自定義倉庫角色",
                    "Read and write repository custom properties values and administer definitions at the organization level.": "讀取和寫入組織級別的倉庫自定義屬性值並管理定義。",
                "Events": "事件",
                    "View events triggered by an activity in an organization.": "查看組織中某項活動所觸發的事件。",
                "GitHub Copilot Business": "GitHub Copilot 商業版",
                    "Manage Copilot Business seats and settings": "管理 GitHub Copilot 商業版席位和設置",
                "Hosted runner custom images": "託管的運行器自定義鏡像",
                    "View and manage hosted runner custom images available to an organization.": "查看和管理組織可用的託管運行器自定義鏡像。",
                "Issue Fields": "議題字段",
                    "Manage issue fields for an organization.": "管理組織的議題字段。",
                "Issue Types": "議題類型",
                    "Manage issue types for an organization.": "管理組織的議題類型。",
                // 知識庫
                    "View and manage knowledge bases for an organization.": "查看和管理組織的知識庫。",
                "Members": "成員",
                    "Organization members and teams.": "組織成員和團隊。",
                // 模型
                    "Manage model access for an organization.": "管理組織的模型訪問。",
                "Network configurations": "網絡配置",
                    "View and manage hosted compute network configurations available to an organization.": "查看和管理組織可用的託管計算網絡配置。",
                "Organization announcement banners": "組織公告橫幅",
                    "View and modify announcement banners for an organization.": "查看並修改組織的公告橫幅。",
                "Organization bypass requests for secret scanning": "組織繞過機密掃描請求",
                    "Review and manage secret scanning push protection bypass requests.": "審查和管理機密掃描推送保護繞過請求。",
                "Organization codespaces": "組織程式碼空間",
                    "Manage Codespaces for an organization.": "管理組織的程式碼空間。",
                "Organization codespaces secrets": "組織程式碼空間機密",
                    "Manage Codespaces Secrets for an organization.": "管理組織的程式碼空間機密。",
                "Organization codespaces settings": "組織程式碼空間設置",
                    "Manage Codespaces settings for an organization.": "管理組織的程式碼空間設置。",
                "Organization dependabot secrets": "組織 Dependabot 機密",
                    "Manage Dependabot organization secrets.": "管理 Dependabot 組織的機密。",
                "Organization dismissal requests for code scanning": "組織程式碼掃描的解除請求",
                    "Review and manage code scanning alert dismissal requests.": "審查和管理程式碼掃描警報解除請求。",
                "Organization private registries": "組織私有註冊表",
                    "Manage private registries for an organization.": "管理組織的私有註冊表。",
                "Plan": "計劃",
                    "View an organization's plan.": "查看組織的計劃。",
                // 專案
                    "Manage projects for an organization.": "管理組織的專案。",
                // 機密掃描警報解除請求
                    "Review and manage secret scanning alert dismissal requests": "審查和管理機密掃描警報解除請求",
                // 機密
                    "Manage Actions organization secrets.": "管理操作組織機密",
                "Self-hosted runners": "自託管運行器",
                    "View and manage Actions self-hosted runners available to an organization.": "查看和管理組織可用的 “操作自託管運行器”。",
                "Team discussions": "團隊討論",
                    "Manage team discussions and related comments.": "管理團隊討論及相關評論。",
                // 變量
                    "Manage Actions organization variables.": "管理操作組織變量。",
                // Web 鉤子
                    "Manage the post-receive hooks for an organization.": "管理組織的接收後鉤子。",

            "This token will be ready for use immediately.": "該令牌將即可可用。",

            "New personal access token": "新建個人訪問令牌",
                "Your new personal access token": "您的新個人訪問令牌",
                "will be ready for use immediately. It will expire on": "將立即準備就緒，可供使用。其有效期至",
                // [/(.+) grants you/, "$1 授予您"],
                // [/(\d+) account permissions?/, "$1 項賬戶權限"],
                // [/(\d+) permissions? for all repositories:/, "所有倉庫的 $1 項權限"],
                // [/(\d+) permissions? for (\d+) repositori(y|es):/, "$1 個倉庫的 $2 項權限"],
                // [/(\d+) organization permissions?/, "$1 項組織權限"],
                "Generating...": "生成中…",

        // 查看、更新精細化個人訪問令牌 https://github.com/settings/personal-access-tokens/<id>
            "No description": "暫無描述",
            "Created": "創建於",
                "today": "今日",

            "Access on": "訪問:",
            "Access on the": "訪問:",
            "organization": "組織",

            "User permissions": "用戶權限",
            "Repository permissions": "倉庫權限",
            "Organization permissions": "組織權限",

            // 具體權限暫時翻譯 太麻煩 主要他將讀/寫具體的權限合併描述

            // 頂部提醒
                "Your personal access token has been updated": "您的個人訪問令牌已更新",

        // 重新生成精細化個人訪問令牌 https://github.com/settings/personal-access-tokens/<id>/regenerate
            "Regenerate fine-grained personal access token": "重新生成精細化個人訪問令牌",

        // 開發者設置 - 個人訪問令牌（經典） https://github.com/settings/tokens
            "Personal access tokens (classic)": "個人訪問令牌（經典）",
            "Generate new token": "生成新令牌",
                "Fine-grained, repo-scoped": "精細化、 倉庫域",
                "Generate new token (classic)": "生成新令牌（經典）",
                    "For general use": "一般用途",

            "Tokens you have generated that can be used to access the": "生成令牌用於訪問",

            "Expires": "有效期至",
            "This token has no expiration date": "此令牌未設置有效期",
            "This token has expired": "此令牌已過期",
            "Never used": "從未使用",

            // 生成令牌後提醒複製
                "Make sure to copy your personal access token now. You won’t be able to see it again!": "確保立即複製您的個人訪問令牌。您將無法再看到它！",

            "Personal access tokens (classic) function like ordinary OAuth access tokens. They can be used instead of a password for Git over HTTPS, or can be used to": "個人訪問令牌（經典）的功能類似於普通的 OAuth 訪問令牌。它們可以用來代替 HTTPS 上 Git 的密碼，或者可以用來",
            "authenticate to the API over Basic Authentication": "通過 ‘基本身份驗證’ 對 API 進行身份驗證",

        // 創建新個人訪問令牌（經典） https://github.com/settings/tokens/new
            "New personal access token (classic)": "新建個人訪問令牌（經典）",
            "Note": "備註",
                "Note can't be blank": "備註不能為空",
            "What’s this token for?": "這個令牌有什麼用？",

            "Expiration": "有效期",
            // "This token expires": "該令牌有效期至",
            ". To set a new expiration date, you must": "。要設置一個新的有效期，您必須",


            "Select scopes": "選擇作用域",
                "Scopes define the access for personal tokens.": "作用域定義了個人令牌的訪問範圍。",
                "Read more about OAuth scopes.": "瞭解更多關於 OAuth 作用域的信息。",

            // 權限
                "Full control of private repositories": "完全控制私有倉庫",
                "Access commit status": "訪問提交狀態",
                "Access deployment status": "訪問部署狀態",
                "Access public repositories": "訪問公共倉庫",
                "Access repository invitations": "訪問倉庫邀請",
                "Read and write security events": "讀寫安全事件",
                "Update GitHub Action workflows": "更新 GitHub Actions 工作流程",
                "Upload packages to GitHub Package Registry": "將包上傳到 GitHub Packages 包註冊",
                "Download packages from GitHub Package Registry": "從 GitHub Packages 包註冊表下載包",
                "Delete packages from GitHub Package Registry": "從 GitHub Packages 包註冊表中刪除包",
                "Full control of orgs and teams, read and write org projects": "完全控制組織和團隊，讀寫組織專案",
                "Read and write org and team membership, read and write org projects": "讀寫組織和團隊成員，讀寫組織專案",
                "Read org and team membership, read org projects": "讀取組織和團隊成員，讀取組織專案",
                "Manage org runners and runner groups": "管理組織運行器和運行器組",
                "Full control of user public keys": "完全控制用戶公鑰",
                "Write user public keys": "寫入用戶公鑰",
                "Read user public keys": "讀取用戶公鑰",
                "Full control of repository hooks": "完全控制倉庫鉤子",
                "Write repository hooks": "寫入倉庫鉤子",
                "Read repository hooks": "讀取倉庫鉤子",
                "Full control of organization hooks": "完全控制組織鉤子",
                "Create gists": "創建程式碼片段",
                "Access notifications": "訪問通知",
                "Update ALL user data": " 更新所有用戶數據",
                "Read ALL user profile data": "讀取所有用戶個人資料數據",
                "Access user email addresses (read-only)": "訪問用戶電子郵箱地址（只讀）",
                "Follow and unfollow users": "關注和取消關注用戶",
                "Delete repositories": "刪除倉庫",
                "Read and write team discussions": "讀寫團隊討論",
                "Read team discussions": "讀取團隊討論",
                "Full control of enterprises": "完全控制企業",
                "Manage enterprise runners and runner groups": "管理企業運行器和運行器組",
                "Read and write enterprise billing data": "讀寫企業計費數據",
                "Read enterprise profile data": "讀取企業個人數據",
                "Provisioning of users and groups via SCIM": "通過 SCIM 配置用戶和組",
                "Full control of audit log": "完全控制審核日誌",
                "Read access of audit log": "讀取審核日誌",
                "Full control of codespaces": "完全控制程式碼空間",
                "Ability to create, read, update, and delete codespace secrets": "創建、讀取、更新和刪除程式碼空間機密",
                "Full control of GitHub Copilot settings and seat assignments": "完全控制 GitHub Copilot 設置和席位分配",
                "View and edit Copilot Business seat assignments": "查看和編輯 GitHub Copilot 商業版席位分配",
                "Write org hosted compute network configurations": "寫入組織託管計算網絡配置",
                "Read org hosted compute network configurations": "讀取組織託管計算網絡配置",
                "Full control of projects": "完全控制專案",
                "Read access of projects": "讀取專案",
                "Full control of public user GPG keys": "完全控制公共用戶 GPG 密鑰",
                "(Developer Preview)": "（開發者預覽版）",
                "Write public user GPG keys": "寫入公共用戶 GPG 密鑰",
                "Read public user GPG keys": "讀取公共用戶 GPG 密鑰",
                "Full control of public user SSH signing keys": "完全控制公共用戶 SSH 簽名密鑰",
                "Write public user SSH signing keys": "寫入公共用戶 SSH 簽名密鑰",
                "Read public user SSH signing keys": "讀取公共用戶 SSH 簽名密鑰",

            "Generate token": "生成令牌",
                // 頂部提醒
                "Some of the scopes you’ve selected are included in other scopes. Only the minimum set of necessary scopes has been saved.": "您選擇的一些作用域包含在其他作用域中。只保存了必要作用域的最小集合。",
                "Note has already been taken": "備註已存在",

        // 重新生成個人訪問令牌（經典） https://github.com/settings/tokens/<id>/regenerate
            "Regenerate personal access token (classic)": "重新生成個人訪問令牌（經典）",
                "Submitting this form will generate a new token. Be aware that any scripts or applications using this token will need to be updated.": "提交此表單將產生一個新的令牌。請注意，任何使用該令牌的腳本或應用將需要更新。",
            "Regenerate token": "重新生成令牌",

    },
    "regexp": [ // 正則翻譯
        [/Expires on ([^ ]+), ([^ ]+) (\d+) (\d+)/, function(all, week, month, day, year){
            var weekKey = {
                "Sun"  : "週日",
                "Mon"  : "週一",
                "Tue"  : "週二",
                "Wed"  : "週三",
                "Thu"  : "週四",
                "Fri"  : "週五",
                "Sat"  : "週六"
            };
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            return '有效期至 ' + year + '年' + monthKey[month] + day + '日，' + weekKey[week];
        }],
        [/(\d+) days? \((.+)\)/, (match, d , p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return d + `天（${translatedDate}）`;
        }],
        [/Last used within the last (\d+) weeks?/, "最後一次使用是最近 $1 周之內"],
        [/Last used within the last (\d+) months?/, "最後一次使用是最近 $1 月之內"],
        [/Last used within the last (\d+) years?/, "最後一次使用是最近 $1 年之內"],
        [/Limit set by ([^ ]+) organization/, "由 $1 組織設定的限制"],
        [/Selected (\d+) repositor(y|ies)./, "選定 $1 個倉庫"],
        // 新建個人訪問令牌對話框
            [/(.+) grants you/, "$1 授予您"],
            [/(\d+) account permissions?/, "$1 項賬戶權限"],
            [/(\d+) permissions? for all repositories:/, "所有倉庫的 $1 項權限"],
            [/(\d+) permissions? for (\d+) repositori(y|es):/, "$1 個倉庫的 $2 項權限"],
            [/(\d+) organization permissions?/, "$1 項組織權限"],
    ],
    "title": {
        "static": {
            "Fine-grained Personal Access Tokens": "精細化的個人訪問令牌",
            "New Fine-grained Personal Access Token": "新建精細化個人訪問令牌",
            "Personal Access Tokens (Classic)": "個人訪問令牌（經典）",
            "New Personal Access Token (Classic)": "新建個人訪問令牌（經典）",
        },
    },
};
I18N["zh-TW"]["settings/tokens"] = I18N["zh-TW"]["settings/personal-access-tokens"];

// 倉庫相關==
I18N["zh-TW"]["repository-public"] = { // 倉庫 - 公共部分
    "static": { // 靜態翻譯
        // 倉庫頁面 /<user-name>/<repo-name>/
            // 被 GitHub 官方禁用
            "This repository has been disabled.": "此倉庫已被禁用。",
            "Access to this repository has been disabled by GitHub Staff due to a violation of GitHub's terms of service. If you are the owner of the repository, you may reach out to GitHub Support for more information.": "由於違反了 GitHub 的服務條款，GitHub 已禁止訪問此倉庫。如果您是倉庫的所有者，您可以聯繫 GitHub 支持以獲取更多信息。",

            // 倉庫地址-浮動信息窗口(僅 Android UA)
            "Navigate back to": "返回到",

            // 頂部提示
            "Sorry, that branch already exists.": "抱歉，該分支已存在。",
            "has invited you to collaborate on this repository": "邀請您成為該倉庫協作者",
                "View invitation": "查看",
            "Updated issue templates for this repository": "已為此倉庫更新議題模板",

            // 存檔
            "This repository has been archived by the owner. It is now read-only.": "此倉庫已被所有者存檔。它現在是只讀的。",

            "Appearance settings": "外觀設置", // 未登錄時出現
                "Increase contrast": "高對比度",
                    "Enable high contrast for light or dark mode (or both) based on your system settings": "根據您的系統設置，為淺色或深色模式（或兩者）啟用高對比度",
                    "Light mode": "淺色模式",
                    "Dark mode": "深色模式",
                    "On": "開",
                    "Off": "關",

            // 倉庫違反 DMCA
            "Repository unavailable due to DMCA takedown.": "由於 DMCA 刪除，倉庫不可用。",
            "This repository is currently disabled due to a DMCA takedown notice. We have disabled public access to the repository. The notice has been": "由於 DMCA 刪除通知，此倉庫當前已被禁用。我們已經禁止公眾訪問該倉庫。該通知已",
            "publicly posted": "公開發布",
            "If you are the repository owner, and you believe that your repository was disabled as a result of mistake or misidentification, you have the right to file a counter notice and have the repository reinstated. Our help articles provide more details on our": "如果您是倉庫所有者，並且您認為您的倉庫由於錯誤或誤認而被禁用，您有權提交反通知並恢復倉庫。我們的幫助文章提供了關於我們的更多詳細信息",
            "DMCA takedown policy": "DMCA 刪除政策",
            "how to file a counter notice": "如何提交反通知",
            ". If you have any questions about the process or the risks in filing a counter notice, we suggest that you consult with a lawyer.": "。如果您對提交反通知的流程或風險有任何疑問，我們建議您諮詢律師。",

             // 用戶 浮動信息卡
                "- same time": "- 時間相同",
                "Recently edited these files": "最近編輯過這些文件",
                "Owns this repository": "擁有該倉庫",
                "Left a review": "留下了一個評論",
                "Committed to this repository": "已提交過這個倉庫",
                "Committed to this repository in the past day": "最近一天裡已提交過這個倉庫",
                "Committed to this repository in the past week": "最近一週裡已提交過這個倉庫",
                "Committed to this repository in the past month": "最近一個月裡已提交過這個倉庫",
                "Member of": "隸屬組織",
                // [/, and (\d+) more/, "，以及其他 $1 個組織"],
                "Opened this issue": "打開了該議題",
                "Opened this pull request": "打開了該拉取請求",
                "Opened this pull request (their first ever)": "打開了該拉取請求（他們有史以來的第一個請求）",
                "Started this discussion": "開啟了該討論",

            // 組織  浮動信息卡
                // [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
                // [/(\d+) members?/, "$1 個成員"],

            "Some checks haven't completed yet": "部分檢查還未完成",

            "Jump to bottom": "跳到底部", //小屏模式
            "Forked from": "複刻自", // 同上（發行版未登錄頁面）

            "people": "人", // 提交
            "committed": "提交於", // 提交浮窗
            "authored": "撰寫於",
            "authored and": "撰寫和", // 1 編寫，由 2 提交

            // 標籤欄
            "Code": "程式碼",
            "Pull requests": "拉取請求",
            "Discussions": "討論",
            "Actions": "操作",
            "Projects": "專案",
            "Models": "模型",
            "Security": "安全",
            "Insights": "洞察",
            "Settings": "設置",

            "Additional navigation options": "更多導航選項", // 小屏
            "View all files": "查看所有文件", //Android UA 下出現

            // "Pulse": "統計",
            // "Graphs": "圖表",

            // 返回通知頁狀態條
            "Back to notifications": "回到通知",
            "Done": "已完成",
            "Subscribe": "訂閱",
            "Unsubscribe": "退訂",
            "Mark as read": "標記為已讀",
            "Mark as unread": "標記為未讀",
            "Move to inbox": "移動到收件箱",
            "Save": "保存",
            "Unsave": "未保存",

            // 評論框頭部欄 (議題 & 拉取請求)
                "Contributor": "貢獻者",
                "Owner": "所有者",
                "Author": "作者",
                    "You are the author of this issue": "您是這個議題的作者。",  // 議題
                    "You are the author of this pull request.": "您是這個拉取請求的作者。", // 拉取請求
                    "This user is the author of this issue": "該用戶是這個議題的作者。",  // 議題
                    "This user is the author of this issue.": "該用戶是這個議題的作者。",// 拉取請求
                    "This user is the author of this pull request.": "該用戶是這個拉取請求的作者。",// 拉取請求
                "Member": "成員",
                    //[/This user is a member of the ([^ ]+)./, "該用戶是 $1 組織的成員。"],
                "Collaborator": "協作者",
                    //[/This user has been invited to collaborate on the ([^ ]+) repository./, "該用戶已被邀請在 $1 倉庫上進行協作。"],
                "Pick your reaction": "選擇您的表情",
                "Copy link": "複製鏈接",
                "Quote reply": "引用回覆",
                "Reference in new issue": "引用到新議題",
                    // 引用到新議題 對話框
                    "Body": "正文",
                    "Issue title": "議題標題",
                    "Issue body": "議題正文",
                    "Select repository": "選擇倉庫",
                    "Repository:": "倉庫：",
                    "No matching repositories.": "沒有匹配的倉庫。",
                "Report content": "舉報內容",
                "Report": "舉報",
                // 評論刪除提醒
                    "Are you sure you want to delete this?": "您定要刪除這個嗎？",

                "commented": "評論於",
                "commented on behalf of": "評論，代表",
                "— with": "— 通過",
                "Update comment": "更新評論",
                "Hide": "隱藏",
                    "via email": "通過郵件",

                "created": "創建",
                "edited": "編輯",
                "(most recent)": "(最近的)",
                "(deleted)": "(已刪除)",
                "deleted this content": "刪除了該內容",
                // 評論歷史查看
                "Options": "選項",
                // 選項下拉菜單
                "More options": "更多選項",
                "The most recent revision cannot be deleted. Need to delete sensitive information? Go to the specific edit where the information was added.": "最近的修訂版不能被刪除。需要刪除敏感信息？請到信息的具體編輯處修改。",
                "Delete revision from history": "從歷史記錄中刪除修訂",
                "This edit’s content will no longer be visible.": "此修改的內容將不再可見。",
                    "Delete revision": "刪除修訂",
                // 評論狀態
                "This comment has been hidden.": "此評論被隱藏。",
                "This comment was marked as abuse.": "此評論被標記為濫用。",
                "This comment was marked as spam.": "此評論被標記為垃圾信息。",
                "This comment was marked as off-topic.": "此評論被標記為偏離主題。",
                "This comment was marked as outdated.": "此評論被標記為已過時。",
                "This comment was marked as duplicate.": "此評論被標記為重複。",
                "This comment was marked as resolved.": "此評論被標記為已解決。",
                "Sign in to view": "登錄後查看", // 未登錄

            // 切換分支/標籤 下拉菜單
                "Switch branches/tags": "切換分支/標籤",
                "Find or create a branch…": "查找或創建分支…",
                "Find a branch...": "查找分支…",
                "Filter branches/tags": "搜索分支/標籤",
                "Branches": "分支",
                "default": "默認",
                "View all branches": "查看全部分支",
                "Find a tag": "查找標籤",
                "Tags": "標籤",
                "Tag": "標籤",
                "Search for a tag": "搜索標籤",
                "Nothing to show": "暫無",
                "View all tags": "查看全部標籤",

                "Find or create a branch...": "查找或創建分支…",
                "Search or create a new tag": "搜索或創建新標籤",
                "View all": "查看全部",
                "branches": "分支",
                "Find a tag...": "查找標籤…",
                "Nothing to show": "暫無",
                "tags": "標籤",

                "View all rules": "查看全部規則",

            // 鍵盤快捷鍵
                "Open in codespace"  : "在程式碼空間中打開",
                "Open in github.dev editor"  : "在 github.dev 編輯器中打開",
                "Open github.dev editor in a new tab"  : "在新標籤頁中打開 github.dev 編輯器",
                "Open cs.github.com in a new tab": "在新標籤頁中打開 cs.github.com",
                "Focus secondary search bar" : "聚焦二級搜索欄",
                "Go to Code"                 : "跳轉到程式碼",
                "Go to Issues"               : "跳轉到議題",
                "Go to Pull Requests"        : "跳轉到拉取請求",
                "Go to Actions"              : "跳轉到操作",
                "Go to Projects"             : "跳轉到專案",
                "Go to Wiki"                 : "跳轉到 Wiki",
                "Go to Discussions"          : "跳轉到討論",

                "Copilot chat": "Copilot 聊天",
                "Open Copilot chat": "打開 Copilot 聊天",
                "Close Copilot chat": "關閉 Copilot 聊天",
                "Expand/collapse Copilot chat": "展開/摺疊 Copilot 聊天",

            // 議題
                "Submit comment": "提交評論",
                "Submit comment and close issue": "提交評論並關閉議題",
                "Preview comment": "預覽評論",
                "Create issue": "創建議題",
                // "篩選用戶": "",
                "Filter by or edit assignees"  : "按受理人篩選或編輯受理人",
                "Filter by or edit labels"     : "按標籤篩選或編輯標籤",
                "Filter by or edit projects"   : "按專案篩選或編輯專案",
                "Filter by or edit milestones" : "按里程碑篩選或編輯里程碑",
                "Reply (quoting selected text)": "答覆（引用所選文本）",
                "Open saved replies": "打開快捷回覆（引用所選文本）",
                "Insert saved reply (with open saved replies)": "插入快捷回覆（打開快捷回覆）",

                "Pull request list": "拉取請求列表",
                    "Open pull request"  : "打開拉取請求",
                "Pull request - Conversation tab": "拉取請求 - 對話標籤卡",
                    "Submit comment and close or open pull request": "提交評論和關閉或打開拉取請求",
                    "Request reviewers": "請求審查者",
                    "Link an issue or pull request from the same repository": "鏈接同一倉庫的議題或拉取請求",
                    "Toggle visibility of all collapsed review comments instead of just the current one": "切換所有摺疊審查意見的可見性，而不僅僅是當前的審查意見",
                "Pull request - Files changed tab": "拉取請求 - 文件更改標籤卡",
                    "Open commits list": "打開提交列表",
                    "Open files list": "打開文件列表",
                    "Next commit": "下一個提交",
                    "Previous commit": "上一個提交",
                    "Show or hide annotations": "顯示或隱藏批註",
                    "Show or hide comments": "顯示或隱藏評論",
                    "Submit a review comment": "提交審查意見",
                    "Collapse or expand all files instead of just the current one": "摺疊或展開所有文件，而不僅僅是當前文件",
                    "and click": "和點擊",

            // 高頻詞
                "Merged": "已合併",
                "Draft": "草案",
                "Branch": "分支",
                "Branches": "分支",
                "Tags": "標籤",

            "Compare & pull request": "比較 & 拉取請求",

        // 倉庫 404 頁面（非刪庫狀態）
            "404 - page not found": "404 - 找不到頁面",
            "The": "該",
            "branch of": "分支",
            "does not contain the path": "倉庫，不包含路徑",
            "Return to the repository overview": "返回倉庫概述",
            "Cannot find a valid ref in": "未找到有效的引用",
            "Go to default branch": "跳轉到默認分支",

        // 500 頁面
            "Looks like something went wrong!": "好像出了什麼問題！",
            "We track these errors automatically, but if the problem persists feel free to contact us. In the meantime, try refreshing.": "我們會自動跟蹤這些錯誤，但如果問題仍然存在，請隨時與我們聯繫。與此同時，嘗試刷新。",
            "Contact Support": "聯繫 GitHub 支持",
            "GitHub Status": "GitHub 狀態",

        // 頁面加載異常(倉庫)
            "Error loading page": "加載頁面出錯",
            "It looks like your internet connection is down. Please check it.": "您的網絡連接似乎出現故障。請檢查一下。",

        // 邀請繼任者提醒
            "Ensure the future of your work!": "確保您工作的未來！",
            "Consider inviting another GitHub user to be your successor.": "考慮邀請另一位 GitHub 用戶作為您的繼任者。",
            "Inviting a successor helps ensure the continuity of your work in case you are unable to access your account.": "邀請繼任者有助於在您無法訪問賬戶時確保工作的連續性。",
            "Invite a successor": "邀請繼任者",

        // 倉庫贊助
            "Couldn't load subscription status.": "無法加載贊助狀態。",
            "Retry": "重試",

        // 提交檢查對話框
            "Some checks haven’t completed yet": "部分檢查尚未完成",
            "Some checks were not successful": "部分檢查未成功",
            "All checks have passed": "所有檢查通過",
            "All checks have failed": "所有檢查失敗",
            "Waiting to run this check...": "正在等待運行此檢查…",
            "Queued": "隊列中",
            "Skipped": "已跳過",
            "Deployed": "已部署",
            "Pending": "待處理",
            "Build Failed": "構建失敗",
            "Build Passed": "構建通過",
            "Build Errored": "構建錯誤",
            "Build Canceled": "構建取消",
            "Waiting for build": "等待構建",

        // 未登錄浮窗
            "You must be signed in to change notification settings": "您必須登錄後才能更改通知設置",
            "You must be signed in to star a repository": "您必須登錄後才能標星倉庫",
            "You must be signed in to add this repository to a list": "您必須登錄後才能將此倉庫添加到列表中",
            "You must be logged in to vote": "您必須登錄後才能投票",

        "Open commit details": "打開提交詳情",
        "failure": "失敗",
    },
    "regexp": [ // 正則翻譯
        [/Started (\d+) discussions? in this repository in the past day/, "過去一天內在此倉庫中開啟了 $1 個討論"], // 用戶 浮動信息卡
        [/Started (\d+) discussions? in this repository in the past week/, "過去一週內在此倉庫中開啟了 $1 個討論"], // 用戶 浮動信息卡
        [/Started (\d+) discussions? in this repository in the past month/, "過去一個月內在此倉庫中開啟了 $1 個討論"], // 用戶 浮動信息卡
        [/Started (\d+) discussions? in this repository/, "在此倉庫中開啟了 $1 個討論"], // 用戶 浮動信息卡
        [/Opened this pull request \(their first in ([^ ]+)\)/, "打開了這個拉取請求（首次在 $1 發表）"], // 用戶 浮動信息卡
        [/([^ ]+) requested changes, you commented/, "$1 要求更改，您發表評論"], // 拉取請求 浮動信息卡
        [/(\d+) successful checks?/, "$1 個成功的檢查"],
        [/(\d+) successful/, "$1 成功"],
        [/(@\S+) generated this status\./, "$1 創建了這個狀態"],
        [/Successful in (\d+)s/, "在 $1 秒內成功"],
        [/Successful in (\d+)m/, "在 $1 分內成功"],
        [/(\d+) failing checks?/, "$1 個失敗的檢查"],
        // 3 skipped
        [/(\d+) skipped/, "$1 個跳過"],
        [/Failing after (\d+)s/, "在 $1 秒後失敗"],
        [/(\d+) in progress check/, "$1 個正在運行的檢查"],
        // [/ and /, " 和 "],
        [/, and (\d+) more/, "，以及其他 $1 個組織"], // 用戶 浮動信息卡
        [/^(\d+) repositor(y|ies)/, "$1 個倉庫"], // 組織  浮動信息卡
        [/(\d+) members?/, "$1 個成員"], // 組織  浮動信息卡
        [/Answered (\d+) discussions? in this repository in the past month/, "過去一個月內在此倉庫中回答了 $1 個討論"], // 用戶 浮動信息卡
        [/Answered (\d+) discussions? in this repository in the past week/, "過去一週內在此倉庫中回答了 $1 個討論"], // 用戶 浮動信息卡
        [/Answered (\d+) discussions? in this repository/, "在此倉庫中回答了 $1 個討論"], // 用戶 浮動信息卡
        [/had recent pushes (\d+) seconds? ago/, "分支有了最新的推送，$1 秒之前"],
        [/had recent pushes (\d+) minutes? ago/, "分支有了最新的推送，$1 分鐘之前"],
        [/had recent pushes less than (\d+) minutes? ago/, "分支有了最新的推送，不到 $1 分鐘"],
        [/had recent pushes about/, "分支有了最新的推送，大約"],
        [/This user is a member of the ([^ ]+) organization./, "該用戶是 $1 組織的成員。"],
        [/This user has been invited to collaborate on the ([^ ]+) repository./, "該用戶已被邀請在 $1 倉庫上進行協作。"],
        [/You are the owner of the (.*) repository./, "您是 $1 倉庫的所有者。"],
        [/This user is the owner of the (.*) repository./, "該用戶是 $1 倉庫的所有者。"],
        [/You have been invited to collaborate on the (.*) repository./, "您已受邀參與 $1 倉庫的協作。"],
        [/You have previously committed to the (.*) repository./, "您之前有提交到 $1 倉庫。"],
        [/This user has previously committed to the (.*) repository./, "該用戶之前有提交到 $1 倉庫。"],
        [/This repository was archived by the owner on (.+). It is now read-only./, (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `此倉庫已由所有者於${translatedDate}存檔。它現在是只讀的。`;
        }],
        [/, and ([^ ]+)/, ", 和 $1"],
        [/reacted with (thumbs up|thumbs down|laugh|hooray|confused|heart|rocket|eyes) emoji/, function (all, reacted) {
            var reactedKey = {'thumbs up': "點贊", 'thumbs down': "點踩", laugh: "大笑", hooray: "歡呼", confused: "表示困惑", heart: "比心", rocket: "發送火箭", eyes: "表示關注"};

            return reactedKey[reacted];
        }],
        // 成為協作者提示
        [/You now have push access to the ([^ ]+) repository./, "您現在擁有推送至 $1 倉庫的權限"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
        // 提交 - 作者窗
        [/(\d+) authors?/, "$1 作者"],
    ],
};

I18N["zh-TW"]["page-new-repo"] = {// 倉庫 - 新建/導入/複刻倉庫
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 新建倉庫 https://github.com/new
            "Create a new repository": "新建倉庫",
                "A repository contains all project files, including the revision history.": "倉庫包含專案中的所有文件，包括修訂歷史記錄。",
                "Already have a project repository elsewhere?": "在其他地方已有倉庫？",
                "Import a repository": "導入倉庫",
                "Required fields are marked with an asterisk (*).": "帶星號 (*) 的為必填項。",

            "🎉 Try the new experience": "🎉 嘗試新版頁面",

            "Repository template": "倉庫模板",
                "Fetching templates…": "正在獲取模板…",
                "No template": "不設置模板",
                "No templates available.": "無可用模板。",
                "Start your repository with a template repository's contents.": "使用模板倉庫的內容新建倉庫。",

            "Owner": "所有者",
            "Repository name": "倉庫名稱",
            "Great repository names are short and memorable. Need inspiration? How about": "好的倉庫名稱應該簡單且容易記憶。需要靈感嗎？這個怎麼樣：",
                "Checking availability…": "檢查可用性…",
                "is available.": "名稱可用。",
                "The repository": "倉庫",
                "already exists on this account": "已經存在於此賬戶",
                "Your new repository will be created as": "您的新倉庫將被創建為",
                "New repository name must not be blank": "新倉庫名稱不能為空",

                // 用戶名同名倉庫
                "You found a secret!": "您發現了一個秘密！",
                "is a ✨": "是一個 ✨",
                "special": "特別的",
                "✨ repository that you can use to add a": "✨ 倉庫，您可以用它來添加一個",
                "to your GitHub profile. Make sure it’s public and initialize it with a": "到您的 GitHub 個人資料。確保它是公開的，並在初始化時加入一個",
                "to get started.": "以便開始工作。",
                 // 組織 .github 倉庫
                "to your organization's GitHub profile. Make sure it’s public and initialize it with a": "到您組織的 GitHub 個人資料。確保它是公開的，並在初始化時加入一個",
                "in the": "在",
                "directory to get started.": "目錄下以便開始工作。",

                // 組織倉庫
                "You may not create private repositories by organization policy.": "根據組織政策，您不能創建私有倉庫。",

            "Description": "描述",
                "(optional)": "(可選)",
            "Public": "公共",
                "Anyone on the internet can see this repository. You choose who can commit.": "任何人都可以看到這個倉庫，您可以選擇誰能提交。",
            "Private": "私有",
                "You choose who can see and commit to this repository.": "您可以選擇誰可以看和提交到該倉庫。",
            "Initialize this repository with:": "使用以下方式初始化此倉庫：",
                // "Skip this step if you’re importing an existing repository.": "如果您要導入現有倉庫，請跳過此步驟。",
                "Add a README file": "添加 README 文件",
                    "This is where you can write a long description for your project.": "您可以在此處為您的專案編寫詳細描述。",
                    "Learn more about READMEs.": "瞭解更多關於 README 的信息。",
            "Add .gitignore": "添加 .gitignore 文件",
                "Choose which files not to track from a list of templates.": "從模板列表中選擇哪些文件不需要跟蹤。",
                "Learn more about ignoring files.": "瞭解更多關於忽略文件的信息。",
                ".gitignore template:": ".gitignore 模板：",
                    ".gitignore template": ".gitignore 模板",
                    "Filter…": "篩選…",
                    "None": "無",

                    // 篩選 - 無模板
                    "You haven't created any items yet": "您尚未創建任何專案",
                        "Please add or create new items to populate the list.": "請添加或創建新專案以填充列表。",
            "Choose a license": "選擇許可證",
                "A license tells others what they can and can't do with your code.": "許可證告訴其他人，他們可以使用您的程式碼做什麼和不能做什麼。",
                "Learn more about licenses.": "瞭解更多關於許可證的信息。",

                "License:": "許可證：",
                    "License": "許可證",

            // 市場應用列表
            "Grant your Marketplace apps access to this repository": "授予市場應用訪問該倉庫的權限",
            "You are": "您",
            "subscribed to": "訂閱了",
            "Marketplace app": "個市場應用",
            "s": " ",

            "You are creating a public repository in your personal account.": "您正在個人賬戶中創建公共倉庫",
            "You are creating a private repository in your personal account.": "您正在個人賬戶中創建私有倉庫",

            "This will set": "這將設置",
            "as the default branch.": "為默認分支。",
            "Change the default name in": "變更默認名稱在",
            "your": "您的",
            "settings": "設置",

            "Create repository": "創建倉庫",
            "Creating repository...": "創建倉庫中…",

        // 依據模板新建倉庫 https://github.com/new?template_owner=<template-owner>&template_name=<template-name>
            "Include all branches": "包括所有分支",
                "Copy all branches from": "複製所有",
                "and not just the default branch.": "倉庫分支，而不僅僅是默認分支。",

                "If enabled, all branches from the template repository will be included.": "如果啟用，將包含來自模板倉庫的所有分支。",

        // 導入倉庫 第一頁 https://github.com/new/import
            "Import your project to GitHub": "將您的專案導入到 GitHub",
                "Import all the files, including revision history, from another version control system.": "導入的所有文件，包括修訂歷史記錄，來自其他版本控制系統。",
                "Support for importing Mercurial, Subversion and Team Foundation Version Control (TFVC) repositories ended on April 12, 2024. For more details, see the": "對導入 Mercurial、Subversion 和 Team Foundation 版本控制 (TFVC) 倉庫的支持已結束於 2024 年 4 月 12 日。有關詳細信息，請參閱",
                "changelog": "更新日誌",

            "Your source repository details": "您源倉庫的詳情",
            "The URL for your source repository": "您源倉庫的 URL",
                "Learn more about the types of": "瞭解更多關於",
                "importing git repositories": "導入 Git 倉庫",

            "Please enter your credentials if required for cloning your remote repository.": "如果需要克隆遠程倉庫，請輸入您的憑據。",
            "Your username for your source repository": "源倉庫用戶名",
            "Your access token or password for your source repository": "源倉庫的訪問令牌或密碼",

            "Your new repository details": "新倉庫詳情",
            //"Owner": "所有者",
            // "Repository name": "倉庫名稱",
                // "is available.": "名稱可用。",
                //"The repository": "倉庫",
                //"already exists on this account.": "已經存在於此賬戶。",
                //"Your new repository will be created as": "您的新倉庫將被創建為",
            //"Public": "公共",
            //"Anyone on the internet can see this repository. You choose who can commit.": "任何人都可以看到這個倉庫，您可以選擇誰能提交。",
            //"Private": "私有",
            //"You choose who can see and commit to this repository.": "您可以選擇誰可以看和提交到該倉庫。",
            "Cancel": "取消",
            "Begin import": "開始導入",
            "Preparing import…": "準備導入…",
            "Importing commits and revision history to GitHub...": "導入提交和修訂歷史到 GitHub…",

        // 導入倉庫 第一頁 /<user-name>/<repo-name>/import
            "Import all the files, including the revision history, from another version control system.": "導入的所有文件，包括修訂歷史記錄，來自其他版本控制系統。",
            "Your old repository’s clone URL": "您舊倉庫的克隆地址",
            "supported VCS.": "VCS 的支持。",
            "Your existing repository": "您已存在的倉庫",
            "Change repository": "選擇倉庫",

        // 導入倉庫 第二頁 /<user-name>/<repo-name>/import
            "Your import will begin shortly...": "導入即將開始…",
            "Preparing your new repository": "準備您的新倉庫",
                "There is no need to keep this window open, we’ll email you when the import is done.": "無需保持此窗口，導入完成後我們會通過電子郵件通知您。",
                "There is no need to keep this window open. We'll email you when the import is done.": "無需保持此窗口，導入完成後我們會通過電子郵件通知您。",
            "Detecting your project’s version control system…": "正在檢測專案的版本控制系統…",
            "Importing commits and revision history…": "導入提交和修訂歷史…",
            // [/Updating branches and (\d) commit authors?…/, "更新分支和 $1 個提交者…"],
            "Optimizing repository and pushing commits to GitHub…": "優化倉庫並將提交推送到 GitHub…",
            "Importing complete! Your new repository": "導入完成！您的新倉庫",
            "is ready.": "已準備就緒。",

        // 複刻倉庫 /<user-name>/<repo-name>/fork
            "Create a new fork": "創建新複刻",
                "A": " ",
                "fork": "複刻",
                "is a copy of a repository. Forking a repository allows you to freely experiment with changes without affecting the original project.": "是一個倉庫的副本。複刻倉庫可以讓您在不影響原專案的情況下自由地進行修改實驗。",
                "View existing forks.": "查看現有複刻。",

            "No available destinations to fork this repository.": "沒有複刻此倉庫的可用目標。",
            "Creating fork…": "正在創建複刻…",

            // "Owners": "所有者",
                "Search owners": "搜索",
                "Choose an owner": "選擇所有者",
                    "(fork already exists)": "(複刻已存在)",
            // "Repository name": "倉庫名稱",

                // "The repository": "倉庫",
                // "already exists on this account.": "已經存在於此賬戶。",
                "Your new repository will be created as": "您的新倉庫將被創建為",
                    "The repository name can only contain ASCII letters, digits, and the characters": "倉庫名稱只能包含 ASCII 字母、數字和字符",

            "By default, forks are named the same as their upstream repository. You can customize the name to distinguish it further.": "默認情況下，複刻的名稱與他們的上游倉庫相同。您可以自定義名稱以進一步區分它。",

            "Copy the": "僅複製",
            "branch only": "分支",

            "Contribute back to": "回饋給",
            "by adding your own branch.": "通過添加您自己的分支。",

            "You are creating a fork in your personal account.": "您正在向您的個人賬戶中創建一個複刻。",
            "Create fork": "創建複刻",

        // 新版新建倉庫頁
            "Switch back to classic experience": "回到經典頁面",
            "Repositories contain a project's files and version history.": "倉庫包含專案的文件和版本歷史。",
            "Have a project elsewhere?": "在其他地方已有倉庫？",

            "General": "通常",
                "Great repository names are short and memorable. How about": "好的倉庫名稱應該簡單且容易記憶。這個怎麼樣：",

            "Configuration": "配置",
                "Choose visibility": "選擇可見性",
                    "Choose who can see and commit to this repository": "選擇誰可以查看並提交此倉庫",
                "Start with a template": "使用模板開始",
                    "Templates pre-configure your repository with files.": "模板會用文件預先配置您的倉庫。",
                "Add README": "添加自述文件",
                    "READMEs can be used as longer descriptions.": "自述文件可以用作更長的描述。",
                    "About READMEs": "關於自述文件",
                // gitignore
                    ".gitignore tells git which files not to track.": ".gitignore 告訴 git 不追蹤哪些文件。",
                    "About ignoring files": "關於忽略文件",

                    "Choose a .gitignore template": "選擇 .gitignore 模板",
                        "Search templates": "搜索模板",
                        "No .gitignore": "無",
                "Add license": "添加許可證",
                    "Licenses explain how others can use your code.": "許可證解釋其他人如何使用您的程式碼。",
                    "About licenses": "關於許可證",

                    "Search licenses": "選擇許可證",
                    "No license": "無",
                "Connect GitHub Apps": "連接 GitHub 應用",
                    "Connect this repository to apps": "將此倉庫連接到",
                    "is subscribed to": "訂閱的應用",

                    "Choose GitHub Apps": "選擇 GitHub 應用",
                    "Search apps": "搜索應用",
                    "Cancel and close": "關閉",

            "Jumpstart your project with Copilot (optional)": "用 Copilot 快速啟動您的專案（可選）",
                "Tell Copilot what you want to build in this repository. After creation, Copilot will open a pull request with generated files - such as a basic app, starter code, or other features you describe - then request your review when it's ready.": "告訴 Copilot 您想在此倉庫中構建什麼。在創建完成後，Copilot 會打開一個包含生成文件的拉取請求（例如基礎應用、起始程式碼或您描述的其他功能），然後在準備好後請求您進行審核。",
                "About Copilot coding agent": "關於 Copilot 編程智能體",

                "Prompt": "提示詞",
                    "Describe what you want Copilot to build": "描述您想讓 Copilot 做什麼",

    },
    "regexp": [ // 正則翻譯
        // [/([^ ]+) is available\./,"$1 名稱可用。"],
        [/You are creating a public repository in the ([^ ]+) organization./,"您正在 $1 組織中創建一個公共倉庫。"], // 創建組織的公共倉庫
        [/You are creating a private repository in the ([^ ]+) organization./,"您正在 $1 組織中創建一個私有倉庫。"], // 創建組織的私有倉庫
        // [/\(fork already exists\)/, "（複刻已存在）"], // 複刻頁面
        // [/\(repository already exists\)/, "（倉庫已存在）"], // 複刻頁面
        [/You are creating a fork in the ([^ ]+) organization./, "您正在 $1 組織中創建一個複刻。"], // 複刻頁面
        [/Updating branches and (\d+) commit authors?…/, "更新分支和 $1 個提交者…"], // 倉庫導入第二頁
        //[/Connect this repository to apps ([^ ]+) is subscribed to/, "將此倉庫連接到 $1 訂閱的應用程式"],
        [/Auto-installed by ([^ ]+)/, "由 $1 自動安裝"],
        [/(\d+) apps? selected/, "已選擇 $1 個應用"],
        [/The repository ([^ ]+) already exists on this account/, "倉庫 $1 已存在於此賬戶"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        // [/, and (\d+) more/, "，以及其他 $1 個組織"], // 用戶 浮動信息卡
        // [/(\d+) repositor(y|ies)/, "$1 個倉庫"], // 組織  浮動信息卡
        // [/(\d+) members?/, "$1 個成員"], // 組織  浮動信息卡
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "static": {
            "New repository": "新建倉庫",
            "Import repository": "導入倉庫",
        },
        "regexp": [
            [/Fork/, "複刻"],
        ],
    },
};
I18N["zh-TW"]["new"] = I18N["zh-TW"]["page-new-repo"];
I18N["zh-TW"]["new/import"] = I18N["zh-TW"]["page-new-repo"];
I18N["zh-TW"]["repository/import"] = I18N["zh-TW"]["page-new-repo"];
I18N["zh-TW"]["repository/fork"] = I18N["zh-TW"]["page-new-repo"];
I18N["zh-TW"]["orgs/repositories/new"] = I18N["zh-TW"]["page-new-repo"];

I18N["zh-TW"]["repository"] = { // 倉庫頁面 /<user-name>/<repo-name>/
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 頂部
            "Help us improve GitHub Codespaces": "幫助我們改進 GitHub 程式碼空間",
                "Tell us how to make GitHub Codespaces work better for you with three quick questions.": "通過三個簡單的問題告訴我們如何讓 GitHub 程式碼空間更適合您。",

            "Sorry, couldn’t delete that branch.": "抱歉，無法刪除此分支。",
            "Copilot will begin working on your prompt in a draft pull request, and will request review from you when ready.": "Copilot 將起草一個拉取請求開始處理您的需求，並在準備好後請求您進行審核。",

        // 程式碼標籤卡 & 倉庫首頁 /<user-name>/<repo-name>/ 和 /<user-name>/<repo-name>/tree/<branch>
            // [/Branch ([^ ]+) was renamed to ([^ ]+)./, "分支 $1 已更名為 $2。"],

            // 快捷鍵
                "Commands": "命令",
                "Clone repository: Copy HTTPS": "克隆倉庫：複製 HTTPS",
                "Clone repository: Copy SSH": "克隆倉庫：複製 SSH",
                "Clone repository: Copy GitHub CLI": "克隆倉庫：複製 GitHub CLI",
                "Copy file permalink": "複製文件永久鏈接",

            // 操作條
                "forked from": "複刻自",
                "Public repository · Forked from": "公共倉庫 · 複刻自", // Android UA 下出現
                "Public repository · Generated from": "公共倉庫 · 創建自", // 同上
                "Public archive repository": "公共存檔倉庫",
                "Public archive repository · Forked from": "公共存檔倉庫 · 複刻自",
                "generated from": "創建自",
                "mirrored from": "鏡像自",

                "Pin": "置頂",
                    "Pin this repository to your profile": "置頂此倉庫到您的個人資料",
                    "No pin slots remaining in your profile": "您的個人資料中沒有剩餘的置頂位",
                "Edit Pins": "編輯置頂",
                    "Pin to…": "置頂到…",
                    "Profile": "個人資料頁",
                        "Pin this to your personal profile, visible to everyone": "將此置頂到您的個人資料，對所有人可見",
                        "Limit reached": "已達上限",
                    // 組織倉庫
                    "Public pins in this organization": "該組織的公共置頂",
                        "Visible to anyone": "對任何人可見",
                    "Private pins in this organization": "該組織的私有置頂",
                        "Visible to members only": "僅對成員可見",
                "Unpin": "取消置頂",

                "Ignoring": "忽略",
                "Stop ignoring": "取消忽略",
                "Watch": "關注",
                "Unwatch": "取消關注",

                "Star": "星標",
                "Unstar": "已加星標",
                "Fork": "複刻",
                "Unfork": "取消複刻",

                "Sponsor": "贊助",
                // 贊助對話框
                // [/Sponsor ([^ ]+)?/, "贊助 $1"], // 贊助按鈕 對話框 標題
                "External links": "外部鏈接",
                "Learn more about funding links in repositories": "瞭解更多關於倉庫中的贊助鏈接的信息",
                "Report abuse": "舉報濫用",

                // 提交欄 GitHub Action
                "All checks have passed": "已通過所有檢查",


                // 關注 & 訂閱通知設置 下拉菜單
                "Notification settings": "通知設置", //小屏模式
                "Subscribe to events for": "訂閱事件",
                "Notifications": "通知類型",
                "Participating and @mentions": "參與和 @您",
                    "Only receive notifications from this repository when participating or @mentioned.": "僅在參與或 @您 時接收來自此倉庫的通知。",
                "All Activity": "所有活動",
                    "Notified of all notifications on this repository.": "接收來自此倉庫所有通知。",
                "Ignore": "忽略",
                    "Never be notified.": "永不接收通知。",
                "Custom": "自定義",
                    "Select events you want to be notified of in addition to participating and @mentions.": "選擇除參與和 @您 之外還要接收通知的事件。",
                "Get push notifications on": "要獲取推送通知，使用",
                "Releases": "發行版",
                    //"Issues are not enabled for this repository": "此倉庫未啟用議題功能",
                "Discussions": "討論",
                    //"Discussions are not enabled for this repository": "該倉庫未啟用討論功能",
                    //"Discussions are not enabled for this repo": "此倉庫未啟用討論功能",
                    "are not enabled for this repository": "功能未啟用",
                "Security alerts": "安全警報",
                //"Cancel": "取消",
                "Apply": "應用",

                // 複刻下拉
                "Cannot fork because repository is empty.": "無法複刻，因為倉庫是空的。",
                "Cannot fork because you own this repository and are not a member of any organizations.": "不能複刻，因為您擁有該倉庫，而且不是任何組織的成員。",
                "Existing forks": "現有的複刻",
                "You don't have any forks of this repository.": "您沒有此倉庫的任何複刻。",
                "Create a new fork": "創建複刻",

                //
                "Star this repository": "標星倉庫", //小屏模式
                "Unstar this repository": "取消倉庫星標", //小屏模式

            // 倉庫主頁 分支保護
                // [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保護"], // 倉庫主頁 分支保護
                "Your": "您的",
                "branch isn't protected": "分支不受保護", // 新版倉庫概述
                "Protect this branch from force pushing or deletion, or require status checks before merging.": "保護此分支免受強制推送或刪除，或在合併前要求狀態檢查。",
                "View documentation.": "查看文檔",
                "Protect this branch": "保護該分支",
                "Dismiss": "忽略",

            // 倉庫主頁 Dependabot 警告框
                "We found potential security vulnerabilities in your dependencies.": "我們在您的依賴項中發現了潛在的安全漏洞。",
                "Only the owner of this repository can see this message.": "僅此倉庫的所有者可以看到此消息。",
                "See Dependabot alerts": "查看 Dependabot 警報",

            // 空倉庫
                "This repository is empty.": "此倉庫是空的。",
                "Care to check out the": "是否願意查看",
                "GitHub Channel on YouTube": "YouTube 上的 GitHub 頻道",
                "while you wait?": "在您等待的時候？",

            // 已上架的 GitHub Action 專案
                "Use this GitHub action with your project": "將此 GitHub Actions 用於您的專案",
                "Add this Action to an existing workflow or create a new one": "將此操作添加到現有工作流程或創建新工作流程",
                "View on Marketplace": "去市場查看",

            // 未上架的 GitHub Action 專案
                "You can publish this Action to the GitHub Marketplace": "您可以將此 Action 發佈到 GitHub 市場",
                "Draft a release": "起草發佈",

            // 訪問已刪除的分支
            "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "這個提交不屬於本倉庫的任何分支，可能屬於倉庫以外的分支。",

            // 最近有了新提交提醒
            // [/had recent pushes less than/, "有了最近的推送，不到"], //最近有了新提交提醒
            // [/had recent pushes/, "有了最近的推送，"], //最近有了新提交提醒

            "Navigate back to": "導航回", // 小屏模式

            // 左側正文

            // 文檔欄目(僅 Andoid UA)
            "Menu": "菜單",

            // 自述文件(README.md)
            "Filter headings": "篩選標題",
            "Edit file": "編輯文件",

            // 默認分支被重命名提醒框
                "The default branch has been renamed!": "默認分支已重命名!",
                "is now named": "已重命名為",
                "If you have a local clone, you can update it by running the following commands.": "如果您有一個本地克隆，您可以通過運行以下命令來更新它。",
                "OK, got it": "好的，我知道了！",

                // 上游倉庫分支重命名
                    "The default branch on the parent repository has been renamed!": "上游倉庫默認分支已被重新命名!",
                    "renamed its default branch": "默認分支重命名為",
                    "You can rename this fork's default branch to match in": "您可以重命名此複刻默認分支以匹配，在",
                    "branch settings": "分支設置",

            "branch": "分支",
            "branches": "分支",
            "tag": "標籤",
            "tags": "標籤",

            "Go to file": "轉到文件",
                "No matches found": "未找到匹配項",
                "Go to folder": "轉到文件夾",
                "See all results": "查看所有結果",
            "Add file": "添加文件",
                // 添加文件 下拉菜單
                "Create new file": "新建文件",
                "Upload files": "上傳文件",
                "Upload file": "上傳文件", // Android UA

            // 程式碼 下拉菜單
                "Local": "本地",
                    "Clone": "克隆",
                        // HTTPS
                        "Clone using the web URL.": "使用 Web URL 克隆。",
                        // SSH
                        "You don't have any public SSH keys in your GitHub account.": "您的 GitHub 賬戶中沒有任何公共 SSH 密鑰。",
                        "You can": "您可以",
                        "add a new public key": "添加新的公共密鑰",
                        ", or try cloning this repository via HTTPS.": "，或嘗試通過 HTTPS 克隆此倉庫。",

                        "Use a password-protected SSH key.": "使用受密碼保護的 SSH 密鑰。",
                        // GitHub CLI
                        "Work fast with our official CLI.": "使用我們的官方 CLI 快速工作。",
                        "Learn more about the CLI": "瞭解更多關於 CLI 的信息",

                    "Open with GitHub Desktop": "在 GitHub Desktop 中打開",
                        "Launching GitHub Desktop": "GitHub Desktop 啟動中",
                            "If nothing happens,": "如果沒有響應",
                            "download GitHub Desktop": "下載 GitHub Desktop",
                            "and try again.": "並重試",
                    "Open with Visual Studio": "在 Visual Studio 中打開",
                    "Download ZIP": "下載 ZIP 壓縮包",

                    "Code 55% faster with AI pair programming.": "與 AI 一起編程，寫程式碼速度提高55%。",
                        "Start my free trial": "開始我的免費試用",
                        "Don't show again": "不再顯示",

                    "Which remote URL should I use?": "我應該使用哪個遠程 URL ?",
                    "Copy url to clipboard": "複製鏈接到剪貼板",
                    // "Copy to clipboard": "複製到剪切板",
                    // "Copied!": "✅ 複製成功!",

                // 程式碼空間
                    // 維護提示
                        "Codespaces is undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "程式碼空間正在維護。在此期間，用戶可能會遇到連接問題。更多詳情請訪問",
                        "Codespaces will be undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "程式碼空間將進行維護。在此期間，用戶可能會遇到連接問題。更多詳情請訪問",
                        "this announcement": "此公告",
                    "Your workspaces in the cloud": "您在雲端的工作空間",
                    //[/Create a codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
                    "Codespace repository configuration": "程式碼空間倉庫配置",
                        "New with options...": "新建（選項）…",
                        "Configure dev container": "配置開發容器",
                        "Set up prebuilds": "設置預構建",
                        "Manage codespaces": "管理程式碼空間",
                        "Share a deep link": "分享深度鏈接",
                            "Share codespace configuration": "共享程式碼空間配置",
                            "Choose which settings from this configuration to include when sharing": "選擇共享時要包含此配置中的哪些設置",
                            "Quick start": "快速開始",
                            "Automatically create or reuse the most recent matching codespace.": "自動創建或使用最新匹配的程式碼空間。",
                            "Read more about creating a link.": "閱讀有關創建鏈接的更多信息。",
                            "Snippets": "片段",
                            "Use the following snippets to embed an “Open in Codespaces” button for this configuration in your own page or README.": "使用以下程式碼片段在您自己的頁面或 README 中嵌入此配置的 “在 Codespaces 中打開” 按鈕。",
                        "What are codespaces?": "什麼是程式碼空間？",
                    "No codespaces": "尚無程式碼空間",
                    "You don't have any codespaces with this repository checked out": "您沒有檢出此倉庫的任何程式碼空間",
                    "Opening in codespace": "正在打開程式碼空間",
                    //[/Create codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
                    "Learn more about codespaces...": "瞭解更多關於程式碼空間的信息…",
                    "Codespace usage for this repository is paid for by": "該倉庫的程式碼空間使用費由以下人員支付",

                    "On current branch": "在當前分支",
                        "No codespaces on current branch": "當前分支上沒有程式碼空間",
                    "On other branches": "在其他分支",
                    "miniature adventure": "迷你探險",
                    "Open miniature adventure in web": "在網絡中打開迷你探險",
                    "Active": "激活",
                        "Open in ...": "打開…",
                            "Open in browser": "在瀏覽器中打開",
                            "Open in Visual Studio Code": "在 Visual Studio Code 中打開",
                            "Open in JetBrains Gateway": "在 JetBrains Gateway 中打開",
                            "Open in JupyterLab": "在 JupyterLab 中打開",
                        "Rename": "重命名",
                            "Change codespace display name to...": "將程式碼空間顯示名稱更改為…",
                        "Export changes to a branch": "將更改導出到分支",
                            "This will create a new branch with any unpushed changes": "這將創建一個包含任何未推送更改的新分支",
                            "Create branch": "創建分支",
                        "Change machine type": "更改機器類型",
                            "Change codespace machine type": "更改程式碼空間機器類型",
                            "Machine type": "機器類型",
                                "2-core": "雙核",
                                "4-core": "四核",
                            "Need even more power?": "需要更多的力量？",
                            "Contact our team": "聯繫我們團隊",
                            "to enable 32-core or GPU machines.": "啟用 32 核或 GPU 機器。",
                            "Update codespace": "升級程式碼空間",
                        "Stop codespace": "停止程式碼空間",
                    "Show more actions for codespace": "顯示程式碼空間的更多操作",
                        "Open in Browser": "在瀏覽器中打開",
                        "Open in Visual Studio Code": "在 Visual Studio Code 中打開",
                        "Open in JetBrains Gateway": "在 JetBrains Gateway 中打開",
                        "Open in JupyterLab": "在 JupyterLab 中打開",
                        "Rename": "重命名",
                            "Rename codespace": "重命名程式碼空間",
                            "Name": "名稱",
                        "Auto-delete codespace": "自動刪除程式碼空間",
                        "Export changes to a branch": "將更改導出到分支",
                            "This will create a new branch with any unpushed changes": "這將創建一個包含任何未推送更改的新分支",
                            "Checking branch status": "檢查分支情況",
                            "Create branch": "創建分支",
                        "Export changes to a fork": "將更改導出到複刻",
                            "You do not have write access to this codespace's repository. This will create a new fork of the repository at": "您沒有對此程式碼空間的倉庫的寫訪問權限。這將創建一個新的倉庫分支在",
                            ", reassign your codespace to that fork, and export your changes to a new branch.": "，將程式碼空間重新分配給該複刻，並將更改導出到新分支。",
                            "Create fork": "創建複刻",
                        "Change machine type": "修改機器類型",
                            "Change codespace machine type": "修改程式碼空間機器類型",
                            "Update codespace": "更新程式碼空間",
                        "Stop codespace": "停止程式碼空間",
                    "No changes": "未更改",
                    "Uncommitted changes": "未提交更改",

                    "You seem to have a billing issue. Please adjust your billing settings to continue using codespaces.": "您似乎遇到了賬單問題。請調整您的賬單設置以繼續使用程式碼空間。",

                    // 刪除對話框
                        "Are you sure?": "您確定嗎？",

                // Copilot
                    "Describe a task...": "描述任務…",
                    "Start task": "開始任務",

                    // [/Codespace \"(.+)\" stopped./, "程式碼空間 “$1” 已停止。"],
                    // [/Codespace \"(.+)\" deleted./, "程式碼空間 “$1” 已刪除。"],
                    // [/Are you sure you want to delete (.+)\?/, "您確定要刪除 $1 嗎？"],


            "Use this template": "使用此模板",
                "Create a new repository": "新建倉庫",
                "Open in a codespace": "在程式碼空間中打開",

            // 個人倉庫 當前分支狀態
            "This branch is": "該分支",
            "ahead of": "領先於", // 新版倉庫概述
            "behind": "落後", // 新版倉庫概述
            "This branch is up to date with": "該分支保持同步與", // 新版倉庫概述

            "Contribute": "貢獻",
                // 貢獻按鈕下拉菜單
                "This branch is not ahead of the upstream": "這個分支不領先於上游",
                "No new commits yet. Enjoy your day!": "尚無新提交。祝您愉快！",
                "Open a pull request to contribute your changes upstream.": "打開拉取請求以向上遊貢獻您的更改。",
                "This branch is not behind the upstream": "這個分支不落後於上游",
                "Open pull request": "打開拉取請求",

            "Sync fork": "同步複刻",
                // 同步複刻按鈕下拉菜單
                "This branch is out-of-date": "此分支已過時",
                "Update branch to merge the latest changes from the upstream repository into this branch.": "更新分支，將上游倉庫的最新修改合併到本分支。",
                // [/Update branch to keep this branch up-to-date by syncing (\d+) commits? from the upstream repository./, "通過從上游倉庫同步 $1 個提交來更新分支，以使該分支保持最新。"], // 同步複刻
                "Update branch to keep this branch up-to-date by syncing": "更新分支以保持該分支與最新狀態同步，需要同步",
                "from the upstream repository.": "來自上游倉庫。",
                "Learn more about syncing a fork": "瞭解更多關於複刻同步的信息",
                // [/This branch is not behind the upstream ([^ ]+)/, "該分支不落後與上游 $1"], // 同步複刻
                "No new commits to fetch. Enjoy your day!": "尚無新提交。祝您愉快！", //相同
                "Compare": "對比",
                "Update branch": "更新分支",

                "This branch has conflicts that must be resolved": "該分支有必須解決的衝突",
                // [/Discard (\d+) commits? to make this branch match the upstream repository. (\d+)commits? will be removed from this branch./, "丟棄 $1 個提交，以使本分支與上游倉庫一致。$2 個提交將從本分支中刪除。"],
                "Discard": "丟棄", // 新版倉庫概述
                "to make this branch match the upstream repository.": "，以使本分支與上游倉庫一致。", // 新版倉庫概述
                "will be removed from this branch.": "將從本分支中刪除。", // 新版倉庫概述
                "You can resolve merge conflicts using the command line and a text editor.": "您可以使用命令行和文本編輯器解決合併衝突。",
                // [/Discard (\d+) commits?/, "丟棄 $1 個提交"],
                "Discarding changes...": "放棄更改…",

                // 頂部提醒
                    // [/Successfully fetched and merged from upstream ([^ ]+)/, "成功從上游 $1 獲取並合併。"],

            // "Choose a head ref": "選擇一個頭引用",

            // "There isn’t anything to compare.": "沒有什麼可比較的。",
            // "and": "和",
            // "are entirely different commit histories.": "是完全不同的提交歷史。",
            // "No commit comments for this range": "在此範圍內沒有提交評論",
            // "No new commits yet. enjoy your day!": "尚無新提交。祝您愉快！",
            // "Find a branch": "查找分支",

            // 正文
            "commit": "次提交",
            "commits": "次提交",
            "failure": "失敗",
            "success": "成功",
            "Approved": "已批准",
            // [/([\d,]+) Commits?/, "$1 次提交"], // 新版倉庫概述
            "Open commit details": "打開提交詳細信息", // TODO: 修復該詞條翻譯不生效問題

            "Failed to load latest commit information.": "載入最新提交信息失敗。",

            "View code": "查看程式碼", //小屏模式

            // 倉庫缺失 README 提醒
            "Help people interested in this repository understand your project by adding a README.": "通過添加 README，幫助對此倉庫感興趣的人瞭解您的專案。",
            "Help people interested in this repository understand your project.": "幫助對此倉庫感興趣的人瞭解您的專案。",
            "Add a README": "添加 README",

            // 右側欄

            // 與用戶名同名倉庫 編輯 README
            "is a special repository.": "是一個特殊的倉庫。",
            "Its": "它的",
            "will appear on your public profile.": "將出現在您的公開個人資料中。",
            "Edit README": "編輯 README",
            "Visit profile": "查看資料",

            "is special. If you": "是特殊的。如果您",
            "make this a public repository": "將倉庫設置為公開",
            ", its": "，它的",
            "Go to Settings": "前往設置",

            // 組織下.github 倉庫 README
                "is a special repository. Create a": "是一個特殊的倉庫。創建",
                "and it will appear on the organization's profile!": "並將出現在該組織資料中!",
                "Add profile README": "添加 profile/README",

                "is a special repository.": "是一個特殊的倉庫。",
                "will appear on the organization's profile.": "將出現在該組織資料中。",

            // 組織下.github-private 倉庫 README
                "Add a README with an overview of your project.": "為您專案添加一個概述 README 文件。",
                "The": " ",
                // [/will appear on ([^ ]+)'s member profile, visible only to organization members./, "將出現在 $1 的成員資料中，僅對組織成員可見。"],

            // "About": "關於"，
            "No description, website, or topics provided.": "未提供描述、網站或主題。",
            "Readme": "自述文件",
            "README": "自述文件",
            "Contributing": "貢獻指南",
            "View license": "查看許可證",
                "GPL-3.0 license": "GPL-3.0 許可證",
                "AGPL-3.0 license": "AGPL-3.0 許可證",
                "LGPL-3.0 license": "LGPL-3.0 許可證",
                "MIT license": "MIT 許可證",
                "Apache-2.0 license": "Apache-2.0 許可證",
                "OFL-1.1 license": "OFL-1.1 許可證",
                "0BSD license": "0BSD 許可證",
                "BSD-3-Clause license": "BSD-3-Clause 許可證",
                "CC0-1.0 license": "CC0-1.0 許可證",
                "WTFPL license": "WTFPL 許可證",
                "Unknown": "未知",
            "Code of conduct": "行為準則",
            "Security policy": "安全政策",
            "Cite this repository": "引用此倉庫",
                "If you use this software in your work, please cite it using the following metadata.": "如果您使用此軟體，請使用以下元數據進行引用。",
                "Learn more about CITATION files.": "瞭解更多關於引用文件的信息。",
                "View citation file": "查看引用文件",
            "Activity": "活動",
            "Custom properties": "自定義屬性",
            "star": "星標",
            "stars": "星標",
            "watching": "關注",
            "fork": "複刻",
            "forks": "複刻",
            "Report repository": "舉報倉庫",
            "Public repository": "公共倉庫", //小屏模式
            "Private repository": "私有倉庫", //小屏模式


            // 倉庫描述編輯 對話框
            "Edit repository details": "編輯倉庫簡述",
            "Description": "描述",
            "Short description of this repository": "簡短的描述下您的倉庫",
            "Website": "網址",
            "Enter a valid URL": "請輸入有效的 URL",
            "Use your GitHub Pages website": "使用您的 GitHub Pages 站點",
            "Topics": "主題",
            "(separate with spaces)": "（空格分隔）",
            "Suggested:": "建議：",
                "Add this topic": "接受該建議",
                "Decline this topic": "拒絕該建議",
                    "This isn’t relevant": "這並不相關",
                    "This is too specific": "這太具體了",
                    "This is too general": "這太籠統了",
                    "I just don’t like it": "我只是不喜歡它",
            "Include in the home page": "包含在主頁中",

                // 頂部提醒
                "Your repository details have been saved.": "您的倉庫簡述已保存。",

            "Releases": "發行版",
                "No releases published": "未發佈任何版本",
                "Latest": "最新",
                "Create a new release": "創建發行版",
            // "Packages": "軟體包",
                "No packages published": "未發佈軟體包",
                "Publish your first package": "發佈軟體包",
            "Sponsor this project": "贊助本專案",
                "Learn more about GitHub Sponsors": "瞭解更多關於 GitHub 贊助者的信息",
            "Used by": "使用者",
            "Contributors": "貢獻者",
            "Environments": "環境",
            "Deployments": "部署",
                "+ more deployments": "+ 更多部署",
            "Languages": "語言",

            // "branch": "分支",
            // "branches": "分支",
            // "release": "次發佈",
            // "releases": "次發佈",
            // "contributor": "個貢獻者",
            // "contributors": "個貢獻者",

        // 新版倉庫概述
            // /<user-name>/<repo-name>#coc
                "Add a code of conduct": "添加行為準則",
                "Define community standards, signal a welcoming and inclusive project, and outline procedures for handling abuse by adding a code of conduct.": "通過添加行為準則，明確社區標準，體現專案的歡迎和包容性，並概述處理濫用行為的程式。",

            // /<user-name>/<repo-name>#license
                "License": "許可證",
                "Add a license": "添加許可證",
                "Add a license to your repository to make it clear how others can use, change, and contribute to your project.": "向倉庫中添加許可證，以明確其他人可以如何使用、更改您的專案並為您的專案做出貢獻。",

            // /<user-name>/<repo-name>#security
                "Add a security policy": "添加安全策略",
                "Help your community understand how to securely report security vulnerabilities for your project.": "幫助您的社區瞭解如何安全地報告專案的安全漏洞。",

        // Action 倉庫 右側欄
            "Suggested workflows": "建議的工作流程",
            "Based on your tech stack": "基於您的技術堆棧",
            "Set up": "設立",
            "Configure": "設置",
            "More workflows": "更多工作流程",
            "Dismiss suggestions": "隱藏建議",

        // 倉庫複刻中...
            // [/Forking ([^ ]+)/, "複刻 $1 中"], // 複刻中...
            "Generating your repository...": "正在創建您的倉庫…",
            "It should only take a few seconds.": "應該只需要幾秒鐘的時間。",
            "Refresh": "刷新",

        // 初始化空倉庫 /<user-name>/<repo-name>/
            "Start coding with Codespaces": "使用程式碼空間開始編程",
                "Add a README file and start coding in a secure, configurable, and dedicated development environment.": "添加 README 文件並在安全、可配置和專用的開發環境中開始編碼。",
                "Create a codespace": "創建程式碼空間",
            // 組織倉庫
            "Set up GitHub Copilot": "設置 GitHub Copilot",
                "Use GitHub's AI pair programmer to autocomplete suggestions as you code.": "使用 GitHub 的 AI 配對程式員在您編碼時自動完成建議。",
                "Get started with GitHub Copilot": "開始使用 GitHub Copilot",
            "Add collaborators to this repository": "將協作者添加到此倉庫",
                "Search for people using their GitHub username or email address.": "使用 GitHub 用戶名或電子郵件地址搜索人員。",
                "Invite collaborators": "邀請協作者",
            "Quick setup": "快速安裝",
            "— if you’ve done this kind of thing before": "- 如果您以前做過這樣的事",
            "Set up in Desktop": "安裝到 GitHub Desktop",
            "Get started by": "通過",
            "creating a new file": "創建一個新文件",
            "uploading an existing file": "上傳一個現有的文件",
            ". We recommend every repository include a": "來開始。我們推薦每個倉庫都包括",
            ", and": "，和",
            "…or create a new repository on the command line": "…或在命令行上創建一個新的倉庫",
            "…or push an existing repository from the command line": "…或從命令行中推送現有的倉庫",
            "…or import code from another repository": "…或從另一個倉庫導入程式碼",
            "You can initialize this repository with code from a Subversion, Mercurial, or TFS project.": "您可以初始化此倉庫從一個 Subversion，Mercurial 或 TFS 專案導入。",
            "Import code": "導入程式碼",
            "ProTip!": "專業提示！",
                "Use the URL for this page when adding GitHub as a remote.": "將 GitHub 添加為遠程時，請使用此頁面上的 URL。",

        // 文件管理器 /<user-name>/<repo-name>/tree/<branch>/<文件夾路徑>/
          // /<user-name>/<repo-name>/?search=1
          // /<user-name>/<repo-name>/tree/?search=1
            // 文件樹側邊欄
                "Expand file tree": "展開文件樹",
                "Collapse file tree": "摺疊文件樹",
                "Search this repository": "搜索此倉庫",

                // 搜索框
                    "Go to file": "轉到文件",
                        "No matches found": "未找到匹配項",
                        "Go to folder": "轉到文件夾",
                        "See all results": "查看所有結果",

            "Add file": "添加文件",
                // 添加文件 下拉菜單
                "Create new file": "新建文件",
                "Upload files": "上傳文件",

            // 新三個點
                "Copy path": "複製路徑",
                "Copy permalink": "複製永久鏈接",
                "Delete directory": "刪除文件夾",
                "View options": "查看選項",
                    "Center content": "核心內容",

            "Copied path!": "✅ 路徑已複製！",

            "History": "歷史",

            "Top": "頂部",
            "Jump to file": "跳轉到文件",

            "Name": "文件名",
            "Last commit message": "最後提交消息",
            "Last commit date": "最後提交時間",

            // 編輯按鈕
            "Edit README": "編輯 README", // md 文件

        // 文件管理器 - 議題模板 /<user-name>/<repo-name>/tree/<branch>/.github/ISSUE_TEMPLATE
            "Customize the issue creation experience with a": "自定義議題的創建模板使用一個",
            "file.": "文件。",
            "Learn more about configuring a template chooser.": "瞭解更多關於配置模板選擇器的信息。",

    },
    "regexp": [ // 正則翻譯
        // 個人倉庫 貢獻和同步複刻操作後 信息提示條
        [/Successfully fetched and fast-forwarded from upstream ([^ ]+)\./, "成功從上游 $1 中獲取並快速轉發。"],
        [/Successfully discarded changes and synchronized branch to match upstream ([^ ]+)\./, "成功丟棄更改，並將分支與上游 $1 保持同步。"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/commits by (.+)/, "由 $1 提交"],
        [/Signed-off-by: (.*)/, "簽字人：$1"], // TODO: 修復該詞條翻譯不生效問題
        [/Branch ([^ ]+) was renamed to ([^ ]+)./, "分支 $1 已更名為 $2。"],
        [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保護"], // 倉庫主頁 分支保護
        [/([\d,]+) Commits?/, "$1 次提交"], // 新版倉庫概述
        [/Create a codespace on (.+)/, "在 $1 上創建程式碼空間"], // 倉庫主頁 創建程式碼空間
        [/Create codespace on (.+)/, "在 $1 上創建程式碼空間"],
        [/Codespace \"(.+)\" stopped./, "程式碼空間 “$1” 已停止。"],
        [/Codespace \"(.+)\" deleted./, "程式碼空間 “$1” 已刪除。"],
        [/Are you sure you want to delete (.+)\?/, "您確定要刪除 $1 嗎？"],
        [/Sponsor ([^ ]+)?/, "贊助 $1"], // 贊助按鈕 對話框 標題
        [/\+ ([\d,]+) releases?/, "+ $1 個發行版"], // 倉庫首頁右側欄 發行版
        [/\+ ([\d,]+) packages?/, "+ $1 個軟體包"], // 倉庫首頁右側欄 軟體包
        [/\+ ([\d,]+) contributors?/, "+ $1 位貢獻者"], // 倉庫首頁右側欄 貢獻者
        [/\+ ([\d,]+) environments?/, "+ $1 個環境"], // 倉庫首頁右側欄 環境
        [/\+ ([\d,]+) deployments?/, "+ $1 個部署"], // 倉庫首頁右側欄 部署
        // 同步複刻
        [/Update branch to keep this branch up-to-date by syncing (\d+) commits? from the upstream repository./, "通過從上游倉庫同步 $1 個提交來更新分支，以使該分支保持最新。"],
        [/This branch is not behind the upstream ([^ ]+)/, "該分支不落後與上游 $1"],
        [/Discard (\d+) commits? to make this branch match the upstream repository. (\d+) commits? will be removed from this branch./, "丟棄 $1 個提交，以使本分支與上游倉庫一致。$2 個提交將從本分支中刪除。"],
        [/Discard (\d+) commits?/, "丟棄 $1 個提交"],
        [/Successfully fetched and merged from upstream ([^ ]+)/, "成功從上游 $1 獲取並合併。"],
        // 貢獻
        [/This branch is not ahead of the upstream ([^ ]+)\./, "該分支並不領先上游 $1。"],
        [/This branch is (\d+) commits? ahead of ([^ ]+)\./, "該分支領先上游 $2 $1個提交。"],
        // 個人倉庫當前分支狀態
        [/This branch is up to date with ([^ ]+)\./, "該分支與上游 $1 保持同步。"],
        [/(\d+) commits? ahead/, "領先 $1 個提交"],
        [/(\d+) commits? behind/, "落後 $1 個提交"],
        [/(\d+) commits?/, "$1 個提交"], // 新版倉庫概述
        [/Save (.+?) to your computer and use it in GitHub Desktop./, "使用 GitHub Desktop，保存 $1 到您的電腦。"],
        [/Forking ([^ ]+)/, "複刻 $1 中"], // 複刻中...
        [/Fork your own copy of ([^ ]+)/, "複刻成您自己的 $1 副本"], // 複刻按鈕提示
        [/will appear on ([^ ]+)'s member profile, visible only to organization members./, "將出現在 $1 的成員資料中，僅對組織成員可見。"],
        [/and ([^ ]+) were installed on this repository/, "和 $1 已安裝到此倉庫"], // 頂部提示：市場應用（如果有）
        [/([^ ]+) and (\d+) other licenses found/, function(all, lic, num){
            var licKey = {'Unknown': '未知'};
            return licKey[lic] + '和另外' + num + '個許可證';
        }],
        [/First (\d+) files? shown./, "顯示前 $1 個文件。"],
        [/Copy \"(.+)\" to clipboard/, "複製“$1”到剪切板"],
        // 程式碼 -> 程式碼空間
        [/(\d+) changes?/, "$1 個更改"],
        [/(.+) has unpushed changes, are you sure you want to delete\?/, "$1 有未提交更改，您確定要刪除嗎？"],
    ],
    "title": {
        "regexp": [
            [/(.+) at (.+?) · (.+)/, "$1 在分支 $2 · $3"],
            [/(.+) at (.+)/, "$1 在分支 $2"],
        ],
    },
};
I18N["zh-TW"]["repository/tree"] = I18N["zh-TW"]["repository"];

I18N["zh-TW"]["repository/milestones"] = { // 倉庫 - 里程碑頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 里程碑頁面 /<user-name>/<repo-name>/milestones
            "Labels": "標籤",
            "Milestones": "里程碑",

            "You haven’t created any Milestones.": "您尚未創建任何里程碑。",
            "Use Milestones to create collections of Issues and Pull Requests for a particular release or project.": "使用里程碑為特定版本或專案創建議題和拉取請求的集合。",

            // 組織 倉庫 里程碑
            "No Milestones found!": "沒有發現里程碑!",
            "If this project had milestones, we’d show you them here. Promise!": "如果該專案有里程碑，我們會在此處向您展示。",

            "Create a Milestone": "創建里程碑",

            "Sort": "排序",
            "Sort by": "排序",
                "Recently updated": "最近更新",
                "Furthest due date": "最遲到期日",
                "Closest due date": "最近到期日",
                "Least complete": "最不完整",
                "Most complete": "最完整",
                "Alphabetical": "按字母順序",
                "Reverse alphabetical": "按字母倒序",
                "Most issues": "最多的議題",
                "Fewest issues": "最少的議題",

            "No due date": "沒有截止日期",
            "issues closed": "議題關閉",
            // [/Due by (.*)/, "截止日期 $1"], // 里程碑截止日期
            "Last updated": "最後更新",
            "(more)": "（更多）",
            // 完成進度條
            "complete": "已完成",
            "open": "打開",
            "closed": "關閉",

        // 新建里程碑頁面 /<user-name>/<repo-name>/milestones/new
            "New milestone": "新建里程牌",
                "Create a new milestone to help organize your issues and pull requests. Learn more about": "創建一個新的里程碑來幫助組織您的議題和拉取請求。瞭解更多關於",
                "milestones and issues": "里程碑和議題",
            "Title": "標題",
            "Due date (optional)": "截止日期（可選）",
            "Description": "描述",
            "Create milestone": "創建里程碑",

        // 單個里程碑頁 /<user-name>/<repo-name>/milestones
            "opened": "打開於",
            "was closed": "關閉於",

            "There are no open issues in this milestone": "此里程碑沒有打開議題",
            "Add issues to milestones to help organize your work for a particular release or project. Find and add": "將議題添加到里程碑，有助於為特定的版本或專案組織您的工作。在此倉庫中查找並添加",
            "issues with no milestones": "沒有里程碑的議題。",
            "in this repo.": " ",

            "There are no closed issues in this milestone": "此里程碑沒有已關閉議題",
            "Issues will automatically be moved here when they are closed.": "議題在關閉後會自動移到這裡。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/([\d,]+) Open/, "$1 打開"],
        [/([\d,]+) Closed/, "$1 已關閉"],
        [/(\d+\%) completed/, "$1 已完成"],
    ],
};

I18N["zh-TW"]["repository/milestone"] = I18N["zh-TW"]["repository/milestones"]; // 倉庫 - 某里程碑

I18N["zh-TW"]["repository/pull_issue_public"] = { // 倉庫 - 議題和拉取請求頁面公共部分
    "static": { // 靜態翻譯
        // pull 與 request 公共詞條
            "Filters": "篩選",
                // 篩選下拉菜單
                "Filter Issues": "篩選議題",
                "Open issues and pull requests": "打開的議題和拉取請求",
                "Your issues": "您提出的議題",
                "Your pull requests": "您的拉取請求",
                "Everything assigned to you": "任何分配給您的",
                "Everything mentioning you": "任何提及您的",
                "View advanced search syntax": "查看高級搜索語法",

            "Search all issues": "搜索所有議題",
            "Clear current search query, filters, and sorts": "清除當前的搜索查詢、篩選器和排序方式",

            "ProTip!": "專業提示！",
                "Find everything you created by searching": "通過搜索查找您創建的所有內容：",
                "Exclude your own issues with": "排除您自己創建的議題：",
                "Mix and match filters to narrow down what you’re looking for.": "通過混合和匹配篩選器以縮小查找範圍。",
                "Exclude everything labeled": "排除所有標有",
                "with": "標籤的內容，使用：",
                "Follow long discussions with": "要跟進長討論，請使用：",
                "on any issue or pull request to go back to the pull request listing page.": "在任何議題或拉取請求上使用以返回拉取請求列表頁面。",
                "Filter pull requests by the default branch with": "通過默認分支過濾拉取請求：",
                "to see everything that’s not assigned.": "以查看所有未分配的內容。",
                "Find all pull requests that aren't related to any open issues with": "查找所有未關聯任何打開議題的拉取請求，使用：",
                "Add comments to specific lines under": "在以下特定行添加註釋：",
                "will show everything without a milestone.": "將顯示所有沒有里程碑的內容。",
                "Updated in the last three days:": "最近 3 天更新：",
                "Notify someone on an issue with a mention, like:": "在議題中通過 @ 提及通知某人，例如：",
                "Adding": "添加",
                "will show everything without a label.": "將顯示所有無標籤的內容。",
                "on any issue or pull request to go back to the issue listing page.": "在任何議題或拉取請求上使用以返回議題列表頁面。",
                "Click a checkbox on the left to edit multiple issues at once.": "單擊左側複選框即可同時編輯多個議題。",
                // [/Ears burning? Get @([^ ]+) mentions with/, "耳朵要炸了？如果只需要查看提及了 $1 的內容，請使用"]


            "Labels": "標籤",
                "No labels": "無標籤",
            "Milestones": "里程碑",
            "New issue": "創建議題",
            "New": "創建", // 小屏

            // 篩選工作條
            // "Author": "作者",
                "Filter by author": "按用戶篩選",
                "Filter users": "篩選用戶名",

            "Label": "標籤",
                "Filter by label": "按標籤篩選",
                "Filter labels": "篩選標籤",
                "Unlabeled": "無標籤",
                "to exclude labels": "排除標籤",
                "for logical OR": "表示邏輯“或”",

            // "Projects": "專案",
                "Filter by project": "按專案篩選",
                "Filter projects": "篩選專案",
                "Repository": "倉庫",
                "Organization": "組織",
                "No projects found. Sorry about that.": "很抱歉，未找到任何專案。",

            // "Milestones": "里程碑",
                "Filter by milestone": "按里程碑篩選",
                "Filter milestones": "篩選里程碑",
                "Issues with no milestone": "無里程碑的議題",
                "Pull requests with no milestone": "無里程碑的拉取請求", // pulls
                "Nothing to show": "暫無",

            "Assignee": "受理人",
                "Filter by who’s assigned": "按受理人篩選",
                "Filter assignees": "篩選受理人",
                "Assigned to nobody": "無受理人",
                // [/Awaiting requested review from ([^ ]+)/, "正在等待 $1 審查請求"],
                "Requested changes must be addressed to merge this pull request.": "要合併這個拉取請求，必須先解決所要求的更改。",
                "No one -": "無人 -",
                    "Assign yourself": "分配給自己",

            "Relationships": "關係",
                "Parent issue": "父議題",

            "Sort": "排序",
                "Sort by": "排序",
                "Newest": "最新的",
                "Oldest": "最早的",
                "Most commented": "最多評論",
                "Least commented": "最少評論",
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新", //?
                "Most reactions": "多數反應",
                "Best match": "最佳匹配",

            // 選中模式
                "selected": "選中",
                "Mark as": "標記為",
                "Apply labels": "應用標籤",
                "Assign": "分配",
                    "Assign someone": "分配給某人",
                    "Assign to nobody": "分配給任何人",

            // 篩選結果
            "No results matched your search.": "沒有與您的搜索匹配的結果。",
            "You could search": "您可以搜索",
            "all of GitHub": "所有 GitHub",
            "or try an": "或者嘗試",
            "advanced search": "高級搜索",

            // 狀態詞
            "was merged": "合併於",
            "was closed": "關閉於",
            "closed this": "關閉了這個",
            "reopened this": "重新打開了這個",
            "Approved": "已批准",
            "Review required": "需要審查", // 拉取請求 頁面狀態詞
                "Review required before merging": "合併前需要審查",
            "outdated": "陳舊的",
            "Pending": "待定",
            "Draft": "草案",
            "deployed": "部署",
                "View deployment": "查看部署",
            "This was referenced": "被引用於",
            "locked as": "鎖定為",
                "spam": "垃圾信息",
            "and limited conversation to collaborators": "並限制與協作者對話",
            "assigned": "分配給",
            "labels": "標籤",

            // 圖標浮窗
            "Open issue": "議題已打開",
            "Closed issue": "議題已完成",
            "Closed as not planned issue": "議題已關閉因未計劃",
            "Open Pull Request": "拉取請求已打開",
            "Draft Pull Request": "拉取請求草案",
            "Merged Pull Request": "拉取請求已合併",
            "Closed Pull Request": "拉取請求已關閉",

            // [/(\d+) linked pull requests?/, "鏈接 $1 個拉取請求"],

        // 某個拉取請求和某個議題 公共詞條
            // 頂部提醒
                "You’ve been unsubscribed from this thread.": "您已退訂該主題。",

            // 右側欄
                "Reviewers": "審查者",
                    "No reviews": "無人審查",
                    "Loading suggestions…": "載入推薦…",
                    // [/([^ ]+) left review comments/, "$1 發表了審查意見"],
                    // [/At least (\d+) approving reviews? is required to merge this pull request./, "合併此拉取請求至少需要 $1 次批准審核。"], // 具體的拉取請求 審查者
                    "No reviews—at least 1 approving review is required.": "未經審查—至少需要 1 次批准審查。",
                    "Re-request review": "重新請求審核",
                    "Still in progress?": "仍在進行中嗎？",
                    // [/Awaiting requested review from ([^ ]+)/, "等待 $1 的審查請求"]
                    "Learn about draft PRs": "瞭解拉取請求草案",
                        "Try draft pull requests": "嘗試拉取請求草案",
                        "Open an in-progress pull request without asking for formal review or risking an unwanted merge. When you're ready for code review, you can mark your draft pull request as ready for review, which will request reviews from any code owners.": "打開正在進行的拉取請求，無需請求正式審核，也不必冒不必要的合併風險。當您準備好進行程式碼審核時，您可以將拉取請求草案標記為已準備好審核，這將請求任何程式碼所有者進行審核。",
                        "Ask admin for access": "向管理員請求權限",
                    "Convert to draft": "設置為草案",
                        // 設置草案對話框
                            "Convert this pull request to draft?": "將此拉取請求轉換為草案？", // 拉取請求
                            "People who are already subscribed will not be unsubscribed.": "已訂閱的用戶將不會被取消訂閱。",
                    // 下拉
                    "Request up to 15 reviewers": "最多請求 15 個審查者",
                    // [/([^ ]+) approved these changes/, "$1 批准這些更改"], // 具體的拉取請求 審查者
                    "Request": "請求",
                    // [/Request review from ([^ ]+)/, "請求 $1 審查"], // 具體的拉取請求 審查者
                    "This pull request is waiting on your review.": "此拉取請求正在等待您的審核。",

                "Assignees": "受理人",
                    "No one assigned": "無人受理",
                    "No one—": "無人 - ",
                    "assign yourself": " 受理自己",
                    // 下拉框
                    "Assign up to 10 people to this issue": "最多指定 10 人", // 議題
                    "Assign up to 10 people to this pull request": "最多指定 10 人", // 拉取請求
                    "Clear assignees": "清除受理人",
                    "Type or choose a user": "輸入或選擇用戶",
                    "Suggestions": "建議",

                // "Labels": "標籤",
                    "None yet": "暫無",
                    // 下拉
                    "bug": "BUG",
                        "Something isn't working": "有些東西不工作",
                    "dependencies": "依賴性",
                        "Pull requests that update a dependency file": "更新一個依賴文件的拉取請求",
                    "documentation": "文檔",
                        "Improvements or additions to documentation": "文檔的改進或補充",
                    "duplicate": "重複",
                        "This issue or pull request already exists": "這個議題或拉取請求已經存在",
                    "enhancement": "增強",
                        "New feature or request": "新功能或請求",
                    "good first issue": "好的首發議題",
                        "Good for newcomers": "適合新人",
                    "help wanted": "需要幫助",
                        "Extra attention is needed": "需要特別關注",
                    "invalid": "無效",
                        "This doesn't seem right": "這似乎不對",
                    "question": "問題",
                        "Further information is requested": "要求提供更多信息",
                    "wontfix": "不會修復",
                        "This will not be worked on": "這將不會被處理",

                    "Apply labels to this issue": "應用標籤", // 議題
                    "Apply labels to this pull request": "應用標籤", // 拉取請求
                    "Edit labels": "編輯標籤",

                    // 拉取請求
                    "dependencies": "依賴項",
                        "Pull requests that update a dependency file": "更新依賴文件的拉取請求",

                // 專案
                    "Recent": "最近",
                    "User": "用戶",
                    "No projects": "無專案",

                "Milestone": "里程碑",
                    "No milestone": "無里程碑",
                    //下拉
                    "Set milestone": "設置里程碑",
                        "Nothing to show": "暫無",

                "Development": "進展",
                    "Successfully merging this pull request may close these issues.": "成功合併此拉取請求可能會關閉這些議題。",
                    "Successfully merging a pull request may close this issue.": "成功合併一個拉取請求可能會關閉此議題。",
                    // 下拉
                    "Link an issue from this repository": "關聯來自此倉庫的議題",
                    "Filter": "篩選",
                    "No results": "無結果",
                    "Open in Workspace": "在工作區打開",

                // "Notifications": "通知類型",
                "Customize": "自定義",
                "Subscribe": "訂閱",
                // "Unsubscribe": "取消訂閱",
                "You’re not receiving notifications from this thread.": "您沒有收到來自該話題的通知。",
                "You're not receiving notifications from this thread.": "您沒有收到來自該話題的通知。",
                "You're receiving notifications because you're subscribed to this thread.": "您收到通知是因為您訂閱了該話題。",
                "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因為您訂閱了該話題。",
                "You’re receiving notifications because you’re watching this repository.": "您收到通知是因為您正在關注此倉庫。",
                "You’re receiving notifications because you authored the thread.": "您收到通知是因為您提出了該話題。",
                "You’re receiving notifications because you were mentioned.": "您收到通知是因為有人 @您。",
                "You’re receiving notifications because you commented.": "您收到通知是因為您發表了評論。",
                "You’re receiving notifications because you are watching pull requests on this repository.": "您收到通知是因為您正在關注此倉庫上的拉取請求。",
                "You’re receiving notifications because you are watching issues on this repository.": "您收到通知是因為您正在關注此倉庫上的議題。",
                "You’re receiving notifications because you modified the open/close state.": "您收到通知是因為您修改了打開/關閉狀態。",
                "You’re receiving notifications because you were assigned.": "您收到通知是因為您受理了它。",
                "You’re ignoring this repository.": "您忽略了這個倉庫。",

                    // 通知設置對話框
                    "Notification settings": "通知設置",
                    "Notifications settings": "通知設置", // 新版議題頁面
                    "Not subscribed": "未訂閱",
                        "Only receive notifications from this pull request when you have participated or have been @mentioned.": "只有在您參與或被 @您 時才會收到來自此拉取請求的通知。",
                        "Only receive notifications from this issue when you have participated or have been @mentioned.": "只有在您參與或被 @您 時才會收到來自此議題的通知。", // 議題頁面
                    "Subscribed": "訂閱",
                        "Receive all notifications from this pull request.": "接收來自此拉取請求的所有通知。",
                        "Receive all notifications from this issue.": "接收來自此議題的所有通知。",  // 議題頁面
                    "Custom": "自定義",
                        "You will only be notified for events selected from the list below. If you participate or are @mentioned you will be subscribed.": "您只會收到從以下列表中選擇的事件的通知。如果您參與或 @您 時，將自動訂閱。",
                        "You will only be notified for the events selected from the list below.": "您只會收到從以下列表中選擇的事件的通知。",
                        "If you participate or are @mentioned you will be subscribed.": "如果您參與或 @您 時，將自動訂閱。",
                    // 議題
                        "Receive a notification when this issue has been closed.": "當議題被關閉時，收到通知。",
                        "Reopened": "重新打開",
                            "Receive a notification when this issue has been reopened.": "當議題被重新打開時，收到通知。",
                    // 拉取請求
                        "Receive a notification when this pull request has been merged.": "當拉取請求被合併時，收到通知。",
                        "Receive a notification when this pull request has been closed.": "當拉取請求被關閉時，收到通知。",
                        "Receive a notification when this pull request has been reopened.": "當拉取請求被重新打開時，收到通知。",

                "Lock conversation": "鎖定對話",
                    "Lock conversation on this issue": "鎖定此議題的對話",
                    "Lock conversation on this pull request": "鎖定此拉取請求的對話",
                    "Other users": "其他用戶",
                    "can’t add new comments": "無法添加新評論",
                    "to this issue.": "到該議題。",
                    "to this pull request.": "到該拉取請求。",
                    "You and other collaborators": "您和其他協作者",
                    "with access": "有權限訪問",
                    "to this repository": "該倉庫",
                    "can still leave comments": "仍然可以發表評論",
                    "that others can see.": "其他人可以看到。",
                    "You can always unlock this issue again in the future.": "您今後仍可以隨時再次解鎖此議題。",
                    "You can always unlock this pull request again in the future.": "您今後仍可以隨時再次解鎖此拉取請求。",
                    "Other users can't add new comments to this issue. You and other members of teams with": "其他用戶無法在此議題下添加新評論。您及",
                    "write access": "有權訪問",
                    "to this repository can still leave comments that others can see. You can always unlock this issue again in the future.": "該倉庫的團隊成員仍可發表其他用戶可見的評論。您隨時可以在未來重新解鎖此議題。",
                    "Reason for locking": "鎖定原因",
                    "Choose a reason": "選擇原因",
                    "Reason": "原因",
                        "No reason": "無",
                        "Off-topic": "偏離主題",
                        "Too heated": "爭論不休",
                        "Resolved": "已解決",
                        "Spam": "垃圾信息",
                    "Optionally, choose a reason for locking that others can see. Learn more about when it’s appropriate to": "或者，選擇其他人可以看到的鎖定原因。詳細瞭解何時適合",
                    "lock conversations": "鎖定對話",
                    // "Lock conversation on this issue": "鎖定對話",
                "Unlock conversation": "解鎖對話",
                    "Unlock conversation on this issue": "解鎖此議題的對話",
                    "Unlock conversation on this pull request": "解鎖此拉取請求的對話",
                    "Everyone": "任何人",
                    "will be able to comment on this issue once more.": "將能夠再次對這個議題發表評論。",
                    "will be able to comment on this pull request once more.": "將能夠再次對這個拉取請求發表評論。",
                    "You can always lock this pull request again in the future.": "您今後仍可以隨時再次鎖定此拉取請求。",
                    "You can always lock this issue again in the future.": "您今後仍可以隨時再次鎖定此議題。",
                    "Everyone will be able to comment on this issue once more. You can always lock this issue again in the future.": "任何人將能夠再次對這個議題發表評論。您今後仍可以隨時再次鎖定此議題。",

                // 隱藏評論對話框
                "The reason will be displayed to describe this comment to others.": "將顯示原因，以便向其他人描述此評論。",
                "Learn more about hiding comments": "瞭解更多關於隱藏評論的信息",
                "comment": "評論",
                "Unhide": "取消隱藏",
                "Choose a reason for hiding this comment": "選擇隱藏此評論原因",
                "Choose a reason": "選擇原因",
                    "Abuse": "濫用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏離主題",
                    "Outdated": "過時",
                    "Duplicate": "重複",
                    "Resolved": "已解決",

                "This comment has been minimized.": "此評論已最小化。",
                    "Show comment": "顯示評論",
                    "Hide comment": "隱藏評論",

            "Remember, contributions to this repository should follow our": "請記住，對該倉庫的貢獻應遵循我們的",
            "GitHub Community Guidelines": "GitHub 社區準則",
            "Remember, contributions to this repository should follow its": "請記住，對該倉庫的貢獻應遵循",
            "contributing guidelines": "貢獻指南",
            "security policy": "安全政策",
            "code of conduct": "行為準則",
            "contributing guidelines": "貢獻準則",

            // 被鎖定
                "This conversation has been locked as": "此對話已鎖定為",
                    "and limited to collaborators.": "，並限制與協作者對話。",
                "You can't perform this action at this time.": "您此時不能操作。",

            // 底部贊助
                "Show your support for": "通過贊助來表達您對",
                "by sponsoring them.": "的支持。",
                "Sponsor": "贊助",

            // 底部提示欄 (未登錄)
                "Sign up for free": "免費註冊",
                "to subscribe to this conversation on GitHub": "在 GitHub 上訂閱這個討論",
                "to join this conversation on GitHub": "加入 GitHub 上的這個討論",
                ". Already have an account?": "。已經有賬戶？",
                "Sign in to comment": "登錄後發表評論",
    },
    "regexp": [ // 正則翻譯
        // [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有寫入權限的審查者至少需要 $1 次批准審查。"],
        [/(\+\d+) more reviewers?/, "$1 個審查者"],
        [/(\d+) linked issues?/, "鏈接 $1 個議題"],
        [/Assigned to (.*)/, "分配給 $1"],
        [/Edited (\d+) times?/, "編輯 $1 次"],
        [/Open issues created by ([^ ]+)/, "$1 創建議題"],
        [/issues opened by ([^ ]+)/, "$1 打開議題"],
        [/Open pull requests created by ([^ ]+)/, "$1 創建拉取請求"],
        [/pull requests opened by ([^ ]+)/, "$1 打開拉取請求"],
        [/(\d+) hidden conversations/, "$1 條隱藏對話"],
        [/Ears burning\? Get @([^ ]+) mentions with/, "耳朵要炸了？如果只需要查看提及了 $1 的內容，請使用"]
    ]
};

I18N["zh-TW"]["repository/issues"] = { // 倉庫 - 議題頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["static"],

        // 倉庫 --> 議題 標籤卡/<user-name>/<repo-name>/issues
        // /<user-name>/<repo-name>/labels/<label-name>
            // 歡迎信息
            "Welcome to issues!": "歡迎關注議題！",
            "Issues are used to track todos, bugs, feature requests, and more. As issues are created, they’ll appear here in a searchable and filterable list. To get started, you should": "議題用於跟蹤待辦事項、錯誤、功能請求等。創建議題後，它們將出現在可搜索和可篩選的列表中。要開始，您應該",
            "create an issue": "創建議題",
                "Open issue creation in fullscreen": "全屏", // 有議題模板時

            "Label issues and pull requests for new contributors": "標記新貢獻者的議題和拉取請求",
            "Now, GitHub will help potential first-time contributors": "現在，GitHub 將幫助潛在的首次貢獻者",
            "discover issues": "探索議題",
            "labeled with": "標記為",
                "Completed": "已完成",
            "Project": "專案",

            "Clear filter": "清除篩選",
            "Filter authors": "篩選作者",
            "Filter by assignees": "篩選受理人",
                "No assignees": "無人受理",
            // 新版內容
                // 頂部
                    "👋 Want to contribute to": "👋 想做貢獻給",
                // 排序
                    "Created on": "創建時間",
                    "Comments": "評論",
                    "Total comments": "評論數",
                    "Reactions": "看法數",
                    "Total reactions": "總看法數",
                    "Thumbs up": "點贊",
                    "Thumbs down": "點踩",
                    "Rocket": "火箭",
                    "Hooray": "歡呼",
                    "Eyes": "關注",
                    "Heart": "比心",
                    "Laugh": "大笑",
                    "Confused": "拒絕",
                    "Ascending": "遞增",
                    "Descending": "遞減",

                "Types": "類型",
                "Issue type": "議題類型",
                    "Filter by issue type": "按議題類型篩選",
                    "Select issue type": "選擇議題類型",
                    "Filter types": "篩選類型",
                        "No type": "無類型",
                            "Issues with no type": "無類型議題",
                            "No issue type": "無議題類型",
                // 搜索
                "Try adjusting your search filters.": "嘗試調整搜索篩選器。",

            // [/Want to contribute to ([^ ]+)/, "想為 $1 做貢獻嗎？"], /issues
            "If you have a bug or an idea, read the": "如果您發現一個錯誤或有任何想法，請閱讀",
            "before opening an issue.": "，在打開議題之前。",
            "If you have a bug or an idea, browse the open issues before opening a new one. You can also take a look at the": "如果您發現一個錯誤或有任何想法，請在打開新議題之前瀏覽未解決的議題。您也可以看看",
            "Open Source Guide": "開源指南",
                "Learn about Open Source and how to contribute": "瞭解開源和如何貢獻",
            "If you're ready to tackle some open issues,": "如果您準備好解決一些未解決的議題，",
            "we've collected some good first issues for you": "我們已為您收集了一些好的首發議題",
            "we've collected some good first issues for you.": "我們已為您收集了一些好的首發議題。", // 新版議題頁

            "Dismiss": "忽略",
                // 忽略 下拉
                "Dismiss for this repository only": "僅對該倉庫不在提示",
                "Dismiss for all repositories": "對所有倉庫均不在提示",


            "There aren’t any open issues.": "暫無開放的議題。",

            // 狀態詞
            "Merged": "已合併",
            // "open": "打開",
            // "Opened": "打開",
            "opened": "打開於",
            // "closed": "已關閉",
            // 新版
                "Closed as not planned": "關閉因未計劃",
                "Closed as duplicate": "關閉因重複",
                "of": "於",
                "Not planned": "未計劃",

            // 父級議題
            "Parent:": "父級：",
            // 子級議題
            "Create sub-issue": "創建子議題",
                //"Create sub-issue": "創建子議題",
                    // 窗口
                        "Create new issue": "新建議題",
                            "Select an item": "選擇一項",
                                "Select repository": "選擇倉庫",
                            "Templates and forms": "模板和表單",
                                // 空白議題
                                    "Create a new issue from scratch": "從頭開始創建新議題",
                "Add existing issue": "添加現有議題",
                    "Search issues": "搜索議題",
                        "Group selected": "分組選擇",


                "Blank issue": "空白議題",
                    "in": "在",
                "Type your description here…": "在此鍵入介紹…",
                "Create more sub-issues": "創建更多子議題",

                // 警告
                    "Are you sure?": "您確定嗎？",
                        "Sub-issues are limited to one parent. Confirm you want to proceed with this change.": "子議題僅允許關聯一個父議題。請確認是否要繼續進行此更改？",
                        "Change parent issue": "更改父議題",

            "Sub-issues": "子議題",
                "Collapse Sub-issues": "摺疊子議題",
                "Expand Sub-issues": "展開子議題",

                "More list item action bar": "更多操作",
                    "Remove sub-issue": "移除子議題",

            "Invalid value": "無效值",
            "for": "，",
            //"parent-issue": "父議題",

            "You commented on and opened this issue": "您打開了此議題並發表了評論",
            "You were mentioned on and commented on this issue": "您被提及並對此議題發表了評論",
            "You commented on this issue": "您對此議題發表了評論",
            "You opened this issue": "您打開了此議題",

            // 置頂議題
            "Pinned issues": "置頂議題",
            "Drag to reorder": "拖拽排序",
            "Pinned issue options": "置頂選項",

            "Unpin": "取消置頂",
            "Advanced move...": "高級移動…",
                "Move selected item": "移動選中項",
                    "Item": "標題",
                    "Action": "操作",
                    "Move item before": "移動到…之前",
                    "Move item after": "移動到…之後",
                    "Move to position": "指定位置",
                    "Move": "移動",
            "Search Issues": "搜索議題",
                // 倉庫
                    "No repository": "無倉庫",
                    "Has repository": "包含倉庫",
                    "Exclude repo": "排除倉庫",
                // 組織
                    "Has organization": "包含組織",
                    "Exclude org": "排除組織",
                "Is": "類型為",
                    "Exclude is": "排除類型為",
                    "Issue": "議題",
                    "Pull Request": "拉取請求",
                    "Unmerged": "未合併",
                    "Locked": "已鎖定",
                    "Unlocked": "未鎖定",
                    "Blocked": "已阻塞",
                "State": "狀態",
                    "Exclude state": "排除狀態",
                // 標籤
                    "No label": "無標籤",
                    "Has label": "包含標籤",
                    "Exclude label": "排除標籤",
                    "aesthetics": "美化",
                    "bug": "缺陷",
                    "dependencies": "依賴項",
                    "development": "開發中",
                    "discuss": "討論",
                    "documentation": "文檔",
                    "duplicate": "重複",
                    "enhancement": "功能增強",
                    "forums": "論壇",
                    "good first issue": "適合新手",
                    "help wanted": "求助",
                    "invalid": "無效",
                    "question": "提問",
                    "website": "網站",
                    "wontfix": "不會修復",
                // 類型
                    "No type": "無類型",
                    "Has type": "包含類型",
                "Project": "專案",
                    "No project": "無專案",
                    "Has project": "包含專案",
                    "Exclude project": "排除專案",
                "Milestone": "里程碑",
                    "No milestone": "無里程碑",
                    "Has milestone": "包含里程碑",
                    "Exclude milestone": "排除里程碑",
                // 受理人
                    "No assignee": "無受理人",
                    "Has assignee": "包含受理人",
                    "Me": "我",
                        "Signed-in user": "已登錄用戶",
                    // Copilot
                        "Your AI pair programmer": "您的 AI 編程助理",
                    "Exclude assignee": "排除受理人",
                "Author": "作者",
                    "Has author": "包含作者",
                    "Exclude author": "排除作者",
                "Involves": "涉及",
                    "Has involves": "包含涉及",
                    "Exclude involves": "排除涉及",
                "Mentions": "提及",
                    "Has mentions": "包含提及",
                    "Exclude mentions": "排除提及",
                "Parent issue": "父議題",
                    "No parent issue": "無父議題",
                    "Has parent issue": "包含父議題",
                    "Exclude parent-issue": "排除父議題",
                "Blocking": "阻塞",
                    "No blocking": "無阻塞",
                    "Has blocking": "包含阻塞",
                    "Exclude blocking": "排除阻塞",
                "Blocked by": "被…阻塞",
                    "No blocked by": "無被阻塞",
                    "Has blocked by": "包含被阻塞",
                    "Exclude blocked-by": "排除被阻塞",
                "Sub-issue": "子議題",
                    "No sub-issue": "無子議題",
                    "Has sub-issue": "包含子議題",
                    "Exclude sub-issue": "排除子議題",
                "Update date": "更新日期",
                    "Exclude updated": "排除更新日期",
                    "Today": "今天",
                    "Yesterday": "昨天",
                    "Past 7 days": "過去 7 天",
                    "Past 30 days": "過去 30 天",
                    "Past year": "過去 1 年",
                "Creation date": "創建日期",
                    "Has creation date": "包含創建日期",
                    "Exclude created": "排除創建日期",
                "Closed date": "關閉日期",
                    "Has closed date": "包含關閉日期",
                    "Exclude closed": "排除關閉日期",
                "Merge date": "合併日期",
                    "Has merge date": "包含合併日期",
                    "Exclude merged": "排除合併日期",
                "Review requested": "已請求評審",
                    "Has review requested": "包含已請求評審",
                    "Exclude review-requested": "排除已請求評審",
                "In": "在",
                    "Has in": "包含在",
                    "Exclude in": "排除在",
                    "Body": "正文",
                    "Comments": "評論",
                "Commenter": "評論者",
                    "Has commenter": "包含評論者",
                    "Exclude commenter": "排除評論者",
                "User": "用戶",
                    "Has user": "包含用戶",
                    "Exclude user": "排除用戶",
                "User review requested": "已請求用戶評審",
                    "Has user review requested": "包含已請求用戶評審",
                    "Exclude user-review-requested": "排除已請求用戶評審",
                "Reviewed by": "評審者",
                    "Has reviewed by": "包含評審者",
                    "Exclude reviewed-by": "排除評審者",
                "Comment count": "評論數",
                    "Has comment count": "有評論數",
                    "Less than 10": "少於 10",
                    "More than 10": "多於 10",
                    "Between 10 and 100": "10 到 100",
                "Interactions count": "互動數",
                    "Has interactions count": "有互動數",
                "Closed reason": "關閉原因",
                    "Exclude reason": "排除原因",
                    "Completed": "已完成",
                    "Not planned": "未計劃",
                    "Duplicate": "重複",
                "Linked": "已鏈接",
                    "Has linked": "包含已鏈接",
                    "Exclude linked": "排除已鏈接",
                "Archived": "已歸檔",
                    "Has archived": "包含已歸檔",
                    "Exclude archived": "排除已歸檔",
                    "True": "是",
                    "False": "否",
                "Reaction count": "表情回應數",
                    "Has reaction count": "有表情回應數",
                // 草案
                    "Has draft": "包含草案",
                    "Exclude draft": "排除草案",
                "Review state": "評審狀態",
                    "Has review state": "包含評審狀態",
                    "Exclude review": "排除評審狀態",
                    "No reviews": "無評審",
                "Code language": "程式碼語言",
                    "Has code language": "包含程式碼語言",
                    "Exclude language": "排除程式碼語言",
                "Commit SHA": "提交 SHA",
                    "Has commit sha": "包含提交 SHA",
                    "Exclude sha": "排除提交 SHA",
                "Base": "基礎分支",
                    "Has base": "包含基礎分支",
                    "Exclude base": "排除基礎分支",
                "Head": "對比分支",
                    "Has head": "包含對比分支",
                    "Exclude head": "排除對比分支",
                // 狀態 (Status)
                    "Has status": "包含狀態檢查",
                    "Exclude status": "排除狀態檢查",
                    "Pending": "待處理",
                    "Success": "成功",
                    "Failure": "失敗",
                    "Queued": "排隊中",
                    "Waiting": "等待中",
                    "Cancelled": "已取消",
                    "Skipped": "已跳過",
                "Team": "團隊",
                    "Has team": "包含團隊",
                    "Exclude team": "排除團隊",
                "Team review requested": "已請求團隊評審",
                    "Has team review requested": "包含已請求團隊評審",
                    "Exclude team-review-requested": "排除已請求團隊評審",
                // 排序
                    "Has sort": "包含排序",
                    "Exclude sort": "排除排序",
                    "Least reactions": "最少回應",
                    "Most thumbs up (👍) reactions": "👍 回應最多",
                    "Least thumbs up (👍) reactions": "👍 回應最少",
                    "Most thumbs down (👎) reactions": "👎 回應最多",
                    "Least thumbs down (👎) reactions": "👎 回應最少",
                    "Most laugh (😄) reactions": "😄 回應最多",
                    "Least laugh (😄) reactions": "😄 回應最少",
                    "Most confused (😕) reactions": "😕 回應最多",
                    "Least confused (😕) reactions": "😕 回應最少",
                    "Most tada (🎉) reactions": "🎉 回應最多",
                    "Least tada (🎉) reactions": "🎉 回應最少",
                    "Most heart (❤️) reactions": "❤️ 回應最多",
                    "Least heart (❤️) reactions": "❤️ 回應最少",
                    "Most eyes (👀) reactions": "👀 回應最多",
                    "Least eyes (👀) reactions": "👀 回應最少",
                "AND": "且",
                "OR": "或",
                "Exclude": "排除",
            // 過濾器問題
                "Empty value for": "空值",
                "Invalid value": "無效值",
                "for": "對於",

            "Order": "順序",

        // 新建議題 選擇議題模板  /<user-name>/<repo-name>/issues/new/choose
            "Get started": "開始",
            "Don’t see your issue here?": "在這裡沒有看到您的議題？",
            "Open a blank issue.": "打開一個空白議題。",
            "Edit templates": "編輯模板",
            "Report abuse": "舉報濫用",

            "View organization templates": "查看組織模板", // 組織倉庫

            // 警告
                "Discard changes?": "丟棄更改？",
                "Close and discard": "丟棄並關閉",

        // 新建空白議題  /<user-name>/<repo-name>/issues/new
            "Title": "標題",
            "Helpful resources": "幫助性資源",
            "Create more": "創建多個",
            "Write with Copilot": "請 Copilot 編寫",
                "Navigate to Copilot Chat": "導航到 Copilot 聊天",
                    "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您確定要放棄它們嗎？",
                    "Keep editing": "否", // 實際作用：返回編寫頁面
                    "Go to Copilot": "是", // 實際作用：前往 Copilot 頁面

            "Choose a different template": "切換模板",

        // 從討論創建議題  /<user-name>/<repo-name>/issues/new?created_from_discussion_number=<id>
            "Documentation has changed since you last contributed": "自您上次貢獻以來，文檔已更改",
            ". Take a look before submitting an issue:": "。在提交議題之前先看一下：",
            "Contributing guidelines": "貢獻指南",
            "Last updated": "最後更新",

        // 某條具體的議題 /<user-name>/<repo-name>/issues/<id> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 快捷鍵
                "Convert issue to discussion…": "將議題轉化為討論…",

            "This issue was moved to a discussion.": "這個議題被轉移到討論中。",
            "You can continue the conversation there.": "您可以在那裡繼續討論。",
            "Go to discussion →": "轉到討論→",

            "Edit": "編輯",
            "Issue body actions": "菜單", // 原文過於囉嗦，直接省略

            // 狀態詞 同 /<user-name>/<repo-name>/pull/<id>
            "changed the title": "修改了標題",
            "opened this issue": "打開了該議題",
            "· Fixed by": "· 修復了",
            "mentioned this issue": "提及了該議題",
            "mentioned this": "提及此",
            "opened this": "打開了這個",
            "linked a pull request": "關聯了一個拉取請求",
            "linked a pull request that will close this issue": "關聯了一個關閉此議題的拉取請求",
            //"that will": "這將會",
            //"close": "關閉",
            //"this issue": "這個議題",
            // "that will close this issue": "這將會關閉這個議題",
            // "Issue": "議題",
            "added a commit that closed this issue": "在提交時關閉了這個議題",
            "closed this in": "關閉於",
            "added the": "添加了",
            "added": "添加了",
            "and removed": "並移除了",
            "removed the": "移除了",
            "removed": "移除了",
            "label": "標籤",
            "labels": "標籤",
            "self-assigned this": "自己受理了該議題",
            // "edited": "編輯的",
            "added this to the": "添加到",
            "added this to": "添加到",
            "milestone": "里程碑",
            "moved this to": "移動到",
            "closed this": "關閉了",
            "as": "因",
            "as a": "因",
            "closed this as": "已關閉因",
                "not planned": "非計劃中",
                "completed": "已完成",
            "reopened this": "重新打開了這個",
            "This was referenced": "這是引用",
            "deleted a comment from": "刪除了評論，來自",
            "· May be fixed by": " · 可通過該方案修復",
            "pinned this issue": "置頂議題",
            "unpinned this issue": "取消置頂",
            "Repository owner": "倉庫所有者",
            "Repository owner locked and limited conversation to collaborators": "倉庫所有者鎖定並限制與協作者對話",
            "Repository owner locked as": "倉庫所有者鎖定為",
            "Repository owner deleted a comment": "倉庫所有者刪除了評論",
            "Repository owner deleted a comment from": "倉庫所有者刪除了評論來自",
            "locked": "鎖定",
            "locked as": "鎖定為",
                "off-topic": "偏離主題",
                "too heated": "爭論不休",
                "resolved": "已解決",
                "spam": "垃圾信息",
            "and limited conversation to collaborators": "並限制與協作者對話",
            "unlocked this conversation": "解鎖了對話",
            "merged commit": "已合併提交",
            // "into": "到",
            "deleted the": "刪除了",
            "locked and limited conversation to collaborators": "鎖定並限制與協作者對話",
            "converted this issue into discussion": "此議題已轉化為討論",
            "converted this issue into a discussion": "此議題已轉化為討論",
            "removed their assignment": "取消了他們的任務",
            "assigned": "分配給了",
            "unassigned": "取消分配給",
            "and unassigned": "和取消了分配給",
            "marked this pull request as draft": "將此拉取請求標記為草案",
            "marked this pull request as ready for review": "將此拉取請求標記為可供審查",
            "dismissed a stale review via": "駁回了一個陳舊的審查，通過",
            "requested changes": "請求了更改",
            "added a commit that referenced this issue": "添加了一個引用此問題的提交",
            "referenced this issue": "提及這個議題",
            "closed this as completed": "已完成，關閉",
            "added a parent issue": "添加了一個父議題",
            "added a commit that references this issue": "添加了一個引用此議題的提交",
            "transferred this issue from": "將此議題轉移，從",
            "as off topic": "為偏離主題",
            "as too heated": "為爭論不休",
            "as spam": "為垃圾信息",
            "as resolved": "為已解決",
            "added a sub-issue": "添加子議題",
            "added sub-issues": "添加子議題",
            "removed a parent issue": "移除父議題",
            "removed a sub-issue": "移除子議題",
            "marked": "標記",
                "as a duplicate of this issue": "議題同此重複", // 示例 https://github.com/maboloshi/github-chinese/issues/405

            // 右側欄 補充
            "Metadata": "元數據", // 小屏模式
                // "Development": "進展",
                    "Code with agent mode": "智能體模式編程",
                        "Select code repository": "選擇倉庫",
                        "Start a codespace with Copilot agent mode for this issue in another repository.": "為另一個倉庫中的此議題啟動使用 Copilot 智能體模式的程式碼空間。",
                    "No branches or pull requests": "沒有分支或拉取請求",
                    "Shows branches and pull requests linked to this issue.": "顯示與該議題相關的分支和拉取請求。",
                    "Create a branch": "創建分支",
                    "for this issue or link a pull request.": "為這個議題或關聯一個拉取請求",
                    "When branches are created from issues, their pull requests are automatically linked.": "當從議題中創建分支時，它們的拉取請求會自動關聯。",

                    // 關係
                        "Add parent": "添加父議題",
                        "Select a repository": "選擇一個倉庫",
                        "Change or remove parent": "更改或移除父議題",
                            "Selected": "當前",

                    // 參與者數大於2
                        "and others": "等",

                    // 下拉
                    "Link a pull request from this repository": "關聯來自此倉庫的拉取請求",

                    // "linked a pull request that will": "關聯一個拉取請求, 將會",
                    // "close": "關閉",
                    // "this issue": "這個議題",

                    // 第一次打開議題
                    "It looks like this is your first time opening an issue in this project!": "看起來這是您第一次在此專案中打開議題！",
                    "Be sure to review the": "請務必查閱",

                    // 議題表單
                    "You're using an": "您正在使用",
                    "issue form": "議題表單",
                    ", a new type of issue template.": "，一種新型議題模板。",

                    // 創建分支 對話框
                        "Create a branch for this issue": "為該議題創建一個分支",
                        "Branch name": "分支名稱",
                        "Repository destination": "倉庫目的地",
                            "Search for a repository": "搜索倉庫",
                        "Change branch source": "更改分支源",
                        "What's next?": "下一步是什麼？",
                            "Checkout locally": "檢出本地",
                            "Open branch with GitHub Desktop": "使用 GitHub Desktop 打開分支",
                        "Create branch": "創建分支",

                    // 在本地倉庫檢出對話框
                        "Checkout in your local repository": "在本地倉庫檢出",
                        "Run the following commands in your local clone.": "在您的本地克隆中運行以下指令。",

                    // 專案
                        "Select projects": "選擇專案",

                    // 進展
                        "Link a branch or pull request": "關聯分支或拉取請求",
                        "Select a repository to search for branches and pull requests or": "選擇一個倉庫來搜索分支和拉取請求或",
                        "create a branch": "創建一分支",
                        "Search pull requests": "搜索拉取請求",
                        "Search for repositories": "搜索倉庫",
                        "Link a branch, pull request, or": "關聯分支、拉取請求或",
                        "Search for branches or pull requests": "搜索分支或拉取請求",
                        "no pull request": "無拉取請求",

                "Duplicate issue": "複製議題",
                    // [/Duplicate current issue in ([^ ]+\/[^ ]+)/, "在 $1 中複製當前議題"],
                    "Changing the repository may remove Milestone, Labels, Type, and Assignees from the duplicate issue.": "更改倉庫可能會從重複議題中移除里程碑、標籤、類型和分配人員。",
                    "This issue is being duplicated across repositories. The following metadata might not be copied: Milestone, Labels.": "該議題正跨倉庫中被複制創建。以下元數據可能不會被複制：里程碑、標籤。",
                "Pin issue": "置頂議題",
                    "Up to 3 issues can be pinned and they will appear publicly at the top of the issues page": "最多可以置頂 3 個議題，它們將公開顯示在議題頁面的頂部",
                    "Up to 3 issues can be pinned to the top of the issues page": "最多可以在議題頁面置頂 3 個議題",
                    "This will unpin this issue from the top of the issues page": "將從議題頁面取消置頂該議題",
                    // 頂部提醒
                    "The issue has been pinned.": "該議題已置頂。",
                "Unpin issue": "取消置頂",
                    "Up to 3 issues can be pinned and they will appear at the top of the issues page": "最多可以置頂 3 個議題，它們將顯示在議題頁面的頂部",
                    "3/3 issues already pinned. Unpin an issue to pin this one.": "已有3/3個議題被置頂。請先取消置頂其中一個議題，才能置頂當前議題。",
                    // 頂部提醒
                    "The issue has been unpinned.": "該議題已取消置頂。",
                "Transfer issue": "轉移議題",
                    // 轉移議題 對話框
                        "Transfer this issue": "轉移議題",
                            "This does not scrub any issue content. Content such as text references to other issues, pull requests, projects and teams will still appear in the description or comments. Labels will be transferred.": "該操作不會清除任何議題內容。對其它議題、拉取請求、專案和團隊的文本引用仍會保留在描述或評論中。標籤將會被轉移。",
                            "Repository projects assigned to this issue will not transfer to the new location": "分配給此議題的倉庫專案不會轉移到新位置",
                        "Choose a repository": "選擇倉庫",
                        "Find a repository": "搜索倉庫",
                        "Warning!": "警告！",
                            "Transferring an issue does not scrub any issue content. Content such as text references to other issues, pull requests, projects, teams will remain in this issue's descriptions and comments.": "轉移議題不會清除任何議題內容。諸如對其他議題、拉取請求、專案、團隊的文本引用等內容將保留在此議題的描述和評論中。",
                            "Assignees, labels and milestones will be transferred if they are present in the target repository.": "如果目標倉庫中存在受讓人、標籤和里程碑，它們將被轉移。",
                "Convert to discussion": "轉為討論",
                    // 轉換議題為討論 對話框
                    "Convert issue to a discussion": "轉換議題為討論",
                        "Are you sure you want to convert this issue to a discussion?": "您確定要將議題轉換為討論嗎？",
                        "What happens when an issue is converted into a discussion:": "將議題轉化為討論時，會發生什麼：",
                        "Issue will be closed and locked": "議題將被關閉並鎖定",
                        "Title, description, and author will be the same as the issue": "標題、描述和作者將與議題相同",
                        "All comments and reactions will be the same as the issue": "所有評論和反應將與議題相同",
                        "Category for new discussion": "新討論的類別",
                            "Announcements": "公告",
                            "General": "通常",
                            "Ideas": "想法",
                            "Polls": "投票",
                            "Q&A": "問與答",
                            "Show and tell": "展示與講述",
                        "I understand, convert this issue": "我明白了，依然轉化該議題",
                "Delete issue": "刪除議題",
                    "Delete issue?": "刪除議題？",
                    "Are you sure you want to delete this issue?": "您確定要刪除此議題嗎？",
                    "This cannot be undone": "這不能被撤消",
                    "Only adminstrators can delete issues": "只有管理員可以刪除議題",
                    "Deletion will remove the issue from search and previous references will point to a placeholder": "刪除將會從搜索中刪除議題，以前的引用將指向一個佔位符",
                    "Delete this issue": "刪除議題",
                    "Deleting issue…": "議題刪除中…",
                    // 頂部提醒
                    "The issue was successfully deleted.": "該議題已成功刪除。",

                "Participants": "參與者",
                    "No participants": "尚無參與者",

            // 新版議題頁面
            "remaining": "剩餘",
            "items": "項",
            "Load more": "載入更多",

            "This conversation has been locked and limited to collaborators.": "此對話已鎖定並限制與協作者對話。",
            "This issue has been deleted.": "該議題已被刪除。",
            "deleted this from": "刪除了這個，從",

            "Reference in a new issue": "在新議題中提及",

            // 評論框
            "edited by": "編輯者",
            "Hidden as": "隱藏因",
                "abuse": "濫用",
                "show comment": "顯示評論",
                "hide comment": "隱藏評論",
            "Edits": "編輯",
                "Most recent": "最近",
                "Viewing edit": "查看編輯",
                "Delete revision": "刪除修訂",
            "Reopen Issue": "重新打開議題",
                "You do not have permissions to reopen this issue": "您沒有權限重新打開此議題",
            // 評論刪除對話框
                "Delete comment": "刪除評論",
                "Are you sure you'd like to delete this comment?": "您確定要刪除這條評論嗎？",
            // 關閉議題
                "You do not have permissions to close this issue": "您沒有權限關閉此議題",
            "Comment can not be empty": "評論不能為空",
            "Add files": "添加文件", // 小屏模式

        // 議題標籤管理 /<user-name>/<repo-name>/issues/labels
        // 倉庫 --> 標籤頁面 /<user-name>/<repo-name>/labels
            "Labels": "標籤",
            "Milestones": "里程碑",
            "Search all labels": "搜索所有標籤",

            "labels": "標籤",

            "New label": "新建標籤",
                "Label preview": "標籤預覽",
                "Label name": "標籤名",
                "Description": "描述",
                "Description (optional)": "描述（可選）",
                "Color": "顏色",
                    "Get a new color": "獲得新顏色",
                    "Choose from default colors:": "從默認顏色中選擇：",
                "Create label": "創建標籤",

            "Sort": "排序",
                "Alphabetically": "按字母順序",
                "Reverse alphabetically": "按字母倒序",
                "Most issues": "最多的議題",
                "Fewest issues": "最少的議題",

            // 標籤
                "bug": "BUG",
                    "Something isn't working": "有些東西不工作",
                "dependencies": "依賴性",
                    "Pull requests that update a dependency file": "更新一個依賴文件的拉取請求",
                "documentation": "文檔",
                    "Improvements or additions to documentation": "文檔的改進或補充",
                "duplicate": "重複",
                    "This issue or pull request already exists": "這個議題或拉取請求已經存在",
                "enhancement": "增強",
                    "New feature or request": "新功能或請求",
                "good first issue": "好的首發議題",
                    "Good for newcomers": "適合新人",
                "help wanted": "需要幫助",
                    "Extra attention is needed": "需要特別關注",
                "invalid": "無效",
                    "This doesn't seem right": "這似乎不對",
                "question": "問題",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不會修復",
                    "This will not be worked on": "這將不會被處理",

            // [/open issues? and pull requests?/, "個打開的議題和拉取請求"], // 標籤頁面
            // [/open issues? or pull requests?/, "個打開的議題或拉取請求"], // 標籤頁面

            "Convert to discussions": "轉為討論",
                // 轉換議題為討論 對話框
                "Convert issue to discussion": "轉換議題為討論",
                "Convert issues to discussions": "轉換議題為討論",
                    // [/Are you sure you want to convert (\d+) issues? with the following label to (?:a |)discussions?\?/, "您確定要將帶有以下標籤的 $1 條議題轉換為討論嗎？"],
                    // "What happens when an issue is converted into a discussion:": "將議題轉化為討論時，會發生什麼：",
                    "Issue will be locked": "議題將被鎖定",
                    // "Title, description, and author will be the same as the issue": "標題、描述和作者將與議題相同",
                    "Existing links will redirect to the new discussion": "現有鏈接將重定向至新討論",
                    // "All comments and reactions will be the same as the issue": "所有評論和反應將與議題相同",
                    "Discussions do not have tasklists": "討論沒有任務列表",
                    "Discussions do not have assignees": "討論沒有受理人",
                    "Discussions cannot be added to projects": "討論無法添加到專案",
                    "Discussions do not have milestones": "討論沒有里程碑",
                    "You must choose a category for the discussion to belong to. You will be able to change this after the conversion is complete.": "您必須為討論選擇一個所屬類別。轉換完成後，您可以更改類別。",
                    "Choose a category": "選擇類別",
                        "Announcements": "公告",
                        "General": "通常",
                        "Ideas": "想法",
                        "Polls": "投票",
                        "Q&A": "問與答",
                        "Show and tell": "展示與講述",
                    "I understand, convert issue to discussion": "我明白了，依然將議題轉換為討論",
                    "I understand, convert issues to discussions": "我明白了，依然將議題轉換為討論",
                    "Future issues with this label will not be automatically converted into discussions.": "今後帶有此標籤的議題不會自動轉換為討論。",

        // 添加/編輯議題模板 /<user-name>/<repo-name>/issues/templates/edit
            "Propose changes": "提出更改",
            "Add template:": "添加模板：",
            "select": "選擇",
            "Bug report": "錯誤報告",
                "Standard bug report template": "標準錯誤報告模板",
                "Create a report to help us improve": "創建報告以幫助我們改進",
            "Feature request": "功能要求",
                "Standard feature request template": "標準功能請求模板",
                "Suggest an idea for this project": "為這個專案提出想法",
            "Custom template": "自定義模板",
                "Blank template for other issue types": "其他議題類型的空白模板",
                "Custom issue template": "自定義議題模板",
                "Describe this issue template's purpose here.": "在此處描述此議題模板的用途。",

            "Preview and edit": "預覽和編輯",
            "Close preview": "關閉預覽",

            "Template name": "模板名稱",
            "This file lives in": "該文件位於",
            "Template content": "模板內容",
                "Styling with Markdown is supported": "支持 Markdown 格式",
            "Optional additional items": "可選附加專案",
            "Issue default title": "議題默認標題",
            "This will be suggested as the issue title": "建議作為議題標題",
                "Add a placeholder for issue title, ex. [BUG]": "設置默認議題標題，例如：[BUG]",

            "Commit changes": "提交更改",
                "Commit message": "提交信息",
                "Extended commit message": "擴展描述",
                    "Add an optional extended description": "添加描述... (可選)",
                "Commit directly to the": "提交到",
                "branch.": "分支。",

                "Some rules will be bypassed by committing directly": "直接提交可以繞過一些規則",
                "Bypass rules and commit changes": "繞過規則並提交更改",

                "Create a": "創建",
                "new branch": "新分支",
                "for this commit and start a pull request.": "為這個提交，並且發起一個拉取請求。",

        // Copilot 浮窗 獨有詞條
            "Ask about the issue:": "討論此議題：",

        // 底部提示欄（未登錄
        "to join this conversation on GitHub.": "加入 GitHub 上的這個討論。",
            "Already have an account?": "已經有賬戶？",

    },
    "regexp": [ // 正則翻譯
        [/Want to contribute to ([^ ]+)\?/, "想為 $1 做貢獻？"],
        [/Awaiting requested review from ([^ ]+)/, "正在等待 $1 審查請求"],
        [/([\d,]+) Open/, "$1 打開"],
        [/([\d,]+) Closed/, "$1 已關閉"],
        [/(#\d+) opened/, "$1 打開於"],
        [/(#\d+) by/, "$1 打開者"],
        [/(\d+) linked pull requests?/, "鏈接 $1 個拉取請求"],
        [/([\d,]+) linked issues?/, "$1 個關聯議題"],
        [/(\d+) tasks? done/, "$1 個任務完成"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 個任務"],
        [/(\d+) tasks?/, "$1 個任務"],
        [/First time contributing to ([^ ]+)\?/, "首次為 $1 做貢獻？"],

        // 具體某條議題 /<user-name>/<repo-name>/issues/<id>
        [/· ([\d,]+) comments?/, "• $1 條評論"],
        [/([\d,]+) participants?/, "$1 位參與者"],
        [/(\d+) similar comments?/, "$1 條類似評論"],
        [/(\d+) hidden items?/, "$1 條隱藏專案"],
        [/added a commit to ([^ ]+) that referenced this issue/, "為 $1 添加了引用這個議題的提交"],
        [/Only people who can see ([^ ]+) will see this reference./, "只有能看到 $1 的人才能看到這個參考。"],
        [/Sponsor ([^ ]+)?/, "贊助 $1"], // 贊助按鈕 對話框 標題
        [/Notify someone on an issue with a mention, like: @([^ ]+)./, "在議題中通過 @ 提及通知某人，例如：@$1。"], // 專業提示
        [/Edited (\d+) times?/, "已編輯 $1 次"],
        [/edited by ([^ ]+)/, "由 $1 編輯"],
        [/This issue will close when (#?\d+) is merged/, "此議題將在 $1 合併時關閉"],
        [/Opened this issue \(their first in ([^ ]+)\)/, "打開了這個議題（首次在 $1 發表）"],
        [/Duplicate current issue in ([^ ]+\/[^ ]+)/, "在 $1 中複製當前議題"],
        [/added (\d+) commits? that reference this issue/, "添加 $1 個引用此議題的提交"],
        [/This issue will close once commit ([a-f0-9]{7}) is merged into the \'([^ ]+)\' branch./, "此議題將在提交 $1 合併到 '$2' 分支後關閉。"],

        // 標籤頁面
        [/open issues? and pull requests?/, "個打開的議題和拉取請求"],
        [/open issues? or pull requests?/, "個打開的議題或拉取請求"],
        [/Are you sure you want to convert (\d+) issues? with the following label to (?:a |)discussions?\?/, "您確定要將帶有以下標籤的 $1 條議題轉換為討論嗎？"],
        [/(\d+) labels/, "$1 個標籤"],

        // 子議題
        [/Create new sub-issue in ([^ ]+)/, "在 $1 中新建子議題"],
        [/(\d+) of (\d+)/, "$1 / $2"],
        [/Filter contains (\d+) issues?\:/, "篩選包含 $1 個議題："],

        // 新版議題
        [/(.+) will be between (.+) and (.+)./, "“$1” 將在 “$2” 和 “$3” 之間。"],
        [/(.+) will not be moved./, "“$1” 將不會被移動。"],
        [/(.+) will be first item in the list./, "“$1” 將移至最前。"],
        [/(.+) will be last item in the list./, "“$1” 將移至最後。"],
        [/of (\d+) selected/, "/ $1 選中"],
        [/(\d+\%) completed/, "$1 完成"],
        [/Issue (#\d+) created/, "議題 $1 已創建"],
        [/Lines (\d+) to (\d+) in/, "第 $1 - $2 行，"],
        [/mentioned this in (\d+) issues?/, "在 $1 個議題中提及"],
        [/Create new issue in (.+)/, "在 $1 新建議題"],
        [/Close as duplicate of (\#\d+)/, "因同 $1 重複關閉"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["regexp"],
    ],
    "title": {
        "static": {
            "New Issue": "創建議題",
        },
        "regexp": [
            [/Issues?/, "議題"],
        ],
    },
};
I18N["zh-TW"]["repository/labels"] = I18N["zh-TW"]["repository/issues"];

I18N["zh-TW"]["repository/pulls"] = { // 倉庫 - 拉取請求頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["static"],

        // 倉庫 --> 拉取請求 標籤卡 /<user-name>/<repo-name>/pulls
            // 歡迎信息
            "Welcome to pull requests!": "歡迎使用拉取請求！",
            "Pull requests help you collaborate on code with other people. As pull requests are created, they’ll appear here in a searchable and filterable list. To get started, you should": "拉取請求可幫助您與其他人協作處理程式碼。創建拉取請求後，它們將出現在可搜索和可篩選的列表中。要開始，您應該",
            "create a pull request": "創建拉取請求",

            // [/First time contributing to ([^ ]+)?/, "首次為 $1 做貢獻？"], // /pulls
            "If you know how to fix an": "如果您知道如何修復一個",
            "issue": "議題",
            ", consider opening a pull request for it.": "，可考慮為它打開一個拉取請求。",
            "You can read this repository’s": "您可以閱讀該倉庫的",
            "to learn how to open a good pull request.": "，去學習如何打開一個好的拉取請求。",
            "If you would like to submit code to this repository, consider opening a pull request.": "如果您想向這個倉庫提交程式碼，請考慮打開一個拉取請求。",
            "If you would like to submit code to this repository, consider opening a pull request. You can read this repository’s": "如果您想向這個倉庫提交程式碼，請考慮打開一個拉取請求。您可以閱讀該倉庫的",

            "Label issues and pull requests for new contributors": "標記新貢獻者的議題和拉取請求",
            "Now, GitHub will help potential first-time contributors": "現在，GitHub 將幫助潛在的首次貢獻者",
            "discover issues": "探索議題",
            "labeled with": "標記為",

            "Dismiss": "忽略",
                // 忽略 下拉
                "Dismiss for this repository only": "僅對該倉庫不在提示",
                "Dismiss for all repositories": "對所有倉庫均不在提示",

            "New pull request": "發起拉取請求",

            "Reviews": "審查",
                // 篩選工作條
                "Filter by reviews": "按審查篩選",
                "No reviews": "未經審查",
                // "Review required": "需要審查",
                "Approved review": "已批准的審查",
                "Changes requested": "已請求更改",
                "Reviewed by you": "由您審查",
                "Not reviewed by you": "您未審查",
                "Awaiting review from you": "等待您審查",
                "Awaiting review from you or your team": "等待您或您的團隊的審查",
                "Awaiting review from you specifically": "特別等待您審查",

                // 篩選結果
                "There aren’t any open pull requests.": "暫無拉取請求。",

                "You commented on and opened this pull request": "您打開了此拉取請求並發表了評論",
                "You were mentioned on and commented on this pull request": "您被提及並對此拉取請求發表了評論",
                "You commented on this pull request": "您對此拉取請求發表了評論",
                "You opened this pull request": "您打開了此拉取請求",

                "Suggested change": "建議更改",

    },
    "regexp": [
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["regexp"],

        [/(\d+) reviews? requesting changes?/, "$1 個請求審查更改"],
        [/(\d+) linked issues?/, "鏈接 $1 個議題"],
        [/([\d,]+) Open/, "$1 打開"],
        [/([\d,]+) Closed/, "$1 已關閉"],
        [/(#\d+) opened/, "$1 打開於"],
        [/(#\d+) by/, "$1 打開者"],
        [/(\d+) tasks? done/, "$1 個任務完成"],
        [/(\d+) of (\d+) tasks?/, "$1 / $2 個任務"],
        [/(\d+) tasks?/, "$1 個任務"],
        [/(\d+) Total/, "$1 總計"],
        [/(\d+) review requesting changes/, "$1 個要求修改的審查"],
        [/First time contributing to ([^ ]+)\?/, "首次為 $1 做貢獻？"],
        [/Suggested change/, "建議更改"],
        [/Ears burning\? Get\@([^ ]+) mentions with/, "耳朵癢嗎？使用 @$1 查看提及："], // 專業提示
        [/Notify someone on an issue with a mention, like: \@([^ ]+)/, "在議題中通過 @ 提及通知某人，例如：@$1"],
    ],
    "title": {
        "regexp": [
            [/Pull requests/, "拉取請求"],
        ],
    },
};

I18N["zh-TW"]["repository/pull"] = { // 倉庫 - 某個拉取請求頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["static"],

        // 某條具體的拉取請求 /<user-name>/<repo-name>/pull/<id> >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 頂部提醒
                "The head ref may contain hidden characters:": "頭部引用可能包含隱藏字符：",
                "Your review was submitted on a merged pull request.": "您的審查已提交，一個合併的拉取請求。",
                "Marked pull request as ready for review.": "標記拉取請求為可審核。",
                "Your review was submitted successfully.": "您的審查已成功提交。",
                "requested your review on this pull request.": "請求審核此拉取請求。",
                // Dependabot 打開的拉取請求
                    "Merging this pull request will resolve": "合併此拉取請求將解決", // 後面警報數走正則
                    //"on rollup including a": "，包括 1 個",
                    "severity alert.": "風險警報。",

            // 快捷鍵
                "Edit pull request title": "編輯拉取請求標題",
                "Edit pull request body": "編輯拉取請求主體",

            // 編輯 -> 選擇基礎庫
            "Choose a base branch": "選擇基礎分支",
            "base:": "基礎：",
                // 更改基礎分支對話框
                "Find a branch": "搜索分支",
                "Are you sure you want to change the base?": "您確定要更改基礎分支嗎？",
                "Some commits from the old base branch may be removed from the timeline, and old review comments may become outdated.": "舊的基礎分支的一些提交可能會從時間線上刪除，而舊的審查意見可能會變得過時。",
                "Change base": "更改基礎分支",

            // 程式碼 下拉菜單
                "Code 55% faster with AI pair programming.": "與 AI 一起編程，寫程式碼速度提高55%。",
                    "Start my free trial": "開始我的免費試用",
                    "Don't show again": "不再顯示",

                "Local": "本地",
                    "Checkout with GitHub CLI": "使用 GitHub CLI 檢出",
                    "Work fast with our official CLI.": "使用我們的官方 CLI 快速工作。",
                    "Checkout with GitHub Desktop": "使用 GitHub Desktop 檢出",
                        "Launching GitHub Desktop": "GitHub Desktop 啟動中",
                        "If nothing happens,": "如果沒有響應",
                            "download GitHub Desktop": "下載 GitHub Desktop",
                            "and try again.": "並重試",

                // 程式碼空間
                    // 維護提示
                        "Codespaces is undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "程式碼空間正在維護。在此期間，用戶可能會遇到連接問題。更多詳情請訪問",
                        "Codespaces will be undergoing maintenance. Users may experience connection issues during this time, for more details please visit": "程式碼空間將進行維護。在此期間，用戶可能會遇到連接問題。更多詳情請訪問",
                        "this announcement": "此公告",
                    "This pull request must be reopened to create new codespaces on it.": "必須重新打開此拉取請求才能在其上創建新的程式碼空間。",
                    "Your workspaces in the cloud": "您在雲端的工作空間",
                    //[/Create a codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
                    "Codespace repository configuration": "程式碼空間倉庫配置",
                        "New with options...": "新建（選項）…",
                        "Configure dev container": "配置開發容器",
                        "Set up prebuilds": "設置預構建",
                        "Manage codespaces": "管理程式碼空間",
                        "Share a deep link": "分享深度鏈接",
                            "Share codespace configuration": "共享程式碼空間配置",
                            "Choose which settings from this configuration to include when sharing": "選擇共享時要包含此配置中的哪些設置",
                            "Quick start": "快速開始",
                            "Automatically create or reuse the most recent matching codespace.": "自動創建或使用最新匹配的程式碼空間。",
                            "Read more about creating a link.": "閱讀有關創建鏈接的更多信息。",
                            "Snippets": "片段",
                            "Use the following snippets to embed an “Open in Codespaces” button for this configuration in your own page or README.": "使用以下程式碼片段在您自己的頁面或 README 中嵌入此配置的 “在 Codespaces 中打開” 按鈕。",
                        "What are codespaces?": "什麼是程式碼空間？",
                    "No codespaces": "尚無程式碼空間",
                    "You don't have any codespaces with this repository checked out": "您沒有檢出此倉庫的任何程式碼空間",
                    //[/Create codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
                    "Learn more about codespaces...": "瞭解更多關於程式碼空間的信息…",

                    "On current branch": "在當前分支",
                        "No codespaces on current branch": "當前分支上沒有程式碼空間",
                    "On other branches": "在其他分支",
                    "miniature adventure": "迷你探險",
                    "Open miniature adventure in web": "在網絡中打開迷你探險",
                    "Active": "激活",
                        "Open in ...": "打開…",
                            "Open in browser": "在瀏覽器中打開",
                            "Open in Visual Studio Code": "在 Visual Studio Code 中打開",
                            "Open in JetBrains Gateway": "在 JetBrains Gateway 中打開",
                            "Open in JupyterLab": "在 JupyterLab 中打開",
                        "Rename": "重命名",
                            "Change codespace display name to...": "將程式碼空間顯示名稱更改為…",
                        "Export changes to a branch": "將更改導出到分支",
                            "This will create a new branch with any unpushed changes": "這將創建一個包含任何未推送更改的新分支",
                            "Create branch": "創建分支",
                        "Change machine type": "更改機器類型",
                            "Change codespace machine type": "更改程式碼空間機器類型",
                            "Machine type": "機器類型",
                                "2-core": "雙核",
                                "4-core": "四核",
                            "Need even more power?": "需要更多的力量？",
                            "Contact our team": "聯繫我們團隊",
                            "to enable 32-core or GPU machines.": "啟用 32 核或 GPU 機器。",
                            "Update codespace": "升級程式碼空間",
                        "Stop codespace": "停止程式碼空間",
                    "Codespace configuration": "程式碼空間設置",
                    "No changes": "未更改",

                    "Codespace usage for this repository is paid for by": "該倉庫的程式碼空間使用費由以下人員支付",

                    "You seem to have a billing issue. Please adjust your billing settings to continue using codespaces.": "您似乎遇到了賬單問題。請調整您的賬單設置以繼續使用程式碼空間。",

                    // 被拉黑
                        "Repository access limited": "倉庫訪問受限",
                            "You do not have access to push to this repository and its owner has disabled forking.": "您無權推送到此倉庫，其所有者已禁用了複刻。",

                    // [/Codespace \"(.+)\" stopped./, "程式碼空間 “$1” 已停止。"],
                    // [/Codespace \"(.+)\" deleted./, "程式碼空間 “$1” 已刪除。"],
                    // [/Are you sure you want to delete (.+)\?/, "您確定要刪除 $1 嗎？"],

                // Copilot
                    "Describe a change you'd like to make to this pull request, such as adding tests or documentation...": "描述您想對此拉取請求進行的更改，例如添加測試或文檔…",
                    "Start task": "開始任務",
                    "You can ask Copilot to make changes to this pull request by mentioning @copilot in a comment.": "您可以在評論中提及 @copilot，讓 Copilot 對此拉取請求進行更改。",
                    "Copilot generated this review using guidance from": "Copilot 生成此次審查，使用",
                        "repository custom instructions": "倉庫自定義指令",

            // 自動修復漏洞 提示
                "This automated pull request fixes a": "這個自動拉取請求將修復了一個",
                "security vulnerability": "安全漏洞",
                "Only users with access to Dependabot alerts can see this message.": "只有有權訪問 Dependabot 警報的用戶才能看到此消息。",
                "Learn more about Dependabot security updates": "瞭解更多關於 Dependabot 安全更新的信息",
                "opt out": "選擇退出",
            // 頂部提醒
                "Opted out of Dependabot security updates.": "選擇退出 Dependabot 安全更新。",

            // Dependabot 警報 拉取請求 提示
                "Merging this pull request will resolve a": "合併此拉取請求將解決",
                "high": "高",
                "severity": "嚴重性",
                "Dependabot alert": "Dependabot 警報",
                "on": "：",
                // 首次彈窗
                    "Your first automated security update": "您的第一個自動安全更新",
                        "Dependabot security updates keep your projects secure and up-to-date.": "Dependabot 安全更新使您的專案安全且最新。",
                        "You can opt out at any time in": "您可以在任何時候選擇退出在",
                        "this repository’s settings": "倉庫設置",
                        "Got it!": "我知道了",

                // 合併後頂部提醒
                    // [/This pull request resolved a Dependabot alert on ([^ ]+)./, "該請求解決了 $1 的 Dependabot 警報問題。"],

            // 狀態詞
            // [/merged (\d+) commits? into/, "將 4 個提交合併到"],
            "into": "到",
            // "merged": "已合併",
            "wants to merge": "希望合併",
            "commit into": "個提交到",
            "commits into": "個提交到",
            "from": "來自",
            "closed this": "關閉了這個",
            "reopened this": "重新打開了這個",
            "added a commit that referenced this pull request": "添加了引用此拉取請求的提交",
            "removed the request for review from": "取消請求審查",
            "pushed a commit that referenced this pull request": "推送了一個引用此拉取請求的提交",
            "suggested changes": "建議更改",
            "deleted the branch": "刪除了分支",
            "deleted a comment from": "刪除了評論從",
            // Copilot 專屬狀態詞
            "started work": "開工",
            "on behalf of": "代表",
                "View session": "查看",
            "finished work on behalf of": "完工，代表",
            "stopped work on behalf of": "停工，代表",
                "due to an error": "因為錯誤",

            // 標籤欄
            "Conversation": "討論",
            // 提交
                "No new commits": "無新提交", // 下方句子走正則
                "was force-pushed and no longer has any new commits. Pushing new commits will allow the pull request to be re-opened.": "分支已強制推送，並且不再包含任何新的提交。推送新的提交將允許重新打開拉取請求。",
            "Checks": "檢查",
                "Search logs": "搜索日誌",
                "Pushing new commits will allow the pull request to be re-opened.": "推送新的提交將允許重新打開拉取請求。", // 上面的句子走正則
            "Files changed": "更改的文件",
                "No changes to show.": "無更改顯示。", // 刪除複刻倉庫的提交時出現
                "This commit has no content.": "該提交無內容。", // 同上
              "authored": "撰寫於",

            // 右側欄 補充
                // 審查者
                "Reviewers whose approvals may not affect merge requirements": "審查者的批准可能不影響合併要求。",

                "Allow edits by maintainers": "允許維護者進行編輯",
                    "Allowing edits by maintainers": "允許維護者進行編輯",
                    "If checked, users with write access to": "若勾選此項，擁有對",
                    "can add new commits to": "具有寫入權限的用戶可以在您的",
                    "branch.": "分支上添加新的提交。",
                    "You can always change this setting later.": "您可以隨時修改此設置。",
                    "Note: By granting write access, maintainers could potentially edit your repository's workflows to reveal values of secrets and gain access to other branches.": "注意：通過授予寫入權限，維護者可能會編輯您倉庫的工作流程以揭示機密值，並獲取對其他分支的訪問權限。",
                    "Got it": "知道了",
                    "If checked,": "如果選中，",
                    // [/users with write access to ([^ ]+) can add new commits/, "對 $1 具有寫權限的用戶可以添加新的提交"], // 具體拉取請求
                    "to your": "到您的",
                    "branch. You can always change this setting later.": "分支。您以後可以隨時更改此設置。",
                "Allow edits and access to secrets by maintainers": "允許維護者編輯和訪問機密",
                    "Maintainers could potentially edit this repository's workflows to reveal values of secrets and gain access to other branches.": "維護者有可能編輯這個倉庫的工作流程來獲取機密值，並獲得對其他分支的訪問。",

                "Maintainers are allowed to edit this pull request.": "允許維護者編輯此拉取請求。",

                // 進展
                    "In progress": "進行中",
                    "started": "開始於",
                    "Copilot is done": "Copilot 已完成",
                    "Copilot has failed": "Copilot 已失敗",
                    "completed after": "總耗時", // 示例：總耗時 11分45秒
                    "failed after": "失敗於",

            // 討論標籤卡 主頁
            "Refresh": "刷新",

            "marked this pull request as draft": "將此拉取請求標記為草案",
            "First-time contributor": "首次貢獻者",
            // [/This user is a first-time contributor to the ([^ ]+) repository./, "該用戶是第一次為 $1 倉庫做貢獻。"]
            "View changes": "查看更改",
            "Outdated": "陳舊的",
            "Resolve conversation": "轉為已解決對話",
                "Resolving conversation…": "正在轉為已解決對話……",
            "Unresolve conversation": "轉為未解決對話",
                "Unresolving conversation…": "正在轉為未解決對話……",
                "marked this conversation as resolved.": "已將此對話標記為已解決。",
            "Changes requested": "更改請求",
            "Change requested": "更改請求",
            "Show resolved": "顯示已解決",
            "Hide resolved": "隱藏已解決",
            "Reviews": "審查",
            "Show all reviewers": "顯示所有審查者",
            "Hide all reviewers": "隱藏所有審查者",
            "New changes since you last viewed": "自您上次查看以來的新變化",
            "mentioned this pull request": "提及這個拉取請求",
            "linked an issue": "鏈接議題",
            "that may be": "將在該拉取請求合併時",
            "closed": "關閉",  // 浮動小字走正則
            "by this pull request": " ",
            "dismissed": "駁回",
            "\’s": " 的",
            "stale review": "陳舊審查",
            "via": "通過",
            "force-pushed": "強制推送",
            "enabled auto-merge (squash)": "啟用自動合併（壓縮）",
            "the": " ",
            "branch from": "分支從",
            "and others": "和其他成員",
            "previously": "預先",
            "approved these changes": "批准這些更改",
            "previously approved these changes": "預先批准這些更改",
                "See review": "查看審查",
                "Dismiss review": "駁回審查",
            "started a review": "開始審查",
                "View reviewed changes": "查看已審核的更改",
            "self-requested a review": "自我要求審查",
            "self-assigned this": "已自我審查",
            "unassign me": "取消自我分配",
            "marked this pull request as ready for review": "已將此拉取請求標記為可審核",
            "merged commit": "合併提交",
            "left a comment": "發表評論",
            "Add more commits by pushing to the": "添加更多提交，通過推送到",
            "branch on": "分支在",
            "requested review from": "請求審查",
                "a team": "團隊",
                "as a": "作為",
                "code owner": "程式碼所有者",
            "started reviewing": "開始審查",
            "finished reviewing on behalf of": "完成審查，代表",
            "This pull request was": "此拉取請求已",
            "Compare": "比較",
            "deleted the": "刪除",
            "branch": "分支",
            "added": "添加",
            "requested changes": "要求更改",
            "changed the title": "修改了標題",
            "changed the base branch from": "更改基礎分支從",
            "added the": "添加",
            "label": "標籤",
            "closed this": "已關閉",
            "reopened this": "已重新打開",
            "closed this by deleting the head repository": "已關閉因倉庫已刪除",
            "Requested changes": "請求更改",
            "restored the": "恢復",
            "unlocked this conversation": "解鎖此對話",
            "added this to the": "添加到",
            "milestone": "里程碑",
            "review requested due to automatic review settings": "因設置自動審查",

            //
            "This branch has not been deployed": "該分支尚未部署",
            "No deployments": "未部署",

            // 拉取請求狀態
            "Review requested": "請求審查",
            "Review has been requested on this pull request. It is not required to merge.": "此拉取請求已請求進行審查。這不是合併的必要條件。",
            "Learn more about requesting a pull request review.": "瞭解更多關於申請拉取請求審核的信息。",
            // [/(\d+) pending reviewers?/, "$1 名待審者"],
            "was requested for review": "被請求審查",

            "Changes reviewed": "更改已審查",
                "No applicable reviews submitted by reviewers with write access.": "沒有具有寫入權限的審查者提交適用的審查意見。",

            // 已請求更改
                // [/(\d+) reviews? requesting changes by reviewers with write access./, "$1 條評論請求更改由具有寫入權限的審查者進行更改。"], // 拉取請求

            "All conversations are resolved": "所有對話均已解決",
                // [/(\d+) resolved conversations?/, "2 條對話已解決"], // 拉取請求

            "No unresolved conversations": "沒有未解決的對話",
                "There aren't yet any conversations on this pull request.": "此拉取請求尚無任何對話。",

            "This pull request is still a work in progress": "此拉取請求仍在進行中",
                "Ready for review": "準備審核",
                "Draft pull requests cannot be merged.": "拉取請求草案不能合併。",
            "This pull request can be automatically merged by project collaborators": "此拉取請求可以由專案協作者自動合併",
                "Only those with": "只有對此倉庫具有",
                "write access": "寫入訪問權限",
                "to this repository can merge pull requests.": "的才可合併拉取請求。",
                "to this repository can mark a draft pull request as ready for review.": "的才可將拉取請求草案標記為可供審查。",

            // "Review required": "需要審查", // 拉取請求 頁面狀態詞
                "Add your review": "添加您的評論",
                // [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有寫入權限的審查者至少需要 $1 次批准審查。"],
            "Code owner review required": "需要程式碼所有者審核",
                "was requested for review as a code owner": "要求以程式碼所有者身份進行審查",
            "Conversation resolution required": "需要解決對話",
                "A conversation must be resolved before this pull request can be merged.": "在合併此拉取請求前，必須先解決對話。",
            "Learn more about pull request reviews.": "瞭解更多關於拉取請求審核的信息。",
            "Changes approved": "變更已獲批准",
            "Approval not required": "不需要批准",
            "This pull request may be merged without approvals.": "可以在沒有批准的情況下合併此拉取請求。",
            // [/(\d+) approving reviews? by reviewers? with write access./, "$1 個批准的審查由具有寫入權限的審查者進行審查。"],
            // [/(\d+) approvals?/, "$1 項批准"],
            "Some checks haven’t completed yet": "有些檢查還沒有完成",
            // [/1 in progress check/, "$1個正在進行的檢查"],
            "Some checks were not successful": "有些檢查不成功",
            // [/1 skipped, 4 successful, and 2 failing checks/, "$1 個跳過, $2 個成功, $3 失敗"],
            // [/1 skipped, 4 successful, and 2 expected checks/, "$1 個跳過, $2 個成功, $3 個預先檢查"],
            "All checks have passed": "所有檢查均已通過",
            "All checks have failed": "所有檢查均失敗",
            // [/5 successful checks/, ""],
            // [/6 checks passed/, ""],
                "Show all checks": "顯示所有檢查",
                "Hide all checks": "隱藏所有檢查",
                "Details": "細節",
                "Required": "必須",
                "Checks settings": "檢查設置",
                    "Group by status": "按狀態分組",
                    "No grouping": "不分組",
            "Unresolved conversations": "未解決的討論",
                // [/(\d+) conversations? must be resolved before merging./, "合併之前必須解決 $1 個對話。"],
            "No conflicts with base branch": "與基礎分支沒有衝突",
                "Changes can be cleanly merged.": "更改可以被幹淨地合併。",

                "Update branch options": "更新分支選項",
            "Merging is blocked": "合併被阻止",
                "Commits must have verified signatures.": "提交必須驗證簽名。",
                "The base branch requires all conversations on code to be resolved.": "基礎分支要求解決所有關於程式碼的對話。",
                "The base branch requires all commits to be signed.": "基礎分支要求所有提交都經過簽名。",
                "Learn more about signing commits.": "瞭解更多關於簽名提交的信息。",
                "View rules": "查看規則",
                // 無權提交
                "You're not authorized to push to this branch. Visit": "您沒有權限推送到此分支。請訪問",
                    "for more information.": "獲取更多信息。",
                // 新版合併界面
                "Merge is not an allowed merge method in this repository.": "合併不是此倉庫允許的合併方法。",
                "Pull request cannot be merged because it has a merge conflict.": "由於存在合併衝突，無法合併拉取請求。",
                "User does not have push access to the repository.": "用戶無權推送到此倉庫。",
                "You're not authorized to push to this branch. Visit https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-protected-branches/about-protected-branches for more information.": "您無權推送到該分支。請訪問 https://docs.github.com/repositories/configuring-branches-and-merges-in-your-repository/managing-protected-branches/about-protected-branches 瞭解更多信息。",

                // 繞過規則合併
                "Merge without waiting for requirements to be met (bypass rules)": "無需等待滿足要求即可合併（繞過規則）",
                "Bypass rules and merge": "繞過規則合併",
                    "Confirm bypass rules and merge": "確認繞過規則合併",
                "Bypass rules and merge (squash)": "繞過規則合併（壓縮）",
                    "Confirm bypass rules and merge (squash)": "確認繞過規則合併（壓縮）",
                "Bypass rules and merge (rebase)": "繞過規則合併（變基）",
                    "This will rebase your changes and merge them into": "將更改變基合併到",
                    "Confirm bypass rules and merge (rebase)": "確認繞過規則合併（變基）",

            "Merging can be performed automatically once the requested changes are addressed.": "一旦請求的更改得到解決，合併就可以自動執行。",
            "This branch is out-of-date with the base branch": "此分支相比基礎分支已過時",
                "Merge the latest changes from": "將",
                "into this branch.": "的最新更改合併到此分支中。",
                    "Update branch": "更新分支",
                        "Update with merge commit": "使用合併提交更新",
                            "The latest changes will be merged into this branch with a merge commit.": "最新的更改將通過合併提交合併到此分支中。",
                            "The merge commit will be associated with your account.": "合併提交將與您的賬戶相關聯。",
                        "Update with rebase": "使用變基更新",
                            "This branch cannot be rebased due to conflicts.": "由於衝突，此分支不能變基。",
                            "This pull request will be rebased on top of the latest changes and then force pushed.": "此拉取請求將會在最新的更改之上進行變基，並且會使用強制推送的方式提交。",
                            "This branch cannot be rebased due to conflicts": "由於衝突，無法對此分支執行變基操作。",
                // [/Merge the latest changes from ([^ ]+) into this branch. This merge commit will be associated with ([^ ]+)./, "將最新更改從 $1 分支合併到當前分支。該合併提交將與用戶 $2 相關聯。"],

            "The base branch restricts merging to authorized users.": "基礎分支合併僅限於授權用戶。",
            "Learn more about protected branches.": "瞭解更多關於受保護分支的信息。",
            // [/Merging can be performed automatically with (\d+) approving review./, "合併可以通過 $1 次批准審查自動執行。"],
            "Merge without waiting for requirements to be met (bypass branch protections)": "合併而無需等待需求滿足（繞過分支保護）。",
                "Extended description": "擴展描述",
                "Add an optional extended description…": "添加可選的擴展描述…",
                // [/This commit will be authored by ([^@]+@[^\n]+)/, "此提交的作者是 $1"],
            "Checks awaiting conflict resolution": "等待衝突解決",

            // 合併失敗提示
                "Merge attempt failed": "合併嘗試失敗",
                "We couldn’t merge this pull request. Reload the page before trying again.": "我們無法合併此請求。重新加載頁面後再試。",

            // [/(\d+) workflow awaiting approval/, "$1 個工作流等待批准"],
            "First-time contributors need a maintainer to approve running workflows.": "首次貢獻者需要維護者來批准正在運行的工作流。",
            "The base branch does not accept merge commits. Alternate merge methods are preferred.": "基礎分支不接受合併提交。其他合併方法是首選。",
            // [/The ([^ ]+) branch requires linear history/, "$1 分支為要求線性歷史記錄"],
            "Learn more about required linear history.": "瞭解更多關於要求線性歷史記錄的信息。",

            "Checking for the ability to merge automatically...": "檢測自動合併的能力…",
            "Hang in there while we check the branch's status.": "請等待，我們正在檢查該分支的狀態",

            "Required statuses must pass before merging": "合併前必須通過所需的狀態",
            "All required": "所有必需",
            "statuses": "狀態",
            "and check runs on this pull request must run successfully to enable automatic merging.": "和檢查運行在該拉取請求上必須成功運行，才能啟用自動合併。",

            "Continuous integration has not been set up": "尚未設置持續集成",
            "several other apps": "其他一些應用",
            "can be used to automatically catch bugs and enforce style.": "可用於自動捕獲錯誤和強制執行樣式。",

            "This branch has no conflicts with the base branch": "該分支與基礎分支沒有衝突",
            "No conflicts with base branch": "與基本分支無衝突",
                "Merging can be performed automatically.": "可以自動地執行合併。",
                "Changes can be cleanly merged.": "可以乾淨地合併更改。",

            "This branch has no conflicts with the base branch when rebasing": "該分支基變時與基礎分支沒有衝突。",
                "Rebase and merge can be performed automatically.": "可以自動執行變基和合併。",

                "You’re not": "您無",
                "authorized": "權限",
                "to merge this pull request.": "合併此拉取請求。",

            "Merge pull request": "合併拉取請求",
                "Merging is blocked due to failing merge requirements": "由於未滿足合併要求，合併已被阻止。",
            // 合併拉取請求 按鈕下拉
            "Select merge method": "選擇合併方式",
                "Create a merge commit": "創建合併提交",
                    "All commits from this branch will be added to the base branch via a merge commit.": "該分支的所有提交都將通過合併提交加入到基礎分支中。",
                    "Not enabled for this repository": "未為此倉庫啟用",
                "Squash and merge": "壓縮合併",
                    // [/The (\d+) commits? from this branch will be added to the base branch./, "該分支的 $1 個提交將合併到基本分支中。"],
                "Rebase and merge": "變基合併",
                    // [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "該分支的 $1 個提交將變基合併到基礎分支中。"],
                    "Failed to load repo merge settings": "無法加載倉庫合併設置",

            //確認合併 對話框
                // 新版合併界面
                "Commit header": "提交標題",
                "Commit message": "提交信息",
                "This commit will be authored by": "此提交的作者是",
            "Confirm merge": "確認合併",
            "Confirm squash and merge": "確認壓縮合併",
            "Confirm rebase and merge": "確認變基合併",
            "Merging…": "合併中…",

            "You can also": "您也可以",
            "open this in GitHub Desktop": "在 GitHub Desktop 中打開",
            "or view": "，或查看",
            "You can also merge this with the command line, view": "您也可以使用命令行合併，查看",
            "command line instructions": "命令行指令",
            "You can also merge this with the command line.": "您也可以使用命令行合併。",
            "View command line instructions.": "查看命令行指令。",

            // "Merged": "已合併",
            "More actions": "更多操作",
            "View details": "查看詳情",
            "Hide details": "隱藏詳情",
            "Revert": "還原",
                "Create a new pull request to revert these changes": "創建一個新的拉取請求以恢復這些更改",
            "Closed with unmerged commits": "已關閉的未合併的提交",
                "This pull request is closed.": "此拉取請求已關閉。",

            "Pull request successfully merged and closed": "拉取請求已成功合併並關閉",
                "You're all set — the": "一切就緒",
                "branch has been merged and deleted.": "分支已合併並刪除。",
                "You're all set — the branch has been merged.": "一切就緒 - 該分支已合併。",
            "Delete branch": "刪除分支",
            "Restore branch": "恢復分支",

            "Pull request closed": "拉取請求已關閉",
            "This pull request is closed, but the": "此拉取請求已關閉，但是",
            "branch has unmerged commits.": "分支具有未合併的提交。",
            "branch has unmerged commits. You can delete this branch if you wish.": "分支具有未合併的提交。您可以根據需要刪除此分支。",
            "If you wish, you can also delete this fork of": "如果需要，還可以刪除此複刻",
            "If you wish, you can delete this fork of": "如果需要，可以刪除此複刻",
            "in the": "在",
            "settings": "設置",

            // "Only those with": "只有對此倉庫具有",
            // "write access": "寫入訪問權限",
            // "to this repository can merge pull requests.": "的才可合併拉取請求。",
            "You’re all set — the": "一切就緒 —",
            "You’re all set—the": "一切就緒 —",
            "branch can be safely deleted.": "分支可以被安全刪除。",
            "This branch has conflicts that must be resolved": "該分支存在衝突，必須解決",
                "Resolve conflicts then push again. These conflicts are too complex to resolve in the web editor. Actions workflows will not trigger on activity from this pull request while it has merge conflicts.": "解決衝突後再次推送。這些衝突過於複雜，無法在 Web 編輯器中解決。當該拉取請求存在合併衝突時，操作工作流將不會觸發該拉取請求的活動。",
                "These conflicts are too complex to resolve in the web editor.": "這些衝突過於複雜，無法在網頁編輯器中解決。",
                "You do not have permission to push to the head branch.": "您沒有權限向主分支推送。",
                "Use the command line": "使用命令行",
                "to resolve conflicts before continuing.": "解決衝突後再繼續。",
                "or the command line to resolve conflicts before continuing. Actions workflows will not trigger on activity from this pull request while it has merge conflicts.": "或通過命令行解決衝突。在此拉取請求仍存在合併衝突的情況下，操作工作流不會因該拉取請求的活動而觸發。",
                "or the command line to resolve conflicts before continuing.": "或通過命令行解決衝突後再繼續。",
                "Use the command line to resolve conflicts before continuing.": "使用命令行解決衝突後再繼續。",

                "Checkout via command line": "通過命令行檢出",
                "Checkout via the command line": "通過命令行檢出", // 新版合併界面
                "If the conflicts on this branch are too complex to resolve in the web editor, you can check it out via command line to resolve the conflicts.": "如果該分支上的衝突過於複雜，無法在 Web 編輯器中解決，您可以通過命令行檢出來解決衝突。",
                "If you do not want to use the merge button or an automatic merge cannot be performed, you can perform a manual merge on the command line. However, the following steps are not applicable if the base branch is protected.": "如果不想使用合併按鈕或無法執行自動合併，可以在命令行上執行手動合併。但若基本分支受到保護，則不適用以下步驟。", //新版合併界面
                "Step": "步驟", // 新版合併界面
                "Step 1:": "第 1 步：",
                    "From your project repository, check out a new branch and test the changes.": "從專案倉庫中，檢出新分支並測試更改。",
                    "Clone the repository or update your local repository with the latest changes.": "克隆倉庫或使用最新更改更新本地倉庫。",
                "Step 2:": "第 2 步：",
                    "Merge the changes and update on GitHub.": "合併更改並在 GitHub 上更新。",
                    "Switch to the head branch of the pull request.": "切換到拉取請求的頭部分支。",
                "Step 3:": "第 3 步：",
                    "Merge the base branch into the head branch.": "將基礎分支合併至頭部分支。",
                "Step 4:": "第 4 步：",
                    "Fix the conflicts and commit the result.": "修復衝突並提交。",
                    "See": "查閱",
                        "Resolving a merge conflict using the command line": "使用命令行解決合併衝突",
                        "for step-by-step instructions on resolving merge conflicts.": "的分步說明。",
                "Step 5:": "第 5 步：",
                    "Push the changes.": "推送更改。",
                // 新版合併界面 複製按鈕
                    "Copy clone URL": "複製克隆鏈接",
                    "Copy clone command": "複製克隆命令",
                    "Copy checkout command": "複製切換命令",
                    "Copy merge command": "複製合併命令",
                    "Copy push command": "複製推送命令",

            "Resolve conflicts": "解決衝突",
                "Use the": "使用",
                "web editor": "Web 編輯器",
                "or the": "或",
                "command line": "命令行",
                "to resolve conflicts.": "來解決衝突。",
                "These conflicts are too complex to resolve in the web editor": "這些衝突過於複雜，無法在網頁編輯器中解決",
            "Conflicting files": "衝突的文件:",

            "Require approval from specific reviewers before merging": "合併前需要特定審查者的批准",
                "Branch protection rules": "分支保護規則",
                "Rulesets": "規則集",
                "ensure specific people approve pull requests before they're merged.": "確保特定人員在合併之前批准拉取請求。",
            "Add rule": "添加規則",
            // [/Ensure specific people or teams approve pull requests before they're merged into your ([^ ]+) branch./, "確保特定的人或團隊在拉取請求被合併到您的 $1 分支之前批准它們。"], // 合併拉取請求

            // [/(\d+) workflows? awaiting approval/, "$1 個工作流程等待批准"],
            "This workflow requires approval from a maintainer.": "此工作流程需要維護者批准。",
            "Learn more about approving workflows.": "瞭解更多關於批准工作流程的信息。",
            "Approve and run": "批准並運行",
            "Approve and run workflows": "批准並運行工作流程",
            "Approve workflows to run": "批准運行工作流程",

            // 狀態詞
            "reviewed": "審查",
            "requested a review from": "請求審查",
            "Reply...": "回覆…",

            // 程式碼審查回覆
            "Suggestions cannot be applied on outdated comments.": "建議不要應用於過時的評論。",
            "Suggested change": "更改建議",
            "This code change can be committed by users with write permissions.": "具有寫入權限的用戶可以提交此程式碼更改。",

            "This branch was successfully deployed": "該分支已成功部署",
            "Show environments": "顯示環境",
            // [/(\d+) active deployments?/, "$1 個活動的部署"],

            // 評論輸入框選項，僅PR界面有
                "Copilot actions": "Copilot 操作",
                   "Generate": "生成",
                   "Summary": "總結",
                   "Generate a summary of the changes in this pull request.": "生成此拉取請求的更改摘要。",
                "Summarizing changes… this might take a minute": "總結更改…這可能需要 1 分鐘",

        // 拉取請求 --> 提交 標籤卡 /<user-name>/<repo-name>/pull/<id>/commits
            // 頂部提示
                "This pull request is big! We're only showing the most recent 250 commits": "該拉取請求過大！僅顯示最近 250 次提交",
            "Commits": "提交",
            // [/Commits (.+)/, "提交於 $1"]
            "committed": "提交於",

            "Copy the full SHA": "複製完整的 SHA",
            "View commit details": "查看提交詳情",
            "Browse the repository at this point in the history": "瀏覽該階段的歷史倉庫內容",

        // 拉取請求--> 提交 --> 某提交詳情/<user-name>/<repo-name>/pull/<id>/commits/<full SHA>
            "commit": "提交",
            // 修改的文件 左側 展開按鈕
            "Expand all": "展開全部",
            "Expand All": "展開全部",
            "Collapse expanded lines": "摺疊展開行",
            "Expand Up": "向上展開",
            "Expand Down": "向下展開",

            // 修改的 yaml 文件，預覽窗口
            "Loading Dependency Review...": "正在加載依賴審查…",
            "No dependencies changed.": "未更改依賴。",
                "The changes to this file likely do not affect the dependencies": "對此文件的更改可能不會影響依賴",

            "Give feedback on": "提交反饋，在",
                "dependency review": "依賴項審查",

            // 修改的文件 右側下拉
            "Show comments": "顯示評論",
            "Show annotations": "顯示註釋",
            "View file": "查看文件",
            "Edit file": "編輯文件",
            "Delete file": "刪除文件",
            "Open in desktop": "在 GitHub Desktop 中打開",
            "Copilot is not available for this file type": "Copilot 不支持此文件類型",

            // 上一頁
            "You are viewing the earliest commit": "您正在查看最早的提交",
            // 下一頁
            "You are viewing the latest commit": "您正在查看最新的提交",

            "This merge commit was added into this branch cleanly.": "該合併提交被幹淨利落地添加到該分支中。",
                "There are no new changes to show, but you can still": "沒有新的更改可顯示，但您仍然可以",
                "view the diff.": "查看差異。",

            // 中間
            "Loading branch information": "正在加載分支信息",

            "Some comments aren't visible on the classic Files Changed page.": "某些評論在傳統更改的文件頁不可見。",

        // 拉取請求 --> 更改的文件 標籤卡 /<user-name>/<repo-name>/pull/<id>/files
            // 網絡錯誤
            "There was an issue loading this file": "加載此文件時出錯",
                "Try refreshing the page or if the problem persists": "請嘗試刷新頁面，如果問題仍然存在，請",
                    "contact support": "聯繫支持人員",

            "Try the new experience": "嘗試新體驗",
            // 工具條
            "Browse files": "瀏覽文件", // 兩個提交的比較頁面

            "Show file tree": "顯示文件樹",
            "Hide file tree": "隱藏文件樹",
            "Changes from": "更改自",
                "all commits": "所有提交",
                // 下拉
                "Show all changes": "顯示所有更改",
                // [/(\d+) commits?/, "$1 條提交"],
                "Show changes since your last review": "顯示自您上次評論以來的更改",
                // "You haven‘t reviewed this pull requeste": "您尚未審查過此請求請求",
                "You haven’t reviewed this pull request yet": "您尚未審查此請求請求",
                "Select commit": "選擇提交",
                "Hold shift + click to select a range": "按住 shift + 單擊以選擇一個範圍",
            "File filter": "文件篩選",
                "Filter by extension": "按文件後綴名篩選",
                    "No extension": "無後綴名",
                    // [/All (\d+) file types? selected/, "所有 $1 種文件類型被選中"],
                    // [/Select all 1 file types?/, "選擇所有 $1 種文件類型"],
                    "Only manifest files": "僅清單文件",
                "There are no files selected for viewing": "沒有選擇要查看的文件",
                "Viewed files": "查看過的文件",
                // "filter file types": "篩選文件類型",
                // "filter viewed files": "篩選已查看文件",
                // "hide viewed files": "隱藏已查看文件",
                // "filter by context": "按內容篩選",
            "Clear filters": "清除篩選",
            "Conversations": "討論",
            "Jump to conversation": "跳轉到討論",
                "Give feedback": "反饋",
                // [/Unresolved conversations/, "未解決的討論"],
                "Nice work!": "幹得好！",
                "All of your conversations have been resolved.": "您的所有討論都已解決。",
                // [/Resolved conversations/, "已解決的討論"],
                "No conversations yet": "尚無討論",
                "Review conversations will show up here.": "審查討論將顯示在這裡。",
            // "Jump to": "跳轉到",
                "Jump to file": "跳轉到文件",
                "Filter changed files": "篩選已更改文件",
                    "No files found.": "未找到文件。",
            // 差異視圖
                "Diff view": "差異視圖",
                // "Always": "總是",
                "Unified": "同屏",
                "Split": "分屏",
                // "Just for now": "僅當前",
                // "Hide whitespace changes": "隱藏空白更改",
                "Hide whitespace": "隱藏空白",
                "Apply and reload": "應用並重新加載",
            "Show whitespace": "顯示空白",
            "Expand file": "展開文件",
            "Collapse file": "摺疊文件",
            // "Refresh": "刷新",
            // 複製文件按鈕
                "Copy file name to clipboard": "複製文件名到剪切板",
            
            "Open overview side panel": "打開概覽側邊欄",
                "Close overview panel": "關閉", // 過於囉嗦省略
            // 評論
                "No replies": "無回覆",

            "files viewed": "查看過的文件",
                "Marking files as viewed can help keep track of your progress, but will not affect your submitted review": "將文件標記為已查看可以幫助您跟蹤進度，但不會糾正您提交的審查",
            // 諮詢 Copilot
                "Loading Copilot features…": "加載 Copilot 功能…",
                "Copilot is not available for this pull request": "Copilot 不可用於此拉取請求",
            "Review in codespace": "在程式碼空間中審查",
            // "Review changes": "審查更改", // 使用 Selector 規則翻譯
                // 下拉
                "Finish your review": "完成審查",
                    "Submit general feedback without explicit approval.": "未批准，並提出一般性反饋意見。",
                "Approve": "批准",
                    "Submit feedback approving these changes.": "批准，並提出反饋意見。",
                    "Submit feedback and approve merging these changes.": "提交反饋意見並批准合併這些更改。",
                    "Pull request authors can’t approve their own pull request.": "拉取請求作者無法批准自己的拉取請求。",
                    "Only users with explicit access to this repository may approve pull requests": "只有對這個倉庫有明確訪問權限的用戶才能批准拉取請求",
                "Request changes": "請求更改",
                    "Submit feedback suggesting changes.": "請求更改，並提出更改反饋意見。",
                    "Submit feedback that must be addressed before merging.": "提交合併前必須解決的反饋意見",
                    "Pull request authors can’t request changes on their own pull request.": "拉取請求作者不能在自己的拉取請求上請求更改。",
                    "Only users with explicit access to this repository may request changes to pull requests": "只有對這個倉庫有明確訪問權限的用戶才能請求更改拉取請求",
                "Abandon review": "放棄審核",
                "Submit review": "提交審查",
                    // 頂部提醒
                        "You need to leave a comment indicating the requested changes.": "您需要留下評論，說明所要求的更改。",
                "Cancel review": "取消審核",
                "pending": "條待處理",
                "comment": "評論",
                "comments": "評論",

            "Review changes": "審查更改",
                // 被鎖定
                "This conversation has been locked and limited to collaborators.": "此對話已鎖定，並限制與協作者對話。",

            "Viewed": "已查看",
            "Comment on this file": "評論此文件",
            "Comment on file": "評論此文件",

            "No changes to show": "沒有更改",
                "This commit does not include any file changes": "此提交未包含文件更改",

            "Load diff": "載入差異", // old 待清理
            "Load Diff": "載入差異", // new
            "This file was deleted.": "該文件已被刪除",
            "Large diffs are not rendered by default.": "默認情況下，大的差異不會被呈現。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默認不呈現。瞭解更多信息關於",
            "how customized files appear on GitHub": "更改文件在 GitHub 中的顯示方式", // old 待清理
            "customizing how changed files appear on GitHub.": "自定義更改文件在 GitHub 中的顯示方式。", // new
            "File renamed without changes.": "文件僅重命名，內容沒有更改。",
            "File renamed without changes": "文件僅重命名，內容沒有更改",
            "Binary file not shown.": "不顯示二進制文件。",
            "Display the source diff": "顯示源差異",
            "Display the rich diff": "顯示富差異",
                "Added": "增加",
                "Deleted": "刪除",
                "2-up": "並排",
                "Swipe": "拖拽",
                "Onion Skin": "漸變",

            "These merge commits were added into this branch cleanly.": "這些合併提交已被幹淨利落地添加到該分支中。",
                "There are no new changes to show.": "沒有任何新的變化。",

            // 未更改文件檢查註釋(GA 檢查)
                "Unchanged files with check annotations": "帶檢查註釋的未更改文件",
                    "View workflow job for this annotation": "查看此註釋的工作流程作業",

            // 程式碼評論
                "Comment on lines": "評論行",
                "Commenting on lines": "評論行",

            // Copilot 菜單
                "Ask Copilot about this diff": "與 Copilot 討論此差異",
                    "Copilot is not available for this file type": "Copilot 不支持此文件類型",
                "Ask Copilot about this file-diff": "與 Copilot 討論此文件差異",
                "Copilot menu": "Copilot 菜單",
                    "Explain": "解釋",
                    "Attach to current thread": "附加到當前主題",
                    "Reference added to thread": "已附加至主題", // 左下角浮窗
                    "Ask about this diff": "詢問此差異",

                "Select files to discuss": "選擇文件討論",
                    "Copilot is not available for this file": "Copilot 不支持此文件",
                    "Start chat": "開始聊天",

            // 建議更改
                "Suggested change": "建議更改",
                "Sign off and commit suggestion": "簽署並提交建議",
                    "Suggestions cannot be applied from pending reviews.": "無法應用待審核中的更改",
                    "This suggestion has been applied or marked resolved.": "該建議已被應用或標記為已解決。",
                    "Outdated suggestions cannot be applied.": "過時建議不能應用。",
                "Add suggestion to batch": "批量添加建議",
                    "Add this suggestion to a batch that can be applied as a single commit.": "將此建議添加到可批量處理的單個提交中。",
                    "Batching suggestions must be done from the files tab.": "批處理建議必須在 “文件” 選項卡中進行。",
                "Commit suggestion": "提交建議",

                "Pending in batch": "待批量處理",
                "Remove from batch": "從批量處理中移除",
                    "Remove this suggestion from those to be applied in batch": "從批量應用的建議中刪除此建議",
                "Sign off and commit suggestions": "簽署並提交建議",
                    "Apply all batched suggestions as a single commit": "將所有批量建議作為單個提交應用",
                "Sign off and commit changes": "簽署並提交更改",
                    "Applying commit...": "正在應用提交…",

                "This diff has recently been updated.": "該差異最近已更新。",
                "Refresh and try again.": "刷新並重試。",

                "Multiple suggested changes can be batched together in a single commit. Each suggestion author will be attributed in the commit as a co-author.": "多個建議更改可以在一次提交中批量處理。每個建議作者都將在提交中被歸為共同作者。",

            // 新版
                "Switch back": "返回舊版",
                "Feedback": "反饋",

                "Collapse file tree": "摺疊文件樹",
                "Expand file tree": "展開文件樹",

                "All changes": "所有更改",
                "All commits": "所有提交",
                "Changes since your last review": "自您上次審核以來的更改",
                "Specific commit…": "特定提交…",
                    "Pick one or more commits": "選擇多個提交",
                    "Clear selection": "清除選擇",
                        "Picking a range will select commits in between.": "選擇一個範圍將會選中其間的提交。",

                "viewed": "已審查",

                "Comments": "評論",
                "Submit": "提交",
                    "review": "審查",

                "Filter files…": "篩選文件…",
                "Filter options": "選項",
                    "File extensions": "文件擴展名",

                "Layout": "結構",
                "Minimize comments": "最小化評論",
                "Compact line height": "緊湊行高",

                "Select all": "全選",
                "Expand above": "向上展開",
                "Expand below": "向下展開",
                "Go to next hunk": "下一塊",

        // 拉取請求 --> 更改的文件 標籤卡 /<user-name>/<repo-name>/pull/<id>/files/<full SHA>
            "You are viewing a condensed version of this merge commit. You can view the": "您正在查看該合併提交的濃縮版本。您可以查看",
            "full changes here": "完整的更改",

            "We went looking everywhere, but couldn’t find those commits.": "我們嘗試尋找，就是找不到那些提交者。",
            "Sometimes commits can disappear after a force-push. Head back to the": "有時提交會在強推後消失。頭部回到",
            "latest changes here": "最新的更改",

            "Previous file (K)": "上個文件 (K)",
            "Next file (J)": "下個文件 (J)",

            "Comment on line": "評論行",
            "Expand comment": "展開評論",
            "Collapse comment": "摺疊評論",
            "Unresolve comment": "取消解決評論",
                "marked this comment as resolved": "標記為已解決",
            "Resolve comment": "解決評論",
                "Apply suggestion": "應用建議",
                    "More suggestion batching options": "更多選項",
                        "This feature is not supported yet.": "此功能尚未支持。",
            "Return to code": "返回程式碼",
            "Reference in a new issue": "在新議題中引用",

            // 圖片壓縮
            "You're in single-file mode": "當前為單文件模式",
                "Due to the large number of changes in this pull request, only one file is being shown at a time.": "由於此拉取請求中的更改數量較多，因此一次只顯示一個文件。",

                "buttons to move between files.": "按鈕在文件之間移動。",

                "OK, got it": "知道了",

            // 評論
                "Filter comments": "篩選評論",
                    "Show resolved comments": "顯示已解決評論",
                    "Show outdated comments": "顯示陳舊的評論",

                "No comments on changes yet": "還沒有評論",
                    "Comments will show up here as soon as there are some.": "評論將在此顯示。",

                // Copilot
                    "Implement suggestion": "採納建議",
                    "Mention Copilot": "提及 Copilot",
                        "Copilot isn't available for cross-repository pull requests": "Copilot 在跨倉庫的拉取請求中不可用",

        // 拉取請求 --> 解決衝突 /<user-name>/<repo-name>/pull/<id>/conflicts
            "Resolving conflicts": "解決衝突",
            "between": " ",
            "and committing changes": "並提交更改",
            // [/(\d+) conflicting files?/, "$1 個衝突文件"],
            // [/(\d+) conflicts?/, "$1 處衝突"],

            "Keyboard hints": "快捷鍵",
                "How to interact with code conflict editor via keyboard": "如何通過鍵盤與程式碼衝突編輯器交互",
                    "Toggle between edit mode and tab focus mode": "切換編輯模式和標籤焦點模式",
                    "Navigation between elements with tab focus mode on": "在 Tab 焦點模式下在元素之間導航",
                    "Move to next conflict control after accepting suggestion": "接受建議後移動到下一個衝突控件",
                    "Exit editor": "退出編輯器",
                        "then": "以及",

            "Mark as resolved": "標記為已解決",
                "Remove all conflict markers to resolve this file": "刪除所有衝突標記以解決此文件衝突",
            "Indent mode": "縮進模式",
                "Spaces": "空格",
                "Tabs": "製表符",
            "Indent size": "縮進尺寸",
            "Line wrap mode": "換行模式",
                "No wrap": "不換行",
                "Soft wrap": "軟換行",

            "Commit merge": "提交合併",
            "Sign off and commit merge": "簽署並提交合併",
                "Heads up, this will commit to": "請注意，這將提交到",
                "Commit updates to the": "提交更改到",
                "branch.": "分支。",
                "Create a": "創建",
                "new branch": "新分支",
                "and commit updates. Your pull request will be updated automatically.": "並提交更改。您的拉取請求將自動更新。",
                // [/I understand, sign off and update/, "我明白了，依然簽署並更新"],
                "You are": "您將",
                "signing off": "簽署",
                // [/on this commit as ([^@]+@[^\n]+)/, "該提交以 $1 身份"],
                "Committing merge…": "正在提交合併…",

                "conflict": "衝突",
                "conflicts": "衝突",

            "Accept current change": "接受當前更改",
            "Accept incoming change": "接受傳入更改",
            "Accept both changes": "接受全部更改",

        // 拉取請求 - 由 Copilot 編寫 https://github.com/用戶名/倉庫名/pull/編號/agent-sessions
            "Back to pull request #": "返回到拉取請求 #",

            "Copilot coding agent now uses fewer premium requests!": "Copilot 編程智能體現在使用更少的高級請求！",
                "From now on, each session uses just one premium request.": "從現在起，每個會話只會使用一次高級請求。",

            // 狀態
                "Failed": "失敗",
            "Sessions": "進度",
            "Duration": "總時長",
            "Premium requests": "高級請求",
                "Learn more about premium requests": "關於高級請求",

            "premium": "高級",
            "request": "請求",
            "requests": "請求",
            "used in": "被用於",
            "session": "任務",
            "sessions": "任務",

            "Stop session": "停止任務",
            "Open menu": "操作",
                "View verbose logs": "查看日誌",

            "Spinning up dev environment…": "正在啟動開發環境…",
            "Starting MCP servers…": "正在啟動 MCP 服務器…",
            "Making sure Copilot feels comfortable in the cockpit…": "確保 Copilot 在駕駛艙中感到舒適…",
            "Fueling the runtime engines…": "為運行時引擎加油…",
            "Copilot is working…": "Copilot 工作中…",

            "Copilot stopped work due to an error": "Copilot 因錯誤停工",
                "Copilot has encountered an error. See logs for additional details.": "Copilot 遇到錯誤。請查看日誌以獲取更多詳細信息。",
                // 內部錯誤，走正則
                "View detailed logs": "查看詳細日誌",

            // 進度
            "View repository": "查看倉庫",

        // 新版拉取請求提交頁面
            "authored and": "撰寫和",
            "Browse repository at this point": "查看此時間點的倉庫",

        "ProTip!": "專業提示！",
            "to the end of URLs for Git’s plaintext views.": "到 Git 純文本視圖的 URL 結尾。",
            "Add comments to specific lines under": "為以下特定行添加註釋於",
        "Switch back to the classic merge experience": "切換回經典的合併界面",
        "Try the new merge experience": "嘗試新的合併界面",

        "Repository owner locked as": "倉庫所有者鎖定為",
            "resolved": "已解決",
            "too heated": "爭論不休",
            "off-topic": "偏離主題",

        "Merge status cannot be loaded": "合併狀態加載出錯",
            "Try reloading the page, or if the problem persists": "嘗試重新加載頁面，或者如果問題仍然存在",
                "contact support": "請聯繫支持人員",
            "GitHub status": "GitHub 狀態",

        "Mention \@copilot in a comment to make changes to this pull request.": "在評論中提及 @copilot 以對該拉取請求進行更改。",


    },
    "regexp": [ // 正則翻譯
        [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "該分支的 $1 次提交將變基並添加到基本分支。"],
        [/([^ ]+):([^ ]+)% was force-pushed and no longer has any new commits./, "$1:$2 分支被強制推送，現在沒有新的提交。"], // 放這裡是因為跟現有詞條衝突
        // 建議更改（詞條打架移動至此）
        [/on this commit as ([^@]+@[^\n]+)/, "該提交以 $1 身份"],
        // Dependabot 打開的拉取請求
        [/This pull request resolved a Dependabot alert on ([^ ]+)./, "此拉取請求解決了 1 個 Dependabot 警報，在 $1 上。"],
        [/(\d+) Dependabot alerts?/, "$1 個 Dependabot 警報"],
        [/^on ([^ ]+) including a/, "在 $1 上，包括 1 個"],
        [/^on ([^ ]+)./, "在 $1 上。"],

        // 提交時展開收縮的描述
        [/Show description for ([a-f0-9]{7})/, "顯示提交 $1 的描述"],
        [/Hide description for ([a-f0-9]{7})/, "隱藏提交 $1 的描述"],

        // 新版 PR 提交頁
        [/wants to merge (\d+) commits? into/, "希望合併 $1 條提交到"],
        [/Commits on (.+)/,  (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `提交於${translatedDate}`;
        }],
        [/Add(?: a)? comment on line ((L|R)(\d+))/, "在 $1 行評論"],
        [/Suggest change on line ((L|R)(\d+))/, "建議更改 $1 行"],
        [/Expand all lines: (.+)/, "展開所有行：$1"],
        [/Collapse non-diff lines: (.+)/, "摺疊未更改行：$1"],
        // CODEOWNERS 文件指定所有者
        [/Owned by (\@.+) \(from CODEOWNERS line (\d+)\)/, "由 $1 擁有（來自 CODEOWNERS 第 $2 行）"],

        // 具體某條拉取請求
        [/edited by ([^ ]+)/, "由 $1 編輯"],
        [/At least (\d+) approving reviews? is required to merge this pull request./, "合併此拉取請求至少需要 $1 次批准審核。"],
        [/Commits?/, "提交"],
        [/Files? changed/, "文件更改"],
        [/merged (\d+) commits? into/, "將 $1 個提交合併到"],
        [/Copy full SHA for ([^ ]+)/, "複製 $1 完整的 SHA"], // Android UA ? 提交卡
        [/View checks?/, "查看檢查"], // Android UA ?
        [/([^ ]+) left review comments?/, "$1 發表了審查意見"],
        [/([^ ]+) approved these changes?/, "$1 批准這些更改"], // 具體的拉取請求 審查者
        [/Request review from ([^ ]+)/, "請求 $1 審查"], // 具體的拉取請求 審查者
        [/users with write access to ([^ ]+) can add new commits/, "對 $1 具有寫權限的用戶可以添加新的提交"], // 具體拉取請求
        [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准審查才能合併此拉取請求。"], // 具體的拉取請求 審查者
        [/This user is a first-time contributor to the ([^ ]+) repository./, "該用戶是第一次為 $1 倉庫做貢獻。"],
        [/(\d+) pending reviewers?/, "$1 名待審者"],
        [/([\d,]+) participants?/, "$1 位參與者"],
        [/At least (\d+) approving reviews? is required by reviewers with write access./, "具有寫入權限的審查者至少需要 $1 次批准審查。"],
        [/(\d+) approving reviews? by reviewers? with write access./, "$1 個批准的審查由具有寫入權限的審查者進行審查。"],
        [/(\d+) review requesting changes by reviewers? with write access./, "$1 個請求審查更改由具有寫入權限的審查者進行審查。"],
        [/(\d+) approvals?/, "$1 項批准"],
        [/(\d+) reviews? requesting changes by reviewers with write access/, "$1 項審查，要求有寫入權限的審查者進行更改"], // 拉取請求
        [/(\d+) changes? requested by reviewers with write access/, "具有寫入權限的審查者提出 $1 項更改請求"],
        [/(\d+) changes? requested/, "$1 項更改請求"],
        [/This pull request closes issue (#\d+)./, "該拉取請求將關閉議題 $1。"], // 死活不翻譯
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "$1 處增加，$2 處刪除未顯示，因為差異太大。請使用本地 Git 客戶端查看這些更改。"],
        [/(\d+) requested change/, "$1 項請求更改"],

        // 狀態
        [/branch (\d+) times, most recently from/, "分支 $1 次，最近一次從"],
        [/pushed a commit to ([^ ]+) that referenced this pull request/, " 向 $1 推送一次提交，其中引用了此拉取請求"],
        [/added a commit to ([^ ]+) that referenced this pull request/, "向 $1 添加一個提交，其中引用了此拉取請求"],
        [/Missing successful active ([^ ]+) deployment./, "未成功激活 $1 部署。"], // 新本合併頁面

        [/(\d+) in progress checks?/, "$1 個正在進行的檢查"],
        [/(\d+) skipped and (\d+) successful checks?/, "$1 個跳過, $2 個成功檢查"],
        [/(\d+) successful and (\d+) failing checks?/, "$1 個成功, $2 個失敗檢查"],
        [/(\d+) skipped, (\d+) successful, and (\d+) failing checks?/, "$1 個跳過, $2 個成功, $3 個失敗檢查"],
        [/(\d+) skipped, (\d+) successful, (\d+) cancelled, and (\d+) failing checks?/, "$1 個跳過, $2 個成功, $3 個取消, $4 個失敗檢查"],
        [/(\d+) skipped, (\d+) successful, and (\d+) expected checks?/, "$1 個跳過, $2 個成功, $3 個預先檢查"],
        [/(\d+) skipped, (\d+) successful, (\d+) queue, and (\d+) expected checks?/, "$1 個跳過, $2 個成功, $3 個排隊, $4 個預先檢查"],
        [/(\d+) skipped, (\d+) successful, (\d+) in progress, and (\d+) expected checks?/, "$1 個跳過, $2 個成功, $3 個正在進行, $4 個預先檢查"],
        [/(\d+) neutral checks?/, "$1 次中立檢查"],
        [/(\d+) successful checks?/, "$1 次成功檢查"],
        [/(\d+) of (\d+) checks? passed/, "$1/$2 次檢查通過"],
        [/(\d+) checks? passed/, "$1 次檢查通過"],

        [/Merge the latest changes from ([^ ]+) into this branch. This merge commit will be associated with ([^ ]+)./, "將最新更改從 $1 分支合併到當前分支。該合併提交將與用戶 $2 相關聯。"],
        [/Merging can be performed automatically with (\d+) approving review./, "合併可以通過 $1 次批准審查自動執行。"],
        [/(\d+) workflow awaiting approval/, "$1 個工作流等待批准"],
        [/The ([^ ]+) branch requires linear history/, "$1 分支為要求線性歷史記錄"],
        [/The (\d+) commits? from this branch will be added to the base branch./, "該分支的 $1 個提交將合併到基本分支中。"], // 合併拉取請求 按鈕下拉
        [/The (\d+) commits? from this branch will be combined into one commit in the base branch./, "該分支的 $1 個提交將合併到基礎分支中。"], // 合併拉取請求 按鈕下拉
        [/The (\d+) commits? from this branch will be rebased and added to the base branch./, "該分支的 $1 個提交將變基合併到基礎分支中。"], // 合併拉取請求 按鈕下拉
        [/Ensure specific people or teams approve pull requests before they're merged into your ([^ ]+) branch./, "確保特定的人或團隊在拉取請求被合併到您的 $1 分支之前批准它們。"], // 合併拉取請求
        [/(\d+) commits?/, "$1 條提交"],
        [/All (\d+) file types? selected/, "所有 $1 種文件類型被選中"], // 文件篩選
        [/Select all (\d+) file types?/, "選擇所有 $1 種文件類型"],
        [/Unresolved conversations/, "未解決的討論"],
        [/Resolved conversations/, "已解決的討論"],
        // [/Commits (.+)/, "提交於 $1"], // 提交標籤卡
        [/(#\d+) will be closed when this pull request is merged/, "$1 將在該拉取請求合併時關閉"],
        // 程式碼空間
        [/Create a codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
        [/Create codespace on ([^ ]+)/, "在 $1 上創建程式碼空間"],
        [/Codespace \"(.+)\" stopped./, "程式碼空間 “$1” 已停止。"],
        [/Codespace \"(.+)\" deleted./, "程式碼空間 “$1” 已刪除。"],
        [/Are you sure you want to delete (.+)\?/, "您確定要刪除 $1 嗎？"],
        [/(\d+) conflicting files?/, "$1 個衝突文件"], //conflicts
        [/(\d+) conflicts?/, "$1 處衝突"],  //conflicts
        [/Awaiting requested review from ([^ ]+)/, "等待 $1 審查請求"], // 具體的拉取請求
        [/([^ ]+) is a code owner/, "$1 是程式碼所有者"], // 具體的拉取請求
        [/This commit will be authored by ([^@]+@[^\n]+)/, "此提交的作者是 $1"], // 具體的拉取請求
        [/This pull request resolved a Dependabot alert on ([^ ]+)./, "該請求解決了 $1 的 Dependabot 警報問題。"],
        [/(\d+) workflows? awaiting approval/, "$1 個工作流程等待批准"],
        [/(\d+) resolved conversations?/, "$1 條對話已解決"], // 拉取請求
        [/I understand, continue updating ([^ ]+)/, "我明白了，繼續更新 $1"],
        [/I understand, sign off and update/, "我明白了，依然簽署並更新"],
        [/Notify someone on an issue with a mention, like: @([^ ]+)./, "在議題中通過 @ 提及通知某人，例如：@$1。"], // 專業提示
        [/(\d+) conversations? must be resolved before merging./, "合併之前必須解決 $1 個對話。"],
        [/(\d+) hidden items?/, "$1 條隱藏專案"],
        [/([^ ]+) requested changes/, "$1 要求更改"],
        [/(\d+) active deployments?/, "$1 個活動的部署"],
        [/Check failure on line (\d+)/, "第 $1 行檢查失敗："],

        // 命令行解決衝突頁面
        [/Copy (.+?) to clipboard/, "複製 $1 到剪切板"],

        // 文件差異過大 參考 https://github.com/maboloshi/github-chinese/pull/306/files
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "差異過大，不會顯示 $1 行添加以及 $2 行刪除。請使用本地 Git 客戶端查看更改。"],

        // 任務
        [/(\d+) tasks?/, "$1 個任務"],

        // 評論
        [/Lines (\d+) to (\d+) in/, "第 $1 - $2 行，"],

        // 建議更改
        //[/on this commit as ([^@]+@[^\n]+)/, "提交，身份為 $1"],

        // Copilot
        [/Copilot has encountered an internal error. If the problem persists, please contact GitHub Support, including the request ID `([^ ]+)`. To retry, leave a comment on this pull request asking Copilot to try again./, "Copilot 遇到了內部錯誤。如果問題仍然存在，請聯繫 GitHub 支持，並附上請求 ID `$1`。要重試，請在此拉取請求中發表評論，要求 Copilot 再試一次。"],

        // 解決衝突編輯器（似乎又是 F12 才會翻譯）
        [/Search:/, "搜索："],
        [/\(Use \/re\/ syntax for regexp search\)/, "(使用 /re/ 進行正則搜索)"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        ...I18N["zh-TW"]["repository/pull_issue_public"]["regexp"],
    ],
    "selector": [ // 元素篩選器規則
        ["span[data-message='Review changes']", "審查更改"], // 拉取請求 --> 更改的文件
    ],
    "title": {
        "regexp": [
            [/(.+) by (.+) · Pull Request #(\d+) · (.+)/, "$1 作者：$2 · 拉取請求 #$3 · $4"],
        ],
    },
};

I18N["zh-TW"]["repository/compare"] = { // 倉庫 - 比較並創建拉取請求
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 變更比較 頁面 /<user-name>/<repo-name>/compare@
            "Compare changes": "比較變更",
            "Compare changes across branches, commits, tags, and more below. If you need to, you can also": "比較跨分支，提交，標籤，和更多的變更。如果您需要，也可以",
            "compare across forks": "比較複刻庫和源倉庫",
            "Learn more about diff comparisons here": "點擊此處瞭解更多關於差異比較的信息",
            "This is a direct comparison between two commits made in this repository or its related repositories.": "這是本倉庫或其相關倉庫中兩次提交的直接比較。",
            "View the default comparison": "查看此範圍的默認比較",
            "for this range or": "或",

            // 分支選擇欄
            "base repository:": "基礎倉庫：",
                "Choose a Base Repository": "選擇基礎倉庫",
                "Filter repos": "篩選倉庫",
            "head repository:": "頭部倉庫：",
                "Choose a Head Repository": "選擇頭部倉庫",

            "base:": "基礎分支：",
                "Choose a base ref": "選擇基礎引用",
                "Find a branch": "搜索分支",
                "Find a tag": "搜索標籤",
            "compare:": "比較分支：",
                "Choose a head ref": "選擇頭部引用",

            "Choose different branches or forks above to discuss and review changes.": "選擇不同的分支或複刻來討論和查看變化。",
            "Learn about pull requests": "瞭解拉取請求",

            "Create pull request": "創建拉取請求",

            "Compare and review just about anything": "比較和審查任何文件",
            "Branches, tags, commit ranges, and time ranges. In the same repository and across forks.": "分支，標籤，提交範圍和時間範圍。在同一倉庫和複刻的倉庫。",
            "Example comparisons": "比較例子",

            "Commit": "提交",
            "Commits": "提交",
            "File changed": "更改的文件",
            "Files changed": "更改的文件",

        // 提出合併分支 /<user-name>/<repo-name>/compare/<branch>...<user-name-1>:<branch-1>
        // /<user-name>/<repo-name>/compare/<branch>...<branch-1>
        // <user-name>/<repo-name>/compare/<branch>...<user-name-1>:<repo-name-1>:<branch-1>
            "Comparing changes": "比較變更",
            "Choose two branches to see what’s changed or to start a new pull request. If you need to, you can also": "選擇兩個分支，看看發生了什麼改變，或發起一個新的拉請求。如果您需要，您也可以",
            "learn more about diff comparisons": "瞭解更多關於差異比較的信息",
            // "base fork:": "基複刻：",
            "Documentation has changed since you last contributed": "文件已發生變化，自您上次提交文件於",
            ". Take a look before submitting a pull request:": "。在提交拉取請求前，請先看一下：",
            "Contributing guidelines": "貢獻指南",
            "Last updated": "最近更新於",

            "There isn’t anything to compare.": "沒有任何東西可比較。",
                "We couldn’t figure out how to compare these references, do they point to valid commits?": "我們不知道如何比較這些引用，它們是否指向有效的提交？",

                "You’ll need to use two different branch names to get a valid comparison.": "您需要使用兩個不同的分支名稱來進行有效的比較。",
                "Check out some of these sample comparisons.": "看看這些比較的例子吧。",

                "is up to date with all commits from": "已是最新，提交於",
                ". Try": "。嘗試",
                "switching the base": "切換基礎庫",
                "for your comparison.": "來進行比較。",

                "are entirely different commit histories.": "是完全不同的提交歷史。",

            "Discuss and review the changes in this comparison with others.": "與他人討論並回顧此次對比中的變化。",

            "This comparison is big! We’re only showing the most recent 250 commits": "這個比較是很大的! 我們只顯示最近的 250 個提交。",

            "You’ll need to use two different branch names to get a valid comparison.": "您需要使用兩個不同的分支名稱來進行有效的比較。",

            "are identical.": "是相同的。",

            "Create another pull request to discuss and review the changes again.": "創建另一個拉取請求，再次討論和審查這些更改。",

            // 修改的文件 左側 展開按鈕
            "Expand all": "展開全部",
            "Expand All": "展開全部",
            "Expand Up": "向上展開",
            "Expand Down": "向下展開",

            "Unified": "同屏",
            "Split": "分屏",

            "Load diff": "載入差異",
            "This file was deleted.": "該文件已被刪除",
            "Large diffs are not rendered by default.": "默認情況下，大的差異不會被呈現。",
            "File renamed without changes": "文件僅重命名，內容沒有更改",
            "Binary file not shown.": "不顯示二進制文件。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默認不會呈現。詳細瞭解",
                "how customized files appear on GitHub": "自定義文件在 GitHub 上的顯示方式",
            "Empty file.": "空文件。",

            // 提交相關
            "Copy the full SHA": "複製完整 SHA",
            "View commit details": "查看提交詳情",
            "Browse the repository at this point in the history": "瀏覽該階段的歷史倉庫內容",

        // 直接提交拉取請求 /<user-name>/<repo-name>/compare/<branch>...<branch-1>?quick_pull=1
            "Open a pull request": "新建一個拉取請求",
            "The change you just made was written to a new branch named": "您剛剛所做的更改已寫入新分支",
            ". Create a pull request below to propose these changes.": ". 請在下方創建拉取請求，提出這些更改。",
            "Create a new pull request by comparing changes across two branches. If you need to, you can also": "通過比較兩個分支的更改來創建一個新的拉請求。如果需要，還可以",

            // 提示框（第一次提交拉取請求時）
            "It looks like this is your first time opening a pull request in this project!": "看起來這是您在這個專案中首次發起的拉取請求呢！",
            "Be sure to review the": "請務必查閱",
            "contributing guidelines": "貢獻指南",
            "Reporting a security vulnerability?": "報告安全漏洞？",
            "Check out the project's": "查看本專案的",
            "Looking for help?": "需要幫助？",
                "Check out the project’s": "查看本專案的",
                "instructions for getting support": "支持說明",

            "Checking mergeability…": "檢查可合併性…",
            "Don’t worry, you can still create the pull request.": "別擔心，您仍然可以創建拉取請求。",
            "Able to merge.": "可被合併。",
            "Can’t automatically merge.": "無法自動合併。",
            "These branches can be automatically merged.": "該分支可被自動合併。",

            "View pull request": "查看拉取請求", //存在拉取請求時
                "No description available": "無說明", // 拉取請求無評論時

            "commit": "次提交",
            "commits": "次提交",
            "file changed": "個文件變更",
            "files changed": "個文件變更",
            "contributor": "位貢獻者",
            "contributors": "位貢獻者",
            // "No commit comments for this range": "該範圍變更沒有提交註釋",

            "Reviewers": "審查者",
                "No reviews": "未經審查",
                "Loading suggestions…": "載入推薦…",
                // [/([^ ]+) left review comments/, "$1 發表了審查意見"],
                // [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准審查才能合併此拉取請求。"],
                "No reviews—at least 0 approving review is required.": "未經審查 — 至少需要 0 次批准審查。",
                "Re-request review": "重新請求審核",
                "Still in progress?": "仍在進行中嗎？",
                // [/Awaiting requested review from ([^ ]+)/, "等待 $1 的審查請求"]
                "Learn about draft PRs": "瞭解拉取請求草案",
                    "Try draft pull requests": "嘗試拉取請求草案",
                    "Open an in-progress pull request without asking for formal review or risking an unwanted merge. When you're ready for code review, you can mark your draft pull request as ready for review, which will request reviews from any code owners.": "打開正在進行的拉取請求，無需請求正式審核，也不必冒不必要的合併風險。當您準備好進行程式碼審核時，您可以將拉取請求草案標記為已準備好審核，這將請求任何程式碼所有者進行審核。",
                    "Ask admin for access": "向管理員請求權限",
                "Convert to draft": "設置為草案",
                "Request up to 15 reviewers": "最多請求 15 個審查者",
                // [/([^ ]+) approved these changes/, "$1 批准這些更改"], // 具體的拉取請求 審查者
                "Request": "請求",
                // [/Request review from ([^ ]+)/, "請求 $1 審查"], // 具體的拉取請求 審查者
                "This pull request is waiting on your review.": "此拉取請求正在等待您的審核。",
                // Copilot
                    "Copilot can review pull requests": "Copilot 可以審查拉取請求",
                    "Request a review from Copilot to get fast, actionable feedback on your code, so you can start iterating before you receive a human review.": "向 Copilot 請求程式碼審查，即可獲得快速且可操作的反饋，讓您能在收到人工審查前就開始迭代優化。",
                    "OK, dismiss": "關閉",

            "Assignees": "受理人",
                "No one assigned": "無人受理",
                "No one—": "無人 - ",
                "assign yourself": " 受理自己",
                "Assign up to 10 people to this issue": "最多指定 10 人", // 議題
                "Assign up to 10 people to this pull request": "最多指定 10 人", // 拉取請求
                "Clear assignees": "清除受理人",
                "Type or choose a user": "輸入或選擇用戶",
                "Suggestions": "建議",

            "Labels": "標籤",
                "None yet": "暫無",
                "bug": "BUG",
                    "Something isn't working": "有些東西不工作",
                "confirmed": "已確認",
                    "Issue confirmed to exist and the reason is known": "問題已確認存在，原因已知",
                "dependencies": "依賴性",
                    "Pull requests that update a dependency file": "更新依賴文件的拉取請求",
                "documentation": "文檔",
                    "Improvements or additions to documentation": "文檔的改進或補充",
                "duplicate": "重複",
                    "This issue or pull request already exists": "這個議題或拉取請求已經存在",
                "enhancement": "增強",
                    "New feature or request": "新功能或請求",
                "good first issue": "好的首發議題",
                    "Good for newcomers": "適合新人",
                "help wanted": "需要幫助",
                    "Extra attention is needed": "需要特別關注",
                "invalid": "無效",
                    "This doesn't seem right": "這似乎不對",
                "question": "問題",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不會修復",
                    "Not going to fix it": "不打算修復",
                    "This will not be worked on": "這將不會被處理",

                "Apply labels to this issue": "應用標籤", // 議題
                "Apply labels to this pull request": "應用標籤", // 拉取請求
                "Edit labels": "編輯標籤",

                "dependencies": "依賴項",
                    "Pull requests that update a dependency file": "更新依賴文件的拉取請求",
                "Recent": "最近",
                "User": "用戶",
                "No projects": "無專案",

            "Milestone": "里程碑",
                "No milestone": "無里程碑",
                "Set milestone": "設置里程碑",
                    "Nothing to show": "暫無",

        "Allow edits and access to secrets by maintainers": "允許維護人員編輯和訪問機密",
            "If checked,": "如果勾選，",
            "users with write access to": "則擁有",
            "can add new commits": "寫訪問權限的用戶可以向您的",
            "to your": "向您的",
            "branch.": "分支添加新提交。",
            "You can always change this setting later.": "您可以隨時更改這一設置。",
            "Note: By granting write access, maintainers could potentially edit your repository's workflows to reveal values of secrets and gain access to other branches.": "注意：通過授予寫入權限，維護者可能會編輯您倉庫的工作流程以揭示機密值，並獲取對其他分支的訪問權限。",
            "Got it": "知道了",
        // 創建拉取請求 按鈕下拉
            "Open a pull request that is ready for review": "打開一個準備好進行審核的拉取請求",
            "Automatically requests reviews from code owners": "自動請求程式碼所有者進行審查",
            "Create draft pull request": "創建拉取請求草案",
            "Cannot be merged until marked ready for review": "在標記為準備好進行審核之前無法合併",
            "Doesn't request code owners review and cannot be merged": "不請求程式碼所有者審核並且無法合併",
            "Draft pull request": "拉取請求草案",
        "Remember, contributions to this repository should follow its": "請記住，對該倉庫的貢獻應遵循其",
        "security policy": "安全政策",
        "code of conduct": "行為準則",
        "Remember, contributions to this repository should follow our": "請記住，對此倉庫的貢獻應遵循我們的",
        "GitHub Community Guidelines": "GitHub 社區準則",
        "Support": "支持",

        // 右側欄補充
        "Development": "進展",
            "Use": "使用",
            "Closing keywords": "關閉關鍵詞",
            "in the description to automatically close issues": "在描述中，以自動關閉議題",
            "Use Closing keywords to add a closing reference": "使用關閉關鍵詞添加一個關閉引用",

        "Helpful resources": "幫助性資源",
            // "GitHub Community Guidelines": "GitHub 社區準則",
            "Contributing": "貢獻準則",
            "Code of conduct": "行為準則",
            "Security policy": "安全政策",

        // 標籤對應版本比較 /<user-name>/<repo-name>/compare/<tag-id1>...<tag-id2>
            // 僅限 MD文件
            "Display the source diff": "顯示源差異",
            "Display the rich diff": "顯示富差異",

            "Load more commits": "載入更多的提交",

        // /<user-name>/<repo-name>/compare/<tag>...<branch>
            "Commit comments": "提交評論",

        "Showing": "顯示",
        "with": "包含",

        // 編輯器右上角三點，“顯示評論”走正則
        "View file": "查看文件",
        "Edit file": "編輯文件",
        "Delete file": "刪除文件",

        // 加載差異失敗
        "This comparison is taking too long to generate.": "生成比較結果的時間過長。",
        "Unfortunately it looks like we can’t render this comparison for you right now. It might be too big, or there might be something weird with your repository.": "不幸的是，我們現在無法為您提供這種比較。它可能太大了，或者您的倉庫有什麼奇怪的地方。",
        "You can try running this command locally to see the comparison on your machine:": "您可以嘗試在本地運行此命令以查看比較結果：",

        // 評論輸入框選項
        "Copilot actions": "Copilot 操作",
            "Generate": "生成",
                "Summary": "總結",
                    "Generate a summary of the changes in this pull request.": "生成此拉取請求的更改摘要。",
        "Summarizing changes… this might take a minute": "總結更改…這可能需要 1 分鐘",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Show comments?/, "顯示評論"], // 編輯器右上角三點
        [/committed/, "提交於"],
        [/(\d+) contributors?/, "$1 貢獻者"],
        [/Allow(ing)? edits by maintainers/, "允許維護人員編輯"],
        [/users with write access to ([^ ]+) can add new commits/, "則擁有 $1 寫訪問權限的用戶可以向您的"],
        [/(\d+) changed files?/, "更改的文件"],
        [/(\d+) additions?/, "$1 處增加"],
        [/(\d+) deletions?/, "$1 處刪除"],
        [/At least (\d+) approving reviews? are required to merge this pull request./, "至少需要 $1 次批准審查才能合併此拉取請求。"], // 創建拉取請求
    ],
    "title": {
        "regexp": [
            [/Compare/, "比較"],
        ],
    },
};

I18N["zh-TW"]["repository/commit"] = { // 倉庫 - 提交頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 具體某個提交頁面 /<user-name>/<repo-name>/commit/<full SHA>
            "Commit": "提交",

            // 快捷鍵
            "Browsing commits": "瀏覽提交",
            // "": "提交評論",
            "Close form": "關閉評論",
            "Parent commit": "父提交",
            "Other parent commit": "其他父提交",

            // 訪問已刪除的提交
            "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "這個提交不屬於本倉庫的任何分支，可能屬於倉庫以外的分支。",

            "Browse files": "瀏覽文件",
            "Loading branch information": "載入分支信息",

            // [/This commit closes issue (#\d+)./, "此提交關閉了提議 $1。"], //具體提交頁面
            "committed": "提交於",
            "commit": "提交",

            "Showing": "顯示",
            "with": "包含",
            "always": "總是",
            "Whitespace": "顯示空白字符差異",
            "Ignore whitespace": "忽略空白字符差異",
            "Unified": "同屏",
            "Split": "分屏",
            "Minimize comments": "最小化評論",

            "Display the source diff": "顯示源差異",
            "Display the rich diff": "顯示富差異",
            "Comment on this file": "評論此文件", // new code view

            "Filter changed files": "篩選已更改的文件", // new code view 側欄
            "Show file tree": "顯示文件樹", // new code view 側欄
            "Hide file tree": "隱藏文件樹", // new code view 側欄

            "Submodule": "子模塊",
            "updated": "已更新",
            // [/from ([^ ]+) to ([^ ]+)/, "從 $1 到 $2。"], //具體提交頁面

            "Binary file not shown.": "不顯示二進制文件",
            "Empty file.": "空文件。",
            "File renamed without changes.": "文件僅重命名，內容沒有更改。",
            "Whitespace-only changes.": "僅空白字符更改。",

            "Some content is hidden": "某些內容被隱藏",
                "Large Commits have some content hidden by default. Use the searchbox below for content that may be hidden.": "大型提交默認隱藏部分內容。使用下面的搜索框查找可能隱藏的內容。",
            "Dismiss banner": "關閉",

            "Load diff": "載入差異",
            "Load Diff": "載入差異",
            "This file was deleted.": "該文件已被刪除",
            "Large diffs are not rendered by default.": "默認情況下，大的差異不會被呈現。",
            "Some generated files are not rendered by default. Learn more about": "某些生成的文件默認不呈現。瞭解更多信息關於",
            "how customized files appear on GitHub": "更改文件在 GitHub 中的顯示方式",
            "customizing how changed files appear on GitHub.": "自定義更改文件在 GitHub 上顯示方式。",
            "File renamed without changes.": "文件僅重命名，內容沒有更改。",
            "File renamed without changes": "文件僅重命名，內容沒有更改",
            "Binary file not shown.": "不顯示二進制文件。",
            "Diff is too big to render. To view,": "差異過大，",
            "check out this pull request locally.": "請在本地查看拉取請求。",

            // 修改的文件 左側 展開按鈕
            "Expand all": "展開全部",
            "Expand Up": "向上展開",
            "Expand Down": "向下展開",
            "Collapse expanded lines": "摺疊展開的線",

            // 修改的 yaml 文件，預覽窗口
            "Loading Dependency Review...": "正在加載依賴審查…",
            "No dependencies changed.": "未更改依賴。",
                "The changes to this file likely do not affect the dependencies": "對此文件的更改可能不會影響依賴",

            "Give feedback on": "提交反饋，在",
                "dependency review": "依賴項審查",

            // 修改的文件 右側下拉
            "Show comments": "顯示評論",
            "Show annotations": "顯示註釋",
            "View file": "查看文件",
            "Edit file": "編輯文件",
            "Delete file": "刪除文件",
            "Open in desktop": "在 GitHub Desktop 中打開",
            "Copilot is loading...": "Copilot 加載中…",
            "Ask about this diff": "詢問此差異",
                "Explain": "解釋",
                "Attach to current thread": "附加至當前話題",

            //底部評論框上部
            "Lock conversation": "鎖定對話",
                "Lock conversation on this commit": "鎖定關於此提交的對話",
                "Locking the conversation means:": "鎖定對話意味著：",
                    "Other users": "其他用戶",
                    "can’t add new comments": "無法添加新評論",
                    "to this commit.": "到這個提交。",
                    "You and other collaborators": "您和其他協作者",
                    "with access": "有權限訪問",
                    "to this repository": "該倉庫",
                    "can still leave comments": "仍然可以發表評論",
                    "that others can see.": "其他人可以看到。",
                "You can always unlock this commit again in the future.": "您可以隨時再次解鎖此提交。",
            "Unlock conversation": "解鎖對話",
                "Unlock conversation on this commit": "解鎖關於此提交的對話",
                "Unlocking the conversation means:": "解鎖對話意味著：",
                "will be able to comment on this commit once more.": "將能夠再次對此提交發表評論。",
                "You can always lock this commit again in the future.": "您可以隨時再次鎖定此提交。",

                "Reply…": "回覆…",

            "commented on": "評論於",
            "Comment on line": "評論行",

            "Paste, drop, or click to add files": "粘貼、拖放或點擊添加文件",

            // 隱藏評論
            "Choose a reason for hiding this comment": "選擇隱藏此評論原因",
            "The reason will be displayed to describe this comment to others.": "將顯示原因，以便向其他人描述此評論。",
                "Choose a reason for hiding this comment": "選擇隱藏此評論原因",
                "Unhide": "取消隱藏",
                "comment": "評論",
                "Choose a reason": "選擇原因",
                    "Abuse": "濫用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏離主題",
                    "Outdated": "過時",
                    "Duplicate": "重複",
                    "Resolved": "已解決",

            "Subscribe": "訂閱",
            "Unsubscribe": "取消訂閱",
            "You’re not receiving notifications from this thread.": "您沒有收到來自該話題的通知。",
            "You’re receiving notifications because you authored the thread.": "您收到通知是因為您編寫了提交。",
            "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因為您訂閱了該話題。",
            "You’re receiving notifications because you’re watching this repository.": "您收到通知是因為您關注了該倉庫。",

        // 提交 commits 頁面 /<user-name>/<repo-name>/commits/<branch> 或 /<user-name>/<repo-name>/commits
            "Commits": "提交",
            "commit": "提交",
            // 快捷鍵
                "Copy file permalink": "複製文件永久鏈接",

            "Copy full SHA for": "複製該提交的完整 SHA", // Android UA
            "View commit details": "查看提交詳情",
            "Browse the repository at this point in the history": "瀏覽該階段的歷史倉庫內容",

            "Newer": "新的",
            "Older": "舊的",

            // 拉取請求懸浮卡
                "You were mentioned on and commented on this pull request": "您在該請求中被提及並發表了評論",
                "You left a review": "您發表了評論",

            // 議題懸浮卡
                "You commented on this issue": "您對此議題發表了評論",
                "You commented on and opened this issue": "您評論並打開了此議題",

        // /commits?since=<start-date XXXX-XX-XX>&until=<end-date XXXX-XX-XX>&author=<author-name>
            "No commits history": "尚無提交歷史記錄",
            "There isn't any commit history to show here": "此處沒有可顯示",
            "for the selected date range": "所選日期範圍內的任何提交歷史記錄",
            "There isn't any commit history to show here for the selected date range": "這裡沒有顯示所選日期範圍內的任何提交歷史記錄",

        // 新版提交 commits 頁面 /<user-name>/<repo-name>/commits/<branch> 或 /<user-name>/<repo-name>/commits
            // 用戶篩選
                "All users": "所有用戶",
                "Find a user...": "尋找一個用戶……",
                "View commits for all users": "查看所有用戶的提交",
            // 時間篩選
                "All time": "所有時間",
                "Today": "今天",
            "Clear": "清除",
            "Browse repository at this point": "查看此時間點的倉庫",
            "View code at this point": "查看此時間點的程式碼",

            // 日曆
                "Su": "一",
                "Mo": "二",
                "Tu": "三",
                "We": "四",
                "Th": "五",
                "Fr": "六",
                "Sa": "日",

            // [/Copy full SHA for ([a-f0-9]{7})/, "複製提交 $1 的完整 SHA"],
            // [/Show description for ([a-f0-9]{7})/, "顯示提交 $1 的描述"],
            // [/Hide description for ([a-f0-9]{7})/, "隱藏提交 $1 的描述"],

        // 提交中文件歷史 /<user-name>/<repo-name>/commits/<branch>/<file> 或 /<user-name>/<repo-name>/commits/<full SHA>/<file>
            "History for": "歷史：",
            "View at this point in the history": "在這一歷史節點上查看",

            // [/Renamed from/, "重命名自"], // 提交中文件歷史
            "(Browse History)": "（瀏覽歷史）",

        // 提交中文件夾歷史 /<user-name>/<repo-name>/commits/<branch>/<folder> 或 /<user-name>/<repo-name>/commits/<full SHA>/<folder>
            "End of commit history for this file": "此文件的提交歷史結束",

        // 2/commits?author=maboloshi&since=2021-09-30&until=2021-10-13
            "Seeing something unexpected? Take a look at the": "看到了一些意想不到的東西？請看一下",
            "GitHub commits guide": "GitHub 提交指南",

        // 新版提交頁
            "More actions": "更多操作",
            // 具體某條提交
            "authored and": "撰寫和",
            "authored": "撰寫於",

            // 左側文件管理器
            "Filter options": "篩選…",
            "Filter files…": "篩選文件…",
                "File extensions": "文件擴展名",
                "No extension": "無擴展名",

            // 中間
            "file": "個文件",
                "s": " ",
                "changed": "更改",

            // 展開/收起文件樹按鈕
                "Collapse file tree": "收起文件樹",
                "Expand file tree": "展開文件樹",

            // 展開/收起文件按鈕
                "Collapse file": "收起文件",
                "Expand file": "展開文件",
            // 複製文件按鈕
                "Copy file name to clipboard": "複製文件名到剪切板",

            "There are no files selected for viewing": "沒有更改",

            // 右側
            "Search within code": "在程式碼中搜索",
            "Top": "頂部",
            "Open diff view settings": "打開差異視圖設置",
                "Layout": "佈局",
                    "Hide whitespace": "隱藏空白",
                    "Compact line height": "自定義行高",

                "View comments": "查看評論",
                    "Loading comments": "加載評論中",
                    "Comment on lines": "評論於行",

                "Select all": "全選",
                "Expand above": "向上展開",
                "Expand below": "向下展開",
                "Go to previous hunk": "上一塊",
                "Go to next hunk": "下一塊",

            "Customizable line height": "自定義行高",
                "The default line height has been increased for improved accessibility. You can choose to enable a more compact line height from the view settings menu.": "默認行高已增加，以提高可訪問性。您可以從視圖設置菜單中選擇啟用更緊湊的行高。",
                "Enable compact line height": "啟用自定義行高",
                "Dismiss": "禁用",

            // 底部評論
            "Comments": "評論",
            "edited by": "編輯者",
            "Edits": "編輯",
                "Most recent": "最近",
                "Deleted": "已刪除",
            "Lock": "鎖定",
                "conversation": "對話",
                "Off-topic": "偏離主題",
            "Load more comments": "加載更多評論",
            "Reference in a new issue": "在新議題中提及",
            "Add Files": "添加文件",
            "You're not receiving notifications from this thread.": "您沒有收到來自此主題的通知。",
            "You're receiving notifications because you're subscribed to this thread.": "您收到通知是因為您訂閱了此主題。",
            "Return to code": "返回程式碼",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) parents?/, "$1 個父"],
        [/lines? changed/, "行更改"],//新版提交頁面
        [/(\d+) changed files?/, "$1 個更改的文件"],
        [/(\d+) changes?: (\d+) additions? & (\d+) deletions?$/, "$1 處更改：$2 處增加和 $3 處刪除"],
        [/(\d+) additions?$/, "$1 處增加"],
        [/(\d+) deletions?$/, "$1 處刪除"],
        [/This commit closes issue (#\d+)./, "此提交關閉了議題 $1。"], //具體提交頁面
        [/from ([^ ]+) to ([^ ]+)/, "從 $1 到 $2。"], //具體提交頁面
        [/([\d,]+) additions, ([\d,]+) deletions not shown because the diff is too large. Please use a local Git client to view these changes./, "$1 處增加，$2 處刪除未顯示，因為差異太大。請使用本地 Git 客戶端查看這些更改。"],
        [/(\d+) comments? on commit/, "該提交有 $1 條評論"],
        [/Edited (\d+) times?/, "編輯 $1 次"],
        // [/Commits (.+)/, "提交於 $1"], // 提交頁面 /<user-name>/<repo-name>/commits/<branch
        [/Renamed from/, "重命名自"], // 提交中文件歷史
        [/Copy full SHA for ([a-f0-9]{7})/, "複製提交 $1 的完整 SHA"],
        [/Show description for ([a-f0-9]{7})/, "顯示提交 $1 的描述"],
        [/Hide description for ([a-f0-9]{7})/, "隱藏提交 $1 的描述"],
        [/View (\d+) commit comments?/, "查看 $1 條提交評論"], // 新版提交 commits 頁面 /<user-name>/<repo-name>/commits/<branch>
        [/View checks?/, "查看檢查"], // Android UA
        [/Add a comment on line (L|R)(\d+)/, "在 $1$2 行添加評論"], // 新版提交詳情頁
        [/Add a comment on lines (L|R)(\d+) to (L|R)(\d+)/, "在 $1$2 行到 $3$4 行上添加評論"],
        [/Start conversation on line (L|R)(\d+)/, "在 $1$2 行開始討論"], // 新版提交詳情頁
        [/Expand all lines: ([^ ]+)/, "展開全部：$1"],
        [/Collapse file: ([^ ]+)/, "摺疊文件：$1"],
        [/Collapse non-diff lines: ([^ ]+)/, "摺疊無差異行：$1"],
        [/(\d+) tags?/, "$1 標籤"], // 出現位置：某提交所跨標籤數
    ],
    "title": {
        "regexp": [
            [/Commits/, "提交"],
        ],
    },
};

I18N["zh-TW"]["repository/blob"] = { // 倉庫 - 瀏覽程式碼
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 公共部分
            // 許可證文件 中間欄 頂部 權限信息
                "the": "為：", // 上半句走正則

                // 許可證類型
                    "GNU General Public License v3.0": "GNU 通用公共許可證 v3.0",
                    "GPL-3.0 License": "GPL-3.0 許可證",
                    "AGPL-3.0 License": "AGPL-3.0 許可證",
                    "LGPL-3.0 License": "LGPL-3.0 許可證",
                    "MIT License": "MIT 許可證",
                    "Apache License 2.0": "Apache-2.0 許可證",
                    "OFL-1.1 License": "OFL-1.1 許可證",
                    "0BSD License": "0BSD 許可證",
                    "BSD-3-Clause License": "BSD-3-Clause 許可證",
                    "BSD 3-Clause \"New\" or \"Revised\" License": "BSD-3-Clause 許可證",
                    "CC0-1.0 License": "CC0-1.0 許可證",
                    "WTFPL License": "WTFPL 許可證",
                    "Unknown": "未知",

                // 許可證概述 懶得翻譯 O(∩_∩)O哈哈~

                // 許可證範圍, 限制, 條件
                    "Permissions": "許可事項",
                    "Limitations": "限制條件",
                        "Commercial use": "商業用途",
                        "Modification": "修改",
                        "Distribution": "分佈",
                        "Patent use": "專利使用",
                        "Private use": "私人使用",
                        "Trademark use": "商標使用",
                        "Liability": "責任",
                        "Warranty": "擔保",
                        "Disclose source": "開源",
                        "Same license": "相同的許可證",
                    "Conditions": "條件",
                        "License and copyright notice": "許可和版權聲明",
                        "State changes": "狀態變化",
                        "License and copyright notice for source": "來源許可和版權聲明",
                        "Network use is distribution": "網絡使用即分發",
                        "Same license (library)": "相同的許可證（庫）",
                        "Same license (file)": "相同的許可證（文件）",

                "This is not legal advice.": "這並不是法律建議。",
                "Learn more about repository licenses": "瞭解更多關於倉庫許可證的信息",


        // 文件程式碼頁面 /<user-name>/<repo-name>/blob/<brach>/<file>
            // 頂部提醒
                "This commit does not belong to any branch on this repository, and may belong to a fork outside of the repository.": "此提交不屬於該倉庫上的任何分支，並且可能屬於倉庫的外部分支。",

            // 快捷鍵
                "Source code browsing": "源程式碼瀏覽",
                    "Jump to line": "跳轉到行",
                    "Switch branch/tag": "切換分支/標籤",
                    "Expand URL to its canonical form": "將 URL 擴展為其規範形式",
                    "Show/hide all inline notes": "顯示/隱藏所有內嵌註釋",
                    "Open blame": "打開追溯視圖",
                    "Copy file path": "複製文件路徑",
                    "Toggle symbols panel": "切換符號面板",
                    "Toggle file tree": "切換文件樹",
                    "Open code view": "打開程式碼視圖",
                    "Open preview": "打開預覽",
                    "Open raw file": "打開源文件",
                "File tree": "文件樹",
                    "Move focus to row starting with string": "將焦點移至字符串",
                    "Focus previous row": "聚焦上一行",
                    "Focus next row": "聚焦下一行",
                    "Collapse row, or focus parent row": "摺疊行或聚焦父行",
                    "Expand row, or focus child row": "展開行或聚焦子行",

            // 文件樹側邊欄
                "Expand file tree": "展開文件樹",
                "Collapse file tree": "摺疊文件樹",
                // 搜索框
                    "Go to file": "轉到文件",
                        "No matches found": "未找到匹配項",
                        "Go to folder": "轉到文件夾",
                        "See all results": "查看所有結果",

            // Git LFS 託管的文件
                "Stored with Git LFS": "Git LFS 託管",

            // Action的 action.yml 文件
                "You can publish this Action to the GitHub Marketplace": "您可以將此 Action 發佈到 GitHub 市場",
                "Draft a release": "起草發佈",
            // 工作流程文件 /blob/<brach>/.github/workflows/xxxx.yml
                "View Runs": "查看運行情況",
            // 議題模板 /blob/<brach>/.github/ISSUE_TEMPLATE/xxxx.yml
                "This file is used as an Issue Form template.": "該文件用作議題表單模板。",
                "Give Feedback.": "提交反饋。",
            // 議題模板 /blob/<brach>/.github/ISSUE_TEMPLATE/xxxx.md
                "info": "信息",
                "This file is used as a markdown issue template.": "該文件用作 Markdown 議題模板。",
            // 添加文件按鈕, 文件夾模式下
                "Add file": "添加文件",
            // 三個點
                "Raw file content": "原始文件內容",
                    // "Jump to line": "跳轉到行",
                    "Find in file": "在文件中查找", // 激活 “換行” 時顯示
                    "Copy path": "複製路徑",
                    "Copy permalink": "複製永久鏈接",
                    "View options": "查看選項",
                        "Show code folding buttons": "顯示程式碼摺疊按鈕",
                        "Wrap lines": "換行",
                        "Center content": "核心內容",
                        "Open symbols on click": "單擊打開符號",
                    "Ask about this file": "討論此文件",
                    "Delete file": "刪除文件",

            "Copied path!": "✅ 路徑已複製！",

            "History": "歷史",

            "Top": "頂部",
            "Jump to file": "跳轉到文件",

            // 正文 - 錯誤信息，例如某些二進制文件
                "Error rendering embedded code": "嵌入程式碼渲染錯誤",
                    "Invalid PDF": "無效 PDF",

            // 程式碼操作欄
                "Blame": "追溯",
                "Your blame took too long to compute.": "追溯花了太長時間來計算。",
                // [/(\d+) lines? \((\d+) loc\) ·/, "$1 行 ($1 個位置) ·"],
                // Copilot 廣告
                    "Code 55% faster with GitHub Copilot": "使用 GitHub Copilot 編碼速度提高 55%",
                        "Spend less time creating boilerplate and repetitive code patterns, and more time building great software. Try it in Codespaces or your favorite file editor.": "花更少的時間創建模板和重複的程式碼模式，花更多的時間構建優秀的軟體。在 GitHub 程式碼空間或您最喜歡的文件編輯器中嘗試一下哈。",
                        "Get GitHub Copilot": "獲取 GitHub Copilot",
                        "Don't show again": "不再顯示",

                "Executable File": "可執行文件",
                "executable file": "可執行文件",

                // Copilot
                "Ask Copilot about this file": "與 Copilot 討論此文件",

                "Raw": "源碼",
                // 文件複製圖標
                    "Copy raw file": "複製原始文件",
                    "Copy raw content": "複製原始文件",
                // 文件下載圖標
                    "Download raw file": "下載原始文件",
                // 文件編輯圖標
                    "More file actions": "更多文件操作",
                    "Edit this file": "編輯本文件",
                        "More edit options": "更多編輯選項",
                            "Edit file...": "編輯文件…",
                            "In place": "就地編輯",
                    "Edit the file in your fork of this project": "在您的複刻中編輯文件",
                        "Edit file": "編輯文件",
                            "Edit in place": "就地編輯",
                        "Open with...": "打開…",
                            "You must be on a branch to make or propose changes to this file": "您必須在分支上才能對該文件進行修改或提出修改建議",

                    // 按鈕提示
                    "Fork this repository and edit the file": "複刻此倉庫並編輯文件",
                // 符號面板圖標
                    "Open symbols panel": "打開符號面板",
                    "Close symbols panel": "關閉符號面板",

            // 程式碼視圖 行號欄 菜單
                "Copy line": "複製行",
                "Copy lines": "複製行",
                "Copy permalink": "複製永久鏈接",
                "View git blame": "瀏覽 Git 追溯",
                "Reference in new issue": "引用到新議題",
                "Reference in new discussion": "引用到新討論",
                "View file in GitHub.dev": "在 GitHub.dev 中查看文件",
                "View file in different branch/tag": "查看不同分支/標籤中的文件",

            // 提醒
                "This file contains bidirectional Unicode text that may be interpreted or compiled differently than what appears below. To review, open the file in an editor that reveals hidden Unicode characters.": "此文件包含雙向 Unicode 文本，其解釋或編譯方式可能與下面的顯示不同。要查看，請在一個能顯示隱藏的 Unicode 字符的編輯器中打開文件。",
                "Learn more about bidirectional Unicode characters": "瞭解更多關於雙向 Unicode 字符的信息",
                "Show hidden characters": "顯示隱藏字符",
                "Code view is read-only.": "程式碼視圖只讀。",
                    "Switch to the editor.": "切換到編輯器。",

            // 程式碼視圖底部
                "View remainder of file in raw view": "以原碼視圖查看文件剩餘部分",

            // 正文部分
                // 只讀模式
                    "Code view is read-only. ": "程式碼視圖是只讀的。",
                    "Switch to the editor.": "請切換至編輯器。",
                // csv 文件
                    "Search this file": "搜索這個文件", // csv 文件
                    // 提醒
                        "We can make this file": "如果糾正此錯誤，我們可以使該文件",
                        "beautiful and searchable": "美觀且可搜索",
                        "if this error is corrected: No commas found in this CSV file in line 0.": "：在此 CSV 文件中的第 0 行中找不到逗號。",

                // 大文件
                    "View raw": "查看原始數據",
                    "(Sorry about that, but we can’t show files that are this big right now.)": "（很抱歉，但我們現在無法顯示這麼大的文件。）",
                // 無法渲染
                    "Sorry, something went wrong.": "抱歉，出了一些問題。",
                    "Reload?": "重新加載？",
                    "Unable to render code block": "無法渲染程式碼塊",

            "More Pages": "更多頁面",

            // Markdown 文件右側大綱面板
                "Outline": "大綱",
                    "Close outline": "關閉大綱",
                    "Filter headings": "篩選標題",

            // 右側符號面板
                "Symbols": "符號",
                    "Close symbols": "關閉符號面板",
                    "Symbol outline not available for this file": "大綱不適用於此文件",
                    "To inspect a symbol, try clicking on the symbol directly in the code view.": "要檢查一個符號，可以嘗試在程式碼視圖中直接點擊該符號。",
                    "Code navigation supports a limited number of languages.": "程式碼導航支持有限數量的語言。",
                    "See which languages are supported.": "查看支持哪些語言。",

                    "Find definitions and references for functions and other symbols in this file by clicking a symbol below or in the code.": "通過點擊下方或程式碼中的符號，查找此文件中函數和其他符號的定義和引用。",
                    "Filter symbols": "篩選符號",

                "All Symbols": "所有符號",
                    "Search for this symbol in this repository": "在此倉庫中搜索此符號",
                    "all repositories.": "所有倉庫。",
                    "In this file": "在這個文件中",
                    "Definition": "定義",
                    "search-based": "基於搜索",
                    "References": "引用",
                    "Reference": "引用",
                    "No definitions or references found": "未找到定義或引用",
                    "Search for this symbol": "搜索此符號",

        // 程式碼追溯頁面 /<user-name>/<repo-name>/blame/<branch>/<file>
            "Newer": "新的",
            "Older": "舊的",

            "Contributor": "貢獻者",
            "Contributors": "貢獻者",

            // 浮動搜索框
                "Find": "查找",
                "Press": "按",
                "again to open the browser's find menu": "打開瀏覽器的查找菜單",
                "Search this file": "搜索此文件",

            "Ask Copilot about this snippet": "向 Copilot 詢問此片段",
                "Explain": "解釋",
                "Suggest improvements": "提出優化建議",
                "Attach to current thread": "附加至當前話題",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) lines? \((\d+) loc\) ·/, "$1 行（$2 非空行）·"],  // loc = 程式碼行（line of code）= 行數 - 空行數（lines - blank lines）
        [/(\d+) References?/, "$1 次引用"],
        [/Blame prior to change ([a-f0-9]{7}), made on ([^ ]+)/, "追溯提交 $1，創建於 $2"],

        // 程式碼追溯頁面
        [/(\d+) contributors?/, "$1 位貢獻者"],
        [/(\d+) commits?/, "$1 個提交"],

        // 許可證
        [/([^ ]+) is licensed under/, "$1 的許可證"],

        [/First (\d+) files? shown./, "顯示前 $1 個文件。"],

        [/Line (\d+) options/, "行 $1 選項"], // TODO: 修復翻譯未生效問題

        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/(.+) at (.+?) · (.+)/, "$1 在分支 $2 · $3"],
        ],
    },
};
I18N["zh-TW"]["repository/blame"] = I18N["zh-TW"]["repository/blob"];

I18N["zh-TW"]["repository/discussions"] = { // 討論頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["orgs-public"]["static"],

        // 沒有任何討論時
            "Get started with GitHub Discussions": "開始使用 GitHub 討論",
                "Discussions is a central gathering space for your community to ask questions, share ideas, and build connections with each other—all right next to your code.": "討論是一個社區成員集中交流的空間，大家可以在這裡提問、分享想法，並彼此建立聯繫——而且這一切都在您的程式碼旁邊完成。",

                "Get Started": "開始使用",
                "Not now": "暫不",

                "Only maintainers can see this page and enable Discussions": "只有維護者能看到此頁面並啟用討論",

            // 用法介紹
                // 自定義分類
                    "Create custom categories and discussion types to suit your community's unique needs.": "創建自定義類別和討論類型，以滿足您社區的獨特需求。",
                "Mark the most helpful answer": "標記答案",
                    "Highlight quality responses and make the best answer super discoverable.": "突出優質回答，讓最佳答案易於被發現。",
                "Pin big announcements": "置頂功能",
                    "Direct the community’s attention to important announcements or popular discussions.": "將社區的關注引導至重要公告或熱門討論。",
                "Label your discussions": "標籤功能",
                    "Organize and triage discussions to keep your space tidy and help contributors filter to areas of interest.": "組織和篩選討論內容，以保持社區空間整潔，並幫助參與者過濾到感興趣的領域。",
                "Respond on-the-go with mobile": "通過移動端隨時響應",
                    "Check in and respond to discussions whenever and wherever is convenient for you.": "隨時隨地在方便的時候查看並回復討論。",
                "Connect to your apps": "鏈接應用",
                    "Integrate with your existing workflows and GitHub Actions via the GraphQL API and webhooks.": "通過 GraphQL API 和 Web 鉤子與現有工作流程及 GitHub Actions 集成。",
                "Thread your conversations": "串聯對話",
                    "Keep conversations on track and encourage collaboration with threaded comments.": "通過串聯評論讓對話保持正軌並促進協作。",
                "Monitor community insights": "社區數據看板",
                    "Track the health and growth of your community with a dashboard full of actionable data.": "通過充滿可操作數據的儀表盤，追蹤社區的健康狀況與發展情況。",
                "Ask your community with polls": "社區投票",
                    "Gauge interest in a feature, vote on a meetup time, or learn more about your community with polls.": "通過投票來衡量對某項功能的興趣、對聚會時間進行表決，或進一步瞭解您的社區情況。",

            "Communities using Discussions": "使用討論交流",

            "Ready to try Discussions?": "準備嘗試討論？",
                "Click “get started” to enable it for your community and start your first discussion. Now is not the right time? Click “not now” to dismiss this tab. You can always turn Discussions on in your repository settings later.": "點擊 “開始使用” 即可為您的社區啟用該功能，並發起您的首次討論。現在不方便操作？點擊 “暫不” 可關閉此標籤頁。您也可以稍後在倉庫設置中隨時開啟討論功能。",

            "Read about best practices for setting up Discussions for your community.": "瞭解為社區設置討論功能的最佳實踐。",
                "Visit the docs": "查看",

        // 討論頁面 /<user-name>/<repo-name>/discussions
        // 組織討論頁 /orgs/<orgs-name>/discussions
            // 頂部提示
                "You can't perform that action at this time.": "您現在不能執行該操作。",

            "Start a new discussion": "開始新的討論",
            "Get started by creating the first": "開始吧，為您的社區創建",
            "discussion for your community.": "第一個討論。",
            "Got it": "知道了",

            "About pinned discussions": "關於置頂討論",
            "When you start a discussion,": "當您開始討論時，",
            "you can choose to feature it": "您可以選擇將",
            "here by pinning it.": "其置頂在此處。",

            "Personalize your categories": "自定義您的分類",
            "Choose categories that fit your community. These could be announcements, Q&A with marked answers, open-ended conversations, or polls for community voting.": "選擇適合您社區的類別。這些可以是公告、帶有標記答案的問答、開放式對話或用於調查的社區投票。",

            "Welcome to discussions!": "歡迎參與討論！",
            "Discussions are to share announcements, create conversation in your community, answer questions, and more.": "討論是為了分享公告，在您的社區創造對話，回答問題，以及更多。",
            "Discussions are to share announcements, create conversation in your community, answer questions, and more. To get started, you can create a": "討論是為了分享公告，在您的社區創造對話，回答問題，以及更多。首先，您可以創建一個",

            // 組織討論
            "Welcome to Organization Discussions!": "歡迎參與組織討論！",
            "There are no discussions here yet": "這裡還沒有討論",
            "Organization discussions are to broadcast news, create conversation in your community, answer questions, and share ideas. To get started, you can": "組織討論是為了廣播新聞，在您的社區創造對話，回答問題，並分享想法。要開始，您可以",
            "create a new discussion.": "創建新的討論。",

            // 左側欄
            "Submit search": "提交搜索",
            "Search all discussions": "搜索所有討論",
            "Suggested filters": "推薦的篩選器",
            "filter by discussion author": "按討論作者篩選",
            "filter by discussion category": "按討論分類篩選",
            "filter by answered or unanswered": "按已答覆或未答覆篩選",

            "Categories": "分類",
            "View all discussions": "查看全部討論", // 組織討論
            "View all": "查看全部", // 倉庫討論

            "Most helpful": "最有幫助",
                "Be sure to mark someone’s comment as an answer if it helps you resolve your question — they deserve the credit!": "如果某人的評論有助於您解決問題，請務必將其標記為答案——他們值得稱讚！",
            "Last 30 days": "最近 30 天",
            "Community guidelines": "社區指南",
            "Community insights": "社區見解",

            //
            "Sort by:": "排序方式：",
                "Latest activity": "最新活動",
                "Date created": "創建日期",
                "Top: Past week": "置頂：過去一週",
                "Top: Past month": "置頂：過去一月",
                "Top: Past day": "置頂：過去一天",
                "Top: Past year": "置頂：過去一年",
                "Top: All": "置頂：所有",
            "Label": "標籤",
                "Filter by label": "按標籤篩選",
                "Filter labels": "篩選標籤",
                "Unlabeled": "無標籤",

                "bug": "BUG",
                    "Something isn't working": "有些東西不工作",
                "dependencies": "依賴性",
                    "Pull requests that update a dependency file": "更新一個依賴文件的拉取請求",
                "documentation": "文檔",
                    "Improvements or additions to documentation": "文檔的改進或補充",
                "duplicate": "重複",
                    "This issue or pull request already exists": "這個議題或拉取請求已經存在",
                "enhancement": "增強",
                    "New feature or request": "新功能或請求",
                "good first issue": "好的首發議題",
                    "Good for newcomers": "適合新人",
                "help wanted": "需要幫助",
                    "Extra attention is needed": "需要特別關注",
                "invalid": "無效",
                    "This doesn't seem right": "這似乎不對",
                "question": "問題",
                    "Further information is requested": "要求提供更多信息",
                "wontfix": "不會修復",
                    "This will not be worked on": "這將不會被處理",

                "Edit labels": "編輯標籤",
            "Filter": "篩選",
            "Filter:": "篩選:",
                "Closed": "已關閉",
                "Answered": "已答覆",
                "Unanswered": "未答覆",
                "Locked": "鎖定",
                "Unlocked": "未鎖定",
                "All": "所有",

            "New discussion": "新建討論",

            "There aren't any discussions.": "暫無任何討論。",
            "There are no matching discussions.": "沒有匹配的討論。",
            "There are no matching answered discussions.": "沒有匹配的已答覆討論。",
            "There are no matching unanswered discussions.": "沒有匹配的未答覆討論。",
            "You can open a": "您可以打開一個",
            "new discussion": "新討論",
            "to ask questions about this repository or get help.": "，詢問關於這個倉庫的問題或獲得幫助。",

            "asked": "回覆",
            "started": "開始於",
            "· Unanswered": " · 未答覆",
            "· Answered": " · 已答覆",

            // 下拉補充
            "Use": "使用",
            "click/return": "點擊/回車",
            "to exclude labels.": "去排除標籤。",

            // 狀態詞
            "asked a question in": "提出了一個問題在",
            "Unanswered Question": "未解答的問題",
            "announced": "公佈於",
            "in": "在",

        // 討論分類 /<user-name>/<repo-name>/discussions/categories
            "Manage discussion categories": "管理討論分類",
                "Sections are a dropdown of categories. Categories have types of discussions, and discussions within them.": "本欄目是類別的下拉菜單。類別中包含討論類型和討論內容。",
            // [/(\d+) categories?/, "$1 個分類"],
            "Categories without section": "無欄目分類",
            "Announcements": "公告",
                "Updates from maintainers": "維護者的更新信息",
            "General": "通常",
                "Chat about anything and everything here": "在這裡談論任何事情",
            "Ideas": "想法",
                "Share ideas for new features": "分享對新功能的想法",
            "Polls": "投票",
                "Take a vote from the community": "社區中進行投票",
            "Q&A": "問答",
                "Ask the community for help": "向社會尋求幫助",
                "Answers enabled": "已啟用答案",
            "Show and tell": "展示與講述",
                "Show off something you've made": "炫耀您所做的事情",

            "New section": "新建欄目",
            "New category": "新建分類",

            "Edit Announcements category": "編輯 “公告” 分類",
            "Edit General category": "編輯 “通常” 分類",
            "Edit Ideas category": "編輯 “想法” 分類",
            "Edit Polls category": "編輯 “投票” 分類",
            "Edit Q&A category": "編輯 “問與答” 分類",
            "Edit Show and tell category": "編輯 “展示與講述” 分類",

            "Delete Announcements category": "刪除 “公告” 分類",
            "Delete General category": "刪除 “通常” 分類",
            "Delete Ideas category": "刪除 “想法” 分類",
            "Delete Polls category": "刪除 “投票” 分類",
            "Delete Q&A category": "刪除 “問與答” 分類",
            "Delete Show and tell category": "刪除 “展示與講述” 分類",

            // 刪除分類
                "If this category has discussions associated, where would you like to reassign them?": "如果此類別有相關的討論，您希望將它們重新分配到何處？",
                "Delete and move": "刪除並移動",

            // 刪除欄目
                // [/Delete (.*) section/, "刪除 “$1” 欄目"],
                "Are you sure you want to delete this section? All categories in this section will no longer belong to a section.": "您確定要刪除此欄目嗎？此欄目中的所有分類將不再屬於一個欄目。",

        // 新建 & 編輯 分類 /<user-name>/<repo-name>/discussions/categories/new
        // /<user-name>/<repo-name>/discussions/categories/<id>/edit
            "Create category": "創建分類",
            "Edit category": "編輯分類",
            "Category name": "分類名稱",
            "Description": "描述",
            "Add a description (optional)": "添加描述（可選）",
            "Discussion Format": "討論形式",
                "Open-ended discussion": "開放式討論",
                    "Enable your community to have conversations that don't require a definitive answer to a question. Great for sharing tips and tricks or just chatting.": "使您的社區能夠進行對話，不需要對問題作出明確的回答。很適合分享技巧和竅門，或者只是聊天。",
                "Question / Answer": "問 / 答",
                    "Enable your community to ask questions, suggest answers, and vote on the best suggested answer.": "使您的社區能夠提出問題、建議答案並投票選出最佳建議答案。",
                "Announcement": "公告",
                    "Share updates and news with your community. Only maintainers and admins can post new discussions in these categories, but anyone can comment and reply.": "與您的社區分享更新和新聞。只有維護者和管理員可以在這些類別中發佈新討論，但任何人都可以發表評論和回覆。",
                "Poll": "投票",
                    "Gauge interest, vote, and interact with other community members using polls.": "調查興趣，投票，並使用投票與其他社區成員互動。",
                    "Cannot be changed to polls. Please create a new category for polls.": "不能更改為投票。請為投票創建一個新類別。",
            "Add this category to a section (optional)": "將此分類添加到一個欄目（可選）",
                "No section": "無欄目",

            "Submitting": "提交中",

            // 頂部提醒
                "Category Announcements has been created.": "分類 “公告” 已創建",
                "Category General has been created.": "分類 “通常” 已創建",
                "Category Ideas has been created.": "分類 “想法” 已創建",
                "Category Polls has been created.": "分類 “投票” 已創建",
                "Category Q&A has been created.": "分類 “問與答” 已創建",
                "Category Show and tell has been created.": "分類 “展示與講述” 已創建",

                "Category Announcements has been updated.": "分類 “公告” 已更新",
                "Category General has been updated.": "分類 “通常” 已更新",
                "Category Ideas has been updated.": "分類 “想法” 已更新",
                "Category Polls has been updated.": "分類 “投票” 已更新",
                "Category Q&A has been updated.": "分類 “問與答” 已更新",
                "Category Show and tell has been updated.": "分類 “展示與講述” 已更新",

                "Category Announcements has been deleted.": "分類 “公告” 已刪除",
                "Category General has been deleted.": "分類 “通常” 已刪除",
                "Category Ideas has been deleted.": "分類 “想法” 已刪除",
                "Category Polls has been deleted.": "分類 “投票” 已刪除",
                "Category Q&A has been deleted.": "分類 “問與答” 已刪除",
                "Category Show and tell has been deleted.": "分類 “展示與講述” 已刪除",

                // [/Category \"(.*)\" has been created./, "分類 “$1” 已創建。"],
                // [/Category \"(.*)\" has been updated./, "分類 “$1” 已更新。"],
                // [/Category \"(.*)\" has been deleted./, "分類 “$1” 已刪除。"],

        // 新建 & 編輯欄目 /<user-name>/<repo-name>/discussions/sections/new
            "Create section": "創建欄目",
            "Section name": "欄目名稱",
            "Add categories to this section": "向欄目添加分類",
            "A category can only belong to one section at a time.": "一個分類一次只能屬於一個欄目。",

            // 頂部提醒
                // [/Section \"(.*)\" has been created./, "欄目 “$1” 已創建。"],
                // [/Section \"(.*)\" has been updated./, "欄目 “$1” 已更新。"],
                // [/Section \"(.*)\" has been deleted./, "欄目 “$1” 已刪除。"],

        // 新建討論頁面 /<user-name>/<repo-name>/discussions/new
            "Start a new discussion": "開始新的討論",
            "Select a discussion category": "選擇討論分類",
            "Get started": "開始",
            "Category:": "分類：",
            "Contributing": "貢獻",
            "It looks like this is your first time starting a discussion in this repository!": "看起來這是您第一次在此倉庫中開始討論！",
            "This is a community we build together. Please be welcoming and open minded.": "這是我們共同建立的社區。請保持熱情和開放的態度。",

            // 投票類
            "Poll question": "投票問題",
            "Ask your question here (required)": "在此提出您的問題（必填）。",
            "Poll options": "投票選項",
            "Option 1 (required)": "選項 1（必填）",
            "Option 2 (required)": "選項 2（必填）",
            "Option": "選項",
            "+ Add an option": "+ 增加選項",

            // 右側欄
            "Labels": "標籤",
                "None yet": "暫無",
            "Helpful resources": "幫助性資源",
            "Code of conduct": "行為準則",
            "Security policy": "安全政策",
            "Support": "支持",
            "GitHub Community Guidelines": "GitHub 社區準則",

            "Ask a question, start a conversation, or make an announcement": "提出問題、開始對話或發佈公告",

        // 新建討論頁面 /<user-name>/<repo-name>/discussions/new?category=general
            "If this doesn’t look right you can": "如果這個看起來不對，您可以",
            "choose a different category.": "選擇不同的類別。",
            "Fields marked with an asterisk (*) are required.": "標有星號（*）的字段是必填字段。",
            "Discussion title": "討論標題",

        // 新建討論頁面 /<user-name>/<repo-name>/discussions/new?category=announcements&welcome_text=true
            "Since you're new here, we're helping you to get started by generating your first post to the community. Don't worry, you can edit this discussion after you post!": "由於您是新來的，我們正在幫助您開始向社區發佈您的第一個帖子。不用擔心，您可以在發佈後編輯此討論！",

        // 某個討論頁面 /<user-name>/<repo-name>/discussions/<id>
            // [/Congratulations, you've created the first discussion in ([^ ]+)!/, "恭喜您，您已經在 $1 中創建了第一個討論!"],

            // 頂部提醒
                "Discussion has successfully been pinned.": "討論已成功置頂。",
                "Discussion has been unpinned.": "討論已取消置頂。",
                "Discussion pinned to Announcements": "在 “公告” 上置頂討論",
                "Discussion pinned to General": "在 “通常” 上置頂討論",
                "Discussion pinned to Ideas": "在 “想法” 上置頂討論",
                "Discussion pinned to Polls": "在 “投票” 上置頂討論",
                "Discussion pinned to Q&A": "在 “問與答” 上置頂討論",
                "Discussion pinned to Show and tell": "在 “展示與講述” 上置頂討論",
                "Discussion unpinned from Announcements": "取消在 “公告” 上置頂討論",
                "Discussion unpinned from General": "取消在 “通常” 上置頂討論",
                "Discussion unpinned from Ideas": "取消在 “想法” 上置頂討論",
                "Discussion unpinned from Polls": "取消在 “投票” 上置頂討論",
                "Discussion unpinned from Q&A": "取消在 “問與答” 上置頂討論",
                "Discussion unpinned from Show and tell": "取消在 “展示與講述” 上置頂討論",

            "Pinned": "已置頂",

            "announced in": "宣佈於",
            "started this conversation in": "開始了這次討論，在",
            "asked this question in": "提出了這個問題，在",
            "Maintainer": "維護者",
            "Sponsor": "贊助者",
            "Discussion options": "討論選項",
            "Category": "分類",

            "You are a maintainer on this repository.": "您是這個倉庫的維護者。",
            "You are the author of this discussion.": "您是這個討論的作者。",

            // [/(\d+) answers?/, "$1 位答覆者"],
            "Return to top": "返回頂部",
            // [/(\d+) comments?/, "$1 條評論"],
            // [/(\d+) replies?/, "$1 條答覆"],
            // [/(\d+) suggested answer/, "$1 個建議答案"],

            "Answered by": "答覆者：",
            "View full answer": "查看完整答案",
            "Oldest": "最早",
            "Newest": "最新",
            "Top": "置頂",
            "Comment options": "評論選項",


            "Events": "活動",
            "Marked": "標記為",
            "an": "一個",
            "Marked then unmarked an answer": "標記後，又取消標記",
            "Marked as answer": "標記為答案",
            "Mark as answer": "標記為答案",
            "Answer selected by": "被標記答案由",
            "Unmark as answer": "取消標記為答案",
            "Answer": "答案",

            "This comment has been minimized.": "此評論被最小化。",
            "This comment was marked as off-topic.": "此評論被標記為偏離主題。",
            "Show comment": "顯示評論",
            "Hide comment": "隱藏評論",

            // 隱藏評論對話框
                "The reason will be displayed to describe this comment to others.": "將顯示原因，以便向其他人描述此評論。",
                "Learn more about hiding a comment": "瞭解更多關於隱藏評論的信息",
                "Choose a reason for hiding this comment": "選擇隱藏此評論原因",
                "Unhide": "取消隱藏",
                "Choose a reason": "選擇原因",
                    "Abuse": "濫用",
                    "Spam": "垃圾信息",
                    "Off Topic": "偏離主題",
                    "Outdated": "過時",
                    "Duplicate": "重複",
                    "Resolved": "已解決",

            // 取消隱藏評論
                "Unhide": "取消隱藏",
                "Unhide comment": "取消隱藏評論",
                "Are you sure you want to unhide this comment?": "您確定要取消隱藏此評論嗎？",

            // [/Show (\d+) previous repl(y|ies)/, "顯示 $1 條之前的答覆"],
            // [/(\d+) hidden items?/, "$1 條隱藏專案"],

            "Loading more replies...": "載入更多回復中…",

            "Remember, contributions to this repository should follow its": "請記住，對該倉庫的貢獻應遵循",
            "Remember, contributions to this repository should follow our": "請記住，對該倉庫的貢獻應遵循我們的",
            "code of conduct": "行為準則",
            "contributing guidelines": "貢獻準則",

            // [/(\d+) new suggested answers?/, "$1 個新的建議答案"],
            "Answer selected": "已選擇答案",

            // 右側欄
            // /([\d,]+) participants?/, "$1 位參與者"
            "and others": "和其它",
            "Reopened": "重新打開",
            "Closed as resolved": "關閉為已解決",

            "Change category": "更改類別",
            "Converted from issue": "由議題轉化而來",
                // [/This discussion was converted from issue/, "本討論由以下議題轉換而來"],

            "Notifications": "通知類型",
                "Subscribe": "訂閱",
                "Unsubscribe": "退訂",
                "You’re not receiving notifications from this thread.": "您沒有收到來自該話題的通知。",
                "You’re receiving notifications because you’re watching this repository.": "您收到通知是因為您正在關注此倉庫。",
                "You’re receiving notifications because you authored the thread.": "您收到通知是因為您提出了該話題。",
                "You’re receiving notifications because you’re subscribed to this thread.": "您收到通知是因為您訂閱了該話題。",
                "You’re receiving notifications because you were mentioned.": "您收到通知是因為有人 @您。",
                "You’re receiving notifications because you commented.": "您收到通知是因為您發表了評論。",
                "You’re receiving notifications because you are watching pull requests on this repository.": "您收到通知是因為您正在關注此倉庫上的拉取請求。",
                "You’re receiving notifications because you are watching issues on this repository.": "您收到通知是因為您正在關注此倉庫上的議題。",
                "You’re receiving notifications because you modified the open/close state.": "您收到通知是因為您修改了打開/關閉狀態。",
                "You’re ignoring this repository.": "您忽略了這個倉庫。",

            // 鎖定對話
            "Lock conversation": "鎖定對話",
                "Are you sure you want to lock conversation on this discussion?": "您確定要鎖定此討論的對話嗎？",
                "Other users": "其他用戶",
                "can’t add new comments": "無法添加新評論",
                "to this discussion.": "到該討論。",
                "You and other collaborators": "您和其他協作者",
                "with access": "具有訪問權限",
                "to this repository": "該倉庫",
                "can still leave comments": "仍然可以留下評論",
                "that others can see.": "，其他人可以看到。",
                "You can always unlock this discussion again in the future.": "您今後仍可以隨時再次解鎖此討論。",
                "This conversation has been locked and limited to collaborators.": "此對話已鎖定，僅協作者可評論。",
            "Unlock conversation": "解鎖對話",
                "Are you sure you want to unlock conversation on this discussion?": "您確定要解鎖此討論的對話嗎？",
                "Everyone": "任何人",
                "will be able to comment on this discussion once more.": "將能夠再次對這個討論發表評論。",
                "You can always lock this discussion again in the future.": "您今後仍可以隨時再次鎖定此討論。",
            "Transfer this discussion": "轉移討論",
                // 轉移議題 對話框
                "Results are limited to top repositories, search to find more.": "結果僅限於置頂倉庫，請搜索以查找更多信息。",
                "Move this discussion to another repository owned by": "將此討論移至另一個擁有的倉庫由",
                "Move this discussion to another repository you own.": "將此討論移至您擁有的另一個倉庫。",
                "Search repositories": "搜索倉庫",
                "There aren't any eligible repositories that match your query.": "沒有任何符合條件的倉庫與您的查詢匹配。",
                "There aren't any eligible repositories to transfer this discussion to.": "沒有任何符合條件的倉庫可以將此討論轉移到其他倉庫。",
                "Transfer discussion": "轉移討論",
            "Pin discussion": "置頂討論",
                "You can pin up to 4 discussions. They will appear publicly at the top of the discussions page.": "您最多可以置頂 4 個討論。它們將公開顯示在討論頁面的頂部。",
                "Configure pinned discussion": "設置置頂討論",
                    "Background": "背景色",
                    "Pattern": "圖案",
                "Pinning discussion…": "置頂討論…",
            "Edit pinned discussion": "編輯置頂討論",
            "Unpin discussion": "取消置頂討論",
                "Are you sure you want to unpin this discussion?": "您確定要取消置頂討論嗎？",
                "The discussion itself won't be deleted, it just won't be shown prominently above the list of discussions.": "討論本身不會被刪除，只是不會突出顯示在討論列表上方。",
                // 頂部提醒
                // [/Discussion \"([^ ]+)\" has been unpinned./, "討論 “$1” 已取消置頂。"],
            "Pin discussion to Announcements": "將討論置頂到 “公告”",
                "Pin this discussion to this category": "將此討論置頂到此類別",
                    "This will pin this discussion to the top of the Announcements category.": "這將此討論置頂到 “公告” 類別頂部。",
                    "Pin to Announcements": "置頂到 “公告”",
            "Pin discussion to General": "將討論置頂到 “通常”",
                    "This will pin this discussion to the top of the General category.": "這將此討論置頂到 “通常” 類別頂部。",
                    "Pin to General": "置頂到 “通常”",
            "Pin discussion to Ideas": "將討論置頂到 “想法”",
                    "This will pin this discussion to the top of the Ideas category.": "這將此討論置頂到 “想法” 類別頂部。",
                    "Pin to Ideas": "置頂到 “想法”",
            "Pin discussion to Polls": "將討論置頂到 “投票”",
                    "This will pin this discussion to the top of the Polls category.": "這將此討論置頂到 “投票” 類別頂部。",
                    "Pin to Polls": "置頂到 “投票”",
            "Pin discussion to Q&A": "將討論置頂到 “問與答”",
                    "This will pin this discussion to the top of the Q&A category.": "這將此討論置頂到 “問與答” 類別頂部。",
                    "Pin to Q&A": "置頂到 “問與答”",
            "Pin discussion to Show and tell": "將討論置頂到 “展示與講述”",
                    "This will pin this discussion to the top of the Show and tell category.": "這將此討論置頂到 “展示與講述” 類別頂部。",
                    "Pin to Show and tell": "置頂到 “展示與講述”",
            "Unpin discussion from this category": "從此類別取消置頂",
                "Are you sure you want to unpin this discussion from Announcements?": "您確定要從 “公告” 中取消置頂此討論嗎？",
                "Are you sure you want to unpin this discussion from General?": "您確定要從 “通常” 中取消置頂此討論嗎？",
                "Are you sure you want to unpin this discussion from Ideas?": "您確定要從 “想法” 中取消置頂此討論嗎？",
                "Are you sure you want to unpin this discussion from Polls?": "您確定要從 “投票” 中取消置頂此討論嗎？",
                "Are you sure you want to unpin this discussion from Q&A?": "您確定要從 “問與答” 中取消置頂此討論嗎？",
                "Are you sure you want to unpin this discussion from Show and tell?": "您確定要從 “展示與講述” 中取消置頂此討論嗎？",
                "The discussion itself won't be deleted, it just won't be shown at the top of this category.": "討論本身不會被刪除，只是不會顯示在該類別的頂部。",
            "Create issue from discussion": "從討論中創建議題",
            "Delete discussion": "刪除討論",
                "Delete discussion?": "刪除討論？",
                "The discussion will be deleted permanently. You will not be able to restore the discussion or its comments.": "該討論將被永久刪除。您將無法恢復該討論或其評論。",
                "Deleting discussion…": "正在刪除討論…",
                // 頂部提醒
                "The discussion was successfully deleted.": "該討論已成功刪除。",

            "The original post will be copied into a new issue, and the discussion will remain active.": "原帖將被複制到一個新的議題中，討論將保持活躍。",
            "OK, got it!": "好的，我知道了！",

            // 評論刪除對話框
                "Delete comment": "刪除評論",
                "Are you sure you want to delete this comment?": "您確定要刪除這條評論嗎？",

            // 底部提示欄 (未登錄)
                "Sign up for free": "免費註冊",
                "to join this conversation on GitHub": "加入 GitHub 上的這個討論",
                ". Already have an account?": "。已經有賬戶？",
                "Sign in to comment": "登錄後發表評論",

        // 轉移議題到討論 /<user-name>/<repo-name>discussions/<id>?converting=<討論id>
            "This discussion is being migrated": "此討論正在遷移",
                "The issue and any comments are still being copied to this discussion thread, please check back later.": "該議題和所有評論仍在複製到此討論話題中，請稍後查看",
                "Refresh": "刷新",

        // /<user-name>/community/discussions
            // [/This is a ✨special✨ repository containing the organization level discussions for ([^ ]+). Everything posted here will also be visible at the organization level./, "這是一個 ✨ 特別的 ✨ 倉庫，包含 $1 的組織層面的討論。這裡發佈的所有內容在組織層面上也是可見的。"],
            "View organization discussions": "查看組織討論",

        // 標籤浮動文本
            "This user is a collaborator on this repository.": "該用戶是此倉庫的協作者。",
            "This user is a maintainer on this repository.": "該用戶是此倉庫的維護者。",
            "This user is the author of this discussion.": "該用戶是此討論的作者。",

        // 開始討論按鈕上方小字
            "I have done a": "我已", // 與下條二選一展示
            "Reminder to": "記得", // 同上
            "search for similar discussions": "搜索相似話題先",

        // 評論框編輯
            "Edited": "編輯於",
            "'s edit": " 編輯",
        // 反應相關
            "You can't vote on a locked discussion": "您不能在鎖定討論投票",
            "Uh oh! You can't vote right now.": "哎呀！您現在不能投票。",

        // 投票
            "Show Results": "顯示結果",
            "Hide Results": "隱藏結果",
            "Vote": "投票",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) categories?/, "$1 個分類"],
        [/Congratulations, you've created the first discussion in ([^ ]+)!/, "恭喜您，您已經在 $1 中創建了第一個討論!"],
        [/(\d+) answers?/, "$1 位答覆者"],
        [/(\d+) comments?/, "$1 條評論"],
        [/(\d+) repl(y|ies)/, "$1 條答覆"],
        [/(\d+) suggested answers?/, "$1 個建議答案"],
        [/(\d+) participants?/, "$1 位參與者"],
        [/Show (\d+) previous repl(y|ies)/, "顯示 $1 條之前的答覆"],
        [/(\d+) hidden items?/, "$1 條隱藏專案"],
        [/Discussion \"([^ ]+)\" has been unpinned./, "討論 “$1” 已取消置頂。"],
        [/Edited (\d+) times?/,"編輯 $1 次"], //評論框編輯次數
        [/edited by ([^ ]+)/,"被 $1 編輯"], //評論框 被他人編輯
        [/This is a ✨special✨ repository containing the organization level discussions for ([^ ]+). Everything posted here will also be visible at the organization level./, "這是一個 ✨ 特別的 ✨ 倉庫，包含 $1 的組織層面的討論。這裡發佈的所有內容在組織層面上也是可見的。"],
        [/Category \"(.*)\" has been created./, "分類 “$1” 已創建。"],
        [/Category \"(.*)\" has been updated./, "分類 “$1” 已更新。"],
        [/Category \"(.*)\" has been deleted./, "分類 “$1” 已刪除。"],
        [/Section \"(.*)\" has been created./, "欄目 “$1” 已創建。"],
        [/Section \"(.*)\" has been updated./, "欄目 “$1” 已更新。"],
        [/Section \"(.*)\" has been deleted./, "欄目 “$1” 已刪除。"],
        [/Edit (.*) category/, "編輯 “$1” 分類"],
        [/Delete (.*) category/, "刪除分類 “$1”"],
        [/Edit section (.*)/, "編輯欄目 “$1”"],
        [/Delete section (.*)/, "刪除欄目 “$1”"],
        [/Delete (.*) section/, "刪除 “$1” 欄目"],
        [/(\d+) new suggested answers?/, "$1 個新的建議答案"],
        [/This discussion was converted from issue (#\d+) on (.+)/, "本討論由以下議題轉換而來：$1 ，$2"],
        [/(\d+) new comments?/, "$1 條新評論"],
        [/Show (\d+) more repl(y|ies)/, "顯示剩餘 $1 條答覆"],
        [/(\d+) new/, "$1 新"],
        [/Filter:\s*(Open|Closed|Locked|Unlocked|Answered|Unanswered)(?:,\s*(Open|Closed|Locked|Unlocked|Answered|Unanswered))*\s*/, function (all, stat) {
            var statKey = {Open: '打開', Closed: '關閉', Locked: '鎖定', Unlocked: '未鎖定', Answered: '已答覆', Unanswered: '未答覆', " ,": "，"};

            return '篩選：' + statKey[stat];
        }],
        [/This user is sponsoring ([^ ]+)./, "該用戶正在贊助 $1。"],
        [/(\d+) votes?/, "$1 投票"],
    ],
    "title": {
        "regexp": [
            [/Discussions/, "討論"],
            [/New Discussion · (.+) · Category selection/, "新討論 · $1 · 分類選擇"],
        ],
    },
};
I18N["zh-TW"]["repository/orgs/discussions"] = I18N["zh-TW"]["repository/discussions"] ;

I18N["zh-TW"]["repository/actions"] = { // 倉庫 - 操作頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 頂部提示
            "Actions Enabled.": "操作已啟用。",

        // 複刻倉庫操作頁面提示
            "Workflows aren’t being run on this forked repository": "這個分支倉庫並未運行任何工作流程。",
            "Workflows aren't being run on this forked repository": "這個分支倉庫並未運行任何工作流程。",
            "Because this repository contained workflow files when it was forked, we have disabled them from running on this fork. Make sure you understand the configured workflows and their expected usage before enabling Actions on this repository.": "因為這個倉庫在被分支時含有工作流文件，我們已禁止在此分支上運行它們。在開啟此倉庫的操作之前，請務必理解配置的工作流程及其預期的使用方式。",
            "Because this repository contained workflow files when it was forked, we have disabled them from running on this fork. Make sure you understand the configured workflows and their expected usage before enabling Actions on this repository. Some GitHub features that depend on Actions may still be able to run.": "因為這個倉庫在被分支時含有工作流文件，我們已禁止在此分支上運行它們。在開啟此倉庫的操作之前，請務必理解配置的工作流程及其預期的使用方式。一些依賴於 Actions 的 GitHub 功能可能可以運行。",
            "I understand my workflows, go ahead and enable them": "我已理解我的工作流程，可以放心啟用它們。",
            "View the workflows directory": "查看工作流程目錄",

        //無工作流程
            "There are no workflow runs yet.": "無工作流程運行。",

        // 新建操作 /<user-name>/<repo-name>/actions/new
            "Get started with GitHub Actions": "開始使用 GitHub Actions",
            "Choose a workflow": "選擇工作流程",
            "Build, test, and deploy your code. Make code reviews, branch management, and issue triaging work the way you want. Select a workflow to get started.": "構建、測試和部署您的程式碼。以您想要的方式進行程式碼審查、分支管理和議題分類。選擇一個工作流以開始使用。",
            "Skip this and": "跳過並",
            "set up a workflow yourself": "建立工作流程",
            "Search workflows": "搜索工作流",

            "Suggested for this repository": "建議該倉庫採用",
            "Categories": "類別",
            "Configure": "設置",
            "Deployment": "部署",
            "Continuous integration": "持續集成",
            "Automation": "自動化",
            "Browse all categories": "瀏覽所有類別",
                "Code scanning": "程式碼掃描",
            "View all": "查看全部",

            "Learn more about GitHub Actions": "瞭解更多關於 GitHub Actions 的信息",
            "Getting started and core concepts": "入門和核心概念",
            "New to Actions? Start here. Learn the core concepts and how to get started.": "初次接觸 Actions？從這裡開始。瞭解核心概念和如何開始。",
            "Configuring and managing workflows": "配置和管理工作流程",
            "Create custom workflows to control your project's life cycle processes.": "創建自定義工作流程以控制專案的生命週期過程。",
            "Language and framework guides": "語言與框架指南",
            "Guides for projects written in many programming languages.": "專案指南由多種編程語言編寫。",

            "Didn't find what you're looking for?": "沒有找到您需要的？",
            "Fill out a 2-minute survey to request a new workflow template for GitHub Actions." :"填寫一份 2 分鐘的調查，為 GitHub Actions 申請一個新的工作流模板。",
            "Request": "申請",

        // 新建操作 /<user-name>/<repo-name>/actions/new?category=xxxx
            // [/Found (\d+) workflows?/, "發現 $1 個工作流程"],

        // 操作 /<user-name>/<repo-name>/actions
            // 快捷鍵
                "Go to usage": "跳轉到運用",
                "Go to workflow file": "跳轉到工作流程文件", // /actions/runs/<id>
                "Toggle timestamps in logs": "切換日誌中的時間戳",
                "Toggle fullscreen logs": "切換全屏日誌",
                "Exit fullscreen logs": "退出全屏日誌",
                "Actions main view search bar": "操作主視圖搜索欄",

            "Automate your workflow from idea to production": "從創意到產品，使您的工作流程自動化",
            "GitHub Actions makes it easy to automate all your software workflows, now with world-class CI/CD. Build, test, and deploy your code right from GitHub.": "GitHub Actions 現在可以使用世界一流的 CI/CD 輕鬆自動化所有軟體工作流程。直接從 GitHub 構建、測試和部署您的程式碼。",
            "Learn more about getting started with Actions.": "瞭解更多關於開始使用 GitHub Actions 的信息。",
            "Linux, macOS, Windows, ARM, and containers": "Linux、macOS、Windows、ARM 和容器",
            "Hosted runners for every major OS make it easy to build and test all your projects. Run directly on a VM or inside a container. Use your own VMs, in the cloud or on-prem, with self-hosted runners.": "為每一個主要的操作系統提供的託管運行程式，使您能夠輕鬆地構建和測試您的所有專案。直接在虛擬機上或容器內運行。在雲端或本地使用您自己的虛擬機，以及自託管的運行器。",

            "Matrix builds": "矩陣式構建",
            "Save time with matrix workflows that simultaneously test across multiple operating systems and versions of your runtime.": "使用矩陣工作流程可同時跨多個操作系統和版本運行，節省時間",

            "Any language": "任何語言",
            "GitHub Actions supports Node.js, Python, Java, Ruby, PHP, Go, Rust, .NET, and more. Build, test, and deploy applications in your language of choice.": "GitHub Actions 支持 Node.js、Python、Java、Ruby、PHP、Go、Rust、.NET 等。以您選擇的語言構建、測試和部署應用。",

            "Live logs": "實時日誌",
            "See your workflow run in realtime with color and emoji. It’s one click to copy a link that highlights a specific line number to share a CI/CD failure.": "使用顏色和表情符號實時查看您的工作流程。只需單擊即可複製突出顯示特定行號的鏈接以共享 CI/CD 故障。",

            "Built-in secret store": "內置的機密存儲",
            "Automate your software development practices with workflow files embracing the Git flow by codifying it in your repository.": "通過將工作流程文件編碼到您的倉庫，您的軟體開發實踐，包括 Git 流程自動化。",

            "Multi-container testing": "多容器測試",
            "Test your web service and its DB in your workflow by simply adding some": "在您的工作流程中測試您的網絡服務和它的數據庫，只需添加一些",
            "docker-compose": "docker-組合",
            "to your workflow file.": "到您的工作流程文件。",

            // 左側欄
                "New workflow": "新建工作流程",
                "Management": "管理",
                    "Caches": "緩存",
                    "Deployments": "部署",
                    "Attestations": "證書",
                    "Runners": "運行器",
                    "Usage metrics": "使用情況",
                    "Performance metrics": "數據看板",
                "Disabled": "已禁用",

                // 頂部提醒
                    // [/Workflow (.*) pinned./, "工作流程 $1 已置頂"],
                    // [/Workflow (.*) unpinned./, "工作流程 $1 已取消置頂"],

                // 取消置頂對話框
                    "Unpin this workflow?": "取消工作流程置頂？",
                        "This action will unpin the workflow for all viewers of this repository.": "此操作將為該倉庫的所有查看者取消置頂工作流程。",
                    "Yes, unpin": "是的，取消固定",

            // 工作流文件不存在
            "Not found": "未找到",
                "This workflow does not exist.": "此工作流不存在。",

            "All workflows": "全部工作流程",
                "Show more workflows...": "顯示更多工作流程…",
                "Showing runs from all workflows": "顯示所有工作流程的運行情況",

            "Codespaces Prebuilds": "程式碼空間預構建",
                "Showing all prebuild configuration runs for Codespaces. Learn about": "顯示程式碼空間所有預構建設置的運行情況。瞭解",
                "prebuilding your codespaces.": "程式碼空間預構建。",

            // 篩選條
                "Filter workflow runs": "篩選工作流程",
                    "Narrow your search": "縮小搜索範圍",

            // 反饋提醒
                "Help us improve GitHub Actions": "幫助我們改進 GitHub Actions",
                    "Tell us how to make GitHub Actions work better for you with three quick questions.": "通過三個快速問題告訴我們如何讓 GitHub Actions 更好地為您服務。",


            // [/(\d+) workflow runs?$/, "$1 個工作流程運行"],
            // [/(\d+) workflow runs results/, "$1 個工作流程運行結果"],

            "Event": "事件",
                "Filter by Event": "按事件篩選",
                "No matching events.": "無匹配事件。",
                //"Filter by event": "按事件篩選",
                "Find an event": "查找事件",
                    "issue_comment": "議題評論",
                    "pull_request": "拉取請求",
                    "pull_request_target": "拉取請求目標",
                    "push": "推送",
                    "schedule": "日程",
                    "watch": "關注",
                    "workflow_dispatch": "工作流程調度",
                    "repository_dispatch": "倉庫調度",
                    "dynamic": "動態",
            // 狀態
                "Filter by Status": "按狀態篩選",
                "Find a status": "查找狀態",
                    "queued": "排隊",
                    "in progress": "正在進行中",
                    "waiting": "等待中",
                    "completed": "已完成",
                    "neutral": "中立",
                    "success": "成功",
                    "failure": "失敗",
                    "failed": "失敗",
                    "cancelled": "已取消",
                    "action required": "需要採取行動",
                    "timed out": "已超時",
                    "skipped": "跳過",
                    "stale": "陳舊",
                    "required action": "需要操作",
            "Branch": "分支",
                "Filter by Branch": "按分支篩選",
                "Find a branch": "查找分支",
                "Default": "默認",
            "Actor": "角色",
                "Filter by Actor": "按角色篩選",
                "Find a user": "查找用戶",

            // 日誌 右側按鈕
                // 時間補丁 25年9月24日更新
                "Today at": "今天",
            "Cancel run": "取消運行",
            "View workflow file": "查看工作流程文件",
            "Delete workflow run": "刪除工作流程運行",
                // 刪除工作流程運行 對話框
                    "Are you sure you want to permanently delete this workflow run?": "您確定要永久刪除此工作流程運行嗎？",
                    "This action cannot be undone.": "此操作無法撤消。",
                    "Yes, delete this workflow run": "是的，刪除此工作流程",
                // 頂部提醒
                    "Workflow run deleted successfully.": "工作流程運行刪除成功。",

            // 篩選結果
                "No results matched your search.": "沒有與您的搜索匹配的結果。",
                "You could search": "您可以搜索",
                "all workflow runs": "所有工作流程運行",
                "or try different filters.": "或嘗試不同的篩選器。",

            // 列表區域
                // 工作流程運行狀態
                "In progress": "進行中",
                "Queued": "排隊中",
                "Pending": "待定中",

            // 頂部提醒
                "You have successfully requested the workflow to be canceled.": "您已成功請求取消工作流。",

        // /<user-name>/<repo-name>/actions/workflows/<file>.yml
            //右側三個點
                "Show workflow options": "顯示工作流程選項",
                    "Create status badge": "創建狀態徽章",
                        // 對話框
                            "Default branch": "默認分支",
                                "Filter branches": "篩選分支",
                            "Copy status badge Markdown": "複製狀態徽章 Markdown 程式碼",
                    "Pin workflow": "固定工作流程",
                    "Disable workflow": "禁用工作流程",
                        // 頂部提醒
                        "Workflow disabled successfully.": "工作流程已成功禁用。",

            "This workflow has a": "這個工作流程有一個",
            "event trigger.": "事件觸發器。",

            "Run workflow": "運行工作流程",
                "Use workflow from": "使用工作流程來自：",
                "Branch:": "分支：",
                "Select branch": "選擇分支",
                "Select ref": "選擇引用",
                "Select a tag": "選擇標籤",
                    "Nothing to show": "暫無",

                    "Workflow does not exist or does not have a": "工作流程不存在或沒有",
                    "trigger in this branch.": "觸發在此分支。",
                    "Learn more about manual workflows": "瞭解更多關於手工工作流程的信息",
                "Running workflow...": "正在運行工作流程…",
                // 頂部提醒
                    "Workflow run was successfully requested.": "工作流程已成功請求運行。",

            "This scheduled workflow is disabled because there hasn't been activity in this repository for at least 60 days.": "此計劃工作流程已禁用，因為此倉庫至少 60 天沒有活動。",
            "This scheduled workflow is disabled because there hasn't been activity in this repository for at least 60 days. Enable this workflow to resume scheduled runs.": "此計劃的工作流程已禁用，因為此倉庫至少有 60 天沒有活動。啟用此工作流程可恢復計劃運行。",
            "This scheduled workflow is disabled because scheduled workflows are disabled by default in forks.": "此計劃工作流程已被禁用，因為計劃工作流程在複刻倉庫中默認被禁用。",
            "This workflow was disabled manually.": "工作流程已被手動禁用。",
            "This workflow is": "此工作流程正在等待維護者",
                "awaiting approval": "批准",
                "from a maintainer in": "在",
            "Enable workflow": "啟用工作流程",
                // 頂部提醒
                    "Workflow enabled successfully.": "工作流程已成功啟用。",
            "Re-run jobs": "重新運行作業",
                "Re-running...": "重新運行中…",

            // 重新運行對話框
            "Re-run single job": "重新運行單個作業",
                "A new attempt of this workflow will be started, including": "將開始此工作流程的新嘗試，包括",
                "all the jobs": "所有作業",
                "all failed jobs": "所有失敗作業",
                "and dependents:": "和依賴：",
                "debug logging": "調試日誌",

            "This workflow has no runs yet.": "此工作流程尚未運行。",

        // 緩存 /<user-name>/<repo-name>/actions/caches
            "Showing caches from all workflows.": "顯示所有工作流程的緩存。",
            "Learn more about managing caches.": "瞭解更多關於管理緩存的信息。",
            "Filter caches": "篩選緩存",
            "Filter by branch": "按分支篩選",
            "Approaching total cache storage limit": "接近總緩存存儲限制",
            "Least recently used caches will be automatically evicted to limit the total cache storage to 10 GB.": "最近最少使用的緩存將被自動驅逐，以限制總緩存存儲為 10 GB。",
            "Learn more about cache usage.": "瞭解更多關於緩存使用的信息。",

            // [/(\d+) caches?/, "$1 個緩存"],
            "Sort": "排序",
            "Sort by": "排序方式",
                // 排序下拉菜單
                "Recently used": "最近使用",
                "Least recently used": "最近最少使用",
                "Newest": "最新",
                "Oldest": "最早",
                "Largest size": "最大尺寸",
                "Smallest size": "最小尺寸",
            "No caches": "尚無緩存",
            "Nothing has been cached by workflows running in this repository.": "在此倉庫中運行的工作流程尚未緩存任何內容。",
            "Learn more about caching": "瞭解更多關於緩存的信息",
            "dependencies and build outputs to improve workflow execution time.": "依賴項和構建輸出以縮短工作流執行時間。",
            "Last used": "最近使用",

            // [/(\d+) cache results?/, "$1 個緩存結果"],
            "No caches matched your search": "沒有與您的搜索相匹配的緩存",
            // [/No caches matched your search branch:([^ ]+)/, "沒有與您搜索的分支: $1 相匹配的緩存"],
            "Remove the filters": "刪除篩選器",
            "or try a different search query.": "或嘗試不同的搜索查詢。",

            "Delete cache": "刪除緩存",
                "Remove cache": "刪除緩存",
                "Are you sure you want to delete this cache?": "您確定要刪除此緩存嗎？",
                "This action cannot be undone": "此操作無法撤消",
                "Yes, permanently delete this cache": "是的，永久刪除此緩存",

                "Deleting Cache...": "刪除緩存中…",
                // 頂部提醒
                "Cache deleted successfully.": "緩存已成功刪除。",

        // 運行器 /<user-name>/<repo-name>/actions/runners
            "Runners available to this repository": "此倉庫可用的運行器",
            "New runner": "新建運行器",
            "GitHub-hosted runners": "GitHub 託管的運行器",
                // [/(\d+) available runners?/, "$1 個可用運行器"],
                "Larger GitHub-hosted runners": "大型 GitHub 託管運行程式",
                "Unprovisioned": "未配置",
                "Team & Enterprise": "團隊與企業",
                "Sizes up to:": "尺寸可達：",
                "Standard GitHub-hosted runners": "標準 GitHub 託管的運行器",
                "Ready-to-use runners managed by GitHub.": "由 GitHub 管理的即用型運行器。",
                "Learn more about GitHub-hosted runners.": "瞭解更多關於 GitHub 託管運行器的信息。",
                "Copy ubuntu-latest": "複製 ubuntu-latest",
                "Copy windows-latest": "複製 windows-latest",
                "Copy macos-latest": "複製 macos-latest",

                "View larger runner docs": "查看大型運行器文檔",
                "See pricing": "查看定價",
            "Self-hosted runners": "自託管運行器",
                "You don't have any": "此倉庫尚無任何",
                "self-hosted": "自託管",
                "runners for this repository": "運行器",
                    "Self-hosted runners are virtual machines for GitHub Actions workflows that you manage and maintain outside of GitHub.": "自託管運行器是您在 GitHub 外部管理和維護的 GitHub Actions 工作流程的虛擬機。",

        // /<user-name>/<repo-name>/actions/runs/<id>
            // 頂部提醒
                "Logs deleted successfully.": "日誌已成功刪除。",

            // 標題
            "Re-run all jobs": "重新運行所有作業",
            "Re-run failed jobs": "重新運行失敗作業",
            "Cancel workflow": "取消工作流程",

            //"Latest attempt": "最後運行",
            //"Attempt": "運行",
            "Explain error": "解釋錯誤",
            //右側按鈕
            "View workflow runs": "查看工作流程運行",
            "Workflow run options": "工作流程運行選項",
            "Delete all logs": "刪除所有日誌",
            "Sign in to view logs": "登錄後查看日誌",

            // 左側欄
            "Summary": "摘要",
            "All jobs": "所有作業",
                "Filter by job status": "由作業狀態篩選",
                    "Filter by status": "狀態篩選",
            "Jobs": "作業",
            "Run details": "運行詳情",
            "Usage": "運用",

            //狀態條
            "Triggered via pull request": "通過拉取請求觸發",
            "Triggered via issues": "通過議題觸發",
            "Triggered via push": "通過推送觸發",
            "Triggered via schedule": "通過計劃表觸發",
            "Triggered via dynamic": "通過動態觸發",
            "Triggered via GitHub Pages": "通過 GitHub 頁面觸發",
            "Triggered via repository dispatch": "通過倉庫調度觸發",
            "Triggered via release": "通過發行版觸發",
            "Triggered via issue": "通過議題觸發",
            "Triggered via discussion": "通過討論觸發",
            "Triggered via discussion comment": "通過討論評論觸發",
            "Triggered via workflow run": "通過工作流運行觸發",
            "Re-run triggered": "重新觸發",
            "Manually triggered": "手動觸發",

            "pushed": "推送",
            "opened": "打開",
            "reopened": "重新打開",
            "commented on": "評論於",

            // 狀態
                "Success": "成功",
                "Failure": "失敗",
                "Startup failure": "失敗",
                "Cancelled": "取消",
                "Action required": "請求操作",
                "Waiting": "等待",
            "Total duration": "總時長",
            "Billable time": "計費時間",

            "This workflow is waiting for": "該工作流程正在等待",
                "to complete before running.": "完成後再運行。",
                "Learn more about concurrency": "瞭解有關並發執行的更多信息",

            "Job summary generated at run-time": "運行時生成的工作摘要",

            // 右側中間欄
                "This workflow graph cannot be shown": "無法顯示此工作流圖表",
                "A graph will be generated the next time this workflow is run.": "下次運行此工作流時將生成一個圖表。",

                "This run and associated checks have been archived and are scheduled for deletion.": "此運行和相關檢查已存檔並計劃刪除。",
                "Learn more about checks retention": "瞭解更多關於檢查保留的信息",

            "Artifacts": "附件",
                "Produced during runtime": "在運行期間生成",
                "Name": "名稱",
                "Size": "大小",
                "Digest": "校驗值",
                // [/Delete artifact ([^ ]+)/, "刪除附件 $1"],
                "Expired": "已過期",
                    "This artifact has expired and you can no longer download it": "此附件已過期，您無法再下載",
            "Annotations": "說明",
                // [/1 error/, "$1 個錯誤"],

        // /<user-name>/<repo-name>/actions/runs/<id>/job/<job-id>
            "The logs for this run have expired and are no longer available.": "此運行日誌已過期，不再可用。",
            "This job was cancelled": "作業已取消",

            "Started": "開始於",
            "succeeded": "成功於",
            "ago": "之前",

            "Search logs": "搜索日誌",
            "Re-run this job": "重新運行此作業",
            // 設置按鈕
                "Show timestamps": "顯示時間戳",
                "Show full screen (Shift+F)": "全屏顯示（Shift+F）",
                "Download log archive": "下載日誌存檔",
                "View raw logs": "查看原始日誌",
                "View job summary": "查看作業摘要",

            "Try broadening your search filters.": "嘗試擴大您的搜索篩選器。",

            "Re-run all checks": "重新運行所有檢查",

        // /<user-name>/<repo-name>/actions/runs/<id>/usage
            "Run and billable time": "運行和計費時間",
            "Learn about OS pricing on GitHub Actions": "瞭解 GitHub Actions 上的操作系統定價",
            "Job": "工作",
            "Run time": "運行時間",
            "Billable": "計費",
            "time": "時間",

        // /<user-name>/<repo-name>/actions/runs/<id>/workflow
            "Workflow file": "工作流程文件",
            "Workflow file for this run": "本次運行的工作流程文件",

        // 操作面板
            "Show all jobs": "顯示所有工作",
            "Scheduled": "計劃運行",
            "Commit": "提交",
                "pushed by": "推送者",
            "Manually run by": "手動運行由",
            "The run was canceled by": "取消由", // 原文過於囉嗦
            "Pull request": "拉取請求",
                "synchronize by": "同步者",
                "opened by": "打開者",
                "reopened by": "重新打開者",
            "The operation was canceled.": "已取消。",
            "Release": "發行版",
                "published by": "發佈者",
            "created by": "創建者",
            "completed by": "完成者",
            //"Process completed with exit code 1.": "進程完成，退出程式碼為 1。",
            "Cache not found": "找不到緩存",
            "Starting job": "作業啟動中",
            "This job failed": "此作業失敗",
            "This job was skipped": "此作業被跳過",
            "Waiting for pending jobs": "等待中",
            "Input required and not supplied: token": "需要輸入但未提供：令牌",
            "The deployment was rejected or didn't satisfy other protection rules.": "部署被拒絕或不符合其他保護規則。",
            "Fit to window": "適合",
            "Zoom out": "縮小",
            "Zoom in": "放大",

        // 摘要窗口
            "Unable to load summary": "無法加載摘要",
            "This job summary has expired and is no longer available": "此作業摘要已過期，不再可用",
                // 右側三個點
                "View job logs": "查看日誌",
                "View raw markdown": "查看原始 Markdown",
                "Copy permalink": "複製永久鏈接",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Back to pull request (#\d+)/, "返回拉取請求 $1"],
        [/Workflow (.*) pinned./, "工作流程 $1 已置頂"],
        [/Workflow (.*) unpinned./, "工作流程 $1 已取消置頂"],
        [/Found (\d+) workflows?/, "發現 $1 個工作流程"],
        [/(\d+) workflow runs?$/, "$1 個工作流程運行"],
        [/(\d+) workflow runs? results?/, "$1 個工作流程運行結果"],
        [/Download ([^ ]+)/, "下載 $1"],
        [/Delete ([^ ]+)/, "刪除 $1"],
        [/(\d+) errors?/, "$1 個錯誤"],
        [/(\d+) cache results?/, "$1 個緩存結果"],
        [/(\d+) caches?/, "$1 個緩存"],
        [/No caches matched your search branch:([^ ]+)/, "沒有與您搜索的分支: $1 相匹配的緩存"],
        [/(\d+) available runners?/, "$1 個可用運行器"],
        [/(\d+)\/(\d+) jobs? completed/, "$1/$2 個工作完成"],
        [/(\d+) jobs? completed/, "$1 個工作完成"],
        [/(\d+) warnings?/, "$1 個警告"],
        [/Latest attempt (#\d+)/, "最後運行 $1"],
        [/Latest (#\d+)/, "最新 $1"],
        [/Attempt (#\d+)/, "運行 $1"],
        [/cached/, "被緩存"],
        [/(\d+)-cores · (\d+) GB RAM · (\d+) GB SSD Storage/, "$1 核心 · $2 GB內存 · $3 GB SSD 存儲"],
        [/Process completed with exit code (\d+)/, "進程已結束，退出程式碼為 $1"],
        [/([^ ]+) value is not set/, "$1 值未設置"],
        [/([^ ]+) summary/, "$1 摘要"],
        [/By ([^ ]+)/, "創建：$1"],
        [/Branch "([^ ]+)" is not allowed to deploy to ([^ ]+) due to environment protection rules./, "由於環境保護規則，“$1”分支不允許部署到 $2 上。"],
        // 時間
        [/(\d+)d (\d+)h (\d+)m (\d+)s/, "$1天$2時$3分$4秒"],
        [/(\d+)h (\d+)m (\d+)s/, "$1時$2分$3秒"],
        [/(\d+)h (\d+)m/, "$1時$2分"],
    ],
    "title": {
        "regexp": [
            [/Workflow runs/, "工作流程運行"],
            [/Caches/, "緩存"],
        ],
    },
};
I18N["zh-TW"]["repository/runs"] = I18N["zh-TW"]["repository/actions"];

I18N["zh-TW"]["repository/deployments"] = { // 倉庫 - 部署頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // /<user-name>/<repo-name>/deployments
            // 左側欄
                "Deployed": "部署",
                    "All deployments": "所有部署",
                    "Environments": "環境",
                    "Manage environments": "管理環境",

            // 面板
                // 所有部署
                    "Latest deployments from pinned environments": "來自固定環境的最新部署",
                //具體某一項
                    "Latest deployments": "最新部署",
                    "Last": "最後",
                    "deployed": "部署於",
                // 中間面板
                    "Your search did not match any deployments": "您的搜索未匹配任何部署",
                    "Try a different search query": "嘗試不同的搜索查詢",

                // 篩選條
                    "Filter": "篩選",
                        "Filter deployments": "篩選部署",
                        // 搜索框菜單
                            "State": "狀態",
                                "success": "成功",
                                "failure": "失敗",
                                "error": "錯誤",
                                "inactive": "不活躍",
                                "pending": "待定",
                                "queued": "排隊",
                                "in progress": "進行中",
                                "waiting": "等待中",
                            "Creator": "創建者",
                            "Environment": "環境",
                            "Ref": "引用",
                            "Text": "文本",

                    // 篩選器窗口
                        "Advanced filters": "高級篩選",
                        "Build complex filter queries": "建立複雜的篩選器查詢",
                        "To start building your query add your first filter using the button below.": "要開始建立查詢，請使用下面的按鈕添加第一個篩選器。",

                        "Qualifier": "限定",
                        "Operator": "操作",
                            "is one of": "之中的",
                            "is": "是",
                        "Value": "值",
                            "Make a selection": "請選擇",
                            "Select items": "請選擇專案",
                            "Filter values": "篩選值",
                            "Enter search text": "鍵入任意文本",
                                "Me": "我",
                                "Signed-in user": "已登錄用戶",
                        "Add a filter": "添加篩選器",
                        "Apply": "應用",

                    // 關閉彈窗
                        "Discard changes?": "是否放棄更改？",
                            "You have unsaved changes. Are you sure you want to discard them?": "您有未保存的更改。您確定要放棄它們嗎？",
                            "Keep editing": "繼續編輯",
                            "Close and discard": "關閉並放棄",

                    //篩選器報錯窗口
                        "Empty value for": "空值：",
                        "Text will be ignored since log searching is not yet available:": "由於尚未提供日誌搜索功能，文本將被忽略：",

                // 列表
                    "Active": "活躍",
                    "Inactive": "不活躍",
                    "Abandoned": "廢棄",
                    "Deployed to": "部署到",
                    "Failed to deploy to": "無法部署到",

                    "View logs": "查看日誌",
                    "View workflow run": "查看工作流程運行",

        // /<user-name>/<repo-name>/deployments/activity_log?environment=github-pages
            "Deployments": "部署",
            "/ History": "/ 歷史",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/deployments?/, "部署"],
        [/Filter contains (\d+) issues?:/, "過濾器包含 $1 個問題："], // 過濾器報錯窗口
        [/via/, "通過"],
    ],
    "title": {
        "regexp": [
            [/Deployments/, "部署"],
        ],
    },
};

I18N["zh-TW"]["repository/attestations"] = { // 倉庫 - 證書頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // <user-name>/repo-name>/attestations 證書
            "Attestations": "證書",

            "No attestations": "尚無證書",
                "Create attestations using the": "創建證書，請使用",
                "action": "操作工作流",

            "Filter": "篩選",
                "Sort by:": "排序方式：",
                    "Newest": "最新",
                    "Oldest": "最早",
                "Search or filter": "搜索或篩選",
                "Advanced filters": "高級篩選",
                "Build complex filter queries": "建立複雜的篩選器查詢",
                "To start building your query add your first filter using the button below.": "要開始建立查詢，請使用下面的按鈕添加第一個篩選器。",
                "Add a filter": "添加篩選器",
                "Apply": "應用",
                "Created": "創建於",
                    "before": "之前",
                    "after": "之後",
                    "before and including": "之前包括",
                    "after and including": "之後包括",
                    "between": "之間",
                    "is one of": "之中的",
                    "is not one of": "不包含",
                    "is": "是",
                "Has": "包含",
                "Predicate type": "謂詞類型",
                "Exclude": "排除",
                "Text": "文本",
                    "Enter search text": "鍵入任意文本",


            "Qualifier": "條件",
            "Operator": "操作",
            "Value": "值",
                "Make a selection": "請選擇",
                "Select items": "請選擇專案",
                "Select an item": "請選擇一個專案",
                "Filter values": "篩選值",
    },
    "title": {
        "regexp": [
            [/Attestations/, "證書"],
        ],
    },
};

I18N["zh-TW"]["repository/watchers"] = { // 倉庫 - 關注者頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 關注者頁面  /<user-name>/<repo-name>/watchers
            "Watchers": "關注者",
            "No one’s watching this repository yet. You could be the first.": "暫無關注者。您可以成為第一個",
            "Learn more about how watching repositories works on GitHub": "瞭解更多關於如何在 GitHub 上關注倉庫的工作方式",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        // [/Joined/,"加入於"], // 追星者，關注者頁面
    ],
};

I18N["zh-TW"]["repository/stargazers"] = { // 倉庫 - 追星者頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 追星者頁面  /<user-name>/<repo-name>/stargazers
            "Stargazers": "追星者",
            "All": "全部",
            "You know": "您關注的",
            "Be the first to star this repository": "成為第一個為這個倉庫標星的人",
            "about how starring works on GitHub.": "關於如何在 GitHub 上標星。",
            "Be the first of your friends to star this repository.": "成為第一個為這個倉庫標星的朋友。",

        // /<user-name>/<repo-name>/stargazers/you_know
            "No one you follow has starred this repository yet.": "您關注的任何人都未標星此倉庫。",
            "Learn more about how starring works on GitHub.": "瞭解更多關於在 GitHub 上標星的工作原理。",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        // [/Joined/,"加入於"], // 追星者，關注者頁面
    ],
};

I18N["zh-TW"]["repository/new"] = { // 倉庫 - 新建/編輯/上傳/刪除文件頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 新建文件頁面 /<user-name>/<repo-name>/new/<branch>
            // 文件樹側邊欄
                "Expand file tree": "展開文件樹",
                "Collapse file tree": "摺疊文件樹",
                "Add file": "添加文件",
                // 搜索框
                    "Search this repository": "搜索此倉庫",
                    "Go to file": "轉到文件",
                        "No matches found": "未找到匹配項",
                        "Go to folder": "轉到文件夾",
                        "See all results": "查看所有結果",

            "Name your file...": "文件名…",
            "in": "在",

            "Cancel changes": "取消更改",
                "You have unsaved changes. Do you want to discard them?": "您有未保存的更改。您想丟棄它們嗎？",
            "Commit changes...": "提交更改…",

            "Preview": "預覽",
                "Loading preview…": "載入預覽…",
                    "There is no content to preview.": "沒有可預覽的內容。",
                    "There has been an error generating the preview.": "生成預覽時發生錯誤。",
                    "Unable to load this preview, sorry.": "抱歉，無法加載此預覽。",
                    "There are no changes to show.": "沒有要顯示的更改。",
                    "But you can preview the whole file.": "但您可以預覽整個文件。", // new code view

            // 程式碼編輯框
                // Copilot 廣告
                    "Code 55% faster with GitHub Copilot": "使用 GitHub Copilot 編碼速度提高 55%",
                        "Spend less time creating boilerplate and repetitive code patterns, and more time building great software. Try it in Codespaces or your favorite file editor.": "花更少的時間創建模板和重複的程式碼模式，花更多的時間構建優秀的軟體。在 GitHub 程式碼空間或您最喜歡的文件編輯器中嘗試一下哈。",
                        "Get GitHub Copilot": "獲取 GitHub Copilot",
                        "Don't show again": "不再顯示",

                "Indent mode": "縮進模式",
                    "Spaces": "空格",
                    "Tabs": "Tab",
                "Indent size": "縮進大小",
                "Line wrap mode": "換行模式",
                    "No wrap": "不換行",
                    "Soft wrap": "軟換行",

            "Show Diff": "顯示差異",

            // 提交對話框
                "Commit changes": "提交更改",
                    "There was an error committing your changes:": "在提交您的更改時出現錯誤：",
                    "A file with the same name already exists. Please choose a different name and try again.": "已存在同名文件。請選擇其他名稱並重試。",
                    "File could not be edited": "文件不能編輯",
                    "See what changed": "查看更改",
                "Sign off and commit changes": "提交更改並簽署",
                "Propose changes": "提出更改建議", // 向他人倉庫提交
                "Sign off and propose changes": "提出更改建議並簽署", // 向他人倉庫提交
                    "Commit message": "提交信息",
                    "Extended description": "擴展描述",
                        "Add an optional extended description...": "添加描述... (可選)",

                    "Message and description suggested by Copilot.": "Copilot建議的消息和描述。",
                        "Send feedback": "提交反饋",

                    "You are": "您將",
                    "signing off": "簽署",
                    // [/on this commit as/,"該提交以"],

                    "You can’t commit to": "您不能提交到",
                    "because its is a": "，因為它是一個",
                    "protected branch": "受保護分支",

                    "Commit directly to the": "提交到",
                    "branch": "分支",

                    "Some rules will be bypassed by committing directly": "直接提交可以繞過一些規則",
                    "Bypass rules and commit changes": "繞過規則並提交更改",

                    "Create a": "創建",
                    "new branch": "新分支",
                    "for this commit and start a pull request": "為這個提交，並且發起一個拉取請求",
                    "Learn more about pull requests": "瞭解更多關於拉取請求的信息",

                "Something went wrong. Please fork the project, then try from your fork.": "出錯了。請複刻該專案，然後從您的複刻處嘗試。",

            // 底部欄
                "Use": "使用",
                "to toggle the": "切換",
                "key moving focus. Alternatively, use": "鍵移動對焦。或者使用",
                "then": "鍵，然後",
                "to move to the next interactive element on the page.": "鍵移動到頁面上的下一個交互元素。",

            // 頂部提醒
            // [/Your license is ready. Please review it below and either commit it to the ([^ ]+) branch or to a new branch./, "您的許可證已準備就緒。請在下面審查它並將其提交到 $1 分支或新分支。"],

        // 編輯文件頁面 /<user-name>/<repo-name>/edit/<branch>/<file>
            // 非本人倉庫
                "You need to fork this repository to propose changes.": "您需要複刻此倉庫以提出更改。",
                    "Sorry, you’re not able to edit this repository directly—you need to fork it and propose your changes from there instead.": "抱歉，您無法直接編輯此倉庫——您需要將其複刻並從那裡提出您的更改。",
                "Fork this repository": "複刻此倉庫",
                    "Learn more about forks": "瞭解更多關於複刻的信息",

                "You have unsaved changes on this file that can be restored.": "您可以恢復該文件上未保存的更改。",
                    "Discard": "丟棄",
                    "Restore": "恢復",

                "You’re making changes in a project you don’t have write access to. Submitting a change will write it to a new branch in your fork": "您正在對沒有寫入權限的專案進行更改。提交更改會將其寫入您的複刻",
                ", so you can send a pull request.": " 中的新分支，這樣您就可以發送拉取請求。",

            // 複刻倉庫過舊
                "Sorry, it looks like your fork is outdated!": "抱歉，您的複刻好像過時了！",
                "You’ll have to bring it up to date before you can propose changes.": "在提出修改意見之前，您必須對其進行更新。",
                "Update your fork": "更新您的複刻",

            // 組織倉庫 編輯文件頁面
                "You’re making changes in a project you don’t have write access to. We’ve": "您正在對沒有寫入權限的專案進行更改。我們已經",
                "created a fork of this project": "為該專案創建複刻",
                "for you to commit your proposed changes to. Submitting a change will write it to a new branch in your fork, so you can send a pull request.": "供您提交建議的更改。提交更改會將其寫入複刻中的新分支，這樣您就可以發送拉取請求。",

            // 混合換行符
                "We’ve detected the file has mixed line endings. When you commit changes we will normalize them to": "我們檢測到該文件具有混合行結尾。當您提交更改時，我們會將它們標準化為",
                "Windows-style": "Windows 樣式",

            // 與用戶名同名倉庫 編輯 README.md 文件
                "is a special repository: its": "是一個特殊的倉庫：它的",
                "will appear on your profile!": "將出現在您的個人資料中！",

                "is now a special repository: its": "現在是一個特殊的倉庫：它的",

            // 組織下.github 倉庫 編輯 /profile/README.md 文件
                "is a special repository: this": "是一個特殊的倉庫：這個",
                "will appear on your organization's profile!": "將出現在您的組織資料中!",

            // 編輯 .gitignore 文件
                "Choose .gitignore template": "選擇 .gitignore 模板",
                    ".gitignore template": ".gitignore 模板",
                    "Filter…": "篩選…",
                    "None": "無",

            // 編輯 工作流程文件 .github/workflows/xxxx.yml
                "Collapse help panel": "摺疊幫助面板",

                // 幫助面板側邊欄
                    "Search Marketplace for Actions": "搜索 Actions 市場",
                    "Featured Actions": "特色 Actions",
                    "Featured categories": "特色分類",
                        "Code quality": "程式碼質量",
                        "Monitoring": "監控",
                        "Continuous integration": "持續集成",
                        "Project management": "專案管理",
                        "Deployment": "部署",
                        "Project management": "專案管理",
                        "Testing": "測試",
                    "\/ Search results": "\/搜索結果",
                    "Browse all actions on the GitHub Marketplace": "瀏覽 GitHub 市場 上的所有 Actions",

                    // 具體某個操作
                        "View full Marketplace listing": "去市場查看詳細信息", // 跳轉去市場對應頁面
                        "Installation": "安裝",
                        "Copy and paste the following snippet into your": "將以下程式碼段複製並粘貼到您的",
                            "file.": "文件。",
                        "Version:": "版本：",

                // 底部欄補充
                    "Space": "空格",
                    "to trigger autocomplete in most situations.": "在大多數情況下將觸發自動完成。",
                    "Documentation": "文檔",

            // 編輯 LICENSE 許可證文件
                "Choose a license template": "選擇許可證模板",

            // 編輯 議題表單模板文件 .github/ISSUE_TEMPLATE/xxxx.yml
                // 頂部提示
                "Looks like this file is an issue template. Need help?": "此文件是一個議題模板。需要幫助？",
                "Learn more about issue templates.": "瞭解更多關於議題模板的信息。",
                "Give feedback.": "提交反饋。",
                // 右側幫助說明
                "Top-level configuration options": "頂層配置選項",
                    "Required Fields": "必填項",
                        "(String): The template's name. Must be unique across all templates, including Markdown templates.": "（字符串）模板名。不能與其他模板名重複，包括 Markdown 模板",
                        "(String): A description of this template's intended use. This will be shown in the issue template chooser interface.": "(字符串）：該模板預期用途的說明。這將顯示在議題模板選擇界面中。",
                    "Optional Fields": "可選項",
                        "(Array or String): This issue will be automatically assigned to these users. Can be array of usernames or comma-delimited string, e.g. \"monalisa,nat\"": "(數組或字符串）：此議題將自動分配給這些用戶。可以是用戶名數組或以逗號分隔的字符串，例如 “monalisa,nat”。",
                        "(Array or String): This issue will automatically receive these labels upon creation. Can be array of labels or comma-delimited string, e.g. \"bug,needs-triage\"": "(數組或字符串）：該議題在創建時將自動接收這些標籤。可以是標籤數組或以逗號分隔的字符串，例如 “bug,needs-triage”（錯誤，需要分流）。",
                        "(Array or String): This issue will be automatically added to these projects. Can be array of projects or comma-delimited string, e.g. \"github\/1,github\/2\"": "(數組或字符串）：該議題將自動添加到這些專案中。可以是專案數組或以逗號分隔的字符串，如 “github\/1,github\/2”。",
                        "(String): Default title that will be pre-populated in the issue submission form.": "(字符串）：將在議題表單中預填的默認標題。",
                        "(Array): Definition of user inputs.": "(數組）：用戶輸入的定義。",
                "Input type configuration options": "輸入類型配置項",
                    // Markdown
                        "Markdown blocks contain arbitrary text that a maintainer can add to a template, to provide extra context or guidance to a contributor. Supports Markdown formatting. This text will": "Markdown 塊包含任意文本，維護者可將其添加到模板中，為貢獻者提供額外的上下文或指導。支持 Markdown 格式。這些文本",
                        "not be rendered in the submitted issue body": "不會在提交的議題正文中呈現。",
                        // 必填項
                            "(String): The text that will be rendered. Markdown formatting is supported.": "(字符串）：將渲染的文本。支持 Markdown 格式。",
                        "Tip #1: YAML processing will cause the hash symbol to be treated as a comment. To insert Markdown headers, wrap your text in quotes.": "提示 1：YAML 處理會將 # 號視為註釋。要插入 Markdown 標題，請用引號將文本包起來。",
                        "Tip #2: For multi-line text, you can use the pipe operator.": "提示 2：對於多行文本，可以使用管道運算符。",
                        "Example": "示例",
                    "Input": "輸入",
                        "Inputs are single-line form input fields. Contributors may use markdown formatting in their responses.": "輸入為單行表單輸入字段。貢獻者可在回覆中使用標記符格式。",
                        "Required Attributes": "必要屬性",
                            "(String): A brief description of the expected user input.": "(字符串）： 預期用戶輸入的簡要說明。",
                        "Optional Attributes": "可選屬性",
                            "(String): Extra context or guidance about filling out this form input. Supports Markdown.": "(字符串）：有關填寫此表單輸入的額外上下文或指導。支持 Markdown。",
                            "(String): Renders as semi-transparent \"placeholder\" element in the input field when it's empty.": "(字符串）：當輸入框為空時，渲染為半透明的 “placeholder”元素。",
                            "(String): Default text that is pre-populated in the input field.": "(字符串）：輸入字段中預填的默認文本。",
                        // ID
                            "(String): Optional unique identifier. Can only contain alphanumeric characters,": "(字符串）：可選的唯一標識符。只能包含字母數字字符、",
                        "Validations": "驗證",
                            "(Boolean): If": "(布爾值）：若",
                            ", the form will not be submittable until this is filled out. Only for public repositories.": "，則填寫此信息後才能提交表格。僅適用於公共倉庫。",
                    "Textarea": "文本區域",
                        "Very similar to inputs, textareas are multiple-line form input fields. Typically used if you'd like a contributor to provide an answer longer than a few words. Contributors may use markdown formatting in their responses.": "文本區域與輸入非常相似，都是多行表單輸入字段。如果希望貢獻者提供長於幾個單詞的答案，通常會使用文本區域。貢獻者可以在回覆中使用標記符格式。",
                        // 可選屬性
                            "(String): If a value is provided, user-submitted text will be formatted into a codeblock automatically.": "(字符串）：如果提供該值，用戶提交的文本將自動格式化為程式碼塊。",
                    "Dropdown": "下拉菜單",
                        "Users can select their answer from options defined by the maintainer.": "用戶可以從維護者定義的選項中選擇答案。",
                            "(String Array): Set of values that user can select from to answer. Cannot be empty, and all choices must be distinct.": "(字符串數組）：用戶可從中選擇回答的一組值。不能為空，且所有選擇必須是不同的。",
                        // 可選屬性
                            ", users can submit multiple selections.": "則用戶可提交多選項。",
                        // 驗證
                            ", the form will not be submittable until at least one choice is selected. Only for public repositories.": "則至少選擇一個選項後才能提交表單。僅適用於公共倉庫。",
                    "Checkboxes": "勾選框",
                    "A group of one or more checkboxes. This will be saved as a Markdown checkbox, and will continue to support interactive updating.": "由一個或多個複選框組成的組。這將被保存為 Markdown 複選框，並將繼續支持交互式更新。",
                        "(Array): Set of values that user can select from to answer. Cannot be empty. Each item must have a": "(數組）：用戶可從中選擇回答的數值集合。不能為空。每個專案必須有一個",
                        ", described below.": "，如下所述。",
                    "Within each item in": "對於任何帶",
                        ", the following fields are supported:": "元素則支持以下字段：",
                        "(String): The text that will appear beside the checkbox. Markdown is supported for bold or italic text formatting, and hyperlinks.": "(字符串）：複選框旁邊顯示的文本。Markdown 支持粗體或斜體文本格式以及超鏈接。",
                    "Optional": "可選",
                        "(Boolean): If required, the form will not be submittable unless checked. Only for public repositories.": "(布爾值）：如果需要，除非選中，否則表單將無法提交。僅適用於公共倉庫。",

            // 查找工具欄
                "Find": "查找",
                "next": "下一處",
                "previous": "上一處",
                "all": "全部",
                "match case": "區分大小寫",
                "regexp": "正則",
                "by word": "全字匹配",
                "Replace": "替換",
                "replace": "替換",
                "replace all": "全部替換",

        // 刪除文件頁面 /<user-name>/<repo-name>/delete/<branch>/<file>
            // 頂部提醒
            "File successfully deleted.": "文件已成功刪除。",

            "Copy path to clipboard": "複製路徑到剪切板",

            "Load diff": "加載差異",
            "This file was deleted.": "此文件已刪除。",

        // 上傳文件頁面 /<user-name>/<repo-name>/upload/<branch>
            // 自有倉庫
                "Drag files here to add them to your repository": "拖拽文件添加到當前倉庫",
                "Drag additional files here to add them to your repository": "拖拽其他文件添加到當前倉庫",
                "Or": "或",
                "choose your files": "選擇文件",
                "Drop to upload your files": "拖拽上傳您的文件",
                // 處理反饋
                "Yowza, that’s a big file. Try again with a file smaller than 25MB.": "我勒個擦，這麼大的文件，單文件不得超過25MB",
                "Yowza, that’s a lot of files. Try again with fewer than 100 files.": "我勒個擦，這麼多文件，一次不能超過100個",
                "This file is": "這個文件是",
                "empty": "空的",
                "Something went really wrong, and we can’t process that file.": "遇到錯誤，我們無法處理這個文件。",

                // 文件上傳進度條
                "Uploading": "文件上傳中",
                "of": "/",

                // 提交框 補充
                    "Add files via upload": "通過上傳添加文件",
                    "Add an optional extended description…": "添加可選的擴展描述…",

                    "branch.": "分支。", // 上傳頁面
                    "for this commit and start a pull request.": "為這個提交，並且發起一個拉取請求。", // 上傳頁面
                    "Learn more about pull requests.": "瞭解更多關於拉取請求的信息。", // 上傳頁面

                // 提交後處理頁面
                    "Processing your files…": "正在處理您的文件…",

            // 他人倉庫
                "Uploads are disabled.": "上傳功能已禁用。",
                "File uploads require push access to this repository.": "文件上傳需要推送訪問此倉庫。",

        // new code view
            "Top": "頂部",
            "Jump to file": "跳轉到文件",

    },
    "regexp": [ // 正則翻譯
        [/on this commit as/,"該提交以"],
        [/Commit changes?/, "提交更改"], // 提交對話框
        [/Your license is ready. Please review it below and either commit it to the ([^ ]+) branch or to a new branch./, "您的許可證已準備就緒。請在下面審查它並將其提交到 $1 分支或新分支。"],
        [/Your search has returned (\d+) results?./, "您的搜索返回了 $1 條結果。"],
        [/First (\d+) files? shown./, "顯示前 $1 個文件。"],
        [/([^ ]+) has committed since you started editing./, "$1 自您開始編輯以來已提交。"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/New File at/, "新建文件在"],
            [/Editing (.+) at (.+) · (.+)/, "編輯文件 $1 在分支 $2 · $3"],
        ],
    },
};
I18N["zh-TW"]["repository/edit"] = I18N["zh-TW"]["repository/new"];
I18N["zh-TW"]["repository/delete"] = I18N["zh-TW"]["repository/new"];
I18N["zh-TW"]["repository/upload"] = I18N["zh-TW"]["repository/new"];

I18N["zh-TW"]["repository/find"] = { //  倉庫 - 查找文件頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // Find file 頁面 /<user-name>/<repo-name>/find/<branch>
            "You’ve activated the": "您已激活",
            "file finder": "文件搜索模式",
            ". Start typing to filter the file list. Use": "。輸入關鍵詞查找您的文件。使用",
            "and": "和",
            "to navigate,": "選擇文件",
            "to view files,": "查看文件",
            "to exit.": "返回。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
};

I18N["zh-TW"]["repository/models"] = { // 倉庫 - 模型
    "static": {
        ...I18N["zh-TW"]["repository-public"]["static"],
        "Public Preview": "公共預覽",
        "Expand menu": "展開目錄",
        "Collapse menu": "摺疊目錄",
        "Catalog": "目錄",
        "Share feedback": "反饋",
        "Filter items": "篩選專案",

        // 概況
            "Build your AI products—right inside GitHub. Create prompts, test models, and ship AI-powered features with built-in tools for model access, prompt collaboration, and lightweight evaluation.": "在 GitHub 內部構建您的 AI 產品。利用內置的模型接入、提示協作和輕量級評估工具，創建提示詞、測試模型，並發布 AI 驅動的功能。",
                "Read the docs": "閱讀文檔",
                "to learn more.": "瞭解詳情。",

            "You do not have access to GitHub Models on this repository": "您無權訪問此倉庫上的 GitHub 模型",
                "You need write permissions or higher for this repository to use GitHub Models.": "您需要擁有此倉庫寫入權限或更高權限，才能使用 GitHub 模型。",
                "Learn more about GitHub Models.": "瞭解更多。",

            "Get started": "開始使用",
                "Watch the models demo": "觀看模型演示",
                "Watch this 3-minute demo reel to learn everything you can do with GitHub Models": "觀看這個 3 分鐘的演示視頻，瞭解您可以使用 GitHub 模型完成的所有操作",

            "Prompts": "提示詞",
                "Create, evaluate, and iterate on prompts right inside your repo.": "在您的倉庫內直接創建、評估和迭代提示詞。",
                "Get write permissions or higher for this repository to create and manage prompts.": "獲得對此倉庫的寫入權限或更高權限，才能創建和管理提示詞。",
                "Create a prompt": "創建提示詞",
                "Build with natural language or using": "使用自然語言或使用",
                "prompt.yml files": "prompt.yml 文件",
                "Test sample prompt": "測試示例提示詞",
                "Manage prompts stored in your repo using": "管理您倉庫中的提示詞，使用",
                "Get started with Models in your codebase": "開始使用模型您的程式碼庫", // 還有一些部分未翻譯

            "Add AI to your project now": "立即添加 AI 到您的專案",
                "Drop this snippet into your code to start using AI instantly.": "將此程式碼片段插入您的程式碼中，即可立即開始使用 AI。",
                "Get API Key": "獲取 API 密鑰",

            "Explore 40+ models in the catalog": "在目錄中探索 40+ 模型",
                "Compare models in the playground—test parameters, token usage, and latency to find the right fit for your use case.": "在遊樂場中對比模型——測試參數、令牌使用量和延遲，以找到最適合您用例的模型。",
            "Power your prompt with the right model": "為您的提示詞選擇合適的模型",
                "Test and compare models against your prompt to find the best fit, then commit it directly to your project when you're ready.": "針對您的提示詞測試和對比不同模型，以找到最合適的模型，然後在準備好後將其直接提交到您的專案中。",
            "Instrument your Actions workflow with models": "使用模型為您的 Actions 工作流提供支持",
                "Set up a new GitHub Actions workflow using models.": "使用模型新建 Actions 工作流。",

        // 提示詞
            "Manage": "管理",
                "prompts stored in your repo using": "您倉庫中的提示詞，使用",
                ".prompt.yml file": ".prompt.yml 文件",
                "format.": "格式。",
    },
    "regexp": [
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) prompts? found/, "$1 條提示詞"],
    ],
    "title": {
        "regexp": [
            [/Models/, "模型"],
            [/Prompts/, "提示詞"],
        ],
    },
}

I18N["zh-TW"]["repository/wiki"] = { // 倉庫 - wiki 頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // wiki 頁面  /<user-name>/<repo-name>/wiki
            // [/Welcome to the ([^ ]+) wiki!/, "歡迎訪問 $1 的 Wiki"], // wiki頁面
            "You do not have permission to update this wiki.": "您無權更新此 wiki。",
            "Wikis provide a place in your repository to lay out the roadmap of your project, show the current status, and document software better, together.": "Wiki 為您的倉庫提供了一個更好的文檔資料。",
            "Create the first page": "創建第一個頁面",

            // [/edited this page/, "編輯此頁"], // wiki
            // [/(\d+) revisions?/, "$1 次修訂"], // wiki
            "New page": "新建頁面",
            "Add a custom footer": "添加自定義頁腳",

            // 右側欄
            "Pages": "頁面",
                "Toggle table of contents": "摺疊/展開目錄",
                "Find a page…": "搜索頁面…",
            "Add a custom sidebar": "添加自定義側邊欄",
            "Clone this wiki locally": "在本地克隆這個 Wiki",

            "Last updated": "最後更新",

        // 新建 wiki 頁面 /<user-name>/<repo-name>/wiki/_new
            "Create new page": "創建新頁面",
            "Title": "標題",
            "Write": "編輯",
            "Preview": "預覽",
            "Edit mode:": "標記語言：",
            "Edit message": "提交信息",

            "Write a small message here explaining this change. (Optional)": "請簡要描述所作修改(可選)",
            "Save page": "保存頁面",
            // 頂部提醒
                "Your Wiki was created.": "您的 Wiki 已創建。",

        // 編輯 wiki 頁面 /<user-name>/<repo-name>/wiki/<page name>/_edit
            // [/Editing/, "編輯"], //編輯 wiki
            "Page history": "頁面歷史",
            "Delete page": "刪除頁面",
                "Are you sure you want to delete this page?": "您確定要刪除此頁面嗎？",

            "Someone has edited the wiki since you started. Please reload this page and re-apply your changes.": "此頁面已被其他用戶修改。請重新加載此頁面並重新應用您的更改。",

            // 頂部提醒
                "The wiki page was successfully deleted.": "Wiki 頁面已成功刪除。",

        // wiki頁面歷史 /<user-name>/<repo-name>/wiki/<page name>/_history
            "History": "歷史",
            "Edit page": "編輯頁面",
            "Revisions": "修訂",
            "Compare revisions": "對比修訂",
                "Invalid or empty diff.": "無效或無差異。",

        // wiki修訂間差異 /<user-name>/<repo-name>/wiki/<page name>/_compare
            "Revert changes": "撤銷更改",
            "Back to top": "回到頂部",
            "Showing": "顯示",
            "with": "包含",
            "Unified": "同屏",
            "Split": "分屏",
            // 差異按鈕
                "Display the source diff": "顯示源差異",
                "Display the rich diff": "顯示富差異",
            // 修改的文件 右側下拉
                "Show comments": "顯示評論",
                "Show annotations": "顯示註釋",
                "View file": "查看文件",
                "Edit file": "編輯文件",
                "Delete file": "刪除文件",

        // wiki 編輯器（補全未翻譯部分
            // 工具欄
                "Header 1": "1 級標題",
                "Header 2": "2 級標題",
                "Header 3": "3 級標題",

                "Image": "圖片",
                    "Insert Image": "插入圖片",
                        "Image URL": "圖片 URL",
                        "Alt Text": "文本",

                "Unordered List": "無序列表",
                "Ordered List": "有序列表",
                "Blockquote": "整段引用",
                "Horizontal Rule": "水平規則",

                "Help": "幫助",
                    "Block Elements": "段落元素",
                        "Paragraphs & Breaks": "圖表 & 段落",
                            "To create a paragraph, simply create a block of text that is not separated by one or more blank lines. Blocks of text separated by one or more blank lines will be parsed as paragraphs.": "要創建一個段落，只需創建一個沒有一個或多個空行分隔的文本塊即可。被一個或多個空行分隔的文本塊將被解析為段落。",
                            "If you want to create a line break, end a line with two or more spaces, then hit Return/Enter.": "如果要創建換行符，請在行尾空兩格或更多格，然後按 Return/Enter 鍵。",
                        "Headers": "標題",
                            // Markdown 支持兩種標題格式。維基編輯器使用“atx”樣式的標題。只需在標題文本前加上 # 字符數即可指定標題深度。例如：# 1 級標題，## 2 級標題 和 ### 3 級標題 的標題將逐漸變小。您可以用任意數量的#號結束標題。
                            "Markdown supports two header formats. The wiki editor uses the “atx”-style headers. Simply prefix your header text with the number of": "Markdown 支持兩種標題格式。維基編輯器使用“atx”樣式的標題。只需在標題文本前加上",
                            "characters to specify heading depth. For example:": "字符數即可指定標題深度。例如：",
                            "will be progressively smaller headers. You may end your headers with any number of hashes.": "的標題將逐漸變小。您可以用任意數量的#號結束標題。",
                        "Blockquotes": "整段引用",
                            // Markdown 通過在每行前加上 > 來創建電子郵件風格的 “楷體引號”。如果您決定硬包文本並在每行前加上 > 字符，這種方法看起來效果最好，但 Markdown 也支持在段落前加上 >。
                                "Markdown creates blockquotes email-style by prefixing each line with the": "Markdown 通過在每行前加上",
                                ". This looks best if you decide to hard-wrap text and prefix each line with a": "來創建電子郵件風格的 “楷體引號”。如果您決定硬包文本並在每行前加上",
                                "character, but Markdown supports just putting": "字符，這種方法看起來效果最好，但 Markdown 也支持在段落前加上",
                                "before your paragraph.": "。",
                        // 清單
                            // Markdown 支持有序和無序列表。要創建有序列表，只需在每行前加上一個數字（任何數字都可以，這就是編輯器只使用一個數字的原因）。要創建無序列表，可以在每行前加上 *、+ 或 -。
                                "Markdown supports both ordered and unordered lists. To create an ordered list, simply prefix each line with a number (any number will do — this is why the editor only uses one number.) To create an unordered list, you can prefix each line with": "Markdown 支持有序和無序列表。要創建有序列表，只需在每行前加上一個數字（任何數字都可以，這就是編輯器只使用一個數字的原因）。要創建無序列表，可以在每行前加上",
                                "or": "或",
                            // 列表項可以包含多個段落，但每個段落必須縮進至少 4 個空格或一個製表符。
                                "List items can contain multiple paragraphs, however each paragraph must be indented by at least 4 spaces or a tab.": "列表項可以包含多個段落，但每個段落必須縮進至少 4 個空格或一個製表符。",
                        "Code Blocks": "程式碼塊",
                            "Markdown wraps code blocks in pre-formatted tags to preserve indentation in your code blocks. To create a code block, indent the entire block by at least 4 spaces or one tab. Markdown will strip the extra indentation you’ve added to the code block.": "Markdown 將程式碼塊封裝在預設格式的標籤中，以保留程式碼塊的縮進。要創建程式碼塊，請將整個程式碼塊縮進至少 4 個空格或一個製表符。Markdown 會去掉您添加到程式碼塊中的額外縮進。",
                        "Horizontal Rules": "水平規則",
                            "Horizontal rules are created by placing three or more hyphens, asterisks or underscores on a line by themselves. Spaces are allowed between the hyphens, asterisks or underscores.": "橫線規則是將三個或三個以上的連字符、星號或下劃線單獨放在一行中。連字符、星號或下劃線之間允許有空格。",
                    "Span Elements": "引用元素",
                        "Links": "鏈接",
                            // Markdown 有兩種鏈接類型：內聯和引用。對於這兩種類型的鏈接，您希望向用戶顯示的文本都放在方括號中。例如，如果您想讓鏈接顯示文本 “GitHub”，您可以寫成 [GitHub]。
                                "Markdown has two types of links:": "Markdown 有兩種鏈接類型：",
                                "inline": "內聯",
                                "reference": "引用",
                                ". For both types of links, the text you want to display to the user is placed in square brackets. For example, if you want your link to display the text “GitHub”, you write": "。對於這兩種類型的鏈接，您希望向用戶顯示的文本都放在方括號中。例如，如果您想讓鏈接顯示文本 “GitHub”，您可以寫成",
                            // 要創建內嵌鏈接，請在括號後創建一組括號，並在括號內寫入 URL。(例如，[GitHub](https://github.com/)）。內聯鏈接允許使用相對路徑。
                                "To create an inline link, create a set of parentheses immediately after the brackets and write your URL within the parentheses. (e.g.,": "要創建內嵌鏈接，請在括號後創建一組括號，並在括號內寫入 URL。(例如，",
                                "). Relative paths are allowed in inline links.": "）。內聯鏈接允許使用相對路徑。",
                            // 要創建引用鏈接，請使用兩組方括號。[[我的內部鏈接|內部引用]]將鏈接到內部引用。
                                "To create a reference link, use two sets of square brackets.": "要創建引用鏈接，請使用兩組方括號。",
                                "will link to the internal reference": "將鏈接到",
                        "Emphasis": "強調",
                            // 星號（*）和下劃線（_）被視為強調，並用 `<em>` 標籤包裹，這在大多數瀏覽器中通常顯示為斜體。雙星號（**）或雙下劃線（__）被視為使用 `<strong>` 標籤的粗體。要創建斜體或粗體文本，只需用單個/雙個星號/下劃線包裹您的單詞。例如，**我的雙重強調文本** 變成我的雙重強調文本，*我的單一強調文本* 變成我的單一強調文本。
                                "Asterisks (": "星號（",
                                ") and underscores (": "）和下劃線（",
                                ") are treated as emphasis and are wrapped with an": "）被視為強調，並用",
                                "tag, which usually displays as italics in most browsers. Double asterisks (": "標籤包裹，這在大多數瀏覽器中通常顯示為斜體。雙星號（",
                                ") or double underscores (": "）或雙下劃線（",
                                ") are treated as bold using the": "）被視為使用",
                                "tag. To create italic or bold text, simply wrap your words in single/double asterisks/underscores. For example,": "標籤的粗體。要創建斜體或粗體文本，只需用單個/雙個星號/下劃線包裹您的單詞。例如，",
                                "becomes": "變成",
                                ", and": "，",
                        // 程式碼
                            // 要創建內聯程式碼，只需用反標 (`) 將程式碼包起來即可。Markdown 會將 `myFunction` 變成 myFunction。
                                "To create inline spans of code, simply wrap the code in backticks (": "要創建內聯程式碼，只需用反標",
                                "). Markdown will turn": ") 將程式碼包起來即可。Markdown 會將",
                                "into": "變成",
                        "Images": "圖片",
                            // Markdown 的圖像語法與鏈接語法很相似；基本上是相同的語法，前面加上一個感嘆號（!）。例如，如果您想鏈接到 https://github.com/unicorn.png 網站上的圖片，並使用另一文本 “我的獨角獸”，您可以寫成 ![My Unicorn](https://github.com/unicorn.png)。
                            "Markdown image syntax looks a lot like the syntax for links; it is essentially the same syntax preceded by an exclamation point (": "Markdown 的圖像語法與鏈接語法很相似；基本上是相同的語法，前面加上一個感嘆號（",
                            "). For example, if you want to link to an image at": "）。例如，如果您想鏈接到",
                            "with the alternate text": "網站上的圖片，並使用另一文本",
                            ", you would write": "，您可以寫成",
                    "Miscellaneous": "雜項",
                        "Automatic Links": "自動鏈接",
                            // 如果您想創建一個能顯示實際 URL 的鏈接，markdown 允許您用 < 和 > 來快速封裝 URL。例如，只要寫入 <https://github.com/>，就能輕鬆創建 https://github.com/ 鏈接。
                            "If you want to create a link that displays the actual URL, markdown allows you to quickly wrap the URL in": "如果您想創建一個能顯示實際 URL 的鏈接，markdown 允許您用",
                            "to do so. For example, the link": "來快速封裝 URL。例如，創建鏈接",
                            "is easily produced by writing": "只需寫入",
                        "Escaping": "忽略",
                            "If you want to use a special Markdown character in your document (such as displaying literal asterisks), you can escape the character with the backslash (": "如果您想在文檔中使用特殊的 Markdown 字符（例如顯示星號），可以用反斜槓 (",
                            "). Markdown will ignore the character directly after a backslash.": ") 來轉義該字符。Markdown 將忽略反斜線後的字符。",
                            //"If you want to use a special Markdown character in your document (such as displaying literal asterisks), you can escape the character with the backslash (\). Markdown will ignore the character directly after a backslash.": "如果您想在文檔中使用特殊的 Markdown 字符（例如顯示星號），可以用反斜槓 (\) 來轉義該字符。Markdown 將忽略反斜線後的字符。",

            // 底部
                "Attach files by dragging & dropping, selecting or pasting them.": "通過拖放、選擇或粘貼來添加文件。",
                "Styling with Markdown is supported": "支持使用 Markdown 創建樣式",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Welcome to the ([^ ]+) wiki!/, "歡迎訪問 $1 的 Wiki"], // wiki頁面
        [/edited this page/, "編輯此頁"], // wiki
        [/(\d+) revisions?/, "$1 次修訂"], // wiki
        [/Editing/, "編輯"], //編輯 wiki
        [/Could not find version "([^ ]+)"/, "找不到版本 “$1”"],
        [/Compare:/, "對比："],
        [/(\d+) additions?/, "$1 處增加"],
        [/(\d+) deletions?/, "$1 處刪除"],
    ],
};

I18N["zh-TW"]["repository/branches"] = { // 倉庫 - 分支頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 分支頁面 branches  /<user-name>/<repo-name>/branches
            // 標籤卡欄
            "Overview": "概況",
            "Yours": "您的",
            "Active": "活躍的",
            "Stale": "陳舊的",
            "All branches": "所有分支",
            "All": "所有",
            "branches": "分支",
            "New branch": "新建分支",
                // 創建分支對話框
                "Branch source": "源分支",
                    "Choose from this fork or its upstream repository.": "從此複刻或其上游倉庫中進行選擇。",
                    "Choose a source branch": "選擇源分支",
                "Share feedback": "分享反饋",
            "Search branches…": "搜索分支…",
            "Copy branch name to clipboard": "複製分支名到剪切板",

            "Default branch": "默認分支",
            "Switch default branch": "切換默認分支",
            "View branch activity": "查看分支活動",
            "Default": "默認",

            // [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保護"],
            "Your": "您的",
            "branch isn't protected": "分支不受保護",
            "Protect this branch from force pushing or deletion, or require status checks before merging.": "保護此分支不被強制推送或刪除，或在合併之前要求狀態檢查。",
            "Dismiss": "駁回",
            "Protect this branch": "保護該分支",

            "Updated": "更新於",
            "New pull request": "發起拉取請求",

                // 重命名分支對話框
                "Rename default branch": "重命名默認分支", // 重命名默認分支 標題
                "Rename this branch": "重命名分支", // 重命名其他分支 標題
                "Rename": "重命名",
                "to:": "為：",
                "Most projects name the default branch": "大多數專案將默認分支名為",
                "Renaming this branch:": "重命名此分支：",
                    // 該分支存在來自其他分支的拉取請求時
                        "Will update": "將更新",
                        "pull request targeting this branch.": "條針對該分支的拉取請求。",
                        "pull": "條拉取請求",
                        "request": " ",
                        "targeting this": "針對",
                        "branch.": "該分支。",
                        "branch protection rule that explicitly targets": "條分支保護規則明確針對",

                    // 該分支存在用於其他分支的拉取請求時
                        "Will close": "將關閉",
                        "open pull request for this branch.": "個該分支的拉取請求。",
                        "open pull": "個打開的拉取請求",
                        "for this branch.": "針對該分支。",

                    // 重命名 GitHub Pages 所在分支
                        "Will unpublish current GitHub Pages site.": "將取消當前發佈的 GitHub Pages 站點。",
                            "Your current GitHub Pages site will become unpublished. A new commit on the renamed branch will publish the GitHub Pages site again.": "您當前的 GitHub Pages 站點將被取消發佈。重命名分支上的新提交將再次發佈 GitHub Pages 站點。",

                    "Will not update your members' local environments.": "不會更新您成員的本地環境。",
                "Renaming this branch will not update your members' local environments.": "重命名此分支不會更新您成員的本地環境。",
                    "Your members will have to manually update their local environments. We'll let them know when they visit the repository, or you can share the following commands.": "您的成員將不得不手動更新他們的本地環境。我們會在他們訪問倉庫時通知他們，或者您可以共享以下命令。",

                "Rename branch": "重命名分支",
                "Saving…": "保存中…",

                "Deleted": "已刪除",
                // 刪除分支後
                "Restore": "還原",
                "Deleted just now by": "剛剛被刪除",

                // 刪除對話框 僅當該分支存在拉取請求
                "The branch": "分支",
                // [/is associated with (\d+) open pull requests?:/, "與 $1 個拉取請求相關聯："], // 分支頁面
                "is associated with an open pull request:": "與 1 個拉取請求相關聯：", // 分支頁面
                "If you delete this branch, the pull request will be closed.": "如果您刪除此分支，則拉取請求將被關閉。",
                "Are you sure you want to delete this branch?": "您確定要刪除此分支嗎？",

                // 頂部提醒
                // [/Branch ([^ ]+) will be renamed to ([^ ]+) shortly./,"分支 $1 將很快重命名為 $2。"], //分支重命名成功

            "Your branches": "您的分支",
            "You haven’t pushed any branches to this repository.": "您沒有推送任何分支到該倉庫。",
            "Active branches": "活躍的分支",
            "There aren’t any active branches.": "沒有任何活躍的分支。",
            "Stale branches": "陳舊的分支",
            "There aren’t any stale branches.": "沒有任何陳舊的分支。",
            "View more active branches": "查看更多活躍的分支",
            "View more stale branches": "查看更多陳舊的分支",

            // [/(\d+) commits? ahead, (\d+) commits? behind ([^ ]+)/, "領先 $1 個提交，落後 $2 個提交於 $3"],

            // 新版分支視圖
                // 創建分支對話框
                "Create a branch": "創建分支",
                    "New branch name": "新分支名稱",
                    "Source": "源分支",
                        "Switch branches": "切換分支",
                        "Find a branch...": "查找分支…",
                        "default": "默認",
                    "Create new branch": "創建新分支",

                "Search branches...": "搜索分支…",

                // 無匹配結果
                    "No branches": "沒有分支",
                    "No branches match the search": "沒有符合搜索條件的分支",

                "Check status": "檢查狀態",
                "Behind": "落後",
                "Ahead": "領先",
                "Pull request": "拉取請求",

                "Copy branch name to clipboard": "將分支名稱複製到剪貼板",
                "This branch is protected by branch protections": "該分支受分支保護的保護",

                "Branch menu": "分支菜單",
                    "Activity": "活動",
                    "View rules": "查看規則",
                        "There are no rulesets associated with this branch.": "該分支沒有相關的規則集。",

                "View more branches": "查看更多分支",

                // 底部提醒
                    "You can't delete this protected branch.": "您無法刪除此受保護分支。",
                    "You can't delete the default branch.": "您不能刪除默認分支。",
                    "Branch could not be deleted.": "不能刪除分支。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Your ([^ ]+) branch isn't protected/, "您的 $1 分支不受保護"],
        [/Rename default branch/, "重命名默認分支"],
        [/Rename branch/, "重命名分支"],
        [/Your branch name will be ([^ ]+)/, "分支將重命名為 $1"],
        [/Delete branch/, "刪除分支"],
        // [/is associated with (\d+) open pull requests?:/, "與 $1 個拉取請求相關聯："],
        [/Branch ([^ ]+) will be renamed to ([^ ]+) shortly./,"分支 $1 將很快重命名為 $2。"], //分支重命名成功
        [/(\d+) commits? ahead, (\d+) commits? behind ([^ ]+)/, "領先 $1 個提交，落後 $2 個提交於 $3"],
        [/(\d+) commits? behind ([^ ]+)/, "落後 $1 個提交於 $2"],
        [/(\d+) commits? ahead ([^ ]+)/, "領先 $1 個提交於 $2"],
        [/Ahead behind count: (\d+)/, "領先落後數：$1"],
    ],
    "selector": [ // 元素篩選器規則
        ["a[data-target='branch-filter.allFilter']", "所有分支"],
    ],
    "title": {
        "regexp": [
            [/Branches/, "分支"],
        ],
    },
};

I18N["zh-TW"]["repository/activity"] = { // 倉庫 - 活動頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 活動頁面 /<user-name>/<repo-name>/activity
            "Activity": "活動",

            "All branches": "所有分支",
                "Switch branches": "切換分支",
                "Find a branch...": "查找分支…",
                "Branches": "分支",
                "default": "默認",
                "View activity for all branches": "查看所有分支的活動",

            "All activity": "所有活動",
                "Direct pushes": "直接推送",
                "Pull request merges": "拉取請求合併",
                "Merge queue merges": "合併隊列合併",
                "Force pushes": "強制推送",
                "Branch creations": "創建分支",
                "Branch deletions": "刪除分支",

            "All users": "所有用戶",
                "Find a user...": "查找用戶…",
                "View activity for all users": "查看所有用戶的活動",

            "All time": "所有時間",
                "Last 24 hours": "過去 24 小時",
                "Last week": "上星期",
                "Last month": "上個月",
                "Last quarter": "上季度",
                "Last year": "去年",


            "Showing oldest first": "顯示最早的",
            "Showing most recent first": "顯示最近的",

            "Compare changes": "比較變更",
            "Restore Branch": "恢復分支",

            "Previous": "上一頁",
            "Next": "下一頁",

            "Direct push": "直接推送",
            "Pull request merge": "拉取請求合併",
            "Force push": "強制推送",
            "Branch creation": "創建分支",
            "Branch deletion": "刪除分支",

            "force pushed to": "強制推送到",
            "deleted": "刪除",

            "Share feedback about this page": "分享關於此頁面的反饋",

        // 活動頁面 - 指定分支 /<user-name>/<repo-name>/activity?ref=<branch-name>
            "created this branch": "創建此分支",
            "deleted this branch": "刪除此分支",
            "force pushed": "強制推送",

            "No activity matched your search.": "沒有與您搜索相匹配的活動。",
            "Try expanding your search by selecting a different branch, activity type, user, or timeframe.": "嘗試通過選擇不同的分支、活動類型、用戶或時間範圍來擴大搜索範圍。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/pushed (\d+) commits? to/, "推送 $1 個提交到"],
        [/pushed (\d+) commits?/, "推送 $1 個提交"],
    ],
};

I18N["zh-TW"]["repository/releases"] = { // 倉庫 - 發行版頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 發行版 頁面 /<user-name>/<repo-name>/releases
            "Releases": "發行版",
            // 無發行版時
            "There aren’t any releases here": "沒有任何發行版",
            "You can create a release to package software, along with release notes and links to binary files, for other people to use. Learn more about releases in": "您可以創建一個發行版來打包軟體，以及發行說明和二進制文件鏈接，供其他人使用。瞭解更多關於發行版的信息，查看",
            "our docs": "文檔",
            "Releases are powered by": "發行版是指通過對倉庫中",
            "tagging specific points of history": "特定歷史點",
            "in a repository. They’re great for marking release points like": "進行標記來發布。用於發佈的版本號類似",
            "Create a new release": "創建發行版",

            // 有發行版時
            "Draft a new release": "起草發行版",
            "Find a release": "搜索發行版",

                // 搜索未找到
                "No releases found": "無匹配結果",
            // 左側欄
            "Pre-release": "預發行版",
            "Latest": "最新發行版",
            "Draft": "草案",

            "Compare": "對比",
                "Choose a tag to compare": "選擇標籤進行比較",
                "Find a tag": "搜索標籤",
                "View all tags": "查看全部標籤",

            "Read more": "閱讀更多內容",
            "Contributors": "貢獻者",
            "Assets": "資源",
            // [/Show all (\d+) assets?/, "顯示所有 $1 個資產？"],

            "Join discussion": "加入討論",

            // [/Edit: (.*)/, "編輯：$1"],
            // [/Delete: (.*)/, "刪除：$1"],

        // 發行版 標籤卡 /<user-name>/<repo-name>/tags
            "Create release": "創建發行版",
            "Edit release": "編輯發行版",

            "Toggle commit message": "顯示/隱藏提交消息",

            "Notes": "說明",
            "Downloads": "下載",

            "Delete tag": "刪除標籤",
                // 刪除標籤 對話框
                    "Delete this tag?": "刪除此標籤？",
                    "This will delete the information for the tag": "這將刪除標籤信息",
                    "and cannot be undone.": "而且無法撤銷。",
                    "Delete this tag": "刪除此標籤",

        // 某個發行版標籤 /<user-name>/<repo-name>/releases/tag/<tag>
            // 不存在發行版時
            // "Create release": "創建發行版",
            "from tag": "來自該標籤",
            // "Edit": "編輯",
            "release": "發行版",

            // "Read release notes": "閱讀發佈說明",
            // 狀態詞
            "released this": "發佈於",
            "tagged this": "標記了",
            "drafted this": "起草了",

            // 刪除標籤對話框
            "Delete tag?": "刪除標籤？",
            "This will delete the information for this tag and cannot be undone.": "將刪除該標籤的所有信息，並且無法撤消。",
            "I understand, delete this tag": "我明白了，依然刪除該標籤",

            // 存在發行版時
            // 15 commits to master since this release

            "Delete release": "刪除發行版",
            // 刪除發行版對話框
            "Delete this release?": "刪除該發行版？",
            // "This will delete the information for this release.": "這將會刪除該發行版的信息。",
                "This will delete the information for the release": "這將刪除該發行版信息：",
            "Delete this release": "刪除發行版",

            // 頂部提醒框
            "Your tag was removed": "您的標籤已刪除",
            "Your release was removed": "您的發行版已刪除",

        // 創建發行版 /releases/new 和 編輯發行版 /releases/edit/<tag>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            // 提醒條
            "This is a draft and won’t be seen by the public unless it’s published.": "這是一個草案，除非發佈，否則不會被公眾看到。",
            "This is a draft and won’t be seen by the public unless it is published": "這是一個草案，除非發佈，否則不會被公眾看到。",
            "Discard draft": "丟棄草案",

            "New Release": "新建發行版", // 上方
            "New release": "新建發行版", // 下方

            "Release notes": "發行版說明",
                "Select a previous tag to create generated release notes": "選擇一個先前的標籤以生成發行說明",

            "Choose a tag": "選擇標籤",
                "Find or create a new tag": "查找或創建新標籤",
                "Search or create a new tag": "查找或新建標籤",
            "Tag:": "標籤：",
                "Select tag": "選擇標籤",
                "Create new tag": "新建標籤",
            "Target:": "目標：",
                "Pick a branch or recent commit": "選擇分支或最近的提交",
                "Filter branches…": "篩選分支…",
                "Filter recent commits…": "篩選最近提交…",
                "Recent Commits": "最近提交…",
            "Choose an existing tag, or create a new tag on publish": "選擇現有的標籤，或在發佈時創建新標籤",
            "Choose an existing tag, or create a new tag when you publish this release.": "選擇現有的標籤，或在您發佈這個版本時，創建新標籤。",

            "Loading tag information…": "載入標籤信息…",
            // 在篩選標籤框輸入 標籤時
            "Create new tag:": "創建新標籤：",
            "on publish": "發佈時",
            // 輸入結果
            "Duplicate tag name": "重複的標籤名",
                "This tag already has release notes. Would you like to": "這個標籤已經有發行說明。您是否願意",
                "edit them?": "編輯它們？",
                "edit the existing notes": "編輯現有註釋",
                "Existing tag": "已存在的標籤",
            "Invalid tag name": "無效的標籤名",
                "We weren’t able to create the release for you. Make sure you have a valid tag.": "我們無法為您創建發行版。請確保您有一個有效的標籤。",
                "There was an error creating your Release: tag name can't be blank, tag name is not well-formed, published releases must have a valid tag.": "創建發行版時出錯：標籤名稱不能為空，標籤名稱格式不正確，已發佈的發行版必須有一個有效的標籤。",
                "We can’t create a tag with this name. Take a look at the suggestions in the sidebar for example tag names.": "我們不能用這個名字創建標籤。看看側邊欄的建議，看看標籤名稱的例子。",
            "Excellent! This tag will be created from the target when you publish this release.": "優秀! 當您發佈這個版本時，這個標籤將從目標創建。",

            "Release title": "發行版標題",

            "Previous tag:": "上一個標籤：",
            "Previous tag": "上一個標籤",
                "Auto": "自動",
                "auto": "自動",
                "Select previous tag to compare": "選擇上一個標籤進行比較",
                    "Find previous tag": "篩選上一個標籤",
            "Generate release notes": "生成發行版說明",
                "Select a valid tag to automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "選擇一個有效的標籤，以自動為該差異中的所有合併拉取請求和該版本的貢獻者添加至 Markdown 說明",
                "Automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "自動為來自此差異和此發行版貢獻者的所有已合併拉取請求，添加 Markdown 說明。",
                "Clear existing notes to automatically add the Markdown for all the merged pull requests from this diff and contributors of this release": "清除現有的註釋，以自動添加來自此差異和此版本貢獻者的所有合併的拉取請求的標記。",

                "There were no pull requests associated with the commits included in this release.": "此版本中沒有與提交相關的拉取請求。",

            "Describe this release": "描述此發行版",

            // 編輯器按鈕(老版)
                "Add heading text": "添加標題文本",
                "Add bold text, <Ctrl+b>": "添加粗體文本 <Ctrl+b>",
                "Add italic text, <Ctrl+i>": "添加斜體文本 <Ctrl+i>",
                "Add a quote, <Ctrl+Shift+.>": "添加引用 <Ctrl+Shift+.>",
                "Add code, <Ctrl+e>": "添加程式碼 <Ctrl+e>",
                "Add a link, <Ctrl+k>": "添加鏈接 <Ctrl+k>",
                "Add a bulleted list, <Ctrl+Shift+8>": "添加無序列表 <Ctrl+Shift+8>",
                "Add a numbered list, <Ctrl+Shift+7>": "添加有序列表 <Ctrl+Shift+7>",
                "Add a task list, <Ctrl+Shift+l>": "添加任務列表 <Ctrl+Shift+l>",
                "Directly mention a user or team": "直接提及用戶或團隊",
                "Reference an issue, pull request or discussion": "引用議題，拉取請求或討論",
                "Add saved reply": "添加快捷回覆",
                    "Select a reply": "選擇回覆",
                        "Filter saved replies": "篩選快捷回覆",
                        "Create a new saved reply": "創建新快捷回覆",
                "Attach files by dragging & dropping, selecting or pasting them.": "通過拖拽、選擇或粘貼來附加文件。",

            // 附加文件
            "Attach binaries by dropping them here or selecting them.": "拖拽文件到這來或選擇它們來附加文件。",
            "Uploading your release now…": "正在上傳到您的發行版…",
            "Uploading your file now…": "正在上傳您的文件…",
            "An attachment with that filename already exists.": "同名附件已經存在。",
            "Try a different file.": "請嘗試不同的文件。",
            "We don’t support that file type.  try zipping it.": "我們不支持該文件類型，請嘗試壓縮它。",
            "Try another file.": "請嘗試另一個文件。",
            "Yowza, that’s a big file.": "喲，這可是個大文件。",
            "Try again": "請嘗試",
            "With a file smaller than 2GB.": "一個小於 2GB 的文件。",
            "This file is empty.": "這是一個空文件。",
            "with a file that’s not empty.": "一個非空的文件。",
            "Something went really wrong, and we can’t process that file.": "確實出了點問題，我們無法處理該文件。",
            "Try again.": "請重試。",

            // "Delete and try uploading this file again.": "刪除並重新上傳。",
            "Upload failed. Delete and try uploading this file again.": "上傳失敗。請刪除並重新上傳。",
            "will be deleted": "將被刪除",
            "Remove": "刪除",
            "Undo": "撤銷",

            "Set as a pre-release": "設置為預發佈版本",
                "This release is labeled as non-production ready.": "此版本標記為非正式版本。",
                "This release will be labeled as non-production ready": "此版本將被標記為非正式版本。",
            "Create a discussion for this release": "為此版本創建討論",
                "People will be able to leave comments and reactions on this release using Discussions.": "人們將能夠使用“討論”對此版本發表評論和反應。",
                        "Category:": "類別：",
                            "Announcements": "公告",
                            "General": "通常",
                            "Ideas": "想法",
                            "Polls": "投票",
                            "Q&A": "問與答",
                            "Show and tell": "展示與講述",
            "Set as the latest release": "設置為最新版本", //edit
                "This release is labeled as the latest for this repository.": "此版本將被標記為此倉庫的最新版本。",
                "This release will be labeled as the latest for this repository.": "此版本將被標記為此倉庫的最新版本。",

            "Publish release": "發佈發行版",
                "Publishing…": "發佈中…",
            "Update release": "更新發行版",
                "Saving release…": "保存中…",
            "Save draft": "保存草案",
            "Saved!": "已保存",
            "Saving draft failed. Try again?": "保存草案失敗。請重試？",

            // 丟棄草案 對話框
            "Are you sure?": "您確定哇?",
            "This will delete the information for this draft.": "這將會刪除該草案的信息。",
            "Delete this draft": "刪除草案",

            // 右側欄
            "Tagging suggestions": "標籤建議",
            "It’s common practice to prefix your version names with the letter": "通常的做法是在版本名稱前加上字母",
            ". Some good tag names might be": "。一些好的標籤名稱可能是",
            "If the tag isn’t meant for production use, add a pre-release version after the version name. Some good pre-release versions might be": "如果標籤不是用於生產的，就在版本名後面加上預發佈版本。一些好的預發佈版本可能是",

            "Semantic versioning": "語義版本管理",
            "If you’re new to releasing software, we highly recommend to": "如果您是發佈新手，我們強烈您",
            "learn more about semantic versioning.": "瞭解更多關於語義版本管理的信息。",

            "A newly published release will automatically be labeled as the latest release for this repository.": "新發布的版本將自動標記為該倉庫的最新版本。",
            "If \'Set as the latest release\' is unchecked, the latest release will be determined by higher semantic version and creation date.": "如果未選中 “設置為最新版本”，則最新版本將由更高語義版本和創建日期確定。",
            "Learn more about release settings.": "瞭解更多關於發行版設置的信息。",

       // 創建 Action 發行版到市場 /releases/new?marketplace 和 編輯 /releases/edit/... >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
            "Release Action": "發佈 Action",
                "Publish this release to the GitHub Marketplace": "將此版本發佈到 GitHub 市場",
                "You must": "您必須",
                "accept the GitHub Marketplace Developer Agreement": "接受 GitHub 市場開發者協議",
                "before publishing an Action.": "在發佈之前。",

                "Publish this Action to the GitHub Marketplace": "將此 Action 發佈到 GitHub  市場",
                "Your Action will be discoverable in the Marketplace and available in GitHub search.": "您的 Action 將在市場中被發現，並可在 GitHub 搜索中找到。",

                "Your action.yml needs changes before it can be published.": "您的 action.yml 需要更改才能發佈。",
                "Everything looks good! You have all the required information.": "一切看起來都不錯！您擁有所有必需的信息。",

                "Name": "名稱",
                    "- Name must be unique. Cannot match an existing action, user or organization name.": "- 名稱必須唯一。不能與現有的操作、用戶或組織名稱相匹配。",
                "Description": "描述",
                "Icon": "圖標",
                "Color": "顏色",

                "A README exists.": "已經存在 README 文件。",

                "Primary Category": "主要類別",
                    "Choose an option": "請選擇",
                "Another Category": "其他分類",
                    "— optional": "— 可選",

        // 發行版評論
            "No significant changes": "無重大變化", // GitHub Action 生成的發行版

        // 反應相關
            "You reacted": "您表達看法",
            "All reactions": "所有看法", // Android UA

    },
    "regexp": [ // 正則翻譯
        [/Show all (\d+) assets?/, "顯示所有 $1 個資產"],
        [/(\d+) commits?/, "$1 個提交"],
        [/to ([^ ]+) since this release/, "在此發行版之後進入 $1 分支"],  // $1 分支在此發行版之後有 xxx 個提交
        [/This will delete the information for the release ([^ ]+)./, "這將刪除發行版 $1 的信息。"],
        [/Toggle (.*)'s commit message/, "切換 $1 的提交消息"],
        [/Edit: (.*)/, "編輯：$1"],
        [/Delete: (.*)/, "刪除：$1"],
        [/Remove attached binary ([^ ]+)/, "刪除 $1"],
        [/and (\d+) other contributors/, "和另外 $1 個貢獻者"],
        [/You and (\d+) others? reacted/, "您和另外 $1 人表達看法"],
        [/^([^ ]+) and ([^ ]+)/, "$1 和 $2"], // 發行版 - 貢獻者（2位
        [/(\d+) (people|person) reacted/, "$1 人表達看法"],
        [/There are no releases containing \"([^ ]+)\"./, "沒有發行版包含“$1”。"],
        [/Edit (.+)/, "編輯 $1"],
        [/^([^ ]+) will be created on publish/, "$1 將在發佈時創建"],
        [/^([^ ]+) is used by another release/, "$1 已存在"], // 省略部分內容
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Releases?/, "發行版"],
            [/Tags/, "標籤"],
            [/New release/, "新建發行版"],
        ],
    },
};
I18N["zh-TW"]["repository/tags"] = I18N["zh-TW"]["repository/releases"];

I18N["zh-TW"]["repository/packages"] = { // 倉庫 - 軟體包頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // /<user-name>/<repo-name>/packages
            "Get started with GitHub Packages": "開始使用 GitHub 軟體包",
            "Safely publish packages, store your packages alongside your code, and share your packages privately with your team.": "安全地發佈包，將您的包與您的程式碼一起存儲，並與您的團隊私下共享您的包。",
             "Choose a registry": "選擇註冊表",

            "A software platform used for building applications based on containers — small and lightweight execution environments.": "用於構建基於容器的應用的軟體平臺——小型輕量級執行環境。",
            "A default package manager used for the Java programming language and the Java runtime environment.": "用於 Java 編程語言和 Java 運行環境的一個默認包管理器。",
            "A free and open source package manager used for the Microsoft development platforms including .NET.": "一個自由和開源的開源包管理器，用於包括 .NET 在內的 Microsoft 開發平臺。",
            "A standard format for distributing Ruby programs and libraries used for the Ruby programming language.": "分發用於 Ruby 編程語言的 Ruby 程式和庫的標準格式。",
            "A package manager for JavaScript, included with Node.js. npm makes it easy for developers to share and reuse code.": "npm 是一個 JavaScript 的包管理器，包含在 Node.js 中。它使開發人員能夠輕鬆地分享和重用程式碼。",
            "Containers": "容器",
            "A single place for your team to manage Docker images and decide who can see and access your images.": "為您的團隊提供一個管理 Docker 鏡像的單一場所，並決定誰可以看到和訪問您的鏡像。",

            "Package settings": "軟體包設置",
            "Repository source": "倉庫來源",
            "This is the repository where the package's source code is stored. This is defined in the repository's package.json file using the": "這是軟體包源程式碼的倉庫。這是在倉庫中的 package.json 文件使用字段",
            "field.": "定義的。",
            "A GitHub repository has been identified as the source for this package. This package will be displayed in this repositories package list.": "GitHub 倉庫已被確定為該軟體包的來源，該軟體包將顯示在此倉庫的軟體包列表中。",
            "You have referenced a non-GitHub source for this package that cannot be verified.": "您引用了一個無法驗證的非 GitHub 來源的軟體包。",
            "Manage Actions access": "操作訪問權限管理",
            "Add Repository": "添加倉庫",
            "Pick the repositories that can access this package using": "選擇可以訪問此軟體包的倉庫，用於",
            "Role:": "角色:",
            "Choose role": "選擇角色",
            "Change role": "更改角色",
            "Read": "只讀",
            "Write": "編輯",
            "Admin": "管理",
            "Remove": "刪除",
            "Actions repository access": "操作倉庫訪問",
            "Pick the repositories that can access this package using GitHub Actions.": "選擇可以使用 GitHub Actions 訪問此軟體包的倉庫。",
            "Permissions added for selected repositories.": "為選定的倉庫添加了權限。",
            "Permissions updated for selected repositories.": "更新了選定倉庫的權限。",
            "Can upload and download this package. Can read and write package metadata.": "可以上傳和下載此軟體包，並且可以讀取和寫入元數據。",
            "Can download this package and read package metadata.": "可以下載此軟體包並讀取元數據。",
            "Can upload, download, and manage this package. Can read and write package metadata. Can delete and restore packages.": "可以上傳、下載和管理此軟體包，可以讀取和寫入元數據，可以刪除和恢復此軟體包。",
            "Can upload, download, and manage this package. Can read and write package metadata. Can grant package permissions.": "可以上傳、下載和管理此軟體包，可以讀取和寫入元數據，可以授予軟體包權限。",
            "Manage Codespaces access": "程式碼空間訪問管理",
            "Codespaces repository access": "程式碼空間倉庫訪問",
            "Pick the repositories that can read this package using GitHub Codespaces.": "選擇可以使用 GitHub 程式碼空間 讀取此軟體包的倉庫。",
            "Pick the repositories that can read this package using": "選擇可以讀取此軟體包的倉庫，用於",
            "Inherited access": "繼承訪問",
            "Inherit access from source repository (recommended)": "從源倉庫繼承訪問權限 (推薦)",
            "Go to": "轉到",
            "to change access, or remove inherited access to manage it separately. Inherited access is recommended.": "的訪問設置以更改訪問權限，或刪除繼承的訪問權限以單獨管理它，建議使用繼承訪問權限。",
            "Danger Zone": "危險操作",
            "Change package visibility": "更改軟體包可見性",
            "This package is currently public.": "該軟體包當前是公開的",
            "This package is currently private.": "該軟體包當前是私有的",
            "Change visibility": "更改可見性",
            "Delete this package": "刪除軟體包",
            "Once you delete a package, there is no going back. Please be certain.": "您一旦刪除了軟體包，將再也無法恢復，請確認！",
            "Manage access": "訪問管理",
            "Invite teams or people": "邀請團隊或人員",

        // 倉庫鏈接對話框
            "Confirm you want to unlink this repository": "確認您要取消與此倉庫的鏈接",
            "Yes, unlink this repository": "是的，取消鏈接此倉庫",

        // 添加倉庫對話框
            "Select repository that can access this package using GitHub actions": "選擇可以使用 GitHub 操作訪問此軟體包的倉庫",
            "Add repositories": "添加倉庫",

        // 刪除倉庫對話框
            "Confirm you want to remove this repository": "確認要刪除此倉庫",
            "Once removed,": "刪除後，",
            "will no longer have access to the": "將無法再訪問",
            "package.": "軟體包。",

        // 程式碼空間添加倉庫對話框
            "Select repository that can access this package using GitHub codespaces": "選擇可以使用 GitHub 程式碼空間訪問此軟體包的倉庫",

        // 更改軟體包可見性對話框
            "Make this package visible to anyone.": "使這個軟體包對所有人都可見。",
            "Make this package visible privately, to organization members that have access.": "僅這個軟體包有權訪問的組織成員可見。",
            "Please type": "請輸入",
            "to confirm:": "進行確認：",
            "I understand the consequences, change package visibility.": "我明白後果，依然更改軟體包可見性",

        // 刪除軟體包對話框
            "Are you absolutely sure?": "您真的確定嗎？",
            "Once this package is deleted, it will no longer be accessible.": "一旦刪除了這個軟體包，您將無法再訪問它。",
            "This action will delete package": "此操作將刪除軟體包",
            ". Versions of this package will no longer be accessible, and it will not appear in searches or package listings.": "。此軟體包的版本將不再可訪問，並且不會出現在搜索結果或軟體包列表中。",
            "I understand the consequences, delete this package": "我明白後果，依然刪除這個軟體包",

        // 更改倉庫角色對話框
            "Select a new role": "選擇新角色",
            "Recommended for non-code contributors who want to view or discuss your package.": "推薦給想要查看或討論您的軟體包的非程式碼貢獻者。",
            "Recommended for contributors who actively push to your package.": "推薦給積極推送程式碼到您的軟體包的貢獻者。",

        // 更改成員角色對話框
            "Recommended for people who need full access to the package, including sensitive and destructive actions like managing security and package visibility.": "建議需要完全訪問軟體包的人員使用，包括管理安全性和軟體包可見性等敏感和破壞性操作。",

        // 訪問管理刪除對話框
            "Confirm you want to remove this user": "確認刪除該用戶",

        // 邀請團隊或人員對話框
            "Invite teams or people to": "邀請團隊或人員參與",
            "Search by username, full name, or email": "搜索用戶名、全名或電子郵件"
    },
    "regexp": [
        [/Are you sure you want to unlink (.*) from (.*)\?/, "您確定要取消 $1 與 $2 的鏈接嗎？"],
        [/(\d+) repositor(y|ies) selected…/, "選中 $1 個倉庫"],
        [/Change the role of (\d+) repositor(y|ies)\?/, "更改 $1 個倉庫的角色？"],
        [/(\d+) repositor(y|ies)/, "$1 個倉庫"],
        [/(\d+) members? selected…/, "選中 $1 個成員"],
        [/Change the role of (\d+) members?\?/, "更改 $1 個成員的角色？"],
        [/(\d+) members?/, "$1 個成員"],
        [/(.*)'s access settings/, "$1 訪問設置"],
        [/Removed access from repository (.*)\./, "刪除了倉庫 $1 的訪問權限。"],
        [/Removed (.*) as a package collaborator\./, "刪除了 $1 作為軟體包的協作者。"],

        // 刪除倉庫對話框
        [/Remove (.*) from (.*)/, "從 $2 中刪除 $1"],

        // 更改倉庫角色對話框
        [/Change (\d+) Roles?/, "更改 $1 個角色"],
    ],
}

I18N["zh-TW"]["repository/pkgs"] = { // 倉庫 - 軟體包
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository/packages"]["static"],

        // /<user-name>/<repo-name>/pkgs/container/<pag name>
            "Installation": "安裝",
                "OS / Arch": "系統 / 架構",
                    "unknown/unknown": "未知/未知",
            "Learn more about packages": "瞭解更多關於軟體包的信息",
            "Learn more about npm packages": "瞭解更多關於 npm 軟體包的信息",
            "Install from the command line": "從命令行安裝",
            "Install from the command line:": "從命令行安裝：",
            "Install via package.json:": "通過 package.json 安裝：",
            "Use as base image in Dockerfile:": "在 Dockerfile 中用作基礎鏡像：",
            "Recent tagged image versions": "最近被標記的映像版本",
            "latest": "最新",
            "Latest": "最新",
            // [/Published (.*) · Digest/, "發佈於 $1 · 摘要"],
            "View all tagged versions": "查看所有被標記的版本",

            "Details": "詳細信息",
                "stars": "星標",
            "Readme": "自述文件",
            "Last published": "最新發布",
            "Total downloads": "總下載量",
            "Start a discussion": "開始討論",
            "Contributors": "貢獻者",
            "Open an issue": "打開一個議題",
            "Package settings": "軟體包設置",

            "Recent Versions": "最近版本",
            "View and manage all versions": "查看和管理所有版本",

            "Add a Readme to the linked repository": "添加一個 README 自述文件到鏈接的倉庫",
            "The linked repository's Readme will be shown here.": "鏈接倉庫中的 README 自述文件將在此處顯示。",

        // 全部版本 /<user-name>/<repo-name>/pkgs/container/<pag name>/versions
            "All versions": "所有版本",
            // [/Published (*)/, "發佈於 $1"],
            // [/(\d+) tagged/, "$1 個標記"],
            // [/(\d+) untagged/, "$1 個未標記"],

        // 某個版本 /<user-name>/<repo-name>/pkgs/container/<pag name>/<version id>
            "About this version": "關於這個版本",
            "Manifest": "清單",
            "No description provided": "未提供說明",
            "This package version was published": "此版本軟體包發佈於",

            "To provide a description, add the following line to your Dockerfile:": "要提供描述，請將以下行添加到您的 Dockerfile 中：",
            "For multi-arch images, set a value for the": "對於多架構鏡像，請設置",
            "key in the": "值在",
            "field of the manifest:": "字段：",
            "Learn more about labelling container images": "瞭解更多關於標記容器鏡像的信息",

            "Download activity": "下載活動",
                "Download activity of this version": "此版本的下載活動",
            "Last 30 days": "最近 30 天",
            "Last week": "最近一週",
            "Today": "今天",

            "Other tags on this version": "此版本的其他標籤",
            "View all versions": "查看全部版本",

        // 版本刪除對話框
            "Are you absolutely sure?": "您真的確定嗎？",
            "This cannot be undone. This will permanently delete the version": "這個操作不能撤銷，這將永久刪除版本",
            "so users and processes won’t be able to download this version.": "，用戶和程式將無法再下載該版本。",
            "Please type": "請輸入",
            "to confirm:": "進行確認：",
            "I understand the consequences, delete this version": "我明白後果，依然刪除此版本"
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository/packages"]["regexp"],

        //[/Published (.*) · Digest/, "發佈於 $1 · 摘要"],
        [/Published (.*) · Digest/, (match, p1) => { // p1為(.+)
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `發佈於 ${translatedDate} · 摘要`;
        }],
        [/Published (.*)/, "發佈於 $1"],
        [/(\d+) tagged/, "$1 個標記"],
        [/(\d+) untagged/, "$1 個未標記"],
        [/(\d+) dependencies/, "$1 個依賴包"],
        [/(\d+) active/, "$1 個可用"],
        [/(\d+) deleted/, "$1 個已刪除"],
        [/(\d+) contributors?/, "$1 位貢獻者"],
    ],
};
I18N["zh-TW"]["packages"] = { // 軟體包 - 未鏈接倉庫的軟體包
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository/pkgs"]["static"],

        "Link this package to a repository": "將此軟體包鏈接到倉庫",
        "By linking to a repository, you can automatically add a Readme, link discussions, and show contributors on this page.": "通過鏈接到倉庫，您可以自動添加 README 自述文件、鏈接討論、在此頁面上顯示貢獻者。",
        "Connect Repository": "關聯倉庫",

        // 關聯倉庫對話框
        "Select a repository to link to this package.": "選擇一個倉庫以鏈接到此軟體包。"
    },
    "regexp": [  // 正則翻譯
        ...I18N["zh-TW"]["repository/pkgs"]["regexp"],
    ],
};

I18N["zh-TW"]["repository/security"] = { // 倉庫 - 安全頁面
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],

        // 安全標籤卡 & 安全概述 /<user-name>/<repo-name>/security

            // 公共部分
            "Reporting": "報告",
                "Policy": "政策",
                "Advisories": "諮詢",
            "Vulnerability alerts": "漏洞警報",
                "Code scanning": "程式碼掃描",
                "Secret scanning": "機密掃描",

            "Disabled": "禁用",
            "Enabled": "啟用",
            "Needs setup": "需要設置",

            "Security overview": "安全概述",
            "Report a vulnerability": "報告漏洞",
            "Fork this repository and edit the file": "複刻此倉庫並編輯文件",
            "Security policy •": "安全政策 •",
                "Define how users should report security vulnerabilities for this repository": "定義用戶應如何報告此倉庫的安全漏洞",

                "Suggest how users should report security vulnerabilities for this repository": "建議用戶應如何報告此倉庫的安全漏洞",
                "Suggest a security policy": "安全政策建議",

                "View how to securely report security vulnerabilities for this repository": "查看如何安全地報告此倉庫的安全漏洞",
                "View security policy": "查看安全策略",

            "Security advisories •": "安全公告 •",
                "View or disclose security advisories for this repository": "查看或公開此倉庫的安全公告",
                "View security advisories": "查看安全公告",
                "View security advisories for this repository": "查看此倉庫的安全公告",

            "Private vulnerability reporting •": "私下漏洞報告 •",
                "Allow users to privately report potential security vulnerabilities": "允許用戶私下報告潛在的安全漏洞",
                "Enable vulnerability reporting": "啟用漏洞報告",
                "See reported vulnerabilities": "查看報告的漏洞",

            "Dependabot alerts •": "Dependabot 警報 •",
                "— Active": "— 激活",
                "Get notified when one of your dependencies has a vulnerability": "當您的一個依賴項存在漏洞時得到通知",
                "Enable Dependabot alerts": "啟用 Dependabot 警報",
                "View Dependabot alerts": "查看 Dependabot 警報",
                "You don't have permissito enable this feature":"您沒有啟用此功能的權限。",

            "Code scanning alerts •": "程式碼掃描警報 •",
                "Automatically detect common vulnerability and coding errors": "自動檢測常見漏洞和編碼錯誤",
                "Set up code scanning": "設置程式碼掃描",
                "View alerts": "查看警報",
                // 私有庫
                "Advanced Security is only available for Organizations": "高級安全只適用於組織",
                "Find out more": "瞭解更多",
                "Code scanning for private repositories is part of GitHub Advanced Security": "私有倉庫的程式碼掃描是 GitHub 高級安全的一部分", //組織倉庫
                "Contact sales": "聯繫銷售", //組織倉庫

            "Secret scanning alerts •": "機密掃描警報 •",
                "Get notified when a secret is pushed to this repository": "當機密被推送到倉庫時得到通知",
                "Enable in settings": "在設置中啟用",
                "View detected secrets": "查看檢測到的機密",

            // "Vulnerability details": "漏洞詳情",
            "High severity": "高風險",
            "Moderate severity": "中風險",
            "Low severity": "低風險",
            // "Create dependabot security update": "創建可靠的安全更新",

            "Suggest a policy": "建議政策",

            "Code scanning configuratierror": "程式碼掃描配置錯誤",
                "CodeQL is reporting errors. Check the": "CodeQL 出錯。檢查",
                "status page": "狀態頁",
                "for help.": "以尋求幫助",

            "Checking code scanning status...": "正在檢查程式碼掃描狀態",

        // 安全政策 /<user-name>/<repo-name>/security/policy
            "Set up a security policy": "制定安全政策",
            "Help your community understand how to securely report security vulnerabilities for your project.": "幫助您的社區瞭解如何安全地報告專案的安全漏洞。",
            "Start setup": "開始設置",

            "No security policy detected": "未檢測到安全策略",
            "This project has not set up a": "該專案尚未設置",
            "file yet.": "文件。",

        // 安全公告 /<user-name>/<repo-name>/security/advisories
            "Security Advisories": "安全公告",
            "Privately discuss, fix, and publish information about security vulnerabilities in your repository's code.": "私人討論，修復和發佈倉庫程式碼中的安全漏洞的信息。",
            "New draft security advisory": "新的安全建議草案",

            // [/(\d+) Draft/, "$1 項草案"],
            // [/(\d+) Published/, "$1 項已發佈"],
            // [/(\d+) Closed/, "$1 項已關閉"],

            "There aren’t any triage security advisories": "沒有任何安全建議通知",
            "There aren’t any draft security advisories": "沒有任何安全建議草案",
            "There aren’t any published security advisories": "沒有任何已發佈的安全公告",
            "There aren’t any closed security advisories": "沒有任何已關閉的安全公告",

            // 他人庫
            "View information about security vulnerabilities from this repository's maintainers.": "查看倉庫維護者提供的安全漏洞信息。",

        // Dependabot 警報 /<user-name>/<repo-name>/security/dependabot
            "Dependabot alerts": "Dependabot 警報",
            "Dependency files checked": "檢查依賴文件",

            "Ignore the false alarms": "忽略誤報",
            "To help you focus on the alerts that matter, Dependabot now proactively dismisses low impact alerts. These alerts may only have limited effects (e.g. long-running builds or tests) or are unlikely to be exploitable.": "為了幫助您專注於重要的警報，Dependabot 現在會主動消除低影響警報。這些警報可能只會產生有限的影響（例如長時間運行的構建或測試）或不太可能被利用。",
            "Opt out": "設置",
            "learn more about auto-dismissing alerts.": "瞭解更多關於自動撤消警報的信息。",

            "Auto-triage your alerts": "自動分類您的警報",
                "Control how Dependabot opens pull requests, ignores false positives and snoozes alerts. Rules can be enforced at the organization level. Free for open source and available for private repos through": "控制 Dependabot 如何打開拉取請求、忽略誤報和推遲警報。規則可以在組織層面強制執行。免費供開源專案使用，私有倉庫需要通過",
                "GitHub Advanced Security.": "GitHub 高級安全性。",
                "Learn more about auto-triage": "瞭解更多關於自動分類的信息",

            "opened": "打開於",

            "Dependabot alerts are disabled.": "Dependabot 警報已禁用。",
            "To receive Dependabot alerts, you must first enable Dependabot alerts in": "要接收 Dependabot 警報，必須首先啟用 Dependabot 警報",
            "this repository’s settings": "在倉庫的設置中",

            "Welcome to Dependabot alerts!": "歡迎使用 Dependabot 警報！",
            "Dependabot alerts track security vulnerabilities that apply to your repository's dependencies. As alerts are created, they’ll appear here.": "Dependabot 警報跟蹤適用於倉庫依賴項的安全漏洞。一旦創建警報後，它們將顯示在此處。",

            "Configure": "設置",
                "Manage repository vulnerability settings": "管理倉庫漏洞設置",
                "Manage Dependabot rules": "管理 Dependabot 規則",
                "Manage account notification settings": "管理賬戶通知設置",
                "Refresh Dependabot alerts": "刷新 Dependabot 警報",
                    "Reprocess your project's current dependency files.": "重新處理專案當前的依賴項文件。",
                    // 頂部提醒
                        "Refresh queued, it may take several minutes to see changes reflected in your alerts.": "刷新隊列後，可能需要幾分鐘才能看到警報中反映的更改。",
                        "Refreshed recently, available again in about 1 hour.": "最近刷新，約 1 小時後可再次使用。",

            "Search all Dependabot alerts": "搜索所有 Dependabot 警報",
                "- submit": "- 提交",
                "Narrow your search": "縮小搜索範圍",
                    "fix-started, no-bandwidth, tolerable-risk, inaccurate, not-used, fixed, auto-dismissed": "修復啟動、無帶寬、可容忍風險、不準確、未使用、已修復、自動忽略",
                    "critical, high, moderate, low": "嚴重、高、中、低",
                    "package-name": "軟體包名稱",
                    "ecosystem-name": "生態系統名稱",
                    "most-important, newest, oldest, severity, manifest-path, package-name, epss-percentage": "最重要、最新、最舊、嚴重性、清單路徑、軟體包名稱、EPSS-百分比",
                    "open, closed": "打開、關閉",
                    "patch": "補丁",
                    "runtime, development": "運行時、開發",
                    "direct": "直接",
                    "team-name": "團隊名稱",
                    "topic-name": "主題名稱",
                    "CVE exploitation likelihood. `n`, `>n`, `<n`, `>=n`, `<=n`, or range `n..n`, where `n` is a number from 0.0 to 1.0": "CVE 被利用的可能性。`n`, `>n`, `<n`, `>=n`, `<=n` 或範圍 `n...n`，其中 `n` 為 0.0 至 1.0 之間的數字",
                    "manifest-name": "清單名稱",

            // 篩選條
                "Closed as": "關閉",
                    "Filter by resolution": "按決議篩選",
                    "Clear resolution": "清除決議篩選",
                        "A fix has already been started": "修復已經開始",
                        "No bandwidth to fix this": "沒有帶寬來修復",
                        "Risk is tolerable to this project": "風險可承受",
                        "This alert is inaccurate or incorrect": "此警報不準確或不正確",
                        "Vulnerable code is not actually used": "漏洞程式碼實際未使用",
                        "Dismissal comment": "忽略評論",
                        "Dismiss Alerts": "忽略警報",
                        "Fixed": "已修復",
                        "fixed": "已修復",
                        "Auto-dismissed": "自動忽略",
            "Package": "軟體包",
                "Filter by packages": "按軟體包篩選",
                "Clear package filter": "清除軟體包篩選器",
                "No results found": "未找到結果",
            "Ecosystem": "生態系統",
                "Filter by ecosystem": "按生態系統篩選",
                "Clear ecosystem filter": "清除生態系統篩選器",
            "Manifest": "清單",
                "Filter by manifest": "按清單篩選",
                "Clear manifest filter": "清除清單篩選器",
            "Severity": "嚴重等級",
                "Filter by severity": "按嚴重性篩選",
            "Sort": "排序",
                "Most important": "最重要的",
                "Newest": "最新的",
                "Oldest": "最早的",
                "Manifest path": "表現路徑",
                "Package name": "包名稱",

            "selected": "條被選中",
            "Dismiss alerts": "忽略警報",
                "Select a reason to dismiss": "選擇忽略理由",

            "opened": "打開於",

            "No results matched your search.": "沒有與您的搜索匹配的結果。",
            "Clear current search filters.": "清除當前搜索篩選器。",

            "ProTip!": "專業提示！",
                "See auto-dismissed alerts with": "要查看自動解除的警報，請使用",
                "to see alerts without an available fix.": "來查看沒有可用修復程式的警報。",
                "Find alerts on your dev dependencies using": "使用以下命令查找開發依賴項的警報：",
                "to see alerts with calls to vulnerable functions.": "查看調用易受攻擊函數的警報。",

         // 具體某條 Dependabot 警報 /security/dependabot/<id>
            "Dismiss alert": "忽略警報",

            "Opened": "打開",
            // [/Upgrade ([^ ]+) to fix/, "升級 $1 去修復"], // 某個 Dependabot 警報
            // [/Upgrade ([^ ]+) to version/, "升級 $1 到版本"], // 某個 Dependabot 警報
            "Create Dependabot security update": "創建 Dependabot 安全更新",

            // [/Dependabot cannot update ([^ ]+) to a non-vulnerable version/, "Dependabot 無法將 $1 更新為無漏洞的版本"],
            "The latest possible version that can be installed is": "最新可以安裝版本是",
            "because of the following conflicting dependency:": "，但是存在以下衝突的依賴項：",
            "because of the following conflicting dependencies:": "，但是存在以下衝突的依賴項：",
            "The earliest fixed version is": "最早修復版本為",
            "Try again": "再試一次",
            "View logs": "查看日誌",
            "about troubleshooting Dependabot errors": "關於排除 Dependabot 錯誤的信息",

            "Transitive dependency": "通過",
            "is introduced via": "傳遞依賴性",

            "Patched version": "補丁版本",

            "Impact": "影響",
            "Patches": "補丁",
            "Workarounds": "解決方法",
            "Workarounds / Mitigations": "解決方法/緩解措施",
            "References": "參考信息",
            "For more information": "更多信息",

            // [/Bump ([^ ]+) from ([^ ]+) to ([^ ]+)/, "將 $1 從 $2 升級到 $3"],
            "Merging this pull request would fix": "合併此拉取請求將修復",
            "Review security update": "審查安全更新",

            "opened this": "打開了這個",

            // 右側欄
                "This score calculates overall vulnerability severity from 0 to 10 and is based on the Common Vulnerability Scoring System (CVSS).": "該分數以通用漏洞評分系統 (CVSS) 為基礎，從 0 到 10 計算總體漏洞嚴重性。",
                "CVSS v4 base metrics": "CVSS v4 基本指標",
                    "Exploitability Metrics": "可利用性指標",
                        "Attack Vector": "攻擊載體",
                            "Network": "網絡",
                            "Local": "本地",
                        "Attack Complexity": "攻擊複雜性",
                        "Attack Requirements": "攻擊要求",
                        "Privileges Required": "所需權限",
                            "None": "無",
                        "User interaction": "用戶交互",
                            "Required": "必須",
                    "Vulnerable System Impact Metrics": "脆弱系統影響指標",
                        "Confidentiality": "保密性",
                        "Integrity": "完整性",
                        "Availability": "可利用性",
                    "Subsequent System Impact Metrics": "後續系統影響指標",
                    "Learn more about base metrics": "瞭解更多關於基礎指標的信息",

                    // CVSS v4 基本指標 對話框 // BUG: 詳細解釋文本翻譯不生效
                    // 可利用性指標
                        "Attack Vector:": "攻擊載體：",
                            "This metric reflects the context by which vulnerability exploitation is possible. This metric value (and consequently the resulting severity) will be larger the more remote (logically, and physically) an attacker can be in order to exploit the vulnerable system. The assumption is that the number of potential attackers for a vulnerability that could be exploited from across a network is larger than the number of potential attackers that could exploit a vulnerability requiring physical access to a device, and therefore warrants a greater severity.": "該指標反映漏洞被利用的可能性的上下文。攻擊者距離越遠（邏輯上和物理上），該指標值（以及由此得出的嚴重性）就越高。假設可以從網絡上利用的漏洞比需要物理訪問設備的漏洞擁有更多的潛在攻擊者，因此嚴重性更高。",
                        "Attack Complexity:": "攻擊複雜性：",
                            "This metric captures measurable actions that must be taken by the attacker to actively evade or circumvent existing built-in security-enhancing conditions in order to obtain a working exploit. These are conditions whose primary purpose is to increase security and/or increase exploit engineering complexity. A vulnerability exploitable without a target-specific variable has a lower complexity than a vulnerability that would require non-trivial customization. This metric is meant to capture security mechanisms utilized by the vulnerable system.": "該指標衡量攻擊者為繞過或規避現有內置安全機制而必須採取的可量化操作。這些機制的主要目的是提升安全性或增加利用難度。不需要目標特定變量的漏洞比需要非平凡定製的漏洞複雜性更低。",
                        "Attack Requirements:": "攻擊要求：",
                            "This metric captures the prerequisite deployment and executiconditions or variables of the vulnerable system that enable the attack. These differ from security-enhancing techniques/technologies (ref Attack Complexity) as the primary purpose of these conditions is not to explicitly mitigate attacks, but rather, emerge naturally as a consequence of the deployment and execution of the vulnerable system.": "該指標衡量使攻擊成為可能的先決部署和執行條件或變量。這些條件與安全增強技術不同（參見攻擊複雜性），它們並非專門用於緩解攻擊，而是脆弱系統部署和運行的自然結果。",
                        "Privileges Required:": "所需權限：",
                            "This metric describes the level of privileges an attacker must possess prior to successfully exploiting the vulnerability. The method by which the attacker obtains privileged credentials prior to the attack (e.g., free trial accounts), is outside the scope of this metric. Generally, self-service provisioned accounts do not constitute a privilege requirement if the attacker can grant themselves privileges as part of the attack.": "該指標描述攻擊者在成功利用漏洞前必須擁有的權限級別。攻擊者在攻擊前獲取特權憑據的方式（如免費試用賬戶）不在本指標範圍內。",
                        "User interaction:": "用戶交互：",
                            "This metric captures the requirement for a human user, other than the attacker, to participate in the successful compromise of the vulnerable system. This metric determines whether the vulnerability can be exploited solely at the will of the attacker, or whether a separate user (or user-initiated process) must participate in some manner.": "該指標衡量除攻擊者外是否需要其他人類用戶參與才能成功攻破脆弱系統。",
                    // 脆弱系統影響指標
                        "Confidentiality:": "機密性：",
                            "This metric measures the impact to the confidentiality of the informatimanaged by the VULNERABLE SYSTEM due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, as well as preventing access by, or disclosure to, unauthorized ones.": "該指標衡量成功利用漏洞後對脆弱系統所管理信息的機密性影響。",
                        "Integrity:": "完整性：",
                            "This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information. Integrity of the VULNERABLE SYSTEM is impacted when an attacker makes unauthorized modificatiof system data. Integrity is also impacted when a system user can repudiate critical actions taken in the context of the system (e.g. due to insufficient logging).": "該指標衡量成功利用漏洞後對信息的可信度和準確性的影響。",
                        "Availability:": "可用性：",
                            "This metric measures the impact to the availability of the VULNERABLE SYSTEM resulting from a successfully exploited vulnerability. While the Confidentiality and Integrity impact metrics apply to the loss of confidentiality or integrity of data (e.g., information, files) used by the system, this metric refers to the loss of availability of the impacted system itself, such as a networked service (e.g., web, database, email). Since availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of a system.": "該指標衡量成功利用漏洞後對脆弱系統本身可用性的影響（如網絡服務被打掛）。",
                    // 後續系統影響指標
                        // 機密性
                            "This metric measures the impact to the confidentiality of the informatimanaged by the SUBSEQUENT SYSTEM due to a successfully exploited vulnerability. Confidentiality refers to limiting information access and disclosure to only authorized users, as well as preventing access by, or disclosure to, unauthorized ones.": "該指標衡量成功利用漏洞後對後續系統所管理信息的機密性影響。",
                        // 完整性
                            "This metric measures the impact to integrity of a successfully exploited vulnerability. Integrity refers to the trustworthiness and veracity of information. Integrity of the SUBSEQUENT SYSTEM is impacted when an attacker makes unauthorized modificatiof system data. Integrity is also impacted when a system user can repudiate critical actions taken in the context of the system (e.g. due to insufficient logging).": "該指標衡量成功利用漏洞後對後續系統數據完整性的影響。",
                        // 可用性
                            "This metric measures the impact to the availability of the SUBSEQUENT SYSTEM resulting from a successfully exploited vulnerability. While the Confidentiality and Integrity impact metrics apply to the loss of confidentiality or integrity of data (e.g., information, files) used by the system, this metric refers to the loss of availability of the impacted system itself, such as a networked service (e.g., web, database, email). Since availability refers to the accessibility of information resources, attacks that consume network bandwidth, processor cycles, or disk space all impact the availability of a system.": "該指標衡量成功利用漏洞後對後續系統本身可用性的影響。",

                "EPSS score": "EPSS 得分",
                "Weaknesses": "缺陷",
                "Related alerts": "相關警報",
                "See advisory in GitHub Advisory Database": "請參閱 GitHub 諮詢數據庫中的諮詢",
                "See all of your affected repositories": "查看您所有受影響的倉庫",
                "See something to contribute?": "看到有什麼可貢獻的嗎？",
                "Suggest improvements for this advisory on the GitHub Advisory Database.": "在 GitHub 諮詢數據庫上建議改進此諮詢。",

            // 生成安全更新
                // 頂部提醒
                    // [/Started generating a security update for ([^ ]+)./, "開始為 $1 生成安全更新。"],
                // [/Creating a security update for ([^ ]+)/, "為 $1 創建安全更新"],
                "Dependabot is creating a security update to fix": "Dependabot 正在創建一個安全更新來修復",
                // [/(\d+) Dependabot alerts?/, "$1 個 Dependabot 警報"],
                // [/on ([^ ]+) in/, "關於 $1 在"],
                // [/Or, manually upgrade ([^ ]+) to version/, "或者，手動將 $1 升級到版本"],
                "or later. For example:": "或更高。例如：",

         // 具體某條Dependabot 警報 日誌 /security/dependabot/<id>/update-logs/<id2>
            "Update logs": "更新日誌",

        // 程式碼掃描器 /<user-name>/<repo-name>/security/code-scanning
            "Automatically detect vulnerabilities in your code.": "自動檢測您程式碼中的漏洞。",
            "Configure tools that integrate with Code Scanning to keep the quality of your code under control. Learn more about": "配置與程式碼掃描集成的工具，以控制程式碼質量。瞭解更多關於",
            "Code Scanning": "程式碼掃描",

            "Configure scanning tool": "配置掃描工具",

            "All tools are working as expected": "所有工具均按預期運行",
            "Tools": "工具",
            "Add tool": "添加工具",

            // 搜索條
                "Available filters": "可用篩選器",
                    "filter by open/closed state": "按打開/關閉狀態篩選",
                    "filter by tool": "按工具篩選",
                    "filter by branch name": "按分支名稱篩選",
                    "filter by pr number": "按 PR 號篩選",
                    "filter by ref (e.g. branches/tags)": "按引用篩選（例如 分支/標籤）",
                    "filter by rule": "按規則篩選",
                    "filter by rule tag": "按規則標籤篩選",
                    "filter by severity": "按嚴重程度篩選",
                    "sort by": "排序方式",
                    "only show alerts in application code": "僅在應用程式程式碼中顯示警報",
                    "filter by closure reason": "按關閉原因篩選",
                    "filter by file path (e.g. lib/crypto or *_test.js)": "按文件路徑篩選（例如 lib/crypto or *_test.js）",
                    "filter by language": "按語言篩選",
                    "filter by assignee": "按受理人過濾",
                    "filter by presence of a property": "按屬性的存在進行過濾",
                    "filter by absence of a property": "按不存在屬性進行過濾",
                "Filter alerts": "篩選警報",

            "Language": "語言",
                "Filter by language": "篩選語言",
            "Tool": "工具",
                "Filter by tool": "篩選工具",
            // 分支
                "Filter by branch": "篩選分支",
            "Rule": "規則",
                "Filter by rule": "篩選規則",
                "Filter rules": "篩選規則",
            // 嚴重等級
                "Medium": "中風險",
                "Error": "錯誤",
                "Warning": "警告",
                "Note": "注意",

            "Looking good!": "看起來不錯！",
                "No new code scanning alerts.": "沒有新的程式碼掃描警報。",
            "No code scanning alerts here!": "尚無程式碼掃描警報！",
                "Keep up the good work!": "繼續努力！",
            "No code scanning alerts found.": "尚無程式碼掃描警報。",
                "We'll keep watching out for new ones.": "我們會繼續關注新的消息。",

            "Detected by": "檢測者",
            "in": "在",

            "CodeQL is reporting errors.": "CodeQL 出錯。",
            "Check the": "檢查",

            // 專業提示
                "You can run CodeQL locally from the command line.": "您可以從命令行在本地運行 CodeQL。",
                "You can run CodeQL locally using Visual Studio Code.": "您可以使用 Visual Studio Code 在本地運行 CodeQL。",
                "CodeQL queries are developed by an open-source coaliticalled the": "CodeQL 查詢由一個開源聯盟開發：", // BUG: 翻譯不生效
                    "GitHub Security Lab": "GitHub 安全實驗室",
                "The libraries and queries that power CodeQL are open-source.": "支持 CodeQL 的庫和查詢是開源的。",
                "You can upload code scanning analyses from other third-party tools using GitHub Actions.": "您可以使用 GitHub Actions 從其他第三方工具上傳程式碼掃描分析。",
                "You can configure CodeQL to run with additional queries.": "您可以配置 CodeQL 以運行其他查詢。",

        // 具體某條 程式碼掃描 警報/<user-name>/<repo-name>/security/security/code-scanning/<id>
            "Code scanning alerts": "程式碼掃描警報",
            "Speed up the remediatiof this alert with": "加快修復此警報的速度，使用", // BUG: 翻譯不生效
                "Copilot Autofix for CodeQL": "CodeQL 的 Copilot 自動修復",
            "Generate fix": "創建修復",
            "Affected branches": "受影響分支",
            "Rule ID": "規則 ID",
            "Query": "查詢",
            "View source": "查看源程式碼",
            "First detected in commit": "首次在提交中檢測到",
            "Assignees": "受理人",
                "No one -": "無人 -",
                "Assign yourself": "分配給自己",
                "Assign up to 10 people to this alert": "最多為 10 人分配此警報",
                "Filter assignees": "篩選受理人",
                // Copilot
                    "bot": "機器人",
                    "Ensure a fix has been generated.": "確保已生成修復程式。",
            "Development": "開發",
                "Link a branch, pull request, or": "鏈接分支、拉取請求或",
                    "create a new branch": "創建新分支",
                    "to start working this alert.": "以開始處理此警報。", // BUG: 翻譯不生效
                "Link a branch or pull request": "鏈接分支或拉取請求",
                "Search pull requests": "搜索拉取請求",
                "Group selected": "已選擇組",
            // 受影響的分支
                "Configurations analyzing": "配置分析",
                    "The following configurations have reported this alert.": "以下配置已報告此警報。",
                    "Last updated": "最後更新",
            "Appeared in branch": "出現在分支",

        // /<user-name>/<repo-name>/security/code-scanning/tools/CodeQL/status
            "Scanned files": "掃描文件",
                "Download language CSV report": "下載語言 CSV 報告",
            "Setup types": "設置類型",
            "Default setup": "默認設置",
            "· Last scan": "· 最近一次掃描",
            "Menu": "菜單",
            "View setup type": "查看設置類型",

        // 機密掃描警報 /<user-name>/<repo-name>/security/secret-scanning
            // 頂端窗口
            "Can you give us some feedback?": "您能給我們一些反饋意見嗎？",
            "We want to better understand our users' needs and experiences.": "我們希望更好地瞭解用戶的需求和體驗。",
            "Book some time with us": "與我們預約時間，",
            "to discuss the GitHub secret scanning experience.": "討論 GitHub 機密掃描體驗。",

            "Secret scanning alerts": "機密掃描警報",
            "Secret scanning disabled": "機密掃描已停用",
                "To scan for secrets, you must first enable secret scanning in": "要掃描機密，您必須首先啟用機密掃描在",
                "this repository's settings": "此倉庫設置",

            // 關閉
                "Revoked": "已撤銷",
                "False positive": "假陽性",
                "Used in tests": "僅測試",
                "Won't fix": "不會修復",
                "Ignored by configuration": "配置忽略",
                "Clear closure reasons": "全部",

            "Bypassed": "繞行",
                "True": "是",
            "Validity": "有效性",
                "Active": "活躍",
                "Inactive": "不活躍",
                "Unknown": "未知",
            "Secret type": "機密類型",
                "Service Providers": "服務提供商",
                "Custom Patterns": "自定義模式",
                "Filter by secret type": "按機密類型篩選",
                "Filter secret type": "篩選機密類型",
                "Nothing to show": "暫無",

            "Provider": "提供者",
                "Filter by provider": "按提供者篩選",
                "Filter provider": "篩選提供者",

            // 排序
                "Recently updated": "最近更新",
                "Least recently updated": "最早更新",

            "Clear current search query, filters, and sorts": "清除當前搜索查詢、過濾器和排序",

            "No secrets found.": "沒有發現任何機密",
            "Try": "嘗試",
            "clearing filters": "清除過濾器",
            "to view all of this repository's secret alerts.": "以查看此倉庫的所有機密警報。",
            "Your repository doesn't have any unresolved secrets.": "您的倉庫沒有任何未解決的機密。",

            // 具體某條信息 https://github.com/<user-name>/<repo-name>/security/secret-scanning/<id>
                "detected a": "檢測到",
                    "secret": "機密",
                "Give us feedback": "提交反饋",

                "Close as": "關閉為",
                    "Select a close reason": "選擇關閉原因",
                    "This secret has been revoked": "機密被撤銷",
                    "This secret is not in production code": "機密不在生產程式碼中",
                    "This alert is not valid": "警報無效",
                    "This alert is not relevant": "警報無關",

                "Reopen alert": "重新打開",

                    "Close alert": "關閉警報",

                "Secret detected": "檢測到",
                "Possibly active secret": "可能活躍",
                    "Copy token": "複製令牌",

                "Remediation steps": "補救措施",
                    "Follow the steps below before you close this alert.": "關閉此警報前，請按照以下步驟操作。",
                    "Rotate the secret if it's in use to prevent breaking workflows.": "如果正在使用，請輪換機密以防中斷工作流程。",
                    "Revoke this": "撤銷",
                    "through": "通過",
                    "to prevent unauthorized access.": "，以防止未經授權的訪問。",
                    //"Revoke this Google API Key through Google to prevent unauthorized access.": "通過 Google 撤銷此 Google API 密鑰，以防止未經授權的訪問。",
                    "Check security logs for potential breaches.": "檢查安全日誌，查找潛在漏洞。",
                    "Close the alert as revoked.": "關閉已撤銷的警報。",

                // 檢測到位置
                    "Preview unavailable": "預覽不可用",
                    "This file is too large to show a preview": "文件過大，無法顯示預覽",

                    // 複製
                        "to clipboard": "到剪切板",

                    "View file": "瀏覽文件",
                    "View git blame": "瀏覽 Git 追溯",

                // 狀態詞
                    "opened this alert": "打開此警報",
                    "reopened this": "重新打開",
                    "closed this as": "將其關閉為",
                    "closed as": "關閉為",
                        "used in tests": "僅測試",
                        "won't fix": "不會修復",
                        "revoked": "忽略",
                        "false positive": "假陽性",
                    "closed this as completed in": "將其關閉為已完成",

                "hidden item": "條隱藏專案",
                "s": " ",
                "Load all...": "加載全部…",

        // 新建安全公告草案 /<user-name>/<repo-name>/security/advisories/new
            "Open a draft security advisory": "打開一個安全公告草案",
            "After the draft security advisory is open, you can privately discuss it with collaborators and create a temporary private fork where you can collaborate on a fix. If you've already fixed the vulnerability, just fill out the draft security advisory and then publish it.": "在安全公告草案打開後，您可以與協作者私下討論，並創建一個臨時的私有複刻，在那裡您們可以協作進行修復。如果您已經修復了該漏洞，只需填寫安全公告草案，然後發佈即可。",

            "Advisory Details": "公告詳情",
            "Title *": "標題 *",
            "CVE identifier": "CVE 標識符",
                "Request CVE ID later": "稍後請求 CVE ID",
                "I have an existing CVE ID": "我有一個現有的 CVE ID",
            "Description *": "描述 *",

            "Affected products": "受影響的產品",
            "Ecosystem *": "生態系統 *",
                "Don't see the ecosystem you're looking for? It may not be supported yet.": "沒有看到您正在尋找的生態系統？可能還不支持。",
                "Select an ecosystem": "選擇一個生態系統",
                "Go": "",
                "Other": "其他",
            "Affected versions": "受影響的版本",
            "Patched versions": "補丁版本",
            "Add another affected product": "添加另一個受影響的產品",

            // 嚴重等級
            "Pending selection": "待選擇",

            "Select severity": "選擇嚴重程度",
                "Low": "低風險",
                "Moderate": "中風險",
                "High": "高風險",
                "Critical": "關鍵風險",
                "Assess severity using CVSS": "使用 CVSS 評估嚴重程度",

            "Vector string": "矢量字符串",

            "Calculator": "計算器",
                "Learn more about CVSS scoring": "瞭解更多關於 CVSS 計分的信息",

                "Adjacent": "鄰近",
                "Physical": "物理",

            "Common weakness enumerator (CWE)": "常見弱點枚舉器 (CWE)",
                "Search by CWE": "按 CWE 搜索",

            "Credits": "用戶",
                "Add a user by username, full name, or email": "通過用戶名、全名或電子郵件添加用戶",

            "Create draft security advisory": "創建安全公告草案",

            // 右側欄
            "Access and visibility": "訪問和可見性",
                "Until it is published, this draft security advisory will only be visible to the maintainers of": "在發佈之前，此安全公告草案僅對以下的所有者可見",
                ". Other users and teams may be added once the advisory is created.": "。 其他用戶和團隊可以在諮詢創建後加入。",
            "Once published, security advisories on public repositories are visible to everyone.": "一旦發佈，公共倉庫上的安全公告對所有人都是可見的。",
            "Once reviewed by GitHub, security advisories may be broadcast on the": "一旦通過 GitHub 的審查，安全公告就可以出現在",
            "GitHub Advisory Database": "GitHub 諮詢數據庫",
            ". They may also trigger Dependabot alerts to users that depend on this repository.": "。它們還可能向依賴此倉庫的用戶觸發 Dependabot 警報。",

            "Security policy": "安全政策",
            "Glossary and documentation": "詞彙表和文檔",
            "Dependabot language support": "Dependabot 語言支持",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/([\d,]+) Triages?/, "$1 分類"],
        [/([\d,]+) Draft/, "$1 草案"],
        [/([\d,]+) Published/, "$1 發佈"],
        [/([\d,]+) Open/, "$1 打開"],
        [/(#\d+) opened/, "$1 打開於"],
        [/([\d,]+) Closed/, "$1 關閉"],
        [/(#\d+) closed as/, "$1 關閉為"],
        [/(\d+) selected/, "$1 條被選中"],
        [/Detected in (\d+) locations?/, "在 $1 個位置檢測到"],
        [/Detected in ([^ ]+)/, "在 $1 中檢測到"],
        [/Upgrade ([^ ]+) to fix/, "升級 $1 去修復"], // 某個 Dependabot 警報
        [/Upgrade ([^ ]+) to version/, "升級 $1 到版本"], // 某個 Dependabot 警報
        [/Dependabot cannot update ([^ ]+) to a non-vulnerable version/, "Dependabot 無法將 $1 更新為無漏洞的版本"],
        [/Bump ([^ ]+) from ([^ ]+) to ([^ ]+)/, "將 $1 從 $2 升級到 $3"],
        [/Started generating a security update for ([^ ]+)./, "開始為 $1 生成安全更新。"],
        [/Creating a security update for ([^ ]+)/, "為 $1 創建安全更新"],
        [/(\d+) Dependabot alerts?/, "$1 個 Dependabot 警報"],
        [/on ([^ ]+) in/, "關於 $1 在"],
        [/Or, manually upgrade ([^ ]+) to version/, "或者，手動將 $1 升級到版本"],
        [/on (.+)/, "$1"],
        [/(\d+)\/(\d+) files? scanned/, "$1/$2 文件已掃描"],
        //[/Copy ([^/]\/(?:[^/]+\/)*[^/]+$) to clipboard/, "複製 $1 到剪切板"],
        [/Prototype Pollution in ([^ ]+)/, "$1 上游汙染"],
        [/First detected (.+)/, (match, p1) => { // 受影響的分支 // BUG: 翻譯不生效
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `初次檢測 ${translatedDate}`;
        }],
    ],
    "title": {
        "regexp": [
            [/Security Overview/, "安全概述"],
            [/Security Policy/, "安全政策"],
            [/Security Advisories/, "安全諮詢"],
            [/Dependabot alerts?/, "Dependabot 警報"],
            [/Code scanning alerts?/, "程式碼掃描警報"],
            [/Secret scanning/, "機密掃描"],
        ],
    },
};

I18N["zh-TW"]["repository/contribute"] = { // 倉庫 - 貢獻頁面
    "static": { // 靜態翻譯

        // 貢獻頁面 /<user-name>/<repo-name>/contribute
            "Contribute to": "貢獻於",
            "Make your first contribution to this repository by tackling one of the issues listed below.": "通過解決下面列出的一個議題，為這個倉庫做出您的第一個貢獻。",
            "Each issue displayed here is a \"good first issue,\" selected for its relative approachability for first-time contributors.": "此處顯示的每個議題都是 “好的首發議題”，因其對首次貢獻者來說相對容易。",

            "Read the contributing guidelines": "閱讀貢獻指南",

            "Good first issues": "好的首發議題",
            "See all issues": "查看所有議題",

            "This repo doesn't have any good first issues, yet": "該倉庫暫無任何好的首發議題",
            "Once its maintainers label issues and pull requests for new contributors, they will begin to appear here.": "一旦它的維護者為新的貢獻者標記了議題和拉取請求，它們就會開始出現在這裡。",
            "All issues in this repository": "此倉庫中的所有議題",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["repository/subscription"] = { // 倉庫 - 通知狀態頁面
    "static": { // 靜態翻譯

        // 倉庫通知狀態管理 /<user-name>/<repo-name>/subscription
            "Your": "您的",
            "notifications status": "通知狀態",
            "A notification is created every time someone discusses something inside of the repository — Pull Requests, Issues, Comments, and Commit discussions. Whether you are watching the repository, not watching it, or ignoring it determines which notifications you receive.": "每當有人在倉庫內討論什麼，比如拉取請求、議題、評論和提交討論，都會產生一個通知。無論您是關注倉庫、不關注還是忽略它，都決定了您會收到哪些通知。",
            "Not watching": "不關注",
                "You will only receive notifications when you participate or are @mentioned.": "只有當您參與或被 @您 時，您才會收到通知。",
            "Releases only": "僅發行版",
                "You will only receive notifications for new releases, or when you participate or are @mentioned.": "您只會收到新版本的通知，或者當您參與或被 @您 時。",
            "Watching": "關注",
                "You will receive all notifications for this repository.": "您將收到此倉庫的所有通知。",
            "Ignored": "忽略",
                "You will not receive any notifications for this repository.": "您將不會收到有關此倉庫的任何通知。",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["repository/invitations"] = { // 倉庫 - 接受邀請頁面
    "static": { // 靜態翻譯

        // 接受邀請 /<user-name>/<repo-name>/invitations
            "invited you to collaborate": "邀請您進行協作",
            "invited you to collaborate on": "邀請您進行協作",
            "Accept invitation": "接受邀請",
            "Decline": "拒絕",
            "Decline invitation": "拒絕",
            "Owners": "所有者",
            "Your public profile information": "您的公開個人資料信息",
            "Certain activity": "某些活動",
            "within this repository": "在這個倉庫中",
            "Country of request origin": "請求來源國家/地區",
            "Your access level for this repository": "您對該倉庫的訪問等級",
            "Your IP address": "您的 IP 地址",
            "Is this user sending spam or malicious content?": "此用戶是否發送垃圾郵件或惡意內容？",

    },
    "regexp": [ // 正則翻譯
        [/of ([^ ]+) will be able to see:/, "$1 將能夠看到："], // 邀請頁
        [/Block ([^ ]+)/, "拉黑 $1"],
    ],
};


// 洞察 >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

I18N["zh-TW"]["repository-insights-menu"] = { // 倉庫 -> 洞察 - 公共部分
    "static": { // 靜態翻譯
        // 公共部分
            // 左側菜單
            "Pulse": "統計",
            "Contributors": "貢獻者",
            "Community": "社區",
            "Community Standards": "社區準則",
            "Community standards": "社區準則",
            "Traffic": "流量",
            "Commits": "提交",
            "Code frequency": "程式碼頻率",
            "Dependency graph": "依賴項關係圖",
            // "Punch card": "時刻",
            "Network": "網絡",
            // "Members": "成員",
            "Forks": "複刻",
            "Actions Usage Metrics": "操作使用情況",
            "Actions Performance Metrics": "操作數據看板",
            "Actions usage metrics": "操作使用情況",
            "Actions performance metrics": "操作數據看板",

            "People": "成員", //組織倉庫

            // 私有庫禁用部分功能的提醒
            "Upgrade to GitHub Pro or make this repository public to enable this feature.": "升級到 GitHub Pro 或將此倉庫設為公開以啟用此功能。",
            // 他人私有庫
            "Contact an administrator to upgrade to GitHub Team or make this repository public to enable this feature.": "請聯繫管理員升級到 GitHub 團隊或將此設為倉庫公開以啟用此功能。",

            "We want to know how these insights are helping you and where they could be improved.": "我們想知道這些洞察如何幫助您，以及在哪些方面可以改進。",
            "Give us your feedback": "向我們提供反饋意見",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["repository/pulse"] = { // 倉庫 -> 洞察 - 統計
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 統計 /<user-name>/<repo-name>/pulse
            "Period:": "週期：",
                "Filter activity": "篩選活動",
                "24 hours": "24 小時",
                "3 days": "3 天",
                "1 week": "1 周",
                "1 month": "1 個月",
            "Active pull request": "活躍的拉取請求",
            "Active pull requests": "活躍的拉取請求",
            "Active issue": "活躍的議題",
            "Active issues": "活躍的議題",
            "Merged pull request": "合併的拉取請求",
            "Merged pull requests": "合併的拉取請求",
            "Open pull request": "打開的拉取請求",
            "Open pull requests": "打開的拉取請求",
            "Closed issue": "關閉的議題",
            "Closed issues": "關閉的議題",
            "New issue": "新議題",
            "New issues": "新議題",

            "Excluding merges,": "不包括合併，",
            // [/(\d+) authors?/, "$1 位作者"],
            "have pushed": "推送了",
            "has pushed": "推送了",
            "commit": "次提交",
            "commits": "次提交",
            // [/to ([^ ]+), and/, "到 $1 分支和"],
            // [/to all branches. On ([^ ]+),/, "到全部分支。在 $1 分支，"],
            // [/(\d+) files?/, "$1 個文件"],
            "have changed and there have been": "已經發生了變化，並且有",
            "has changed and there have been": "已經發生了變化，並且有",
            "additions": "處增加",
            "deletions": "處刪除",

            "commit authored by": "次提交，作者：",
            "commits authored by": "次提交，作者：",

            "Want to help out?": "想幫忙嗎？",
            "Fork this repository": "複刻倉庫",
            "Release published by": "個發行版已發佈由",
            "Releases published by": "個發行版已發佈由",
            "published": "發佈",
            "Pull request merged by": "個拉取請求已合併由",
            "Pull requests merged by": "個拉取請求已合併由",
            "Pull request opened by": "個拉取請求打開由",
            "Pull requests opened by": "個拉取請求打開由",
            "Issue closed by": "個議題已關閉由",
            "Issues closed by": "個議題已關閉由",
            "Issue opened by": "個議題打開由",
            "Issues opened by": "個議題打開由",
            "person": "人",
            "people": "人",
            "Sometimes conversations happen on old items that aren’t yet closed. Here is a list of all the Issues and Pull Requests with unresolved conversations.": "有時會針對尚未關閉的舊專案進行討論。以下是所有未解決的討論的議題和拉取請求的列表。",
            // [/• (\d+) new comments/, "• $1 個新評論"],
            "Unresolved conversation": "個未解決的討論",
            "Unresolved conversations": "個未解決的討論",

            "merged": "已合併",
            "opened": "打開",
            "closed": "已關閉",

            // 新版（2025/9）
            "There hasn't been any commit activity on": "沒有任何提交活動於",
            "over the last": "在最近",

            "Summary": "總結",
                "author": "位作者",
                "authors": "位作者",
                "have": " ",
                "has": " ",
                "pushed": "推送",
                "to all branches.": "到所有分支。",

                "On": "在",
                "file": "文件",
                "changed and there have been": "已經發生了變化，並且有",

            "Top Committers": "提交排行",
                "Chart options": "圖表選項",
                    "View as table": "以表格形式查看",
                        "Category": "作者", // 此處原文錯誤
                    "Download CSV": "下載 CSV",
                    "Download PNG": "下載 PNG",

                "Customization settings": "自定義設置",
                    "Column & bar chart settings": "柱狀圖設置",
                        "Increase Contrast": "增加對比度",
                            "Adds gradients and outlines to increase contrast in charts.": "為圖表添加漸變效果和輪廓，以增強對比度",
                        "Show data labels": "顯示數據標籤",
                            "Show labels for each data point in column and bar charts.": "在柱狀圖中顯示每個數據點的標籤",

            "Sometimes conversations happen on old items that aren't yet closed. Here is a list of all the Issues and Pull Requests with unresolved conversations.": "有時對尚未關閉的舊專案會有新的討論。以下是所有有未解決討論的議題和拉取請求列表。",
                "commented on": "評論於",
                "new comments": "新評論",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) authors?/, "$1 位作者"],
        [/to ([^ ]+) and/, "到 $1 分支和"],
        [/to all branches. On ([^ ]+),/, "到全部分支。在 $1 分支，"],
        [/(\d+) files?/, "$1 個文件"],
        [/(\d+) commented on/, "$1 評論於",],
        [/• (\d+) new comments?/, "• $1 個新評論"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last 24 hours./, "在過去的 24 小時裡，$1 沒有任何提交活動。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last 3 days./, "在過去的 3 天裡，$1 沒有任何提交活動。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last week./, "在過去的 1 周裡，$1 沒有任何提交活動。"],
        [/There hasn’t been any commit activity on ([^ ]+) in the last month./, "在過去的 1 月裡，$1 沒有任何提交活動。"],
        [/releases? published/, "發行版已發佈"],
        [/pull requests? opened/, "拉取請求打開"],
        [/pull requests? merged/, "拉取請求合併"],
        [/issues? opened/, "議題打開"],
        [/issues? closed/, "議題關閉"],
        [/(\d+) commits? authored by ([^ ]+)/, "$2 提交 $1 次"],
    ],
    "title": {
        "regexp": [
            [/Pulse/, "洞察"],
        ],
    },
};

I18N["zh-TW"]["repository/graphs/contributors"] = { // 倉庫 -> 洞察 - 貢獻者
    "static": { // 靜態翻譯

        // 貢獻者 /<user-name>/<repo-name>/graphs/contributors
            "Loading contributions…": "載入貢獻者…",
            // [/Contributions to (.*), excluding merge commits/, "貢獻到 $1 分支，不包括合併提交"],
            "Contributions:": "貢獻者：",
                // 下拉菜單
                "Filter contributions": "篩選貢獻者",
                "Additions": "添加數量",
                "Deletions": "刪除數量",
                // [/Contributions to (.*), excluding merge commits and bot accounts/, "貢獻到 $1 分支，不包括合併提交和機器人賬戶"],
            "Crunching the latest data, just for you. Hang tight…": "正在為您準備最新數據，請稍後…",

        // 新版
            // 標題
                "Contributions per week to": "每週貢獻到",
                ", excluding merge commits": " 分支，不包括合併提交",
                ", line counts have been omitted because commit count exceeds 10,000.": " 分支，由於提交次數超過 10,000 次，因此省略行數。",
            // 篩選欄
                "Period": "時間",
                    "All": "全部",
                    "Last month": "上月",
            // 日期
                "Weekly from": " 每週從",
                "From": "從",
            // 提交圖表
                "over time": "總覽",
                "commit": "次提交",
                    "s": " ",
                "Contributions": "貢獻", // 圖表旁豎寫
                "Chart options": "圖表選項",
                    "View as table": "以表格形式查看",
                    "Download CSV": "下載 CSV",
                    "Download PNG": "下載 PNG",
                    // 表格窗口
                        "Commits over time": "提交總覽",
                        "DateTime": "日期時間",
                        "Week of": "周",

        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],
    },
    "regexp": [ // 正則翻譯
        [/Contributions to (.*), excluding merge commits/, "貢獻到 $1 分支，不包括合併提交"],
        [/Contributions to (.*), excluding merge commits and bot accounts/, "貢獻到 $1 分支，不包括合併提交和機器人賬戶"],
        [/Contributions to (.*), line counts have been omitted because commit count exceeds 10,000./, "貢獻到 $1 分支，由於提交次數超過 10,000 次，因此省略行數。"],
        //[/Contributions per week to (.*), excluding merge commits/, "每週貢獻到 $1 分支，不包括合併提交"],
        [/([\d,]+) commits?/, "$1 次提交"],
        // 新版
        [/Last (\d+) months?/, "最後 $1 個月"],
        [/([^ ]+)'s (Commits|Additions|Deletions)/, function(all, user, cont){

            var contKey = {Commits: '提交', Additions: '添加數量', Deletions: '刪除數量'};

            return user + ' 的' + contKey[cont];
        }],
        [/Week (?:of|from) (?:Monday,)?(.+)/, (match, p1) => { // p1為(.+)
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}當週`; // 無論如何都是星期一
        }],
        [/([^ ]+)-([^ ]+) (\d+)/, (match, p1, p2 ,p3) => { // 出現位置：具體某貢獻者 - 貢獻數柱形圖日期，原文格式為 月-月 年
            const translatedP1 = I18N["zh-TW"]["public"]["static"][p1] || p1;
            const translatedP2 = I18N["zh-TW"]["public"]["static"][p2] || p2;
            return `${p3}年 ${translatedP1}-${translatedP2}`; // 此處修改格式為 年 月-月
        }],
        [/(\d+) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)/, function(all, d, m){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        [/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) '(\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Contributors to (.+)/, "$1 的貢獻者"],
        ],
    },
};

I18N["zh-TW"]["repository/graphs/community"] = { // 倉庫 -> 洞察 - 社區
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 社區 /<user-name>/<repo-name>/graphs/community
            "Enable Discussions to unlock Community Insights!": "啟用討論，以解鎖社區見解！",
            "Discussions is the central space for your community to share announcements, ask questions, and host conversations.": "討論是您的社區共享公告、提出問題和主持對話的中心空間。",
            "Set up discussions": "建立討論",

            "Community insights": "社區見解",
            "Period:": "週期：",
                "Filter activity": "篩選活動",
                "Last 30 days": "最近 30 天",
                "Last 3 months": "最近 3 個月",
                "Last year": "最近 1 年",

            "Contribution activity": "貢獻活動",
                "Count of total contribution activity to Discussions, Issues, and PRs": "對討論、議題和拉取請求的總貢獻活動計數",
                "discussions": "討論",
                "Quantity": "數量",
                "Timeline": "時間軸",
                // [/(\d+) pull requests created/, "$1 個拉取請求創建"],
            "We tried our best, but the graph wouldn’t load. Try reloading the page.": "我們盡了最大努力，但圖表無法加載。嘗試重新加載頁面。",
            "Discussions page views": "討論頁面瀏覽量",
                "Total page views to Discussions segmented by logged in vs anonymous users.": "按登錄用戶與匿名用戶劃分的討論的總頁面瀏覽量。",
                "logged in": "登錄",
                "anonymous": "匿名",

                "Not enough data yet.": "還沒有足夠的數據。",
                "It usually takes about a week to populate this chart.": "填充此圖表通常需要大約一週的時間。",
                "Read more about insights": "閱讀更多關於見解的信息",

            "Discussions daily contributors": "每日討論的貢獻者",
                "Count of unique users who have reacted, upvoted, marked an answer, commented, or posted in the selected period.": "在所選時間段內，作出反應、投票、標記答案、評論或發帖的唯一用戶的數量。",
            "Discussions new contributors": "討論的新貢獻者",
                "Count of unique new users to Discussions who have reacted, upvoted, marked an answer, commented, or posted in the selected period.": "在所選時間段內，對討論作出反應、投票、標記答案、評論或發帖的唯一新用戶的數量。",

            "Crunching the latest data, just for you. Hang tight…": "正在為您準備最新數據，請稍後…",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) pull requests? created/, "$1 個拉取請求創建"],
        [/(\d+) issues? created/, "$1 個議題創建"],
        [/(\d+) discussions? created/, "$1 個討論創建"],
        [/(\d+) contributors?/, "$1 貢獻者"],
    ],
};

I18N["zh-TW"]["repository/community"] = { // 倉庫 -> 洞察 - 社區準則
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 社區準則 /<user-name>/<repo-name>/community
            "Here’s how this project compares to": "以下是該專案內容，不同於",
            "recommended community standards": "推薦的社區標準",
            "Checklist": "檢查清單",
            "Add": "添加",
            "Propose": "提議",

            "Description": "描述",
                "Add a description to your repository so people understand the goals of your project.": "向您的倉庫添加描述，以便人們瞭解您專案的目標。",
            "README": "自述文件（README）",
                "Writing a README": "編寫自述文件（README）",
            "Code of conduct": "行為準則",
                "What is a code of conduct?": "什麼是行為準則？",
            "Contributing": "貢獻",
                "Writing contributing guidelines": "編寫貢獻指南",
            "License": "許可證",
                "Choosing a license": "選擇許可證",
            "Security policy": "安全政策",
                "Set up a security policy": "設置安全策略",
            "Issue templates": "議題模板",
            "Pull request template": "拉取請求模板",
            "Repository admins accept content reports": "倉庫管理員接受內容報告", // 組織倉庫?
            "What is": "什麼是",
            "the community profile": "社區簡介",

        // 添加許可證 /<user-name>/<repo-name>/community/license/new?branch=main
            "Add a license to your project": "為您的專案添加許可證",
            "Choose a license to add to your project": "選擇要添加到專案的許可證",
            "Select a template on the left to get started.": "在左側選擇一個模板開始。",
            "Learn more about": "瞭解更多關於",
            "which license best fits your project": "哪種許可證最適合您的專案",

        // 添加許可證 /<user-name>/<repo-name>/community/license/new?branch=<branch name>&template=<template name>
            // 右側欄
                "You’ll have a chance to review before committing a": "您將有機會在提交之前進行審查",
                "file to a new branch or the root of your project.": "文件到新分支或專案的根目錄。",

                "To adopt": "採用",
                ", enter your details. You’ll have a chance to review before committing a": "，輸入您的詳細信息。您將有機會在提交之前進行審查",
                "Year": "年份",
                    "The current year": "當前年份",
                "Full name": "全名",
                    "The full name or username of the repository owner": "倉庫所有者的全名或用戶名",
                "Review and submit": "審查並提交",

            // 中間欄 頂部 權限信息
                "Permissions": "許可事項",
                "Limitations": "限制條件",
                    "Commercial use": "商業用途",
                    "Modification": "修改",
                    "Distribution": "分佈",
                    "Patent use": "專利使用",
                    "Private use": "私人使用",
                    "Trademark use": "商標使用",
                    "Liability": "責任",
                    "Warranty": "擔保",
                    "Disclose source": "開源",
                    "Same license": "相同的許可證",
                "Conditions": "條件",
                    "License and copyright notice": "許可和版權聲明",
                    "State changes": "狀態變化",
                    "License and copyright notice for source": "來源許可和版權聲明",
                    "Network use is distribution": "網絡使用即分發",
                    "Same license (library)": "相同的許可證（庫）",
                    "Same license (file)": "相同的許可證（文件）",

                "This is not legal advice.": "這並不是法律建議。",
                "Learn more about repository licenses": "瞭解更多關於倉庫許可證的信息",

        // 添加行為準則 /<user-name>/<repo-name>/community/code-of-conduct/new
            "Add a code of conduct to your project": "為您的專案添加行為準則",
            "Choose a code of conduct to add to your project": "選擇要添加到專案中的行為準則",
            "what a code of conduct is": "什麼是行為準則",
            "and how to enforce it.": "以及如何執行。",
            "Contributor Covenant": "貢獻者協議",
                "Recommended for projects of all sizes": "建議用於各種規模的專案",
                "Contact method": "聯繫方式",
            "Citizen Code Of Conduct": "公民行為準則",
                "Suitable for large communities and events": "適合大型社區和活動",
                "Link to reporting guidelines": "報告指南鏈接",
                "Link to policy": "政策鏈接",
                "Note": "註釋",
                "Contact info": "聯繫信息",
                "Community name": "團隊名稱",
                "Governing body": "管理機構",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Community Standards": "社區準則",
        },
    },
};

I18N["zh-TW"]["repository/graphs/traffic"] = { // 倉庫 -> 洞察 - 流量
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 流量 /<user-name>/<repo-name>/graphs/traffic
            "Git clones": "Git 克隆",
            "Clones": "克隆",
            "Unique cloners": "唯一克隆者",
            "clones": "次克隆",
            "clone": "次克隆",
            "unique cloners": "個唯一克隆者",
            "unique cloner": "個唯一克隆者",
            "Visitors": "訪客",

            "Referring sites": "引薦網站",
            "Site": "站點",
            "Domains": "域名",
            "Views": "瀏覽",
            "Unique visitors": "唯一訪客",
            "Unique Visits": "唯一訪問",
            "views": "次瀏覽",
            "view": "次瀏覽",
            "Visits": "訪問",
            "unique visitors": "個唯一訪客",
            "unique visitor": "個唯一訪客",
            "Popular content": "熱門內容",
            "Content": "內容",
            "Path": "路徑",

            "We don’t have enough data to show anything useful.": "我們沒有足夠的數據來顯示任何有用的東西。",
            "It usually takes about a week to populate this graph.": "通常需要一週左右的時間來填充此圖表。",
            "It looks like traffic to your repository is a little light. Go spread the word and check back later!": "看起來您的倉庫的流量有點少呀。去宣傳一下吧，稍後再回來查看！",

            "Crunching the latest data, just for you. Hang tight…": "正在為您準備最新數據，請稍後…",

        // 新版
            "Referring sites and popular content are temporarily unavailable or may not display accurately. We're actively working to resolve the issue.": "引用網站和熱門內容暫時無法使用或可能無法準確顯示。我們正在積極解決該問題。",

            "Clones in last 14 days": "最近 14 天克隆數",
            "Unique cloners in last 14 days": "最近 14 天唯一克隆者",
                "Cloners": "克隆者",
            "Total views in last 14 days": "最近 14 天訪問數",
                "Total views": "總訪問數",
            "Unique visitors in last 14 days": "最近 14 天唯一訪客",

            "Chart options": "圖表選項",
                "View as table": "以表格形式查看",
                "Download CSV": "下載 CSV",
                "Download PNG": "下載 PNG",

            "Customization settings": "自定義設置",
                "Line chart settings": "折線圖設置",
                    "Differentiate by line style": "折線樣式區分",
                        "Use unique line styles (dashed, dotted, etc.) to differentiate lines in charts.": "使用獨特的線條樣式（如虛線、點線等）在圖表中區分不同的線條。",
                    "Show data labels": "顯示數據標籤",
                        "Show labels for each data point in line chart.": "在折線圖每個數據點顯示標籤。",

            // 表格
            "Category": "日期", // 實際上為日期
            "Total": "總計",
            "Unique": "唯一",

            "We don't have enough data to show anything useful.": "我們沒有足夠的數據來顯示任何有用的東西。",
            "It usually takes about a week to populate this table.": "通常需要一週左右的時間來填充此圖表。",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) Clones?/, "$1 次克隆"],
        [/(\d+) Unique cloners?/, "$1 位唯一克隆者"],
        [/(\d+) Views?/, "$1 次訪問"],
        [/(\d+) Unique visitors?/, "$1 位唯一訪客"],
    ],
};

I18N["zh-TW"]["repository/graphs/commit-activity"] = { // 倉庫 -> 洞察 - 提交
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 提交 /<user-name>/<repo-name>/graphs/commit-activity
            "Sunday"    : "週日",
            "Monday"    : "週一",
            "Tuesday"   : "週二",
            "Wednesday" : "週三",
            "Thursday"  : "週四",
            "Friday"    : "週五",
            "Saturday"  : "週六",

            "Crunching the latest data, just for you. Hang tight…": "正在為您準備最新數據，請稍後…",

        // 新版
            "Commits over the last year of": "最近一年內提交到",

            "Number of commits per week": "每週提交數",
            "Customization settings": "自定義設置",
                "Column & bar chart settings": "柱狀圖設置",
                    "Increase Contrast": "增加對比度",
                    "Adds gradients and outlines to increase contrast in charts.": "為圖表添加漸變效果和輪廓，以增強對比度",
                    "Show data labels": "顯示數據標籤",
                    "Show labels for each data point in column and bar charts.": "在柱狀圖中顯示每個數據點的標籤",

            "Chart options": "圖表選項",
                "View as table": "以表格形式查看",
                "Download CSV": "下載 CSV",
                "Download PNG": "下載 PNG",

                "DateTime": "日期",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/commits? the week of (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) (\d+)/, function(all, month, day){
            var monthKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月"
            };

            return '次提交本週，' + monthKey[month] + day + '日';
        }],
        [/Week of (.+)/, (match, p1) => { // p1為(.+)
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}當週` ; // 這裡寫翻譯結果
        }],
    ],
    "title": {
        "regexp": [
            [/Commits/, "提交"],
        ],
    },
};

I18N["zh-TW"]["repository/graphs/code-frequency"] = { // 倉庫 -> 洞察 - 程式碼頻率
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 程式碼頻率 /<user-name>/<repo-name>/graphs/code-frequency
            "Code frequency over the history of": "歷史上的程式碼頻率",
            "Additions": "添加數量",
            "Deletions": "刪除數量",
            "per week": "每週",
            "Crunching the latest data, just for you. Hang tight…": "正在為您準備最新數據，請稍後…",

            // 過多
            "There are too many commits to generate this graph.": "提交次數過多，無法生成圖表。",
            "More information about this data can be found in the": "有關這些數據的更多信息，請參閱",
            "activity documentation": "活動文檔",

        // 新版
        "Additions and deletions per week": "添加數量和刪除數量/每週",
        "Chart options": "圖表選項",
            "View as table": "以表格形式查看",
            "Download CSV": "下載 CSV",
            "Download PNG": "下載 PNG",
            // 圖表本體
                "DateTime": "日期時間",
                "Frequency": "頻率",
                "Values": "值",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Week (?:of|from) (?:Monday,)?(.+)/, (match, p1) => { // p1為(.+)
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `${translatedDate}當週`; // 無論如何都是星期一
        }],
        [/(\d+) (Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)/, function(all, d, m){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
        [/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec) '(\d+)/, function(all, m, d){
            var mKey = {
                "Jan": "1月",
                "Feb": "2月",
                "Mar": "3月",
                "Apr": "4月",
                "May": "5月",
                "Jun": "6月",
                "Jul": "7月",
                "Aug": "8月",
                "Sep": "9月",
                "Oct": "10月",
                "Nov": "11月",
                "Dec": "12月",
            };

            return mKey[m] + d + "日";
        }],
    ],
    "title": {
        "regexp": [
            [/Code frequency/, "程式碼頻率"],
        ],
    },
};

I18N["zh-TW"]["repository/network/dependencies"] = { // 倉庫 -> 洞察 - 依賴項關係圖 - 依賴項
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        "Dependencies": "依賴項",
        "Dependents": "依賴者",
        // 依賴項關係圖 - 依賴項 /network/dependencies
            "Tell us how to make the Dependency Graph work better for you with a few quick questions.": "請通過幾個簡單的問題告訴我們，如何使 “依賴項關係圖” 更好地為您工作。",

            "Dependency graph is disabled": "依賴項關係圖未啟用",
            "The owner of this repository has not yet enabled the dependency graph. Once enabled, you can": "此倉庫的所有者尚未啟用依賴項關係圖。一旦啟用，您可以", //個人倉庫
            "Dependency graph has not been enabled by an organization owner or a user with admin permissions for this repository. Once enabled, you can": "依賴項關係圖還沒有被組織所有者或具有該倉庫管理權限的用戶啟用。一旦啟用，您可以", // 組織倉庫
            "track this repository’s dependencies": "追蹤此倉庫的依賴項",
            "Learn more about how we use your data.":"深入瞭解我們對您數據的使用方式。",

            "Enable the dependency graph": "啟用依賴項關係圖",
            "Track this repository’s": "追蹤該倉庫的",
            "dependencies and sub-dependencies": "依賴項和子依賴項",
            "The": " ",
            "is not enabled for this repository. Click on \"Enable the dependency graph\" below to enable it.": "暫未啟用。單擊下面的 “啟用依賴項關係圖” 以啟用它。",
            "If you’d like to enable the": "如果您想啟用",
            "dependency graph": "依賴項關係圖",
            "vulnerability alerting": "漏洞警報",
            "click on \"Allow access\" below to enable it.": "點擊下面的 “允許訪問” 來啟用它。",
            "Learn more about how we use your data": "瞭解更多關於我們如何使用您的數據的信息",
            "Allow access": "允許訪問",

            "No dependencies found.": "未找到依賴項",
            "To view your dependency graph, your repository must define dependencies in": "要查看依賴項關係圖，您的倉庫必須定義依賴項存在",
            "one of the supported manifest file types": "一個支持的清單文件",
            ", like": "，例如",
            ", and": "，和",

            "Export SBOM": "導出 SBOM",

            "Detect additional dependencies with GitHub Actions": "使用 GitHub Actions 檢測額外的依賴項",
                // 並非所有依賴項都會自動檢測到，例如 Gradle 這樣的生態系統。GitHub Actions 會通過依賴項提交 API 添加您的依賴項，這樣您就可以收到有關已知漏洞的 Dependabot 警報。
                "Not all dependencies are automatically detected for ecosystems like Gradle. GitHub Actions adds your dependencies using the": "並非所有依賴項都會自動檢測到，例如 Gradle 這樣的生態系統。GitHub Actions 會通過",
                "dependency submission API": "依賴項提交 API",
                "so you can receive Dependabot alerts for known vulnerabilities.": "添加您的依賴項，這樣您就可以收到有關已知漏洞的 Dependabot 警報。",
            "View in Marketplace": "去市場查看",

            // "Dependencies": "依賴項",
            "Search all dependencies": "搜索所有依賴項",
                "Suggested filters": "建議篩選",

            "These dependencies are defined in": "這些依賴項被定義在",
            "’s manifest files, such as": "的清單文件，例如",
            "Dependencies defined in": "依賴項被定義在",

            // 發現已知漏洞
            "Dependencies defined in these manifest files have known security vulnerabilities and should be updated:": "這些清單文件中定義的依賴項具有已知的安全漏洞，應更新：",
            // [/(\d+) vulnerabilities? found/, "發現 $1 個漏洞"],
            "Known security vulnerability in": "已知的安全漏洞，在",
                "Known vulnerability found": "發現已知漏洞",
                "update suggested:": "更新建議：",
                "Always verify the validity and compatibility of suggestions with your codebase.": "始終驗證建議與程式碼庫的有效性和兼容性。",

            // [/(\d+) more dependencies/, "更多 $1 個依賴項"],
            // [/Load (\d+) more…/, "加載更多 $1個…"],
            "Ecosystem": "生態系統",
                "Filter by ecosystem": "按生態系統篩選",

            "ProTip!": "專業提示！",
            "What’s not been updated": "未更新內容",
                "Supported ecosystems will have transitivity labels on their packages.": "受支持的生態系統將在其包上有傳遞性標籤。",

            "View transitive paths": "查看傳遞路徑",
            "You can view transitive paths for packages within supported ecosystems.": "您可以在受支持的生態系統中查看包的傳遞路徑。",
            "OK, got it": "好的，明白了",
            "Show dependency options": "顯示依賴選項",
                "Show paths": "顯示路徑",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/View Dependabot alerts?/, "查看 Dependabot 警報"],
        //[/Detected automatically on (.+)/, "自動檢測於$1"],
        [/· Detected automatically on (.+)/, (match, p1) => {
            const dateRegExp = I18N["zh-TW"]["public"]["time-regexp"];
            const translatedDate = dateRegExp.reduce((acc, [pattern, replacement]) => acc.replace(pattern, replacement), p1);
            return `· 自動檢測於 ${translatedDate}`;
        }],
        [/(\d+) Total/, "$1 總計"],
        [/(\d+) vulnerabilities? found/, "發現 $1 個漏洞"],
        [/(\d+) more dependencies/, "更多 $1 個依賴項"],
        [/(\d+) moderate · (\d+) total/, "$1 中風險 · $2 總計"],
        [/(\d+) high · (\d+) total/, "$1 高風險 · $2 總計"],
        [/(\d+) high/, "$1 高風險"],
        [/(\d+) moderate/, "$1 中風險"],
        [/Load (\d+) more…/, "加載更多 $1個…"],
    ],
    "title": {
        "regexp": [
            [/Dependencies/, "依賴項"],
        ],
    },
};

I18N["zh-TW"]["repository/network/dependents"] = { // 倉庫 -> 洞察 - 依賴項關係圖 - 依賴者
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        "Dependencies": "依賴項",
        "Dependents": "依賴者",
        // 依賴項關係圖 - 依賴者 /network/dependents
            "GitHub does not currently determine the dependents of private repositories": "GitHub 目前無法確定私有倉庫的依賴者",

            "Export SBOM": "導出 SBOM",
            // "Dependents": "依賴者",
            "We haven’t found any dependents for this repository yet.": "我們尚未找到此倉庫的任何依賴者。",
            "We’ll keep looking!": "我們會繼續尋找！",

            "Repositories that depend on": "依賴的倉庫包括",
            "Package:": "軟體包：",

            "These counts are approximate and may not exactly match the dependents shown below.": "這些計數是近似值，可能與下方顯示的依賴項不完全匹配。",

            // [/(\d+) Repositor(y|ies)/, "$1 倉庫"],
            // [/(\d+) Packages?/, "$1 軟體包"],

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) Repositor(y|ies)/, "$1 倉庫"],
        [/(\d+) Packages?/, "$1 軟體包"],
    ],
    "title": {
        "regexp": [
            [/Network Dependents/, "網絡依賴者"],
        ],
    },
};

I18N["zh-TW"]["repository/network/updates"] = { // 倉庫 -> 洞察 - 依賴項關係圖 - Dependabot
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        "Dependencies": "依賴項",
        "Dependents": "依賴者",

        "Export SBOM": "導出 SBOM",
        // 依賴項關係圖 - Dependabot /network/updates
            "Enable Dependabot": "啟用 Dependabot",
            "Dependabot isn't enabled": "未啟用 Dependabot",
            "Dependabot isn't enabled on forks by default": "默認情況下，Dependabot 不會在複刻上啟用。",

            "Dependabot version updates aren't configured yet": "尚未配置 Dependabot 版本更新",
            "Dependabot creates pull requests to keep your dependencies up-to-date.": "Dependabot 創建拉取請求以保持您的依賴項是最新的。",
            "Create config file": "創建配置文件",

            "Recent update jobs": "最近更新的工作",

            "Dependabot version updates": "Dependabot 版本更新",
            "automatically keep your application up-to-date by periodically updating dependencies to their latest versions.": "通過定期將依賴項更新到最新版本，自動保持應用的最新狀態。",
            "Dependabot security updates": "Dependabot 版本更新",
            "can also help keep dependencies updated.": "還可以幫助保持依賴項更新。",

            "Monitored dependency files": "受監控的依賴文件",
            "Check for updates": "檢查更新",
            "Recent jobs": "近期工作",
            "view logs": "查看日誌",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
};

I18N["zh-TW"]["repository/network"] = { // 倉庫 -> 洞察 - 網絡圖
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 網絡圖 /<user-name>/<repo-name>/network
            // 鍵盤快捷鍵
                "Scroll left": "向左滑動",
                "Scroll right": "向右滑動",
                "Scroll up": "向上滑動",
                "Scroll down": "向下滑動",
                "Toggle visibility of the head labels": "切換頭部標籤的可見性",
                "Scroll all the way left": "一直向左滑動",
                "Scroll all the way right": "一直向右滑動",
                "Scroll all the way up": "一直向上滑動",
                "Scroll all the way down": "一直向下滑動",

            "Network graph": "網絡圖",
            "Timeline of the most recent commits to this repository and its network ordered by most recently pushed to.": "最近提交到此倉庫的時間軸及其網絡圖按最近推送的順序排序。",

            "The repository network shows the 100 most recently pushed forks.": "倉庫網絡圖顯示最近推送的 100 個複刻。",

            "Loading graph data": "加載網絡圖數據",
            "Keyboard shortcuts available": "可用的鍵盤快捷鍵",

            "Sorry, your browser doesn’t support the <canvas> element.": "抱歉，您的瀏覽器不支持 <canvas> 元素。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Network Graph/, "網絡圖"],
        ],
    },
};

I18N["zh-TW"]["repository/network/members"] = { // 倉庫 -> 洞察 - 複刻
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 複刻 - 樹形視圖 /<user-name>/<repo-name>/network/members
            "switch to list view": "切換到列表視圖",

            "No one has forked this repository yet.": "目前，暫無人複刻該倉庫。",
            "Forks are a great way to contribute to a repository. After": "複刻是給該倉庫做貢獻的好方法。首先",
            "forking a repository": "複刻倉庫",
            ", you can send the original author a": "，然後您可向原作者發送",
            "pull request": "拉取請求",

            "Woah, this network is huge! We’re showing only some of this network’s repositories.": "哇，這個網絡太龐大了! 我們只展示了這個網絡中的一部分倉庫。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
};

I18N["zh-TW"]["repository/forks"] = { // 倉庫 -> 洞察 - 複刻
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-insights-menu"]["static"],

        // 複刻 - 列表視圖 /<user-name>/<repo-name>/forks
            "Switch to tree view": "切換到樹形視圖",

            "No one has forked this repository yet": "目前，暫無人複刻該倉庫",
            "Forks are a great way to contribute to a repository. After": "複刻是給該倉庫做貢獻的好方法。首先",
            "forking a repository": "複刻倉庫",
            ", you can send the original author a": "，然後您可向原作者發送",
            "pull request": "拉取請求",

            "No forked repositories found": "尚無複刻倉庫",
            "Try changing your filters, or search for": "嘗試更改篩選器，或搜索",
            "active forked repositories": "活躍的複刻倉庫",

            "Period:": "週期:",
                "Filter by period": "篩選週期",
                "1 month": "1 個月",
                "6 months": "6 個月",
                "1 year": "1 年",
                "2 years": "2 年",
                "5 years": "5 年",
                "All time": "所有時間",

                "Any repository that has not been created or updated during this period will be excluded.": "在此期間未被創建或更新的任何倉庫將被排除在外。",
            "Repository type:": "倉庫類型:",
                "Filter by repository type": "篩選倉庫類型",
                "None": "無",
                "Active": "活躍",
                    "Repositories with push activity": "有推送活動的倉庫",
                "Inactive": "不活躍",
                    "Repositories with no push activity": "無推送活動的倉庫",
                "Network": "網絡",
                    "Forks of other forks": "其他複刻的複刻",
                "Archived": "存檔",
                    "Archived repositories": "已存檔的倉庫",
                "Starred": "星標",
                    "Repositories with at least 1 star": "至少有 1 個星標的倉庫",
            "Sort:": "排序:",
                "Sort by": "排序方式",
                    "Most starred": "最多星標",
                    "Recently updated": "最近更新",
                    "Open issues": "打開的議題",
                    "Open pull requests": "打開的拉取請求",
                "Defaults Saved": "默認值已保存",
                "Save Defaults": "保存默認值",

            "Never updated": "從未更新",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Created/, "創建於"],
        [/Updated/, "更新於"],
        [/(Active|Inactive|Network|Archived|Starred) (\+\d+)/, function(all, type, num){
            var typeKey = {"Active": "活躍","Inactive": "不活躍","Network": "網絡","Archived": "存檔","Starred": "星標"};
            return typeKey[type] + ' ' + num;
        }],
    ],
    "title": {
        "regexp": [
            [/Forks/, "複刻"],
        ],
    },
};

// 洞察 <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<

I18N["zh-TW"]["repository-settings-menu"] = { // 倉庫設置公共部分
    "static": { // 靜態翻譯
        // >>>>>>>>>>>>>>>>>>   倉庫設置 公共部分  <<<<<<<<<<<<<<<<<<<
            // 頂部提醒欄
            "Most repository settings are hidden for archived repositories. This repository must be unarchived to change them.": "對於存檔的倉庫，大多數倉庫設置都是隱藏的。 必須解除倉庫存檔才能更改它們。",
            "This repository has been archived by the owner. It is now read-only.": "此倉庫已由所有者存檔。它現在是只讀的。",
            "Repository settings saved.": "倉庫設置已保存。",


            // 左側菜單
            "General": "通常",

            "Access": "訪問",
                // "Collaborators": "協作者",
                "Collaborators and teams": "協作者和團隊", // 組織倉庫
                "Team and member roles": "團隊和成員職責",  // 組織倉庫
                "Moderation options": "節制選項",
                    "Interaction limits": "互動限制",
                    "Code review limits": "程式碼審查限制",

            "Code and automation": "程式碼與自動化",
                "Branches": "分支",
                "Tags": "標籤",
                "Rules": "規則",
                    "Rulesets": "規則集",
                // "Actions": "操作",
                    // "General": "通常",
                    "Runners": "運行器",
                "Models": "模型",
                "Webhooks": "Web 鉤子",
                // Copilot
                    "Code review": "程式碼審查",
                    "Coding agent": "編程智能體",
                "Environments": "環境",
                "Pages": "GitHub Pages",
                "Custom properties": "自定義屬性",  // 組織倉庫

            // "Security": "安全",
                "Advanced Security": "高級安全",
                "Deploy keys": "部署密鑰",
                "Secrets and variables": "機密和變量",

            "Integrations": "集成",
                "GitHub Apps": "GitHub 應用",
                "Email notifications": "郵件通知",
                "Autolink references": "自動鏈接引用",

    },
    "regexp": [ // 正則翻譯
    ],
};

I18N["zh-TW"]["repository/settings"] = { // 倉庫設置 - 通常 /<user-name>/<repo-name>/settings
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 通常 - 設置頁面 /<user-name>/<repo-name>/settings ====================================
            "Repository name": "倉庫名稱",
            "Rename": "重命名",
                // [/is available./, "名稱可用。"],
                "The repository": "倉庫",
                "already exists on this account.": "已經存在於此賬戶。",
                "Your new repository will be created as": "您的新倉庫將被創建為",
                // 頂部提醒
                "Repository name was not changed": "倉庫名稱未更改",

            "Template repository": "模板庫",
                "Template repositories let users generate new repositories with the same directory structure and files.": "模板倉庫允許用戶生成具有相同目錄結構和文件的新倉庫。",
                "A repository with LFS content cannot be used as a template.": "帶有 LFS 內容的倉庫不能作為模板使用。",
                "Learn more about template repositories": "瞭解更多關於模板庫的信息",

                "Require contributors to sign off on web-based commits": "要求貢獻者在基於 Web 的提交上籤署",
                "Enabling this setting will require contributors to sign off on commits made through GitHub’s web interface. Signing off is a way for contributors to affirm that their commit complies with the repository's terms, commonly the": "啟用此設置將要求貢獻者簽署通過 GitHub 的 Web 界面所做的提交。簽署是貢獻者確認他們的提交符合倉庫條款的一種方式，通常是",
                "Developer Certificate of Origin (DCO)": "開發者來源證書（DCO）",
                "Learn more about signing off on commits": "瞭解更多關於簽署提交的信息",

            "This setting is enabled on the upstream repository. Disabling this setting may block commits from being merged upstream.": "此設置在上游倉庫中啟用。禁用此設置可能會阻止提交向上遊合併。",

            "Default branch": "默認分支",
            "The default branch is considered the “base” branch in your repository, against which all pull requests and code commits are automatically made, unless you specify a different branch.": "默認分支被認為是倉庫中的 “基礎” 分支，所有的拉取請求和程式碼提交都是針對該分支進行的，除非您指定一個不同的分支。",
            "Rename branch": "重命名分支",
                // 重命名分支對話框
                "Rename this branch": "重命名分支",
                "Rename": "重命名",
                "to:": "為：",
                // [/is already the branch name./, "已經是分支的名稱了。"],
                // [/Your branch name will be/, "您的分支的名稱將重命名為"],
                "Most projects name the default branch": "大多數專案將默認分支名為",
                "Renaming this branch:": "重命名此分支：",
                    // 該分支存在來自其他分支的拉取請求時
                        "Will update": "將更新",
                        "pull request targeting this branch.": "條針對該分支的拉取請求。",
                        "pull requests targeting this branch.": "條針對該分支的拉取請求。",
                        "branch protection rule that explicitly targets": "條分支保護規則明確針對",

                    // 該分支存在用於其他分支的拉取請求時
                        "Will close": "將關閉",
                        "open pull request for this branch.": "個該分支的拉取請求。",

                    // 重命名 GitHub Pages 所在分支
                        "Will unpublish current GitHub Pages site.": "將取消當前發佈的 GitHub Pages 站點。",
                            "Your current GitHub Pages site will become unpublished. A new commit on the renamed branch will publish the GitHub Pages site again.": "您當前的 GitHub Pages 站點將被取消發佈。重命名分支上的新提交將再次發佈 GitHub Pages 站點。",

                    "Will not update your members' local environments.": "不會更新您成員的本地環境。",
                "Renaming this branch will not update your members' local environments.": "重命名此分支不會更新您成員的本地環境。",
                    "Your members will have to manually update their local environments. We'll let them know when they visit the repository, or you can share the following commands.": "您的成員將不得不手動更新他們的本地環境。我們會在他們訪問倉庫時通知他們，或者您可以共享以下命令。",
                "Saving…": "保存中…",

            "Switch to another branch": "切換到另一分支",
                // 分支切換對話框
                "Switch default branch to another branch": "將默認分支切換到另一分支",
                // [/Choose another branch to use as the default branch of ([^ ]+) instead of/,"選擇另一分支作為 $1 的默認分支而不是"], // 分支切換 對話框
                "Switch default branch": "切換默認分支",
                "Filter branches": "篩選分支",
                "default": "默認",
                // 更新默認分支對話框
                "Update default branch": "更新默認分支",
                "Changing your default branch": "更改您的默認分支",
                "can have unintended consequences that can affect new pull requests and clones.": "可能會產生意想不到的後果，影響新的拉取請求和克隆。",
                "I understand, update the default branch.": "我明白了，依然更新默認分支",
                // 頂部提醒
                    // [/Default branch changed to ([^ ])/, "默認分支更改為 $1"]

            // 發行版
                "Enable release immutability": "啟用發行版不可修改",
                    "Disallow assets and tags from being modified once a release is published.": "禁止在發佈發行版後修改資產和標籤。",

            "Social preview": "社交預覽",
            // 關於私有庫提醒
            "You can upload a social image, but it will not be visible publicly while": "您可以上傳社交圖片，但當",
            "is private.": "是私密時，它不會公開顯示。",
            "Upload an image to customize your repository’s social media preview.": "上傳圖像以自定義倉庫的社交媒體預覽。",
            "Images should be at least 640×320px (1280×640px for best display).": "圖片至少應為 640×320 像素（1280×640 像素以獲得最佳顯示效果）。",
            "Download template": "下載模板",
            "Edit": "編輯",
                "Upload an image…": "上傳圖片…",
                "Remove image": "刪除圖片",

            "Features": "功能",
            // "Wikis": "",
                "Wikis host documentation for your repository.": "Wikis 為您的倉庫託管文檔。",
                "Restrict editing to collaborators only": "僅限協作者進行編輯",
                "Restrict editing to users in teams with push access only": "僅限具有推送訪問權限的團隊中的成員進行編輯", //組織倉庫
                    "Public wikis will still be readable by everyone.": "公共 Wikis 仍然可供所有人閱讀。",

            // 私人庫 啟用 Wiki 提醒
                "Upgrade or make this repository public to enable Wikis": "升級或公開此倉庫，以啟用 Wiki",
                "GitHub Wikis is a simple way to let others contribute content. Any GitHub user can create and edit pages to use for documentation, examples, support, or anything you wish.": "GitHub Wikis 是一種讓他人貢獻內容的簡單方法。任何 GitHub 用戶都可以創建和編輯頁面，用於文檔、示例、支持或任何您想要的東西。",
                // "Upgrade": "升級",
                    "Learn more about wikis": "瞭解更多關於 Wiki 的信息",

            // 議題
            "Issues integrate lightweight task tracking into your repository. Keep projects on track with issue labels and milestones, and reference them in commit messages.": "議題將輕量級任務跟蹤集成到您的倉庫中。使用議題標籤和里程碑保持專案正常運行，並在提交消息中引用它們。",
            "Get organized with issue templates": "使用議題模板進行組織",
            "Give contributors issue templates that help you cut through the noise and help them push your project forward.": "為貢獻者提供議題模板，幫助您消除干擾並幫助他們推進您的專案。",
            "Set up templates": "設置模板",

            "Allow forking": "允許複刻", // 組織倉庫
            "If disabled, existing forks will be unaffected.": "如果禁用，現有複刻將不受影響。", // 組織倉庫

            // 贊助
            "Sponsorships": "贊助",
            "Sponsorships help your community know how to financially support this repository.": "贊助可幫助您的社區瞭解如何在資金上支持此倉庫。",
            "Display a \"Sponsor\" button": "顯示 “贊助” 按鈕",
            "Add links to GitHub Sponsors or third-party methods your repository accepts for financial contributions to your project.": "添加指向 GitHub 贊助者或您的倉庫接受的第三方收款鏈接，以便為您的專案提供資金捐助。",
            "Set up sponsor button": "設置贊助按鈕",
            "Edit funding links": "編輯贊助鏈接",

            // 專案
            "Projects on GitHub help you organize and prioritize your work. You can create projects for specific feature work, comprehensive roadmaps, or even release checklists.": "GitHub 上的專案可以幫助您組織工作並確定其優先次序。您可以為特定的功能工作、全面的路線圖、甚至是發佈清單創建專案",

            "Preserve this repository": "保留這個倉庫",
            "Include this code in the": "將此程式碼包含在",
            "GitHub Archive Program": "GitHub 存檔計劃中",

            "Table of contents": "目錄",
            "Autogenerate table of contents for markdown files in this repository. the table of contents will be displayed near the top of the file.": "自動生成此倉庫中 Markdown 文件的目錄。目錄將顯示在文件頂部附近。",

            // "Discussions": "討論",
            "Discussions is the space for your community to have conversations, ask questions and post answers without opening issues.": "討論是您的社區進行對話、提問和發佈答案的地方，而無需打開議題。",
            "Get started with Discussions": "開始討論",
            "Engage your community by having discussions right in your repository, where your community already lives": "通過在您的社區已經存在的倉庫中進行討論來吸引您的社區",
            "Set up discussions": "建立討論",

            // 專案
            "Projects on GitHub are created at the repository owner's level (organization or user) and can be linked to a repository's Projects tab. Projects are suitable for cross-repository development efforts such as feature work, complex product roadmaps or even Issue triage.": "GitHub 上的專案是在倉庫所有者級別（組織或用戶）創建的，並且可以鏈接到倉庫的專案選項卡。專案適用於跨倉庫的開發工作，例如功能工作、複雜的產品路線圖，甚至問題分流。",

            // "Pull Requests": "拉取請求",
                "When merging pull requests, you can allow any combination of merge commits, squashing, or rebasing. At least one option must be enabled. If you have linear history requirement enabled on any protected branch, you must enable squashing or rebasing.": "當合併拉取請求時，您可以允許合併提交、壓縮或變基的任意組合。必須至少啟用一個選項。如果您在任何受保護分支上啟用了線性歷史要求，則必須啟用壓縮或變基。",

                "You must select at least one option": "您必須至少選擇一個選項",
                "Allow merge commits": "允許合併提交",
                    "Add all commits from the head branch to the base branch with a merge commit.": "使用合併提交將所有從頭部分支的提交添加到基礎分支。",
                        "Default commit message": "默認提交信息",
                            "Presented when merging a pull request with merge.": "當合併拉取請求時時出現。",
                        "Default message": "默認信息",
                        "Pull request title": "拉取請求標題",
                        "Pull request title and commit details": "拉取請求標題和提交詳情",
                        "Pull request title and description": "拉取請求標題和描述",

                "Allow squash merging": "允許壓縮合併",
                    "Combine all commits from the head branch into a single commit in the base branch.": "將來自頭部分支的所有提交合併到基礎分支中的單個提交中。",
                        // "Default commit message": "默認提交信息",
                            "Presented when merging a pull request with squash.": "當使用壓縮合併拉取請求時顯示。",
                        "Default to pull request title and commit details": "默認為拉取請求標題和提交詳細信息",

                    "Default to PR title for squash merge commits": "默認將拉取請求的標題作為壓縮合併提交的信息",
                    "This will pre-populate the commit message with the PR title when performing a squash merge.": "在執行壓縮合併時，將在提交信息中添加拉取請求的標題。",

                "Allow rebase merging": "允許變基合併",
                    "Add all commits from the head branch onto the base branch individually.": "將來自頭部分支的所有提交單獨添加到基礎分支。",

                "Control how and when users are prompted to update their branches if there are new changes available in the base branch.": "如果基礎分支中有可用的新更改，則控制提示用戶更新其分支的方式和時間。",
                "Always suggest updating pull request branches": "始終建議更新拉取請求分支",
                    "Whenever there are new changes available in the base branch, present an “update branch” option in the pull request.": "每當基礎分支中有可用的新更改時，就在拉取請求中顯示 “更新分支” 選項。",

                "You can allow setting pull requests to merge automatically once all required reviews and status checks have passed.": "一旦所有必需的審查和狀態檢查都通過，您可以允許設置拉取請求自動合併。",

                "Allow auto-merge": "允許自動合併",
                    "Waits for merge requirements to be met and then merges automatically.": "等待滿足合併要求，然後自動合併。",
                    "Why is this option disabled?": "為什麼該選項被禁用？",

                "After pull requests are merged, you can have head branches deleted automatically.": "合併拉取請求後，您可以自動刪除頭部分支。",

                    "Automatically delete head branches": "自動刪除頭部分支",
                        "Deleted branches will still be able to be restored.": "刪除的分支仍然可以恢復。",

            "Archives": "檔案",
            "When creating source code archives, you can choose to include files stored using Git LFS in the archive.": "創建源程式碼存檔時，您可以選擇在存檔中包含使用 Git LFS 存儲的文件。",

            "Include Git LFS objects in archives": "在檔案中包含 Git LFS 對象",
            "Git LFS usage in archives is billed at the same rate as usage with the client.": "歸檔中的 Git LFS 使用率與客戶端的使用率相同。",

            "Pushes": "推送",
            "Limit how many branches and tags can be updated in a single push": "限制一次推送中可以更新多少個分支和標籤",
                "Pushes will be rejected if they attempt to update more than this.": "如果推送嘗試更新超過該值，則推送將被拒絕。",
                "Learn more about this setting": "瞭解更多關於此設置的信息",
                ", and send us your": "，並向我們發送您的",
                "feedback": "反饋",

                "Up to": "在一次推送中最多可以更新",
                "branches and tags can be updated in a push": "個分支和標籤",

                // 提醒
                "Must be a whole number between 2 and 1000": "必須是 2 到 1000 之間的整數",

            // 議題
                "After merging a pull request, linked issues can be closed automatically.": "合併拉取請求後，可以自動關閉關聯議題。",
                    "Auto-close issues with merged linked pull requests": "使用已合併的關聯拉取請求自動關閉議題",
                        "Whenever linked pull requests have merged, auto-close the issue.": "當關聯的拉取請求被合併時，自動關閉該議題。",

            "Danger Zone": "危險區",
            "Change repository visibility": "更改倉庫可見性",
            "You cannot change the visibility of a fork. please": "您無法更改複刻倉庫的可見性。請",
            "Duplicate the repository": "複製倉庫",
            "For security reasons, you cannot change the visibility of a fork.": "出於安全原因，您無法更改複刻倉庫的可見性。",

            // 更改倉庫可見性對話框
            "Change visibility": "更改可見性",
                "Change to private": "更改為私有",
                "Change to public": "更改為公開",
            "This repository is currently public.": "該倉庫當前是公開的。",
            "This repository is currently private.": "該倉庫當前是私有的。",
            "I want to make this repository public": "我想將此倉庫設為公開",
                "The code will be visible to everyone who can visit https://github.com": "所有可以訪問 https://github.com 的人都可以看到程式碼",
                "Attachments uploaded to this repository's issues and pull requests will not be accessible unless it is made private again.": "上傳到此倉庫的議題和拉取請求的附件將無法訪問，除非再次設為私有。",
                "Anyone can fork your repository.": "任何人都可以複刻您的倉庫。",
                "All push rulesets will be disabled.": "所有推送規則集都將被禁用。",
                "Your changes will be published as activity.": "您的更改將作為活動發佈。",
                "Actions history and logs will be visible to everyone.": "操作歷史和日誌將對所有人可見。",
                "Make this repository public": "我想將此倉庫設為公開",
            "I want to make this repository private": "我想將此倉庫設為私有",
                "Making this repository private could permanently erase these counts by removing stars and watchers associated to users that will no longer have access to this repository:": "該倉庫私有化，將會通過解除星標者和關注者，刪除這些計數。他們將無法訪問該倉庫：",
                    "star": "星標者",
                    "stars": "星標者",
                    "watcher": "關注者",
                    "watchers": "關注者",
                "If you decide to make this repository public in the future, it will not be possible to restore these stars and watchers and this will affect its repository rankings.": "即使您決定將來公開此倉庫，也無法恢復這些星標者和關注者，這將影響其倉庫排名。",
                "Dependency graph and Dependabot alerts will remain enabled with permission to perform read-only analysis on this repository.": "依賴項關係圖和 Dependabot 警報將保持啟用，並有權限對該倉庫進行只讀分析。",
                "Dependency graph and Dependabot alerts will remain enabled with permission to perform read-only analysis on this repository. Any custom Dependabot alert rules will be disabled unless GitHub Advanced Security is enabled for this repository.": "依賴項關係圖和 Dependabot 警報將繼續啟用，並允許對該倉庫執行只讀分析。除非為該倉庫啟用了 GitHub 高級安全功能，否則任何自定義的 Dependabot 警報規則都將被禁用。",
                "Code scanning will become unavailable.": "程式碼掃描將變得不可用。",
                "Current forks will remain public and will be detached from this repository.": "當前的複刻將保持公開，並將從該倉庫中分離出來。",
                "Make this repository private": "將此倉庫設為私有",
                "I have read and understand these effects": "我已閱讀並理解這些影響",

                "Warning: this is a destructive action": "警告：這是一個破壞性的行為",
                "To confirm, type the number of stars on this repository in the box below": "要確認，請在下面的框中輸入此倉庫的星標數",

            "Disable branch protection rules": "禁用分支保護規則",
                "Disable branch protection rules enforcement and APIs": "禁用分支保護規則執行和 API",

                // 頂部提醒
                    "Branch protection settings saved.": "分支保護設置已保存。",

            // 禁用分支保護對話框
                "This will hide the branch protection settings and disable branch protection rules for this repository.": "這將隱藏分支保護設置，並禁用該倉庫的分支保護規則。",
                "Disabling branch protection rules allows you to enforce branch and tag protections exclusively with Repository Rules.": "禁用分支保護規則後，允許您僅使用倉庫規則來執行分支和標籤保護。",

                "This action will disable:": "此操作將禁用：",
                    "Branch protection rule enforcement": "分支保護執行",
                    "Branch protection rule APIs": "分支保護 API",
                // [/(\d+) branch protection rules?/, "$1 項分支保護規則"],
                "will be disabled as part of this action": "作為此操作的一部分將被禁用",

            "Re-enable branch protection rules": "重新啟用分支保護規則",
                "Re-enable branch protection rules enforcement and APIs": "重新啟用分支保護規則執行和 API",

            // 重新啟用分支保護對話框
                "Re-enable branch protection": "重新啟用分支保護",
                "will be re-enabled as part of this action": "作為此操作的一部分將被重新啟用",

            "Transfer ownership": "轉讓所有權",
            "Transfer": "轉讓",
            "Transfer this repository to another user or to an organization where you have the ability to create repositories.": "將此倉庫轉讓給另一位用戶或您可以創建倉庫的組織。",
            "Organization members cannot transfer repositories": "組織成員沒有轉讓所有權的權限",

            "Leave fork network": "離開複刻網絡",
            "Can't leave the fork network because this fork has child forks.": "無法離開複刻網絡，因為此複刻有子複刻。",
            "Can't detach forks larger than 1 GB.": "無法解除大於 1 GB 的複刻關聯。",
            "Unlink this repository from the fork network and make it standalone.": "將該倉庫從複刻網絡中解除關聯，使其成為獨立倉庫。",
            "Detach is in progress.": "分離中。",
            // 頂部提醒
                "Detaching this repository.": "分離此倉庫…",

            "Archive this repository": "存檔倉庫",
            "Mark this repository as archived and read-only.": "將此倉庫標記為已存檔和只讀。",

            // 存檔倉庫對話框
            "Archive repository": "存檔倉庫",
            "This repository will become read-only.": "該倉庫將設置為只讀。",
            "You will still be able to fork the repository and unarchive it at any time.": "您仍然可以隨時訪問複刻倉庫並取消存檔。",
            "Unexpected bad things will happen if you don’t read this!": "如果您不閱讀此說明，將會發生意想不到的事情！",
            "All scheduled workflows will stop running.": "所有預定的工作流程將停止運行。",
            "Security features will be unavailable:": "安全功能將無法使用：",
            "Code scanning": "程式碼掃描",
            "Before you archive, please consider:": "在您存檔之前，請考慮：",
            "Updating any repository settings": "更新倉庫設置",
            "Closing all open issues and pull requests": "關閉所有打開的議題和拉取請求",
            "Making a note in your README": "在您的 README 中做個說明",
            "Please type": "請鍵入",
            "to confirm.": "進行確定。",
            "I understand the consequences, archive this repository": "我明白後果，依然存檔該倉庫",
            // "This repository has been archived by the owner. It is now read-only.": "此倉庫已由所有者存檔。它現在是只讀的。",

            // 頂部提醒
            // [/Your repository \"([^ ]+)\" was successfully archived./, "您的倉庫 “$1” 已成功存檔。"], //倉庫存檔

            "Unarchive this repository": "解除倉庫存檔",
            "Mark this repository as unarchived and read-write.": "將此倉庫標記為未存檔和可讀寫。",

            // 解除倉庫存檔對話框
            "Unarchive repository": "解除倉庫存檔",
            "This will make": "這將使",
            "read-write.": "可讀寫。",
            "Once unarchived, the following can be modified and commented on:": "一旦解除存檔，就可以對以下內容進行修改和評論：",
            "Pull Requests": "拉取請求",
            "Labels": "標籤",
            "Releases": "發行版",
            "Milestones": "里程碑",
            "Past due by": "已經過期於",
            "Security features will become available:": "安全功能將不可用：",
            "I understand the consequences, unarchive this repository": "我明白後果，依然解除該倉庫存檔",

            "Delete this repository": "刪除倉庫",
            "Once you delete a repository, there is no going back. Please be certain.": "您一旦刪除倉庫，將再也無法恢復。請確認。",
            "Organization members cannot delete repositories.": "組織成員沒有刪除倉庫的權限",

            // 離開複刻網絡對話框
                "This will permanently remove the fork relationship to the upstream repository": "這將永久移除與上游倉庫的複刻關係：",
                "will become a standalone repository and will no longer be able to fetch upstream updates or propose changes to the upstream repository": "將成為獨立倉庫，無法再獲取上游更新，也無法向原倉庫提交更改：",
                "cannot rejoin the fork network.": "不能重新加入複刻網絡。",

            // 頂部提醒
            // [/Your repository \"([^ ]+)\" was successfully unarchived./, "您的倉庫 “$1” 已成功解除存檔。"], //倉庫解除存檔

            // 刪除倉庫對話框
                // [/Delete/, "刪除"],
                "I want to delete this repository": "我想刪除這個倉庫",

                "This will permanently delete the": "這將永久刪除",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all collaborator associations will be permanently deleted.": "倉庫、Wiki、議題、評論、軟體包、機密、工作流程，並刪除所有協作者關聯。",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all collaborator associations.": "倉庫、Wiki、議題、評論、軟體包、機密、工作流程，並刪除所有協作者關聯。",
                "repository, wiki, issues, comments, packages, secrets, workflow runs, and remove all team associations.": "倉庫、Wiki、議題、評論、軟體包、機密、工作流程，並刪除所有團隊關聯。", // 組織倉庫
                "This will not change your billing plan. If you want to downgrade, you can do so in your Billing Settings.": "這並不會更改您的結算方案。 如果您想降級，可以在結算設置中進行降級。",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/is available./, "名稱可用。"],
        [/Make ([^ ]+) private/, "將 $1 設為私有"],
        [/Make ([^ ]+) public/, "將 $1 設為公開"],
        [/(\d+) stars?/, "$1 位星標者"],
        [/(\d+) watchers?/, "$1 位關注者"],
        [/To confirm, type \"([^ ]+)\" in the box below/, "要確認，請在下面的方框中輸入 \"$1\""],
        [/Your repository \"([^ ]+)\" was successfully archived./, "您的倉庫 “$1” 已成功存檔。"], //倉庫存檔
        [/Your repository \"([^ ]+)\" was successfully unarchived./, "您的倉庫 “$1” 已成功解除存檔。"], //倉庫解除存檔
        [/is already the branch name./, "已經是分支的名稱了。"],
        [/Your branch name will be/, "您的分支的名稱將重命名為"],
        [/Choose another branch to use as the default branch of ([^ ]+) instead of/,"選擇另一分支作為 $1 的默認分支而不是"], // 分支切換 對話框
        [/(\d+) branch protection rules?/, "$1 項分支保護規則"], // 禁用/重啟啟用分支保護
        [/Delete/, "刪除"],
        [/Default branch changed to ([^ ])/, "默認分支更改為 $1"],
        // 離開複刻網絡
        [/Forked from ([^ ])/, "複刻自 $1"],
    ],
    "title": {
        "static": {
            "General": "通常",
        },
    },
};

I18N["zh-TW"]["repository/settings/access"] = { // 倉庫設置 - 協作者/(組織倉庫 協作者和團隊) /<user-name>/<repo-name>/settings/access
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 協作者 / 協作者和團隊 - 訪問管理頁面 /<user-name>/<repo-name>/settings/access ====================================
            // 頂部提醒
                "Repository invitation URLs work for invited users only. You may only share this URL with an invited user.": "倉庫邀請 URL 僅適用於受邀請的用戶。您只能與受邀請的用戶共享此 URL。",

                // [/Removed ([^ ]+) as a collaborator of ([^ ]+\/[^ ]+)/, "刪除 $1 為 $2 的協作者"],

            "Who has access": "誰有權訪問",
            "public repository": "公共倉庫",
            "Public repository": "公共倉庫",
            "This repository is public and visible to anyone": "該倉庫是公開的，對任何人都可見",
            "This repository is public and visible to anyone.": "該倉庫是公開的，對任何人都可見。",
            "private repository": "私有倉庫",
            "Only those with access to this repository can view it.": "只有擁有該倉庫訪問權的用戶才能查看。",
            "Manage": "管理",
            "Manage visibility": "管理", // 內容重複，直接省略

            "Direct access": "直接訪問",
            "collaborators have access to this repository. Only you can contribute to this repository.": "個協作者有權訪問此倉庫。 只有您可以對此倉庫做出貢獻。",
            "has access to this repository.": "位有權訪問此倉庫。",
            "have access to this repository.": "有權訪問此倉庫。",
            // 組織倉庫
            "teams or members have access to this repository. Only": "團隊或成員有權訪問此倉庫。只有",
            "Owners": "所有者",
            "can contribute to this repository.": "可以為此倉庫做出貢獻。",

            // 組織倉庫
            "Base role": "基本角色",
            "All": "所有",
            // [/(\d+) members?/, "$1 位成員"],
            "can access this repository.": "可以訪問此倉庫。",

            "Manage access": "訪問管理",
            "You haven't invited any collaborators yet": "您尚未邀請任何協作者",
            // "invite a collaborator": "邀請協作者",
            "Add people": "添加他人",
                // 邀請對話框
                    "Add people to": "添加成員到",
                    "Search by username, full name, or email": "搜索用戶名、全名、或電子郵箱",
                    "Find people": "查找",
                    "Invite collaborator": "邀請協作者",
                    "Add to repository": "添加到倉庫",
                    // 頂部提醒
                        // [/([^ ]+) has been added as a collaborator on the repository./, "$1 已被添加為倉庫的協作者。"],


            "Select all": "全選",
                // [/(\d+) members? selected…/, "已選擇 $1 名成員..."],
                "Change role": "切換角色",
                "Remove Access": "刪除訪問權限",
            "Type": "類型",
                "Filter by member type": "按成員類型篩選",
                    "Organization Members": "組織成員",
                    "Outside Collaborators": "外部協作者",
                    "Pending Invitations": "待處理邀請",
            "Find a collaborator…": "尋找協作者……",
            "Find people or a team…": "尋找用戶或一個團隊……",
            "No Results": "無結果",

            "Pending Invite": "待處理邀請",
            "Invite expired": "已過期",
            // [/Awaiting ([^ ]+)’s response/, "等待 $1 的回覆"],
            "Remove": "移除",

            // 移除邀請對話框
                "Confirm you want to remove this invitation": "確認移除邀請",
                "Once canceled,": "取消後，",
                "will no longer be invited to access the": "將不再被邀請訪問",
                "repository.": "倉庫。",
                // [/Cancel ([^ ]+)'s invitation/, "取消邀請 $1"],
                // 頂部提醒
                    // [/([^ ]+) is no longer invited to this repository./, "$1 不再受邀訪問該倉庫。"],

            // 刪除協助者對話框
                "Confirm you want to remove this member": "確認要刪除此成員？",
                "Once removed,": "一旦刪除，",
                "will no longer have direct access to this repository. However, they may still have access to this repository if they are a member of a team that is granted access.": "將不再能直接訪問此倉庫。但是，如果他們是獲准訪問該倉庫的團隊成員，則仍可訪問該倉庫。",
                // 頂部提醒
                    // [/Remove ([^ ]+) from this repository/, "從該倉庫移除 $1"],

            // 組織倉庫
            "Create team": "創建組織",
            "You haven't added any teams or people yet": "您尚未添加團隊或成員",
            "Organization owners can manage individual and team access to the organization's repositories. Team maintainers can also manage a team's repository access.": "組織所有者可以管理成員和團隊對組織倉庫的訪問。團隊維護者也可以管理一個團隊的倉庫訪問。",
            "Learn more about organization access": "瞭解更多關於組織訪問權限的信息",
            "Add teams": "添加團隊",

            // "Add people to": "添加成員到",
            "Select a member above": "在上面選擇一名成員",
            "Add teams to": "添加團隊",
            "Search by team name": "按團隊名稱搜索",
            "Select a team above": "在上面選擇一個團隊",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) members? selected…/, "已選擇 $1 名成員..."],
        [/(\d+) members?/, "$1 位成員"],
        [/(\d+) collaborators?/, "$1 位協作者"],
        [/(\d+) invitations?/, "$1 個邀請"],
        [/Awaiting ([^ ]+)’s response/, "等待 $1 的回覆"],
        [/([^ ]+) • Collaborator/, "$1 • 協作者"],
        [/([^ ]+) • Invite collaborator/, "$1 • 邀請協作者"],
        [/(\d+) users?/, "$1 個用戶"],
        [/(\d+) teams?/, "$1 個團隊"],
        [/Add people to ([^ ]+)/, "添加人員到 $1"],
        [/([^ ]+) has been added as a collaborator on the repository./, "已將 $1 添加為倉庫協作者。"],
        [/Cancel ([^ ]+)'s invitation/, "取消邀請 $1"],
        [/([^ ]+) is no longer invited to this repository./, "$1 不再受邀訪問該倉庫。"],
        [/Remove ([^ ]+) from this repository/, "從該倉庫移除 $1"],
        [/Removed ([^ ]+) as a collaborator of ([^ ]+\/[^ ]+)/, "刪除 $1 為 $2 的協作者"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Manage access": "訪問管理",
        },
    },
};

I18N["zh-TW"]["repository/settings/interaction_limits"] = { // 倉庫設置 - 互動限制 /<user-name>/<repo-name>/settings/interaction_limits
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 審查設置 (倉庫)互動限制 /<user-name>/<repo-name>/settings/interaction_limits
        // 同全局 同組織倉庫
            "Temporary interaction limits": "臨時互動限制",
            "Temporarily restrict which external users can interact with your repository (comment, open issues, or create pull requests) for a configurable period of time.": "在配置的時間段內，可臨時限制哪些外部用戶與您的倉庫互動（評論、打開議題或創建拉取請求）。",
            "This may be used to force a \"cool-down\" period during heated discussions or prevent unwanted interactions.": "可用於在激烈討論期間，強制進入 “冷靜” 期或防止不必要的互動。",

            "You can restrict repository interactions across your account in your": "您可以限制倉庫交互，在您的賬戶設置中的",
            "account settings": "互動限制",

            // [/You can restrict repository interactions across the ([^ ]+) organization in your/, "您可以在您的 $1 組織中限制倉庫交互"],

            "Limit to existing users": "僅限現有用戶",
                "Users that have recently created their account will be unable to interact with the repository.": "最近創建賬戶的用戶將無法與該倉庫互動。",
            "Limit to prior contributors": "僅限於先前的貢獻者",
                "Users that have not previously": "以前從未",
                "committed": "提交",
                // [/to the ([^ ]+) branch of this repository will be unable to interact with the repository./, "到該倉庫的 $1 分支的用戶將無法與該倉庫互動。"],
            "Limit to repository collaborators": "僅限倉庫協作者",
                "Users that are not": "不是",
                // "collaborators": "",
                // "of one of your repositories will not be able to interact with that repository.": "",
                "will not be able to interact with the repository.": "將無法與該倉庫互動。",

            "New users": "新用戶",
            "Users": "用戶",
            "Contributors": "貢獻者",
            "Collaborators": "協作者",
            "Organization members": "組織成員", //組織倉庫

            "Enable": "啟用",
            "Disable": "禁用",
            // 交互限制時間 下拉菜單
            "Enable interaction limits for:": "啟用交互限制：",
            "24 hours": "24 小時",
            "3 days": "3 天",
            "1 week": "1 周",
            "1 month": "1 個月",
            "6 months": "6 個月",

            // 頂部提醒
            "Repository interaction limit settings saved.": "倉庫交互限制設置已保存。",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
            [/You can restrict repository interactions across the ([^ ]+) organization in your/, "您可以在您的 $1 組織中限制倉庫交互"],
            [/to the ([^ ]+) branch of this repository will be unable to interact with the repository./, "到該倉庫的 $1 分支的用戶將無法與該倉庫互動。"],
    ],
    "title": {
        "static": {
            "Temporary interaction limits": "臨時互動限制",
        },
    },
};

I18N["zh-TW"]["repository/settings/code_review_limits"] = { // 倉庫設置 - 程式碼審查限制 /<user-name>/<repo-name>/settings/code_review_limits
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // Code review limits 程式碼審查限制 /<user-name>/<repo-name>/settings/code_review_limits
            "Restrict users who are permitted to approve or request changes on pull requests in this repository.": "限制允許批准或請求更改該倉庫中拉取請求的用戶。",
            "Limit to users explicitly granted": "限於明確授予",
            "read": "讀取",
            "or higher access": "或 更高權限的用戶",
                "When enabled, only users explicitly granted access to this repository will be able to submit pull request reviews that \"approve\" or \"request changes\". All users able to submit comment pull request reviews will continue to be able to do so.": "啟用後，只有被明確授予該倉庫訪問權的用戶才能提交 “批准” 或 “請求更改” 的拉取請求審查。所有能夠提交評論拉取請求審查的用戶將繼續能夠這樣做。",

            // 頂部提醒
                "Code review limit settings saved.": "程式碼審查限制設置已保存。",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "static": {
            "Code review limits": "程式碼審查限制",
        },
    },
};

I18N["zh-TW"]["repository/settings/branches"] = { // 倉庫設置 - 分支 /<user-name>/<repo-name>/settings/branches
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 分支管理頁面 /<user-name>/<repo-name>/settings/branches====================================
            "Branch protection rules": "分支保護規則",
            "Add rule": "添加規則",

            "Define branch protection rules to disable force pushing, prevent branches from being deleted, and optionally require status checks before merging. New to branch protection rules?": "定義分支保護規則，以禁止強制推送，防止分支被刪除，並可選擇要求在合併前進行狀態檢查。初次接觸分支保護規則？",

            "No branch protection rules defined yet.": "尚未定義分支保護規則。",

            "You haven't protected any of your branches": "您沒有保護任何分支",
            "Classic branch protections have not been configured": "未配置經典分支保護",
            "Define branch rules to disable force pushing, prevent branches from being deleted, or require pull requests before merging. Learn more about": "定義分支規則，以禁止強制推送、防止分支被刪除或在合併前要求提交拉取請求。瞭解更多：",
            //"Define a protected branch rule to disable force pushing, prevent branches from being deleted, and optionally require status checks before merging.": "定義分支保護規則，以禁用強制推送，防止分支被刪除，並可選擇在合併前進行狀態檢查。",
            "repository rules": "倉庫規則",
            "protected branches": "受保護分支",
            "Add branch ruleset": "添加分支規則集",
            "Add classic branch protection rule": "添加經典分支保護規則",
            //"Learn more about protected branches": "瞭解更多關於受保護分支的信息",
            //"Add branch protection rule": "添加分支保護規則",

            // 私有庫 分支保護 未執行 提醒
            "Your protected branch rules won't be enforced on this private repository until you move to a GitHub Team or Enterprise organization account.": "您的受保護分支規則不會在這個私有倉庫上執行，直到您遷移至 GitHub 團隊或企業組織賬戶。",
            "Move to an organization": "轉移到組織",

            "Not enforced": "未執行",
                "Rules on your private repos can't be enforced until you upgrade to GitHub Team or Enterprise.": "在您升級到 GitHub 團隊或企業版之前，您的私有倉庫的規則不能被執行。",

            // [/Currently applies to (\d+) branchs?/, "目前適用於 $1 個分支"], // 倉庫設置-->分支-->分支保護規則

            // 刪除分支保護規則
            "Delete this branch protection rule?": "刪除此分支保護規則？",
            "This action cannot be undone.": "此操作無法撤消。",
            "I understand, delete this rule.": "我明白了，依然刪除此規則。",

            // 頂部提醒
            "Branch protection rule settings saved.": "分支保護規則設置已保存。",
            "Branch protection rule created.": "分支保護規則已創建。",
            "Branch protection rule was successfully deleted.": "分支保護規則已成功刪除。",


    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Currently applies to (\d+) branch(?:es|)/, "目前適用於 $1 個分支"], // 倉庫設置-->分支-->分支保護規則
    ],
    "title": {
        "regexp": [
            [/Settings · Branches/, "設置 · 分支"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/branch_protection_rules"] = { // 倉庫設置 - 分支/分支保護 /<user-name>/<repo-name>/settings/branch_protection_rules
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 新建分支保護規則 頁面 /<user-name>/<repo-name>/settings/branch_protection_rules/new====================================
            "Branch protection rule": "分支保護規則",

            "Protect your most important branches": "保護您最重要的分支",
                "Branch protection rules": "分支保護規則",
                "define whether collaborators can delete or force push to the branch and set requirements for any pushes to the branch, such as passing status checks or a linear commit history.": "定義協作者是否可以刪除或強制推送到分支，並對任何推送到分支的內容設置要求，如通過狀態檢查或線性提交歷史。",

                "Your GitHub Free plan": "您的 GitHub 免費計劃",
                "Your organization's GitHub Free plan": "您組織的 GitHub 免費計劃", // 組織倉庫
                "can only enforce rules on its public repositories, like this one.": "只能對其公共倉庫執行規則，例如這個。",

                "Your rules won't be enforced on this private repository until you": "您的規則將不會在此私有倉庫上強制執行，直到您",
                "move to a GitHub Team or Enterprise organization account": "遷移至 GitHub 團隊或企業組織賬戶",
                "upgrade this organization to GitHub Team or Enterprise": "升級組織至 GitHub 團隊或企業版", // 組織倉庫

            "Branch name pattern": "分支名稱模式",
            "Protect matching branches": "保護匹配的分支",
                "Require a pull request before merging": "要求在合併前提交拉取請求",
                    "When enabled, all commits must be made to a non-protected branch and submitted via a pull request before they can be merged into a branch that matches this rule.": "啟用後，所有提交都必須提交到不受保護的分支，並通過拉取請求提交，然後才能將它們合併到與此規則匹配的分支中。",
                    "Require approvals": "要求批准審查",
                        "When enabled, pull requests targeting a matching branch require a number of approvals and no changes requested before they can be merged.": "啟用後，針對匹配分支的拉取請求需要若干次批准審查，並且在合併之前無需請求更改。",
                        "Required number of approvals before merging:": "合併前所需的批准審查數量：",
                    "Dismiss stale pull request approvals when new commits are pushed": "當新的提交被推送時，撤銷陳舊的拉取請求批准審查",
                        "New reviewable commits pushed to a matching branch will dismiss pull request review approvals.": "推送到匹配分支的新的可審查提交將撤銷之前的拉取請求的批准審查。",
                    "Require review from Code Owners": "要求程式碼所有者進行審查",
                        "Require an approved review in pull requests including files with a designated code owner.": "要求在拉取請求中進行批准審查，包括有指定程式碼所有者的文件。",
                    "Restrict who can dismiss pull request reviews": "限制誰可以駁回拉取請求審查", // 組織倉庫
                        "Specify people, teams, or apps allowed to dismiss pull request reviews.": "指定允許駁回拉取請求審查的人員、團隊或應用。",
                        "People, teams, or apps that can dismiss reviews.": "允許駁回審查的人員、團隊或應用。",
                            "Organization and repository administrators": "組織和倉庫管理員",
                                "These members can always dismiss.": "這些成員總是允許駁回。",
                                "These members cannot dismiss.": "這些成員不允許駁回。",
                    "Allow specified actors to bypass required pull requests": "允許指定的參與者繞過所需的拉取請求", //組織倉庫
                        "Specify people, teams, or apps who are allowed to bypass required pull requests.": "指定允許繞過所需拉取請求的人員、團隊或應用。",
                        "People, teams, or apps who can bypass required pull requests": "允許繞過所需拉取請求的人員、團隊或應用",
                            // "Organization and repository administrators": "組織和倉庫管理員",
                                "These members can always bypass required pull requests.": "這些成員始終允許繞過所需的拉取請求。",
                                "These members cannot bypass.": "這些成員不允許繞過。",
                    "Require approval of the most recent reviewable push": "要求批准最新的可審查推送",
                        "Whether the most recent reviewable push must be approved by someone other than the person who pushed it.": "最新的可審核推送是否必須得到推送者以外的其他人批准。",
                "Require status checks to pass before merging": "要求在合併前通過狀態檢查",
                    "Choose which": "選擇那些",
                    "status checks": "狀態檢查",
                    "must pass before branches can be merged into a branch that matches this rule. When enabled, commits must first be pushed to another branch, then merged or pushed directly to a branch that matches this rule after status checks have passed.": "必須通過，才能將分支合併到符合此規則的分支。啟用後，提交的內容必須先推送到另一個分支，然後在狀態檢查通過後再合併或直接推送到符合此規則的分支。",

                    "Require branches to be up to date before merging": "要求分支在合併前必須是最新的",
                        "This ensures pull requests targeting a matching branch have been tested with the latest code. This setting will not take effect unless at least one status check is enabled (see below).": "這可確保針對匹配分支的拉取請求已使用最新的程式碼進行了測試。除非啟用了至少一個狀態檢查，否則這個設置不會生效（見下文）。",

                    "Do not require status checks on creation": "不要求在創建時進行狀態檢查",
                        "Allow repositories and branches to be created if a check would otherwise prohibit it.": "允許創建倉庫和分支，否則檢查將禁止創建。",

                    "Search for status checks in the last week for this repository": "搜索此倉庫最近一週的狀態檢查",
                    "Status checks that are required.": "需要進行的狀態檢查。",

                    "No status checks found": "尚無狀態檢查",
                        "Sorry, we couldn’t find any status checks in the last week for this repository.": "抱歉，我們最近一週未找此倉庫的任何狀態檢查。",
                    "Learn more about status checks": "瞭解更多關於狀態檢查的信息",
                "Require conversation resolution before merging": "要求在合併前解決對話",
                    "When enabled, all conversations on code must be resolved before a pull request can be merged into a branch that matches this rule.": "啟用後，必須先解決所有有關程式碼的對話，然後才能將拉取請求合併到與此規則匹配的分支中。",
                    "Learn more about requiring conversation completion before merging": "瞭解更多關於合併前要求完成對話的信息",
                "Require signed commits": "要求帶簽名的提交",
                    "Commits pushed to matching branches must have verified signatures.": "推送到匹配分支的提交必須帶有經過驗證的簽名。",
                "Require linear history": "要求線性歷史記錄",
                    "Prevent merge commits from being pushed to matching branches.": "防止合併後的提交被推送到匹配的分支。",
                "Require merge queue": "要求合併隊列", // 組織倉庫
                    "Merges to matching branches must be performed via a merge queue.": "對匹配分支的合併必須通過合併隊列執行。",
                    "Make sure to configure your CI to build branches created by the queue.": "確保您配置 CI 以構建由隊列創建的分支",
                    "Merge method": "合併模式",
                        "Method to use when merging changes from queued pull requests.": "合併來自列隊拉取請求的更改時使用的模式。",
                        "Method:": "模式：",
                            "Merge commit": "合併提交",
                            "Squash and merge": "壓縮合併",
                            "Rebase and merge": "變基合併",
                    "Build concurrency": "構建並發",
                        "Limit the number of queued pull requests building at the same time.": "限制同時構建的列隊拉取請求的數量。",
                        "Maximum pull requests to build:": "構建的最大拉取請求：",
                    "Merge limits": "合併限制",
                        "Limit the number of pull requests merged into the protected branch in a single merge operation.": "限制在單個合併操作中合併到受保護分支的拉取請求的數量。",
                        "Minimum pull requests to merge:": "合併的最小拉取請求：",
                            "or after": "或",
                            "minutes": "分鐘之後",
                        "Maximum pull requests to merge:": "合併的最大拉取請求：",
                        "Only merge non-failing pull requests": "僅合併未失敗的拉取請求",
                    "Status check timeout": "狀態檢查超時",
                        "Time (in minutes) a required status check must report a conclusion within to not be considered failed.": "所需的狀態檢查必須在規定的時間（以分鐘為單位）內報告結論才不會被視為失敗。",
                        "Consider check failed after:": "考慮檢查失敗：",
                "Require deployments to succeed before merging": "要求部署成功後再合併",
                    "Choose which environments must be successfully deployed to before branches can be merged into a branch that matches this rule.": "選擇必須成功部署到哪些環境才能將分支合併到與此規則匹配的分支中。",
                            "No deployment environments found": "尚無部署環境",
                            "Sorry, we couldn’t find any deployments for this repository.": "抱歉，我們未找到此倉庫的任何部署。",
                            "Deployment environments found in this repository": "在此倉庫中找到的部署環境",
                                "Required": "必須",
                "Lock branch": "鎖定分支",
                    "Branch is read-only. Users cannot push to the branch.": "分支為只讀。用戶無法推送到該分支。",
                "Do not allow bypassing the above settings": "不允許繞過上述設置",
                    "The above settings will apply to administrators and custom roles with the \"bypass branch protections\" permission.": "上述設置將應用於具有 “繞過分支保護” 權限的管理員和自定義角色。",
                "Restrict who can push to matching branches": "限制誰可以推送到匹配的分支", // 組織倉庫
                    "Specify people, teams, or apps allowed to push to matching branches. Required status checks will still prevent these people, teams, and apps from merging if the checks fail.": "指定允許推送到匹配分支的人員、團隊或應用。如果檢查失敗，所需的狀態檢查仍然會阻止這些人、團隊和應用的合併。",

                    "Restrict pushes that create matching branches": "限制創建匹配分支的推送",
                        "Only people, teams, or apps allowed to push will be able to create new branches matching this rule.": "只有允許推送的人員、團隊或應用才能創建符合此規則的新分支。",
                        "People, teams, or apps with push access": "允許推送的人員、團隊或應用",
                            "Organization administrators, repository administrators, and users with the Maintain role.": "組織管理員、倉管理員和具有維護角色的用戶。",
                            "Organization administrators, repository administrators, the merge queue, and users with the Maintain role.": "組織管理員、倉管理員、合併隊列和具有維護角色的用戶。", // 開啟需要合併隊列
                                "Admins can always push. Users with the Maintain role can push when required status checks pass.": "管理員始終允許推送。具有維護角色的用戶允許在所需狀態檢查通過時推送。",
                                "These members can push when required status checks pass.": "這些成員允許在所需狀態檢查通過時推送。",

            "Rules applied to everyone including administrators": "規則適用於每個人，包括管理員",
                "Allow force pushes": "允許強制推送",
                    "Everyone": "所有人",
                        "Permit force pushes for all users with push access.": "允許所有有推送權限的用戶強制推送。",
                    "Specify who can force push": "指定誰允許強制推送",
                        "Only these people, teams, or apps are allowed to force push.": "僅允許這些人、團隊或應用強制推送。",
                        "Search for people, teams, or apps": "搜索人員、團隊或應用",
                        "People, teams, or apps who can force push": "允許強制推送的人員、團隊或應用",
                            "Organization and repository administrators (automatic)": "組織和倉庫管理員（自動）",
                "Allow deletions": "允許刪除",
                    "Allow users with push access to delete matching branches.": "允許具有推送權限的用戶刪除匹配的分支。",

            // 頂部提醒
            "Branch protection rule created.": "分支保護規則已創建。",

        // 編輯分支保護規則 頁面 /<user-name>/<repo-name>/settings/branch_protection_rules/<id>===================================
            // [/Applies to (\d+) branchs?/, "應用於 $1 個分支"], //倉庫設置-->分支-->分支保護規則-->編輯

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Applies to (\d+) branch(?:es|)/, "應用於 $1 個分支"], //倉庫設置-->分支-->分支保護規則-->編輯
    ],
    "title": {
        "regexp": [
            [/Settings · Branches · New branch protection rule/, "設置 · 分支 · 新建分支保護規則"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/tag_protection"] = { // 倉庫設置 - 標籤 /<user-name>/<repo-name>/settings/tag_protection
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 標籤 頁面 /<user-name>/<repo-name>/settings/tag_protection===============================
            // 頂部提醒
                "Tag protection rule created.": "標籤保護規則已創建。",
                "Tag protection rule deleted.": "標籤保護規則已刪除。",

            // 頂部窗口
            "Level up your tag protections with Repository Rules": "利用倉庫規則提升標籤保護級別",
            "Protected tags are being deprecated. To continue protecting tags, please migrate to a tag ruleset by August 30th. You can learn more about the sunset in our": "受保護的標籤將被廢棄。要繼續保護標籤，請在 8 月 30 日前遷移到標籤規則集。您可以在我們的",
            "changelog": "更改日誌",
            "and can get started now by migrating to rulesets.": "中瞭解更多信息，並且可以立即開始遷移到規則集。",

            "Protected tags": "受保護的標籤",
            "Protected tags are available to Pro, Team, and Enterprise users": "專業版、團隊版和企業版用戶均可使用受保護的標籤", //私有庫
            "Protected tags can only be created or deleted by users with enhanced permissions defined by your organization owners.": "受保護的標籤只能由具有由組織所有者定義的增強權限的用戶創建或刪除。",
            "Learn more about protected tags": "瞭解更多關於受保護標籤的信息",
            "No protected tag rules exist yet": "尚無受保護的標籤規則存在",
            "Protected tags have been deprecated": "受保護的標籤已棄用",
            "Go to rulesets to create new tag rules": "轉到規則集創建新標籤規則",
            "New rule": "新建規則",
            "Import to rulesets": "導入規則集",
                "Import your tag protection rules into repository rules": "將您的標籤保護規則導入倉庫規則集",
                    "Migrate your protected tags to one or more repository rulesets. This will implement the same tag protections you currently have today. Once created, the tag rulesets can take advantage of new ruleset features:": "將受保護的標籤遷移到一個或多個倉庫規則集。這將實現與當前相同的標籤保護。創建後，標籤規則集可利用規則集的新功能：",
                        "Requiring status checks to pass": "要求通過狀態檢查",
                        "Signed commits": "要求簽名提交",
                        "Requiring linear history": "需要線性歷史",
                        "and more": "和更多",
                    "Create separate rulesets for creating and deleting protected tags": "為創建和刪除受保護的標籤創建單獨的規則集",
                        "Users and Teams with at least Maintainer role will be able to create new protected tags. Administrators will be able to delete protected tags. This is the same behavior as existing tag protections.": "至少具有維護者角色的用戶和團隊可以創建新的受保護標籤。管理員可以刪除受保護標籤。這與現有標籤保護的行為相同。",
                    "Create one ruleset for all protected tag operations": "為所有受保護的標籤操作創建規則集",
                        "Administrators will be able to create and delete protected tags.": "管理員可以創建和刪除受保護的標籤。",

                    "Learn more about tag rulesets": "瞭解更多關於標籤規則集的信息",
                    "Import": "導入",

            "Delete tag protection rule": "刪除標籤保護規則",
                "Delete tag protection rule?": "刪除標籤保護規則？",
                    "Are you sure you want to delete this tag protection rule? Anyone who can write to this repository will be able to create tags with this pattern.": "您確定要刪除此標籤保護規則嗎？任何可以寫入此倉庫的人都能夠使用此模式創建標籤。",
                    "Yes, remove this tag protection rule": "是的，刪除此標籤保護規則",

            // [/(\d+) rules?/, "$1 條規則"],

        // 新建標籤規則 頁面 /<user-name>/<repo-name>/settings/tag_protection/new===============================
            "/ New rule": "/ 新建規則",
            "Tag name pattern": "標籤名稱模式",
            "Example: You can use": "示例：您可以使用",
            "to target tags named": "來鎖定名為",
            ", and so on.": "等的標籤。",

            "Add rule": "添加規則",

    },
    "regexp": [ // 正則翻譯
        [/(\d+) rules?/, "$1 條規則"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Settings · Tags/, "設置 · 標籤"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/rules"] = { // 倉庫設置 - 規則 - 規則集 /<user-name>/<repo-name>/settings/rules
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"], // 組織設置
        ...I18N["zh-TW"]["confirm-access"]["static"],

        // 倉庫規則集頁面 /<user-name>/<repo-name>/rules
        // 規則集 頁面 /<user-name>/<repo-name>/settings/rules
            "Your rulesets won't be enforced on this private repository until you upgrade this organization account to GitHub Team.": "在您將此組織賬戶升級到 GitHub Team 之前，您的規則集不會在此私有倉庫上強制執行。", // 組織 私有倉庫

            "Organization rulesets won't be enforced": "在您將該組織賬戶升級到 GitHub 企業版之前，", // 組織設置
            "until you upgrade this organization account to GitHub Enterprise.": "組織規則集將不會強制執行。", // 組織設置

            "You haven't created any rulesets": "您尚未創建任何規則集",
                "Define whether collaborators can delete or force push and set requirements for any pushes, such as passing status checks or a linear commit history.": "定義協作者是否可以刪除或強制推送，並為任何推送設置要求，如通過狀態檢查或線性提交歷史。",
                "Learn more about rulesets.": "瞭解更多關於規則集的信息。",

            "Rulesets": "規則集",
            "New ruleset": "新建規則集",
                "New branch ruleset": "新建分支規則集",
                    "New tag ruleset": "新建標籤規則集",
                    "Import a ruleset": "導入規則集",
                        "Choose a JSON file to upload": "選擇 JSON 文件上傳",

            "Ruleset": "規則集",

            "No rulesets have been added yet": "尚未添加任何規則集",

            "All": "全部",
            "• targeting": "• 針對",
            ", targeting": ", 針對",

            "Ruleset menu": "菜單",
                "Export ruleset": "導出規則集",
                "Delete ruleset": "刪除規則",

            // 刪除規則對話框
                "Delete ruleset?": "刪除規則？",
                "Are you sure you want to delete this ruleset? This action cannot be undone.": "您確定要刪除此規則集嗎？此操作無法撤消。",

        // 新建分支規則 /<user-name>/<repo-name>/settings/rules/new?target=branch&enforcement=disabled
        // 新建標籤規則 /<user-name>/<repo-name>/settings/rules/new?target=tag&enforcement=disabled
        // 編輯規則 /<user-name>/<repo-name>/settings/rules/<id>

            "Protect your most important branches": "保護您最重要的分支",
                "define whether collaborators can delete or force push and set requirements for any pushes, such as passing status checks or a linear commit history.": "定義協作者是否可以刪除或強制推送，並為任何推送設置要求，如通過狀態檢查或線性提交歷史。",

            "Tag": "標籤",
            "tags": "標籤",

            "Open additional options": "打開其他選項",
            "Export": "導出",
            "ruleset": "規則",

            "Name": "名稱",
                "Ruleset name cannot be empty": "規則集名稱不能為空",
            "Enforcement status": "執行狀態",
                "Active": "激活",
                    "This ruleset will be enforced": "規則將被執行",
                    "Rules will be enforced": "規則將被執行",
                    "Enable Organization Ruleset": "啟用組織規則集", // 組織設置
                        "I want rules enforced on targeted repositories in this ruleset.": "我希望此規則集中強制執行針對目標倉庫的規則。",
                "Evaluate": "評估", // 組織設置
                    "Evaluate Rulesets to trial rules and view insights": "評估規則集，以試用規則並查看洞察",
                    "Evaluate mode is only available to Enterprise organizations.": "評估模式僅適用於企業組織。",
                        "Upgrade to Enterprise to use this mode.": "升級到企業版即可使用此模式。",
                "Disabled": "禁用",
                    "Do not evaluate or enforce rules": "不評估或執行規則",
                    "This ruleset will not be enforced": "規則將不被執行",

            "Bypass list": "旁路列表",
                "Exempt roles, teams, and apps from this ruleset by adding them to the bypass list.": "通過將角色、團隊和應用程式添加到旁路列表，使其免受此規則集的約束。",
                "Exempt roles, teams, or apps from this ruleset by adding them to the bypass list.": "通過將角色、團隊或應用程式添加到旁路列表，使其免受此規則集的約束。",
                "Exempt roles or teams from this ruleset by adding them to the bypass list": "通過將角色或團隊添加到旁路列表，使其免受此規則集的約束", // 組織設置
                "Add bypass": "添加旁路",

                 // 添加旁路對話框
                    "Choose which roles, teams, and apps can bypass this ruleset": "選擇哪些角色、團隊和應用可繞過此規則集",

                    "Filter items": "篩選",
                    "Filter bypass actors": "篩選旁路參與者",

                    "No suggestions": "暫無建議",

                    "Suggestions": "建議",
                        "Role": "角色",
                        "App": "應用",
                        "Organization admin": "組織管理員",
                        "Repository admin": "倉庫管理員",
                        "Maintain": "維護",
                        "triage": "分類",
                        "maintain": "維持",
                        "read": "讀取",
                        "write": "寫入",
                        "vulnerability_reporter": "漏洞報告員",
                        "Add selected": "添加所選",

                "Always allow": "總是允許",
                "Allow for pull requests only": "僅允許拉取請求",
                    "Allow": "允許",
                        "Always": "總是",
                        "For pull requests only": "僅適用於拉取請求",
                    "Delete bypass": "刪除旁路",

                "Bypass list is empty": "旁路列表為空",

            "Target branches": "目標分支",
                "Which branches should be matched?": "哪些分支應匹配？",
                "Which branches do you want to make a ruleset for?": "您想為哪些分支制定規則集？",
                "Which tags do you want to make a ruleset for?": "您想為哪些標籤制定規則集？", // 標籤
                "Which repositories and branches do you want to make a ruleset for?": "您想為哪些倉庫和分支創建規則集？", // 組織設置

                // 組織設置
                    "Target repositories": "目標倉庫",
                        "Repository targeting determines which repositories will be protected by this ruleset. Use inclusion patterns to expand the list of repositories under this ruleset. Use exclusion patterns to exclude repositories.": "倉庫目標確定哪些倉庫將受此規則集保護。使用包含模式來擴展此規則集下的倉庫列表。使用排除模式來排除倉庫。",
                    "Target:": "目標：",
                        "All repositories": "所有倉庫",
                            "Target all repositories within the organization": "組織內的所有倉庫",
                        "Dynamic list by name": "按名稱動態列表",
                            "Target repositories based on name": "基於名稱的目標倉庫",
                        "Dynamic list by property": "按屬性動態列表",
                            "Target repositories based on properties": "基於屬性的目標倉庫",
                        "Select repositories": "選擇倉庫",
                            "Target a specific list of selected repositories": "以選定倉庫列表為目標",

                    "Targeting criteria": "目標規則",
                        "No repository targets have been added yet": "尚未添加倉庫目標",

                        "Prevent renaming of target repositories": "防止重命名目標倉庫",
                            "When checked, target repositories can only be renamed by those with bypass permission.": "選中後，目標倉庫只能由具有繞過權限的成員重命名。",

                            "Repositories that match the matching pattern will be targeted by this ruleset.": "與匹配規則相匹配的倉庫將成為該規則集的目標。",
                            "Repositories that do not match the matching pattern will be targeted by this ruleset.": "與匹配規則不匹配的倉庫將成為該規則集的目標。",

                    "Target by repository properties": "目標倉庫屬性",
                        "Repository targeting determines which repositories will be protected by this ruleset.": "倉庫目標確定哪些倉庫將受此規則集保護",

                        "Add a target": "添加目標",
                            "Include by property": "包含屬性",
                            "Exclude by property": "排除屬性",

                        "Include repositories by custom property": "按自定義屬性包含倉庫",
                            "Custom properties allow you to create your own metadata for repositories": "自定義屬性允許您為倉庫創建自己的元數據，",
                            "include": "包括",
                            "exclude": "排除",
                            "Property": "屬性",
                                "Select property": "選擇屬性",
                                    "Select an item": "選擇專案",
                                        "Search for properties": "搜索屬性",

                    // 倉庫
                        "Select items": "選擇專案",
                            "Repos": "倉庫",

                "Target": "目標",
                    "Branch targeting determines which branches will be protected by this ruleset. Use inclusion patterns to expand the list of branches under this ruleset. Use exclusion patterns to exclude branches.": "分支目標確定哪些分支將受此規則集保護。使用包含模式來擴展該規則集下的分支列表。使用排除模式來排除分支。",
                    "Tag targeting determines which tags will be protected by this ruleset. Use inclusion patterns to expand the list of tags under this ruleset. Use exclusion patterns to exclude tags.": "標籤目標確定哪些標籤將受此規則集保護。使用包含模式來擴展該規則集下的標籤列表。使用排除模式來排除標籤。", // 標籤

                    "Branch targeting criteria": "目標分支規則",
                    "Tag targeting criteria": "目標標籤規則", // 標籤
                        "Add target": "添加目標",
                            "Include default branch": "包含默認分支",
                            "Include all branches": "包含所有分支",
                            "Include all tags": "包含所有標籤", // 標籤
                            "Target by inclusion or exclusion pattern": "通過包含或排除規則確定目標",
                            "Include by pattern": "包含規則",
                            "Exclude by pattern": "排除規則",

                        "Branch targeting has not been configured": "尚未配置分支目標",
                        "Tag targeting has not been configured": "尚未配置標籤目標", // 標籤

                        "Default": "默認",
                        "All branches": "所有分支",
                        "All tags": "所有標籤", // 標籤

                        "Applies to": "適用於",
                        "target:": "個目標：",
                        "targets:": "個目標：",
                        "Targets have changed and branch match list will update on save.": "目標已更改，分支匹配列表將在保存時更新。",
                            "Targets have changed and": "目標已更改，",
                            "branch": "分支",
                            "branches": "分支",
                            "match list will update on save.": "匹配列表將在保存時更新。",
                        "targets including": "個目標，包括",
                        "Targets have changed and repository match list will update on save.": "目標已更改，倉庫匹配列表將在保存時更新。", // 組織設置

                        // 包含規則 對話框
                            "Branches that match the matching pattern will be targeted by this ruleset.": "與匹配規則相匹配的分支將成為該規則集的目標。",
                            "Tags that match the matching pattern will be targeted by this ruleset.": "與匹配規則相匹配的標籤將成為該規則集的目標。", // 標籤
                            "naming pattern": "命名規則",
                                "Pattern cannot be empty": "規則不能為空",
                            "Example patterns: \"": "示例：\"",
                            "Learn more about fnmatch": "瞭解更多關於 fnmatch 的信息",
                            "Add Inclusion pattern": "添加包含規則",

                        // 排除規則 對話框
                            "Branches that do not match the matching pattern will be targeted by this ruleset.": "與匹配規則不匹配的分支將成為該規則集的目標。",
                            "Tags that do not match the matching pattern will be targeted by this ruleset.": "與匹配規則不匹配的標籤將成為該規則集的目標。", // 標籤
                            "Add Exclusion pattern": "添加排除規則",

            // 規則
            "Branch rules": "分支規則",
            "rules": "規則",
                "Which rules should be applied to the targets that you have selected?": "哪些規則應適用於您選擇的目標？",
                "Which rules should be applied?": "應適用哪些規則？",

                "protections": "保護",
                    "Restrict creations": "限制創建",
                        "Only allow users with bypass permission to create matching refs.": "只允許具有繞過權限的用戶創建匹配的引用。",
                    "Restrict updates": "限制更新",
                        "Only allow users with bypass permission to update matching refs.": "只允許具有繞過權限的用戶更新匹配的引用。",
                            "Allow fork syncing": "允許複刻倉庫同步",
                                 "Branch can pull changes from its upstream repository": "分支可從上游倉庫中拉取更改",
                    "Restrict deletions": "限制刪除",
                        "Only allow users with bypass permissions to delete matching refs.": "只允許具有繞過權限的用戶刪除匹配的引用。",
                    "Require linear history": "需要線性歷史",
                        "Prevent merge commits from being pushed to matching refs.": "防止合併後的提交被推送到匹配的引用。",
                    "Require merge queue": "要求合併隊列", // 組織倉庫
                        "Merges must be performed via a merge queue.": "合併必須通過合併隊列進行。",
                        "Merge method": "合併模式",
                            "Method to use when merging changes from queued pull requests.": "合併來自列隊拉取請求的更改時使用的模式。",

                                "Merge commit": "合併提交",
                                "Squash and merge": "壓縮合併",
                                "Rebase and merge": "變基合併",
                        "Build concurrency": "構建並發",
                            "Limit the number of queued pull requests requesting checks and workflow runs at the same time.": "限制同時請求檢查和工作流運行的隊列拉取請求數量。",
                        "Minimum group size": "最小分組數",
                            "The minimum number of PRs that will be merged together in a group.": "將合併為一組的拉取請求的最小數量。",
                        "Maximum group size": "最大分組數",
                            "The maximum number of PRs that will be merged together in a group.": "將合併為一組的拉取請求的最大數量。",
                        "Wait time to meet minimum group size (minutes)": "達到最小分組數的等待時間（分鐘）",
                            "The time merge queue should wait after the first PR is added to the queue for the minimum group size to be met. After this time has elapsed, the minimum group size will be ignored and a smaller group will be merged.": "第一個拉取請求添加到隊列後，合併隊列為達到最小分組規模所需的等待時間。超過這一時間後，將忽略最小分組大小，合併一個較小的分組",
                        "Require all queue entries to pass required checks": "要求所有隊列條目通過必要的檢查",
                            "When this setting is disabled, only the commit at the head of the merge group, i.e. the commit containing changes from all of the PRs in the group, must pass its required checks to merge.": "禁用此設置後，只有位於合併組頭部的提交（即包含組內所有拉取請求變更的提交）必須通過合併所需的檢查。",
                        "Status check timeout (minutes)": "狀態檢查超時（分鐘）",
                            "Maximum time for a required status check to report a conclusion. After this much time has elapsed, checks that have not reported a conclusion will be assumed to have failed": "報告結論所需的狀態檢查的最長時間。超過此時間後，未報告結論的檢查將被視為失敗",
                    "Require deployments to succeed": "要求部署成功",
                        "Choose which environments must be successfully deployed to before refs can be pushed into a ref that matches this rule.": "選擇必須成功部署到哪些環境，之後才能將引用推送到與此規則匹配的引用中。",
                        "Hide additional settings": "隱藏附加設置",
                        "Show additional settings": "顯示附加設置",
                            "Search for deployment environments": "搜索部署環境",
                            "No deployment environments have been added": "未添加部署環境",
                            "Learn more about deployment environments": "瞭解更多關於部署環境的信息",
                    "Require signed commits": "要求帶簽名的提交",
                        "Commits pushed to matching refs must have verified signatures.": "推送到匹配引用的提交必須帶有經過驗證的簽名。",
                    "Require a pull request before merging": "要求在合併前提交拉取請求",
                        "Require all commits be made to a non-target branch and submitted via a pull request before they can be merged.": "要求所有的提交都必須在非目標分支上進行，並在合併前通過拉取請求提交。",
                            "Required approvals": "要求批准審查",
                                "The number of approving reviews that are required before a pull request can be merged.": "拉取請求合併前所需的批准審查次數。",
                            "Dismiss stale pull request approvals when new commits are pushed": "當新的提交被推送時，撤銷陳舊的拉取請求批准審查",
                                "New, reviewable commits pushed will dismiss previous pull request review approvals.": "推送新的可審查提交將撤銷之前的拉取請求的批准審查。",
                            "Require review from Code Owners": "要求程式碼所有者進行審查",
                                "Require an approving review in pull requests that modify files that have a designated code owner.": "要求對具有指定程式碼所有者的文件修改的拉取請求中進行批准審查。",
                            "Require approval of the most recent reviewable push": "要求批准最新的可審查推送",
                                "Whether the most recent reviewable push must be approved by someone other than the person who pushed it.": "最新的可審核推送是否必須得到推送者以外的其他人批准。",
                            "Require conversation resolution before merging": "要求在合併前解決對話",
                                "All conversations on code must be resolved before a pull request can be merged.": "在合併拉取請求之前，必須解決有關程式碼的所有對話。",
                            "Request pull request review from Copilot": "請求 Copilot 進行拉取請求審查",
                                "Automatically request review from Copilot for new pull requests, if the author has access to Copilot code review.": "如果作者有權訪問 Copilot 程式碼審查，則自動請求 Copilot 對新拉取請求進行審查。",

                            "Allowed merge methods": "允許合併方法",
                                "Merge, Squash": "合併，壓縮",
                                "Merge, Squash, Rebase": "合併，壓縮，變基",
                                "Merge, Rebase, Squash": "合併，變基，壓縮",
                                "Merge, Rebase, Squash": "合併，變基，壓縮",
                                "Merge, Rebase": "合併，變基",
                                "Squash, Rebase": "壓縮，變基",
                                "Squash, Rebase, Merge": "壓縮，變基，合併",
                                "Squash, Merge": "壓縮，合併",
                                "Squash, Merge, Rebase": "壓縮，合併，變基",
                                "Rebase, Merge": "變基，合併",
                                "Rebase, Squash": "變基，壓縮",
                                "Rebase, Squash, Merge": "變基，壓縮，合併",
                                "Rebase, Merge, Squash": "變基，合併，壓縮",
                                "Merge": "合併",
                                    "Add all commits from the head branch to the base branch with a merge commit.": "將所有來自頭部分支的提交通過一次合併提交添加到基礎分支。",
                                "Squash": "壓縮",
                                    "Combine all commits from the head branch into a single commit in the base branch.": "將頭部分支上的所有提交合併為一個提交，然後將其集成到基礎分支。",
                                "Rebase": "變基",
                                    "Add all commits from the head branch onto the base branch individually.": "將頭部分支中的所有提交逐個添加到基礎分支上。",
                                "When merging pull requests, you can allow any combination of merge commits, squashing, or rebasing. At least one option must be enabled.": "在合併拉取請求時，您可以允許合併提交、壓縮或變基這三種方式中的任意組合。至少啟用其中一種選項。",
                    "Require status checks to pass": "要求通過狀態檢查",
                        "Choose which status checks must pass before the ref is updated. When enabled, commits must first be pushed to another ref where the checks pass.": "更新引用之前必須選擇通過哪些狀態檢查。啟用後，提交必須首先推送到檢查通過的另一個引用。",
                            "Require branches to be up to date before merging": "要求分支在合併前必須是最新的",
                                "Whether pull requests targeting a matching branch must be tested with the latest code. This setting will not take effect unless at least one status check is enabled.": "針對匹配分支的拉取請求，使用最新程式碼進行測試。至少啟用一項狀態檢查，否則此設置不會生效。",
                                "Do not require status checks on creation": "不要求在創建時進行狀態檢查",
                                    "Allow repositories and branches to be created if a check would otherwise prohibit it.": "允許創建倉庫和分支，否則檢查將禁止創建。",
                                // "Enter the name of a status check": "輸入狀態檢查的名稱",
                                    // [/Add '(.*)'/, "添加 $1"],
                                "No required checks": "無需進行必要的檢查",
                                    "Add checks": "添加檢查",
                                        "Add Checks": "添加檢查",
                                            "Search for checks": "搜索檢查",
                                            "No results": "無結果",
                                "No checks have been added": "未添加任何檢查",
                                "Learn more about status checks": "瞭解更多關於狀態檢查的信息",
                    "Block force pushes": "阻止強制推送",
                        "Prevent users with push access from force pushing to refs.": "防止具有推送權限的用戶強制推送到引用。",
                    "Require code scanning results": "需要程式碼掃描結果",
                        "Choose which tools must provide code scanning results before the reference is updated. When configured, code scanning must be enabled and have results for both the commit and the reference being updated.": "選擇哪些工具必須在更新引用之前提供程式碼掃描結果。配置後，程式碼掃描必須啟用，並為提交和正在更新的引用提供結果。",
                        "Required tools and alert thresholds": "所需工具和警報閾值",
                            "Add tool": "添加工具",
                                "Tool name": "工具名稱",
                                "Enter the name of a code scanning tool": "輸入程式碼掃描工具名稱",
                        "Security alerts": "安全警報",
                            "None": "無",
                            "Critical": "關鍵",
                            "High or higher": "高風險及以上",
                            "Medium or higher": "中風險及以上",
                        "Alerts": "警報",
                            "Errors": "僅錯誤",
                            "Errors and Warnings": "錯誤和警告",
                        "Delete Tool": "刪除工具",
                        "Tools that must provide code scanning results for this rule to pass.": "必須提供程式碼掃描結果才能通過此規則的工具。",
                        "Learn more about enabling code scanning.": "瞭解更多關於啟用程式碼掃描的信息。",

                    "Require code quality results": "要求程式碼質量結果",
                        "Choose which severity levels of code quality results should block pull request merges. When configured, a code quality analysis must be done on the pull request before the changes can be merged.": "選擇哪些程式碼質量結果嚴重級別應阻止拉取請求合併。配置後，必須在拉取請求上進行程式碼質量分析，才能合併更改。",
                        "Severity": "嚴重級別",
                            "Error": "錯誤",
                            "Warning": "警告",
                            "Warnings and higher": "警告及以上",
                            "Notes and higher": "備註及以上",
                        "The lowest severity level at which code quality reviews need to be resolved before commits can be merged.": "在合併提交之前，需要解決的最低嚴重級別程式碼質量審查。",

                    "Automatically request Copilot code review": "自動請求 Copilot 程式碼審查",
                        "Request Copilot code review for new pull requests automatically if the author has access to Copilot code review and their premium requests quota has not reached the limit.": "如果作者有權訪問 Copilot 程式碼審查並且其高級請求配額尚未達到限制，則自動請求 Copilot 對新拉取請求進行程式碼審查。",
                        "Review new pushes": "審查新的推送",
                        "Copilot automatically reviews each new push to the pull request.": "Copilot 自動審查每個新的推送請求。",
                        "Review draft pull requests": "審查草稿拉取請求",
                        "Copilot automatically reviews draft pull requests before they are marked as ready for review.": "Copilot 自動審查草稿拉取請求，在標記為準備好審查之前。",

                    "Manage static analysis tools in Copilot code review": "在 Copilot 程式碼審查中管理靜態分析工具",
                        "Copilot code review will include findings from the selected static analysis tools in its review comments.": "Copilot 程式碼審查將在其審查意見中包括所選靜態分析工具的結果。",

                    // 組織設置
                    "Require workflows to pass before merging": "要求合併前，工作流通過狀態檢查",
                        "Require all changes made to a targeted branch to pass the specified workflows before they can be merged.": "要求目標分支上的所有更改在合併前通過指定的工作流",
                        "Workflow configurations": "工作流程配置",
                            "No workflow configurations found": "尚無工作流配置",

                        "Add workflow": "添加工作流",
                            "Add required workflow": "添加所需的工作流",
                                // 倉庫
                                    "Select a repository": "選擇倉庫",
                                "Select branch or tag": "選擇分支或標籤",
                                    "Branch or tag": "分支或標籤",
                                    "Pin to commit": "固定到提交",
                                        "Always reference the current commit": "始終引用當前提交",
                                "Enter a SHA": "輸入 SHA",
                                    "Enter a valid SHA": "輸入有效的 SHA",
                                    "Enter the SHA for the commit you want to reference": "輸入要引用的提交的 SHA",
                                    "Invalid SHA": "無效的 SHA",
                                "Pick a workflow file": "選擇工作流文件",
                                    "Please select a workflow path": "請選擇工作流路徑",

            "Restrictions": "限制", // 組織設置
                "Restrict commit metadata": "限制提交元數據",
                    "Restrict commit author email addresses, committer email addresses, commit message content, and other metadata": "限制提交作者電子郵箱地址、提交者電子郵箱地址、提交消息內容和其他元數據",

                    "Metadata restrictions": "元數據限制",
                        "No metadata restrictions have been added": "尚無元素限制",
                        "Learn more about": "瞭解更多關於",
                        "metadata": "元素",
                        "restrictions": "限制",

                        "Add restriction": "添加限制",
                            // 添加元數據限制 對話框
                                "Add a metadata restriction": "添加元數據限制",
                                    "Applies To": "適用於",
                                        "Commit message": "提交信息",
                                        "Author email": "作者電子郵箱地址",
                                        "Committer email": "提交者電子郵箱地址",
                                        "Branch name": "分支名稱",
                                    "Requirement": "要求",
                                        "Must": "必須",
                                        "start with a matching pattern": "以匹配規則開頭",
                                        "end with a matching pattern": "以匹配規則結束",
                                        "contain a matching pattern": "包含匹配規則",
                                        "match a given regex pattern": "匹配給定的正則表達式規則",
                                        "Must not": "不得",
                                    "Matching pattern": "匹配規則",
                                    "Description": "描述",
                                        // [/Commit message must start with a matching pattern/, "提交信息必須以匹配規則開頭"],
                                        // [/Commit message must end with a matching pattern/, "提交信息必須以匹配規則結束"],
                                        // [/Commit message must contain with a matching pattern/, "提交信息必須包含匹配規則"],
                                        // [/Commit message must match a given regex pattern/, "提交信息必須匹配給定的正則表達式規則"],
                                        // [/Commit message must not start with a matching pattern/, "提交信息不得以匹配規則開頭"],
                                        // [/Commit message must not end with a matching pattern/, "提交信息不得以匹配規則結束"],
                                        // [/Commit message must not contain a matching pattern/, "提交信息不得包含匹配規則"],
                                        // [/Commit message must not match a given regex pattern/, "提交信息不得匹配給定的正則表達式規則"],

                                        // [/Author email must start with a matching pattern/, "作者電子郵箱地址必須以匹配規則開頭"],
                                        // [/Author email must end with a matching pattern/, "作者電子郵箱地址必須以匹配規則結束"],
                                        // [/Author email must contain a matching pattern/, "作者電子郵箱地址必須包含匹配規則"],
                                        // [/Author email must match a given regex pattern/, "作者電子郵箱地址必須匹配給定的正則表達式規則"],
                                        // [/Author email must not start with a matching pattern/, "作者電子郵箱地址不得以匹配規則開頭"],
                                        // [/Author email must not end with a matching pattern/, "作者電子郵箱地址不得以匹配規則結束"],
                                        // [/Author email must not contain a matching pattern/, "作者電子郵箱地址不得包含匹配規則"],
                                        // [/Author email must not match a given regex pattern/, "作者電子郵箱地址不得匹配給定的正則表達式規則"],

                                        // [/Committer email must start with a matching pattern/, "提交者電子郵箱地址必須以匹配規則開頭"],
                                        // [/Committer email must end with a matching pattern/, "提交者電子郵箱地址必須以匹配規則結束"],
                                        // [/Committer email must contain a matching pattern/, "提交者電子郵箱地址必須包含匹配規則"],
                                        // [/Committer email must match a given regex pattern/, "提交者電子郵箱地址必須匹配給定的正則表達式規則"],
                                        // [/Committer email must not start with a matching pattern/, "提交者電子郵箱地址不得以匹配規則開頭"],
                                        // [/Committer email must not end with a matching pattern/, "提交者電子郵箱地址不得以匹配規則結束"],
                                        // [/Committer email must not contain a matching pattern/, "提交者電子郵箱地址不得包含匹配規則"],
                                        // [/Committer email must not match a given regex pattern/, "提交者電子郵箱地址不得匹配給定的正則表達式規則"],

                                        // [/Branch name must start with a matching pattern/, "分支名稱必須以匹配規則開頭"],
                                        // [/Branch name must end with a matching pattern/, "分支名稱必須以匹配規則結束"],
                                        // [/Branch name must contain a matching pattern/, "分支名稱必須包含匹配規則"],
                                        // [/Branch name must match a given regex pattern/, "分支名稱必須匹配給定的正則表達式規則"],
                                        // [/Branch name must not start with a matching pattern/, "分支名稱不得以匹配規則開頭"],
                                        // [/Branch name must not end with a matching pattern/, "分支名稱不得以匹配規則結束"],
                                        // [/Branch name must not contain a matching pattern/, "分支名稱不得包含匹配規則"],
                                        // [/Branch name must not match a given regex pattern/, "分支名稱不得匹配給定的正則表達式規則"],

                                    "How this rule will appear to your": "這個規則將如何在您的",
                                    "organization": "組織",
                                    "'s users throughout": "內的用戶中顯示",
                "Restrict branch names": "限制分支名",

            "Revert": "撤銷",
            "Reverting...": "撤銷…",
            "changes": "更改",
            "change": "更改",

            // 右下角提示
                "Unauthorized": "未經授權",
                "Ruleset created": "規則集已創建",
                "Changes reverted": "更改已恢復",
                "No changes have been made": "未作任何更改",
                "Invalid rules: 'Required status checks'": "無效規則：“必需的狀態檢查”",
                "This": "此",
                    "does not target any resources and will not be applied.": "未針對任何資源，將不會生效。",
                "Ruleset updated": "規則已更新",


    },
    "regexp": [ // 正則翻譯
        [/Applies to (\d+) target/, "適用於 $1 個目標"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) branch rules? • targeting (\d+) branch(es)?/, "$1 條分支規則 • 針對 $1 個分支"],
        [/(\d+) branch rules?/, "$1 條分支規則"],
        [/(\d+) rules?/, "$1 條規則"],
        [/(\d+) branch(?:es|)?/, "$1 個分支"],
        [/(\d+) tags?/, " $1 個標籤"],
        [/Add '(.*)'/, "添加 $1"],
        [/Commit message must start with a matching pattern/, "提交信息必須以匹配規則開頭"],
        [/Commit message must end with a matching pattern/, "提交信息必須以匹配規則結束"],
        [/Commit message must contain with a matching pattern/, "提交信息必須包含匹配規則"],
        [/Commit message must match a given regex pattern/, "提交信息必須匹配給定的正則表達式規則"],
        [/Commit message must not start with a matching pattern/, "提交信息不得以匹配規則開頭"],
        [/Commit message must not end with a matching pattern/, "提交信息不得以匹配規則結束"],
        [/Commit message must not contain a matching pattern/, "提交信息不得包含匹配規則"],
        [/Commit message must not match a given regex pattern/, "提交信息不得匹配給定的正則表達式規則"],
        [/Author email must start with a matching pattern/, "作者電子郵箱地址必須以匹配規則開頭"],
        [/Author email must end with a matching pattern/, "作者電子郵箱地址必須以匹配規則結束"],
        [/Author email must contain a matching pattern/, "作者電子郵箱地址必須包含匹配規則"],
        [/Author email must match a given regex pattern/, "作者電子郵箱地址必須匹配給定的正則表達式規則"],
        [/Author email must not start with a matching pattern/, "作者電子郵箱地址不得以匹配規則開頭"],
        [/Author email must not end with a matching pattern/, "作者電子郵箱地址不得以匹配規則結束"],
        [/Author email must not contain a matching pattern/, "作者電子郵箱地址不得包含匹配規則"],
        [/Author email must not match a given regex pattern/, "作者電子郵箱地址不得匹配給定的正則表達式規則"],
        [/Committer email must start with a matching pattern/, "提交者電子郵箱地址必須以匹配規則開頭"],
        [/Committer email must end with a matching pattern/, "提交者電子郵箱地址必須以匹配規則結束"],
        [/Committer email must contain a matching pattern/, "提交者電子郵箱地址必須包含匹配規則"],
        [/Committer email must match a given regex pattern/, "提交者電子郵箱地址必須匹配給定的正則表達式規則"],
        [/Committer email must not start with a matching pattern/, "提交者電子郵箱地址不得以匹配規則開頭"],
        [/Committer email must not end with a matching pattern/, "提交者電子郵箱地址不得以匹配規則結束"],
        [/Committer email must not contain a matching pattern/, "提交者電子郵箱地址不得包含匹配規則"],
        [/Committer email must not match a given regex pattern/, "提交者電子郵箱地址不得匹配給定的正則表達式規則"],
        [/Branch name must start with a matching pattern/, "分支名稱必須以匹配規則開頭"],
        [/Branch name must end with a matching pattern/, "分支名稱必須以匹配規則結束"],
        [/Branch name must contain a matching pattern/, "分支名稱必須包含匹配規則"],
        [/Branch name must match a given regex pattern/, "分支名稱必須匹配給定的正則表達式規則"],
        [/Branch name must not start with a matching pattern/, "分支名稱不得以匹配規則開頭"],
        [/Branch name must not end with a matching pattern/, "分支名稱不得以匹配規則結束"],
        [/Branch name must not contain a matching pattern/, "分支名稱不得包含匹配規則"],
        [/Branch name must not match a given regex pattern/, "分支名稱不得匹配給定的正則表達式規則"],
        ...I18N["zh-TW"]["orgs-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Settings · Rulesets?/, "設置 · 規則集"],
        ],
    },
};
I18N["zh-TW"]["orgs/settings/rules"] = I18N["zh-TW"]["repository/settings/rules"];
I18N["zh-TW"]["repository/rules"] = I18N["zh-TW"]["repository/settings/rules"];

I18N["zh-TW"]["repository/settings/actions"] = { // 倉庫設置 - 操作 /<user-name>/<repo-name>/settings/actions
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 操作頁面 /<user-name>/<repo-name>/settings/actions
            "Actions permissions": "操作權限",
                "This setting has been disabled by organization administrators.": "此設置已被組織管理員禁用。", // 組織倉庫
                "Allow all actions and reusable workflows": "允許所有操作和可複用的工作流程",
                    "Any action or reusable workflow can be used, regardless of who authored it or where it is defined.": "可以使用任何操作或可複用的工作流程，而不管它是誰創作的或在哪裡定義的。",
            "Disable actions": "禁用操作",
                "The Actions tab is hidden and no workflows can run.": "“操作” 選項卡將被隱藏，無法運行任何工作流程。",
            // [/Allow ([^ ]+) actions and reusable workflows/, "允許 $1 的操作和可複用的工作流程"],
                // [/Any action or reusable workflow defined in a repository within ([^ ]+) can be used./, "可以使用在 $1 的倉庫中定義的任何操作或可複用的工作流程。"], // 操作頁面
            // [/Allow ([^ ]+), and select non-([^ ]+), actions and reusable workflows/, "允許 $1，並選擇非 $2、操作和可複用的工作流程"],
                // [/Any action or reusable workflow that matches the specified criteria, plus those defined in a repository within ([^ ]+), can be used./, "可以使用符合指定條件的操作或工作流程，以及在 $1 的倉庫中定義的操作或可複用的工作流程。"], // 操作頁面
                "Learn more about allowing specific actions and reusable workflows to run.": "瞭解更多關於允許運行特定操作和可複用的工作流程的信息。",
                "Allow actions created by GitHub": "允許由 GitHub 創建的操作",
                "Allow actions by Marketplace": "允許來自市場的操作，",
                "verified creators": "由經驗證的創建者創建",
                "Allow specified actions and reusable workflows": "允許指定的操作和可複用的工作流程",
                "Enter a comma-separated list of actions and reusable workflows": "輸入以逗號分隔的操作和可複用的工作流程列表",
                "Wildcards, tags, and SHAs are allowed.": "允許使用通配符、標籤和 SHA。",
                "Action examples:": "操作示例：",
                "Reusable workflow examples:": "可複用的工作流程示例：",
                "Entire organization or repository examples:": "整個組織或倉庫的示例：",
                // "Save": "保存",
                // 頂部提醒
                    "Actions policy updated.": "操作政策已更新",
            "Require actions to be pinned to a full-length commit SHA": "要求將操作固定到完整的提交 SHA",

            "Artifact and log retention": "工件和日誌保留",
                "Choose the repository settings for artifacts and logs.": "選擇工件和日誌的倉庫設置。",
                "There is a maximum limit of": "最大限制為",
                "days.": "天。",
                "Your organization has set a maximum limit of": "您的組織已將上限設置為", //組織倉庫
                "Learn more about the artifact and log retention policy.": "瞭解更多關於工件和日誌保留政策的信息。",

                // 輸入框提示
                "Duration must be 1 or more.": "不能小於 1",
                "Duration must be 90 or less": "不能大於 90",
                "There is a maximum limit of": "最多",

                "days": "天",

            "Fork pull request workflows": "複刻拉取請求工作流程",
                "Run workflows from fork pull requests": "從複刻拉取請求運行工作流程",
                    "This tells Actions to run workflows from pull requests originating from repository forks. Note that doing so will give maintainers of those forks the ability to use tokens with read permissions on the source repository.": "這告訴 Actions 運行工作流程，來自倉庫複刻的拉取請求。請注意，這樣做將使這些複刻的維護者有能力在源碼庫上使用具有讀取權限的令牌。",
                "Send write tokens to workflows from fork pull requests.": "從複刻拉取請求，發送可寫令牌到工作流程",
                    "This tells Actions to send tokens with": "這告訴 Actions 發送令牌",
                    "write": "寫入",
                    "permissions to workflows from pull requests originating from repository forks. Note that doing so will give maintainers of those forks": "權限到工作流程，來自倉庫複刻的拉取請求。請注意，這樣做將授予這些複刻的維護者",
                    "permissions against the source repository.": "權限，針對源倉庫。",
                "Send secrets to workflows from fork pull requests.": "從複刻拉取請求，發送機密到工作流程",
                    "This tells Actions to send repository secrets to workflows from pull requests originating from repository forks.": "這告訴 Actions 發送倉庫機密到工作流程，來自倉庫複刻的拉取請求。",

            "Approval for running fork pull request workflows from contributors": "允許貢獻者運行複刻拉取請求工作流",
                "Choose which subset of users will require approval before running workflows on their pull requests. Both the pull request author and the actor of the pull request event triggering the workflow will be checked to determine if approval is required. If approval is required, a user with write access to the repository must": "選擇在拉取請求上運行工作流之前需要批准的用戶子集。將檢查拉取請求作者和觸發工作流的拉取請求事件的行為者，以確定是否需要批准。如果需要批准，則必須由具有寫權限的用戶",
                "approve the pull request workflow to be run.": "批准才能運行拉取請求工作流。",
            "Fork pull request workflows from outside collaborators": "從外部協作者，複刻拉取請求工作流程",
                "Choose which subset of outside collaborators will require approval to run workflows on their pull requests.": "選擇哪些外部協作者的子集需要批准才能對他們的拉取請求運行工作流程。",
                "Learn more about approving workflow runs from public forks.": "瞭解更多關於批准來自公共複刻的工作流運行的信息。",
            "Require approval for first-time contributors who are new to GitHub": "要求對首次加入 GitHub 的貢獻者進行批准審查",
                "Only first-time contributors who recently created a GitHub account will require approval to run workflows.": "只有最近創建 GitHub 賬戶的首次貢獻者才需要獲得批准才能運行工作流程。",
                "Only users who are both new on GitHub and who have never had a commit or pull request merged into this repository will require approval to run workflows.": "只有新加入 GitHub 和從未有提交或拉取請求合併到該倉庫的用戶才需要批准運行工作流。",
            "Require approval for first-time contributors": "要求對首次貢獻者進行批准審查",
                "Only first-time contributors will require approval to run workflows.": "只有首次貢獻者才需要獲得批准才能運行工作流程。",
                "Only users who have never had a commit or pull request merged into this repository will require approval to run workflows.": "只有從未有提交或拉動請求合併到該倉庫的用戶才需要批准運行工作流。",
            "Require approval for all outside collaborators": "要求對所有外部協作者進行批准審查",
                "All outside collaborators will always require approval to run workflows on their pull requests.": "所有外部協作者將始終需要批准才能在他們的拉取請求上運行工作流程。",
            "Require approval for all external contributors": "要求對所有外部貢獻者進行批准審查",
                "All users that are not a member or owner of this repository will require approval to run workflows.": "所有不是該倉庫成員或所有者的用戶，均需獲得批准才能運行工作流。",
                // [/All users that are not a member or owner of this repository and not a member of the ([^ ]+) organization will require approval to run workflows./, "所有不是該倉庫成員或所有者，且未加入 $1 組織的用戶，均需獲得批准才能運行工作流。"], // 組織

            "Workflow permissions": "工作流程權限",
                "Choose the default permissions granted to the GITHUB_TOKEN when running workflows in this repository. You can specify more granular permissions in the workflow using YAML.": "在倉庫中運行工作流程時，選擇授予 GITHUB_TOKEN 的默認權限。您可以使用 YAML 在工作流程中指定更細化的權限。",
                "Learn more about managing permissions.": "瞭解更多關於管理權限的信息。",
                "Read and write permissions": "讀取和寫入權限",
                    "Workflows have read and write permissions in the repository for all scopes.": "工作流程在倉庫中對所有作用域具有讀和寫的權限。",
                "Read repository contents and packages permissions": "讀取倉庫的內容和軟體包的權限",
                    "Workflows have read permissions in the repository for the contents and packages scopes only.": "工作流程在倉庫中僅對內容和軟體包作用域具有只讀的權限。",
                    "Choose whether GitHub Actions can create pull requests or submit approving pull request reviews.": "選擇 GitHub Actions 是否可以創建拉取請求或提交批准拉取請求審查。",
                        "Allow GitHub Actions to create and approve pull requests": "允許 GitHub Actions 創建和批准拉取請求",

                // 頂部提醒
                    "Default workflow permissions settings saved.": "已保存默認工作流程權限設置。",

        // 運行器頁面 /<user-name>/<repo-name>/settings/actions/runners
            "New self-hosted runner": "新建自託管運行器",
            "Host your own runners and customize the environment used to run jobs in your GitHub Actions workflows.": "託管您自己的運行器，並定製用於在您的 GitHub Actions 工作流程中運行作業的環境。",
            "Learn more about self-hosted runners": "瞭解更多關於自託管運行器的信息",
            "There are no runners configured": "暫無設置運行器",
            "Learn more about using runners": "瞭解更多關於使用運行器的信息",
            "to run actions on your own servers.": "在您自己的服務器上運行操作的信息。",

        // 創建運行器頁面 /<user-name>/<repo-name>/settings/actions/runners/new
            // [/\/ Add new self-hosted runner ·/, "/ 創建自託管運行器 ·"],
            "Adding a self-hosted runner requires that you download, configure, and execute the GitHub Actions Runner. By downloading and configuring the GitHub Actions Runner, you agree to the": "添加一個自託管運行器需要您下載、配置並執行 GitHub Actions 運行器。下載並配置 GitHub Actions 運行器 後，您同意",
                "GitHub Terms of Service": "GitHub 服務條款",
                "GitHub Corporate Terms of Service": "GitHub 企業服務條款",
                ", as applicable.": "，如適用。",
            "Runner image": "運行器鏡像",
            "Architecture": "架構",
            "Download": "下載",
            "We recommend configuring the runner under \"\\actions-runner\". This will help avoid issues related to service identity folder permissions and long path restrictions on Windows.": "我們建議在 “\\actions-runner” 下配置運行器。這將有助於避免與 Windows 上的服務標識文件夾權限和長路徑限制相關的議題。",
            "Configure": "設置",
            "Using your self-hosted runner": "使用您的自託管運行器",
            "For additional details about configuring, running, or shutting down the runner, please check out our": "關於配置、運行或關閉運行器的其他細節，請查看我們的",
            "product docs": "產品文檔",
            "Add new self-hosted runner": "添加新的自託管運行器",
            "Using self-hosted runners in public repositories is not recommended.": "在公共倉庫中使用自託管運行器不推薦。",
            "Forks of your public repository can potentially run dangerous code on your self-hosted runner by creating a pull request.": "公共倉庫的複刻可以潛在地在您的自託管運行器上運行危險程式碼，通過創建拉取請求。",
            "Learn more about security hardening for self-hosted runners": "瞭解更多關於自託管運行器的安全強化",
            "Adding a self-hosted runner requires that you download, configure, and execute the GitHub Actions Runner. If you do not already have an existing volume licensing agreement for your GitHub purchases, by downloading and configuring the GitHub Actions Runner, you agree to the": "添加一個自託管運行器需要您下載、配置並執行 GitHub Actions 運行器。如果您還沒有現有的 GitHub 購買量許可證協議，通過下載並配置 GitHub 操作運行器，您同意",
            "GitHub Customer Agreement": "GitHub 客戶協議",

    },
    "regexp": [ // 正則翻譯
        [/\/ Add new self-hosted runner ·/, "/ 創建自託管運行器 ·"],
        [/Allow ([^ ]+) actions and reusable workflows/, "允許 $1 的操作和可複用的工作流程"],
        [/Any action or reusable workflow defined in a repository within ([^ ]+) can be used./, "可以使用在 $1 的倉庫中定義的任何操作或可複用的工作流程。"], // 操作頁面
        [/Allow ([^ ]+), and select non-([^ ]+), actions and reusable workflows/, "允許 $1，並選擇非 $2、操作和可複用的工作流程"],
        [/Any action or reusable workflow that matches the specified criteria, plus those defined in a repository within ([^ ]+), can be used./, "可以使用符合指定條件的操作或工作流程，以及在 $1 的倉庫中定義的操作或可複用的工作流程。"], // 操作頁面
        [/All users that are not a member or owner of this repository and not a member of the ([^ ]+) organization will require approval to run workflows./, "所有不是該倉庫成員或所有者，且未加入 $1 組織的用戶，均需獲得批准才能運行工作流。"], // 組織
        [/Add new self-hosted runner · (.+)/, "添加自託管運行器 · $1"],
        ...I18N["zh-TW"]["repository-public"]["regexp"],
    ],
    "title": {
        "regexp": [
            [/Actions settings/, "操作設置"],
            [/Runners/, "運行器"],
            [/Add new self-hosted runner/, "添加自託管運行器"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/models/access-policy"] = { // 倉庫設置 - 模型 /<user-name>/<repo-name>/settings/models/access-policy
    "static": {
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"],

        //"Models": "模型",

        "Models in this repository": "此倉庫模型",
            "If disabled, the Models tab will be hidden, and the prompt editor and comparison tooling evaluations will be unavailable.": "如果禁用，模型選項卡將被隱藏，提示編輯器和對比工具評估也將不可用。",
            "Learn more about Models.": "瞭解更多。",
    },
    "regexp": [],
    "title": {
        "regexp": [
            [/settings · GitHub Models access policy/, "設置 · GitHub 模型訪問政策"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/hooks"] = { // 倉庫設置 - Web 鉤子 /<user-name>/<repo-name>/settings/hooks
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"],

        // Web 鉤子 頁面 /<user-name>/<repo-name>/settings/hooks====================================
            "Add webhook": "添加 Web 鉤子",
            "Webhooks allow external services to be notified when certain events happen. When the specified events happen, we'll send a POST request to each of the URLs you provide. Learn more in our": "Web 鉤子允許在發生某些事件時通知外部服務。當指定的事件發生時，我們將向您提供的每個 URL 發送 POST 請求。瞭解更多信息，在我們的",
            "Webhooks Guide": "Web 鉤子指南",

            "We will also send events from this repository to your": "我們還將把這個倉庫的事件發送到您的", // 組織倉庫
            "organization webhooks": "組織 Web 鉤子", // 組織倉庫

            "This hook has never been triggered.": "此鉤子從未被觸發過。",
            "Last delivery was successful.": "上次觸發成功。",

            // 刪除對話框
                "Delete webhook?": "刪除 Web 鉤子？",
                "This action cannot be undone. Future events will no longer be delivered to this webhook": "此操作無法撤消。未來的事件將不再傳遞到此 Web 鉤子",
                "Yes, delete webhook": "是的，刪除 Web 鉤子",

        // 添加鉤子 頁面 /<user-name>/<repo-name>/settings/hooks/new ====================================
            "Webhooks /": "Web 鉤子 /",
            "Add webhook": "添加 Web 鉤子",
            "We'll send a": "我們將",
            "request to the URL below with details of any subscribed events. You can also specify which data format you'd like to receive (JSON,": "請求到以下 URL，其中包含任何訂閱事件的詳細信息。您還可以指定要接收的數據格式（JSON、",
            "etc": "等",
            "). More information can be found in": "）。更多信息可以在",
            "our developer documentation": "開發人員文檔",

            "Payload URL": "有效負載 URL",
            "Content type": "內容類型",
            "Secret": "機密",
                "Leave blank to remove secret": "留空以刪除機密",
            "There is currently a secret configured for this webhook. If you've lost or forgotten this secret, you can change it, but be aware that any integrations using this secret will need to be updated.": "目前 Web 鉤子已配置了一個機密。如果您丟失或忘記了這個機密，可以更改它，但請注意，任何使用此機密的集成將需要更新",
            "Change secret": "修改機密",

            "SSL verification": "SSL 驗證",
            "By default, we verify SSL certificates when delivering payloads.": "默認情況下，我們在交付有效負載時驗證 SSL 證書。",
            "Enable SSL verification": "啟用 SSL 驗證",
            "Disable": "禁用",
            "(not recommended)": "（不推薦）",
                "Are you sure?": "您確定嗎？",
                "Warning": "警告",
                ": Disabling SSL verification has serious implications.": "：禁用 SSL 驗證具有嚴重的影響。",
                "SSL verification helps ensure that hook payloads are delivered to your URL endpoint securely, keeping your data away from prying eyes. Disabling this option is": "SSL 驗證有助於確保鉤子有效負載安全地傳送到您的 URL 端點，使您的數據遠離窺探。禁用此選項是",
                "not recommended": "不推薦的",
                "Disable, I understand my webhooks may not be secure": "禁用，我明白我的 web 鉤子可能不安全",

            "Which events would you like to trigger this webhook?": "您希望哪些事件觸發此 Web 鉤子？",
                "Just the": "僅",
                "push": "推送",
                "event.": "事件。",
                "Send me": "發送給我",
                "everything": "所有",
                "Let me select individual events.": "讓我選擇單個事件。",
                    "Branch or tag creation": "分支或標籤創建",
                        "Branch or tag created.": "分支或標籤的創建。",
                    "Branch or tag deletion": "分支或標籤刪除",
                        "Branch or tag deleted.": "分支或標籤的刪除。",
                    "Branch protection configurations": "分支保護配置",
                        "All branch protections disabled or enabled for a repository.": "禁用或啟用倉庫的所有分支保護。",
                    "Branch protection rules": "分支保護規則",
                        "Branch protection rule created, deleted or edited.": "分支保護規則的創建、刪除或編輯。",
                    "Bypass requests for push rulesets": "繞過推送規則集的請求",
                        "Push ruleset bypass request was created, cancelled, completed, received a response, or a response was dismissed.": "推送規則集旁路請求已創建、取消、完成、收到回覆或回覆被駁回。",
                    "Bypass requests for secret scanning push protections": "繞過機密掃描推送保護請求",
                        "Secret scanning push protection bypass request was created, cancelled, completed, received a response, or a response was dismissed. Note: Delegated bypass for push protection is currently in beta and subject to change.": "機密掃描推送保護旁路請求的創建、取消、完成、收到回覆或回覆被駁回。注意：推送保護的委託旁路目前處於測試階段，可能會有更改。",
                    "Check runs": "檢查運行",
                        "Check run is created, requested, rerequested, or completed.": "檢查運行的創建、請求、重新請求或完成。",
                    "Check suites": "檢查套件",
                        "Check suite is requested, rerequested, or completed.": "檢查套件的請求、重新請求或完成。",
                    "Code scanning alerts": "程式碼掃描警報",
                        "Code Scanning alert created, fixed in branch, or closed": "程式碼掃描警報的創建、在分支中的修復或關閉。",
                    "Collaborator add, remove, or changed": "協作者的添加、刪除或更改",
                        "Collaborator added to, removed from, or has changed permissions for a repository.": "協作者添加到倉庫、從倉庫中刪除或更改了倉庫的權限。",
                    "Commit comments": "提交評論",
                        "Commit or diff commented on.": "提交或差異評論。",
                    "Custom property": "自定義屬性",
                        "Custom property is created, updated, or deleted.": "自定義屬性的創建、更新或刪除。",
                    "Custom property values": "自定義屬性值",
                        "Custom property values are changed for a repository": "倉庫自定義屬性值的更改。",
                    "Dependabot alerts": "Dependabot 警報",
                        "Dependabot alert auto_dismissed, auto_reopened, created, dismissed, reopened, fixed, or reintroduced.": "Dependabot 警報自動解除、自動重新打開、創建、解除、重新打開、修復或重新引入。",
                    "Deploy keys": "部署密鑰",
                        "A deploy key is created or deleted from a repository.": "在倉庫中部署密鑰的創建或刪除。",
                    "Deployment statuses": "部署狀態",
                        "Deployment status updated from the API.": "通過 API 更新部署狀態。",
                    "Deployments": "部署",
                        "Repository was deployed or a deployment was deleted.": "倉庫的部署或刪除部署。",
                    "Discussion comments": "討論評論",
                        "Discussion comment created, edited, or deleted.": "討論評論的創建、編輯或刪除。",
                    // "Discussion": "討論",
                        "Discussion created, edited, closed, reopened, pinned, unpinned, locked, unlocked, transferred, answered, unanswered, labeled, unlabeled, had its category changed, or was deleted.": "討論的創建、編輯、關閉、重新打開、置頂、取消置頂、鎖定、解鎖、轉移、答覆、取消答覆、標記、取消標記、更改其類別或刪除。",
                    "Forks": "複刻",
                        "Repository forked.": "倉庫複刻。",
                    "Issue comments": "議題評論",
                        "Issue comment created, edited, or deleted.": "議題評論的創建、編輯或刪除。",
                    // "Issue": "議題",
                        "Issue opened, edited, deleted, transferred, pinned, unpinned, closed, reopened, assigned, unassigned, labeled, unlabeled, milestoned, demilestoned, locked, or unlocked.": "議題的打開、編輯、刪除、轉移、置頂、取消置頂、關閉、重新打開、分配、取消分配、標記、取消標記、設置里程碑、取消里程碑、鎖定或解鎖。",
                    "Labels": "標籤",
                        "Label created, edited or deleted.": "標籤的創建、編輯或刪除。",
                    "Memberships": "團隊成員", // 組織設置
                        "Team membership added or removed.": "團隊成員的添加或刪除。",
                    "Merge groups": "合併組",
                        "Merge Group requested checks, or was destroyed.": "合併組的請求檢查或銷燬。",
                    "Meta": "元數據",
                        "This particular hook is deleted.": "這個特定的鉤子被刪除。",
                    "Milestones": "里程碑",
                        "Milestone created, closed, opened, edited, or deleted.": "里程碑的創建、關閉、打開、編輯或刪除。",
                    "Org blocks": "組織黑名單", // 組織設置
                        "A user has been blocked or unblocked.": "用戶拉黑或解除拉黑。",
                    "Organizations": "組織", // 組織設置
                        "Organization deleted, renamed, member invited, member added, or member removed.": "組織的刪除、重命名以及成員的邀請、添加或刪除。",
                    // "Packages": "軟體包",
                        "GitHub Packages published or updated in a repository.": "倉庫中 GitHub 軟體包的發佈或更新 。",
                    "Page builds": "構建 GitHub Pages",
                        "Pages site built.": "GitHub Pages 站點的建立。",
                    "Project cards": "專案面板卡",
                        "Project card created, updated, or deleted.": "專案面板卡的創建、更新或刪除。",
                    "Project columns": "專案欄目",
                        "Project column created, updated, moved or deleted.": "專案列目的創建、更新、移動或刪除。",
                    "Project v2 items": "專案項 v2", // 組織設置
                        "Project item created, edited, deleted, archived, restored, converted, or reordered. Feedback is welcome in": "專案條目的創建、編輯、刪除、歸檔、恢復、轉換或重新排序。歡迎提供反饋意見在",
                        "this discussion": "這個討論",
                    // "": "專案",
                        "Project created, updated, or deleted.": "專案的創建、更新或刪除。",
                    "Projects v2": "專案 v2", // 組織設置
                        "Project created, updated, deleted, closed, or reopened. Feedback is welcome in": "專案的創建、更新、刪除、關閉或重新打開。歡迎提供反饋意見在",
                    "Pull request review comments": "拉取請求審查意見",
                        "Pull request diff comment created, edited, or deleted.": "拉取請求差異評論的創建、編輯或刪除。",
                    "Pull request review threads": "拉取請求的審查線程",
                        "A pull request review thread was resolved or unresolved.": "拉取請求的審查線程的解決或未解決。",
                    "Pull request reviews": "拉取請求審查",
                        "Pull request review submitted, edited, or dismissed.": "拉取請求審查的提交、編輯或駁回。",
                    // "": "拉取請求",
                        "Pull request assigned, auto merge disabled, auto merge enabled, closed, converted to draft, demilestoned, dequeued, edited, enqueued, labeled, locked, milestoned, opened, ready for review, reopened, review request removed, review requested, synchronized, unassigned, unlabeled, or unlocked.": "拉取請求的分配、禁用自動合併、啟用自動合併、關閉、轉換為草案、取消里程碑、取消隊列、編輯、隊列、標記、鎖定、設置里程碑、打開、準備審查、重新打開、取消審查請求、請求審查、同步、取消分配、取消標記或解鎖。",
                    "Pushes": "推送",
                        "Git push to a repository.": "Git 推送到倉庫。",
                    "Registry packages": "註冊軟體包",
                        "Registry package published or updated in a repository.": "倉庫中註冊軟體包的發佈或更新。",
                    "Releases": "發行版",
                        "Release created, edited, published, unpublished, or deleted.": "發行版的創建、編輯、發佈、取消發佈或刪除。",
                    // "": "倉庫",
                        "Repository created, deleted, archived, unarchived, publicized, privatized, edited, renamed, or transferred.": "倉庫的創建、刪除、歸檔、取消歸檔、公開、私有化、編輯、重命名或轉讓。",
                    "Repository advisories": "倉庫公告",
                        "Repository advisory published or reported.": "倉庫公告發布或報告。",
                    "Repository imports": "倉庫導入",
                        "Repository import succeeded, failed, or cancelled.": "倉庫導入的成功、失敗或取消。",
                    "Repository rulesets": "倉庫規則集",
                        "Repository ruleset created, deleted or edited.": "倉庫規則集的創建、刪除或編輯。",
                    "Repository vulnerability alerts": "倉庫漏洞警報",
                        "Dependabot alert (aka dependency vulnerability alert) created, resolved, or dismissed on a repository.": "Dependabot 警報（又名依賴漏洞警報）在倉庫上的創建、解決或解除。",
                    "Secret scanning alert locations": "機密掃描警報位置",
                        "Secrets scanning alert location created.": "機密掃描警報位置的創建。",
                    "Secret scanning alerts": "機密掃描警報",
                        "Secrets scanning alert created, resolved, reopened, validated, or publicly leaked.": "機密掃描警報的創建、解決、重新打開、驗證或公開洩露。",
                    "Security and analyses": "安全和分析",
                        "Code security features enabled or disabled for a repository.": "啟用或禁用倉庫的程式碼安全功能。",
                    "Secret scanning scans": "機密掃描",
                        "Secrets scanning scan completed.": "機密掃描已完成",
                    // "": "星標",
                        "A star is created or deleted from a repository.": "標星或取消倉庫星標。",
                    "Statuses": "狀態",
                        "Commit status updated from the API.": "通過 API 更新提交狀態。",
                    "Team adds": "團隊添加",
                        "Team added or modified on a repository.": "在倉庫上添加或修改的團隊。",
                    "Teams": "團隊",  // 組織設置
                        "Team is created, deleted, edited, or added to/removed from a repository.": "團隊的創建、刪除、編輯以及向倉庫添加團隊、從倉庫中移除團隊。",
                    "Visibility changes": "可見性變化",
                        "Repository changes from private to public.": "倉庫從私有更改為公共。",
                    "Watches": "關注",
                        "User stars a repository.": "用戶標星倉庫。",
                    "Wiki": "",
                        "Wiki page updated.": "Wiki 頁面的更新。",
                    "Workflow jobs": "工作流程作業",
                        "Workflow job queued, waiting, in progress, or completed on a repository.": "倉庫中工作流作業的隊列、等待、正在進行或完成。",
                    "Workflow runs": "工作流程運行",
                        "Workflow run requested or completed on a repository.": "倉庫中工作流程運行的請求或完成。",
                "Active": "激活",
                "We will deliver event details when this hook is triggered.": "當鉤子被觸發時，我們將提供事件詳細信息。",

            // 頂部提醒
            "Okay, that hook was successfully created. We sent a ping payload to test it out! Read more about it at https://docs.github.com/webhooks/#ping-event.": "好的，這個鉤子已經成功創建。我們發送了一個 ping 負載來測試它! 閱讀更多關於它的信息，請訪問 https://docs.github.com/webhooks/#ping-event。",

        // 管理 鉤子 /<user-name>/<repo-name>/settings/hooks/<id>
            "Manage webhook": "管理 Web 鉤子",
            "If you've lost or forgotten this secret, you can change it, but be aware that any integrations using this secret will need to be updated. —": "如果您丟失或忘記了此機密，則可以更改它，但請注意，使用此機密的任何集成都需要更新。 —",
            "Change Secret": "更改機密",
            "Update webhook": "更新 Web 鉤子",
            // 頂部提醒
                "Okay, the hook was successfully updated.": "好的，Web 鉤子已經成功更新。",
            "Delete webhook": "刪除 Web 鉤子",

        // 最近交付標籤 /<user-name>/<repo-name>/settings/hooks/<id>?tab=deliveries
            "Recent Deliveries": "最近交付",
                "redelivery": "再交付",
            "Loading deliveries…": "載入交付…",
            "Detailed delivery information will be shown here once the hook has been triggered.": "一旦觸發鉤子，詳細的交付信息將在此處顯示。",

            "Request": "請求",
            "Response": "應答",
            "Redeliver": "重新交付",
                "Redeliver payload?": "重新交付有效負載？",
                "The payload will be delivered to": "該有效負載將被發送到",
                "using the current webhook configuration.": "使用當前的 Web 鉤子 配置。",
                "Yes, redeliver this payload": "是的，重新發送此有效負載",
                    "Delivering payload…": "交付有效載荷…",
    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/Completed in (\d+(\.\d+)) seconds?./, "在 $1 秒內完成。"],
    ],
    "title": {
        "static": {
            "Add webhook": "添加 Web 鉤子",
        },
        "regexp": [
            [/Webhooks · Settings/, "Web 鉤子 · 設置"],
        ],
    },
};
I18N["zh-TW"]["orgs/settings/hooks"] = I18N["zh-TW"]["repository/settings/hooks"];

I18N["zh-TW"]["repository/settings/copilot/code_review"] = {
    "static": {
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"],

        // 程式碼審查
            "Enable automatic code review": "啟用自動程式碼審查",
                "You can enable Copilot to automatically review pull requests by enabling it inside Repository rules.": "您可以在倉庫規則中啟用 Copilot，從而讓 Copilot 自動審查拉取請求。",
                "Learn more about automatic code reviews.": "瞭解更多關於自動程式碼生成的信息。",
                "Go to repository rules": "前往倉庫規則",

        "General settings": "常規設置",
            "Use custom instructions when reviewing pull requests": "在審查拉取請求時使用自定義指令",
                "Copilot references": "Copilot 在審查拉取請求時會參考",
                "repository custom instructions": "倉庫自定義指令",
                "when reviewing pull requests.": "。",

        "With Copilot code review, you can add Copilot as a reviewer to your pull requests, including drafts. You can also select lines in Visual Studio Code and ask Copilot to review and comment on specific sections.": "使用 Copilot 程式碼審查，您可以將 Copilot 添加為拉取請求的審查者，包括草稿。您還可以在 Visual Studio Code 中選擇行，並請求 Copilot 審查和評論特定部分。",
        "Learn more about Copilot code reviews.": "瞭解更多關於 Copilot 程式碼審查的信息。",

        "Automated code reviews using rulesets": "使用規則集自動程式碼審查",
            "Use rulesets to configure Copilot to review pull requests automatically.": "使用規則集配置 Copilot 自動審查拉取請求。",
            "Learn how to set up rulesets.": "瞭解如何設置規則集。",

        "Go to rulesets": "前往規則集",
        "No rulesets set up for automated reviews": "尚無設置自動程式碼審查的規則集",
        "Create a ruleset to automate code reviews for pull requests targeting your default branch": "創建一個規則集，自動程式碼審查針對您的默認分支的拉取請求",
        "Create ruleset for default branch": "創建針對默認分支的規則集",
    },
    "regexp": [
        // 1 repository ruleset
        [/(\d+) repository rulesets?/, "$1 倉庫規則集"],
        // 3 branch rules • targeting 1 branch
        [/(\d+) branch rules? • targeting (\d+) branch(?:es)?/, "$1 分支規則 • 針對 $2 分支"],
    ],
    "title": {
        "regexp": [
            [/Settings · Code review/, "設置 · 程式碼審查"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/copilot/coding_agent"] = {
    "static": {
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],
        ...I18N["zh-TW"]["orgs-settings-menu"]["static"],

        "Copilot coding agent": "Copilot 編程智能體",

        "You can configure Copilot coding agent for other users with access to this repository, but you won't be able to assign tasks to Copilot because you don't have a Copilot Pro+ or Copilot Enterprise license.": "您可以為其他具有此倉庫訪問權限的用戶配置 Copilot 編程智能體，但由於您沒有 Copilot Pro+ 或 Copilot 企業版許可證，因此無法向 Copilot 分配任務。",

        "With Copilot coding agent, developers can delegate tasks to Copilot, freeing them to focus on the creative, complex, and high-impact work that matters most. Simply assign an issue to Copilot, wait for the agent to request review, then leave feedback on the pull request to iterate. To learn more, see the": "使用 Copilot 編程智能體，開發者可以將任務委託給 Copilot，從而專注於更具創造性、複雜性和高影響力的重要工作。只需將議題分配給 Copilot，等待助手發起評審請求，然後在拉取請求上留下反饋進行迭代。更多信息請參閱",
        "With Copilot coding agent, developers can delegate tasks to Copilot, freeing them to focus on the creative, complex, and high-impact work that matters most. Assign an issue to Copilot, wait for the agent to request review, then leave feedback on the pull request to iterate.": "藉助 Copilot 編程智能體，開發者可以將任務委託給 Copilot，從而有更多時間專注於最重要的創造性、複雜和高影響力的工作。只需將議題分配給 Copilot，等待請求程式碼審查，然後在拉取請求上留下反饋，進行迭代即可。",
        "Learn more about Copilot coding agent": "瞭解更多",

        "Internet access": "訪問互聯網",
            "Ensure that the agent only accesses approved network resources during code generation and execution.": "確保智能體在程式碼生成和執行過程中只訪問已批准的網絡資源。",
                "Learn more about customizing network access": "瞭解更多",

            "Enable firewall": "啟用防火牆",
                "Recommended": "推薦",
                "Limit Copilot coding agent’s Internet access to only allow access to allowlisted locations": "將 Copilot 編程智能體的互聯網訪問權限限制為僅允許訪問白名單中的位置。",
            "Recommended allowlist": "推薦白名單",
                "Allow access to locations frequently used to install tools, packages, and dependencies": "允許訪問常用於安裝工具、軟體包和依賴項的位置",
            "Custom allowlist": "自定義白名單",
                "Allow access to specific domains, IP addresses, or URLs.": "允許訪問特定域名、IP 地址或 URL。",

            // settings/copilot/coding_agent/allowlist 自定義白名單
                "Add items to the allowlist to enable Copilot coding agent to access specific domains, IP addresses, or URLs.": "將專案添加到允許列表，以便 Copilot 智能體能夠訪問特定的域名、IP 地址或 URL。",
                    "See the GitHub Docs for syntax and examples.": "請參閱 GitHub 文檔以獲取語法和示例。",

                "e.g. https://example.com/a/path or example.com": "例：https://example.com/a/path 或 example.com",
                "Add rule": "添加規則",
                "Rule must be a valid domain, IP address, or URL": "規則必須是有效域名、IP 地址或 URL",

                "No rules yet": "無規則",
                    "Tip: Paste a list of rules into the input to add them all at once.": "提示：將規則列表粘貼到輸入框中，可以一次性添加所有規則。",
                "Delete rule": "刪除規則",

                // 保存
                    "Allowlist settings saved successfully!": "白名單設置保存成功！",

        "Model Context Protocol (MCP)": "模型上下文協議（MCP）",
            "The MCP is an open standard that defines how applications share context with large language models (LLMs). MCP provides a standardized way to connect AI models to different data sources and tools, enabling them to work together more effectively.": "MCP 是一個開放標準，定義了應用程式如何與大型語言模型（LLM）共享上下文。MCP 提供了一種標準化的方法，將 AI 模型與不同的數據源和工具連接起來，使它們能夠更高效地協同工作。",
            "You can use MCP to extend the capabilities of Copilot coding agent by connecting it to other tools and services. For information on how to write your JSON MCP configuration, see the": "您可以使用 MCP 通過將其連接到其他工具和服務，來擴展 Copilot 編程智能體的功能。有關如何編寫您的 JSON MCP 配置的詳細信息，請參見",
            "You can use MCP to extend the capabilities of Copilot coding agent by connecting it to other tools and services.": "您可以使用 MCP 通過將其連接到其他工具和服務，來擴展 Copilot 編程智能體的功能。",
                "Learn how to write your JSON MCP configuration": "瞭解如何編寫您的 JSON MCP 配置",

            "MCP configuration": "MCP 配置",
                // 程式碼窗 - 底部欄
                  "to toggle the": "切換",
                  "key moving focus. Alternatively, use": "鍵移動對焦。或者使用",
                  "then": "鍵，然後",
                  "to move to the next interactive element on the page.": "鍵移動到頁面上的下一個交互元素。",

            "Your configuration will be validated on save.": "您的配置將在保存時進行驗證。",

            "Save MCP configuration": "保存",

            "Use of Copilot coding agent is subject to the": "使用 Copilot 編程智能體需遵守",
                "pre-release terms": "預發行條款",
    },
    "regexp": [
        [/(\d+) rules?/, "$1 規則"],
    ],
    "title": {
        "static": {
            "Copilot coding agent": "Copilot 編程智能體",
        },
    },
};

I18N["zh-TW"]["repository/settings/environments"] = { // 倉庫設置 - 環境 /<user-name>/<repo-name>/settings/environment
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 倉庫 環境 /<user-name>/<repo-name>/settings/environments
            "New environment": "新建環境",
            "You can configure environments with protection rules, variables, and secrets.": "您可以使用保護規則，變量和機密配置環境。",
            "Learn more about configuring environments.": "瞭解更多關於配置環境的信息。",

            "There are no environments for this repository": "此倉庫尚無環境",
            "Environments are used by your workflows for deployments.": "您的工作流程使用環境進行部署。",
            "You can configure environments with protection rules and secrets.": "您可以使用保護規則和機密配置環境。",

            "Delete environment": "刪除環境",
            // 刪除環境對話框
            "Are you sure you want to delete this environment?": "您確定要刪除此環境嗎？",
                "Deleting an environment will delete all associated secrets, variables, and protection rules.": "刪除環境將刪除所有關聯的機密、變量和保護規則。",
                "I understand, delete this environment": "我明白了，依然刪除這個環境",
            // 頂部提醒
                "Environment deleted.": "環境已刪除。",
                "There was an error saving your new environment.": "保存新環境時出錯。",

        // 倉庫 新建環境 /<user-name>/<repo-name>/settings/environments/new
            "/ Add": "/ 添加",
            "Name": "名稱",
            "Configure environment": "設置環境",
            "Name can't be blank": "名稱不能為空",

        // 編輯環境 /<user-name>/<repo-name>/settings/environments/<id>/edit
            // 頂部提醒
                // [/Environment \"([^ ]+)\" created./, "環境 “$1” 已創建。"],
                // [/Environment \"([^ ]+)\" updated./, "環境 “$1” 已更新。"],

            "/ Configure": "/ 設置",

            "Deployment protection rules": "部署保護規則",
                "Configure reviewers, timers, and custom rules that must pass before deployments to this environment can proceed.": "配置審查者、計時器和自定義規則，在繼續部署到此環境之前必須通過這些規則。",

                "Required reviewers": "所需的審查者",
                    "Specify people or teams that may approve workflow runs when they access this environment.": "指定訪問此環境時可以批准工作流運行的人員或團隊。",
                        "Add up to": "最多添加",
                        "more": " ",
                        "reviewers": "位審查者",
                        "Search for people or teams...": "搜索人員或團隊…",

                    "Prevent self-review": "防止自我審查",
                        "Require a different approver than the user who triggered the workflow run.": "要求與觸發工作流程運行的用戶不同的批准審查者。",
                "Wait timer": "等待計時器",
                    "Set an amount of time to wait before allowing deployments to proceed.": "設置允許部署繼續之前等待的時間。",
                    "minutes": "分鐘",
                "Enable custom rules with GitHub Apps": "使用 GitHub Apps 啟用自定義規則",
                    "Learn about existing apps": "瞭解現有應用",
                    "create your own protection rules": "創建您自己的保護規則",
                    "so you can deploy with confidence.": "以便您可以放心地進行部署。",
                "Allow administrators to bypass configured protection rules": "允許管理員繞過配置的保護規則",
                "Save protection rules": "保存保護規則",

            "Deployment branches and tags": "部署分支和標籤",
                "Limit which branches and tags can deploy to this environment based on rules or naming patterns.": "根據規則或命名模式限制哪些分支和標籤可以部署到此環境。",
                "No restriction": "沒有限制",
                    "No restriction to which branch or tag from this repository can deploy.": "不限制倉庫中的分支或標籤進行部署。",
                "Protected branches only": "僅受保護的分支",
                    "Deployment limited to branches with protection rules.": "部署僅限於具有保護規則的分支。",
                "Selected branches and tags": "選中的分支和標籤",
                    "Specify a list of branches and tags using naming patterns.": "使用命名模式指定分支和標籤的列表。",

                "Applies to": "適用於",
                // [/(\d+) branch(?:es|)/, "$1 個分支"],
                ". Based on the existing": "。基於已有的",
                "repository branch protection rules": "倉庫分支保護規則",
                // [/Currently applies to (\d+) branch(?:es|)/, "目前適用於 $1 個分支"],

                "No branch or tag rules applied yet:": "尚未應用分支或標籤規則：",
                "all branches and tags are still allowed to deploy.": "仍允許所有分支和標籤進行部署。",

                // [/(\d+) branch(?:es|) allowed/, "允許 $1 個分支"],
                // [/(\d+) branch(?:es|) and (\d+)  tags? allowed/, "允許 $1 個分支和 $2 個標籤"],
                "Add deployment branch or tag rule": "添加部署分支或標籤規則",
                    // 添加部署分支規則 對話框
                    "Ref type:": "引用類型：",
                        "Tag": "標籤",
                    "Name pattern:": "名稱的模式：",
                    "Add rule": "添加規則",
                "Update deployment branch rule": "更新部署分支規則",
                    "Update rule": "更新規則",
                "Remove": "刪除",

                // 頂部提醒
                    "Environment changes successfully saved: all branches can deploy.": "環境更改已成功保存：所有分支都可以部署。",
                    "Environment changes successfully saved: only protected branches can deploy.": "環境更改已成功保存：只有受保護的分支才能部署。",
                    "Environment changes successfully saved: only selected branches and tags can deploy.": "環境更改已成功保存：只有選定的分支和標籤才能部署。",
                    // [/Deployment branch rule \"([^ ]+)\" saved successfully./ ,"部署分支規則 “$1” 已成功保存。"],
                    // [/Deployment branch rule \"([^ ]+)\" removed./, "部署分支規則 “$1” 已刪除。",]

            "Environment secrets": "環境機密",
                "Secrets are encrypted environment variables. They are accessible only by GitHub Actions in the context of this environment by using the": "機密是加密的環境變量。它們只能由 GitHub Actions 在這個環境中訪問",
                    "secret context": "機密上下文",

                "Name": "名稱",
                "Value": "值",
                "Last updated": "最後更新",

                "This environment has no secrets.": "該環境尚無機密。",
                "Add environment secret": "添加環境機密",
                    // 添加機密對話框
                    "Add secret": "添加機密",
                    "Secret value": "機密值",
                    // 提醒
                        "Failed to add secret: Secret names can only contain alphanumeric characters ([a-z], [A-Z], [0-9]) or underscores (_). Spaces are not allowed. Must start with a letter ([a-z], [A-Z]) or underscores (_).": "添加機密失敗：機密名稱只能包含字母、數字字符 ([a-z], [A-Z], [0-9]) 或下劃線 (_)。不允許使用空格。必須以字母 ([a-z], [A-Z]) 或下劃線 (_) 開頭。",
                        "Name and value are required": "名稱和值是必填項。",

                "Update secret": "更新機密",
                // 刪除機密 對話框
                    "Delete secret": "刪除機密",
                        "Are you sure you want to delete": "您確定要刪除",
                        "Yes, delete this": "是的，刪除該",
                        "secret": "機密",

            "Environment variables": "環境變量",
                "Variables are used for non-sensitive configuration data. They are accessible only by GitHub Actions in the context of this environment by using the": "變量用於非敏感配置數據。它們只能由 GitHub Actions 在此環境中訪問",
                    "variable context": "變量上下文",

                "This environment has no variables.": "該環境尚無變量。",
                "Add environment variable": "添加環境變量",
                    // 添加變量對話框
                    "Add variable": "添加變量",
                    "Variable value": "變量值",
                    // 提醒
                        "Failed to add variable: Variable names can only contain alphanumeric characters ([a-z], [A-Z], [0-9]) or underscores (_). Spaces are not allowed. Must start with a letter ([a-z], [A-Z]) or underscores (_).": "添加變量失敗： 變量名只能包含字母、數字字符（[a-z]、[A-Z]、[0-9]）或下劃線 (_)。不允許使用空格。必須以字母 ([a-z], [A-Z]) 或下劃線 (_) 開頭。",

                "Update variable": "更新變量",
                // 刪除變量 對話框
                    "Delete variable": "刪除變量",
                    "variable": "變量",

    },
    "regexp": [ // 正則翻譯
        ...I18N["zh-TW"]["repository-public"]["regexp"],
        [/(\d+) protection rules?/, "$1 個保護規則"], // /environments
        [/(\d+) secrets?/, "$1 個機密"], // /environments
        [/(\d+) variables?/, "$1 個變量"], // /environments
        [/Environment \"([^ ]+)\" created./, "環境 “$1” 已創建。"],
        [/Environment \"([^ ]+)\" updated./, "環境 “$1” 已更新。"],
        [/Currently applies to (\d+) branch(?:es|)/, "目前適用於 $1 個分支"],
        [/(\d+) branch(?:es|) and (\d+) tags? allowed/, "允許 $1 個分支和 $2 個標籤"],
        [/(\d+) branch(?:es|) allowed/, "允許 $1 個分支"],
        [/(\d+) branch(?:es|)/, "$1 個分支"],
        [/Deployment branch rule \"([^ ]+)\" saved successfully./ ,"部署分支規則 “$1” 已成功保存。"],
        [/Deployment branch rule \"([^ ]+)\" removed./, "部署分支規則 “$1” 已刪除。",]
    ],
    "title": {
        "regexp": [
            [/Environments/, "環境"],
            [/Create environment/, "創建環境"],
            [/Configure environment/, "配置環境"],
        ],
    },
};

I18N["zh-TW"]["repository/settings/codespaces"] = { // 倉庫設置 - 程式碼空間 /<user-name>/<repo-name>/settings/codespaces
    "static": { // 靜態翻譯
        ...I18N["zh-TW"]["repository-public"]["static"],
        ...I18N["zh-TW"]["repository-settings-menu"]["static"],

        // 程式碼空間 /<user-name>/<repo-name>/settings/codespaces
            // 頂部提醒
                "Prebuild configuration created": "預構建設置已創建",
                "Prebuild configuration deleted": "預構建設置已刪除",
            "Prebuild configuration": "預構建設置",

            "Set up prebuild": "設置預構建",
            "There are no prebuilds configured for this repository": "尚無預構建設置",
            "Prebuild configurations speed up Codespace creations significantly by pre-executing all the tasks required to build your development environment.": "預構建設置通過預先執行構建開發環境所需的所有任務，大大加快了程式碼空間的創建。",
            "Learn more about setting up prebuilds": "瞭解更多關於預構建設置的信息",

            // 狀態
                "Currently Running": "正在運行中",
                "Disabled": "禁用",
            "See output": "查看輸出結果",

            "Configuration menu": "設置菜單",
                "Manually trigger": "手動觸發",
                "View runs": "查看運行日誌",
                "Disable runs":"暫停運行",
                "Enable runs":"恢復運行",

            // 刪除對話框
                "Are you sure?": "您確定嗎？",
                "Are you sure you want to delete this prebuild configuration? Running workflow may fail and templates associated with this configuration will be deleted.": "您確定要刪除這個預構建設置嗎？運行中的工作流可能會失敗，與此設置相關的模板將被刪除。",

        // 程式碼空間-新建預構建設置 /<user-name>/<repo-name>/settings/codespaces/prebuild_configurations/ne