/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api;

import io.swagger.v3.oas.annotations.Operation;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import org.apache.pdfbox.multipdf.LayerUtility;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.GeneralApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@GeneralApi
public class ToSinglePageController {
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/pdf-to-single-page"})
    @StandardPdfResponse
    @Operation(summary="Convert a multi-page PDF into a single long page PDF", description="This endpoint converts a multi-page PDF document into a single paged PDF document. The width of the single page will be same as the input's width, but the height will be the sum of all the pages' heights. Input:PDF Output:PDF Type:SISO")
    public ResponseEntity<byte[]> pdfToSinglePage(@ModelAttribute PDFFile request) throws IOException {
        try (PDDocument sourceDocument = this.pdfDocumentFactory.load(request);){
            ResponseEntity responseEntity;
            block17: {
                float totalHeight = 0.0f;
                float maxWidth = 0.0f;
                for (PDPage page : sourceDocument.getPages()) {
                    PDRectangle pageSize = page.getMediaBox();
                    totalHeight += pageSize.getHeight();
                    maxWidth = Math.max(maxWidth, pageSize.getWidth());
                }
                PDDocument newDocument = this.pdfDocumentFactory.createNewDocumentBasedOnOldDocument(sourceDocument);
                try {
                    PDPage newPage = new PDPage(new PDRectangle(maxWidth, totalHeight));
                    newDocument.addPage(newPage);
                    LayerUtility layerUtility = new LayerUtility(newDocument);
                    float yOffset = totalHeight;
                    try {
                        layerUtility.wrapInSaveRestore(newPage);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    int pageIndex = 0;
                    for (PDPage page : sourceDocument.getPages()) {
                        PDFormXObject form = layerUtility.importPageAsForm(sourceDocument, pageIndex);
                        if (form != null) {
                            AffineTransform af = AffineTransform.getTranslateInstance(0.0, yOffset - page.getMediaBox().getHeight());
                            String defaultLayerName = "Layer" + pageIndex;
                            layerUtility.appendFormAsLayer(newPage, form, af, defaultLayerName);
                        }
                        yOffset -= page.getMediaBox().getHeight();
                        ++pageIndex;
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    newDocument.save((OutputStream)baos);
                    byte[] result = baos.toByteArray();
                    responseEntity = WebResponseUtils.bytesToWebResponse((byte[])result, (String)GeneralUtils.generateFilename((String)request.getFileInput().getOriginalFilename(), (String)"_singlePage.pdf"));
                    if (newDocument == null) break block17;
                }
                catch (Throwable throwable) {
                    if (newDocument != null) {
                        try {
                            newDocument.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                newDocument.close();
            }
            return responseEntity;
        }
    }

    @Generated
    public ToSinglePageController(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

