/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import lombok.Generated;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.model.api.converters.PdfToPresentationRequest;
import stirling.software.SPDF.model.api.converters.PdfToTextOrRTFRequest;
import stirling.software.SPDF.model.api.converters.PdfToWordRequest;
import stirling.software.common.configuration.RuntimePathConfig;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.PDFToFile;
import stirling.software.common.util.TempFileManager;
import stirling.software.common.util.WebResponseUtils;

@RestController
@RequestMapping(value={"/api/v1/convert"})
@Tag(name="Convert", description="Convert APIs")
public class ConvertPDFToOffice {
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final TempFileManager tempFileManager;
    private final RuntimePathConfig runtimePathConfig;

    @PostMapping(consumes={"multipart/form-data"}, value={"/pdf/presentation"})
    @Operation(summary="Convert PDF to Presentation format", description="This endpoint converts a given PDF file to a Presentation format. Input:PDF Output:PPT Type:SISO")
    public ResponseEntity<byte[]> processPdfToPresentation(@ModelAttribute PdfToPresentationRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String outputFormat = request.getOutputFormat();
        PDFToFile pdfToFile = new PDFToFile(this.tempFileManager, this.runtimePathConfig);
        return pdfToFile.processPdfToOfficeFormat(inputFile, outputFormat, "impress_pdf_import");
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/pdf/text"})
    @Operation(summary="Convert PDF to Text or RTF format", description="This endpoint converts a given PDF file to Text or RTF format. Input:PDF Output:TXT Type:SISO")
    public ResponseEntity<byte[]> processPdfToRTForTXT(@ModelAttribute PdfToTextOrRTFRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String outputFormat = request.getOutputFormat();
        if ("txt".equals(request.getOutputFormat())) {
            try (PDDocument document = this.pdfDocumentFactory.load(inputFile);){
                PDFTextStripper stripper = new PDFTextStripper();
                String text = stripper.getText(document);
                ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])text.getBytes(), (String)GeneralUtils.generateFilename((String)inputFile.getOriginalFilename(), (String)".txt"), (MediaType)MediaType.TEXT_PLAIN);
                return responseEntity;
            }
        }
        PDFToFile pdfToFile = new PDFToFile(this.tempFileManager, this.runtimePathConfig);
        return pdfToFile.processPdfToOfficeFormat(inputFile, outputFormat, "writer_pdf_import");
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/pdf/word"})
    @Operation(summary="Convert PDF to Word document", description="This endpoint converts a given PDF file to a Word document format. Input:PDF Output:WORD Type:SISO")
    public ResponseEntity<byte[]> processPdfToWord(@ModelAttribute PdfToWordRequest request) throws IOException, InterruptedException {
        MultipartFile inputFile = request.getFileInput();
        String outputFormat = request.getOutputFormat();
        PDFToFile pdfToFile = new PDFToFile(this.tempFileManager, this.runtimePathConfig);
        return pdfToFile.processPdfToOfficeFormat(inputFile, outputFormat, "writer_pdf_import");
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/pdf/xml"})
    @Operation(summary="Convert PDF to XML", description="This endpoint converts a PDF file to an XML file. Input:PDF Output:XML Type:SISO")
    public ResponseEntity<byte[]> processPdfToXML(@ModelAttribute PDFFile file) throws Exception {
        MultipartFile inputFile = file.getFileInput();
        PDFToFile pdfToFile = new PDFToFile(this.tempFileManager, this.runtimePathConfig);
        return pdfToFile.processPdfToOfficeFormat(inputFile, "xml", "writer_pdf_import");
    }

    @Generated
    public ConvertPDFToOffice(CustomPDFDocumentFactory pdfDocumentFactory, TempFileManager tempFileManager, RuntimePathConfig runtimePathConfig) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.tempFileManager = tempFileManager;
        this.runtimePathConfig = runtimePathConfig;
    }
}

