/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import stirling.software.SPDF.controller.api.converters.ConvertPdfJsonController;
import stirling.software.SPDF.exception.CacheUnavailableException;

@ControllerAdvice(assignableTypes={ConvertPdfJsonController.class})
public class ConvertPdfJsonExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConvertPdfJsonExceptionHandler.class);
    private final ObjectMapper objectMapper;

    @ExceptionHandler(value={CacheUnavailableException.class})
    @ResponseBody
    public ResponseEntity<byte[]> handleCacheUnavailable(CacheUnavailableException ex) {
        try {
            byte[] body = this.objectMapper.writeValueAsBytes(Map.of("error", "cache_unavailable", "action", "reupload", "message", ex.getMessage()));
            return ResponseEntity.status((HttpStatusCode)HttpStatus.GONE).contentType(MediaType.APPLICATION_JSON).body((Object)body);
        }
        catch (Exception e) {
            log.warn("Failed to serialize cache_unavailable response", (Throwable)e);
            Map<String, String> fallbackBody = Map.of("error", "cache_unavailable", "action", "reupload", "message", String.valueOf(ex.getMessage()));
            try {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.GONE).contentType(MediaType.APPLICATION_JSON).body((Object)this.objectMapper.writeValueAsBytes(fallbackBody));
            }
            catch (Exception ignored) {
                return ResponseEntity.status((HttpStatusCode)HttpStatus.GONE).contentType(MediaType.APPLICATION_JSON).body((Object)"{\"error\":\"cache_unavailable\",\"action\":\"reupload\",\"message\":\"Cache unavailable\"}".getBytes(StandardCharsets.UTF_8));
            }
        }
    }

    @Generated
    public ConvertPdfJsonExceptionHandler(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

