/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.misc;

import io.github.pixee.security.Filenames;
import io.swagger.v3.oas.annotations.Operation;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.config.swagger.StandardPdfResponse;
import stirling.software.SPDF.controller.api.converters.ConvertPDFToPDFA;
import stirling.software.SPDF.model.api.misc.AddAttachmentRequest;
import stirling.software.SPDF.model.api.misc.AttachmentInfo;
import stirling.software.SPDF.model.api.misc.DeleteAttachmentRequest;
import stirling.software.SPDF.model.api.misc.ExtractAttachmentsRequest;
import stirling.software.SPDF.model.api.misc.ListAttachmentsRequest;
import stirling.software.SPDF.model.api.misc.RenameAttachmentRequest;
import stirling.software.SPDF.service.AttachmentServiceInterface;
import stirling.software.common.annotations.AutoJobPostMapping;
import stirling.software.common.annotations.api.MiscApi;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.GeneralUtils;
import stirling.software.common.util.WebResponseUtils;

@MiscApi
public class AttachmentController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AttachmentController.class);
    private final CustomPDFDocumentFactory pdfDocumentFactory;
    private final AttachmentServiceInterface pdfAttachmentService;
    private final ConvertPDFToPDFA convertPDFToPDFA;

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/add-attachments"})
    @StandardPdfResponse
    @Operation(summary="Add attachments to PDF", description="This endpoint adds attachments to a PDF. Input:PDF, Output:PDF Type:MISO")
    public ResponseEntity<byte[]> addAttachments(@ModelAttribute AddAttachmentRequest request) throws Exception {
        String baseFileName;
        MultipartFile fileInput = request.getFileInput();
        List attachments = request.getAttachments();
        boolean convertToPdfA3b = request.isConvertToPdfA3b();
        this.validateAttachmentRequest(attachments);
        String originalFileName = Filenames.toSimpleFileName((String)fileInput.getOriginalFilename());
        if (originalFileName == null || originalFileName.isEmpty()) {
            originalFileName = "document";
        }
        String string = baseFileName = originalFileName.contains(".") ? originalFileName.substring(0, originalFileName.lastIndexOf(46)) : originalFileName;
        if (convertToPdfA3b) {
            byte[] pdfaBytes;
            try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, false);){
                pdfaBytes = this.convertPDFToPDFA.convertPDDocumentToPDFA(document, "pdfa-3b");
            }
            try (PDDocument pdfaDocument = Loader.loadPDF((byte[])pdfaBytes);){
                this.pdfAttachmentService.addAttachment(pdfaDocument, attachments);
                this.convertPDFToPDFA.ensureEmbeddedFileCompliance(pdfaDocument);
                ConvertPDFToPDFA.fixType1FontCharSet((PDDocument)pdfaDocument);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                pdfaDocument.save((OutputStream)baos);
                byte[] resultBytes = baos.toByteArray();
                String outputFilename = baseFileName + "_with_attachments_PDFA-3b.pdf";
                ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])resultBytes, (String)outputFilename, (MediaType)MediaType.APPLICATION_PDF);
                return responseEntity;
            }
        }
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, false);){
            this.pdfAttachmentService.addAttachment(document, attachments);
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)fileInput.getOriginalFilename()), (String)"_with_attachments.pdf"));
            return responseEntity;
        }
    }

    private void validateAttachmentRequest(List<MultipartFile> attachments) {
        if (attachments == null || attachments.isEmpty()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.attachmentsRequired", (String)"At least one attachment is required", (Object[])new Object[0]);
        }
        long maxAttachmentSize = 0x3200000L;
        long maxTotalSize = 0xC800000L;
        long totalSize = 0L;
        for (MultipartFile attachment : attachments) {
            if (attachment == null || attachment.isEmpty()) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.attachmentEmpty", (String)"Attachment files cannot be null or empty", (Object[])new Object[0]);
            }
            if (attachment.getSize() > 0x3200000L) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.attachmentTooLarge", (String)"Attachment ''{0}'' exceeds maximum size of {1} bytes", (Object[])new Object[]{attachment.getOriginalFilename(), 0x3200000L});
            }
            totalSize += attachment.getSize();
        }
        if (totalSize > 0xC800000L) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.totalAttachmentsTooLarge", (String)"Total attachment size {0} exceeds maximum of {1} bytes", (Object[])new Object[]{totalSize, 0xC800000L});
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/extract-attachments"})
    @Operation(summary="Extract attachments from PDF", description="This endpoint extracts all embedded attachments from a PDF into a ZIP archive. Input:PDF Output:ZIP Type:SISO")
    public ResponseEntity<byte[]> extractAttachments(@ModelAttribute ExtractAttachmentsRequest request) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, true);){
            Optional extracted = this.pdfAttachmentService.extractAttachments(document);
            if (extracted.isEmpty()) {
                throw ExceptionUtils.createIllegalArgumentException((String)"error.noAttachmentsFound", (String)"No embedded attachments found in the provided PDF", (Object[])new Object[0]);
            }
            MultipartFile fileInput = request.getFileInput();
            String sourceName = fileInput != null ? fileInput.getOriginalFilename() : request.getFileId();
            String outputName = Filenames.toSimpleFileName((String)GeneralUtils.generateFilename((String)sourceName, (String)"_attachments.zip"));
            ResponseEntity responseEntity = WebResponseUtils.bytesToWebResponse((byte[])((byte[])extracted.get()), (String)outputName, (MediaType)MediaType.APPLICATION_OCTET_STREAM);
            return responseEntity;
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/list-attachments"})
    @Operation(summary="List attachments in PDF", description="This endpoint lists all embedded attachments in a PDF. Input:PDF Output:JSON Type:SISO")
    public ResponseEntity<List<AttachmentInfo>> listAttachments(@ModelAttribute ListAttachmentsRequest request) throws IOException {
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, true);){
            List attachments = this.pdfAttachmentService.listAttachments(document);
            ResponseEntity responseEntity = ResponseEntity.ok((Object)attachments);
            return responseEntity;
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/rename-attachment"})
    @StandardPdfResponse
    @Operation(summary="Rename attachment in PDF", description="This endpoint renames an embedded attachment in a PDF. Input:PDF Output:PDF Type:MISO")
    public ResponseEntity<byte[]> renameAttachment(@ModelAttribute RenameAttachmentRequest request) throws Exception {
        MultipartFile fileInput = request.getFileInput();
        String attachmentName = request.getAttachmentName();
        String newName = request.getNewName();
        if (attachmentName == null || attachmentName.isBlank()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.attachmentNameRequired", (String)"Attachment name cannot be null or empty", (Object[])new Object[0]);
        }
        if (newName == null || newName.isBlank()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.newNameRequired", (String)"New attachment name cannot be null or empty", (Object[])new Object[0]);
        }
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, false);){
            this.pdfAttachmentService.renameAttachment(document, attachmentName, newName);
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)fileInput.getOriginalFilename()), (String)"_attachment_renamed.pdf"));
            return responseEntity;
        }
    }

    @AutoJobPostMapping(consumes={"multipart/form-data"}, value={"/delete-attachment"})
    @StandardPdfResponse
    @Operation(summary="Delete attachment from PDF", description="This endpoint deletes an embedded attachment from a PDF. Input:PDF Output:PDF Type:MISO")
    public ResponseEntity<byte[]> deleteAttachment(@ModelAttribute DeleteAttachmentRequest request) throws Exception {
        MultipartFile fileInput = request.getFileInput();
        String attachmentName = request.getAttachmentName();
        if (attachmentName == null || attachmentName.isBlank()) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.attachmentNameRequired", (String)"Attachment name cannot be null or empty", (Object[])new Object[0]);
        }
        try (PDDocument document = this.pdfDocumentFactory.load((PDFFile)request, false);){
            this.pdfAttachmentService.deleteAttachment(document, attachmentName);
            ResponseEntity responseEntity = WebResponseUtils.pdfDocToWebResponse((PDDocument)document, (String)GeneralUtils.generateFilename((String)Filenames.toSimpleFileName((String)fileInput.getOriginalFilename()), (String)"_attachment_deleted.pdf"));
            return responseEntity;
        }
    }

    @Generated
    public AttachmentController(CustomPDFDocumentFactory pdfDocumentFactory, AttachmentServiceInterface pdfAttachmentService, ConvertPDFToPDFA convertPDFToPDFA) {
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.pdfAttachmentService = pdfAttachmentService;
        this.convertPDFToPDFA = convertPDFToPDFA;
    }
}

