/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.pipeline;

import io.github.pixee.security.ZipSecurity;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.SPDFApplication;
import stirling.software.SPDF.controller.api.pipeline.PipelineProcessor;
import stirling.software.SPDF.model.PipelineConfig;
import stirling.software.SPDF.model.PipelineOperation;
import stirling.software.SPDF.model.PipelineResult;
import stirling.software.SPDF.service.ApiDocService;
import stirling.software.common.model.enumeration.Role;
import stirling.software.common.service.UserServiceInterface;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class PipelineProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineProcessor.class);
    private final ApiDocService apiDocService;
    private final UserServiceInterface userService;
    private final ServletContext servletContext;

    public PipelineProcessor(ApiDocService apiDocService, @Autowired(required=false) UserServiceInterface userService, ServletContext servletContext) {
        this.apiDocService = apiDocService;
        this.userService = userService;
        this.servletContext = servletContext;
    }

    public static String removeTrailingNaming(String filename) {
        int dotIndex = filename.lastIndexOf(".");
        if (dotIndex == -1) {
            return filename;
        }
        String name = filename.substring(0, dotIndex);
        String extension = filename.substring(dotIndex);
        int underscoreIndex = name.lastIndexOf("_");
        if (underscoreIndex == -1) {
            return filename;
        }
        return name.substring(0, underscoreIndex) + extension;
    }

    private String getApiKeyForUser() {
        if (this.userService == null) {
            return "";
        }
        return this.userService.getApiKeyForUser(Role.INTERNAL_API_USER.getRoleId());
    }

    private String getBaseUrl() {
        String contextPath = this.servletContext.getContextPath();
        String port = SPDFApplication.getStaticPort();
        return "http://localhost:" + port + contextPath + "/";
    }

    PipelineResult runPipelineAgainstFiles(List<Resource> outputFiles, PipelineConfig config) throws Exception {
        PipelineResult result = new PipelineResult();
        ByteArrayOutputStream logStream = new ByteArrayOutputStream();
        PrintStream logPrintStream = new PrintStream(logStream);
        boolean hasErrors = false;
        boolean filtersApplied = false;
        for (PipelineOperation pipelineOperation : config.getOperations()) {
            String operation = pipelineOperation.getOperation();
            boolean isMultiInputOperation = this.apiDocService.isMultiInput(operation);
            log.info("Running operation: {} isMultiInputOperation {}", (Object)operation, (Object)isMultiInputOperation);
            Map parameters = pipelineOperation.getParameters();
            ArrayList<String> inputFileTypes = this.apiDocService.getExtensionTypes(false, operation);
            if (inputFileTypes == null) {
                inputFileTypes = new ArrayList<String>(List.of("ALL"));
            }
            if (!this.apiDocService.isValidOperation(operation, parameters)) {
                log.error("Invalid operation or parameters: o:{} p:{}", (Object)operation, (Object)parameters);
                throw new IllegalArgumentException("Invalid operation: " + operation + " with parameters: " + String.valueOf(parameters));
            }
            String url = this.getBaseUrl() + operation;
            ArrayList<Resource> newOutputFiles = new ArrayList<Resource>();
            if (!isMultiInputOperation) {
                for (Resource file2 : outputFiles) {
                    boolean hasInputFileType = false;
                    for (String extension : inputFileTypes) {
                        if (!"ALL".equals(extension) && !file2.getFilename().toLowerCase(Locale.ROOT).endsWith(extension)) continue;
                        hasInputFileType = true;
                        LinkedMultiValueMap body = new LinkedMultiValueMap();
                        body.add((Object)"fileInput", (Object)file2);
                        for (Map.Entry entry : parameters.entrySet()) {
                            Object object = entry.getValue();
                            if (object instanceof List) {
                                List entryList = (List)object;
                                for (Object item : entryList) {
                                    body.add((Object)((String)entry.getKey()), item);
                                }
                                continue;
                            }
                            body.add((Object)((String)entry.getKey()), entry.getValue());
                        }
                        ResponseEntity response = this.sendWebRequest(url, (MultiValueMap)body);
                        if (operation.startsWith("/api/v1/filter/filter-") && (response.getBody() == null || ((byte[])response.getBody()).length == 0)) {
                            filtersApplied = true;
                            log.info("Skipping file due to filtering {}", (Object)operation);
                            continue;
                        }
                        if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
                            logPrintStream.println("Error: " + String.valueOf(response.getBody()));
                            hasErrors = true;
                            continue;
                        }
                        this.processOutputFiles(operation, response, newOutputFiles);
                    }
                    if (hasInputFileType) continue;
                    String string = file2.getFilename();
                    String providedExtension = "no extension";
                    if (string != null && string.contains(".")) {
                        providedExtension = string.substring(string.lastIndexOf(".")).toLowerCase(Locale.ROOT);
                    }
                    logPrintStream.println("No files with extension " + String.join((CharSequence)", ", inputFileTypes) + " found for operation " + operation + ". Provided file '" + string + "' has extension: " + providedExtension);
                    hasErrors = true;
                }
            } else {
                List<Resource> matchingFiles;
                if (inputFileTypes.contains("ALL")) {
                    matchingFiles = new ArrayList<Resource>(outputFiles);
                } else {
                    ArrayList<String> finalinputFileTypes = inputFileTypes;
                    matchingFiles = outputFiles.stream().filter(file -> finalinputFileTypes.stream().anyMatch(file.getFilename().toLowerCase(Locale.ROOT)::endsWith)).toList();
                }
                if (!matchingFiles.isEmpty()) {
                    LinkedMultiValueMap body = new LinkedMultiValueMap();
                    for (Resource resource : matchingFiles) {
                        body.add((Object)"fileInput", (Object)resource);
                    }
                    for (Map.Entry entry : parameters.entrySet()) {
                        Object object = entry.getValue();
                        if (object instanceof List) {
                            List entryList = (List)object;
                            for (Object item : entryList) {
                                body.add((Object)((String)entry.getKey()), item);
                            }
                            continue;
                        }
                        body.add((Object)((String)entry.getKey()), entry.getValue());
                    }
                    ResponseEntity response = this.sendWebRequest(url, (MultiValueMap)body);
                    if (HttpStatus.OK.equals((Object)response.getStatusCode())) {
                        this.processOutputFiles(operation, response, newOutputFiles);
                    } else {
                        logPrintStream.println("Error in multi-input operation: " + String.valueOf(response.getBody()));
                        hasErrors = true;
                    }
                } else {
                    List<String> providedExtensions = outputFiles.stream().map(file -> {
                        String filename = file.getFilename();
                        if (filename != null && filename.contains(".")) {
                            return filename.substring(filename.lastIndexOf(".")).toLowerCase(Locale.ROOT);
                        }
                        return "no extension";
                    }).distinct().toList();
                    logPrintStream.println("No files with extension " + String.join((CharSequence)", ", inputFileTypes) + " found for multi-input operation " + operation + ". Provided files have extensions: " + String.join((CharSequence)", ", providedExtensions) + " (total files: " + outputFiles.size() + ")");
                    hasErrors = true;
                }
            }
            logPrintStream.close();
            outputFiles = newOutputFiles;
        }
        if (hasErrors) {
            log.error("Errors occurred during processing. Log: {}", (Object)logStream.toString());
        }
        result.setHasErrors(hasErrors);
        result.setFiltersApplied(filtersApplied);
        result.setOutputFiles(outputFiles);
        return result;
    }

    ResponseEntity<byte[]> sendWebRequest(String url, MultiValueMap<String, Object> body) {
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        String apiKey = this.getApiKeyForUser();
        headers.add("X-API-KEY", apiKey);
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity entity = new HttpEntity(body, (MultiValueMap)headers);
        return restTemplate.exchange(url, HttpMethod.POST, entity, byte[].class, new Object[0]);
    }

    private List<Resource> processOutputFiles(String operation, ResponseEntity<byte[]> response, List<Resource> newOutputFiles) throws IOException {
        String newFilename = operation.contains("auto-rename") ? this.extractFilename(response) : PipelineProcessor.removeTrailingNaming((String)this.extractFilename(response));
        if (this.isZip((byte[])response.getBody(), newFilename)) {
            newOutputFiles.addAll(this.unzip((byte[])response.getBody()));
        } else {
            1 outputResource = new /* Unavailable Anonymous Inner Class!! */;
            newOutputFiles.add((Resource)outputResource);
        }
        return newOutputFiles;
    }

    public String extractFilename(ResponseEntity<byte[]> response) {
        String filename = "default-filename.ext";
        HttpHeaders headers = response.getHeaders();
        String contentDisposition = headers.getFirst("Content-Disposition");
        if (contentDisposition != null && !contentDisposition.isEmpty()) {
            String[] parts;
            for (String part : parts = contentDisposition.split(";")) {
                if (!part.trim().startsWith("filename")) continue;
                filename = part.split("=")[1].trim().replace("\"", "");
                filename = URLDecoder.decode(filename, StandardCharsets.UTF_8);
                break;
            }
        }
        return filename;
    }

    List<Resource> generateInputFiles(File[] files) throws Exception {
        if (files == null || files.length == 0) {
            log.info("No files");
            return null;
        }
        ArrayList<Resource> outputFiles = new ArrayList<Resource>();
        for (File file : files) {
            Path normalizedPath = Paths.get(file.getName(), new String[0]).normalize();
            if (normalizedPath.startsWith("..")) {
                throw new SecurityException("Potential path traversal attempt in file name: " + file.getName());
            }
            Path path = Paths.get(file.getAbsolutePath(), new String[0]);
            log.info("Reading file: {}", (Object)path);
            if (Files.exists(path, new LinkOption[0])) {
                2 fileResource = new /* Unavailable Anonymous Inner Class!! */;
                outputFiles.add((Resource)fileResource);
                continue;
            }
            log.info("File not found: {}", (Object)path);
        }
        log.info("Files successfully loaded. Starting processing...");
        return outputFiles;
    }

    List<Resource> generateInputFiles(MultipartFile[] files) throws Exception {
        if (files == null || files.length == 0) {
            log.info("No files");
            return null;
        }
        ArrayList<Resource> outputFiles = new ArrayList<Resource>();
        for (MultipartFile file : files) {
            3 fileResource = new /* Unavailable Anonymous Inner Class!! */;
            outputFiles.add((Resource)fileResource);
        }
        log.info("Files successfully loaded. Starting processing...");
        return outputFiles;
    }

    private boolean isZip(byte[] data, String filename) {
        String lower;
        if (data == null || data.length < 4) {
            return false;
        }
        if (filename != null && (lower = filename.toLowerCase()).endsWith(".cbz")) {
            return false;
        }
        return data[0] == 80 && data[1] == 75 && data[2] == 3 && data[3] == 4;
    }

    private boolean isZip(byte[] data) {
        return this.isZip(data, null);
    }

    private List<Resource> unzip(byte[] data) throws IOException {
        log.info("Unzipping data of length: {}", (Object)data.length);
        ArrayList<Resource> unzippedFiles = new ArrayList<Resource>();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(data);
             ZipInputStream zis = ZipSecurity.createHardenedInputStream((InputStream)bais);){
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((count = zis.read(buffer)) != -1) {
                    baos.write(buffer, 0, count);
                }
                String filename = entry.getName();
                4 fileResource = new /* Unavailable Anonymous Inner Class!! */;
                if (this.isZip(baos.toByteArray(), filename)) {
                    log.info("File {} is a zip file. Unzipping...", (Object)filename);
                    unzippedFiles.addAll(this.unzip(baos.toByteArray()));
                    continue;
                }
                unzippedFiles.add((Resource)fileResource);
            }
        }
        log.info("Unzipping completed. {} files were unzipped.", (Object)unzippedFiles.size());
        return unzippedFiles;
    }
}

