/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.controller.api.security;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.cos.COSInputStream;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.PDJavascriptNameTreeNode;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.apache.pdfbox.pdmodel.graphics.PDXObject;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentGroup;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationFileAttachment;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.xmpbox.XMPMetadata;
import org.apache.xmpbox.schema.PDFAIdentificationSchema;
import org.apache.xmpbox.xml.DomXmpParser;
import org.apache.xmpbox.xml.XmpParsingException;
import org.apache.xmpbox.xml.XmpSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import stirling.software.SPDF.controller.api.security.GetInfoOnPDF;
import stirling.software.common.model.api.PDFFile;
import stirling.software.common.service.CustomPDFDocumentFactory;
import stirling.software.common.util.ExceptionUtils;
import stirling.software.common.util.RegexPatternUtils;
import stirling.software.common.util.WebResponseUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@RestController
@RequestMapping(value={"/api/v1/security"})
@Tag(name="Security", description="Security APIs")
public class GetInfoOnPDF {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GetInfoOnPDF.class);
    private static final int DEFAULT_PPI = 72;
    private static final float SIZE_TOLERANCE = 1.0f;
    private static final int MAX_LOGGED_ERRORS = 5;
    private static final String PAGE_PREFIX = "Page ";
    private static final long MAX_FILE_SIZE = 0x6400000L;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final CustomPDFDocumentFactory pdfDocumentFactory;

    private static void addOutlinesToArray(PDOutlineItem outline, ArrayNode arrayNode) {
        if (outline == null) {
            return;
        }
        ObjectNode outlineNode = objectMapper.createObjectNode();
        outlineNode.put("Title", outline.getTitle());
        arrayNode.add((JsonNode)outlineNode);
        for (PDOutlineItem child = outline.getFirstChild(); child != null; child = child.getNextSibling()) {
            GetInfoOnPDF.addOutlinesToArray((PDOutlineItem)child, (ArrayNode)arrayNode);
        }
    }

    public static boolean checkForStandard(PDDocument document, String standardKeyword) {
        if ("PDF/A".equalsIgnoreCase(standardKeyword)) {
            return GetInfoOnPDF.getPdfAConformanceLevel((PDDocument)document) != null;
        }
        return GetInfoOnPDF.checkStandardInMetadata((PDDocument)document, (String)standardKeyword);
    }

    public static String getPdfAConformanceLevel(PDDocument document) {
        if (document == null || document.isEncrypted()) {
            return null;
        }
        return GetInfoOnPDF.getPdfAVersionFromMetadata((PDDocument)document);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPdfAVersionFromMetadata(PDDocument document) {
        try {
            PDMetadata pdMetadata = document.getDocumentCatalog().getMetadata();
            if (pdMetadata == null) return null;
            try (COSInputStream metaStream = pdMetadata.createInputStream();){
                DomXmpParser domXmpParser = new DomXmpParser();
                XMPMetadata xmpMeta = domXmpParser.parse((InputStream)metaStream);
                PDFAIdentificationSchema pdfId = xmpMeta.getPDFAIdentificationSchema();
                if (pdfId != null) {
                    Integer part = pdfId.getPart();
                    String conformance = pdfId.getConformance();
                    if (part == null) return null;
                    if (conformance == null) return null;
                    String string = part + conformance.toUpperCase(Locale.ROOT);
                    return string;
                }
                try (COSInputStream rawStream = pdMetadata.createInputStream();){
                    byte[] metadataBytes = rawStream.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    String extracted = GetInfoOnPDF.extractPdfAVersionFromRawXml((String)rawMetadata);
                    if (extracted == null) return null;
                    String string = extracted;
                    return string;
                }
            }
            catch (XmpParsingException e) {
                log.debug("XMP parsing failed, trying raw metadata search: {}", (Object)e.getMessage());
                try (COSInputStream metaStream2 = pdMetadata.createInputStream();){
                    byte[] metadataBytes = metaStream2.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    String extracted = GetInfoOnPDF.extractPdfAVersionFromRawXml((String)rawMetadata);
                    if (extracted == null) return null;
                    String string = extracted;
                    return string;
                }
            }
        }
        catch (Exception e) {
            log.debug("Error reading PDF/A metadata: {}", (Object)e.getMessage());
        }
        return null;
    }

    private static String extractPdfAVersionFromRawXml(String rawXml) {
        if (rawXml == null || rawXml.isEmpty()) {
            return null;
        }
        try {
            Pattern partPattern = RegexPatternUtils.getInstance().getPdfAidPartPattern();
            Pattern confPattern = RegexPatternUtils.getInstance().getPdfAidConformancePattern();
            Matcher partMatcher = partPattern.matcher(rawXml);
            Matcher confMatcher = confPattern.matcher(rawXml);
            if (partMatcher.find() && confMatcher.find()) {
                String part = partMatcher.group(1);
                String conformance = confMatcher.group(1).toUpperCase(Locale.ROOT);
                return part + conformance;
            }
        }
        catch (Exception e) {
            log.debug("Error parsing raw XMP for PDF/A version: {}", (Object)e.getMessage());
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private static boolean validatePdfAWithPreflight(PDDocument document, String version) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkStandardInMetadata(PDDocument document, String standardKeyword) {
        try {
            block17: {
                boolean bl;
                PDMetadata pdMetadata = document.getDocumentCatalog().getMetadata();
                if (pdMetadata == null) return false;
                try (COSInputStream metaStream = pdMetadata.createInputStream();){
                    byte[] metadataBytes = metaStream.readAllBytes();
                    String rawMetadata = new String(metadataBytes, StandardCharsets.UTF_8);
                    if (rawMetadata.contains(standardKeyword)) {
                        boolean bl2 = true;
                        return bl2;
                    }
                }
                metaStream = pdMetadata.createInputStream();
                try {
                    DomXmpParser domXmpParser = new DomXmpParser();
                    XMPMetadata xmpMeta = domXmpParser.parse((InputStream)metaStream);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    new XmpSerializer().serialize(xmpMeta, (OutputStream)baos, true);
                    String xmpString = baos.toString(StandardCharsets.UTF_8);
                    if (!xmpString.contains(standardKeyword)) break block17;
                    bl = true;
                    if (metaStream == null) return bl;
                }
                catch (XmpParsingException e) {
                    log.debug("XMP parsing failed for standard check, but raw metadata was already checked: {}", (Object)e.getMessage());
                    return false;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                metaStream.close();
                return bl;
            }
            return false;
        }
        catch (Exception e) {
            ExceptionUtils.logException((String)"PDF standard checking", (Exception)e);
        }
        return false;
    }

    private static ObjectNode generatePDFSummaryData(PDDocument document, String pdfaConformanceLevel, Boolean pdfaValidationPassed) {
        ObjectNode summaryData = objectMapper.createObjectNode();
        if (document.isEncrypted()) {
            summaryData.put("encrypted", true);
        }
        AccessPermission accessPermission = document.getCurrentAccessPermission();
        ArrayNode restrictedPermissions = objectMapper.createArrayNode();
        if (!accessPermission.canAssembleDocument()) {
            restrictedPermissions.add("document assembly");
        }
        if (!accessPermission.canExtractContent()) {
            restrictedPermissions.add("content extraction");
        }
        if (!accessPermission.canExtractForAccessibility()) {
            restrictedPermissions.add("accessibility extraction");
        }
        if (!accessPermission.canFillInForm()) {
            restrictedPermissions.add("form filling");
        }
        if (!accessPermission.canModify()) {
            restrictedPermissions.add("modification");
        }
        if (!accessPermission.canModifyAnnotations()) {
            restrictedPermissions.add("annotation modification");
        }
        if (!accessPermission.canPrint()) {
            restrictedPermissions.add("printing");
        }
        if (!restrictedPermissions.isEmpty()) {
            summaryData.set("restrictedPermissions", (JsonNode)restrictedPermissions);
            summaryData.put("restrictedPermissionsCount", restrictedPermissions.size());
        }
        if (pdfaConformanceLevel != null) {
            summaryData.put("standardCompliance", "PDF/A-" + pdfaConformanceLevel);
            summaryData.put("standardPurpose", "long-term archiving");
            if (pdfaValidationPassed != null) {
                summaryData.put("standardValidationPassed", pdfaValidationPassed);
            }
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/X")) {
            summaryData.put("standardCompliance", "PDF/X");
            summaryData.put("standardPurpose", "graphic exchange");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/UA")) {
            summaryData.put("standardCompliance", "PDF/UA");
            summaryData.put("standardPurpose", "universal accessibility");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/E")) {
            summaryData.put("standardCompliance", "PDF/E");
            summaryData.put("standardPurpose", "engineering workflows");
        } else if (GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/VT")) {
            summaryData.put("standardCompliance", "PDF/VT");
            summaryData.put("standardPurpose", "variable and transactional printing");
        }
        return summaryData;
    }

    private static void setNodePermissions(PDDocument pdfBoxDoc, ObjectNode permissionsNode) {
        AccessPermission accessPermission = pdfBoxDoc.getCurrentAccessPermission();
        permissionsNode.put("Document Assembly", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canAssembleDocument()));
        permissionsNode.put("Extracting Content", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canExtractContent()));
        permissionsNode.put("Extracting for accessibility", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canExtractForAccessibility()));
        permissionsNode.put("Form Filling", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canFillInForm()));
        permissionsNode.put("Modifying", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canModify()));
        permissionsNode.put("Modifying annotations", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canModifyAnnotations()));
        permissionsNode.put("Printing", GetInfoOnPDF.getPermissionState((boolean)accessPermission.canPrint()));
    }

    private static String getPermissionState(boolean state) {
        return state ? "Allowed" : "Not Allowed";
    }

    public static String getPageOrientation(double width, double height) {
        if (width > height) {
            return "Landscape";
        }
        if (height > width) {
            return "Portrait";
        }
        return "Square";
    }

    public static String getPageSize(float width, float height) {
        HashMap<String, PDRectangle> standardSizes = new HashMap<String, PDRectangle>();
        standardSizes.put("Letter", PDRectangle.LETTER);
        standardSizes.put("LEGAL", PDRectangle.LEGAL);
        standardSizes.put("A0", PDRectangle.A0);
        standardSizes.put("A1", PDRectangle.A1);
        standardSizes.put("A2", PDRectangle.A2);
        standardSizes.put("A3", PDRectangle.A3);
        standardSizes.put("A4", PDRectangle.A4);
        standardSizes.put("A5", PDRectangle.A5);
        standardSizes.put("A6", PDRectangle.A6);
        for (Map.Entry entry : standardSizes.entrySet()) {
            PDRectangle size = (PDRectangle)entry.getValue();
            if (!GetInfoOnPDF.isCloseToSize((float)width, (float)height, (float)size.getWidth(), (float)size.getHeight())) continue;
            return (String)entry.getKey();
        }
        return "Custom";
    }

    private static boolean isCloseToSize(float width, float height, float standardWidth, float standardHeight) {
        return Math.abs(width - standardWidth) <= 1.0f && Math.abs(height - standardHeight) <= 1.0f;
    }

    private static void setDimensionInfo(ObjectNode dimensionInfo, float width, float height) {
        float widthInInches = width / 72.0f;
        float heightInInches = height / 72.0f;
        float widthInCm = widthInInches * 2.54f;
        float heightInCm = heightInInches * 2.54f;
        dimensionInfo.put("Width (px)", String.format(Locale.ROOT, "%.2f", Float.valueOf(width)));
        dimensionInfo.put("Height (px)", String.format(Locale.ROOT, "%.2f", Float.valueOf(height)));
        dimensionInfo.put("Width (in)", String.format(Locale.ROOT, "%.2f", Float.valueOf(widthInInches)));
        dimensionInfo.put("Height (in)", String.format(Locale.ROOT, "%.2f", Float.valueOf(heightInInches)));
        dimensionInfo.put("Width (cm)", String.format(Locale.ROOT, "%.2f", Float.valueOf(widthInCm)));
        dimensionInfo.put("Height (cm)", String.format(Locale.ROOT, "%.2f", Float.valueOf(heightInCm)));
    }

    private static ArrayNode exploreStructureTree(List<Object> nodes) {
        ArrayNode elementsArray = objectMapper.createArrayNode();
        if (nodes != null) {
            for (Object obj : nodes) {
                if (!(obj instanceof PDStructureNode)) continue;
                PDStructureNode node = (PDStructureNode)obj;
                ObjectNode elementNode = objectMapper.createObjectNode();
                if (node instanceof PDStructureElement) {
                    PDStructureElement structureElement = (PDStructureElement)node;
                    elementNode.put("Type", structureElement.getStructureType());
                    elementNode.put("Content", GetInfoOnPDF.getContent((PDStructureElement)structureElement));
                    ArrayNode childElements = GetInfoOnPDF.exploreStructureTree((List)structureElement.getKids());
                    if (!childElements.isEmpty()) {
                        elementNode.set("Children", (JsonNode)childElements);
                    }
                }
                elementsArray.add((JsonNode)elementNode);
            }
        }
        return elementsArray;
    }

    private static String getContent(PDStructureElement structureElement) {
        StringBuilder contentBuilder = new StringBuilder();
        for (Object item : structureElement.getKids()) {
            if (item instanceof COSString) {
                COSString cosString = (COSString)item;
                contentBuilder.append(cosString.getString());
                continue;
            }
            if (!(item instanceof PDStructureElement)) continue;
            PDStructureElement pdstructureelement = (PDStructureElement)item;
            contentBuilder.append(GetInfoOnPDF.getContent((PDStructureElement)pdstructureelement));
        }
        return contentBuilder.toString();
    }

    private static String formatDate(Instant instant) {
        if (instant != null) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            ZonedDateTime zonedDateTime = instant.atZone(ZoneId.systemDefault());
            return zonedDateTime.format(formatter);
        }
        return null;
    }

    private static void validatePdfFile(MultipartFile file) {
        if (file == null || file.isEmpty()) {
            throw new IllegalArgumentException("PDF file is required");
        }
        if (file.getSize() > 0x6400000L) {
            throw ExceptionUtils.createIllegalArgumentException((String)"error.fileSizeLimit", (String)"File size ({0} bytes) exceeds maximum allowed size ({1} bytes)", (Object[])new Object[]{file.getSize(), 0x6400000L});
        }
        String contentType = file.getContentType();
        if (contentType != null && !"application/pdf".equals(contentType)) {
            log.warn("File content type is {}, expected application/pdf", (Object)contentType);
        }
    }

    private static ResponseEntity<byte[]> createErrorResponse(String errorMessage) {
        try {
            ObjectNode errorNode = objectMapper.createObjectNode();
            errorNode.put("error", errorMessage);
            errorNode.put("timestamp", System.currentTimeMillis());
            String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)errorNode);
            return WebResponseUtils.bytesToWebResponse((byte[])jsonString.getBytes(StandardCharsets.UTF_8), (String)"error.json", (MediaType)MediaType.APPLICATION_JSON);
        }
        catch (Exception e) {
            log.error("Failed to create error response", (Throwable)e);
            return ResponseEntity.internalServerError().build();
        }
    }

    private static ObjectNode extractMetadata(PDDocument document) {
        ObjectNode metadata = objectMapper.createObjectNode();
        try {
            PDDocumentInformation info = document.getDocumentInformation();
            if (info != null) {
                String modificationDate;
                String creationDate;
                if (info.getTitle() != null) {
                    metadata.put("Title", info.getTitle());
                }
                if (info.getAuthor() != null) {
                    metadata.put("Author", info.getAuthor());
                }
                if (info.getSubject() != null) {
                    metadata.put("Subject", info.getSubject());
                }
                if (info.getKeywords() != null) {
                    metadata.put("Keywords", info.getKeywords());
                }
                if (info.getProducer() != null) {
                    metadata.put("Producer", info.getProducer());
                }
                if (info.getCreator() != null) {
                    metadata.put("Creator", info.getCreator());
                }
                if ((creationDate = GetInfoOnPDF.formatDate(info.getCreationDate() != null ? info.getCreationDate().toInstant() : null)) != null) {
                    metadata.put("CreationDate", creationDate);
                }
                if ((modificationDate = GetInfoOnPDF.formatDate(info.getModificationDate() != null ? info.getModificationDate().toInstant() : null)) != null) {
                    metadata.put("ModificationDate", modificationDate);
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting metadata: {}", (Object)e.getMessage());
        }
        return metadata;
    }

    private static ObjectNode extractDocumentInfo(PDDocument document) {
        ObjectNode docInfoNode = objectMapper.createObjectNode();
        try {
            PDDocumentInformation info = document.getDocumentInformation();
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            docInfoNode.put("PDF version", document.getVersion());
            if (info != null) {
                docInfoNode.put("Trapped", info.getTrapped());
            }
            String pageMode = catalog.getPageMode().name();
            docInfoNode.put("Page Mode", GetInfoOnPDF.getPageModeDescription((String)pageMode));
        }
        catch (Exception e) {
            log.error("Error extracting document info: {}", (Object)e.getMessage());
        }
        return docInfoNode;
    }

    private static ObjectNode extractComplianceInfo(PDDocument document) {
        ObjectNode compliancy = objectMapper.createObjectNode();
        try {
            String pdfaConformanceLevel = GetInfoOnPDF.getPdfAConformanceLevel((PDDocument)document);
            boolean isPdfACompliant = pdfaConformanceLevel != null;
            boolean isPdfXCompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/X");
            boolean isPdfECompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/E");
            boolean isPdfVTCompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/VT");
            boolean isPdfUACompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/UA");
            boolean isPdfBCompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/B");
            boolean isPdfSECCompliant = GetInfoOnPDF.checkForStandard((PDDocument)document, (String)"PDF/SEC");
            compliancy.put("IsPDF/ACompliant", isPdfACompliant);
            if (pdfaConformanceLevel != null) {
                compliancy.put("PDF/AConformanceLevel", pdfaConformanceLevel);
                Boolean pdfaValidationPassed = GetInfoOnPDF.validatePdfAWithPreflight((PDDocument)document, (String)pdfaConformanceLevel);
                compliancy.put("IsPDF/AValidated", pdfaValidationPassed);
            }
            compliancy.put("IsPDF/XCompliant", isPdfXCompliant);
            compliancy.put("IsPDF/ECompliant", isPdfECompliant);
            compliancy.put("IsPDF/VTCompliant", isPdfVTCompliant);
            compliancy.put("IsPDF/UACompliant", isPdfUACompliant);
            compliancy.put("IsPDF/BCompliant", isPdfBCompliant);
            compliancy.put("IsPDF/SECCompliant", isPdfSECCompliant);
        }
        catch (Exception e) {
            log.error("Error extracting compliance info: {}", (Object)e.getMessage());
        }
        return compliancy;
    }

    private static ObjectNode extractEncryptionInfo(PDDocument document) {
        ObjectNode encryption = objectMapper.createObjectNode();
        try {
            if (document.isEncrypted()) {
                encryption.put("IsEncrypted", true);
                PDEncryption pdfEncryption = document.getEncryption();
                if (pdfEncryption != null) {
                    encryption.put("EncryptionAlgorithm", pdfEncryption.getFilter());
                    encryption.put("KeyLength", pdfEncryption.getLength());
                    encryption.put("Version", pdfEncryption.getVersion());
                    encryption.put("Revision", pdfEncryption.getRevision());
                }
            } else {
                encryption.put("IsEncrypted", false);
            }
        }
        catch (Exception e) {
            log.error("Error extracting encryption info: {}", (Object)e.getMessage());
        }
        return encryption;
    }

    private static ObjectNode extractPermissions(PDDocument document) {
        ObjectNode permissionsNode = objectMapper.createObjectNode();
        try {
            GetInfoOnPDF.setNodePermissions((PDDocument)document, (ObjectNode)permissionsNode);
        }
        catch (Exception e) {
            log.error("Error extracting permissions: {}", (Object)e.getMessage());
        }
        return permissionsNode;
    }

    private static ObjectNode extractFormFields(PDDocument document) {
        ObjectNode formFieldsNode = objectMapper.createObjectNode();
        try {
            PDAcroForm acroForm = document.getDocumentCatalog().getAcroForm();
            if (acroForm != null) {
                for (PDField field : acroForm.getFieldTree()) {
                    formFieldsNode.put(field.getFullyQualifiedName(), field.getValueAsString());
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting form fields: {}", (Object)e.getMessage());
        }
        return formFieldsNode;
    }

    private static ObjectNode extractOtherInfo(PDDocument document) {
        ObjectNode other = objectMapper.createObjectNode();
        try {
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            ArrayNode embeddedFilesArray = GetInfoOnPDF.extractEmbeddedFiles((PDDocumentCatalog)catalog);
            other.set("EmbeddedFiles", (JsonNode)embeddedFilesArray);
            ArrayNode attachmentsArray = GetInfoOnPDF.extractAttachments((PDDocument)document);
            other.set("Attachments", (JsonNode)attachmentsArray);
            ArrayNode javascriptArray = GetInfoOnPDF.extractJavaScript((PDDocumentCatalog)catalog);
            other.set("JavaScript", (JsonNode)javascriptArray);
            ArrayNode layersArray = GetInfoOnPDF.extractLayers((PDDocument)document);
            other.set("Layers", (JsonNode)layersArray);
            ArrayNode bookmarksArray = GetInfoOnPDF.extractBookmarks((PDDocument)document);
            other.set("Bookmarks/Outline/TOC", (JsonNode)bookmarksArray);
            String xmpString = GetInfoOnPDF.extractXMPMetadata((PDDocument)document);
            other.put("XMPMetadata", xmpString);
            try {
                PDStructureTreeRoot structureTreeRoot = document.getDocumentCatalog().getStructureTreeRoot();
                if (structureTreeRoot != null) {
                    ArrayNode structureTreeArray = GetInfoOnPDF.exploreStructureTree((List)structureTreeRoot.getKids());
                    other.set("StructureTree", (JsonNode)structureTreeArray);
                }
            }
            catch (Exception e) {
                log.error("Error extracting structure tree: {}", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            log.error("Error extracting other info: {}", (Object)e.getMessage());
        }
        return other;
    }

    private static ArrayNode extractEmbeddedFiles(PDDocumentCatalog catalog) {
        ArrayNode embeddedFilesArray = objectMapper.createArrayNode();
        try {
            Map efMap;
            PDEmbeddedFilesNameTreeNode efTree;
            if (catalog.getNames() != null && (efTree = catalog.getNames().getEmbeddedFiles()) != null && (efMap = efTree.getNames()) != null) {
                for (Map.Entry entry : efMap.entrySet()) {
                    ObjectNode embeddedFileNode = objectMapper.createObjectNode();
                    embeddedFileNode.put("Name", (String)entry.getKey());
                    PDEmbeddedFile embeddedFile = ((PDComplexFileSpecification)entry.getValue()).getEmbeddedFile();
                    if (embeddedFile != null) {
                        embeddedFileNode.put("FileSize", embeddedFile.getLength());
                        embeddedFileNode.put("MimeType", embeddedFile.getSubtype());
                        embeddedFileNode.put("CreationDate", GetInfoOnPDF.formatDate(embeddedFile.getCreationDate() != null ? embeddedFile.getCreationDate().toInstant() : null));
                        embeddedFileNode.put("ModificationDate", GetInfoOnPDF.formatDate(embeddedFile.getModDate() != null ? embeddedFile.getModDate().toInstant() : null));
                    }
                    embeddedFilesArray.add((JsonNode)embeddedFileNode);
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting embedded files: {}", (Object)e.getMessage());
        }
        return embeddedFilesArray;
    }

    private static ArrayNode extractAttachments(PDDocument document) {
        ArrayNode attachmentsArray = objectMapper.createArrayNode();
        try {
            for (PDPage page : document.getPages()) {
                for (PDAnnotation annotation : page.getAnnotations()) {
                    if (!(annotation instanceof PDAnnotationFileAttachment)) continue;
                    PDAnnotationFileAttachment fileAttachmentAnnotation = (PDAnnotationFileAttachment)annotation;
                    ObjectNode attachmentNode = objectMapper.createObjectNode();
                    attachmentNode.put("Name", fileAttachmentAnnotation.getAttachmentName());
                    attachmentNode.put("Description", fileAttachmentAnnotation.getContents());
                    try {
                        PDComplexFileSpecification fileSpec = (PDComplexFileSpecification)fileAttachmentAnnotation.getFile();
                        if (fileSpec != null && fileSpec.getEmbeddedFile() != null) {
                            attachmentNode.put("FileSize", fileSpec.getEmbeddedFile().getLength());
                        }
                    }
                    catch (Exception e) {
                        log.debug("Could not get attachment file size: {}", (Object)e.getMessage());
                    }
                    attachmentsArray.add((JsonNode)attachmentNode);
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting attachments: {}", (Object)e.getMessage());
        }
        return attachmentsArray;
    }

    private static ArrayNode extractJavaScript(PDDocumentCatalog catalog) {
        ArrayNode javascriptArray;
        block6: {
            javascriptArray = objectMapper.createArrayNode();
            try {
                PDJavascriptNameTreeNode javascriptDict;
                PDDocumentNameDictionary namesDict = catalog.getNames();
                if (namesDict == null || (javascriptDict = namesDict.getJavaScript()) == null) break block6;
                try {
                    Map jsEntries = javascriptDict.getNames();
                    for (Map.Entry entry : jsEntries.entrySet()) {
                        String jsCodeStr;
                        ObjectNode jsNode = objectMapper.createObjectNode();
                        jsNode.put("JS Name", (String)entry.getKey());
                        PDActionJavaScript jsAction = (PDActionJavaScript)entry.getValue();
                        if (jsAction != null && (jsCodeStr = jsAction.getAction()) != null) {
                            jsNode.put("JS Script Length", jsCodeStr.length());
                        }
                        javascriptArray.add((JsonNode)jsNode);
                    }
                }
                catch (IOException e) {
                    log.error("Error reading JavaScript entries: {}", (Object)e.getMessage());
                }
            }
            catch (Exception e) {
                log.error("Error extracting JavaScript: {}", (Object)e.getMessage());
            }
        }
        return javascriptArray;
    }

    private static ArrayNode extractLayers(PDDocument document) {
        ArrayNode layersArray = objectMapper.createArrayNode();
        try {
            PDOptionalContentProperties ocProperties = document.getDocumentCatalog().getOCProperties();
            if (ocProperties != null) {
                for (PDOptionalContentGroup ocg : ocProperties.getOptionalContentGroups()) {
                    ObjectNode layerNode = objectMapper.createObjectNode();
                    layerNode.put("Name", ocg.getName());
                    layersArray.add((JsonNode)layerNode);
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting layers: {}", (Object)e.getMessage());
        }
        return layersArray;
    }

    private static ArrayNode extractBookmarks(PDDocument document) {
        ArrayNode bookmarksArray = objectMapper.createArrayNode();
        try {
            PDDocumentOutline root = document.getDocumentCatalog().getDocumentOutline();
            if (root != null) {
                for (PDOutlineItem child : root.children()) {
                    GetInfoOnPDF.addOutlinesToArray((PDOutlineItem)child, (ArrayNode)bookmarksArray);
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting bookmarks: {}", (Object)e.getMessage());
        }
        return bookmarksArray;
    }

    private static String extractXMPMetadata(PDDocument document) {
        String xmpString;
        block16: {
            xmpString = null;
            try {
                PDMetadata pdMetadata = document.getDocumentCatalog().getMetadata();
                if (pdMetadata == null) break block16;
                try (COSInputStream inputStream = pdMetadata.createInputStream();){
                    DomXmpParser domXmpParser = new DomXmpParser();
                    XMPMetadata xmpMeta = domXmpParser.parse((InputStream)inputStream);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    new XmpSerializer().serialize(xmpMeta, (OutputStream)outputStream, true);
                    xmpString = outputStream.toString(StandardCharsets.UTF_8);
                }
                catch (XmpParsingException e) {
                    log.debug("XMP parsing failed, reading raw metadata: {}", (Object)e.getMessage());
                    try (COSInputStream inputStream2 = pdMetadata.createInputStream();){
                        byte[] metadataBytes = inputStream2.readAllBytes();
                        xmpString = new String(metadataBytes, StandardCharsets.UTF_8);
                    }
                }
            }
            catch (Exception e) {
                log.error("Error extracting XMP metadata: {}", (Object)e.getMessage());
            }
        }
        return xmpString;
    }

    private static ObjectNode extractPerPageInfo(PDDocument document) {
        ObjectNode pageInfoParent = objectMapper.createObjectNode();
        try {
            int pageCount = document.getNumberOfPages();
            StringBuilder keyBuilder = new StringBuilder("Page ".length() + 8);
            for (int pageNum = 0; pageNum < pageCount; ++pageNum) {
                try {
                    PDPage page = document.getPage(pageNum);
                    ObjectNode pageInfo = GetInfoOnPDF.extractSinglePageInfo((PDDocument)document, (PDPage)page, (int)pageNum);
                    keyBuilder.setLength(0);
                    keyBuilder.append("Page ").append(pageNum + 1);
                    pageInfoParent.set(keyBuilder.toString(), (JsonNode)pageInfo);
                    continue;
                }
                catch (Exception e) {
                    log.error("Error extracting info for page {}: {}", (Object)(pageNum + 1), (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            log.error("Error extracting per-page info: {}", (Object)e.getMessage());
        }
        return pageInfoParent;
    }

    private static ObjectNode extractSinglePageInfo(PDDocument document, PDPage page, int pageNum) throws IOException {
        ObjectNode pageInfo = objectMapper.createObjectNode();
        PDRectangle mediaBox = page.getMediaBox();
        float width = mediaBox.getWidth();
        float height = mediaBox.getHeight();
        ObjectNode sizeInfo = objectMapper.createObjectNode();
        GetInfoOnPDF.setDimensionInfo((ObjectNode)sizeInfo, (float)width, (float)height);
        sizeInfo.put("Standard Page", GetInfoOnPDF.getPageSize((float)width, (float)height));
        pageInfo.set("Size", (JsonNode)sizeInfo);
        pageInfo.put("Rotation", page.getRotation());
        pageInfo.put("Page Orientation", GetInfoOnPDF.getPageOrientation((double)width, (double)height));
        pageInfo.put("MediaBox", mediaBox.toString());
        pageInfo.put("CropBox", page.getCropBox() == null ? "Undefined" : page.getCropBox().toString());
        pageInfo.put("BleedBox", page.getBleedBox() == null ? "Undefined" : page.getBleedBox().toString());
        pageInfo.put("TrimBox", page.getTrimBox() == null ? "Undefined" : page.getTrimBox().toString());
        pageInfo.put("ArtBox", page.getArtBox() == null ? "Undefined" : page.getArtBox().toString());
        PDFTextStripper textStripper = new PDFTextStripper();
        textStripper.setStartPage(pageNum + 1);
        textStripper.setEndPage(pageNum + 1);
        String pageText = textStripper.getText(document);
        pageInfo.put("Text Characters Count", pageText.length());
        ObjectNode annotationsObject = GetInfoOnPDF.extractPageAnnotations((PDPage)page);
        pageInfo.set("Annotations", (JsonNode)annotationsObject);
        PDResources resources = page.getResources();
        if (resources != null) {
            ArrayNode imagesArray = GetInfoOnPDF.extractPageImages((PDResources)resources);
            pageInfo.set("Images", (JsonNode)imagesArray);
            ArrayNode linksArray = GetInfoOnPDF.extractPageLinks((PDPage)page);
            pageInfo.set("Links", (JsonNode)linksArray);
            ArrayNode fontsArray = GetInfoOnPDF.extractPageFonts((PDResources)resources);
            pageInfo.set("Fonts", (JsonNode)fontsArray);
            ObjectNode xObjectCountNode = GetInfoOnPDF.extractPageXObjects((PDResources)resources);
            pageInfo.set("XObjectCounts", (JsonNode)xObjectCountNode);
        }
        ArrayNode multimediaArray = GetInfoOnPDF.extractPageMultimedia((PDPage)page);
        pageInfo.set("Multimedia", (JsonNode)multimediaArray);
        return pageInfo;
    }

    private static ObjectNode extractPageAnnotations(PDPage page) throws IOException {
        ObjectNode annotationsObject = objectMapper.createObjectNode();
        List annotations = page.getAnnotations();
        int subtypeCount = 0;
        int contentsCount = 0;
        for (PDAnnotation annotation : annotations) {
            if (annotation.getSubtype() != null) {
                ++subtypeCount;
            }
            if (annotation.getContents() == null) continue;
            ++contentsCount;
        }
        annotationsObject.put("AnnotationsCount", annotations.size());
        annotationsObject.put("SubtypeCount", subtypeCount);
        annotationsObject.put("ContentsCount", contentsCount);
        return annotationsObject;
    }

    private static ArrayNode extractPageImages(PDResources resources) {
        ArrayNode imagesArray = objectMapper.createArrayNode();
        try {
            for (COSName name : resources.getXObjectNames()) {
                PDXObject xObject = resources.getXObject(name);
                if (!(xObject instanceof PDImageXObject)) continue;
                PDImageXObject image = (PDImageXObject)xObject;
                ObjectNode imageNode = objectMapper.createObjectNode();
                imageNode.put("Width", image.getWidth());
                imageNode.put("Height", image.getHeight());
                if (image.getMetadata() != null && image.getMetadata().getFile() != null && image.getMetadata().getFile().getFile() != null) {
                    imageNode.put("Name", image.getMetadata().getFile().getFile());
                }
                if (image.getColorSpace() != null) {
                    imageNode.put("ColorSpace", image.getColorSpace().getName());
                }
                imageNode.put("BitsPerComponent", image.getBitsPerComponent());
                imagesArray.add((JsonNode)imageNode);
            }
        }
        catch (Exception e) {
            log.error("Error extracting page images: {}", (Object)e.getMessage());
        }
        return imagesArray;
    }

    private static ArrayNode extractPageLinks(PDPage page) throws IOException {
        ArrayNode linksArray = objectMapper.createArrayNode();
        HashSet<String> uniqueURIs = new HashSet<String>();
        List annotations = page.getAnnotations();
        for (PDAnnotation annotation : annotations) {
            PDAnnotationLink linkAnnotation;
            PDAction pDAction;
            if (!(annotation instanceof PDAnnotationLink) || !((pDAction = (linkAnnotation = (PDAnnotationLink)annotation).getAction()) instanceof PDActionURI)) continue;
            PDActionURI uriAction = (PDActionURI)pDAction;
            String uri = uriAction.getURI();
            uniqueURIs.add(uri);
        }
        for (String uri : uniqueURIs) {
            ObjectNode linkNode = objectMapper.createObjectNode();
            linkNode.put("URI", uri);
            linksArray.add((JsonNode)linkNode);
        }
        return linksArray;
    }

    private static ArrayNode extractPageFonts(PDResources resources) {
        ArrayNode fontsArray = objectMapper.createArrayNode();
        HashMap<String, ObjectNode> uniqueFontsMap = new HashMap<String, ObjectNode>();
        try {
            for (COSName fontName : resources.getFontNames()) {
                String uniqueKey;
                PDFont font = resources.getFont(fontName);
                ObjectNode fontNode = objectMapper.createObjectNode();
                fontNode.put("IsEmbedded", font.isEmbedded());
                fontNode.put("Name", font.getName());
                fontNode.put("Subtype", font.getType());
                PDFontDescriptor fontDescriptor = font.getFontDescriptor();
                if (fontDescriptor != null) {
                    fontNode.put("ItalicAngle", fontDescriptor.getItalicAngle());
                    int flags = fontDescriptor.getFlags();
                    fontNode.put("IsItalic", (flags & 1) != 0);
                    fontNode.put("IsBold", (flags & 0x40) != 0);
                    fontNode.put("IsFixedPitch", (flags & 2) != 0);
                    fontNode.put("IsSerif", (flags & 4) != 0);
                    fontNode.put("IsSymbolic", (flags & 8) != 0);
                    fontNode.put("IsScript", (flags & 0x10) != 0);
                    fontNode.put("IsNonsymbolic", (flags & 0x20) != 0);
                    fontNode.put("FontFamily", fontDescriptor.getFontFamily());
                    fontNode.put("FontWeight", fontDescriptor.getFontWeight());
                }
                if (uniqueFontsMap.containsKey(uniqueKey = fontNode.toString())) {
                    ObjectNode existingFontNode = (ObjectNode)uniqueFontsMap.get(uniqueKey);
                    int count = existingFontNode.get("Count").asInt() + 1;
                    existingFontNode.put("Count", count);
                    continue;
                }
                fontNode.put("Count", 1);
                uniqueFontsMap.put(uniqueKey, fontNode);
            }
            for (ObjectNode uniqueFontNode : uniqueFontsMap.values()) {
                fontsArray.add((JsonNode)uniqueFontNode);
            }
        }
        catch (Exception e) {
            log.error("Error extracting page fonts: {}", (Object)e.getMessage());
        }
        return fontsArray;
    }

    private static ObjectNode extractPageXObjects(PDResources resources) {
        ObjectNode xObjectCountNode = objectMapper.createObjectNode();
        HashMap<String, Integer> xObjectCountMap = new HashMap<String, Integer>();
        try {
            for (COSName cOSName : resources.getXObjectNames()) {
                PDXObject xObject = resources.getXObject(cOSName);
                String xObjectType = xObject instanceof PDImageXObject ? "Image" : (xObject instanceof PDFormXObject ? "Form" : "Other");
                xObjectCountMap.put(xObjectType, xObjectCountMap.getOrDefault(xObjectType, 0) + 1);
            }
            for (Map.Entry entry : xObjectCountMap.entrySet()) {
                xObjectCountNode.put((String)entry.getKey(), (Integer)entry.getValue());
            }
        }
        catch (Exception e) {
            log.error("Error extracting page XObjects: {}", (Object)e.getMessage());
        }
        return xObjectCountNode;
    }

    private static ArrayNode extractPageMultimedia(PDPage page) throws IOException {
        ArrayNode multimediaArray = objectMapper.createArrayNode();
        List annotations = page.getAnnotations();
        for (PDAnnotation annotation : annotations) {
            if (!"RichMedia".equals(annotation.getSubtype())) continue;
            ObjectNode multimediaNode = objectMapper.createObjectNode();
            multimediaNode.put("Subtype", annotation.getSubtype());
            multimediaNode.put("Contents", annotation.getContents());
            multimediaArray.add((JsonNode)multimediaNode);
        }
        return multimediaArray;
    }

    private static ImageStatistics calculateImageStatistics(PDDocument document) {
        ImageStatistics stats = new ImageStatistics();
        stats.totalImages = 0;
        stats.uniqueImages = 0;
        try {
            HashSet<String> uniqueImageHashes = new HashSet<String>();
            for (PDPage page : document.getPages()) {
                PDResources resources = page.getResources();
                if (resources == null) continue;
                for (COSName xObjectName : resources.getXObjectNames()) {
                    PDXObject xObject = resources.getXObject(xObjectName);
                    if (!(xObject instanceof PDImageXObject)) continue;
                    PDImageXObject image = (PDImageXObject)xObject;
                    ++stats.totalImages;
                    String imageHash = String.format("%d_%d_%d_%s", image.getWidth(), image.getHeight(), image.getBitsPerComponent(), image.getSuffix());
                    uniqueImageHashes.add(imageHash);
                }
            }
            stats.uniqueImages = uniqueImageHashes.size();
        }
        catch (Exception e) {
            log.error("Error calculating image statistics: {}", (Object)e.getMessage());
        }
        return stats;
    }

    @PostMapping(consumes={"multipart/form-data"}, value={"/get-info-on-pdf"})
    @Operation(summary="Get comprehensive PDF information", description="Extracts all available information from a PDF file. Input:PDF Output:JSON Type:SISO")
    public ResponseEntity<byte[]> getPdfInfo(@ModelAttribute PDFFile request) throws IOException {
        ResponseEntity responseEntity;
        block13: {
            MultipartFile inputFile = request.getFileInput();
            try {
                GetInfoOnPDF.validatePdfFile((MultipartFile)inputFile);
            }
            catch (IllegalArgumentException e) {
                log.error("Invalid PDF file: {}", (Object)e.getMessage());
                return GetInfoOnPDF.createErrorResponse((String)("Invalid PDF file: " + e.getMessage()));
            }
            boolean readonly = true;
            PDDocument pdfBoxDoc = this.pdfDocumentFactory.load(inputFile, readonly);
            try {
                ObjectNode jsonOutput = objectMapper.createObjectNode();
                ObjectNode metadata = GetInfoOnPDF.extractMetadata((PDDocument)pdfBoxDoc);
                ObjectNode basicInfo = this.extractBasicInfo(pdfBoxDoc, inputFile.getSize());
                ObjectNode docInfoNode = GetInfoOnPDF.extractDocumentInfo((PDDocument)pdfBoxDoc);
                ObjectNode compliancy = GetInfoOnPDF.extractComplianceInfo((PDDocument)pdfBoxDoc);
                ObjectNode encryption = GetInfoOnPDF.extractEncryptionInfo((PDDocument)pdfBoxDoc);
                ObjectNode permissionsNode = GetInfoOnPDF.extractPermissions((PDDocument)pdfBoxDoc);
                ObjectNode other = GetInfoOnPDF.extractOtherInfo((PDDocument)pdfBoxDoc);
                ObjectNode formFieldsNode = GetInfoOnPDF.extractFormFields((PDDocument)pdfBoxDoc);
                String pdfaConformanceLevel = GetInfoOnPDF.getPdfAConformanceLevel((PDDocument)pdfBoxDoc);
                Boolean pdfaValidationPassed = null;
                if (pdfaConformanceLevel != null) {
                    pdfaValidationPassed = GetInfoOnPDF.validatePdfAWithPreflight((PDDocument)pdfBoxDoc, (String)pdfaConformanceLevel);
                }
                ObjectNode summaryData = GetInfoOnPDF.generatePDFSummaryData((PDDocument)pdfBoxDoc, (String)pdfaConformanceLevel, pdfaValidationPassed);
                ObjectNode pageInfoParent = GetInfoOnPDF.extractPerPageInfo((PDDocument)pdfBoxDoc);
                jsonOutput.set("Metadata", (JsonNode)metadata);
                jsonOutput.set("BasicInfo", (JsonNode)basicInfo);
                jsonOutput.set("DocumentInfo", (JsonNode)docInfoNode);
                jsonOutput.set("Compliancy", (JsonNode)compliancy);
                jsonOutput.set("Encryption", (JsonNode)encryption);
                jsonOutput.set("Permissions", (JsonNode)permissionsNode);
                jsonOutput.set("FormFields", (JsonNode)formFieldsNode);
                jsonOutput.set("Other", (JsonNode)other);
                jsonOutput.set("PerPageInfo", (JsonNode)pageInfoParent);
                if (summaryData != null && !summaryData.isEmpty()) {
                    jsonOutput.set("SummaryData", (JsonNode)summaryData);
                }
                String jsonString = objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)jsonOutput);
                responseEntity = WebResponseUtils.bytesToWebResponse((byte[])jsonString.getBytes(StandardCharsets.UTF_8), (String)"response.json", (MediaType)MediaType.APPLICATION_JSON);
                if (pdfBoxDoc == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (pdfBoxDoc != null) {
                        try {
                            pdfBoxDoc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("IO error while processing PDF: {}", (Object)e.getMessage(), (Object)e);
                    return GetInfoOnPDF.createErrorResponse((String)("Error reading PDF file: " + e.getMessage()));
                }
                catch (Exception e) {
                    log.error("Unexpected error while processing PDF: {}", (Object)e.getMessage(), (Object)e);
                    return GetInfoOnPDF.createErrorResponse((String)("Unexpected error processing PDF: " + e.getMessage()));
                }
            }
            pdfBoxDoc.close();
        }
        return responseEntity;
    }

    private ObjectNode extractBasicInfo(PDDocument document, long fileSizeInBytes) {
        ObjectNode basicInfo = objectMapper.createObjectNode();
        try {
            basicInfo.put("FileSizeInBytes", fileSizeInBytes);
            String fullText = new PDFTextStripper().getText(document);
            String[] words = RegexPatternUtils.getInstance().getWhitespacePattern().split(fullText);
            int paragraphCount = RegexPatternUtils.getInstance().getMultiFormatNewlinePattern().split(fullText).length;
            basicInfo.put("WordCount", words.length);
            basicInfo.put("ParagraphCount", paragraphCount);
            basicInfo.put("CharacterCount", fullText.length());
            String language = document.getDocumentCatalog().getLanguage();
            if (language != null) {
                basicInfo.put("Language", language);
            }
            basicInfo.put("Number of pages", document.getNumberOfPages());
            ImageStatistics imageStats = GetInfoOnPDF.calculateImageStatistics((PDDocument)document);
            basicInfo.put("TotalImages", imageStats.totalImages);
            basicInfo.put("UniqueImages", imageStats.uniqueImages);
        }
        catch (Exception e) {
            log.error("Error extracting basic info: {}", (Object)e.getMessage());
        }
        return basicInfo;
    }

    private static String getPageModeDescription(String pageMode) {
        if (pageMode == null) {
            return "Unknown";
        }
        return RegexPatternUtils.getInstance().getPageModePattern().matcher(pageMode).replaceFirst("");
    }

    @Generated
    public GetInfoOnPDF(CustomPDFDocumentFactory pdfDocumentFactory) {
        this.pdfDocumentFactory = pdfDocumentFactory;
    }
}

