/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.SPDF.model.SplitTypes;
import stirling.software.common.model.api.PDFFile;

public class SplitPdfBySectionsRequest
extends PDFFile {
    @Schema(description="Pages to be split by section", defaultValue="SPLIT_ALL", requiredMode=Schema.RequiredMode.REQUIRED)
    private String pageNumbers;
    @Schema(implementation=SplitTypes.class, description="Modes for page split. Valid values are:\nSPLIT_ALL_EXCEPT_FIRST_AND_LAST: Splits all except the first and the last pages.\nSPLIT_ALL_EXCEPT_FIRST: Splits all except the first page.\nSPLIT_ALL_EXCEPT_LAST: Splits all except the last page.\nSPLIT_ALL: Splits all pages.\nCUSTOM: Custom split.\n")
    private String splitMode;
    @Schema(description="Number of horizontal divisions for each PDF page", defaultValue="0", minimum="0", requiredMode=Schema.RequiredMode.REQUIRED)
    private int horizontalDivisions;
    @Schema(description="Number of vertical divisions for each PDF page", defaultValue="1", minimum="0", requiredMode=Schema.RequiredMode.REQUIRED)
    private int verticalDivisions;
    @Schema(description="Merge the split documents into a single PDF", defaultValue="false", requiredMode=Schema.RequiredMode.REQUIRED)
    private Boolean merge;

    @Generated
    public SplitPdfBySectionsRequest() {
    }

    @Generated
    public String getPageNumbers() {
        return this.pageNumbers;
    }

    @Generated
    public String getSplitMode() {
        return this.splitMode;
    }

    @Generated
    public int getHorizontalDivisions() {
        return this.horizontalDivisions;
    }

    @Generated
    public int getVerticalDivisions() {
        return this.verticalDivisions;
    }

    @Generated
    public Boolean getMerge() {
        return this.merge;
    }

    @Generated
    public void setPageNumbers(String pageNumbers) {
        this.pageNumbers = pageNumbers;
    }

    @Generated
    public void setSplitMode(String splitMode) {
        this.splitMode = splitMode;
    }

    @Generated
    public void setHorizontalDivisions(int horizontalDivisions) {
        this.horizontalDivisions = horizontalDivisions;
    }

    @Generated
    public void setVerticalDivisions(int verticalDivisions) {
        this.verticalDivisions = verticalDivisions;
    }

    @Generated
    public void setMerge(Boolean merge) {
        this.merge = merge;
    }

    @Generated
    public String toString() {
        return "SplitPdfBySectionsRequest(pageNumbers=" + this.getPageNumbers() + ", splitMode=" + this.getSplitMode() + ", horizontalDivisions=" + this.getHorizontalDivisions() + ", verticalDivisions=" + this.getVerticalDivisions() + ", merge=" + this.getMerge() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SplitPdfBySectionsRequest)) {
            return false;
        }
        SplitPdfBySectionsRequest other = (SplitPdfBySectionsRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHorizontalDivisions() != other.getHorizontalDivisions()) {
            return false;
        }
        if (this.getVerticalDivisions() != other.getVerticalDivisions()) {
            return false;
        }
        Boolean this$merge = this.getMerge();
        Boolean other$merge = other.getMerge();
        if (this$merge == null ? other$merge != null : !((Object)this$merge).equals(other$merge)) {
            return false;
        }
        String this$pageNumbers = this.getPageNumbers();
        String other$pageNumbers = other.getPageNumbers();
        if (this$pageNumbers == null ? other$pageNumbers != null : !this$pageNumbers.equals(other$pageNumbers)) {
            return false;
        }
        String this$splitMode = this.getSplitMode();
        String other$splitMode = other.getSplitMode();
        return !(this$splitMode == null ? other$splitMode != null : !this$splitMode.equals(other$splitMode));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SplitPdfBySectionsRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHorizontalDivisions();
        result = result * 59 + this.getVerticalDivisions();
        Boolean $merge = this.getMerge();
        result = result * 59 + ($merge == null ? 43 : ((Object)$merge).hashCode());
        String $pageNumbers = this.getPageNumbers();
        result = result * 59 + ($pageNumbers == null ? 43 : $pageNumbers.hashCode());
        String $splitMode = this.getSplitMode();
        result = result * 59 + ($splitMode == null ? 43 : $splitMode.hashCode());
        return result;
    }
}

