/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.converters;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.common.model.api.PDFFile;

public class PdfToVideoRequest
extends PDFFile {
    @Schema(description="The output video format", allowableValues={"mp4", "webm"}, defaultValue="mp4")
    private String videoFormat = "mp4";
    @Schema(description="Seconds each page should appear in the video", minimum="1", maximum="30", defaultValue="3")
    private Integer secondsPerPage = 3;
    @Schema(description="Target video resolution", allowableValues={"ORIGINAL", "1080p", "720p", "480p"}, defaultValue="ORIGINAL")
    private String resolution = "ORIGINAL";
    @Schema(description="DPI to render PDF pages before encoding", minimum="72", maximum="500", defaultValue="150")
    private Integer dpi = 150;
    @Schema(description="Opacity of the watermark (only applied if a watermark text is specified)", minimum="0.0", maximum="1.0", defaultValue="0.1")
    private Float opacity = Float.valueOf(0.1f);
    @Schema(description="Watermark text to overlay on the video", example="Stirling Software", defaultValue="Stirling Software")
    private String watermarkText;

    @Generated
    public PdfToVideoRequest() {
    }

    @Generated
    public String getVideoFormat() {
        return this.videoFormat;
    }

    @Generated
    public Integer getSecondsPerPage() {
        return this.secondsPerPage;
    }

    @Generated
    public String getResolution() {
        return this.resolution;
    }

    @Generated
    public Integer getDpi() {
        return this.dpi;
    }

    @Generated
    public Float getOpacity() {
        return this.opacity;
    }

    @Generated
    public String getWatermarkText() {
        return this.watermarkText;
    }

    @Generated
    public void setVideoFormat(String videoFormat) {
        this.videoFormat = videoFormat;
    }

    @Generated
    public void setSecondsPerPage(Integer secondsPerPage) {
        this.secondsPerPage = secondsPerPage;
    }

    @Generated
    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    @Generated
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    @Generated
    public void setOpacity(Float opacity) {
        this.opacity = opacity;
    }

    @Generated
    public void setWatermarkText(String watermarkText) {
        this.watermarkText = watermarkText;
    }

    @Generated
    public String toString() {
        return "PdfToVideoRequest(videoFormat=" + this.getVideoFormat() + ", secondsPerPage=" + this.getSecondsPerPage() + ", resolution=" + this.getResolution() + ", dpi=" + this.getDpi() + ", opacity=" + this.getOpacity() + ", watermarkText=" + this.getWatermarkText() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PdfToVideoRequest)) {
            return false;
        }
        PdfToVideoRequest other = (PdfToVideoRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$secondsPerPage = this.getSecondsPerPage();
        Integer other$secondsPerPage = other.getSecondsPerPage();
        if (this$secondsPerPage == null ? other$secondsPerPage != null : !((Object)this$secondsPerPage).equals(other$secondsPerPage)) {
            return false;
        }
        Integer this$dpi = this.getDpi();
        Integer other$dpi = other.getDpi();
        if (this$dpi == null ? other$dpi != null : !((Object)this$dpi).equals(other$dpi)) {
            return false;
        }
        Float this$opacity = this.getOpacity();
        Float other$opacity = other.getOpacity();
        if (this$opacity == null ? other$opacity != null : !((Object)this$opacity).equals(other$opacity)) {
            return false;
        }
        String this$videoFormat = this.getVideoFormat();
        String other$videoFormat = other.getVideoFormat();
        if (this$videoFormat == null ? other$videoFormat != null : !this$videoFormat.equals(other$videoFormat)) {
            return false;
        }
        String this$resolution = this.getResolution();
        String other$resolution = other.getResolution();
        if (this$resolution == null ? other$resolution != null : !this$resolution.equals(other$resolution)) {
            return false;
        }
        String this$watermarkText = this.getWatermarkText();
        String other$watermarkText = other.getWatermarkText();
        return !(this$watermarkText == null ? other$watermarkText != null : !this$watermarkText.equals(other$watermarkText));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PdfToVideoRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $secondsPerPage = this.getSecondsPerPage();
        result = result * 59 + ($secondsPerPage == null ? 43 : ((Object)$secondsPerPage).hashCode());
        Integer $dpi = this.getDpi();
        result = result * 59 + ($dpi == null ? 43 : ((Object)$dpi).hashCode());
        Float $opacity = this.getOpacity();
        result = result * 59 + ($opacity == null ? 43 : ((Object)$opacity).hashCode());
        String $videoFormat = this.getVideoFormat();
        result = result * 59 + ($videoFormat == null ? 43 : $videoFormat.hashCode());
        String $resolution = this.getResolution();
        result = result * 59 + ($resolution == null ? 43 : $resolution.hashCode());
        String $watermarkText = this.getWatermarkText();
        result = result * 59 + ($watermarkText == null ? 43 : $watermarkText.hashCode());
        return result;
    }
}

