/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.model.api.general;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Generated;
import stirling.software.common.model.api.PDFFile;

public class BookletImpositionRequest
extends PDFFile {
    @Schema(description="The number of pages per side for booklet printing (always 2 for proper booklet).", type="number", defaultValue="2", requiredMode=Schema.RequiredMode.REQUIRED, allowableValues={"2"})
    private int pagesPerSheet = 2;
    @Schema(description="Boolean for if you wish to add border around the pages")
    private Boolean addBorder = false;
    @Schema(description="The spine location for the booklet.", type="string", defaultValue="LEFT", allowableValues={"LEFT", "RIGHT"})
    private String spineLocation = "LEFT";
    @Schema(description="Add gutter margin (inner margin for binding)")
    private Boolean addGutter = false;
    @Schema(description="Gutter margin size in points (used when addGutter is true)", type="number", defaultValue="12")
    private float gutterSize = 12.0f;
    @Schema(description="Generate both front and back sides (double-sided printing)")
    private Boolean doubleSided = true;
    @Schema(description="For manual duplex: which pass to generate", type="string", defaultValue="BOTH", allowableValues={"BOTH", "FIRST", "SECOND"})
    private String duplexPass = "BOTH";
    @Schema(description="Flip back sides for short-edge duplex printing (default is long-edge)")
    private Boolean flipOnShortEdge = false;

    @Generated
    public BookletImpositionRequest() {
    }

    @Generated
    public int getPagesPerSheet() {
        return this.pagesPerSheet;
    }

    @Generated
    public Boolean getAddBorder() {
        return this.addBorder;
    }

    @Generated
    public String getSpineLocation() {
        return this.spineLocation;
    }

    @Generated
    public Boolean getAddGutter() {
        return this.addGutter;
    }

    @Generated
    public float getGutterSize() {
        return this.gutterSize;
    }

    @Generated
    public Boolean getDoubleSided() {
        return this.doubleSided;
    }

    @Generated
    public String getDuplexPass() {
        return this.duplexPass;
    }

    @Generated
    public Boolean getFlipOnShortEdge() {
        return this.flipOnShortEdge;
    }

    @Generated
    public void setPagesPerSheet(int pagesPerSheet) {
        this.pagesPerSheet = pagesPerSheet;
    }

    @Generated
    public void setAddBorder(Boolean addBorder) {
        this.addBorder = addBorder;
    }

    @Generated
    public void setSpineLocation(String spineLocation) {
        this.spineLocation = spineLocation;
    }

    @Generated
    public void setAddGutter(Boolean addGutter) {
        this.addGutter = addGutter;
    }

    @Generated
    public void setGutterSize(float gutterSize) {
        this.gutterSize = gutterSize;
    }

    @Generated
    public void setDoubleSided(Boolean doubleSided) {
        this.doubleSided = doubleSided;
    }

    @Generated
    public void setDuplexPass(String duplexPass) {
        this.duplexPass = duplexPass;
    }

    @Generated
    public void setFlipOnShortEdge(Boolean flipOnShortEdge) {
        this.flipOnShortEdge = flipOnShortEdge;
    }

    @Generated
    public String toString() {
        return "BookletImpositionRequest(pagesPerSheet=" + this.getPagesPerSheet() + ", addBorder=" + this.getAddBorder() + ", spineLocation=" + this.getSpineLocation() + ", addGutter=" + this.getAddGutter() + ", gutterSize=" + this.getGutterSize() + ", doubleSided=" + this.getDoubleSided() + ", duplexPass=" + this.getDuplexPass() + ", flipOnShortEdge=" + this.getFlipOnShortEdge() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BookletImpositionRequest)) {
            return false;
        }
        BookletImpositionRequest other = (BookletImpositionRequest)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPagesPerSheet() != other.getPagesPerSheet()) {
            return false;
        }
        if (Float.compare(this.getGutterSize(), other.getGutterSize()) != 0) {
            return false;
        }
        Boolean this$addBorder = this.getAddBorder();
        Boolean other$addBorder = other.getAddBorder();
        if (this$addBorder == null ? other$addBorder != null : !((Object)this$addBorder).equals(other$addBorder)) {
            return false;
        }
        Boolean this$addGutter = this.getAddGutter();
        Boolean other$addGutter = other.getAddGutter();
        if (this$addGutter == null ? other$addGutter != null : !((Object)this$addGutter).equals(other$addGutter)) {
            return false;
        }
        Boolean this$doubleSided = this.getDoubleSided();
        Boolean other$doubleSided = other.getDoubleSided();
        if (this$doubleSided == null ? other$doubleSided != null : !((Object)this$doubleSided).equals(other$doubleSided)) {
            return false;
        }
        Boolean this$flipOnShortEdge = this.getFlipOnShortEdge();
        Boolean other$flipOnShortEdge = other.getFlipOnShortEdge();
        if (this$flipOnShortEdge == null ? other$flipOnShortEdge != null : !((Object)this$flipOnShortEdge).equals(other$flipOnShortEdge)) {
            return false;
        }
        String this$spineLocation = this.getSpineLocation();
        String other$spineLocation = other.getSpineLocation();
        if (this$spineLocation == null ? other$spineLocation != null : !this$spineLocation.equals(other$spineLocation)) {
            return false;
        }
        String this$duplexPass = this.getDuplexPass();
        String other$duplexPass = other.getDuplexPass();
        return !(this$duplexPass == null ? other$duplexPass != null : !this$duplexPass.equals(other$duplexPass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BookletImpositionRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPagesPerSheet();
        result = result * 59 + Float.floatToIntBits(this.getGutterSize());
        Boolean $addBorder = this.getAddBorder();
        result = result * 59 + ($addBorder == null ? 43 : ((Object)$addBorder).hashCode());
        Boolean $addGutter = this.getAddGutter();
        result = result * 59 + ($addGutter == null ? 43 : ((Object)$addGutter).hashCode());
        Boolean $doubleSided = this.getDoubleSided();
        result = result * 59 + ($doubleSided == null ? 43 : ((Object)$doubleSided).hashCode());
        Boolean $flipOnShortEdge = this.getFlipOnShortEdge();
        result = result * 59 + ($flipOnShortEdge == null ? 43 : ((Object)$flipOnShortEdge).hashCode());
        String $spineLocation = this.getSpineLocation();
        result = result * 59 + ($spineLocation == null ? 43 : $spineLocation.hashCode());
        String $duplexPass = this.getDuplexPass();
        result = result * 59 + ($duplexPass == null ? 43 : $duplexPass.hashCode());
        return result;
    }
}

