/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.service;

import jakarta.annotation.PostConstruct;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.core.ValidationException;
import org.verapdf.gf.foundry.VeraGreenfieldFoundryProvider;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.PDFAValidator;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.flavours.PDFFlavours;
import org.verapdf.pdfa.results.TestAssertion;
import org.verapdf.pdfa.results.ValidationResult;
import stirling.software.SPDF.model.api.security.PDFVerificationResult;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class VeraPDFService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VeraPDFService.class);
    private static final String NOT_PDFA_STANDARD_ID = "not-pdfa";
    private static final String NOT_PDFA_STANDARD_NAME = "Not PDF/A (no PDF/A identification metadata)";

    private static PDFVerificationResult convertToVerificationResult(ValidationResult result, PDFAFlavour declaredFlavour, PDFAFlavour validationFlavour) {
        PDFVerificationResult verificationResult = new PDFVerificationResult();
        PDFAFlavour validationProfile = validationFlavour != null ? validationFlavour : result.getPDFAFlavour();
        boolean validationIsPdfa = VeraPDFService.isPdfaFlavour((PDFAFlavour)validationProfile);
        if (validationProfile != null) {
            verificationResult.setValidationProfile(validationProfile.getId());
            verificationResult.setValidationProfileName(VeraPDFService.getStandardName((PDFAFlavour)validationProfile));
        }
        if (declaredFlavour != null) {
            verificationResult.setStandard(declaredFlavour.getId());
            verificationResult.setDeclaredPdfa(VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredFlavour));
        } else if (validationProfile != null && !validationIsPdfa) {
            verificationResult.setStandard(validationProfile.getId());
            verificationResult.setDeclaredPdfa(false);
        } else {
            verificationResult.setStandard("not-pdfa");
            verificationResult.setDeclaredPdfa(false);
        }
        for (TestAssertion assertion : result.getTestAssertions()) {
            if (assertion.getStatus() != TestAssertion.Status.FAILED) continue;
            PDFVerificationResult.ValidationIssue issue = VeraPDFService.createValidationIssue((TestAssertion)assertion);
            verificationResult.addFailure(issue);
        }
        verificationResult.setCompliant(result.isCompliant());
        String baseName = declaredFlavour != null ? VeraPDFService.getStandardName((PDFAFlavour)declaredFlavour) : (validationIsPdfa ? "Not PDF/A (no PDF/A identification metadata)" : (validationProfile != null ? VeraPDFService.getStandardName((PDFAFlavour)validationProfile) : "Unknown standard"));
        String standardDisplay = VeraPDFService.formatStandardDisplay((String)baseName, (int)verificationResult.getTotalFailures(), (boolean)VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredFlavour), (validationIsPdfa && declaredFlavour == null ? 1 : 0) != 0);
        verificationResult.setStandardName(standardDisplay);
        verificationResult.setComplianceSummary(standardDisplay);
        log.debug("Validation complete for profile {} (declared: {}): {} failures", new Object[]{validationProfile != null ? validationProfile.getId() : "unknown", declaredFlavour != null ? declaredFlavour.getId() : "not-pdfa", verificationResult.getTotalFailures()});
        return verificationResult;
    }

    private static PDFVerificationResult.ValidationIssue createValidationIssue(TestAssertion assertion) {
        PDFVerificationResult.ValidationIssue issue = new PDFVerificationResult.ValidationIssue();
        if (assertion.getRuleId() != null) {
            int testNumber;
            issue.setRuleId(assertion.getRuleId().toString());
            issue.setClause(assertion.getRuleId().getClause());
            if (assertion.getRuleId().getSpecification() != null) {
                issue.setSpecification(assertion.getRuleId().getSpecification().toString());
            }
            if ((testNumber = assertion.getRuleId().getTestNumber()) > 0) {
                issue.setTestNumber(String.valueOf(testNumber));
            }
        }
        issue.setMessage(assertion.getMessage());
        issue.setLocation(assertion.getLocation() != null ? assertion.getLocation().toString() : "Unknown");
        return issue;
    }

    private static PDFVerificationResult createNoPdfaDeclarationResult() {
        PDFVerificationResult result = new PDFVerificationResult();
        result.setStandard("not-pdfa");
        result.setStandardName("Not PDF/A (no PDF/A identification metadata)");
        result.setComplianceSummary("Not PDF/A (no PDF/A identification metadata)");
        result.setCompliant(false);
        result.setDeclaredPdfa(false);
        PDFVerificationResult.ValidationIssue issue = new PDFVerificationResult.ValidationIssue();
        issue.setMessage("Document does not declare PDF/A compliance in its XMP metadata.");
        issue.setSpecification("XMP pdfaid");
        result.addFailure(issue);
        return result;
    }

    private static PDFVerificationResult buildErrorResult(PDFAFlavour declaredFlavour, PDFAFlavour validationFlavour, String errorMessage) {
        PDFAFlavour declaredForResult;
        PDFVerificationResult errorResult = new PDFVerificationResult();
        PDFAFlavour pDFAFlavour = declaredForResult = VeraPDFService.isPdfaFlavour((PDFAFlavour)validationFlavour) ? declaredFlavour : validationFlavour;
        if (declaredForResult != null) {
            errorResult.setStandard(declaredForResult.getId());
            errorResult.setStandardName(VeraPDFService.getStandardName((PDFAFlavour)declaredForResult) + " with errors");
            errorResult.setDeclaredPdfa(VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredForResult));
        } else if (VeraPDFService.isPdfaFlavour((PDFAFlavour)validationFlavour)) {
            errorResult.setStandard("not-pdfa");
            errorResult.setStandardName("Not PDF/A (no PDF/A identification metadata)");
            errorResult.setDeclaredPdfa(false);
        } else {
            errorResult.setStandard(validationFlavour != null ? validationFlavour.getId() : "not-pdfa");
            errorResult.setStandardName((validationFlavour != null ? VeraPDFService.getStandardName((PDFAFlavour)validationFlavour) : "Unknown standard") + " with errors");
            errorResult.setDeclaredPdfa(false);
        }
        errorResult.setValidationProfile(validationFlavour != null ? validationFlavour.getId() : "not-pdfa");
        errorResult.setValidationProfileName(validationFlavour != null ? VeraPDFService.getStandardName((PDFAFlavour)validationFlavour) : "Unknown standard");
        errorResult.setComplianceSummary(errorResult.getStandardName());
        errorResult.setCompliant(false);
        PDFVerificationResult.ValidationIssue failure = new PDFVerificationResult.ValidationIssue();
        failure.setMessage(errorMessage);
        errorResult.addFailure(failure);
        return errorResult;
    }

    @PostConstruct
    public void initialize() {
        try {
            VeraGreenfieldFoundryProvider.initialise();
            log.info("VeraPDF Greenfield initialized successfully");
        }
        catch (Exception e) {
            log.error("Failed to initialize VeraPDF", (Throwable)e);
        }
    }

    public List<PDFVerificationResult> validatePDF(InputStream pdfStream) throws IOException, ValidationException, ModelParsingException, EncryptedPdfException {
        boolean hasPdfaDeclaration;
        List detectedFlavours;
        PDFAFlavour declaredFlavour;
        byte[] pdfBytes = pdfStream.readAllBytes();
        ArrayList<PDFVerificationResult> results = new ArrayList<PDFVerificationResult>();
        try (PDFAParser detectionParser = Foundries.defaultInstance().createParser((InputStream)new ByteArrayInputStream(pdfBytes));){
            declaredFlavour = detectionParser.getFlavour();
            detectedFlavours = detectionParser.getFlavours();
        }
        boolean hasValidPdfaMetadata = false;
        if (VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredFlavour)) {
            try (PDFAParser quickParser = Foundries.defaultInstance().createParser((InputStream)new ByteArrayInputStream(pdfBytes), declaredFlavour);){
                PDFAValidator quickValidator = Foundries.defaultInstance().createValidator(declaredFlavour, false);
                ValidationResult quickResult = quickValidator.validate(quickParser);
                hasValidPdfaMetadata = true;
                for (TestAssertion assertion : quickResult.getTestAssertions()) {
                    if (assertion.getStatus() != TestAssertion.Status.FAILED || assertion.getRuleId() == null) continue;
                    String clause = assertion.getRuleId().getClause();
                    int testNumber = assertion.getRuleId().getTestNumber();
                    if ("6.7.2".equals(clause) && testNumber == 1) {
                        hasValidPdfaMetadata = false;
                        log.debug("Document lacks XMP metadata (6.7.2): {}", (Object)assertion.getMessage());
                    } else {
                        if (!"6.7.11".equals(clause) || testNumber != 1) continue;
                        hasValidPdfaMetadata = false;
                        log.debug("Document lacks PDF/A identification in XMP (6.7.11): {}", (Object)assertion.getMessage());
                    }
                    break;
                }
            }
            catch (Exception e) {
                log.debug("Error checking for PDF/A identification: {}", (Object)e.getMessage());
                hasValidPdfaMetadata = false;
            }
        }
        ArrayList<PDFAFlavour> flavoursToValidate = new ArrayList<PDFAFlavour>();
        boolean bl = hasPdfaDeclaration = VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredFlavour) && hasValidPdfaMetadata;
        if (declaredFlavour != null) {
            boolean isDeclaredPdfa = VeraPDFService.isPdfaFlavour((PDFAFlavour)declaredFlavour);
            if (isDeclaredPdfa && hasPdfaDeclaration) {
                flavoursToValidate.add(declaredFlavour);
            } else if (!isDeclaredPdfa) {
                flavoursToValidate.add(declaredFlavour);
            }
        }
        for (PDFAFlavour flavour : detectedFlavours) {
            if (flavour.equals((Object)declaredFlavour)) continue;
            if (PDFFlavours.isFlavourFamily((PDFAFlavour)flavour, (PDFAFlavour.SpecificationFamily)PDFAFlavour.SpecificationFamily.PDF_A)) {
                if (hasPdfaDeclaration) {
                    flavoursToValidate.add(flavour);
                    continue;
                }
                log.debug("Ignoring detected PDF/A flavour {} because no PDF/A declaration exists in XMP", (Object)flavour.getId());
                continue;
            }
            if (!PDFFlavours.isFlavourFamily((PDFAFlavour)flavour, (PDFAFlavour.SpecificationFamily)PDFAFlavour.SpecificationFamily.PDF_UA) && !PDFFlavours.isFlavourFamily((PDFAFlavour)flavour, (PDFAFlavour.SpecificationFamily)PDFAFlavour.SpecificationFamily.WTPDF)) continue;
            flavoursToValidate.add(flavour);
        }
        if (!hasPdfaDeclaration) {
            results.add(VeraPDFService.createNoPdfaDeclarationResult());
        }
        if (flavoursToValidate.isEmpty()) {
            log.info("No verifiable PDF/A, PDF/UA, or WTPDF standards declared via XMP metadata");
            return results;
        }
        for (PDFAFlavour flavour : flavoursToValidate) {
            try {
                PDFAParser parser = Foundries.defaultInstance().createParser((InputStream)new ByteArrayInputStream(pdfBytes), flavour);
                try {
                    PDFAFlavour parserDeclared = parser.getFlavour();
                    PDFAValidator validator = Foundries.defaultInstance().createValidator(flavour, false);
                    ValidationResult result = validator.validate(parser);
                    PDFAFlavour declaredForResult = PDFFlavours.isFlavourFamily((PDFAFlavour)flavour, (PDFAFlavour.SpecificationFamily)PDFAFlavour.SpecificationFamily.PDF_A) ? parserDeclared : flavour;
                    results.add(VeraPDFService.convertToVerificationResult((ValidationResult)result, (PDFAFlavour)declaredForResult, (PDFAFlavour)flavour));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            catch (Exception e) {
                log.error("Error validating standard {}: {}", (Object)flavour.getId(), (Object)e.getMessage());
                results.add(VeraPDFService.buildErrorResult((PDFAFlavour)declaredFlavour, (PDFAFlavour)flavour, (String)("Validation error: " + e.getMessage())));
            }
        }
        return results;
    }

    private static boolean isPdfaFlavour(PDFAFlavour flavour) {
        return PDFFlavours.isFlavourFamily((PDFAFlavour)flavour, (PDFAFlavour.SpecificationFamily)PDFAFlavour.SpecificationFamily.PDF_A);
    }

    private static String formatStandardDisplay(String baseName, int errorCount, boolean declaredPdfa, boolean inferredPdfaWithoutDeclaration) {
        if (inferredPdfaWithoutDeclaration) {
            return "Not PDF/A (no PDF/A identification metadata)";
        }
        if (!declaredPdfa && "Not PDF/A (no PDF/A identification metadata)".equals(baseName)) {
            return "Not PDF/A (no PDF/A identification metadata)";
        }
        if (errorCount > 0) {
            return baseName + " with errors";
        }
        return baseName + " compliant";
    }

    private static String getStandardName(PDFAFlavour flavour) {
        String id = flavour.getId();
        String part = flavour.getPart().toString();
        String level = flavour.getLevel().toString();
        if (!(id.isEmpty() || id.charAt(0) != '1' && id.charAt(0) != '2' && id.charAt(0) != '3' && id.charAt(0) != '4')) {
            return "PDF/A-" + part + (level.isEmpty() ? "" : level);
        }
        if (id.contains("ua")) {
            return "PDF/UA-" + part;
        }
        if (id.contains("wtpdf")) {
            return "WTPDF " + part;
        }
        return flavour.toString();
    }
}

