/*
 * Decompiled with CFR 0.152.
 */
package stirling.software.SPDF.utils.text;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDResources;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stirling.software.SPDF.utils.text.TextEncodingHelper;
import stirling.software.common.util.RegexPatternUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextFinderUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TextFinderUtils.class);

    public static boolean validateFontReliability(PDFont font) {
        if (font == null) {
            return false;
        }
        if (font.isDamaged()) {
            log.debug("Font {} is marked as damaged - using TextEncodingHelper validation", (Object)font.getName());
        }
        if (TextEncodingHelper.canCalculateBasicWidths((PDFont)font)) {
            log.debug("Font {} passed basic width calculations - considering reliable", (Object)font.getName());
            return true;
        }
        String[] basicTests = new String[]{"1", "2", "3", "a", "A", "e", "E", " "};
        int workingChars = 0;
        for (String testChar : basicTests) {
            if (!TextEncodingHelper.canEncodeCharacters((PDFont)font, (String)testChar)) continue;
            ++workingChars;
        }
        if (workingChars > 0) {
            log.debug("Font {} can process {}/{} basic characters - considering reliable", new Object[]{font.getName(), workingChars, basicTests.length});
            return true;
        }
        log.debug("Font {} failed all basic tests - considering unreliable", (Object)font.getName());
        return false;
    }

    public static List<Pattern> createOptimizedSearchPatterns(Set<String> searchTerms, boolean useRegex, boolean wholeWordSearch) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String term : searchTerms) {
            if (term == null || term.trim().isEmpty()) continue;
            try {
                String patternString;
                String string = patternString = useRegex ? term.trim() : Pattern.quote(term.trim());
                if (wholeWordSearch) {
                    patternString = TextFinderUtils.applyWordBoundaries((String)term.trim(), (String)patternString);
                }
                Pattern pattern = RegexPatternUtils.getInstance().createSearchPattern(patternString, true);
                patterns.add(pattern);
                log.debug("Created search pattern: '{}' -> '{}'", (Object)term.trim(), (Object)patternString);
            }
            catch (Exception e) {
                log.warn("Failed to create pattern for term '{}': {}", (Object)term, (Object)e.getMessage());
            }
        }
        return patterns;
    }

    private static String applyWordBoundaries(String originalTerm, String patternString) {
        if (originalTerm.length() == 1 && Character.isDigit(originalTerm.charAt(0))) {
            return "(?<![\\w])" + patternString + "(?![\\w])";
        }
        if (originalTerm.length() == 1) {
            return "(?<![\\w])" + patternString + "(?![\\w])";
        }
        return "\\b" + patternString + "\\b";
    }

    public static boolean hasProblematicFonts(PDPage page) {
        if (page == null) {
            return false;
        }
        try {
            PDResources resources = page.getResources();
            if (resources == null) {
                return false;
            }
            int totalFonts = 0;
            int completelyUnusableFonts = 0;
            for (COSName fontName : resources.getFontNames()) {
                try {
                    PDFont font = resources.getFont(fontName);
                    if (font == null) continue;
                    ++totalFonts;
                    if (TextFinderUtils.validateFontReliability((PDFont)font)) continue;
                    ++completelyUnusableFonts;
                }
                catch (Exception e) {
                    log.debug("Font loading failed for {}: {}", (Object)fontName.getName(), (Object)e.getMessage());
                    ++totalFonts;
                }
            }
            boolean hasProblems = totalFonts > 0 && completelyUnusableFonts * 2 > totalFonts;
            log.debug("Page font analysis: {}/{} fonts are completely unusable - page {} problematic", new Object[]{completelyUnusableFonts, totalFonts, hasProblems ? "IS" : "is NOT"});
            return hasProblems;
        }
        catch (Exception e) {
            log.warn("Font analysis failed for page: {}", (Object)e.getMessage());
            return false;
        }
    }
}

