/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeval.function.math;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.jeval.Evaluator;
import net.sourceforge.jeval.function.Function;
import net.sourceforge.jeval.function.FunctionGroup;
import net.sourceforge.jeval.function.math.Abs;
import net.sourceforge.jeval.function.math.Acos;
import net.sourceforge.jeval.function.math.Asin;
import net.sourceforge.jeval.function.math.Atan;
import net.sourceforge.jeval.function.math.Atan2;
import net.sourceforge.jeval.function.math.Ceil;
import net.sourceforge.jeval.function.math.Cos;
import net.sourceforge.jeval.function.math.Exp;
import net.sourceforge.jeval.function.math.Floor;
import net.sourceforge.jeval.function.math.IEEEremainder;
import net.sourceforge.jeval.function.math.Log;
import net.sourceforge.jeval.function.math.Max;
import net.sourceforge.jeval.function.math.Min;
import net.sourceforge.jeval.function.math.Pow;
import net.sourceforge.jeval.function.math.Random;
import net.sourceforge.jeval.function.math.Rint;
import net.sourceforge.jeval.function.math.Round;
import net.sourceforge.jeval.function.math.Sin;
import net.sourceforge.jeval.function.math.Sqrt;
import net.sourceforge.jeval.function.math.Tan;
import net.sourceforge.jeval.function.math.ToDegrees;
import net.sourceforge.jeval.function.math.ToRadians;

public class MathFunctions
implements FunctionGroup {
    private List functions = new ArrayList();

    public MathFunctions() {
        this.functions.add(new Abs());
        this.functions.add(new Acos());
        this.functions.add(new Asin());
        this.functions.add(new Atan());
        this.functions.add(new Atan2());
        this.functions.add(new Ceil());
        this.functions.add(new Cos());
        this.functions.add(new Exp());
        this.functions.add(new Floor());
        this.functions.add(new IEEEremainder());
        this.functions.add(new Log());
        this.functions.add(new Max());
        this.functions.add(new Min());
        this.functions.add(new Pow());
        this.functions.add(new Random());
        this.functions.add(new Rint());
        this.functions.add(new Round());
        this.functions.add(new Sin());
        this.functions.add(new Sqrt());
        this.functions.add(new Tan());
        this.functions.add(new ToDegrees());
        this.functions.add(new ToRadians());
    }

    public String getName() {
        return "numberFunctions";
    }

    public List getFunctions() {
        return this.functions;
    }

    public void load(Evaluator evaluator) {
        Iterator functionIterator = this.functions.iterator();
        while (functionIterator.hasNext()) {
            evaluator.putFunction((Function)functionIterator.next());
        }
    }

    public void unload(Evaluator evaluator) {
        Iterator functionIterator = this.functions.iterator();
        while (functionIterator.hasNext()) {
            evaluator.removeFunction(((Function)functionIterator.next()).getName());
        }
    }
}

