/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.data.transform;

import java.util.Date;

public class TransformColumn
implements Comparable<TransformColumn>,
Cloneable {
    protected String transformId;
    protected String sourceColumnName;
    protected String targetColumnName;
    protected boolean pk;
    protected String transformType = "copy";
    protected String transformExpression;
    protected int transformOrder;
    protected IncludeOnType includeOn = IncludeOnType.ALL;
    protected Date createTime;
    protected Date lastUpdateTime;
    protected String lastUpdateBy;
    protected String sourceColumnNameLowerCase;
    protected String targetColumnNameLowerCase;

    public TransformColumn(String transformId) {
        this.transformId = transformId;
    }

    public TransformColumn() {
    }

    public TransformColumn(String sourceColumnName, String targetColumnName, boolean pk) {
        this.setSourceColumnName(sourceColumnName);
        this.setTargetColumnName(targetColumnName);
        this.pk = pk;
    }

    public TransformColumn(String sourceColumnName, String targetColumnName, boolean pk, String transformType, String transformExpression) {
        this(sourceColumnName, targetColumnName, pk);
        this.transformType = transformType;
        this.transformExpression = transformExpression;
    }

    public String getSourceColumnName() {
        return this.sourceColumnName;
    }

    public String getSourceColumnNameLowerCase() {
        return this.sourceColumnNameLowerCase;
    }

    public final void setSourceColumnName(String sourceColumnName) {
        this.sourceColumnName = sourceColumnName;
        this.sourceColumnNameLowerCase = sourceColumnName == null ? null : sourceColumnName.toLowerCase();
    }

    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public String getTargetColumnNameLowerCase() {
        return this.targetColumnNameLowerCase;
    }

    public final void setTargetColumnName(String targetColumnName) {
        this.targetColumnName = targetColumnName;
        this.targetColumnNameLowerCase = targetColumnName == null ? null : targetColumnName.toLowerCase();
    }

    public boolean isPk() {
        return this.pk;
    }

    public void setPk(boolean pk) {
        this.pk = pk;
    }

    public String getTransformType() {
        return this.transformType;
    }

    public void setTransformType(String transformType) {
        this.transformType = transformType;
    }

    public String getTransformExpression() {
        return this.transformExpression;
    }

    public void setTransformExpression(String transformExpression) {
        this.transformExpression = transformExpression;
    }

    public void setIncludeOn(IncludeOnType includeOn) {
        this.includeOn = includeOn;
    }

    public IncludeOnType getIncludeOn() {
        return this.includeOn;
    }

    public void setTransformOrder(int transformOrder) {
        this.transformOrder = transformOrder;
    }

    public int getTransformOrder() {
        return this.transformOrder;
    }

    public void setTransformId(String transformId) {
        this.transformId = transformId;
    }

    public String getTransformId() {
        return this.transformId;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getLastUpdateBy() {
        return this.lastUpdateBy;
    }

    public void setLastUpdateBy(String lastUpdateBy) {
        this.lastUpdateBy = lastUpdateBy;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includeOn == null ? 0 : this.includeOn.hashCode());
        result = 31 * result + (this.targetColumnName == null ? 0 : this.targetColumnName.hashCode());
        result = 31 * result + (this.transformId == null ? 0 : this.transformId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TransformColumn)) {
            return false;
        }
        TransformColumn other = (TransformColumn)obj;
        if (this.includeOn != other.includeOn) {
            return false;
        }
        if (this.targetColumnName == null ? other.targetColumnName != null : !this.targetColumnName.equals(other.targetColumnName)) {
            return false;
        }
        return !(this.transformId == null ? other.transformId != null : !this.transformId.equals(other.transformId));
    }

    public TransformColumn clone() {
        TransformColumn clone = new TransformColumn();
        clone.setTransformId(this.transformId);
        clone.setSourceColumnName(this.sourceColumnName);
        clone.setTargetColumnName(this.targetColumnName);
        clone.setPk(this.pk);
        clone.setTransformType(this.transformType);
        clone.setTransformExpression(this.transformExpression);
        clone.setTransformOrder(this.transformOrder);
        clone.setIncludeOn(this.includeOn);
        clone.setCreateTime(this.createTime == null ? null : new Date(this.createTime.getTime()));
        clone.setLastUpdateTime(this.lastUpdateTime == null ? null : new Date(this.lastUpdateTime.getTime()));
        clone.setLastUpdateBy(this.lastUpdateBy);
        return clone;
    }

    @Override
    public int compareTo(TransformColumn o) {
        return Integer.valueOf(this.transformOrder).compareTo(o.transformOrder);
    }

    public static enum IncludeOnType {
        INSERT,
        UPDATE,
        DELETE,
        ALL;


        public static IncludeOnType decode(String v) {
            if (v.equals("I")) {
                return INSERT;
            }
            if (v.equals("U")) {
                return UPDATE;
            }
            if (v.equals("D")) {
                return DELETE;
            }
            return ALL;
        }

        public String toDbValue() {
            if (this == INSERT) {
                return "I";
            }
            if (this == DELETE) {
                return "D";
            }
            if (this == UPDATE) {
                return "U";
            }
            return "*";
        }
    }
}

