/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.util.Objects;

public class PerfResult {
    private String name;
    private long count;
    private long millis;
    private float rating;
    private String outcome;
    public static final String OUTCOME_SUCCESS = "Success";
    public static final String OUTCOME_FAILED = "Failed";
    public static final String OUTCOME_SKIPPED = "Skipped";

    public PerfResult(String name, long count, long millis, float rating) {
        this.name = name;
        this.count = count;
        this.millis = millis;
        this.outcome = "";
    }

    public PerfResult(String name) {
        this.name = name;
        this.count = 0L;
        this.millis = 0L;
        this.outcome = "";
    }

    public int hashCode() {
        return Objects.hash(this.count, this.millis, this.name, this.outcome);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PerfResult other = (PerfResult)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.getClass().getSimpleName() + " { name=" + this.name + ", count=" + this.count + ", millis=" + this.millis + ", ops=" + this.getOperationsPerSecond() + " }";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getCount() {
        return this.count;
    }

    public void incrementCount(long inc) {
        this.count += inc;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getMillis() {
        return this.millis;
    }

    public void incrementMillis(long inc) {
        this.millis += inc;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public long getOperationsPerSecond() {
        if (this.millis > 0L) {
            return (long)((float)this.count / ((float)this.millis / 1000.0f));
        }
        return this.count;
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = rating;
    }

    public String getOutcome() {
        return this.outcome;
    }

    public void setOutcome(String outcome) {
        this.outcome = outcome;
    }
}

