/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.jumpmind.exception.IoException;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.StagingManager;
import org.jumpmind.symmetric.io.stage.ThresholdFileWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagedResource
implements IStagedResource {
    private static final Logger log = LoggerFactory.getLogger(StagedResource.class);
    private AtomicInteger references = new AtomicInteger(0);
    protected File directory;
    protected File file;
    protected String path;
    protected StringBuilder memoryBuffer;
    protected long lastUpdateTime;
    protected IStagedResource.State state;
    protected OutputStream outputStream = null;
    protected Map<Thread, InputStream> inputStreams = null;
    protected Map<Thread, BufferedReader> readers = null;
    protected BufferedWriter writer;
    protected StagingManager stagingManager;

    public StagedResource(File directory, String path, StagingManager stagingManager) {
        this.directory = directory;
        this.path = path;
        this.stagingManager = stagingManager;
        this.lastUpdateTime = System.currentTimeMillis();
        File doneFile = this.buildFile(IStagedResource.State.DONE);
        if (doneFile.exists()) {
            this.state = IStagedResource.State.DONE;
            this.file = doneFile;
            this.lastUpdateTime = this.file.lastModified();
        } else {
            this.state = IStagedResource.State.CREATE;
            this.file = this.buildFile(this.state);
            if (this.file.exists()) {
                this.lastUpdateTime = this.file.lastModified();
            }
        }
    }

    protected static String toPath(File directory, File file) {
        String path = file.getAbsolutePath();
        path = path.replaceAll("\\\\", "/");
        int extensionIndex = (path = path.substring(directory.getAbsolutePath().length(), file.getAbsolutePath().length())).lastIndexOf(".");
        if (extensionIndex > 0) {
            path = path.substring(1, extensionIndex);
            return path;
        }
        throw new IllegalStateException("Expected an extension of .done or .create at the end of the path and did not find it: " + path);
    }

    @Override
    public void reference() {
        this.references.incrementAndGet();
        log.debug("Increased reference to {} for {} by {}", new Object[]{this.references, this.path, Thread.currentThread().getName()});
    }

    @Override
    public void dereference() {
        this.references.decrementAndGet();
        log.debug("Decreased reference to {} for {} by {}", new Object[]{this.references, this.path, Thread.currentThread().getName()});
    }

    @Override
    public boolean isInUse() {
        return this.references.get() > 0 || this.readers != null && this.readers.size() > 0 || this.writer != null || this.inputStreams != null && this.inputStreams.size() > 0 || this.outputStream != null;
    }

    @Override
    public boolean isFileResource() {
        return this.file != null && this.file.exists();
    }

    @Override
    public boolean isMemoryResource() {
        return this.memoryBuffer != null && this.memoryBuffer.length() > 0;
    }

    protected final File buildFile(IStagedResource.State state) {
        return new File(this.directory, String.format("%s.%s", this.path, state.getExtensionName()));
    }

    @Override
    public IStagedResource.State getState() {
        return this.state;
    }

    @Override
    public void setState(IStagedResource.State state) {
        File newFile;
        if (this.file != null && this.file.exists() && !(newFile = this.buildFile(state)).equals(this.file)) {
            this.closeInternal();
            if (newFile.exists()) {
                if (this.writer != null || this.outputStream != null) {
                    throw new IoException("Could not write '{}' it is currently being written to", new Object[]{newFile.getAbsolutePath()});
                }
                if (!FileUtils.deleteQuietly((File)newFile)) {
                    log.warn("Failed to delete '{}' in preparation for renaming '{}'", (Object)newFile.getAbsolutePath(), (Object)this.file.getAbsoluteFile());
                    if (this.readers != null && this.readers.size() > 0) {
                        for (Thread thread : this.readers.keySet()) {
                            BufferedReader reader = this.readers.get(thread);
                            log.warn("Closing unwanted reader for '{}' that had been created on thread '{}'", (Object)newFile.getAbsolutePath(), (Object)thread.getName());
                            try {
                                if (reader == null) continue;
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    this.readers = null;
                    if (!FileUtils.deleteQuietly((File)newFile)) {
                        log.warn("Failed to delete '{}' for a second time", (Object)newFile.getAbsolutePath());
                    }
                }
            }
            if (!this.file.renameTo(newFile)) {
                this.handleFailedRename(this.file, newFile);
            }
        }
        this.refreshLastUpdateTime();
        this.state = state;
        this.file = this.buildFile(state);
    }

    protected void handleFailedRename(File oldFile, File newFile) {
        String msg = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        int tries = 5;
        while (!newFile.exists() && tries-- > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (newFile.exists()) {
            if (this.isSameFile(oldFile, newFile)) {
                msg = String.format("Had trouble renaming file.  The destination file already exists, and is the same size - will proceed. Source file: (%s size: %s lastModified: %s) Target file: (%s size: %s lastModified: %s)", oldFile, oldFile.length(), dateFormat.format(oldFile.lastModified()), newFile, newFile.length(), dateFormat.format(newFile.lastModified()));
                FileUtils.deleteQuietly((File)oldFile);
                log.info(msg);
                return;
            }
            msg = String.format("Had trouble renaming file.  The destination file already exists, but is not the same size. Source file: (%s size: %s lastModified: %s) Target file: (%s size: %s lastModified: %s)", oldFile, oldFile.length(), dateFormat.format(oldFile.lastModified()), newFile, newFile.length(), dateFormat.format(newFile.lastModified()));
        } else {
            msg = String.format("Had trouble renaming file. The destination file does not appear to exist. Source file: (%s size: %s lastModified: %s) Target file: (%s)", oldFile, oldFile.length(), dateFormat.format(oldFile.lastModified()), newFile);
        }
        log.warn(msg);
        throw new IllegalStateException(msg);
    }

    protected boolean isSameFile(File oldFile, File newFile) {
        return oldFile.length() == newFile.length();
    }

    @Override
    public synchronized BufferedReader getReader() {
        BufferedReader reader;
        this.refreshLastUpdateTime();
        Thread thread = Thread.currentThread();
        BufferedReader bufferedReader = reader = this.readers != null ? this.readers.get(thread) : null;
        if (reader == null) {
            if (this.file != null && this.file.exists()) {
                try {
                    reader = this.createReader();
                    this.createReadersMap();
                    this.readers.put(thread, reader);
                }
                catch (IOException ex) {
                    throw new IoException((Exception)ex);
                }
            } else if (this.memoryBuffer != null && this.memoryBuffer.length() > 0) {
                reader = new BufferedReader(new StringReader(this.memoryBuffer.toString()));
                this.createReadersMap();
                this.readers.put(thread, reader);
            } else {
                throw new IllegalStateException("There is no content to read.  Memory buffer was empty and " + this.file.getAbsolutePath() + " was not found.");
            }
        }
        return reader;
    }

    protected BufferedReader createReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8.name()));
    }

    private final synchronized void createReadersMap() {
        if (this.readers == null) {
            this.readers = new HashMap<Thread, BufferedReader>(this.path.contains("common") ? 10 : 1);
        }
    }

    private final synchronized void closeReadersMap() {
        if (this.readers != null && this.readers.size() == 0) {
            this.readers = null;
        }
    }

    private final synchronized void createInputStreamsMap() {
        if (this.inputStreams == null) {
            this.inputStreams = new HashMap<Thread, InputStream>(this.path.contains("common") ? 10 : 1);
        }
    }

    private final synchronized void closeInputStreamsMap() {
        if (this.inputStreams != null && this.inputStreams.size() == 0) {
            this.inputStreams = null;
        }
    }

    @Override
    public void close() {
        this.refreshLastUpdateTime();
        this.closeInternal();
    }

    private void closeInternal() {
        InputStream inputStream;
        BufferedReader reader;
        Thread thread = Thread.currentThread();
        BufferedReader bufferedReader = reader = this.readers != null ? this.readers.get(thread) : null;
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.readers.remove(thread);
            this.closeReadersMap();
        }
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.writer = null;
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
        }
        InputStream inputStream2 = inputStream = this.inputStreams != null ? this.inputStreams.get(thread) : null;
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.inputStreams.remove(thread);
            this.closeInputStreamsMap();
        }
    }

    @Override
    public void closeReaders() {
        if (this.readers != null) {
            for (BufferedReader reader : this.readers.values()) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            this.readers = null;
        }
    }

    @Override
    public OutputStream getOutputStream() {
        return this.getOutputStream(false);
    }

    @Override
    public OutputStream getOutputStream(boolean append) {
        this.refreshLastUpdateTime();
        try {
            if (this.outputStream == null && this.file != null) {
                if (!append && this.file.exists()) {
                    log.warn("getOutputStream had to delete {} because it already existed", (Object)this.file.getAbsolutePath());
                    this.file.delete();
                }
                this.file.getParentFile().mkdirs();
                this.outputStream = this.createOutputStream(append);
            }
            return this.outputStream;
        }
        catch (FileNotFoundException e) {
            throw new IoException((Exception)e);
        }
    }

    protected OutputStream createOutputStream(boolean append) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(this.file, append));
    }

    @Override
    public synchronized InputStream getInputStream() {
        InputStream reader;
        this.refreshLastUpdateTime();
        Thread thread = Thread.currentThread();
        InputStream inputStream = reader = this.inputStreams != null ? this.inputStreams.get(thread) : null;
        if (reader == null) {
            if (this.file != null && this.file.exists()) {
                try {
                    reader = this.createInputStream();
                    this.createInputStreamsMap();
                    this.inputStreams.put(thread, reader);
                }
                catch (IOException ex) {
                    throw new IoException((Exception)ex);
                }
            } else if (this.memoryBuffer != null && this.memoryBuffer.length() > 0) {
                reader = new ByteArrayInputStream(this.memoryBuffer.toString().getBytes(StandardCharsets.UTF_8));
                this.createInputStreamsMap();
                this.inputStreams.put(thread, reader);
            } else {
                throw new IllegalStateException("There is no content to read. " + this.file.getAbsolutePath() + " was not found.");
            }
        }
        return reader;
    }

    protected InputStream createInputStream() throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public BufferedWriter getWriter(long threshold) {
        this.refreshLastUpdateTime();
        if (this.writer == null) {
            if (this.file != null && this.file.exists()) {
                log.warn("getWriter had to delete {} because it already existed.", (Object)this.file.getAbsolutePath());
                this.file.delete();
            } else if (this.memoryBuffer != null) {
                log.warn("We had to delete the memory buffer for {} because it already existed", (Object)this.getPath());
                this.memoryBuffer = null;
            }
            this.memoryBuffer = threshold > 0L ? new StringBuilder() : null;
            this.writer = this.createWriter(threshold);
        }
        return this.writer;
    }

    protected BufferedWriter createWriter(long threshold) {
        return new BufferedWriter(new ThresholdFileWriter(threshold, this.memoryBuffer, this.file));
    }

    @Override
    public long getSize() {
        if (this.file != null && this.file.exists()) {
            return this.file.length();
        }
        if (this.memoryBuffer != null) {
            return this.memoryBuffer.length();
        }
        return 0L;
    }

    @Override
    public boolean exists() {
        return this.file != null && this.file.exists() && this.file.length() > 0L || this.memoryBuffer != null && this.memoryBuffer.length() > 0;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void refreshLastUpdateTime() {
        this.lastUpdateTime = System.currentTimeMillis();
    }

    @Override
    public boolean delete() {
        this.close();
        boolean deleted = false;
        if (this.file != null && this.file.exists()) {
            FileUtils.deleteQuietly((File)this.file);
            boolean bl = deleted = !this.file.exists();
        }
        if (this.memoryBuffer != null) {
            this.memoryBuffer = null;
            deleted = true;
        }
        this.stagingManager.removeResourcePath(this.path);
        if (deleted && log.isDebugEnabled() && this.path.contains("outgoing")) {
            log.debug("Deleted staging resource {}", (Object)this.path);
        }
        return deleted;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.file != null && this.file.exists() ? this.file.getAbsolutePath() : String.format("%d bytes in memory", this.memoryBuffer != null ? this.memoryBuffer.length() : 0);
    }
}

