/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io.stage;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.util.BinaryEncoding;
import org.jumpmind.symmetric.io.data.Batch;
import org.jumpmind.symmetric.io.stage.IStagedResource;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.io.stage.PerfListener;
import org.jumpmind.symmetric.io.stage.PerfResult;
import org.jumpmind.symmetric.io.stage.StagingFileLock;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StagingPerf {
    protected static final String STAGE_PATH = "test";
    protected static final String STAT_LOCK_ACQUIRE = "Acquire Lock";
    protected static final String STAT_BATCH_CREATE = "Create Batch File";
    protected static final String STAT_BATCH_WRITE = "Write Batch File";
    protected static final String STAT_BATCH_RENAME = "Rename Batch File";
    protected static final String STAT_BATCH_FIND = "Find Batch File";
    protected static final String STAT_BATCH_READ = "Read Batch File";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected IStagingManager stagingMgr;
    protected PerfListener listener;
    protected String serverInfo;

    public StagingPerf(IStagingManager stagingMgr, PerfListener listener) {
        this.stagingMgr = stagingMgr;
        this.listener = listener;
        this.serverInfo = String.format("Server: '%s' Host: '%s' IP: '%s'", this.getClass().getName(), AppUtils.getHostName(), AppUtils.getIpAddress());
    }

    public List<PerfResult> run(int seconds) {
        long startTime;
        HashMap<String, PerfResult> results = new HashMap<String, PerfResult>();
        long lastCallbackTime = startTime = System.currentTimeMillis();
        long totalSeconds = 0L;
        this.log.info("Starting staging test, duration of {} seconds", (Object)seconds);
        try {
            SecureRandom random = new SecureRandom();
            long startBatchId = random.nextInt(999999) + 1;
            long endBatchId = startBatchId + (long)(seconds * 500);
            for (long batchId = startBatchId; batchId < endBatchId; ++batchId) {
                Batch batch = new Batch(Batch.BatchType.EXTRACT, 0L, "default", BinaryEncoding.HEX, "master", "1", true);
                batch.setBatchId(1L);
                this.testBatch(batch, results);
                if (Thread.interrupted()) {
                    this.log.warn("Test ending because thread interrupted");
                } else {
                    long time = System.currentTimeMillis();
                    totalSeconds = (time - startTime) / 1000L;
                    if (totalSeconds < (long)seconds) {
                        if (time - lastCallbackTime <= 1000L) continue;
                        List<PerfResult> resultsAsList = this.getResultsAsList(results);
                        this.logResults(totalSeconds, resultsAsList);
                        this.listener.update(this.getResultsAsList(results), (float)totalSeconds / (float)seconds);
                        lastCallbackTime = time;
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error("Failed to run test", (Throwable)e);
        }
        List<PerfResult> resultsAsList = this.getResultsAsList(results);
        this.logResults(totalSeconds, resultsAsList);
        return resultsAsList;
    }

    protected void logResults(long totalSeconds, List<PerfResult> resultsAsList) {
        this.log.info("Running for {} seconds", (Object)totalSeconds);
        for (PerfResult result : resultsAsList) {
            this.log.info(result.toString());
        }
    }

    protected void testBatch(Batch batch, Map<String, PerfResult> results) {
        String resourceLocation;
        IStagedResource resource;
        long ts;
        String timestampedHeaderLine;
        block30: {
            timestampedHeaderLine = String.format("TEST: SymmetricDS staging file with random contents. Current Timestamp: %tc", System.currentTimeMillis());
            ts = System.currentTimeMillis();
            StagingFileLock lock = this.stagingMgr.acquireFileLock(this.serverInfo, STAGE_PATH, batch.getStagedLocation(), batch.getBatchId());
            if (!lock.isAcquired()) {
                String errorMsg = "Failed to create staging file " + lock.getLockFile().getAbsolutePath();
                this.failTask(results, STAT_LOCK_ACQUIRE, errorMsg);
                throw new RuntimeException(errorMsg);
            }
            this.incrementTaskDuration(results, STAT_LOCK_ACQUIRE, System.currentTimeMillis() - ts);
            lock.releaseLock();
            ts = System.currentTimeMillis();
            resource = this.stagingMgr.create(STAGE_PATH, batch.getStagedLocation(), batch.getBatchId());
            resourceLocation = "";
            if (resource != null) {
                resourceLocation = resource.getPath();
                this.incrementTaskDuration(results, STAT_BATCH_CREATE, System.currentTimeMillis() - ts);
                ts = System.currentTimeMillis();
                try (BufferedWriter writer = resource.getWriter(0L);){
                    writer.write(timestampedHeaderLine + "\n");
                    for (int i = 0; i < 100; ++i) {
                        writer.write(RandomStringUtils.secure().next(1000));
                    }
                    break block30;
                }
                catch (IOException e) {
                    String errorMsg = "Failed to write staging file " + resourceLocation + " " + e.getMessage();
                    this.failTask(results, STAT_BATCH_WRITE, errorMsg);
                    throw new RuntimeException(e);
                }
                finally {
                    resource.close();
                }
            }
            String errorMsg = "Failed to create staging file test";
            this.failTask(results, STAT_BATCH_CREATE, errorMsg);
            this.skipTask(results, STAT_BATCH_WRITE, null);
            this.skipTask(results, STAT_BATCH_RENAME, null);
            this.skipTask(results, STAT_BATCH_READ, null);
            this.skipTask(results, STAT_BATCH_FIND, null);
            throw new RuntimeException(errorMsg);
        }
        this.incrementTaskDuration(results, STAT_BATCH_WRITE, System.currentTimeMillis() - ts);
        ts = System.currentTimeMillis();
        resource.setState(IStagedResource.State.DONE);
        this.incrementTaskDuration(results, STAT_BATCH_RENAME, System.currentTimeMillis() - ts);
        ts = System.currentTimeMillis();
        resource = this.stagingMgr.find(STAGE_PATH, batch.getStagedLocation(), batch.getBatchId());
        if (resource == null) {
            String errorMsg = "Failed to locate staging file " + resourceLocation;
            this.failTask(results, STAT_BATCH_FIND, errorMsg);
            this.skipTask(results, STAT_BATCH_READ, null);
            throw new RuntimeException(errorMsg);
        }
        resourceLocation = resource.getPath();
        this.incrementTaskDuration(results, STAT_BATCH_FIND, System.currentTimeMillis() - ts);
        ts = System.currentTimeMillis();
        String testHeaderLine = null;
        try (BufferedReader reader = resource.getReader();){
            testHeaderLine = reader.readLine();
            if (testHeaderLine == null) {
                String errorMsg = "Failed to read contents of staging file " + resourceLocation;
                this.failTask(results, STAT_BATCH_READ, errorMsg);
                throw new RuntimeException(errorMsg);
            }
            if (!timestampedHeaderLine.equals(testHeaderLine)) {
                String errorMsg = "Failed to validate contents of staging file " + resourceLocation;
                this.failTask(results, STAT_BATCH_READ, errorMsg);
                throw new RuntimeException(errorMsg);
            }
            while (reader.readLine() != null) {
            }
        }
        catch (IOException e) {
            this.failTask(results, STAT_BATCH_READ, "Failed to read staging file " + resourceLocation + " " + e.getMessage());
            throw new RuntimeException(e);
        }
        finally {
            if (resource != null) {
                resource.close();
            }
        }
        this.incrementTaskDuration(results, STAT_BATCH_READ, System.currentTimeMillis() - ts);
        resource.delete();
    }

    protected void failTask(Map<String, PerfResult> results, String statName, String error) {
        PerfResult result = results.get(statName);
        if (result == null) {
            result = new PerfResult(statName);
            results.put(statName, result);
        }
        result.incrementCount(1L);
        if (error == null) {
            result.setOutcome("Failed");
        } else {
            result.setOutcome(error);
        }
    }

    protected void skipTask(Map<String, PerfResult> results, String statName, String outcome) {
        PerfResult result = results.get(statName);
        if (result == null) {
            result = new PerfResult(statName);
            results.put(statName, result);
        }
        result.incrementCount(1L);
        if (outcome == null) {
            result.setOutcome("Skipped");
        } else {
            result.setOutcome(outcome);
        }
    }

    protected void incrementTaskDuration(Map<String, PerfResult> results, String statName, long millis) {
        PerfResult result = results.get(statName);
        if (result == null) {
            result = new PerfResult(statName);
            results.put(statName, result);
        }
        result.incrementCount(1L);
        result.incrementMillis(millis);
        if (StringUtils.isBlank((CharSequence)result.getOutcome())) {
            result.setOutcome("Success");
        }
    }

    public static List<PerfResult> getEmptyResults() {
        ArrayList<PerfResult> list = new ArrayList<PerfResult>();
        list.add(new PerfResult(STAT_LOCK_ACQUIRE));
        list.add(new PerfResult(STAT_BATCH_CREATE));
        list.add(new PerfResult(STAT_BATCH_WRITE));
        list.add(new PerfResult(STAT_BATCH_RENAME));
        list.add(new PerfResult(STAT_BATCH_FIND));
        list.add(new PerfResult(STAT_BATCH_READ));
        return list;
    }

    protected List<PerfResult> getResultsAsList(Map<String, PerfResult> results) {
        ArrayList<PerfResult> list = new ArrayList<PerfResult>();
        this.updateTaskRating(STAT_LOCK_ACQUIRE, results, list, 50L, 8000L);
        this.updateTaskRating(STAT_BATCH_CREATE, results, list, 100L, 12000L);
        this.updateTaskRating(STAT_BATCH_WRITE, results, list, 5L, 200L);
        this.updateTaskRating(STAT_BATCH_RENAME, results, list, 150L, 18000L);
        this.updateTaskRating(STAT_BATCH_FIND, results, list, 150L, 18000L);
        this.updateTaskRating(STAT_BATCH_READ, results, list, 10L, 400L);
        return list;
    }

    protected void updateTaskRating(String statName, Map<String, PerfResult> results, List<PerfResult> list, long lowCount, long highCount) {
        PerfResult result = results.get(statName);
        if (result != null) {
            String outcome = result.getOutcome();
            if (!StringUtils.isBlank((CharSequence)statName) && !"Success".equals(outcome)) {
                result.setRating(0.0f);
            } else {
                long opSec = result.getOperationsPerSecond();
                if (opSec <= lowCount) {
                    result.setRating(1.0f);
                } else if (opSec >= highCount) {
                    result.setRating(9.9f);
                } else {
                    float rating = 9.9f * ((float)(opSec - lowCount) / (float)(highCount - lowCount));
                    result.setRating(rating);
                }
            }
            list.add(result);
        }
    }
}

