/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.ase;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ChangeCatalogConnectionHandler;
import org.jumpmind.db.sql.IConnectionHandler;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlUtils;

public class AseDdlReader
extends AbstractJdbcDdlReader {
    private Pattern isoDatePattern = Pattern.compile("'(\\d{4}\\-\\d{2}\\-\\d{2})'");
    private Pattern isoTimePattern = Pattern.compile("'(\\d{2}:\\d{2}:\\d{2})'");
    private int majorVersion;

    public AseDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
    }

    protected int getMajorVersion(DatabaseMetaDataWrapper metaData) throws SQLException {
        if (this.majorVersion == 0) {
            this.majorVersion = metaData.getMetaData().getDatabaseMajorVersion();
        }
        return this.majorVersion;
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineAutoIncrementFromResultSetMetaData(connection, table, table.getColumns());
            if (this.getMajorVersion(metaData) >= 15) {
                this.determineGeneratedColumns(connection, table, table.getColumns());
            }
        }
        return table;
    }

    protected void determineGeneratedColumns(Connection conn, Table table, Column[] columnsToCheck) {
        StringBuilder query = new StringBuilder();
        if (columnsToCheck == null || columnsToCheck.length == 0) {
            return;
        }
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplateDirty();
        query.append("select col.name, com.text\nfrom syscolumns col left join syscomments com\non col.computedcol = com.id\nwhere col.id = (select id from sysobjects where name = ?)");
        ArrayList<String> l = new ArrayList<String>();
        l.add(table.getName());
        List result = sqlTemplate.query(query.toString(), l.toArray());
        block0: for (Column column : columnsToCheck) {
            for (Row row : result) {
                if (!column.getName().equalsIgnoreCase(row.getString("name"))) continue;
                String definition = row.getString("text");
                if (definition == null) continue block0;
                column.setGenerated(true);
                if (definition.startsWith("AS ")) {
                    definition = definition.substring(2).trim();
                }
                column.setDefaultValue(definition);
                continue block0;
            }
        }
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        if (typeName != null && typeName.toUpperCase().startsWith("TEXT")) {
            return -1;
        }
        if (typeName != null && typeName.equalsIgnoreCase("BIGDATETIME")) {
            return 93;
        }
        if (typeName != null && typeName.equalsIgnoreCase("BIGTIME")) {
            return 92;
        }
        if (typeName != null && typeName.equalsIgnoreCase("UNITEXT")) {
            return -4;
        }
        if (typeName != null && typeName.equalsIgnoreCase("UNICHAR")) {
            return -3;
        }
        if (typeName != null && typeName.equalsIgnoreCase("UNIVARCHAR")) {
            return -3;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 2 && column.getSizeAsInt() == 18 && column.getScale() == 0) {
            column.setMappedTypeCode(-5);
        } else if (column.getMappedTypeCode() == 2 && column.getSizeAsInt() == 12 && column.getScale() == 0) {
            column.setMappedTypeCode(4);
        } else if (column.getDefaultValue() != null) {
            if (column.getMappedTypeCode() == 93) {
                Matcher matcher = this.isoDatePattern.matcher(column.getDefaultValue());
                Timestamp timestamp = null;
                if (matcher.matches()) {
                    timestamp = new Timestamp(Date.valueOf(matcher.group(1)).getTime());
                } else {
                    matcher = this.isoTimePattern.matcher(column.getDefaultValue());
                    if (matcher.matches()) {
                        timestamp = new Timestamp(Time.valueOf(matcher.group(1)).getTime());
                    }
                }
                if (timestamp != null) {
                    column.setDefaultValue(timestamp.toString());
                }
            } else if (TypeMap.isTextType((int)column.getMappedTypeCode())) {
                column.setDefaultValue(this.unescape(column.getDefaultValue(), "'", "''"));
            }
        }
        String typeName = column.getJdbcTypeName();
        if (typeName != null) {
            if (typeName.equalsIgnoreCase("date")) {
                this.removeColumnSize(column);
            } else if (typeName.equalsIgnoreCase("datetime") || typeName.equalsIgnoreCase("smalldatetime") || typeName.equalsIgnoreCase("bigdatetime") || typeName.equalsIgnoreCase("time") || typeName.equalsIgnoreCase("bigtime")) {
                this.resetColumnSize(column, String.valueOf(column.getScale()));
            }
        }
        return column;
    }

    @Override
    protected void readIndex(DatabaseMetaDataWrapper metaData, Map<String, Object> values, Map<String, IIndex> knownIndices) throws SQLException {
        String indexName;
        if (this.getPlatform().getDdlBuilder().isDelimitedIdentifierModeOn() && (indexName = (String)values.get("INDEX_NAME")) != null) {
            String delimiter = this.getPlatformInfo().getDelimiterToken();
            if (indexName != null && indexName.startsWith(delimiter) && indexName.endsWith(delimiter)) {
                indexName = indexName.substring(delimiter.length(), indexName.length() - delimiter.length());
                values.put("INDEX_NAME", indexName);
            }
        }
        super.readIndex(metaData, values, knownIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<ForeignKey> readForeignKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT refobjs.name, localtables.id, remotetables.name, remotetables.id");
        for (int idx = 1; idx <= 16; ++idx) {
            query.append(", refs.fokey");
            query.append(idx);
            query.append(", refs.refkey");
            query.append(idx);
        }
        query.append(" FROM dbo.sysreferences refs, dbo.sysobjects refobjs, dbo.sysobjects localtables, dbo.sysobjects remotetables");
        query.append(" WHERE refobjs.type = 'RI' AND refs.constrid = refobjs.id AND");
        query.append(" localtables.type = 'U' AND refs.tableid = localtables.id AND localtables.name = '");
        query.append(SqlUtils.sanitizeIdentifier((String)tableName));
        query.append("' AND remotetables.type = 'U' AND refs.reftabid = remotetables.id");
        Statement stmt = connection.createStatement();
        PreparedStatement prepStmt = connection.prepareStatement("SELECT name FROM dbo.syscolumns WHERE id = ? AND colid = ?");
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        try {
            ResultSet fkRs = stmt.executeQuery(query.toString());
            while (fkRs.next()) {
                ForeignKey fk = new ForeignKey(fkRs.getString(1));
                int localTableId = fkRs.getInt(2);
                int remoteTableId = fkRs.getInt(4);
                fk.setForeignTableName(fkRs.getString(3));
                for (int idx = 0; idx < 16; ++idx) {
                    short fkColIdx = fkRs.getShort(5 + idx + idx);
                    short pkColIdx = fkRs.getShort(6 + idx + idx);
                    Reference ref = new Reference();
                    if (fkColIdx == 0) break;
                    prepStmt.setInt(1, localTableId);
                    prepStmt.setShort(2, fkColIdx);
                    ResultSet colRs = prepStmt.executeQuery();
                    if (colRs.next()) {
                        ref.setLocalColumnName(colRs.getString(1));
                    }
                    colRs.close();
                    prepStmt.setInt(1, remoteTableId);
                    prepStmt.setShort(2, pkColIdx);
                    colRs = prepStmt.executeQuery();
                    if (colRs.next()) {
                        ref.setForeignColumnName(colRs.getString(1));
                    }
                    colRs.close();
                    fk.addReference(ref);
                }
                result.add(fk);
            }
            fkRs.close();
        }
        finally {
            stmt.close();
            prepStmt.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) throws SQLException {
        StringBuffer query = new StringBuffer();
        query.append("SELECT name = si.name FROM dbo.sysindexes si, dbo.sysobjects so WHERE so.name = '");
        query.append(table.getName());
        query.append("' AND si.name = '");
        query.append(index.getName());
        query.append("' AND so.id = si.id AND (si.status & 2048) > 0");
        try (Statement stmt = connection.createStatement();){
            ResultSet rs = stmt.executeQuery(query.toString());
            boolean result = rs.next();
            rs.close();
            boolean bl = result;
            return bl;
        }
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) throws SqlException {
        List<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT trig.name AS trigger_name, trig.id AS trigger_id, tab.name AS table_name, tab.id AS table_id, db.name AS catalog, trig.crdate AS created_on, tab.deltrig AS table_delete_trigger_id, tab.instrig AS table_insert_trigger_id, tab.updtrig AS table_update_trigger_id FROM sysobjects AS trig INNER JOIN sysobjects AS tab ON trig.id = tab.deltrig OR trig.id = tab.instrig OR trig.id = tab.updtrig INNER JOIN master.dbo.sysdatabases AS db ON db.dbid = db_id() WHERE tab.name = ? AND db.name = ? ";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("trigger_name"));
                trigger.setTableName(row.getString("table_name"));
                trigger.setCatalogName(row.getString("catalog"));
                trigger.setEnabled(true);
                trigger.setSource("");
                if (row.getString("table_insert_trigger_id").equals(row.getString("trigger_id"))) {
                    trigger.setTriggerType(Trigger.TriggerType.INSERT);
                    row.put("trigger_type", (Object)"insert");
                } else if (row.getString("table_delete_trigger_id").equals(row.getString("trigger_id"))) {
                    trigger.setTriggerType(Trigger.TriggerType.DELETE);
                    row.put("trigger_type", (Object)"delete");
                } else if (row.getString("table_update_trigger_id").equals(row.getString("trigger_id"))) {
                    trigger.setTriggerType(Trigger.TriggerType.UPDATE);
                    row.put("trigger_type", (Object)"update");
                }
                row.remove((Object)"table_insert_trigger_id");
                row.remove((Object)"table_delete_trigger_id");
                row.remove((Object)"table_update_trigger_id");
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, catalog});
        for (final Trigger trigger : triggers) {
            int id = (Integer)trigger.getMetaData().get("trigger_id");
            String sourceSql = "SELECT text FROM syscomments WHERE id = ? ORDER BY colid ";
            sqlTemplate.query(sourceSql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

                public Trigger mapRow(Row row) {
                    trigger.setSource(trigger.getSource() + "\n" + row.getString("text"));
                    return trigger;
                }
            }, new Object[]{id});
        }
        return triggers;
    }

    @Override
    protected String getTableNamePattern(String tableName) {
        tableName = tableName.replace("_", "\\_");
        tableName = tableName.replace("%", "\\%");
        return tableName;
    }

    @Override
    protected StringBuilder appendColumn(StringBuilder query, String identifier) {
        boolean useQuote;
        boolean bl = useQuote = identifier != null && identifier.length() <= this.platform.getDatabaseInfo().getMaxColumnNameLength() - 2;
        if (useQuote) {
            query.append("\"");
        }
        query.append(identifier);
        if (useQuote) {
            query.append("\"");
        }
        return query;
    }

    @Override
    protected IConnectionHandler getConnectionHandler(String catalog) {
        return new ChangeCatalogConnectionHandler(catalog == null ? this.platform.getDefaultCatalog() : catalog);
    }
}

