/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.firebird;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.sql.ConcurrencySqlException;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlTemplateSettings;
import org.jumpmind.db.sql.SymmetricLobHandler;

public class FirebirdJdbcSqlTemplate
extends JdbcSqlTemplate {
    public FirebirdJdbcSqlTemplate(DataSource dataSource, SqlTemplateSettings settings, SymmetricLobHandler lobHandler, DatabaseInfo databaseInfo) {
        super(dataSource, settings, lobHandler, databaseInfo);
        this.primaryKeyViolationCodes = new int[]{335544665, 335544349};
        this.uniqueKeyViolationNameRegex = new String[]{"unique index \"(.*?)\""};
        this.foreignKeyViolationCodes = new int[]{335544466};
        this.foreignKeyChildExistsViolationMessageParts = new String[]{"Foreign key references are present for the record"};
        this.deadlockSqlStates = new String[]{"40001"};
    }

    @Override
    public boolean supportsReturningKeys() {
        return true;
    }

    @Override
    protected boolean allowsNullForIdentityColumn() {
        return true;
    }

    @Override
    public boolean isDataTruncationViolation(Throwable ex) {
        SQLException sqlEx = this.findSQLException(ex);
        return sqlEx != null && sqlEx.getMessage() != null && sqlEx.getMessage().contains("State:22001");
    }

    public SqlException translate(String message, Throwable ex) {
        if (ex instanceof SQLException && ((SQLException)ex).getErrorCode() == 0x14000010) {
            throw new ConcurrencySqlException(message, ex);
        }
        return super.translate(message, ex);
    }
}

