/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.hana;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.platform.IDdlReader;
import org.jumpmind.db.sql.Row;

public class HanaDdlReader
extends AbstractJdbcDdlReader
implements IDdlReader {
    protected static final List<String> SUPPORTED_AUTO_INCREMENT_CLAUSES = List.of("BY DEFAULT AS IDENTITY", "ALWAYS AS IDENTITY");

    public HanaDdlReader(IDatabasePlatform platform) {
        super(platform);
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineExtraColumnInfo(table);
        }
        return table;
    }

    protected void determineExtraColumnInfo(Table table) {
        String sql = "SELECT column_name, generation_type FROM sys.table_columns WHERE schema_name = ? AND table_name = ?";
        List rows = this.platform.getSqlTemplateDirty().query(sql, new Object[]{table.getSchema(), table.getName()});
        for (Row row : rows) {
            Column column;
            String columnName = row.getString("column_name");
            String generationType = row.getString("generation_type");
            if (!StringUtils.isNotBlank((CharSequence)generationType) || (column = table.findColumn(columnName)) == null || !SUPPORTED_AUTO_INCREMENT_CLAUSES.stream().anyMatch(clause -> clause.equalsIgnoreCase(generationType))) continue;
            this.log.info("Setting auto-increment to true for column: {}, on table: {}", (Object)column.getName(), (Object)table.getName());
            column.setAutoIncrement(true);
            this.log.info("Setting generated to false to match schema for table: {}, column: {}", (Object)table.getName(), (Object)column.getName());
            column.setGenerated(false);
        }
        if (rows.isEmpty()) {
            this.log.warn("Could not find extra column info for table {}", (Object)table.getFullyQualifiedTableName());
        }
    }
}

