/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mssql;

import javax.sql.DataSource;
import org.jumpmind.db.platform.IDdlBuilder;
import org.jumpmind.db.platform.mssql.MsSql2008DatabasePlatform;
import org.jumpmind.db.platform.mssql.MsSql2016DdlBuilder;
import org.jumpmind.db.sql.SqlTemplateSettings;

public class MsSql2016DatabasePlatform
extends MsSql2008DatabasePlatform {
    public static final String JDBC_SUBPROTOCOL = "sqlserver";
    public static final int SP1_BUILD_NUMBER = 4001;

    public MsSql2016DatabasePlatform(DataSource dataSource, SqlTemplateSettings settings) {
        super(dataSource, settings);
        if (settings.isAllowTriggerCreateOrReplace()) {
            int majorVersion;
            String[] versionArray;
            boolean triggersCreateOrReplaceSupported = true;
            String versionString = this.sqlTemplateDirty.queryForString("select serverproperty('ProductVersion')", (Object[])null);
            if (versionString != null && (versionArray = versionString.split("[.]")).length == 4 && (majorVersion = Integer.parseInt(versionArray[0])) == 13) {
                int buildNumber = Integer.parseInt(versionArray[2]);
                triggersCreateOrReplaceSupported = buildNumber >= 4001;
            }
            this.getDatabaseInfo().setTriggersCreateOrReplaceSupported(triggersCreateOrReplaceSupported);
        }
    }

    @Override
    protected IDdlBuilder createDdlBuilder() {
        return new MsSql2016DdlBuilder();
    }

    @Override
    public String getName() {
        return "mssql2016";
    }
}

