/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.PlatformColumn;
import org.jumpmind.db.model.Reference;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.Trigger;
import org.jumpmind.db.platform.AbstractJdbcDdlReader;
import org.jumpmind.db.platform.DatabaseMetaDataWrapper;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.JdbcSqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.util.VersionUtil;

public class MySqlDdlReader
extends AbstractJdbcDdlReader {
    private Boolean mariaDbDriver = null;
    private boolean supportsGeneratedColumns;

    public MySqlDdlReader(IDatabasePlatform platform) {
        super(platform);
        this.setDefaultCatalogPattern(null);
        this.setDefaultSchemaPattern(null);
        this.setDefaultTablePattern("%");
        this.setDefaultColumnPattern("%");
        String versionString = platform.getSqlTemplate().getDatabaseProductVersion();
        this.supportsGeneratedColumns = !VersionUtil.isOlderThanVersion((String)versionString, (String)"5.7");
    }

    @Override
    protected String getResultSetCatalogName() {
        if (this.isMariaDbDriver()) {
            return "TABLE_SCHEMA";
        }
        return super.getResultSetCatalogName();
    }

    @Override
    protected Table readTable(Connection connection, DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Table table = super.readTable(connection, metaData, values);
        if (table != null) {
            this.determineExtraColumnInfo(table);
        }
        return table;
    }

    protected void determineExtraColumnInfo(Table table) {
        String sql = "SELECT column_name, extra, column_type" + (this.supportsGeneratedColumns ? ", generation_expression" : "") + " FROM information_schema.columns WHERE table_schema = ? AND table_name = ?";
        List rows = this.platform.getSqlTemplateDirty().query(sql, new Object[]{table.getCatalog(), table.getName()});
        for (Row row : rows) {
            PlatformColumn platformColumn;
            Column column;
            String extra = row.getString("extra");
            String columnName = row.getString("column_name");
            String columnType = row.getString("column_type");
            if (StringUtils.isNotBlank((CharSequence)extra) && (column = table.findColumn(columnName)) != null) {
                if (column.getMappedTypeCode() == 93 && extra.toLowerCase().contains("on update")) {
                    column.setAutoUpdate(true);
                    column.setGenerated(false);
                } else if (this.supportsGeneratedColumns && column.isGenerated()) {
                    if (extra.toUpperCase().contains("DEFAULT_GENERATED")) {
                        column.setGenerated(false);
                        column.setExpressionAsDefaultValue(true);
                    } else if (column.getDefaultValue() == null || column.getDefaultValue().equalsIgnoreCase("NULL")) {
                        column.setDefaultValue(row.getString("generation_expression"));
                    }
                } else if (extra.equalsIgnoreCase("auto_increment")) {
                    column.setAutoIncrement(true);
                }
            }
            if (columnType == null || !columnType.toLowerCase().startsWith("enum(")) continue;
            String[] parsedEnums = columnType.substring(5, columnType.length() - 1).split(",");
            for (int i = 0; i < parsedEnums.length; ++i) {
                parsedEnums[i] = StringUtils.unwrap((String)parsedEnums[i], (String)"'");
            }
            Column column2 = table.findColumn(columnName);
            if (column2 == null || (platformColumn = (PlatformColumn)column2.getPlatformColumns().get(this.platform.getName())) == null) continue;
            platformColumn.setEnumValues(parsedEnums);
        }
        if (rows.isEmpty()) {
            this.log.warn("Could not find extra column info for table {}", (Object)table.getFullyQualifiedTableName());
        }
    }

    @Override
    protected Integer mapUnknownJdbcTypeForColumn(Map<String, Object> values) {
        String typeName = (String)values.get("TYPE_NAME");
        Integer type = (Integer)values.get("DATA_TYPE");
        if ("YEAR".equals(typeName)) {
            return 4;
        }
        if ("INT UNSIGNED".equals(typeName)) {
            return -5;
        }
        if (typeName != null && typeName.endsWith("TEXT")) {
            boolean convertTextToLob;
            String catalog = (String)values.get("TABLE_CAT");
            String tableName = (String)values.get("TABLE_NAME");
            String columnName = (String)values.get("COLUMN_NAME");
            String collation = this.platform.getSqlTemplate().queryForString("select collation_name from information_schema.columns where table_schema = ? and table_name = ? and column_name = ?", new Object[]{catalog, tableName, columnName});
            String convertTextToLobParm = System.getProperty("mysqlddlreader.converttexttolob", "true");
            boolean bl = convertTextToLob = collation != null && collation.endsWith("_bin") && convertTextToLobParm.equalsIgnoreCase("true");
            if ("LONGTEXT".equals(typeName)) {
                return convertTextToLob ? 2004 : 2005;
            }
            if ("MEDIUMTEXT".equals(typeName)) {
                return convertTextToLob ? 2004 : -1;
            }
            if ("TEXT".equals(typeName)) {
                return convertTextToLob ? 2004 : -1;
            }
            if ("TINYTEXT".equals(typeName)) {
                return convertTextToLob ? 2004 : -1;
            }
            return super.mapUnknownJdbcTypeForColumn(values);
        }
        if (type != null && type == 1111 && "UUID".equalsIgnoreCase("UUID")) {
            return 12;
        }
        if (type != null && type == 1111) {
            return -1;
        }
        return super.mapUnknownJdbcTypeForColumn(values);
    }

    @Override
    protected Column readColumn(DatabaseMetaDataWrapper metaData, Map<String, Object> values) throws SQLException {
        Column column = super.readColumn(metaData, values);
        if (column.getMappedTypeCode() == 93) {
            this.adjustColumnSize(column, -20);
        } else if (column.getMappedTypeCode() == 92) {
            this.adjustColumnSize(column, -9);
        } else if (column.getMappedTypeCode() == 91) {
            this.removeColumnSize(column);
            if ("0000-00-00".equals(column.getDefaultValue())) {
                column.setDefaultValue(null);
                ((PlatformColumn)column.getPlatformColumns().get(this.platform.getName())).setDefaultValue("0000-00-00");
            }
        }
        if (column.getMappedTypeCode() == 93 && "0000-00-00 00:00:00".equals(column.getDefaultValue())) {
            column.setDefaultValue(null);
        }
        if ("".equals(column.getDefaultValue())) {
            column.setDefaultValue(null);
        }
        if (column.getJdbcTypeName().equalsIgnoreCase("POINT") || column.getJdbcTypeName().equalsIgnoreCase("LINESTRING") || column.getJdbcTypeName().equalsIgnoreCase("POLYGON")) {
            column.setJdbcTypeName("GEOMETRY");
        }
        if ("UUID".equalsIgnoreCase(column.getJdbcTypeName())) {
            column.setSize("36");
            PlatformColumn platformColumn = (PlatformColumn)column.getPlatformColumns().get(this.platform.getName());
            if (platformColumn != null && "UUID".equalsIgnoreCase(platformColumn.getType())) {
                platformColumn.setSize(-1);
            }
        }
        return column;
    }

    @Override
    protected void genericizeDefaultValuesAndUpdatePlatformColumn(Column column) {
        PlatformColumn platformColumn = column.findPlatformColumn(this.platform.getName());
        if (!"0000-00-00".equals(platformColumn.getDefaultValue())) {
            platformColumn.setDefaultValue(column.getDefaultValue());
        }
        if ("getdate()".equalsIgnoreCase(column.getDefaultValue())) {
            column.setDefaultValue("CURRENT_TIMESTAMP");
        }
    }

    @Override
    protected boolean isInternalPrimaryKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, IIndex index) {
        return "PRIMARY".equals(index.getName());
    }

    @Override
    protected boolean isInternalForeignKeyIndex(Connection connection, DatabaseMetaDataWrapper metaData, Table table, ForeignKey fk, IIndex index) {
        return this.getPlatform().getDdlBuilder().getForeignKeyName(table, fk).equals(index.getName());
    }

    protected boolean isMariaDbDriver() {
        if (this.mariaDbDriver == null) {
            this.mariaDbDriver = "mariadb-jdbc".equals(this.getPlatform().getSqlTemplate().getDriverName());
        }
        return this.mariaDbDriver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Collection<ForeignKey> readForeignKeys(Connection connection, DatabaseMetaDataWrapper metaData, String tableName) throws SQLException {
        if (!this.isMariaDbDriver()) {
            return super.readForeignKeys(connection, metaData, tableName);
        }
        LinkedHashMap<String, ForeignKey> fks = new LinkedHashMap<String, ForeignKey>();
        ResultSet fkData = null;
        try {
            fkData = metaData.getForeignKeys(tableName);
            while (fkData.next()) {
                int count = fkData.getMetaData().getColumnCount();
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (int i = 1; i <= count; ++i) {
                    values.put(fkData.getMetaData().getColumnName(i), fkData.getObject(i));
                }
                String fkName = (String)values.get("CONSTRAINT_NAME");
                ForeignKey fk = (ForeignKey)fks.get(fkName);
                if (fk == null) {
                    fk = new ForeignKey(fkName);
                    fk.setForeignTableName((String)values.get("REFERENCED_TABLE_NAME"));
                    fks.put(fkName, fk);
                }
                Reference ref = new Reference();
                ref.setForeignColumnName((String)values.get("REFERENCED_COLUMN_NAME"));
                ref.setLocalColumnName((String)values.get("COLUMN_NAME"));
                Object pos = values.get("POSITION_IN_UNIQUE_CONSTRAINT");
                if (pos instanceof Number) {
                    ref.setSequenceValue(((Number)pos).intValue());
                }
                fk.addReference(ref);
            }
        }
        finally {
            this.close(fkData);
        }
        return fks.values();
    }

    @Override
    public List<Trigger> getTriggers(String catalog, String schema, String tableName) {
        List<Trigger> triggers = new ArrayList();
        this.log.debug("Reading triggers for: " + tableName);
        JdbcSqlTemplate sqlTemplate = (JdbcSqlTemplate)this.platform.getSqlTemplate();
        String sql = "SELECT TRIGGER_NAME, TRIGGER_SCHEMA, TRIGGER_CATALOG, EVENT_MANIPULATION AS TRIGGER_TYPE, EVENT_OBJECT_TABLE AS TABLE_NAME, EVENT_OBJECT_SCHEMA AS TABLE_SCHEMA, EVENT_OBJECT_CATALOG AS TABLE_CATALOG, TRIG.* FROM INFORMATION_SCHEMA.TRIGGERS AS TRIG WHERE EVENT_OBJECT_TABLE=? and EVENT_OBJECT_SCHEMA=? ;";
        triggers = sqlTemplate.query(sql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

            public Trigger mapRow(Row row) {
                Trigger trigger = new Trigger();
                trigger.setName(row.getString("TRIGGER_NAME"));
                trigger.setCatalogName(row.getString("TRIGGER_CATALOG"));
                trigger.setSchemaName(row.getString("TRIGGER_SCHEMA"));
                trigger.setTableName(row.getString("TABLE_NAME"));
                trigger.setEnabled(true);
                String triggerType = row.getString("TRIGGER_TYPE");
                if (triggerType.equals("DELETE") || triggerType.equals("INSERT") || triggerType.equals("UPDATE")) {
                    trigger.setTriggerType(Trigger.TriggerType.valueOf((String)triggerType));
                }
                trigger.setMetaData((Map)row);
                return trigger;
            }
        }, new Object[]{tableName, catalog});
        for (final Trigger trigger : triggers) {
            String name = trigger.getName();
            String sourceSql = "SHOW CREATE TRIGGER `" + catalog + "`." + name;
            sqlTemplate.query(sourceSql, (ISqlRowMapper)new ISqlRowMapper<Trigger>(){

                public Trigger mapRow(Row row) {
                    trigger.setSource(row.getString("SQL Original Statement"));
                    return trigger;
                }
            }, new Object[0]);
        }
        return triggers;
    }
}

