/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.driver;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.jumpmind.driver.InterceptResult;
import org.jumpmind.driver.PreparedStatementWrapper;
import org.jumpmind.driver.WrapperInterceptor;
import org.jumpmind.properties.TypedProperties;

public class ConnectionWrapper
implements Connection {
    private WrapperInterceptor interceptor;
    private Connection wrapped;
    private TypedProperties engineProperties;

    public ConnectionWrapper(Connection wrapped) {
        this.wrapped = wrapped;
        TypedProperties systemPlusEngineProperties = new TypedProperties();
        systemPlusEngineProperties.putAll(System.getProperties());
        this.engineProperties = systemPlusEngineProperties;
        this.interceptor = WrapperInterceptor.createInterceptor(this, this.engineProperties);
    }

    public ConnectionWrapper(Connection wrapped, WrapperInterceptor interceptor) {
        this.wrapped = wrapped;
        this.interceptor = interceptor;
    }

    @Override
    public void setReadOnly(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setReadOnly", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setReadOnly(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setReadOnly", null, startTime, endTime, arg1);
    }

    @Override
    public void close() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("close", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.close();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("close", null, startTime, endTime, new Object[0]);
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isReadOnly", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isReadOnly();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isReadOnly", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void abort(Executor arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("abort", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.abort(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("abort", null, startTime, endTime, arg1);
    }

    @Override
    public Statement createStatement() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("createStatement", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Statement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Statement value = this.wrapped.createStatement();
        InterceptResult postResult = this.interceptor.postExecute("createStatement", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Statement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Statement createStatement(int arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("createStatement", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Statement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Statement value = this.wrapped.createStatement(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("createStatement", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Statement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Statement createStatement(int arg1, int arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("createStatement", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return (Statement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Statement value = this.wrapped.createStatement(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("createStatement", value, startTime, endTime, arg1, arg2, arg3);
        if (postResult.isIntercepted()) {
            return (Statement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public PreparedStatement prepareStatement(String arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String arg1, int arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1, arg2, arg3);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String arg1, int arg2, int arg3, int arg4) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1, arg2, arg3, arg4);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1, arg2, arg3, arg4);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1, arg2, arg3, arg4);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String arg1, int[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String arg1, String[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public PreparedStatement prepareStatement(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareStatement", arg1);
        if (preResult.isIntercepted()) {
            return (PreparedStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        PreparedStatement value = this.wrapped.prepareStatement(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareStatement", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (PreparedStatement)postResult.getInterceptResult();
        }
        return new PreparedStatementWrapper(value, arg1, this.engineProperties);
    }

    @Override
    public CallableStatement prepareCall(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareCall", arg1);
        if (preResult.isIntercepted()) {
            return (CallableStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        CallableStatement value = this.wrapped.prepareCall(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareCall", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (CallableStatement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public CallableStatement prepareCall(String arg1, int arg2, int arg3) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareCall", arg1, arg2, arg3);
        if (preResult.isIntercepted()) {
            return (CallableStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        CallableStatement value = this.wrapped.prepareCall(arg1, arg2, arg3);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareCall", value, startTime, endTime, arg1, arg2, arg3);
        if (postResult.isIntercepted()) {
            return (CallableStatement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public CallableStatement prepareCall(String arg1, int arg2, int arg3, int arg4) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("prepareCall", arg1, arg2, arg3, arg4);
        if (preResult.isIntercepted()) {
            return (CallableStatement)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        CallableStatement value = this.wrapped.prepareCall(arg1, arg2, arg3, arg4);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("prepareCall", value, startTime, endTime, arg1, arg2, arg3, arg4);
        if (postResult.isIntercepted()) {
            return (CallableStatement)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public String nativeSQL(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("nativeSQL", arg1);
        if (preResult.isIntercepted()) {
            return (String)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        String value = this.wrapped.nativeSQL(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("nativeSQL", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (String)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setAutoCommit(boolean arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setAutoCommit", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setAutoCommit(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setAutoCommit", null, startTime, endTime, arg1);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getAutoCommit", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.getAutoCommit();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getAutoCommit", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void commit() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("commit", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.commit();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("commit", null, startTime, endTime, new Object[0]);
    }

    @Override
    public void rollback(Savepoint arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("rollback", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.rollback(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("rollback", null, startTime, endTime, arg1);
    }

    @Override
    public void rollback() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("rollback", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.rollback();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("rollback", null, startTime, endTime, new Object[0]);
    }

    @Override
    public boolean isClosed() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isClosed", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isClosed();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isClosed", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getMetaData", new Object[0]);
        if (preResult.isIntercepted()) {
            return (DatabaseMetaData)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        DatabaseMetaData value = this.wrapped.getMetaData();
        InterceptResult postResult = this.interceptor.postExecute("getMetaData", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (DatabaseMetaData)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setCatalog(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setCatalog", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setCatalog(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setCatalog", null, startTime, endTime, arg1);
    }

    @Override
    public String getCatalog() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getCatalog", new Object[0]);
        if (preResult.isIntercepted()) {
            return (String)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        String value = this.wrapped.getCatalog();
        InterceptResult postResult = this.interceptor.postExecute("getCatalog", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (String)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setTransactionIsolation(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTransactionIsolation", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTransactionIsolation(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTransactionIsolation", null, startTime, endTime, arg1);
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getTransactionIsolation", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getTransactionIsolation();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getTransactionIsolation", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return (SQLWarning)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        SQLWarning value = this.wrapped.getWarnings();
        InterceptResult postResult = this.interceptor.postExecute("getWarnings", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (SQLWarning)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void clearWarnings() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("clearWarnings", new Object[0]);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.clearWarnings();
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("clearWarnings", null, startTime, endTime, new Object[0]);
    }

    public Map getTypeMap() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getTypeMap", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Map)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Map<String, Class<?>> value = this.wrapped.getTypeMap();
        InterceptResult postResult = this.interceptor.postExecute("getTypeMap", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Map)postResult.getInterceptResult();
        }
        return value;
    }

    public void setTypeMap(Map arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setTypeMap", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setTypeMap(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setTypeMap", null, startTime, endTime, arg1);
    }

    @Override
    public void setHoldability(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setHoldability", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setHoldability(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setHoldability", null, startTime, endTime, arg1);
    }

    @Override
    public int getHoldability() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getHoldability", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getHoldability();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getHoldability", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("setSavepoint", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Savepoint)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Savepoint value = this.wrapped.setSavepoint();
        InterceptResult postResult = this.interceptor.postExecute("setSavepoint", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Savepoint)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Savepoint setSavepoint(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setSavepoint", arg1);
        if (preResult.isIntercepted()) {
            return (Savepoint)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Savepoint value = this.wrapped.setSavepoint(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("setSavepoint", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Savepoint)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void releaseSavepoint(Savepoint arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("releaseSavepoint", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.releaseSavepoint(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("releaseSavepoint", null, startTime, endTime, arg1);
    }

    @Override
    public Clob createClob() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("createClob", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Clob)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Clob value = this.wrapped.createClob();
        InterceptResult postResult = this.interceptor.postExecute("createClob", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Clob)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Blob createBlob() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("createBlob", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Blob)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Blob value = this.wrapped.createBlob();
        InterceptResult postResult = this.interceptor.postExecute("createBlob", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Blob)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public NClob createNClob() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("createNClob", new Object[0]);
        if (preResult.isIntercepted()) {
            return (NClob)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        NClob value = this.wrapped.createNClob();
        InterceptResult postResult = this.interceptor.postExecute("createNClob", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (NClob)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("createSQLXML", new Object[0]);
        if (preResult.isIntercepted()) {
            return (SQLXML)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        SQLXML value = this.wrapped.createSQLXML();
        InterceptResult postResult = this.interceptor.postExecute("createSQLXML", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (SQLXML)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public boolean isValid(int arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isValid", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isValid(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isValid", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setClientInfo(Properties arg1) throws SQLClientInfoException {
        InterceptResult preResult = this.interceptor.preExecute("setClientInfo", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setClientInfo(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setClientInfo", null, startTime, endTime, arg1);
    }

    @Override
    public void setClientInfo(String arg1, String arg2) throws SQLClientInfoException {
        InterceptResult preResult = this.interceptor.preExecute("setClientInfo", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setClientInfo(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setClientInfo", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getClientInfo", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Properties)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Properties value = this.wrapped.getClientInfo();
        InterceptResult postResult = this.interceptor.postExecute("getClientInfo", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (Properties)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public String getClientInfo(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getClientInfo", arg1);
        if (preResult.isIntercepted()) {
            return (String)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        String value = this.wrapped.getClientInfo(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getClientInfo", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (String)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Array createArrayOf(String arg1, Object[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("createArrayOf", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Array)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Array value = this.wrapped.createArrayOf(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("createArrayOf", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Array)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public Struct createStruct(String arg1, Object[] arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("createStruct", arg1, arg2);
        if (preResult.isIntercepted()) {
            return (Struct)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Struct value = this.wrapped.createStruct(arg1, arg2);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("createStruct", value, startTime, endTime, arg1, arg2);
        if (postResult.isIntercepted()) {
            return (Struct)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setSchema(String arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setSchema", arg1);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setSchema(arg1);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setSchema", null, startTime, endTime, arg1);
    }

    @Override
    public String getSchema() throws SQLException {
        long endTime;
        InterceptResult preResult = this.interceptor.preExecute("getSchema", new Object[0]);
        if (preResult.isIntercepted()) {
            return (String)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        String value = this.wrapped.getSchema();
        InterceptResult postResult = this.interceptor.postExecute("getSchema", value, startTime, endTime = System.currentTimeMillis(), new Object[0]);
        if (postResult.isIntercepted()) {
            return (String)postResult.getInterceptResult();
        }
        return value;
    }

    @Override
    public void setNetworkTimeout(Executor arg1, int arg2) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("setNetworkTimeout", arg1, arg2);
        if (preResult.isIntercepted()) {
            return;
        }
        long startTime = System.currentTimeMillis();
        this.wrapped.setNetworkTimeout(arg1, arg2);
        long endTime = System.currentTimeMillis();
        this.interceptor.postExecute("setNetworkTimeout", null, startTime, endTime, arg1, arg2);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("getNetworkTimeout", new Object[0]);
        if (preResult.isIntercepted()) {
            return (Integer)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        int value = this.wrapped.getNetworkTimeout();
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("getNetworkTimeout", value, startTime, endTime, new Object[0]);
        if (postResult.isIntercepted()) {
            return (Integer)postResult.getInterceptResult();
        }
        return value;
    }

    public Object unwrap(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("unwrap", arg1);
        if (preResult.isIntercepted()) {
            return preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        Object value = this.wrapped.unwrap(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("unwrap", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return postResult.getInterceptResult();
        }
        return value;
    }

    public boolean isWrapperFor(Class arg1) throws SQLException {
        InterceptResult preResult = this.interceptor.preExecute("isWrapperFor", arg1);
        if (preResult.isIntercepted()) {
            return (Boolean)preResult.getInterceptResult();
        }
        long startTime = System.currentTimeMillis();
        boolean value = this.wrapped.isWrapperFor(arg1);
        long endTime = System.currentTimeMillis();
        InterceptResult postResult = this.interceptor.postExecute("isWrapperFor", value, startTime, endTime, arg1);
        if (postResult.isIntercepted()) {
            return (Boolean)postResult.getInterceptResult();
        }
        return value;
    }

    public TypedProperties getEngineProperties() {
        return this.engineProperties;
    }

    public void setEngineProperties(TypedProperties engineProperties) {
        this.engineProperties = engineProperties;
    }
}

