/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.alter;

import org.jumpmind.db.alter.TableChangeImplBase;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;

public class PrimaryKeyChange
extends TableChangeImplBase {
    private Column[] _oldPrimaryKeyColumns;
    private Column[] _newPrimaryKeyColumns;

    public PrimaryKeyChange(Table table, Column[] oldPrimaryKeyColumns, Column[] newPrimaryKeyColumns) {
        super(table);
        this._oldPrimaryKeyColumns = oldPrimaryKeyColumns;
        this._newPrimaryKeyColumns = newPrimaryKeyColumns;
    }

    public Column[] getOldPrimaryKeyColumns() {
        return this._oldPrimaryKeyColumns;
    }

    public Column[] getNewPrimaryKeyColumns() {
        return this._newPrimaryKeyColumns;
    }

    @Override
    public void apply(Database database, boolean caseSensitive) {
        Column column;
        int idx;
        Table table = database.findTable(this.getChangedTable().getName(), caseSensitive);
        for (idx = 0; idx < this._oldPrimaryKeyColumns.length; ++idx) {
            column = table.findColumn(this._oldPrimaryKeyColumns[idx].getName(), caseSensitive);
            if (column == null) continue;
            column.setPrimaryKey(false);
        }
        for (idx = 0; idx < this._newPrimaryKeyColumns.length; ++idx) {
            column = table.findColumn(this._newPrimaryKeyColumns[idx].getName(), caseSensitive);
            column.setPrimaryKey(true);
        }
    }
}

