/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.PlatformIndex;

public abstract class IndexImpBase
implements IIndex {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected ArrayList<IndexColumn> columns = new ArrayList();
    protected ArrayList<IndexColumn> includedColumns = new ArrayList();
    protected Map<String, PlatformIndex> platformIndexes;

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public IndexColumn getColumn(int idx) {
        return this.columns.get(idx);
    }

    @Override
    public IndexColumn[] getColumns() {
        return this.columns.toArray(new IndexColumn[this.columns.size()]);
    }

    @Override
    public boolean hasColumn(Column column) {
        for (int idx = 0; idx < this.columns.size(); ++idx) {
            IndexColumn curColumn = this.getColumn(idx);
            if (!column.getName().equals(curColumn.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addColumn(IndexColumn column) {
        if (column != null) {
            for (int idx = 0; idx < this.columns.size(); ++idx) {
                IndexColumn curColumn = this.getColumn(idx);
                if (curColumn.getOrdinalPosition() <= column.getOrdinalPosition()) continue;
                this.columns.add(idx, column);
                return;
            }
            this.columns.add(column);
        }
    }

    @Override
    public void removeColumn(IndexColumn column) {
        this.columns.remove(column);
    }

    @Override
    public void removeColumn(int idx) {
        this.columns.remove(idx);
    }

    @Override
    public int getIncludedColumnCount() {
        return this.includedColumns.size();
    }

    @Override
    public IndexColumn getIncludedColumn(int idx) {
        return this.includedColumns.get(idx);
    }

    @Override
    public IndexColumn[] getIncludedColumns() {
        return this.includedColumns.toArray(new IndexColumn[this.includedColumns.size()]);
    }

    @Override
    public boolean hasIncludedColumn(Column column) {
        for (int idx = 0; idx < this.includedColumns.size(); ++idx) {
            IndexColumn curColumn = this.getIncludedColumn(idx);
            if (!column.getName().equals(curColumn.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addIncludedColumn(IndexColumn column) {
        if (column != null) {
            for (int idx = 0; idx < this.includedColumns.size(); ++idx) {
                IndexColumn curColumn = this.getIncludedColumn(idx);
                if (curColumn.getOrdinalPosition() <= column.getOrdinalPosition()) continue;
                this.includedColumns.add(idx, column);
                return;
            }
            this.includedColumns.add(column);
        }
    }

    @Override
    public abstract Object clone() throws CloneNotSupportedException;

    @Override
    public boolean hasAllPrimaryKeys() {
        boolean hasAllPrimaryKeys = true;
        for (IndexColumn col : this.columns) {
            hasAllPrimaryKeys &= col.isPrimaryKey();
        }
        return hasAllPrimaryKeys;
    }

    @Override
    public void removePlatformIndex(PlatformIndex platformIndex) {
        if (this.platformIndexes != null) {
            this.platformIndexes.remove(platformIndex.getName());
        }
    }

    @Override
    public void addPlatformIndex(PlatformIndex platformIndex) {
        if (this.platformIndexes == null) {
            this.platformIndexes = new HashMap<String, PlatformIndex>();
        }
        this.platformIndexes.put(platformIndex.getName(), platformIndex);
    }

    @Override
    public Map<String, PlatformIndex> getPlatformIndexes() {
        return this.platformIndexes;
    }

    @Override
    public PlatformIndex findPlatformIndex(PlatformIndex platformIndex) {
        PlatformIndex ret = null;
        if (this.platformIndexes != null) {
            ret = this.platformIndexes.get(platformIndex.getName());
        }
        return ret;
    }

    protected void clonePlatformIndexes(IndexImpBase indexImpBase) throws CloneNotSupportedException {
        if (this.platformIndexes != null) {
            for (String key : this.platformIndexes.keySet()) {
                PlatformIndex platformIndex = this.platformIndexes.get(key);
                indexImpBase.addPlatformIndex(platformIndex.clone());
            }
        }
    }
}

