/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.db2;

import java.util.Iterator;
import java.util.List;
import org.jumpmind.db.alter.AddColumnChange;
import org.jumpmind.db.alter.AddPrimaryKeyChange;
import org.jumpmind.db.alter.ColumnDataTypeChange;
import org.jumpmind.db.alter.CopyColumnValueChange;
import org.jumpmind.db.alter.PrimaryKeyChange;
import org.jumpmind.db.alter.RemoveColumnChange;
import org.jumpmind.db.alter.RemovePrimaryKeyChange;
import org.jumpmind.db.alter.TableChange;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.model.TypeMap;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.PlatformUtils;

public class Db2DdlBuilder
extends AbstractDdlBuilder {
    protected boolean migrateDataToRemoveColumn = false;

    public Db2DdlBuilder() {
        super("db2");
        this.databaseInfo.addNativeTypeMapping(2003, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-2, "CHAR {0} FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping(-7, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(6, "DOUBLE", 8);
        this.databaseInfo.addNativeTypeMapping(2000, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-4, "LONG VARCHAR FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping(-1, "LONG VARCHAR");
        this.databaseInfo.addNativeTypeMapping(0, "LONG VARCHAR FOR BIT DATA", -4);
        this.databaseInfo.addNativeTypeMapping(2, "DECIMAL", 3);
        this.databaseInfo.addNativeTypeMapping(1111, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(2002, "BLOB", 2004);
        this.databaseInfo.addNativeTypeMapping(-6, "SMALLINT", 5);
        this.databaseInfo.addNativeTypeMapping(-3, "VARCHAR {0} FOR BIT DATA");
        this.databaseInfo.addNativeTypeMapping("BOOLEAN", "SMALLINT", "SMALLINT");
        this.databaseInfo.setHasSize(93, true);
        this.databaseInfo.setHasSize(-101, true);
        this.databaseInfo.setHasSize(-102, true);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setDefaultSize(-2, 254);
        this.databaseInfo.setDefaultSize(-3, 254);
        this.databaseInfo.setDefaultSize(93, 6);
        this.databaseInfo.setDefaultSize(92, 0);
        this.databaseInfo.setMaxSize("TIMESTAMP", 12);
        this.databaseInfo.setMaxIdentifierLength(128);
        this.databaseInfo.setMaxColumnNameLength(128);
        this.databaseInfo.setMaxConstraintNameLength(128);
        this.databaseInfo.setMaxForeignKeyNameLength(128);
        this.databaseInfo.setNonBlankCharColumnSpacePadded(true);
        this.databaseInfo.setBlankCharColumnSpacePadded(true);
        this.databaseInfo.setCharColumnSpaceTrimmed(false);
        this.databaseInfo.setEmptyStringNulled(false);
        this.databaseInfo.setBinaryQuoteStart("blob(X'");
        this.databaseInfo.setBinaryQuoteEnd("')");
        this.databaseInfo.setCanTriggerExistWithoutTable(true);
    }

    @Override
    protected String getNativeDefaultValue(Column column) {
        if (column.getMappedTypeCode() == -7 || PlatformUtils.supportsJava14JdbcTypes() && column.getMappedTypeCode() == PlatformUtils.determineBooleanTypeCode()) {
            return this.getDefaultValueHelper().convert(column.getDefaultValue(), column.getMappedTypeCode(), 5);
        }
        return super.getNativeDefaultValue(column);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
        ddl.append("GENERATED BY DEFAULT AS IDENTITY (START WITH 1, INCREMENT BY 1, NO CACHE, ORDER)");
    }

    @Override
    public String getSelectLastIdentityValues(Table table) {
        return "VALUES IDENTITY_VAL_LOCAL()";
    }

    @Override
    public void writeExternalIndexDropStmt(Table table, IIndex index, StringBuilder ddl) {
        ddl.append("DROP INDEX ");
        this.printIdentifier(this.getIndexName(index), ddl);
        this.printEndOfStatement(ddl);
    }

    @Override
    protected void writeCastExpression(Column sourceColumn, Column targetColumn, StringBuilder ddl) {
        String targetNativeType;
        String sourceNativeType = this.getBareNativeType(sourceColumn);
        if (sourceNativeType.equals(targetNativeType = this.getBareNativeType(targetColumn))) {
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
        } else {
            Object type = this.getSqlType(targetColumn);
            if (TypeMap.isNumericType(sourceColumn.getMappedTypeCode()) && "VARCHAR".equalsIgnoreCase(targetNativeType)) {
                Object sizeSpec = targetColumn.getSize();
                if (sizeSpec == null) {
                    sizeSpec = this.databaseInfo.getDefaultSize(targetColumn.getMappedTypeCode());
                }
                type = "CHAR(" + String.valueOf(sizeSpec) + ")";
            }
            ddl.append("CAST(");
            this.printIdentifier(this.getColumnName(sourceColumn), ddl);
            ddl.append(" AS ");
            ddl.append((String)type);
            ddl.append(")");
        }
    }

    @Override
    protected void processTableStructureChanges(Database currentModel, Database desiredModel, Table sourceTable, Table targetTable, List<TableChange> changes, StringBuilder ddl) {
        TableChange change;
        Iterator<TableChange> changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (!(change instanceof AddColumnChange)) continue;
            AddColumnChange addColumnChange = (AddColumnChange)change;
            if (!addColumnChange.getNewColumn().isAutoIncrement()) {
                this.processChange(currentModel, desiredModel, addColumnChange, ddl);
                changeIt.remove();
                continue;
            }
            return;
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof PrimaryKeyChange) {
                this.processChange(currentModel, desiredModel, (PrimaryKeyChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof RemovePrimaryKeyChange)) continue;
            this.processChange(currentModel, desiredModel, (RemovePrimaryKeyChange)change, ddl);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (change instanceof RemoveColumnChange && !this.migrateDataToRemoveColumn) {
                this.processChange(currentModel, desiredModel, (RemoveColumnChange)change, ddl);
                changeIt.remove();
                continue;
            }
            if (!(change instanceof CopyColumnValueChange)) continue;
            CopyColumnValueChange copyColumnChange = (CopyColumnValueChange)change;
            this.processChange(currentModel, desiredModel, copyColumnChange, ddl);
            changeIt.remove();
        }
        changeIt = changes.iterator();
        while (changeIt.hasNext()) {
            change = changeIt.next();
            if (!(change instanceof AddPrimaryKeyChange)) continue;
            this.processChange(currentModel, desiredModel, (AddPrimaryKeyChange)change, ddl);
            changeIt.remove();
        }
        super.processTableStructureChanges(currentModel, desiredModel, sourceTable, targetTable, changes, ddl);
    }

    @Override
    protected boolean writeAlterColumnDataTypeToBigInt(ColumnDataTypeChange change, StringBuilder ddl) {
        if (!change.getChangedColumn().isPrimaryKey()) {
            this.writeTableAlterStmt(change.getChangedTable(), ddl);
            ddl.append(" ALTER COLUMN ");
            Column column = change.getChangedColumn();
            column.setTypeCode(change.getNewTypeCode());
            this.printIdentifier(this.getColumnName(column), ddl);
            ddl.append(" SET DATA TYPE ");
            ddl.append(this.getSqlType(column));
            this.printEndOfStatement(ddl);
            return true;
        }
        return false;
    }

    protected void processChange(Database currentModel, Database desiredModel, AddColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("ADD COLUMN ");
        this.writeColumn(change.getChangedTable(), change.getNewColumn(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemoveColumnChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP COLUMN ");
        this.printIdentifier(this.getColumnName(change.getColumn()), ddl);
        this.printEndOfStatement(ddl);
        this.writeReorgStmt(change.getChangedTable(), ddl);
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, RemovePrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    protected void processChange(Database currentModel, Database desiredModel, PrimaryKeyChange change, StringBuilder ddl) {
        ddl.append("ALTER TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(change.getChangedTable()));
        this.printIndent(ddl);
        ddl.append("DROP PRIMARY KEY");
        this.printEndOfStatement(ddl);
        this.writeExternalPrimaryKeysCreateStmt(change.getChangedTable(), change.getNewPrimaryKeyColumns(), ddl);
        change.apply(currentModel, this.delimitedIdentifierModeOn);
    }

    @Override
    protected void writeExternalPrimaryKeysCreateStmt(Table table, Column[] primaryKeyColumns, StringBuilder ddl) {
        super.writeExternalPrimaryKeysCreateStmt(table, primaryKeyColumns, ddl);
        this.writeReorgStmt(table, ddl);
        this.printEndOfStatement(ddl);
    }

    protected void writeReorgStmt(Table table, StringBuilder ddl) {
        ddl.append("CALL SYSPROC.ADMIN_CMD('REORG TABLE ");
        ddl.append(this.getFullyQualifiedTableNameShorten(table));
        ddl.append("')");
    }

    @Override
    protected void writeCascadeAttributesForForeignKeyUpdate(ForeignKey key, StringBuilder ddl) {
        if (key.getOnUpdateAction() == ForeignKey.ForeignKeyAction.RESTRICT || key.getOnUpdateAction() == ForeignKey.ForeignKeyAction.NOACTION) {
            super.writeCascadeAttributesForForeignKeyUpdate(key, ddl);
        }
    }

    @Override
    public String mapDefaultValue(Object defaultValue, Column column) {
        String defaultValueStr = super.mapDefaultValue(defaultValue, column);
        if (defaultValueStr.toLowerCase().equals("current_timestamp()")) {
            defaultValueStr = "current_timestamp(6)";
        }
        return defaultValueStr;
    }

    @Override
    protected void writeColumnType(Table table, Column column, StringBuilder ddl) {
        boolean isTimestampAutoUpdate;
        boolean bl = isTimestampAutoUpdate = column.getMappedTypeCode() == 93 && column.isAutoUpdate();
        if (isTimestampAutoUpdate) {
            for (Column col : table.getColumns()) {
                if (col.getMappedTypeCode() != 93 || !col.isAutoUpdate()) continue;
                isTimestampAutoUpdate = col.equals(column);
                break;
            }
        }
        if (isTimestampAutoUpdate) {
            ddl.append("generated by default for each row on update as row change timestamp not null");
        } else {
            super.writeColumnType(table, column, ddl);
        }
    }

    @Override
    protected void writeColumnDefaultValue(Table table, Column column, StringBuilder ddl) {
        if (column.getMappedTypeCode() != 93 || !column.isAutoUpdate()) {
            this.printDefaultValue(this.getNativeDefaultValue(column), column, ddl);
        }
    }
}

