/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.db.platform.voltdb;

import java.util.ArrayList;
import java.util.Arrays;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.ForeignKey;
import org.jumpmind.db.model.IIndex;
import org.jumpmind.db.model.IndexColumn;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.AbstractDdlBuilder;
import org.jumpmind.db.platform.IAlterDatabaseInterceptor;

public class VoltDbDdlBuilder
extends AbstractDdlBuilder {
    public VoltDbDdlBuilder() {
        super("voltdb");
        this.databaseInfo.setMaxIdentifierLength(-1);
        this.databaseInfo.addNativeTypeMapping(91, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(92, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(-103, "TIMESTAMP", 93);
        this.databaseInfo.addNativeTypeMapping(-7, "TINYINT", -6);
        this.databaseInfo.addNativeTypeMapping(8, "DECIMAL", 3);
        this.databaseInfo.addNativeTypeMapping(2005, "VARCHAR(100000)", 12);
        this.databaseInfo.addNativeTypeMapping(-1, "VARCHAR(100000)", 12);
        this.databaseInfo.addNativeTypeMapping(1, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-2, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(2004, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-3, "VARCHAR", 12);
        this.databaseInfo.addNativeTypeMapping(-4, "VARCHAR", 12);
        this.databaseInfo.setDefaultSize(1, 254);
        this.databaseInfo.setDefaultSize(12, 254);
        this.databaseInfo.setMaxSize("TIMESTAMP", 6);
    }

    @Override
    protected void writeColumnAutoIncrementStmt(Table table, Column column, StringBuilder ddl) {
    }

    @Override
    protected void createTable(Table table, StringBuilder ddl, boolean temporary, boolean recreate) {
        for (Column column : table.getColumns()) {
            column.setAutoIncrement(false);
        }
        super.createTable(table, ddl, temporary, recreate);
    }

    @Override
    public boolean isAlterDatabase(Database currentModel, Database desiredModel, IAlterDatabaseInterceptor ... alterDatabaseInterceptors) {
        this.alignPrimaryKeys(currentModel, desiredModel);
        this.alignIndicies(currentModel, desiredModel);
        return super.isAlterDatabase(currentModel, desiredModel, alterDatabaseInterceptors);
    }

    protected void alignPrimaryKeys(Database currentModel, Database desiredModel) {
        for (Table desiredTable : desiredModel.getTables()) {
            Table currentTable;
            if (desiredTable.getPrimaryKeyColumnCount() <= 1 || (currentTable = currentModel.findTable(desiredTable.getName())) == null) continue;
            this.alignPrimaryKeys(currentTable, desiredTable);
        }
    }

    protected void alignPrimaryKeys(Table currentTable, Table desiredTable) {
        ArrayList<Column> currentColumns = new ArrayList<Column>(Arrays.asList(currentTable.getColumns()));
        currentTable.removeAllColumns();
        for (Column desiredPkColumn : desiredTable.getPrimaryKeyColumns()) {
            for (int i = 0; i < currentColumns.size(); ++i) {
                Column currentColumn = (Column)currentColumns.get(i);
                if (!currentColumn.isPrimaryKey() || !currentColumn.getName().equalsIgnoreCase(desiredPkColumn.getName())) continue;
                currentTable.addColumn(currentColumn);
                currentColumns.remove(i);
                --i;
            }
        }
        for (Column currentColumn : currentColumns) {
            currentTable.addColumn(currentColumn);
        }
    }

    private void alignIndicies(Database currentModel, Database desiredModel) {
        for (Table desiredTable : desiredModel.getTables()) {
            for (IIndex desiredIndex : desiredTable.getIndices()) {
                IIndex currentIndex;
                Table currentTable;
                if (desiredIndex.getColumnCount() <= 1 || (currentTable = currentModel.findTable(desiredTable.getName())) == null || (currentIndex = currentTable.findIndex(desiredIndex.getName())) == null) continue;
                this.alignIndexColumns(currentIndex, desiredIndex);
            }
        }
    }

    protected void alignIndexColumns(IIndex currentIndex, IIndex desiredIndex) {
        ArrayList<IndexColumn> currentColumns = new ArrayList<IndexColumn>(Arrays.asList(currentIndex.getColumns()));
        while (currentIndex.getColumnCount() > 0) {
            currentIndex.removeColumn(0);
        }
        int oridinalPosition = 1;
        for (IndexColumn desiredColumn : desiredIndex.getColumns()) {
            for (int i = 0; i < currentColumns.size(); ++i) {
                IndexColumn currentColumn = (IndexColumn)currentColumns.get(i);
                if (!desiredColumn.getName().equalsIgnoreCase(currentColumn.getName())) continue;
                currentColumn.setOrdinalPosition(oridinalPosition++);
                currentIndex.addColumn(currentColumn);
                currentColumns.remove(i);
                --i;
            }
        }
        for (IndexColumn currentColumn : currentColumns) {
            currentIndex.addColumn(currentColumn);
        }
    }

    @Override
    protected void writeCascadeAttributesForForeignKey(ForeignKey key, StringBuilder ddl) {
    }
}

