/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric;

import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.UnrecoverableKeyException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.db.io.DatabaseXmlUtil;
import org.jumpmind.db.model.Database;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.DatabaseInfo;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlResultsListener;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.db.sql.SqlScript;
import org.jumpmind.extension.IProcessInfoListener;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.security.ISecurityService;
import org.jumpmind.security.SecurityServiceFactory;
import org.jumpmind.symmetric.EngineAlreadyRegisteredException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.cache.CacheManager;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.common.ParameterConstants;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.config.INodeIdCreator;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISoftwareUpgradeListener;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.ISymmetricEngineLifecycle;
import org.jumpmind.symmetric.io.DefaultOfflineClientListener;
import org.jumpmind.symmetric.io.stage.IStagingManager;
import org.jumpmind.symmetric.job.DefaultOfflineServerListener;
import org.jumpmind.symmetric.job.IJobManager;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.NodeStatus;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.RemoteNodeStatuses;
import org.jumpmind.symmetric.security.INodePasswordFilter;
import org.jumpmind.symmetric.service.IAcknowledgeService;
import org.jumpmind.symmetric.service.IBandwidthService;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IDataExtractorService;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IFileSyncService;
import org.jumpmind.symmetric.service.IGroupletService;
import org.jumpmind.symmetric.service.IIncomingBatchService;
import org.jumpmind.symmetric.service.IInitialLoadService;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.INodeCommunicationService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOfflinePullService;
import org.jumpmind.symmetric.service.IOfflinePushService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPullService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.IPushService;
import org.jumpmind.symmetric.service.IRegistrationService;
import org.jumpmind.symmetric.service.IRouterService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.IStatisticService;
import org.jumpmind.symmetric.service.ITransformService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.IUpdateService;
import org.jumpmind.symmetric.service.impl.AcknowledgeService;
import org.jumpmind.symmetric.service.impl.BandwidthService;
import org.jumpmind.symmetric.service.impl.ClusterService;
import org.jumpmind.symmetric.service.impl.ConfigurationService;
import org.jumpmind.symmetric.service.impl.ContextService;
import org.jumpmind.symmetric.service.impl.DataExtractorService;
import org.jumpmind.symmetric.service.impl.DataLoaderService;
import org.jumpmind.symmetric.service.impl.DataService;
import org.jumpmind.symmetric.service.impl.FileSyncExtractorService;
import org.jumpmind.symmetric.service.impl.FileSyncService;
import org.jumpmind.symmetric.service.impl.GroupletService;
import org.jumpmind.symmetric.service.impl.IncomingBatchService;
import org.jumpmind.symmetric.service.impl.InitialLoadService;
import org.jumpmind.symmetric.service.impl.LoadFilterService;
import org.jumpmind.symmetric.service.impl.NodeCommunicationService;
import org.jumpmind.symmetric.service.impl.NodeService;
import org.jumpmind.symmetric.service.impl.OfflinePullService;
import org.jumpmind.symmetric.service.impl.OfflinePushService;
import org.jumpmind.symmetric.service.impl.OutgoingBatchService;
import org.jumpmind.symmetric.service.impl.ParameterService;
import org.jumpmind.symmetric.service.impl.PullService;
import org.jumpmind.symmetric.service.impl.PurgeService;
import org.jumpmind.symmetric.service.impl.PushService;
import org.jumpmind.symmetric.service.impl.RegistrationService;
import org.jumpmind.symmetric.service.impl.RouterService;
import org.jumpmind.symmetric.service.impl.SequenceService;
import org.jumpmind.symmetric.service.impl.StatisticService;
import org.jumpmind.symmetric.service.impl.TransformService;
import org.jumpmind.symmetric.service.impl.TriggerRouterService;
import org.jumpmind.symmetric.service.impl.UpdateService;
import org.jumpmind.symmetric.statistic.IStatisticManager;
import org.jumpmind.symmetric.transport.ConcurrentConnectionManager;
import org.jumpmind.symmetric.transport.IConcurrentConnectionManager;
import org.jumpmind.symmetric.transport.ITransportManager;
import org.jumpmind.symmetric.transport.TransportManagerFactory;
import org.jumpmind.symmetric.util.PropertiesUtil;
import org.jumpmind.symmetric.util.SymmetricUtils;
import org.jumpmind.util.AppUtils;
import org.jumpmind.util.ExceptionUtils;
import org.jumpmind.util.FormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractSymmetricEngine
implements ISymmetricEngine {
    private static Map<String, ISymmetricEngine> registeredEnginesByUrl = new ConcurrentHashMap<String, ISymmetricEngine>();
    private static Map<String, ISymmetricEngine> registeredEnginesByName = new ConcurrentHashMap<String, ISymmetricEngine>();
    private static final Logger log = LoggerFactory.getLogger(AbstractSymmetricEngine.class);
    private boolean started = false;
    private boolean starting = false;
    private boolean dbSetupDone = false;
    private boolean isInitialized = false;
    private boolean isStartupDbParametersDifferentFromLastStart = false;
    private Throwable lastException = null;
    protected String deploymentType;
    protected String deploymentSubType;
    protected ITypedPropertiesFactory propertiesFactory;
    protected IDatabasePlatform platform;
    protected ISecurityService securityService;
    protected ParameterService parameterService;
    protected ISymmetricDialect symmetricDialect;
    protected INodeService nodeService;
    protected IConfigurationService configurationService;
    protected IBandwidthService bandwidthService;
    protected IStatisticService statisticService;
    protected IStatisticManager statisticManager;
    protected IConcurrentConnectionManager concurrentConnectionManager;
    protected ITransportManager transportManager;
    protected ITransportManager offlineTransportManager;
    protected IClusterService clusterService;
    protected IPurgeService purgeService;
    protected ITransformService transformService;
    protected IInitialLoadService initialLoadService;
    protected ILoadFilterService loadFilterService;
    protected ITriggerRouterService triggerRouterService;
    protected IOutgoingBatchService outgoingBatchService;
    protected IDataService dataService;
    protected IRouterService routerService;
    protected IDataExtractorService dataExtractorService;
    protected IDataExtractorService fileSyncExtractorService;
    protected IRegistrationService registrationService;
    protected IDataLoaderService dataLoaderService;
    protected IIncomingBatchService incomingBatchService;
    protected IAcknowledgeService acknowledgeService;
    protected IPushService pushService;
    protected IPullService pullService;
    protected IOfflinePushService offlinePushService;
    protected IOfflinePullService offlinePullService;
    protected IJobManager jobManager;
    protected ISequenceService sequenceService;
    protected IExtensionService extensionService;
    protected IGroupletService groupletService;
    protected IStagingManager stagingManager;
    protected INodeCommunicationService nodeCommunicationService;
    protected IFileSyncService fileSyncService;
    protected IContextService contextService;
    protected IUpdateService updateService;
    protected ICacheManager cacheManager;
    protected Date lastRestartTime = null;
    protected boolean registerEngine = true;
    private boolean isFirstStart = true;

    protected abstract ITypedPropertiesFactory createTypedPropertiesFactory();

    protected abstract IDatabasePlatform createDatabasePlatform(TypedProperties var1);

    protected AbstractSymmetricEngine(boolean registerEngine) {
        this.registerEngine = registerEngine;
    }

    public static List<ISymmetricEngine> findEngines() {
        ArrayList<ISymmetricEngine> engines = new ArrayList<ISymmetricEngine>();
        engines.addAll(registeredEnginesByName.values());
        return engines;
    }

    public static ISymmetricEngine findEngineByUrl(String url) {
        if (registeredEnginesByUrl != null && url != null) {
            return registeredEnginesByUrl.get(url);
        }
        return null;
    }

    public static ISymmetricEngine findEngineByName(String name) {
        if (registeredEnginesByName != null && name != null) {
            return registeredEnginesByName.get(name);
        }
        return null;
    }

    public static ISymmetricEngine findEngineByNodeId(String nodeId) {
        if (nodeId != null) {
            for (ISymmetricEngine engine : registeredEnginesByName.values()) {
                if (!nodeId.equals(engine.getNodeId())) continue;
                return engine;
            }
        }
        return null;
    }

    public void setDeploymentType(String deploymentType) {
        this.deploymentType = deploymentType;
    }

    public void setDeploymentSubType(String deploymentSubType) {
        this.deploymentSubType = deploymentSubType;
    }

    protected abstract SecurityServiceFactory.SecurityServiceType getSecurityServiceType();

    protected void init() {
        if (this.propertiesFactory == null) {
            this.propertiesFactory = this.createTypedPropertiesFactory();
        }
        if (this.securityService == null) {
            this.securityService = SecurityServiceFactory.create((SecurityServiceFactory.SecurityServiceType)this.getSecurityServiceType(), (TypedProperties)this.propertiesFactory.reload());
        }
        TypedProperties properties = this.propertiesFactory.reload();
        this.registerSymDSDriver(properties);
        String engineName = properties.get("engine.name");
        if (!Strings.CS.contains((CharSequence)engineName, (CharSequence)"`") && !Strings.CS.contains((CharSequence)engineName, (CharSequence)"(")) {
            MDC.put((String)"engineName", (String)engineName);
        }
        this.platform = this.createDatabasePlatform(properties);
        this.parameterService = new ParameterService(this.platform, this.propertiesFactory, properties.get("sync.table.prefix", "sym"));
        Table paramTable = this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(properties.get("sync.table.prefix"), "parameter"));
        if (paramTable != null) {
            log.debug("Reading parameters because found {}", (Object)paramTable.getFullyQualifiedTableName());
            this.parameterService.setDatabaseHasBeenInitialized(true);
            this.parameterService.rereadParameters();
        }
        this.parameterService.getNodeGroupId();
        this.parameterService.getExternalId();
        this.parameterService.getEngineName();
        this.parameterService.getSyncUrl();
        this.parameterService.getRegistrationUrl();
        MDC.put((String)"engineName", (String)this.parameterService.getEngineName());
        this.platform.setMetadataIgnoreCase(this.parameterService.is("db.metadata.ignore.case"));
        this.platform.setClearCacheModelTimeoutInMs(this.parameterService.getLong("cache.table.time.ms"));
        this.symmetricDialect = this.createSymmetricDialect();
        this.symmetricDialect.setTargetDialect(this.createTargetDialect());
        this.extensionService = this.createExtensionService();
        this.extensionService.refresh();
        this.symmetricDialect.setExtensionService(this.extensionService);
        this.parameterService.setExtensionService(this.extensionService);
        this.cacheManager = new CacheManager(this);
        this.contextService = new ContextService(this.parameterService, this.symmetricDialect);
        this.bandwidthService = new BandwidthService(this);
        this.sequenceService = new SequenceService(this.parameterService, this.symmetricDialect);
        this.stagingManager = this.createStagingManager();
        this.nodeService = new NodeService(this);
        this.configurationService = new ConfigurationService(this, this.symmetricDialect);
        this.dataService = new DataService(this, this.extensionService);
        this.clusterService = this.createClusterService();
        this.statisticService = new StatisticService(this.parameterService, this.symmetricDialect);
        this.statisticManager = this.createStatisticManager();
        this.concurrentConnectionManager = new ConcurrentConnectionManager(this.parameterService, this.statisticManager);
        this.purgeService = new PurgeService(this.parameterService, this.symmetricDialect, this.clusterService, this.dataService, this.sequenceService, this.statisticManager, this.extensionService, this.contextService);
        this.transformService = new TransformService(this, this.symmetricDialect);
        this.loadFilterService = new LoadFilterService(this, this.symmetricDialect);
        this.groupletService = new GroupletService(this);
        this.triggerRouterService = new TriggerRouterService(this);
        this.outgoingBatchService = new OutgoingBatchService(this);
        this.routerService = this.buildRouterService();
        this.nodeCommunicationService = this.buildNodeCommunicationService();
        this.incomingBatchService = new IncomingBatchService(this.parameterService, this.symmetricDialect, this.clusterService);
        this.initialLoadService = new InitialLoadService(this);
        this.dataExtractorService = new DataExtractorService(this);
        this.transportManager = new TransportManagerFactory(this).create();
        this.offlineTransportManager = new TransportManagerFactory(this).create("file");
        this.dataLoaderService = new DataLoaderService(this);
        this.registrationService = new RegistrationService(this);
        this.acknowledgeService = new AcknowledgeService(this);
        this.pushService = new PushService(this);
        this.pullService = new PullService(this);
        this.offlinePushService = new OfflinePushService(this.parameterService, this.symmetricDialect, this.dataExtractorService, this.acknowledgeService, this.offlineTransportManager, this.nodeService, this.clusterService, this.nodeCommunicationService, this.statisticManager, this.configurationService, this.extensionService);
        this.offlinePullService = new OfflinePullService(this.parameterService, this.symmetricDialect, this.nodeService, this.dataLoaderService, this.clusterService, this.nodeCommunicationService, this.configurationService, this.extensionService, this.offlineTransportManager);
        this.fileSyncService = this.buildFileSyncService();
        this.fileSyncExtractorService = new FileSyncExtractorService(this);
        String updateServiceClassName = properties.get("update.service.class");
        if (updateServiceClassName == null) {
            this.updateService = new UpdateService(this);
        } else {
            try {
                Constructor<?> cons = Class.forName(updateServiceClassName).getConstructor(ISymmetricEngine.class);
                this.updateService = (IUpdateService)cons.newInstance(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.jobManager = this.createJobManager();
        this.extensionService.addExtensionPoint(new DefaultOfflineServerListener(this.statisticManager, this.nodeService, this.outgoingBatchService));
        DefaultOfflineClientListener defaultlistener = new DefaultOfflineClientListener(this);
        this.extensionService.addExtensionPoint(defaultlistener);
        if (this.registerEngine) {
            this.registerHandleToEngine();
        }
    }

    protected void registerSymDSDriver(TypedProperties engineProperties) {
        try {
            Class<?> driverClass = Thread.currentThread().getContextClassLoader().loadClass("org.jumpmind.driver.Driver");
            if (driverClass != null) {
                Method method = driverClass.getMethod("register", TypedProperties.class);
                method.invoke(null, engineProperties);
            }
        }
        catch (Exception ex) {
            log.debug("Failed to load org.jumpmind.driver.Driver", (Throwable)ex);
        }
    }

    protected IClusterService createClusterService() {
        return (IClusterService)AppUtils.newInstance(IClusterService.class, ClusterService.class, (Object[])new Object[]{this.parameterService, this.symmetricDialect, this.nodeService, this.extensionService}, (Class[])new Class[]{IParameterService.class, ISymmetricDialect.class, INodeService.class, IExtensionService.class});
    }

    protected IRouterService buildRouterService() {
        return new RouterService(this);
    }

    protected IFileSyncService buildFileSyncService() {
        return new FileSyncService(this);
    }

    protected INodeCommunicationService buildNodeCommunicationService() {
        return new NodeCommunicationService(this);
    }

    protected abstract IStagingManager createStagingManager();

    protected abstract IStatisticManager createStatisticManager();

    protected abstract ISymmetricDialect createSymmetricDialect();

    protected ISymmetricDialect createTargetDialect() {
        return this.getSymmetricDialect();
    }

    protected abstract IExtensionService createExtensionService();

    protected abstract IJobManager createJobManager();

    @Override
    public String getSyncUrl() {
        return this.parameterService.getSyncUrl();
    }

    @Override
    public Properties getProperties() {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)this.parameterService.getAllParameters());
        return p;
    }

    @Override
    public String getEngineName() {
        return this.parameterService.getEngineName();
    }

    @Override
    public void setup() {
        if (this.dbSetupDone) {
            return;
        }
        this.isStartupDbParametersDifferentFromLastStart = this.detectStartupDbParametersDifferentFromLastStart();
        this.setupDatabase(this.isStartupDbParametersDifferentFromLastStart);
        this.parameterService.setDatabaseHasBeenInitialized(true);
        String databaseVersion = this.getNodeService().findIdentity() != null ? this.getNodeService().findIdentity().getSymmetricVersion() : null;
        String softwareVersion = Version.version();
        log.info("SymmetricDS database version : " + databaseVersion);
        log.info("SymmetricDS software version : " + softwareVersion);
        if (databaseVersion != null && !softwareVersion.equals(databaseVersion)) {
            log.info("SymmetricDS database version does not match the current software version, running software upgrade listeners.");
            List<ISoftwareUpgradeListener> softwareUpgradeListeners = this.extensionService.getExtensionPointList(ISoftwareUpgradeListener.class);
            for (ISoftwareUpgradeListener listener : softwareUpgradeListeners) {
                listener.upgrade(databaseVersion, softwareVersion);
            }
        }
        this.parameterService.setDatabaseHasBeenSetup(true);
        this.dbSetupDone = true;
    }

    @Override
    public void setupDatabase(boolean force) {
        log.info("Initializing SymmetricDS database");
        boolean isAutoConfigDatabase = this.parameterService.is("auto.config.database");
        boolean isAutoConfigDatabaseFast = this.parameterService.is("auto.config.database.fast");
        if (force || isAutoConfigDatabase) {
            if (!force && isAutoConfigDatabaseFast && !this.hasSoftwareVersionChanged()) {
                log.info("Version matches for tables and objects");
            } else {
                log.info("Checking tables and objects. force={}", (Object)force);
                this.symmetricDialect.initTablesAndDatabaseObjects();
            }
        } else {
            if (this.hasSoftwareVersionChanged() && !Version.isDevelopment(Version.version())) {
                throw new SymmetricException("Upgrade of SymmetricDS runtime tables to version " + Version.version() + " is required.  Enable auto.config.database parameter for automatic upgrade of tables or perform manual upgrade with symadmin.", new Object[0]);
            }
            log.info("SymmetricDS is not configured to auto-create the database");
        }
        try {
            this.configurationService.initDefaultChannels();
        }
        catch (SqlException e) {
            SQLException se;
            if (e.getCause() instanceof SQLException && (se = (SQLException)e.getCause()).getErrorCode() == -7008 && se.getSQLState().equals("55019")) {
                log.error("Please enable journaling on SYM objects.  For instructions, see the appendix in the User Guide on DB2 for i.");
            }
            throw e;
        }
        this.clusterService.init();
        this.sequenceService.init();
        this.autoConfigRegistrationServer();
        log.info("Done initializing SymmetricDS database");
    }

    protected boolean hasSoftwareVersionChanged() {
        Node identity = this.nodeService.findIdentity();
        if (identity != null) {
            return !Version.version().equals(identity.getSymmetricVersion()) || !Strings.CS.equals(identity.getDeploymentType(), this.getDeploymentType()) || Version.isDevelopment(identity.getSymmetricVersion());
        }
        return true;
    }

    protected void autoConfigRegistrationServer() {
        Node node = this.nodeService.findIdentity();
        if (node == null) {
            this.buildTablesFromDdlUtilXmlIfProvided();
            this.loadFromScriptIfProvided();
            this.parameterService.setDatabaseHasBeenInitialized(true);
            this.parameterService.rereadParameters();
            this.extensionService.refresh();
            this.stagingManager.clean(0L);
        }
        node = this.nodeService.findIdentity();
        if (this.parameterService.isRegistrationServer()) {
            if (node == null && this.parameterService.is("auto.insert.registration.svr.if.not.found", false)) {
                log.info("Inserting rows for node, security, identity and group for registration server");
                String nodeId = this.parameterService.getExternalId();
                node = new Node(this.parameterService, this.symmetricDialect, this.platform.getName());
                node.setNodeId(node.getExternalId());
                this.nodeService.save(node);
                this.nodeService.insertNodeIdentity(nodeId);
                node = this.nodeService.findIdentity();
                this.nodeService.insertNodeGroup(node.getNodeGroupId(), null);
                NodeSecurity nodeSecurity = this.nodeService.findOrCreateNodeSecurity(nodeId);
                nodeSecurity.setInitialLoadTime(new Date());
                nodeSecurity.setInitialLoadEndTime(new Date());
                nodeSecurity.setRegistrationTime(new Date());
                nodeSecurity.setInitialLoadEnabled(false);
                nodeSecurity.setRegistrationEnabled(false);
                this.nodeService.updateNodeSecurity(nodeSecurity);
            } else if (node != null) {
                this.disableRegistrationIfNecessary(node.getNodeId());
            }
        }
    }

    protected boolean buildTablesFromDdlUtilXmlIfProvided() {
        boolean loaded = false;
        String xml = this.parameterService.getString("auto.config.registration.svr.ddlutil.xml");
        if (!StringUtils.isBlank((CharSequence)xml)) {
            File file = new File(xml);
            URL fileUrl = null;
            if (file.isFile()) {
                try {
                    fileUrl = file.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            } else {
                fileUrl = this.getClass().getResource(xml);
            }
            if (fileUrl != null) {
                try {
                    log.info("Building database schema from: {}", (Object)xml);
                    Database database = DatabaseXmlUtil.read((Reader)new InputStreamReader(fileUrl.openStream()));
                    IDatabasePlatform platform = this.symmetricDialect.getPlatform();
                    platform.createDatabase(database, true, true);
                    loaded = true;
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
            }
        }
        return loaded;
    }

    protected boolean loadFromScriptIfProvided() {
        boolean loaded = false;
        String sqlScripts = this.parameterService.getString("auto.config.registration.svr.sql.script");
        if (!StringUtils.isBlank((CharSequence)sqlScripts)) {
            boolean containsCurrentGroup = false;
            LinkedHashMap<String, URL> fileUrlMap = new LinkedHashMap<String, URL>();
            String[] sqlScriptList = sqlScripts.split(",");
            for (String sqlScript : sqlScriptList) {
                if (!StringUtils.isNotBlank((CharSequence)(sqlScript = sqlScript.trim()))) continue;
                File file = new File(sqlScript);
                URL fileUrl = null;
                if (file.isFile()) {
                    try {
                        fileUrl = file.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    fileUrl = this.getClass().getResource(sqlScript);
                    if (fileUrl == null) {
                        fileUrl = Thread.currentThread().getContextClassLoader().getResource(sqlScript);
                    }
                }
                if (fileUrl != null) {
                    fileUrlMap.put(sqlScript, fileUrl);
                    if (containsCurrentGroup) continue;
                    containsCurrentGroup = SymmetricUtils.importContainsCurrentGroup((ISymmetricEngine)this, fileUrl, false);
                    continue;
                }
                log.warn("Could not find the {}: '{}' to execute.  We would have run it if we had found it", (Object)"auto.config.registration.svr.sql.script", (Object)sqlScript);
            }
            if (!containsCurrentGroup) {
                throw new SymmetricException("Invalid %s. The script doesn't contain the current node group (%s).", "auto.config.registration.svr.sql.script", this.parameterService.getNodeGroupId());
            }
            for (Map.Entry entry : fileUrlMap.entrySet()) {
                String sqlScript = (String)entry.getKey();
                URL fileUrl = (URL)entry.getValue();
                log.info("Executing {} '{}' ({})", new Object[]{"auto.config.registration.svr.sql.script", sqlScript, fileUrl});
                new SqlScript(fileUrl, this.symmetricDialect.getPlatform().getSqlTemplate(), true, ";", this.getSymmetricDialect().getPlatform().getSqlScriptReplacementTokens()).execute();
                loaded = true;
            }
        }
        return loaded;
    }

    protected void disableRegistrationIfNecessary(String registrationServerNodeId) {
        NodeSecurity nodeSecurity = this.nodeService.findNodeSecurity(registrationServerNodeId);
        if (nodeSecurity != null && nodeSecurity.isRegistrationEnabled()) {
            log.info("Node {} is a registration server and its registration_enabled flag in {} is set to 1. Setting it back to 0.", (Object)registrationServerNodeId, (Object)TableConstants.getTableName(this.getTablePrefix(), "node_security"));
            nodeSecurity.setRegistrationEnabled(false);
            this.nodeService.updateNodeSecurity(nodeSecurity);
        }
    }

    @Override
    public synchronized boolean start() {
        return this.start(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean start(boolean startJobs) {
        this.isInitialized = false;
        this.lastException = null;
        if (!this.starting && !this.started) {
            try {
                this.starting = true;
                this.symmetricDialect.verifyDatabaseIsCompatible();
                this.setup();
                if (this.isConfigured()) {
                    Node node = this.nodeService.findIdentity();
                    node = this.checkSystemIntegrity(node);
                    this.isInitialized = true;
                    if (node != null) {
                        boolean force;
                        log.info("Starting registered node [group={}, id={}, nodeId={}]", new Object[]{node.getNodeGroupId(), node.getNodeId(), node.getExternalId()});
                        boolean bl = force = this.isStartupDbParametersDifferentFromLastStart || this.parameterService.is("auto.sync.triggers.at.startup.force");
                        if (force || this.parameterService.is("auto.sync.triggers.at.startup", true) || this.triggerRouterService.getActiveTriggerHistories().size() == 0) {
                            this.triggerRouterService.syncTriggers(force);
                        } else {
                            log.info("auto.sync.triggers.at.startup is turned off");
                        }
                        if (this.parameterService.is("heartbeat.sync.on.startup", false) || StringUtils.isBlank((CharSequence)node.getDatabaseType()) || !Strings.CS.equals(node.getSyncUrl(), this.parameterService.getSyncUrl())) {
                            this.heartbeat(false);
                        }
                        if (this.parameterService.is("auto.sync.config.at.startup", true)) {
                            this.pullService.pullConfigData(false);
                        }
                    } else {
                        log.info("Starting unregistered node [group={}, externalId={}]", (Object)this.parameterService.getNodeGroupId(), (Object)this.parameterService.getExternalId());
                    }
                    if (this.jobManager != null) {
                        this.jobManager.init();
                    }
                    if (startJobs && this.jobManager != null) {
                        this.jobManager.startJobs();
                    }
                    if (this.parameterService.isRegistrationServer()) {
                        this.updateService.init();
                    }
                    if (this.isFirstStart) {
                        this.isFirstStart = false;
                    } else {
                        this.clearCaches();
                    }
                    this.lastRestartTime = new Date();
                    this.statisticManager.incrementRestart();
                    this.started = true;
                    for (ISymmetricEngineLifecycle ext : this.extensionService.getExtensionPointList(ISymmetricEngineLifecycle.class)) {
                        ext.started(this);
                    }
                } else {
                    log.error("Did not start SymmetricDS.  It has not been configured properly");
                }
            }
            catch (Throwable ex) {
                log.error("An error occurred while starting SymmetricDS", ex);
                this.lastException = ex;
                this.stop();
            }
            finally {
                this.starting = false;
            }
        }
        if (this.started) {
            log.info(this.getEngineDescription("STARTED:"));
        } else {
            log.info(this.getEngineDescription("NOT STARTED:"));
        }
        return this.started;
    }

    protected Node checkSystemIntegrity(Node node) {
        if (!(node == null || node.getExternalId().equals(this.getParameterService().getExternalId()) && node.getNodeGroupId().equals(this.getParameterService().getNodeGroupId()))) {
            if (this.parameterService.is("node.copy.mode.enabled", false)) {
                this.registrationService.requestNodeCopy();
            } else {
                throw new SymmetricException("The configured state does not match recorded database state.  The recorded external id is '%s' while the configured external id is '%s'. The recorded node group id is '%s' while the configured node group id is '%s'", node.getExternalId(), this.getParameterService().getExternalId(), node.getNodeGroupId(), this.getParameterService().getNodeGroupId());
            }
        }
        boolean useExtractJob = this.parameterService.is("initial.load.use.extract.job.enabled", true);
        boolean streamToFile = this.parameterService.is("stream.to.file.enabled", true);
        if (useExtractJob && !streamToFile) {
            throw new SymmetricException(String.format("Node '%s' is configured with conflicting parameters which may result in replication stopping and/or empty load batches. One of these two parameters needs to be changed: %s=%s and %s=%s", node != null ? node.getNodeId() : "null", "initial.load.use.extract.job.enabled", useExtractJob, "stream.to.file.enabled", streamToFile), new Object[0]);
        }
        INodePasswordFilter filter = this.extensionService.getExtensionPoint(INodePasswordFilter.class);
        if (filter != null) {
            log.info("Testing keystore integrity");
            try {
                this.securityService.encrypt("external.id");
            }
            catch (Exception e) {
                if (ExceptionUtils.is((Throwable)e, (Class[])new Class[]{UnrecoverableKeyException.class})) {
                    throw new SymmetricException("Failed to open keystore because keystore password is wrong.  Check javax.net.ssl.keyStorePassword in conf/sym_service.conf and bin/setenv.", e);
                }
                throw e;
            }
            log.info("Testing node security integrity");
            Map<String, NodeSecurity> nodeSecurities = this.nodeService.findAllNodeSecurity(false);
            ArrayList<NodeSecurity> badNodeSecurities = new ArrayList<NodeSecurity>();
            for (NodeSecurity nodeSecurity : nodeSecurities.values()) {
                if (!StringUtils.isBlank((CharSequence)nodeSecurity.getNodePassword())) continue;
                badNodeSecurities.add(nodeSecurity);
            }
            if (badNodeSecurities.size() > 0) {
                ArrayList<String> nodeIds = new ArrayList<String>();
                for (NodeSecurity nodeSecurity : badNodeSecurities) {
                    nodeIds.add(nodeSecurity.getNodeId());
                }
                if (this.parameterService.is("cluster.lock.enabled")) {
                    throw new IllegalStateException("Unable to decrypt " + badNodeSecurities.size() + " node security rows.  Copy the security/keystore file from a working node in the cluster.  Nodes affected: " + String.valueOf(nodeIds));
                }
                if (this.parameterService.isRegistrationServer()) {
                    log.error("Found {} bad node securities.  Attempting to re-open registration to fix them.  Nodes affected: {}", (Object)badNodeSecurities.size(), nodeIds);
                    String string = this.nodeService.findIdentityNodeId();
                    for (NodeSecurity nodeSecurity : badNodeSecurities) {
                        if (nodeSecurity.getNodeId().equals(string)) {
                            log.info("Re-generating my node password");
                            String password = this.extensionService.getExtensionPoint(INodeIdCreator.class).generatePassword(node);
                            nodeSecurity.setNodePassword(password);
                            this.nodeService.updateNodeSecurity(nodeSecurity);
                            continue;
                        }
                        this.registrationService.reOpenRegistration(nodeSecurity.getNodeId(), true);
                    }
                } else {
                    log.error("Found {} bad node securities.  Removing identity and attempting re-registration to fix them.  You may need to approve the registration request.  Nodes affected: {}", (Object)badNodeSecurities.size(), nodeIds);
                    this.nodeService.deleteIdentity();
                    node = null;
                }
            }
        }
        return node;
    }

    @Override
    public String getEngineDescription(String msg) {
        if (this.lastRestartTime == null) {
            return "";
        }
        String formattedUptime = FormatUtils.formatDurationReadable((long)(System.currentTimeMillis() - this.lastRestartTime.getTime()));
        return String.format("SymmetricDS Node %s\n\t nodeId=%s\n\t groupId=%s\n\t type=%s\n\t subType=%s\n\t name=%s\n\t softwareVersion=%s\n\t databaseName=%s\n\t databaseVersion=%s\n\t driverName=%s\n\t driverVersion=%s\n\t uptime=%s", msg, this.getParameterService().getExternalId(), this.getParameterService().getNodeGroupId(), this.getDeploymentType(), this.getDeploymentSubType(), this.getEngineName(), Version.version(), this.symmetricDialect.getName(), this.symmetricDialect.getVersion(), this.symmetricDialect.getDriverName(), this.symmetricDialect.getDriverVersion(), formattedUptime);
    }

    @Override
    public synchronized void uninstall() {
        this.uninstall(null);
    }

    @Override
    public synchronized void uninstall(IProcessInfoListener listener) {
        log.info("Attempting an uninstall of all SymmetricDS database objects from the database");
        int dropTriggersWeight = 20;
        int dropTablesWeight = 80;
        int totalStepCount = 113;
        ProcessInfo processInfo = this.statisticManager.newProcessInfo(new ProcessInfoKey(this.getNodeId(), null, ProcessType.UNINSTALL));
        if (listener != null) {
            processInfo.setListener(listener);
        }
        processInfo.setTotalDataCount(113L);
        this.stop();
        processInfo.incrementCurrentDataCount();
        log.info("Just cleaned {} files in the staging area during the uninstall.", (Object)this.getStagingManager().clean(0L));
        try {
            String prefix = this.parameterService.getTablePrefix();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "grouplet")) != null) {
                this.groupletService.deleteAllGrouplets();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "trigger_router")) != null) {
                this.triggerRouterService.deleteAllTriggerRouters();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "file_trigger_router")) != null) {
                this.fileSyncService.deleteAllFileTriggerRouters();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "router")) != null) {
                this.triggerRouterService.deleteAllRouters();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "conflict")) != null) {
                this.dataLoaderService.deleteAllConflicts();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "transform_table")) != null) {
                this.transformService.deleteAllTransformTables();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "router")) != null) {
                this.triggerRouterService.deleteAllRouters();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "conflict")) != null) {
                this.dataLoaderService.deleteAllConflicts();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "node_group_link")) != null) {
                this.configurationService.deleteAllNodeGroupLinks();
            }
            processInfo.incrementCurrentDataCount();
            if (this.platform.readTableFromDatabase(null, null, TableConstants.getTableName(prefix, "lock")) != null) {
                this.disableParameter("trigger.capture.ddl.changes");
                this.disableParameter("postgres.trigger.capture.truncate.event");
                this.triggerRouterService.syncTriggers(true);
            }
        }
        catch (SqlException ex) {
            log.warn("Error while trying to remove triggers on tables", (Throwable)ex);
        }
        processInfo.setCurrentDataCount(30L);
        this.symmetricDialect.cleanupTriggers();
        processInfo.incrementCurrentDataCount();
        log.info("Removing SymmetricDS database objects");
        Database symSchema = ((AbstractSymmetricDialect)this.symmetricDialect).readSymmetricSchemaFromDatabase();
        String dropTablesSql = this.platform.getDdlBuilder().dropTables(symSchema);
        DatabaseInfo databaseInfo = this.platform.getDatabaseInfo();
        int dropStatementsToRunCount = SqlScript.calculateTotalStatements((String)dropTablesSql, (String)databaseInfo.getSqlCommandDelimiter(), (boolean)databaseInfo.isTriggersContainJava());
        SqlScript dropTablesScript = new SqlScript(dropTablesSql, this.getSqlTemplate(), false, null);
        dropTablesScript.setListener(AbstractSymmetricEngine.generateDropTablesListener(processInfo, 80, dropStatementsToRunCount, 31));
        dropTablesScript.execute(this.platform.getDatabaseInfo().isRequiresAutoCommitForDdl());
        processInfo.setCurrentDataCount(111L);
        this.symmetricDialect.dropRequiredDatabaseObjects();
        processInfo.incrementCurrentDataCount();
        this.nodeService.deleteIdentity();
        this.parameterService.setDatabaseHasBeenInitialized(false);
        processInfo.setCurrentDataCount(113L);
        log.info("Finished uninstalling SymmetricDS database objects from the database");
    }

    private void disableParameter(String parameter) {
        if (this.parameterService.is(parameter)) {
            this.parameterService.saveParameter(this.parameterService.getExternalId(), this.parameterService.getNodeGroupId(), parameter, false, "system");
        }
    }

    private static ISqlResultsListener generateDropTablesListener(final ProcessInfo processInfo, final int dropTablesWeight, final int dropStatementsToRunCount, final int otherDataCount) {
        return new ISqlResultsListener(){

            public void sqlBefore(String sql, int lineNumber) {
            }

            public void sqlApplied(String sql, int rowsUpdated, int rowsRetrieved, int lineNumber) {
                processInfo.setCurrentDataCount(Math.round((float)(dropTablesWeight * (lineNumber + 1)) / (float)dropStatementsToRunCount) + otherDataCount);
            }

            public void sqlErrored(String sql, SqlException ex, int lineNumber, boolean dropStatement, boolean sequenceCreate) {
            }
        };
    }

    @Override
    public synchronized void stop() {
        log.info("Stopping SymmetricDS externalId={} version={} database={}", new Object[]{this.parameterService == null ? "?" : this.parameterService.getExternalId(), Version.version(), this.symmetricDialect == null ? "?" : this.symmetricDialect.getName()});
        if (this.jobManager != null) {
            this.jobManager.stopJobs();
        }
        if (this.routerService != null) {
            this.routerService.stop();
        }
        if (this.nodeCommunicationService != null) {
            this.nodeCommunicationService.stop();
        }
        if (this.updateService != null) {
            this.updateService.stop();
        }
        if (this.statisticManager != null) {
            List<ProcessInfo> infos = this.statisticManager.getProcessInfos();
            ArrayList<Thread> threadsToWaitOn = new ArrayList<Thread>();
            for (ProcessInfo processInfo : infos) {
                Thread thread = processInfo.getThread();
                if (processInfo.getStatus() == ProcessInfo.ProcessStatus.OK || !thread.isAlive()) continue;
                log.info("Attempting to interrupt thread '{}' ", (Object)thread.getName());
                try {
                    thread.interrupt();
                    threadsToWaitOn.add(thread);
                }
                catch (Exception e) {
                    log.info("Caught exception while attempting to interrupt thread", (Throwable)e);
                }
            }
            for (Thread thread : threadsToWaitOn) {
                try {
                    log.info("Waiting for thread {} to stop", (Object)thread.getName());
                    thread.join(5000L);
                    log.info("Thread {} stopped", (Object)thread.getName());
                }
                catch (Exception e) {
                    log.info("Caught exception while waiting for thread {} to stop", (Object)thread.getName(), (Object)e);
                }
            }
            Thread.interrupted();
        }
        this.started = false;
        this.starting = false;
        this.isInitialized = false;
        if (this.extensionService != null) {
            for (ISymmetricEngineLifecycle ext : this.extensionService.getExtensionPointList(ISymmetricEngineLifecycle.class)) {
                ext.stopped(this);
            }
        }
    }

    @Override
    public synchronized void destroy() {
        this.removeMeFromMap(registeredEnginesByName);
        this.removeMeFromMap(registeredEnginesByUrl);
        if (this.parameterService != null) {
            this.parameterService.setDatabaseHasBeenInitialized(false);
            if (this.getEngineName() != null) {
                registeredEnginesByName.remove(this.getEngineName());
            }
            if (this.getSyncUrl() != null) {
                registeredEnginesByUrl.remove(this.getSyncUrl());
            }
        }
        this.stop();
        if (this.jobManager != null) {
            this.jobManager.destroy();
        }
    }

    @Override
    public String reloadNode(String nodeId, String createBy) {
        return this.dataService.reloadNode(nodeId, false, createBy);
    }

    @Override
    public String sendSQL(String nodeId, String catalogName, String schemaName, String tableName, String sql) {
        return this.dataService.sendSQL(nodeId, catalogName, schemaName, tableName, sql);
    }

    @Override
    public RemoteNodeStatuses push() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        return this.pushService.pushData(true);
    }

    @Override
    public boolean syncTriggers() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        return this.triggerRouterService.syncTriggers();
    }

    @Override
    public boolean forceTriggerRebuild() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        return this.triggerRouterService.syncTriggers(true);
    }

    @Override
    public NodeStatus getNodeStatus() {
        return this.nodeService.getNodeStatus();
    }

    @Override
    public void removeAndCleanupNode(String nodeId) {
        log.info("Removing node {}", (Object)nodeId);
        this.nodeService.deleteNode(nodeId, false);
        log.info("Done removing node ID {}", (Object)nodeId);
    }

    @Override
    public RemoteNodeStatuses pull() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        return this.pullService.pullData(true);
    }

    @Override
    public void route() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        this.routerService.routeData(true);
    }

    @Override
    public void purge() {
        MDC.put((String)"engineName", (String)this.getEngineName());
        this.purgeService.purgeOutgoing(true);
        this.purgeService.purgeIncoming(true);
    }

    @Override
    public boolean isConfigured() {
        boolean configurationValid = false;
        String errorMessage = null;
        boolean isRegistrationServer = this.getNodeService().isRegistrationServer();
        boolean isSelfConfigurable = isRegistrationServer && (this.getParameterService().is("auto.insert.registration.svr.if.not.found", false) || StringUtils.isNotBlank((CharSequence)this.getParameterService().getString("auto.config.registration.svr.sql.script")));
        Table symNodeTable = this.symmetricDialect.getPlatform().getTableFromCache(null, null, TableConstants.getTableName(this.parameterService.getTablePrefix(), "node"), false);
        Node node = symNodeTable != null ? this.getNodeService().findIdentity() : null;
        long offlineNodeDetectionPeriodSeconds = this.getParameterService().getLong("offline.node.detection.period.minutes") * 60L;
        long heartbeatSeconds = this.getParameterService().getLong("heartbeat.sync.on.push.period.sec");
        String registrationUrl = this.getParameterService().getRegistrationUrl();
        if (!isSelfConfigurable && node == null && isRegistrationServer) {
            errorMessage = "This node is configured as a registration server, but it is missing its node_identity.  It probably needs configured.";
        } else if (!isSelfConfigurable && node == null && StringUtils.isBlank((CharSequence)this.getParameterService().getRegistrationUrl())) {
            errorMessage = "Please set the property {} so this node may pull registration or manually insert configuration into the configuration tables";
        } else if ("please set me".equals(registrationUrl)) {
            errorMessage = "Please set the registration.url for the node";
        } else if ("please set me".equals(this.getParameterService().getNodeGroupId())) {
            errorMessage = "Please set the group.id for the node";
        } else if ("please set me".equals(this.getParameterService().getExternalId())) {
            errorMessage = "Please set the external.id for the node";
        } else if (offlineNodeDetectionPeriodSeconds > 0L && offlineNodeDetectionPeriodSeconds <= heartbeatSeconds) {
            errorMessage = String.format("The %s property must be a longer period of time than the %s property.  Otherwise, nodes will be taken offline before the heartbeat job has a chance to run", "offline.node.detection.period.minutes", "heartbeat.sync.on.push.period.sec");
        } else if (node != null && Version.isOlderMinorVersion(Version.version(), node.getSymmetricVersion())) {
            errorMessage = String.format("SymmetricDS does not support automatic downgrading.  The current version running version of %s is older than the last running version of %s", Version.version(), node.getSymmetricVersion());
        } else if (!(StringUtils.isBlank((CharSequence)this.parameterService.getSyncUrl()) || this.parameterService.getSyncUrl().matches(".*/sync/?") || this.parameterService.getSyncUrl().endsWith(this.parameterService.getEngineName()))) {
            errorMessage = String.format("The engine is named %s' but the %s property does not end with the same engine name: %s", this.parameterService.getEngineName(), "sync.url", this.parameterService.getSyncUrl());
        } else if (!StringUtils.isBlank((CharSequence)this.parameterService.getSyncUrl()) && this.parameterService.getSyncUrl().matches(".*/sync/?") && PropertiesUtil.findEnginePropertiesFiles().length > 1) {
            errorMessage = String.format("There are multiple engine property files, so engine name of '%s' should be on the end of the %s property: %s", this.parameterService.getEngineName(), "sync.url", this.parameterService.getSyncUrl());
        } else {
            if (node != null && Version.isOlderMinorVersion(node.getSymmetricVersion(), Version.version())) {
                log.debug("The current version of {} is newer than the last running version of {}", (Object)Version.version(), (Object)node.getSymmetricVersion());
            }
            try {
                String syncUrl = this.transportManager.resolveURL(this.parameterService.getSyncUrl(), this.parameterService.getRegistrationUrl());
                new URL(syncUrl).toURI();
            }
            catch (MalformedURLException e) {
                errorMessage = String.format("The %s property is not a valid URL: %s", "sync.url", this.parameterService.getSyncUrl());
            }
            catch (URISyntaxException e) {
                errorMessage = String.format("The %s property is not a valid URI: %s", "sync.url", this.parameterService.getSyncUrl());
            }
            boolean bl = configurationValid = errorMessage == null;
        }
        if (errorMessage != null) {
            log.error(errorMessage);
            this.lastException = new SymmetricException(errorMessage, new Object[0]);
        }
        return configurationValid;
    }

    @Override
    public void heartbeat(boolean force) {
        MDC.put((String)"engineName", (String)this.getEngineName());
        this.dataService.heartbeat(force);
    }

    @Override
    public void openRegistration(String nodeGroupId, String externalId) {
        MDC.put((String)"engineName", (String)this.getEngineName());
        this.registrationService.openRegistration(nodeGroupId, externalId);
    }

    @Override
    public void clearCaches() {
        this.getExtensionService().refresh();
        this.getTriggerRouterService().clearCache();
        this.getParameterService().rereadParameters();
        this.getTransformService().clearCache();
        this.getDataLoaderService().clearCache();
        this.getConfigurationService().initDefaultChannels();
        this.getConfigurationService().clearCache();
        this.getNodeService().flushNodeAuthorizedCache();
        this.getNodeService().flushNodeCache();
        this.getNodeService().flushNodeGroupCache();
        this.getLoadFilterService().clearCache();
        this.getFileSyncService().clearCache();
    }

    @Override
    public void reOpenRegistration(String nodeId) {
        MDC.put((String)"engineName", (String)this.getEngineName());
        this.registrationService.reOpenRegistration(nodeId);
    }

    @Override
    public boolean isRegistered() {
        return this.nodeService.findIdentity() != null;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isStarting() {
        return this.starting;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public IConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    @Override
    public IParameterService getParameterService() {
        return this.parameterService;
    }

    @Override
    public INodeService getNodeService() {
        return this.nodeService;
    }

    @Override
    public IRegistrationService getRegistrationService() {
        return this.registrationService;
    }

    @Override
    public IClusterService getClusterService() {
        return this.clusterService;
    }

    @Override
    public IPurgeService getPurgeService() {
        return this.purgeService;
    }

    @Override
    public IDataService getDataService() {
        return this.dataService;
    }

    @Override
    public IJobManager getJobManager() {
        return this.jobManager;
    }

    @Override
    public IOutgoingBatchService getOutgoingBatchService() {
        return this.outgoingBatchService;
    }

    @Override
    public IAcknowledgeService getAcknowledgeService() {
        return this.acknowledgeService;
    }

    @Override
    public IBandwidthService getBandwidthService() {
        return this.bandwidthService;
    }

    @Override
    public IDataExtractorService getDataExtractorService() {
        return this.dataExtractorService;
    }

    @Override
    public IDataExtractorService getFileSyncExtractorService() {
        return this.fileSyncExtractorService;
    }

    @Override
    public IDataLoaderService getDataLoaderService() {
        return this.dataLoaderService;
    }

    @Override
    public IIncomingBatchService getIncomingBatchService() {
        return this.incomingBatchService;
    }

    @Override
    public IPullService getPullService() {
        return this.pullService;
    }

    @Override
    public IPushService getPushService() {
        return this.pushService;
    }

    @Override
    public IOfflinePullService getOfflinePullService() {
        return this.offlinePullService;
    }

    @Override
    public IOfflinePushService getOfflinePushService() {
        return this.offlinePushService;
    }

    @Override
    public IRouterService getRouterService() {
        return this.routerService;
    }

    @Override
    public ISecurityService getSecurityService() {
        return this.securityService;
    }

    @Override
    public IStatisticService getStatisticService() {
        return this.statisticService;
    }

    @Override
    public IStatisticManager getStatisticManager() {
        return this.statisticManager;
    }

    @Override
    public ITriggerRouterService getTriggerRouterService() {
        return this.triggerRouterService;
    }

    @Override
    public String getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public String getDeploymentSubType() {
        return this.deploymentSubType;
    }

    @Override
    public ITransformService getTransformService() {
        return this.transformService;
    }

    @Override
    public ILoadFilterService getLoadFilterService() {
        return this.loadFilterService;
    }

    @Override
    public IInitialLoadService getInitialLoadService() {
        return this.initialLoadService;
    }

    @Override
    public IConcurrentConnectionManager getConcurrentConnectionManager() {
        return this.concurrentConnectionManager;
    }

    @Override
    public String getTablePrefix() {
        return this.parameterService.getTablePrefix();
    }

    @Override
    public ITransportManager getTransportManager() {
        return this.transportManager;
    }

    public ITransportManager getOfflineTransportManager() {
        return this.offlineTransportManager;
    }

    @Override
    public IExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    public IContextService getContextService() {
        return this.contextService;
    }

    @Override
    public IStagingManager getStagingManager() {
        return this.stagingManager;
    }

    @Override
    public ISequenceService getSequenceService() {
        return this.sequenceService;
    }

    @Override
    public INodeCommunicationService getNodeCommunicationService() {
        return this.nodeCommunicationService;
    }

    @Override
    public IGroupletService getGroupletService() {
        return this.groupletService;
    }

    @Override
    public Throwable getLastException() {
        return this.lastException;
    }

    @Override
    public String getLastExceptionMessage() {
        return this.lastException == null ? null : this.lastException.getMessage();
    }

    private void removeMeFromMap(Map<String, ISymmetricEngine> map) {
        HashSet<String> keys = new HashSet<String>(map.keySet());
        for (String key : keys) {
            if (!this.equals(map.get(key))) continue;
            map.remove(key);
        }
    }

    private void registerHandleToEngine() {
        String url = this.getSyncUrl();
        ISymmetricEngine alreadyRegister = null;
        if (url != null) {
            alreadyRegister = registeredEnginesByUrl.get(url);
        }
        if (alreadyRegister == null || alreadyRegister.equals(this)) {
            if (url != null) {
                registeredEnginesByUrl.put(url, this);
            }
        } else {
            log.warn("Could not register engine.  There was already an engine registered under the url: {}", (Object)this.getSyncUrl());
        }
        if (this.getEngineName() != null) {
            alreadyRegister = registeredEnginesByName.get(this.getEngineName());
        }
        if (alreadyRegister != null && !alreadyRegister.equals(this)) {
            throw new EngineAlreadyRegisteredException("Could not register engine.  There was already an engine registered under the name: " + this.getEngineName(), new Object[0]);
        }
        registeredEnginesByName.put(this.getEngineName(), this);
    }

    @Override
    public Date getLastRestartTime() {
        return this.lastRestartTime;
    }

    @Override
    public ISqlTemplate getSqlTemplate() {
        return this.getSymmetricDialect().getPlatform().getSqlTemplate();
    }

    @Override
    public Logger getLog() {
        return log;
    }

    @Override
    public <T> T getDataSource() {
        return (T)this.getSymmetricDialect().getPlatform().getDataSource();
    }

    @Override
    public IDatabasePlatform getDatabasePlatform() {
        return this.getSymmetricDialect().getPlatform();
    }

    @Override
    public IFileSyncService getFileSyncService() {
        return this.fileSyncService;
    }

    @Override
    public IUpdateService getUpdateService() {
        return this.updateService;
    }

    @Override
    public String getNodeId() {
        return this.getNodeService().findIdentityNodeId();
    }

    @Override
    public ISymmetricDialect getSymmetricDialect() {
        return this.symmetricDialect;
    }

    @Override
    public ISymmetricDialect getTargetDialect() {
        return this.symmetricDialect.getTargetDialect();
    }

    public String toString() {
        return "Engine " + this.getNodeId() + " " + super.toString();
    }

    @Override
    public ICacheManager getCacheManager() {
        return this.cacheManager;
    }

    protected boolean detectStartupDbParametersDifferentFromLastStart() {
        boolean dbParamsDifferent = false;
        try {
            int hashDbParams = this.parameterService.hashParameterValues(ParameterConstants.STARTUP_DB_OBJECTS_SETUP_PARAMS);
            String currentHashDbParamsAsString = "0x" + Integer.toHexString(hashDbParams);
            String priorHashDbParams = this.contextService.getString("startup.database.parameters.hash");
            if (currentHashDbParamsAsString.equals(priorHashDbParams)) {
                log.debug("No change in SymmetricDS startup database parameters. Hash {} == {}", (Object)currentHashDbParamsAsString, (Object)priorHashDbParams);
            } else {
                dbParamsDifferent = true;
                this.contextService.save("startup.database.parameters.hash", currentHashDbParamsAsString);
                log.info("Detected change in SymmetricDS startup database parameters. Hash {} != {}", (Object)currentHashDbParamsAsString, (Object)priorHashDbParams);
            }
        }
        catch (Exception e) {
            dbParamsDifferent = true;
            log.warn("Unable to compare SymmetricDS startup database parameters! Assuming there are differences.", (Throwable)e);
        }
        return dbParamsDifferent;
    }
}

