/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.jumpmind.db.sql.SqlException;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.NodeChannel;
import org.jumpmind.symmetric.model.NodeGroupChannelWindow;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationCache {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationCache.class);
    private IParameterService parameterService;
    private IConfigurationService configurationService;
    private Semaphore configurationCacheLock = new Semaphore(1);
    private volatile Map<String, List<NodeChannel>> nodeChannelCache;
    private volatile Map<String, Channel> channelsCache;
    private volatile Collection<String> queuesCache;
    private volatile List<NodeGroupLink> nodeGroupLinksCache;
    private volatile Map<String, List<NodeGroupChannelWindow>> channelWindowsByChannelCache;
    private volatile long channelCacheTime;
    private volatile long nodeChannelCacheTime;
    private volatile long nodeGroupLinkCacheTime;
    private volatile long channelWindowsByChannelCacheTime;

    public ConfigurationCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.configurationService = engine.getConfigurationService();
    }

    public List<NodeChannel> getNodeChannels(String nodeId) {
        if (nodeId == null) {
            return new ArrayList<NodeChannel>(0);
        }
        this.checkNodeChannelCache(nodeId);
        if (this.nodeChannelCache != null) {
            return this.nodeChannelCache.getOrDefault(nodeId, new ArrayList(0));
        }
        return new ArrayList<NodeChannel>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNodeChannelCache(String nodeId) {
        List<NodeChannel> nodeChannels;
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms");
        List<NodeChannel> list = nodeChannels = this.nodeChannelCache != null ? this.nodeChannelCache.get(nodeId) : null;
        if (System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || this.nodeChannelCache == null || nodeChannels == null) {
            if (this.nodeChannelCache == null || nodeChannels == null) {
                try {
                    this.configurationCacheLock.acquire();
                    try {
                        boolean refreshCache = System.currentTimeMillis() - this.nodeChannelCacheTime >= channelCacheTimeoutInMs || this.nodeChannelCache == null;
                        List<NodeChannel> list2 = nodeChannels = this.nodeChannelCache != null ? this.nodeChannelCache.get(nodeId) : null;
                        if (refreshCache || nodeChannels == null) {
                            this.populateNodeChannelCache(nodeId, refreshCache, channelCacheTimeoutInMs);
                        }
                    }
                    catch (SqlException e) {
                        log.error("Failed to retrieve node channels", (Throwable)e);
                    }
                    finally {
                        this.configurationCacheLock.release();
                    }
                }
                catch (InterruptedException e) {
                    log.error("Failed to retrieve node channels", (Throwable)e);
                }
            } else if (this.configurationCacheLock.tryAcquire()) {
                try {
                    this.populateNodeChannelCache(nodeId, true, channelCacheTimeoutInMs);
                }
                catch (SqlException e) {
                    log.error("Failed to retrieve node channels", (Throwable)e);
                }
                finally {
                    this.configurationCacheLock.release();
                }
            }
        }
    }

    protected void populateNodeChannelCache(String nodeId, boolean refreshCache, long channelCacheTimeoutInMs) throws SqlException {
        long startTime = System.currentTimeMillis();
        List<NodeChannel> nodeChannels = this.configurationService.getNodeChannelsFromDb(nodeId);
        if (refreshCache) {
            this.nodeChannelCache = new HashMap<String, List<NodeChannel>>();
            this.nodeChannelCacheTime = System.currentTimeMillis();
        }
        this.nodeChannelCache.put(nodeId, nodeChannels);
        long queryTime = System.currentTimeMillis() - startTime;
        if (queryTime > channelCacheTimeoutInMs) {
            log.warn("Query time of {} ms exceeded cache time of {} ms for node channels.  This means the query may run on the database constantly.", (Object)queryTime, (Object)channelCacheTimeoutInMs);
        }
    }

    public long getNodeChannelCacheTime() {
        return this.nodeChannelCacheTime;
    }

    public Map<String, Channel> getChannels(boolean refreshCache) {
        this.checkChannelCache(refreshCache);
        if (this.channelsCache != null) {
            return this.channelsCache;
        }
        return new HashMap<String, Channel>(0);
    }

    public Collection<String> getQueues(boolean refreshCache) {
        this.checkChannelCache(refreshCache);
        if (this.queuesCache != null) {
            return this.queuesCache;
        }
        return new ArrayList<String>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkChannelCache(boolean refreshCache) {
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms", 60000L);
        if (System.currentTimeMillis() - this.channelCacheTime >= channelCacheTimeoutInMs || this.channelsCache == null || refreshCache) {
            if (this.channelsCache == null) {
                try {
                    this.configurationCacheLock.acquire();
                    try {
                        if (System.currentTimeMillis() - this.channelCacheTime >= channelCacheTimeoutInMs || this.channelsCache == null || refreshCache) {
                            this.populateChannelCache(channelCacheTimeoutInMs);
                        }
                    }
                    catch (SqlException e) {
                        log.error("Failed to retrieve channels", (Throwable)e);
                    }
                    finally {
                        this.configurationCacheLock.release();
                    }
                }
                catch (InterruptedException e) {
                    log.error("Failed to retrieve channels", (Throwable)e);
                }
            } else if (this.configurationCacheLock.tryAcquire()) {
                try {
                    this.populateChannelCache(channelCacheTimeoutInMs);
                }
                catch (SqlException e) {
                    log.error("Failed to retrieve channels", (Throwable)e);
                }
                finally {
                    this.configurationCacheLock.release();
                }
            }
        }
    }

    protected void populateChannelCache(long channelCacheTimeoutInMs) throws SqlException {
        long startTime = System.currentTimeMillis();
        this.channelsCache = this.configurationService.getChannelsFromDb();
        HashSet<String> queues = new HashSet<String>();
        for (Channel channel : this.channelsCache.values()) {
            queues.add(channel.getQueue());
        }
        this.queuesCache = queues;
        this.channelCacheTime = System.currentTimeMillis();
        long queryTime = this.channelCacheTime - startTime;
        if (queryTime > channelCacheTimeoutInMs) {
            log.warn("Query time of {} ms exceeded cache time of {} ms for channels.  This means the query may run on the database constantly.", (Object)queryTime, (Object)channelCacheTimeoutInMs);
        }
    }

    public List<NodeGroupLink> getNodeGroupLinks(boolean refreshCache) {
        this.checkNodeGroupLinkCache(refreshCache);
        if (this.nodeGroupLinksCache != null) {
            return this.nodeGroupLinksCache;
        }
        return new ArrayList<NodeGroupLink>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNodeGroupLinkCache(boolean refreshCache) {
        long cacheTimeoutInMs = this.parameterService.getLong("cache.node.group.link.time.ms");
        if (System.currentTimeMillis() - this.nodeGroupLinkCacheTime >= cacheTimeoutInMs || this.nodeGroupLinksCache == null || refreshCache) {
            if (this.nodeGroupLinksCache == null || refreshCache) {
                try {
                    this.configurationCacheLock.acquire();
                    try {
                        if (System.currentTimeMillis() - this.nodeGroupLinkCacheTime >= cacheTimeoutInMs || this.nodeGroupLinksCache == null || refreshCache) {
                            this.populateNodeGroupLinkCache(cacheTimeoutInMs);
                        }
                    }
                    catch (SqlException e) {
                        log.error("Failed to retrieve node group links", (Throwable)e);
                    }
                    finally {
                        this.configurationCacheLock.release();
                    }
                }
                catch (InterruptedException e) {
                    log.error("Failed to retrieve node group links", (Throwable)e);
                }
            } else if (this.configurationCacheLock.tryAcquire()) {
                try {
                    this.populateNodeGroupLinkCache(cacheTimeoutInMs);
                }
                catch (SqlException e) {
                    log.error("Failed to retrieve node group links", (Throwable)e);
                }
                finally {
                    this.configurationCacheLock.release();
                }
            }
        }
    }

    protected void populateNodeGroupLinkCache(long cacheTimeoutInMs) throws SqlException {
        long startTime = System.currentTimeMillis();
        this.nodeGroupLinksCache = this.configurationService.getNodeGroupLinksFromDb();
        this.nodeGroupLinkCacheTime = System.currentTimeMillis();
        long queryTime = this.nodeGroupLinkCacheTime - startTime;
        if (queryTime > cacheTimeoutInMs) {
            log.warn("Query time of {} ms exceeded cache time of {} ms for node group links.  This means the query may run on the database constantly.", (Object)queryTime, (Object)cacheTimeoutInMs);
        }
    }

    public Map<String, List<NodeGroupChannelWindow>> getNodeGroupChannelWindows() {
        this.checkNodeGroupChannelWindowCache();
        if (this.channelWindowsByChannelCache != null) {
            return this.channelWindowsByChannelCache;
        }
        return new HashMap<String, List<NodeGroupChannelWindow>>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkNodeGroupChannelWindowCache() {
        long channelCacheTimeoutInMs = this.parameterService.getLong("cache.channel.time.ms", 60000L);
        if (System.currentTimeMillis() - this.channelWindowsByChannelCacheTime >= channelCacheTimeoutInMs || this.channelWindowsByChannelCache == null) {
            if (this.channelWindowsByChannelCache == null) {
                try {
                    this.configurationCacheLock.acquire();
                    try {
                        if (System.currentTimeMillis() - this.channelWindowsByChannelCacheTime >= channelCacheTimeoutInMs || this.channelWindowsByChannelCache == null) {
                            this.populateNodeGroupChannelWindowCache(channelCacheTimeoutInMs);
                        }
                    }
                    catch (SqlException e) {
                        log.error("Failed to retrieve node group channel windows", (Throwable)e);
                    }
                    finally {
                        this.configurationCacheLock.release();
                    }
                }
                catch (InterruptedException e) {
                    log.error("Failed to retrieve node group channel windows", (Throwable)e);
                }
            } else if (this.configurationCacheLock.tryAcquire()) {
                try {
                    this.populateNodeGroupChannelWindowCache(channelCacheTimeoutInMs);
                }
                catch (SqlException e) {
                    log.error("Failed to retrieve node group channel windows", (Throwable)e);
                }
                finally {
                    this.configurationCacheLock.release();
                }
            }
        }
    }

    protected void populateNodeGroupChannelWindowCache(long channelCacheTimeoutInMs) throws SqlException {
        long startTime = System.currentTimeMillis();
        this.channelWindowsByChannelCache = this.configurationService.getNodeGroupChannelWindowsFromDb();
        this.channelWindowsByChannelCacheTime = System.currentTimeMillis();
        long queryTime = this.channelWindowsByChannelCacheTime - startTime;
        if (queryTime > channelCacheTimeoutInMs) {
            log.warn("Query time of {} ms exceeded cache time of {} ms for node group channel windows.  This means the query may run on the database constantly.", (Object)queryTime, (Object)channelCacheTimeoutInMs);
        }
    }

    public void flushNodeChannels() {
        if (this.configurationCacheLock.tryAcquire()) {
            this.nodeChannelCacheTime = 0L;
            this.configurationCacheLock.release();
        }
    }

    public void flushChannels() {
        if (this.configurationCacheLock.tryAcquire()) {
            this.channelCacheTime = 0L;
            this.configurationCacheLock.release();
        }
    }

    public void flushNodeGroupLinks() {
        if (this.configurationCacheLock.tryAcquire()) {
            this.nodeGroupLinkCacheTime = 0L;
            this.configurationCacheLock.release();
        }
    }

    public void flushNodeGroupChannelWindows() {
        if (this.configurationCacheLock.tryAcquire()) {
            this.channelWindowsByChannelCacheTime = 0L;
            this.configurationCacheLock.release();
        }
    }
}

