/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IDataLoaderService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.DataLoaderService;

public class DataLoaderCache {
    private IParameterService parameterService;
    private IDataLoaderService dataLoaderService;
    private volatile long lastConflictCacheResetTimeInMs;
    private volatile Map<NodeGroupLink, List<DataLoaderService.ConflictNodeGroupLink>> conflictSettingsCache = new HashMap<NodeGroupLink, List<DataLoaderService.ConflictNodeGroupLink>>();
    private volatile Object dataLoaderCacheLock = new Object();

    public DataLoaderCache(ISymmetricEngine engine) {
        this.parameterService = engine.getParameterService();
        this.dataLoaderService = engine.getDataLoaderService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataLoaderService.ConflictNodeGroupLink> getConflictSettingsNodeGroupLinks(NodeGroupLink link, boolean refreshCache) {
        List<DataLoaderService.ConflictNodeGroupLink> list;
        long cacheTime = this.parameterService.getLong("cache.conflict.time.ms");
        if (System.currentTimeMillis() - this.lastConflictCacheResetTimeInMs > cacheTime || refreshCache) {
            this.clearDataLoaderCache();
        }
        Object object = this.dataLoaderCacheLock;
        synchronized (object) {
            list = this.conflictSettingsCache.get(link);
            if (list == null) {
                list = this.dataLoaderService.getConflictSettinsNodeGroupLinksFromDb(link);
                this.conflictSettingsCache.put(link, list);
                this.lastConflictCacheResetTimeInMs = System.currentTimeMillis();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDataLoaderCache() {
        Object object = this.dataLoaderCacheLock;
        synchronized (object) {
            this.conflictSettingsCache = new HashMap<NodeGroupLink, List<DataLoaderService.ConflictNodeGroupLink>>();
            this.lastConflictCacheResetTimeInMs = 0L;
        }
    }
}

