/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.io;

import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.io.IOfflineClientListener;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.INodeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOfflineClientListener
implements IOfflineClientListener,
IBuiltInExtensionPoint {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;

    public DefaultOfflineClientListener(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public void busy(Node remoteNode) {
    }

    @Override
    public void notAuthenticated(Node remoteNode) {
    }

    @Override
    public void unknownError(Node remoteNode, Exception ex) {
    }

    @Override
    public void offline(Node remoteNode) {
    }

    @Override
    public void syncDisabled(Node remoteNode) {
        INodeService nodeService = this.engine.getNodeService();
        Node identity = nodeService.findIdentity();
        if (identity != null && (identity.getCreatedAtNodeId() != null && identity.getCreatedAtNodeId().equals(remoteNode.getNodeId()) || this.engine.getConfigurationService().isMasterToMaster())) {
            this.log.warn("Uninstalling node because sync has been disabled");
            this.engine.uninstall();
        }
    }

    @Override
    public void registrationRequired(Node remoteNode) {
    }

    @Override
    public void online(Node remoteNode) {
    }
}

