/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.load;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.symmetric.io.data.writer.Conflict;
import org.jumpmind.symmetric.io.data.writer.DatabaseWriterSettings;
import org.jumpmind.symmetric.service.IParameterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDataLoaderFactory {
    protected IParameterService parameterService;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    public DatabaseWriterSettings buildParameterDatabaseWriterSettings(List<? extends Conflict> conflictSettings) {
        DatabaseWriterSettings settings = new DatabaseWriterSettings();
        settings.setCreateTableAlterCaseToMatchDatabaseDefault(this.parameterService.is("dataloader.create.table.alter.to.match.db.case", true));
        settings.setCreateTableWithoutDefaultsOnError(this.parameterService.is("dataloader.create.table.without.defaults.on.error", false));
        settings.setMaxRowsBeforeCommit(this.parameterService.getLong("dataloader.max.rows.before.commit"));
        settings.setCommitSleepInterval(this.parameterService.getLong("dataloader.sleep.time.after.early.commit"));
        settings.setIgnoreMissingTables(this.parameterService.is("dataloader.ignore.missing.tables"));
        settings.setTreatDateTimeFieldsAsVarchar(this.parameterService.is("db.treat.date.time.as.varchar.enabled"));
        settings.setTreatBitFieldsAsInteger(this.parameterService.is("db.treat.bit.as.integer.enabled", this.getDefaultTreatBitAsInteger()));
        settings.setSaveCurrentValueOnError(this.parameterService.is("dataloader.error.save.curval", false));
        settings.setFitToColumn(this.parameterService.is("dataloader.fit.to.column", false));
        settings.setAutoResolveForeignKeyViolationDelete(this.parameterService.is("auto.resolve.foreign.key.violation.delete", true));
        settings.setAutoResolvePrimaryKeyViolation(this.parameterService.is("auto.resolve.primary.key.violation", true));
        settings.setAutoResolveUniqueIndexViolation(this.parameterService.is("auto.resolve.unique.index.violation", true));
        settings.setAutoResolveUniqueIndexIgnoreNullValues(this.parameterService.is("auto.resolve.unique.index.ignore.null.values", true));
        settings.setAutoResolveCaptureDeleteMissingRows(this.parameterService.is("auto.resolve.capture.delete.missing.rows"));
        settings.setLogConflictResolution(this.parameterService.is("log.conflict.resolution"));
        settings.setTextColumnExpression(this.parameterService.getString("dataloader.text.column.expression"));
        settings.setApplyChangesOnly(this.parameterService.is("dataloader.apply.changes.only", true));
        settings.setUsePrimaryKeysFromSource(this.parameterService.is("dataloader.use.primary.keys.from.source"));
        settings.setIgnoreSqlDataEventFailures(this.parameterService.is("dataloader.ignore.sql.event.errors", false));
        settings.setLogSqlParamsOnError(this.parameterService.is("dataloader.log.sql.params.on.error", true));
        settings.setCreateIndexConvertUniqueToNonuniqueWhenColumnsNotRequired(this.parameterService.is("create.index.convert.unique.to.nonunique.when.columns.not.required", true));
        settings.setStripOutCommentsInScripts(this.parameterService.is("dataloader.sql.event.strip.comments", true));
        String triggerPrefix = this.parameterService.getString("sync.trigger.prefix");
        if (triggerPrefix == null || triggerPrefix.length() == 0) {
            triggerPrefix = this.parameterService.getString("sync.table.prefix", "sym");
        }
        settings.setRuntimeConfigTriggerPrefix(triggerPrefix);
        settings.setCreateTableIncludeApplicationTriggers(this.parameterService.is("create.table.include.application.triggers", false));
        HashMap<String, Conflict> byChannel = new HashMap<String, Conflict>();
        HashMap<String, Conflict> byTable = new HashMap<String, Conflict>();
        boolean multipleDefaultSettingsFound = false;
        if (conflictSettings != null) {
            for (Conflict conflict : conflictSettings) {
                String qualifiedTableName = conflict.toQualifiedTableName();
                if (StringUtils.isNotBlank((CharSequence)qualifiedTableName)) {
                    byTable.put(qualifiedTableName, conflict);
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)conflict.getTargetChannelId())) {
                    byChannel.put(conflict.getTargetChannelId(), conflict);
                    continue;
                }
                if (settings.getDefaultConflictSetting() != null) {
                    multipleDefaultSettingsFound = true;
                }
                settings.setDefaultConflictSetting(conflict);
            }
        }
        if (multipleDefaultSettingsFound) {
            this.log.warn("There were multiple default conflict settings found.  Using '{}' as the default", (Object)settings.getDefaultConflictSetting().getConflictId());
        }
        if (settings.getDefaultConflictSetting() == null && this.parameterService.is("conflict.default.pk.with.fallback")) {
            Conflict conflict = new Conflict();
            conflict.setDetectType(Conflict.DetectConflict.USE_PK_DATA);
            conflict.setResolveType(Conflict.ResolveConflict.FALLBACK);
            settings.setDefaultConflictSetting(conflict);
        }
        settings.setConflictSettingsByChannel(byChannel);
        settings.setConflictSettingsByTable(byTable);
        settings.setKeepBulkStagingFiles(this.parameterService.is("keep.bulk.staging.files"));
        settings.setMsSqlBulkLoadBcpCodePage(this.parameterService.getString("mssql.bulk.load.bcp.code.page"));
        return settings;
    }

    protected boolean getDefaultTreatBitAsInteger() {
        return false;
    }
}

