/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.model;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jumpmind.db.model.Column;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.csv.CsvReader;
import org.jumpmind.symmetric.db.AbstractTriggerTemplate;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerReBuildReason;

public class TriggerHistory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int triggerHistoryId;
    private String triggerId;
    private String sourceTableName;
    private String sourceTableNameLowerCase;
    private String sourceSchemaName;
    private String sourceCatalogName;
    private Date createTime;
    private String columnNames;
    private String[] parsedColumnNames;
    private String pkColumnNames;
    private String[] parsedPkColumnNames;
    private boolean isMissingPk;
    private String nameForInsertTrigger;
    private String nameForUpdateTrigger;
    private String nameForDeleteTrigger;
    private String errorMessage;
    private Date inactiveTime;
    private int tableHash;
    private long triggerRowHash;
    private long triggerTemplateHash;
    private TriggerReBuildReason lastTriggerBuildReason;

    public TriggerHistory() {
        this.createTime = new Date();
    }

    public TriggerHistory(int triggerHistoryId) {
        this();
        this.triggerHistoryId = triggerHistoryId;
    }

    public TriggerHistory(String tableName, String pkColumnNames, String columnNames) {
        this();
        this.sourceTableName = tableName;
        this.pkColumnNames = pkColumnNames;
        this.columnNames = columnNames;
        this.isMissingPk = Objects.equals(pkColumnNames, columnNames) || StringUtils.isBlank((CharSequence)pkColumnNames);
    }

    public TriggerHistory(Table table, Trigger trigger, AbstractTriggerTemplate triggerTemplate) {
        this(table, trigger, triggerTemplate, null);
    }

    public TriggerHistory(Table table, Trigger trigger, AbstractTriggerTemplate triggerTemplate, TriggerReBuildReason reason) {
        this();
        if (triggerTemplate == null) {
            throw new SymmetricException("triggerTemplate cannot be null. Does the current dialect have a TriggerTemplate?", new Object[0]);
        }
        this.lastTriggerBuildReason = reason;
        this.sourceTableName = trigger.isSourceTableNameWildCarded() || trigger.isSourceTableNameExpanded() ? table.getName() : trigger.getSourceTableNameUnescaped();
        this.columnNames = Table.getCommaDeliminatedColumns((Column[])trigger.orderColumnsForTable(table));
        this.sourceSchemaName = trigger.isSourceSchemaNameWildCarded() ? table.getSchema() : trigger.getSourceSchemaNameUnescaped();
        this.sourceCatalogName = trigger.isSourceCatalogNameWildCarded() ? table.getCatalog() : trigger.getSourceCatalogNameUnescaped();
        this.triggerId = trigger.getTriggerId();
        this.pkColumnNames = Table.getCommaDeliminatedColumns((Column[])trigger.filterExcludedAndIncludedColumns(trigger.getSyncKeysColumnsForTable(table)));
        this.isMissingPk = !table.hasPrimaryKey() || table.isMadeAllColumnsPrimaryKey() || StringUtils.isBlank((CharSequence)this.pkColumnNames);
        this.triggerRowHash = trigger.toHashedValue();
        this.triggerTemplateHash = triggerTemplate.toHashedValue();
        this.tableHash = table.calculateTableHashcode();
    }

    public TriggerHistory(Trigger trigger) {
        this.sourceCatalogName = trigger.getSourceCatalogName();
        this.sourceSchemaName = trigger.getSourceSchemaName();
        this.sourceTableName = trigger.getSourceTableName();
        this.triggerId = trigger.getTriggerId();
    }

    public String getTriggerNameForDmlType(DataEventType type) {
        switch (type) {
            case INSERT: {
                return this.getNameForInsertTrigger();
            }
            case UPDATE: {
                return this.getNameForUpdateTrigger();
            }
            case DELETE: {
                return this.getNameForDeleteTrigger();
            }
        }
        throw new IllegalStateException();
    }

    public String[] getParsedColumnNames() {
        if (this.parsedColumnNames == null && this.columnNames != null) {
            this.parsedColumnNames = this.parseColumnNames(this.columnNames);
        }
        return this.parsedColumnNames;
    }

    public int indexOfColumnName(String columnName, boolean ignoreCase) {
        String[] columnNames = this.getParsedColumnNames();
        int i = 0;
        for (String col : columnNames) {
            if (ignoreCase && col.equalsIgnoreCase(columnName)) {
                return i;
            }
            if (col.equals(columnName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String[] getParsedPkColumnNames() {
        if (this.parsedPkColumnNames == null && this.pkColumnNames != null) {
            this.parsedPkColumnNames = this.parseColumnNames(this.pkColumnNames);
        }
        return this.parsedPkColumnNames;
    }

    public int getTableHash() {
        return this.tableHash;
    }

    public void setTableHash(int tableHash) {
        this.tableHash = tableHash;
    }

    public String getFullyQualifiedSourceTableName() {
        return Table.getFullyQualifiedTableName((String)this.sourceCatalogName, (String)this.sourceSchemaName, (String)this.sourceTableName);
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public void setSourceTableName(String tableName) {
        this.sourceTableName = tableName;
        this.sourceTableNameLowerCase = null;
    }

    public String getSourceTableNameLowerCase() {
        if (this.sourceTableNameLowerCase == null) {
            this.sourceTableNameLowerCase = this.sourceTableName.toLowerCase();
        }
        return this.sourceTableNameLowerCase;
    }

    public String getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String allColumnData) {
        this.columnNames = allColumnData;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public TriggerReBuildReason getLastTriggerBuildReason() {
        return this.lastTriggerBuildReason;
    }

    public void setLastTriggerBuildReason(TriggerReBuildReason lastTriggerBuildReason) {
        this.lastTriggerBuildReason = lastTriggerBuildReason;
    }

    public String getPkColumnNames() {
        return this.pkColumnNames;
    }

    public void setPkColumnNames(String pkColumnData) {
        this.pkColumnNames = pkColumnData;
    }

    public boolean isMissingPk() {
        return this.isMissingPk;
    }

    public void setIsMissingPk(boolean isMissingPk) {
        this.isMissingPk = isMissingPk;
    }

    public int getTriggerHistoryId() {
        return this.triggerHistoryId;
    }

    public void setTriggerHistoryId(int tableSyncAuditId) {
        this.triggerHistoryId = tableSyncAuditId;
    }

    public String getNameForDeleteTrigger() {
        return this.nameForDeleteTrigger;
    }

    public void setNameForDeleteTrigger(String nameForDeleteTrigger) {
        this.nameForDeleteTrigger = nameForDeleteTrigger;
    }

    public String getNameForInsertTrigger() {
        return this.nameForInsertTrigger;
    }

    public void setNameForInsertTrigger(String nameForInsertTrigger) {
        this.nameForInsertTrigger = nameForInsertTrigger;
    }

    public String getNameForUpdateTrigger() {
        return this.nameForUpdateTrigger;
    }

    public void setNameForUpdateTrigger(String nameForUpdateTrigger) {
        this.nameForUpdateTrigger = nameForUpdateTrigger;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void setSourceSchemaName(String schemaName) {
        this.sourceSchemaName = schemaName;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String triggerId) {
        this.triggerId = triggerId;
    }

    public Date getInactiveTime() {
        return this.inactiveTime;
    }

    public void setInactiveTime(Date inactiveTime) {
        this.inactiveTime = inactiveTime;
    }

    public String getSourceCatalogName() {
        return this.sourceCatalogName;
    }

    public void setSourceCatalogName(String sourceCatalogName) {
        this.sourceCatalogName = sourceCatalogName;
    }

    public long getTriggerRowHash() {
        return this.triggerRowHash;
    }

    public void setTriggerRowHash(long triggerRowHash) {
        this.triggerRowHash = triggerRowHash;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int toVirtualTriggerHistId() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.columnNames == null ? 0 : this.columnNames.hashCode());
        result = 31 * result + (this.sourceCatalogName == null ? 0 : this.sourceCatalogName.hashCode());
        result = 31 * result + (this.sourceSchemaName == null ? 0 : this.sourceSchemaName.hashCode());
        result = 31 * result + (this.sourceTableName == null ? 0 : this.sourceTableName.hashCode());
        return result;
    }

    public long getTriggerTemplateHash() {
        return this.triggerTemplateHash;
    }

    public void setTriggerTemplateHash(long triggerTemplateHash) {
        this.triggerTemplateHash = triggerTemplateHash;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String[] parseColumnNames(String argColumnNames) {
        if (argColumnNames.indexOf(34) == -1) {
            return argColumnNames.split(",");
        }
        try (CsvReader reader = new CsvReader((Reader)new StringReader(argColumnNames), ',');){
            if (!reader.readRecord()) throw new SymmetricException("Failed to read a record from CsvReader.", new Object[0]);
            String[] stringArray = reader.getValues();
            return stringArray;
        }
        catch (Exception ex) {
            throw new SymmetricException("Failed to parse columns [" + argColumnNames + "]", ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.triggerHistoryId;
        return result;
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof TriggerHistory && ((TriggerHistory)obj).triggerHistoryId == this.triggerHistoryId;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("triggerHistoryId", this.triggerHistoryId).append("triggerId", (Object)this.triggerId).append("sourceCatalogName", (Object)this.sourceCatalogName).append("sourceSchemaName", (Object)this.sourceSchemaName).append("sourceTableName", (Object)this.sourceTableName).append("columnNames", (Object)this.columnNames).append("pkColumnNames", (Object)this.pkColumnNames).append("inactiveTime", (Object)this.inactiveTime).append("createTime", (Object)this.createTime).toString();
    }
}

