/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.extension.IBuiltInExtensionPoint;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.model.ColumnMatchExpression;
import org.jumpmind.symmetric.model.DataMetaData;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.route.AbstractDataRouter;
import org.jumpmind.symmetric.route.IDataRouter;
import org.jumpmind.symmetric.route.SimpleRouterContext;

public class ColumnMatchDataRouter
extends AbstractDataRouter
implements IDataRouter,
IBuiltInExtensionPoint {
    private ISymmetricEngine engine;
    static final String EXPRESSION_KEY = String.format("%s.Expression.", ColumnMatchDataRouter.class.getName());

    public ColumnMatchDataRouter() {
    }

    public ColumnMatchDataRouter(ISymmetricEngine engine) {
        this.engine = engine;
    }

    @Override
    public Set<String> routeToNodes(SimpleRouterContext routingContext, DataMetaData dataMetaData, Set<Node> nodes, boolean initialLoad, boolean initialLoadSelectUsed, TriggerRouter triggerRouter) {
        Set<String> nodeIds = null;
        if (initialLoadSelectUsed && initialLoad) {
            nodeIds = this.toNodeIds(nodes, null);
        } else {
            List<ColumnMatchExpression> expressions = this.getExpressions(dataMetaData.getRouter(), routingContext);
            Map<String, String> columnValues = this.getDataMap(dataMetaData, this.engine.getSymmetricDialect());
            if (columnValues != null) {
                Node identity = this.engine.getNodeService().findIdentity();
                for (ColumnMatchExpression e : expressions) {
                    String column = e.getTokens()[0].trim();
                    String value = e.getTokens()[1];
                    String columnValue = columnValues.get(column);
                    if (value.equalsIgnoreCase(":NODE_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getNodeId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_NODE_ID")) {
                        String sourceNodeId = identity.getNodeId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceNodeId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":EXTERNAL_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getExternalId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_EXTERNAL_ID")) {
                        String sourceExternalId = identity.getExternalId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceExternalId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":NODE_GROUP_ID")) {
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, node.getNodeGroupId(), nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (value.equalsIgnoreCase(":SOURCE_NODE_GROUP_ID")) {
                        String sourceNodeGroupId = identity.getNodeGroupId();
                        for (Node node : nodes) {
                            nodeIds = this.runExpression(e, columnValue, sourceNodeGroupId, nodes, nodeIds, node);
                        }
                        continue;
                    }
                    if (e.hasEquals() && value.equalsIgnoreCase(":REDIRECT_NODE")) {
                        Map<String, String> redirectMap = this.getRedirectMap(routingContext);
                        String string = redirectMap.get(columnValue);
                        if (string == null) continue;
                        nodeIds = this.addNodeId(string, nodeIds, nodes);
                        continue;
                    }
                    String compareValue = value;
                    if (value.equalsIgnoreCase(":EXTERNAL_DATA")) {
                        compareValue = dataMetaData.getData().getExternalData();
                    } else if (value.startsWith(":")) {
                        compareValue = columnValues.get(value.substring(1));
                    } else if (value.equals("NULL")) {
                        compareValue = null;
                    }
                    nodeIds = this.runExpression(e, columnValue, compareValue, nodes, nodeIds, null);
                }
            } else {
                this.log.warn("There were no columns to match for the data_id of {}", (Object)dataMetaData.getData().getDataId());
            }
        }
        if (nodeIds != null) {
            nodeIds.remove(null);
        } else {
            nodeIds = Collections.emptySet();
        }
        return nodeIds;
    }

    protected Set<String> runExpression(ColumnMatchExpression e, String columnValue, String compareValue, Set<Node> nodes, Set<String> nodeIds, Node node) {
        if (e.run(columnValue, compareValue)) {
            nodeIds = node != null ? this.addNodeId(node.getNodeId(), nodeIds, nodes) : this.toNodeIds(nodes, nodeIds);
        }
        return nodeIds;
    }

    protected List<ColumnMatchExpression> getExpressions(Router router, SimpleRouterContext context) {
        String KEY = EXPRESSION_KEY + router.getRouterId();
        List<ColumnMatchExpression> expressions = (List<ColumnMatchExpression>)context.getContextCache().get(KEY);
        if (expressions == null) {
            expressions = ColumnMatchExpression.parse(router.getRouterExpression());
            context.getContextCache().put(KEY, expressions);
        }
        return expressions;
    }

    protected Map<String, String> getRedirectMap(SimpleRouterContext ctx) {
        String CTX_CACHE_KEY = ColumnMatchDataRouter.class.getSimpleName() + "RouterMap";
        Map<String, String> redirectMap = (Map<String, String>)ctx.getContextCache().get(CTX_CACHE_KEY);
        if (redirectMap == null) {
            redirectMap = this.engine.getConfigurationService().getRegistrationRedirectMap();
            ctx.getContextCache().put(CTX_CACHE_KEY, redirectMap);
        }
        return redirectMap;
    }
}

