/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.symmetric.model.Data;
import org.jumpmind.symmetric.route.ChannelRouterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataMemoryCursor
implements ISqlReadCursor<Data> {
    private static final Logger log = LoggerFactory.getLogger(DataMemoryCursor.class);
    public static final Comparator<Data> SORT_BY_TIME = new DataByTimeComparator();
    public static final Comparator<Data> SORT_BY_ID = new DataByIdComparator();
    protected Iterator<Data> iter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataMemoryCursor(ISqlReadCursor<Data> cursor, ChannelRouterContext context, Comparator<Data> comparator) {
        ArrayList<Data> datas = new ArrayList<Data>();
        Data data = null;
        long ts = System.currentTimeMillis();
        try {
            while ((data = (Data)cursor.next()) != null) {
                datas.add(data);
                long totalTimeInMs = System.currentTimeMillis() - ts;
                if (totalTimeInMs <= 60000L) continue;
                log.info("Reading data to route for channel '{}' has been processing for {} seconds. The following stats have been gathered: dataCount={}", new Object[]{context.getChannel().getChannelId(), (System.currentTimeMillis() - context.getCreatedTimeInMs()) / 1000L, datas.size()});
                ts = System.currentTimeMillis();
            }
        }
        finally {
            cursor.close();
        }
        if (comparator != null) {
            log.debug("Sorting in memory with {}", (Object)comparator.getClass().getSimpleName());
            datas.sort(comparator);
        }
        this.iter = datas.iterator();
    }

    public Data next() {
        if (this.iter.hasNext()) {
            return this.iter.next();
        }
        return null;
    }

    public void close() {
        this.iter = null;
    }

    protected static class DataByTimeComparator
    implements Comparator<Data> {
        protected DataByTimeComparator() {
        }

        @Override
        public int compare(Data o1, Data o2) {
            return o1.getCreateTime().compareTo(o2.getCreateTime());
        }
    }

    protected static class DataByIdComparator
    implements Comparator<Data> {
        protected DataByIdComparator() {
        }

        @Override
        public int compare(Data o1, Data o2) {
            return o1.getDataId() > o2.getDataId() ? 1 : -1;
        }
    }
}

