/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.route;

public class FileParsingOptions {
    private static final String ROUTER_EXPRESSION_INCLUDE_TRANSACTION_ID = "INCLUDE_TRANSACTION_ID";
    private static final String ROUTER_EXPRESSION_TAIL_FILE = "TAIL_FILE";
    private static final String ROUTER_EXPRESSION_STANDARDIZE_NAMES = "STANDARDIZE_NAMES";
    private static final String ROUTER_EXPRESSION_OVERWRITE = "OVERWRITE";
    private static final String ROUTER_EXPRESSION_SEND_DDL = "SEND_DDL";
    private boolean overwrite;
    private boolean tailFile = true;
    private boolean standardizeNames;
    private boolean sendDdl;
    private boolean includeTransactionId;

    public String format() {
        return "STANDARDIZE_NAMES=" + this.standardizeNames + ",OVERWRITE=" + this.overwrite + ",TAIL_FILE=" + this.tailFile + ",SEND_DDL=" + this.sendDdl + ",INCLUDE_TRANSACTION_ID=" + this.includeTransactionId;
    }

    public static FileParsingOptions parse(String expression) {
        FileParsingOptions options = new FileParsingOptions();
        if (expression != null) {
            String[] keyValues = expression.split(",");
            for (int i = 0; i < keyValues.length; ++i) {
                String[] keyValue = keyValues[i].split("=");
                if (keyValue.length <= 1) continue;
                if (ROUTER_EXPRESSION_STANDARDIZE_NAMES.equalsIgnoreCase(keyValue[0])) {
                    options.standardizeNames(Boolean.valueOf(keyValue[1]));
                    continue;
                }
                if (ROUTER_EXPRESSION_TAIL_FILE.equalsIgnoreCase(keyValue[0])) {
                    options.tailFile(Boolean.valueOf(keyValue[1]));
                    continue;
                }
                if (ROUTER_EXPRESSION_OVERWRITE.equalsIgnoreCase(keyValue[0])) {
                    options.overwrite(Boolean.valueOf(keyValue[1]));
                    continue;
                }
                if (ROUTER_EXPRESSION_SEND_DDL.equalsIgnoreCase(keyValue[0])) {
                    options.sendDdl(Boolean.valueOf(keyValue[1]));
                    continue;
                }
                if (!ROUTER_EXPRESSION_INCLUDE_TRANSACTION_ID.equalsIgnoreCase(keyValue[0])) continue;
                options.includeTransactionId(Boolean.valueOf(keyValue[1]));
            }
            if (options.isOverwrite() && options.isTailFile()) {
                options.tailFile(false);
            }
        }
        return options;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public FileParsingOptions overwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public boolean isTailFile() {
        return this.tailFile;
    }

    public FileParsingOptions tailFile(boolean tailFile) {
        this.tailFile = tailFile;
        return this;
    }

    public boolean isStandardizeNames() {
        return this.standardizeNames;
    }

    public FileParsingOptions standardizeNames(boolean standardizeNames) {
        this.standardizeNames = standardizeNames;
        return this;
    }

    public boolean isSendDdl() {
        return this.sendDdl;
    }

    public FileParsingOptions sendDdl(boolean sendDdl) {
        this.sendDdl = sendDdl;
        return this;
    }

    public boolean isIncludeTransactionId() {
        return this.includeTransactionId;
    }

    public FileParsingOptions includeTransactionId(boolean includeTransactionId) {
        this.includeTransactionId = includeTransactionId;
        return this;
    }
}

