/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FilterCriterion {
    private String propertyId;
    private List<Object> values;
    private FilterOption option;

    public FilterCriterion(String propertyId, List<Object> values, FilterOption option) {
        this.propertyId = propertyId;
        this.values = values;
        this.option = option;
    }

    public FilterCriterion(String propertyId, Object value, FilterOption option) {
        this.propertyId = propertyId;
        this.values = new ArrayList<Object>(1);
        this.values.add(value);
        this.option = option;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public List<Object> getValues() {
        return this.values;
    }

    public void setValues(List<Object> values) {
        this.values = values;
    }

    public FilterOption getOption() {
        return this.option;
    }

    public void setOption(FilterOption option) {
        this.option = option;
    }

    public String toString() {
        return this.propertyId + " " + this.option.toAbbrev() + " " + String.valueOf(this.values);
    }

    public String toAbbrevString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.propertyId);
        sb.append(" ");
        sb.append(this.option.toAbbrev());
        sb.append(" ");
        if (this.values.toString().length() > 20 && this.values.size() > 1) {
            sb.append("[");
            sb.append(this.values.size());
            sb.append(" values]");
        } else {
            sb.append(StringUtils.abbreviate((String)this.values.toString(), (int)20));
        }
        return sb.toString();
    }

    public static enum FilterOption {
        EQUALS("Equals", "=", "="),
        NOT_EQUALS("Not Equals", "!=", "<>"),
        GREATER("Greater Than", ">", ">"),
        GREATER_EQUAL("Greater Than or Equal", ">=", ">="),
        LESS("Less Than", "<", "<"),
        LESS_EQUAL("Less Than or Equal", "<=", "<="),
        IN_LIST("In List", "in", "in"),
        NOT_IN_LIST("Not In List", "not in", "not in"),
        BETWEEN("Between", "between", "between"),
        CONTAINS("Contains", "contains", "like"),
        NOT_CONTAINS("Not Contains", "not contains", "not like"),
        STARTS_WITH("Starts With", "starts with", "like");

        private String description;
        private String abbrev;
        private String sql;

        private FilterOption(String description, String abbrev, String sql) {
            this.description = description;
            this.abbrev = abbrev;
            this.sql = sql;
        }

        public String toString() {
            return this.description;
        }

        public String toAbbrev() {
            return this.abbrev;
        }

        public String toSql() {
            return this.sql;
        }
    }
}

