/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jumpmind.db.model.Table;
import org.jumpmind.symmetric.cache.TriggerRouterRoutersCache;
import org.jumpmind.symmetric.config.ITriggerCreationListener;
import org.jumpmind.symmetric.io.data.DataEventType;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.Router;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;

public interface ITriggerRouterService {
    public boolean refreshFromDatabase();

    public List<TriggerHistory> getActiveTriggerHistoriesFromCache();

    public List<TriggerHistory> getActiveTriggerHistories();

    public List<TriggerHistory> getActiveTriggerHistories(Trigger var1);

    public List<TriggerHistory> getActiveTriggerHistories(String var1);

    public Map<String, TriggerHistory> getLastErrorTriggerHistories();

    public List<TriggerRouter> getTriggerRouters(boolean var1);

    public List<TriggerRouter> getTriggerRoutersFromDatabase();

    public List<TriggerRouter> buildTriggerRoutersForSymmetricTables(String var1, NodeGroupLink var2, String ... var3);

    public String buildSymmetricTableRouterId(String var1, String var2, String var3);

    public Trigger getTriggerForCurrentNodeById(String var1);

    public TriggerRouter getTriggerRouterForCurrentNode(String var1, String var2, boolean var3);

    public List<TriggerRouter> getTriggerRoutersForTargetNode(String var1);

    public List<TriggerRouter> getTriggerRoutersForSourceAndTargetNodes(String var1, String var2);

    public List<Trigger> getTriggersForCurrentNode(boolean var1);

    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannel(String var1);

    public Map<String, List<TriggerRouter>> getTriggerRoutersByChannelFromDatabase(String var1);

    public Map<String, List<TriggerRouter>> getTriggerRoutersForCurrentNode(boolean var1);

    public Map<String, TriggerRouterRoutersCache> getTriggerRoutersCacheByNodeGroupIdFromDatabase();

    public Map<Integer, TriggerRouter> getTriggerRoutersByTriggerHist(String var1, boolean var2);

    public Map<String, Map<Integer, TriggerRouter>> getTriggerRoutersByTriggerHistFromDatabase();

    public TriggerRouter getTriggerRouterByTriggerHist(String var1, int var2, boolean var3);

    public Router getActiveRouterByIdForCurrentNode(String var1, boolean var2);

    public Router getRouterById(String var1);

    public Router getRouterById(String var1, boolean var2);

    public List<Router> getRouters();

    public List<Router> getRouters(boolean var1);

    public List<Router> getRoutersByGroupLink(NodeGroupLink var1);

    public boolean isRouterBeingUsed(String var1);

    public void deleteRouter(Router var1);

    public void deleteAllRouters();

    public void saveRouter(Router var1);

    public Router saveRouterAsCopy(Router var1);

    public void renameRouter(String var1, Router var2);

    public List<TriggerRouter> getAllTriggerRoutersForCurrentNode(String var1);

    public List<Trigger> getTriggers();

    public List<Trigger> getTriggers(boolean var1);

    public void saveTrigger(Trigger var1);

    public void insertTriggers(Collection<Trigger> var1);

    public void updateTriggers(Collection<Trigger> var1);

    public void saveTriggerAsCopy(String var1, Trigger var2);

    public void renameTrigger(String var1, Trigger var2);

    public void deleteTrigger(Trigger var1);

    public void deleteTriggers(Collection<Trigger> var1);

    public void deleteAllTriggers();

    public void dropTriggers();

    public void dropTriggers(boolean var1);

    public void dropTriggers(Set<String> var1);

    public void createTriggersOnChannelForTables(String var1, String var2, String var3, List<String> var4, String var5);

    public boolean isTriggerBeingUsed(String var1);

    public boolean doesTriggerExist(String var1);

    public boolean doesTriggerExistForTable(String var1);

    public List<TriggerRouter> getAllTriggerRoutersForReloadForCurrentNode(String var1, String var2);

    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(NodeGroupLink var1, String var2, String var3, String var4, boolean var5);

    public Set<TriggerRouter> getTriggerRouterForTableForCurrentNode(String var1, String var2, String var3, boolean var4);

    public TriggerRouter findTriggerRouterById(String var1, String var2);

    public TriggerRouter findTriggerRouterById(String var1, String var2, boolean var3);

    public List<TriggerRouter> findTriggerRoutersByTriggerId(String var1, boolean var2);

    public List<TriggerRouter> findTriggerRoutersByRouterId(String var1, boolean var2);

    public void inactivateTriggerHistory(TriggerHistory var1);

    public TriggerHistory getNewestTriggerHistoryForTrigger(List<TriggerHistory> var1, String var2, String var3, String var4, String var5);

    public TriggerHistory getNewestTriggerHistoryForTrigger(String var1, String var2, String var3, String var4);

    public TriggerHistory getTriggerHistory(int var1);

    public List<TriggerHistory> findTriggerHistories(String var1, String var2, String var3);

    public TriggerHistory findTriggerHistory(String var1, String var2, String var3);

    public Trigger getTriggerById(String var1);

    public Trigger getTriggerById(String var1, boolean var2);

    public String getTriggerName(DataEventType var1, int var2, Trigger var3, Table var4, List<TriggerHistory> var5, TriggerHistory var6, List<String> var7);

    public void insert(TriggerHistory var1);

    public Map<Long, TriggerHistory> getHistoryRecords();

    public void deleteTriggerRouter(TriggerRouter var1);

    public void deleteTriggerRouter(String var1, String var2);

    public void deleteTriggerRouters(Collection<TriggerRouter> var1);

    public void deleteAllTriggerRouters();

    public void saveTriggerRouter(TriggerRouter var1, boolean var2);

    public void saveTriggerRouter(TriggerRouter var1);

    public void renameTriggerRouter(String var1, String var2, TriggerRouter var3);

    public void insertTriggerRouters(Collection<TriggerRouter> var1);

    public void insertTriggersAndTriggerRouters(Collection<Trigger> var1, Collection<TriggerRouter> var2);

    public void updateTriggerRouters(Collection<TriggerRouter> var1);

    public void syncTrigger(Trigger var1, ITriggerCreationListener var2, boolean var3);

    public void syncTrigger(Trigger var1, ITriggerCreationListener var2, boolean var3, boolean var4);

    public boolean syncTriggers(List<Trigger> var1, ITriggerCreationListener var2, boolean var3, boolean var4);

    public boolean syncTriggers(Table var1, boolean var2);

    public boolean syncTriggers(List<Table> var1, boolean var2);

    public boolean syncTriggers(String var1, boolean var2);

    public void dropTriggers(TriggerHistory var1);

    public boolean syncTriggers(boolean var1);

    public boolean syncTriggers();

    public boolean syncTriggers(StringBuilder var1, boolean var2);

    public Map<Trigger, Exception> getFailedTriggers();

    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistIdAndSortHist(String var1, String var2, String var3, List<TriggerHistory> var4, List<TriggerRouter> var5, boolean var6);

    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistIdAndSortHist(String var1, String var2, String var3, List<TriggerHistory> var4, boolean var5);

    public Map<Integer, List<TriggerRouter>> fillTriggerRoutersByHistId(String var1, String var2, String var3, List<TriggerHistory> var4);

    public TriggerHistory findTriggerHistoryForGenericSync();

    public void clearCache();

    public Collection<Trigger> findMatchingTriggers(List<Trigger> var1, String var2, String var3, String var4);

    public List<Table> getTablesFor(List<TriggerHistory> var1);

    public List<Table> getSortedTablesFor(List<TriggerHistory> var1);

    public List<Trigger> buildTriggersForSymmetricTables(String var1, String ... var2);
}

