/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.time.DateUtils;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.common.TableConstants;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.NodeHost;
import org.jumpmind.symmetric.service.IClusterInstanceGenerator;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.ClusterServiceSqlMap;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterService
extends AbstractService
implements IClusterService {
    protected static final String[] actions = new String[]{"Routing", "Pull", "Push", "Heartbeat", "Purge Incoming", "Purge Outgoing", "Purge Statistics", "SyncTriggers", "Purge Data Gaps", "Stage Management", "Watchdog", "Stat Flush", "File Sync Pull", "File Sync Push", "File Sync Tracker", "Initial Load Extract", "Initial Load Queue", "Offline Push", "Offline Pull", "Monitor", "Sync Config", "Log Miner", "Compare", "Data Refresh"};
    protected static final String[] sharedActions = new String[]{"FILE_SYNC_SHARED"};
    protected static boolean isUpgradedInstanceId;
    protected static final Logger log;
    protected String serverId = null;
    protected static String instanceId;
    protected INodeService nodeService;
    protected IExtensionService extensionService;
    protected Map<String, Lock> lockCache = new ConcurrentHashMap<String, Lock>();

    public ClusterService(IParameterService parameterService, ISymmetricDialect dialect, INodeService nodeService, IExtensionService extensionService) {
        super(parameterService, dialect);
        this.nodeService = nodeService;
        this.extensionService = extensionService;
        this.setSqlMap(new ClusterServiceSqlMap(this.symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
        this.initCache();
    }

    @Override
    public void init() {
        if (this.parameterService.is("cluster.lock.enabled") && !this.isClusteringEnabled()) {
            log.warn("Cluster lock is only available in SymmetricDS Pro.  Remove {} from engine properties.", (Object)"cluster.lock.enabled");
        }
        this.initInstanceId();
        if (isUpgradedInstanceId) {
            String nodeHostTableName = TableConstants.getTableName(this.tablePrefix, "node_host");
            String nodeId = this.nodeService.findIdentityNodeId();
            log.info("Deleting the {} row(s) for node '{}' because the instance ID has changed", (Object)nodeHostTableName, (Object)nodeId);
            this.nodeService.deleteNodeHost(nodeId);
        }
        this.checkSymDbOwnership();
        for (Lock lock : this.lockCache.values()) {
            lock.setLastLockingServerId(lock.getLockingServerId());
            lock.setLockingServerId(null);
            lock.setLastLockTime(lock.getLockTime());
            lock.setLockTime(null);
            lock.setSharedCount(0);
            lock.setSharedEnable(false);
        }
    }

    @Override
    public void refreshLockEntries() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initInstanceId() {
        if (instanceId != null) return;
        Class<ClusterService> clazz = ClusterService.class;
        synchronized (ClusterService.class) {
            IClusterInstanceGenerator generator = null;
            if (this.extensionService != null) {
                generator = this.extensionService.getExtensionPoint(IClusterInstanceGenerator.class);
            }
            ClusterService.initInstanceId(generator);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String initInstanceId(IClusterInstanceGenerator generator) {
        boolean isInstanceIdBlank;
        if (instanceId != null) {
            return instanceId;
        }
        File defaultFile = new File(AppUtils.getSymHome() + "/conf/instance.uuid");
        File instanceIdFile = null;
        URL instanceIdURL = null;
        if ("true".equals(System.getProperty("symmetric.launcher"))) {
            instanceIdFile = defaultFile;
        } else {
            instanceIdURL = ClusterService.class.getClassLoader().getResource("/instance.uuid");
        }
        if (instanceIdFile != null) {
            try {
                instanceId = IOUtils.toString((InputStream)new FileInputStream(instanceIdFile), (Charset)Charset.defaultCharset()).trim();
            }
            catch (Exception ex) {
                log.debug("Failed to load instance id from file '" + String.valueOf(instanceIdFile) + "'", (Throwable)ex);
            }
        } else if (instanceIdURL != null) {
            try {
                instanceId = IOUtils.toString((InputStream)instanceIdURL.openStream(), (Charset)Charset.defaultCharset()).trim();
            }
            catch (Exception ex) {
                log.debug("Failed to load instance id from classpath '" + String.valueOf(instanceIdURL) + "'", (Throwable)ex);
            }
        }
        if ((isInstanceIdBlank = StringUtils.isBlank((CharSequence)instanceId)) || generator != null && !generator.isValid(instanceId)) {
            String newInstanceId = null;
            if (generator != null) {
                newInstanceId = generator.generateInstanceId();
            }
            if (newInstanceId == null) {
                newInstanceId = ClusterService.generateInstanceId(AppUtils.getHostName());
            }
            if (isInstanceIdBlank) {
                log.info("Generated a new instance ID ({}) because the current instance ID is missing or blank", (Object)newInstanceId);
            } else {
                log.info("Generated a new instance ID ({}) because the current instance ID ({}) is invalid", (Object)newInstanceId, (Object)instanceId);
            }
            instanceId = newInstanceId;
            isUpgradedInstanceId = true;
            if (instanceIdFile != null) {
                try {
                    instanceIdFile.getParentFile().mkdirs();
                    IOUtils.write((String)newInstanceId, (OutputStream)new FileOutputStream(instanceIdFile), (Charset)Charset.defaultCharset());
                }
                catch (Exception ex) {
                    throw new SymmetricException("Failed to save file '" + String.valueOf(instanceIdFile) + "' Please correct and restart this node.", ex);
                }
            }
        }
        return instanceId;
    }

    protected void checkSymDbOwnership() {
        List<NodeHost> nodeHosts = this.nodeService.findNodeHosts(this.nodeService.findIdentityNodeId());
        for (NodeHost nodeHost : nodeHosts) {
            if (nodeHost.getInstanceId() == null || Strings.CS.equals(instanceId, nodeHost.getInstanceId())) continue;
            String msg = String.format("*** Node '%s' failed to claim exclusive ownership of the SymmetricDS database. *** This is instance id '%s' but instance id '%s' is already present in sym_node_host.  This is caused when 2 copies of SymmetricDS are pointed at the same database, but not clustered.  If you are configuring a cluster, set cluster.lock.enabled=true and restart.  If you moved your installation or re-installed, run 'delete from sym_node_host where node_id = '%s' and restart SymmetricDS.", this.nodeService.findIdentityNodeId(), instanceId, nodeHost.getInstanceId(), this.nodeService.findIdentityNodeId());
            throw new SymmetricException(msg, new Object[0]);
        }
    }

    @Override
    public String getInstanceId() {
        return instanceId;
    }

    @Override
    public synchronized void persistToTableForSnapshot() {
        this.sqlTemplate.update(this.getSql("deleteSql"), new Object[0]);
        Collection<Lock> values = this.lockCache.values();
        for (Lock lock : values) {
            this.insertLock(lock);
        }
    }

    protected void insertLock(Lock lock) {
        this.sqlTemplate.update(this.getSql("insertCompleteLockSql"), new Object[]{lock.getLockAction(), lock.getLockType(), lock.getLockingServerId(), lock.getLockTime(), lock.getSharedCount(), lock.isSharedEnable() ? 1 : 0, lock.getLastLockTime(), lock.getLastLockingServerId()});
    }

    protected final void initCache() {
        Lock lock;
        this.lockCache.clear();
        for (String action : actions) {
            lock = new Lock();
            lock.setLockAction(action);
            lock.setLockType("CLUSTER");
            this.lockCache.put(action, lock);
        }
        for (String action : sharedActions) {
            lock = new Lock();
            lock.setLockAction(action);
            lock.setLockType("SHARED");
            this.lockCache.put(action, lock);
        }
    }

    @Override
    public synchronized void addLock(String action, String lockType) {
        Lock lock = new Lock();
        lock.setLockAction(action);
        lock.setLockType(lockType);
        this.lockCache.put(action, lock);
    }

    @Override
    public synchronized void removeLock(String action) {
        this.lockCache.remove(action);
    }

    @Override
    public void clearAllLocks() {
        this.initCache();
    }

    @Override
    public boolean lock(String action, String lockType) {
        if (lockType.equals("CLUSTER")) {
            return this.lock(action);
        }
        if (lockType.equals("SHARED")) {
            return this.lockShared(action);
        }
        if (lockType.equals("EXCLUSIVE")) {
            return this.lockExclusive(action);
        }
        throw new UnsupportedOperationException("Lock type of " + lockType + " is not supported");
    }

    @Override
    public boolean lock(String action, String lockType, long waitMillis) {
        if (lockType.equals("SHARED") || lockType.equals("EXCLUSIVE")) {
            return this.lockWait(action, lockType, waitMillis);
        }
        throw new UnsupportedOperationException("Lock type of " + lockType + " is not supported");
    }

    @Override
    public boolean lock(String action) {
        Date timeout = DateUtils.addMilliseconds((Date)new Date(), (int)((int)(-this.parameterService.getLong("cluster.lock.timeout.ms"))));
        return this.lockCluster(action, timeout, new Date(), this.getServerId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockCluster(String action, Date timeToBreakLock, Date timeLockAcquired, String argServerId) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (lock.getLockType().equals("CLUSTER") && (lock.getLockTime() == null || lock.getLockTime().before(timeToBreakLock) || argServerId.equals(lock.getLockingServerId()))) {
                    lock.setLockingServerId(argServerId);
                    lock.setLockTime(timeLockAcquired);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheLockTime(String action, Date timeLockAcquired) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                lock.setLockTime(timeLockAcquired);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockShared(String action) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                Date timeout = DateUtils.addMilliseconds((Date)new Date(), (int)((int)(-this.parameterService.getLong("lock.timeout.ms"))));
                if ((lock.getLockType().equals("SHARED") || lock.getLockTime() == null || lock.getLockTime().before(timeout)) && (lock.isSharedEnable() || lock.getSharedCount() == 0)) {
                    lock.setLockType("SHARED");
                    lock.setLockingServerId(this.getServerId());
                    lock.setLockTime(new Date());
                    if (lock.getSharedCount() == 0) {
                        lock.setSharedEnable(true);
                    }
                    lock.setSharedCount(lock.getSharedCount() + 1);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean lockExclusive(String action) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                Date timeout = DateUtils.addMilliseconds((Date)new Date(), (int)((int)(-this.parameterService.getLong("lock.timeout.ms"))));
                if (lock.getLockType().equals("SHARED") && lock.getSharedCount() == 0 || lock.getLockTime() == null || lock.getLockTime().before(timeout)) {
                    lock.setLockType("EXCLUSIVE");
                    lock.setLockingServerId(this.getServerId());
                    lock.setLockTime(new Date());
                    lock.setSharedCount(0);
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean lockWait(String action, String lockType, long waitMillis) {
        boolean isLocked = false;
        long endTime = System.currentTimeMillis() + waitMillis;
        long sleepMillis = this.parameterService.getLong("lock.wait.retry.ms");
        do {
            if (lockType.equals("SHARED")) {
                isLocked = this.lockShared(action);
            } else if (lockType.equals("EXCLUSIVE") && !(isLocked = this.lockExclusive(action))) {
                this.disableSharedLock(action);
            }
            if (isLocked) break;
            AppUtils.sleep((long)sleepMillis);
        } while (waitMillis == 0L || System.currentTimeMillis() < endTime);
        return isLocked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void disableSharedLock(String action) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                lock.setSharedEnable(false);
            }
        }
    }

    @Override
    public Map<String, Lock> findLocks() {
        return this.lockCache;
    }

    protected static String generateInstanceId(String hostName) {
        int MAX_HOST_LENGTH = 23;
        StringBuilder buff = new StringBuilder();
        buff.append(hostName);
        if (buff.length() > 23) {
            buff.setLength(23);
        }
        buff.append("-");
        buff.append(UUID.randomUUID().toString());
        return buff.toString();
    }

    @Override
    public String getServerId() {
        if (StringUtils.isBlank((CharSequence)this.serverId)) {
            this.serverId = this.parameterService.getString("cluster.server.id");
            if (StringUtils.isBlank((CharSequence)this.serverId)) {
                this.serverId = System.getProperty("runtime.symmetric.cluster.server.id", null);
            }
            if (StringUtils.isBlank((CharSequence)this.serverId)) {
                this.serverId = System.getProperty("bind.address", null);
            }
            if (StringUtils.isBlank((CharSequence)this.serverId)) {
                this.serverId = System.getProperty("jboss.bind.address", null);
            }
            if (StringUtils.isBlank((CharSequence)this.serverId)) {
                try {
                    this.serverId = AppUtils.getHostName();
                }
                catch (Exception ex) {
                    this.serverId = "unknown";
                }
            }
            this.serverId = StringUtils.left((String)this.serverId, (int)255);
            log.info("This node picked a server id of {}", (Object)this.serverId);
        }
        return this.serverId;
    }

    @Override
    public void unlock(String action, String lockType) {
        if (lockType.equals("CLUSTER")) {
            this.unlock(action);
        } else if (lockType.equals("SHARED")) {
            this.unlockShared(action);
        } else if (lockType.equals("EXCLUSIVE")) {
            this.unlockExclusive(action);
        } else {
            throw new UnsupportedOperationException("Lock type of " + lockType + " is not supported");
        }
    }

    @Override
    public void unlock(String action) {
        if (!this.unlockCluster(action, this.getServerId())) {
            log.warn("Failed to release lock for action:{} server:{}", (Object)action, (Object)this.getServerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unlockCluster(String action, String argServerId) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (lock.getLockType().equals("CLUSTER") && argServerId.equals(lock.getLockingServerId())) {
                    lock.setLastLockingServerId(lock.getLockingServerId());
                    lock.setLockingServerId(null);
                    lock.setLastLockTime(lock.getLockTime());
                    lock.setLockTime(null);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unlockShared(String action) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (lock.getLockType().equals("SHARED")) {
                    lock.setLastLockTime(lock.getLockTime());
                    lock.setLastLockingServerId(lock.getLockingServerId());
                    if (lock.getSharedCount() == 1) {
                        lock.setSharedEnable(false);
                        lock.setLockingServerId(null);
                        lock.setLockTime(null);
                    }
                    if (lock.getSharedCount() > 1) {
                        lock.setSharedCount(lock.getSharedCount() - 1);
                    } else {
                        lock.setSharedCount(0);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean unlockExclusive(String action) {
        Lock lock = this.lockCache.get(action);
        if (lock != null) {
            Lock lock2 = lock;
            synchronized (lock2) {
                if (lock.getLockType().equals("EXCLUSIVE")) {
                    lock.setLastLockingServerId(lock.getLockingServerId());
                    lock.setLockingServerId(null);
                    lock.setLastLockTime(lock.getLockTime());
                    lock.setLockTime(null);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isLocked(String action) {
        Map<String, Lock> locks = this.findLocks();
        Lock lock = locks.get(action);
        return lock != null && lock.getLockTime() != null;
    }

    @Override
    public boolean isInfiniteLocked(String action) {
        Map<String, Lock> locks = this.findLocks();
        Lock lock = locks.get(action);
        return lock != null && lock.getLockTime() != null && new Date().before(lock.getLockTime()) && "STOPPED".equals(lock.getLockingServerId());
    }

    @Override
    public void aquireInfiniteLock(String action) {
    }

    @Override
    public void clearInfiniteLock(String action) {
        Map<String, Lock> all = this.findLocks();
        Lock lock = all.get(action);
        if (lock != null && "STOPPED".equals(lock.getLockingServerId()) && lock.getLockType().equals("CLUSTER") && "STOPPED".equals(lock.getLockingServerId())) {
            lock.setLastLockingServerId(null);
            lock.setLockingServerId(null);
            lock.setLastLockTime(null);
            lock.setLockTime(null);
        }
    }

    @Override
    public boolean refreshLock(String action) {
        return true;
    }

    @Override
    public boolean isClusteringEnabled() {
        return false;
    }

    static {
        log = LoggerFactory.getLogger(ClusterService.class);
        instanceId = null;
    }
}

