/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.SymmetricException;
import org.jumpmind.symmetric.load.IReloadGenerator;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.Lock;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.model.NodeSecurity;
import org.jumpmind.symmetric.model.ProcessInfo;
import org.jumpmind.symmetric.model.ProcessInfoKey;
import org.jumpmind.symmetric.model.ProcessType;
import org.jumpmind.symmetric.model.TableReloadRequest;
import org.jumpmind.symmetric.model.TableReloadStatus;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IInitialLoadService;
import org.jumpmind.symmetric.service.INodeService;
import org.jumpmind.symmetric.service.IOutgoingBatchService;
import org.jumpmind.symmetric.service.ITriggerRouterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitialLoadService
extends AbstractService
implements IInitialLoadService {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected ISymmetricEngine engine;
    protected IExtensionService extensionService;
    protected boolean syncTriggersBeforeInitialLoadAttempted = false;
    protected int lastLoadCountToProcess;

    public InitialLoadService(ISymmetricEngine engine) {
        super(engine.getParameterService(), engine.getSymmetricDialect());
        this.engine = engine;
        this.extensionService = engine.getExtensionService();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void queueLoads(boolean force) {
        Node identity = this.engine.getNodeService().findIdentity();
        if (identity != null && identity.isSyncEnabled() && (force || this.engine.getClusterService().lock("Initial Load Queue"))) {
            ProcessInfo processInfo = null;
            try {
                processInfo = this.engine.getStatisticManager().newProcessInfo(new ProcessInfoKey(identity.getNodeId(), null, ProcessType.INSERT_LOAD_EVENTS));
                processInfo.setStatus(ProcessInfo.ProcessStatus.PROCESSING);
                this.processInitialLoadEnabledFlag(identity, processInfo);
                this.processTableRequestLoads(identity, processInfo);
                processInfo.setStatus(ProcessInfo.ProcessStatus.OK);
            }
            catch (Exception e) {
                if (processInfo != null) {
                    processInfo.setStatus(ProcessInfo.ProcessStatus.ERROR);
                }
                this.log.error("Error while queuing initial loads", (Throwable)e);
            }
            finally {
                if (!force) {
                    this.engine.getClusterService().unlock("Initial Load Queue");
                }
            }
        }
    }

    @Override
    public void cancelLoad(TableReloadStatus status) {
        Node identity = this.engine.getNodeService().findIdentity();
        boolean isSourceNode = identity != null && identity.getNodeId().equals(status.getSourceNodeId());
        this.log.info("Cancelling {} load {} {} node {}", new Object[]{isSourceNode ? "outgoing" : "incoming", status.getLoadId(), isSourceNode ? "for" : "from", isSourceNode ? status.getTargetNodeId() : status.getSourceNodeId()});
        List<ProcessInfo> infos = this.engine.getStatisticManager().getProcessInfos();
        ArrayList<ProcessInfo> infosToWaitFor = new ArrayList<ProcessInfo>();
        for (ProcessInfo info : infos) {
            if (info.getCurrentLoadId() != (long)status.getLoadId()) continue;
            this.log.info("Sending interrupt to " + String.valueOf(info.getKey()) + ",batchId=" + info.getCurrentBatchId());
            info.getThread().interrupt();
            infosToWaitFor.add(info);
        }
        if (infosToWaitFor.size() > 0) {
            for (int i = 0; i < 10; ++i) {
                AppUtils.sleep((long)500L);
                ListIterator iterator = infosToWaitFor.listIterator();
                while (iterator.hasNext()) {
                    ProcessInfo p = (ProcessInfo)iterator.next();
                    if (p.getEndTime() != null) {
                        iterator.remove();
                        continue;
                    }
                    this.log.info("Still waiting for process {}, load {} to finish", (Object)p.getKey(), (Object)p.getCurrentLoadId());
                }
                if (infosToWaitFor.size() == 0) break;
            }
        }
        if (isSourceNode) {
            IOutgoingBatchService outgoingBatchService = this.engine.getOutgoingBatchService();
            int count = this.engine.getDataService().updateTableReloadRequestsCancelled(status.getLoadId(), status.getSourceNodeId());
            this.log.info("Marked {} load requests as OK for node {}", (Object)count, (Object)status.getTargetNodeId());
            count = this.engine.getDataExtractorService().cancelExtractRequests(status.getLoadId());
            this.log.info("Marked {} extract requests as OK for node {}", (Object)count, (Object)status.getTargetNodeId());
            count = outgoingBatchService.cancelLoadBatches(status.getLoadId());
            this.log.info("Marked {} batches as OK or IG for node {}", (Object)count, (Object)status.getTargetNodeId());
            this.engine.getDataExtractorService().releaseMissedExtractRequests();
            if (status.isFullLoad()) {
                this.engine.getNodeService().setInitialLoadEnded(null, status.getTargetNodeId());
            } else {
                this.engine.getNodeService().setPartialLoadEnded(null, status.getTargetNodeId());
            }
        } else {
            this.engine.getDataService().updateTableReloadRequestsCancelled(status.getLoadId(), status.getSourceNodeId());
        }
    }

    @Override
    public void cancelAllLoadsForTarget(String targetNodeId) {
        int requestCount = 0;
        List<TableReloadRequest> requests = this.engine.getDataService().getTableReloadRequestToProcessByTarget(targetNodeId);
        for (TableReloadRequest request : requests) {
            if (!StringUtils.isBlank((CharSequence)request.getReloadSelect())) continue;
            this.engine.getDataService().cancelTableReloadRequest(request);
            ++requestCount;
        }
        if (requestCount > 0) {
            this.log.info("Cancelled {} outstanding load requests for target node {}", (Object)requestCount, (Object)targetNodeId);
        }
        List<TableReloadStatus> statuses = this.engine.getDataService().getTableReloadStatusByTarget(targetNodeId);
        for (TableReloadStatus status : statuses) {
            TableReloadRequest request;
            if (status.isCompleted() || status.isCancelled() || (request = this.engine.getDataService().getTableReloadRequest(status.getLoadId())) == null || !StringUtils.isBlank((CharSequence)request.getReloadSelect())) continue;
            this.cancelLoad(status);
        }
    }

    public void processInitialLoadEnabledFlag(Node identity, ProcessInfo processInfo) {
        try {
            List<NodeSecurity> nodeSecurities = this.findNodesThatAreReadyForInitialLoad();
            if (nodeSecurities != null && nodeSecurities.size() > 0) {
                boolean reverseLoadFirst = this.parameterService.is("initial.load.reverse.first");
                List<TriggerHistory> activeHistories = null;
                IReloadGenerator reloadGenerator = this.extensionService.getExtensionPoint(IReloadGenerator.class);
                if (reloadGenerator == null) {
                    activeHistories = this.engine.getTriggerRouterService().getActiveTriggerHistories();
                }
                for (NodeSecurity security : nodeSecurities) {
                    if (reloadGenerator != null) {
                        Node targetNode = this.engine.getNodeService().findNode(security.getNodeId());
                        activeHistories = reloadGenerator.getActiveTriggerHistories(targetNode);
                    }
                    if (activeHistories.size() > 0) {
                        boolean thisMySecurityRecord = security.getNodeId().equals(identity.getNodeId());
                        boolean reverseLoadEnabled = security.isRevInitialLoadEnabled();
                        boolean initialLoadEnabled = security.isInitialLoadEnabled();
                        boolean registered = security.hasRegistered();
                        if (!thisMySecurityRecord && registered && reverseLoadEnabled && (reverseLoadFirst || !initialLoadEnabled)) {
                            if (!Strings.CS.equals(security.getCreatedAtNodeId(), identity.getNodeId())) continue;
                            if (this.parameterService.is("auto.reload.use.config", false)) {
                                this.sendLoadBasedOnConfig(security, true, processInfo);
                            } else {
                                TableReloadRequest request = new TableReloadRequest();
                                request.setTriggerId("ALL");
                                request.setRouterId("ALL");
                                request.setSourceNodeId(security.getNodeId());
                                request.setTargetNodeId(identity.getNodeId());
                                request.setCreateTable(this.parameterService.is("initial.load.create.first"));
                                request.setDeleteFirst(this.parameterService.is("initial.load.delete.first"));
                                request.setCreateTime(new Date());
                                request.setLastUpdateBy(security.getRevInitialLoadCreateBy());
                                this.log.info("Creating load request from node " + security.getNodeId() + " to node " + identity.getNodeId());
                                this.engine.getDataService().insertTableReloadRequest(request);
                                processInfo.incrementCurrentDataCount();
                            }
                            this.engine.getNodeService().setReverseInitialLoadEnabled(security.getNodeId(), false, true, 0L, "initialLoadService");
                            continue;
                        }
                        if (thisMySecurityRecord || !registered || !initialLoadEnabled || reverseLoadFirst && reverseLoadEnabled || !Strings.CS.equals(security.getCreatedAtNodeId(), identity.getNodeId())) continue;
                        if (this.parameterService.is("auto.reload.use.config", false)) {
                            this.sendLoadBasedOnConfig(security, false, processInfo);
                        } else {
                            TableReloadRequest reloadRequest = new TableReloadRequest();
                            reloadRequest.setTriggerId("ALL");
                            reloadRequest.setRouterId("ALL");
                            reloadRequest.setSourceNodeId(identity.getNodeId());
                            reloadRequest.setTargetNodeId(security.getNodeId());
                            reloadRequest.setCreateTable(this.parameterService.is("initial.load.create.first"));
                            reloadRequest.setDeleteFirst(this.parameterService.is("initial.load.delete.first"));
                            reloadRequest.setCreateTime(new Date());
                            reloadRequest.setLastUpdateBy(security.getInitialLoadCreateBy());
                            this.cancelAllLoadsForTarget(security.getNodeId());
                            this.log.info("Creating load request from node " + identity.getNodeId() + " to node " + security.getNodeId());
                            this.engine.getDataService().insertTableReloadRequest(reloadRequest);
                            processInfo.incrementCurrentDataCount();
                        }
                        this.engine.getNodeService().setInitialLoadEnabled(security.getNodeId(), false, false, 0L, "initialLoadService");
                        continue;
                    }
                    List<NodeGroupLink> links = this.engine.getConfigurationService().getNodeGroupLinksFor(this.parameterService.getNodeGroupId(), false);
                    if (links == null || links.size() == 0) {
                        this.log.warn("Could not queue up a load for {} because a node group link is NOT configured over which a load could be delivered", (Object)security.getNodeId());
                        continue;
                    }
                    this.log.warn("Could not queue up a load for {} because sync triggers has not yet run", (Object)security.getNodeId());
                    if (this.syncTriggersBeforeInitialLoadAttempted) continue;
                    this.syncTriggersBeforeInitialLoadAttempted = true;
                    this.engine.getTriggerRouterService().syncTriggers();
                }
            }
        }
        catch (Exception e) {
            this.log.error("Error while processing initial loads using node security", (Throwable)e);
        }
    }

    protected void sendLoadBasedOnConfig(NodeSecurity security, boolean isReverse, ProcessInfo processInfo) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        List<NodeGroupLink> groupLinks = this.engine.getConfigurationService().getNodeGroupLinks(false);
        Node currentNode = this.engine.getNodeService().findNode(security.getNodeId());
        if (isReverse) {
            nodeGroups = new HashSet<String>();
            for (NodeGroupLink link : groupLinks) {
                if (!link.getSourceNodeGroupId().equals(currentNode.getNodeGroupId())) continue;
                nodeGroups.add(link.getTargetNodeGroupId());
            }
            itr = nodeGroups.iterator();
            while (itr.hasNext()) {
                nodes.addAll(this.engine.getNodeService().findEnabledNodesFromNodeGroup((String)((Object)itr.next())));
            }
        } else {
            nodeGroups = new HashSet();
            for (NodeGroupLink link : groupLinks) {
                if (!link.getTargetNodeGroupId().equals(currentNode.getNodeGroupId())) continue;
                nodeGroups.add(link.getSourceNodeGroupId());
            }
            itr = nodeGroups.iterator();
            while (itr.hasNext()) {
                nodes.addAll(this.engine.getNodeService().findEnabledNodesFromNodeGroup((String)((Object)itr.next())));
            }
        }
        for (Node node : nodes) {
            TableReloadRequest request = new TableReloadRequest();
            request.setTriggerId("ALL");
            request.setRouterId("ALL");
            if (isReverse) {
                request.setSourceNodeId(security.getNodeId());
                request.setTargetNodeId(node.getNodeId());
                this.log.info("Creating config based reverse load request from node " + security.getNodeId() + " to node " + node.getNodeId());
            } else {
                request.setSourceNodeId(node.getNodeId());
                request.setTargetNodeId(security.getNodeId());
                this.log.info("Creating config based load request from node " + node.getNodeId() + " to node " + security.getNodeId());
            }
            request.setCreateTable(this.parameterService.is("initial.load.create.first"));
            request.setDeleteFirst(this.parameterService.is("initial.load.delete.first"));
            request.setCreateTime(new Date());
            this.engine.getDataService().insertTableReloadRequest(request);
            processInfo.incrementCurrentDataCount();
        }
    }

    protected void processTableRequestLoads(Node source, ProcessInfo processInfo) {
        List<TableReloadRequest> loadsToProcess = this.engine.getDataService().getTableReloadRequestToProcess(source.getNodeId());
        if (loadsToProcess.size() > 0) {
            boolean reverse;
            List<TriggerRouter> triggerRouters;
            processInfo.setStatus(ProcessInfo.ProcessStatus.CREATING);
            int maxLoadCount = this.parameterService.getInt("initial.load.extract.thread.per.server.count", 20);
            int activeLoadCount = this.engine.getDataService().getActiveTableReloadStatus().size();
            int loadCountToProcess = loadsToProcess.size();
            if (activeLoadCount >= maxLoadCount) {
                this.logActiveLoadCount(activeLoadCount, loadCountToProcess);
                return;
            }
            boolean useExtractJob = this.parameterService.is("initial.load.use.extract.job.enabled", true);
            if (useExtractJob) {
                Map<String, Channel> channels = this.engine.getConfigurationService().getChannels(false);
                boolean isError = false;
                for (Channel channel : channels.values()) {
                    if (!channel.isReloadFlag() || channel.getMaxBatchSize() != 1) continue;
                    this.log.error("Max batch size must be greater than 1 for '{}' channel", (Object)channel.getChannelId());
                    isError = true;
                }
                if (isError) {
                    this.log.error("Initial loads are disabled until max batch size is corrected or {} is set to false", (Object)"initial.load.use.extract.job.enabled");
                    return;
                }
            }
            this.log.info("Found {} table reload requests to process.", (Object)loadCountToProcess);
            boolean streamToFile = this.parameterService.is("stream.to.file.enabled", false);
            HashMap requestsSplitByLoad = new HashMap();
            HashMap<String, List<TriggerRouter>> triggerRoutersByNodeGroup = new HashMap<String, List<TriggerRouter>>();
            Map<Integer, ExtractRequest> extractRequests = null;
            IReloadGenerator reloadGenerator = this.extensionService.getExtensionPoint(IReloadGenerator.class);
            for (TableReloadRequest load : loadsToProcess) {
                boolean registered;
                Node targetNode = this.engine.getNodeService().findNode(load.getTargetNodeId(), true);
                NodeSecurity targetNodeSecurity = this.engine.getNodeService().findNodeSecurity(load.getTargetNodeId(), true);
                if (useExtractJob && !streamToFile) {
                    throw new SymmetricException(String.format("Node '%s' can't process load for '%s' because of conflicting parameters: %s=%s and %s=%s", source.getNodeId(), load.getTargetNodeId(), "initial.load.use.extract.job.enabled", useExtractJob, "stream.to.file.enabled", streamToFile), new Object[0]);
                }
                if (!this.isOkayToQueueLoad(targetNodeSecurity)) continue;
                if (load.isFullLoadRequest() && this.isValidLoadTarget(load.getTargetNodeId())) {
                    ArrayList<TableReloadRequest> fullLoad = new ArrayList<TableReloadRequest>();
                    fullLoad.add(load);
                    triggerRouters = this.getTriggerRoutersForNodeGroup(triggerRoutersByNodeGroup, targetNode.getNodeGroupId());
                    reverse = targetNode.getNodeId().equals(source.getCreatedAtNodeId());
                    extractRequests = this.engine.getDataService().insertReloadEvents(targetNode, reverse, fullLoad, processInfo, triggerRouters, extractRequests, reloadGenerator);
                    --loadCountToProcess;
                    if (++activeLoadCount < maxLoadCount) continue;
                    this.logActiveLoadCount(activeLoadCount, loadCountToProcess);
                    return;
                }
                boolean bl = registered = targetNodeSecurity != null && (targetNodeSecurity.hasRegistered() || targetNodeSecurity.getNodeId().equals(targetNodeSecurity.getCreatedAtNodeId()));
                if (registered) {
                    String key = load.getTargetNodeId() + "::" + String.valueOf(load.getCreateTime());
                    if (!requestsSplitByLoad.containsKey(key)) {
                        requestsSplitByLoad.put((CallSite)((Object)key), new ArrayList());
                    }
                    ((List)requestsSplitByLoad.get(key)).add(load);
                    continue;
                }
                this.log.warn("There was a load queued up for '{}', but the node is not registered.  It is being ignored", (Object)load.getTargetNodeId());
            }
            HashMap<String, List<TriggerRouter>> triggerRoutersByTargetNodeGroupId = new HashMap<String, List<TriggerRouter>>();
            for (Map.Entry entry : requestsSplitByLoad.entrySet()) {
                Node targetNode = this.engine.getNodeService().findNode(((String)entry.getKey()).split("::")[0], true);
                if (targetNode == null) {
                    targetNode = this.engine.getNodeService().findNode(((String)entry.getKey()).split("::")[0], false);
                }
                ITriggerRouterService triggerRouterService = this.engine.getTriggerRouterService();
                triggerRouters = (List<TriggerRouter>)triggerRoutersByTargetNodeGroupId.get(targetNode.getNodeGroupId());
                if (triggerRouters == null) {
                    triggerRouters = triggerRouterService.getAllTriggerRoutersForReloadForCurrentNode(this.parameterService.getNodeGroupId(), targetNode.getNodeGroupId());
                    triggerRoutersByTargetNodeGroupId.put(targetNode.getNodeGroupId(), triggerRouters);
                }
                reverse = targetNode.getNodeId().equals(source.getCreatedAtNodeId());
                extractRequests = this.engine.getDataService().insertReloadEvents(targetNode, reverse, (List)entry.getValue(), processInfo, triggerRouters, extractRequests, reloadGenerator);
                --loadCountToProcess;
                if (++activeLoadCount < maxLoadCount) continue;
                this.logActiveLoadCount(activeLoadCount, loadCountToProcess);
                return;
            }
        }
    }

    protected void logActiveLoadCount(int activeLoadCount, int loadCountToProcess) {
        String message = "Max outgoing loads of {} are active, while {} outgoing loads are pending";
        if (loadCountToProcess != this.lastLoadCountToProcess) {
            this.log.warn(message, (Object)activeLoadCount, (Object)loadCountToProcess);
        } else {
            this.log.debug(message, (Object)activeLoadCount, (Object)loadCountToProcess);
        }
        this.lastLoadCountToProcess = loadCountToProcess;
    }

    protected List<TriggerRouter> getTriggerRoutersForNodeGroup(Map<String, List<TriggerRouter>> triggerRoutersByNodeGroup, String nodeGroupId) {
        List<TriggerRouter> list = triggerRoutersByNodeGroup.get(nodeGroupId);
        if (list == null) {
            list = this.engine.getTriggerRouterService().getAllTriggerRoutersForReloadForCurrentNode(this.parameterService.getNodeGroupId(), nodeGroupId);
            triggerRoutersByNodeGroup.put(nodeGroupId, list);
        }
        return list;
    }

    protected List<NodeSecurity> findNodesThatAreReadyForInitialLoad() {
        INodeService nodeService = this.engine.getNodeService();
        String me = nodeService.findIdentityNodeId();
        ArrayList<NodeSecurity> toReturn = new ArrayList<NodeSecurity>();
        List<NodeSecurity> securities = nodeService.findNodeSecurityWithLoadEnabled();
        for (NodeSecurity nodeSecurity : securities) {
            if (!Strings.CS.equals(nodeSecurity.getCreatedAtNodeId(), me) || !nodeSecurity.hasRegistered() || !nodeSecurity.isInitialLoadEnabled() && !nodeSecurity.isRevInitialLoadEnabled() || !this.isOkayToQueueLoad(nodeSecurity)) continue;
            toReturn.add(nodeSecurity);
        }
        return toReturn;
    }

    protected boolean isOkayToQueueLoad(NodeSecurity nodeSecurity) {
        boolean okayToQueueLoad = true;
        if (this.engine.getConfigurationService().isMasterToMaster() && nodeSecurity != null) {
            Lock routingLock = this.engine.getClusterService().findLocks().get("Routing");
            if (routingLock.getLastLockTime() == null || nodeSecurity.getRegistrationTime() != null && routingLock.getLastLockTime().compareTo(nodeSecurity.getRegistrationTime()) <= 0) {
                okayToQueueLoad = false;
                this.log.info("Delaying initial load request for node {} until the last routing run is after {}", (Object)nodeSecurity.getNodeId(), (Object)nodeSecurity.getRegistrationTime());
            } else {
                int count = this.engine.getOutgoingBatchService().countOutgoingBatchesUnsent("system");
                if (count > 0) {
                    okayToQueueLoad = false;
                    this.log.info("Delaying initial load request for node {} until {} system batches are complete", (Object)nodeSecurity.getNodeId(), (Object)count);
                }
            }
        }
        return okayToQueueLoad;
    }

    protected boolean isValidLoadTarget(String targetNodeId) {
        boolean result = false;
        NodeSecurity targetNodeSecurity = this.engine.getNodeService().findNodeSecurity(targetNodeId);
        if (targetNodeSecurity != null) {
            boolean reverseLoadFirst = this.parameterService.is("initial.load.reverse.first");
            boolean registered = targetNodeSecurity.hasRegistered();
            boolean reverseLoadQueued = targetNodeSecurity.isRevInitialLoadEnabled();
            if (!(!registered || reverseLoadFirst && reverseLoadQueued)) {
                result = true;
            } else {
                this.log.info("Unable to process load for target node id " + targetNodeId + " [registered: " + registered + ", reverse load first: " + reverseLoadFirst + ", reverse load queued: " + reverseLoadQueued + "]");
            }
        }
        return result;
    }
}

