/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.Row;
import org.jumpmind.symmetric.ISymmetricEngine;
import org.jumpmind.symmetric.cache.ICacheManager;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.LoadFilter;
import org.jumpmind.symmetric.model.NodeGroupLink;
import org.jumpmind.symmetric.service.IConfigurationService;
import org.jumpmind.symmetric.service.ILoadFilterService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.LoadFilterServiceSqlMap;

public class LoadFilterService
extends AbstractService
implements ILoadFilterService {
    private Date lastUpdateTime;
    private IConfigurationService configurationService;
    private ICacheManager cacheManager;

    public LoadFilterService(ISymmetricEngine engine, ISymmetricDialect symmetricDialect) {
        super(engine.getParameterService(), symmetricDialect);
        this.configurationService = engine.getConfigurationService();
        this.cacheManager = engine.getCacheManager();
        this.setSqlMap(new LoadFilterServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    @Override
    public Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>> findLoadFiltersFor(NodeGroupLink nodeGroupLink, boolean useCache) {
        Map<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> data = this.cacheManager.findLoadFilters(nodeGroupLink, useCache);
        if (data != null) {
            return data.get(nodeGroupLink);
        }
        return null;
    }

    @Override
    public Map<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> findLoadFiltersFromDb() {
        HashMap<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>> data = new HashMap<NodeGroupLink, Map<LoadFilter.LoadFilterType, Map<String, List<LoadFilter>>>>();
        List<LoadFilterNodeGroupLink> loadFilters = this.getLoadFiltersFromDB();
        boolean ignoreCase = this.parameterService.is("db.metadata.ignore.case");
        for (LoadFilterNodeGroupLink loadFilter : loadFilters) {
            String tableName;
            HashMap<String, ArrayList<LoadFilterNodeGroupLink>> loadFiltersByTable;
            NodeGroupLink nodeGroupLink = loadFilter.getNodeGroupLink();
            if (nodeGroupLink == null) continue;
            HashMap loadFiltersByType = (HashMap)data.get(nodeGroupLink);
            if (loadFiltersByType == null) {
                loadFiltersByType = new HashMap();
                data.put(nodeGroupLink, loadFiltersByType);
            }
            if ((loadFiltersByTable = (HashMap<String, ArrayList<LoadFilterNodeGroupLink>>)loadFiltersByType.get((Object)loadFilter.getLoadFilterType())) == null) {
                loadFiltersByTable = new HashMap<String, ArrayList<LoadFilterNodeGroupLink>>();
                loadFiltersByType.put(loadFilter.getLoadFilterType(), loadFiltersByTable);
            }
            if (StringUtils.isBlank((CharSequence)(tableName = loadFilter.getTargetTableName()))) {
                tableName = "*";
            } else if (ignoreCase) {
                tableName = tableName.toUpperCase();
            }
            String schemaName = loadFilter.getTargetSchemaName();
            if (StringUtils.isBlank((CharSequence)schemaName)) {
                schemaName = "*";
            } else if (ignoreCase) {
                schemaName = schemaName.toUpperCase();
            }
            String catalogName = loadFilter.getTargetCatalogName();
            if (StringUtils.isBlank((CharSequence)catalogName)) {
                catalogName = "*";
            } else if (ignoreCase) {
                catalogName = catalogName.toUpperCase();
            }
            String qualifiedName = Table.getFullyQualifiedTableName((String)catalogName, (String)schemaName, (String)tableName);
            ArrayList<LoadFilterNodeGroupLink> loadFiltersForTable = (ArrayList<LoadFilterNodeGroupLink>)loadFiltersByTable.get(qualifiedName);
            if (loadFiltersForTable == null) {
                loadFiltersForTable = new ArrayList<LoadFilterNodeGroupLink>();
                loadFiltersByTable.put(qualifiedName, loadFiltersForTable);
            }
            loadFiltersForTable.add(loadFilter);
        }
        return data;
    }

    private List<LoadFilterNodeGroupLink> getLoadFiltersFromDB() {
        return this.sqlTemplate.query(this.getSql("selectLoadFilterTable", "orderByLoadFilterOrderSql"), (ISqlRowMapper)new LoadFilterMapper(), new Object[0]);
    }

    @Override
    public List<LoadFilterNodeGroupLink> getLoadFilterNodeGroupLinks() {
        return this.getLoadFiltersFromDB();
    }

    @Override
    public void saveLoadFilter(LoadFilterNodeGroupLink loadFilter) {
        loadFilter.setLastUpdateTime(new Date());
        if (this.sqlTemplate.update(this.getSql("updateLoadFilterSql"), new Object[]{loadFilter.getAfterWriteScript(), loadFilter.getBatchCommitScript(), loadFilter.getBatchCompleteScript(), loadFilter.getBatchRollbackScript(), loadFilter.getBeforeWriteScript(), loadFilter.getHandleErrorScript(), loadFilter.getLoadFilterOrder(), loadFilter.getLoadFilterType().name(), loadFilter.getNodeGroupLink().getSourceNodeGroupId(), loadFilter.getNodeGroupLink().getTargetNodeGroupId(), loadFilter.getTargetCatalogName(), loadFilter.getTargetSchemaName(), loadFilter.getTargetTableName(), loadFilter.isFilterOnInsert() ? 1 : 0, loadFilter.isFilterOnUpdate() ? 1 : 0, loadFilter.isFilterOnDelete() ? 1 : 0, loadFilter.isFailOnError() ? 1 : 0, loadFilter.getLastUpdateBy(), loadFilter.getLastUpdateTime(), loadFilter.getLoadFilterId()}) <= 0) {
            this.sqlTemplate.update(this.getSql("insertLoadFilterSql"), new Object[]{loadFilter.getAfterWriteScript(), loadFilter.getBatchCommitScript(), loadFilter.getBatchCompleteScript(), loadFilter.getBatchRollbackScript(), loadFilter.getBeforeWriteScript(), loadFilter.getHandleErrorScript(), loadFilter.getLoadFilterOrder(), loadFilter.getLoadFilterType().name(), loadFilter.getNodeGroupLink().getSourceNodeGroupId(), loadFilter.getNodeGroupLink().getTargetNodeGroupId(), loadFilter.getTargetCatalogName(), loadFilter.getTargetSchemaName(), loadFilter.getTargetTableName(), loadFilter.isFilterOnInsert() ? 1 : 0, loadFilter.isFilterOnUpdate() ? 1 : 0, loadFilter.isFilterOnDelete() ? 1 : 0, loadFilter.isFailOnError() ? 1 : 0, loadFilter.getLastUpdateBy(), loadFilter.getLastUpdateTime(), new Date(), loadFilter.getLoadFilterId()});
        }
        this.clearCache();
    }

    @Override
    public void saveLoadFilterAsCopy(LoadFilterNodeGroupLink loadFilter) {
        String newId = loadFilter.getLoadFilterId();
        List loadFilters = this.sqlTemplate.query(this.getSql("selectLoadFilterTable", "whereLoadFilterIdLikeSql"), (ISqlRowMapper)new LoadFilterMapper(), new Object[]{newId + "%"});
        List ids = loadFilters.stream().map(LoadFilter::getLoadFilterId).collect(Collectors.toList());
        Object suffix = "";
        int i = 2;
        while (ids.contains(newId + (String)suffix)) {
            suffix = "_" + i;
            ++i;
        }
        loadFilter.setLoadFilterId(newId + (String)suffix);
        this.saveLoadFilter(loadFilter);
    }

    @Override
    public void renameLoadFilter(String oldId, LoadFilterNodeGroupLink loadFilter) {
        this.deleteLoadFilter(oldId);
        this.saveLoadFilter(loadFilter);
    }

    @Override
    public void deleteLoadFilter(String loadFilterId) {
        this.sqlTemplate.update(this.getSql("deleteLoadFilterSql"), new Object[]{loadFilterId});
        this.clearCache();
    }

    @Override
    public void deleteAllLoadFilters() {
        this.sqlTemplate.update(this.getSql("deleteAllLoadFiltersSql"), new Object[0]);
        this.clearCache();
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date = (Date)this.sqlTemplate.queryForObject(this.getSql("selectMaxLastUpdateTime"), Date.class, new Object[0]);
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer filter settings were detected");
            }
            this.lastUpdateTime = date;
            this.clearCache();
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        this.cacheManager.flushLoadFilters();
    }

    public static class LoadFilterNodeGroupLink
    extends LoadFilter {
        private static final long serialVersionUID = 1L;
        protected NodeGroupLink nodeGroupLink;

        public void setNodeGroupLink(NodeGroupLink nodeGroupLink) {
            this.nodeGroupLink = nodeGroupLink;
        }

        public NodeGroupLink getNodeGroupLink() {
            return this.nodeGroupLink;
        }
    }

    class LoadFilterMapper
    implements ISqlRowMapper<LoadFilterNodeGroupLink> {
        LoadFilterMapper() {
        }

        public LoadFilterNodeGroupLink mapRow(Row rs) {
            LoadFilterNodeGroupLink loadFilter = new LoadFilterNodeGroupLink();
            loadFilter.setLoadFilterId(rs.getString("load_filter_id"));
            loadFilter.setNodeGroupLink(LoadFilterService.this.configurationService.getNodeGroupLinkFor(rs.getString("source_node_group_id"), rs.getString("target_node_group_id"), false));
            loadFilter.setTargetCatalogName(rs.getString("target_catalog_name"));
            loadFilter.setTargetSchemaName(rs.getString("target_schema_name"));
            loadFilter.setTargetTableName(rs.getString("target_table_name"));
            loadFilter.setFilterOnInsert(rs.getBoolean("filter_on_insert"));
            loadFilter.setFilterOnUpdate(rs.getBoolean("filter_on_update"));
            loadFilter.setFilterOnDelete(rs.getBoolean("filter_on_delete"));
            loadFilter.setBeforeWriteScript(rs.getString("before_write_script"));
            loadFilter.setAfterWriteScript(rs.getString("after_write_script"));
            loadFilter.setBatchCompleteScript(rs.getString("batch_complete_script"));
            loadFilter.setBatchCommitScript(rs.getString("batch_commit_script"));
            loadFilter.setBatchRollbackScript(rs.getString("batch_rollback_script"));
            loadFilter.setHandleErrorScript(rs.getString("handle_error_script"));
            loadFilter.setCreateTime(rs.getDateTime("create_time"));
            loadFilter.setLastUpdateBy(rs.getString("last_update_by"));
            loadFilter.setLastUpdateTime(rs.getDateTime("last_update_time"));
            loadFilter.setLoadFilterOrder(rs.getInt("load_filter_order"));
            loadFilter.setFailOnError(rs.getBoolean("fail_on_error"));
            try {
                loadFilter.setLoadFilterType(LoadFilter.LoadFilterType.valueOf(rs.getString("load_filter_type").toUpperCase()));
            }
            catch (RuntimeException ex) {
                LoadFilterService.this.log.warn("Invalid value provided for load_filter_type of '{}.'  Valid values are: {}", (Object)rs.getString("load_filter_type"), (Object)Arrays.toString((Object[])LoadFilter.LoadFilterType.values()));
                throw ex;
            }
            return loadFilter;
        }
    }
}

