/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.SqlUtils;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.ITypedPropertiesFactory;
import org.jumpmind.symmetric.config.IParameterFilter;
import org.jumpmind.symmetric.config.IParameterSaveFilter;
import org.jumpmind.symmetric.model.DatabaseParameter;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.impl.AbstractParameterService;
import org.jumpmind.symmetric.service.impl.ParameterServiceSqlMap;

public class ParameterService
extends AbstractParameterService
implements IParameterService {
    String tablePrefix;
    private ITypedPropertiesFactory factory;
    private ParameterServiceSqlMap sql;
    private ISqlTemplate sqlTemplate;
    private Date lastUpdateTime;
    private List<DatabaseParameter> offlineParameters;

    public ParameterService(IDatabasePlatform platform, ITypedPropertiesFactory factory, String tablePrefix) {
        this.tablePrefix = SqlUtils.sanitizeTablePrefix((String)tablePrefix);
        this.factory = factory;
        this.sql = new ParameterServiceSqlMap(platform, tablePrefix);
        this.sqlTemplate = platform.getSqlTemplate();
    }

    @Override
    public String getTablePrefix() {
        return this.tablePrefix;
    }

    @Override
    public boolean refreshFromDatabase() {
        Date date = (Date)this.sqlTemplate.queryForObject(this.sql.getSql("selectMaxLastUpdateTime"), Date.class, new Object[0]);
        if (date != null && (this.lastUpdateTime == null || this.lastUpdateTime.before(date))) {
            if (this.lastUpdateTime != null) {
                this.log.info("Newer database parameters were detected");
            }
            this.lastUpdateTime = date;
            this.rereadParameters();
            return true;
        }
        return false;
    }

    @Override
    public void saveParameter(String key, Object paramValue, String lastUpdateBy) {
        this.saveParameter("ALL", "ALL", key, paramValue, lastUpdateBy);
    }

    @Override
    public void saveParameter(String externalId, String nodeGroupId, String key, Object paramValue, String lastUpdateBy) {
        int count;
        Object object = paramValue = paramValue != null ? paramValue.toString() : null;
        if (this.extensionService != null) {
            for (IParameterSaveFilter filter : this.extensionService.getExtensionPointList(IParameterSaveFilter.class)) {
                paramValue = filter.filterSaveParameter(key, (String)paramValue);
            }
        }
        if ((count = this.sqlTemplate.update(this.sql.getSql("updateParameterSql"), new Object[]{paramValue, lastUpdateBy, new Date(), externalId, nodeGroupId, key})) <= 0) {
            this.sqlTemplate.update(this.sql.getSql("insertParameterSql"), new Object[]{externalId, nodeGroupId, key, paramValue, lastUpdateBy, new Date(), new Date()});
        }
        this.rereadParameters();
    }

    @Override
    public void deleteParameter(String key) {
        this.sqlTemplate.update(this.sql.getSql("deleteParameterByKeySql"), new Object[]{key});
        this.rereadParameters();
    }

    @Override
    public void deleteParameter(String externalId, String nodeGroupId, String key) {
        this.sqlTemplate.update(this.sql.getSql("deleteParameterSql"), new Object[]{externalId, nodeGroupId, key});
        this.rereadParameters();
    }

    @Override
    public void deleteParameterWithUpdate(String externalId, String nodeGroupId, String key) {
        String oldSql = this.sql.getSql("deleteParameterSql");
        Object newSql = "";
        int j = 0;
        for (int i = 0; i < oldSql.length(); ++i) {
            if (oldSql.charAt(i) == '?') {
                newSql = j == 0 ? (String)newSql + "'" + externalId + "'" : (j == 1 ? (String)newSql + "'" + nodeGroupId + "'" : (String)newSql + "'" + key + "'");
                ++j;
                continue;
            }
            newSql = (String)newSql + oldSql.charAt(i);
        }
        this.sqlTemplate.update((String)newSql, new Object[0]);
    }

    @Override
    public void deleteAllParameters() {
        this.sqlTemplate.update(this.sql.getSql("deleteAllParametersSql"), new Object[0]);
        this.rereadParameters();
    }

    @Override
    public void saveParameters(String externalId, String nodeGroupId, Map<String, Object> parameters, String lastUpdateBy) {
        Set<String> keys = parameters.keySet();
        for (String key : keys) {
            this.saveParameter(externalId, nodeGroupId, key, parameters.get(key), lastUpdateBy);
        }
    }

    protected TypedProperties readParametersFromDatabase(String sqlKey, Object ... values) {
        final TypedProperties properties = new TypedProperties();
        final IParameterFilter filter = this.extensionService != null ? this.extensionService.getExtensionPoint(IParameterFilter.class) : null;
        this.sqlTemplate.query(this.sql.getSql(sqlKey), (ISqlRowMapper)new ISqlRowMapper<Object>(){

            public Object mapRow(Row row) {
                String key = row.getString("param_key");
                String value = row.getString("param_value");
                if (filter != null) {
                    value = filter.filterParameter(key, value);
                }
                if (value != null) {
                    properties.setProperty(key, value);
                }
                return row;
            }
        }, values);
        return properties;
    }

    @Override
    public boolean isRegistrationServer() {
        return StringUtils.isBlank((CharSequence)this.getRegistrationUrl()) || this.getRegistrationUrl().equalsIgnoreCase(this.getSyncUrl());
    }

    @Override
    public boolean isRemoteNodeRegistrationServer(Node remoteNode) {
        return this.getRegistrationUrl().equalsIgnoreCase(remoteNode.getSyncUrl());
    }

    @Override
    protected TypedProperties rereadApplicationParameters() {
        TypedProperties p = this.factory.reload();
        p.putAll(this.systemProperties);
        p.putAll((Properties)this.rereadDatabaseParameters((Properties)p));
        this.rereadOfflineNodeParameters();
        return p;
    }

    protected synchronized void rereadOfflineNodeParameters() {
        if (this.databaseHasBeenInitialized) {
            this.offlineParameters = this.getDatabaseParametersFor("node.offline");
        }
    }

    @Override
    public List<DatabaseParameter> getDatabaseParametersForAll() {
        return this.sqlTemplate.query(this.sql.getSql("selectParametersSql"), (ISqlRowMapper)new DatabaseParameterMapper(), new Object[0]);
    }

    @Override
    public List<DatabaseParameter> getDatabaseParametersFor(String paramKey) {
        return this.sqlTemplate.query(this.sql.getSql("selectParametersByKeySql"), (ISqlRowMapper)new DatabaseParameterMapper(), new Object[]{paramKey});
    }

    @Override
    public TypedProperties getDatabaseParameters(String externalId, String nodeGroupId) {
        return this.readParametersFromDatabase("selectParametersByNodeGroupAndExternalIdSql", externalId, nodeGroupId);
    }

    @Override
    public List<DatabaseParameter> getOfflineNodeParameters() {
        if (this.offlineParameters == null) {
            this.rereadOfflineNodeParameters();
        }
        return this.offlineParameters;
    }

    public int hashParameterValues(String[] parameterNames) {
        if (parameterNames == null || parameterNames.length < 1) {
            this.log.debug("No parameters in the list to hash!");
            return 0;
        }
        int combinedHash = 0;
        for (String paramName : parameterNames) {
            if (paramName == null || paramName.length() < 1) {
                this.log.debug("Ignoring blank parameter name!");
                continue;
            }
            combinedHash ^= paramName.hashCode();
            String paramValue = this.getString(paramName, "");
            if (paramValue == null || paramValue.length() < 1) {
                this.log.debug("Ignoring empty value for parameter={}", (Object)paramName);
                continue;
            }
            combinedHash ^= paramValue.hashCode();
            this.log.debug("Hashing parameter {}={}", (Object)paramName, (Object)paramValue);
        }
        this.log.debug("Combined hash of {} parameters={}", (Object)parameterNames.length, (Object)combinedHash);
        return combinedHash;
    }

    class DatabaseParameterMapper
    implements ISqlRowMapper<DatabaseParameter> {
        IParameterFilter filter;

        DatabaseParameterMapper() {
            this.filter = ParameterService.this.extensionService != null ? ParameterService.this.extensionService.getExtensionPoint(IParameterFilter.class) : null;
        }

        public DatabaseParameter mapRow(Row row) {
            String key = row.getString("param_key");
            String value = row.getString("param_value");
            if (this.filter != null) {
                value = this.filter.filterParameter(key, value);
            }
            return new DatabaseParameter(key, value, row.getString("external_id"), row.getString("node_group_id"));
        }
    }
}

