/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.service.impl;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.LongConsumer;
import org.apache.commons.lang3.time.FastDateFormat;
import org.jumpmind.db.sql.ISqlReadCursor;
import org.jumpmind.db.sql.ISqlRowMapper;
import org.jumpmind.db.sql.ISqlTemplate;
import org.jumpmind.db.sql.Row;
import org.jumpmind.db.sql.mapper.LongMapper;
import org.jumpmind.db.sql.mapper.StringMapper;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.ext.IPurgeListener;
import org.jumpmind.symmetric.model.AbstractBatch;
import org.jumpmind.symmetric.model.DataGap;
import org.jumpmind.symmetric.model.ExtractRequest;
import org.jumpmind.symmetric.model.RegistrationRequest;
import org.jumpmind.symmetric.service.IClusterService;
import org.jumpmind.symmetric.service.IContextService;
import org.jumpmind.symmetric.service.IDataService;
import org.jumpmind.symmetric.service.IExtensionService;
import org.jumpmind.symmetric.service.IParameterService;
import org.jumpmind.symmetric.service.IPurgeService;
import org.jumpmind.symmetric.service.ISequenceService;
import org.jumpmind.symmetric.service.impl.AbstractService;
import org.jumpmind.symmetric.service.impl.PurgeServiceSqlMap;
import org.jumpmind.symmetric.statistic.IStatisticManager;

public class PurgeService
extends AbstractService
implements IPurgeService {
    private IClusterService clusterService;
    private IDataService dataService;
    private ISequenceService sequenceService;
    private IStatisticManager statisticManager;
    private IExtensionService extensionService;
    private IContextService contextService;
    private FastDateFormat fastFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    private final int MINS_IN_ONE_WEEK = 10080;

    public PurgeService(IParameterService parameterService, ISymmetricDialect symmetricDialect, IClusterService clusterService, IDataService dataService, ISequenceService sequenceService, IStatisticManager statisticManager, IExtensionService extensionService, IContextService contextService) {
        super(parameterService, symmetricDialect);
        this.clusterService = clusterService;
        this.dataService = dataService;
        this.sequenceService = sequenceService;
        this.statisticManager = statisticManager;
        this.extensionService = extensionService;
        this.contextService = contextService;
        this.setSqlMap(new PurgeServiceSqlMap(symmetricDialect.getPlatform(), this.createSqlReplacementTokens()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeOutgoing(boolean force) {
        long rowsPurged = 0L;
        long startTime = System.currentTimeMillis();
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
        try {
            if ((rowsPurged += this.purgeOutgoing(retentionCutoff, force)) != -1L) {
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged);
            }
        }
        catch (Exception ex) {
            try {
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged, ex);
                this.log.info("Failed to execute purge, but will try again,", (Throwable)ex);
                if ((rowsPurged += this.purgeOutgoing(retentionCutoff, force)) != -1L) {
                    this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged);
                }
            }
            catch (Exception e) {
                this.log.error("Failed to execute purge, so aborting,", (Throwable)e);
                this.statisticManager.addJobStats("Purge Outgoing", startTime, System.currentTimeMillis(), rowsPurged, e);
            }
        }
        finally {
            this.log.info("The outgoing purge process has completed");
        }
        return rowsPurged;
    }

    @Override
    public long purgeIncoming(boolean force) {
        long rowsPurged = 0L;
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.retention.minutes"));
        return rowsPurged += this.purgeIncoming(retentionCutoff, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeOutgoing(Calendar retentionCutoff, boolean force) {
        long rowsPurged = 0L;
        if (force || this.clusterService.lock("Purge Outgoing")) {
            try {
                this.log.info("The outgoing purge process is about to run for data older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
                List<IPurgeListener> purgeListeners = this.extensionService.getExtensionPointList(IPurgeListener.class);
                for (IPurgeListener purgeListener : purgeListeners) {
                    try {
                        rowsPurged += purgeListener.beforePurgeOutgoing(force);
                    }
                    catch (Throwable e) {
                        this.log.error(e.getMessage(), e);
                    }
                }
                if (this.getSymmetricDialect().getName().equalsIgnoreCase("voltdb")) {
                    rowsPurged += this.purgeOutgoingByRetentionCutoff(retentionCutoff);
                } else {
                    OutgoingContext context = this.buildOutgoingContext(retentionCutoff);
                    rowsPurged += this.purgeStrandedBatches();
                    rowsPurged += this.purgeDataRows(context);
                    rowsPurged += this.purgeOutgoingBatch(context);
                    rowsPurged += this.purgeLingeringBatches(context);
                    rowsPurged += (long)this.purgeDataGapsExpired(context);
                    rowsPurged += this.purgeStranded(context);
                    rowsPurged += this.purgeExtractRequests();
                    rowsPurged += this.purgeStrandedChannels();
                }
                for (IPurgeListener purgeListener : purgeListeners) {
                    try {
                        rowsPurged += purgeListener.purgeOutgoing(force);
                    }
                    catch (Throwable e) {
                        this.log.error(e.getMessage(), e);
                    }
                }
            }
            finally {
                if (!force) {
                    this.clusterService.unlock("Purge Outgoing");
                }
            }
        } else {
            this.log.debug("Could not get a lock to run an outgoing purge");
            rowsPurged = -1L;
        }
        return rowsPurged;
    }

    protected long purgeOutgoingByRetentionCutoff(Calendar retentionCutoff) {
        int totalCount = 0;
        totalCount += this.executePurgeDelete(this.getSql("deleteOutgoingBatchByCreateTimeSql"), retentionCutoff.getTime());
        totalCount += this.executePurgeDelete(this.getSql("deleteDataEventByCreateTimeSql"), retentionCutoff.getTime());
        totalCount += this.executePurgeDelete(this.getSql("deleteDataByCreateTimeSql"), retentionCutoff.getTime());
        this.log.info("Done purging {} rows", (Object)(totalCount += this.executePurgeDelete(this.getSql("deleteExtractRequestByCreateTimeSql"), retentionCutoff.getTime())));
        return totalCount;
    }

    protected int executePurgeDelete(String deleteSql, Object argument) {
        this.log.debug("Running the following statement: {} with the following arguments: {}", (Object)deleteSql, argument);
        int count = this.sqlTemplate.update(deleteSql, new Object[]{argument});
        this.log.debug("Deleted {} rows", (Object)count);
        return count;
    }

    private long purgeOutgoingBatch(OutgoingContext context) {
        long[] batchMinMax = new long[]{context.getMinBatchId(), context.getMaxBatchId()};
        long[] eventMinMax = new long[]{context.getMinEventBatchId(), context.getMaxBatchId()};
        int maxNumOfBatchIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
        int maxNumOfDataEventsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.event.batches.to.delete.in.tx");
        int dataEventsPurgedCount = 0;
        int outgoingbatchPurgedCount = 0;
        if (this.parameterService.is("job.purge.first.pass")) {
            this.log.info("Getting first batch_id for outstanding batches");
            long notOkBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("minOutgoingBatchNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
            long[] batchRangeMinMax = this.getRangeMinMax(batchMinMax, notOkBatchId);
            long[] eventRangeMinMax = this.getRangeMinMax(eventMinMax, notOkBatchId);
            batchMinMax = this.getMinMax(batchMinMax, notOkBatchId, batchRangeMinMax);
            eventMinMax = this.getMinMax(eventMinMax, notOkBatchId, eventRangeMinMax);
            dataEventsPurgedCount += this.purgeByMinMax(eventRangeMinMax, MinMaxDeleteSql.DATA_EVENT_RANGE, context, maxNumOfDataEventsToPurgeInTx, count -> this.statisticManager.incrementPurgedDataEventRows(count));
            outgoingbatchPurgedCount += this.purgeByMinMax(batchRangeMinMax, MinMaxDeleteSql.OUTGOING_BATCH_RANGE, context, maxNumOfBatchIdsToPurgeInTx, count -> this.statisticManager.incrementPurgedBatchOutgoingRows(count));
        }
        return (dataEventsPurgedCount += this.purgeByMinMax(eventMinMax, MinMaxDeleteSql.DATA_EVENT, context, maxNumOfDataEventsToPurgeInTx, count -> this.statisticManager.incrementPurgedDataEventRows(count))) + (outgoingbatchPurgedCount += this.purgeByMinMax(batchMinMax, MinMaxDeleteSql.OUTGOING_BATCH, context, maxNumOfBatchIdsToPurgeInTx, count -> this.statisticManager.incrementPurgedBatchOutgoingRows(count)));
    }

    private long[] getRangeMinMax(long[] minMax, long notOkBatchId) {
        return new long[]{minMax[0], Math.min(notOkBatchId > 0L ? notOkBatchId - 1L : minMax[1], minMax[1])};
    }

    private long[] getMinMax(long[] minMax, long notOkBatchId, long[] rangeMinMax) {
        if (rangeMinMax[1] == minMax[1]) {
            minMax[1] = -1L;
        } else {
            minMax[0] = notOkBatchId;
        }
        return minMax;
    }

    private long purgeLingeringBatches(OutgoingContext context) {
        long totalRowsPurged = 0L;
        long totalBatchesPurged = 0L;
        long ts = System.currentTimeMillis();
        long lastBatchId = context.getMinBatchId();
        long maxRows = this.parameterService.getLong("job.purge.max.lingering.batches.read");
        int idType = this.symmetricDialect.getSqlTypeForIds();
        List<Long> batchIds = this.getLingeringBatchIds(lastBatchId, maxRows);
        while (batchIds.size() > 0) {
            for (Long batchId : batchIds) {
                long dataDeleteCount = 0L;
                long eventDeleteCount = 0L;
                long batchDeleteCount = 0L;
                long countNotOkay = this.sqlTemplateDirty.queryForLong(this.getSql("countCommonBatchNotStatusForBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()});
                if (countNotOkay == 0L) {
                    dataDeleteCount = this.sqlTemplate.update(this.getSql("deleteDataByBatchId"), new Object[]{batchId}, new int[]{idType});
                    this.statisticManager.incrementPurgedDataRows(dataDeleteCount);
                    eventDeleteCount = this.sqlTemplate.update(this.getSql("deleteDataEventByBatchId"), new Object[]{batchId}, new int[]{idType});
                    this.statisticManager.incrementPurgedDataEventRows(eventDeleteCount);
                    batchDeleteCount = this.sqlTemplate.update(this.getSql("deleteOutgoingBatchByBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()}, new int[]{idType, 1});
                    this.statisticManager.incrementPurgedBatchOutgoingRows(batchDeleteCount);
                } else {
                    batchDeleteCount = this.sqlTemplate.update(this.getSql("deleteOutgoingBatchByBatchId"), new Object[]{batchId, AbstractBatch.Status.OK.name()}, new int[]{idType, 1});
                    this.statisticManager.incrementPurgedBatchOutgoingRows(batchDeleteCount);
                }
                totalRowsPurged += dataDeleteCount + eventDeleteCount + batchDeleteCount;
                ++totalBatchesPurged;
                if (System.currentTimeMillis() - ts <= 300000L) continue;
                this.log.info("Purged {} of {} batches and {} rows so far", new Object[]{totalBatchesPurged, batchIds.size(), totalRowsPurged});
                ts = System.currentTimeMillis();
                this.clusterService.refreshLock("Purge Outgoing");
            }
            if ((long)batchIds.size() != maxRows) break;
            batchIds = this.getLingeringBatchIds(lastBatchId, maxRows);
            totalRowsPurged = 0L;
            totalBatchesPurged = 0L;
        }
        this.log.info("Done purging {} lingering batches and {} rows", (Object)totalBatchesPurged, (Object)totalRowsPurged);
        return totalRowsPurged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Long> getLingeringBatchIds(long lastBatchId, long maxRows) {
        ArrayList<Long> batchIds = new ArrayList<Long>();
        if (lastBatchId > 0L) {
            this.log.info("Looking for lingering batches before batch {}", (Object)lastBatchId);
            try (ISqlReadCursor cursor = null;){
                cursor = this.sqlTemplateDirty.queryForCursor(this.getSql("selectLingeringBatches"), (ISqlRowMapper)new LongMapper(), new Object[]{lastBatchId, AbstractBatch.Status.OK.name()}, new int[]{this.symmetricDialect.getSqlTypeForIds(), 1});
                Long batchId = null;
                long count = 0L;
                while (count++ < maxRows && (batchId = (Long)cursor.next()) != null) {
                    batchIds.add(batchId);
                }
            }
            if (batchIds.size() > 0) {
                this.log.info("Found {} lingering batches to purge", (Object)batchIds.size());
            }
        }
        return batchIds;
    }

    private long purgeStrandedBatches() {
        int totalRowsPurged = 0;
        this.log.info("Looking for old nodes in batches");
        List nodes = this.sqlTemplateDirty.query(this.getSql("selectNodesWithStrandedBatches"), (ISqlRowMapper)new StringMapper(), new Object[]{1, AbstractBatch.Status.OK.name()});
        if (nodes.size() > 0) {
            this.log.info("Found {} old nodes in batches", (Object)nodes.size());
            for (String nodeId : nodes) {
                int rowsPurged = this.sqlTemplate.update(this.getSql("updateStrandedBatches"), new Object[]{AbstractBatch.Status.OK.name(), nodeId, AbstractBatch.Status.OK.name()});
                this.log.info("Set the status to {} for {} batches associated with node ID {}", new Object[]{AbstractBatch.Status.OK.name(), rowsPurged, nodeId});
                totalRowsPurged += rowsPurged;
                this.statisticManager.incrementPurgedBatchOutgoingRows(rowsPurged);
            }
        }
        this.log.info("Looking for old channels in batches");
        List channels = this.sqlTemplateDirty.query(this.getSql("selectChannelsWithStrandedBatches"), (ISqlRowMapper)new StringMapper(), new Object[]{AbstractBatch.Status.OK.name()});
        if (channels.size() > 0) {
            this.log.info("Found {} old channels in batches", (Object)channels.size());
            for (String channelId : channels) {
                int rowsPurged = this.sqlTemplate.update(this.getSql("updateStrandedBatchesByChannel"), new Object[]{AbstractBatch.Status.OK.name(), channelId, AbstractBatch.Status.OK.name()});
                this.log.info("Set the status to {} for {} batches associated with channel ID {}", new Object[]{AbstractBatch.Status.OK.name(), rowsPurged, channelId});
                totalRowsPurged += rowsPurged;
                this.statisticManager.incrementPurgedBatchOutgoingRows(rowsPurged);
            }
        }
        return totalRowsPurged;
    }

    private long purgeStrandedChannels() {
        int totalRowsPurged = 0;
        this.log.info("Looking for old channels in data");
        List channels = this.sqlTemplateDirty.query(this.getSql("selectOldChannelsForData"), (ISqlRowMapper)new StringMapper(), new Object[0]);
        if (channels.size() > 0) {
            this.log.info("Found {} old channels in data", (Object)channels.size());
            for (String channelId : channels) {
                this.log.info("Purging data for channel {}", (Object)channelId);
                int rowsPurged = this.sqlTemplate.update(this.getSql("deleteDataByChannel"), new Object[]{channelId});
                totalRowsPurged += rowsPurged;
                this.statisticManager.incrementPurgedDataRows(rowsPurged);
            }
            this.log.info("Done purging {} data rows with old channels", (Object)totalRowsPurged);
        }
        return totalRowsPurged;
    }

    private long purgeDataRows(OutgoingContext context) {
        long[] minMax = new long[]{context.getMinDataId(), context.getMaxDataId()};
        long minGapStartId = context.getMinDataGapStartId();
        int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.to.delete.in.tx");
        long dataDeletedCount = 0L;
        if (this.parameterService.is("job.purge.first.pass")) {
            this.log.info("Getting count of outstanding batches");
            long outstandingCount = this.sqlTemplateDirty.queryForLong(this.getSql("countOutgoingBatchNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
            long maxOutstandingCount = this.parameterService.getLong("job.purge.first.pass.outstanding.batches.threshold");
            if (outstandingCount > 0L) {
                this.log.info("Found " + outstandingCount + " outstanding batches, threshold is " + maxOutstandingCount);
            }
            if (outstandingCount <= maxOutstandingCount) {
                long[] rangeMinMax;
                long minDataId = 0L;
                if (outstandingCount > 0L) {
                    this.log.info("Getting first data_id for outstanding batches");
                    minDataId = this.sqlTemplateDirty.queryForLong(this.getSql("selectDataEventMinNotStatusSql"), new Object[]{AbstractBatch.Status.OK.name()});
                }
                if ((rangeMinMax = new long[]{minMax[0], Math.min(Math.min(minDataId > 0L ? minDataId - 1L : minMax[1], minMax[1]), minGapStartId - 1L)})[1] == minMax[1]) {
                    minMax[1] = -1L;
                } else if (rangeMinMax[1] == minDataId - 1L) {
                    minMax[0] = minDataId;
                } else if (rangeMinMax[1] == minGapStartId - 1L) {
                    minMax[0] = minGapStartId;
                }
                dataDeletedCount += (long)this.purgeByMinMax(rangeMinMax, MinMaxDeleteSql.DATA_RANGE, context, maxNumOfDataIdsToPurgeInTx, count -> this.statisticManager.incrementPurgedDataRows(count));
            }
        }
        return dataDeletedCount += (long)this.purgeByMinMax(minMax, MinMaxDeleteSql.DATA, context, maxNumOfDataIdsToPurgeInTx, count -> this.statisticManager.incrementPurgedDataRows(count));
    }

    private long purgeStranded(OutgoingContext context) {
        this.log.info("Getting range for stranded data events");
        int maxNumOfDataEventsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.event.batches.to.delete.in.tx");
        long minGapStartId = context.getMinDataGapStartId();
        long[] minMaxEvent = this.queryForMinMax(this.sqlTemplateDirty, this.getSql("selectStrandedDataEventRangeSql"), null, null);
        int strandedEventDeletedCount = this.purgeByMinMax(minMaxEvent, MinMaxDeleteSql.STRANDED_DATA_EVENT, context, maxNumOfDataEventsToPurgeInTx, count -> this.statisticManager.incrementPurgedStrandedDataEventRows(count));
        this.log.info("Getting range for stranded data");
        int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.data.to.delete.in.tx");
        long minDataId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataId"), new Object[0]);
        long minDataEventId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataEventId"), new Object[0]);
        long[] minMax = new long[]{minDataId, Math.min(minDataEventId, minGapStartId) - 1L};
        int strandedDeletedCount = this.purgeByMinMax(minMax, MinMaxDeleteSql.STRANDED_DATA, context, maxNumOfDataIdsToPurgeInTx, count -> this.statisticManager.incrementPurgedStrandedDataRows(count));
        return strandedEventDeletedCount + strandedDeletedCount;
    }

    private int purgeDataGapsExpired(OutgoingContext context) {
        int purgedDataRowCount = 0;
        List<DataGap> dataGapsExpired = context.getDataGapsExpired();
        List<DataGap> dataGapsExpiredToCheck = this.getDataGapsExpiredToCheck(context);
        if (dataGapsExpiredToCheck.size() > 0) {
            this.log.info("Looking for data in {} expired gaps", (Object)dataGapsExpiredToCheck.size());
            int purgedDataGapCount = 0;
            int checkedDataGapCount = 0;
            long ts = System.currentTimeMillis();
            int[] argTypes = new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds()};
            for (DataGap gap : dataGapsExpiredToCheck) {
                Object[] args = new Object[]{gap.getStartId(), gap.getEndId()};
                if (this.parameterService.is("job.purge.recapture.stranded.data")) {
                    int recapturedRowCount = this.dataService.reCaptureData(gap.getStartId(), gap.getEndId());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Recaptured {} rows of stranded data for gap {} - {}", new Object[]{recapturedRowCount, gap.getStartId(), gap.getEndId()});
                    }
                } else if (this.log.isDebugEnabled()) {
                    this.log.debug("Skipped recapture of stranded data for gap {} - {}", (Object)gap.getStartId(), (Object)gap.getEndId());
                }
                int count = this.sqlTemplate.update(this.getSql("deleteDataByRangeSql"), args, argTypes);
                purgedDataRowCount += count;
                this.statisticManager.incrementPurgedExpiredDataRows(count);
                ++purgedDataGapCount;
                ++checkedDataGapCount;
                if (System.currentTimeMillis() - ts <= 60000L) continue;
                this.log.info("Checked {} expired data gaps. Deleted {} data rows.", (Object)checkedDataGapCount, (Object)count);
                ts = System.currentTimeMillis();
            }
            if (purgedDataRowCount > 0) {
                this.log.info("Repaired {} data in {} expired data gaps", (Object)purgedDataRowCount, (Object)purgedDataGapCount);
            }
        }
        if (dataGapsExpired.size() > 0) {
            Calendar gapRetentionCutoff = Calendar.getInstance();
            gapRetentionCutoff.add(12, -this.parameterService.getInt("purge.expired.data.gap.retention.minutes"));
            this.log.info("Purging expired data gaps that are older than {}", (Object)this.fastFormat.format(gapRetentionCutoff.getTime()));
            int deletedCount = this.sqlTemplate.update(this.getSql("deleteFromDataGapsSql"), new Object[]{gapRetentionCutoff.getTime(), context.getMaxDataId()});
            if (deletedCount > 0) {
                this.log.info("Purged {} expired data gaps", (Object)deletedCount);
            }
        }
        return purgedDataRowCount;
    }

    private List<DataGap> getDataGapsExpiredToCheck(OutgoingContext context) {
        List<DataGap> dataGapsExpired;
        List<DataGap> dataGapsExpiredToCheck = dataGapsExpired = context.getDataGapsExpired();
        int maxDataGapsExpired = this.parameterService.getInt("job.purge.max.data.gaps.read", 100);
        if (dataGapsExpired.size() > maxDataGapsExpired) {
            this.log.info("Getting range for expired data");
            long[] minMax = this.queryForMinMax(this.sqlTemplate, this.getSql("selectExpiredDataRangeSql"), new Object[]{context.getMinDataGapStartId()}, new int[]{this.symmetricDialect.getSqlTypeForIds()});
            dataGapsExpiredToCheck = new ArrayList<DataGap>();
            for (DataGap gap : dataGapsExpired) {
                if (gap.getStartId() > minMax[1]) break;
                if (gap.getEndId() < minMax[0]) continue;
                dataGapsExpiredToCheck.add(gap);
            }
        }
        return dataGapsExpiredToCheck;
    }

    private long[] queryForMinMax(ISqlTemplate template, String sql, Object[] args, int[] types) {
        long[] minMax = new long[]{0L, 0L};
        List rows = template.query(sql, args, types);
        for (Row row : rows) {
            minMax[0] = row.getLong("min_id");
            minMax[1] = row.getLong("max_id");
        }
        return minMax;
    }

    private long purgeExtractRequests() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.extract.request.retention.minutes"));
        this.log.info("Purging table reload statuses that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        long count = this.sqlTemplate.update(this.getSql("deleteTableReloadStatusSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} table reload statuses", (Object)count);
        }
        this.log.info("Purging table reload requests that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        count = this.sqlTemplate.update(this.getSql("deleteTableReloadRequestSql"), new Object[]{retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} table reload requests", (Object)count);
        }
        this.log.info("Purging extract requests that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        count = this.sqlTemplate.update(this.getSql("deleteExtractRequestSql"), new Object[]{ExtractRequest.ExtractStatus.OK.name(), retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} extract requests", (Object)count);
        }
        return count;
    }

    private long purgeRegistrationRequests() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.registration.request.retention.minutes"));
        this.log.info("Purging registration requests that are older than {}", (Object)this.fastFormat.format(retentionCutoff.getTime()));
        long count = this.sqlTemplate.update(this.getSql("deleteRegistrationRequestSql"), new Object[]{RegistrationRequest.RegistrationStatus.OK.name(), RegistrationRequest.RegistrationStatus.RJ.name(), RegistrationRequest.RegistrationStatus.RR.name(), retentionCutoff.getTime()});
        if (count > 0L) {
            this.log.info("Purged {} registration requests", (Object)count);
        }
        return count;
    }

    private long purgeTriggerHist() {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -this.parameterService.getInt("purge.trigger.hist.retention.minutes"));
        Date retentionCutoffDate = retentionCutoff.getTime();
        Timestamp minDataCreateTime = (Timestamp)this.sqlTemplateDirty.queryForObject(this.getSql("minDataCreateTime"), Timestamp.class, new Object[0]);
        if (minDataCreateTime != null && minDataCreateTime.before(retentionCutoffDate)) {
            this.log.warn("Skipping inactive trigger histories created between {} and {} because of a backlog of captured data", (Object)this.fastFormat.format((Date)minDataCreateTime), (Object)this.fastFormat.format(retentionCutoffDate));
            retentionCutoffDate = minDataCreateTime;
        }
        this.log.info("Purging trigger histories that are inactive and older than {}", (Object)this.fastFormat.format(retentionCutoffDate));
        long count = this.sqlTemplate.update(this.getSql("deleteInactiveTriggerHistSql"), new Object[]{retentionCutoffDate});
        if (count > 0L) {
            this.log.info("Purged {} trigger histories", (Object)count);
        }
        return count;
    }

    private int purgeByMinMax(long[] minMax, MinMaxDeleteSql identifier, OutgoingContext context, int maxNumtoPurgeinTx, LongConsumer statConsumer) {
        long minId = minMax[0];
        long maxId = 0L;
        long purgeUpToId = minMax[1];
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        int idSqlType = this.symmetricDialect.getSqlTypeForIds();
        Timestamp cutoffTime = new Timestamp(context.getRetentionCutoff().getTime().getTime());
        identifier = this.getIdentifierIfUsingExists(identifier);
        String name = this.getIdentifierName(identifier);
        if (minMax[0] > minMax[1] || minMax[0] <= 0L) {
            this.log.debug("Ending purge early for {} using range {} through {}", new Object[]{name, minMax[0], minMax[1]});
            return 0;
        }
        ArrayList<DataGap> dataGapsExpired = new ArrayList<DataGap>(context.getDataGapsExpired());
        this.log.info("About to purge {} using range {} through {}", new Object[]{name, minMax[0], minMax[1]});
        block13: while (minId <= purgeUpToId) {
            ++totalDeleteStmts;
            maxId = minId + (long)maxNumtoPurgeinTx;
            if (maxId > purgeUpToId) {
                maxId = purgeUpToId;
            }
            String deleteSql = null;
            Object[] args = null;
            int[] argTypes = null;
            switch (identifier) {
                case DATA: {
                    deleteSql = this.getSql("deleteDataSql");
                    args = new Object[]{minId, maxId, minId, maxId, minId, maxId, AbstractBatch.Status.OK.name()};
                    argTypes = new int[]{idSqlType, idSqlType, idSqlType, idSqlType, idSqlType, idSqlType, 12};
                    break;
                }
                case DATA_EXISTS: {
                    deleteSql = this.getSql("deleteDataExistsSql");
                    args = new Object[]{minId, maxId, AbstractBatch.Status.OK.name()};
                    argTypes = new int[]{idSqlType, idSqlType, 12};
                    break;
                }
                case DATA_RANGE: {
                    deleteSql = this.getSql("deleteDataByRangeSql");
                    long[] minMaxAvoidGaps = PurgeService.getMinMaxAvoidGaps(minId, maxId, dataGapsExpired);
                    if (minMaxAvoidGaps[1] < 0L) {
                        minId = -minMaxAvoidGaps[1];
                        continue block13;
                    }
                    Object[] objectArray = new Object[2];
                    minId = minMaxAvoidGaps[0];
                    objectArray[0] = minId;
                    maxId = minMaxAvoidGaps[1];
                    objectArray[1] = maxId;
                    args = objectArray;
                    argTypes = new int[]{idSqlType, idSqlType};
                    break;
                }
                case DATA_EVENT: {
                    deleteSql = this.getSql("deleteDataEventSql");
                    args = new Object[]{minId, maxId, AbstractBatch.Status.OK.name(), minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType, 12, idSqlType, idSqlType};
                    break;
                }
                case DATA_EVENT_EXISTS: {
                    deleteSql = this.getSql("deleteDataEventExistsSql");
                    args = new Object[]{minId, maxId, AbstractBatch.Status.OK.name()};
                    argTypes = new int[]{idSqlType, idSqlType, 12};
                    break;
                }
                case DATA_EVENT_RANGE: {
                    deleteSql = this.getSql("deleteDataEventByRangeSql");
                    args = new Object[]{minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType};
                    break;
                }
                case OUTGOING_BATCH: {
                    deleteSql = this.getSql("deleteOutgoingBatchSql");
                    args = new Object[]{AbstractBatch.Status.OK.name(), minId, maxId, minId, maxId};
                    argTypes = new int[]{12, idSqlType, idSqlType, idSqlType, idSqlType};
                    break;
                }
                case OUTGOING_BATCH_EXISTS: {
                    deleteSql = this.getSql("deleteOutgoingBatchExistsSql");
                    args = new Object[]{AbstractBatch.Status.OK.name(), minId, maxId};
                    argTypes = new int[]{12, idSqlType, idSqlType};
                    break;
                }
                case OUTGOING_BATCH_RANGE: {
                    deleteSql = this.getSql("deleteOutgoingBatchByRangeSql");
                    args = new Object[]{minId, maxId};
                    argTypes = new int[]{idSqlType, idSqlType};
                    break;
                }
                case STRANDED_DATA: {
                    deleteSql = this.getSql("deleteStrandedData");
                    long[] minMaxAvoidGaps = PurgeService.getMinMaxAvoidGaps(minId, maxId, dataGapsExpired);
                    if (minMaxAvoidGaps[1] < 0L) {
                        minId = -minMaxAvoidGaps[1];
                        continue block13;
                    }
                    Object[] objectArray = new Object[3];
                    minId = minMaxAvoidGaps[0];
                    objectArray[0] = minId;
                    maxId = minMaxAvoidGaps[1];
                    objectArray[1] = maxId;
                    objectArray[2] = cutoffTime;
                    args = objectArray;
                    argTypes = new int[]{idSqlType, idSqlType, 93};
                    if (this.parameterService.is("job.purge.recapture.stranded.data")) {
                        int recapturedRowCount = this.dataService.reCaptureData(minId, maxId);
                        this.log.debug("Recaptured {} stranded data rows for range {} - {}", new Object[]{recapturedRowCount, minId, maxId});
                        break;
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("Skipped recapture of stranded data for range {} - {}", (Object)minId, (Object)maxId);
                    break;
                }
                case STRANDED_DATA_EVENT: {
                    deleteSql = this.getSql("deleteStrandedDataEvent");
                    args = new Object[]{minId, maxId, cutoffTime};
                    argTypes = new int[]{idSqlType, idSqlType, 93};
                }
            }
            this.log.debug("Running the following statement: {} with the following arguments: {}", deleteSql, (Object)Arrays.toString(args));
            int count = this.sqlTemplate.update(deleteSql, args, argTypes);
            this.log.debug("Deleted {} rows", (Object)count);
            statConsumer.accept(count);
            totalCount += count;
            long currentRunTimeMs = System.currentTimeMillis() - ts;
            if (count == 0 && (identifier == MinMaxDeleteSql.STRANDED_DATA || identifier == MinMaxDeleteSql.STRANDED_DATA_EVENT)) {
                long runtimeLimit = this.parameterService.getLong("job.purge.stranded.max.time.ms");
                if (runtimeLimit > 0L && currentRunTimeMs >= runtimeLimit) {
                    this.log.info("Ending purge of {} early at {} after finding empty space. Total rows purged={}", new Object[]{name, maxId, totalCount});
                    break;
                }
                if (currentRunTimeMs > 300000L) {
                    this.log.info("Skipping empty space in {} for range {} - {}", new Object[]{name, minId, maxId});
                } else {
                    this.log.debug("Skipping empty space in {} for range {} - {}. Total rows purged={}", new Object[]{name, minId, maxId, totalCount});
                }
            }
            if (currentRunTimeMs > 300000L) {
                this.log.info("Purged {} of {} rows so far using {} statements", new Object[]{totalCount, name, totalDeleteStmts});
                ts = System.currentTimeMillis();
                this.clusterService.refreshLock("Purge Outgoing");
                this.saveContextLastId(identifier, maxId);
            }
            minId = maxId + 1L;
        }
        this.saveContextLastId(identifier, maxId);
        this.log.info("Done purging {} of {} rows", (Object)totalCount, (Object)name);
        return totalCount;
    }

    protected MinMaxDeleteSql getIdentifierIfUsingExists(MinMaxDeleteSql identifier) {
        if (this.symmetricDialect.getPlatform().getDdlBuilder().getDatabaseInfo().canDeleteUsingExists()) {
            if (identifier == MinMaxDeleteSql.DATA) {
                identifier = MinMaxDeleteSql.DATA_EXISTS;
            } else if (identifier == MinMaxDeleteSql.DATA_EVENT) {
                identifier = MinMaxDeleteSql.DATA_EVENT_EXISTS;
            } else if (identifier == MinMaxDeleteSql.OUTGOING_BATCH) {
                identifier = MinMaxDeleteSql.OUTGOING_BATCH_EXISTS;
            }
        }
        return identifier;
    }

    protected String getIdentifierName(MinMaxDeleteSql identifier) {
        return identifier.toString().toLowerCase().replaceAll("_exists", "");
    }

    protected void saveContextLastId(MinMaxDeleteSql identifier, long lastId) {
        if (lastId > 0L) {
            if (identifier == MinMaxDeleteSql.DATA || identifier == MinMaxDeleteSql.DATA_EXISTS || identifier == MinMaxDeleteSql.DATA_RANGE) {
                this.contextService.save("purge.last.data.id", String.valueOf(lastId));
            } else if (identifier == MinMaxDeleteSql.DATA_EVENT || identifier == MinMaxDeleteSql.DATA_EVENT_EXISTS || identifier == MinMaxDeleteSql.DATA_EVENT_RANGE) {
                this.contextService.save("purge.last.event.batch.id", String.valueOf(lastId));
            } else if (identifier == MinMaxDeleteSql.OUTGOING_BATCH || identifier == MinMaxDeleteSql.OUTGOING_BATCH_EXISTS || identifier == MinMaxDeleteSql.OUTGOING_BATCH_RANGE) {
                this.contextService.save("purge.last.batch.id", String.valueOf(lastId));
            }
        }
    }

    public static long[] getMinMaxAvoidGaps(long minId, long maxId, List<DataGap> dataGapsExpired) {
        if (dataGapsExpired.size() > 0) {
            DataGap gap;
            Iterator<DataGap> iter = dataGapsExpired.iterator();
            while (iter.hasNext() && maxId >= (gap = iter.next()).getStartId()) {
                if (minId > gap.getEndId()) {
                    iter.remove();
                    continue;
                }
                if (minId < gap.getStartId()) {
                    maxId = gap.getStartId() - 1L;
                    break;
                }
                minId = gap.getEndId() + 1L;
                if (maxId <= gap.getEndId()) {
                    maxId = -(gap.getEndId() + 1L);
                    break;
                }
                iter.remove();
            }
        }
        return new long[]{minId, maxId};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long purgeIncoming(Calendar retentionCutoff, boolean force) {
        long purgedRowCount;
        block13: {
            purgedRowCount = 0L;
            long startTime = System.currentTimeMillis();
            try {
                if (force || this.clusterService.lock("Purge Incoming")) {
                    try {
                        this.log.info("The incoming purge process is about to run");
                        List<IPurgeListener> purgeListeners = this.extensionService.getExtensionPointList(IPurgeListener.class);
                        for (IPurgeListener purgeListener : purgeListeners) {
                            try {
                                purgedRowCount += purgeListener.beforePurgeIncoming(force);
                            }
                            catch (Throwable e) {
                                this.log.error(e.getMessage(), e);
                            }
                        }
                        purgedRowCount = this.purgeIncomingBatch(retentionCutoff);
                        purgedRowCount += this.purgeIncomingError();
                        purgedRowCount += this.purgeRegistrationRequests();
                        purgedRowCount += this.purgeTriggerHist();
                        for (IPurgeListener purgeListener : purgeListeners) {
                            try {
                                purgedRowCount += purgeListener.purgeIncoming(force);
                            }
                            catch (Throwable e) {
                                this.log.error(e.getMessage(), e);
                            }
                        }
                        this.statisticManager.addJobStats("Purge Incoming", startTime, System.currentTimeMillis(), purgedRowCount);
                        break block13;
                    }
                    finally {
                        if (!force) {
                            this.clusterService.unlock("Purge Incoming");
                        }
                        this.log.info("The incoming purge process has completed");
                    }
                }
                this.log.debug("Could not get a lock to run an incoming purge");
            }
            catch (Exception ex) {
                this.log.error("", (Throwable)ex);
                this.statisticManager.addJobStats("Purge Incoming", startTime, System.currentTimeMillis(), purgedRowCount, ex);
            }
        }
        return purgedRowCount;
    }

    private long purgeIncomingError() {
        this.log.info("Purging incoming_error table");
        long rowCount = 0L;
        rowCount = this.getSymmetricDialect().supportsSubselectsInDelete() ? (long)this.sqlTemplate.update(this.getSql("deleteIncomingErrorsSql"), new Object[0]) : (long)this.selectIdsAndDelete(this.getSql("selectIncomingErrorsBatchIdsSql"), "batch_id", this.getSql("deleteIncomingErrorsBatchIdsSql"));
        this.log.info("Purged {} rows from incoming_error", (Object)rowCount);
        return rowCount;
    }

    private long purgeIncomingBatch(Calendar time) {
        this.log.info("Getting range for incoming batch");
        List nodeBatchRangeList = this.sqlTemplateDirty.query(this.getSql("selectIncomingBatchRangeSql"), (ISqlRowMapper)new ISqlRowMapper<NodeBatchRange>(){

            public NodeBatchRange mapRow(Row rs) {
                return new NodeBatchRange(rs.getString("node_id"), rs.getLong("min_id"), rs.getLong("max_id"));
            }
        }, new Object[]{time.getTime(), AbstractBatch.Status.OK.name()});
        return this.purgeByNodeBatchRangeList(nodeBatchRangeList);
    }

    private int purgeByNodeBatchRangeList(List<NodeBatchRange> nodeBatchRangeList) {
        long ts = System.currentTimeMillis();
        int totalCount = 0;
        int totalDeleteStmts = 0;
        this.log.info("About to purge incoming batch");
        for (NodeBatchRange nodeBatchRange : nodeBatchRangeList) {
            int maxNumOfDataIdsToPurgeInTx = this.parameterService.getInt("job.purge.max.num.batches.to.delete.in.tx");
            long minBatchId = nodeBatchRange.getMinBatchId();
            long purgeUpToBatchId = nodeBatchRange.getMaxBatchId();
            while (minBatchId <= purgeUpToBatchId) {
                ++totalDeleteStmts;
                long maxBatchId = minBatchId + (long)maxNumOfDataIdsToPurgeInTx;
                if (maxBatchId > purgeUpToBatchId) {
                    maxBatchId = purgeUpToBatchId;
                }
                int rowCount = this.sqlTemplate.update(this.getSql("deleteIncomingBatchSql"), new Object[]{minBatchId, maxBatchId, nodeBatchRange.getNodeId(), AbstractBatch.Status.OK.name()});
                minBatchId = maxBatchId + 1L;
                totalCount += rowCount;
                this.statisticManager.incrementPurgedBatchIncomingRows(rowCount);
            }
            if (totalCount <= 0 || System.currentTimeMillis() - ts <= 300000L) continue;
            this.log.info("Purged {} incoming batch rows so far using {} statements", new Object[]{totalCount, totalDeleteStmts});
            ts = System.currentTimeMillis();
        }
        this.log.info("Done purging {} incoming batch rows", (Object)totalCount);
        return totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeStats(boolean force) {
        Calendar retentionCutoff = Calendar.getInstance();
        retentionCutoff.add(12, -Integer.max(this.parameterService.getInt("purge.stats.retention.minutes"), 10080));
        if (force || this.clusterService.lock("Purge Statistics")) {
            try {
                int purgedCount = this.sqlTemplate.update(this.getSql("purgeNodeHostChannelStatsSql"), new Object[]{retentionCutoff.getTime()});
                purgedCount += this.sqlTemplate.update(this.getSql("purgeNodeHostStatsSql"), new Object[]{retentionCutoff.getTime()});
                if ((purgedCount += this.sqlTemplate.update(this.getSql("purgeNodeHostJobStatsSql"), new Object[]{retentionCutoff.getTime()})) > 0) {
                    this.log.debug("{} stats rows were purged", (Object)purgedCount);
                }
            }
            finally {
                if (!force) {
                    this.clusterService.unlock("Purge Statistics");
                }
            }
        }
    }

    @Override
    public void purgeAllIncomingEventsForNode(String nodeId) {
        int count = this.sqlTemplate.update(this.getSql("deleteIncomingBatchByNodeSql"), new Object[]{nodeId});
        this.log.info("Purged all {} incoming batch for node {}", (Object)count, (Object)nodeId);
    }

    protected int selectIdsAndDelete(String selectSql, String fieldName, String deleteSql) {
        List results = this.sqlTemplate.query(selectSql);
        int rowCount = 0;
        if (!results.isEmpty()) {
            ArrayList<Integer> ids = new ArrayList<Integer>(results.size());
            for (Row row : results) {
                ids.add(row.getInt(fieldName));
            }
            results = null;
            StringBuilder placeHolders = new StringBuilder(ids.size() * 2);
            for (int i = 0; i < ids.size(); ++i) {
                placeHolders.append("?,");
            }
            placeHolders.setLength(placeHolders.length() - 1);
            String deleteStatement = deleteSql.replace("?", placeHolders);
            rowCount = this.sqlTemplate.update(deleteStatement, ids.toArray());
        }
        return rowCount;
    }

    private OutgoingContext buildOutgoingContext(Calendar retentionCutoff) {
        this.log.info("Getting ranges for purge");
        OutgoingContext context = new OutgoingContext(retentionCutoff);
        long startDataId = this.contextService.getLong("purge.last.data.id") + 1L;
        if (startDataId == 1L) {
            startDataId = this.sqlTemplateDirty.queryForLong(this.getSql("minDataId"), new Object[0]);
        }
        context.setMinDataId(startDataId);
        long startBatchId = this.contextService.getLong("purge.last.batch.id") + 1L;
        long startEventBatchId = this.contextService.getLong("purge.last.event.batch.id") + 1L;
        if (startBatchId == 1L || startEventBatchId == 1L) {
            long minBatchId = this.sqlTemplateDirty.queryForLong(this.getSql("minOutgoingBatchId"), new Object[0]);
            startBatchId = Math.max(startBatchId, minBatchId);
            startEventBatchId = Math.max(startEventBatchId, minBatchId);
        }
        context.setMinBatchId(startBatchId);
        context.setMinEventBatchId(startEventBatchId);
        long endBatchId = this.sequenceService.currVal("outgoing_batch") - 1L;
        List batchIds = this.sqlTemplateDirty.query(this.getSql("maxBatchIdForOldBatches"), (ISqlRowMapper)new LongMapper(), new Object[]{startBatchId, endBatchId, new Timestamp(context.getRetentionCutoff().getTime().getTime())}, new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds(), 93});
        if (batchIds != null && batchIds.size() > 0) {
            context.setMaxBatchId((Long)batchIds.get(0));
            this.log.info("Max eligible batch ID: {}", (Object)context.getMaxBatchId());
            List rows = this.sqlTemplateDirty.query(this.getSql("minMaxDataIdForOldBatches"), new Object[]{startBatchId, context.getMaxBatchId()}, new int[]{this.symmetricDialect.getSqlTypeForIds(), this.symmetricDialect.getSqlTypeForIds()});
            if (rows != null && rows.size() > 0) {
                Row row = (Row)rows.get(0);
                long minDataId = row.getLong("min_data_id");
                long maxDataId = row.getLong("max_data_id");
                context.setMaxDataId(maxDataId);
                this.log.info("Max eligible data ID: {}", (Object)context.getMaxDataId());
                if (minDataId < context.getMinDataId()) {
                    this.log.info("Moving starting data ID back from {} to {}", (Object)context.getMinDataId(), (Object)minDataId);
                    context.setMinDataId(minDataId);
                }
            }
        }
        context.setMinDataGapStartId(this.sqlTemplateDirty.queryForLong(this.getSql("minDataGapStartId"), new Object[0]));
        context.setDataGapsExpired(this.dataService.findDataGapsExpired());
        if (context.getMinBatchId() == context.getMinEventBatchId()) {
            this.log.info("Eligible ranges: outgoing batch [{} - {}], data [{} - {}], first data gap [{}]", new Object[]{context.getMinBatchId(), context.getMaxBatchId(), context.getMinDataId(), context.getMaxDataId(), context.getMinDataGapStartId()});
        } else {
            this.log.info("Eligible ranges: outgoing batch [{} - {}], data event [{} - {}], data [{} - {}], first data gap [{}]", new Object[]{context.getMinBatchId(), context.getMaxBatchId(), context.getMinEventBatchId(), context.getMaxBatchId(), context.getMinDataId(), context.getMaxDataId(), context.getMinDataGapStartId()});
        }
        return context;
    }

    static class OutgoingContext {
        private Calendar retentionCutoff;
        private long minDataGapStartId;
        private long minDataId;
        private long maxDataId;
        private long minBatchId;
        private long maxBatchId;
        private long minEventBatchId;
        private List<DataGap> dataGapsExpired;

        public OutgoingContext(Calendar retentionCutoff) {
            this.retentionCutoff = retentionCutoff;
        }

        public Calendar getRetentionCutoff() {
            return this.retentionCutoff;
        }

        public void setRetentionCutoff(Calendar retentionCutoff) {
            this.retentionCutoff = retentionCutoff;
        }

        public long getMinDataGapStartId() {
            return this.minDataGapStartId;
        }

        public void setMinDataGapStartId(long minDataGapStartId) {
            this.minDataGapStartId = minDataGapStartId;
        }

        public long getMinDataId() {
            return this.minDataId;
        }

        public void setMinDataId(long minDataId) {
            this.minDataId = minDataId;
        }

        public long getMaxDataId() {
            return this.maxDataId;
        }

        public long getMinBatchId() {
            return this.minBatchId;
        }

        public void setMinBatchId(long minBatchId) {
            this.minBatchId = minBatchId;
        }

        public void setMaxDataId(long maxDataId) {
            this.maxDataId = maxDataId;
        }

        public long getMaxBatchId() {
            return this.maxBatchId;
        }

        public void setMaxBatchId(long maxBatchId) {
            this.maxBatchId = maxBatchId;
        }

        public long getMinEventBatchId() {
            return this.minEventBatchId;
        }

        public void setMinEventBatchId(long minEventBatchId) {
            this.minEventBatchId = minEventBatchId;
        }

        public List<DataGap> getDataGapsExpired() {
            return this.dataGapsExpired;
        }

        public void setDataGapsExpired(List<DataGap> dataGapsExpired) {
            this.dataGapsExpired = dataGapsExpired;
        }
    }

    static enum MinMaxDeleteSql {
        DATA,
        DATA_EXISTS,
        DATA_RANGE,
        DATA_EVENT,
        DATA_EVENT_EXISTS,
        DATA_EVENT_RANGE,
        OUTGOING_BATCH,
        OUTGOING_BATCH_EXISTS,
        OUTGOING_BATCH_RANGE,
        STRANDED_DATA,
        STRANDED_DATA_EVENT;

    }

    static class NodeBatchRange {
        private String nodeId;
        private long minBatchId;
        private long maxBatchId;

        public NodeBatchRange(String nodeId, long minBatchId, long maxBatchId) {
            this.nodeId = nodeId;
            this.minBatchId = minBatchId;
            this.maxBatchId = maxBatchId;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getMaxBatchId() {
            return this.maxBatchId;
        }

        public long getMinBatchId() {
            return this.minBatchId;
        }
    }
}

