/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jumpmind.extension.IProgressListener;
import org.jumpmind.properties.TypedProperties;
import org.jumpmind.symmetric.Version;
import org.jumpmind.symmetric.util.MavenArtifact;
import org.jumpmind.symmetric.util.ModuleException;
import org.jumpmind.util.AppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleManager {
    private static final Logger log = LoggerFactory.getLogger(ModuleManager.class);
    private static final String EXT_PROPERTIES = ".properties";
    private static final String PROP_REPOSITORIES = "repos";
    private static final String PROP_VERSION = "sym.version";
    private static final String PROP_DRIVER = "driver.";
    private static final String PROP_OLD_MODULES = "modules.old";
    private static final String MODULE_ID_ALL = "all";
    private static ModuleManager instance;
    private Properties properties = new Properties();
    private Map<String, List<MavenArtifact>> modules = new TreeMap<String, List<MavenArtifact>>();
    private Map<String, String> driverToModule = new HashMap<String, String>();
    private List<String> repos = new ArrayList<String>();
    private Set<String> oldModules = new HashSet<String>();
    private String modulesDir = this.prepareModulesDir("symmetric.modules.dir", "lib");
    private String toolsDir = this.prepareModulesDir("symmetric.tools.dir", "tools");

    private ModuleManager() throws ModuleException {
        try (InputStream in = this.getClass().getResourceAsStream("/symmetric-modules.properties");){
            this.properties.load(in);
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                String[] drivers;
                String key = entry.getKey().toString();
                if (key.equals(PROP_REPOSITORIES)) {
                    for (String repo : entry.getValue().toString().split("\\s*,\\s*")) {
                        this.repos.add(repo);
                    }
                    continue;
                }
                if (key.startsWith(PROP_DRIVER)) {
                    for (String driver : drivers = entry.getValue().toString().split("\\s*,\\s*")) {
                        this.driverToModule.put(driver, key.substring(PROP_DRIVER.length()));
                    }
                    continue;
                }
                if (key.equals(PROP_OLD_MODULES)) {
                    drivers = entry.getValue().toString().split("\\s*,\\s*");
                    int n = drivers.length;
                    for (int i = 0; i < n; ++i) {
                        String oldModule = drivers[i];
                        this.oldModules.add(oldModule);
                    }
                    continue;
                }
                ArrayList<MavenArtifact> list = new ArrayList<MavenArtifact>();
                String defaultVersion = Version.version();
                for (String dependency : entry.getValue().toString().split("\\s*,\\s*")) {
                    list.add(new MavenArtifact(dependency, defaultVersion));
                }
                this.modules.put(key, list);
            }
        }
        catch (Exception e) {
            this.logAndThrow("Unable to read symmetric-modules.properties file: " + e.getMessage(), e);
        }
    }

    public static ModuleManager getInstance() throws ModuleException {
        if (instance == null) {
            instance = new ModuleManager();
        }
        return instance;
    }

    protected String prepareModulesDir(String sysPropName, String defaultDir) {
        String dirName = ".";
        String sysModulesDir = System.getProperty(sysPropName);
        if (StringUtils.isNotBlank((CharSequence)sysModulesDir)) {
            dirName = sysModulesDir;
        } else if ("true".equals(System.getProperty("symmetric.launcher"))) {
            dirName = this.joinDirName(AppUtils.getSymHome(), defaultDir);
        }
        File dir = new File(dirName);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dirName;
    }

    public void install(String moduleId) throws ModuleException {
        this.install(moduleId, null);
    }

    public void install(String moduleId, IProgressListener listener) throws ModuleException {
        if (MODULE_ID_ALL.equals(moduleId)) {
            this.installAll();
            return;
        }
        this.checkModuleInstalled(moduleId, false);
        List<MavenArtifact> artifacts = this.resolveArtifacts(moduleId);
        log.info("Installing module {} with {} artifacts", (Object)moduleId, (Object)artifacts.size());
        int allDownloadSize = this.calculateTotalDownloadSize(artifacts);
        log.info("Calculated download size as " + allDownloadSize + " bytes");
        for (MavenArtifact artifact : artifacts) {
            String fileName = this.buildFileName(this.modulesDir, artifact);
            if (new File(fileName).exists()) {
                log.info("{} already exists", (Object)fileName);
            } else {
                boolean installedOkay = false;
                String errorMessage = null;
                for (String repo : this.repos) {
                    String urlString = this.buildUrl(repo, artifact);
                    try {
                        HttpURLConnection conn = this.getHttpUrlConnection(urlString, "GET");
                        if (conn.getResponseCode() == 200) {
                            log.info("Downloading {}", (Object)urlString);
                            try (InputStream in = conn.getInputStream();){
                                try (FileOutputStream out = new FileOutputStream(fileName);){
                                    this.copy(in, out, allDownloadSize, listener);
                                    installedOkay = true;
                                }
                                break;
                            }
                            catch (Exception e) {
                                errorMessage = "Unable to download from " + urlString + " because: " + e.getMessage();
                                log.error(errorMessage);
                                continue;
                            }
                        }
                        errorMessage = "Unable to download " + urlString + " because [" + conn.getResponseCode() + "]";
                        log.debug(errorMessage);
                    }
                    catch (MalformedURLException e) {
                        errorMessage = "Bad URL " + urlString;
                        log.error(errorMessage);
                    }
                    catch (IOException e) {
                        errorMessage = "I/O error while downloading " + urlString + " because: " + e.getMessage();
                        log.error(errorMessage);
                    }
                }
                if (!installedOkay) {
                    this.logAndThrow("Failed to install module " + moduleId + ".  " + errorMessage);
                }
            }
            if (!fileName.toLowerCase().endsWith("zip")) continue;
            this.installZip(moduleId, fileName);
        }
        try {
            FileWriter writer = new FileWriter(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
            Properties prop = new Properties();
            prop.setProperty(PROP_VERSION, Version.version());
            prop.setProperty(moduleId, this.properties.getProperty(moduleId));
            prop.store(writer, "");
            log.info("Successfully installed module {}", (Object)moduleId);
        }
        catch (IOException e) {
            this.logAndThrow("Unable to write properties file for module " + moduleId + " because: " + e.getMessage(), e);
        }
    }

    public void installAll() throws ModuleException {
        List<String> installedModuleIds = this.list();
        for (String moduleId : this.listAll()) {
            if (installedModuleIds.contains(moduleId)) continue;
            this.install(moduleId);
        }
    }

    protected void copy(InputStream in, OutputStream out, int allDownloadSize, IProgressListener listener) throws IOException {
        int readSize = 0;
        int totalSize = 0;
        byte[] buffer = new byte[8192];
        while ((readSize = in.read(buffer)) != -1) {
            out.write(buffer, 0, readSize);
            totalSize += readSize;
            if (listener == null) continue;
            listener.checkpoint(null, totalSize, allDownloadSize);
        }
    }

    protected void installZip(String moduleId, String fileName) throws ModuleException {
        boolean installedOkay;
        block16: {
            installedOkay = true;
            File toDir = new File(this.toolsDir);
            log.info("Unzipping module {} into tools directory {}", (Object)moduleId, (Object)toDir);
            try (FileInputStream in = new FileInputStream(fileName);){
                AppUtils.unzip((InputStream)in, (File)toDir);
                File installScript = new File(toDir, this.getToolDirName(moduleId) + File.separator + "install");
                if (!installScript.exists()) {
                    installScript = new File(toDir, this.getToolDirName(moduleId) + File.separator + "install.bat");
                }
                if (!installScript.exists()) break block16;
                installScript.setExecutable(true);
                log.info("About to run script {}", (Object)installScript.toString());
                ProcessBuilder pb = new ProcessBuilder(installScript.toString());
                pb.directory(installScript.getParentFile());
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        log.info("Install script: {}", (Object)line);
                    }
                }
                log.info("Install script RC={}", (Object)proc.waitFor());
            }
            catch (Exception e) {
                log.error("Unable to unzip {} into directory {} because: {} {}", new Object[]{fileName, toDir, e.getClass().getName(), e.getMessage()});
                installedOkay = false;
            }
        }
        if (!installedOkay) {
            this.logAndThrow("Failed to install tools for module " + moduleId);
        } else {
            new File(fileName).delete();
        }
    }

    protected int calculateTotalDownloadSize(List<MavenArtifact> artifacts) {
        int contentLength = 0;
        for (MavenArtifact artifact : artifacts) {
            if (new File(this.buildFileName(this.modulesDir, artifact)).exists()) continue;
            for (String repo : this.repos) {
                String urlString = this.buildUrl(repo, artifact);
                try {
                    HttpURLConnection conn = this.getHttpUrlConnection(urlString, "HEAD");
                    if (conn.getResponseCode() != 200) continue;
                    InputStream in = conn.getInputStream();
                    try {
                        contentLength += conn.getContentLength();
                    }
                    finally {
                        if (in == null) continue;
                        in.close();
                    }
                }
                catch (IOException e) {
                    log.error("Error while checking file size of {} because {}: {}", new Object[]{urlString, e.getClass().getName(), e.getMessage()});
                }
            }
        }
        return contentLength;
    }

    protected HttpURLConnection getHttpUrlConnection(String urlString, String method) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod(method);
        conn.setInstanceFollowRedirects(true);
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(30000);
        return conn;
    }

    public List<String> listUpgrade() throws ModuleException {
        ArrayList<String> fileNames = new ArrayList<String>();
        for (String moduleId : this.list()) {
            File file = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
            try {
                FileReader reader = new FileReader(file);
                Properties prop = new Properties();
                prop.load(reader);
                String oldDepString = this.removeBlankSpace(prop.getProperty(moduleId));
                String newDepString = this.removeBlankSpace(this.properties.getProperty(moduleId));
                if (oldDepString != null && oldDepString.equals(newDepString)) continue;
                fileNames.addAll(this.listFiles(moduleId));
            }
            catch (IOException e) {
                this.logAndThrow("Unable to list files for module " + moduleId + " because: " + e.getMessage(), e);
            }
        }
        return fileNames;
    }

    public void upgrade(String moduleId) throws ModuleException {
        this.checkModuleInstalled(moduleId, true);
        log.info("Checking if module {} needs upgraded", (Object)moduleId);
        File file = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
        try {
            FileReader reader = new FileReader(file);
            Properties prop = new Properties();
            prop.load(reader);
            String oldDepString = this.removeBlankSpace(prop.getProperty(moduleId));
            String newDepString = this.removeBlankSpace(this.properties.getProperty(moduleId));
            if (oldDepString == null || !oldDepString.equals(newDepString)) {
                log.info("Upgrading module {}", (Object)moduleId);
                this.remove(moduleId);
                if (this.modules.containsKey(moduleId)) {
                    this.install(moduleId);
                }
            }
        }
        catch (IOException e) {
            this.logAndThrow("Unable to list files for module " + moduleId + " because: " + e.getMessage(), e);
        }
    }

    public void upgradeAll() throws ModuleException {
        for (String moduleId : this.list()) {
            this.upgrade(moduleId);
        }
    }

    public void convertToModules() {
        log.info("Module conversion starting");
        String dirName = System.getProperty("symmetric.engines.dir", AppUtils.getSymHome() + "/engines");
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        if (files != null) {
            List<String> currentModules = this.list();
            log.info("Checking {} files in engines directory for possible module conversion", (Object)files.length);
            for (File file : files) {
                if (!file.getName().endsWith(EXT_PROPERTIES)) continue;
                log.info("Checking {} for possible module conversion", (Object)file.getPath());
                this.convertToModule(file, currentModules);
            }
        }
        log.info("Module conversion ended");
    }

    protected void convertToModule(File engineFile, List<String> currentModules) {
        TypedProperties prop = new TypedProperties();
        try (FileInputStream is = new FileInputStream(engineFile);){
            prop.load((InputStream)is);
        }
        catch (IOException e) {
            log.error("Failed module conversion for engine " + engineFile.getPath(), (Throwable)e);
            return;
        }
        String driver = prop.getProperty("db.driver");
        String moduleId = this.driverToModule.get(driver);
        if (moduleId != null && currentModules.contains(moduleId)) {
            log.info("Module '" + moduleId + "' already installed");
        } else if (moduleId != null && this.modules.containsKey(moduleId)) {
            try {
                this.install(moduleId);
                currentModules.add(moduleId);
            }
            catch (ModuleException e) {
                log.error("Failed module conversion for module " + moduleId, (Throwable)e);
            }
        } else {
            log.info("Skipping module conversion for driver '" + driver + "' and module '" + moduleId + "' for engine " + engineFile.getPath());
        }
    }

    private String buildUrl(String repo, MavenArtifact artifact) {
        return this.buildFileName(this.joinDirName(repo, artifact.getGroupId().replace(".", "/"), artifact.getArtifactId(), artifact.getVersion()), artifact);
    }

    private String buildFileName(String baseDir, MavenArtifact artifact) {
        return this.joinDirName(baseDir, artifact.toFileName());
    }

    private String joinDirName(String ... args) {
        return StringUtils.join((Object[])args, (String)"/");
    }

    private List<MavenArtifact> resolveArtifacts(String moduleId) {
        return this.modules.get(moduleId);
    }

    public void remove(String moduleId) throws ModuleException {
        if (MODULE_ID_ALL.equals(moduleId)) {
            this.removeAll();
            return;
        }
        this.checkModuleInstalled(moduleId, true);
        List<String> filesToRemove = this.listFiles(moduleId);
        for (String installedModuleId : this.list()) {
            if (installedModuleId.equals(moduleId)) continue;
            filesToRemove.removeAll(this.listFiles(installedModuleId));
        }
        boolean success = true;
        String zipFileName = null;
        for (String fileName : filesToRemove) {
            File file = new File(this.joinDirName(this.modulesDir, fileName));
            if (file.exists()) {
                boolean delSuccess = new File(this.joinDirName(this.modulesDir, fileName)).delete();
                log.info("Removing {} ({})", (Object)fileName, (Object)(delSuccess ? "OK" : "FAIL"));
                success &= delSuccess;
            } else {
                log.info("Already removed {}", (Object)fileName);
            }
            if (!fileName.endsWith("zip")) continue;
            zipFileName = fileName;
        }
        if (zipFileName != null) {
            File toolDir = new File(this.toolsDir, this.getToolDirName(zipFileName));
            if (toolDir.exists()) {
                try {
                    FileUtils.deleteDirectory((File)toolDir);
                    log.info("Removed directory {}", (Object)toolDir);
                }
                catch (IOException e) {
                    log.info("Removal failed for directory {} because {}: {}", new Object[]{toolDir, e.getClass().getName(), e.getMessage()});
                    success = false;
                }
            } else {
                log.info("Already removed tool directory {}", (Object)toolDir);
            }
        }
        boolean delSuccess = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES)).delete();
        log.info("Removing {} ({})", (Object)(moduleId + EXT_PROPERTIES), (Object)(delSuccess ? "OK" : "FAIL"));
        if (!(success &= delSuccess)) {
            this.logAndThrow("Unable to remove all files associated with module " + moduleId);
        }
    }

    public void removeAll() throws ModuleException {
        for (String moduleId : this.list()) {
            this.remove(moduleId);
        }
    }

    private String[] getPropFileNames() {
        File dir = new File(this.modulesDir);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                String baseName = name;
                int index = name.indexOf(".");
                if (index != -1) {
                    baseName = name.substring(0, index);
                }
                return name.toLowerCase().endsWith(ModuleManager.EXT_PROPERTIES) && (ModuleManager.this.modules.containsKey(baseName) || ModuleManager.this.oldModules.contains(baseName));
            }
        };
        return dir.list(filter);
    }

    public List<String> list() {
        ArrayList<String> names = new ArrayList<String>();
        String[] fileNames = this.getPropFileNames();
        if (fileNames != null) {
            for (String propFileName : fileNames) {
                names.add(propFileName.substring(0, propFileName.length() - EXT_PROPERTIES.length()));
            }
        }
        Collections.sort(names);
        return names;
    }

    public List<String> listFiles(String moduleId) throws ModuleException {
        ArrayList<String> fileNames = new ArrayList<String>();
        this.checkModuleInstalled(moduleId, true);
        File file = new File(this.joinDirName(this.modulesDir, moduleId + EXT_PROPERTIES));
        if (file.canRead()) {
            try {
                FileReader reader = new FileReader(file);
                Properties prop = new Properties();
                prop.load(reader);
                String defaultVersion = prop.getProperty(PROP_VERSION, Version.version());
                for (MavenArtifact artifact : MavenArtifact.parseCsv(prop.getProperty(moduleId), defaultVersion)) {
                    fileNames.add(artifact.toFileName());
                }
            }
            catch (IOException e) {
                this.logAndThrow("Unable to list files for module " + moduleId + " because: " + e.getMessage(), e);
            }
        }
        return fileNames;
    }

    public List<String> listDependencies(String moduleId) throws ModuleException {
        this.checkModuleValid(moduleId, false);
        List<MavenArtifact> artifacts = this.resolveArtifacts(moduleId);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (MavenArtifact artifact : artifacts) {
            fileNames.add(artifact.toFileName());
        }
        return fileNames;
    }

    public List<String> listAll() {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : this.modules.keySet()) {
            names.add(name);
        }
        Collections.sort(names);
        return names;
    }

    private void checkModuleInstalled(String moduleId, boolean shouldBeInstalled) throws ModuleException {
        this.checkModuleValid(moduleId, shouldBeInstalled);
        boolean isInstalled = this.list().contains(moduleId);
        if (isInstalled && !shouldBeInstalled) {
            throw new ModuleException("Module is already installed", false);
        }
        if (!isInstalled && shouldBeInstalled) {
            throw new ModuleException("Module is not installed", false);
        }
    }

    private void checkModuleValid(String moduleId, boolean shouldBeInstalled) throws ModuleException {
        if (!(this.modules.containsKey(moduleId) || shouldBeInstalled && this.oldModules.contains(moduleId))) {
            throw new ModuleException("Invalid module specified", false);
        }
    }

    private String getToolDirName(String zipFileName) {
        String toolDirName = zipFileName.replace(".zip", "");
        int i = toolDirName.indexOf("-");
        if (i > 0) {
            toolDirName = toolDirName.substring(0, i);
        }
        return toolDirName;
    }

    private String removeBlankSpace(String str) {
        if (str != null) {
            str = str.replaceAll("\\s", "");
        }
        return str;
    }

    private void logAndThrow(String message) throws ModuleException {
        log.error(message);
        throw new ModuleException(message);
    }

    private void logAndThrow(String message, Exception e) throws ModuleException {
        log.error(message);
        throw new ModuleException(message, e);
    }
}

