/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.wrapper;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.jumpmind.symmetric.wrapper.UnixService;
import org.jumpmind.symmetric.wrapper.WrapperException;

public class MacService
extends UnixService {
    private static final String LAUNCH_DAEMON_DIR = "/Library/LaunchDaemons";
    private static final String LAUNCH_DAEMON_NAME_PREFIX = "com.jumpmind.";
    private static final String LAUNCH_DAEMON_NAME_SUFFIX = ".plist";
    private static final String LAUNCH_DAEMON_LOAD_COMMAND = "load";
    private static final String LAUNCH_DAEMON_UNLOAD_COMMAND = "unload";
    private static final String LAUNCH_DAEMON_STOP_COMMAND = "stop";
    private static final String LAUNCH_DAEMON_START_COMMAND = "start";

    @Override
    public void install() {
        File fileToWrite = new File(LAUNCH_DAEMON_DIR, this.getLaunchDaemonsFileName(this.config.getName()));
        System.out.println("Writing launch daemon file " + fileToWrite.getAbsolutePath());
        this.writeLaunchDaemonFile(fileToWrite);
        ArrayList<String> loadCmd = this.getLaunchDaemonLoadCommand();
        boolean success = this.runLaunchCtlCmd(loadCmd);
        if (!success) {
            throw new WrapperException(13, 0, "Failed to install service");
        }
    }

    private ArrayList<String> getLaunchDaemonLoadCommand() {
        return this.getLaunchDaemonCmd(LAUNCH_DAEMON_LOAD_COMMAND, "-w", "/Library/LaunchDaemons/" + this.getLaunchDaemonsFileName(this.config.getName()));
    }

    private ArrayList<String> getLaunchDaemonStopCmd() {
        return this.getLaunchDaemonCmd(LAUNCH_DAEMON_STOP_COMMAND, null, this.getLaunchDaemonsName(this.config.getName()));
    }

    private ArrayList<String> getLaunchDaemonUnloadCmd() {
        return this.getLaunchDaemonCmd(LAUNCH_DAEMON_UNLOAD_COMMAND, "-w", "/Library/LaunchDaemons/" + this.getLaunchDaemonsFileName(this.config.getName()));
    }

    private ArrayList<String> getLaunchDaemonStartCmd() {
        return this.getLaunchDaemonCmd(LAUNCH_DAEMON_START_COMMAND, null, this.getLaunchDaemonsName(this.config.getName()));
    }

    private ArrayList<String> getLaunchDaemonCmd(String command, String override, String option) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("launchctl");
        cmdList.add(command);
        if (override != null && override.length() > 0) {
            cmdList.add(override);
        }
        cmdList.add(option);
        return cmdList;
    }

    @Override
    public void uninstall() {
        ArrayList<String> unloadCmd = this.getLaunchDaemonUnloadCmd();
        boolean success = this.runLaunchCtlCmd(unloadCmd);
        if (!success) {
            throw new WrapperException(13, 0, "Failed to uninstall service");
        }
        File fileToDelete = new File(LAUNCH_DAEMON_DIR, this.getLaunchDaemonsFileName(this.config.getName()));
        boolean ret = fileToDelete.delete();
        System.out.println("Delete of file " + fileToDelete.getAbsolutePath() + (ret ? " successful" : " failed"));
    }

    @Override
    public boolean isInstalled() {
        return new File(LAUNCH_DAEMON_DIR, this.getLaunchDaemonsFileName(this.config.getName())).exists();
    }

    private String getLaunchDaemonsFileName(String wrapperName) {
        return this.getLaunchDaemonsName(wrapperName) + LAUNCH_DAEMON_NAME_SUFFIX;
    }

    private String getLaunchDaemonsName(String wrapperName) {
        return LAUNCH_DAEMON_NAME_PREFIX + wrapperName;
    }

    private boolean runLaunchCtlCmd(ArrayList<String> cmd) {
        int ret = -1;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        System.out.println("Running " + String.valueOf(pb.command()));
        Process process = null;
        try {
            process = pb.start();
            ret = process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            System.err.println(e.getMessage());
        }
        if (process != null) {
            ArrayList<String> cmdOutput = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    cmdOutput.add(line);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (cmdOutput.size() > 0) {
                System.err.println(this.commandToString(cmd));
                for (String line : cmdOutput) {
                    System.err.println(line);
                }
            }
        }
        return ret == 0;
    }

    @Override
    protected boolean isPidRunning(int pid) {
        boolean ret = false;
        if (pid != 0) {
            ArrayList<String> cmd = this.getPsCommand(pid);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            Process process = null;
            try {
                process = pb.start();
                process.waitFor();
            }
            catch (IOException | InterruptedException e) {
                System.err.println(e.getMessage());
            }
            if (process != null) {
                String line2;
                BufferedReader reader2;
                ArrayList<String> cmdOutput = new ArrayList<String>();
                ArrayList<String> cmdError = new ArrayList<String>();
                try {
                    reader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    try {
                        line2 = null;
                        while ((line2 = reader2.readLine()) != null) {
                            cmdOutput.add(line2);
                        }
                    }
                    finally {
                        reader2.close();
                    }
                }
                catch (Exception reader2) {
                    // empty catch block
                }
                try {
                    reader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                    try {
                        line2 = null;
                        while ((line2 = reader2.readLine()) != null) {
                            cmdError.add(line2);
                        }
                    }
                    finally {
                        reader2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                for (String line2 : cmdOutput) {
                    if (!line2.contains(this.config.getJavaCommand())) continue;
                    ret = true;
                    break;
                }
                if (cmdError.size() > 0) {
                    System.err.println(this.commandToString(cmd));
                    for (String line2 : cmdError) {
                        System.err.println(line2);
                    }
                    throw new WrapperException(8, 8, "Failed isPidRunning");
                }
            }
        }
        return ret;
    }

    private ArrayList<String> getPsCommand(int pid) {
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add("/bin/ps");
        cmdList.add("-p");
        cmdList.add(String.valueOf(pid));
        cmdList.add("-opid=,comm=");
        return cmdList;
    }

    private void writeLaunchDaemonFile(File runFile) {
        try (FileWriter writer = new FileWriter(runFile);
             BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/symmetricds.plist")));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                line = line.replaceAll("\\$\\{wrapper.displayname}", this.getLaunchDaemonsName(this.config.getDisplayName()));
                line = line.replaceAll("\\$\\{wrapper.home}", this.config.getWorkingDirectory().getAbsolutePath());
                line = line.replaceAll("\\$\\{wrapper.run.as.user}", this.config.getRunAsUser());
                writer.write(line + "\n");
            }
        }
        catch (IOException e) {
            throw new WrapperException(17, 0, "Failed while writing run file", e);
        }
    }

    @Override
    protected void stopProcesses(boolean isStopAbandoned) {
        if (this.isInstalled()) {
            ArrayList<String> stopCmd = this.getLaunchDaemonStopCmd();
            boolean success = this.runLaunchCtlCmd(stopCmd);
            if (!success) {
                throw new WrapperException(9, 0, "Server did not stop");
            }
        } else {
            super.stopProcesses(isStopAbandoned);
        }
    }

    @Override
    public void start() {
        if (this.isInstalled()) {
            if (!this.isPrivileged()) {
                throw new WrapperException(14, 0, "You must be root to start a service");
            }
            if (this.isRunning()) {
                throw new WrapperException(5, 0, "Server is already running");
            }
            this.stopProcesses(true);
            System.out.println("Waiting for server to start");
            boolean success = this.runLaunchCtlCmd(this.getLaunchDaemonStartCmd());
            if (!success) {
                throw new WrapperException(8, 0, "Server did not start");
            }
        } else {
            super.start();
        }
    }
}

