/*
 * Decompiled with CFR 0.152.
 */
package org.jumpmind.symmetric.db;

import org.apache.commons.lang3.StringUtils;
import org.jumpmind.db.model.Table;
import org.jumpmind.db.platform.IDatabasePlatform;
import org.jumpmind.symmetric.db.AbstractSymmetricDialect;
import org.jumpmind.symmetric.db.ISymmetricDialect;
import org.jumpmind.symmetric.model.Channel;
import org.jumpmind.symmetric.model.Node;
import org.jumpmind.symmetric.model.Trigger;
import org.jumpmind.symmetric.model.TriggerHistory;
import org.jumpmind.symmetric.model.TriggerRouter;
import org.jumpmind.symmetric.service.IParameterService;

public abstract class AbstractEmbeddedSymmetricDialect
extends AbstractSymmetricDialect
implements ISymmetricDialect {
    public AbstractEmbeddedSymmetricDialect(IParameterService parameterService, IDatabasePlatform platform) {
        super(parameterService, platform);
    }

    public String createInitialLoadSqlFor(Node node, TriggerRouter trigger, Table table, TriggerHistory triggerHistory, Channel channel, String overrideSelectSql) {
        return this.unescapeTicks(super.createInitialLoadSqlFor(node, trigger, table, triggerHistory, channel, overrideSelectSql));
    }

    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.unescapeTicks(super.createCsvDataSql(trigger, triggerHistory, channel, whereClause));
    }

    public String createCsvDataSql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause, Table table) {
        return this.unescapeTicks(super.createCsvDataSql(trigger, triggerHistory, channel, whereClause, table));
    }

    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause) {
        return this.unescapeTicks(super.createCsvPrimaryKeySql(trigger, triggerHistory, channel, whereClause));
    }

    public String createCsvPrimaryKeySql(Trigger trigger, TriggerHistory triggerHistory, Channel channel, String whereClause, Table table) {
        return this.unescapeTicks(super.createCsvPrimaryKeySql(trigger, triggerHistory, channel, whereClause, table));
    }

    protected String unescapeTicks(String sql) {
        return sql.replace("''", "'");
    }

    public void cleanDatabase() {
    }

    public String getDefaultCatalog() {
        return null;
    }

    public String getInitialLoadTableAlias() {
        return "t.";
    }

    public String preProcessTriggerSqlClause(String sqlClause) {
        if (StringUtils.isNotBlank((CharSequence)sqlClause)) {
            sqlClause = sqlClause.replace("$(newTriggerValue).", "$(newTriggerValue)");
            sqlClause = sqlClause.replace("$(oldTriggerValue).", "$(oldTriggerValue)");
            sqlClause = sqlClause.replace("$(curTriggerValue).", "$(curTriggerValue)");
            return sqlClause.replace("'", "''");
        }
        return sqlClause;
    }

    public boolean escapesTemplatesForDatabaseInserts() {
        return true;
    }
}

